const teamsIds = [
        "677febb48f65d30df",
        "675081f4218833ca1",
        "675081f428be23392",
        "673f41d398ed8a9fe",
        "67d08573c3b788903",
        "675081f4338757568",
        "675081f43c8aa869e",
        "675081f4450ee7686",
        "675081f46688a1598",
        "675081f44eae1fff2",
        "675081f4577147328",
        "675081f47cf78ec80",
        "675081f4855a236e3",
        "675081f48ef82072c",
        "675081f4981df3bcc",
        "675081f4a23d5ec2f",
        "675081f4ac45f6f81",
        "675081f4b42e63030",
        "675081f4bbf6059b2",
        "675081f4c4691dd40",
        "675081f4cd3fc69a9",
        "675081f4d6884299c",
        "675081f4de5f9a2da",
        "675081f4e7651edd7",
        "675081f4ef06fffe7",
        "675081f507ae7a5fa",
        "675081f51f2ef77b2",
        "675081f513384753f",
        "677837cd7a732b1ce",
        "675081f52925a318d",
        "675081f530a4eb4ac",
        "675081f5383981e6e",
        "675081f5405a962eb",
        "675081f547f6e5985",
        "675081f5500214dd2",
        "675081f55a7f4595b",
        "675081f567552660e",
        "675081f56fb4edc6f",
        "675081f58155dbe88",
        "675081f5797fa8470",
        "63fe2e975c350b246",
        "6410865e7b429f6bb",
        "643418441fabd22dd",
        "6320869fe404e348c",
        "6217badb36ba2650e",
        "6528501bc60866d03"
];

window.onload = async function () {
    console.log("Enube Patch Notes Loaded");
    setTimeout(() => {
        patchNotes()

    }, 5000);

};

async function patchNotes() {
    const Swal = await this.window.Espo.loader.requirePromise('swal');
    const userId = localStorage.getItem('espo-user-lastUserId');
    let assignedUserId, defaultTeamId;
    let responseUser

    try {
        responseUser = await makeRequestCRM(`api/v1/User/${userId}`, 'GET');
        // var country = responseUser.countryList
        assignedUserId = responseUser.id;
        defaultTeamId = responseUser.defaultTeamId;

        const country = responseUser.country;
        if (Array.isArray(country) && country.includes("Brasil")) {
            console.log("inclui Brasil");
        }
        if (teamsIds.includes(responseUser.defaultTeamId)) {
            console.log("Time listado");
        }
    }
    catch (error) {
        console.error("Erro ao buscar usuário:", error);
        return;
    }



    const patchResponse = await makeRequestCRM(
        `api/v1/CPatchNotes?maxSize=30&offset=0&orderBy=createdAt&order=desc&where[0][type]=in&where[0][attribute]=updatestatus&where[0][value][]=Released&where[1][type]=past&where[1][attribute]=releasedate&where[1][value]=&where[1][dateTime]=true&where[1][timeZone]=America/Sao_Paulo&where[2][type]=and&where[2][value][0][type]=notEquals&where[2][value][0][attribute]=modaltext&where[2][value][0][value]=&where[2][value][1][type]=isNotNull&where[2][value][1][attribute]=modaltext&where[2][value][1][value]=&where[3][type]=isTrue&where[3][attribute]=displayModal&where[3][value]=true`,
        'GET'
    );

    console.log("Patch Response:", patchResponse);

    try {
        if (patchResponse.total > 0) {
            for (const patch of patchResponse.list) {
                try {
                    const validData = await makeRequestCRM(`api/v1/CPatchNotes/${patch.id}`, 'GET');

                    if (!validData.teamsIds || validData.teamsIds.length === 0) {
                        console.log(`Patch ${patch.name} ignorado: sem teamsIds.`);
                        continue;
                    }

                    const alreadySeen = await checkDashboardAccess(assignedUserId, patch.name);
                    const isTeamValidate = isUserInPermittedTeam(responseUser.teamsIds, validData.teamsIds);

                    if (!alreadySeen && isTeamValidate === true) {
                        await showPatchModal(validData, assignedUserId, validData.modalLink);
                    }
                } catch (loopErr) {
                    console.error(`Erro ao processar patch ${patch.name}:`, loopErr);
                }
            }
        }
    } catch (error) {
        console.error("Erro ao buscar patch notes:", error);
        if (error?.response) {
            console.warn("Resposta da API:", error.response);
        }
        if (error?.url) {
            console.warn("URL que falhou:", error.url);
        }
    }
}

async function checkDashboardAccess(userId, patchName) {
    const url = `api/v1/CDashboardAccess?where[0][type]=equals&where[0][attribute]=assignedUserId&where[0][value]=${userId}&where[1][type]=equals&where[1][attribute]=name&where[1][value]=${encodeURIComponent(patchName)}`;
    const response = await makeRequestCRM(url, 'GET');
    return response.total > 0;
}

async function showPatchModal(patch, userId, modalLink) {
    const Swal = await this.window.Espo.loader.requirePromise('swal');

    const showButton = modalLink && modalLink.trim() !== "";

    return new Promise((resolve) => {
        Swal.fire({
            icon: "info",
            title: patch.titleText,
            html: `<div class="update-notification">
                <p style="margin-top: 1%; font-size: 14px; text-align: center;">
                    <strong>${patch.name}</strong><br>${patch.modaltext}<br><br>
                    ${
                        showButton
                            ? `<span id="viewPatchNote" style="color: #007b78; text-decoration: underline; cursor: pointer; font-size: 14px;">${patch.buttonText}</span>`
                            : ""
                    }
                </p></div>`,
            width: '25%',
            confirmButtonText: "OK",
            confirmButtonColor: '#007b78',
            allowOutsideClick: false,
            allowEscapeKey: false,
        }).then(async () => {
            makeRequestCRM("api/v1/CDashboardAccess", "POST", {
                assignedUserId: userId,
                name: patch.name,
                tabName: "PatchNotes",
                accessTime: new Date().toISOString().replace("T", " ").substring(0, 19)
            });
            resolve();
        });

        if (showButton) {
            document.getElementById('viewPatchNote').addEventListener('click', function () {
                handlePatchNoteRedirect(patch.id, userId, patch.name, patch.updatetype, patch.modalLink);
            });
        }

        document.querySelector('.swal2-actions').style = "margin: 0em auto 0 !important;";
        document.querySelector('#swal2-html-container').style = "padding: 0em 1.6em 0.3em !important;";
        document.querySelector('.swal2-confirm ').style = "padding: 10px 24px; background-color: #007b78; color: white; border: none; font-size: 14px";
    });
}


async function handlePatchNoteRedirect(patchId, userId, patchName, updateType, modalLink) {
    const Swal = await this.window.Espo.loader.requirePromise('swal');
    Swal.close();

    const payloadPostCdp = {
        assignedUserId: userId,
        name: patchName,
        tabName: "PatchNotes",
        accessTime: new Date().toISOString().replace("T", " ").substring(0, 19)
    };

    const url = `api/v1/CDashboardAccess`;

    // try {
    //     await makeRequestCRM(url, "POST", payloadPostCdp);
    // } catch (error) {
    //     console.error("Erro ao registrar acesso ao dashboard", error);
    // }

    window.open(modalLink, '_blank');
}

async function makeRequestCRM(url, method, data) {
    return new Promise(function (resolve, reject) {
        const xhr = new XMLHttpRequest();
        xhr.open(method, url);

        if (data !== undefined) {
            xhr.setRequestHeader('Content-Type', 'application/json');
        }

        xhr.setRequestHeader('Authorization', "Basic YXBpX3VzZXI6RW51YmVAMDE=");

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    try {
                        resolve(JSON.parse(xhr.responseText));
                    } catch (parseErr) {
                        console.error("Erro ao fazer parse do JSON da resposta:", xhr.responseText);
                        reject(parseErr);
                    }
                } else {
                    console.error("Erro na requisição:", {
                        status: xhr.status,
                        statusText: xhr.statusText,
                        response: xhr.responseText,
                        url
                    });
                    reject({
                        status: xhr.status,
                        message: xhr.statusText,
                        response: xhr.responseText,
                        url
                    });
                }
            }
        };

        xhr.onerror = function () {
            console.error("Erro de rede ao acessar:", url);
            reject({ message: "Erro de rede", url });
        };

        try {
            xhr.send(data !== undefined ? JSON.stringify(data) : null);
        } catch (sendError) {
            console.error("Erro ao enviar requisição:", sendError);
            reject(sendError);
        }
    });
}


function isUserInPermittedTeam(userTeams, modalTeams) {
    if (!Array.isArray(userTeams) || !Array.isArray(modalTeams)) {
        console.warn("Parâmetros inválidos: Esperado arrays.");
        return false;
    }

    return userTeams.some(teamId => modalTeams.includes(teamId));
}