<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: a67be8f75bc1974a987315ddc1024a78
 ************************************************************************************/

namespace Espo\Modules\Sales\Entities;

use Espo\Core\Field\Address;
use Espo\Core\Field\Currency;
use Espo\Core\Field\Date;
use Espo\Modules\Sales\Tools\Sales\OrderEntity;

class Invoice extends OrderEntity
{
    public const ENTITY_TYPE = 'Invoice';

    public const STATUS_PAID = 'Paid';

    public function getDateInvoiced(): ?Date
    {
        /** @var ?Date */
        return $this->getValueObject('dateInvoiced');
    }

    public function getDateDue(): ?Date
    {
        /** @var ?Date */
        return $this->getValueObject('dateDue');
    }

    public function getAmount(): ?Currency
    {
        /** @var ?Currency */
        return $this->getValueObject('amount');
    }

    public function getBillingAddress(): Address
    {
        /** @var Address */
        return $this->getValueObject('billingAddress');
    }

    public function getShippingAddress(): Address
    {
        /** @var Address */
        return $this->getValueObject('shippingAddress');
    }

    public function getBuyerReference(): ?string
    {
        return $this->get('buyerReference');
    }

    public function getPurchaseOrderReference(): ?string
    {
        return $this->get('purchaseOrderReference');
    }

    public function getNote(): ?string
    {
        return $this->get('note');
    }
}
