<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Classes\Cleanup;

use Espo\Core\Cleanup\Cleanup;
use Espo\Core\Field\DateTime;
use Espo\Modules\Project\Entities\ProjectTask;
use Espo\ORM\EntityManager;
use Espo\ORM\Query\Part\Condition;
use Espo\ORM\Query\SelectBuilder;

class SubProjectTasks implements Cleanup
{
    private const PERIOD = '2 months';

    public function __construct(
        private EntityManager $entityManager,
    ) {}

    public function process(): void
    {
        $query = SelectBuilder::create()
            ->from(ProjectTask::ENTITY_TYPE)
            ->where(['parentTaskId!=' => null])
            ->where(
                Condition::not(
                    Condition::exists(
                        SelectBuilder::create()
                            ->from('ProjectTask', 'p')
                            ->where(['p.id:' => 'projectTask.parentTaskId'])
                            ->build()
                    )
                )
            )
            ->build();

        $from = DateTime::createNow()->modify('- ' . self::PERIOD)->toString();

        $tasks = $this->entityManager
            ->getRDBRepositoryByClass(ProjectTask::class)
            ->clone($query)
            ->where(['modifiedAt<' => $from])
            ->find();

        foreach ($tasks as $task) {
            $this->entityManager->removeEntity($task);
        }
    }
}
