<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Classes\AppParams;

use Espo\Core\Acl;
use Espo\Modules\Project\Entities\Project;
use Espo\Modules\Project\Entities\ProjectBoard;
use Espo\Modules\Project\Entities\ProjectColumn;
use Espo\ORM\EntityManager;
use Espo\Tools\App\AppParam;
use stdClass;

/**
 * @noinspection PhpUnused
 * @todo Use cache.
 */
class ProjectBoards implements AppParam
{
    public function __construct(
        private EntityManager $entityManager,
        private Acl $acl,
    ) {}

    public function get(): stdClass
    {
        if (!$this->acl->checkScope(Project::ENTITY_TYPE)) {
            return (object) [];
        }

        /** @var iterable<ProjectBoard> $boards */
        $boards = $this->entityManager
            ->getRDBRepositoryByClass(ProjectBoard::class)
            ->where([
                'status' => [
                    ProjectBoard::STATUS_DRAFT,
                    ProjectBoard::STATUS_ACTIVE,
                ]
            ])
            ->select(['id'])
            ->find();

        $map = [];

        foreach ($boards as $board) {
            /** @var iterable<ProjectColumn> $columns */
            $columns = $this->entityManager
                ->getRDBRepositoryByClass(ProjectColumn::class)
                ->where(['boardId' => $board->getId()])
                ->select(['id', 'name', 'mappedStatus'])
                ->order('order')
                ->find();

            $columnDataList = [];

            foreach ($columns as $column) {
                $columnDataList[] = [$column->getId(), $column->getName(), $column->getMappedStatus()];
            }

            $map[$board->getId()] = ['columns' => $columnDataList];
        }

        return (object) $map;
    }
}
