/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: e4c270586a0c8a9fda53bda910f357e0
 ************************************************************************************/

define('advanced:views/report/detail', ['views/detail'], function (Dep) {

    return Dep.extend({

        setup: function () {
            Dep.prototype.setup.call(this);

            const version = this.getConfig().get('version') || '';
            const arr = version.split('.');

            if (
                version === 'dev' || arr.length > 2 && parseInt(arr[0]) * 100 + parseInt(arr[1]) >= 506 ||
                version === '@@version'
            ) {
                let iconHtml;

                if (['Grid', 'JointGrid'].includes(this.model.attributes.type)) {
                    iconHtml = '<span class="fas fa-chart-simple fa-sm"></span>';
                } else {
                    iconHtml = '<span class="fas fa-align-justify fa-sm"></span>';
                }

                this.addMenuItem('buttons', {
                    action: 'show',
                    link: `#Report/show/${this.model.id}`,
                    iconHtml: iconHtml,
                    text: this.translate('Results View', 'labels', 'Report'),
                });
            }
        },

        actionShow: function () {
            const options = {
                id: this.model.id,
                model: this.model
            };

            const rootUrl = this.options.rootUrl || this.options.params.rootUrl;
            if (rootUrl) {
                options.rootUrl = rootUrl;
            }

            this.getRouter().navigate(`#Report/show/${this.model.id}`, {trigger: false});
            this.getRouter().dispatch('Report', 'show', options);
        },
    });
});
