<?php
return [
  'ActionHistoryRecord' => [
    'fields' => [
      'user' => 'User',
      'action' => 'Action',
      'createdAt' => 'Date',
      'userType' => 'User Type',
      'target' => 'Target',
      'targetType' => 'Target Type',
      'authToken' => 'Auth Token',
      'ipAddress' => 'IP Address',
      'authLogRecord' => 'Auth Log Record'
    ],
    'links' => [
      'authToken' => 'Auth Token',
      'authLogRecord' => 'Auth Log Record',
      'user' => 'User',
      'target' => 'Target'
    ],
    'presetFilters' => [
      'onlyMy' => 'Only My'
    ],
    'options' => [
      'action' => [
        'read' => 'Read',
        'update' => 'Update',
        'delete' => 'Delete',
        'create' => 'Create'
      ]
    ]
  ],
  'AddressCountry' => [
    'labels' => [
      'Create AddressCountry' => 'Create Address Country',
      'Populate' => 'Populate'
    ],
    'fields' => [
      'code' => 'Code',
      'isPreferred' => 'Is Preferred'
    ],
    'tooltips' => [
      'code' => 'ISO 3166-1 alpha-2 code.',
      'isPreferred' => 'Preferred countries appear first in the picklist.'
    ],
    'messages' => [
      'confirmPopulateDefaults' => 'All existing countries will be deleted, the default country list will be created. It won\'t be possible to revert the operation.

Are you sure?'
    ],
    'strings' => [
      'populateDefaults' => 'Populate with default country list'
    ]
  ],
  'Admin' => [
    'labels' => [
      'Enabled' => 'Enabled',
      'Disabled' => 'Disabled',
      'System' => 'System',
      'Users' => 'Users',
      'Email' => 'Email',
      'Messaging' => 'Messaging',
      'Data' => 'Data',
      'Misc' => 'Misc',
      'Setup' => 'Setup',
      'Customization' => 'Customization',
      'Available Fields' => 'Available Fields',
      'Layout' => 'Layout',
      'Entity Manager' => 'Entity Manager',
      'Add Panel' => 'Add Panel',
      'Add Field' => 'Add Field',
      'Settings' => 'Settings',
      'Scheduled Jobs' => 'Scheduled Jobs',
      'Upgrade' => 'Upgrade',
      'Clear Cache' => 'Clear Cache',
      'Rebuild' => 'Rebuild',
      'Teams' => 'Teams',
      'Roles' => 'Roles',
      'Portal' => 'Portal',
      'Portals' => 'Portals',
      'Portal Roles' => 'Portal Roles',
      'Portal Users' => 'Portal Users',
      'API Users' => 'API Users',
      'Outbound Emails' => 'Outbound Emails',
      'Group Email Accounts' => 'Group Email Accounts',
      'Personal Email Accounts' => 'Personal Email Accounts',
      'Inbound Emails' => 'Inbound Emails',
      'Email Templates' => 'Email Templates',
      'Import' => 'Import',
      'Layout Manager' => 'Layout Manager',
      'User Interface' => 'User Interface',
      'Auth Tokens' => 'Auth Tokens',
      'Auth Log' => 'Auth Log',
      'App Log' => 'App Log',
      'App Secrets' => 'App Secrets',
      'Authentication' => 'Authentication',
      'Currency' => 'Currency',
      'Integrations' => 'Integrations',
      'Extensions' => 'Extensions',
      'Webhooks' => 'Webhooks',
      'Dashboard Templates' => 'Dashboard Templates',
      'Upload' => 'Upload',
      'Installing...' => 'Installing...',
      'Upgrading...' => 'Upgrading...',
      'Upgraded successfully' => 'Upgraded successfully',
      'Installed successfully' => 'Installed successfully',
      'Ready for upgrade' => 'Ready for upgrade',
      'Run Upgrade' => 'Run Upgrade',
      'Install' => 'Install',
      'Ready for installation' => 'Ready for installation',
      'Uninstalling...' => 'Uninstalling...',
      'Uninstalled' => 'Uninstalled',
      'Create Entity' => 'Create Entity',
      'Edit Entity' => 'Edit Entity',
      'Create Link' => 'Create Link',
      'Edit Link' => 'Edit Link',
      'Notifications' => 'Notifications',
      'Jobs' => 'Jobs',
      'Job Settings' => 'Job Settings',
      'Reset to Default' => 'Reset to Default',
      'Email Filters' => 'Email Filters',
      'Action History' => 'Action History',
      'Label Manager' => 'Label Manager',
      'Template Manager' => 'Template Manager',
      'Lead Capture' => 'Lead Capture',
      'Attachments' => 'Attachments',
      'System Requirements' => 'System Requirements',
      'PDF Templates' => 'PDF Templates',
      'PHP Settings' => 'PHP Settings',
      'Database Settings' => 'Database Settings',
      'Permissions' => 'Permissions',
      'Email Addresses' => 'Email Addresses',
      'Phone Numbers' => 'Phone Numbers',
      'Layout Sets' => 'Layout Sets',
      'Working Time Calendars' => 'Working Time Calendars',
      'Group Email Folders' => 'Group Email Folders',
      'Authentication Providers' => 'Authentication Providers',
      'Address Countries' => 'Address Countries',
      'Success' => 'Success',
      'Fail' => 'Fail',
      'Configuration Instructions' => 'Configuration Instructions',
      'Formula Sandbox' => 'Formula Sandbox',
      'is recommended' => 'is recommended',
      'extension is missing' => 'extension is missing',
      'Workflow Manager' => 'Workflows',
      'Flowcharts' => 'Flowcharts',
      'Processes' => 'Processes',
      'Business Process Management' => 'Business Process Management',
      'Report Filters' => 'Report Filters',
      'Report Panels' => 'Report Panels',
      'Price Rule Conditions' => 'Price Rule Conditions'
    ],
    'layouts' => [
      'list' => 'List',
      'detail' => 'Detail',
      'listSmall' => 'List (Small)',
      'detailSmall' => 'Detail (Small)',
      'detailPortal' => 'Detail (Portal)',
      'detailSmallPortal' => 'Detail (Small, Portal)',
      'listSmallPortal' => 'List (Small, Portal)',
      'listPortal' => 'List (Portal)',
      'relationshipsPortal' => 'Relationship Panels (Portal)',
      'filters' => 'Search Filters',
      'massUpdate' => 'Mass Update',
      'relationships' => 'Relationship Panels',
      'defaultSidePanel' => 'Side Panel Fields',
      'bottomPanelsDetail' => 'Bottom Panels',
      'bottomPanelsEdit' => 'Bottom Panels (Edit)',
      'bottomPanelsDetailSmall' => 'Bottom Panels (Detail Small)',
      'bottomPanelsEditSmall' => 'Bottom Panels (Edit Small)',
      'sidePanelsDetail' => 'Side Panels (Detail)',
      'sidePanelsEdit' => 'Side Panels (Edit)',
      'sidePanelsDetailSmall' => 'Side Panels (Detail Small)',
      'sidePanelsEditSmall' => 'Side Panels (Edit Small)',
      'kanban' => 'Kanban',
      'detailConvert' => 'Convert Lead',
      'listForAccount' => 'List (for Account)',
      'listForContact' => 'List (for Contact)',
      'listItem' => 'List (Item)',
      'detailBottomTotal' => 'Bottom Total',
      'listForAdd' => 'List (Select for Item)',
      'listForAddInventory' => 'List (Select Inventory)',
      'detailCreateFromSalesOrder' => 'Create from Sales Order',
      'detailCreateFromPurchaseOrder' => 'Create from Purchase Order',
      'listForProduct' => 'List for Product',
      'listForTemplateProduct' => 'List for Template Product',
      'listForWarehouse' => 'List for Warehouse',
      'listVariant' => 'List Variants'
    ],
    'fieldTypes' => [
      'address' => 'Address',
      'array' => 'Array',
      'foreign' => 'Foreign',
      'duration' => 'Duration',
      'password' => 'Password',
      'personName' => 'Person Name',
      'autoincrement' => 'Auto-increment',
      'bool' => 'Boolean',
      'currency' => 'Currency',
      'currencyConverted' => 'Currency (Converted)',
      'date' => 'Date',
      'datetime' => 'Date-Time',
      'datetimeOptional' => 'Date/Date-Time',
      'email' => 'Email',
      'enum' => 'Enum',
      'enumInt' => 'Enum Integer',
      'enumFloat' => 'Enum Float',
      'float' => 'Float',
      'int' => 'Integer',
      'link' => 'Link',
      'linkMultiple' => 'Link Multiple',
      'linkParent' => 'Link Parent',
      'linkOne' => 'Link One',
      'phone' => 'Phone',
      'text' => 'Text',
      'url' => 'Url',
      'urlMultiple' => 'Url Multiple',
      'varchar' => 'Varchar',
      'file' => 'File',
      'image' => 'Image',
      'multiEnum' => 'Multi-Enum',
      'attachmentMultiple' => 'Attachment Multiple',
      'rangeInt' => 'Range Integer',
      'rangeFloat' => 'Range Float',
      'rangeCurrency' => 'Range Currency',
      'wysiwyg' => 'Wysiwyg',
      'map' => 'Map',
      'number' => 'Number (auto-increment)',
      'colorpicker' => 'Color Picker',
      'checklist' => 'Checklist',
      'barcode' => 'Barcode',
      'jsonArray' => 'Json Array',
      'jsonObject' => 'Json Object',
      'inlineRelationList' => 'Inline Relation List'
    ],
    'fields' => [
      'type' => 'Type',
      'name' => 'Name',
      'label' => 'Label',
      'tooltipText' => 'Tooltip Text',
      'required' => 'Required',
      'default' => 'Default',
      'maxLength' => 'Max Length',
      'options' => 'Options',
      'optionsReference' => 'Options Reference',
      'after' => 'After (field)',
      'before' => 'Before (field)',
      'link' => 'Link',
      'field' => 'Field',
      'min' => 'Min',
      'max' => 'Max',
      'translation' => 'Translation',
      'previewSize' => 'Preview Size',
      'listPreviewSize' => 'Preview Size in List View',
      'noEmptyString' => 'Empty string value is not allowed',
      'defaultType' => 'Default Type',
      'seeMoreDisabled' => 'Disable Text Cut',
      'cutHeight' => 'Cut Height (px)',
      'entityList' => 'Entity List',
      'isSorted' => 'Is Sorted (alphabetically)',
      'audited' => 'Audited',
      'trim' => 'Trim',
      'height' => 'Height (px)',
      'minHeight' => 'Min Height (px)',
      'provider' => 'Provider',
      'typeList' => 'Type List',
      'rows' => 'Max number of rows',
      'lengthOfCut' => 'Length of cut',
      'sourceList' => 'Source List',
      'prefix' => 'Prefix',
      'nextNumber' => 'Next Number',
      'padLength' => 'Pad Length',
      'disableFormatting' => 'Disable Formatting',
      'dynamicLogicVisible' => 'Conditions making field visible',
      'dynamicLogicReadOnly' => 'Conditions making field read-only',
      'dynamicLogicRequired' => 'Conditions making field required',
      'dynamicLogicOptions' => 'Conditional options',
      'dynamicLogicInvalid' => 'Conditions making field invalid',
      'probabilityMap' => 'Stage Probabilities (%)',
      'notActualOptions' => 'Not Actual Options',
      'activeOptions' => 'Active Options',
      'readOnly' => 'Read-only',
      'readOnlyAfterCreate' => 'Read-only After Create',
      'preview' => 'Preview',
      'attachmentField' => 'Attachment Field',
      'maxFileSize' => 'Max File Size (Mb)',
      'isPersonalData' => 'Is Personal Data',
      'useIframe' => 'Use Iframe',
      'useNumericFormat' => 'Use Numeric Format',
      'strip' => 'Strip',
      'minuteStep' => 'Minutes Step',
      'inlineEditDisabled' => 'Disable Inline Edit',
      'allowCustomOptions' => 'Allow Custom Options',
      'displayAsLabel' => 'Display as Label',
      'displayAsList' => 'Display as List',
      'labelType' => 'Label Type',
      'maxCount' => 'Max Item Count',
      'accept' => 'Accept',
      'viewMap' => 'View Map Button',
      'codeType' => 'Code Type',
      'lastChar' => 'Last Character',
      'onlyDefaultCurrency' => 'Only default currency',
      'decimal' => 'Decimal',
      'displayRawText' => 'Display raw text (no markdown)',
      'conversionDisabled' => 'Disable Conversion',
      'decimalPlaces' => 'Decimal Places',
      'pattern' => 'Pattern',
      'globalRestrictions' => 'Global Restrictions',
      'copyToClipboard' => 'Copy to clipboard button',
      'createButton' => 'Create Button',
      'autocompleteOnEmpty' => 'Autocomplete on empty input',
      'relateOnImport' => 'Relate on Import',
      'aclScope' => 'ACL Scope',
      'onlyAdmin' => 'Only for Admin',
      'enableForm' => 'Enable Form',
      'rowActionItems' => 'Row Action Items',
      'buttonsPosition' => 'Buttons Position (Add & Select)',
      'enableSelect' => 'Enable Select Button',
      'enableAdd' => 'Enable Add Row Button',
      'enableCreateInModal' => 'Enable Create In Modal Button',
      'enableAddMultiple' => 'Enable Add Multiple Button',
      'footerSumFields' => 'Footer Sum Fields',
      'footerSumFieldsMap' => 'Footer Sum Fields Map',
      'middleLink' => 'Middle Link (Act As Middle Entity)',
      'isMiddleLinkUnique' => 'Is Middle Link Unique',
      'layout' => 'Detail Layout',
      'editLayout' => 'Edit Layout',
      'customLayout' => 'Custom Layout',
      'editLayoutLink' => 'Custom Edit Layout',
      'readOnlyFields' => 'Readonly Fields',
      'noEditAccessRequiredForUnLink' => 'No Child Edit Access Required for Link/Unlink',
      'copyFields' => 'Copy Fields',
      'orderBy' => 'Order By',
      'useAutoincrement' => 'Auto-Increment',
      'copyFieldList' => 'Fields to Copy'
    ],
    'strings' => [
      'rebuildRequired' => 'Rebuild is required'
    ],
    'messages' => [
      'cacheIsDisabled' => 'Cache is disabled, the application will run slow. Enable cache in the [settings](#Admin/settings).',
      'formulaFunctions' => 'More functions can be found in [documentation]({documentationUrl}).',
      'rebuildRequired' => 'You need to run rebuild from CLI.',
      'upgradeVersion' => 'TD SYNNEX MCA will be upgraded to version **{version}**. Please be patient as this may take a while.',
      'upgradeDone' => 'TD SYNNEX MCA has been upgraded to version **{version}**.',
      'upgradeBackup' => 'We recommend making a backup of your TD SYNNEX MCA files and data before upgrading.',
      'thousandSeparatorEqualsDecimalMark' => 'The thousands separator character can not be the same as the decimal point character.',
      'userHasNoEmailAddress' => 'User has no email address.',
      'selectEntityType' => 'Select entity type in the left menu.',
      'selectUpgradePackage' => 'Select upgrade package',
      'downloadUpgradePackage' => 'Download upgrade package(s) [here]({url}).',
      'selectLayout' => 'Select needed layout in the left menu and edit it.',
      'selectExtensionPackage' => 'Select extension package',
      'extensionInstalled' => 'Extension {name} {version} has been installed.',
      'installExtension' => 'Extension {name} {version} is ready for an installation.',
      'cronIsDisabled' => 'Cron is disabled, the application is not fully functional. Enable cron in the [settings](#Admin/settings).',
      'cronIsNotConfigured' => 'Scheduled jobs are not running.  Hence inbound emails, notifications and reminders are not working. Please follow the [instructions](https://www.espocrm.com/documentation/administration/server-configuration/#user-content-setup-a-crontab) to setup cron job.',
      'newVersionIsAvailable' => 'New TD SYNNEX MCA version {latestVersion} is available. Please follow the [instructions](https://www.espocrm.com/documentation/administration/upgrading/) to upgrade your instance.',
      'newExtensionVersionIsAvailable' => 'New {extensionName} version {latestVersion} is available.',
      'uninstallConfirmation' => 'Are you sure you want to uninstall the extension?',
      'upgradeInfo' => 'Check the [documentation]({url}) about how to upgrade your TD SYNNEX MCA instance.',
      'upgradeRecommendation' => 'This way of upgrading is not recommended. It\'s better to upgrade from CLI.',
      'newAdvancedPackVersionIsAvailable' => 'New Advanced Pack version {latestVersion} is available. It can be downloaded on the customer portal.'
    ],
    'descriptions' => [
      'settings' => 'System settings of application.',
      'scheduledJob' => 'Jobs which are executed by cron.',
      'jobs' => 'Jobs execute tasks in the background.',
      'upgrade' => 'Upgrade TD SYNNEX MCA.',
      'clearCache' => 'Clear all backend cache.',
      'rebuild' => 'Rebuild backend and clear cache.',
      'users' => 'Users management.',
      'teams' => 'Teams management.',
      'roles' => 'Roles management.',
      'portals' => 'Portals management.',
      'portalRoles' => 'Roles for portal.',
      'portalUsers' => 'Users of portal.',
      'outboundEmails' => 'SMTP settings for outgoing emails.',
      'groupEmailAccounts' => 'Group IMAP email accounts. Email import and Email-to-Case.',
      'personalEmailAccounts' => 'Users email accounts.',
      'emailTemplates' => 'Templates for outbound emails.',
      'import' => 'Import data from CSV file.',
      'layoutManager' => 'Customize layouts (list, detail, edit, search, mass update).',
      'entityManager' => 'Create and edit custom entities. Manage fields and relationships.',
      'userInterface' => 'Configure UI.',
      'authTokens' => 'Active auth sessions. IP address and last access date.',
      'authentication' => 'Authentication settings.',
      'currency' => 'Currency settings and rates.',
      'extensions' => 'Install or uninstall extensions.',
      'integrations' => 'Integration with third-party services.',
      'notifications' => 'In-app and email notification settings.',
      'inboundEmails' => 'Settings for incoming emails.',
      'emailFilters' => 'Email messages that match the specified filter won\'t be imported.',
      'groupEmailFolders' => 'Email folders shared for teams.',
      'actionHistory' => 'Log of user actions.',
      'labelManager' => 'Customize application labels.',
      'templateManager' => 'Customize message templates.',
      'authLog' => 'Login history.',
      'appLog' => 'Application log.',
      'appSecrets' => 'Store sensitive information like API keys, passwords, and other secrets.',
      'leadCapture' => 'Lead capture endpoints and web forms.',
      'attachments' => 'All file attachments stored in the system.',
      'systemRequirements' => 'System Requirements for TD SYNNEX MCA.',
      'apiUsers' => 'Separate users for integration purposes.',
      'webhooks' => 'Manage webhooks.',
      'authenticationProviders' => 'Additional authentication providers for portals.',
      'emailAddresses' => 'All email addresses stored in the system.',
      'phoneNumbers' => 'All phone numbers stored in the system.',
      'dashboardTemplates' => 'Deploy dashboards to users.',
      'layoutSets' => 'Collections of layouts that can be assigned to teams & portals.',
      'workingTimeCalendars' => 'Working schedule.',
      'jobsSettings' => 'Job processing settings. Jobs execute tasks in the background.',
      'sms' => 'SMS settings.',
      'pdfTemplates' => 'Templates for printing to PDF.',
      'formulaSandbox' => 'Write and test formula scripts.',
      'addressCountries' => 'Countries available for address fields.',
      'workflowManager' => 'Configure Workflow rules.',
      'bpmnFlowcharts' => 'Definitions of business processes.',
      'bpmnProcesses' => 'Instances of business processes.',
      'reportFilters' => 'Custom list view filters based on reports.',
      'reportPanels' => 'Detail view panels showing report results.',
      'salesPackSettings' => 'Parameters for sales & purchase functionality.',
      'priceRuleConditions' => 'Formula conditions for price rules.'
    ],
    'keywords' => [
      'settings' => 'system',
      'userInterface' => 'ui,theme,tabs,logo,dashboard',
      'authentication' => 'password,security,ldap',
      'scheduledJob' => 'cron,jobs',
      'integrations' => 'google,maps,google maps',
      'authLog' => 'log,history',
      'authTokens' => 'history,access,log',
      'entityManager' => 'fields,relations,relationships',
      'templateManager' => 'notifications',
      'jobs' => 'cron',
      'labelManager' => 'language,translation',
      'appSecrets' => 'key,keys,password',
      'leadCapture' => 'web forms',
      'bpmnFlowcharts' => 'bpm',
      'bpmnProcesses' => 'bpm',
      'salesPack' => 'price,price book,price books'
    ],
    'options' => [
      'previewSize' => [
        '' => 'Default',
        'x-small' => 'X-Small',
        'small' => 'Small',
        'medium' => 'Medium',
        'large' => 'Large'
      ],
      'labelType' => [
        'state' => 'State',
        'regular' => 'Regular'
      ],
      'order' => [
        'asc' => 'Ascending',
        'desc' => 'Descending'
      ],
      'buttonsPosition' => [
        'top' => 'Top',
        'bottom' => 'Bottom'
      ],
      'rowActionItems' => [
        'edit' => 'Edit',
        'view' => 'View',
        'remove' => 'Remove',
        'unlink' => 'Unlink'
      ]
    ],
    'logicalOperators' => [
      'and' => 'AND',
      'or' => 'OR',
      'not' => 'NOT'
    ],
    'systemRequirements' => [
      'requiredPhpVersion' => 'PHP Version',
      'requiredMysqlVersion' => 'MySQL Version',
      'requiredMariadbVersion' => 'MariaDB version',
      'requiredPostgresqlVersion' => 'PostgreSQL version',
      'host' => 'Host Name',
      'dbname' => 'Database Name',
      'user' => 'User Name',
      'writable' => 'Writable',
      'readable' => 'Readable'
    ],
    'templates' => [
      'twoFactorCode' => '2FA Code',
      'accessInfo' => 'Access Info',
      'accessInfoPortal' => 'Access Info for Portals',
      'assignment' => 'Assignment',
      'mention' => 'Mention',
      'noteEmailReceived' => 'Note about Received Email',
      'notePost' => 'Note about Post',
      'notePostNoParent' => 'Note about Post (no Parent)',
      'noteStatus' => 'Note about Status Update',
      'passwordChangeLink' => 'Password Change Link',
      'invitation' => 'Invitation',
      'cancellation' => 'Cancellation',
      'reminder' => 'Reminder',
      'reportSendingGrid1' => 'Report Grid-1',
      'reportSendingGrid2' => 'Report Grid-2',
      'reportSendingList' => 'Report List',
      'salesEmailPdf' => 'Email PDF (Sales)'
    ]
  ],
  'ApiUser' => [
    'labels' => [
      'Create ApiUser' => 'Create API User'
    ]
  ],
  'AppLogRecord' => [
    'fields' => [
      'message' => 'Message',
      'code' => 'Code',
      'level' => 'Level',
      'exceptionClass' => 'Exception Class',
      'file' => 'File',
      'line' => 'Line',
      'requestMethod' => 'Request Method',
      'requestResourcePath' => 'Request Resource Path'
    ],
    'presetFilters' => [
      'errors' => 'Errors'
    ]
  ],
  'AppSecret' => [
    'labels' => [
      'Create AppSecret' => 'Create Secret'
    ],
    'fields' => [
      'value' => 'Value'
    ],
    'tooltips' => [
      'name' => 'Allowed characters:
* `[a-z]`
* `[A-Z]`
* `[0-9]`
* `_`'
    ]
  ],
  'Attachment' => [
    'fields' => [
      'role' => 'Role',
      'related' => 'Related',
      'file' => 'File',
      'type' => 'Type',
      'field' => 'Field',
      'sourceId' => 'Source ID',
      'storage' => 'Storage',
      'size' => 'Size (bytes)',
      'isBeingUploaded' => 'Is Being Uploaded'
    ],
    'options' => [
      'role' => [
        'Attachment' => 'Attachment',
        'Inline Attachment' => 'Inline Attachment',
        'Import File' => 'Import File',
        'Export File' => 'Export File',
        'Mail Merge' => 'Mail Merge',
        'Mass Pdf' => 'Mass Pdf'
      ]
    ],
    'insertFromSourceLabels' => [
      'Document' => 'Insert Document'
    ],
    'presetFilters' => [
      'orphan' => 'Orphan'
    ]
  ],
  'AuthLogRecord' => [
    'fields' => [
      'username' => 'Username',
      'ipAddress' => 'IP Address',
      'requestTime' => 'Request Time',
      'createdAt' => 'Requested At',
      'isDenied' => 'Is Denied',
      'denialReason' => 'Denial Reason',
      'portal' => 'Portal',
      'user' => 'User',
      'authToken' => 'Auth Token Created',
      'requestUrl' => 'Request URL',
      'requestMethod' => 'Request Method',
      'authTokenIsActive' => 'Auth Token is Active',
      'authenticationMethod' => 'Authentication Method'
    ],
    'links' => [
      'authToken' => 'Auth Token Created',
      'user' => 'User',
      'portal' => 'Portal',
      'actionHistoryRecords' => 'Action History'
    ],
    'presetFilters' => [
      'denied' => 'Denied',
      'accepted' => 'Accepted'
    ],
    'options' => [
      'denialReason' => [
        'CREDENTIALS' => 'Invalid credentials',
        'WRONG_CODE' => 'Wrong code',
        'INACTIVE_USER' => 'Inactive user',
        'IS_PORTAL_USER' => 'Portal user',
        'IS_NOT_PORTAL_USER' => 'Not a portal user',
        'USER_IS_NOT_IN_PORTAL' => 'User is not related to the portal',
        'IS_SYSTEM_USER' => 'Is system user',
        'FORBIDDEN' => 'Forbidden'
      ]
    ]
  ],
  'AuthToken' => [
    'fields' => [
      'user' => 'User',
      'ipAddress' => 'IP Address',
      'lastAccess' => 'Last Access Date',
      'createdAt' => 'Login Date',
      'isActive' => 'Is Active',
      'portal' => 'Portal'
    ],
    'links' => [
      'actionHistoryRecords' => 'Action History'
    ],
    'presetFilters' => [
      'active' => 'Active',
      'inactive' => 'Inactive'
    ],
    'labels' => [
      'Set Inactive' => 'Set Inactive'
    ],
    'massActions' => [
      'setInactive' => 'Set Inactive'
    ]
  ],
  'AuthenticationProvider' => [
    'fields' => [
      'method' => 'Method'
    ],
    'labels' => [
      'Create AuthenticationProvider' => 'Create Provider'
    ]
  ],
  'Currency' => [
    'names' => [
      'AED' => 'United Arab Emirates Dirham',
      'AFN' => 'Afghan Afghani',
      'ALL' => 'Albanian Lek',
      'AMD' => 'Armenian Dram',
      'ANG' => 'Netherlands Antillean Guilder',
      'AOA' => 'Angolan Kwanza',
      'ARS' => 'Argentine Peso',
      'AUD' => 'Australian Dollar',
      'AWG' => 'Aruban Florin',
      'AZN' => 'Azerbaijani Manat',
      'BAM' => 'Bosnia-Herzegovina Convertible Mark',
      'BBD' => 'Barbadian Dollar',
      'BDT' => 'Bangladeshi Taka',
      'BGN' => 'Bulgarian Lev',
      'BHD' => 'Bahraini Dinar',
      'BIF' => 'Burundian Franc',
      'BMD' => 'Bermudan Dollar',
      'BND' => 'Brunei Dollar',
      'BOB' => 'Bolivian Boliviano',
      'BOV' => 'Bolivian Mvdol',
      'BRL' => 'Brazilian Real',
      'BSD' => 'Bahamian Dollar',
      'BTN' => 'Bhutanese Ngultrum',
      'BWP' => 'Botswanan Pula',
      'BYN' => 'Belarusian Ruble',
      'BZD' => 'Belize Dollar',
      'CAD' => 'Canadian Dollar',
      'CDF' => 'Congolese Franc',
      'CHE' => 'WIR Euro',
      'CHF' => 'Swiss Franc',
      'CHW' => 'WIR Franc',
      'CLF' => 'Chilean Unit of Account (UF)',
      'CLP' => 'Chilean Peso',
      'CNH' => 'Chinese Yuan (offshore)',
      'CNY' => 'Chinese Yuan',
      'COP' => 'Colombian Peso',
      'COU' => 'Colombian Real Value Unit',
      'CRC' => 'Costa Rican Colón',
      'CUC' => 'Cuban Convertible Peso',
      'CUP' => 'Cuban Peso',
      'CVE' => 'Cape Verdean Escudo',
      'CZK' => 'Czech Koruna',
      'DJF' => 'Djiboutian Franc',
      'DKK' => 'Danish Krone',
      'DOP' => 'Dominican Peso',
      'DZD' => 'Algerian Dinar',
      'EGP' => 'Egyptian Pound',
      'ERN' => 'Eritrean Nakfa',
      'ETB' => 'Ethiopian Birr',
      'EUR' => 'Euro',
      'FJD' => 'Fijian Dollar',
      'FKP' => 'Falkland Islands Pound',
      'GBP' => 'British Pound',
      'GEL' => 'Georgian Lari',
      'GHS' => 'Ghanaian Cedi',
      'GIP' => 'Gibraltar Pound',
      'GMD' => 'Gambian Dalasi',
      'GNF' => 'Guinean Franc',
      'GTQ' => 'Guatemalan Quetzal',
      'GYD' => 'Guyanaese Dollar',
      'HKD' => 'Hong Kong Dollar',
      'HNL' => 'Honduran Lempira',
      'HRK' => 'Croatian Kuna',
      'HTG' => 'Haitian Gourde',
      'HUF' => 'Hungarian Forint',
      'IDR' => 'Indonesian Rupiah',
      'ILS' => 'Israeli New Shekel',
      'INR' => 'Indian Rupee',
      'IQD' => 'Iraqi Dinar',
      'IRR' => 'Iranian Rial',
      'ISK' => 'Icelandic Króna',
      'JMD' => 'Jamaican Dollar',
      'JOD' => 'Jordanian Dinar',
      'JPY' => 'Japanese Yen',
      'KES' => 'Kenyan Shilling',
      'KGS' => 'Kyrgystani Som',
      'KHR' => 'Cambodian Riel',
      'KMF' => 'Comorian Franc',
      'KPW' => 'North Korean Won',
      'KRW' => 'South Korean Won',
      'KWD' => 'Kuwaiti Dinar',
      'KYD' => 'Cayman Islands Dollar',
      'KZT' => 'Kazakhstani Tenge',
      'LAK' => 'Laotian Kip',
      'LBP' => 'Lebanese Pound',
      'LKR' => 'Sri Lankan Rupee',
      'LRD' => 'Liberian Dollar',
      'LSL' => 'Lesotho Loti',
      'LYD' => 'Libyan Dinar',
      'MAD' => 'Moroccan Dirham',
      'MDL' => 'Moldovan Leu',
      'MGA' => 'Malagasy Ariary',
      'MKD' => 'Macedonian Denar',
      'MMK' => 'Myanmar Kyat',
      'MNT' => 'Mongolian Tugrik',
      'MOP' => 'Macanese Pataca',
      'MRO' => 'Mauritanian Ouguiya',
      'MUR' => 'Mauritian Rupee',
      'MWK' => 'Malawian Kwacha',
      'MXN' => 'Mexican Peso',
      'MXV' => 'Mexican Investment Unit',
      'MYR' => 'Malaysian Ringgit',
      'MZN' => 'Mozambican Metical',
      'NAD' => 'Namibian Dollar',
      'NGN' => 'Nigerian Naira',
      'NIO' => 'Nicaraguan Córdoba',
      'NOK' => 'Norwegian Krone',
      'NPR' => 'Nepalese Rupee',
      'NZD' => 'New Zealand Dollar',
      'OMR' => 'Omani Rial',
      'PAB' => 'Panamanian Balboa',
      'PEN' => 'Peruvian Sol',
      'PGK' => 'Papua New Guinean Kina',
      'PHP' => 'Philippine Piso',
      'PKR' => 'Pakistani Rupee',
      'PLN' => 'Polish Zloty',
      'PYG' => 'Paraguayan Guarani',
      'QAR' => 'Qatari Rial',
      'RON' => 'Romanian Leu',
      'RSD' => 'Serbian Dinar',
      'RUB' => 'Russian Ruble',
      'RWF' => 'Rwandan Franc',
      'SAR' => 'Saudi Riyal',
      'SBD' => 'Solomon Islands Dollar',
      'SCR' => 'Seychellois Rupee',
      'SDG' => 'Sudanese Pound',
      'SEK' => 'Swedish Krona',
      'SGD' => 'Singapore Dollar',
      'SHP' => 'St. Helena Pound',
      'SLL' => 'Sierra Leonean Leone',
      'SOS' => 'Somali Shilling',
      'SRD' => 'Surinamese Dollar',
      'SSP' => 'South Sudanese Pound',
      'STN' => 'São Tomé & Príncipe Dobra (2018)',
      'SYP' => 'Syrian Pound',
      'SZL' => 'Swazi Lilangeni',
      'SVC' => 'Salvadoran Colón',
      'THB' => 'Thai Baht',
      'TJS' => 'Tajikistani Somoni',
      'TND' => 'Tunisian Dinar',
      'TOP' => 'Tongan Paʻanga',
      'TRY' => 'Turkish Lira',
      'TTD' => 'Trinidad & Tobago Dollar',
      'TWD' => 'New Taiwan Dollar',
      'TZS' => 'Tanzanian Shilling',
      'UAH' => 'Ukrainian Hryvnia',
      'UGX' => 'Ugandan Shilling',
      'USD' => 'US Dollar',
      'USN' => 'US Dollar (Next day)',
      'UYI' => 'Uruguayan Peso (Indexed Units)',
      'UYU' => 'Uruguayan Peso',
      'UZS' => 'Uzbekistani Som',
      'VEF' => 'Venezuelan Bolívar',
      'VND' => 'Vietnamese Dong',
      'VUV' => 'Vanuatu Vatu',
      'WST' => 'Samoan Tala',
      'XAF' => 'Central African CFA Franc',
      'XCD' => 'East Caribbean Dollar',
      'XOF' => 'West African CFA Franc',
      'XPF' => 'CFP Franc',
      'YER' => 'Yemeni Rial',
      'ZAR' => 'South African Rand',
      'ZMW' => 'Zambian Kwacha',
      'ZWL' => 'Zimbabwe Dollar'
    ]
  ],
  'DashboardTemplate' => [
    'fields' => [
      'layout' => 'Layout',
      'append' => 'Append (don\'t remove user\'s tabs)'
    ],
    'links' => [],
    'labels' => [
      'Create DashboardTemplate' => 'Create Template',
      'Deploy to Users' => 'Deploy to Users',
      'Deploy to Team' => 'Deploy to Team'
    ]
  ],
  'DashletOptions' => [
    'fields' => [
      'title' => 'Title',
      'dateFrom' => 'Date From',
      'dateTo' => 'Date To',
      'autorefreshInterval' => 'Auto-refresh Interval',
      'displayRecords' => 'Display Records',
      'isDoubleHeight' => 'Height 2x',
      'mode' => 'Mode',
      'enabledScopeList' => 'What to display',
      'users' => 'Users',
      'entityType' => 'Entity Type',
      'primaryFilter' => 'Primary Filter',
      'boolFilterList' => 'Additional Filters',
      'sortBy' => 'Order (field)',
      'sortDirection' => 'Order (direction)',
      'expandedLayout' => 'Layout',
      'skipOwn' => 'Don\'t show own records',
      'url' => 'URL',
      'dateFilter' => 'Date Filter',
      'text' => 'Text',
      'folder' => 'Folder',
      'includeShared' => 'Include Shared',
      'team' => 'Team',
      'futureDays' => 'Next X Days',
      'useLastStage' => 'Group by last reached stage',
      'report' => 'Report',
      'column' => 'Summation Column',
      'displayOnlyCount' => 'Display Only Total',
      'displayTotal' => 'Display Total',
      'useSiMultiplier' => 'SI Multiplier',
      'displayType' => 'What to display'
    ],
    'options' => [
      'mode' => [
        'agendaWeek' => 'Week (agenda)',
        'basicWeek' => 'Week',
        'month' => 'Month',
        'basicDay' => 'Day',
        'agendaDay' => 'Day (agenda)',
        'timeline' => 'Timeline'
      ],
      'sortDirection' => [
        'asc' => 'Ascending',
        'desc' => 'Descending'
      ]
    ],
    'messages' => [
      'selectEntityType' => 'Select Entity Type in dashlet options.'
    ],
    'tooltips' => [
      'skipOwn' => 'Actions made by your user account won\'t be displayed.'
    ]
  ],
  'DynamicLogic' => [
    'labels' => [
      'Field' => 'Field'
    ],
    'options' => [
      'operators' => [
        'equals' => 'Equals',
        'notEquals' => 'Not Equals',
        'greaterThan' => 'Greater Than',
        'lessThan' => 'Less Than',
        'greaterThanOrEquals' => 'Greater Than Or Equals',
        'lessThanOrEquals' => 'Less Than Or Equals',
        'in' => 'In',
        'notIn' => 'Not In',
        'inPast' => 'In Past',
        'inFuture' => 'Is Future',
        'isToday' => 'Is Today',
        'isTrue' => 'Is True',
        'isFalse' => 'Is False',
        'isEmpty' => 'Is Empty',
        'isNotEmpty' => 'Is Not Empty',
        'contains' => 'Contains',
        'notContains' => 'Not Contains',
        'has' => 'Contains',
        'notHas' => 'Not Contains',
        'startsWith' => 'Starts With',
        'endsWith' => 'Ends With',
        'matches' => 'Matches (reg exp)'
      ]
    ]
  ],
  'Email' => [
    'fields' => [
      'name' => 'Name (Subject)',
      'parent' => 'Parent',
      'status' => 'Status',
      'dateSent' => 'Date Sent',
      'from' => 'From',
      'to' => 'To',
      'cc' => 'CC',
      'bcc' => 'BCC',
      'replyTo' => 'Reply To',
      'replyToString' => 'Reply To (String)',
      'personStringData' => 'Person String Data',
      'isHtml' => 'HTML',
      'body' => 'Body',
      'bodyPlain' => 'Body (Plain)',
      'subject' => 'Subject',
      'attachments' => 'Attachments',
      'selectTemplate' => 'Select Template',
      'fromEmailAddress' => 'From Address (link)',
      'emailAddress' => 'Email Address',
      'deliveryDate' => 'Delivery Date',
      'account' => 'Account',
      'users' => 'Users',
      'replied' => 'Replied',
      'replies' => 'Replies',
      'isRead' => 'Is Read',
      'isNotRead' => 'Is Not Read',
      'isImportant' => 'Is Important',
      'isReplied' => 'Is Replied',
      'isNotReplied' => 'Is Not Replied',
      'isUsers' => 'Is User\'s',
      'isUsersSent' => 'Is User\'s Sent',
      'inTrash' => 'In Trash',
      'inArchive' => 'In Archive',
      'folder' => 'Folder',
      'inboundEmails' => 'Group Accounts',
      'emailAccounts' => 'Personal Accounts',
      'hasAttachment' => 'Has Attachment',
      'assignedUsers' => 'Assigned Users',
      'sentBy' => 'Sent By',
      'toEmailAddresses' => 'To EmailAddresses',
      'ccEmailAddresses' => 'CC Email Addresses',
      'bccEmailAddresses' => 'BCC EmailAddresses',
      'replyToEmailAddresses' => 'Reply-To EmailAddresses',
      'messageId' => 'Message Id',
      'messageIdInternal' => 'Message Id (Internal)',
      'folderId' => 'Folder Id',
      'folderString' => 'Folder',
      'fromName' => 'From Name',
      'fromString' => 'From String',
      'fromAddress' => 'From Address',
      'replyToName' => 'Reply-To Name',
      'replyToAddress' => 'Reply-To Address',
      'isSystem' => 'Is System',
      'icsContents' => 'ICS Contents',
      'icsEventData' => 'ICS Event Data',
      'icsEventUid' => 'ICS Event UID',
      'createdEvent' => 'Created Event',
      'event' => 'Event',
      'icsEventDateStart' => 'ICS Event Date Start',
      'groupFolder' => 'Group Folder',
      'groupStatusFolder' => 'Group Status Folder',
      'sendAt' => 'Send At',
      'tasks' => 'Tasks',
      'emailContent' => 'Email Content'
    ],
    'links' => [
      'replied' => 'Replied',
      'replies' => 'Replies',
      'inboundEmails' => 'Group Accounts',
      'emailAccounts' => 'Personal Accounts',
      'assignedUsers' => 'Assigned Users',
      'sentBy' => 'Sent By',
      'attachments' => 'Attachments',
      'fromEmailAddress' => 'From Email Address',
      'toEmailAddresses' => 'To Email Addresses',
      'ccEmailAddresses' => 'CC Email Addresses',
      'bccEmailAddresses' => 'BCC Email Addresses',
      'replyToEmailAddresses' => 'Reply-To Email Addresses',
      'createdEvent' => 'Created Event',
      'groupFolder' => 'Group Folder',
      'emailContent' => 'Email Content'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Sending' => 'Sending',
        'Sent' => 'Sent',
        'Archived' => 'Imported',
        'Received' => 'Received',
        'Failed' => 'Failed'
      ],
      'groupStatusFolder' => [
        'Archive' => 'Archive',
        'Trash' => 'Trash'
      ]
    ],
    'labels' => [
      'Create Email' => 'Archive Email',
      'Archive Email' => 'Archive Email',
      'Import EML' => 'Import EML',
      'Compose' => 'Compose',
      'Reply' => 'Reply',
      'Reply to All' => 'Reply to All',
      'Forward' => 'Forward',
      'Insert Field' => 'Insert Field',
      'Original message' => 'Original message',
      'Forwarded message' => 'Forwarded message',
      'Email Accounts' => 'Personal Email Accounts',
      'Inbound Emails' => 'Group Email Accounts',
      'Email Templates' => 'Email Templates',
      'Send Test Email' => 'Send Test Email',
      'Send' => 'Send',
      'Email Address' => 'Email Address',
      'Mark Read' => 'Mark Read',
      'Sending...' => 'Sending...',
      'Save Draft' => 'Save Draft',
      'Mark all as read' => 'Mark all as read',
      'Show Plain Text' => 'Show Plain Text',
      'Mark as Important' => 'Mark as Important',
      'Unmark Importance' => 'Unmark Importance',
      'Move to Trash' => 'Move to Trash',
      'Retrieve from Trash' => 'Retrieve from Trash',
      'Move to Folder' => 'Move to Folder',
      'Moved to Archive' => 'Moved to Archive',
      'No Records Moved' => 'No Records Moved',
      'Filters' => 'Filters',
      'Folders' => 'Folders',
      'Group Folders' => 'Group Folders',
      'No Subject' => 'No Subject',
      'View Users' => 'View Users',
      'Event' => 'Event',
      'View Attachments' => 'View Attachments',
      'Moved to Trash' => 'Moved to Trash',
      'Retrieved from Trash' => 'Retrieved from Trash',
      'Schedule Send' => 'Schedule Send',
      'Create Lead' => 'Create Lead',
      'Create Contact' => 'Create Contact',
      'Add to Contact' => 'Add to Contact',
      'Add to Lead' => 'Add to Lead',
      'Create Task' => 'Create Task',
      'Create Case' => 'Create Case'
    ],
    'strings' => [
      'sendingFailed' => 'Email sending failed',
      'group' => 'Group'
    ],
    'messages' => [
      'confirmSend' => 'Send the email?',
      'couldNotSentScheduledEmail' => 'Could not send scheduled [email]({link})',
      'notEditAccess' => 'No edit access to email.',
      'groupFolderNoAccess' => 'No access to group folder.',
      'groupMoveOutNoEditAccess' => 'Cannot move out from group folder. No edit access to email.',
      'groupMoveToNoEditAccess' => 'Cannot move to group folder. No edit access to email.',
      'groupMoveToTrashNoEditAccess' => 'Cannot move email from group folder to trash. No edit access to email.',
      'groupMoveToArchiveNoEditAccess' => 'Cannot move from group folder to Archive. No edit access to email.',
      'alreadyImported' => 'The [email]({link}) already exists in the system.',
      'invalidCredentials' => 'Invalid credentials.',
      'unknownError' => 'Unknown error.',
      'recipientAddressRejected' => 'Recipient address rejected.',
      'noSmtpSetup' => 'SMTP is not configured: {link}',
      'testEmailSent' => 'Test email has been sent',
      'emailSent' => 'Email has been sent',
      'savedAsDraft' => 'Saved as draft',
      'sendConfirm' => 'Send the email?',
      'removeSelectedRecordsConfirmation' => 'Are you sure you want to remove selected emails?

They will be removed for other users too.',
      'removeRecordConfirmation' => 'Are you sure you want to remove the email?

It will be removed for other users too.',
      'confirmInsertTemplate' => 'The email body will be lost. Are you sure you want to insert the template?'
    ],
    'presetFilters' => [
      'sent' => 'Sent',
      'archived' => 'Imported',
      'inbox' => 'Inbox',
      'drafts' => 'Drafts',
      'trash' => 'Trash',
      'archive' => 'Archive',
      'important' => 'Important'
    ],
    'actions' => [
      'moveToArchive' => 'Archive'
    ],
    'massActions' => [
      'markAsRead' => 'Mark as Read',
      'markAsNotRead' => 'Mark as Not Read',
      'markAsImportant' => 'Mark as Important',
      'markAsNotImportant' => 'Unmark Importance',
      'moveToTrash' => 'Move to Trash',
      'moveToFolder' => 'Move to Folder',
      'moveToArchive' => 'Archive',
      'retrieveFromTrash' => 'Retrieve from Trash'
    ],
    'otherFields' => [
      'file' => 'File'
    ]
  ],
  'EmailAccount' => [
    'fields' => [
      'name' => 'Name',
      'status' => 'Status',
      'host' => 'Host',
      'username' => 'Username',
      'password' => 'Password',
      'port' => 'Port',
      'monitoredFolders' => 'Monitored Folders',
      'security' => 'Security',
      'fetchSince' => 'Fetch Since',
      'emailAddress' => 'Email Address',
      'sentFolder' => 'Sent Folder',
      'storeSentEmails' => 'Store Sent Emails',
      'keepFetchedEmailsUnread' => 'Keep Fetched Emails Unread',
      'emailFolder' => 'Put in Folder',
      'connectedAt' => 'Connected At',
      'useImap' => 'Fetch Emails',
      'useSmtp' => 'Use SMTP',
      'smtpHost' => 'SMTP Host',
      'smtpPort' => 'SMTP Port',
      'smtpAuth' => 'SMTP Auth',
      'smtpSecurity' => 'SMTP Security',
      'smtpAuthMechanism' => 'SMTP Auth Mechanism',
      'smtpUsername' => 'SMTP Username',
      'smtpPassword' => 'SMTP Password'
    ],
    'links' => [
      'filters' => 'Filters',
      'emails' => 'Emails'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ],
      'smtpAuthMechanism' => [
        'plain' => 'PLAIN',
        'login' => 'LOGIN',
        'crammd5' => 'CRAM-MD5'
      ]
    ],
    'labels' => [
      'Create EmailAccount' => 'Create Email Account',
      'IMAP' => 'IMAP',
      'Main' => 'Main',
      'Test Connection' => 'Test Connection',
      'Send Test Email' => 'Send Test Email',
      'SMTP' => 'SMTP'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'messages' => [
      'couldNotConnectToImap' => 'Could not connect to IMAP server',
      'connectionIsOk' => 'Connection is Ok',
      'imapNotConnected' => 'Could not connect to [IMAP account](#EmailAccount/view/{id}).'
    ],
    'tooltips' => [
      'useSmtp' => 'The ability to send emails.',
      'emailAddress' => 'The user record (assigned user) should have the same email address to be able to use this email account for sending.',
      'monitoredFolders' => 'Multiple folders should be separated by comma.

You can add a \'Sent\' folder to sync emails sent from an external email client.',
      'storeSentEmails' => 'Sent emails will be stored on the IMAP server. Email Address field should match the address emails will be sent from.'
    ]
  ],
  'EmailAddress' => [
    'labels' => [
      'Primary' => 'Primary',
      'Opted Out' => 'Opted Out',
      'Invalid' => 'Invalid'
    ],
    'fields' => [
      'optOut' => 'Opted Out',
      'invalid' => 'Invalid'
    ],
    'presetFilters' => [
      'orphan' => 'Orphan'
    ]
  ],
  'EmailFilter' => [
    'fields' => [
      'from' => 'From',
      'to' => 'To',
      'subject' => 'Subject',
      'bodyContains' => 'Body Contains',
      'bodyContainsAll' => 'Body Contains All',
      'action' => 'Action',
      'isGlobal' => 'Is Global',
      'emailFolder' => 'Folder',
      'groupEmailFolder' => 'Group Email Folder',
      'markAsRead' => 'Mark as Read',
      'skipNotification' => 'Skip Notification'
    ],
    'links' => [
      'emailFolder' => 'Folder',
      'groupEmailFolder' => 'Group Email Folder'
    ],
    'labels' => [
      'Create EmailFilter' => 'Create Email Filter',
      'Emails' => 'Emails'
    ],
    'options' => [
      'action' => [
        'None' => 'None',
        'Skip' => 'Ignore',
        'Move to Folder' => 'Put in Folder',
        'Move to Group Folder' => 'Put in Group Folder'
      ]
    ],
    'tooltips' => [
      'name' => 'Give the filter a descriptive name.',
      'subject' => 'Use a wildcard *: 

 * `text*` – starts with text,
 * `*text*` – contains text,
 * `*text` – ends with text.',
      'bodyContains' => 'Body of the email contains any of the specified words or phrases.',
      'bodyContainsAll' => 'An email body contains all specified words or phrases.',
      'from' => 'Emails being sent from the specified address. Leave empty if not needed. You can use wildcard *.',
      'to' => 'Emails being sent to the specified address. Leave empty if not needed. You can use wildcard *.',
      'isGlobal' => 'Applies this filter to all emails incoming to system.'
    ]
  ],
  'EmailFolder' => [
    'fields' => [
      'skipNotifications' => 'Skip Notifications'
    ],
    'labels' => [
      'Create EmailFolder' => 'Create Folder',
      'Manage Folders' => 'Manage Folders',
      'Emails' => 'Emails'
    ]
  ],
  'EmailTemplate' => [
    'fields' => [
      'name' => 'Name',
      'status' => 'Status',
      'isHtml' => 'HTML',
      'body' => 'Body',
      'subject' => 'Subject',
      'attachments' => 'Attachments',
      'oneOff' => 'One-off',
      'category' => 'Category',
      'insertField' => 'Placeholders'
    ],
    'links' => [],
    'labels' => [
      'Create EmailTemplate' => 'Create Email Template',
      'Info' => 'Info',
      'Available placeholders' => 'Available placeholders'
    ],
    'messages' => [
      'infoText' => 'Available placeholders:

{optOutUrl} &#8211; URL for an unsubscribe link;

{optOutLink} &#8211; an unsubscribe link.'
    ],
    'tooltips' => [
      'oneOff' => 'Check if you are going to use this template only once. E.g. for Mass Email.'
    ],
    'presetFilters' => [
      'actual' => 'Actual'
    ],
    'placeholderTexts' => [
      'today' => 'Today\'s date',
      'now' => 'Current date & time',
      'currentYear' => 'Current Year',
      'optOutUrl' => 'URL for an unsubscribe link',
      'optOutLink' => 'an unsubscribe link'
    ]
  ],
  'EmailTemplateCategory' => [
    'labels' => [
      'Create EmailTemplateCategory' => 'Create Category',
      'Manage Categories' => 'Manage Categories',
      'EmailTemplates' => 'Email Templates'
    ],
    'fields' => [
      'order' => 'Order',
      'childList' => 'Child List'
    ],
    'links' => [
      'emailTemplates' => 'Email Templates'
    ]
  ],
  'EntityManager' => [
    'labels' => [
      'Fields' => 'Fields',
      'Relationships' => 'Relationships',
      'Layouts' => 'Layouts',
      'Schedule' => 'Schedule',
      'Log' => 'Log',
      'Formula' => 'Formula',
      'Parameters' => 'Parameters'
    ],
    'fields' => [
      'name' => 'Name',
      'type' => 'Type',
      'labelSingular' => 'Label Singular',
      'labelPlural' => 'Label Plural',
      'stream' => 'Stream',
      'label' => 'Label',
      'linkType' => 'Link Type',
      'entity' => 'Entity',
      'entityForeign' => 'Foreign Entity',
      'linkForeign' => 'Foreign Link',
      'link' => 'Link',
      'labelForeign' => 'Foreign Label',
      'sortBy' => 'Default Order (field)',
      'sortDirection' => 'Default Order (direction)',
      'relationName' => 'Middle Table Name',
      'linkMultipleField' => 'Link Multiple Field',
      'linkMultipleFieldForeign' => 'Foreign Link Multiple Field',
      'disabled' => 'Disabled',
      'textFilterFields' => 'Text Filter Fields',
      'audited' => 'Audited',
      'auditedForeign' => 'Foreign Audited',
      'statusField' => 'Status Field',
      'beforeSaveCustomScript' => 'Before Save Custom Script',
      'beforeSaveApiScript' => 'API Before Save Script',
      'color' => 'Color',
      'kanbanViewMode' => 'Kanban View',
      'kanbanStatusIgnoreList' => 'Ignored groups in Kanban view',
      'iconClass' => 'Icon',
      'countDisabled' => 'Disable record count',
      'fullTextSearch' => 'Full-Text Search',
      'parentEntityTypeList' => 'Parent Entity Types',
      'foreignLinkEntityTypeList' => 'Foreign Links',
      'optimisticConcurrencyControl' => 'Optimistic concurrency control',
      'preserveAuditLog' => 'Preserve Audit Log',
      'updateDuplicateCheck' => 'Duplicate check on update',
      'duplicateCheckFieldList' => 'Duplicate check fields',
      'stars' => 'Stars',
      'layout' => 'Layout',
      'selectFilter' => 'Select Filter',
      'author' => 'Author',
      'module' => 'Module',
      'version' => 'Version',
      'primaryFilters' => 'Primary Filters',
      'assignedUsers' => 'Multiple Assigned Users',
      'collaborators' => 'Collaborators',
      'aclContactLink' => 'ACL Contact Link',
      'aclAccountLink' => 'ACL Account Link',
      'activityStatusList' => 'Activity Statuses',
      'historyStatusList' => 'History Statuses',
      'completedStatusList' => 'Completed Statuses',
      'canceledStatusList' => 'Canceled Statuses',
      'variantSyncFieldList' => 'Variant sync fields',
      'doneStatusList' => 'Done Statuses',
      'softReserveStatusList' => 'Soft Reserve Statuses',
      'reserveStatusList' => 'Reserve Statuses',
      'failedStatusList' => 'Failed Statuses',
      'deliveryRequiredStatusList' => 'Delivery Required Statuses',
      'lockableFieldList' => 'Lock Fields'
    ],
    'options' => [
      'type' => [
        '' => 'None',
        'Base' => 'Base',
        'Person' => 'Person',
        'CategoryTree' => 'Category Tree',
        'Event' => 'Event',
        'BasePlus' => 'Base Plus',
        'Company' => 'Company'
      ],
      'linkType' => [
        'manyToMany' => 'Many-to-Many',
        'oneToMany' => 'One-to-Many',
        'manyToOne' => 'Many-to-One',
        'oneToOneRight' => 'One-to-One Right',
        'oneToOneLeft' => 'One-to-One Left',
        'parentToChildren' => 'Parent-to-Children',
        'childrenToParent' => 'Children-to-Parent'
      ],
      'sortDirection' => [
        'asc' => 'Ascending',
        'desc' => 'Descending'
      ],
      'module' => [
        'Custom' => 'Custom'
      ]
    ],
    'messages' => [
      'urlHashCopiedToClipboard' => 'A URL fragment for the *{name}* filter is copied to the clipboard. You can add it to the navbar.',
      'confirmRemoveLink' => 'Are you sure you want to remove the *{link}* relationship?',
      'nameIsAlreadyUsed' => 'Name \'{name}\' is already used.',
      'nameIsNotAllowed' => 'Name \'{name}\' is not allowed.',
      'nameIsTooLong' => 'Name is too long.',
      'confirmRemove' => 'Are you sure you want to remove the entity type from the system?',
      'entityCreated' => 'Entity has been created',
      'linkAlreadyExists' => 'Link name conflict.',
      'linkConflict' => 'Name conflict: link or field with the same name already exists.',
      'beforeSaveCustomScript' => 'A script called every time before an entity is saved. Use for setting calculated fields.',
      'beforeSaveApiScript' => 'A script called on create and update API requests before an entity is saved. Use for custom validation and duplicate checking.'
    ],
    'tooltips' => [
      'aclContactLink' => 'The link with Contact to use when applying access control for portal users.',
      'aclAccountLink' => 'The link with Account to use when applying access control for portal users.',
      'collaborators' => 'The ability to share records with specific users.',
      'assignedUsers' => 'The ability to assign multiple users to a record.

Note that after enabling the parameter, existing assigned users won\'t be transferred to the new *Assigned Users* field.',
      'duplicateCheckFieldList' => 'Which fields to check when performing checking for duplicates.',
      'updateDuplicateCheck' => 'Perform checking for duplicates when updating a record.',
      'optimisticConcurrencyControl' => 'Prevents writing conflicts.',
      'preserveAuditLog' => 'Disables cleanup of the audit log. This parameter is applicable only if Stream is disabled. As if Stream is enabled, audit log records are not being deleted.',
      'stars' => 'The ability to star records. Stars can be used by users to bookmark records.',
      'statusField' => 'Updates of this field are logged in stream.',
      'textFilterFields' => 'Fields used by text search.',
      'stream' => 'Whether the entity has the Stream.',
      'disabled' => 'Check if you don\'t need this entity in your system.',
      'linkAudited' => 'Creating related record and linking with existing record will be logged in Stream.',
      'linkMultipleField' => 'Link Multiple field provides a handy way to edit relations. Don\'t use it if you can have a large number of related records.',
      'linkSelectFilter' => 'A primary filter to apply by default when selecting a record.',
      'entityType' => 'Base Plus - has Activities, History and Tasks panels.

Event - available in Calendar and Activities panel.',
      'countDisabled' => 'Total number won\'t be displayed on the list view. Can decrease loading time when the DB table is big.',
      'fullTextSearch' => 'Running rebuild is required.',
      'linkParamReadOnly' => 'A read-only link cannot be edited via the *link* and *unlink* API requests. It won\'t be possible to relate and unrelate records via the relationship panel. It still possible to edit read-only links via link and link-multiple fields.',
      'activityStatusList' => 'Status values determining that an activity record should be displayed in the Activity panel and considered as actual.',
      'historyStatusList' => 'Status values determining that an activity record should be displayed in the History panel.',
      'completedStatusList' => 'Status values determining that an activity is completed.',
      'canceledStatusList' => 'Status values determining that an activity is canceled and won\'t be taken into account in free/busy ranges.',
      'lockableFieldList' => 'Fields that become read-only when an order is locked.',
      'productVariantSyncFieldList' => 'Fields that are synced from a template to product variants.',
      'salesOrderSoftReserveStatusList' => 'Statuses on which inventory is soft reserved.',
      'salesOrderDoneStatusList' => 'Statuses indicating that a sales order is done.',
      'purchaseOrderDoneStatusList' => 'Statuses indicating that a purchase order is done.',
      'purchaseOrderCanceledStatusList' => 'Statuses indicating that an order is canceled.',
      'receiptOrderDoneStatusList' => 'Statuses indicating that a receipt order is done.',
      'receiptOrderCanceledStatusList' => 'Statuses indicating that a receipt order is canceled.',
      'salesOrderCanceledStatusList' => 'Statuses indicating that an order is canceled.',
      'invoiceDoneStatusList' => 'Statuses indicating that an invoice is done.',
      'invoiceCanceledStatusList' => 'Statuses indicating that an invoice is canceled.',
      'quoteDoneStatusList' => 'Statuses indicating that a quote is done.',
      'quoteCanceledStatusList' => 'Statuses indicating that a quote is canceled.',
      'deliveryRequiredStatusList' => 'Statuses on which a delivery order should be created.',
      'deliveryOrderCanceledStatusList' => 'Statuses indicating that a delivery order is canceled. Inventory is automatically returned to stock.',
      'deliveryOrderReserveStatusList' => 'Statuses on which inventory is reserved.',
      'deliveryOrderSoftReserveStatusList' => 'Statuses on which inventory is soft reserved.',
      'deliveryOrderFailedStatusList' => 'Statuses indicating that a delivery order could not be delivered. Inventory is not automatically returned to stock. Manual intervention might be required.',
      'deliveryOrderDoneStatusList' => 'Statuses indicating that a delivery order is done.',
      'transferOrderCanceledStatusList' => 'Statuses indicating that a transfer order is canceled. Inventory is automatically returned to stock.',
      'transferOrderReserveStatusList' => 'Statuses on which inventory is reserved.',
      'transferOrderSoftReserveStatusList' => 'Statuses on which inventory is soft reserved.',
      'transferOrderFailedStatusList' => 'Statuses indicating that a transfer order could not be delivered. Inventory is not automatically returned to stock. Manual intervention might be required.',
      'transferOrderDoneStatusList' => 'Statuses indicating that a transfer order is done.',
      'returnOrderDoneStatusList' => 'Statuses indicating that a return order is done.',
      'returnOrderCanceledStatusList' => 'Statuses indicating that a return order is canceled.'
    ]
  ],
  'Export' => [
    'fields' => [
      'exportAllFields' => 'Export all fields',
      'fieldList' => 'Field List',
      'format' => 'Format',
      'status' => 'Status',
      'xlsxLite' => 'Lite',
      'xlsxRecordLinks' => 'Record Links',
      'xlsxTitle' => 'Title'
    ],
    'options' => [
      'format' => [
        'csv' => 'CSV',
        'xlsx' => 'XLSX (Excel)'
      ],
      'status' => [
        'Pending' => 'Pending',
        'Running' => 'Running',
        'Success' => 'Success',
        'Failed' => 'Failed'
      ]
    ],
    'tooltips' => [
      'xlsxLite' => 'Consumes much less memory. Recommended if a big number of records is exported.',
      'xlsxTitle' => 'Print a title and current date in the header.'
    ],
    'messages' => [
      'exportProcessed' => 'Export has been processed. Download the [file]({url}).',
      'infoText' => 'The export is being processed in idle by cron. It can take some time to finish. Closing this modal dialog won\'t affect the execution process.'
    ]
  ],
  'Extension' => [
    'fields' => [
      'name' => 'Name',
      'version' => 'Version',
      'description' => 'Description',
      'isInstalled' => 'Installed',
      'checkVersionUrl' => 'An URL for checking new versions'
    ],
    'labels' => [
      'Uninstall' => 'Uninstall',
      'Install' => 'Install'
    ],
    'messages' => [
      'uninstalled' => 'Extension {name} has been uninstalled',
      'fileExceedsMaxUploadSize' => 'The file size exceeds the max upload size {maxSize}. Consider increasing `post_max_size` or install the extension via CLI.'
    ]
  ],
  'ExternalAccount' => [
    'labels' => [
      'Connect' => 'Connect',
      'Disconnect' => 'Disconnect',
      'Disconnected' => 'Disconnected',
      'Connected' => 'Connected'
    ],
    'help' => [],
    'messages' => [
      'externalAccountNoConnectDisabled' => 'External account for integration \'{integration}\' has been disabled due not being able to connect.'
    ]
  ],
  'FieldManager' => [
    'labels' => [
      'Dynamic Logic' => 'Dynamic Logic',
      'Name' => 'Name',
      'Label' => 'Label',
      'Type' => 'Type'
    ],
    'options' => [
      'dateTimeDefault' => [
        '' => 'None',
        'javascript: return this.dateTime.getNow(1);' => 'Now',
        'javascript: return this.dateTime.getNow(5);' => 'Now (5m)',
        'javascript: return this.dateTime.getNow(15);' => 'Now (15m)',
        'javascript: return this.dateTime.getNow(30);' => 'Now (30m)',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(1, \'hours\', 15);' => '+1 hour',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(2, \'hours\', 15);' => '+2 hours',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(3, \'hours\', 15);' => '+3 hours',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(4, \'hours\', 15);' => '+4 hours',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(5, \'hours\', 15);' => '+5 hours',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(6, \'hours\', 15);' => '+6 hours',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(7, \'hours\', 15);' => '+7 hours',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(8, \'hours\', 15);' => '+8 hours',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(9, \'hours\', 15);' => '+9 hours',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(10, \'hours\', 15);' => '+10 hours',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(11, \'hours\', 15);' => '+11 hours',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(12, \'hours\', 15);' => '+12 hours',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(1, \'days\', 15);' => '+1 day',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(2, \'days\', 15);' => '+2 days',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(3, \'days\', 15);' => '+3 days',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(4, \'days\', 15);' => '+4 days',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(5, \'days\', 15);' => '+5 days',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(6, \'days\', 15);' => '+6 days',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(1, \'week\', 15);' => '+1 week'
      ],
      'dateDefault' => [
        '' => 'None',
        'javascript: return this.dateTime.getToday();' => 'Today',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'days\');' => '+1 day',
        'javascript: return this.dateTime.getDateShiftedFromToday(2, \'days\');' => '+2 days',
        'javascript: return this.dateTime.getDateShiftedFromToday(3, \'days\');' => '+3 days',
        'javascript: return this.dateTime.getDateShiftedFromToday(4, \'days\');' => '+4 days',
        'javascript: return this.dateTime.getDateShiftedFromToday(5, \'days\');' => '+5 days',
        'javascript: return this.dateTime.getDateShiftedFromToday(6, \'days\');' => '+6 days',
        'javascript: return this.dateTime.getDateShiftedFromToday(7, \'days\');' => '+7 days',
        'javascript: return this.dateTime.getDateShiftedFromToday(8, \'days\');' => '+8 days',
        'javascript: return this.dateTime.getDateShiftedFromToday(9, \'days\');' => '+9 days',
        'javascript: return this.dateTime.getDateShiftedFromToday(10, \'days\');' => '+10 days',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'weeks\');' => '+1 week',
        'javascript: return this.dateTime.getDateShiftedFromToday(2, \'weeks\');' => '+2 weeks',
        'javascript: return this.dateTime.getDateShiftedFromToday(3, \'weeks\');' => '+3 weeks',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'months\');' => '+1 month',
        'javascript: return this.dateTime.getDateShiftedFromToday(2, \'months\');' => '+2 months',
        'javascript: return this.dateTime.getDateShiftedFromToday(3, \'months\');' => '+3 months',
        'javascript: return this.dateTime.getDateShiftedFromToday(4, \'months\');' => '+4 months',
        'javascript: return this.dateTime.getDateShiftedFromToday(5, \'months\');' => '+5 months',
        'javascript: return this.dateTime.getDateShiftedFromToday(6, \'months\');' => '+6 months',
        'javascript: return this.dateTime.getDateShiftedFromToday(7, \'months\');' => '+7 months',
        'javascript: return this.dateTime.getDateShiftedFromToday(8, \'months\');' => '+8 months',
        'javascript: return this.dateTime.getDateShiftedFromToday(9, \'months\');' => '+9 months',
        'javascript: return this.dateTime.getDateShiftedFromToday(10, \'months\');' => '+10 months',
        'javascript: return this.dateTime.getDateShiftedFromToday(11, \'months\');' => '+11 months',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'year\');' => '+1 year'
      ],
      'barcodeType' => [
        'EAN13' => 'EAN-13',
        'EAN8' => 'EAN-8',
        'EAN5' => 'EAN-5',
        'EAN2' => 'EAN-2',
        'UPC' => 'UPC (A)',
        'UPCE' => 'UPC (E)',
        'pharmacode' => 'Pharmacode',
        'QRcode' => 'QR code'
      ],
      'globalRestrictions' => [
        'forbidden' => 'Forbidden',
        'internal' => 'Internal',
        'onlyAdmin' => 'Admin-only',
        'readOnly' => 'Read-only',
        'nonAdminReadOnly' => 'Non-admin read-only'
      ]
    ],
    'tooltips' => [
      'optionsReference' => 'Re-use options from another field.',
      'currencyDecimal' => 'Use the Decimal DB type. In the app, values will be represented as strings. Check this parameter if precision is required.',
      'cutHeight' => 'A text higher then a specified value will be cut with a \'show more\' button displayed.',
      'urlStrip' => 'Strip a protocol and a trailing slash.',
      'audited' => 'Updates will be logged in stream.',
      'required' => 'Field will be mandatory. Can\'t be left empty.',
      'default' => 'Value will be set by default upon creating.',
      'min' => 'Min acceptable value.',
      'max' => 'Max acceptable value.',
      'seeMoreDisabled' => 'If not checked then long texts will be shortened.',
      'lengthOfCut' => 'How long text can be before it will be cut.',
      'maxLength' => 'Max acceptable length of text.',
      'before' => 'The date value should be before the date value of the specified field.',
      'after' => 'The date value should be after the date value of the specified field.',
      'readOnly' => 'Field value can\'t be specified by user. But can be calculated by formula.',
      'readOnlyAfterCreate' => 'The field value can be specified when creating a new record. After that, the field becomes read-only. It can still be calculated by formula.',
      'preview' => 'Show the preview button. Applicable if Markdown is enabled.',
      'fileAccept' => 'Which file types to accept. It\'s possible to add custom items.',
      'barcodeLastChar' => 'For EAN-13 type.',
      'maxFileSize' => 'If empty or 0 then no limit.',
      'conversionDisabled' => 'The currency conversion action won\'t be applied to this field.',
      'pattern' => 'A regular expression to check a field value against. Define an expression or select a predefined one.',
      'options' => 'A list of possible values and their labels.',
      'optionsArray' => 'A list of possible values and their labels. If empty, the field will allow entering custom values.',
      'maxCount' => 'Maximum number of items allowed to be selected.',
      'displayAsList' => 'Each item in a new line.',
      'optionsVarchar' => 'A list of autocomplete values.',
      'linkReadOnly' => 'Field value can\'t be specified by user. But can be calculated by formula.

It will also disable the ability to create a related record from relationship panels.',
      'relateOnImport' => 'When importing with this field, it will automatically relate a record with a matching foreign record. Use this functionality only if the foreign field is considered as unique.'
    ],
    'fieldParts' => [
      'address' => [
        'street' => 'Street',
        'city' => 'City',
        'state' => 'State',
        'country' => 'Country',
        'postalCode' => 'Postal Code',
        'map' => 'Map'
      ],
      'personName' => [
        'salutation' => 'Salutation',
        'first' => 'First',
        'middle' => 'Middle',
        'last' => 'Last'
      ],
      'currency' => [
        'converted' => '(Converted)',
        'currency' => '(Currency)'
      ],
      'datetimeOptional' => [
        'date' => 'Date'
      ]
    ],
    'fieldInfo' => [
      'varchar' => 'A single-line text.',
      'enum' => 'Selectbox, only one value can be selected.',
      'text' => 'A multiline text with markdown support.',
      'date' => 'Date w/o time.',
      'datetime' => 'Date and time',
      'currency' => 'A currency value. A float number with a currency code.',
      'int' => 'A whole number.',
      'float' => 'A number with a decimal part.',
      'bool' => 'A checkbox. Two possible values: true and false.',
      'multiEnum' => 'A list of values, multiple values can be selected. The list is ordered.',
      'checklist' => 'A list of checkboxes.',
      'array' => 'A list of values, similar to Multi-Enum field.',
      'address' => 'An address with street, city, state, postal code and country.',
      'url' => 'For storing links.',
      'urlMultiple' => 'Multiple links.',
      'wysiwyg' => 'A text with HTML support.',
      'file' => 'For file uploading.',
      'image' => 'For image uploading.',
      'attachmentMultiple' => 'Allows to upload multiple files.',
      'number' => 'An auto-incrementing number of string type with a possible prefix and specific length.',
      'autoincrement' => 'A generated read-only auto-incrementing integer number.',
      'barcode' => 'A barcode. Can be printed to PDF.',
      'email' => 'A set of email addresses with their parameters: Opted-out, Invalid, Primary.',
      'phone' => 'A set of phone numbers with their parameters: Type, Opted-out, Invalid, Primary.',
      'foreign' => 'A field of a related record. Read-only.',
      'link' => 'A record related through Belongs-To (many-to-one or one-to-one) relationship.',
      'linkParent' => 'A record related through Belongs-To-Parent relationship. Can be of different entity types.',
      'linkMultiple' => 'A set of records related through Has-Many (many-to-many or one-to-many) relationship. Not all relationships have their link-multiple fields. Only those do, where Link-Multiple parameter(s) is enabled.'
    ],
    'messages' => [
      'fieldCreatedAddToLayouts' => 'Field has been created. Now, you can add it to [layouts]({link})',
      'confirmRemove' => 'Are you sure you want to remove the *{field}* field?

Field removal does not remove data from the database. Data from the database will be removed if you run hard rebuild.',
      'fieldNameIsNotAllowed' => 'Field name \'{field}\' is not allowed.',
      'fieldAlreadyExists' => 'Field \'{field}\' already exists in \'{entityType}\'.',
      'linkWithSameNameAlreadyExists' => 'Link with the name \'{field}\' already exists in \'{entityType}\'.',
      'namingFieldLinkConflict' => 'Name \'{field}\' conflicts with link.'
    ]
  ],
  'Formula' => [
    'labels' => [
      'Check Syntax' => 'Check Syntax',
      'Run' => 'Run'
    ],
    'fields' => [
      'target' => 'Target',
      'targetType' => 'Target Type',
      'script' => 'Script',
      'output' => 'Output',
      'error' => 'Error'
    ],
    'messages' => [
      'runSuccess' => 'Executed successfully.',
      'runError' => 'Error.',
      'checkSyntaxSuccess' => 'Syntax is correct.',
      'checkSyntaxError' => 'Syntax error.',
      'emptyScript' => 'Script is empty.'
    ],
    'tooltips' => [
      'output' => 'Print values with the function `output\\printLine`.'
    ]
  ],
  'Global' => [
    'scopeNames' => [
      'Note' => 'Note',
      'Email' => 'Email',
      'User' => 'User',
      'Team' => 'Team',
      'Role' => 'Role',
      'EmailTemplate' => 'Email Template',
      'EmailTemplateCategory' => 'Email Template Categories',
      'EmailAccount' => 'Personal Email Account',
      'EmailAccountScope' => 'Personal Email Account',
      'OutboundEmail' => 'Outbound Email',
      'ScheduledJob' => 'Scheduled Job',
      'ExternalAccount' => 'External Account',
      'Extension' => 'Extension',
      'Dashboard' => 'Dashboard',
      'InboundEmail' => 'Group Email Account',
      'Stream' => 'Stream',
      'Import' => 'Import',
      'ImportError' => 'Import Error',
      'Template' => 'Template',
      'Job' => 'Job',
      'EmailFilter' => 'Email Filter',
      'Portal' => 'Portal',
      'PortalRole' => 'Portal Role',
      'Attachment' => 'Attachment',
      'EmailFolder' => 'Email Folder',
      'GroupEmailFolder' => 'Group Email Folder',
      'PortalUser' => 'Portal User',
      'ApiUser' => 'API User',
      'ScheduledJobLogRecord' => 'Scheduled Job Log Record',
      'PasswordChangeRequest' => 'Password Change Request',
      'ActionHistoryRecord' => 'Action History Record',
      'AuthToken' => 'Auth Token',
      'UniqueId' => 'Unique ID',
      'LastViewed' => 'Last Viewed',
      'Settings' => 'Settings',
      'FieldManager' => 'Field Manager',
      'Integration' => 'Integration',
      'LayoutManager' => 'Layout Manager',
      'EntityManager' => 'Entity Manager',
      'Export' => 'Export',
      'DynamicLogic' => 'Dynamic Logic',
      'DashletOptions' => 'Dashlet Options',
      'Admin' => 'Admin',
      'Global' => 'Global',
      'Preferences' => 'Preferences',
      'EmailAddress' => 'Email Address',
      'PhoneNumber' => 'Phone Number',
      'AppLogRecord' => 'App Log Record',
      'AuthLogRecord' => 'Auth Log Record',
      'AuthFailLogRecord' => 'Auth Fail Log Record',
      'LeadCapture' => 'Lead Capture Entry Point',
      'LeadCaptureLogRecord' => 'Lead Capture Log Record',
      'ArrayValue' => 'Array Value',
      'DashboardTemplate' => 'Dashboard Template',
      'Currency' => 'Currency',
      'LayoutSet' => 'Layout Set',
      'Webhook' => 'Webhook',
      'WebhookQueueItem' => 'Webhook Queue Item',
      'Mass Action' => 'Mass Action',
      'WorkingTimeCalendar' => 'Working Time Calendar',
      'WorkingTimeRange' => 'Working Time Exception',
      'AuthenticationProvider' => 'Authentication Provider',
      'GlobalStream' => 'Global Stream',
      'AddressCountry' => 'Address Country',
      'AppSecret' => 'App Secret',
      'Account' => 'Account',
      'Contact' => 'Contact',
      'Lead' => 'Lead',
      'Target' => 'Target',
      'Opportunity' => 'Opportunity',
      'Meeting' => 'Meeting',
      'Calendar' => 'Calendar',
      'Call' => 'Call',
      'Task' => 'Task',
      'Case' => 'Case',
      'Document' => 'Document',
      'DocumentFolder' => 'Document Folder',
      'Campaign' => 'Campaign',
      'TargetList' => 'Target List',
      'MassEmail' => 'Mass Email',
      'EmailQueueItem' => 'Email Queue Item',
      'CampaignTrackingUrl' => 'Tracking URL',
      'Activities' => 'Activities',
      'KnowledgeBaseArticle' => 'Knowledge Base Article',
      'KnowledgeBaseCategory' => 'Knowledge Base Category',
      'CampaignLogRecord' => 'Campaign Log Record',
      'Workflow' => 'Workflow',
      'Report' => 'Report',
      'ReportCategory' => 'Report Category',
      'WorkflowLogRecord' => 'Workflow Log Record',
      'WorkflowCategory' => 'Workflow Category',
      'BpmnFlowchart' => 'Process Flowchart',
      'BpmnProcess' => 'Process',
      'BpmnUserTask' => 'Process User Task',
      'ReportFilter' => 'Report Filter',
      'ReportPanel' => 'Report Panel',
      'Product' => 'Product',
      'ProductCategory' => 'Product Category',
      'ProductBrand' => 'Product Brand',
      'ProductAttribute' => 'Product Attribute',
      'ProductAttributeOption' => 'Product Attribute Option',
      'Quote' => 'Quote',
      'QuoteItem' => 'Quote Item',
      'SalesOrder' => 'Sales Order - List',
      'SalesOrderItem' => 'Sales Order Item',
      'Invoice' => 'Invoice',
      'InvoiceItem' => 'Invoice Item',
      'DeliveryOrder' => 'Delivery Order',
      'DeliveryOrderItem' => 'Delivery Order Item',
      'ReceiptOrder' => 'Receipt Order',
      'ReceiptOrderItem' => 'Receipt Order Item',
      'TransferOrder' => 'Transfer Order',
      'TransferOrderItem' => 'Transfer Order Item',
      'Tax' => 'Tax',
      'ShippingProvider' => 'Shipping Provider',
      'OpportunityItem' => 'Opportunity Item',
      'PurchaseOrder' => 'Purchase Order',
      'PurchaseOrderItem' => 'Purchase Order Item',
      'ReturnOrder' => 'Return Order',
      'ReturnOrderItem' => 'Return Order Item',
      'Supplier' => 'Supplier',
      'ProductPrice' => 'Product Price',
      'SupplierProductPrice' => 'Supplier Product Price',
      'PriceBook' => 'PriceBook',
      'PriceRule' => 'Price Rule',
      'PriceRuleCondition' => 'Price Rule Condition',
      'Warehouse' => 'Warehouse',
      'InventoryTransaction' => 'Inventory Transaction',
      'InventoryNumber' => 'Inventory Number',
      'InventoryAdjustment' => 'Inventory Adjustment',
      'InventoryAdjustmentItem' => 'Inventory Adjustment Item',
      'DashboardSet' => 'Dashboard Set',
      'Service' => 'Service',
      'ServiceItem' => 'Service Item',
      'Analytics' => 'Analytics',
      'LeadsPartnerCenter' => 'Leads Partner Center',
      'PartnerID' => 'Partner ID',
      'Surestep' => 'Partner Program - List',
      'Portfolio' => 'Calculator',
      'AssesmentCompany' => 'AssesmentCompany',
      'NurturingForm' => 'Nurturing Form',
      'CloudConsumption' => 'Cloud Consumption',
      'CPB' => 'Cloud Practice Builder - List',
      'GooglePartnerAdvantage' => 'Google Partner Advantage',
      'Program' => 'Programa',
      'AWS' => 'Partner Program - List',
      'DsetAws' => 'DSET AWS',
      'DataAnalyticsReport' => 'Data Analytics Report',
      'PartnersGoogleCloud' => 'Partner Program - List',
      'ExternalFormPost' => 'ExternalFormPost',
      'Distributor' => 'Distributor',
      'VendorContract' => 'VendorContract',
      'Earn' => 'Earn',
      'Contract' => 'Contrato',
      'Orders' => 'Orders',
      'Notifications' => 'Notification',
      'DSET' => 'DSET',
      'VendorCloudConsumption' => 'Cloud Consumption Revenue',
      'DashboardSet5' => 'Canales - General',
      'DashboardSet6' => 'Rocket - Dashboard',
      'DashboardSet7' => 'Rocket - Dashboard',
      'DashboardSet9' => 'Canales  - General',
      'DashboardSet13' => 'Oportunidades - Dash',
      'DashboardSet14' => 'Canales - Google',
      'DashboardSet15' => 'Oportunidades - General',
      'DashboardSet16' => 'Canales - AWS',
      'PBGeral' => 'Practice Builder High Growth - List',
      'DashboardSet28' => 'Oportunidades - Dash',
      'DashboardSet33' => 'Oportunidades - General',
      'DashboardSet34' => 'Canales - General',
      'DashboardSet35' => 'Canales - Microsoft',
      'DashboardSet36' => 'Rocket - Argentina - Dashboard',
      'DashboardSet37' => 'Rocket - Brasil - Dashboard',
      'DashboardSet38' => 'Rocket - CCA - Dashboard',
      'DashboardSet39' => 'Rocket - Chile - Dashboard.',
      'DashboardSet40' => 'Rocket - Colombia - Dashboard',
      'DashboardSet41' => 'Rocket - Ecuador - Dashboard',
      'DashboardSet42' => 'Rocket - Mexico - Dashboard',
      'DashboardSet43' => 'Rocket - Peru - Dashboard',
      'DashboardSet44' => 'High Growth',
      'AWSVersions' => 'AWS Versions',
      'Marketing' => 'Marketing',
      'VendorSubscription' => 'VendorSubscription',
      'Importer' => 'Importador',
      'DashboardSet47' => 'Oportunidades - Dash',
      'DashboardSet48' => 'Oportunidades - General',
      'DashboardSet50' => 'Rocket - Uruguay - Dashboard',
      'DashboardSet53' => 'Entrenamientos - Dash',
      'VendorAccount' => 'VendorAccount',
      'Country' => 'Country',
      'DashboardAccess' => 'Dashboard Access',
      'DashboardSet56' => 'Facturación Canales',
      'DashboardSet57' => 'DSET AWS',
      'TourContent' => 'TourContent',
      'EmailContent' => 'Email Content',
      'DashboardSet58' => 'Cloud',
      'ContractGoals' => 'Meta',
      'AccountVMB' => 'Account VMB',
      'AccountVBM' => 'Account VBM',
      'TechnicalSupport' => 'TechnicalSupport',
      'RocketMargins' => 'Margens Rocket',
      'DashboardSet62' => 'Destination AI',
      'Migrations' => 'Migration',
      'BucketTimer' => 'Duração do Bucket',
      'Messenger' => 'Messenger',
      'PatchNotes' => 'Patch Notes',
      'Sources' => 'Sources',
      'OpportunityAWS' => 'Opportunity AWS',
      'OpportunityGoogle' => 'Opportunity Google',
      'DashboardSet70' => 'Google',
      'Renewals' => 'Renewal',
      'CAccountEndCustomer' => 'Account End Customer',
      'DashboardSet79' => 'Oportunidades - Dashboard v2025',
      'DashboardSet80' => 'Cybersecurity'
    ],
    'scopeNamesPlural' => [
      'Note' => 'Notes',
      'Email' => 'Emails',
      'User' => 'Users',
      'Team' => 'Teams',
      'Role' => 'Roles',
      'EmailTemplate' => 'Email Templates',
      'EmailTemplateCategory' => 'Email Template Categories',
      'EmailAccount' => 'Personal Email Accounts',
      'EmailAccountScope' => 'Personal Email Accounts',
      'OutboundEmail' => 'Outbound Emails',
      'ScheduledJob' => 'Scheduled Jobs',
      'ExternalAccount' => 'External Accounts',
      'Extension' => 'Extensions',
      'Dashboard' => 'Dashboard',
      'InboundEmail' => 'Group Email Accounts',
      'EmailAddress' => 'Email Addresses',
      'PhoneNumber' => 'Phone Numbers',
      'Stream' => 'Stream',
      'Import' => 'Import',
      'ImportError' => 'Import Errors',
      'Template' => 'Templates',
      'Job' => 'Jobs',
      'EmailFilter' => 'Email Filters',
      'Portal' => 'Portals',
      'PortalRole' => 'Portal Roles',
      'Attachment' => 'Attachments',
      'EmailFolder' => 'Email Folders',
      'GroupEmailFolder' => 'Group Email Folders',
      'PortalUser' => 'Portal Users',
      'ApiUser' => 'API Users',
      'ScheduledJobLogRecord' => 'Scheduled Job Log Records',
      'PasswordChangeRequest' => 'Password Change Requests',
      'ActionHistoryRecord' => 'Action History',
      'AuthToken' => 'Auth Tokens',
      'UniqueId' => 'Unique IDs',
      'LastViewed' => 'Last Viewed',
      'AppLogRecord' => 'App Log',
      'AuthLogRecord' => 'Auth Log',
      'AuthFailLogRecord' => 'Auth Fail Log',
      'LeadCapture' => 'Lead Capture',
      'LeadCaptureLogRecord' => 'Lead Capture Log',
      'ArrayValue' => 'Array Values',
      'DashboardTemplate' => 'Dashboard Templates',
      'Currency' => 'Currency',
      'LayoutSet' => 'Layout Sets',
      'Webhook' => 'Webhooks',
      'WebhookQueueItem' => 'Webhook Queue Items',
      'WorkingTimeCalendar' => 'Working Time Calendars',
      'WorkingTimeRange' => 'Working Time Exceptions',
      'AuthenticationProvider' => 'Authentication Providers',
      'GlobalStream' => 'Global Stream',
      'AddressCountry' => 'Address Countries',
      'AppSecret' => 'App Secrets',
      'Account' => 'Accounts',
      'Contact' => 'Contacts',
      'Lead' => 'Leads',
      'Target' => 'Targets',
      'Opportunity' => 'Opportunities',
      'Meeting' => 'Meetings',
      'Calendar' => 'Calendar',
      'Call' => 'Calls',
      'Task' => 'Tasks',
      'Case' => 'Cases',
      'Document' => 'Documents',
      'DocumentFolder' => 'Document Folders',
      'Campaign' => 'Campaigns',
      'TargetList' => 'Target Lists',
      'MassEmail' => 'Mass Emails',
      'EmailQueueItem' => 'Email Queue Items',
      'CampaignTrackingUrl' => 'Tracking URLs',
      'Activities' => 'Activities',
      'KnowledgeBaseArticle' => 'Knowledge Base',
      'KnowledgeBaseCategory' => 'Knowledge Base Categories',
      'CampaignLogRecord' => 'Campaign Log Records',
      'Workflow' => 'Workflows',
      'Report' => 'Reports',
      'ReportCategory' => 'Report Categories',
      'WorkflowLogRecord' => 'Workflows Log',
      'WorkflowCategory' => 'Workflow Categories',
      'BpmnFlowchart' => 'Process Flowcharts',
      'BpmnProcess' => 'Processes',
      'BpmnUserTask' => 'Process User Tasks',
      'ReportFilter' => 'Report Filters',
      'ReportPanel' => 'Report Panels',
      'Product' => 'Products',
      'ProductCategory' => 'Product Categories',
      'ProductBrand' => 'Product Brands',
      'ProductAttribute' => 'Product Attributes',
      'ProductAttributeOption' => 'Product Attribute Options',
      'OpportunityItem' => 'Opportunity Items',
      'Quote' => 'Quotes',
      'QuoteItem' => 'Quote Items',
      'SalesOrder' => 'Sales Orders',
      'SalesOrderItem' => 'Sales Order Items',
      'Invoice' => 'Invoices',
      'InvoiceItem' => 'Invoice Items',
      'PurchaseOrder' => 'Purchase Orders',
      'PurchaseOrderItem' => 'Purchase Order Items',
      'ReturnOrder' => 'Return Orders',
      'ReturnOrderItem' => 'Return Order Items',
      'DeliveryOrder' => 'Delivery Orders',
      'DeliveryOrderItem' => 'Delivery Order Items',
      'ReceiptOrder' => 'Receipt Orders',
      'ReceiptOrderItem' => 'Receipt Order Items',
      'TransferOrder' => 'Transfer Orders',
      'TransferOrderItem' => 'Transfer Order Items',
      'Tax' => 'Taxes',
      'ShippingProvider' => 'Shipping Providers',
      'Supplier' => 'Suppliers',
      'ProductPrice' => 'Product Prices',
      'SupplierProductPrice' => 'Supplier Product Prices',
      'PriceBook' => 'PriceBooks',
      'PriceRule' => 'Price Rules',
      'PriceRuleCondition' => 'Price Rule Conditions',
      'Warehouse' => 'Warehouses',
      'InventoryTransaction' => 'Inventory Transactions',
      'InventoryNumber' => 'Inventory Numbers',
      'InventoryAdjustment' => 'Inventory Adjustments',
      'InventoryAdjustmentItem' => 'Inventory Adjustment Items',
      'DashboardSet' => 'Dashboard Sets',
      'Service' => 'Services',
      'ServiceItem' => 'Service Items',
      'Analytics' => 'Analytics',
      'LeadsPartnerCenter' => 'Leads Partner Center',
      'PartnerID' => 'Partner ID',
      'Surestep' => 'List - Surestep',
      'Portfolio' => 'Calculator',
      'AssesmentCompany' => 'AssesmentCompanies',
      'NurturingForm' => 'Nurturing Forms',
      'CloudConsumption' => 'Cloud Consumptions',
      'CPB' => 'List - Cloud Practice Builder',
      'GooglePartnerAdvantage' => 'Google Partner Advantage',
      'Program' => 'Programas',
      'AWS' => 'List - Partner Program',
      'DsetAws' => 'DSET AWS',
      'DataAnalyticsReport' => 'Data Analytics Report',
      'PartnersGoogleCloud' => 'List - Partner Program',
      'ExternalFormPost' => 'ExternalFormPosts',
      'Distributor' => 'Distributors',
      'VendorContract' => 'VendorContracts',
      'Earn' => 'Earns',
      'Contract' => 'Contratos',
      'Orders' => 'Orderses',
      'Notifications' => 'Notifications',
      'DSET' => 'DSETs',
      'VendorCloudConsumption' => 'Cloud Consumptions Revenue',
      'DashboardSet5' => 'Canales - General',
      'DashboardSet6' => 'Rocket - Dashboard',
      'DashboardSet7' => 'Rocket - Dashboard',
      'DashboardSet9' => 'Canales  - General',
      'DashboardSet13' => 'Oportunidades - Dash',
      'DashboardSet14' => 'Canales - Google',
      'DashboardSet15' => 'Oportunidades - General',
      'DashboardSet16' => 'Canales - AWS',
      'PBGeral' => 'List - General Practice Builder',
      'DashboardSet28' => 'Oportunidades - Dash',
      'DashboardSet33' => 'Oportunidades - General',
      'DashboardSet34' => 'Canales - General',
      'DashboardSet35' => 'Canales - Microsoft',
      'DashboardSet36' => 'Rocket - Argentina - Dashboard',
      'DashboardSet37' => 'Rocket - Brasil - Dashboard',
      'DashboardSet38' => 'Rocket - CCA - Dashboard',
      'DashboardSet39' => 'Rocket - Chile - Dashboard.',
      'DashboardSet40' => 'Rocket - Colombia - Dashboard',
      'DashboardSet41' => 'Rocket - Ecuador - Dashboard',
      'DashboardSet42' => 'Rocket - Mexico - Dashboard',
      'DashboardSet43' => 'Rocket - Peru - Dashboard',
      'DashboardSet44' => 'High Growth',
      'AWSVersions' => 'AWS Versions',
      'Marketing' => 'Marketing',
      'VendorSubscription' => 'VendorSubscriptions',
      'Importer' => 'Importador',
      'DashboardSet47' => 'Oportunidades - Dash',
      'DashboardSet48' => 'Oportunidades - General',
      'DashboardSet50' => 'Rocket - Uruguay - Dashboard',
      'DashboardSet53' => 'Entrenamientos - Dash',
      'VendorAccount' => 'VendorAccounts',
      'Country' => 'Countries',
      'DashboardAccess' => 'Dashboard Access',
      'DashboardSet56' => 'Facturación Canales',
      'DashboardSet57' => 'DSET AWS',
      'TourContent' => 'TourContents',
      'EmailContent' => 'Email Content',
      'DashboardSet58' => 'Cloud',
      'ContractGoals' => 'Metas',
      'AccountVMB' => 'Account VMBs',
      'AccountVBM' => 'Account VBMs',
      'TechnicalSupport' => 'TechnicalSupports',
      'RocketMargins' => 'Margens Rocket',
      'DashboardSet62' => 'Destination AI',
      'Migrations' => 'Migrations',
      'BucketTimer' => 'Duração do Bucket',
      'Messenger' => 'Mensageria',
      'PatchNotes' => 'Patch Notes',
      'Sources' => 'Sources',
      'OpportunityAWS' => 'Opportunity AWS',
      'OpportunityGoogle' => 'Opportunity Google',
      'DashboardSet70' => 'Google',
      'Renewals' => 'Renewals',
      'CAccountEndCustomer' => 'Account End Customers',
      'DashboardSet79' => 'Oportunidades - Dashboard v2025',
      'DashboardSet80' => 'Cybersecurity'
    ],
    'labels' => [
      'Previous Page' => 'Previous Page',
      'Next Page' => 'Next Page',
      'First Page' => 'First Page',
      'Last Page' => 'Last Page',
      'Page' => 'Page',
      'Sort' => 'Sort',
      'Column Resize' => 'Column Resize',
      'Misc' => 'Misc',
      'General' => 'General',
      'Merge' => 'Merge',
      'None' => 'None',
      'Home' => 'Home',
      'by' => 'by',
      'Proceed' => 'Proceed',
      'Saved' => 'Saved',
      'Error' => 'Error',
      'Select' => 'Select',
      'Not valid' => 'Not valid',
      'Please wait...' => 'Please wait...',
      'Please wait' => 'Please wait',
      'Attached' => 'Attached',
      'Loading...' => 'Loading...',
      'Uploading...' => 'Uploading...',
      'Sending...' => 'Sending...',
      'Send' => 'Send',
      'Merged' => 'Merged',
      'Removed' => 'Removed',
      'Posted' => 'Posted',
      'Linked' => 'Linked',
      'Unlinked' => 'Unlinked',
      'Done' => 'Done',
      'Access denied' => 'Access denied',
      'Not found' => 'Not found',
      'Access' => 'Access',
      'Timeout' => 'Timeout',
      'No internet' => 'No internet',
      'Are you sure?' => 'Are you sure?',
      'Record has been removed' => 'Record has been removed',
      'Wrong username/password' => 'Wrong username/password',
      'Post cannot be empty' => 'Post cannot be empty',
      'Username can not be empty!' => 'Username can not be empty!',
      'Cache is not enabled' => 'Cache is not enabled',
      'Cache has been cleared' => 'Cache has been cleared',
      'Rebuild has been done' => 'Rebuild has been done',
      'Return to Application' => 'Return to Application',
      'Modified' => 'Modified',
      'Created' => 'Created',
      'Create' => 'Create',
      'create' => 'create',
      'Scheduled' => 'Scheduled',
      'Overview' => 'Overview',
      'Details' => 'Details',
      'Add Field' => 'Add Field',
      'Add Dashlet' => 'Add Dashlet',
      'Filter' => 'Filter',
      'Edit Dashboard' => 'Edit Dashboard',
      'Add' => 'Add',
      'Add Item' => 'Add Item',
      'Reset' => 'Reset',
      'Menu' => 'Menu',
      'More' => 'More',
      'Search' => 'Search',
      'Only My' => 'Only My',
      'Open' => 'Open',
      'Admin' => 'Admin',
      'About' => 'About',
      'Refresh' => 'Refresh',
      'Remove' => 'Remove',
      'Restore' => 'Restore',
      'Options' => 'Options',
      'Username' => 'Username (E-mail)',
      'Password' => 'Password',
      'Login' => 'Login',
      'Log Out' => 'Log Out',
      'Log in' => 'Log in',
      'Log in as' => 'Log in as',
      'Sign in' => 'Sign in',
      'Preferences' => 'Preferences',
      'State' => 'State',
      'Street' => 'Street',
      'Country' => 'Country',
      'City' => 'City',
      'PostalCode' => 'Postal Code',
      'Star' => 'Star',
      'Unstar' => 'Unstar',
      'Starred' => 'Starred',
      'Followed' => 'Followed',
      'Follow' => 'Follow',
      'Followers' => 'Followers',
      'Clear Local Cache' => 'Clear Local Cache',
      'Actions' => 'Actions',
      'Delete' => 'Delete',
      'Update' => 'Update',
      'Save' => 'Save',
      'Edit' => 'Edit',
      'View' => 'View',
      'Cancel' => 'Cancel',
      'Apply' => 'Apply',
      'Unlink' => 'Unlink',
      'Mass Update' => 'Mass Update',
      'Export' => 'Export',
      'No Data' => 'No Data',
      'No Access' => 'No Access',
      'All' => 'All',
      'Active' => 'Active',
      'Inactive' => 'Inactive',
      'Write your comment here' => 'Write your comment here',
      'Post' => 'Post',
      'Stream' => 'Stream',
      'Show more' => 'Show more',
      'Dashlet Options' => 'Dashlet Options',
      'Full Form' => 'Full Form',
      'Insert' => 'Insert',
      'Person' => 'Person',
      'First Name' => 'First Name',
      'Last Name' => 'Last Name',
      'Middle Name' => 'Middle Name',
      'Original' => 'Original',
      'You' => 'You',
      'you' => 'you',
      'change' => 'change',
      'Change' => 'Change',
      'Primary' => 'Primary',
      'Save Filter' => 'Save Filter',
      'Remove Filter' => 'Remove Filter',
      'Ready' => 'Ready',
      'Administration' => 'Administration',
      'Run Import' => 'Run Import',
      'Duplicate' => 'Duplicate',
      'Notifications' => 'Notifications',
      'Mark all read' => 'Mark all read',
      'See more' => 'See more',
      'Today' => 'Today',
      'Tomorrow' => 'Tomorrow',
      'Yesterday' => 'Yesterday',
      'Now' => 'Now',
      'Submit' => 'Submit',
      'Close' => 'Close',
      'Yes' => 'Yes',
      'No' => 'No',
      'Select All Results' => 'Select All Results',
      'Value' => 'Value',
      'Current version' => 'Current version',
      'List View' => 'List View',
      'Tree View' => 'Tree View',
      'Unlink All' => 'Unlink All',
      'Total' => 'Total',
      'Print' => 'Print',
      'Print to PDF' => 'Print to PDF',
      'Default' => 'Default',
      'Number' => 'Number',
      'From' => 'From',
      'To' => 'To',
      'Create Post' => 'Create Post',
      'Previous Entry' => 'Previous Entry',
      'Next Entry' => 'Next Entry',
      'View List' => 'View List',
      'Attach File' => 'Attach File',
      'Skip' => 'Skip',
      'Attribute' => 'Attribute',
      'Function' => 'Function',
      'Self-Assign' => 'Self-Assign',
      'Self-Assigned' => 'Self-Assigned',
      'Expand' => 'Expand',
      'Collapse' => 'Collapse',
      'Expanded' => 'Expanded',
      'Collapsed' => 'Collapsed',
      'Top Level' => 'Top Level',
      'New notifications' => 'New notifications',
      'Manage Categories' => 'Manage Categories',
      'Manage Folders' => 'Manage Folders',
      'Convert to' => 'Convert to',
      'View Personal Data' => 'View Personal Data',
      'Personal Data' => 'Personal Data',
      'Erase' => 'Erase',
      'View Followers' => 'View Followers',
      'Convert Currency' => 'Convert Currency',
      'View on Map' => 'View on Map',
      'Preview' => 'Preview',
      'Move Over' => 'Move Over',
      'Up' => 'Up',
      'Save & Continue Editing' => 'Save & Continue Editing',
      'Save & New' => 'Save & New',
      'Field' => 'Field',
      'Fields' => 'Fields',
      'Resolution' => 'Resolution',
      'Resolve Conflict' => 'Resolve Conflict',
      'Download' => 'Download',
      'Global Search' => 'Global Search',
      'Navigation Panel' => 'Show Navigation Panel',
      'Copy to Clipboard' => 'Copy to Clipboard',
      'Copied to clipboard' => 'Copied to clipboard',
      'Audit Log' => 'Audit Log',
      'View Audit Log' => 'View Audit Log',
      'View User Access' => 'View User Access',
      'Reacted' => 'Reacted',
      'Reaction Removed' => 'Reaction Removed',
      'Reactions' => 'Reactions',
      'Create In Modal' => 'Create In Modal',
      'Add row' => 'Add Row',
      'Schedule' => 'Schedule',
      'Log' => 'Log',
      'Scheduler' => 'Scheduler',
      'Create InboundEmail' => 'Create Inbound Email',
      'Activities' => 'Activities',
      'History' => 'History',
      'Attendees' => 'Attendees',
      'Schedule Meeting' => 'Schedule Meeting',
      'Schedule Call' => 'Schedule Call',
      'Compose Email' => 'Compose Email',
      'Log Meeting' => 'Log Meeting',
      'Log Call' => 'Log Call',
      'Archive Email' => 'Archive Email',
      'Create Task' => 'Create Task',
      'Tasks' => 'Tasks',
      'Start Process' => 'Start Process',
      'Lock' => 'Lock',
      'Unlock' => 'Unlock',
      'kanbanStatusFields' => 'Kanban Status Fields'
    ],
    'messages' => [
      'pleaseWait' => 'Please wait...',
      'loading' => 'Loading...',
      'saving' => 'Saving...',
      'confirmLeaveOutMessage' => 'Are you sure you want to leave the form?',
      'notModified' => 'You have not modified the record',
      'duplicate' => 'The record you are creating might already exist',
      'dropToAttach' => 'Drop to attach',
      'pageNumberIsOutOfBound' => 'Page number is out of bound',
      'fieldUrlExceedsMaxLength' => 'Encoded URL exceeds max length of {maxLength}',
      'fieldNotMatchingPattern' => '{field} does not match the pattern `{pattern}`',
      'fieldNotMatchingPattern$noBadCharacters' => '{field} contains not allowed characters',
      'fieldNotMatchingPattern$noAsciiSpecialCharacters' => '{field} should not contain ASCII special characters',
      'fieldNotMatchingPattern$latinLetters' => '{field} can contain only latin letters',
      'fieldNotMatchingPattern$latinLettersDigits' => '{field} can contain only latin letters and digits',
      'fieldNotMatchingPattern$latinLettersDigitsWhitespace' => '{field} can contain only latin letters, digits and whitespace',
      'fieldNotMatchingPattern$latinLettersWhitespace' => '{field} can contain only latin letters and whitespace',
      'fieldNotMatchingPattern$digits' => '{field} can contain only digits',
      'fieldNotMatchingPattern$uriOptionalProtocol' => '{field} must be a valid URL',
      'fieldNotMatchingPattern$phoneNumberLoose' => '{field} contains characters not allowed in a phone number',
      'fieldInvalid' => '{field} is invalid',
      'fieldIsRequired' => '{field} is required',
      'fieldPhoneInvalid' => '{field} is invalid',
      'fieldPhoneInvalidCode' => 'Invalid country code',
      'fieldPhoneTooShort' => '{field} is too short',
      'fieldPhoneTooLong' => '{field} is too long',
      'fieldPhoneInvalidCharacters' => 'Only digits, latin letters and characters `-+_@:#().` are allowed',
      'fieldPhoneExtensionTooLong' => 'Extension should not be longer than {maxLength}',
      'fieldShouldBeEmail' => '{field} should be a valid email',
      'fieldShouldBeFloat' => '{field} should be a valid float',
      'fieldShouldBeInt' => '{field} should be a valid integer',
      'fieldShouldBeNumber' => '{field} should be a valid number',
      'fieldShouldBeDate' => '{field} should be a valid date',
      'fieldShouldBeDatetime' => '{field} should be a valid date/time',
      'fieldShouldAfter' => '{field} should be after {otherField}',
      'fieldShouldBefore' => '{field} should be before {otherField}',
      'fieldShouldBeBetween' => '{field} should be between {min} and {max}',
      'fieldShouldBeLess' => '{field} shouldn\'t be greater than {value}',
      'fieldShouldBeGreater' => '{field} shouldn\'t be less than {value}',
      'fieldBadPasswordConfirm' => '{field} not confirmed properly',
      'fieldMaxFileSizeError' => 'File should not exceed {max} Mb',
      'fieldValueDuplicate' => 'Duplicate value',
      'fieldIsUploading' => 'Uploading in progress',
      'fieldExceedsMaxCount' => 'Count exceeds max allowed {maxCount}',
      'barcodeInvalid' => '{field} is not valid {type}',
      'arrayItemMaxLength' => 'Item shouldn\'t be longer than {max} characters',
      'resetPreferencesDone' => 'Preferences has been reset to defaults',
      'confirmation' => 'Are you sure?',
      'unlinkAllConfirmation' => 'Are you sure you want to unlink all related records?',
      'resetPreferencesConfirmation' => 'Are you sure you want to reset preferences to defaults?',
      'removeRecordConfirmation' => 'Are you sure you want to remove the record?',
      'unlinkRecordConfirmation' => 'Are you sure you want to unlink the related record?',
      'removeSelectedRecordsConfirmation' => 'Are you sure you want to remove selected records?',
      'unlinkSelectedRecordsConfirmation' => 'Are you sure you want to unlink selected records?',
      'massUpdateResult' => '{count} records have been updated',
      'massUpdateResultSingle' => '{count} record has been updated',
      'recalculateFormulaConfirmation' => 'Are you sure you want to recalculate formula for selected records?',
      'noRecordsUpdated' => 'No records were updated',
      'massRemoveResult' => '{count} records have been removed',
      'massRemoveResultSingle' => '{count} record has been removed',
      'noRecordsRemoved' => 'No records were removed',
      'clickToRefresh' => 'Click to refresh',
      'writeYourCommentHere' => 'Write your comment here',
      'writeMessageToUser' => 'Write a message to {user}',
      'writeMessageToSelf' => 'Write a message on your stream',
      'typeAndPressEnter' => 'Type & press enter',
      'checkForNewNotifications' => 'Check for new notifications',
      'checkForNewNotes' => 'Check for stream updates',
      'internalPost' => 'Post will be seen only by internal users',
      'internalPostTitle' => 'Post is seen only by internal users',
      'done' => 'Done',
      'notUpdated' => 'Not updated',
      'confirmMassUpdate' => 'Are you sure you want to mass-update selected records?',
      'confirmMassFollow' => 'Are you sure you want to follow selected records?',
      'confirmMassUnfollow' => 'Are you sure you want to unfollow selected records?',
      'massFollowResult' => '{count} records now are followed',
      'massUnfollowResult' => '{count} records now are not followed',
      'massFollowResultSingle' => '{count} record now is followed',
      'massUnfollowResultSingle' => '{count} record now is not followed',
      'massFollowZeroResult' => 'Nothing got followed',
      'massUnfollowZeroResult' => 'Nothing got unfollowed',
      'erasePersonalDataConfirmation' => 'Checked fields will be erased permanently. Are you sure?',
      'maintenanceModeError' => 'The application currently is in maintenance mode.',
      'maintenanceMode' => 'The application currently is in maintenance mode. Only admin users have access.

Maintenance mode can be disabled at Administration → Settings.',
      'resolveSaveConflict' => 'The record has been modified. You need to resolve the conflict before you can save the record.',
      'massPrintPdfMaxCountError' => 'Can\'t print more that {maxCount} records.',
      'massActionProcessed' => 'Mass action has been processed.',
      'validationFailure' => 'Backend validation failure.

Field: `{field}`
Validation: `{type}`',
      'extensionLicenseInvalid' => 'Invalid \'{name}\' extension license.',
      'extensionLicenseExpired' => 'The \'{name}\' extension license subscription has expired.',
      'extensionLicenseSoftExpired' => 'The \'{name}\' extension license subscription has expired.',
      'confirmAppRefresh' => 'The application has been updated. It is recommended to refresh the page to ensure the proper functioning.',
      'loggedOutLeaveOut' => 'Logged out. The session is inactive. You may lose unsaved form data after page refresh. You may need to make a copy.',
      'noAccessToRecord' => 'Operation requires `{action}` access to record.',
      'noAccessToForeignRecord' => 'Operation requires `{action}` access to foreign record.',
      'noLinkAccess' => 'Can\'t relate with {foreignEntityType} record through the link \'{link}\'. No access.',
      'cannotUnrelateRequiredLink' => 'Can\'t unrelate required link.',
      'cannotRelateNonExisting' => 'Can\'t relate with non-existing {foreignEntityType} record.',
      'cannotRelateForbidden' => 'Can\'t relate with forbidden {foreignEntityType} record. `{action}` access required.',
      'cannotRelateForbiddenLink' => 'No access to link \'{link}\'.',
      'cannotLinkAlreadyLinked' => 'Cannot link an already linked record.',
      'error404' => 'The url you requested can\'t be handled.',
      'error403' => 'You don\'t have access to this area.',
      'emptyMassUpdate' => 'No fields available for Mass Update.',
      'attemptIntervalFailure' => 'The operation is not allowed during a specific time interval. Wait for some time before the next attempt.',
      'confirmRestoreFromAudit' => 'The previous values will be set in a form. Then you can save the record to restore the previous values.',
      'starsLimitExceeded' => 'The number of stars exceeded the limit.',
      'select2OrMoreRecords' => 'Select 2 or more records',
      'selectNotMoreThanNumberRecords' => 'Select not more than {number} records',
      'selectAtLeastOneRecord' => 'Select at least one record',
      'duplicateConflict' => 'A record already exists.',
      'cannotRemoveCategoryWithChildCategory' => 'Cannot remove a category that has a child category.',
      'cannotRemoveNotEmptyCategory' => 'Cannot remove a non-empty category.'
    ],
    'boolFilters' => [
      'onlyMy' => 'Only My',
      'onlyMyTeam' => 'My Team',
      'followed' => 'Followed',
      'shared' => 'Shared'
    ],
    'presetFilters' => [
      'followed' => 'Followed',
      'all' => 'All',
      'starred' => 'Starred'
    ],
    'massActions' => [
      'delete' => 'Delete',
      'remove' => 'Remove',
      'merge' => 'Merge',
      'update' => 'Update',
      'massUpdate' => 'Mass Update',
      'unlink' => 'Unlink',
      'export' => 'Export',
      'follow' => 'Follow',
      'unfollow' => 'Unfollow',
      'convertCurrency' => 'Convert Currency',
      'recalculateFormula' => 'Recalculate Formula',
      'printPdf' => 'Print to PDF',
      'lock' => 'Lock',
      'unlock' => 'Unlock'
    ],
    'fields' => [
      'name' => 'Name',
      'firstName' => 'First Name',
      'lastName' => 'Last Name',
      'middleName' => 'Middle Name',
      'salutationName' => 'Salutation',
      'assignedUser' => 'Assigned User',
      'assignedUsers' => 'Assigned Users',
      'collaborators' => 'Collaborators',
      'emailAddress' => 'Email',
      'emailAddressData' => 'Email Address Data',
      'emailAddressIsOptedOut' => 'Email Address is Opted-Out',
      'emailAddressIsInvalid' => 'Email Address is Invalid',
      'assignedUserName' => 'Assigned User Name',
      'teams' => 'Teams',
      'users' => 'Users',
      'createdAt' => 'Created At',
      'modifiedAt' => 'Modified At',
      'createdBy' => 'Created By',
      'modifiedBy' => 'Modified By',
      'streamUpdatedAt' => 'Stream Updated At',
      'description' => 'Description',
      'address' => 'Address',
      'phoneNumber' => 'Phone',
      'phoneNumberMobile' => 'Phone (Mobile)',
      'phoneNumberHome' => 'Phone (Home)',
      'phoneNumberFax' => 'Phone (Fax)',
      'phoneNumberOffice' => 'Phone (Office)',
      'phoneNumberOther' => 'Phone (Other)',
      'phoneNumberData' => 'Phone Number Data',
      'phoneNumberIsOptedOut' => 'Phone Number is Opted-Out',
      'phoneNumberIsInvalid' => 'Phone Number is Invalid',
      'order' => 'Order',
      'parent' => 'Parent',
      'children' => 'Children',
      'id' => 'ID',
      'ids' => 'IDs',
      'type' => 'Type',
      'names' => 'Names',
      'types' => 'Types',
      'targetListIsOptedOut' => 'Is Opted Out (Target List)',
      'childList' => 'Child List',
      'billingAddressCity' => 'City',
      'billingAddressCountry' => 'Country',
      'billingAddressPostalCode' => 'Postal Code',
      'billingAddressState' => 'State',
      'billingAddressStreet' => 'Street',
      'billingAddressMap' => 'Map',
      'addressCity' => 'City',
      'addressStreet' => 'Street',
      'addressCountry' => 'Country',
      'addressState' => 'State',
      'addressPostalCode' => 'Postal Code',
      'addressMap' => 'Map',
      'shippingAddressCity' => 'City (Shipping)',
      'shippingAddressStreet' => 'Street (Shipping)',
      'shippingAddressCountry' => 'Country (Shipping)',
      'shippingAddressState' => 'State (Shipping)',
      'shippingAddressPostalCode' => 'Postal Code (Shipping)',
      'shippingAddressMap' => 'Map (Shipping)',
      'products' => 'Products',
      'inventoryNumbers' => 'Inventory Numbers',
      'allowFractionalQuantity' => 'Allow Fractional Quantity',
      'productType' => 'Product Type',
      'isDone' => 'Is Done',
      'isNotActual' => 'Is Not Actual',
      'isLocked' => 'Locked',
      'isHardLocked' => 'Hard-Locked',
      'KanbanViewFields' => 'Kanban Status Fields'
    ],
    'links' => [
      'assignedUser' => 'Assigned User',
      'assignedUsers' => 'Assigned Users',
      'collaborators' => 'Collaborators',
      'createdBy' => 'Created By',
      'modifiedBy' => 'Modified By',
      'team' => 'Team',
      'roles' => 'Roles',
      'teams' => 'Teams',
      'users' => 'Users',
      'parent' => 'Parent',
      'children' => 'Children',
      'contacts' => 'Contacts',
      'opportunities' => 'Opportunities',
      'leads' => 'Leads',
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks',
      'emails' => 'Emails',
      'accounts' => 'Accounts',
      'cases' => 'Cases',
      'documents' => 'Documents',
      'account' => 'Account',
      'opportunity' => 'Opportunity',
      'contact' => 'Contact'
    ],
    'dashlets' => [
      'Stream' => 'Stream',
      'Emails' => 'My Inbox',
      'Iframe' => 'Iframe',
      'Records' => 'Record List',
      'Memo' => 'Memo',
      'Leads' => 'My Leads',
      'Opportunities' => 'My Opportunities',
      'Tasks' => 'My Tasks',
      'Cases' => 'My Cases',
      'Calendar' => 'Calendar',
      'Calls' => 'My Calls',
      'Meetings' => 'My Meetings',
      'OpportunitiesByStage' => 'Opportunities by Stage',
      'OpportunitiesByLeadSource' => 'Opportunities by Lead Source',
      'SalesByMonth' => 'Sales by Month',
      'SalesPipeline' => 'Sales Pipeline',
      'Activities' => 'My Activities',
      'Report' => 'Report',
      'BpmnUserTasks' => 'Process User Tasks'
    ],
    'notificationMessages' => [
      'assign' => '{entityType} {entity} has been assigned to you',
      'emailReceived' => 'Email received from {from}',
      'entityRemoved' => '{user} removed {entityType} {entity}',
      'emailInbox' => '{user} added email {entity} to your inbox',
      'userPostReaction' => '{user} reacted to your {post}',
      'userPostInParentReaction' => '{user} reacted to your {post} in {entityType} {entity}',
      'eventAttendee' => '{user} added you to {entityType} {entity}'
    ],
    'streamMessages' => [
      'post' => '{user} posted on {entityType} {entity}',
      'attach' => '{user} attached on {entityType} {entity}',
      'status' => '{user} updated {field} of {entityType} {entity}',
      'update' => '{user} updated {entityType} {entity}',
      'postTargetTeam' => '{user} posted to team {target}',
      'postTargetTeams' => '{user} posted to teams {target}',
      'postTargetPortal' => '{user} posted to portal {target}',
      'postTargetPortals' => '{user} posted to portals {target}',
      'postTarget' => '{user} posted to {target}',
      'postTargetYou' => '{user} posted to you',
      'postTargetYouAndOthers' => '{user} posted to {target} and you',
      'postTargetAll' => '{user} posted to all',
      'postTargetSelf' => '{user} self-posted',
      'postTargetSelfAndOthers' => '{user} posted to {target} and themself',
      'mentionInPost' => '{user} mentioned {mentioned} in {entityType} {entity}',
      'mentionYouInPost' => '{user} mentioned you in {entityType} {entity}',
      'mentionInPostTarget' => '{user} mentioned {mentioned} in post',
      'mentionYouInPostTarget' => '{user} mentioned you in post to {target}',
      'mentionYouInPostTargetAll' => '{user} mentioned you in post to all',
      'mentionYouInPostTargetNoTarget' => '{user} mentioned you in post',
      'create' => '{user} created {entityType} {entity}',
      'createThis' => '{user} created this {entityType}',
      'createAssignedThis' => '{user} created this {entityType} assigned to {assignee}',
      'createAssigned' => '{user} created {entityType} {entity} assigned to {assignee}',
      'createAssignedYou' => '{user} created {entityType} {entity} assigned to you',
      'createAssignedThisSelf' => '{user} created this {entityType} self-assigned',
      'createAssignedSelf' => '{user} created {entityType} {entity} self-assigned',
      'assign' => '{user} assigned {entityType} {entity} to {assignee}',
      'assignThis' => '{user} assigned this {entityType} to {assignee}',
      'assignYou' => '{user} assigned {entityType} {entity} to you',
      'assignThisVoid' => '{user} unassigned this {entityType}',
      'assignVoid' => '{user} unassigned {entityType} {entity}',
      'assignThisSelf' => '{user} self-assigned this {entityType}',
      'assignSelf' => '{user} self-assigned {entityType} {entity}',
      'assignMultiAdd' => '{user} assigned {entity} to {assignee}',
      'assignMultiRemove' => '{user} unassigned {entity} from {removedAssignee}',
      'assignMultiAddRemove' => '{user} assigned {entity} to {assignee} and unassigned from {removedAssignee}',
      'assignMultiAddThis' => '{user} assigned this {entityType} to {assignee}',
      'assignMultiRemoveThis' => '{user} unassigned this {entityType} from {removedAssignee}',
      'assignMultiAddRemoveThis' => '{user} assigned this {entityType} to {assignee} and unassigned from {removedAssignee}',
      'postThis' => '{user} posted',
      'attachThis' => '{user} attached',
      'statusThis' => '{user} updated {field}',
      'updateThis' => '{user} updated this {entityType}',
      'createRelatedThis' => '{user} created {relatedEntityType} {relatedEntity} related to this {entityType}',
      'createRelated' => '{user} created {relatedEntityType} {relatedEntity} related to {entityType} {entity}',
      'relate' => '{user} linked {relatedEntityType} {relatedEntity} with {entityType} {entity}',
      'relateThis' => '{user} linked {relatedEntityType} {relatedEntity} with this {entityType}',
      'unrelate' => '{user} unlinked {relatedEntityType} {relatedEntity} from {entityType} {entity}',
      'unrelateThis' => '{user} unlinked {relatedEntityType} {relatedEntity} from this {entityType}',
      'emailReceivedFromThis' => 'Email received from {from}',
      'emailReceivedInitialFromThis' => 'Email received from {from}, this {entityType} created',
      'emailReceivedThis' => 'Email received',
      'emailReceivedInitialThis' => 'Email received, this {entityType} created',
      'emailReceivedFrom' => 'Email received from {from}, related to {entityType} {entity}',
      'emailReceivedFromInitial' => 'Email received from {from}, {entityType} {entity} created',
      'emailReceived' => 'Email received related to {entityType} {entity}',
      'emailReceivedInitial' => 'Email received: {entityType} {entity} created',
      'emailReceivedInitialFrom' => 'Email received from {from}, {entityType} {entity} created',
      'emailSent' => '{by} sent email related to {entityType} {entity}',
      'emailSentThis' => '{by} sent email',
      'eventConfirmationAccepted' => '{invitee} accepted participation in {entityType} {entity}',
      'eventConfirmationDeclined' => '{invitee} declined participation in {entityType} {entity}',
      'eventConfirmationTentative' => '{invitee} is tentative about participation in {entityType} {entity}',
      'eventConfirmationAcceptedThis' => '{invitee} accepted participation',
      'eventConfirmationDeclinedThis' => '{invitee} declined participation',
      'eventConfirmationTentativeThis' => '{invitee} is tentative about participation'
    ],
    'streamMessagesMale' => [
      'postTargetSelfAndOthers' => '{user} posted to {target} and himself'
    ],
    'streamMessagesFemale' => [
      'postTargetSelfAndOthers' => '{user} posted to {target} and herself'
    ],
    'lists' => [
      'monthNames' => [
        0 => 'January',
        1 => 'February',
        2 => 'March',
        3 => 'April',
        4 => 'May',
        5 => 'June',
        6 => 'July',
        7 => 'August',
        8 => 'September',
        9 => 'October',
        10 => 'November',
        11 => 'December'
      ],
      'monthNamesShort' => [
        0 => 'Jan',
        1 => 'Feb',
        2 => 'Mar',
        3 => 'Apr',
        4 => 'May',
        5 => 'Jun',
        6 => 'Jul',
        7 => 'Aug',
        8 => 'Sep',
        9 => 'Oct',
        10 => 'Nov',
        11 => 'Dec'
      ],
      'dayNames' => [
        0 => 'Sunday',
        1 => 'Monday',
        2 => 'Tuesday',
        3 => 'Wednesday',
        4 => 'Thursday',
        5 => 'Friday',
        6 => 'Saturday'
      ],
      'dayNamesShort' => [
        0 => 'Sun',
        1 => 'Mon',
        2 => 'Tue',
        3 => 'Wed',
        4 => 'Thu',
        5 => 'Fri',
        6 => 'Sat'
      ],
      'dayNamesMin' => [
        0 => 'Su',
        1 => 'Mo',
        2 => 'Tu',
        3 => 'We',
        4 => 'Th',
        5 => 'Fr',
        6 => 'Sa'
      ]
    ],
    'durationUnits' => [
      'd' => 'd',
      'h' => 'h',
      'm' => 'm',
      's' => 's'
    ],
    'options' => [
      'salutationName' => [
        'Mr.' => 'Mr.',
        'Mrs.' => 'Mrs.',
        'Ms.' => 'Ms.',
        'Dr.' => 'Dr.'
      ],
      'language' => [
        'ar_AR' => 'Arabic',
        'af_ZA' => 'Afrikaans',
        'az_AZ' => 'Azerbaijani',
        'be_BY' => 'Belarusian',
        'bg_BG' => 'Bulgarian',
        'bn_IN' => 'Bengali',
        'bs_BA' => 'Bosnian',
        'ca_ES' => 'Catalan',
        'cs_CZ' => 'Czech',
        'cy_GB' => 'Welsh',
        'da_DK' => 'Danish',
        'de_DE' => 'German',
        'el_GR' => 'Greek',
        'en_GB' => 'English (UK)',
        'es_MX' => 'Spanish (Mexico)',
        'en_US' => 'English (US)',
        'es_ES' => 'Spanish (Spain)',
        'et_EE' => 'Estonian',
        'eu_ES' => 'Basque',
        'fa_IR' => 'Persian',
        'fi_FI' => 'Finnish',
        'fo_FO' => 'Faroese',
        'fr_CA' => 'French (Canada)',
        'fr_FR' => 'French (France)',
        'ga_IE' => 'Irish',
        'gl_ES' => 'Galician',
        'gn_PY' => 'Guarani',
        'he_IL' => 'Hebrew',
        'hi_IN' => 'Hindi',
        'hr_HR' => 'Croatian',
        'hu_HU' => 'Hungarian',
        'hy_AM' => 'Armenian',
        'id_ID' => 'Indonesian',
        'is_IS' => 'Icelandic',
        'it_IT' => 'Italian',
        'ja_JP' => 'Japanese',
        'ka_GE' => 'Georgian',
        'km_KH' => 'Khmer',
        'ko_KR' => 'Korean',
        'ku_TR' => 'Kurdish',
        'lt_LT' => 'Lithuanian',
        'lv_LV' => 'Latvian',
        'mk_MK' => 'Macedonian',
        'ml_IN' => 'Malayalam',
        'ms_MY' => 'Malay',
        'nb_NO' => 'Norwegian Bokmål',
        'nn_NO' => 'Norwegian Nynorsk',
        'ne_NP' => 'Nepali',
        'nl_NL' => 'Dutch',
        'pa_IN' => 'Punjabi',
        'pl_PL' => 'Polish',
        'ps_AF' => 'Pashto',
        'pt_BR' => 'Portuguese (Brazil)',
        'pt_PT' => 'Portuguese (Portugal)',
        'ro_RO' => 'Romanian',
        'ru_RU' => 'Russian',
        'sk_SK' => 'Slovak',
        'sl_SI' => 'Slovene',
        'sq_AL' => 'Albanian',
        'sr_RS' => 'Serbian',
        'sv_SE' => 'Swedish',
        'sw_KE' => 'Swahili',
        'ta_IN' => 'Tamil',
        'te_IN' => 'Telugu',
        'th_TH' => 'Thai',
        'tl_PH' => 'Tagalog',
        'tr_TR' => 'Turkish',
        'uk_UA' => 'Ukrainian',
        'ur_PK' => 'Urdu',
        'vi_VN' => 'Vietnamese',
        'zh_CN' => 'Simplified Chinese (China)',
        'zh_HK' => 'Traditional Chinese (Hong Kong)',
        'zh_TW' => 'Traditional Chinese (Taiwan)'
      ],
      'dateSearchRanges' => [
        'on' => 'On',
        'notOn' => 'Not On',
        'after' => 'After',
        'before' => 'Before',
        'between' => 'Between',
        'today' => 'Today',
        'past' => 'Past',
        'future' => 'Future',
        'currentMonth' => 'Current Month',
        'lastMonth' => 'Last Month',
        'nextMonth' => 'Next Month',
        'currentQuarter' => 'Current Quarter',
        'lastQuarter' => 'Last Quarter',
        'currentYear' => 'Current Year',
        'lastYear' => 'Last Year',
        'lastSevenDays' => 'Last 7 Days',
        'lastXDays' => 'Last X Days',
        'nextXDays' => 'Next X Days',
        'ever' => 'Ever',
        'isEmpty' => 'Is Empty',
        'olderThanXDays' => 'Older Than X Days',
        'afterXDays' => 'After X Days',
        'currentFiscalYear' => 'Current Fiscal Year',
        'lastFiscalYear' => 'Last Fiscal Year',
        'currentFiscalQuarter' => 'Current Fiscal Quarter',
        'lastFiscalQuarter' => 'Last Fiscal Quarter'
      ],
      'searchRanges' => [
        'is' => 'Is',
        'isEmpty' => 'Is Empty',
        'isNotEmpty' => 'Is Not Empty',
        'isOneOf' => 'Any Of',
        'isFromTeams' => 'Is From Team',
        'isNot' => 'Is Not',
        'isNotOneOf' => 'None Of',
        'anyOf' => 'Any Of',
        'allOf' => 'All Of',
        'noneOf' => 'None Of',
        'any' => 'Any'
      ],
      'varcharSearchRanges' => [
        'equals' => 'Equals',
        'like' => 'Is Like (%)',
        'notLike' => 'Is Not Like (%)',
        'startsWith' => 'Starts With',
        'endsWith' => 'Ends With',
        'contains' => 'Contains',
        'notContains' => 'Not Contains',
        'isEmpty' => 'Is Empty',
        'isNotEmpty' => 'Is Not Empty',
        'notEquals' => 'Not Equals'
      ],
      'intSearchRanges' => [
        'equals' => 'Equals',
        'notEquals' => 'Not Equals',
        'greaterThan' => 'Greater Than',
        'lessThan' => 'Less Than',
        'greaterThanOrEquals' => 'Greater Than or Equals',
        'lessThanOrEquals' => 'Less Than or Equals',
        'between' => 'Between',
        'isEmpty' => 'Is Empty',
        'isNotEmpty' => 'Is Not Empty'
      ],
      'autorefreshInterval' => [
        0 => 'None',
        '0.5' => '30 seconds',
        1 => '1 minute',
        2 => '2 minutes',
        5 => '5 minutes',
        10 => '10 minutes'
      ],
      'phoneNumber' => [
        'Mobile' => 'Mobile',
        'Office' => 'Office',
        'Fax' => 'Fax',
        'Home' => 'Home',
        'Other' => 'Other'
      ],
      'saveConflictResolution' => [
        'current' => 'Current',
        'actual' => 'Actual',
        'original' => 'Original'
      ],
      'reminderTypes' => [
        'Popup' => 'Popup',
        'Email' => 'Email'
      ],
      'inventoryStatus' => [
        'Available' => 'Available',
        'On Hand' => 'On Hand',
        'Not Available' => 'Not Available'
      ]
    ],
    'sets' => [
      'summernote' => [
        'NOTICE' => 'You can find translation here: https://github.com/HackerWins/summernote/tree/master/lang',
        'font' => [
          'bold' => 'Bold',
          'italic' => 'Italic',
          'underline' => 'Underline',
          'strike' => 'Strike',
          'clear' => 'Remove Font Style',
          'height' => 'Line Height',
          'name' => 'Font Family',
          'size' => 'Font Size'
        ],
        'image' => [
          'image' => 'Picture',
          'insert' => 'Insert Image',
          'resizeFull' => 'Resize Full',
          'resizeHalf' => 'Resize Half',
          'resizeQuarter' => 'Resize Quarter',
          'floatLeft' => 'Float Left',
          'floatRight' => 'Float Right',
          'floatNone' => 'Float None',
          'dragImageHere' => 'Drag an image here',
          'selectFromFiles' => 'Select from files',
          'url' => 'Image URL',
          'remove' => 'Remove Image'
        ],
        'link' => [
          'link' => 'Link',
          'insert' => 'Insert Link',
          'unlink' => 'Unlink',
          'edit' => 'Edit',
          'textToDisplay' => 'Text to display',
          'url' => 'To what URL should this link go?',
          'openInNewWindow' => 'Open in new window'
        ],
        'video' => [
          'video' => 'Video',
          'videoLink' => 'Video Link',
          'insert' => 'Insert Video',
          'url' => 'Video URL?',
          'providers' => '(YouTube, Vimeo, Vine, Instagram, or DailyMotion)'
        ],
        'table' => [
          'table' => 'Table'
        ],
        'hr' => [
          'insert' => 'Insert Horizontal Rule'
        ],
        'style' => [
          'style' => 'Style',
          'normal' => 'Normal',
          'blockquote' => 'Quote',
          'pre' => 'Code',
          'h1' => 'Header 1',
          'h2' => 'Header 2',
          'h3' => 'Header 3',
          'h4' => 'Header 4',
          'h5' => 'Header 5',
          'h6' => 'Header 6'
        ],
        'lists' => [
          'unordered' => 'Unordered list',
          'ordered' => 'Ordered list'
        ],
        'options' => [
          'help' => 'Help',
          'fullscreen' => 'Full Screen',
          'codeview' => 'Code View'
        ],
        'paragraph' => [
          'paragraph' => 'Paragraph',
          'outdent' => 'Outdent',
          'indent' => 'Indent',
          'left' => 'Align left',
          'center' => 'Align center',
          'right' => 'Align right',
          'justify' => 'Justify full'
        ],
        'color' => [
          'recent' => 'Recent Color',
          'more' => 'More Color',
          'background' => 'Back Color',
          'foreground' => 'Font Color',
          'transparent' => 'Transparent',
          'setTransparent' => 'Set transparent',
          'reset' => 'Reset',
          'resetToDefault' => 'Reset to default'
        ],
        'shortcut' => [
          'shortcuts' => 'Keyboard shortcuts',
          'close' => 'Close',
          'textFormatting' => 'Text formatting',
          'action' => 'Action',
          'paragraphFormatting' => 'Paragraph formatting',
          'documentStyle' => 'Document Style'
        ],
        'history' => [
          'undo' => 'Undo',
          'redo' => 'Redo'
        ]
      ]
    ],
    'listViewModes' => [
      'list' => 'List',
      'kanban' => 'Kanban'
    ],
    'themes' => [
      'Dark' => 'Dark',
      'Light' => 'Light',
      'Espo' => 'Espo',
      'EspoRtl' => 'RTL',
      'Sakura' => 'Sakura',
      'Violet' => 'Violet',
      'Hazyblue' => 'Hazyblue',
      'Glass' => 'Glass'
    ],
    'themeNavbars' => [
      'side' => 'Side Navbar',
      'top' => 'Top Navbar'
    ],
    'fieldValidations' => [
      'required' => 'Required',
      'maxCount' => 'Max Count',
      'maxLength' => 'Max Length',
      'pattern' => 'Pattern Matching',
      'emailAddress' => 'Valid Email Address',
      'phoneNumber' => 'Valid Phone Number',
      'array' => 'Array',
      'arrayOfString' => 'Array of Strings',
      'valid' => 'Validity',
      'noEmptyString' => 'No Empty String',
      'max' => 'Max Value',
      'min' => 'Min Value'
    ],
    'fieldValidationExplanations' => [
      'valid' => 'Invalid value.',
      'maxLength' => 'Value length exceeds maximum value.',
      'phone_valid' => 'Phone number is not valid. May be caused by a wrong or empty country code.',
      'url_valid' => 'Invalid URL value.',
      'currency_valid' => 'Invalid amount value.',
      'currency_validCurrency' => 'The currency code value is invalid or not allowed.',
      'varchar_pattern' => 'Likely, the value contains not allowed characters.',
      'email_emailAddress' => 'Invalid email address value.',
      'phone_phoneNumber' => 'Invalid phone number value.',
      'datetimeOptional_valid' => 'Invalid date-time value.',
      'datetime_valid' => 'Invalid date-time value.',
      'date_valid' => 'Invalid date value.',
      'enum_valid' => 'Invalid enum value. The value must be one of defined enum options. An empty value is allowed only if the field has an empty option.',
      'int_valid' => 'Invalid integer number value.',
      'float_valid' => 'Invalid number value.',
      'multiEnum_valid' => 'Invalid multi-enum value. Values must be one of defined field options.'
    ],
    'navbarTabs' => [
      'Business' => 'Business',
      'Marketing' => 'Marketing',
      'Support' => 'Support',
      'CRM' => 'CRM',
      'Activities' => 'Activities',
      'SalesPack' => 'Sales & Purchase'
    ],
    'wysiwygLabels' => [
      'cell' => 'Cell',
      'align' => 'Align',
      'width' => 'Width',
      'height' => 'Height',
      'borderWidth' => 'Border Width',
      'borderColor' => 'Border Color',
      'cellPadding' => 'Cell Padding',
      'backgroundColor' => 'Background Color',
      'verticalAlign' => 'Vertical Align'
    ],
    'wysiwygOptions' => [
      'align' => [
        'left' => 'Left',
        'center' => 'Center',
        'right' => 'Right'
      ],
      'verticalAlign' => [
        'top' => 'Top',
        'middle' => 'Middle',
        'bottom' => 'Bottom'
      ]
    ],
    'detailViewModes' => [
      'detail' => 'Detail'
    ],
    'strings' => [
      'yesterdayShort' => 'Yest'
    ],
    'reactions' => [
      'Smile' => 'Smile',
      'Surprise' => 'Surprise',
      'Laugh' => 'Laugh',
      'Meh' => 'Meh',
      'Sad' => 'Sad',
      'Love' => 'Love',
      'Like' => 'Like',
      'Dislike' => 'Dislike'
    ],
    'recordActions' => [
      'create' => 'Create',
      'read' => 'Read',
      'edit' => 'Edit',
      'delete' => 'Delete',
      'stream' => 'Stream'
    ],
    'tabs' => [
      'Stream' => 'Stream'
    ],
    'featureEnableInfo' => [
      'PriceBooks' => 'The *Price Books* feature is not enabled. You can enable it at Administration > Sales Pack > [Settings](#Admin/salesPackSettings).',
      'Warehouses' => 'The *Warehouses* feature is not enabled. You can enable it at Administration > Sales Pack > [Settings](#Admin/salesPackSettings).',
      'InventoryTransactions' => 'The *Inventory Transactions* feature is not enabled. You can enable it at Administration > Sales Pack > [Settings](#Admin/salesPackSettings).'
    ]
  ],
  'GroupEmailFolder' => [
    'links' => [
      'emails' => 'Emails'
    ],
    'labels' => [
      'Create GroupEmailFolder' => 'Create Folder'
    ]
  ],
  'Import' => [
    'labels' => [
      'New import with same params' => 'New import with same params',
      'Revert Import' => 'Revert Import',
      'Return to Import' => 'Return to Import',
      'Run Import' => 'Run Import',
      'Back' => 'Back',
      'Field Mapping' => 'Field Mapping',
      'Default Values' => 'Default Values',
      'Add Field' => 'Add Field',
      'Created' => 'Created',
      'Updated' => 'Updated',
      'Result' => 'Result',
      'Show records' => 'Show records',
      'Remove Duplicates' => 'Remove Duplicates',
      'importedCount' => 'Imported (count)',
      'duplicateCount' => 'Duplicates (count)',
      'updatedCount' => 'Updated (count)',
      'Create Only' => 'Create Only',
      'Create and Update' => 'Create & Update',
      'Update Only' => 'Update Only',
      'Update by' => 'Update by',
      'Set as Not Duplicate' => 'Set as Not Duplicate',
      'File (CSV)' => 'File (CSV)',
      'First Row Value' => 'First Row Value',
      'Skip' => 'Skip',
      'Header Row Value' => 'Header Row Value',
      'Field' => 'Field',
      'What to Import?' => 'What to Import?',
      'Entity Type' => 'Entity Type',
      'What to do?' => 'What to do?',
      'Properties' => 'Properties',
      'Header Row' => 'Header Row',
      'Person Name Format' => 'Person Name Format',
      'John Smith' => 'John Smith',
      'Smith John' => 'Smith John',
      'Smith, John' => 'Smith, John',
      'Field Delimiter' => 'Field Delimiter',
      'Date Format' => 'Date Format',
      'Decimal Mark' => 'Decimal Mark',
      'Text Qualifier' => 'Text Qualifier',
      'Time Format' => 'Time Format',
      'Currency' => 'Currency',
      'Preview' => 'Preview',
      'Next' => 'Next',
      'Step 1' => 'Step 1',
      'Step 2' => 'Step 2',
      'Double Quote' => 'Double Quote',
      'Single Quote' => 'Single Quote',
      'Imported' => 'Imported',
      'Duplicates' => 'Duplicates',
      'Skip searching for duplicates' => 'Skip searching for duplicates',
      'Timezone' => 'Timezone',
      'Remove Import Log' => 'Remove Import Log',
      'New Import' => 'New Import',
      'Import Results' => 'Import Results',
      'Run Manually' => 'Run Manually',
      'Silent Mode' => 'Silent Mode',
      'Export' => 'Export'
    ],
    'messages' => [
      'importRunning' => 'Import running...',
      'noErrors' => 'No errors',
      'utf8' => 'Should be UTF-8 encoded',
      'duplicatesRemoved' => 'Duplicates removed',
      'inIdle' => 'Execute in idle (for big data; via cron)',
      'revert' => 'This will remove all imported records permanently.',
      'removeDuplicates' => 'This will permanently remove all imported records that were recognized as duplicates.',
      'confirmRevert' => 'This will remove all imported records permanently. Are you sure?',
      'confirmRemoveDuplicates' => 'This will permanently remove all imported records that were recognized as duplicates. Are you sure?',
      'confirmRemoveImportLog' => 'This will remove the import log. All imported records will be kept. You won\'t be able to revert import results. Are you sure?',
      'removeImportLog' => 'This will remove the import log. All imported records will be kept. Use it if you are sure that import is fine.'
    ],
    'params' => [
      'phoneNumberCountry' => 'Telephone country code'
    ],
    'fields' => [
      'file' => 'File',
      'entityType' => 'Entity Type',
      'imported' => 'Imported Records',
      'duplicates' => 'Duplicate Records',
      'updated' => 'Updated Records',
      'status' => 'Status'
    ],
    'links' => [
      'errors' => 'Errors'
    ],
    'options' => [
      'status' => [
        'Failed' => 'Failed',
        'Standby' => 'Standby',
        'Pending' => 'Pending',
        'In Process' => 'In Process',
        'Complete' => 'Complete'
      ],
      'personNameFormat' => [
        'f l' => 'First Last',
        'l f' => 'Last First',
        'f m l' => 'First Middle Last',
        'l f m' => 'Last First Middle',
        'l, f' => 'Last, First'
      ]
    ],
    'strings' => [
      'commandToRun' => 'Command to run (from CLI)',
      'saveAsDefault' => 'Save as default'
    ],
    'tooltips' => [
      'manualMode' => 'If checked, you will need to run import manually from CLI. Command will be shown after setting up the import.',
      'silentMode' => 'A majority of after-save scripts will be skipped, stream notes won\'t be created. Import will run faster.'
    ]
  ],
  'ImportError' => [
    'fields' => [
      'type' => 'Type',
      'validationFailures' => 'Validation Failures',
      'import' => 'Import',
      'rowIndex' => 'Row Index',
      'exportRowIndex' => 'Export Row Index',
      'lineNumber' => 'Line Number',
      'exportLineNumber' => 'Export Line Number',
      'row' => 'Row',
      'entityType' => 'Entity Type'
    ],
    'options' => [
      'type' => [
        'Validation' => 'Validation',
        'Access' => 'Access',
        'Not-Found' => 'Not-Found'
      ]
    ],
    'tooltips' => [
      'lineNumber' => 'A line number in the original CSV.',
      'exportLineNumber' => 'A line number in the export CSV.'
    ]
  ],
  'InboundEmail' => [
    'fields' => [
      'name' => 'Name',
      'emailAddress' => 'Email Address',
      'team' => 'Target Team',
      'status' => 'Status',
      'assignToUser' => 'Assign to User',
      'host' => 'Host',
      'username' => 'Username',
      'password' => 'Password',
      'port' => 'Port',
      'monitoredFolders' => 'Monitored Folders',
      'trashFolder' => 'Trash Folder',
      'security' => 'Security',
      'createCase' => 'Create Case',
      'reply' => 'Auto-Reply',
      'caseDistribution' => 'Case Distribution',
      'replyEmailTemplate' => 'Reply Email Template',
      'replyFromAddress' => 'Reply From Address',
      'replyToAddress' => 'Reply To Address',
      'replyFromName' => 'Reply From Name',
      'targetUserPosition' => 'Target User Position',
      'fetchSince' => 'Fetch Since',
      'addAllTeamUsers' => 'For all team users',
      'teams' => 'Teams',
      'sentFolder' => 'Sent Folder',
      'storeSentEmails' => 'Store Sent Emails',
      'keepFetchedEmailsUnread' => 'Keep Fetched Emails Unread',
      'connectedAt' => 'Connected At',
      'excludeFromReply' => 'Exclude from Reply',
      'useImap' => 'Fetch Emails',
      'useSmtp' => 'Use SMTP',
      'smtpHost' => 'SMTP Host',
      'smtpPort' => 'SMTP Port',
      'smtpAuth' => 'SMTP Auth',
      'smtpSecurity' => 'SMTP Security',
      'smtpAuthMechanism' => 'SMTP Auth Mechanism',
      'smtpUsername' => 'SMTP Username',
      'smtpPassword' => 'SMTP Password',
      'fromName' => 'From Name',
      'smtpIsShared' => 'SMTP Is Shared',
      'smtpIsForMassEmail' => 'SMTP Is for Mass Email',
      'groupEmailFolder' => 'Group Email Folder',
      'isSystem' => 'Is System'
    ],
    'tooltips' => [
      'isSystem' => 'Is the system email account.',
      'useSmtp' => 'The ability to send emails.',
      'reply' => 'Notify email senders that their emails has been received.

 Only one email will be sent to a particular recipient during some period of time to prevent looping.',
      'createCase' => 'Automatically create case from incoming emails.',
      'replyToAddress' => 'Specify email address of this mailbox to make responses come here.',
      'caseDistribution' => 'How cases will be assigned to. Assigned directly to the user or among the team.',
      'assignToUser' => 'User cases will be assigned to.',
      'team' => 'Team cases will be assigned to.',
      'teams' => 'Teams emails will be assigned to.',
      'targetUserPosition' => 'Users with specified position will be distributed with cases.',
      'addAllTeamUsers' => 'Emails will be appearing in Inbox of all users of specified teams.',
      'monitoredFolders' => 'Multiple folders should be separated by comma.',
      'smtpIsShared' => 'If checked then users will be able to send emails using this SMTP. Availability is controlled by Roles through the Group Email Account permission.',
      'smtpIsForMassEmail' => 'If checked then SMTP will be available for Mass Email.',
      'storeSentEmails' => 'Sent emails will be stored on the IMAP server.',
      'groupEmailFolder' => 'Put incoming emails in a group folder.',
      'excludeFromReply' => 'When replying on emails sent to this account\'s email address, its email address won\'t be added to CC.

Note that by enabling this parameter, the email address of this account will be exposed to users who have access to send Emails.'
    ],
    'links' => [
      'filters' => 'Filters',
      'emails' => 'Emails',
      'assignToUser' => 'Assign to User',
      'groupEmailFolder' => 'Group Email Folder'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ],
      'caseDistribution' => [
        '' => 'None',
        'Direct-Assignment' => 'Direct-Assignment',
        'Round-Robin' => 'Round-Robin',
        'Least-Busy' => 'Least-Busy'
      ],
      'smtpAuthMechanism' => [
        'plain' => 'PLAIN',
        'login' => 'LOGIN',
        'crammd5' => 'CRAM-MD5'
      ]
    ],
    'labels' => [
      'Create InboundEmail' => 'Create Email Account',
      'IMAP' => 'IMAP',
      'Actions' => 'Actions',
      'Main' => 'Main'
    ],
    'messages' => [
      'couldNotConnectToImap' => 'Could not connect to IMAP server',
      'imapNotConnected' => 'Could not connect to group [IMAP account](#InboundEmail/view/{id}).'
    ]
  ],
  'Integration' => [
    'fields' => [
      'enabled' => 'Enabled',
      'clientId' => 'Client ID',
      'clientSecret' => 'Client Secret',
      'redirectUri' => 'Redirect URI',
      'apiKey' => 'API Key',
      'siteKey' => 'Site Key',
      'secretKey' => 'Secret Key',
      'scoreThreshold' => 'Score Threshold'
    ],
    'titles' => [
      'GoogleMaps' => 'Google Maps',
      'GoogleReCaptcha' => 'Google reCAPTCHA'
    ],
    'messages' => [
      'selectIntegration' => 'Select an integration from menu.',
      'noIntegrations' => 'No Integrations is available.'
    ],
    'help' => [
      'GoogleReCaptcha' => 'Obtain the Site Key and Secret Key from [Google](https://www.google.com/recaptcha/).',
      'Google' => '**Obtain OAuth 2.0 credentials from the Google Developers Console.**

Visit [Google Developers Console](https://console.developers.google.com/project) to obtain OAuth 2.0 credentials such as a Client ID and Client Secret that are known to both Google and TD SYNNEX MCA application.',
      'GoogleMaps' => 'Obtain API key [here](https://developers.google.com/maps/documentation/javascript/get-api-key).'
    ]
  ],
  'Job' => [
    'fields' => [
      'status' => 'Status',
      'executeTime' => 'Execute At',
      'executedAt' => 'Executed At',
      'startedAt' => 'Started At',
      'attempts' => 'Attempts Left',
      'failedAttempts' => 'Failed Attempts',
      'serviceName' => 'Service',
      'method' => 'Method (deprecated)',
      'methodName' => 'Method',
      'scheduledJob' => 'Scheduled Job',
      'scheduledJobJob' => 'Scheduled Job Name',
      'data' => 'Data',
      'targetType' => 'Target Type',
      'targetId' => 'Target ID',
      'number' => 'Number',
      'queue' => 'Queue',
      'group' => 'Group',
      'className' => 'Class Name',
      'targetGroup' => 'Target Group',
      'job' => 'Job'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pending',
        'Success' => 'Success',
        'Running' => 'Running',
        'Failed' => 'Failed'
      ]
    ]
  ],
  'LayoutManager' => [
    'fields' => [
      'width' => 'Width',
      'link' => 'Link',
      'notSortable' => 'Not Sortable',
      'align' => 'Align',
      'panelName' => 'Panel Name',
      'style' => 'Style',
      'sticked' => 'Stick to top',
      'isMuted' => 'Muted color',
      'isLarge' => 'Large font size',
      'hidden' => 'Hidden',
      'noLabel' => 'No Label',
      'dynamicLogicVisible' => 'Conditions making panel visible',
      'dynamicLogicStyled' => 'Conditions making style applied',
      'tabLabel' => 'Tab Label',
      'tabBreak' => 'Tab-Break',
      'noteText' => 'Note Text',
      'noteStyle' => 'Note Style'
    ],
    'options' => [
      'align' => [
        'left' => 'Left',
        'right' => 'Right'
      ],
      'style' => [
        'default' => 'Default',
        'success' => 'Success',
        'danger' => 'Danger',
        'info' => 'Info',
        'warning' => 'Warning',
        'primary' => 'Primary'
      ]
    ],
    'labels' => [
      'New panel' => 'New panel',
      'Layout' => 'Layout'
    ],
    'messages' => [
      'alreadyExists' => 'Layout `{name}` already exists.',
      'createInfo' => 'Custom list layouts can be used by relationship panels.',
      'cantBeEmpty' => 'Layout can\'t be empty.',
      'fieldsIncompatible' => 'Fields can\'t be on the layout together: {fields}.'
    ],
    'tooltips' => [
      'noteText' => 'A text to be displayed in the panel. Markdown is supported.',
      'tabBreak' => 'A separate tab for the panel and all following panels until the next tab-break.',
      'noLabel' => 'Don\'t display a column label in the header.',
      'notSortable' => 'Disables the ability to sort by the column.',
      'width' => 'A column width. It\'s recommended to have one column without specified width, usually it should be the *Name* field.',
      'sticked' => 'The panel will be sticked to the panel above. No gap between panels.',
      'hiddenPanel' => 'Need to click \'show more\' to see the panel.',
      'panelStyle' => 'A color of the panel.',
      'dynamicLogicVisible' => 'If set, the panel will be hidden unless the condition is met.',
      'dynamicLogicStyled' => 'A color will be applied if a specific condition is met . The color is defined by the *Style* parameter.',
      'link' => 'If checked, then a field value will be displayed as a link pointing to the detail view of the record. Usually it is used for *Name* fields.'
    ]
  ],
  'LayoutSet' => [
    'fields' => [
      'layoutList' => 'Layouts'
    ],
    'labels' => [
      'Create LayoutSet' => 'Create Layout Set',
      'Edit Layouts' => 'Edit Layouts'
    ],
    'tooltips' => []
  ],
  'LeadCapture' => [
    'fields' => [
      'name' => 'Name',
      'campaign' => 'Campaign',
      'isActive' => 'Is Active',
      'subscribeToTargetList' => 'Subscribe to Target List',
      'subscribeContactToTargetList' => 'Subscribe Contact if exists',
      'targetList' => 'Target List',
      'fieldList' => 'Payload Fields',
      'optInConfirmation' => 'Double Opt-In',
      'optInConfirmationEmailTemplate' => 'Opt-in confirmation email template',
      'optInConfirmationLifetime' => 'Opt-in confirmation lifetime (hours)',
      'optInConfirmationSuccessMessage' => 'Text to show after opt-in confirmation',
      'leadSource' => 'Lead Source',
      'apiKey' => 'API Key',
      'targetTeam' => 'Target Team',
      'exampleRequestMethod' => 'Method',
      'exampleRequestUrl' => 'URL',
      'exampleRequestPayload' => 'Payload',
      'exampleRequestHeaders' => 'Headers',
      'createLeadBeforeOptInConfirmation' => 'Create Lead before confirmation',
      'skipOptInConfirmationIfSubscribed' => 'Skip confirmation if lead is already in target list',
      'smtpAccount' => 'SMTP Account',
      'inboundEmail' => 'Group Email Account',
      'duplicateCheck' => 'Duplicate Check',
      'phoneNumberCountry' => 'Telephone country code',
      'fieldParams' => 'Field Params',
      'formId' => 'Form ID',
      'formEnabled' => 'Web Form',
      'formUrl' => 'Form URL',
      'formSuccessText' => 'Text to display after form submission',
      'formText' => 'Text to display on form',
      'formSuccessRedirectUrl' => 'URL to redirect to after form submission',
      'formLanguage' => 'Language used on form',
      'formFrameAncestors' => 'Allowed hosts for form embedding',
      'formCaptcha' => 'Use Captcha'
    ],
    'links' => [
      'targetList' => 'Target List',
      'campaign' => 'Campaign',
      'optInConfirmationEmailTemplate' => 'Opt-in confirmation email template',
      'targetTeam' => 'Target Team',
      'inboundEmail' => 'Group Email Account',
      'logRecords' => 'Log'
    ],
    'labels' => [
      'Create LeadCapture' => 'Create Entry Point',
      'Generate New API Key' => 'Generate New API Key',
      'Request' => 'Request',
      'Confirm Opt-In' => 'Confirm Opt-In',
      'Generate New Form ID' => 'Generate New Form ID',
      'Web Form' => 'Web Form'
    ],
    'messages' => [
      'generateApiKey' => 'Create new API Key',
      'optInConfirmationExpired' => 'Opt-in confirmation link is expired.',
      'optInIsConfirmed' => 'Opt-in is confirmed.'
    ],
    'tooltips' => [
      'formCaptcha' => 'To be able to use Captcha, you need to configure it under **Administration** > **Integrations**.',
      'optInConfirmationSuccessMessage' => 'Markdown is supported.'
    ]
  ],
  'LeadCaptureLogRecord' => [
    'fields' => [
      'number' => 'Number',
      'data' => 'Data',
      'target' => 'Target',
      'leadCapture' => 'Lead Capture',
      'createdAt' => 'Entered At',
      'isCreated' => 'Is Lead Created'
    ],
    'links' => [
      'leadCapture' => 'Lead Capture',
      'target' => 'Target'
    ]
  ],
  'MassAction' => [
    'fields' => [
      'status' => 'Status',
      'processedCount' => 'Processed Count'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pending',
        'Running' => 'Running',
        'Success' => 'Success',
        'Failed' => 'Failed'
      ]
    ],
    'messages' => [
      'infoText' => 'The mass action is being processed in idle by cron. It can take some time to finish. Closing this modal dialog won\'t affect the execution process.'
    ]
  ],
  'Note' => [
    'fields' => [
      'post' => 'Post',
      'attachments' => 'Attachments',
      'targetType' => 'Target',
      'teams' => 'Teams',
      'users' => 'Users',
      'portals' => 'Portals',
      'type' => 'Type',
      'isGlobal' => 'Is Global',
      'isInternal' => 'Is Internal (for internal users)',
      'isPinned' => 'Is Pinned',
      'related' => 'Related',
      'createdByGender' => 'Created By Gender',
      'data' => 'Data',
      'number' => 'Number'
    ],
    'filters' => [
      'all' => 'All',
      'posts' => 'Posts',
      'updates' => 'Updates',
      'activity' => 'Activity'
    ],
    'options' => [
      'targetType' => [
        'self' => 'to myself',
        'users' => 'to particular user(s)',
        'teams' => 'to particular team(s)',
        'all' => 'to all internal users',
        'portals' => 'to portal users'
      ],
      'type' => [
        'Post' => 'Post',
        'Create' => 'Create',
        'CreateRelated' => 'Create Related',
        'Update' => 'Update',
        'Status' => 'Status',
        'Assign' => 'Assign',
        'Relate' => 'Relate',
        'Unrelate' => 'Unrelate',
        'EmailReceived' => 'Email Received',
        'EmailSent' => 'Email Sent'
      ]
    ],
    'labels' => [
      'View Posts' => 'View Posts',
      'View Activity' => 'View Activity',
      'Pin' => 'Pin',
      'Unpin' => 'Unpin',
      'Pinned' => 'Pinned',
      'Quote Reply' => 'Quote Reply'
    ],
    'messages' => [
      'writeMessage' => 'Write your message here',
      'pinnedMaxCountExceeded' => 'Cannot pin more notes. Max allowed number is {count}.'
    ],
    'links' => [
      'portals' => 'Portals',
      'attachments' => 'Attachments',
      'superParent' => 'Super Parent',
      'related' => 'Related'
    ]
  ],
  'PhoneNumber' => [
    'fields' => [
      'type' => 'Type',
      'optOut' => 'Opted Out',
      'invalid' => 'Invalid',
      'numeric' => 'Numeric Value'
    ],
    'presetFilters' => [
      'orphan' => 'Orphan'
    ]
  ],
  'Portal' => [
    'fields' => [
      'name' => 'Name',
      'logo' => 'Logo',
      'url' => 'URL',
      'portalRoles' => 'Roles',
      'isActive' => 'Is Active',
      'isDefault' => 'Is Default',
      'tabList' => 'Tab List',
      'applicationName' => 'Application Name',
      'quickCreateList' => 'Quick Create List',
      'companyLogo' => 'Logo',
      'theme' => 'Theme',
      'language' => 'Language',
      'dashboardLayout' => 'Dashboard Layout',
      'dateFormat' => 'Date Format',
      'timeFormat' => 'Time Format',
      'timeZone' => 'Time Zone',
      'weekStart' => 'First Day of Week',
      'defaultCurrency' => 'Default Currency',
      'layoutSet' => 'Layout Set',
      'authenticationProvider' => 'Authentication Provider',
      'customUrl' => 'Custom URL',
      'customId' => 'Custom ID',
      'authTokenLifetime' => 'Auth Token Lifetime (hours)',
      'authTokenMaxIdleTime' => 'Auth Token Max Idle Time (hours)'
    ],
    'links' => [
      'users' => 'Users',
      'portalRoles' => 'Roles',
      'layoutSet' => 'Layout Set',
      'authenticationProvider' => 'Authentication Provider',
      'notes' => 'Notes',
      'articles' => 'Knowledge Base Articles'
    ],
    'tooltips' => [
      'layoutSet' => 'Provides the ability to have layouts that differ from standard ones.',
      'portalRoles' => 'Specified Portal Roles will be applied to all users of this portal.'
    ],
    'labels' => [
      'Create Portal' => 'Create Portal',
      'User Interface' => 'User Interface',
      'General' => 'General',
      'Settings' => 'Settings'
    ]
  ],
  'PortalRole' => [
    'fields' => [
      'exportPermission' => 'Export Permission',
      'massUpdatePermission' => 'Mass Update Permission',
      'data' => 'Data',
      'fieldData' => 'Field Data'
    ],
    'links' => [
      'users' => 'Users'
    ],
    'labels' => [
      'Access' => 'Access',
      'Create PortalRole' => 'Create Portal Role',
      'Scope Level' => 'Scope Level',
      'Field Level' => 'Field Level'
    ]
  ],
  'PortalUser' => [
    'labels' => [
      'Create PortalUser' => 'Create Portal User'
    ]
  ],
  'Preferences' => [
    'fields' => [
      'dateFormat' => 'Date Format',
      'timeFormat' => 'Time Format',
      'timeZone' => 'Time Zone',
      'weekStart' => 'First Day of Week',
      'thousandSeparator' => 'Thousand Separator',
      'decimalMark' => 'Decimal Mark',
      'defaultCurrency' => 'Default Currency',
      'currencyList' => 'Currency List',
      'language' => 'Language',
      'exportDelimiter' => 'Export Delimiter',
      'receiveAssignmentEmailNotifications' => 'Email notifications upon assignment',
      'receiveMentionEmailNotifications' => 'Email notifications about mentions in posts',
      'receiveStreamEmailNotifications' => 'Email notifications about posts and status updates',
      'assignmentNotificationsIgnoreEntityTypeList' => 'In-app assignment notifications',
      'assignmentEmailNotificationsIgnoreEntityTypeList' => 'Email assignment notifications',
      'reactionNotifications' => 'In-app notifications about reactions',
      'autoFollowEntityTypeList' => 'Global Auto-Follow',
      'signature' => 'Email Signature',
      'dashboardTabList' => 'Tab List',
      'defaultReminders' => 'Default Reminders',
      'defaultRemindersTask' => 'Default Reminders for Tasks',
      'theme' => 'Theme',
      'useCustomTabList' => 'Custom Tab List',
      'addCustomTabs' => 'Add Custom Tabs',
      'tabList' => 'Tab List',
      'emailReplyToAllByDefault' => 'Email Reply to all by default',
      'dashboardLayout' => 'Dashboard Layout',
      'dashboardLocked' => 'Lock Dashboard',
      'emailReplyForceHtml' => 'Email Reply in HTML',
      'doNotFillAssignedUserIfNotRequired' => 'Do not pre-fill assigned user on record creation',
      'followEntityOnStreamPost' => 'Auto-follow record after posting in Stream',
      'followCreatedEntities' => 'Auto-follow created records',
      'followCreatedEntityTypeList' => 'Auto-follow created records of specific entity types',
      'emailUseExternalClient' => 'Use an external email client',
      'textSearchStoringDisabled' => 'Disable text filter storing',
      'calendarSlotDuration' => 'Calendar Slot Duration',
      'calendarScrollHour' => 'Calendar Scroll to Hour'
    ],
    'links' => [],
    'options' => [
      'weekStart' => [
        0 => 'Sunday',
        1 => 'Monday'
      ]
    ],
    'labels' => [
      'Notifications' => 'Notifications',
      'User Interface' => 'User Interface',
      'Misc' => 'Misc',
      'Locale' => 'Locale',
      'Reset Dashboard to Default' => 'Reset Dashboard to Default'
    ],
    'tooltips' => [
      'addCustomTabs' => 'If checked, custom tabs will be appended to default tabs. Otherwise, custom tabs will be used instead of default tabs.',
      'autoFollowEntityTypeList' => 'Automatically follow ALL new records (created by any user) of the selected entity types. To be able to see information in the stream and receive notifications about all records in the system.',
      'doNotFillAssignedUserIfNotRequired' => 'When create record assigned user won\'t be filled with own user unless the field is required.',
      'followCreatedEntities' => 'When create new records, they will be automatically followed even if assigned to another user.',
      'followCreatedEntityTypeList' => 'When create new records of selected entity types, they will be followed automatically even if assigned to another user.'
    ],
    'tabFields' => [
      'label' => 'Label',
      'iconClass' => 'Icon',
      'color' => 'Color'
    ]
  ],
  'Role' => [
    'fields' => [
      'name' => 'Name',
      'roles' => 'Roles',
      'assignmentPermission' => 'Assignment Permission',
      'userPermission' => 'User Permission',
      'messagePermission' => 'Message Permission',
      'portalPermission' => 'Portal Permission',
      'groupEmailAccountPermission' => 'Group Email Account Permission',
      'exportPermission' => 'Export Permission',
      'massUpdatePermission' => 'Mass Update Permission',
      'followerManagementPermission' => 'Follower Management Permission',
      'dataPrivacyPermission' => 'Data Privacy Permission',
      'auditPermission' => 'Audit Permission',
      'mentionPermission' => 'Mention Permission',
      'userCalendarPermission' => 'User Calendar Permission',
      'data' => 'Data',
      'fieldData' => 'Field Data'
    ],
    'links' => [
      'users' => 'Users',
      'teams' => 'Teams'
    ],
    'tooltips' => [
      'messagePermission' => 'Allows to send messages to other users.

* all – can send to all
* team – can send only to teammates
* no – cannot send',
      'assignmentPermission' => 'Allows to assign records to other users.

* all – no restriction
* team – can assign only to teammates
* no – can assign only to self',
      'userPermission' => 'Allows to view stream of other users. Allows users to view the access levels other users have for specific records.',
      'userCalendarPermission' => 'Allows to view calendars of other users.',
      'portalPermission' => 'Access to portal information, the ability to post messages to portal users.',
      'groupEmailAccountPermission' => 'Access to group email accounts, the ability to send emails from group SMTP.',
      'exportPermission' => 'Allows to export records.',
      'massUpdatePermission' => 'The ability to perform mass update of records.',
      'followerManagementPermission' => 'Allows to manage followers of specific records.',
      'dataPrivacyPermission' => 'Allows to view and erase personal data.',
      'auditPermission' => 'Allows to view the audit log.',
      'mentionPermission' => 'Allows to mention other users in the Stream.

* all – can mention all
* team – can mention only teammates
* no – cannot mention'
    ],
    'labels' => [
      'Access' => 'Access',
      'Create Role' => 'Create Role',
      'Scope Level' => 'Scope Level',
      'Field Level' => 'Field Level'
    ],
    'options' => [
      'accessList' => [
        'not-set' => 'not-set',
        'enabled' => 'enabled',
        'disabled' => 'disabled'
      ],
      'levelList' => [
        'all' => 'all',
        'team' => 'team',
        'account' => 'account',
        'contact' => 'contact',
        'own' => 'own',
        'no' => 'no',
        'yes' => 'yes',
        'not-set' => 'not-set'
      ]
    ],
    'actions' => [
      'read' => 'Read',
      'edit' => 'Edit',
      'delete' => 'Delete',
      'stream' => 'Stream',
      'create' => 'Create'
    ],
    'messages' => [
      'changesAfterClearCache' => 'All changes in an access control will be applied after cache is cleared.'
    ]
  ],
  'ScheduledJob' => [
    'fields' => [
      'name' => 'Name',
      'status' => 'Status',
      'job' => 'Job',
      'scheduling' => 'Scheduling'
    ],
    'links' => [
      'log' => 'Log'
    ],
    'labels' => [
      'As often as possible' => 'As often as possible',
      'Create ScheduledJob' => 'Create Scheduled Job'
    ],
    'options' => [
      'job' => [
        'Cleanup' => 'Clean-up',
        'CheckInboundEmails' => 'Check Group Email Accounts',
        'CheckEmailAccounts' => 'Check Personal Email Accounts',
        'SendEmailReminders' => 'Send Email Reminders',
        'AuthTokenControl' => 'Auth Token Control',
        'SendEmailNotifications' => 'Send Email Notifications',
        'CheckNewVersion' => 'Check for New Version',
        'ProcessWebhookQueue' => 'Process Webhook Queue',
        'SendScheduledEmails' => 'Send Scheduled Emails',
        'ProcessMassEmail' => 'Send Mass Emails',
        'ControlKnowledgeBaseArticleStatus' => 'Control Knowledge Base Article Status',
        'ReportTargetListSync' => 'Sync Target Lists with Reports',
        'ScheduleReportSending' => 'Schedule Report Sending',
        'RunScheduledWorkflows' => 'Run Scheduled Workflows',
        'ProcessPendingProcessFlows' => 'Process Pending Flows',
        'InventoryCompress' => 'Inventory Transaction Compress',
        'NotActualOrderLocking' => 'Lock Not Actual Orders',
        'InventoryDetach' => 'Inventory Transaction Detaching'
      ],
      'cronSetup' => [
        'linux' => 'Note: Add this line to the crontab file to run Espo Scheduled Jobs:',
        'mac' => 'Note: Add this line to the crontab file to run Espo Scheduled Jobs:',
        'windows' => 'Note: Create a batch file with the following commands to run Espo Scheduled Jobs using Windows Scheduled Tasks:',
        'default' => 'Note: Add this command to Cron Job (Scheduled Task):'
      ],
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'tooltips' => [
      'scheduling' => 'Crontab notation. Defines frequency of job runs.

`*/5 * * * *` - every 5 minutes

`0 */2 * * *` - every 2 hours

`30 1 * * *` - at 01:30 once a day

`0 0 1 * *` - on the first day of the month'
    ]
  ],
  'ScheduledJobLogRecord' => [
    'fields' => [
      'status' => 'Status',
      'executionTime' => 'Execution Time',
      'target' => 'Target'
    ]
  ],
  'Settings' => [
    'fields' => [
      'useCache' => 'Use Cache',
      'dateFormat' => 'Date Format',
      'timeFormat' => 'Time Format',
      'timeZone' => 'Time Zone',
      'weekStart' => 'First Day of Week',
      'thousandSeparator' => 'Thousand Separator',
      'decimalMark' => 'Decimal Mark',
      'defaultCurrency' => 'Default Currency',
      'baseCurrency' => 'Base Currency',
      'currencyRates' => 'Rate Values',
      'currencyList' => 'Currency List',
      'language' => 'Language',
      'companyLogo' => 'Company Logo',
      'smsProvider' => 'SMS Provider',
      'outboundSmsFromNumber' => 'SMS From Number',
      'smtpServer' => 'Server',
      'smtpPort' => 'Port',
      'smtpAuth' => 'Auth',
      'smtpSecurity' => 'Security',
      'smtpUsername' => 'Username',
      'emailAddress' => 'Email',
      'smtpPassword' => 'Password',
      'outboundEmailFromName' => 'From Name',
      'outboundEmailFromAddress' => 'From Address',
      'outboundEmailIsShared' => 'Is Shared',
      'emailAddressLookupEntityTypeList' => 'Email address look-up scopes',
      'emailAddressSelectEntityTypeList' => 'Email address select scopes',
      'recordsPerPage' => 'Records Per Page',
      'recordsPerPageSmall' => 'Records Per Page (Small)',
      'recordsPerPageSelect' => 'Records Per Page (Select)',
      'recordsPerPageKanban' => 'Records Per Page (Kanban)',
      'tabList' => 'Tab List',
      'quickCreateList' => 'Quick Create List',
      'exportDelimiter' => 'Export Delimiter',
      'globalSearchEntityList' => 'Global Search Entity List',
      'authenticationMethod' => 'Authentication Method',
      'ldapHost' => 'Host',
      'ldapPort' => 'Port',
      'ldapAuth' => 'Auth',
      'ldapUsername' => 'Full User DN',
      'ldapPassword' => 'Password',
      'ldapBindRequiresDn' => 'Bind Requires DN',
      'ldapBaseDn' => 'Base DN',
      'ldapAccountCanonicalForm' => 'Account Canonical Form',
      'ldapAccountDomainName' => 'Account Domain Name',
      'ldapTryUsernameSplit' => 'Try Username Split',
      'ldapPortalUserLdapAuth' => 'Use LDAP Authentication for Portal Users',
      'ldapCreateEspoUser' => 'Create User in TD SYNNEX MCA',
      'ldapSecurity' => 'Security',
      'ldapUserLoginFilter' => 'User Login Filter',
      'ldapAccountDomainNameShort' => 'Account Domain Name Short',
      'ldapOptReferrals' => 'Opt Referrals',
      'ldapUserNameAttribute' => 'Username Attribute',
      'ldapUserObjectClass' => 'User ObjectClass',
      'ldapUserTitleAttribute' => 'User Title Attribute',
      'ldapUserFirstNameAttribute' => 'User First Name Attribute',
      'ldapUserLastNameAttribute' => 'User Last Name Attribute',
      'ldapUserEmailAddressAttribute' => 'User Email Address Attribute',
      'ldapUserTeams' => 'User Teams',
      'ldapUserDefaultTeam' => 'User Default Team',
      'ldapUserPhoneNumberAttribute' => 'User Phone Number Attribute',
      'ldapPortalUserPortals' => 'Default Portals for a Portal User',
      'ldapPortalUserRoles' => 'Default Roles for a Portal User',
      'exportDisabled' => 'Disable Export (only admin is allowed)',
      'assignmentNotificationsEntityList' => 'Entities to notify about upon assignment',
      'assignmentEmailNotifications' => 'Notifications upon assignment',
      'assignmentEmailNotificationsEntityList' => 'Assignment email notifications scopes',
      'streamEmailNotifications' => 'Notifications about updates in Stream for internal users',
      'portalStreamEmailNotifications' => 'Notifications about updates in Stream for portal users',
      'streamEmailNotificationsEntityList' => 'Stream email notifications scopes',
      'streamEmailNotificationsTypeList' => 'What to notify about',
      'streamEmailWithContentEntityTypeList' => 'Entities with email body in stream notes',
      'emailNotificationsDelay' => 'Delay of email notifications (in seconds)',
      'b2cMode' => 'B2C Mode',
      'avatarsDisabled' => 'Disable Avatars',
      'followCreatedEntities' => 'Follow created records',
      'displayListViewRecordCount' => 'Display Total Count (on List View)',
      'theme' => 'Theme',
      'userThemesDisabled' => 'Disable User Themes',
      'attachmentUploadMaxSize' => 'Upload Max Size (Mb)',
      'attachmentUploadChunkSize' => 'Upload Chunk Size (Mb)',
      'emailMessageMaxSize' => 'Email Max Size (Mb)',
      'massEmailMaxPerHourCount' => 'Max number of emails sent per hour',
      'massEmailMaxPerBatchCount' => 'Max number of emails sent per batch',
      'personalEmailMaxPortionSize' => 'Max email portion size for personal account fetching',
      'inboundEmailMaxPortionSize' => 'Max email portion size for group account fetching',
      'maxEmailAccountCount' => 'Max number of personal email accounts per user',
      'emailScheduledBatchCount' => 'Max number of scheduled emails sent per batch',
      'authTokenLifetime' => 'Auth Token Lifetime (hours)',
      'authTokenMaxIdleTime' => 'Auth Token Max Idle Time (hours)',
      'dashboardLayout' => 'Dashboard Layout (default)',
      'siteUrl' => 'Site URL',
      'addressPreview' => 'Address Preview',
      'addressFormat' => 'Address Format',
      'personNameFormat' => 'Person Name Format',
      'notificationSoundsDisabled' => 'Disable Notification Sounds',
      'newNotificationCountInTitle' => 'Display new notification number in page title',
      'applicationName' => 'Application Name',
      'calendarEntityList' => 'Calendar Entity List',
      'busyRangesEntityList' => 'Free/Busy Entity List',
      'mentionEmailNotifications' => 'Send email notifications about mentions in posts',
      'massEmailDisableMandatoryOptOutLink' => 'Disable mandatory opt-out link',
      'massEmailOpenTracking' => 'Email Open Tracking',
      'massEmailVerp' => 'Use VERP',
      'activitiesEntityList' => 'Activities Entity List',
      'historyEntityList' => 'History Entity List',
      'currencyFormat' => 'Currency Format',
      'currencyDecimalPlaces' => 'Currency Decimal Places',
      'aclAllowDeleteCreated' => 'Allow to remove created records',
      'adminNotifications' => 'System notifications in administration panel',
      'adminNotificationsNewVersion' => 'Show notification when new TD SYNNEX MCA version is available',
      'adminNotificationsNewExtensionVersion' => 'Show notification when new versions of extensions are available',
      'textFilterUseContainsForVarchar' => 'Use \'contains\' operator when filtering varchar fields',
      'phoneNumberNumericSearch' => 'Numeric phone number search',
      'phoneNumberInternational' => 'International phone numbers',
      'phoneNumberExtensions' => 'Phone number extensions',
      'phoneNumberPreferredCountryList' => 'Preferred telephone country codes',
      'authTokenPreventConcurrent' => 'Only one auth token per user',
      'scopeColorsDisabled' => 'Disable scope colors',
      'tabColorsDisabled' => 'Disable tab colors',
      'tabIconsDisabled' => 'Disable tab icons',
      'emailAddressIsOptedOutByDefault' => 'Mark new email addresses as opted-out',
      'outboundEmailBccAddress' => 'BCC address for external clients',
      'cleanupDeletedRecords' => 'Clean up deleted records',
      'addressCityList' => 'Address City Autocomplete List',
      'addressStateList' => 'Address State Autocomplete List',
      'fiscalYearShift' => 'Fiscal Year Start',
      'jobRunInParallel' => 'Jobs Run in Parallel',
      'jobMaxPortion' => 'Jobs Max Portion',
      'jobPoolConcurrencyNumber' => 'Jobs Pool Concurrency Number',
      'jobForceUtc' => 'Force UTC Time Zone',
      'daemonInterval' => 'Daemon Interval',
      'daemonMaxProcessNumber' => 'Daemon Max Process Number',
      'daemonProcessTimeout' => 'Daemon Process Timeout',
      'cronDisabled' => 'Disable Cron',
      'maintenanceMode' => 'Maintenance Mode',
      'useWebSocket' => 'Use WebSocket',
      'passwordRecoveryDisabled' => 'Disable password recovery',
      'passwordRecoveryForAdminDisabled' => 'Disable password recovery for admin users',
      'passwordRecoveryForInternalUsersDisabled' => 'Disable password recovery for internal users',
      'passwordRecoveryNoExposure' => 'Prevent email address exposure on password recovery form',
      'passwordGenerateLength' => 'Length of generated passwords',
      'passwordStrengthLength' => 'Minimum password length',
      'passwordStrengthLetterCount' => 'Number of letters required in password',
      'passwordStrengthNumberCount' => 'Number of digits required in password',
      'passwordStrengthBothCases' => 'Password must contain letters of both upper and lower case',
      'passwordStrengthSpecialCharacterCount' => 'Number of special character required in password',
      'auth2FA' => 'Enable 2-Factor Authentication',
      'auth2FAForced' => 'Force regular users to set up 2FA',
      'auth2FAMethodList' => 'Available 2FA methods',
      'auth2FAInPortal' => 'Allow 2FA in portals',
      'workingTimeCalendar' => 'Working Time Calendar',
      'oidcClientId' => 'OIDC Client ID',
      'oidcClientSecret' => 'OIDC Client Secret',
      'oidcAuthorizationRedirectUri' => 'OIDC Authorization Redirect URI',
      'oidcAuthorizationEndpoint' => 'OIDC Authorization Endpoint',
      'oidcTokenEndpoint' => 'OIDC Token Endpoint',
      'oidcJwksEndpoint' => 'OIDC JSON Web Key Set Endpoint',
      'oidcJwtSignatureAlgorithmList' => 'OIDC JWT Allowed Signature Algorithms',
      'oidcScopes' => 'OIDC Scopes',
      'oidcGroupClaim' => 'OIDC Group Claim',
      'oidcCreateUser' => 'OIDC Create User',
      'oidcUsernameClaim' => 'OIDC Username Claim',
      'oidcTeams' => 'OIDC Teams',
      'oidcSync' => 'OIDC Sync',
      'oidcSyncTeams' => 'OIDC Sync Teams',
      'oidcFallback' => 'OIDC Fallback Login',
      'oidcAllowRegularUserFallback' => 'OIDC Allow fallback login for regular users',
      'oidcAllowAdminUser' => 'OIDC Allow OIDC login for admin users',
      'oidcLogoutUrl' => 'OIDC Logout URL',
      'oidcAuthorizationPrompt' => 'OIDC Authorization Prompt',
      'pdfEngine' => 'PDF Engine',
      'quickSearchFullTextAppendWildcard' => 'Append wildcard in quick search',
      'authIpAddressCheck' => 'Restrict access by IP address',
      'authIpAddressWhitelist' => 'IP Address Whitelist',
      'authIpAddressCheckExcludedUsers' => 'Users excluded from check',
      'availableReactions' => 'Available Reactions',
      'priceBooksEnabled' => 'Price Books',
      'defaultPriceBook' => 'Default Price Book',
      'inventoryTransactionsEnabled' => 'Inventory Transactions',
      'warehousesEnabled' => 'Warehouses',
      'deliveryOrdersEnabled' => 'Delivery Orders',
      'receiptOrdersEnabled' => 'Receipt Orders',
      'eInvoiceFormat' => 'Default Format',
      'sellerCompanyName' => 'Company Name',
      'sellerElectronicAddressScheme' => 'Electronic Address Scheme',
      'sellerElectronicAddressIdentifier' => 'Electronic Address Identifier',
      'sellerVatNumber' => 'VAT Number',
      'sellerTaxRegistrationScheme' => 'Tax Registration Scheme',
      'sellerTaxRegistrationIdentifier' => 'Tax Registration Identifier',
      'sellerAddress' => 'Company Address',
      'sellerContactName' => 'Contact Name',
      'sellerContactEmailAddress' => 'Contact Email Address',
      'sellerContactPhoneNumber' => 'Contact Phone Number',
      'salesForbidOrderUnlock' => 'Forbid order unlocking'
    ],
    'options' => [
      'authenticationMethod' => [
        'Oidc' => 'OIDC'
      ],
      'currencyFormat' => [
        1 => '10 USD',
        2 => '$10',
        3 => '10 $'
      ],
      'personNameFormat' => [
        'firstLast' => 'First Last',
        'lastFirst' => 'Last First',
        'firstMiddleLast' => 'First Middle Last',
        'lastFirstMiddle' => 'Last First Middle'
      ],
      'streamEmailNotificationsTypeList' => [
        'Post' => 'Posts',
        'Status' => 'Status updates',
        'EmailReceived' => 'Received emails'
      ],
      'auth2FAMethodList' => [
        'Totp' => 'TOTP',
        'Email' => 'Email',
        'Sms' => 'SMS'
      ]
    ],
    'tooltips' => [
      'authIpAddressCheckExcludedUsers' => 'Users that will be able to log in regardless whether their IP address is in the whitelist.',
      'authIpAddressWhitelist' => 'A list of IP addresses or ranges in CIDR notation.

Portals are not affected by restriction.',
      'workingTimeCalendar' => 'A working time calendar that will be applied to all users by default.',
      'displayListViewRecordCount' => 'A total number of records will be shown on the list view.',
      'currencyList' => 'What currencies will be available in the system.',
      'activitiesEntityList' => 'What records will be available in the Activities panel.',
      'historyEntityList' => 'What records will be available in the History panel.',
      'calendarEntityList' => 'What records will be available in the Calendar.',
      'addressStateList' => 'State suggestions for address fields.',
      'addressCityList' => 'City suggestions for address fields.',
      'addressCountryList' => 'Country suggestions for address fields.',
      'exportDisabled' => 'Users won\'t be able to export records. Only admin will be allowed.',
      'globalSearchEntityList' => 'What records can be searched with Global Search.',
      'siteUrl' => 'A URL of this TD SYNNEX MCA instance. You need to change it if you move to another domain.',
      'useCache' => 'Not recommended to disable, unless for development purpose.',
      'useWebSocket' => 'WebSocket enables two-way interactive communication between a server and a browser. Requires setting up the WebSocket daemon on your server. Check the documentation for more info.',
      'passwordRecoveryForInternalUsersDisabled' => 'Only portal users will be able to recover password.',
      'passwordRecoveryNoExposure' => 'It won\'t be possible to determine whether a specific email address is registered in the system.',
      'emailAddressLookupEntityTypeList' => 'For email address autocomplete.',
      'emailAddressSelectEntityTypeList' => 'Entity types available when searching for an email address from a modal.',
      'emailNotificationsDelay' => 'A message can be edited within the specified timeframe before the notification is sent.',
      'outboundEmailFromAddress' => 'The system email address.',
      'smtpServer' => 'If empty, then Group Email Account with the corresponding email address will be used.',
      'busyRangesEntityList' => 'What will be taken into account when showing busy time ranges in scheduler & timeline.',
      'massEmailVerp' => 'Variable envelope return path. For better handling of bounced messages. Make sure that your SMTP provider supports it.',
      'recordsPerPage' => 'Number of records initially displayed in list views.',
      'recordsPerPageSmall' => 'Number of records initially displayed in relationship panels.',
      'recordsPerPageSelect' => 'Number of records initially displayed when selecting records.',
      'recordsPerPageKanban' => 'Number of records initially displayed in kanban columns.',
      'outboundEmailIsShared' => 'Allow users to send emails from this address.',
      'followCreatedEntities' => 'Users will automatically follow records they created.',
      'emailMessageMaxSize' => 'All inbound emails exceeding a specified size will be fetched w/o body and attachments.',
      'authTokenLifetime' => 'Defines how long tokens can exist.
0 - means no expiration.',
      'authTokenMaxIdleTime' => 'Defines how long since the last access tokens can exist.
0 - means no expiration.',
      'userThemesDisabled' => 'If checked then users won\'t be able to select another theme.',
      'ldapUsername' => 'The full system user DN which allows to search other users. E.g. "CN=LDAP System User,OU=users,OU=espocrm, DC=test,DC=lan".',
      'ldapPassword' => 'The password to access to LDAP server.',
      'ldapAuth' => 'Access credentials for the LDAP server.',
      'ldapUserNameAttribute' => 'The attribute to identify the user. 
E.g. "userPrincipalName" or "sAMAccountName" for Active Directory, "uid" for OpenLDAP.',
      'ldapUserObjectClass' => 'ObjectClass attribute for searching users. E.g. "person" for AD, "inetOrgPerson" for OpenLDAP.',
      'ldapAccountCanonicalForm' => 'The type of your account canonical form. There are 4 options:

- \'Dn\' - the form in the format \'CN=tester,OU=espocrm,DC=test, DC=lan\'.

- \'Username\' - the form \'tester\'.

- \'Backslash\' - the form \'COMPANY\\tester\'.

- \'Principal\' - the form \'tester@company.com\'.',
      'ldapBindRequiresDn' => 'The option to format the username in the DN form.',
      'ldapBaseDn' => 'The default base DN used for searching users. E.g. "OU=users,OU=espocrm,DC=test, DC=lan".',
      'ldapTryUsernameSplit' => 'The option to split a username with the domain.',
      'ldapOptReferrals' => 'if referrals should be followed to the LDAP client.',
      'ldapPortalUserLdapAuth' => 'Allow portal users to use LDAP authentication instead of Espo authentication.',
      'ldapCreateEspoUser' => 'This option allows TD SYNNEX MCA to create a user from the LDAP.',
      'ldapUserFirstNameAttribute' => 'LDAP attribute which is used to determine the user first name. E.g. "givenname".',
      'ldapUserLastNameAttribute' => 'LDAP attribute which is used to determine the user last name. E.g. "sn".',
      'ldapUserTitleAttribute' => 'LDAP attribute which is used to determine the user title. E.g. "title".',
      'ldapUserEmailAddressAttribute' => 'LDAP attribute which is used to determine the user email address. E.g. "mail".',
      'ldapUserPhoneNumberAttribute' => 'LDAP attribute which is used to determine the user phone number. E.g. "telephoneNumber".',
      'ldapUserLoginFilter' => 'The filter which allows to restrict users who able to use TD SYNNEX MCA. E.g. "memberOf=CN=espoGroup, OU=groups,OU=espocrm, DC=test,DC=lan".',
      'ldapAccountDomainName' => 'The domain which is used for authorization to LDAP server.',
      'ldapAccountDomainNameShort' => 'The short domain which is used for authorization to LDAP server.',
      'ldapUserTeams' => 'Teams for created user. For more, see user profile.',
      'ldapUserDefaultTeam' => 'Default team for created user. For more, see user profile.',
      'ldapPortalUserPortals' => 'Default Portals for created Portal User',
      'ldapPortalUserRoles' => 'Default Roles for created Portal User',
      'b2cMode' => 'By default TD SYNNEX MCA is adapted for B2B. You can switch it to B2C.',
      'currencyDecimalPlaces' => 'Number of decimal places. If empty then all nonempty decimal places will be displayed.',
      'aclStrictMode' => 'Enabled: Access to scopes will be forbidden if it\'s not specified in roles.

Disabled: Access to scopes will be allowed if it\'s not specified in roles.',
      'aclAllowDeleteCreated' => 'Users will be able to remove records they created even if they don\'t have a delete access.',
      'textFilterUseContainsForVarchar' => 'If not checked then \'starts with\' operator is used. You can use the wildcard \'%\'.',
      'streamEmailNotificationsEntityList' => 'Email notifications about stream updates of followed records. Users will receive email notifications only for specified entity types.',
      'authTokenPreventConcurrent' => 'Users won\'t be able to be logged in on multiple devices simultaneously.',
      'emailAddressIsOptedOutByDefault' => 'When creating new record email address will be marked as opted-out.',
      'cleanupDeletedRecords' => 'Removed records will be deleted from database after a while.',
      'jobRunInParallel' => 'Jobs will be executed in parallel processes.',
      'jobPoolConcurrencyNumber' => 'Max number of processes run simultaneously.',
      'jobMaxPortion' => 'Max number of jobs processed per one execution.',
      'jobForceUtc' => 'Use the UTC time zone for scheduled jobs. Otherwise, the time zone set in settings will be used.',
      'daemonInterval' => 'Interval between process cron runs in seconds.',
      'daemonMaxProcessNumber' => 'Max number of cron processes run simultaneously.',
      'daemonProcessTimeout' => 'Max execution time (in seconds) allocated for a single cron process.',
      'cronDisabled' => 'Cron will not run.',
      'maintenanceMode' => 'Only administrators will have access to the system.',
      'oidcGroupClaim' => 'A claim to use for team mapping.',
      'oidcFallback' => 'Allow login by username/password.',
      'oidcCreateUser' => 'Create a new user in Espo when no matching user found.',
      'oidcSync' => 'Sync user data (on every login).',
      'oidcSyncTeams' => 'Sync user teams (on every login).',
      'oidcUsernameClaim' => 'A claim to use for a username (for user matching and creation).',
      'oidcTeams' => 'Espo teams mapped against groups/teams/roles of the identity provider. Teams with an empty mapping value will be always assigned to a user (when creating or syncing).',
      'oidcLogoutUrl' => 'An URL the browser will redirect to after logging out from Espo. Intended for clearing the session information in the browser and doing logging out on the provider side. Usually the URL contains a redirect-URL parameter, to return back to Espo.

Available placeholders:
* `{siteUrl}`
* `{clientId}`',
      'quickSearchFullTextAppendWildcard' => 'Append a wildcard to an autocomplete search query when Full-Text search is enabled. Reduces search performance.',
      'salesForbidOrderUnlock' => 'Once an order is locked, it can only be unlocked by an administrator.'
    ],
    'labels' => [
      'Group Tab' => 'Group Tab',
      'Divider' => 'Divider',
      'System' => 'System',
      'Locale' => 'Locale',
      'Search' => 'Search',
      'Misc' => 'Misc',
      'SMTP' => 'SMTP',
      'General' => 'General',
      'Phone Numbers' => 'Phone Numbers',
      'Navbar' => 'Navbar',
      'Dashboard' => 'Dashboard',
      'Configuration' => 'Configuration',
      'In-app Notifications' => 'In-app Notifications',
      'Email Notifications' => 'Email Notifications',
      'Currency Settings' => 'Currency Settings',
      'Currency Rates' => 'Currency Rates',
      'Mass Email' => 'Mass Email',
      'Scheduled Send' => 'Scheduled Send',
      'Test Connection' => 'Test Connection',
      'Connecting' => 'Connecting...',
      'Activities' => 'Activities',
      'Admin Notifications' => 'Admin Notifications',
      'Passwords' => 'Passwords',
      '2-Factor Authentication' => '2-Factor Authentication',
      'Attachments' => 'Attachments',
      'IdP Group' => 'IdP Group',
      'Access' => 'Access',
      'Strength' => 'Strength',
      'Recovery' => 'Recovery',
      'Electronic Invoicing' => 'Electronic Invoicing',
      'Seller Information' => 'Seller Information'
    ],
    'messages' => [
      'ldapTestConnection' => 'The connection successfully established.'
    ]
  ],
  'Stream' => [
    'messages' => [
      'infoMention' => 'Type **@username** to mention user in the post.',
      'infoSyntax' => 'Available markdown syntax',
      'couldNotAddFollowerUserHasNoAccessToStream' => 'Could not add the user \'{userName}\' to the followers. The user does not have \'stream\' access to the record.'
    ],
    'syntaxItems' => [
      'code' => 'code',
      'multilineCode' => 'multiline code',
      'strongText' => 'strong text',
      'emphasizedText' => 'emphasized text',
      'deletedText' => 'deleted text',
      'blockquote' => 'blockquote',
      'link' => 'link text'
    ]
  ],
  'Team' => [
    'fields' => [
      'name' => 'Name',
      'roles' => 'Roles',
      'layoutSet' => 'Layout Set',
      'workingTimeCalendar' => 'Working Time Calendar',
      'positionList' => 'Position List',
      'userRole' => 'User Role',
      'country' => 'Country',
      'subTeams' => 'Sub Time',
      'brand' => 'Brand'
    ],
    'links' => [
      'users' => 'Users',
      'notes' => 'Notes',
      'roles' => 'Roles',
      'layoutSet' => 'Layout Set',
      'workingTimeCalendar' => 'Working Time Calendar',
      'inboundEmails' => 'Group Email Accounts',
      'groupEmailFolders' => 'Group Email Folders'
    ],
    'tooltips' => [
      'workingTimeCalendar' => 'A calendar will be applied to users who have this team set as a Default Team.',
      'layoutSet' => 'Provides the ability to have layouts that differ from standard ones. Layout Set will be applied to users who have this team set as Default Team.',
      'roles' => 'Access Roles. Users of this team obtain access control level from selected roles.',
      'positionList' => 'Available positions in this team. E.g. Salesperson, Manager.'
    ],
    'labels' => [
      'Create Team' => 'Create Team'
    ],
    'options' => [
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Brasil' => 'Brasil',
        'Caribe' => 'Caribe',
        'CALA' => 'CALA',
        'Colombia' => 'Colombia',
        'Chile' => 'Chile',
        'Ecuador' => 'Ecuador',
        'Mexico' => 'Mexico',
        'Peru' => 'Peru',
        'CCA' => 'CCA',
        'Bolivia' => 'Bolivia',
        'Paraguay' => 'Paraguay',
        'Uruguay' => 'Uruguay',
        'Panama' => 'Panama'
      ],
      'brand' => [
        '' => '',
        'AWS' => 'AWS',
        'Google' => 'Google',
        'Microsoft' => 'Microsoft'
      ]
    ]
  ],
  'Template' => [
    'fields' => [
      'name' => 'Name',
      'body' => 'Body',
      'entityType' => 'Entity Type',
      'header' => 'Header',
      'footer' => 'Footer',
      'leftMargin' => 'Left Margin',
      'topMargin' => 'Top Margin',
      'rightMargin' => 'Right Margin',
      'bottomMargin' => 'Bottom Margin',
      'printFooter' => 'Print Footer',
      'printHeader' => 'Print Header',
      'footerPosition' => 'Footer Position',
      'headerPosition' => 'Header Position',
      'variables' => 'Available Placeholders',
      'pageOrientation' => 'Page Orientation',
      'pageFormat' => 'Paper Format',
      'pageWidth' => 'Page Width (mm)',
      'pageHeight' => 'Page Height (mm)',
      'fontFace' => 'Font',
      'title' => 'Title',
      'style' => 'Style'
    ],
    'links' => [],
    'labels' => [
      'Create Template' => 'Create Template'
    ],
    'options' => [
      'pageOrientation' => [
        'Portrait' => 'Portrait',
        'Landscape' => 'Landscape'
      ],
      'pageFormat' => [
        'Custom' => 'Custom'
      ],
      'placeholders' => [
        'pagebreak' => 'Page break',
        'today' => 'Today (date)',
        'now' => 'Now (date-time)'
      ],
      'fontFace' => []
    ],
    'tooltips' => [
      'footer' => 'Use {pageNumber} to print page number.',
      'variables' => 'Copy-paste needed placeholder to Header, Body or Footer.'
    ]
  ],
  'User' => [
    'fields' => [
      'name' => 'Name',
      'userName' => 'User Name',
      'title' => 'Title',
      'type' => 'Type',
      'isAdmin' => 'Is Admin',
      'defaultTeam' => 'Default Team',
      'emailAddress' => 'Email',
      'phoneNumber' => 'Phone',
      'roles' => 'Roles',
      'portals' => 'Portals',
      'portalRoles' => 'Portal Roles',
      'teamRole' => 'Position',
      'password' => 'Password',
      'currentPassword' => 'Current Password',
      'passwordConfirm' => 'Confirm Password',
      'newPassword' => 'New Password',
      'newPasswordConfirm' => 'Confirm New Password',
      'yourPassword' => 'Your current password',
      'avatar' => 'Avatar',
      'avatarColor' => 'Avatar Color',
      'isActive' => 'Is Active',
      'isPortalUser' => 'Is Portal User',
      'contact' => 'Contact',
      'accounts' => 'Accounts',
      'account' => 'Account (Primary)',
      'sendAccessInfo' => 'Send Email with Access Info to User',
      'portal' => 'Portal',
      'gender' => 'Gender',
      'position' => 'Position in Team',
      'ipAddress' => 'IP Address',
      'passwordPreview' => 'Password Preview',
      'isSuperAdmin' => 'Is Super Admin',
      'lastAccess' => 'Last Access',
      'apiKey' => 'API Key',
      'secretKey' => 'Secret Key',
      'dashboardTemplate' => 'Dashboard Template',
      'workingTimeCalendar' => 'Working Time Calendar',
      'auth2FA' => '2FA',
      'authMethod' => 'Authentication Method',
      'auth2FAEnable' => 'Enable 2-Factor Authentication',
      'auth2FAMethod' => '2FA Method',
      'auth2FATotpSecret' => '2FA TOTP Secret',
      'layoutSet' => 'Layout Set',
      'acceptanceStatus' => 'Acceptance Status',
      'acceptanceStatusMeetings' => 'Acceptance Status (Meetings)',
      'acceptanceStatusCalls' => 'Acceptance Status (Calls)',
      'country' => 'Country',
      'userType' => 'User Type',
      'partner' => 'Account',
      'clientid' => 'Rocket Client ID',
      'clientsecret' => 'Rocket Client Secret',
      'lead' => 'Lead',
      'contact1' => 'Contact1',
      'productBrand' => 'Product Brand',
      'awsClientId' => 'AwsClientId',
      'awsClientSecret' => 'AwsClientSecret',
      'lastAccessDate' => 'Last Access Date',
      'teamCountry' => 'Team Country',
      'countryList' => 'Country List',
      'vbmAccount' => 'Account',
      'opportunities' => 'Opportunities',
      'userPosition' => 'Cargo',
      'accountVMB' => 'Account VMB',
      'mobileApp' => 'Mobile App',
      'configApp' => 'ConfigApp',
      'accountbdm' => 'Account',
      'accounts1' => 'Accounts',
      'accountsBdms' => 'Carteira de Clientes - BDMs',
      'salesTerritory' => 'Sales Territory',
      'bDM' => 'VBA/BDR/BDM',
      'migrationsaccountManager' => 'Migrações (Account Manager)',
      'migrations' => 'Migrações (BDM Cloud)',
      'processOwnerMigrations' => 'Migrações (Process Owner)',
      'cAccountSales' => 'Carteira de Clientes - AMs'
    ],
    'links' => [
      'defaultTeam' => 'Default Team',
      'teams' => 'Teams',
      'roles' => 'Roles',
      'notes' => 'Notes',
      'portals' => 'Portals',
      'portalRoles' => 'Portal Roles',
      'contact' => 'Contact',
      'accounts' => 'Accounts',
      'account' => 'Account (Primary)',
      'tasks' => 'Tasks',
      'userData' => 'User Data',
      'dashboardTemplate' => 'Dashboard Template',
      'workingTimeCalendar' => 'Working Time Calendar',
      'workingTimeRanges' => 'Working Time Exceptions',
      'layoutSet' => 'Layout Set',
      'targetLists' => 'Target Lists',
      'partner' => 'Account',
      'lead' => 'Lead',
      'contact1' => 'Contact1',
      'vbmAccount' => 'Account',
      'opportunities' => 'Opportunities',
      'accountVMB' => 'Account VMB',
      'accountbdm' => 'Account',
      'accounts1' => 'Accounts',
      'accountsBdms' => 'Carteira de Clientes - BDMs',
      'migrationsaccountManager' => 'Migrações (Account Manager)',
      'migrations' => 'Migrações (BDM Cloud)',
      'processOwnerMigrations' => 'Migrações (Process Owner)',
      'cAccountSales' => 'Carteira de Clientes - AMs'
    ],
    'labels' => [
      'Create User' => 'Create User',
      'Generate' => 'Generate',
      'Access' => 'Access',
      'Preferences' => 'Preferences',
      'Change Password' => 'Change Password',
      'Teams and Access Control' => 'Teams and Access Control',
      'Forgot Password?' => 'Forgot Password?',
      'Password Change Request' => 'Password Change Request',
      'Email Address' => 'Email Address',
      'External Accounts' => 'External Accounts',
      'Email Accounts' => 'Email Accounts',
      'Portal' => 'Portal',
      'Create Portal User' => 'Create Portal User',
      'Proceed w/o Contact' => 'Proceed w/o Contact',
      'Generate New API Key' => 'Generate New API Key',
      'Generate New Password' => 'Generate New Password',
      'Send Password Change Link' => 'Send Password Change Link',
      'Back to login form' => 'Back to login form',
      'Requirements' => 'Requirements',
      'Security' => 'Security',
      'Reset 2FA' => 'Reset 2FA',
      'Code' => 'Code',
      'Secret' => 'Secret',
      'Send Code' => 'Send Code',
      'Login Link' => 'Login Link'
    ],
    'tooltips' => [
      'defaultTeam' => 'All records created by this user will be related to this team by default.',
      'userName' => 'Letters a-z, numbers 0-9, dots, hyphens, @-signs and underscores are allowed.',
      'isAdmin' => 'Admin user can access everything.',
      'isActive' => 'If unchecked then user won\'t be able to login.',
      'teams' => 'Teams which this user belongs to. Access control level is inherited from team\'s roles.',
      'roles' => 'Additional access roles. Use it if user doesn\'t belong to any team or you need to extend access control level exclusively for this user.',
      'portalRoles' => 'Additional portal roles. Use it to extend access control level exclusively for this user.',
      'portals' => 'Portals which this user has access to.',
      'layoutSet' => 'Layouts from a specified set will be applied for the user instead of default ones.',
      'productBrand' => 'Determines which manufacturers the user will access on the opportunities and leads screens.'
    ],
    'messages' => [
      '2faMethodNotConfigured' => 'The 2FA method is not fully configured in the system.',
      'loginAs' => 'Open the login link in an incognito window to preserve your current session. Use your admin credentials to log in.',
      'sendPasswordChangeLinkConfirmation' => 'An email with a unique link will be sent to the user allowing them to change their password. The link will expire after a specific amount of time.',
      'passwordRecoverySentIfMatched' => 'Assuming the entered data matched any user account.',
      'passwordStrengthLength' => 'Must be at least {length} characters long.',
      'passwordStrengthLetterCount' => 'Must contain at least {count} letter(s).',
      'passwordStrengthNumberCount' => 'Must contain at least {count} digit(s).',
      'passwordStrengthSpecialCharacterCount' => 'Must contain at least {count} special character(s).',
      'passwordStrengthBothCases' => 'Must contain letters of both upper and lower case.',
      'passwordWillBeSent' => 'Password will be sent to user\'s email address.',
      'passwordChanged' => 'Password has been changed',
      'userCantBeEmpty' => 'Username can not be empty',
      'wrongUsernamePassword' => 'Wrong username/password',
      'failedToLogIn' => 'Failed to log in',
      'emailAddressCantBeEmpty' => 'Email Address can not be empty',
      'userNameEmailAddressNotFound' => 'Username/Email Address not found',
      'forbidden' => 'Forbidden, please try later',
      'uniqueLinkHasBeenSent' => 'The unique URL has been sent to the specified email address.',
      'passwordChangedByRequest' => 'Password has been changed.',
      'setupSmtpBefore' => 'You need to setup [SMTP settings]({url}) to make the system be able to send password in email.',
      'userNameExists' => 'User Name already exists',
      'loginError' => 'Error occurred',
      'wrongCode' => 'Wrong code',
      'codeIsRequired' => 'Code is required',
      'yourAuthenticationCode' => 'Your authentication code: {code}.',
      'choose2FaSmsPhoneNumber' => 'Select a phone number that will be used for 2FA.',
      'choose2FaEmailAddress' => 'Select an email address that will be used for 2FA. It\'s highly recommended to use a non-primary email address.',
      'enterCodeSentInEmail' => 'Enter the code sent to your email address.',
      'enterCodeSentBySms' => 'Enter the code sent by SMS to your phone number.',
      'enterTotpCode' => 'Enter a code from your authenticator app.',
      'verifyTotpCode' => 'Scan the QR-code with your mobile authenticator app. If you have a trouble with scanning, you can enter the secret manually. After that you will see a 6-digit code in your application. Enter this code in the field below.',
      'generateAndSendNewPassword' => 'A new password will be generated and sent to the user\'s email address.',
      'security2FaResetConfirmation' => 'Are you sure you want to reset the current 2FA settings?',
      'auth2FARequiredHeader' => '2 factor authentication required',
      'auth2FARequired' => 'You need to set up 2 factor authentication. Use an authenticator application on your mobile phone (e.g. Google Authenticator).',
      'ldapUserInEspoNotFound' => 'User is not found in TD SYNNEX MCA. Contact your administrator to create the user.',
      'passwordChangeRequestNotFound' => 'The password change request is not found. It might be expired. Try to initiate a new password recovery from the [login page]({url}).',
      'defaultTeamIsNotUsers' => 'Default Team should be one of user\'s Teams'
    ],
    'options' => [
      'gender' => [
        '' => 'Not Set',
        'Male' => 'Male',
        'Female' => 'Female',
        'Neutral' => 'Neutral'
      ],
      'type' => [
        'regular' => 'Regular',
        'admin' => 'Admin',
        'portal' => 'Portal',
        'system' => 'System',
        'super-admin' => 'Super-Admin',
        'api' => 'API'
      ],
      'authMethod' => [
        'ApiKey' => 'API Key',
        'Hmac' => 'HMAC'
      ],
      'userType' => [
        'Reseller' => 'Reseller',
        'Customer' => 'Customer',
        'Internal team' => 'Internal team',
        ' ' => ' ',
        'Synnex Staff' => 'TD SYNNEX'
      ],
      'productBrand' => [
        'AWS' => 'AWS',
        'Cisco' => 'Cisco',
        'Enterprise' => 'Enterprise',
        'Fortinet' => 'Fortinet',
        'IBM' => 'IBM',
        'Microsoft' => 'Microsoft',
        'Google' => 'Google',
        'IBM Cloud' => 'IBM Cloud'
      ],
      'countryList' => [
        'Brasil' => 'Brasil',
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Colombia' => 'Colombia',
        'Ecuador' => 'Ecuador',
        'Mexico' => 'Mexico',
        'Uruguay' => 'Uruguay',
        'Peru' => 'Peru',
        'Caribe' => 'Caribe',
        'Chile' => 'Chile',
        'Panama' => 'Panama',
        'Paraguay' => 'Paraguay'
      ],
      'configApp' => [
        'AWS' => 'AWS',
        'GCP' => 'GCP',
        'Azure' => 'Azure'
      ],
      'salesTerritory' => [
        'Accelerate' => 'Accelerate',
        'CA&A' => 'CA&A',
        'Cisco Solutions 1' => 'Cisco Solutions 1',
        'Cisco Solutions 2' => 'Cisco Solutions 2',
        'Cloud XaaS' => 'Cloud XaaS',
        'Infra' => 'Infra',
        'Marketing Cloud' => 'Marketing Cloud',
        'Sales Support Cloud' => 'Sales Support Cloud',
        'Security' => 'Security',
        'Service Providers 1' => 'Service Providers 1',
        'Service Providers 2' => 'Service Providers 2',
        'Specialized Solutions - IBM/Oracle' => 'Specialized Solutions - IBM/Oracle',
        'Specialized Solutions - Regional' => 'Specialized Solutions - Regional',
        'VBM Cloud' => 'VBM Cloud',
        'VP, General Manager' => 'VP, General Manager'
      ]
    ],
    'boolFilters' => [
      'onlyMyTeam' => 'Only My Team',
      'onlyMe' => 'OnlyMe'
    ],
    'presetFilters' => [
      'active' => 'Active',
      'activePortal' => 'Portal Active',
      'activeApi' => 'API Active',
      'reportFilter669ab1ec9e2cc5afe' => 'BDM Users: AWS',
      'reportFilter669ab1fb8382eba48' => 'BDM Users: Microsoft',
      'reportFilter669ab2078ca7cc670' => 'BDM Users: Google'
    ],
    'actions' => [
      'changePosition' => 'Change Position'
    ]
  ],
  'Webhook' => [
    'labels' => [
      'Create Webhook' => 'Create Webhook'
    ],
    'fields' => [
      'event' => 'Event',
      'url' => 'URL',
      'isActive' => 'Is Active',
      'user' => 'API User',
      'entityType' => 'Entity Type',
      'field' => 'Field',
      'secretKey' => 'Secret Key'
    ],
    'links' => [
      'user' => 'User'
    ]
  ],
  'WebhookQueueItem' => [
    'fields' => [
      'event' => 'Event',
      'webhook' => 'Webhook',
      'target' => 'Target',
      'data' => 'Data',
      'status' => 'Status',
      'processedAt' => 'Processed At',
      'attempts' => 'Attempts',
      'processAt' => 'Process At'
    ],
    'links' => [
      'webhook' => 'Webhook'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pending',
        'Success' => 'Success',
        'Failed' => 'Failed'
      ]
    ]
  ],
  'WorkingTimeCalendar' => [
    'labels' => [
      'Create WorkingTimeCalendar' => 'Create Calendar'
    ],
    'fields' => [
      'timeZone' => 'Time Zone',
      'timeRanges' => 'Workday Schedule',
      'weekday0' => 'Sun',
      'weekday1' => 'Mon',
      'weekday2' => 'Tue',
      'weekday3' => 'Wed',
      'weekday4' => 'Thu',
      'weekday5' => 'Fri',
      'weekday6' => 'Sat',
      'weekday0TimeRanges' => 'Sun Schedule',
      'weekday1TimeRanges' => 'Mon Schedule',
      'weekday2TimeRanges' => 'Tue Schedule',
      'weekday3TimeRanges' => 'Wed Schedule',
      'weekday4TimeRanges' => 'Thu Schedule',
      'weekday5TimeRanges' => 'Fri Schedule',
      'weekday6TimeRanges' => 'Sat Schedule'
    ],
    'links' => [
      'ranges' => 'Exceptions'
    ]
  ],
  'WorkingTimeRange' => [
    'labels' => [
      'Create WorkingTimeRange' => 'Create Exception',
      'Calendars' => 'Calendars'
    ],
    'fields' => [
      'timeRanges' => 'Schedule',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'type' => 'Type',
      'calendars' => 'Calendars',
      'users' => 'Users'
    ],
    'links' => [
      'calendars' => 'Calendars',
      'users' => 'Users'
    ],
    'options' => [
      'type' => [
        'Non-working' => 'Non-working',
        'Working' => 'Working'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Actual'
    ],
    'tooltips' => [
      'calendars' => 'Calendars to apply the exception to. The exception will be applied to all users of selected calendars.

Leave the field empty if you need to apply the exception only for specific users.',
      'users' => 'Specific users to apply the exception to.'
    ]
  ],
  'Account' => [
    'fields' => [
      'name' => 'Name',
      'emailAddress' => 'Email',
      'website' => 'Website',
      'phoneNumber' => 'Phone',
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'description' => 'Description',
      'sicCode' => 'Tax identification number: (TAX ID / NIT / RUC / CNPJ)',
      'industry' => 'Industry',
      'type' => 'Type',
      'contactRole' => 'Title',
      'contactIsInactive' => 'Inactive',
      'campaign' => 'Campaign',
      'targetLists' => 'Target Lists',
      'targetList' => 'Target List',
      'originalLead' => 'Original Lead',
      'priceBook' => 'Price Book',
      'electronicAddressScheme' => 'Electronic Address Scheme',
      'electronicAddressIdentifier' => 'Electronic Address Identifier',
      'updateField' => 'Update Field',
      'leads' => 'Leads',
      'logo' => 'Logo',
      'renewalresponsible' => 'Renewal Responsible',
      'companyID' => 'TD SYNNEX ID',
      'country' => 'Country',
      'partnerIDs' => 'Partner IDs',
      'surestep' => 'Surestep',
      'surestepLevel1' => 'Surestep Level',
      'ciscoJourney' => 'Cisco Journey',
      'opps' => 'Opportunities',
      'partnerPrograms' => 'Partner Programs',
      'cloudConsumptions' => 'Cloud consumption',
      'cpb' => 'Cloud Practice Builder',
      'programs1' => 'Program',
      'typeOfBusiness' => 'Business Type',
      'aWS' => 'AWS',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'googleClouds' => 'Google Clouds',
      'partnersGoogleClouds' => 'Partners Google Clouds',
      'statusCPB' => 'Status CPB',
      'dSETAWS' => 'DSET AWS',
      'programaGoogleCloud' => 'Program - Google Cloud',
      'region' => 'Region',
      'progresspartner' => 'Partner Progress',
      'partnersGoogleCloud' => 'Partner Progress',
      'programaCloudPracticeBuilder' => 'Program - Cloud Practice Builder',
      'programSurestep' => 'Program - Surestep',
      'iSVExperience1' => 'Programa ISV Experience',
      'consumoSurestep' => 'Surestep Consumption',
      'cPBs' => 'CPBs',
      'updated' => 'Updated',
      'externalIDcdp' => 'External ID cdp',
      'events' => 'Events',
      'sPMSID' => 'SPMSID',
      'aWSs' => 'AWS',
      'aws' => 'Partner Program',
      'dSETs' => 'DSET',
      'cpbIoTFinancial' => 'CPB IoT Financial',
      'cpbIoTStrategy' => 'CPB IoT Strategy',
      'cPBIoTAnalytic' => 'CPB IoT Analytic',
      'cPBIoTMarketing' => 'CPB IoT Marketing',
      'cPBIoTTechnology' => 'CPB IoT Technology',
      'pBGeral' => 'PBGeral',
      'vendorSubscriptions' => 'Vendor Subscriptions',
      'accountParent' => 'Headquarters',
      'accounts' => 'Branch',
      'typeOfCompany' => 'Tipo de Empresa',
      'services1' => 'Opportunities (Services) - End Customer',
      'vendorAccounts' => 'Vendor Accounts',
      'dSAStartDate' => 'DSA start date',
      'user' => 'VBM User',
      'isv' => 'ISV',
      'unity' => 'Unity',
      'dSAStatus' => 'DSA Status',
      'reports' => 'Reports',
      'renewals' => 'Microsoft Renewals - next 90 days',
      'emailContent' => 'Email Content',
      'accountVMB' => 'Account VMB',
      'accountVBM' => 'Account VBM',
      'emailContents' => 'Email Contents',
      'top5Customers' => 'Top 5 Customers',
      'reservedInstances' => 'Reserved Instances',
      'bdm' => 'VBA/BDR/BDM',
      'cloudsolvSSAID' => 'CloudsolvSSAID',
      'hasRenewals' => 'hasRenewals',
      'cisCode' => 'CIS Code',
      'dataAIAssessment' => 'Data AI Assessment',
      'salesOrdersRecommendations' => 'Microsoft Recommendations - next 90 days',
      'accountContent' => 'Account Content',
      'messenger' => 'Messenger',
      'messengers' => 'Mensageria',
      'renewalsMicrosoft' => 'Microsoft Renewals',
      'cUserSales' => 'AM',
      'cRenewalsMicrosoft' => 'Microsoft Renewals',
      'cPartnerAssessmentCategory' => 'Categoria do Parceiro'
    ],
    'links' => [
      'contacts' => 'Contacts',
      'contactsPrimary' => 'Contacts (primary)',
      'opportunities' => 'Opportunities',
      'cases' => 'Cases',
      'documents' => 'Documents',
      'meetingsPrimary' => 'Meetings (expanded)',
      'callsPrimary' => 'Calls (expanded)',
      'tasksPrimary' => 'Tasks (expanded)',
      'emailsPrimary' => 'Emails (expanded)',
      'targetLists' => 'Target Lists',
      'campaignLogRecords' => 'Campaign Log',
      'campaign' => 'Campaign',
      'portalUsers' => 'Portal Users',
      'originalLead' => 'Original Lead',
      'priceBook' => 'Price Book',
      'supplier' => 'Supplier',
      'quotes' => 'Quotes',
      'quoteItems' => 'Quote Items',
      'salesOrders' => 'Sales Orders',
      'salesOrderItems' => 'Sales Order Items',
      'invoices' => 'Invoices',
      'invoiceItems' => 'Invoice Items',
      'purchaseOrders' => 'Purchase Orders',
      'purchaseOrderItems' => 'Purchase Order Items',
      'deliveryOrders' => 'Delivery Orders',
      'deliveryOrderItems' => 'Delivery Order Items',
      'receiptOrders' => 'Receipt Orders',
      'receiptOrderItems' => 'Receipt Order Items',
      'returnOrders' => 'Return Orders',
      'returnOrderItems' => 'Return Order Items',
      'leads' => 'Leads',
      'renewalresponsible' => 'Renewal Responsible',
      'partnerIDs' => 'Partner IDs',
      'surestep' => 'Surestep',
      'ciscoJourney' => 'Cisco Journey',
      'opps' => 'Opportunities',
      'partnerPrograms' => 'Partner Programs',
      'cloudConsumptions' => 'Cloud Consumptions',
      'cpb' => 'Cloud Practice Builder',
      'programs1' => 'Program',
      'aWS' => 'AWS',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'googleClouds' => 'Google Clouds',
      'partnersGoogleClouds' => 'Partners Google Clouds',
      'programaGoogleCloud' => 'Program Google Cloud',
      'region' => 'Region',
      'country' => 'Country',
      'progresspartner' => 'Partner Progress',
      'partnersGoogleCloud' => 'Partner Progress',
      'programaAWS' => 'Programs - AWS',
      'programaCloudPracticeBuilder' => 'Program Cloud Practice Builder',
      'programSurestep' => 'Program - Surestep',
      'iSVExperience1' => 'Programa ISV Experience',
      'cPBs' => 'CPBs',
      'events' => 'Events',
      'aWSs' => 'AWS',
      'aws' => 'AWS',
      'dSETs' => 'DSET',
      'cpbIoTFinancial' => 'CPB IoT Financial',
      'cpbIoTStrategy' => 'CPB IoT Strategy',
      'cPBIoTAnalytic' => 'CPB IoT Analytic',
      'cPBIoTMarketing' => 'CPB IoT Marketing',
      'cPBIoTTechnology' => 'CPB IoT Technology',
      'pBGeral' => 'PBGeneral',
      'vendorSubscriptions' => 'Vendor Subscriptions',
      'accountParent' => 'Headquarters',
      'accounts' => 'Branch',
      'services1' => 'Opportunities (Services) - End Customer',
      'vendorAccounts' => 'Vendor Accounts',
      'user' => 'VBM User',
      'reports' => 'Reports',
      'renewals' => 'Renewals',
      'emailContent' => 'Email Content',
      'accountVMB' => 'Account VMB',
      'accountVBM' => 'Account VBM',
      'emailContents' => 'Email Contents',
      'top5Customers' => 'Top 5 Customers',
      'reservedInstances' => 'Reserved Instances',
      'bdm' => 'BDMs',
      'users' => 'BDMs',
      'dataAIAssessment' => 'Data AI Assessment',
      'salesOrdersRecommendations' => 'Microsoft Recommendations',
      'accountContent' => 'Account Content',
      'messenger' => 'Messenger',
      'messengers' => 'Messaging',
      'renewalsMicrosoft' => 'Microsoft Renewals',
      'cUserSales' => 'AM',
      'cRenewalsMicrosoft' => 'Microsoft Renewals'
    ],
    'options' => [
      'type' => [
        'Customer' => 'Customer',
        'Investor' => 'Investor',
        'Partner' => 'Partner',
        'Reseller' => 'Reseller',
        '' => '',
        'ISV' => 'ISV',
        'Enterprise' => 'Enterprise',
        'Consulting' => 'Consulting',
        'Technology' => 'Technology',
        'Socio	' => 'Partner'
      ],
      'industry' => [
        'Aerospace' => 'Aerospace',
        'Agriculture' => 'Agriculture',
        'Advertising' => 'Advertising',
        'Apparel & Accessories' => 'Apparel & Accessories',
        'Architecture' => 'Architecture',
        'Automotive' => 'Automotive',
        'Banking' => 'Banking',
        'Biotechnology' => 'Biotechnology',
        'Building Materials & Equipment' => 'Building Materials & Equipment',
        'Chemical' => 'Chemical',
        'Construction' => 'Construction',
        'Computer' => 'Computer',
        'Defense' => 'Defense',
        'Creative' => 'Creative',
        'Culture' => 'Culture',
        'Consulting' => 'Consulting',
        'Education' => 'Education',
        'Electronics' => 'Electronics',
        'Electric Power' => 'Electric Power',
        'Energy' => 'Energy',
        'Entertainment & Leisure' => 'Entertainment & Leisure',
        'Finance' => 'Finance',
        'Food & Beverage' => 'Food & Beverage',
        'Grocery' => 'Grocery',
        'Hospitality' => 'Hospitality',
        'Healthcare' => 'Healthcare',
        'Insurance' => 'Insurance',
        'Legal' => 'Legal',
        'Manufacturing' => 'Manufacturing',
        'Mass Media' => 'Mass Media',
        'Mining' => 'Mining',
        'Music' => 'Music',
        'Marketing' => 'Marketing',
        'Publishing' => 'Publishing',
        'Petroleum' => 'Petroleum',
        'Real Estate' => 'Real Estate',
        'Retail' => 'Retail',
        'Shipping' => 'Shipping',
        'Service' => 'Service',
        'Support' => 'Support',
        'Sports' => 'Sports',
        'Software' => 'Software',
        'Technology' => 'Technology',
        'Telecommunications' => 'Telecommunications',
        'Television' => 'Television',
        'Testing, Inspection & Certification' => 'Testing, Inspection & Certification',
        'Transportation' => 'Transportation',
        'Travel' => 'Travel',
        'Venture Capital' => 'Venture Capital',
        'Wholesale' => 'Wholesale',
        'Water' => 'Water'
      ],
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Brasil' => 'Brazil',
        'CALA' => 'CALA',
        'Caribe' => 'Caribbean',
        'Centro' => 'Centro',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Equador' => 'Ecuador',
        'México' => 'Mexico',
        'Perú' => 'Peru',
        'South' => 'Sul',
        'Amer.Virgin Is.' => 'Amer.Virgin Is.',
        'Antigua/Barbuda' => 'Antigua/Barbuda',
        'Aruba' => 'Aruba',
        'Bahamas' => 'Bahamas',
        'Barbados' => 'Barbados',
        'Bermuda' => 'Bermuda',
        'Bolivia' => 'Bolivia',
        'BQ' => 'BQ',
        'Brit.Virgin Is.' => 'Brit.Virgin Is.',
        'Cayman Islands' => 'Cayman Islands',
        'Costa Rica' => 'Costa Rica',
        'CW' => 'CW',
        'Dominican Republic' => 'Dominican Republic',
        'El Salvador' => 'El Salvador',
        'Grenada' => 'Grenada',
        'Guadeloupe' => 'Guadeloupe',
        'Guyana' => 'Guyana',
        'Honduras' => 'Honduras',
        'Jamaica' => 'Jamaica',
        'Nicaragua' => 'Nicaragua',
        'Panama' => 'Panama',
        'St. Lucia' => 'St. Lucia',
        'St. Vincent' => 'St. Vincent',
        'Suriname' => 'Suriname',
        'SX' => 'SX',
        'Trinidad Tobago' => 'Trinidad Tobago',
        'USA' => 'USA',
        'CCA' => 'CCA',
        'Ecuador' => 'Ecuador',
        'Mexico' => 'Mexico',
        'Peru' => 'Peru',
        'Brazil' => 'Brazil',
        'Guadelouope' => 'Guadelouope',
        'Guatemala' => 'Guatemala',
        'Paraguay' => 'Paraguay',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'Ecuador ' => 'Ecuador',
        'Santa Lucía' => 'Santa Lucía',
        'San vicente y las Granadinas' => 'San vicente y las Granadinas',
        'San Cristóbal y Nieves' => 'San Cristóbal y Nieves',
        'Belice' => 'Belize',
        'Haití' => 'Haiti',
        'Granada' => 'Granada',
        'Cuba' => 'Cuba',
        'Antigua y barbuda' => 'Antigua and Barbuda',
        'United States' => 'United States',
        'Brasil (teste)' => 'Brazil (teste)'
      ],
      'statusCPB' => [
        '' => '',
        'Concluido' => 'Done',
        'Desenvolvimento' => 'Development',
        'Iniciado' => 'Started'
      ],
      'dSETAWS' => [
        '' => '',
        'Principiante' => 'Beginner',
        'Intermedio' => 'Intermediate',
        'Avanzado' => 'Advanced'
      ],
      'region' => [
        '' => '',
        'Brasil' => 'Brazil',
        'CCA' => 'CCA',
        'Mexico' => 'Mexico',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'None LAC' => 'None LAC'
      ],
      'typeOfCompany' => [
        '' => '',
        'Matriz' => 'Headquarters',
        'Filial' => 'Branch'
      ],
      'isv' => [
        '' => 'No',
        'Sim' => 'Yes'
      ],
      'unity' => [
        '' => '',
        'Velocity' => 'Velocity',
        'Valor' => 'Value',
        'Telco' => 'Telco'
      ],
      'dSAStatus' => [
        '' => '',
        'Cancelled' => 'Cancelled',
        'Executed' => 'Executed',
        'In Progress' => 'In Progress',
        'Inactive' => 'Inactive',
        'Pending DSA Signature' => 'Pending DSA Signature',
        'Rejected' => 'Rejected'
      ]
    ],
    'labels' => [
      'Create Account' => 'Create Account',
      'Copy Billing' => 'Copy Billing',
      'Set Primary' => 'Set Primary'
    ],
    'presetFilters' => [
      'customers' => 'Customers',
      'partners' => 'Partners',
      'recentlyCreated' => 'Recently Created',
      'reportFilter6660add1bf8c29edd' => 'Renewals Notification: Account',
      'reportFilter67c9a61c38980f876' => 'Contas - Brasil'
    ],
    'tabs' => [
      'Account' => 'Account',
      'Support' => 'Support'
    ]
  ],
  'Calendar' => [
    'modes' => [
      'month' => 'Month',
      'week' => 'Week',
      'day' => 'Day',
      'agendaWeek' => 'Week',
      'agendaDay' => 'Day',
      'timeline' => 'Timeline'
    ],
    'labels' => [
      'Today' => 'Today',
      'Create' => 'Create',
      'Shared' => 'Shared',
      'Add User' => 'Add User',
      'current' => 'current',
      'time' => 'time',
      'User List' => 'User List',
      'Manage Users' => 'Manage Users',
      'View Calendar' => 'View Calendar',
      'Create Shared View' => 'Create Shared View'
    ]
  ],
  'Call' => [
    'fields' => [
      'name' => 'Name',
      'parent' => 'Parent',
      'status' => 'Status',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'direction' => 'Direction',
      'duration' => 'Duration',
      'description' => 'Description',
      'users' => 'Users',
      'contacts' => 'Contacts',
      'leads' => 'Leads',
      'reminders' => 'Reminders',
      'account' => 'Account',
      'acceptanceStatus' => 'Acceptance Status',
      'uid' => 'UID',
      'insideSales' => 'Inside Sales?',
      'impossibleContact' => 'Impossible to Contact',
      'leads1' => 'Leads',
      'lead' => 'Lead',
      'solution' => 'Solution',
      'source' => 'Source',
      'leadCountry' => 'Lead Country'
    ],
    'links' => [
      'leads1' => 'Leads',
      'lead' => 'Lead'
    ],
    'options' => [
      'status' => [
        'Planned' => 'Planned',
        'Held' => 'Held',
        'Not Held' => 'Not Held'
      ],
      'direction' => [
        'Outbound' => 'Outbound',
        'Inbound' => 'Inbound'
      ],
      'acceptanceStatus' => [
        'None' => 'None',
        'Accepted' => 'Accepted',
        'Declined' => 'Declined',
        'Tentative' => 'Tentative'
      ],
      'insideSales' => [
        'Yes' => 'Sim',
        'No' => 'Não',
        ' ' => ' '
      ],
      'impossibleContact' => [
        '' => '',
        'No number' => 'No number',
        'Invalid number' => 'Invalid number'
      ],
      'source' => [
        'Microsoft Surestep' => 'Microsoft Surestep',
        'Security' => 'Security',
        'Modern Workplace' => 'Modern Workplace',
        '' => '',
        'Other' => 'Other'
      ]
    ],
    'massActions' => [
      'setHeld' => 'Set Held',
      'setNotHeld' => 'Set Not Held'
    ],
    'labels' => [
      'Create Call' => 'Create Call',
      'Set Held' => 'Set Held',
      'Set Not Held' => 'Set Not Held',
      'Send Invitations' => 'Send Invitations'
    ],
    'presetFilters' => [
      'planned' => 'Planned',
      'held' => 'Held',
      'todays' => 'Today\'s'
    ]
  ],
  'Campaign' => [
    'fields' => [
      'name' => 'Name',
      'description' => 'Description',
      'status' => 'Status',
      'type' => 'Type',
      'startDate' => 'Start Date',
      'endDate' => 'End Date',
      'targetLists' => 'Target Lists',
      'excludingTargetLists' => 'Excluding Target Lists',
      'sentCount' => 'Sent',
      'openedCount' => 'Opened',
      'clickedCount' => 'Clicked',
      'optedOutCount' => 'Opted Out',
      'bouncedCount' => 'Bounced',
      'optedInCount' => 'Opted In',
      'hardBouncedCount' => 'Hard Bounced',
      'softBouncedCount' => 'Soft Bounced',
      'leadCreatedCount' => 'Leads Created',
      'revenue' => 'Revenue',
      'revenueConverted' => 'Revenue (converted)',
      'budget' => 'Budget',
      'budgetConverted' => 'Budget (converted)',
      'budgetCurrency' => 'Budget Currency',
      'contactsTemplate' => 'Contacts Template',
      'leadsTemplate' => 'Leads Template',
      'accountsTemplate' => 'Accounts Template',
      'usersTemplate' => 'Users Template',
      'mailMergeOnlyWithAddress' => 'Skip records w/o filled address'
    ],
    'links' => [
      'targetLists' => 'Target Lists',
      'excludingTargetLists' => 'Excluding Target Lists',
      'accounts' => 'Accounts',
      'contacts' => 'Contacts',
      'leads' => 'Leads',
      'opportunities' => 'Opportunities',
      'campaignLogRecords' => 'Log',
      'massEmails' => 'Mass Emails',
      'trackingUrls' => 'Tracking URLs',
      'contactsTemplate' => 'Contacts Template',
      'leadsTemplate' => 'Leads Template',
      'accountsTemplate' => 'Accounts Template',
      'usersTemplate' => 'Users Template'
    ],
    'options' => [
      'type' => [
        'Email' => 'Email',
        'Web' => 'Web',
        'Television' => 'Television',
        'Radio' => 'Radio',
        'Newsletter' => 'Newsletter',
        'Mail' => 'Mail'
      ],
      'status' => [
        'Planning' => 'Planning',
        'Active' => 'Active',
        'Inactive' => 'Inactive',
        'Complete' => 'Complete'
      ]
    ],
    'labels' => [
      'Create Campaign' => 'Create Campaign',
      'Target Lists' => 'Target Lists',
      'Statistics' => 'Statistics',
      'hard' => 'hard',
      'soft' => 'soft',
      'Unsubscribe' => 'Unsubscribe',
      'Mass Emails' => 'Mass Emails',
      'Email Templates' => 'Email Templates',
      'Unsubscribe again' => 'Unsubscribe again',
      'Subscribe again' => 'Subscribe again',
      'Create Target List' => 'Create Target List',
      'Mail Merge' => 'Mail Merge',
      'Generate Mail Merge PDF' => 'Generate Mail Merge PDF'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'messages' => [
      'unsubscribed' => 'You have been unsubscribed from our mailing list.',
      'subscribedAgain' => 'You are subscribed again.'
    ],
    'tooltips' => [
      'targetLists' => 'Targets that should receive messages.',
      'excludingTargetLists' => 'Targets that should not receive messages.'
    ]
  ],
  'CampaignLogRecord' => [
    'fields' => [
      'action' => 'Action',
      'actionDate' => 'Date',
      'data' => 'Data',
      'campaign' => 'Campaign',
      'parent' => 'Target',
      'object' => 'Object',
      'application' => 'Application',
      'queueItem' => 'Queue Item',
      'stringData' => 'String Data',
      'stringAdditionalData' => 'String Additional Data',
      'isTest' => 'Is Test'
    ],
    'links' => [
      'queueItem' => 'Queue Item',
      'parent' => 'Parent',
      'object' => 'Object',
      'campaign' => 'Campaign'
    ],
    'options' => [
      'action' => [
        'Sent' => 'Sent',
        'Opened' => 'Opened',
        'Opted Out' => 'Opted Out',
        'Bounced' => 'Bounced',
        'Clicked' => 'Clicked',
        'Lead Created' => 'Lead Created',
        'Opted In' => 'Opted In'
      ]
    ],
    'labels' => [
      'All' => 'All'
    ],
    'presetFilters' => [
      'sent' => 'Sent',
      'opened' => 'Opened',
      'optedOut' => 'Opted Out',
      'optedIn' => 'Opted In',
      'bounced' => 'Bounced',
      'clicked' => 'Clicked',
      'leadCreated' => 'Lead Created'
    ]
  ],
  'CampaignTrackingUrl' => [
    'fields' => [
      'url' => 'URL',
      'action' => 'Action',
      'urlToUse' => 'Code to insert instead of URL',
      'message' => 'Message',
      'campaign' => 'Campaign'
    ],
    'links' => [
      'campaign' => 'Campaign'
    ],
    'labels' => [
      'Create CampaignTrackingUrl' => 'Create Tracking URL'
    ],
    'options' => [
      'action' => [
        'Redirect' => 'Redirect',
        'Show Message' => 'Show Message'
      ]
    ],
    'tooltips' => [
      'url' => 'The recipient will be redirected to this location after they follow the link.',
      'message' => 'The message will be shown to the recipient after they follow the link. Markdown is supported.'
    ]
  ],
  'Case' => [
    'fields' => [
      'name' => 'Name',
      'number' => 'Number',
      'status' => 'Status',
      'account' => 'Account',
      'contact' => 'Contact',
      'contacts' => 'Contacts',
      'priority' => 'Priority',
      'type' => 'Type',
      'description' => 'Description',
      'inboundEmail' => 'Group Email Account',
      'lead' => 'Lead',
      'attachments' => 'Attachments',
      'originalEmail' => 'Original Email',
      'isInternal' => 'Hidden from Portal',
      'solicitationType' => 'My solicitation is about:',
      'solicitationEntity' => 'Request Entity',
      'testField' => 'TestField',
      'other' => 'Specify Entity',
      'url' => 'Registry URL',
      'slaPrediction' => 'Forecast (SLA)',
      'cRegion' => 'Region'
    ],
    'links' => [
      'inboundEmail' => 'Group Email Account',
      'account' => 'Account',
      'contact' => 'Contact (Primary)',
      'Contacts' => 'Contacts',
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks',
      'emails' => 'Emails',
      'articles' => 'Knowledge Base Articles',
      'lead' => 'Lead',
      'attachments' => 'Attachments'
    ],
    'options' => [
      'status' => [
        'New' => 'New',
        'Assigned' => 'Assigned',
        'Pending' => 'Pending',
        'Closed' => 'Closed',
        'Rejected' => 'Rejected',
        'Duplicate' => 'Duplicate'
      ],
      'priority' => [
        'Low' => 'Low',
        'Normal' => 'Normal',
        'High' => 'High',
        'Urgent' => 'Urgent'
      ],
      'type' => [
        'Question' => 'Question',
        'Incident' => 'Incident',
        'Problem' => 'Problem'
      ],
      'solicitationType' => [
        'Select an option.' => 'Select an option.',
        'Trouble with 404 error.' => 'Trouble with 404 error.',
        'Trouble with 500 error.' => 'Trouble with 500 error.',
        'I need help with one or more fields.' => 'I need help with one or more fields.',
        'My data is not updated.' => 'My data is not updated.',
        'My data is wrong.' => 'My data is wrong.',
        'My list is outdated.' => 'My list is outdated.',
        'I can\'t create reports.' => 'I can\'t create reports.',
        'I can\'t create calls.' => 'I can\'t create calls.',
        'I can\'t create meetings.' => 'I can\'t create meetings.',
        'I can\'t create tasks.' => 'I can\'t create tasks.',
        'I can\'t create reminders.' => 'I can\'t create reminders.',
        'I can\'t make edits.' => 'I can\'t make edits.',
        'I can\'t make updates.' => 'I can\'t make updates.',
        'I can\'t access the Kanban view.' => 'I can\'t access the Kanban view.',
        'I can\'t see my data in the list.' => 'I can\'t see my data in the list.',
        'I can\'t see my data in the dashboards.' => 'I can\'t see my data in the dashboards.',
        'I couldn\'t understand a tutorial.' => 'I couldn\'t understand a tutorial.',
        'There is no tutorials for my specific need.' => 'There is no tutorials for my specific need.',
        'I am not finding a specific data/information (Requires description).' => 'I am not finding a specific data/information (Requires description).',
        'I can\'t see my history.' => 'I can\'t see my history.',
        'I can\'t see my activities.' => 'I can\'t see my activities.',
        'I can\'t see my tasks.' => 'I can\'t see my tasks.',
        'I can\'t see my dashboards.' => 'I can\'t see my dashboards.',
        'Other.' => 'Other.'
      ],
      'solicitationEntity' => [
        'Select an option.' => 'Selecione uma opção',
        'Accounts' => 'Cuentas',
        'Calls' => 'Llamadas',
        'Contacts' => 'Contactos',
        'Leads' => 'Leads',
        'Meetings' => 'Reuniones',
        'Opportunities' => 'Oportunidades',
        'Reports' => 'Reportes',
        'Tasks' => 'Tareas',
        'Users' => 'Usuários',
        'Quotes' => 'Cotizaciones',
        '' => '',
        'Other' => 'Otro',
        'Partner Program' => 'Partner Program'
      ],
      'cRegion' => [
        '' => '',
        'Brasil' => 'Brasil',
        'MCA' => 'MCA'
      ]
    ],
    'labels' => [
      'Create Case' => 'Create Case',
      'Close' => 'Close',
      'Reject' => 'Reject',
      'Closed' => 'Closed',
      'Rejected' => 'Rejected'
    ],
    'presetFilters' => [
      'open' => 'Open',
      'closed' => 'Closed'
    ],
    'tooltips' => [
      'solicitationType' => 'Here you will find some options for opening a ticket. If you don\'t find the one you need, select the option: \'Other\' and describe it in the \'Description\' field.',
      'solicitationEntity' => 'To open a support request, please select which entity you need help with.',
      'url' => 'Enter the registry URL.'
    ]
  ],
  'Contact' => [
    'fields' => [
      'name' => 'Name',
      'emailAddress' => 'Email',
      'title' => 'Account Title',
      'account' => 'Account',
      'accounts' => 'Accounts',
      'phoneNumber' => 'Phone',
      'accountType' => 'Account Type',
      'doNotCall' => 'Do Not Call',
      'address' => 'Address',
      'opportunityRole' => 'Opportunity Role',
      'accountRole' => 'Title',
      'description' => 'Description',
      'campaign' => 'Campaign',
      'targetLists' => 'Target Lists',
      'targetList' => 'Target List',
      'portalUser' => 'Portal User',
      'hasPortalUser' => 'Has Portal User',
      'originalLead' => 'Original Lead',
      'acceptanceStatus' => 'Acceptance Status',
      'accountIsInactive' => 'Account Inactive',
      'acceptanceStatusMeetings' => 'Acceptance Status (Meetings)',
      'acceptanceStatusCalls' => 'Acceptance Status (Calls)',
      'originalEmail' => 'Original Email',
      'analytics' => 'Analytics',
      'customerID' => 'Customer ID',
      'partnerID' => 'Partner ID',
      'type' => 'Type',
      'updateField' => 'Update Field',
      'user' => 'User',
      'bdmuser' => 'BDM User',
      'requestedContact' => 'Requested contact',
      'nurturingProfile' => 'Nurturing Profile',
      'nurturingLinkProfile' => 'Nurturing Link profile',
      'archivosDeIntereses' => 'Archivos de intereses',
      'partnersGoogleCloud' => 'Partners Google Cloud',
      'partnersGoogleClouds' => 'Program Google Clouds',
      'programGoogleCloud' => 'Program Google Cloud',
      'programGoogleClouds' => 'Program Google Clouds',
      'cPB' => 'CPB',
      'dSET' => 'DSET',
      'position' => 'Position',
      'quotes' => 'Quotes',
      'opportunity' => 'Opportunity',
      'billingContactOpportunities' => 'Opportunities',
      'accountVBM' => 'Account VBM',
      'source' => 'Source',
      'externalIDcdp' => 'ExternalIDcdp',
      'emailContents' => 'Email Contents',
      'hasRenewals' => 'Contact Renewals',
      'dataAIAssessment' => 'Data AI Assessment',
      'salesContact' => 'Sales Contact',
      'accountCountry' => 'Account Country',
      'cMarketing' => 'Marketing',
      'cAccountEndCustomer' => 'Account End Customer'
    ],
    'links' => [
      'opportunities' => 'Opportunities',
      'cases' => 'Cases',
      'targetLists' => 'Target Lists',
      'campaignLogRecords' => 'Campaign Log',
      'campaign' => 'Campaign',
      'account' => 'Account (Primary)',
      'accounts' => 'Accounts',
      'casesPrimary' => 'Cases (Primary)',
      'tasksPrimary' => 'Tasks (expanded)',
      'opportunitiesPrimary' => 'Opportunities (Primary)',
      'portalUser' => 'Portal User',
      'originalLead' => 'Original Lead',
      'documents' => 'Documents',
      'quotesBilling' => 'Quotes (Billing)',
      'quotesShipping' => 'Quotes (Shipping)',
      'salesOrdersBilling' => 'Sales Orders (Billing)',
      'salesOrdersShipping' => 'Sales Orders (Shipping)',
      'invoicesBilling' => 'Invoices (Billing)',
      'invoicesShipping' => 'Invoices (Shipping)',
      'purchaseOrdersBilling' => 'Purchase Orders (Billing)',
      'purchaseOrdersShipping' => 'Purchase Orders (Shipping)',
      'deliveryOrdersShipping' => 'Delivery Orders (Shipping)',
      'returnOrdersBilling' => 'Return Orders (Billing)',
      'returnOrdersShipping' => 'Return Orders (Shipping)',
      'receiptOrdersShipping' => 'Receipt Orders (Shipping)',
      'analytics' => 'Analytics',
      'user' => 'User',
      'bdmuser' => 'BDM User',
      'partnersGoogleCloud' => 'Partners Google Cloud',
      'partnersGoogleClouds' => 'Program Google Clouds',
      'programGoogleCloud' => 'Programa Google Cloud',
      'programGoogleClouds' => 'Programa Google Clouds',
      'cPB' => 'CPB',
      'dSET' => 'DSET',
      'quotes' => 'Quotes',
      'opportunity' => 'Opportunity',
      'billingContactOpportunities' => 'Opportunities',
      'accountVBM' => 'Account VBM',
      'emailContents' => 'Email Contents',
      'dataAIAssessment' => 'Data AI Assessment',
      'cMarketing' => 'Marketing',
      'cAccountEndCustomer' => 'Account End Customer'
    ],
    'labels' => [
      'Create Contact' => 'Create Contact'
    ],
    'options' => [
      'opportunityRole' => [
        '' => '',
        'Decision Maker' => 'Decision Maker',
        'Evaluator' => 'Evaluator',
        'Influencer' => 'Influencer'
      ],
      'type' => [
        '' => '',
        'Revenda' => 'Revenda',
        'Cliente Final' => 'Cliente Final',
        'ISV' => 'ISV',
        'Renewal' => 'Renewal',
        'Customer' => 'Customer',
        'Reseller' => 'Reseller',
        'Primary' => 'Primary Contact',
        'Finance' => 'Finance',
        'Sales' => 'Sales'
      ],
      'archivosDeIntereses' => [
        'SMB Sales Scenarios - FY22' => 'SMB Sales Scenarios - FY22',
        'Azure App Modernization PDF' => 'Azure App Modernization PDF',
        'Azure Open Source PDF' => 'Azure Open Source PDF',
        'Azure Virtual Desktop PDF' => 'Azure Virtual Desktop PDF',
        'Azure Analytics PDF' => 'Azure Analytics PDF',
        'Azure Migration PDF' => 'Azure Migration PDF',
        'Azure Fundamental Guide PDF' => 'Azure Fundamental Guide PDF',
        'SPA Security PDF' => 'SPA Security PDF',
        'Latam Partner One :: Step by Step' => 'Latam Partner One :: Step by Step'
      ],
      'source' => [
        '' => '',
        'CloudSolv' => 'CloudSolv',
        'Campaign' => 'Campaign',
        'Commercial Portfolio' => 'Commercial Portfolio',
        'Manufacturer' => 'Manufacturer',
        'Meetings' => 'Meetings'
      ]
    ],
    'presetFilters' => [
      'portalUsers' => 'Portal Users',
      'notPortalUsers' => 'Not Portal Users',
      'accountActive' => 'Active'
    ]
  ],
  'Document' => [
    'labels' => [
      'Create Document' => 'Create Document',
      'Details' => 'Details'
    ],
    'fields' => [
      'name' => 'Name',
      'status' => 'Status',
      'file' => 'File',
      'type' => 'Type',
      'publishDate' => 'Publish Date',
      'expirationDate' => 'Expiration Date',
      'description' => 'Description',
      'accounts' => 'Accounts',
      'folder' => 'Folder',
      'service' => 'Service',
      'importers' => 'Importers',
      'quote' => 'Quote',
      'quotes' => 'Quotes',
      'avisoEstimativa' => 'Notice'
    ],
    'links' => [
      'accounts' => 'Accounts',
      'opportunities' => 'Opportunities',
      'folder' => 'Folder',
      'leads' => 'Leads',
      'contacts' => 'Contacts',
      'service' => 'Service',
      'importers' => 'Importers',
      'quote' => 'Quote',
      'quotes' => 'Quotes'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Draft' => 'Draft',
        'Expired' => 'Expired',
        'Canceled' => 'Canceled'
      ],
      'type' => [
        '' => 'None',
        'Contract' => 'Contract',
        'NDA' => 'None',
        'EULA' => 'EULA',
        'License Agreement' => 'License Agreement',
        'Cotação' => 'Quote',
        'Estimativa' => 'Estimate'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active',
      'draft' => 'Draft'
    ]
  ],
  'DocumentFolder' => [
    'labels' => [
      'Create DocumentFolder' => 'Create Document Folder',
      'Manage Categories' => 'Manage Folders',
      'Documents' => 'Documents'
    ],
    'links' => [
      'documents' => 'Documents'
    ]
  ],
  'EmailQueueItem' => [
    'fields' => [
      'name' => 'Name',
      'status' => 'Status',
      'target' => 'Target',
      'sentAt' => 'Date Sent',
      'attemptCount' => 'Attempts',
      'emailAddress' => 'Email Address',
      'massEmail' => 'Mass Email',
      'isTest' => 'Is Test'
    ],
    'links' => [
      'target' => 'Target',
      'massEmail' => 'Mass Email'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pending',
        'Sent' => 'Sent',
        'Failed' => 'Failed',
        'Sending' => 'Sending'
      ]
    ],
    'presetFilters' => [
      'pending' => 'Pending',
      'sent' => 'Sent',
      'failed' => 'Failed'
    ]
  ],
  'KnowledgeBaseArticle' => [
    'labels' => [
      'Create KnowledgeBaseArticle' => 'Create Article',
      'Any' => 'Any',
      'Send in Email' => 'Send in Email',
      'Move Up' => 'Move Up',
      'Move Down' => 'Move Down',
      'Move to Top' => 'Move to Top',
      'Move to Bottom' => 'Move to Bottom'
    ],
    'fields' => [
      'name' => 'Name',
      'status' => 'Status',
      'type' => 'Type',
      'attachments' => 'Attachments',
      'publishDate' => 'Publish Date',
      'expirationDate' => 'Expiration Date',
      'description' => 'Description',
      'body' => 'Body',
      'categories' => 'Categories',
      'language' => 'Language',
      'portals' => 'Portals'
    ],
    'links' => [
      'cases' => 'Cases',
      'opportunities' => 'Opportunities',
      'categories' => 'Categories',
      'portals' => 'Portals'
    ],
    'options' => [
      'status' => [
        'In Review' => 'In Review',
        'Draft' => 'Draft',
        'Archived' => 'Archived',
        'Published' => 'Published'
      ],
      'type' => [
        'Article' => 'Article'
      ]
    ],
    'tooltips' => [
      'portals' => 'Article will be available only in specified portals.'
    ],
    'presetFilters' => [
      'published' => 'Published'
    ]
  ],
  'KnowledgeBaseCategory' => [
    'labels' => [
      'Create KnowledgeBaseCategory' => 'Create Category',
      'Manage Categories' => 'Manage Categories',
      'Articles' => 'Articles'
    ],
    'links' => [
      'articles' => 'Articles'
    ]
  ],
  'Lead' => [
    'labels' => [
      'Converted To' => 'Converted To',
      'Create Lead' => 'Create Lead',
      'Convert' => 'Convert',
      'convert' => 'convert'
    ],
    'fields' => [
      'name' => 'Name',
      'emailAddress' => 'Email',
      'title' => 'Title',
      'website' => 'Website',
      'phoneNumber' => 'Phone',
      'accountName' => 'Account Name',
      'doNotCall' => 'Do Not Call',
      'address' => 'Address',
      'status' => 'Status',
      'source' => 'Source',
      'opportunityAmount' => 'Opportunity Amount',
      'opportunityAmountConverted' => 'Opportunity Amount (converted)',
      'description' => 'Description',
      'createdAccount' => 'Account',
      'createdContact' => 'Contact',
      'createdOpportunity' => 'Opportunity',
      'convertedAt' => 'Converted At',
      'campaign' => 'Campaign',
      'targetLists' => 'Target Lists',
      'targetList' => 'Target List',
      'industry' => 'Industry',
      'acceptanceStatus' => 'Acceptance Status',
      'opportunityAmountCurrency' => 'Opportunity Amount Currency',
      'acceptanceStatusMeetings' => 'Acceptance Status (Meetings)',
      'acceptanceStatusCalls' => 'Acceptance Status (Calls)',
      'originalEmail' => 'Original Email',
      'parceiros' => 'Company (OLD)',
      'type' => 'Type',
      'countryList' => 'Country',
      'user' => 'User',
      'externalId' => 'ExternalId',
      'engagementId' => 'EngagementId',
      'expirationDateTime' => 'Expires on:',
      'calls1' => 'Calls',
      'industria' => 'MX Industry',
      'nurturingProfile' => 'Nurturing Profile',
      'createSurestep' => 'Convert Lead and Create Surestep',
      'surestep' => 'Surestep',
      'iDSynnex' => 'ID SYNNEX',
      'ciscoProjectWon' => 'Project Closed?',
      'ciscoPrograms' => 'Cisco Programs',
      'alreadyContacted' => 'Contacted?',
      'cnpj' => 'CNPJ',
      'brand' => 'Product Brand',
      'brands' => 'Product Brands',
      'opportunities' => 'Opportunities',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'createdAtVendor' => 'CreatedAtVendor',
      'conversionForecast' => 'Lead Conversion Forecast',
      'marketings' => 'Specify the origin'
    ],
    'links' => [
      'targetLists' => 'Target Lists',
      'campaignLogRecords' => 'Campaign Log',
      'campaign' => 'Campaign',
      'createdAccount' => 'Account',
      'createdContact' => 'Contact',
      'createdOpportunity' => 'Opportunity',
      'cases' => 'Cases',
      'documents' => 'Documents',
      'parceiros' => 'Empresa (OLD)',
      'user' => 'User',
      'calls1' => 'Calls',
      'surestep' => 'Surestep',
      'ciscoPrograms' => 'Cisco Programs',
      'brand' => 'Product Brands',
      'brands' => 'Brands',
      'opportunities' => 'Opportunities',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'marketings' => 'Marketings'
    ],
    'options' => [
      'status' => [
        'New' => 'New',
        'Assigned' => 'Assigned',
        'In Process' => 'In Process',
        'Converted' => 'Converted',
        'Recycled' => 'Recycled',
        'Dead' => 'Lost',
        'Ready to contact' => 'Ready to contact',
        'Approved to follow' => 'Approved to follow',
        'Approved to Follow' => 'Approved to Follow'
      ],
      'source' => [
        'Call' => 'Call',
        'Email' => 'Email',
        'Existing Customer' => 'Existing Customer',
        'Partner' => 'Partner',
        'Public Relations' => 'Public Relations',
        'Web Site' => 'Web Site',
        'Campaign' => 'Campaign',
        'Other' => 'Other',
        '' => 'None',
        'Microsoft' => 'Microsoft',
        'MICROSOFT | Projeto Social Selling ISV\'s (Data to Go)' => 'MICROSOFT | Projeto Social Selling ISV\'s (Data to Go)',
        'IBM | Projeto Social Selling (Data to Go)' => 'IBM | Projeto Social Selling (Data to Go)',
        'Microsoft MPC' => 'Microsoft MPC',
        'Social Selling Microsoft CSP' => 'Social Selling Microsoft CSP',
        'Microsoft | Captação novos canais Linkedin' => 'Microsoft | Captação novos canais Linkedin',
        'SYNNEX' => 'SYNNEX',
        'EDGE for Cloud' => 'EDGE for Cloud',
        'ISV Experience' => 'ISV Experience',
        'MSFTPartnerCenter' => 'MSFTPartnerCenter',
        'Geração de Oportunidade - F5' => 'Opportunity Generation - F5',
        'Campanha LGPD - 2022' => 'Campaign LGPD - 2022',
        'Microsoft Surestep Recruitment' => 'Surestep Recruitment',
        'Derivaciones Leads Microsoft Argentina - FY21' => 'Derivaciones Leads Microsoft Argentina - FY21',
        'DG Partner Acquisition Banner IT Sitio Q3FY21' => 'DG Partner Acquisition Banner IT Sitio Q3FY21',
        'Partner Acquisition ISV Q2FY22' => 'Partner Acquisition ISV Q2FY22',
        'CISCO' => 'CISCO',
        'K.NOW' => 'K.NOW',
        'Accelerate' => 'Accelerate',
        'DMP' => 'DMP Cisco',
        'Levantamiento de datos de clientes finales de DATA/IA Segmento corportate' => 'Collection of data from DATA/IA end customers Corporate segment',
        'Lean Sales - Cisco' => 'Lean Sales - Cisco',
        'Telemarketing - Cisco' => 'Telemarketing - Cisco',
        'Select - Cisco' => 'Select - Cisco',
        'Cisco Radius LATAM Q1FY22 Comstor BRA' => 'Cisco Radius LATAM Q1FY22 Comstor BRA',
        'Cisco Radius LATAM Q2FY22 Comstor BRA' => 'Cisco Radius LATAM Q2FY22 Comstor BRA',
        'Cisco Radius LATAM Q3FY22 Comstor BRA' => 'Cisco Radius LATAM Q3FY22 Comstor BRA',
        'Download Content - Surestep' => 'Download Content - Surestep',
        'Submit Form - Surestep' => 'Surestep - Submit Form',
        'Surestep - Activate Campaign' => 'Surestep - Activate Campaign',
        'Surestep - Azure Development' => 'Surestep - Azure Development',
        'Surestep - Azure Recruitment' => 'Surestep - Azure Recruitment',
        'Surestep - Inspire Campaign' => 'Surestep - Inspire Campaign',
        'Surestep - Skyrocket Campaign' => 'Surestep - Skyrocket Campaign',
        'Evento - Terça nas Nuvens' => 'Event - Tuesday in the Clouds',
        'Surestep Recruitment' => 'Surestep Recruitment',
        'Cisco Radius' => 'Cisco Radius',
        'Cisco - Synnex Westcon Comstor - Cisco & Pure Storage' => 'Cisco - Synnex Westcon Comstor - Cisco & Pure Storage',
        'Cisco - HYPE Solutions & TD Synnex' => 'Cisco - HYPE Solutions & TD Synnex',
        'Cisco - DAP: Goahead Demand Generation' => 'Cisco - DAP: Goahead Demand Generation',
        'Cisco - DAP: Think Digital Demand Generation' => 'Cisco - DAP: Think Digital Demand Generation',
        'Cisco - Social Selling ' => 'Cisco - Social Selling ',
        'Cisco - SCALE: Demand Generation Collaboration' => 'Cisco - SCALE: Demand Generation Collaboration',
        'Cisco - DAP: Cisco Unified Campaign Demand Generation' => 'Cisco - DAP: Cisco Unified Campaign Demand Generation',
        'Cisco - DAP: HYPE & Cisco Hyperflex Tech Experience ' => 'Cisco - DAP: HYPE & Cisco Hyperflex Tech Experience ',
        'Cisco - DAP: Evento 12 CIOs Interatell ' => 'Cisco - DAP: Evento 12 CIOs Interatell ',
        'Cisco - DAP: Plano de ações ND&C ' => 'Cisco - DAP: ND&C Action Plan',
        'Cisco - DAP: Plano de Ações da NEXA ' => 'Cisco - DAP: NEXA Action Plan',
        'Cisco & Synnex Comstor - Secure Remote Work' => 'Cisco & Synnex Comstor - Secure Remote Work',
        'Cisco & Synnex Comstor - MIT SLOAN' => 'Cisco & Synnex Comstor - MIT SLOAN',
        'Cisco & Veeam Synnex - Pós Evento' => 'Cisco & Veeam Synnex - Post Event',
        'Cisco & Veeam & Synnex Westcon Comstor' => 'Cisco & Veeam & Synnex Westcon Comstor',
        'Cisco & Synnex Comstor - MVC' => 'Cisco & Synnex Comstor - MVC',
        'Cisco & TD Synnex - Lead Gen' => 'Cisco & TD Synnex - Lead Gen',
        'MW - Assessment de Migración' => 'MW - Migration Assessment',
        'MW - Incentivos de venta para cierres de MS365' => 'MW - Sales incentives for MS365 retailers',
        'MW - Incentivo a la primera venta' => 'MW - First sale incentive',
        'MW - XPND (Azure & MWP)' => 'MW - XPND (Azure & MWP)',
        'MW - Capacitación Herramientas colaborativas' => 'MW - Capacity Building Collaborative tools',
        'Azure - Pruebas de concepto' => 'Azure - Proof of Concepts',
        'Azure - Incentivos para nuevos NACs' => 'Azure - Incentives for new NACs',
        'Azure - Webinar AZURE' => 'Azure - Webinar AZURE',
        'MW - Webinar MW' => 'MW - Webinar MW',
        'Azure - Referido Microsoft ' => 'Azure - Microsoft Referral',
        'Azure - Partner Center' => 'Azure - Partner Center',
        'Azure - Alianza ruta N' => 'Azure - Route N Alliance',
        'Azure - Alianza Rockstart' => 'Azure - Alliance Rockstart',
        'Azure - Evento StartCo' => 'Azure - StartCo Event',
        'Azure - Base Edtech/Legaltech/Proptech' => 'Azure - Base Edtech/Legaltech/Proptech',
        'Azure / MW - Partner' => 'Azure / MW - Partner',
        'Microsoft AR - Agencia Novaz' => 'Microsoft AR - Novaz Agency',
        'Microsoft AR - Agencia Marco Marketing' => 'Microsoft AR - Marco Marketing Agency',
        'Microsoft AR - Leads Generados Mediaware (Enfasys)' => 'Microsoft AR - Mediaware Generated Leads (Enfasys)',
        'Microsoft AR - Webinars' => 'Microsoft AR - Webinars',
        'Microsoft AR - SureStep Programs' => 'Microsoft AR - SureStep Programs',
        'Microsoft AR – Prensa' => 'Microsoft AR – Press',
        'Microsoft AR – IT SITIO' => 'Microsoft AR – IT SITIO',
        'Microsoft AR – Corefone' => 'Microsoft AR – Corefone',
        'CO-MW-Assessment de Migración' => 'CO-MW-Migration Assessment',
        'CO-MW-Incentivo venta para cierres MW' => 'CO-MW-Incentive sales for larger MW',
        'CO-MW-Incentivo ventas mensuales MW' => 'CO-MW-MW monthly sales incentive',
        'CO-MW-Incentivo primera Venta' => 'CO-MW-First Sale Incentive',
        'CO-MW-Capacitación Herramientas colaborativas' => 'CO-MW-Capacitación Collaborative tools',
        'EC-MW-Incentivo venta para cierres MW' => 'EC-MW-Incentive sales for larger MW',
        'EC-MW-Incentivo ventas mensuales MW' => 'EC-MW-MW monthly sales incentive',
        'EC-MW-Incentivo primera Venta' => 'EC-MW-First Sale Incentive',
        'Atividades de Marketing' => 'Marketing Activities',
        'Microsoft – Evento CCE (FIESP)' => 'Microsoft – CCE Event (FIESP)',
        'Microsoft CCE - Comunicação ' => 'Microsoft CCE - Communication',
        'Nuvens Carregadas Opp' => 'Opp Storm Clouds'
      ],
      'type' => [
        '' => '',
        'Customer' => 'Customer',
        'Reseller' => 'Reseller',
        'ISV' => 'ISV',
        'Operadora/ISP' => 'Operator/ISP',
        'Fabricante' => 'Product Brand',
        'TD SYNNEX' => 'TD SYNNEX',
        'ISV / Startup Parceira TD SYNNEX' => 'ISV / Startup Parceira TD SYNNEX',
        'ISV / Startup não Parceira TD SYNNEX' => 'ISV / Startup não Parceira TD SYNNEX',
        'Revenda de TI Parceira TD SYNNEX' => 'Revenda de TI Parceira TD SYNNEX',
        'Revenda de TI não Parceira TD SYNNEX' => 'Revenda de TI não Parceira TD SYNNEX'
      ],
      'countryList' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Brasil' => 'Brazil',
        'Caribe' => 'Caribe',
        'CALA' => 'CALA',
        'Centro' => 'Centro',
        'Colombia' => 'Colombia',
        'Chile' => 'Chile',
        'Ecuador' => 'Ecuador',
        'Perú' => 'Perú',
        'Mexico' => 'Mexico',
        'Dominican Republic' => 'Dominican Republic',
        'Bolivia' => 'Bolivia',
        'CCA' => 'CCA',
        'Peru' => 'Peru',
        'Paraguay' => 'Paraguay',
        'Uruguay' => 'Uruguay'
      ],
      'industria' => [
        'Aeroespacial' => 'Aerospace',
        'Agricultura' => 'Agriculture',
        'Agua' => 'Water',
        'Alimentación y bebidas' => 'Food and beverages',
        'Arquitectura' => 'Architecture',
        'Automotriz' => 'Automotive',
        'Banca' => 'Banking',
        'Bienes Raices' => 'Real estate',
        'Biotecnología' => 'Biotechnology',
        'Capital de Riesgo' => 'Venture Capital',
        'Comestibles' => 'Groceries',
        'Compra Total' => 'Purchasing',
        'Computación' => 'Computing',
        'Construcción' => 'Construction',
        'Consultando' => 'Consulting',
        'Creativo' => 'Creative',
        'Cuidado de la Salud' => 'Health Care',
        ' Cultura' => ' Cultura',
        'Defensa' => 'Defense',
        'Deportes' => 'Sports',
        'Educación' => 'Education',
        'Electrónicos' => 'Electronics',
        'Energía' => 'Energy',
        'Energía Eléctrica' => 'Electrical energy',
        'Entrega' => 'Delivery',
        'Entretenimiento y Ocio' => 'Entertainment and Leisure',
        ' Fabricación' => 'Manufacturing',
        ' Finanzas' => 'Finance',
        'Hospitalidad' => 'Hospitality',
        'Jurídico' => 'Legal',
        'Marketing' => 'Marketing',
        'Materiales de construcción y equipamiento' => 'Construction materials and equipment',
        'Medios masivos' => 'Mass media',
        'Menudeo' => 'Retail',
        'Minería' => 'Mining',
        ' Música' => 'Music',
        'Petróleo' => 'Petroleum',
        'Prueba, Inspección y Certificación' => 'Testing, Inspection and Certification',
        'Publicaciones' => 'Publications',
        'Publicidad' => 'Advertising',
        ' Química' => 'Chemistry',
        'Ropa y Accesorios' => 'Clothing and Accessories',
        'Seguros' => 'Insurance',
        'Servicios' => 'Services',
        'Software' => 'Software',
        'Soporte' => 'Support',
        'Tecnología' => 'Technology',
        'Telecomunicaciones' => 'Telecommunications',
        'Televisión' => 'Television',
        'Transporte' => 'Transport',
        'Viaje' => 'ViajeTransport',
        '' => ''
      ],
      'ciscoProjectWon' => [
        'Não' => 'No',
        'Sim' => 'Yes'
      ],
      'alreadyContacted' => [
        '' => '',
        'No' => 'No',
        'Si' => 'Yes',
        'En Curso' => 'In Progress'
      ],
      'conversionForecast' => [
        '' => 'Sem previsão',
        'Immediate' => 'Immediate',
        '1 Month' => '1 Month',
        '3 Months' => '3 Months',
        '6 Months' => '6 Months',
        '2 Months' => '2 Months',
        '4 Months' => '4 Months',
        '5 Months' => '5 Months'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active',
      'actual' => 'Open',
      'converted' => 'Converted'
    ],
    'tooltips' => [
      'createSurestep' => 'This button allows the user to create data in the Surestep Entity. This also converts the Lead into a Contact and creates the Account in both entities. Please, make sure that this Contact or Account does not exist before continuing.

This action can not be undone.'
    ]
  ],
  'MassEmail' => [
    'fields' => [
      'name' => 'Name',
      'status' => 'Status',
      'storeSentEmails' => 'Store Sent Emails',
      'startAt' => 'Date Start',
      'fromAddress' => 'From Address',
      'fromName' => 'From Name',
      'replyToAddress' => 'Reply-to Address',
      'replyToName' => 'Reply-to Name',
      'campaign' => 'Campaign',
      'emailTemplate' => 'Email Template',
      'inboundEmail' => 'Email Account',
      'targetLists' => 'Target Lists',
      'excludingTargetLists' => 'Excluding Target Lists',
      'optOutEntirely' => 'Opt-Out Entirely',
      'smtpAccount' => 'SMTP Account'
    ],
    'links' => [
      'targetLists' => 'Target Lists',
      'excludingTargetLists' => 'Excluding Target Lists',
      'queueItems' => 'Queue Items',
      'campaign' => 'Campaign',
      'emailTemplate' => 'Email Template',
      'inboundEmail' => 'Email Account'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Pending' => 'Pending',
        'In Process' => 'In Process',
        'Complete' => 'Complete',
        'Canceled' => 'Canceled',
        'Failed' => 'Failed'
      ]
    ],
    'labels' => [
      'Create MassEmail' => 'Create Mass Email',
      'Send Test' => 'Send Test',
      'System SMTP' => 'System SMTP',
      'system' => 'system',
      'group' => 'group'
    ],
    'messages' => [
      'selectAtLeastOneTarget' => 'Select at least one target.',
      'testSent' => 'Test email(s) supposed to be sent'
    ],
    'tooltips' => [
      'optOutEntirely' => 'Email addresses of recipients that unsubscribed will be marked as opted out and they will not receive any mass emails anymore.',
      'targetLists' => 'Targets that should receive messages.',
      'excludingTargetLists' => 'Targets that should not receive messages.',
      'storeSentEmails' => 'Emails will be stored in CRM.'
    ],
    'presetFilters' => [
      'actual' => 'Actual',
      'complete' => 'Complete'
    ]
  ],
  'Meeting' => [
    'fields' => [
      'name' => 'Name',
      'parent' => 'Parent',
      'status' => 'Status',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'duration' => 'Duration',
      'description' => 'Description',
      'users' => 'Users',
      'contacts' => 'Contacts',
      'leads' => 'Leads',
      'reminders' => 'Reminders',
      'account' => 'Account',
      'acceptanceStatus' => 'Acceptance Status',
      'dateStartDate' => 'Date Start (all day)',
      'dateEndDate' => 'Date End (all day)',
      'isAllDay' => 'Is All-Day',
      'sourceEmail' => 'Source Email',
      'uid' => 'UID',
      'joinUrl' => 'Join URL'
    ],
    'links' => [],
    'options' => [
      'status' => [
        'Planned' => 'Planned',
        'Held' => 'Held',
        'Not Held' => 'Not Held'
      ],
      'acceptanceStatus' => [
        'None' => 'None',
        'Accepted' => 'Accepted',
        'Declined' => 'Declined',
        'Tentative' => 'Tentative'
      ]
    ],
    'massActions' => [
      'setHeld' => 'Set Held',
      'setNotHeld' => 'Set Not Held'
    ],
    'labels' => [
      'Create Meeting' => 'Create Meeting',
      'Set Held' => 'Set Held',
      'Set Not Held' => 'Set Not Held',
      'Send Invitations' => 'Send Invitations',
      'Send Cancellation' => 'Send Cancellation',
      'on time' => 'on time',
      'before' => 'before',
      'All-Day' => 'All-Day',
      'Acceptance' => 'Acceptance'
    ],
    'presetFilters' => [
      'planned' => 'Planned',
      'held' => 'Held',
      'todays' => 'Today\'s'
    ],
    'messages' => [
      'sendInvitationsToSelectedAttendees' => 'Invitation emails will be sent to the selected attendees.',
      'sendCancellationsToSelectedAttendees' => 'Cancellation emails will be sent to the selected attendees.',
      'selectAcceptanceStatus' => 'Set your acceptance status.',
      'nothingHasBeenSent' => 'Nothing were sent'
    ]
  ],
  'Opportunity' => [
    'fields' => [
      'name' => 'Name',
      'account' => 'Partner',
      'stage' => 'Stage',
      'amount' => 'Amount',
      'probability' => 'Probability, %',
      'leadSource' => 'Lead source',
      'doNotCall' => 'Do Not Call',
      'closeDate' => 'Close Date',
      'contacts' => 'Contacts',
      'contact' => 'Contact (Primary)',
      'description' => 'Description',
      'amountConverted' => 'Amount (converted)',
      'amountWeightedConverted' => 'Amount Weighted',
      'campaign' => 'Campaign',
      'originalLead' => 'Original Lead',
      'amountCurrency' => 'Amount Currency',
      'contactRole' => 'Contact Role',
      'lastStage' => 'Last Stage',
      'itemList' => 'Item List',
      'priceBook' => 'Price Book',
      'licenseType' => 'License Type',
      'partnerResponsible' => 'Partner Responsible',
      'customerType' => 'Tipo de Cliente',
      'productBrand' => 'Product Brand',
      'country' => 'Country',
      'solutionType' => 'Billing',
      'quarter' => 'Quarter',
      'endUser' => 'End User',
      'customer' => 'Customer',
      'sources' => 'Sources',
      'oppSource' => 'Source',
      'dollarIBM' => 'Dólar IBM',
      'dollarIBMCurrency' => 'Dólar IBM (Currency)',
      'dollarIBMConverted' => 'Dólar IBM (Converted)',
      'dollarCIS' => 'Dólar CIS',
      'dollarCISCurrency' => 'Dólar CIS (Currency)',
      'dollarCISConverted' => 'Dólar CIS (Converted)',
      'dollarAmount' => 'Total (USD)',
      'dollarAmountCurrency' => 'Total (Dólar) (Currency)',
      'dollarAmountConverted' => 'Total (Dólar) (Converted)',
      'dollarType' => 'dollar type',
      'requests' => 'orders',
      'technicalSupports' => 'Technical Supports',
      'technicalSupport' => 'Technical Support',
      'techSupportDescription' => 'Description (Technical Support)',
      'endDate' => 'License Expiration Date',
      'accountEmail' => 'E-mail (Partner)',
      'lead' => 'Lead',
      'leadCountry' => 'Country (Lead)',
      'leadEmail' => 'E-mail (Lead)',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'externalId' => 'ExternalId',
      'region' => 'Region',
      'partnerGoogleCloud' => 'Partners Google Cloud',
      'amountDiscount' => 'Total Amount (With Discount)',
      'amountDiscountCurrency' => 'Amount with Discount (Currency)',
      'amountDiscountConverted' => 'Amount with Discount (Converted)',
      'partnersGoogleClouds' => 'Program Google Clouds',
      'partnersGoogleCloud' => 'Program Google Cloud',
      'partnerLevel' => 'Partner Level',
      'products' => 'Products',
      'statusSynced' => 'Status Synced',
      'customerEmail' => 'Email (End User)',
      'countryCustomer' => 'País (End User)',
      'progresoPartner' => 'Partner Progress',
      'googleCalculator' => 'Google calculator link',
      'cdpOpportunityID' => 'Opportunity ID (CDP)',
      'lostReason' => 'Reason for Loss / Cancellation',
      'amountproxconsumo' => 'Approximate Amount of Annual Consumption',
      'reason' => 'Reason for Cancellation',
      'externalIDcdp' => 'ExternalIDcdp',
      'cpb' => 'CPB',
      'submissionID' => 'Submission ID',
      'marketing' => 'Specify the Source',
      'sourceNew' => 'Source',
      'aws' => 'AWS - Partner Program',
      'emailEndUser' => 'Email del Cliente final',
      'paisDelClienteFinal' => 'End Customer Country',
      'newcustomer' => 'New End User',
      'priceBooks' => 'Price Books',
      'stageUpdateAWS' => 'Stage Update AWS',
      'connectedAreasStatus' => 'Status (Connected Areas)',
      'commercialTerms' => 'Commercial Terms',
      'users' => 'VBA/BDR/BDM',
      'discountValue' => 'Total Discount',
      'discountValueCurrency' => 'Total Discount (Currency)',
      'discountValueConverted' => 'Total Discount (Converted)',
      'billingContact' => 'Billing Contact',
      'addEndUser' => 'Add End Customer',
      'quoteDateReview' => 'Review Date - Approved Quote',
      'avisoItens' => 'Notice',
      'quoteApprovalDate' => 'Quote Approval Date',
      'messengers' => 'Messaging',
      'opportunityAWS' => 'Opportunity AWS',
      'useCase' => 'Use Case',
      'opportunityID' => 'Opportunity ID AWS',
      'aWSAccountID' => 'AWS Account ID',
      'sPMSID' => 'SPMS ID',
      'stageAWS' => 'Stage AWS',
      'statusAWS' => 'Status AWS',
      'partnerTypeAWS' => 'Partner Type',
      'segment' => 'Segment',
      'estimatedRevenue' => 'Estimated Monthly Revenue',
      'marketplace' => 'Marketplace',
      'cOpportunityGoogle' => 'Opportunity Google',
      'cNDealRegistration' => 'N° Deal Registration (Si aplica)',
      'cCategoryGoogle' => 'Category',
      'DR' => 'Deal Registration (DR)'
    ],
    'links' => [
      'contacts' => 'Contacts',
      'contact' => 'Contact (Primary)',
      'documents' => 'Documents',
      'campaign' => 'Campaign',
      'originalLead' => 'Original Lead',
      'quotes' => 'Quotes',
      'salesOrders' => 'Sales Orders',
      'invoices' => 'Invoices',
      'items' => 'Items',
      'priceBook' => 'Price Book',
      'productBrand' => 'Product Brand',
      'customer' => 'Customer',
      'sources' => 'Source',
      'oppSource' => 'Source',
      'technicalSupports' => 'Technical Support',
      'technicalSupport' => 'Technical Support',
      'lead' => 'Lead',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'regiones' => 'Region',
      'partnerGoogleCloud' => 'Partners Google Cloud',
      'partnersGoogleClouds' => 'Program Google Clouds',
      'partnersGoogleCloud' => 'Program Google Cloud',
      'products' => 'Products',
      'progresoPartner' => 'Progress Partner',
      'cpb' => 'CPB',
      'marketing' => 'Specify the Source',
      'aws' => 'AWS - Partner Program',
      'priceBooks' => 'Price Books',
      'users' => 'BDM User',
      'billingContact' => 'Billing Contact',
      'messengers' => 'Messaging',
      'opportunityAWS' => 'Opportunity AWS',
      'cOpportunityGoogle' => 'Opportunity Google'
    ],
    'options' => [
      'stage' => [
        'Prospecting' => 'Prospecting',
        'Qualification' => 'Qualification',
        'Proposal' => 'Proposal',
        'Negotiation' => 'Negotiation',
        'Needs Analysis' => 'Needs Analysis',
        'Value Proposition' => 'Value Proposition',
        'Id. Decision Makers' => 'Id. Decision Makers',
        'Perception Analysis' => 'Perception Analysis',
        'Proposal/Price Quote' => 'Proposal/Price Quote',
        'Negotiation/Review' => 'Negotiation/Review',
        'Closed Won' => 'Closed Won',
        'Closed Lost' => 'Closed Lost',
        'Opportunity Technical Feasibility' => 'Opportunity Technical Feasibility',
        'Opportunity Commercial Qualification' => 'Opportunity Commercial Qualification',
        'Implementation' => 'Implementation',
        'Cancelada' => 'Cancelled'
      ],
      'licenseType' => [
        '' => '',
        'CSP' => 'CSP',
        'Open' => 'Open',
        'AWS' => 'AWS',
        'Azure' => 'Azure',
        'M365' => 'M365 Monthly',
        'Renewal' => 'Renewal',
        'Services' => 'Services',
        'Dynamics 365' => 'Dynamics 365',
        'Software Subscription' => 'Software Subscription',
        'Software Perpetual' => 'Software Perpetual',
        'M365 Annual' => 'M365 Annual',
        'Modern Workplace' => 'Modern Workplace',
        'Azure IR' => 'Azure IR',
        'NCE' => 'NCE',
        'Open Value SA' => 'Open Value SA',
        'Open Value Subscription 1 Ano' => 'Open Value Subscription 1 Ano',
        'Open Value Subscription 3 Anos' => 'Open Value Subscription 3 Anos',
        'Open Value' => 'Open Value',
        'Open Value Perpetual' => 'Open Value Perpetual',
        'Renovações' => 'Renewals',
        'SPLA' => 'SPLA',
        'SW Perpetual' => 'SW Perpetual',
        'SW Subscription 1 Ano' => 'SW Subscription 1 Ano',
        'SW Subscription 3 Anos' => 'SW Subscription 3 Anos',
        'ESA' => 'ESA',
        'Marketplace' => 'Marketplace',
        'Pay As You Go' => 'Pay As You Go',
        'New Business' => 'New Business',
        'Upgrade' => 'Upgrade',
        'Google Cloud Platform' => 'Google Cloud Platform',
        'Google Workspace' => 'Google Workspace',
        'Commit - GCP' => 'Commit - GCP',
        'Commit - WS' => 'Commit - WS',
        'Google Workspace Starter' => 'Google Workspace Starter',
        'Google Workspace Business (1-300 Seats)' => 'Google Workspace Business (1-300 Seats)',
        'Google Workspace Essentials' => 'Google Workspace Essentials',
        'Google Workspace Standard' => 'Google Workspace Standard',
        'Google Workspace Plus' => 'Google Workspace Plus',
        'Google Workspace AppSheet' => 'Google Workspace AppSheet',
        'Cloud Identity' => 'Cloud Identity',
        'Google Vault' => 'Google Vault',
        'Google Voice' => 'Google Voice',
        'Google Workspace Business' => 'Google Workspace Business',
        'Google Workspace Enterprise' => 'Google Workspace Enterprise'
      ],
      'customerType' => [
        'Enterprise' => 'Enterprise',
        'ISV' => 'ISV',
        'SMB' => 'SMB',
        '' => '',
        'Public' => 'Public',
        'Corporate' => 'Corporativo',
        'Government' => 'Governo'
      ],
      'solutionType' => [
        '' => '',
        'Modern Workplace (Annual)' => 'Modern Workplace (Annual)',
        'Modern Workplace (Monthly)' => 'Modern Workplace (Monthly)',
        'Software (Perpetual)' => 'Software (Perpetual)',
        'Software (Subscription)' => 'Software (Subscription)',
        'Modern Workplace (3 Years)' => 'Modern Workplace (3 Years)',
        'Reserved Instances (1 Year)' => 'Reserved Instances (1 Year)',
        'Reserved Instances (3 Years)' => 'Reserved Instances (3 Years)',
        'Monthly' => 'Monthly',
        'Annual' => 'Annual - 1 year',
        '3 Years' => '3 years',
        'Perpetual' => 'One Time (Perpetual)',
        'Annual - 3 Years' => 'Annual - 3 years',
        'One Time' => 'One Time',
        'Open Value Perpetual' => 'Open Value Perpetual',
        'Open Value Subscription 1 Year' => 'Open Value Subscription 1 Year',
        'Open Value Subscription 3 Years' => 'Open Value Subscription 3 Years',
        'SW Perpétuo' => 'SW Perpétuo',
        'SW Subscription 1 ano' => 'SW Subscription 1 ano',
        '2 Years' => '2 years',
        'Annual - Monthly Payment' => 'Annual - Monthly Payment',
        'Flexible' => 'Flexible',
        'Trial' => 'Trial',
        'Pay as you go' => 'Pay as you go',
        'Upfront' => 'Upfront'
      ],
      'quarter' => [
        '' => '',
        'Q1' => 'Q1',
        'Q2' => 'Q2',
        'Q3' => 'Q3',
        'Q4' => 'Q4'
      ],
      'dollarType' => [
        '' => '',
        'Dólar CIS' => 'Dólar CIS',
        'Dólar IBM' => 'Dólar IBM'
      ],
      'requests' => [
        '' => '',
        'VBM Enterprise' => 'VBM Enterprise',
        'Cloud' => 'Cloud',
        'On Premise' => 'On Premise'
      ],
      'lostReason' => [
        '' => '',
        'Otro proveedor' => 'Other provider',
        'Otro partner de Google' => 'Another Google partner',
        'Tiempo de vigencia de propuestaPrecio' => 'Proposal validity period',
        'Más adelante' => 'Later',
        'Licitación perdida' => 'Lost bid',
        'Concorrente Tier 1' => 'Tier 1 Competitor',
        'Concorrente MOSP' => 'MOSP Competitor',
        'Concorrente (Outro Distribuidor)' => 'Competitor (Other Distributor)',
        'Concorrente EA' => 'Concorrente EA competitor',
        'Concorrente (Outro Fabricante)' => 'Competitor (Other Manufacturer)',
        'WO' => 'WO',
        'Cadastro Reprovado' => 'Registration Failed',
        'Crédito Reprovado' => 'Disapproved Credit',
        'Concorrente MPSA' => 'MPSA Competitor',
        'Concorrente ESD' => 'ESD Competitor',
        'Prazo de Pagamento' => 'Payment Term',
        'Cliente final desistiu da compra' => 'End customer abandoned the purchase',
        'Opp Duplicada' => 'Duplicated Opportunity',
        'Fechado com outro Revendedor' => 'Closed with another Reseller',
        'Sem retorno do Revendedor / Cliente final' => 'No return from Reseller / End Customer',
        'Contrato não efetivado (Stellr)' => 'Contract not executed (Stellr)',
        'Cancelada por falta de atualização interna' => 'Canceled due to lack of internal update'
      ],
      'reason' => [
        'O cliente não tinha um orçamento' => 'The client does not have an ornament',
        'Cliente/oportunidade muito pequena' => 'Very small client/opportunity',
        'O cliente não respondeu' => 'The client did not respond',
        'O cliente escolheu outro fornecedor' => 'The client chooses another supplier',
        'Minha solução ou serviços não é um ajuste' => 'My solution or services is not an adjustment',
        'Não é cliente' => 'I\'m not a client',
        'Linha de tempo proposta muito curta' => 'Line of time proposed very short',
        'Relatar como abuso, phishing' => 'Report as abuse, phishing',
        'Outro' => 'Other'
      ],
      'sourceNew' => [
        '' => '',
        'Campanhas' => 'Campaigns',
        'Meetings' => 'Meetings',
        'Carteira do BDM' => 'Carteira do BDM',
        'Fabricante' => 'Vendor',
        'Carteira Comercial ' => 'Commercial Portfolio'
      ],
      'newcustomer' => [
        'New customer' => 'New End User '
      ],
      'connectedAreasStatus' => [
        '' => '',
        'Envolvido' => 'Envolvido',
        'Pendente' => 'Pending',
        'Respondido' => 'Answered',
        'Aguardando Retorno' => 'Waiting for return',
        'BDM' => 'BDM',
        'Movimentação' => 'Movimentação',
        'N/A' => 'N/A'
      ]
    ],
    'labels' => [
      'Create Opportunity' => 'Create Opportunity',
      'Items' => 'Items',
      'Select Product' => 'Select Product',
      'Add Item' => 'Add Item',
      'Add Products' => 'Add Products'
    ],
    'presetFilters' => [
      'open' => 'Open',
      'won' => 'Won',
      'lost' => 'Lost'
    ],
    'panels' => [
      'items' => 'Items'
    ],
    'tooltips' => [
      'discountValue' => '(PT-BR) \\nThe value entered must be zero or negative. If this value is not updated after saving the opportunity, please reload the page (Press F5). (Spanish) The value entered must be zero or negative. If this value is not updated after saving the opportunity, please Reload the page (Press F5).'
    ]
  ],
  'TargetList' => [
    'fields' => [
      'name' => 'Name',
      'description' => 'Description',
      'entryCount' => 'Entry Count',
      'optedOutCount' => 'Opted Out Count',
      'campaigns' => 'Campaigns',
      'endDate' => 'End Date',
      'targetLists' => 'Target Lists',
      'includingActionList' => 'Including',
      'excludingActionList' => 'Excluding',
      'targetStatus' => 'Target Status',
      'isOptedOut' => 'Is Opted Out',
      'sourceCampaign' => 'Source Campaign',
      'syncWithReports' => 'Reports',
      'syncWithReportsEnabled' => 'Enabled',
      'syncWithReportsUnlink' => 'Unlink'
    ],
    'links' => [
      'accounts' => 'Accounts',
      'contacts' => 'Contacts',
      'leads' => 'Leads',
      'campaigns' => 'Campaigns',
      'massEmails' => 'Mass Emails',
      'syncWithReports' => 'Sync with Reports'
    ],
    'options' => [
      'type' => [
        'Email' => 'Email',
        'Web' => 'Web',
        'Television' => 'Television',
        'Radio' => 'Radio',
        'Newsletter' => 'Newsletter'
      ],
      'targetStatus' => [
        'Opted Out' => 'Opted Out',
        'Listed' => 'Listed'
      ]
    ],
    'labels' => [
      'Create TargetList' => 'Create Target List',
      'Opted Out' => 'Opted Out',
      'Cancel Opt-Out' => 'Cancel Opt-Out',
      'Opt-Out' => 'Opt-Out',
      'Sync with Reports' => 'Sync with Reports'
    ],
    'tooltips' => [
      'syncWithReportsEnabled' => 'Enable auto-sync with a list report.',
      'syncWithReportsUnlink' => 'Entries which are not contained in report results will be unlinked from Target List.',
      'syncWithReports' => 'Target List will be synced with results of selected reports.'
    ]
  ],
  'Task' => [
    'fields' => [
      'name' => 'Name',
      'parent' => 'Parent',
      'status' => 'Status',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date Due',
      'dateStartDate' => 'Date Start (all day)',
      'dateEndDate' => 'Date End (all day)',
      'priority' => 'Priority',
      'description' => 'Description',
      'isOverdue' => 'Is Overdue',
      'account' => 'Account',
      'dateCompleted' => 'Date Completed',
      'attachments' => 'Attachments',
      'reminders' => 'Reminders',
      'contact' => 'Contact',
      'originalEmail' => 'Original Email',
      'emailUser' => 'Email User',
      'tarea' => 'Task',
      'productBrands' => 'Product Brand',
      'country' => 'Country',
      'region' => 'Region',
      'fabricante' => 'Product Brand',
      'productBrand' => 'Product Brand',
      'tag' => 'Tag',
      'countryTask' => 'Country'
    ],
    'links' => [
      'attachments' => 'Attachments',
      'account' => 'Account',
      'contact' => 'Contact',
      'email' => 'Email',
      'productBrands' => 'Product Brand',
      'fabricante' => 'Fabricante',
      'productBrand' => 'Product Brand'
    ],
    'options' => [
      'status' => [
        'Not Started' => 'Not Started',
        'Started' => 'Started',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Deferred' => 'Deferred',
        'Recibida' => 'Received'
      ],
      'priority' => [
        'Low' => 'Low',
        'Normal' => 'Normal',
        'High' => 'High',
        'Urgent' => 'Urgent'
      ],
      'tarea' => [
        1 => '1',
        '' => ''
      ],
      'tag' => [
        '' => '',
        'Ready for test' => 'Ready for Test',
        'Ready for deploy' => 'Ready for deploy',
        'Stand-by' => 'Stand-by',
        'Blocked' => 'Blocked',
        'In Approval' => 'In Approval',
        'Recurrent' => 'Recorrente'
      ],
      'countryTask' => [
        '' => '',
        'Brasil' => 'Brazil',
        'MCA' => 'MCA'
      ]
    ],
    'labels' => [
      'Create Task' => 'Create Task',
      'Complete' => 'Complete',
      'overdue' => 'overdue'
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed',
      'deferred' => 'Deferred',
      'todays' => 'Today\'s',
      'overdue' => 'Overdue'
    ],
    'nameOptions' => [
      'replyToEmail' => 'Reply to email'
    ]
  ],
  'BpmnFlowNode' => [
    'labels' => [
      'Reset' => 'Reset'
    ],
    'fields' => [
      'status' => 'Status',
      'processedAt' => 'Processed At',
      'elementType' => 'Element Type',
      'element' => 'Element'
    ],
    'options' => [
      'status' => [
        'Created' => 'Created',
        'Pending' => 'Pending',
        'In Process' => 'In Process',
        'Standby' => 'Standby',
        'Processed' => 'Processed',
        'Rejected' => 'Rejected',
        'Failed' => 'Failed',
        'Interrupted' => 'Interrupted'
      ]
    ]
  ],
  'BpmnFlowchart' => [
    'labels' => [
      'Create BpmnFlowchart' => 'Create Flowchart',
      'Hand tool' => 'Hand tool',
      'Create Event tool' => 'Create Event tool',
      'Create Gateway tool' => 'Create Event tool',
      'Create Activity tool' => 'Create Activity tool',
      'Connect tool' => 'Connect tool',
      'Erase tool' => 'Erase tool',
      'Full Screen' => 'Full Screen',
      'Processes' => 'Processes',
      'data' => 'Data',
      'Zoom In' => 'Zoom In',
      'Zoom Out' => 'Zoom Out',
      'Error' => 'Error',
      'Events' => 'Events',
      'Activities' => 'Activities',
      'Gateways' => 'Gateways'
    ],
    'fields' => [
      'isActive' => 'Is Active',
      'targetType' => 'Target Entity Type',
      'data' => 'Data',
      'hasNoneStartEvent' => 'Has Start Event of None type'
    ],
    'links' => [
      'processes' => 'Processes'
    ],
    'elements' => [
      'eventStartConditional' => 'Conditional Start Event',
      'eventStartTimer' => 'Timer Start Event',
      'eventStartError' => 'Error Start Event',
      'eventStartEscalation' => 'Escalation Start Event',
      'eventStartSignal' => 'Signal Start Event',
      'eventStart' => 'Start Event',
      'eventStartCompensation' => 'Compensation Start Event',
      'eventStartConditionalEventSubProcess' => 'Sub-Process Conditional Start Event',
      'eventStartTimerEventSubProcess' => 'Sub-Process Timer Start Event',
      'eventStartSignalEventSubProcess' => 'Sub-Process Signal Start Event',
      'eventIntermediateTimerCatch' => 'Timer Intermediate Event (Catching)',
      'eventIntermediateConditionalCatch' => 'Conditional Intermediate Event (Catching)',
      'eventIntermediateEscalationThrow' => 'Escalation Intermediate Event (Throwing)',
      'eventIntermediateSignalThrow' => 'Signal Intermediate Event (Throwing)',
      'eventIntermediateCompensationThrow' => 'Compensation Intermediate Event (Throwing)',
      'eventIntermediateSignalCatch' => 'Signal Intermediate Event (Catching)',
      'eventIntermediateMessageCatch' => 'Message Intermediate Event (Catching)',
      'eventEnd' => 'End Event',
      'eventEndTerminate' => 'Terminate End Event',
      'eventEndError' => 'Error End Event',
      'eventEndEscalation' => 'Escalation End Event',
      'eventEndSignal' => 'Signal End Event',
      'eventEndCompensation' => 'Compensation End Event',
      'eventIntermediateErrorBoundary' => 'Error Intermediate Event (Boundary)',
      'eventIntermediateTimerBoundary' => 'Timer Intermediate Event (Boundary)',
      'eventIntermediateConditionalBoundary' => 'Conditional Intermediate Event (Boundary)',
      'eventIntermediateEscalationBoundary' => 'Escalation Intermediate Event (Boundary)',
      'eventIntermediateSignalBoundary' => 'Signal Intermediate Event (Boundary)',
      'eventIntermediateMessageBoundary' => 'Message Intermediate Event (Boundary)',
      'eventIntermediateCompensationBoundary' => 'Compensation Intermediate Event (Boundary)',
      'gatewayExclusive' => 'Exclusive Gateway',
      'gatewayInclusive' => 'Inclusive Gateway',
      'gatewayParallel' => 'Parallel Gateway',
      'gatewayEventBased' => 'Event Based Gateway',
      'taskSendMessage' => 'Send Message Task',
      'taskScript' => 'Script Task',
      'taskBusinessRule' => 'Business Rule Task',
      'taskUser' => 'User Task',
      'task' => 'Task',
      'callActivity' => 'Call Activity',
      'subProcess' => 'Sub-Process',
      'eventSubProcess' => 'Event Sub-Process',
      'flow' => 'Sequence Flow'
    ],
    'presetFilters' => [
      'isManuallyStartable' => 'Manually Startable',
      'activeHasNoneStartEvent' => 'Active w/ None Start Event',
      'active' => 'Active'
    ]
  ],
  'BpmnFlowchartElement' => [
    'fields' => [
      'text' => 'Text',
      'triggerType' => 'Trigger Type',
      'timer' => 'Timer Parameters',
      'defaultFlowId' => 'Default Flow',
      'from' => 'From',
      'to' => 'To',
      'replyTo' => 'Reply-To',
      'cc' => 'CC',
      'fromEmailAddress' => 'From Email Address',
      'toEmailAddress' => 'To Email Address',
      'replyToEmailAddress' => 'Reply-To Email Address',
      'ccEmailAddress' => 'CC Email Address',
      'toSpecifiedTeams' => 'To Teams',
      'toSpecifiedUsers' => 'To Users',
      'toSpecifiedContacts' => 'To Contacts',
      'attachmentsVariable' => 'Attachments Variable',
      'emailTemplate' => 'Email Template',
      'doNotStore' => 'Do not store sent email',
      'actions' => 'Actions',
      'formula' => 'Formula (script)',
      'actionType' => 'Action Type',
      'targetUser' => 'Target User',
      'assignmentType' => 'Assignment',
      'targetTeam' => 'Target Team',
      'targetUserPosition' => 'Target User Position',
      'startDirection' => 'Start Direction',
      'targetReport' => 'Target Report',
      'scheduling' => 'Scheduling',
      'schedulingApplyTimezone' => 'Apply timezone',
      'messageType' => 'Message Type',
      'canBeFailed' => 'Can be Failed',
      'target' => 'Target',
      'callableType' => 'Callable Type',
      'errorCode' => 'Error Code',
      'escalationCode' => 'Escalation Code',
      'cancelActivity' => 'Is Interrupting',
      'isInterrupting' => 'Is Interrupting',
      'targetType' => 'Target Entity Type',
      'flowchartVisualization' => 'Flowchart',
      'flowchart' => 'Flowchart',
      'signal' => 'Signal',
      'returnVariableList' => 'Return Variables',
      'returnCollectionVariable' => 'Return Collection Variable',
      'repliedTo' => 'Reply To',
      'relatedTo' => 'Related To',
      'instructions' => 'Instructions',
      'conditionsFormula' => 'Conditions Formula',
      'optOutLink' => 'Opt-Out Link',
      'isMultiInstance' => 'Multi-Instance',
      'isSequential' => 'Sequential',
      'loopCollectionExpression' => 'Collection Expression',
      'targetIdExpression' => 'Target ID Expression',
      'activityId' => 'Activity ID'
    ],
    'labels' => [
      'Conditions' => 'Conditions',
      'Actions' => 'Actions',
      'Field' => 'Field',
      'Flows Conditions' => 'Flows Conditions'
    ],
    'tooltips' => [
      'compensateActivityId' => 'An ID of an activity to compensate. If omitted, all completed compensable activities will be compensated.',
      'targetIdExpression' => 'The expression defining an ID of the target record.',
      'returnCollectionVariable' => 'Specify a variable name for data that will be returned from the multi-instance sub-process. The variable will contain an array of objects. Each object will contain return-variables of each sub-process instance.',
      'loopCollectionExpression' => 'The expression defining a list of values. Each value will instantiate a separate sub-process. The value will be available in the variable `$inputItem`.',
      'taskSendMessageEmailAddress' => 'Available placeholders:

* `{$$variable}`',
      'targetReport' => 'Records from the list report will be passed to the new process.',
      'target' => 'Select which record will be used as a target.',
      'userTaskName' => 'A name of User Task record that will be created.

Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'userTaskInstructions' => 'Instructions for a user. Markdown is supported.

Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'returnVariableList' => 'Specify formula variables that will be copied from the sub-process to the parent process once the sub-process successfully ends.',
      'scheduling' => 'Crontab notation. Defines frequency.

`*/5 * * * *` – every 5 minutes

`0 */2 * * *` – every 2 hours

`30 1 * * *` – at 01:30 once a day

`0 0 1 * *` – on the first day of the month',
      'schedulingApplyTimezone' => 'Apply the system default timezone to scheduling. Otherwise, UTC will be used.'
    ],
    'options' => [
      'emailAddress' => [
        'system' => 'System',
        'currentUser' => 'Current User',
        'specifiedEmailAddress' => 'Specified Email Address',
        'assignedUser' => 'Assigned User',
        'followers' => 'Followers',
        'specifiedContacts' => 'Specified Contacts',
        'specifiedUsers' => 'Specified Users',
        'specifiedTeams' => 'Specified Teams',
        'followersExcludingAssignedUser' => 'Followers excluding Assigned User',
        'processAssignedUser' => 'User assigned to Process',
        'targetEntity' => 'Target Record',
        '' => 'None'
      ],
      'triggerType' => [
        'afterRecordCreated' => 'After record created',
        'afterRecordSaved' => 'After record saved',
        'afterRecordUpdated' => 'After record updated',
        'sequential' => 'Sequential'
      ],
      'timerShiftOperator' => [
        'plus' => 'plus',
        'minus' => 'minus'
      ],
      'timerShiftUnits' => [
        'minutes' => 'minutes',
        'hours' => 'hours',
        'days' => 'days',
        'months' => 'months',
        'seconds' => 'seconds'
      ],
      'timerBase' => [
        'moment' => 'Moment when event triggered',
        'formula' => 'Calculated by formula'
      ],
      'actionType' => [
        'Approve' => 'Approve',
        'Review' => 'Review'
      ],
      'assignmentType' => [
        '' => 'None',
        'processAssignedUser' => 'User assigned to Process',
        'specifiedUser' => 'Specified User',
        'rule:Round-Robin' => 'Round-Robin',
        'rule:Least-Busy' => 'Least-Busy'
      ],
      'startDirection' => [
        '' => 'Auto',
        'r' => 'Right',
        'd' => 'Down',
        'u' => 'Up',
        'l' => 'Left'
      ],
      'messageType' => [
        'Email' => 'Email'
      ]
    ]
  ],
  'BpmnProcess' => [
    'labels' => [
      'Create BpmnProcess' => 'Start Process',
      'Stop Process' => 'Stop Process',
      'User Tasks' => 'User Tasks',
      'Flowcharts' => 'Flowcharts',
      'Interrupt' => 'Interrupt',
      'Reject' => 'Reject',
      'Start flow from here' => 'Start flow from here',
      'Reactivate' => 'Reactivate',
      'View Variables' => 'View Variables',
      'View Error' => 'View Error',
      'Error Message' => 'Error Message'
    ],
    'fields' => [
      'status' => 'Status',
      'targetType' => 'Target Entity Type',
      'target' => 'Target',
      'createdEntitiesData' => 'Created Entities Data',
      'flowchartData' => 'Flowchart Data',
      'flowchart' => 'Flowchart',
      'flowchartVisualization' => 'Flowchart (visualization)',
      'flowchartElementsDataHash' => 'Flowchart Elements',
      'variables' => 'Variables',
      'endedAt' => 'Ended At',
      'startElementId' => 'Start Element',
      'workflowId' => 'Workflow ID',
      'parentProcess' => 'Parent Process',
      'parentProcessFlowNode' => 'Parent Process Flow Node',
      'rootProcess' => 'Root Process'
    ],
    'links' => [
      'flowchart' => 'Flowchart',
      'target' => 'Target',
      'flowNodes' => 'Flow Log',
      'userTasks' => 'Process User Tasks',
      'childProcesses' => 'Child Processes',
      'parentProcess' => 'Parent Process',
      'parentProcessFlowNode' => 'Parent Process Flow Node',
      'rootProcess' => 'Root Process'
    ],
    'options' => [
      'status' => [
        'Created' => 'Created',
        'Started' => 'Started',
        'Ended' => 'Ended',
        'Paused' => 'Paused',
        'Stopped' => 'Stopped',
        'Interrupted' => 'Interrupted'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Active',
      'ended' => 'Ended'
    ]
  ],
  'BpmnUserTask' => [
    'labels' => [
      'Resolve' => 'Resolve'
    ],
    'fields' => [
      'actionType' => 'Action Type',
      'resolution' => 'Resolution',
      'target' => 'Target',
      'process' => 'Process',
      'isResolved' => 'Is Resolved',
      'resolutionNote' => 'Resolution Note',
      'instructions' => 'Instructions',
      'isCanceled' => 'Is Canceled'
    ],
    'links' => [
      'process' => 'Process',
      'target' => 'Target',
      'flowNode' => 'Flow Node'
    ],
    'options' => [
      'actionType' => [
        'Approve' => 'Approve',
        'Review' => 'Review',
        'Accomplish' => 'Accomplish'
      ],
      'resolution' => [
        '' => 'None',
        'Approved' => 'Approved',
        'Rejected' => 'Rejected',
        'Reviewed' => 'Reviewed',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'resolved' => 'Resolved',
      'canceled' => 'Canceled'
    ]
  ],
  'Report' => [
    'labels' => [
      'Create Report' => 'Create Report',
      'Run' => 'Run',
      'Total' => 'Total',
      'Group Total' => 'Group Total',
      '-Empty-' => '-Empty-',
      'Parameters' => 'Parameters',
      'Filters' => 'Filters',
      'Chart' => 'Chart',
      'List Report' => 'List Report',
      'Grid Report' => 'Grid Report',
      'days' => 'days',
      'never' => 'never',
      'Get Csv' => 'Get Csv',
      'EmailSending' => 'Email Sending',
      'View Report' => 'View Report',
      'Report' => 'Report',
      'AND' => 'AND',
      'OR' => 'OR',
      'NOT' => 'NOT IN',
      'IN' => 'IN',
      'Complex expression' => 'Complex expression',
      'Having' => 'Having',
      'Add AND group' => 'Add AND group',
      'Add OR group' => 'Add OR group',
      'Add NOT group' => 'Add NOT group',
      'Add IN group' => 'Add IN group',
      'Add Having group' => 'Add Having group',
      'Add Complex expression' => 'Add Complex expression',
      'Columns' => 'Columns',
      'Send Email' => 'Send Email',
      'Results View' => 'Results View',
      'Create Joint Grid Report' => 'Create Joint Grid Report',
      'Label' => 'Label',
      'Type' => 'Type',
      'Decimal Places' => 'Decimal Places'
    ],
    'fields' => [
      'type' => 'Type',
      'entityType' => 'Entity Type',
      'description' => 'Description',
      'groupBy' => 'Group by',
      'columns' => 'Columns',
      'orderBy' => 'Order by',
      'filters' => 'Filters',
      'runtimeFilters' => 'Runtime Filters',
      'chartType' => 'Chart Type',
      'emailSendingInterval' => 'Interval',
      'emailSendingTime' => 'Time',
      'emailSendingUsers' => 'Users',
      'emailSendingSettingDay' => 'Day',
      'emailSendingSettingMonth' => 'Month',
      'emailSendingSettingWeekdays' => 'Days',
      'emailSendingDoNotSendEmptyReport' => 'Don\'t send if report is empty',
      'chartColorList' => 'Colors',
      'chartColor' => 'Color',
      'chartOneColumns' => 'Chart Columns',
      'chartOneY2Columns' => 'Chart Secondary Axis Columns',
      'orderByList' => 'List Order',
      'column' => 'Column',
      'exportFormat' => 'Format',
      'category' => 'Category',
      'applyAcl' => 'Apply ACL',
      'portals' => 'Portals',
      'joinedReports' => 'Sub-Reports',
      'joinedReportLabel' => 'Sub-Report Label',
      'filtersDataList' => 'Filters Data List',
      'columnsData' => 'Columns Data',
      'filtersData' => 'Filters Data',
      'accounts' => 'Accounts'
    ],
    'tooltips' => [
      'emailSendingUsers' => 'Users report result will be sent to',
      'chartColorList' => 'Custom colors for specific groups.',
      'applyAcl' => 'Report results will depend on the user\'s access.',
      'groupBy' => 'Data will be aggregated by one or two groups. If empty, then data will not be aggregated, only totals will be displayed.

[Complex expressions](https://www.espocrm.com/documentation/user-guide/complex-expressions/) can be used.',
      'columns' => 'What data to display. 

[Complex expressions](https://www.espocrm.com/documentation/user-guide/complex-expressions/) can be used.',
      'runtimeFilters' => 'Additional filters that will be available on the report view.',
      'portals' => 'Report will be available only in specified portals.'
    ],
    'functions' => [
      'COUNT' => 'Count',
      'SUM' => 'Sum',
      'AVG' => 'Avg',
      'MIN' => 'Min',
      'MAX' => 'Max',
      'YEAR' => 'Year',
      'QUARTER' => 'Quarter',
      'MONTH' => 'Month',
      'DAY' => 'Day',
      'WEEK' => 'Week',
      'YEAR_FISCAL' => 'Fiscal Year',
      'QUARTER_FISCAL' => 'Fiscal Quarter'
    ],
    'orders' => [
      'ASC' => 'ASC',
      'DESC' => 'DESC',
      'LIST' => 'LIST'
    ],
    'options' => [
      'dashletDisplayType' => [
        '' => '',
        'Chart' => 'Chart',
        'List' => 'List',
        'Chart-Total' => 'Chart & Total',
        'Total' => 'Total',
        'Table' => 'Table'
      ],
      'chartType' => [
        'BarHorizontal' => 'Bar (horizontal)',
        'BarVertical' => 'Bar (vertical)',
        'BarGroupedHorizontal' => 'Bar Grouped (horizontal)',
        'BarGroupedVertical' => 'Bar Grouped (vertical)',
        'Pie' => 'Pie',
        'Line' => 'Line',
        'Radar' => 'Radar'
      ],
      'emailSendingInterval' => [
        '' => 'None',
        'Daily' => 'Daily',
        'Weekly' => 'Weekly',
        'Monthly' => 'Monthly',
        'Yearly' => 'Yearly'
      ],
      'emailSendingSettingDay' => [
        32 => 'Last day of month'
      ],
      'type' => [
        'Grid' => 'Grid',
        'List' => 'List',
        'JointGrid' => 'Joint Grid'
      ],
      'function' => [
        '' => 'No Function',
        'custom' => 'Expression',
        'customWithOperator' => 'Expression w/ Operator',
        'DATE_NUMBER' => 'DATE',
        'MONTH_NUMBER' => 'MONTH',
        'YEAR_NUMBER' => 'YEAR',
        'QUARTER_NUMBER' => 'QUARTER',
        'DAYOFWEEK_NUMBER' => 'DAYOFWEEK',
        'HOUR_NUMBER' => 'HOUR',
        'MINUTE_NUMBER' => 'MINUTE',
        'LOWER' => 'LOWER',
        'UPPER' => 'UPPER',
        'TRIM' => 'TRIM',
        'LENGTH' => 'LENGTH',
        'WEEK_NUMBER_0' => 'WEEK (Sunday)',
        'WEEK_NUMBER_1' => 'WEEK (Monday)',
        'COUNT' => 'COUNT',
        'SUM' => 'SUM',
        'AVG' => 'AVG',
        'MAX' => 'MAX',
        'MIN' => 'MIN'
      ],
      'operator' => [
        'equals' => 'Equals',
        'notEquals' => 'Not Equals',
        'greaterThan' => 'Greater Than',
        'lessThan' => 'Less Than',
        'greaterThanOrEquals' => 'Greater Than or Equals',
        'lessThanOrEquals' => 'Less Than or Equals',
        'in' => 'In',
        'notIn' => 'Not In',
        'isTrue' => 'Is True',
        'isFalse' => 'Is False',
        'isNull' => 'Is Null',
        'isNotNull' => 'Is Not Null',
        'like' => 'Like'
      ],
      'exportFormat' => [
        'csv' => 'CSV',
        'xlsx' => 'XLSX (Excel)'
      ],
      'layoutAlign' => [
        'left' => 'Left',
        'right' => 'Right'
      ],
      'columnType' => [
        '' => 'Auto',
        'Summary' => 'Summary'
      ]
    ],
    'messages' => [
      'emailTemplateParsingError' => 'Error while parsing template `{template}`.',
      'executionError' => 'Could not run the report. Check the report parameters. Find more details in the log file.',
      'emptyStringGroupExcluded' => 'A group with an empty string value is excluded from the results.',
      'notAllowedFormulaInFilter' => 'Formula expression in filters contains a not allowed function.',
      'validateMaxCount' => 'Count should not be greater than {maxCount}',
      'havingFilterWithoutGroupByError' => 'Having filter can\'t be used without Group-By.',
      'gridReportDescription' => 'Group by one or two columns and see summations. Can be displayed as a chart.',
      'listReportDescription' => 'Simple list of records which meet filters criteria.',
      'invalidColumnError' => 'Invalid column name. Check the report parameters.',
      'sqlSyntaxError' => 'Could not compose a valid SQL from report parameters.',
      'onlyFullGroupByError' => 'Unsupported report parameters. Either change parameters or disable `ONLY_FULL_GROUP_BY` SQL mode in the database config.'
    ],
    'presetFilters' => [
      'list' => 'List',
      'grid' => 'Grid',
      'listTargets' => 'List (Targets)',
      'listAccounts' => 'List (Accounts)',
      'listContacts' => 'List (Contacts)',
      'listLeads' => 'List (Leads)',
      'listUsers' => 'List (Users)'
    ],
    'errorMessages' => [
      'error' => 'Error',
      'noChart' => 'No chart selected for the report.',
      'selectReport' => 'Select a report in the dashlet options.'
    ],
    'filtersGroupTypes' => [
      'or' => 'OR',
      'and' => 'AND',
      'not' => 'NOT IN',
      'subQueryIn' => 'IN',
      'having' => 'Having'
    ],
    'layoutFields' => [
      'link' => 'Link',
      'width' => 'Width',
      'notSortable' => 'Not Sortable',
      'exportOnly' => 'Export Only',
      'align' => 'Align'
    ],
    'links' => [
      'accounts' => 'Accounts'
    ]
  ],
  'ReportCategory' => [
    'labels' => [
      'Create ReportCategory' => 'Create Category',
      'Manage Categories' => 'Manage Categories',
      'Reports' => 'Reports'
    ],
    'fields' => [
      'order' => 'Order'
    ],
    'links' => [
      'reports' => 'Reports'
    ]
  ],
  'ReportFilter' => [
    'labels' => [
      'Create ReportFilter' => 'Create Filter',
      'Rebuild Filters' => 'Rebuild Filters'
    ],
    'fields' => [
      'order' => 'Order',
      'report' => 'Report',
      'entityType' => 'Entity Type',
      'isActive' => 'Is Enabled'
    ],
    'links' => [
      'report' => 'Report'
    ],
    'tooltips' => [
      'teams' => 'Teams the filter will be available for. If no teams specified then no restriction by team will be applied.',
      'report' => 'List Report that will be used for the filter.'
    ]
  ],
  'ReportPanel' => [
    'labels' => [
      'Create ReportPanel' => 'Create Panel',
      'Rebuild Panels' => 'Rebuild Panels'
    ],
    'fields' => [
      'report' => 'Report',
      'entityType' => 'Entity Type',
      'isActive' => 'Is Enabled',
      'type' => 'Type',
      'reportType' => 'Report Type',
      'displayTotal' => 'Display Total',
      'displayOnlyTotal' => 'Display Only Total',
      'column' => 'Column',
      'reportEntityType' => 'Report Entity Type',
      'columnList' => 'Column List',
      'dynamicLogicVisible' => 'Conditions making panel visible',
      'order' => 'Order',
      'displayType' => 'What to display',
      'useSiMultiplier' => 'SI Multiplier'
    ],
    'links' => [
      'report' => 'Report'
    ],
    'tooltips' => [
      'teams' => 'Teams the panel will be displayed for. If no teams specified then no restriction by team will be applied.',
      'report' => 'Report that will be used for the panel.',
      'order' => '[0..1] - before Stream panel;
[3..4] - before relationship panels;
[6..] - after relationship panels.'
    ],
    'options' => [
      'type' => [
        'side' => 'Side',
        'bottom' => 'Bottom'
      ]
    ]
  ],
  'Workflow' => [
    'fields' => [
      'Name' => 'Name',
      'entityType' => 'Target Entity',
      'type' => 'Trigger Type',
      'isActive' => 'Active',
      'description' => 'Description',
      'usersToMakeToFollow' => 'Users to make to follow the record',
      'whatToFollow' => 'What to follow',
      'portalOnly' => 'Portal Only',
      'portal' => 'Portal',
      'targetReport' => 'Target Report',
      'scheduling' => 'Scheduling',
      'schedulingApplyTimezone' => 'Apply timezone',
      'methodName' => 'Service Method',
      'assignmentRule' => 'Assignment Rule',
      'targetTeam' => 'Target Team',
      'targetUserPosition' => 'Target User Position',
      'listReport' => 'List Report',
      'linkList' => 'Link with Target Entity through relationships',
      'linkListShort' => 'Links',
      'target' => 'Target',
      'whoFollow' => 'Who make to follow',
      'signalName' => 'Signal',
      'requestType' => 'Request Type',
      'requestUrl' => 'URL',
      'requestContentType' => 'Content Type',
      'requestContent' => 'Payload',
      'requestContentVariable' => 'Payload from variable',
      'optOutLink' => 'Opt-Out Link',
      'headers' => 'Headers',
      'manualLabel' => 'Manual Label',
      'manualDynamicLogic' => 'Manual Dynamic-Logic',
      'manualTeams' => 'Manual Teams',
      'manualAccessRequired' => 'Manual Access Required',
      'manualElementType' => 'Manual Element Type',
      'manualElementTypeInForm' => 'Element Type',
      'manualLabelInForm' => 'Label',
      'manualAccessRequiredInForm' => 'Access Required',
      'manualTeamsInForm' => 'For Teams',
      'manualDynamicLogicInForm' => 'Conditions',
      'manualConfirmation' => 'Manual Confirmation',
      'manualConfirmationInForm' => 'Confirmation Dialog',
      'manualConfirmationText' => 'Manual Confirmation Text',
      'manualConfirmationTextInForm' => 'Confirmation Text',
      'manualStyle' => 'Manual Button Style',
      'manualStyleInForm' => 'Button Style',
      'category' => 'Category',
      'conditionsAll' => 'Conditions All',
      'conditionsAny' => 'Conditions Any',
      'conditionsFormula' => 'Conditions Formula',
      'actions' => 'Actions',
      'processOrder' => 'Process Order',
      'attachmentsVariable' => 'Attachments Variable'
    ],
    'links' => [
      'portal' => 'Portal',
      'targetReport' => 'Target Report',
      'workflowLogRecords' => 'Log',
      'category' => 'Category'
    ],
    'tooltips' => [
      'processOrder' => 'Multiple workflow rules for the same target will be processed according their order. The lower the order value, the sooner a rule runs.',
      'manualConfirmation' => 'To display a confirmation dialog before running the workflow.',
      'manualConfirmationText' => 'A text to show to a user when confirming workflow start.',
      'schedulingApplyTimezone' => 'Apply the system default timezone to scheduling. Otherwise, UTC will be used.',
      'manualDynamicLogic' => 'Conditions making the workflow available for a record.',
      'manualTeams' => 'Teams who will have access to run the workflow. If empty, only admin will have access.',
      'manualAccessRequired' => 'Access to a record required to be able run the workflow.',
      'manualLabel' => 'A UI element label text.',
      'requestUrl' => 'Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'requestHeaders' => 'Additional headers.

Format:
```key: value```

Available placeholders:
* `{$attribute}`
* `{$$variable}`
* `{#secrets.name}`',
      'requestContent' => 'In JSON format.

Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'requestContentVariable' => 'A variable name. If specified, payload will be taken from the variable.',
      'portalOnly' => 'If checked workflow will be triggered only in portal.',
      'portal' => 'Specific portal where workflow will be triggered. Leave empty if you need it to work in any portal.',
      'scheduling' => 'Crontab notation. Defines frequency of workflow rule runs.

`*/5 * * * *` – every 5 minutes

`0 */2 * * *` – every 2 hours

`30 1 * * *` – at 01:30 once a day

`0 0 1 * *` – on the first day of the month'
    ],
    'labels' => [
      'Create Workflow' => 'Create Rule',
      'General' => 'General',
      'Manual Trigger' => 'Manual Trigger',
      'Conditions' => 'Conditions',
      'Actions' => 'Actions',
      'All' => 'All',
      'Any' => 'Any',
      'Formula' => 'Formula',
      'Email Address' => 'Email Address',
      'Email Template' => 'Email Template',
      'From' => 'From',
      'To' => 'To',
      'immediately' => 'Immediately',
      'Reply-To' => 'Reply-To',
      'CC' => 'CC',
      'later' => 'Later',
      'today' => 'today',
      'plus' => 'plus',
      'minus' => 'minus',
      'days' => 'days',
      'hours' => 'hours',
      'months' => 'months',
      'minutes' => 'minutes',
      'Link' => 'Link',
      'Add Field' => 'Add Field',
      'equals' => 'equals',
      'wasEqual' => 'was equal',
      'notEquals' => 'not equals',
      'wasNotEqual' => 'was not equal',
      'changed' => 'changed',
      'notChanged' => 'not changed',
      'notEmpty' => 'not empty',
      'isEmpty' => 'empty',
      'value' => 'value',
      'field' => 'field',
      'true' => 'true',
      'false' => 'false',
      'greaterThan' => 'greater than',
      'lessThan' => 'less than',
      'greaterThanOrEquals' => 'greater than or equals',
      'lessThanOrEquals' => 'less than or equals',
      'between' => 'between',
      'on' => 'on',
      'before' => 'before',
      'after' => 'after',
      'beforeToday' => 'before today',
      'afterToday' => 'after today',
      'recipient' => 'Recipient',
      'has' => 'has',
      'notHas' => 'not has',
      'contains' => 'contains',
      'notContains' => 'not contains',
      'messageTemplate' => 'Message Template',
      'users' => 'Users',
      'Target Entity' => 'Target Entity',
      'Current' => 'Current',
      'Workflow' => 'Workflow',
      'Workflows Log' => 'Workflows Log',
      'methodName' => 'Service Method',
      'additionalParameters' => 'Additional Parameters (JSON format)',
      'doNotStore' => 'Do not store sent email',
      'Related' => 'Related',
      'Entity Type' => 'Entity Type',
      'Workflow Rule' => 'Workflow Rule',
      'Add Condition' => 'Add Condition',
      'Add Action' => 'Add Action',
      'Created' => 'Created',
      'Field' => 'Field',
      'Entity' => 'Entity',
      'Process' => 'Process'
    ],
    'emailAddressOptions' => [
      '' => 'None',
      'currentUser' => 'Current user',
      'specifiedEmailAddress' => 'Specified email address',
      'assignedUser' => 'Assigned user',
      'targetEntity' => 'Target record',
      'specifiedUsers' => 'Specified users',
      'specifiedContacts' => 'Specified contacts',
      'teamUsers' => 'Users of teams related to target record',
      'followers' => 'Followers of target record',
      'followersExcludingAssignedUser' => 'Followers excluding assigned user',
      'specifiedTeams' => 'Users of specified teams',
      'system' => 'System',
      'fromOrReplyTo' => 'From/Reply-To address'
    ],
    'options' => [
      'type' => [
        'afterRecordSaved' => 'After record saved (created or updated)',
        'afterRecordCreated' => 'After record created',
        'afterRecordUpdated' => 'After record updated',
        'manual' => 'Manual',
        'scheduled' => 'Scheduled',
        'sequential' => 'Sequential',
        'signal' => 'Signal'
      ],
      'subjectType' => [
        'value' => 'value',
        'field' => 'field',
        'today' => 'today/now',
        'typeOf' => 'type of'
      ],
      'assignmentRule' => [
        'Round-Robin' => 'Round-Robin',
        'Least-Busy' => 'Least-Busy'
      ],
      'manualAccessRequired' => [
        'read' => 'read',
        'edit' => 'edit',
        'admin' => 'admin'
      ],
      'manualElementType' => [
        'Button' => 'Button',
        'Dropdown-Item' => 'Dropdown Item'
      ]
    ],
    'actionTypes' => [
      'sendEmail' => 'Send Email',
      'createEntity' => 'Create Record',
      'createRelatedEntity' => 'Create Related Record',
      'updateEntity' => 'Update Target Record',
      'updateRelatedEntity' => 'Update Related Record',
      'relateWithEntity' => 'Link with Another Record',
      'unrelateFromEntity' => 'Unlink from Another Record',
      'makeFollowed' => 'Make Followed',
      'createNotification' => 'Create Notification',
      'triggerWorkflow' => 'Trigger Another Workflow Rule',
      'runService' => 'Run Service Action',
      'applyAssignmentRule' => 'Apply Assignment Rule',
      'updateCreatedEntity' => 'Update Created Record',
      'updateProcessEntity' => 'Update Process Record',
      'startBpmnProcess' => 'Start BPM Process',
      'sendRequest' => 'Send HTTP Request',
      'executeFormula' => 'Execute Formula Script'
    ],
    'texts' => [
      'allMustBeMet' => 'All must be met',
      'atLeastOneMustBeMet' => 'At least one must be met',
      'formulaInfo' => 'Conditions of any complexity in espo-formula language'
    ],
    'messages' => [
      'jsonInvalid' => 'Is not valid JSON.',
      'loopNotice' => 'Be careful about a possible looping through two or more workflow rules continuously.',
      'messageTemplateHelpText' => 'Available placeholders:

* `{entity}` – target record
* `{user}` – current user
* `{$$variable}` – formula variable'
    ],
    'serviceActions' => [
      'sendEventInvitations' => 'Send Invitations',
      'addQuoteItemList' => 'Add Quote Items',
      'addInvoiceItemList' => 'Add Invoice Items',
      'addSalesOrderItemList' => 'Add Sales Order Items',
      'convertCurrency' => 'Convert Currency',
      'sendInEmail' => 'Send In Email',
      'optOut' => 'Opt-out',
      'generateAndSendPassword' => 'Generate Password'
    ],
    'serviceActionsHelp' => [
      'generateAndSendPassword' => 'A new password will be generated and sent to the user\'s email address.',
      'optOut' => 'Optional parameter: targetListId. If not specified, then marks an email address opted-out.

 Example:
```{"targetListId": "TARGET_LIST_ID"}```',
      'convertCurrency' => 'Optional parameter: targetCurrency. If not specified, then it will convert to the default currency.',
      'sendInEmail' => 'Parameters:
* templateId - ID of PDF template
* emailTemplateId - ID of email template
* to - recipient (optional parameter); by default will be sent to billing contact or account; example: `link:account.assignedUser`

Example:

```{
    "templateId": "TEMPLATE_ID",
    "emailTemplateId": "EMAIL_TEMPLATE_ID",
    "to": "link:billingContact"
}```',
      'addQuoteItemList' => 'Example: 

```{
  "itemList": [
     {
      "quantity": 1, "procuctId": "productId", "name": "Product Name", "listPrice": 100, "unitPrice": 100
     }
  ]
}```',
      'addInvoiceItemList' => 'Example: 

```{
  "itemList": [
     {
      "quantity": 1, "procuctId": "productId", "name": "Product Name", "listPrice": 100, "unitPrice": 100
     }
  ]
}```',
      'addSalesOrderItemList' => 'Example: 

```{
  "itemList": [
     {
      "quantity": 1, "procuctId": "productId", "name": "Product Name", "listPrice": 100, "unitPrice": 100
     }
  ]
}```'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ]
  ],
  'WorkflowCategory' => [
    'labels' => [
      'Create WorkflowCategory' => 'Create Category'
    ],
    'fields' => [
      'order' => 'Order'
    ],
    'links' => [
      'workflows' => 'Workflows'
    ]
  ],
  'WorkflowLogRecord' => [
    'labels' => [],
    'fields' => [
      'target' => 'Target',
      'workflow' => 'Workflow'
    ]
  ],
  'DeliveryOrder' => [
    'labels' => [
      'Create DeliveryOrder' => 'Create Delivery Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Valid' => 'Valid',
      'Invalid' => 'Invalid',
      'Show Availability' => 'Show Availability',
      'Availability' => 'Availability',
      'Total' => 'Total'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'salesOrder' => 'Sales Order',
      'shippingAddress' => 'Shipping Address',
      'shippingContact' => 'Shipping Contact',
      'shippingCost' => 'Shipping Cost',
      'amount' => 'Amount',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'amountCurrency' => 'Amount Currency',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'shippingDate' => 'Shipping Date',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'currency' => 'Currency',
      'inventoryData' => 'Inventory Data',
      'inventoryStatus' => 'Inventory Status',
      'warehouse' => 'Warehouse',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'salesOrder' => 'Sales Order',
      'account' => 'Account',
      'tax' => 'Tax',
      'inventoryTransactions' => 'Inventory Transactions',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'In Progress' => 'In Progress',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Failed' => 'Failed'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'inventoryIsInAdjustment' => 'Can\'t save as inventory is currently in a started adjustment.',
      'notAvailableInventory' => 'Not enough inventory is available.',
      'notAvailableInventoryStatusChanged' => 'Not enough inventory is available. Cannot change the status.'
    ],
    'texts' => [
      'itemTooMany' => '{number} extra needs to be removed.',
      'itemTooFew' => '{number} more needs to be added.'
    ]
  ],
  'DeliveryOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'deliveryOrder' => 'Delivery Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'account' => 'Account',
      'deliveryOrderStatus' => 'Delivery Order Status',
      'inventoryNumber' => 'Inventory Number',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'deliveryOrder' => 'Delivery Order',
      'product' => 'Product',
      'account' => 'Account',
      'inventoryNumber' => 'Inventory Number'
    ]
  ],
  'InventoryAdjustment' => [
    'labels' => [
      'Create InventoryAdjustment' => 'Create Adjustment',
      'Add Item' => 'Add Item',
      'Items' => 'Items'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'amount' => 'Amount',
      'itemList' => 'Item List',
      'date' => 'Date',
      'reason' => 'Reason',
      'warehouse' => 'Warehouse',
      'isDone' => 'Is Done',
      'doneAt' => 'Done At'
    ],
    'links' => [
      'items' => 'Items',
      'inventoryTransactions' => 'Inventory Transactions',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Started' => 'Started',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ],
      'reason' => [
        'Stocktaking' => 'Stocktaking',
        'Write-off' => 'Write-off',
        'Waste' => 'Waste',
        'Shrinkage' => 'Shrinkage',
        'Damage' => 'Damage',
        'Internal' => 'Internal'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'itemProductIsNotInventory' => 'Product {name} is not inventory.',
      'emptyNewQuantityInItem' => 'On-hand quantity is not specified for an item.',
      'sameItemsInAnotherAdjustment' => 'The same items are in another started adjustment.',
      'duplicateItems' => 'Can\'t have the same items in an adjustment.'
    ]
  ],
  'InventoryAdjustmentItem' => [
    'fields' => [
      'name' => 'Name',
      'newQtyOnHand' => 'On-Hand Qty',
      'qty' => 'Adjusted',
      'newQuantityOnHand' => 'New On-Hand Quantity ',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'inventoryAdjustment' => 'Adjustment',
      'description' => 'Description',
      'inventoryAdjustmentStatus' => 'Inventory Adjustment Status',
      'inventoryNumber' => 'Inventory Number',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory',
      'warehouse' => 'Warehouse'
    ],
    'links' => [
      'inventoryAdjustment' => 'Adjustment',
      'product' => 'Product',
      'inventoryNumber' => 'Inventory Number'
    ],
    'presetFilters' => [
      'completed' => 'Completed'
    ]
  ],
  'InventoryNumber' => [
    'labels' => [
      'Create InventoryNumber' => 'Create Number',
      'Quantity' => 'Quantity',
      'Warehouses' => 'Warehouses',
      'Inventory History' => 'Inventory History',
      'View History' => 'View History',
      'Received' => 'Received',
      'Shipped' => 'Shipped'
    ],
    'fields' => [
      'type' => 'Type',
      'product' => 'Product',
      'quantityOnHand' => 'On Hand',
      'quantityReserved' => 'Reserved',
      'quantityInTransit' => 'In Transit',
      'incomingDate' => 'Incoming Date',
      'productionDate' => 'Production Date',
      'expirationDate' => 'Expiration Date',
      'warehousesOnHand' => 'Warehouses (On Hand)',
      'deleteId' => 'Delete ID',
      'number' => 'Internal Number',
      'orderFifo' => 'Order FIFO',
      'orderFefo' => 'Order FEFO',
      'orderLifo' => 'Order LIFO',
      'quantityWarehouseOnHand' => 'On Hand in Warehouse',
      'quantityWarehouseReserved' => 'Reserved in Warehouse'
    ],
    'links' => [
      'product' => 'Product',
      'inventoryTransactions' => 'Inventory Transactions'
    ],
    'presetFilters' => [
      'onHand' => 'On Hand',
      'notOnHand' => 'Not On Hand'
    ],
    'messages' => [
      'alreadyExists' => 'The same inventory number already exists.'
    ]
  ],
  'InventoryTransaction' => [
    'labels' => [
      'Create InventoryTransaction' => 'Create Transaction'
    ],
    'fields' => [
      'number' => 'Number',
      'type' => 'Type',
      'parent' => 'Parent',
      'quantity' => 'Quantity',
      'product' => 'Product',
      'warehouse' => 'Warehouse',
      'inventoryNumber' => 'Inventory Number'
    ],
    'links' => [
      'parent' => 'Parent',
      'product' => 'Product',
      'warehouse' => 'Warehouse',
      'inventoryNumber' => 'Inventory Number'
    ],
    'options' => [
      'type' => [
        'Transfer' => 'Transfer',
        'Reserve' => 'Reserve',
        'Soft Reserve' => 'Soft Reserve'
      ]
    ]
  ],
  'Invoice' => [
    'labels' => [
      'Create Invoice' => 'Create Invoice',
      'Taxes' => 'Taxes',
      'Shipping Providers' => 'Shipping Providers',
      'Add Item' => 'Add Item',
      'Templates' => 'Templates',
      'Items' => 'Items',
      'Invoice Items' => 'Invoice Items',
      'E-Invoice' => 'E-Invoice',
      'Validate' => 'Validate'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'opportunity' => 'Opportunity',
      'quote' => 'Quote',
      'salesOrder' => 'Sales Order',
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateInvoiced' => 'Date Invoiced',
      'dateDue' => 'Due Date',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'priceBook' => 'Price Book',
      'buyerReference' => 'Buyer Reference'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'opportunity' => 'Opportunity',
      'account' => 'Account',
      'tax' => 'Tax',
      'quote' => 'Quote',
      'salesOrder' => 'Sales Order',
      'priceBook' => 'Price Book'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Sent' => 'Sent',
        'In Review' => 'In Review',
        'Confirmed' => 'Confirmed',
        'Paid' => 'Paid',
        'Rejected' => 'Rejected',
        'Canceled' => 'Canceled'
      ],
      'eInvoiceFormats' => [
        'CiusRo' => 'CIUS-RO e-Factura',
        'CiusIt' => 'CIUS-IT',
        'CiusAtGov' => 'CIUS-AT-GOV',
        'CiusAtNat' => 'CIUS-AT-NAT',
        'Peppol' => 'PEPPOL BIS Billing 3.0',
        'CiusEsFace' => 'CIUS-ES-FACE',
        'Nlcius' => 'NLCIUS',
        'XRechnung' => 'XRechnung'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'paid' => 'Paid'
    ],
    'messages' => [
      'invoiceIsValid' => 'Invoice is valid',
      'ublRuleValidationFailure' => 'Invalid invoice.

Failed rule ID: `{ruleId}`

{message}'
    ],
    'eInvoiceFields' => [
      'eInvoiceFormat' => 'E-Invoice Format',
      'format' => 'Format'
    ]
  ],
  'InvoiceItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'order' => 'Line Number',
      'invoice' => 'Invoice',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'invoiceStatus' => 'Invoice Status'
    ],
    'links' => [
      'invoice' => 'Invoice',
      'product' => 'Product',
      'account' => 'Account'
    ],
    'labels' => [
      'Invoices' => 'Invoices'
    ]
  ],
  'OpportunityItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'amountCurrency' => 'Amount (Currency)',
      'unitPriceCurrency' => 'Unit Price (Currency)',
      'product' => 'Product',
      'order' => 'Line Number',
      'opportunity' => 'Opportunity',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPrice' => 'List Price',
      'listPriceConverted' => 'List Price (Converted)',
      'listPriceCurrency' => 'List Price (Currency)',
      'opportunityStage' => 'Stage',
      'licenseType' => 'License',
      'services' => 'Service Opportunity',
      'brand' => 'Brand',
      'timeContract' => 'Period',
      'productBrand' => 'Product Brand',
      'amountDiscountItem' => 'Value w/ Discount',
      'amountDiscountItemCurrency' => 'Unit Discounted (Currency)',
      'amountDiscountItemConverted' => 'Unit Discounted (Converted)',
      'contractType' => 'Contract',
      'region' => 'Region',
      'priceBooks' => 'Price Books',
      'update' => 'Reprocess',
      'editAmount' => 'Edit Value',
      'margin' => 'Margin',
      'productSKU' => 'SKU',
      'cSolutionType' => 'Facturación',
      'cItem1' => 'Item1',
      'solutionType' => 'Facturación',
      'cLicenseTypeGoogle' => 'License Type',
      'cLicenseTypeAWS' => 'License Type AWS'
    ],
    'links' => [
      'opportunity' => 'Opportunity',
      'product' => 'Product',
      'services' => 'Service Opportunity',
      'productBrand' => 'Product Brand',
      'priceBooks' => 'Price Books'
    ],
    'labels' => [
      'Opportunities' => 'Opportunities'
    ],
    'options' => [
      'licenseType' => [
        '' => '',
        'Azure' => 'Azure',
        'Microsoft 365 - Montlhy' => 'Microsoft 365 - Mensual',
        'Microsoft 365 - Annual' => 'Microsoft 365 - Anual',
        'Dynamics 365' => 'Dynamics 365',
        'Software Subscription' => 'Software Subscription',
        'Software Perpetual' => 'Software Perpetual',
        'CSP' => 'CSP',
        'AWS' => 'AWS',
        'NCE' => 'NCE',
        'Azure IR' => 'Azure IR',
        'Open' => 'Open',
        'Open Value Perpetual' => 'Open Value Perpetual',
        'Open Valeu SA' => 'Open Value SA',
        'Open Valeu Subscription 1 Ano' => 'Open Value Subscription 1 Año',
        'Open Valeu Subscription 3 Anos' => 'Open Value Subscription 3 Años',
        'SW Perpetual' => 'SW Perpetual',
        'SW Subscription 1 Ano' => 'SW Subscription 1 Ano',
        'SW Subscription 3 Anos' => 'SW Subscription 3 Anos',
        'ESA' => 'ESA',
        'Marketplace' => 'Marketplace',
        'Subscription' => 'Subscription',
        'Google Cloud Platform' => 'Google Cloud Platform',
        'Google Workspace' => 'Google Workspace',
        'New Business' => 'New Business',
        'Renewal' => 'Renewal',
        'Upgrade' => 'Upgrade',
        'M365' => 'M365',
        'Services' => 'Services',
        'Open Value ' => 'Open Value ',
        'D365' => 'D365',
        'Power Platform' => 'Power Platform',
        'Open Value Subscription' => 'Open Value Subscription',
        'OVS-ES' => 'OVS-ES',
        'School' => 'School',
        'O365/M365' => 'O365/M365'
      ],
      'brand' => [
        'Google' => 'Google',
        'Microsoft' => 'Microsoft',
        'IBM' => 'IBM',
        'Cisco' => 'Cisco',
        'AWS' => 'AWS',
        '' => ''
      ],
      'timeContract' => [
        '' => '',
        '1 Month' => '1 Month',
        '1 Year' => '1 Year',
        '2 Years' => '2 Years',
        '3 Years' => '3 Years',
        'Perpetual' => 'Perpetual',
        'Pay as you go' => 'Pay as you go',
        '1 month' => '1 Mes'
      ],
      'contractType' => [
        '' => '',
        'Open' => 'Open',
        'SPLA' => 'SPLA',
        'Services Pofesionals' => 'Services Pofesionals',
        'CSP' => 'CSP',
        'Professional Services' => 'Professional Services',
        'NCE' => 'NCE',
        'CSP NCE' => 'CSP NCE',
        'Open Value' => 'Open Value'
      ],
      'region' => [
        '' => '',
        'BRA' => 'BRA',
        'MCA' => 'MCA'
      ],
      'cSolutionType' => [
        '' => '',
        'Monthly' => 'Monthly',
        'Annual' => 'Annual',
        'Flexible' => 'Flexible',
        'Pay as you go' => 'Pay as you go',
        'Trial version' => 'Trial version',
        'One time' => 'One time'
      ],
      'solutionType' => [
        '' => '',
        'Flexible' => 'Flexível',
        'Pay as you go' => 'Pay as you go',
        'Trial version' => 'Trial version',
        'onetime' => 'One Time',
        'annually' => 'Anual',
        'monthly' => 'Mensal',
        'Monthly' => 'Monthly',
        'Annual' => 'Annual'
      ],
      'cLicenseTypeGoogle' => [
        '' => '',
        'New Business' => 'New Business',
        'Renewal' => 'Renewal',
        'Upgrade' => 'Upgrade'
      ],
      'cLicenseTypeAWS' => [
        '' => '',
        'AWS' => 'AWS'
      ]
    ]
  ],
  'PriceBook' => [
    'labels' => [
      'Create PriceBook' => 'Create PriceBook'
    ],
    'fields' => [
      'parentPriceBook' => 'Parent Price Book',
      'status' => 'Status',
      'country' => 'Country',
      'opportunity' => 'Opportunity',
      'opportunityItem' => 'Opportunity Item',
      'product' => 'Product',
      'unitPrice' => 'UnitPrice',
      'unitPriceCurrency' => 'UnitPrice (Currency)',
      'unitPriceConverted' => 'UnitPrice (Converted)',
      'countryLabel' => 'CountryLabel',
      'productUnitPrice' => 'ProductUnitPrice',
      'productUnitPriceCurrency' => 'ProductUnitPrice (Moeda)',
      'productUnitPriceConverted' => 'ProductUnitPrice (Convertido)'
    ],
    'links' => [
      'products' => 'Products',
      'parentPriceBook' => 'Parent Price Book',
      'accounts' => 'Accounts',
      'prices' => 'Prices',
      'rules' => 'Rules',
      'childPriceBooks' => 'Child Price Books',
      'country' => 'Country',
      'opportunity' => 'Opportunity',
      'opportunityItem' => 'Opportunity Item',
      'product' => 'Product'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ]
  ],
  'PriceRule' => [
    'labels' => [
      'Create PriceRule' => 'Create Rule'
    ],
    'fields' => [
      'priceBook' => 'Price Book',
      'status' => 'Status',
      'productCategory' => 'Product Category',
      'minQuantity' => 'Min. Quantity',
      'price' => 'Price',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'minQty' => 'Min. Qty',
      'percentage' => 'Percentage',
      'discount' => 'Discount',
      'target' => 'Target',
      'condition' => 'Condition',
      'conditionSelect' => 'Condition Select',
      'roundingMethod' => 'Rounding Method',
      'roundingFactor' => 'Rounding Factor',
      'surcharge' => 'Surcharge',
      'currency' => 'Currency',
      'basedOn' => 'Based On',
      'supplier' => 'Supplier'
    ],
    'links' => [
      'supplier' => 'Supplier',
      'productCategory' => 'Product Category',
      'condition' => 'Condition',
      'priceBook' => 'Price Book',
      'product' => 'Product'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ],
      'basedOn' => [
        'Unit' => 'Unit',
        'Price Book' => 'Price Book',
        'Supplier' => 'Supplier',
        'Cost' => 'Cost'
      ],
      'basedOnShort' => [
        'Unit' => 'U',
        'Price Book' => 'PB',
        'Supplier' => 'S',
        'Cost' => 'C'
      ],
      'target' => [
        'All' => 'All',
        'Product Category' => 'Product Category',
        'Conditional' => 'Conditional'
      ],
      'percentageType' => [
        'Discount' => 'Discount',
        'Markup' => 'Markup'
      ],
      'roundingFactor' => [
        'Half Up' => 'Half Up',
        'Up' => 'Up',
        'Down' => 'Down'
      ]
    ],
    'tooltips' => [
      'minQuantity' => 'The rule will be applied only if the quantity of items being sold exceeds the specified value.',
      'currency' => 'The amount will be converted to the specified currency before rounding. Also defines the currency of the surcharge.',
      'basedOn' => 'What to use as a base price.

* Unit – the unit price defined in the Price Book or defined in the Product record; Price Book rules are not applied;
* Price Book – is obtained from the same Price Book; rules are applied;
* Supplier – the price of the Supplier;
* Cost – the cost specified in the Product record.',
      'surcharge' => 'An amount to add after percentage and rounding are applied. Use a negative number to subtract.',
      'roundingFactor' => 'The amount will be round off to the multiple of the specified value.',
      'percentage' => 'A percentage of the standard price to deduct or add.'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ]
  ],
  'PriceRuleCondition' => [
    'labels' => [
      'Create PriceRuleCondition' => 'Create Condition'
    ],
    'fields' => [
      'condition' => 'Condition'
    ],
    'tooltips' => [
      'condition' => 'A formula expression. Should return true or false.'
    ]
  ],
  'Product' => [
    'labels' => [
      'Create Product' => 'Create Product',
      'Price' => 'Price',
      'Brands' => 'Brands',
      'Categories' => 'Categories',
      'Price Books' => 'Price Books',
      'Quantity' => 'Quantity',
      'Warehouses' => 'Warehouses',
      'Generate' => 'Generate',
      'Orders' => 'Orders',
      'Select Variant' => 'Select Variant',
      'Select Variants' => 'Select Variants',
      'Select Template' => 'Select Template',
      'View Price' => 'View Price'
    ],
    'fields' => [
      'status' => 'Status',
      'brand' => 'Brand',
      'partNumber' => 'Part Number',
      'category' => 'Category',
      'pricingType' => 'Pricing Type',
      'pricingFactor' => 'Pricing Factor',
      'costPrice' => 'Cost Price',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'costPriceCurrency' => 'Cost Price Currency',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'costPriceConverted' => 'Cost Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'url' => 'URL',
      'isTaxFree' => 'Tax-free',
      'weight' => 'Weight',
      'suppliers' => 'Suppliers',
      'unitPriceSelect' => 'Unit Price (Select)',
      'unitPriceSelectCurrency' => 'Unit Price (Select) (Currency)',
      'allowFractionalQuantity' => 'Allow Fractional Quantity',
      'quantity' => 'Available',
      'quantityReserved' => 'Reserved',
      'quantitySoftReserved' => 'Soft-Reserved',
      'quantityOnHand' => 'On Hand',
      'quantityInTransit' => 'In Transit',
      'quantityOnOrder' => 'On Order',
      'quantityWarehouse' => 'Available in Warehouse',
      'quantityWarehouseOnHand' => 'On Hand in Warehouse',
      'quantityWarehouseReserved' => 'Reserved in Warehouse',
      'qty' => 'Qty',
      'isInventory' => 'Is Inventory',
      'inventoryNumberType' => 'Inventory Number Type',
      'warehousesOnHand' => 'Warehouses (On Hand)',
      'type' => 'Type',
      'template' => 'Template',
      'attributes' => 'Attributes',
      'variantAttributeOptions' => 'Attribute Values',
      'variantOrder' => 'Variant Order',
      'expirationDays' => 'Expiration Days',
      'removalStrategy' => 'Removal Strategy',
      'ciscoArchitecture' => 'Architecture (Cisco)',
      'sku' => 'SKU#',
      'offerModel' => 'Offer Model',
      'enduserType' => 'End User (Type)',
      'billingType' => 'Billing Model',
      'subCategory' => 'Subcategory',
      'partNumberDescription' => 'Part Number (Descrição)',
      'categoryType' => 'Type of Contract',
      'opportunitiesProduct' => 'Opportunities Product',
      'opportunitys' => 'Opportunitys',
      'isnewcommerce' => 'Isnewcommerce',
      'billingCycle' => 'Billing',
      'offerID' => 'OfferID',
      'formID' => 'FormID',
      'skuID' => 'SkuID',
      'identityID' => 'IdentityID',
      'lastUpdate' => 'LastUpdate',
      'duration' => 'Duration',
      'region' => 'Region',
      'instanceKey' => 'InstanceKey',
      'isReservedInstances' => 'IsReservedInstances',
      'culture' => 'Culture',
      'bestSeller' => 'BestSeller',
      'licenseType' => 'Licença',
      'timeContract' => 'Período',
      'termDuration' => 'TermDuration',
      'priceBooks' => 'Price Books',
      'sku2' => 'SKU#2',
      'sku3' => 'SKU#3',
      'productCategory' => 'Product Category',
      'update' => 'Update'
    ],
    'links' => [
      'brand' => 'Brand',
      'category' => 'Category',
      'prices' => 'Prices',
      'supplierPrices' => 'Supplier Prices',
      'inventoryNumbers' => 'Inventory Numbers',
      'inventoryTransactions' => 'Inventory Transactions',
      'attributes' => 'Attributes',
      'attributeOptions' => 'Attribute Options',
      'variantAttributeOptions' => 'Variant Attribute Options',
      'template' => 'Template',
      'variants' => 'Variants',
      'variantInventoryNumbers' => 'Variant Inventory Numbers',
      'inventoryAdjustmentItems' => 'Adjustments',
      'opportunitiesProduct' => 'Opportunities Product',
      'opportunitys' => 'Opportunities',
      'priceBooks' => 'Price Books'
    ],
    'options' => [
      'pricingType' => [
        'Same as List' => 'Same as List',
        'Fixed' => 'Fixed',
        'Discount from List' => 'Discount from List',
        'Markup over Cost' => 'Markup over Cost',
        'Profit Margin' => 'Profit Margin'
      ],
      'inventoryNumberType' => [
        'Batch' => 'Batch',
        'Serial' => 'Serial'
      ],
      'type' => [
        'Regular' => 'Regular',
        'Template' => 'Template',
        'Variant' => 'Variant'
      ],
      'removalStrategy' => [
        'FIFO' => 'FIFO',
        'FEFO' => 'FEFO',
        'LIFO' => 'LIFO'
      ],
      'ciscoArchitecture' => [
        '' => '',
        'Collab' => 'Collab',
        'Data Center' => 'Data Center',
        'Enterprise' => 'Enterprise',
        'Meraki' => 'Meraki',
        'Security' => 'Security'
      ],
      'enduserType' => [
        '' => '',
        'Charity' => 'Charity',
        'Educational' => 'Educational',
        'Corporate' => 'Corporate',
        'Commercial' => 'Commercial'
      ],
      'billingType' => [
        '' => '',
        'Anual (Pagamento Anual)' => 'Anual (Pagamento Anual)',
        'Anual (Pagamento Mensal)' => 'Anual (Pagamento Mensal)',
        'Anual (Pagamento Upfront)' => 'Anual (Pagamento Upfront)',
        'Mensal' => 'Mensal',
        'One Time' => 'One Time',
        'Trianual (Pagamento Upfront)' => 'Trianual (Pagamento Upfront)',
        'Único' => 'Único',
        'Upfront' => 'Upfront',
        'License' => 'License'
      ],
      'subCategory' => [
        '' => '',
        'Access' => 'Access',
        'BizTalk Server' => 'BizTalk Server',
        'Excel' => 'Excel',
        'Exchange Server' => 'Exchange Server',
        'Office' => 'Office',
        'Outlook' => 'Outlook',
        'PowerPoint' => 'PowerPoint',
        'Project' => 'Project',
        'Publisher' => 'Publisher',
        'SharePoint' => 'SharePoint',
        'Skype for Business Server' => 'Skype for Business Server',
        'SQL Server' => 'SQL Server',
        'Visio' => 'Visio',
        'Visual Studio' => 'Visual Studio',
        'Windows' => 'Windows',
        'Windows GGWA' => 'Windows GGWA',
        'Windows Server' => 'Windows Server',
        'Word' => 'Word',
        'Azure SQL Edge' => 'Azure SQL Edge',
        'Power Platform' => 'Power Platform',
        'Connectivity & Sharing' => 'Connectivity & Sharing',
        'Windows Server 2022' => 'Windows Server 2022',
        'Windows 7 Extended Security' => 'Windows 7 Extended Security',
        'Productivity & End user computing' => 'Productivity & End User Computing'
      ],
      'categoryType' => [
        '' => '',
        'O365/M365' => 'O365/M365',
        'D365/Power Platform' => 'D365/Power Platform',
        'Software Subscription' => 'Software Subscription',
        'Software Perpetuo' => 'Software Perpetuo',
        'CSP' => 'CSP',
        'Open' => 'Open',
        'SPLA' => 'SPLA',
        'CSP NCE' => 'CSP NCE',
        'Open Value - 1 Ano' => 'Open Value - 1 Ano',
        'Open Value - 2 Anos' => 'Open Value - 2 Anos',
        'Open Value - 3 Anos' => 'Open Value - 3 Anos',
        'Open Value' => 'Open Value'
      ],
      'billingCycle' => [
        'monthly' => 'Mensal',
        'annually' => 'Anual',
        'onetime' => 'One Time'
      ],
      'licenseType' => [
        'M365' => 'M365',
        'Software Subscription' => 'Software Subscription',
        'Software Perpetual' => 'Software Perpetual',
        'Open Value' => 'Open Value',
        'Azure' => 'Azure',
        '' => '',
        'D365' => 'D365',
        'Power Platform' => 'Power Platform',
        'Open Value Subscription' => 'Open Value Subscription',
        'OVS-ES' => 'OVS-ES',
        'O365/M365' => 'O365/M365',
        'School' => 'School'
      ],
      'timeContract' => [
        '' => '',
        '1 Month' => '1 Month',
        '1 Year' => '1 Year',
        '2 Years' => '2 Years',
        '3 Years' => '3 Years',
        'Perpetual' => 'Perpetual',
        'Pay as you go' => 'Pay as you go'
      ],
      'productCategory' => [
        '' => '',
        'Charity' => 'Charity',
        'Education' => 'Education',
        'Commercial' => 'Commercial',
        'Government' => 'Government',
        'Corporate' => 'Corporate',
        'Academic' => 'Academic'
      ]
    ],
    'presetFilters' => [
      'available' => 'Available',
      'inventory' => 'Inventory',
      'allVariants' => 'All Variants',
      'availableVariants' => 'Available Variants'
    ],
    'tabs' => [
      'inventory' => 'Inventory',
      'prices' => 'Prices',
      'variants' => 'Variants',
      'template' => 'Template',
      'orders' => 'Orders'
    ],
    'messages' => [
      'generateVariantsConfirmation' => 'Generate all possible variant combinations?',
      'variantsGenerated' => 'Done. {count} variants generated.',
      'attributesRequired' => 'At least one attribute is required',
      'optionsRequired' => 'Options are required'
    ],
    'massActions' => [
      'updatePrice' => 'Update Price'
    ]
  ],
  'ProductAttribute' => [
    'labels' => [
      'Create ProductAttribute' => 'Create Attribute',
      'Move to Top' => 'Move to Top',
      'Move Up' => 'Move Up',
      'Move Down' => 'Move Down',
      'Move to Bottom' => 'Move to Bottom'
    ],
    'fields' => [
      'order' => 'Order',
      'options' => 'Options'
    ],
    'links' => [
      'options' => 'Options',
      'products' => 'Products'
    ]
  ],
  'ProductAttributeOption' => [
    'labels' => [
      'Create ProductAttributeOption' => 'Create Option'
    ],
    'fields' => [
      'order' => 'Order',
      'attribute' => 'Attribute',
      'color' => 'Color',
      'attributeOrder' => 'Attribute Order'
    ],
    'links' => [
      'attribute' => 'Attribute',
      'products' => 'Products',
      'productVariants' => 'Product Variants'
    ]
  ],
  'ProductBrand' => [
    'labels' => [
      'Create ProductBrand' => 'Create Product Brand'
    ],
    'fields' => [
      'website' => 'Website',
      'opportunities' => 'Opportunities',
      'partnerIDs' => 'Partner IDs',
      'sources' => 'Sources',
      'lead' => 'Lead',
      'leads' => 'Leads',
      'partnerPrograms' => 'Partner Programs',
      'cpb' => 'Cloud Practice Builder',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'programs' => 'Program',
      'aWSs' => 'AWS',
      'events' => 'Events',
      'task' => 'Task',
      'dSET' => 'DSET',
      'vendorCloudConsumption' => 'Vendor Cloud Consumption',
      'tasks' => 'Tasks',
      'campanas' => 'Campaigns',
      'marketing' => 'Campaigns',
      'marketings' => 'Marketing',
      'opportunityItem' => 'Opportunity Item',
      'service' => 'Services',
      'vendorAccounts' => 'Vendor Accounts'
    ],
    'links' => [
      'products' => 'Products',
      'opportunities' => 'Opportunities',
      'partnerIDs' => 'Partner IDs',
      'sources' => 'Sources',
      'lead' => 'Lead',
      'leads' => 'Leads',
      'partnerPrograms' => 'Partner Programs',
      'cpb' => 'Cloud Practice Builder',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'programs' => 'Program',
      'aWSs' => 'AWS',
      'events' => 'Events',
      'task' => 'Task',
      'dSET' => 'DSET',
      'vendorCloudConsumption' => 'Vendor Cloud Consumption',
      'tasks' => 'Tasks',
      'campanas' => 'Campaigns',
      'marketing' => 'Marketing Campaigns',
      'marketings' => 'Marketing',
      'opportunityItem' => 'Opportunity Item',
      'service' => 'Service',
      'vendorAccounts' => 'Vendor Accounts'
    ]
  ],
  'ProductCategory' => [
    'labels' => [
      'Create ProductCategory' => 'Create Category',
      'Manage Categories' => 'Manage Categories',
      'Products' => 'Products'
    ],
    'fields' => [
      'order' => 'Order',
      'childList' => 'Child List'
    ],
    'links' => [
      'products' => 'Products'
    ]
  ],
  'ProductPrice' => [
    'labels' => [
      'Create ProductPrice' => 'Create Price'
    ],
    'fields' => [
      'priceBook' => 'Price Book',
      'status' => 'Status',
      'product' => 'Product',
      'minQuantity' => 'Min. Quantity',
      'price' => 'Price',
      'priceCurrency' => 'Price Currency',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'minQty' => 'Min. Qty',
      'partNumber' => 'Part Number',
      'priceConverted' => 'Price Converted'
    ],
    'links' => [
      'priceBook' => 'Price Book',
      'product' => 'Product'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'tooltips' => [
      'minQuantity' => 'The price will be used only when the quantity of items being sold exceeds the specified value.'
    ],
    'messages' => [
      'priceMassUpdated' => 'Prices updated, count: {count}'
    ],
    'massActions' => [
      'updatePrice' => 'Update Price'
    ]
  ],
  'PurchaseOrder' => [
    'labels' => [
      'Create PurchaseOrder' => 'Create Purchase Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Purchase Order Items' => 'Purchase Order Items',
      'Create Receipt' => 'Create Receipt'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'supplierAddress' => 'Supplier Address',
      'supplierAddressStreet' => 'Street (Supplier)',
      'supplierAddressCity' => 'City (Supplier)',
      'supplierAddressState' => 'State (Supplier)',
      'supplierAddressCountry' => 'Country (Supplier)',
      'supplierAddressPostalCode' => 'Postal Code (Supplier)',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'supplier' => 'Supplier',
      'warehouse' => 'Ship to Warehouse',
      'isReceiptFullyCreated' => 'Receipt Fully Created',
      'hasInventoryItems' => 'Has Inventory Items',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'account' => 'Account',
      'tax' => 'Tax',
      'supplier' => 'Supplier',
      'inventoryTransactions' => 'Inventory Transactions',
      'receiptOrders' => 'Receipt Orders',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Released' => 'Released',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'cannotCreateReceiptInEditMode' => 'Cannot create receipt orders while in edit mode.'
    ]
  ],
  'PurchaseOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'order' => 'Line Number',
      'purchaseOrder' => 'Purchase Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'purchaseOrderStatus' => 'Purchase Order Status',
      'inventoryNumberType' => 'Inventory Number Type'
    ],
    'links' => [
      'purchaseOrder' => 'Purchase Order',
      'product' => 'Product',
      'account' => 'Account'
    ],
    'labels' => [
      'Purchase Orders' => 'Purchase Orders'
    ]
  ],
  'Quote' => [
    'labels' => [
      'Create Quote' => 'Create Quote',
      'Taxes' => 'Taxes',
      'Shipping Providers' => 'Shipping Providers',
      'Add Item' => 'Add Item',
      'Templates' => 'Templates',
      'Items' => 'Items',
      'Quote Items' => 'Quote Items',
      'Apply Price Book' => 'Apply Price Book',
      'Locked' => 'Locked',
      'Unlocked' => 'Unlocked',
      'Send in Email' => 'Send in Email'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Quote Number',
      'numberA' => 'Quote Number (auto-incremented)',
      'invoiceNumber' => 'Invoice Number',
      'account' => 'Account',
      'opportunity' => 'Opportunity',
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateQuoted' => 'Date Quoted',
      'dateOrdered' => 'Date Ordered',
      'dateInvoiced' => 'Date Invoiced',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'priceBook' => 'Price Book',
      'inventoryStatus' => 'Inventory Status',
      'isDone' => 'Is Done',
      'amountDiscounted' => 'Total Discounted Amount',
      'amountDiscountedCurrency' => 'Total Discounted Amount (Currency)',
      'amountDiscountedConverted' => 'Total Discounted Amount (Converted)',
      'quoteAccessKey' => 'Quotation Access Key',
      'receipt' => 'Tax Invoice',
      'quotePage' => 'Quote Page',
      'reply' => 'Quote Review',
      'billingContactEmail' => 'Billing Contact Email',
      'oppStage' => 'Opportunity Stage',
      'commercialConditions' => 'Commercial Conditions',
      'contacts' => 'Contacts',
      'documents' => 'Documents',
      'sendEmail' => 'Send Email to Billing Contact',
      'reviewDate' => 'Review Date',
      'amountWithDiscount' => 'Total Amount (With Discount)',
      'amountWithDiscountCurrency' => 'Total Amount (With Discount) (Currency)',
      'amountWithDiscountConverted' => 'Total Amount (With Discount) (Converted)',
      'quotes' => 'Versions',
      'quoteParent' => 'Price',
      'version' => 'Version'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'opportunity' => 'Opportunity',
      'account' => 'Account',
      'tax' => 'Tax',
      'salesOrders' => 'Sales Orders',
      'invoices' => 'Invoices',
      'priceBook' => 'Price Book',
      'inventoryData' => 'Inventory Data',
      'contacts' => 'Contacts',
      'documents' => 'Documents',
      'quotes' => 'Versions',
      'quoteParent' => 'Quote'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'In Review' => 'In Review',
        'Presented' => 'Presented',
        'Approved' => 'Approved',
        'Rejected' => 'Rejected',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'approved' => 'Approved'
    ],
    'messages' => [
      'cannotRemoveLockedRecord' => 'Cannot remove the locked record.',
      'massLockDone' => '{count} locked',
      'massUnlockDone' => '{count} unlocked',
      'confirmMassLock' => 'Are you sure you want to lock selected records?',
      'confirmMassUnlock' => 'Are you sure you want to unlock selected records?',
      'cantModifyLocked' => 'Cannot modify *{field}* in the locked record.',
      'productTemplateCannotBeSelected' => 'A product template cannot be selected in an item. *{name}* is a template.',
      'fieldCannotBeFractional' => 'Quantity cannot be fractional for this product',
      'invalidItems' => 'Invalid items.',
      'requiredInventoryNumber' => 'Inventory Number is required.',
      'requiredQuantityReceived' => 'Quantity Received is required.',
      'notEnoughQuantity' => 'Not enough quantity is available.',
      'enoughQuantity' => 'Enough quantity is available.',
      'softNotEnoughQuantity' => 'Enough quantity is on hand but some items are soft-reserved.',
      'applyNewPriceConfirmation' => 'A different price is available for the specified quantity. Would you like to apply it?',
      'cannotUnlockByRegularUser' => 'Cannot unlock. Only an administrator is permitted.'
    ],
    'texts' => [
      'onHandQuantityInfo' => 'On hand',
      'availableQuantityInfo' => 'Available',
      'lackingQuantityInfo' => 'Lacking',
      'totalAvailableQuantityInfo' => 'In all warehouses',
      'totalOnHandQuantityInfo' => 'On hand in all warehouses',
      'onHandInventoryNumberInfo' => 'Inv. number on hand',
      'onHandBatchInfo' => 'On hand in batch',
      'onHandSerialInfo' => 'Serial on hand'
    ],
    'tooltips' => [
      'quoteAccessKey' => 'To generate an Access Key, please select "Billing Contact".'
    ]
  ],
  'QuoteItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'order' => 'Line Number',
      'quote' => 'Quote',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'quoteStatus' => 'Quote Status',
      'discountAmount' => 'Value with Discount',
      'discountAmountCurrency' => 'Total Amount (With Discount) (Currency)',
      'discountAmountConverted' => 'Total Amount (With Discount) (Converted)',
      'timeContract' => 'Time Contract',
      'solutionType' => 'Billing',
      'discountItem' => 'Discount (%)'
    ],
    'links' => [
      'quote' => 'Quote',
      'product' => 'Product',
      'account' => 'Account'
    ],
    'labels' => [
      'Quotes' => 'Quotes'
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'options' => [
      'timeContract' => [
        '' => '',
        '1 Month' => '1 Month',
        '1 Year' => '1 Year',
        '2 Years' => '2 Years',
        '3 Years' => '3 Years',
        'Perpetual' => 'Perpetual',
        'Pay as you go' => 'Pay as you go'
      ],
      'solutionType' => [
        '' => '',
        '1 Month' => '1 Month',
        '1 Year' => '1 Year',
        'Monthly' => 'Monthly',
        'Annual' => 'Anual',
        'Up Front' => 'Up Front',
        '2 Years' => '2 Years',
        '3 Years' => '3 Years',
        'Flexible' => 'Flexible',
        'Perpetual' => 'Perpetual',
        'Pay as you go' => 'Pay as you go',
        'Quote' => 'Quote',
        'Annual - Monthly Payment' => 'Annual - Monthly Payment',
        'Trial Version' => 'Trial '
      ]
    ]
  ],
  'ReceiptOrder' => [
    'labels' => [
      'Create ReceiptOrder' => 'Create Receipt Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Received Inventory' => 'Received Inventory',
      'Import Serial Numbers' => 'Import Serial Numbers',
      'CSV File' => 'CSV File'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'supplier' => 'Supplier',
      'purchaseOrder' => 'Purchase Order',
      'returnOrder' => 'Return Order',
      'shippingContact' => 'Shipping Contact',
      'shippingCost' => 'Shipping Cost',
      'amount' => 'Amount',
      'shippingProvider' => 'Shipping Provider',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'amountCurrency' => 'Amount Currency',
      'itemList' => 'Item List',
      'receivedItemList' => 'Received Item List',
      'dateOrdered' => 'Date Ordered',
      'dateReceived' => 'Date Received',
      'weight' => 'Weight',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'currency' => 'Currency',
      'isDone' => 'Is Done',
      'warehouse' => 'Warehouse',
      'fieldDelimiter' => 'Field Delimiter',
      'textQualifier' => 'Text Qualifier',
      'headerRow' => 'Header Row',
      'columnNumber' => 'Column Number',
      'preview' => 'Preview'
    ],
    'links' => [
      'items' => 'Items',
      'receivedItems' => 'Received Items',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'purchaseOrder' => 'Purchase Order',
      'returnOrder' => 'Return Order',
      'account' => 'Account',
      'supplier' => 'Supplier',
      'inventoryTransactions' => 'Inventory Transactions',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'inventoryIsInAdjustment' => 'Can\'t save as inventory is currently in a started adjustment.',
      'serialNumbersExists' => 'Some serial numbers already exists.

{numbers}',
      'serialNumberImportLimitExceeded' => 'Cannot import more than {maxSize} serial numbers.',
      'serialNumberAlreadyInStock' => 'Serial number already in stock.

{numbers}',
      'receivedSerialNumberNotOne' => 'Quantity of a received item with a serial number should be one.',
      'receivedInventoryNumberProductMismatch' => 'Inventory number does not correspond to the product.',
      'receivedInventoryNumberIsEmpty' => 'Not specified inventory number.',
      'receivedQuantityMismatch' => 'Received quantity mismatch.',
      'emptyQuantityReceived' => 'Need to specify Quantity Received before completing the order.'
    ]
  ],
  'ReceiptOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'qtyReceived' => 'Qty Rcv',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'quantityReceived' => 'Quantity Received',
      'quantityReceivedInt' => 'Quantity Received (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'receiptOrder' => 'Receipt Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'account' => 'Account',
      'receiptOrderStatus' => 'Receipt Order Status',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'receiptOrder' => 'Receipt Order',
      'product' => 'Product',
      'account' => 'Account'
    ]
  ],
  'ReturnOrder' => [
    'labels' => [
      'Create ReturnOrder' => 'Create Return Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Create Receipt' => 'Create Receipt'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'salesOrder' => 'Sales Order',
      'billingAddress' => 'Billing Address',
      'fromAddress' => 'Ship from Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'fromAddressStreet' => 'Street (from)',
      'fromAddressCity' => 'City (from)',
      'fromAddressState' => 'State (from)',
      'fromAddressCountry' => 'Country (from)',
      'fromAddressPostalCode' => 'Postal Code (from)',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'supplier' => 'Supplier',
      'warehouse' => 'Ship to Warehouse',
      'isReceiptFullyCreated' => 'Receipt Fully Created',
      'hasInventoryItems' => 'Has Inventory Items',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'account' => 'Account',
      'salesOrder' => 'Sales Order',
      'tax' => 'Tax',
      'supplier' => 'Supplier',
      'receiptOrders' => 'Receipt Orders',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Released' => 'Released',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'cannotCreateReceiptInEditMode' => 'Cannot create receipt orders while in edit mode.'
    ]
  ],
  'ReturnOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'inventoryNumber' => 'Inventory Number',
      'order' => 'Line Number',
      'returnOrder' => 'Return Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'returnOrderStatus' => 'Return Order Status',
      'inventoryNumberType' => 'Inventory Number Type'
    ],
    'links' => [
      'returnOrder' => 'Return Order',
      'product' => 'Product',
      'account' => 'Account'
    ]
  ],
  'SalesOrder' => [
    'labels' => [
      'Create SalesOrder' => 'Create Sales Order',
      'Taxes' => 'Taxes',
      'Shipping Providers' => 'Shipping Providers',
      'Add Item' => 'Add Item',
      'Templates' => 'Templates',
      'Items' => 'Items',
      'Sales Order Items' => 'Sales Order Items',
      'Create Delivery' => 'Create Delivery',
      'Add Delivery' => 'Add Delivery',
      'Not Created' => 'Not Created'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'opportunity' => 'Opportunity',
      'quote' => 'Quote',
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount',
      'amount' => 'FOB',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'dateInvoiced' => 'Date Invoiced',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'priceBook' => 'Price Book',
      'inventoryData' => 'Inventory Data',
      'inventoryStatus' => 'Inventory Status',
      'isDeliveryCreated' => 'Delivery Created',
      'hasInventoryItems' => 'Has Inventory Items',
      'isDone' => 'Is Done',
      'partnerID' => 'Partner ID',
      'quantity' => 'Qtd.',
      'cloudsolvSSAID' => 'CloudSolv SSA ID',
      'contractEndDateVendor' => 'Data de Vencimento',
      'subscriptionAutomaticRenew' => 'Automatic renewal',
      'orderDetail' => 'Order Detail',
      'subscriptionID' => 'SubscriptionID',
      'billingCycle' => 'Billing Cycle',
      'endUserAmount' => 'End User',
      'endUserAmountCurrency' => 'End User Amount (Currency)',
      'endUserAmountConverted' => 'End User Amount (Converted)',
      'subscriptionAmount' => 'Partner Markup',
      'subscriptionAmountCurrency' => 'SubscriptionAmount (Currency)',
      'subscriptionAmountConverted' => 'SubscriptionAmount (Converted)',
      'listPrice' => 'List Price',
      'discountPricingRules' => 'Discount Pricing Rules',
      'markupPricingRules' => 'Markup Pricing Rules',
      'pricingInfo' => 'Pricing Info',
      'contractIdExternal' => 'Contract External ID',
      'directbilling' => 'Direct Billing',
      'contractLastRenovation' => 'Last Renovation',
      'termDuration' => 'Term Duration',
      'profit' => 'Profit',
      'profitCurrency' => 'Profit (Currency)',
      'profitConverted' => 'Profit (Converted)',
      'countryExternal' => 'Country',
      'accountNameExternal' => 'End Customer',
      'accountParentNameExternal' => 'Partner',
      'vendorCloudConsumption' => 'Vendor Cloud Consumption',
      'vendorAccountName' => 'VendorAccountName',
      'cloudConsumption' => 'Cloud Consumption',
      'productSSA' => 'Product',
      'reseller' => 'Reseller',
      'microsoftRecommendations' => 'Microsoft Recommendation',
      'microsoftRecommendationsText' => 'Recommendation',
      'top5Customers' => 'Cliente Top 5',
      'accountTop5' => 'Account',
      'accountReservedInstances' => 'Account',
      'accountRecommendation' => 'Account Recommendations',
      'product' => 'Product',
      'converterQuantity' => 'Qtd.',
      'microsoftRecommendationsEmail' => 'Recommendation (Email)',
      'contractEndDateDays' => 'Expiration in (days)'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'opportunity' => 'Opportunity',
      'account' => 'Account',
      'tax' => 'Tax',
      'quote' => 'Quote',
      'invoices' => 'Invoices',
      'deliveryOrders' => 'Delivery Orders',
      'returnOrders' => 'Return Orders',
      'priceBook' => 'Price Book',
      'inventoryTransactions' => 'Inventory Transactions',
      'partnerID' => 'Partner ID',
      'vendorCloudConsumption' => 'Vendor Cloud Consumption',
      'cloudConsumption' => 'Cloud Consumption',
      'reseller' => 'Reseller',
      'accountTop5' => 'Account',
      'accountReservedInstances' => 'Account',
      'accountRecommendation' => 'Account Recommendations',
      'service' => 'Service'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'Active' => 'Active',
        'Approved' => 'Approved',
        'Completed' => 'Completed',
        'Rejected' => 'Rejected',
        'Canceled' => 'Canceled'
      ],
      'billingCycle' => [
        'Monthly' => 'Monthly',
        'Annualy' => 'Annualy',
        'Annually' => 'Annually',
        'OneTime' => 'OneTime',
        '' => 'Empty'
      ],
      'countryExternal' => [
        'BR' => 'BR',
        'CL' => 'CL',
        'CO' => 'CO',
        'AR' => 'AR',
        'EC' => 'EC',
        'CH' => 'CH',
        'PE' => 'PE',
        'PA' => 'PA',
        '' => '',
        'MX' => 'MX'
      ],
      'microsoftRecommendations' => [
        'Copilot M365' => 'Copilot M365',
        'EMS E3' => 'EMS E3',
        'EMS E5' => 'EMS E5',
        'Microsoft 365 Business Premium' => 'Microsoft 365 Business Premium',
        'Microsoft 365 Business Standard' => 'Microsoft 365 Business Standard',
        'Microsoft 365 A3' => 'Microsoft 365 A3',
        'Microsoft 365 A5' => 'Microsoft 365 A5',
        'Office 365 E1' => 'Office 365 E1',
        'Office 365 E3' => 'Office 365 E3',
        'Office 365 E5' => 'Office 365 E5',
        'Windows E3' => 'Windows E3',
        'Windows E5' => 'Windows E5',
        'None' => 'None',
        'Microsoft 365 Business Standard + Copilot M365' => 'Microsoft 365 Business Standard + Copilot M365',
        'Office 365 E3 + Copilot M365' => 'Office 365 E3 + Copilot M365'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed',
      'reportFilter664d0b06517450b14' => 'Renewals - Next 30 days',
      'reportFilter664d0e340882520f7' => 'Renewals - 31 to 60 days',
      'reportFilter664d0e6ceb98d29e4' => 'Renewals - 61 to 90 days',
      'reportFilter664d0eba732cf5106' => 'Renewals Reserved Instance - 90 days',
      'reportFilter664d0fd3e3ead8274' => 'Renewals Auto OFF - Next 30 days',
      'reportFilter664d101ecb1f34383' => 'Renewals Auto OFF - 31 to 60 days',
      'reportFilter664d1038e67c31c3c' => 'Renewals Auto OFF - 61 to 90 days',
      'reportFilter664dfdebb84637a58' => 'Renewals - next 90 days',
      'reportFilter664e33d0e85544c6c' => 'Renewals Recommendation Copilot M365',
      'reportFilter66831cbe23b6204fe' => 'Count Renewals Recommendation Microsoft',
      'reportFilter669153f230b85ba6a' => 'Renewals - Top 5 Customers',
      'reportFilter66916dc409c1b86f7' => 'Renewals - Reserved Instance'
    ],
    'messages' => [
      'cannotCreateDeliveryInEditMode' => 'Cannot create delivery orders while in edit mode.'
    ]
  ],
  'SalesOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'order' => 'Line Number',
      'salesOrder' => 'Sales Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'salesOrderStatus' => 'Sales Order Status',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory',
      'services' => 'Services'
    ],
    'links' => [
      'salesOrder' => 'Sales Order',
      'product' => 'Product',
      'account' => 'Account',
      'services' => 'Services'
    ],
    'labels' => [
      'Sales Orders' => 'Sales Orders'
    ]
  ],
  'ShippingProvider' => [
    'labels' => [
      'Create ShippingProvider' => 'Create Shipping Provider'
    ],
    'fields' => [
      'website' => 'Website'
    ]
  ],
  'Supplier' => [
    'labels' => [
      'Create Supplier' => 'Create Supplier'
    ],
    'fields' => [
      'account' => 'Account',
      'status' => 'Status'
    ],
    'links' => [
      'account' => 'Account',
      'prices' => 'Prices',
      'purchaseOrders' => 'Purchase Orders'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ]
  ],
  'SupplierProductPrice' => [
    'labels' => [
      'Create SupplierProductPrice' => 'Create Supplier Price'
    ],
    'fields' => [
      'supplier' => 'Supplier',
      'status' => 'Status',
      'product' => 'Product',
      'minQuantity' => 'Min. Quantity',
      'price' => 'Price',
      'priceCurrency' => 'Price Currency',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'minQty' => 'Min. Qty',
      'partNumber' => 'Part Number',
      'priceConverted' => 'Price Converted'
    ],
    'links' => [
      'supplier' => 'Supplier',
      'product' => 'Product'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'massActions' => [
      'updatePrice' => 'Update Price'
    ]
  ],
  'Tax' => [
    'labels' => [
      'Create Tax' => 'Create Tax'
    ],
    'fields' => [
      'rate' => 'Rate'
    ]
  ],
  'TransferOrder' => [
    'labels' => [
      'Create TransferOrder' => 'Create Transfer Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Valid' => 'Valid',
      'Invalid' => 'Invalid',
      'Show Availability' => 'Show Availability',
      'Availability' => 'Availability',
      'Total' => 'Total'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'fromWarehouse' => 'From Warehouse',
      'toWarehouse' => 'To Warehouse',
      'fromAddress' => 'Ship from Address',
      'toAddress' => 'Ship to Address',
      'shippingCost' => 'Shipping Cost',
      'amount' => 'Amount',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'amountCurrency' => 'Amount Currency',
      'shippingProvider' => 'Shipping Provider',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'shippingDate' => 'Shipping Date',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'currency' => 'Currency',
      'inventoryData' => 'Inventory Data',
      'inventoryStatus' => 'Inventory Status',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'inventoryTransactions' => 'Inventory Transactions',
      'fromWarehouse' => 'From Warehouse',
      'toWarehouse' => 'To Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'In Progress' => 'In Progress',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Failed' => 'Failed'
      ],
      'inventoryStatus' => [
        'Available' => 'Available',
        'On Hand' => 'On Hand',
        'Not Available' => 'Not Available'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'warehousesAreSame' => 'Warehouses must be different'
    ]
  ],
  'TransferOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'qtyReceived' => 'Qty Rcv',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'quantityReceived' => 'Quantity Received',
      'quantityReceivedInt' => 'Quantity Received (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'transferOrder' => 'Transfer Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'transferOrderStatus' => 'Transfer Order Status',
      'inventoryNumber' => 'Inventory Number',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'transferOrder' => 'Transfer Order',
      'product' => 'Product',
      'inventoryNumber' => 'Inventory Number'
    ]
  ],
  'Warehouse' => [
    'labels' => [
      'Create Warehouse' => 'Create Warehouse'
    ],
    'fields' => [
      'status' => 'Status',
      'isAvailableForStock' => 'Available for Stock',
      'isStock' => 'Stock'
    ],
    'links' => [
      'inventoryTransactions' => 'Inventory Transactions',
      'products' => 'Products',
      'inventoryNumbers' => 'Inventory Numbers'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active'
    ]
  ],
  'DashboardSet' => [
    'fields' => [
      'dashboardTemplate' => 'Dashboard Template',
      'iconClass' => 'Icon',
      'number' => 'Number'
    ],
    'labels' => [
      'Create DashboardSet' => 'Create Dashboard Set'
    ],
    'links' => [
      'dashboardTemplate' => 'Dashboard Template'
    ]
  ],
  'Service' => [
    'fields' => [
      'account' => 'Account',
      'amount' => 'Amount',
      'amountConverted' => 'Amount (converted)',
      'amountCurrency' => 'Amount Currency',
      'description' => 'Description',
      'itemList' => 'Item List',
      'name' => 'Name',
      'billingSituation' => 'Situação Financeira',
      'billingType' => 'Tipo de Faturamento',
      'cancelReason' => 'Motivo de Cancelamento',
      'stage' => 'Status',
      'consumptionEstimate' => 'Estimativa de Consumo (Mensal)',
      'consumptionEstimateCurrency' => 'Estimativa de Consumo (Mensal) (Currency)',
      'consumptionEstimateConverted' => 'Estimativa de Consumo (Mensal) (Converted)',
      'costVSReceipt' => 'Lucro',
      'costVSReceiptCurrency' => 'Lucro (Currency)',
      'costVSReceiptConverted' => 'Lucro (Converted)',
      'custo' => 'Custo',
      'custoCurrency' => 'Custo (Currency)',
      'custoConverted' => 'Custo (Converted)',
      'custoUSD' => 'Custo (Convertido)',
      'custoUSDCurrency' => 'Custo (Convertido) (Currency)',
      'custoUSDConverted' => 'Custo (Convertido) (Converted)',
      'documents' => 'Documentos',
      'productBrand' => 'Fabricante',
      'servicesVersionses' => 'Service Versions',
      'dollarAmount' => 'Cotação do Dólar',
      'endDate' => 'Data de Conclusão',
      'endUserEmail' => 'Cliente Final (E-mail)',
      'faturamento' => 'Faturamento',
      'followup' => 'Follow Up',
      'installationCost' => 'Custo de Instalação',
      'installationCostCurrency' => 'Custo de Instalação (Currency)',
      'installationCostConverted' => 'Custo de Instalação (Converted)',
      'serviceType' => 'Tipo de Serviço',
      'installationMarkupPercentage' => 'Markup Instalação / Implementação (%)',
      'installationRevenue' => 'Receita em Instalação / Implementação',
      'installationRevenueCurrency' => 'Receita em Instalação / Implementação (Currency)',
      'installationRevenueConverted' => 'Receita em Instalação / Implementação (Converted)',
      'margem' => 'Margem (%)',
      'mso' => 'MSO',
      'nfParceiro' => 'NF Parceiro',
      'nfSYNNEX' => 'NF TD SYNNEX',
      'netRevenueCloud' => 'Receita Líquida (Com Impostos)',
      'netRevenueCloudCurrency' => 'Receita Líquida (Com Impostos) (Currency)',
      'netRevenueCloudConverted' => 'Receita Líquida (Com Impostos) (Converted)',
      'notes' => 'Observações',
      'number' => 'Número',
      'opportunityType' => 'Tipo de Oportunidade',
      'order' => 'Order',
      'pO' => 'PO',
      'pOID' => 'PO ID',
      'partnerCommission' => 'Comissão da Revenda',
      'partnerCommissionCurrency' => 'Comissão da Revenda (Currency)',
      'partnerCommissionConverted' => 'Comissão da Revenda (Converted)',
      'operadoraRevendaEmail' => 'Operadora / Revenda (Email)',
      'partnerNumber' => 'Partner Number',
      'projectType' => 'Tipo do Projeto',
      'receita' => 'Receita',
      'receitaCurrency' => 'Receita (Currency)',
      'receitaConverted' => 'Receita (Converted)',
      'revenue' => 'Revenue',
      'revenueCurrency' => 'Revenue (Currency)',
      'revenueConverted' => 'Revenue (Converted)',
      'revenueNet' => 'Revenue Net',
      'revenueNetCurrency' => 'Revenue Net (Currency)',
      'revenueNetConverted' => 'Revenue Net (Converted)',
      'sellingDate' => 'Data de Venda',
      'sendingDate' => 'Data de Envio',
      'serviceActivity' => 'Atividade do Serviço',
      'serviceAmountTotal' => 'Valor Bruto do Serviço (BRL)',
      'serviceAmountTotalCurrency' => 'Valor Bruto do Serviço (BRL) (Currency)',
      'serviceAmountTotalConverted' => 'Valor Bruto do Serviço (BRL) (Converted)',
      'serviceAmountTotalUSD' => 'Valor Bruto do Serviço (USD)',
      'serviceAmountTotalUSDCurrency' => 'Valor Bruto do Serviço (USD) (Currency)',
      'serviceAmountTotalUSDConverted' => 'Valor Bruto do Serviço (USD) (Converted)',
      'servicePartnerValue' => 'Valor do Parceiro de Serviço',
      'servicePartnerValueCurrency' => 'Valor do Parceiro de Serviço (Currency)',
      'servicePartnerValueConverted' => 'Valor do Parceiro de Serviço (Converted)',
      'serviceProviderVarchar' => 'Prestador de Serviços',
      'solicitationDate' => 'Data da Solicitação do Serviço',
      'startDate' => 'Data de Início',
      'supportCost' => 'Custo de Suporte',
      'supportCostCurrency' => 'Custo de Suporte (Currency)',
      'supportCostConverted' => 'Custo de Suporte (Converted)',
      'supportMarkupPercentage' => 'Markup Suporte (%)',
      'supportRevenue' => 'Receita em Suporte',
      'supportRevenueCurrency' => 'Receita em Suporte (Currency)',
      'supportRevenueConverted' => 'Receita em Suporte (Converted)',
      'ticket' => 'Ticket',
      'accountType' => 'Tipo de Parceiro',
      'totalCost' => 'Custo Total',
      'totalCostCurrency' => 'Custo Total (Currency)',
      'totalCostConverted' => 'Custo Total (Converted)',
      'totalRevenue' => 'Receita Total',
      'totalRevenueCurrency' => 'Receita Total (Currency)',
      'totalRevenueConverted' => 'Receita Total (Converted)',
      'type' => 'Serviços Prestados',
      'update' => 'Update',
      'version' => 'Versão',
      'winProbability' => 'Probabilidade de Fechamento',
      'tax' => 'Impostos (%)',
      'proposalDueDate' => 'Data Limite (Envio da Proposta)',
      'createVersion' => 'Criar Versão',
      'requester' => 'Solicitante',
      'createBilling' => 'Criar Faturamento',
      'billing' => 'Faturamento'
    ],
    'labels' => [
      'Add Item' => 'Add Item',
      'Add Products' => 'Add Products',
      'Create Service' => 'Create Service',
      'Items' => 'Items',
      'Select Product' => 'Select Product'
    ],
    'links' => [
      'invoices' => 'Invoices',
      'items' => 'Items',
      'quotes' => 'Quotes',
      'salesOrders' => 'Sales Orders',
      'documents' => 'Documentos',
      'productBrand' => 'Fabricante',
      'servicesVersionses' => 'Service Versions'
    ],
    'options' => [
      'billingSituation' => [
        'Aguardando para Faturar' => 'Aguardando para Faturar',
        'Em Faturamento' => 'Em Faturamento',
        'Faturado' => 'Faturado',
        'Serviço Free' => 'Free'
      ],
      'billingType' => [
        '' => '',
        'Cliente' => 'Cliente',
        'Revenda' => 'Revenda'
      ],
      'stage' => [
        '' => '',
        'Pendente de informação' => 'Pendente de informação',
        'Enviada' => 'Enviada',
        'Possível' => 'Em negociação',
        'Revisado' => 'Revisado',
        'Em vias de fechamento' => 'Em vias de fechamento',
        'Ganho' => 'Ganho',
        'Perdido / Cancelado' => 'Perdido / Cancelado',
        'Criação Indevida' => 'Criação Indevida',
        'Ainda temos chance' => 'Ainda temos chance',
        'Faturado' => 'Faturado',
        'A faturar' => 'A faturar',
        'Aguardando Checklist' => 'Aguardando Checklist',
        'Pré Vendas' => 'Pré Vendas',
        'Serviço WIP' => 'Serviço WIP',
        'Serviço Finalizado' => 'Serviço Finalizado'
      ],
      'faturamento' => [
        '' => '',
        'Faturado' => 'Faturado',
        'Será Faturado' => 'Será Faturado',
        'Aguardando Pedido' => 'Aguardando Pedido',
        'Em negociação' => 'Em negociação'
      ],
      'serviceType' => [
        '' => '',
        'Serviços Profissionais' => 'Serviços Profissionais',
        'Serviços Cloud' => 'Serviços Cloud',
        'Treinamento' => 'Treinamentos'
      ],
      'opportunityType' => [
        '' => '',
        'Pagamento' => 'Pagamento',
        'Recebimento (Venda)' => 'Recebimento (Venda)'
      ],
      'projectType' => [
        '' => '',
        'Partner to Partner' => 'Partner to Partner',
        'Ficha de Oferta' => 'Ficha de Oferta',
        'MOSP para CSP' => 'MOSP para CSP'
      ],
      'serviceActivity' => [
        '' => '',
        'Serviço de DNS' => 'Serviço de DNS',
        'Migração de recursos do Azure entre Tenants' => 'Migração de recursos do Azure entre Tenants',
        'Migração de VM' => 'Migração de VM',
        'Suporte' => 'Suporte',
        'Implementação de Serviço de DLP' => 'Implementação de Serviço de DLP',
        'Implementação' => 'Implementação'
      ],
      'type' => [
        'Cloud' => 'Cloud',
        'Serviços Profissionais' => 'Serviços Profissionais',
        'Treinamento' => 'Treinamento',
        'Suporte' => 'Suporte',
        'Educação' => 'Educação'
      ],
      'winProbability' => [
        0 => '0',
        10 => '10%',
        20 => '20%',
        40 => '40%',
        80 => '80%',
        100 => '100%'
      ]
    ],
    'presetFilters' => [],
    'tooltips' => [
      'installationMarkupPercentage' => 'Valores entre 0-100.'
    ]
  ],
  'ServiceItem' => [
    'fields' => [
      'amount' => 'Amount',
      'amountConverted' => 'Amount (Converted)',
      'amountCurrency' => 'Amount (Currency)',
      'description' => 'Description',
      'name' => 'Name',
      'order' => 'Line Number',
      'product' => 'Product',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'service' => 'Service',
      'unitPrice' => 'Unit Price',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'unitPriceCurrency' => 'Unit Price (Currency)'
    ],
    'labels' => [
      'Services' => 'Services'
    ],
    'links' => [
      'product' => 'Product',
      'service' => 'Service'
    ]
  ],
  'AWS' => [
    'fields' => [
      'tier' => 'Tier',
      'account' => 'Account',
      'productBrand' => 'Product Brand',
      'sumSelect' => 'SumSelect',
      'partnerType' => 'Partner Type',
      'competency' => 'Competency',
      'partnerBusinessPlan' => 'Partner Business Plan',
      'launchedOppsAmount' => 'Launched Opps Amount',
      'launchedOppsAmountCurrency' => 'Launched Opps Amount (Currency)',
      'launchedOppsAmountConverted' => 'Launched Opps Amount (Converted)',
      'accountCountry' => 'account Country',
      'city' => 'Ciudad',
      'region' => 'Region',
      'country' => 'Pais',
      'levelCheck' => 'Level Check',
      'accounts' => 'Cuentas',
      'aWSAccreditedProfessionalsBussines' => 'AWS Accredited Professionals - Business',
      'aWSAccreditedProfessionalsTechnical' => 'Accredited Professionals - Technical',
      'aWSFoundationalCertifiedIndividuals' => 'Foundational Certified individuals',
      'aWSTechnicalCertifiedIndividuals' => 'Technical Certified individuals',
      'aWSTechnicalCertifiedIndividualsAssociate' => 'Technical Certified Individuals - Associate',
      'aWSTechnicalCertifiedIndividualsProOrSpecialty' => 'Technical Certified Individuals - Pro or Specialt',
      'customerSatisfactionResponses' => 'Customer Satisfaction Responses',
      'launchedOppsCount' => 'Launched Opps Count',
      'publiclyReferenceableCustomers' => 'Publicly Referenceable Customers',
      'account1' => 'Accounts',
      'specialities' => 'Especialidades',
      'countCompetency' => 'Conteo de Competencias',
      'countEspecialidades' => 'Conteo de Especialidades',
      'lastupdate' => 'AVT Report',
      'awsVersions' => 'AWS Versions',
      'technicalprogram' => 'Technical Program Validations',
      'opportunities' => 'Opportunities',
      'update' => 'Crear Version',
      'accountsAWS' => 'Cuentas AWS',
      'levelCheckCustomerSuccessThinkBig' => 'Level Check - Customer Success (Think Big)',
      'levelCheckExperienceThinkBig' => 'Level Check - Experience (Think Big)',
      'levelCheckKnowledgeThinkBig' => 'Level Check - Knowledge (Think Big)',
      'levelCheckThinkBig' => 'Level Check (Think Big)',
      'levelCheckCustomerSuccess' => 'LevelCheck -  Customer Success',
      'levelCheckExperience' => 'LevelCheck - Experience',
      'levelCheckKnowledge' => 'LevelCheck - Knowledge',
      'sumselectCustomerSuccess' => 'Sumselect - Customer Success',
      'sumselectExperience' => 'Sumselect - Experience',
      'sumselectKnowledge' => 'Sumselect - Knowledge',
      'dataAnalytics' => 'Data & Analytics',
      'oracle' => 'Oracle',
      'devOps' => 'DevOps',
      'security' => 'Security',
      'networkingConsultingCompetency' => 'Networking Consulting Competency',
      'government' => 'Government',
      'education' => 'Education',
      'sAP' => 'SAP',
      'financialServices' => 'Financial Services',
      'storage' => 'Storage',
      'migration' => 'Migration',
      'machineLearningConsultingPartner' => 'Machine Learning Consulting Partner',
      'publicSafetyServicesCompetency' => 'Public Safety Services Competency',
      'cloudOperationsServicesCompetency' => 'Cloud Operations Services Competency',
      'travelAndHospitality' => 'Travel and Hospitality',
      'resilienceServicesCompetency' => 'Resilience Services Competency',
      'level1MSSP' => 'Level 1 MSSP',
      'retail' => 'Retail',
      'advertisingAndMarketingTechnologyServicesCompetency' => 'Advertising and Marketing Technology Services Competency',
      'ioTConsulting' => 'IoT Consulting',
      'microsoftWorkloads' => 'Microsoft Workloads',
      'nonprofit' => 'Nonprofit',
      'migrationAndModernizationISVPartner' => 'Migration and Modernization ISV Partner',
      'digitalWorkplace' => 'Digital Workplace',
      'smallAndMediumBusinessServicesCompetency' => 'Small and Medium Business Services Competency',
      'amazonEC2ForWindowsServer' => 'Amazon EC2 for Windows Server',
      'amazonCloudFront' => 'Amazon CloudFront',
      'amazonEKSDelivery' => 'Amazon EKS Delivery',
      'amazonRedshift' => 'Amazon Redshift',
      'amazonRDS' => 'Amazon RDS',
      'aWSWAF' => 'AWS WAF',
      'amazonAPIGateway' => 'Amazon API Gateway',
      'aWSGlueDelivery' => 'AWS Glue Delivery',
      'amazonEC2SystemsManager' => 'Amazon EC2 Systems Manager',
      'aWSControlTowerDelivery' => 'AWS Control Tower Delivery',
      'amazonEMR' => 'Amazon EMR',
      'amazonQuickSight' => 'Amazon QuickSight',
      'aWSCloudFormation' => 'AWS CloudFormation',
      'amazonConnect' => 'Amazon Connect',
      'aWSLambda' => 'AWS Lambda',
      'aWSServerMigrationService' => 'AWS Server Migration Service',
      'amazonKinesis' => 'Amazon Kinesis',
      'aWSConfig' => 'AWS Config',
      'amazonDynamoDB' => 'Amazon DynamoDB',
      'aWSDirectConnect' => 'AWS Direct Connect',
      'aWSDatabaseMigrationService' => 'AWS Database Migration Service',
      'noLevel' => 'Without level',
      'accountsdSA' => 'Tiene DSA',
      'sPMSID' => 'SPMS ID',
      'sPMSIDCountry' => 'SPMS ID Pais',
      'aWSGravitonDelivery' => 'AWS Graviton Delivery',
      'amazonECSDelivery' => 'Amazon ECS Delivery',
      'amazonMSKDelivery' => 'Amazon MSK Delivery',
      'amazonOpenSearchServiceDelivery' => 'Amazon OpenSearch Service Delivery',
      'saaS' => 'SaaS',
      'mediaEntertainmentServicesCompetency' => 'Media & Entertainment Services Competency',
      'generativeAIServicesCompetency' => 'Generative AI Services Competency',
      'consumerGoodsServicesCompetency' => 'Consumer Goods Services Competency',
      'aWSTransferFamilyDelivery' => 'AWS Transfer Family Delivery',
      'segment' => 'Segmento',
      'focus' => 'Focus'
    ],
    'links' => [
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks',
      'account' => 'Account',
      'productBrand' => 'Product Brand',
      'accountCountry' => 'account Country',
      'accounts' => 'Cuentas',
      'account1' => 'Accounts',
      'awsVersions' => 'AWS Versions',
      'opportunities' => 'Opportunities',
      'accountsAWS' => 'Cuentas AWS'
    ],
    'labels' => [
      'Create AWS' => 'Crear Partner Program - Lista'
    ],
    'options' => [
      'tier' => [
        '' => '',
        'Select' => 'Select',
        'Advanced' => 'Advanced',
        'Premier' => 'Premier',
        'Registered' => 'Registered',
        'Sin Nivel' => 'Sin Nivel'
      ],
      'competency' => [
        'Vacio' => 'Vacio',
        'Data & Analytics' => 'Data & Analytics',
        'Networking Consulting Competency' => 'Networking Consulting Competency',
        'Oracle' => 'Oracle',
        'DevOps' => 'DevOps',
        'Security' => 'Security',
        'Government' => 'Government',
        'Education' => 'Education',
        'SAP' => 'SAP',
        'Financial Services' => 'Financial Services',
        'Storage' => 'Storage',
        'Migration' => 'Migration',
        'Machine Learning Consulting Partner' => 'Machine Learning Consulting Partner',
        'Public Safety Services Competency' => 'Public Safety Services Competency',
        'Cloud Operations Services Competency' => 'Cloud Operations Services Competency',
        'Travel and Hospitality' => 'Travel and Hospitality',
        'Resilience Services Competency' => 'Resilience Services Competency',
        'Level 1 MSSP' => 'Level 1 MSSP',
        'Retail' => 'Retail',
        'Advertising and Marketing Technology Services Competency' => 'Advertising and Marketing Technology Services Competency',
        'IoT Consulting' => 'IoT Consulting',
        'Microsoft Workloads' => 'Microsoft Workloads',
        'Nonprofit' => 'Nonprofit',
        'Migration and Modernization ISV Partner' => 'Migration and Modernization ISV Partner',
        'Digital Workplace' => 'Digital Workplace',
        'Small and Medium Business Services Competency' => 'Small and Medium Business Services Competency',
        'SaaS' => 'SaaS',
        'Media & Entertainment Services Competency' => 'Media & Entertainment Services Competency',
        'Generative AI Services Competency' => 'Generative AI Services Competency',
        'Consumer Goods Services Competency' => 'Consumer Goods Services Competency',
        'AWS Database Migration Service' => 'AWS Database Migration Service'
      ],
      'partnerBusinessPlan' => [
        0 => '0',
        1 => '1'
      ],
      'levelCheck' => [
        'Ready to Select' => 'Ready to Select',
        'Ready to Advanced' => 'Ready to Advanced',
        'Ready to Premier' => 'Ready to Premier'
      ],
      'specialities' => [
        'Amazon EC2 for Windows Server' => 'Amazon EC2 for Windows Server',
        'Amazon CloudFront' => 'Amazon CloudFront',
        'Amazon EKS Delivery' => 'Amazon EKS Delivery',
        'Amazon Redshift' => 'Amazon Redshift',
        'Amazon RDS' => 'Amazon RDS',
        'AWS WAF' => 'AWS WAF',
        'Amazon API Gateway' => 'Amazon API Gateway',
        'AWS Glue Delivery' => 'AWS Glue Delivery',
        'Amazon EC2 Systems Manager' => 'Amazon EC2 Systems Manager',
        'AWS Control Tower Delivery' => 'AWS Control Tower Delivery',
        'Amazon EMR' => 'Amazon EMR',
        'Amazon QuickSight' => 'Amazon QuickSight',
        'AWS CloudFormation' => 'AWS CloudFormation',
        'Amazon Connect' => 'Amazon Connect',
        'AWS Lambda' => 'AWS Lambda',
        'AWS Server Migration Service' => 'AWS Server Migration Service',
        'Amazon Kinesis' => 'Amazon Kinesis',
        'AWS Config' => 'AWS Config',
        'Amazon DynamoDB' => 'Amazon DynamoDB',
        'AWS Direct Connect' => 'AWS Direct Connect',
        'AWS Database Migration Service' => 'AWS Database Migration Service',
        'AWS Graviton Delivery' => 'AWS Graviton Delivery',
        'AWS Transfer Family Delivery' => 'AWS Transfer Family Delivery',
        ' Amazon ECS Delivery' => ' Amazon ECS Delivery',
        'Amazon MSK Delivery' => 'Amazon MSK Delivery',
        'Amazon OpenSearch Service Delivery' => 'Amazon OpenSearch Service Delivery'
      ],
      'levelCheckCustomerSuccessThinkBig' => [
        'Think Big for Select' => 'Think Big for Select',
        'Think Big for Advanced' => 'Think Big for Advanced'
      ],
      'levelCheckExperienceThinkBig' => [
        'Think Big for Select' => 'Think Big for Select',
        'Think Big for Advanced' => 'Think Big for Advanced'
      ],
      'levelCheckKnowledgeThinkBig' => [
        'Think Big for Select' => 'Think Big for Select',
        'Think Big for Advanced' => 'Think Big for Advanced'
      ],
      'levelCheckThinkBig' => [
        'Think Big for Select' => 'Think Big for Select',
        'Think Big for Advanced' => 'Think Big for Advanced'
      ],
      'levelCheckCustomerSuccess' => [
        'Think Big for Advanced' => 'Think Big for Advanced',
        'Ready to Advanced' => 'Ready to Advanced',
        'Ready to Premier' => 'Ready to Premier',
        'Ready to Select' => 'Ready to Select'
      ],
      'levelCheckExperience' => [
        'Ready to Select' => 'Ready to Select',
        'Ready to Advanced' => 'Ready to Advanced',
        'Ready to Premium' => 'Ready to Premium'
      ],
      'levelCheckKnowledge' => [
        'Ready to Select' => 'Ready to Select',
        'Ready to Advanced' => 'Ready to Advanced',
        'Ready to Premier' => 'Ready to Premier'
      ],
      'segment' => [
        '' => '',
        'PS' => 'PS',
        'CS' => 'CS'
      ]
    ],
    'tooltips' => [
      'update' => '(PT-BR) Após selecionar esta opção, clique em "Salvar" ou "Atualizar" e atualize a sua página (F5) para que a versão apareça na aba de registro de versões.

(Español) Después de seleccionar esta opción, haga clic en "Guardar" o "Actualizar" y actualice su página (F5) para que la versión aparezca en la pestaña de registro de versiones.

(English)After selecting this option, click "Save" or "Update" and refresh your page (F5) to have the version appear in the version log tab.',
      'noLevel' => '(English) After selecting this option, click "Save" to update the level.',
      'accountsdSA' => '(PT-BR) Selecione se a conta tem DSA

(Español) Seleccione si la cuenta tiene DSA

(English) Select if the account has DSA',
      'levelCheck' => '(PT-BR) Verificação para saber se você está pronto para avançar para o próximo nível.

(Español) Verificación para saber si esta listo para avanzar de nivel.

(English) Check to see if you are ready to advance to the next level.',
      'levelCheckCustomerSuccess' => '(PT-BR) Verificação para saber se você está pronto para avançar para o próximo nível.

(Español) Verificación para saber si esta listo para avanzar de nivel.

(English) Check to see if you are ready to advance to the next level.',
      'levelCheckExperience' => '(PT-BR) Verificação para saber se você está pronto para avançar para o próximo nível.

(Español) Verificación para saber si esta listo para avanzar de nivel.

(English) Check to see if you are ready to advance to the next level.',
      'levelCheckKnowledge' => '(PT-BR) Verificação para saber se você está pronto para avançar para o próximo nível.

(Español) Verificación para saber si esta listo para avanzar de nivel.

(English) Check to see if you are ready to advance to the next level.'
    ]
  ],
  'AWSVersions' => [
    'links' => [
      'aws' => 'AWS Partner Program'
    ],
    'labels' => [
      'Create AWSVersions' => 'Create AWS Versions'
    ],
    'fields' => [
      'awsAccreditedProfessionalsBussines' => 'AWS Accredited Professionals - Business',
      'awsAccreditedProfessionalsTechnical' => 'AWS Accredited Professionals - Technical',
      'awsFoundationalCertifiedIndividuals' => 'AWS Foundational Certified individuals',
      'awsTechnicalCertifiedIndividuals' => 'AWS Technical Certified individuals',
      'awsTechnicalCertifiedIndividualsAssociate' => 'Technical Certified Individuals - Associate',
      'awsTechnicalCertifiedIndividualsProOrSpecialty' => 'Technical Certified Individuals - Pro or Specialt',
      'competency' => 'Competency',
      'countCompetency' => 'Quantity of Skills',
      'countEspecialidades' => 'Quantity of Specialties',
      'customerSatisfactionResponses' => 'Customer Satisfaction Responses',
      'lastupdate' => 'AVT Report',
      'launchedOppsAmount' => 'Launched Opps Amount',
      'launchedOppsAmountCurrency' => 'Launched Opps Amount (Currency)',
      'launchedOppsAmountConverted' => 'Launched Opps Amount (Converted)',
      'launchedOppsCount' => 'Launched Opps Count',
      'partnerBusinessPlan' => 'Partner Business Plan',
      'partnerType' => 'Partner Type',
      'publiclyReferenceableCustomers' => 'Publicly Referenceable Customers',
      'tier' => 'Tier',
      'specialities' => 'Specialties',
      'aws' => 'AWS Partner Program',
      'technicalprogram' => 'Technical Program Validations',
      'dSA' => 'DSA',
      'dataCompetencias' => 'Date Skills',
      'dataEspecialidades' => 'Date Specialties',
      'sPMSID' => 'SPMS ID'
    ],
    'options' => [
      'competency' => [
        'Data & Analytics' => 'Data & Analytics',
        'Oracle' => 'Oracle',
        'DevOps' => 'DevOps',
        'Security' => 'Security',
        'Networking Consulting Competency' => 'Networking Consulting Competency',
        'Government' => 'Government',
        'Education' => 'Education',
        'SAP' => 'SAP',
        'Financial Services' => 'Financial Services',
        'Storage' => 'Storage',
        'Migration' => 'Migration',
        'Machine Learning Consulting Partner' => 'Machine Learning Consulting Partner',
        'Public Safety Services Competency' => 'Public Safety Services Competency'
      ],
      'partnerBusinessPlan' => [
        0 => '0',
        1 => '1'
      ],
      'tier' => [
        '' => '',
        'Registered' => 'Registered',
        'Select' => 'Select',
        'Advanced' => 'Advanced',
        'Premier' => 'Premier'
      ],
      'specialities' => [
        'Amazon EC2 for Windows Server' => 'Amazon EC2 for Windows Server',
        'Amazon CloudFront' => 'Amazon CloudFront',
        'Amazon EKS Delivery' => 'Amazon EKS Delivery',
        'Amazon Redshift' => 'Amazon Redshift',
        'Amazon RDS' => 'Amazon RDS',
        'AWS WAF' => 'AWS WAF',
        'Amazon API Gateway' => 'Amazon API Gateway',
        'AWS Glue Delivery' => 'AWS Glue Delivery',
        'Amazon EC2 Systems Manager' => 'Amazon EC2 Systems Manager',
        'AWS Control Tower Delivery' => 'AWS Control Tower Delivery',
        'Amazon EMR' => 'Amazon EMR',
        'Amazon QuickSight' => 'Amazon QuickSight',
        'AWS CloudFormation' => 'AWS CloudFormation',
        'Amazon Connect' => 'Amazon Connect',
        'AWS Lambda' => 'AWS Lambda',
        'AWS Server Migration Service' => 'AWS Server Migration Service',
        'Amazon Kinesis' => 'Amazon Kinesis',
        'AWS Config' => 'AWS Config',
        'Amazon DynamoDB' => 'Amazon DynamoDB',
        'AWS Direct Connect' => 'AWS Direct Connect',
        'AWS Database Migration Service' => 'AWS Database Migration Service'
      ],
      'dSA' => [
        'Si' => 'Si'
      ]
    ]
  ],
  'AccountContent' => [
    'fields' => [
      'account' => 'Account',
      'sourceContent' => 'Source Content'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create AccountContent' => 'Create Account content'
    ],
    'options' => [
      'sourceContent' => [
        '' => '',
        'Renewals' => 'Renewals',
        'AI Content' => 'AI Content'
      ]
    ]
  ],
  'AccountVBM' => [
    'fields' => [
      'account' => 'Account',
      'contact' => 'Contact',
      'contracts' => 'Contracts',
      'iSV' => 'ISV',
      'msftProgram' => 'Microsoft Program',
      'unity' => 'Unity',
      'reseller' => 'Reseller',
      'country' => 'Country',
      'paises' => 'País'
    ],
    'links' => [
      'account' => 'Account',
      'contact' => 'Contact',
      'contracts' => 'Contracts'
    ],
    'labels' => [
      'Create AccountVBM' => 'Create Account VBM'
    ],
    'options' => [
      'iSV' => [
        '' => 'No',
        'Yes' => 'Yes'
      ],
      'msftProgram' => [
        '' => 'Not apply',
        'CSU' => 'CSU',
        'CSU y TCO' => 'CSU y TCO',
        'CSU & TCO' => 'CSU & TCO'
      ],
      'unity' => [
        '' => '',
        'Velocity' => 'Velocity',
        'Worth' => 'Worth',
        'Telco' => 'Telco'
      ]
    ]
  ],
  'Analytics' => [
    'fields' => [
      'url' => 'Url',
      'contacts' => 'Contacts',
      'name' => 'Name',
      'appId' => 'App ID',
      'clientId' => 'Client Id',
      'clientsecret' => 'Client Secret',
      'params' => 'Params',
      'ratio' => 'Aspect Ratio',
      'reportId' => 'Report Id',
      'rocket' => 'Rocket',
      'workspace' => 'Workspace',
      'iframerate' => 'Iframe Rate',
      'embedParamCheck' => 'Embed Parameters Check'
    ],
    'links' => [
      'contacts' => 'Contacts'
    ],
    'labels' => [
      'Create Analytics' => 'Create Analytics'
    ]
  ],
  'AssesmentCompany' => [
    'fields' => [
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'website' => 'Website',
      'domain' => 'Domain',
      'assesmentStep' => 'AssesmentStep',
      'language' => 'Language'
    ],
    'links' => [
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks'
    ],
    'labels' => [
      'Create AssesmentCompany' => 'Create AssesmentCompany'
    ],
    'options' => [
      'assesmentStep' => [
        '' => '',
        'organizational' => 'organizational',
        'financial' => 'financial',
        'strategy' => 'strategy',
        'technology' => 'technology',
        'salesandmarketing' => 'salesandmarketing',
        'contact' => 'contact'
      ]
    ]
  ],
  'Aws' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Aws' => 'Create AWS'
    ]
  ],
  'BucketTimer' => [
    'fields' => [
      'migrations' => 'Migração',
      'bucket' => 'Bucket',
      'duration' => 'Duração',
      'endDate' => 'Data Final',
      'startDate' => 'Data de InÍcio',
      'label' => 'Rótulo'
    ],
    'links' => [
      'migrations' => 'Migração'
    ],
    'labels' => [
      'Create BucketTimer' => 'Create Duração do Bucket'
    ],
    'options' => [
      'bucket' => [
        'Upside Pipeline' => 'Upside | Pipeline',
        'Sales | BDM' => 'Sales | BDM (Pendências)',
        'Pre - Sales' => 'Pre - Sales',
        'CSC | SSCloud' => 'CSC | SSCloud',
        'Geração Consumo' => 'Geração Consumo',
        'Consumo Estimado Concluído' => 'Consumo Estimado Concluído',
        'Cancelado' => 'Cancelado',
        'Fechado | Movimentação de Billing' => 'Fechado | Movimentação de Billing',
        'Validação Pré-vendas | CoE' => 'Validação Pré-vendas | CoE',
        'Jira | SSCLOUD' => 'Jira | SSCLOUD (Criação / Migração Organization)',
        'Acompanhamento | Consumo' => 'Acompanhamento | Consumo'
      ]
    ]
  ],
  'CAccountEndCustomer' => [
    'fields' => [
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'website' => 'Website',
      'country' => 'Country',
      'sicCode' => 'Número de identificación fiscal: (TAX ID / NIT / RUC / CNPJ)',
      'region' => 'Region',
      'contacts' => 'Contacts'
    ],
    'links' => [
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks',
      'contacts' => 'Contacts'
    ],
    'labels' => [
      'Create CAccountEndCustomer' => 'Create Account End Customer'
    ],
    'options' => [
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'Costa Rica' => 'Costa Rica',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador' => 'Ecuador',
        'El Salvador' => 'El Salvador',
        'Guadelouope' => 'Guadelouope',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Mexico' => 'Mexico',
        'Panama' => 'Panama',
        'Paraguay' => 'Paraguay',
        'Peru' => 'Peru',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'CCA' => 'CCA',
        'Caribe' => 'Caribe',
        'Santa Lucía' => 'Santa Lucía',
        'San vicente y las Granadinas' => 'San vicente y las Granadinas',
        'San Cristóbal y Nieves' => 'San Cristóbal y Nieves',
        'Jamaica' => 'Jamaica',
        'United States' => 'United States',
        'Belice' => 'Belice',
        'Haití' => 'Haití',
        'Guyana' => 'Guyana',
        'Granada' => 'Granada',
        'Cuba' => 'Cuba',
        'Barbados' => 'Barbados',
        'Bahamas' => 'Bahamas',
        'Antigua y barbuda' => 'Antigua y barbuda',
        'Nicaragua' => 'Nicaragua'
      ],
      'region' => [
        '' => '',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'Brasil' => 'Brasil',
        'Mexico' => 'Mexico',
        'CCA' => 'CCA',
        'None LAC' => 'None LAC'
      ]
    ]
  ],
  'CDPSecurity' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create CDPSecurity' => 'Create CDP Security'
    ]
  ],
  'CPB' => [
    'fields' => [
      'account' => 'Account',
      'suresteps' => 'Suresteps',
      'productBrands' => 'Product Brand',
      'accounts' => 'Accounts',
      'categoriaCPB' => 'CPB Category',
      'statusCPB' => 'CPB status',
      'dSETAWS' => 'DSET AWS',
      'vendor' => 'Vendor',
      'country' => 'Country',
      'region' => 'Region',
      'contacts' => 'Contacts',
      'accountsCPB' => 'Accounts CPB',
      'contact' => 'Contact',
      'submissionID' => 'Submission ID',
      'language' => 'Language',
      'oportunidad' => 'Opportunities'
    ],
    'links' => [
      'account' => 'Account',
      'suresteps' => 'Suresteps',
      'productBrands' => 'Brands',
      'accounts' => 'Accounts',
      'contacts' => 'Contacts',
      'accountsCPB' => 'Accounts CPB',
      'contact' => 'Contact',
      'oportunidad' => 'Opportunities'
    ],
    'labels' => [
      'Create CPB' => 'Crear Cloud Practice Builder - Lista'
    ],
    'options' => [
      'categoriaCPB' => [
        'Accelerator' => 'Accelerator',
        'Starter' => 'Starter',
        'Transformer' => 'Transformer',
        '' => '',
        '	Sem Categoria' => 'N/A'
      ],
      'statusCPB' => [
        'Concluido' => 'Concluded',
        'No Concluido ' => 'Not Concluded'
      ],
      'dSETAWS' => [
        'Concluido ' => 'Concluded',
        'No Concluido ' => 'Not Concluded'
      ],
      'vendor' => [
        '' => '',
        'AWS' => 'AWS',
        'Google' => 'Google',
        'Microsoft' => 'Microsoft'
      ],
      'country' => [
        'Argentina ' => 'Argentina ',
        'Colombia ' => 'Colombia ',
        '' => '',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'Chile' => 'Chile',
        'Costa Rica ' => 'Costa Rica ',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador' => 'Ecuador',
        'Guadeloupe' => 'Guadeloupe',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'El Salvador' => 'El Salvador',
        'Mexico' => 'Mexico',
        'Panama ' => 'Panama ',
        'Paraguay ' => 'Paraguay ',
        'Peru' => 'Peru',
        'Puerto Rico ' => 'Puerto Rico ',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'Colombia' => 'Colombia',
        'Caribe' => 'Caribe'
      ],
      'region' => [
        '' => '',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'CCA' => 'CCA',
        'Brasil' => 'Brasil',
        'Mexico' => 'Mexico'
      ],
      'language' => [
        'Português' => 'pt',
        'English' => 'en',
        'Español' => 'es',
        '' => '',
        'pt' => 'Português',
        'en' => 'English',
        'es' => 'Español'
      ]
    ]
  ],
  'CPBIoTAnalytic' => [
    'fields' => [
      'revenueIoTDigitisation' => '1. What percentage of your revenue accounts for IoT / Digitisation?',
      'revenueanalytics' => '2. What percentage of your revenue accounts for analytics?',
      'practiceforIoTData' => '3. How would you describe the position of your practice for IoT/Data?',
      'technologystack' => '4. In a typical IoT/analytics customer discussion or solution delivery, which vendors would be included in the technology stack?',
      'organisationdelivered' => '5. In a typical IoT/analytics solution delivery, which technologies and/or services has your organisation delivered?',
      'relationtoIoTdigitization' => '6. Which of the following are in progress or completed at your organisation in relation to IoT/digitization adoption activities?',
      'supportdevelopcapability' => '7. Please indicate which data solution components, your organisation needs support develop capability for. (select all that apply)',
      'businessmostbenefit' => '8. Where would your business most benefit from support to enable your IoT/Data strategy? (select all that apply)',
      'investinAnalytics' => '9. To meet your strategy, in what timeframe are you currently expecting to invest in Analytics?',
      'drivesyoursales' => '10. What drives your sales strategy for IoT/Digitisation?',
      'partoftheirecosystem' => '11. Are you engaging with any organisations who specialise in IoT with the aim of becoming part of their eco-system?',
      'solutionsinIoTDigitisation' => '12. Within your organisation is what is the sales pipeline stage for the majority of solutions in IoT/Digitisation?',
      'sizeforIoTdigitisation' => '13. What is your average deal size for IoT/digitisation?',
      'solutiondeliveryforIoT' => '14. In what areas have you established case studies that evidence your organisation\'s solution delivery for IoT?',
      'consultancyservicesforAnalytics' => '15. How do you deliver your professional consultancy services for Analytics & IoT/ Digitisation Solutions?',
      'designservicesforIoTDigitisation' => '16. How would you rate your design services for IoT/Digitisation?',
      'servicesforAnalytics' => '17. How would you rate your design services for Analytics?',
      'proofofconceptservicesforIoTDigitisation' => '18. How would you rate your proof of concept services for IoT/Digitisation?',
      'conceptservicesforAnalytics' => '19. How would you rate your proof of concept services for Analytics?',
      'implementationservicesforIoTDigitisation' => '20. How would you rate your implementation services for IoT/Digitisation?',
      'implementationservicesforAnalytics' => '21. How would you rate your implementation services for Analytics?',
      'solutionbyyourselfforIoT' => '22. In a typical solution delivery are you able to deliver the entire solution by yourself for IoT?',
      'resourceorganisationforIoTdata' => '23. Please indicate what resource you currently have in your organisation for IoT/data.',
      'analyticsadoptionactivities' => '24. Which of the following are in progress or completed at your organisation in relation to analytics adoption activities?',
      'dataintegrationqualitygovernancemarket' => '25. How would describe your organisation\'s awareness and knowledge of the data integration/quality/governance market?',
      'customersengagementIoTdigitisation' => '26. How would you describe your customers\' engagement with IoT/digitisation?',
      'account' => 'Account'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTAnalytic' => 'Create CPB IoT Analytic'
    ],
    'options' => [
      'revenueIoTDigitisation' => [
        '' => '',
        '>50%' => '>50%',
        '26% to 50%' => '26% to 50%',
        '11% to 25%' => '11% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%',
        'Prefer not to disclose' => 'Prefer not to disclose'
      ],
      'revenueanalytics' => [
        '' => '',
        '>50%' => '>50%',
        '26% to 50%' => '26% to 50%',
        '11% to 25%' => '11% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%',
        'Prefer not to disclose' => 'Prefer not to disclose'
      ],
      'practiceforIoTData' => [
        '' => '',
        'At inception' => 'At inception',
        'Developing strategy' => 'Developing strategy',
        'Investment budgeted' => 'Investment budgeted',
        'Developing' => 'Developing',
        'Optimising' => 'Optimising',
        'Mature' => 'Mature',
        'Not planning to have one' => 'Not planning to have one'
      ],
      'technologystack' => [
        '' => '',
        'Advantech' => 'Advantech',
        'Panduit' => 'Panduit',
        'Keonn' => 'Keonn',
        'Relayr' => 'Relayr',
        'Episensor' => 'Episensor',
        'Nexiona' => 'Nexiona',
        'IFM' => 'IFM',
        'Worldsensing' => 'Worldsensing',
        'Actility' => 'Actility',
        'Schneider Electric' => 'Schneider Electric',
        'Siemens' => 'Siemens',
        'Sigfox' => 'Sigfox',
        'Vodafone' => 'Vodafone',
        'Dell' => 'Dell',
        'Microsoft' => 'Microsoft',
        'IBM' => 'IBM',
        'HPE' => 'HPE',
        'Cisco' => 'Cisco',
        'AWS' => 'AWS',
        'Oracle' => 'Oracle',
        'Other' => 'Other'
      ],
      'organisationdelivered' => [
        '' => '',
        'Device connectivity' => 'Device connectivity',
        'Data forwarding' => 'Data forwarding',
        'Real-time monitoring' => 'Real-time monitoring',
        'GPS' => 'GPS',
        'Security' => 'Security',
        'Communication gateways' => 'Communication gateways',
        'Cloud management' => 'Cloud management',
        'Data design' => 'Data design',
        'Data analytics' => 'Data analytics',
        'Automation' => 'Automation',
        'Machine learning' => 'Machine learning',
        'Business intelligence' => 'Business intelligence',
        'Design' => 'Design',
        'Proof of concepts' => 'Proof of concepts',
        'Hosting' => 'Hosting',
        'Consultancy' => 'Consultancy',
        'Service management' => 'Service management',
        'Support' => 'Support'
      ],
      'relationtoIoTdigitization' => [
        '' => '',
        'Exploring' => 'Exploring',
        'Early stage set-up' => 'Early stage set-up',
        'Building resource' => 'Building resource',
        'Training & skills development' => 'Training & skills development',
        'Leveraging internally' => 'Leveraging internally',
        'Defining value proposition' => 'Defining value proposition',
        'Developing sales strategy' => 'Developing sales strategy',
        'Going to market' => 'Going to market',
        'Delivering solutions' => 'Delivering solutions',
        'Reviewing & refining' => 'Reviewing & refining'
      ],
      'supportdevelopcapability' => [
        '' => '',
        'IoT sensors' => 'IoT sensors',
        'Edge compute' => 'Edge compute',
        'Connectivity' => 'Connectivity',
        'IoT Platforms' => 'IoT Platforms',
        'Data Integration' => 'Data Integration',
        'Data Repository' => 'Data Repository',
        'Data Quality' => 'Data Quality',
        'Data Governance' => 'Data Governance',
        'Business Intelligence Reporting/Visualisation' => 'Business Intelligence Reporting/Visualisation',
        'Business Logic/Workflow' => 'Business Logic/Workflow',
        'AI/Cognitive/ML' => 'AI/Cognitive/ML',
        'Data Security' => 'Data Security'
      ],
      'businessmostbenefit' => [
        '' => '',
        'Sales & marketing' => 'Sales & marketing',
        'Expert to join visits' => 'Expert to join visits',
        'Lead generation' => 'Lead generation',
        'Lead qualification' => 'Lead qualification',
        'Recruitment' => 'Recruitment',
        'Training' => 'Training',
        'Finance & billing' => 'Finance & billing',
        'Solution design' => 'Solution design',
        'Solution implementation' => 'Solution implementation'
      ],
      'investinAnalytics' => [
        '' => '',
        'Underway' => 'Underway',
        '1-3 months' => '1-3 months',
        '4-6 months' => '4-6 months',
        '7-9 months' => '7-9 months',
        '10-12 months' => '10-12 months',
        '>12 months' => '>12 months',
        'None' => 'None'
      ],
      'drivesyoursales' => [
        '' => '',
        'New revenue streams through diversification' => 'New revenue streams through diversification',
        'New sales growth' => 'New sales growth',
        'Replace legacy business' => 'Replace legacy business'
      ],
      'partoftheirecosystem' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'solutionsinIoTDigitisation' => [
        '' => '',
        'Tentative discussions' => 'Tentative discussions',
        'Pre-sales or earlier' => 'Pre-sales or earlier',
        'At qualification or earlier' => 'At qualification or earlier',
        'At solution design or earlier' => 'At solution design or earlier',
        'At evaluation or earlier' => 'At evaluation or earlier',
        'At negotiation or earlier' => 'At negotiation or earlier',
        'At final stage or earlier' => 'At final stage or earlier',
        'No pipeline in place' => 'No pipeline in place'
      ],
      'sizeforIoTdigitisation' => [
        '' => '',
        '£0' => '£0',
        '<£10k' => '<£10k',
        '£10k-£50k' => '£10k-£50k',
        '£51k-100k' => '£51k-100k',
        '£101k-£200k' => '£101k-£200k',
        '£201k-£300k' => '£201k-£300k',
        '>£300k' => '>£300k'
      ],
      'solutiondeliveryforIoT' => [
        '' => '',
        'POC' => 'POC',
        'Pilots' => 'Pilots',
        'End-to-end' => 'End-to-end',
        'Design' => 'Design',
        'Implementation' => 'Implementation',
        'Meeting business outcomes' => 'Meeting business outcomes',
        'Others' => 'Others',
        'None' => 'None'
      ],
      'consultancyservicesforAnalytics' => [
        '' => '',
        'Outsourced' => 'Outsourced',
        'Vendor support' => 'Vendor support',
        'Through partnerships' => 'Through partnerships',
        'With associates/contractors' => 'With associates/contractors',
        'Business unit' => 'Business unit',
        'Department in house' => 'Department in house',
        'Not providing' => 'Not providing'
      ],
      'designservicesforIoTDigitisation' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'servicesforAnalytics' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'proofofconceptservicesforIoTDigitisation' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'conceptservicesforAnalytics' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'implementationservicesforIoTDigitisation' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'implementationservicesforAnalytics' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'solutionbyyourselfforIoT' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'Yes through partnerships' => 'Yes through partnerships'
      ],
      'resourceorganisationforIoTdata' => [
        '' => '',
        'Solutions Architecture' => 'Solutions Architecture',
        'Sales & marketing' => 'Sales & marketing',
        'Finance & billing' => 'Finance & billing',
        'Installation' => 'Installation',
        'Implementation' => 'Implementation',
        'Configuration' => 'Configuration',
        'Technical support' => 'Technical support'
      ],
      'analyticsadoptionactivities' => [
        '' => '',
        'Exploring' => 'Exploring',
        'Early stage set-up' => 'Early stage set-up',
        'Building resource' => 'Building resource',
        'Training & skills development' => 'Training & skills development',
        'Leveraging internally' => 'Leveraging internally',
        'Defining value proposition' => 'Defining value proposition',
        'Developing sales strategy' => 'Developing sales strategy',
        'Going to market' => 'Going to market',
        'Delivering solutions' => 'Delivering solutions',
        'Reviewing & refining' => 'Reviewing & refining'
      ],
      'dataintegrationqualitygovernancemarket' => [
        '' => '',
        'Not started' => 'Not started',
        'Early stages' => 'Early stages',
        'Developing' => 'Developing',
        'Expert' => 'Expert',
        'Not part of our strategy' => 'Not part of our strategy'
      ],
      'customersengagementIoTdigitisation' => [
        '' => '',
        'Early adopter' => 'Early adopter',
        'Exploring' => 'Exploring',
        'Actively engaged' => 'Actively engaged',
        'Disengaging' => 'Disengaging',
        'Not engaged' => 'Not engaged'
      ]
    ]
  ],
  'CPBIoTFinancial' => [
    'fields' => [
      'businessDescription' => '1. How would your customers describe your business?',
      'keyAreas' => '2. What are the key areas that make up your solution offerings? (select all that apply)',
      'threeYearStrategy' => '3. Does your organisation have a 3 year strategy and defined goals?',
      'businessLength' => '4. How long have you been in business?',
      'numberOfEmployees' => '5. How many employees do you have?',
      'firstStatement' => '6. To what extent do you agree with the following statement: "All senior leaders and executives are aligned with a 3 year strategy and goals."',
      'secondStatement' => '7. To what extent do you agree with the following statement: "We have already presented our vision to our employees and have their buy-in."',
      'businessPlanRate' => '8. How would you rate your organisation\'s ability to execute on a business plan or transition plan?',
      'organisationGaps' => '10. What are your organisation\'s biggest gaps/challenges to building the solutions practice you would like to build? (select all that apply)',
      'preSalesRate' => '9. How would you rate your organisation\'s pre-sales function and relevant technical expertise to support your transition?',
      'organisationRevenue' => '11. What was your organisation\'s total revenue for your last Fiscal Year?',
      'organisationGrowth' => '12. What was your organisation\'s Year Over Year revenue growth for your last Fiscal year?',
      'grossProfit' => '13. How does your current gross profit figure compare to the past 3 years?',
      'organisationFinancialPerformance' => '14. Considering the last 3 Fiscal Years, which areas have contributed most to your organisation\'s financial performance? (select all that apply)',
      'hardwareRevenuePercentage' => '15. In the last financial year, what percentage of your organisation\'s overall sales revenue came from Hardware?',
      'softwareRevenuePercentage' => '16. In the last financial year, what percentage of your organisation\'s overall sales revenue came from Software?',
      'servicesRevenuePercentage' => '17. In the last financial year, what percentage of your organisation\'s overall sales revenue came from Professional Services?',
      'recurringRevenueStreamsPercentage' => '18. What percentage of your revenue was from recurring revenue streams in the last financial year?',
      'mostProfitableArea' => '19. Considering your entire business, what area was most profitable in the last financial year?',
      'averageProductGrossMargin' => '20. What is the average product gross margin retained by your organisation, excluding rebates and other incentives, from the resale of hardware/software?',
      'organisationCombinedGrossMargin' => '21. What is your organisation\'s combined gross margin, including services?',
      'servicesMarginOverview' => '22. Looking at your current Fiscal Year, how would you describe your Services margin compared to previous years?',
      'organisationEBIT' => '23. What was your organisation\'s Operating Profit (EBIT) during the last Fiscal Year?',
      'account' => 'Account'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTFinancial' => 'Create CPB IoT Financial'
    ],
    'options' => [
      'businessDescription' => [
        '' => '',
        'Solution Provider' => 'Solution Provider',
        'Managed Service Provider' => 'Managed Service Provider',
        'Independent Software Vendor' => 'Independent Software Vendor',
        'Systems Integrator' => 'Systems Integrator',
        'Hybrid Cloud Enabler/Provider' => 'Hybrid Cloud Enabler/Provider',
        'Reseller/VAR' => 'Reseller/VAR',
        'IT Supplier' => 'IT Supplier',
        'Direct Market Reseller' => 'Direct Market Reseller'
      ],
      'keyAreas' => [
        '' => '',
        'Cloud/Hybrid Cloud' => 'Cloud/Hybrid Cloud',
        'Data Analytics' => 'Data Analytics',
        'IoT' => 'IoT',
        'Security' => 'Security',
        'Hardware / Infrastructure' => 'Hardware / Infrastructure',
        'Back up & Data Recovery' => 'Back up & Data Recovery',
        'Managed Services' => 'Managed Services',
        'Professional Services' => 'Professional Services'
      ],
      'threeYearStrategy' => [
        '' => '',
        'Yes' => 'Yes',
        'Being Developed' => 'Being Developed',
        'No' => 'No'
      ],
      'businessLength' => [
        '' => '',
        'Less than 1 year' => 'Less than 1 year',
        '1 - 2 years' => '1 - 2 years',
        '3 - 5 years' => '3 - 5 years',
        '6 - 10 years' => '6 - 10 years',
        'Over 10 years' => 'Over 10 years'
      ],
      'numberOfEmployees' => [
        '' => '',
        'Less than 5 employees' => 'Less than 5 employees',
        '5 - 9 employees' => '5 - 9 employees',
        '10 - 49 employees' => '10 - 49 employees',
        '50+ employees' => '50+ employees'
      ],
      'firstStatement' => [
        '' => '',
        'Strongly Agree' => 'Strongly Agree',
        'Agree' => 'Agree',
        'Undecided' => 'Undecided',
        'Disagree' => 'Disagree',
        'Strongly Disagree' => 'Strongly Disagree'
      ],
      'secondStatement' => [
        '' => '',
        'Strongly Agree' => 'Strongly Agree',
        'Agree' => 'Agree',
        'Undecided' => 'Undecided',
        'Disagree' => 'Disagree',
        'Strongly Disagree' => 'Strongly Disagree'
      ],
      'businessPlanRate' => [
        '' => '',
        'Excellent' => 'Excellent',
        'Good' => 'Good',
        'Acceptable' => 'Acceptable',
        'Poor' => 'Poor',
        'Very Poor' => 'Very Poor'
      ],
      'organisationGaps' => [
        'Capabilities' => 'Capabilities',
        'Skills' => 'Skills',
        'Training' => 'Training',
        'Domain expertise' => 'Domain expertise',
        'Lead Generation' => 'Lead Generation',
        'Sales' => 'Sales',
        'Other' => 'Other'
      ],
      'preSalesRate' => [
        '' => '',
        'Excellent' => 'Excellent',
        'Good' => 'Good',
        'Acceptable' => 'Acceptable',
        'Poor' => 'Poor',
        'Very Poor' => 'Very Poor'
      ],
      'organisationRevenue' => [
        '' => '',
        '$10 million +' => '$10 million +',
        '$5 million +' => '$5 million +',
        '$1 million +' => '$1 million +',
        '< $1 million' => '< $1 million'
      ],
      'organisationGrowth' => [
        '' => '',
        'More than 10%' => 'More than 10%',
        '5% to 10%' => '5% to 10%',
        '0% to 5%' => '0% to 5%',
        'Flat' => 'Flat',
        'Decreasing' => 'Decreasing'
      ],
      'grossProfit' => [
        '' => '',
        'Increasing' => 'Increasing',
        'Flat' => 'Flat',
        'Decreasing' => 'Decreasing'
      ],
      'organisationFinancialPerformance' => [
        'Cloud/Hybrid' => 'Cloud/Hybrid',
        'Services' => 'Services',
        'IoT, Big Data, Mobility, Social Business' => 'IoT, Big Data, Mobility, Social Business',
        'Company Acquisition/Merger' => 'Company Acquisition/Merger',
        'Software' => 'Software',
        'Hardware' => 'Hardware',
        'Other' => 'Other'
      ],
      'hardwareRevenuePercentage' => [
        '' => '',
        'More than 50%' => 'More than 50%',
        '25% to 50%' => '25% to 50%',
        '10% to 25%' => '10% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'softwareRevenuePercentage' => [
        '' => '',
        'More than 50%' => 'More than 50%',
        '25% to 50%' => '25% to 50%',
        '10% to 25%' => '10% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'servicesRevenuePercentage' => [
        '' => '',
        'More than 50%' => 'More than 50%',
        '25% to 50%' => '25% to 50%',
        '10% to 25%' => '10% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'recurringRevenueStreamsPercentage' => [
        '' => '',
        'More than 60%' => 'More than 60%',
        '40% to 60%' => '40% to 60%',
        '20% to 40%' => '20% to 40%',
        '10% to 20%' => '10% to 20%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'mostProfitableArea' => [
        '' => '',
        'Hardware' => 'Hardware',
        'Software' => 'Software',
        'Services' => 'Services',
        'IoT, Big Data, Mobility, Social Business' => 'IoT, Big Data, Mobility, Social Business',
        'Cloud/Consumption' => 'Cloud/Consumption',
        'None of the above' => 'None of the above'
      ],
      'averageProductGrossMargin' => [
        '' => '',
        '25%+' => '25%+',
        '15% to 25%' => '15% to 25%',
        '10% to 15%' => '10% to 15%',
        '5% to 10%' => '5% to 10%',
        'Less than 5%' => 'Less than 5%'
      ],
      'organisationCombinedGrossMargin' => [
        '' => '',
        '25%+' => '25%+',
        '15% to 25%' => '15% to 25%',
        '10% to 15%' => '10% to 15%',
        '5% to 10%' => '5% to 10%',
        'Less than 5%' => 'Less than 5%'
      ],
      'servicesMarginOverview' => [
        '' => '',
        'Increasing' => 'Increasing',
        'Flat' => 'Flat',
        'Decreasing' => 'Decreasing'
      ],
      'organisationEBIT' => [
        '' => '',
        'More than 10%' => 'More than 10%',
        '5% to 10%' => '5% to 10%',
        '0% to 5%' => '0% to 5%',
        'Flat' => 'Flat',
        'Decreasing' => 'Decreasing'
      ]
    ]
  ],
  'CPBIoTMarketing' => [
    'fields' => [
      'linesofBusiness' => '1. Can your sales team effectively sell to Lines of Business within your end user customers?',
      'salesreps' => '2. How many sales reps do you have?',
      'salesrepscarryServices' => '3. Do your sales reps carry Services quotas or accelerators?',
      'describeyouorganisation' => '4. How would you describe you organisation\'s ability to successfully implement a marketing strategy?',
      'areaofyourbusiness' => '5. What is an area of your business in which you could use marketing support? (please select all that apply)',
      'solutionsthatyoursales' => '6. Select all solutions that your sales team typically propose to your customers. (select all that apply)',
      'salesgeneratedHardware' => '7. Considering all of your sales generated in the past 12 months, what percentage was led by Hardware?',
      'salesgeneratedSoftware' => '8. Considering all of your sales generated in the past 12 months, what percentage was led by Software?',
      'salesgeneratedServices' => '9. Considering all of your sales generated in the past 12 months, what percentage was led by Services?',
      'salesteamleadgeneration' => '10. How would you rate your sales team\'s lead generation engine?',
      'businessoutcomes' => '11. Do you have a detailed sales approach that shows how your offerings achieve customers\' desired business outcomes?',
      'monthlyRecurringRevenue' => '13. Does your organisation have an employee compensation plan that supports Monthly Recurring Revenue (MRR)?',
      'newbusinesstargets' => '14. Do you have new business targets that include new technologies and/or customers?',
      'horizontalsegments' => '15. What horizontal segments do you sell into?',
      'typicalsalesengagement' => '16. In a typical sales engagement, which departments do you currently involve in the decision making process?',
      'verticalssell' => '17. What verticals do you sell into?',
      'deployyoursolutions' => '18. In regards to the environment on which your end users deploy your solutions - which is the most relevant?',
      'account' => 'Account',
      'servicesversusproductsales' => '12. Does your organisation have an employee compensation plan for services versus product sales?'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTMarketing' => 'Create CPB IoT Marketing'
    ],
    'options' => [
      'linesofBusiness' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'Not Sure' => 'Not Sure'
      ],
      'salesreps' => [
        '' => '',
        'Less than 3 reps' => 'Less than 3 reps',
        '3 - 5 reps' => '3 - 5 reps',
        '6 - 10 reps' => '6 - 10 reps',
        '11 - 49 reps' => '11 - 49 reps',
        'More than 50 reps' => 'More than 50 reps'
      ],
      'salesrepscarryServices' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No'
      ],
      'describeyouorganisation' => [
        '' => '',
        'Excellent' => 'Excellent',
        'Good' => 'Good',
        'Needs Improvement' => 'Needs Improvement',
        'Poor' => 'Poor',
        'Not Sure' => 'Not Sure'
      ],
      'areaofyourbusiness' => [
        '' => '',
        'Digital/Online Presence' => 'Digital/Online Presence',
        'Content Creation' => 'Content Creation',
        'Value Proposition Creation' => 'Value Proposition Creation',
        'Lead Generation' => 'Lead Generation',
        'Marketing Plan Creation' => 'Marketing Plan Creation',
        'Outsource Marketing' => 'Outsource Marketing',
        'Not Sure' => 'Not Sure',
        'We\'ve Mastered Our Marketing Engine' => 'We\'ve Mastered Our Marketing Engine'
      ],
      'solutionsthatyoursales' => [
        '' => '',
        'IoT' => 'IoT',
        'Managed Services' => 'Managed Services',
        'Public Cloud' => 'Public Cloud',
        'Private / Hybrid Cloud' => 'Private / Hybrid Cloud',
        'Software' => 'Software',
        'Hardware / Infrastructure' => 'Hardware / Infrastructure',
        'Back up & Data Recovery' => 'Back up & Data Recovery',
        'Maintenance Services' => 'Maintenance Services',
        'Professional Services' => 'Professional Services',
        'Other' => 'Other'
      ],
      'salesgeneratedHardware' => [
        '' => '',
        '50% or above' => '50% or above',
        '40% - 49%' => '40% - 49%',
        '20% - 39%' => '20% - 39%',
        '10% - 19%' => '10% - 19%',
        'Less than 10%' => 'Less than 10%'
      ],
      'salesgeneratedSoftware' => [
        '' => '',
        '50% or above' => '50% or above',
        '40% - 49%' => '40% - 49%',
        '20% - 39%' => '20% - 39%',
        '10% - 19%' => '10% - 19%',
        'Less than 10%' => 'Less than 10%'
      ],
      'salesgeneratedServices' => [
        '' => '',
        '50% or above' => '50% or above',
        '40% - 49%' => '40% - 49%',
        '20% - 39%' => '20% - 39%',
        '10% - 19%' => '10% - 19%',
        'Less than 10%' => 'Less than 10%'
      ],
      'salesteamleadgeneration' => [
        '' => '',
        'Excellent' => 'Excellent',
        'Good' => 'Good',
        'Acceptable' => 'Acceptable',
        'Poor' => 'Poor',
        'Very Poor' => 'Very Poor'
      ],
      'businessoutcomes' => [
        '' => '',
        'Yes' => 'Yes',
        'In progress' => 'In progress',
        'No' => 'No'
      ],
      'monthlyRecurringRevenue' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No'
      ],
      'newbusinesstargets' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'horizontalsegments' => [
        '' => '',
        'Large (500+ employed)' => 'Large (500+ employed)',
        'Mid (100 to 499 employed)' => 'Mid (100 to 499 employed)',
        'Small (1 to 99 employed)' => 'Small (1 to 99 employed)'
      ],
      'typicalsalesengagement' => [
        '' => '',
        'IT' => 'IT',
        'Digital/Innovation' => 'Digital/Innovation',
        'Finance' => 'Finance',
        'Operations' => 'Operations',
        'Procurement' => 'Procurement',
        'HR' => 'HR',
        'Sales & Marketing' => 'Sales & Marketing',
        'Customer Service' => 'Customer Service',
        'Other' => 'Other'
      ],
      'verticalssell' => [
        '' => '',
        'Manufacturing' => 'Manufacturing',
        'Legal' => 'Legal',
        'Retail' => 'Retail',
        'Healthcare' => 'Healthcare',
        'Finance' => 'Finance',
        'Banking' => 'Banking',
        'Education' => 'Education',
        'Government' => 'Government',
        'Smart Space' => 'Smart Space',
        'Logistics' => 'Logistics',
        'Transport' => 'Transport',
        'Energy' => 'Energy',
        'Utilities' => 'Utilities',
        'Pharmaceutical' => 'Pharmaceutical',
        'Other' => 'Other'
      ],
      'deployyoursolutions' => [
        '' => '',
        'On premise' => 'On premise',
        'Hybrid' => 'Hybrid',
        'Single Tenant Platform' => 'Single Tenant Platform',
        'Multi Tenant Platform' => 'Multi Tenant Platform'
      ],
      'servicesversusproductsales' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No'
      ]
    ]
  ],
  'CPBIoTStrategy' => [
    'fields' => [
      'account' => 'Account',
      'analystConsulting' => '1. Do you regularly consult with analysts (in-house or externally) in order to realise your organisation\'s goals and transition business models?',
      'organisationBenchmark' => '2. Does your organisation benchmark itself against other partners in your field?',
      'cashFlowManagePlan' => '3. If change is involved in your business goals, do you have a plan to manage your cash flow?',
      'organisationInvestingAreas' => '4. Select the areas in which you see your organisation investing over the next 3 years. (select all that apply)',
      'asAServiceSolutions' => '5. Do you provide any Software/Infrastucture as a Service offerings, or do you have any solutions that will move to SaaS/IaaS based in the future?',
      'ownSolutionEngagement' => '6. Are you engaging with any vendors, partners or solution providers to build out your own solution stack?',
      'highestGrowthAreas' => '7. Which areas do you see as the highest growth potential in the next 12 months?',
      'dataLifecycle' => '8. Where in the data lifecycle are your focus points?'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTStrategy' => 'Create CPB IoT Strategy'
    ],
    'options' => [
      'analystConsulting' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'organisationBenchmark' => [
        '' => '',
        'Frequently' => 'Frequently',
        'Occasionally' => 'Occasionally',
        'Unsure how' => 'Unsure how',
        'Not interested' => 'Not interested'
      ],
      'cashFlowManagePlan' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'organisationInvestingAreas' => [
        '' => '',
        'Data center' => 'Data center',
        'Employees' => 'Employees',
        'Service offerings' => 'Service offerings',
        'Technology development' => 'Technology development',
        'Systems' => 'Systems',
        'Other' => 'Other',
        'No funds to invest' => 'No funds to invest'
      ],
      'asAServiceSolutions' => [
        '' => '',
        'Yes, we currently offer SaaS/IaaS' => 'Yes, we currently offer SaaS/IaaS',
        'Solutions identified for move to SaaS/IaaS' => 'Solutions identified for move to SaaS/IaaS',
        'No, we do not intend to offer SaaS solutions' => 'No, we do not intend to offer SaaS solutions'
      ],
      'ownSolutionEngagement' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'highestGrowthAreas' => [
        '' => '',
        'IoT' => 'IoT',
        'Analytics' => 'Analytics',
        'Managed Workspace' => 'Managed Workspace',
        'Cyber Security' => 'Cyber Security',
        'Social Platforms' => 'Social Platforms',
        'Big Data' => 'Big Data',
        'Mobile' => 'Mobile',
        'Cloud/Hybrid' => 'Cloud/Hybrid',
        'Physical Infrastructure' => 'Physical Infrastructure',
        'Automation & Orchestration ' => 'Automation & Orchestration ',
        'Business Intelligence' => 'Business Intelligence',
        'Consumption-as-a-Service' => 'Consumption-as-a-Service',
        'Other' => 'Other'
      ],
      'dataLifecycle' => [
        '' => '',
        'Generate' => 'Generate',
        'Collect' => 'Collect',
        'Analyse' => 'Analyse',
        'React' => 'React',
        'Predict' => 'Predict'
      ]
    ]
  ],
  'CPBIoTTechnology' => [
    'fields' => [
      'salesrevenue' => '1. In the last financial year, what percentage of your organisation\'s overall sales revenue came from Managed Services?',
      'managedservicessolution' => '2. Have you hired specialised managed services/solution sales expertise or retrained product focused sales people to sell services and solutions?',
      'documentedstrategy' => '3. Do you have a well defined and documented strategy for your managed services?',
      'managedServicesprocesses' => '4. How would you rate your Managed Services processes, systems, tools and SLA\'s?',
      'transformAndhost' => '5. For your managed services do you offer a standard catalogue that includes monitor, operate, optimise, transform and host, or equivalent?',
      'deliverypractice' => '6. Do you have a scalable and repeatable delivery practice for your managed services?',
      'consumptionbased' => '7. Do you have a consumption-based billing capability, either internally or externally?',
      'hardwaresaleschanging' => '8. How do you see the percentage of your hardware sales changing in the next 12 - 24 months?',
      'softwaresaleschanging' => '9. How do you see the percentage of your software sales changing in the next 12 - 24 months?',
      'servicessaleschanging' => '10. How do you see the percentage of your services sales changing in the next 12 - 24 months?',
      'account' => 'Account'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTTechnology' => 'Create CPB IoT Technology'
    ],
    'options' => [
      'salesrevenue' => [
        '' => '',
        'More than 50%' => 'More than 50%',
        '25% to 50%' => '25% to 50%',
        '10% to 25%' => '10% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'managedservicessolution' => [
        '' => '',
        'Yes' => 'Yes',
        'Training in progress' => 'Training in progress',
        'Recruitment in progress' => 'Recruitment in progress',
        'No' => 'No'
      ],
      'documentedstrategy' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'We do not have Managed Services' => 'We do not have Managed Services'
      ],
      'managedServicesprocesses' => [
        '' => '',
        'Good' => 'Good',
        'Acceptable' => 'Acceptable',
        'Poor' => 'Poor',
        'Managed Services being developed' => 'Managed Services being developed',
        'We don\'t provide Managed Services' => 'We don\'t provide Managed Services'
      ],
      'transformAndhost' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'We do not have Managed Services' => 'We do not have Managed Services'
      ],
      'deliverypractice' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'We do not have Managed Services' => 'We do not have Managed Services'
      ],
      'consumptionbased' => [
        '' => '',
        'Yes' => 'Yes',
        'In Progress' => 'In Progress',
        'No' => 'No'
      ],
      'hardwaresaleschanging' => [
        '' => '',
        'Increasing' => 'Increasing',
        'No change' => 'No change',
        'Decreasing' => 'Decreasing'
      ],
      'softwaresaleschanging' => [
        '' => '',
        'Increasing' => 'Increasing',
        'No change' => 'No change',
        'Decreasing' => 'Decreasing'
      ],
      'servicessaleschanging' => [
        '' => '',
        'Increasing' => 'Increasing',
        'No change' => 'No change',
        'Decreasing' => 'Decreasing'
      ]
    ]
  ],
  'CalendrioseEventos' => [
    'fields' => [
      'status' => 'Status',
      'dataHora' => 'Data/Hora do Evento',
      'publicoAlvo' => 'Público Alvo'
    ],
    'links' => [],
    'labels' => [
      'Create CalendrioseEventos' => 'Create Calendários e Eventos'
    ],
    'options' => [
      'status' => [
        'Planejado' => 'Planejado',
        'Confirmado' => 'Confirmado',
        'Realizado' => 'Realizado'
      ],
      'publicoAlvo' => [
        'TD Synnex' => 'TD Synnex',
        'Revenda' => 'Revenda',
        'CF' => 'CF',
        'ISVs' => 'ISVs',
        'ISP' => 'ISP'
      ]
    ]
  ],
  'CiscoJourney' => [
    'fields' => [
      'kNOW' => 'KNOW',
      'videos1and2' => 'Videos 1 e 2',
      'videos3And4' => 'Videos 3 e 4',
      'video5' => 'Vídeo 5',
      'vdeos67And8' => 'Vídeos 6, 7 e 8',
      'account' => 'Account'
    ],
    'links' => [
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks',
      'account' => 'Account'
    ],
    'labels' => [
      'Create CiscoJourney' => 'Create Cisco Journey'
    ],
    'options' => [
      'kNOW' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'videos1and2' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'videos3And4' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'video5' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'vdeos67And8' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ]
    ],
    'tooltips' => [
      'videos1and2' => 'Sim: Registro Synnex / Registro CISCO
Não: Comunicação de Engajamento para continuar a jornada e registrar-se na Cisco.',
      'kNOW' => 'Sim:	Jornada de vídeos Velocity Accelerate.
Não:	Comunicação de engajamento e divulgação da jornada.',
      'videos3And4' => 'Sim: Inscrição no Evento Cisco Select e material de apoio das certificações.
Não: Comunicação de Engajamento para continuar a jornada e registrar-se na Cisco.',
      'video5' => 'Sim: Inscrição nos cursos K.NOW / Black Belt - Envio de material de apoio.
Não: Comunicação de Engajamento para continuar a jornada.',
      'vdeos67And8' => 'Sim: Ao terminar a jornada, encaminhar comunicação de boas vindas e direcionar o contato de vendas e o time de produto entrar em contato.
Não: Comunicação de Engajamento para continuar a jornada e registrar-se na Cisco.'
    ]
  ],
  'CloudConsumption' => [
    'fields' => [
      'partnerID' => 'Partner ID',
      'billingPeriod' => 'Data da medição',
      'amount' => 'Valor',
      'amountCurrency' => 'Valor (Currency)',
      'amountConverted' => 'Valor (Converted)',
      'status' => 'Status',
      'account' => 'Conta',
      'salesOrder' => 'Sales Order',
      'lastupdate' => 'Last Update'
    ],
    'links' => [
      'partnerID' => 'Partner ID',
      'account' => 'Conta',
      'salesOrder' => 'Sales Order'
    ],
    'labels' => [
      'Create CloudConsumption' => 'Create Cloud Consumption'
    ],
    'tooltips' => [
      'billingPeriod' => 'Data da medição do consumo. Quando a data for o último dia do mês, este registro reflete o valor do consumo no mês. Atenção: este valor poderá ser atualizado até o quinto dia do mês seguinte devido a variações no envio das informações pelo próprio fabricante.'
    ],
    'options' => [
      'status' => [
        'In progress' => 'In progress',
        'Complete' => 'Complete'
      ]
    ]
  ],
  'Contract' => [
    'links' => [
      'contractGoals' => 'Contract Goals',
      'accountVBM' => 'Account VBM'
    ],
    'labels' => [
      'Create Contract' => 'Create Contract'
    ],
    'fields' => [
      'paises' => 'Country',
      'periodoImportado' => 'periodo_importado',
      'contratoMs' => 'contrato_ms',
      'tipo' => 'Type',
      'fornecedor' => 'fornecedor',
      'nomefornecedor' => 'nomefornecedor',
      'fatcfourv' => 'fat_cf_ou_rv',
      'clienteParaFaturamento' => 'cliente_para_faturamento',
      'descricaoCliente' => 'End Customer',
      'revendedor' => 'Reseller',
      'descricaoRevendedor' => 'Reseller',
      'codItem' => 'cod_item',
      'descricaoItem' => 'descricao_item',
      'chargeType' => 'charge_type',
      'syndicationpartnersubscriptionnumber' => 'ERP Sales Order',
      'inicioDaCobranca' => 'inicio_da_cobranca',
      'fimDaCobranca' => 'fim_da_cobranca',
      'orderId' => 'order_id',
      'invoice' => 'invoice',
      'dataAprovManual' => 'data_aprov_manual',
      'usuarioAprovManual' => 'usuario_aprov_manual',
      'usuario' => 'user',
      'horaAprov' => 'hora_aprov',
      'ordenDeCompra' => 'orden_de_compra',
      'log' => 'log',
      'nfGerada' => 'nf_gerada',
      'subcategoria' => 'subcategoria',
      'quantidade' => 'Amount',
      'precoUnitario' => 'preco_unitario',
      'valorTotal' => 'Cost Amount',
      'descContrato' => 'desc_contrato',
      'acresContrato' => 'acres_contrato',
      'descRevenda' => 'desc_revenda',
      'vlrPercentualComissao' => 'vlr_percentual_comissao',
      'valorComissao' => 'valor_comissao',
      'resellerunitprice' => 'resellerunitprice',
      'totalRv' => 'Valor de Venda',
      'enduserunitprice' => 'enduserunitprice',
      'totalCf' => 'total_cf',
      'tblpreco' => 'tblpreco',
      'lucro' => 'Margem (US$)',
      'date' => 'Data (Período Importado)',
      'quarter' => 'Quarter',
      'month' => 'Month',
      'margem' => 'Margem (%)',
      'facturadeVenta' => 'Factura_de_Venta',
      'facturaDeVenta' => 'FacturaDeVenta',
      'statusDoContrato' => 'Status Contrato',
      'totalsales' => 'Sale Amount',
      'credit' => 'Credit',
      'lastupdate' => 'Last Update',
      'contractGoals' => 'Contract Goals',
      'accountVBM' => 'Account VBM',
      'soldByCountry' => 'SoldByCountry',
      'emisionVenta' => 'EmisionVenta',
      'spla' => 'Spla',
      'termDuration' => 'TermDuration',
      'billingCycle' => 'BillingCycle'
    ],
    'options' => [
      'quarter' => [
        '' => '',
        'Q1' => 'Q1',
        'Q2' => 'Q2',
        'Q3' => 'Q3',
        'Q4' => 'Q4'
      ],
      'statusDoContrato' => [
        'FATURADO' => 'FATURADO',
        'Faturado' => 'Faturado',
        'NF Devolvida	' => 'NF Devolvida	',
        'Crédito Vinculado	' => 'Crédito Vinculado	',
        'Validado' => 'Validado',
        'NF Devolvida' => 'NF Devolvida',
        'Cr\\u00e9dito Vinculado' => 'Cr\\u00e9dito Vinculado',
        '' => '',
        'Crédito Vinculado' => 'Crédito Vinculado',
        'Não Validado' => 'Não Validado'
      ]
    ],
    'presetFilters' => [
      'reportFilter6686eac9c5a60065c' => 'Contracts Q1',
      'reportFilter6686ead1b861b28d9' => 'Contracts Q2',
      'reportFilter6686eae14885b6a3a' => 'Contracts Q3',
      'reportFilter6686eae8f245d4139' => 'Contracts Q4'
    ]
  ],
  'ContractGoals' => [
    'fields' => [
      'contracts' => 'Contracts',
      'q1' => 'Q1 (Dec-Fev)',
      'q1Currency' => 'Q1 (Currency)',
      'q1Converted' => 'Q1 (Converted)',
      'q2' => 'Q2 (Mar-Mai)',
      'q2Currency' => 'Q2 (Currency)',
      'q2Converted' => 'Q2 (Converted)',
      'amountGoal' => 'Meta',
      'amountGoalCurrency' => 'Meta (Moneda)',
      'amountGoalConverted' => 'Meta (Convertido)',
      'newResellers' => 'Novas Revendas',
      'q1goal' => 'Q1 - Meta',
      'q1goalCurrency' => 'Q1 - Meta (Moneda)',
      'q1goalConverted' => 'Q1 - Meta (Convertido)',
      'year' => 'Ano',
      'type' => 'Tipo',
      'sync' => 'Sync',
      'roi' => 'Diferença / Lucro',
      'roiCurrency' => 'Diferença / Lucro (Moneda)',
      'roiConverted' => 'Diferença / Lucro (Convertido)',
      'revendedorID' => 'Revendedor ID',
      'region' => 'Region',
      'q4goal' => 'Q4 - Meta',
      'q4goalCurrency' => 'Q4 - Meta (Moneda)',
      'q4goalConverted' => 'Q4 - Meta (Convertido)',
      'q4diff' => 'Q4 - Diferença',
      'q4diffCurrency' => 'Q4 - Diferença (Moneda)',
      'q4diffConverted' => 'Q4 - Diferença (Convertido)',
      'q4' => 'Q4 (Set-Nov)',
      'q4Currency' => 'Q4 - Set/Out/Nov (Moneda)',
      'q4Converted' => 'Q4 - Set/Out/Nov (Convertido)',
      'q3goal' => 'Q3 - Meta',
      'q3goalCurrency' => 'Q3 - Meta (Moneda)',
      'q3goalConverted' => 'Q3 - Meta (Convertido)',
      'q3diff' => 'Q3 - Diferença',
      'q3diffCurrency' => 'Q3 - Diferença (Moneda)',
      'q3diffConverted' => 'Q3 - Diferença (Convertido)',
      'q3' => 'Q3 (Jun-Ago)',
      'q3Currency' => 'Q3 - Jun/Jul/Ago (Moneda)',
      'q3Converted' => 'Q3 - Jun/Jul/Ago (Convertido)',
      'q2goal' => 'Q2 - Meta',
      'q2goalCurrency' => 'Q2 - Meta (Moneda)',
      'q2goalConverted' => 'Q2 - Meta (Convertido)',
      'q2diff' => 'Q2 - Diferença',
      'q2diffCurrency' => 'Q2 - Diferença (Moneda)',
      'q2diffConverted' => 'Q2 - Diferença (Convertido)',
      'q1diff' => 'Q1 - Diferença',
      'q1diffCurrency' => 'Q1 - Diferença (Moneda)',
      'q1diffConverted' => 'Q1 - Diferença (Convertido)',
      'country' => 'País'
    ],
    'links' => [
      'contracts' => 'Contracts'
    ],
    'labels' => [
      'Create ContractGoals' => 'Crear Meta'
    ],
    'options' => [
      'year' => [
        2023 => '2023',
        2024 => '2024',
        2025 => '2025',
        2026 => '2026',
        2027 => '2027',
        2028 => '2028',
        2029 => '2029',
        2030 => '2030',
        '' => ''
      ],
      'type' => [
        '' => '',
        'Licenciamento' => 'Licenciamento',
        'Consumo' => 'Consumo',
        'Licença' => 'Licença'
      ],
      'region' => [
        '' => '',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'Brasil' => 'Brasil',
        'CCA' => 'CCA'
      ],
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'Costa Rica' => 'Costa Rica',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador' => 'Ecuador',
        'El Salvador' => 'El Salvador',
        'Guadelouope' => 'Guadelouope',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Mexico' => 'Mexico',
        'Panama' => 'Panama',
        'Paraguay' => 'Paraguay',
        'Peru' => 'Peru',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'CCA' => 'CCA',
        'Caribe' => 'Caribe',
        'Santa Lucía' => 'Santa Lucía',
        'San vicente y las Granadinas' => 'San vicente y las Granadinas',
        'San Cristóbal y Nieves' => 'San Cristóbal y Nieves',
        'Jamaica' => 'Jamaica',
        'Belice' => 'Belice',
        'Haití' => 'Haití',
        'Guyana' => 'Guyana',
        'Granada' => 'Granada',
        'Cuba' => 'Cuba',
        'Barbados' => 'Barbados',
        'Bahamas' => 'Bahamas',
        'Antigua y barbuda' => 'Antigua y barbuda',
        'Nicaragua' => 'Nicaragua',
        'United States' => 'United States',
        'CALA' => 'CALA'
      ]
    ]
  ],
  'Country' => [
    'fields' => [
      'countryLabel' => 'CountryLabel',
      'priceBooks' => 'Price Books'
    ],
    'links' => [
      'priceBooks' => 'Price Books'
    ],
    'labels' => [
      'Create Country' => 'Create Country'
    ],
    'options' => [
      'countryLabel' => [
        'Argentina' => 'Argentina',
        'Colombia' => 'Colombia',
        'Brasil' => 'Brasil',
        'Chile' => 'Chile',
        'Peru' => 'Peru',
        'Ecuador' => 'Ecuador',
        'Cala' => 'Cala',
        'Mexico' => 'Mexico',
        'Uruguai' => 'Uruguai',
        '' => ''
      ]
    ]
  ],
  'CuentasVBM' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create CuentasVBM' => 'Create VBM Accounts'
    ]
  ],
  'DSET' => [
    'fields' => [
      'account' => 'Account',
      'contact' => 'Contact',
      'productBrands' => 'Brands',
      'categoriaCPB' => 'CPB Category',
      'country' => 'País',
      'dSETAWS' => 'DSET AWS',
      'language' => 'Idioma',
      'region' => 'Region',
      'statusCPB' => 'CPB status',
      'submissionID' => 'Submission ID',
      'vendor' => 'Vendor'
    ],
    'links' => [
      'account' => 'Account',
      'contact' => 'Contact',
      'productBrands' => 'Brands'
    ],
    'labels' => [
      'Create DSET' => 'Create DSET'
    ],
    'options' => [
      'categoriaCPB' => [
        '' => '',
        'Sem Categoria' => 'Without category',
        'Starter' => 'Starter',
        'Transformer' => 'Transformer',
        'Accelerator' => 'Accelerator'
      ],
      'country' => [
        '' => '',
        'Argentina ' => 'Argentina ',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'Chile' => 'Chile',
        'Colombia ' => 'Colombia ',
        'Costa Rica ' => 'Costa Rica ',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador' => 'Ecuador',
        'Guadeloupe' => 'Guadeloupe',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'El Salvador' => 'El Salvador',
        'Mexico' => 'Mexico',
        'Panama ' => 'Panama ',
        'Paraguay ' => 'Paraguay ',
        'Peru' => 'Peru',
        'Puerto Rico ' => 'Puerto Rico ',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela'
      ],
      'dSETAWS' => [
        'No Concluído' => 'Not Concluded',
        'Concluído' => 'Concluded'
      ],
      'language' => [
        '' => '',
        'pt' => 'Português',
        'en' => 'English',
        'es' => 'Espanõl'
      ],
      'region' => [
        '' => '',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'CCA' => 'CCA',
        'Brasil' => 'Brasil',
        'México' => 'México'
      ],
      'statusCPB' => [
        'No Concluído' => 'Not Concluded',
        'Concluído' => 'Concluded'
      ],
      'vendor' => [
        '' => '',
        'AWS' => 'AWS',
        'Google' => 'Google',
        'Microsoft' => 'Microsoft'
      ]
    ]
  ],
  'DashboardAccess' => [
    'fields' => [
      'accessTime' => 'Access Time',
      'tabName' => 'Tab Name'
    ],
    'links' => [],
    'labels' => [
      'Create DashboardAccess' => 'Create Dashboard Access'
    ]
  ],
  'DataAIAssessment' => [
    'fields' => [
      'category' => 'Category',
      'account' => 'Conta',
      'contact' => 'Contato',
      'contacts' => 'Contatos',
      'country' => 'Pais'
    ],
    'links' => [
      'account' => 'Conta',
      'contact' => 'Contato',
      'contacts' => 'Contatos'
    ],
    'labels' => [
      'Create DataAIAssessment' => 'Crear Data AI - Lista'
    ],
    'options' => [
      'category' => [
        '' => '',
        'Aware' => 'Aware',
        'Ready' => 'Ready',
        'Expert' => 'Expert'
      ]
    ]
  ],
  'DataAnalytics' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create DataAnalytics' => 'Create Data Analytics'
    ]
  ],
  'DataAnalyticsReport' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create DataAnalyticsReport' => 'Create Data Analytics Report'
    ]
  ],
  'Distributor' => [
    'fields' => [
      'accessToken' => 'AccessToken',
      'accountId' => 'AccountId',
      'appId' => 'AppId',
      'clientId' => 'ClientId',
      'clientSecret' => 'ClientSecret',
      'codErp' => 'CodErp',
      'culture' => 'Culture',
      'domain' => 'Domain',
      'expireToken' => 'ExpireToken',
      'mpnId' => 'MpnId',
      'refreshToken' => 'RefreshToken',
      'scope' => 'Scope',
      'countryCode' => 'Country Code'
    ],
    'links' => [],
    'labels' => [
      'Create Distributor' => 'Create Distributor'
    ],
    'options' => [
      'scope' => [
        'api.partner.microsoft.com' => 'api.partner.microsoft.com',
        'management.azure.com' => 'management.azure.com',
        'graph.microsoft.com' => 'graph.microsoft.com',
        'api.partnercenter.microsoft.com' => 'api.partnercenter.microsoft.com'
      ]
    ]
  ],
  'DsetAws' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create DsetAws' => 'Create DSET AWS'
    ]
  ],
  'Earn' => [
    'fields' => [
      'earningId' => 'earningId',
      'participantId' => 'participantId',
      'participantIdType' => 'participantIdType',
      'participantName' => 'Region',
      'programName' => 'Program Name',
      'transactionId' => 'transactionId',
      'transactionCurrency' => 'transactionCurrency',
      'lever' => 'lever',
      'engagementName' => 'engagementName',
      'engagementId' => 'engagementId',
      'earningType' => 'earningType',
      'claimId' => 'claimId',
      'paymentId' => 'Payment ID',
      'paymentStatusDescription' => 'paymentStatusDescription',
      'customerId' => 'customerId',
      'customerName' => 'customerName',
      'partNumber' => 'partNumber',
      'productName' => 'productName',
      'productId' => 'productId',
      'parentProductId' => 'parentProductId',
      'parentProductName' => 'parentProductName',
      'productType' => 'productType',
      'invoiceNumber' => 'invoiceNumber',
      'subscriptionId' => 'subscriptionId',
      'resellerId' => 'resellerId',
      'resellerName' => 'resellerName',
      'distributorId' => 'distributorId',
      'distributorName' => 'distributorName',
      'agreementNumber' => 'agreementNumber',
      'agreementStartDate' => 'agreementStartDate',
      'agreementEndDate' => 'agreementEndDate',
      'workload' => 'workload',
      'transactionType' => 'transactionType',
      'localProviderSeller' => 'localProviderSeller',
      'taxRemitModel' => 'taxRemitModel',
      'storeFee' => 'storeFee',
      'transactionPaymentMethod' => 'transactionPaymentMethod',
      'tpan' => 'tpan',
      'purchaseTypeCode' => 'purchaseTypeCode',
      'purchaseOrderType' => 'purchaseOrderType',
      'purchaseOrderCoverageStartDate' => 'purchaseOrderCoverageStartDate',
      'purchaseOrderCoverageEndDate' => 'purchaseOrderCoverageEndDate',
      'externalReferenceId' => 'externalReferenceId',
      'externalReferenceIdLabel' => 'externalReferenceIdLabel',
      'licensingProgramName' => 'licensingProgramName',
      'taxCountry' => 'taxCountry',
      'taxState' => 'taxState',
      'taxCity' => 'taxCity',
      'taxZipCode' => 'taxZipCode',
      'programCode' => 'programCode',
      'lastPaymentCurrency' => 'lastPaymentCurrency',
      'assetId' => 'assetId',
      'orderId' => 'orderId',
      'lineItemId' => 'lineItemId',
      'resellerCountry' => 'resellerCountry',
      'customerCountry' => 'Customer Country',
      'customerEmail' => 'customerEmail',
      'skuId' => 'skuId',
      'customerTenantId' => 'customerTenantId',
      'invoiceDate' => 'invoiceDate',
      'fundCategory' => 'fundCategory',
      'categoryId' => 'categoryId',
      'reasonCode' => 'reasonCode',
      'bucketSize' => 'bucketSize',
      'milestone' => 'milestone',
      'billingGroupId' => 'billingGroupId',
      'quantityType' => 'quantityType',
      'topParentPartNumber' => 'topParentPartNumber',
      'productFamily' => 'productFamily',
      'topParentProductFamily' => 'topParentProductFamily',
      'agreementType' => 'agreementType',
      'userCount' => 'userCount',
      'desktopCount' => 'desktopCount',
      'baseline' => 'baseline',
      'baselineType' => 'baselineType',
      'isPrivateOffer' => 'isPrivateOffer',
      'transactionExchangeRate' => 'transactionExchangeRate',
      'transactionAmount' => 'transactionAmount',
      'earningRate' => 'earningRate',
      'quantity' => 'quantity',
      'earningAmount' => 'Earning Amount',
      'earningExchangeRate' => 'earningExchangeRate',
      'taxRemitted' => 'taxRemitted',
      'earningAmountInLastPaymentCurrency' => 'earningAmountInLastPaymentCurrency',
      'instantRebateAmount' => 'instantRebateAmount',
      'transactionDate' => 'transactionDate',
      'paymentStatus' => 'Payment Status',
      'transactionCountryCode' => 'TransactionCountryCode',
      'calculationDate' => 'CalculationDate',
      'exchangeRateDate' => 'ExchangeRateDate',
      'subscriptionStartDate' => 'SubscriptionStartDate',
      'subscriptionEndDate' => 'SubscriptionEndDate',
      'earningAmountUSD' => 'Earning Amount (USD)',
      'earningAmountUSDCurrency' => 'Earning Amount (USD) (Currency)',
      'earningAmountUSDConverted' => 'Earning Amount (USD) (Converted)',
      'transactionAmountUSD' => 'Transaction Amount (USD)',
      'transactionAmountUSDCurrency' => 'Transaction Amount (USD) (Currency)',
      'transactionAmountUSDConverted' => 'Transaction Amount (USD) (Converted)',
      'estimatedPaymentMonth' => 'Estimated Payment Month',
      'earningDate' => 'EarningDate',
      'partnerCountryCode' => 'Country Code',
      'earningDate2' => 'Earning Date'
    ],
    'links' => [],
    'labels' => [
      'Create Earn' => 'Create Earn'
    ],
    'options' => [
      'paymentStatus' => [
        'UNPROCESSED' => 'Unprocessed',
        'PROCESSED' => 'Processed',
        'Sent' => 'Sent',
        'Reprocessing' => 'Reprocessing',
        'Upcoming' => 'Upcoming',
        'Sent:Payout Profile Not Available' => 'Sent - Payout Profile Not Available'
      ],
      'transactionCountryCode' => [
        '' => '',
        'BR' => 'BR',
        'MX' => 'MX',
        'EC' => 'EC',
        'AR' => 'AR',
        'CO' => 'CO',
        'CA' => 'CA',
        'CH' => 'CH',
        'BO' => 'BO',
        'PE' => 'PE'
      ],
      'estimatedPaymentMonth' => [
        'Apr-2023' => 'Apr-2023',
        'Mar-2023' => 'Mar-2023',
        'May-2023' => 'May-2023',
        'Jul-2023' => 'Jul-2023',
        'Not applicable' => 'Not applicable'
      ],
      'partnerCountryCode' => [
        'BR' => 'BR',
        'CO' => 'CO',
        'MX' => 'MX',
        'CL' => 'CL',
        'PA' => 'PA',
        'EC' => 'EC',
        'AR' => 'AR',
        'PE' => 'PE'
      ]
    ]
  ],
  'EmailContent' => [
    'fields' => [
      'attachments' => 'Add Attachments',
      'done' => 'Done',
      'scheduled' => 'Scheduled',
      'status' => 'Status',
      'country' => 'Country',
      'sendExample' => 'Send Example',
      'accounts' => 'Accounts',
      'content' => 'Content',
      'startDate' => 'Promo Start Date',
      'endDate' => 'Promo End Date',
      'active' => 'Active',
      'promoContent' => 'Promo Content',
      'title' => 'Title',
      'promoTitle' => 'Promo Title',
      'emails' => 'Emails',
      'emailAddress' => 'E-mail',
      'accountsList' => 'Accounts List',
      'contactsList' => 'Contacts List'
    ],
    'links' => [
      'accounts' => 'Accounts',
      'emails' => 'Emails',
      'accountsList' => 'Accounts List',
      'contactsList' => 'Contacts List'
    ],
    'labels' => [
      'Create EmailContent' => 'Create Email Content'
    ],
    'options' => [
      'status' => [
        'Created' => 'Created',
        'Started' => 'Started / Reviewing',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Sent' => 'Sent',
        'Scheduled' => 'Scheduled'
      ],
      'country' => [
        'Ecuador' => 'Ecuador',
        'Colombia' => 'Colombia',
        'Chile' => 'Chile',
        'Argentina' => 'Argentina',
        'Paraguay' => 'Paraguay',
        'Uruguay' => 'Uruguay',
        'Peru' => 'Peru',
        'Mexico' => 'Mexico',
        'Venezuela' => 'Venezuela',
        'El Salvador' => 'El Salvador',
        'Costa Rica' => 'Costa Rica',
        'Bolivia' => 'Bolivia',
        'Dominican Republic' => 'Dominican Republic',
        'Panama' => 'Panama',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Nicaragua' => 'Nicaragua',
        'Puerto Rico' => 'Puerto Rico',
        'Jamaica' => 'Jamaica',
        'Barbados' => 'Barbados',
        'Guadeloupe' => 'Guadeloupe',
        'Brasil (teste)' => 'Brasil (teste)'
      ]
    ],
    'tooltips' => [
      'sendExample' => 'Click here to send a sample email to your email address. Please, make sure to add your email address to the field below. ',
      'content' => 'Define the email content. You can insert text and image, make sure the maximum image width size is 559px.',
      'scheduled' => 'Set when the email must be sent to the Accounts list below. Then change the status to "Completed" and check the "Done" box if the email is ready to be sent on the scheduled date.',
      'country' => 'Select the country to receive this communication.',
      'attachments' => 'If there are any assets to send, please attach them here.',
      'active' => 'Range Date: Active Promo',
      'done' => 'Check the "Done" box if the email is ready to be sent on the scheduled date.',
      'status' => 'Change the status to "Completed" and check the "Done" box if the email is ready to be sent on the scheduled date.',
      'promoContent' => 'Define the promo content (Promociones). You can insert text and image, make sure the maximum image width size is 600px.',
      'startDate' => 'Promotion start date.',
      'endDate' => 'Final date of the promotion.',
      'title' => 'Set the title for the Promo email section.',
      'promoTitle' => 'Set the title for the Promo email section.',
      'emailAddress' => 'Please, make sure to add your email address to the field below and then click on "Send Example". A sample email will be sent to your registered email address.'
    ]
  ],
  'Events' => [
    'fields' => [
      'parent' => 'Parent',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'duration' => 'Duration',
      'status' => 'Status',
      'reminders' => 'Reminders',
      'dateStartDate' => 'Date Start (all day)',
      'dateEndDate' => 'Date End (all day)',
      'isAllDay' => 'Is All-Day',
      'productBrands' => 'Fabricantes',
      'accounts' => 'Parceiros'
    ],
    'links' => [
      'parent' => 'Parent',
      'productBrands' => 'Fabricantes',
      'accounts' => 'Parceiros'
    ],
    'options' => [
      'status' => [
        'Planned' => 'Planned',
        'Held' => 'Held',
        'Not Held' => 'Not Held'
      ]
    ],
    'labels' => [
      'Create Events' => 'Create Event',
      'Schedule Events' => 'Schedule Event',
      'Log Events' => 'Log Event',
      'Set Held' => 'Set Held',
      'Set Not Held' => 'Set Not Held'
    ],
    'massActions' => [
      'setHeld' => 'Set Held',
      'setNotHeld' => 'Set Not Held'
    ],
    'presetFilters' => [
      'planned' => 'Planned',
      'held' => 'Held',
      'todays' => 'Today\'s'
    ]
  ],
  'ExternalFormPost' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create ExternalFormPost' => 'Create ExternalFormPost'
    ]
  ],
  'GoogleCloud' => [
    'fields' => [
      'account' => 'Account',
      'product' => 'Product',
      'subProduct' => 'Sub Product',
      'amount' => 'Amount',
      'amountCurrency' => 'Amount (Currency)',
      'amountConverted' => 'Amount (Converted)',
      'stage' => 'Stage',
      'discount' => 'Discount (%)',
      'googleClouds' => 'Google Clouds',
      'googleCloudParent' => 'Google Cloud Parent',
      'tipodeoportunidad' => 'Tipo de Oportunidad',
      'cantidadDeLicencias' => 'Cantidad de licencias',
      'contratoATiempo' => 'Contrato a tiempo',
      'nombreDelProyecto' => 'Nombre del Proyecto',
      'productosAConsumir' => 'Producto/s a consumir',
      'amountProxConsumo' => 'Amount Aprox de Consumo',
      'amountProxConsumoCurrency' => 'Amount Prox Consumo (Currency)',
      'amountProxConsumoConverted' => 'Amount Prox Consumo (Converted)',
      'edicinDeWorkspace1' => 'Edicion de Workspace',
      'partner' => 'Partner',
      'partnersGoogleCloud' => 'Partner Google Cloud',
      'rebates' => 'Rebates',
      'backend' => 'Backend %',
      'region' => 'Region',
      'country' => 'Country',
      'oportunidadesGoogle' => 'Oportunidades Google',
      'contratoATiempoList' => 'Contrato a Tiempo'
    ],
    'links' => [
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks',
      'account' => 'Account',
      'googleClouds' => 'Google Clouds',
      'googleCloudParent' => 'Google Cloud Parent',
      'partner' => 'Partner',
      'partnersGoogleCloud' => 'Partner Google Cloud',
      'oportunidadesGoogle' => 'Oportunidades Google'
    ],
    'labels' => [
      'Create GoogleCloud' => 'Criar Oportunidad Google Cloud'
    ],
    'options' => [
      'product' => [
        '' => '',
        'Google Workspace' => 'Google Workspace',
        'Google Cloud Platform' => 'Google Cloud Platform'
      ],
      'subProduct' => [
        '' => '',
        'License Type' => 'License Type',
        'GCP Service' => 'GCP Service'
      ],
      'stage' => [
        'Prospecting' => 'Prospecting',
        'Proposal' => 'Proposal',
        'Negotiation' => 'Negotiation',
        'Closed Won' => 'Closed Won',
        'Closed Lost' => 'Closed Lost'
      ],
      'tipodeoportunidad' => [
        '' => '',
        'Upgrade de licencias' => 'Upgrade de licencias',
        'New Business' => 'New Business',
        'Renovación de Licencias' => 'Renovación de Licencias'
      ],
      'nombreDelProyecto' => [
        '' => '',
        'Almacenamiento Cloud' => 'Almacenamiento Cloud',
        'Servidores Web' => 'Servidores Web',
        'AGFA Healthcare as a services' => 'AGFA Healthcare as a services',
        'Recaptcha' => 'Recaptcha'
      ],
      'productosAConsumir' => [
        '' => '',
        'Cloud Storage' => 'Cloud Storage',
        'VM' => 'VM',
        'GCP' => 'GCP',
        'Recaptcha' => 'Recaptcha'
      ],
      'edicinDeWorkspace1' => [
        '' => '',
        'Business Starter' => 'Business Starter',
        'Business Standard' => 'Business Standard',
        'Business Plus' => 'Business Plus',
        'Enterprise Starter' => 'Enterprise Starter',
        'Enterprise Standard ' => 'Enterprise Standard ',
        'Enterprise Plus' => 'Enterprise Plus',
        'Frontline' => 'Frontline'
      ],
      'rebates' => [
        '' => '',
        'Si' => 'Si',
        'No' => 'No'
      ],
      'contratoATiempoList' => [
        '' => '',
        'Plan Flexible' => 'Plan Flexible',
        'Plan a 12 meses de contrato' => 'Plan a 12 meses de contrato',
        'Plan a 24 meses de contrato' => 'Plan a 24 meses de contrato',
        'Plan a 36 meses de contrato' => 'Plan a 36 meses de contrato',
        'Versión de prueba' => 'Versión de prueba'
      ]
    ]
  ],
  'GooglePartnerAdvantage' => [
    'fields' => [
      'productBrand' => 'Product Brand',
      'stage' => 'Stage',
      'qualify' => 'Qualify',
      'refine' => 'Refine',
      'techEvalSolutionDev' => 'Tech Evaluation | Solution Dev',
      'proposalNegotiation' => 'Proposal | Negotiation',
      'lead' => 'Lead',
      'opportunities' => 'Opportunities',
      'amount' => 'Value',
      'amountCurrency' => 'Opportunity Value (Currency)',
      'amountConverted' => 'Opportunity Value (Converted)',
      'update' => 'Update',
      'account' => 'Account Name',
      'opportunityOwner' => 'Opportunity Owner',
      'productFamily' => 'Product Family',
      'email' => 'E-mail',
      'phone' => 'Phone',
      'domain' => 'Client Domain',
      'oppIDGoogle' => 'Opportunity ID',
      'lostReason' => 'Reason for Cancellation/Loss',
      'closeDate' => 'Closing/Loss Date',
      'country' => 'Country',
      'reason' => 'Reason'
    ],
    'links' => [
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks',
      'productBrand' => 'Product Brand',
      'lead' => 'Lead',
      'opportunities' => 'Opportunities',
      'account' => 'Account Name'
    ],
    'labels' => [
      'Create GooglePartnerAdvantage' => 'Create Google Partner Advantage'
    ],
    'options' => [
      'stage' => [
        'Qualify' => 'Qualify',
        'Refine' => 'Refine',
        'Tech Evaluation | Solution Dev' => 'Tech Evaluation | Solution Dev',
        'Proposal | Negotiation' => 'Proposal | Negotiation',
        'Closed' => 'Closed',
        '' => 'Nenhum',
        'Lost' => 'Lost'
      ],
      'qualify' => [
        'At least one meeting with C-level, Co- Founder or C-1 level business sponsor.' => 'At least one meeting with C-level, Co- Founder or C-1 level business sponsor.',
        '[Select/Enterprise only] Completed Cloud Account Plan (go/cloudaccountplan)' => '[Select/Enterprise only] Completed Cloud Account Plan (go/cloudaccountplan)',
        'Accept/Reject opportunity in SFDC and progress to Stage 1 (30 day SLA)' => 'Accept/Reject opportunity in SFDC and progress to Stage 1 (30 day SLA)'
      ],
      'refine' => [
        '[Select/Enterprise only] Mutual Evaluation Plan (go/cloud-mep) is recommended.' => '[Select/Enterprise only] Mutual Evaluation Plan (go/cloud-mep) is recommended.',
        'Completed Cloud Project Discovery (go/cloud-pdg)' => 'Completed Cloud Project Discovery (go/cloud-pdg)',
        'Partner Attach' => 'Partner Attach',
        'Solution Tagging' => 'Solution Tagging',
        'Site Selection' => 'Site Selection'
      ],
      'techEvalSolutionDev' => [
        'Decision Maker Signoff on Technical Win' => 'Decision Maker Signoff on Technical Win',
        'Technical Proposal & Architecture (go/cloudtp)' => 'Technical Proposal & Architecture (go/cloudtp)',
        'Technical Deal Blockers Identified' => 'Technical Deal Blockers Identified',
        'Capacity Plan (go/getonering)' => 'Capacity Plan (go/getonering)',
        'Populate Term (Months)' => 'Populate Term (Months)',
        'AI/ML and Business Need (If AI/ML is Yes) are required' => 'AI/ML and Business Need (If AI/ML is Yes) are required'
      ],
      'proposalNegotiation' => [
        'Partner and/or PSO SOW' => 'Partner and/or PSO SOW',
        'Executed Contract' => 'Executed Contract',
        'Countersigned MSA and order form' => 'Countersigned MSA and order form',
        'Commercial Proposal' => 'Commercial Proposal'
      ],
      'productFamily' => [
        '' => '',
        'Google Cloud Platform' => 'Google Cloud Platform',
        'Google Workspace' => 'Google Workspace'
      ],
      'lostReason' => [
        '' => '',
        'SLA' => 'SLA',
        'Cliente não retornou contato' => 'Customer did not return contact',
        'Cliente escolheu outro fornecedor' => 'Customer chose another supplier',
        'Cliente não tem interesse na solução ofertada' => 'Client is not interested in the solution offered',
        'Preços' => 'Prices',
        'Outro' => 'Other'
      ]
    ],
    'tooltips' => [
      'qualify' => 'Indetify initial problem and desire to adress with key Stakeholders.',
      'refine' => 'Problems uncovered and align solution to critical business need.',
      'techEvalSolutionDev' => 'Customer confirmed their required capabilities. Final Solution and POC confirmed.',
      'proposalNegotiation' => 'Technical validation complete and customer agreed to pricing signature date.'
    ]
  ],
  'Importer' => [
    'fields' => [
      'status' => 'Status',
      'inputFile' => 'Arquivo de Entrada',
      'outputFile' => 'Arquivo de Saída',
      'type' => 'Tipo de Dados',
      'detailOppCIS' => 'Detalhes',
      'templateURL' => 'Template URL - Cloud Brasil',
      'documents' => 'Documents'
    ],
    'links' => [
      'documents' => 'Documents'
    ],
    'labels' => [
      'Create Importer' => 'Create Importador'
    ],
    'options' => [
      'status' => [
        '' => '',
        'Created' => 'Created',
        'Processing' => 'Processing',
        'Done' => 'Done',
        'Error' => 'Error'
      ],
      'type' => [
        '' => '',
        'Oportunidades Brasil' => 'Oportunidades Brasil',
        'Canais AWS LAC' => 'Partner Program AWS MCA ',
        'Oportunidades AWS LAC' => 'Oportunidades AWS MCA',
        'opp_partner_program_aws' => 'Oportunidades AWS MCA'
      ]
    ]
  ],
  'LeadsPartnerCenter' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create LeadsPartnerCenter' => 'Create Leads Partner Center'
    ]
  ],
  'Marketing' => [
    'fields' => [
      'vendor' => 'Vendor',
      'startDate' => 'Start Date',
      'endingDate' => 'End Date',
      'productBrands' => 'Vendor',
      'country' => 'Country',
      'noExpiration' => 'Expiration',
      'productBrand' => 'Vendor',
      'category' => 'Category',
      'status' => 'Status',
      'opportunities' => 'Opportunities',
      'opportunity' => 'Opportunity',
      'oportunidade' => 'Opportunity',
      'investment' => 'Investment',
      'investmentCurrency' => 'Investment (Currency)',
      'investmentConverted' => 'Investment (Converted)',
      'roi' => 'ROI',
      'roiCurrency' => 'ROI (Currency)',
      'roiConverted' => 'ROI (Converted)',
      'profit' => 'Profit',
      'profitCurrency' => 'Profit (Currency)',
      'profitConverted' => 'Profit (Converted)',
      'profitReal' => 'Profit (BRL)',
      'profitRealCurrency' => 'Profit (BRL) (Currency)',
      'profitRealConverted' => 'Profit (BRL) (Converted)',
      'leads' => 'Leads',
      'contacts' => 'Contacts'
    ],
    'links' => [
      'vendor' => 'Vendor',
      'productBrands' => 'ProductBrand',
      'productBrand' => 'Brand',
      'opportunities' => 'Opportunities',
      'opportunity' => 'Opportunity',
      'oportunidade' => 'Opportunity',
      'leads' => 'Leads',
      'contacts' => 'Contacts'
    ],
    'labels' => [
      'Create Marketing' => 'Create Marketing'
    ],
    'options' => [
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brazil',
        'CCA' => 'CCA',
        'Costa Rica' => 'Costa Rica',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Ecuador ' => 'Ecuador ',
        'Dominican Republic' => 'Dominican Republic',
        'El Salvador' => 'El Salvador',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Mexico' => 'Mexico',
        'Panama' => 'Panama',
        'Guadelouope' => 'Guadelouope',
        'Paraguay' => 'Paraguay',
        'Peru' => 'Peru',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'Ecuador' => 'Ecuador'
      ],
      'noExpiration' => [
        ' ' => 'Expiration'
      ],
      'category' => [
        'Incentivo' => 'Incentive',
        'Digital' => 'Digital',
        '' => ''
      ],
      'status' => [
        '' => '',
        'Activo' => 'Active',
        'Inactivo ' => 'Inactive'
      ]
    ],
    'tooltips' => [
      'roi' => '\\nSum of the values ​​of the opportunities gained.',
      'profit' => 'ROI - Investment = Profit\\nIn case the field is not updated, fill in any value so that the platform will recalculate based on the opportunities won.',
      'profitReal' => 'ROI - Investment = Profit \\nCase or field is not updated, enter any value so that the platform can refaça or calculation based on the winning opportunities.'
    ]
  ],
  'Messenger' => [
    'fields' => [
      'account' => 'Account',
      'sendMessage' => 'Send Message',
      'type' => 'Tipo',
      'origin' => 'Origem',
      'channel' => 'Canal',
      'opportunity' => 'Oportunidade',
      'contentAI' => 'Content AI',
      'status' => 'Status',
      'contentReseller' => 'Institucional Revenda',
      'contentClient' => 'Institucional Cliente Final',
      'salesPitch' => 'Benefícios Produto'
    ],
    'links' => [
      'account' => 'Account',
      'opportunity' => 'Oportunidade'
    ],
    'labels' => [
      'Create Messenger' => 'Criar Mensageria'
    ],
    'options' => [
      'type' => [
        'Account' => 'Account'
      ],
      'origin' => [
        'AI' => 'AI'
      ],
      'channel' => [
        'Email' => 'Email'
      ],
      'status' => [
        'Sent' => 'Enviado',
        'Error' => 'Erro',
        '' => '',
        'Created' => 'Solicitado'
      ]
    ]
  ],
  'Migrations' => [
    'fields' => [
      'parent' => 'Parent',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'duration' => 'Duration',
      'status' => 'Status',
      'reminders' => 'Reminders',
      'dateStartDate' => 'Date Start (all day)',
      'dateEndDate' => 'Date End (all day)',
      'isAllDay' => 'Is All-Day',
      'accountManager' => 'Account Manager / Inside Sales',
      'bdmCloud' => 'BDM Cloud',
      'bucketTimers' => 'Bucket Duration',
      'processOwner' => 'Process Owner',
      'accountIDAWS' => 'AWS Account ID',
      'bucket' => 'Bucket AWS',
      'cancellationReason' => 'Reason for Cancellation',
      'checklistConsumo' => 'Checklist Consumo (Billing x Pipeline)',
      'checklistMigration' => 'Sales | BDM | Billing Movement Checklist',
      'checklistPreSales' => 'Pre-sales | CoE Checklist',
      'completedIn' => 'Completed on',
      'dueDate' => 'Delayed',
      'estimateAmount' => 'Estimated Value',
      'externalID' => 'External ID',
      'jiraCSC' => 'Jira CSC',
      'jiraEngenharia' => 'Engineering Jira',
      'label' => 'Label',
      'priority' => 'Priority',
      'checklistCSC' => 'Checklist Jira | SSCLOUD',
      'lostReason' => 'Justification (Opportunity)',
      'migrationOrigin' => 'Migration Type',
      'partialAmount' => 'Partial Value',
      'partialAmountCurrency' => 'Partial Value (Currency)',
      'partialAmountConverted' => 'Partial Value (Converted)',
      'bucketMicrosoft' => 'Bucket Microsoft',
      'checklistMicrosoft1' => 'Identificação e proposta (MOSP/EA/T1/DIST)',
      'checklistMicrosoft2' => 'Sequência após aprovação do cliente (MOSP/EA/T1/DIST)',
      'checklistMicrosoft3' => 'Somente para Migração de T1/DIST',
      'checklistMicrosoft4' => 'Somente para Migração MOSP/EA',
      'checklistMicrosoft5' => 'Sequência após aprovação do cliente (MOSP/EA)',
      'checklistMicrosoft' => 'Identificação e proposta (MOSP/EA)',
      'opportunityStage' => 'Estágio da Oportunidade'
    ],
    'links' => [
      'parent' => 'Parent',
      'accountManager' => 'Account Manager / Inside Sales',
      'bdmCloud' => 'BDM Cloud',
      'bucketTimers' => 'Bucket Duration',
      'processOwner' => 'Process Owner'
    ],
    'options' => [
      'status' => [
        'Planned' => 'Planned',
        'Held' => 'Held',
        'Not Held' => 'Not Held'
      ],
      'accountIDAWS' => [
        'Digite' => 'Type and press enter'
      ],
      'bucket' => [
        'Upside Pipeline' => 'Upside | Pipeline',
        'Fechado | Movimentação de Billing' => 'Fechado | Movimentação de Billing',
        'Sales | BDM (pendências)' => 'Sales | BDM (pendências)',
        'Validação Pré-vendas | CoE' => 'Validação Pré-vendas | CoE',
        'Jira | SSCLOUD (criação/migração de org)' => 'Jira | SSCLOUD (criação/migração de org)',
        'Acompanhamento Consumo' => 'Acompanhamento Consumo',
        'Consumo Estimado Concluído' => 'Consumo Estimado Concluído',
        'Cancelado' => 'Cancelado',
        'Jira | SSCLOUD' => 'Jira | SSCLOUD (Criação / Migração Organization)',
        'Acompanhamento | Consumo' => 'Acompanhamento | Consumo',
        'Sales | BDM' => 'Sales | BDM (Pendências)',
        '' => ''
      ],
      'checklistConsumo' => [
        'Primeiro billing parcial' => 'First Partial Billing',
        'Billing completo' => 'Completed Billing'
      ],
      'checklistMigration' => [
        'Validação sobre tipo de conta do Cliente Final (Standalone, Service Prov)' => 'Validation of End Customer Account Type (Standalone, Service Provider)',
        'Validação sobre de acordo do Parceiro em Proposta / Condições Comerciais' => 'Validation of Partner Agreement in Proposal / Commercial Terms',
        'Validação sobre aprovação de Crédito para Cliente Final' => 'Validation of Credit Approval for End Customer',
        'Validação sobre existência de créditos do Hyperscaler para Cliente Final' => 'Validation of Hyperscaler Credit Availability for End Customer',
        'Validação sobre plano de suporte contratado na conta' => 'Validation of the Support Plan Contracted for the Account',
        'Criação do documento "Cloud Check-up" / Abertura de chamado Pré-Vendas' => 'Criação do documento "Cloud Check-up" / Abertura de chamado Pré-Vendas',
        'Criação do documento Cloud Check-up / Abertura de chamado Pré-Vendas' => 'Creation of the Cloud Check-up Document / Opening of Pre-sales Ticket',
        'Validação sobre tipo de conta do Cliente Final (Standalone / Service Prov)' => 'Validação sobre tipo de conta do Cliente Final (Standalone / Service Prov)'
      ],
      'checklistPreSales' => [
        'Validação da estrutura do ambiente do Cliente Final' => 'Validation of the End Customer\'s Environment Structure',
        'Validação sobre existência Workloads/Consumo na conta Payer' => 'Validation of the Existence of Workloads/Consumption in the Payer Account',
        'Validação sobre arquivamento de reports de billing anteriores' => 'Validation of Archiving of Previous Billing Reports',
        'Validação sobre nível de segurança e aderência à Políticas TD Synnex' => 'Validation of Security Level and Adherence to TD Synnex Policies',
        'Validação sobre existência Instância Reservadas / Saving Plans' => 'Validation of the Existence of Reserved Instances / Saving Plans',
        'Validação sobre existência Políticas de Controle de Serviço (SCPs)' => 'Validation of the Existence of Service Control Policies (SCPs)',
        'Validação sobre existência Cost Tags Allocations' => 'Validation of the Existence of Cost Tag Allocations',
        'Validação sobre capacidades de Serviço (Parceiro/Cliente Final)' => 'Validation of Service Capabilities (Partner/End Customer)',
        'Atualização do documento "Cloud Check-up" / Abertura de chamado CSC' => 'Atualização do documento "Cloud Check-up" / Abertura de chamado CSC',
        'Atualização do documento Cloud Check-up / Abertura de chamado CSC' => 'Update of the Cloud Check-up Document / Opening of CSC Ticket'
      ],
      'label' => [
        'AWS' => 'AWS',
        '' => 'Selecione',
        'Microsoft' => 'Microsoft'
      ],
      'priority' => [
        '' => '',
        'Low' => 'Low',
        'Medium' => 'Medium',
        'High' => 'High',
        'Urgent' => 'Urgent',
        'Important' => 'Importante'
      ],
      'checklistCSC' => [
        'Abertura do processo administrativo de movimentação' => 'Opening of the Administrative Process for Movement',
        'Validação sobre conclusão do processo administrativo de movimentação' => 'Validation of the Completion of the Administrative Process for Movement',
        'Validação dos contatos principais de acesso ao ambiente' => 'Validation of Key Access Contacts to the Environment'
      ],
      'bucketMicrosoft' => [
        'Upside | Pipeline' => 'Upside | Pipeline',
        'Pré-migração' => 'Pré-migração',
        'Execução T1/DIST (Time SSCLOUD JIRA)' => 'Execução T1/DIST (Time SSCLOUD JIRA)',
        'Execução MOSP/EA (Time Serviços)' => 'Execução MOSP/EA (Time Serviços)',
        'Acompanhamento | Consumo' => 'Acompanhamento | Consumo',
        'Consumo Estimado Concluído' => 'Consumo Estimado Concluído',
        'Cancelado' => 'Cancelado',
        '' => ''
      ],
      'checklistMicrosoft1' => [
        'Identificar origem da migração (MOSP/EA ou Dist/T1)' => 'Identificar origem da migração (MOSP/EA ou Dist/T1)',
        'Parceiro/Cliente baixar o CSV para assessment (Somente MOSP/EA)' => 'Parceiro/Cliente baixar o CSV para assessment (Somente MOSP/EA)',
        'Parceiro/Ciente baixar o relatório de consumo detalhado para estimativa' => 'Parceiro/Ciente baixar o relatório de consumo detalhado para estimativa',
        'Enviar ao time de engenharia os relatórios para assessment (Somente MOSP/EA)' => 'Enviar ao time de engenharia os relatórios para assessment (Somente MOSP/EA)',
        'Enviar ao time de engenharia o relatório de consumo detalhado para estimativa' => 'Enviar ao time de engenharia o relatório de consumo detalhado para estimativa',
        'Devolução para o parceiro com resultado do assessment (MOSP/EA)' => 'Devolução para o parceiro com resultado do assessment (MOSP/EA)',
        'Devolução para o parceiro com resultado da estimativa' => 'Devolução para o parceiro com resultado da estimativa',
        'Aprovação do cliente e andamento no fluxo' => 'Aprovação do cliente e andamento no fluxo',
        'Identificar origem da migração' => 'Identificar origem da migração'
      ],
      'checklistMicrosoft2' => [
        'Realizar a administração delegada (MOSP/EA/T1/DIST)' => 'Realizar a administração delegada (MOSP/EA/T1/DIST)',
        'Cadastrar o cliente na plataforma StreamOne Stellr (MOSP/EA/T1/DIST)' => 'Cadastrar o cliente na plataforma StreamOne Stellr (MOSP/EA/T1/DIST)',
        'Incluir um pedido de Azure para o cliente (MOSP/EA/T1/DIST)' => 'Incluir um pedido de Azure para o cliente (MOSP/EA/T1/DIST)',
        'Solicitar ao parceiro/cliente um usuário no modelo tdsynnex@dominiocliente.com.br (Somente MOSP/EA)' => 'Solicitar ao parceiro/cliente um usuário no modelo tdsynnex@dominiocliente.com.br (Somente MOSP/EA)',
        'Permissão do usuário como contribuidor na assinatura de origem e destino (Somente MOSP/EA)' => 'Permissão do usuário como contribuidor na assinatura de origem e destino (Somente MOSP/EA)',
        'Enviar todos os dados para o time de serviços dar inicio a movimentação (Somente MOSP/EA)' => 'Enviar todos os dados para o time de serviços dar inicio a movimentação (Somente MOSP/EA)',
        'Time de serviços realiza a pré-migração (Somente MOSP/EA)' => 'Time de serviços realiza a pré-migração (Somente MOSP/EA)',
        'Relatório de pré-migração enviado ao parceiro/cliente para aprovação final (Somente MOSP/EA)' => 'Relatório de pré-migração enviado ao parceiro/cliente para aprovação final (Somente MOSP/EA)'
      ],
      'checklistMicrosoft3' => [
        'AM abrir solicitação de migração para o time de SSCLOUD (somente T1/DIST)' => 'AM abrir solicitação de migração para o time de SSCLOUD (somente T1/DIST)',
        'Time de SSCLOUD executa a solicitação via Partner Center (somente T1/DIST)' => 'Time de SSCLOUD executa a solicitação via Partner Center (somente T1/DIST)',
        'Migração aprovada verificação TD SYNNEX se a migração foi concluída (somente T1/DIST)' => 'Migração aprovada verificação TD SYNNEX se a migração foi concluída (somente T1/DIST)',
        'Migração concluída (somente T1/DIST)' => 'Migração concluída (somente T1/DIST)',
        'Sincronização da assinatura migrada com o contrato no StreamOne Stellr (somente T1/DIST)' => 'Sincronização da assinatura migrada com o contrato no StreamOne Stellr (somente T1/DIST)',
        'Envio do comando Powershell para o cliente (somente T1/DIST)' => 'Envio do comando Powershell para o cliente (somente T1/DIST)',
        'Retorno do cliente que o comando foi executado com sucesso (somente T1/DIST)' => 'Retorno do cliente que o comando foi executado com sucesso (somente T1/DIST)'
      ],
      'checklistMicrosoft4' => [
        'Agendamento com o cliente para a melhor data (somente MOSP/EA)' => 'Agendamento com o cliente para a melhor data (somente MOSP/EA)',
        'Início da movimentação (somente MOSP/EA)' => 'Início da movimentação (somente MOSP/EA)',
        'Conclusão da movimentação (somente MOSP/EA)' => 'Conclusão da movimentação (somente MOSP/EA)'
      ],
      'checklistMicrosoft5' => [
        'Solicitar ao parceiro/cliente um usuário no modelo tdsynnex@dominiocliente.com.br (Somente MOSP/EA)' => 'Solicitar ao parceiro/cliente um usuário no modelo tdsynnex@dominiocliente.com.br (Somente MOSP/EA)',
        'Permissão do usuário como contribuidor na assinatura de origem e destino (Somente MOSP/EA)' => 'Permissão do usuário como contribuidor na assinatura de origem e destino (Somente MOSP/EA)',
        'Enviar todos os dados para o time de serviços dar inicio a movimentação (Somente MOSP/EA)' => 'Enviar todos os dados para o time de serviços dar inicio a movimentação (Somente MOSP/EA)',
        'Time de serviços realiza a pré-migração (Somente MOSP/EA)' => 'Time de serviços realiza a pré-migração (Somente MOSP/EA)',
        'Relatório de pré-migração enviado ao parceiro/cliente para aprovação final (Somente MOSP/EA)' => 'Relatório de pré-migração enviado ao parceiro/cliente para aprovação final (Somente MOSP/EA)'
      ],
      'checklistMicrosoft' => [
        'Parceiro/Cliente baixar o CSV para assessment (Somente MOSP/EA)' => 'Parceiro/Cliente baixar o CSV para assessment (Somente MOSP/EA)',
        'Enviar ao time de engenharia os relatórios para assessment (Somente MOSP/EA)' => 'Enviar ao time de engenharia os relatórios para assessment (Somente MOSP/EA)',
        'Devolução para o parceiro com resultado do assessment (Somente MOSP/EA)' => 'Devolução para o parceiro com resultado do assessment (Somente MOSP/EA)'
      ]
    ],
    'labels' => [
      'Create Migrations' => 'Create Migration',
      'Schedule Migrations' => 'Migration Schedule',
      'Log Migrations' => 'Migration Log',
      'Set Held' => 'Set Held',
      'Set Not Held' => 'Set Not Held'
    ],
    'massActions' => [
      'setHeld' => 'Set Held',
      'setNotHeld' => 'Set Not Held'
    ],
    'presetFilters' => [
      'planned' => 'Planned',
      'held' => 'Held',
      'todays' => 'Today\'s'
    ],
    'tooltips' => [
      'checklistConsumo' => 'Acompanhamento de consumo pós migração.',
      'checklistMicrosoft1' => 'Oportunidade criada pelo time de vendas.',
      'checklistMicrosoft2' => 'Início do processo pré-migração.',
      'checklistMicrosoft3' => 'Abertura pelo AM para o time de SSCLOUD para migrações de T1/DIST.',
      'checklistMicrosoft4' => 'Após aprovação do cliente e todos os pré-requisitos de migração inicia-se a migração de fato.',
      'checklistMicrosoft5' => 'Início do processo pré-migração.',
      'checklistMicrosoft' => 'Oportunidade criada pelo time de vendas.'
    ]
  ],
  'Notifications' => [
    'fields' => [
      'type' => 'Tipo',
      'language' => 'Idioma',
      'banner' => 'Banner'
    ],
    'links' => [],
    'labels' => [
      'Create Notifications' => 'Create Notification'
    ],
    'options' => [
      'type' => [
        'Information' => 'Information',
        'Notification' => 'Notification',
        '' => ''
      ],
      'language' => [
        '' => '',
        'Português' => 'Português',
        'Espanhol' => 'Espanhol',
        'Español' => 'Español'
      ]
    ]
  ],
  'NurturingForm' => [
    'fields' => [
      'formID' => 'ID do Form',
      'formData' => 'Resultados do Form',
      'nurturingPrefix' => 'Prefixo da instância',
      'nurturingCountry' => 'País da instância',
      'pushContactToIntegration' => 'Enviar leads para integração',
      'formSource' => 'Origem do formulário'
    ],
    'links' => [],
    'labels' => [
      'Create NurturingForm' => 'Criar Nurturing Form'
    ],
    'tooltips' => [
      'formID' => 'ID do form o qual deseja buscar os resultados. Apenas o número que pode ser visualizado na URL da instância após clicar no formulário.',
      'nurturingPrefix' => 'Prefixo utilizado no banco de dados da instância. Normalmente é composto de 3 caracteres seguidos da _. Ex: abc_
Em caso de dúvidas, consulte equipe técnica.',
      'pushContactToIntegration' => 'Ao marcar este campo, os resultados deste formulário serão adicionados à entidade de Leads. Atenção: caso o lead já exista no CDP, os dados serão atualizados COM EXCEÇÃO DA ORIGEM.',
      'formSource' => 'Nome da campanha da qual este formulário faz parte. É utilizado internamente para análise de performance e resultados das oportunidades geradas.'
    ],
    'options' => [
      'nurturingCountry' => [
        'Selecione' => 'Selecione',
        'Argentina' => 'westconarg',
        'Brasil' => 'westconbra',
        'CCA' => 'westconcca',
        'Colômbia' => 'westconcol',
        'Chile' => 'westconchi',
        'Equador' => 'westconecu',
        'México' => 'westconmex',
        'Peru' => 'westconpex',
        'westconarg' => 'Argentina',
        'westconbra' => 'Brasil',
        'westconcca' => 'CCA',
        'westconcol' => 'Colômbia',
        'westconchi' => 'Chile',
        'westconecu' => 'Ecuador',
        'westconmex' => 'México',
        'westconper' => 'Peru'
      ]
    ]
  ],
  'OpportunityAWS' => [
    'fields' => [
      'opportunityID' => 'Opportunity ID',
      'aWSAccountID' => 'AWS Account ID',
      'stageAWS' => 'Stage AWS',
      'statusAWS' => 'Status AWS',
      'partnerTypeAWS' => 'Partner Type',
      'useCase' => 'Use Case',
      'segment' => 'Segment',
      'estimatedRevenue' => 'estimated Monthly Recurring Revenue',
      'estimatedRevenueCurrency' => 'estimated Monthly Recurring Revenue (Moneda)',
      'estimatedRevenueConverted' => 'estimated Monthly Recurring Revenue (Convertido)',
      'marketplace' => 'Marketplace',
      'sPMSID' => 'SPMS ID',
      'opportunity' => 'Opportunity'
    ],
    'links' => [
      'opportunity' => 'Opportunity'
    ],
    'labels' => [
      'Create OpportunityAWS' => 'Create Opportunity AWS'
    ],
    'options' => [
      'stageAWS' => [
        '' => '',
        'Committed' => 'Committed',
        'Qualified' => 'Qualified',
        'Prospect' => 'Prospect',
        'Technical Validation' => 'Technical Validation',
        'Business Validation' => 'Business Validation',
        'Closed Lost' => 'Closed Lost',
        'Canceled' => 'Canceled',
        'Launched' => 'Launched',
        'Completed' => 'Completed'
      ],
      'statusAWS' => [
        '' => '',
        'Approved' => 'Approved',
        'Submitted' => 'Submitted',
        'Action Required' => 'Action Required',
        'Rejected' => 'Rejected'
      ],
      'partnerTypeAWS' => [
        '' => '',
        'ISV' => 'ISV',
        'Consulting' => 'Consulting'
      ],
      'useCase' => [
        '' => '',
        'AI/Machine Learning' => 'AI/Machine Learning',
        'Archiving' => 'Archiving',
        'Big Data' => 'Big Data',
        'Business Applications' => 'Business Applications',
        'Cloud Management Tools & DevOps' => 'Cloud Management Tools & DevOps',
        'Containers & Serverless' => 'Containers & Serverless',
        'Database' => 'Database',
        'End User Computing' => 'End User Computing',
        'Energy' => 'Energy',
        'Financial Services' => 'Financial Services',
        'Healthcare & Life Sciences' => 'Healthcare & Life Sciences',
        'Hybrid application platform' => 'Hybrid application platform',
        'Industrial Software' => 'Industrial Software',
        'IOT' => 'IOT',
        'Media & High performance computing (HPC)' => 'Media & High performance computing (HPC)',
        'Migration' => 'Migration',
        'Monitoring, logging and performance' => 'Monitoring, logging and performance',
        'Networking' => 'Networking',
        'Security' => 'Security',
        'Storage' => 'Storage',
        'Training' => 'Training',
        'Web development & DevOps' => 'Web development & DevOps'
      ],
      'segment' => [
        '' => '',
        'AGS' => 'AGS',
        'CS' => 'CS',
        'PS' => 'PS',
        'SUP' => 'SUP'
      ]
    ]
  ],
  'OpportunityGoogle' => [
    'fields' => [
      'nDealRegistration' => 'N° Deal Registration (Si aplica)',
      'categoryGoogle' => 'Category Google',
      'rebates' => 'Rebates',
      'customerSolution' => 'Necesidad/proyecto que tiene el cliente',
      'decisionMakingAuthority' => 'Autoridad para la toma de decisión',
      'clientbudget' => 'Presupuesto con el que cuenta el cliente (Budget)',
      'dR' => 'DR',
      'backend' => 'Backend',
      'googleCalculator' => 'Link de calculadora de Google',
      'amountproxconsumo' => 'Monto Aproximado de Consumo anual',
      'submissionID' => 'Submission ID',
      'opportunity' => 'Opportunity',
      'nameProject' => 'Nombre del Proyecto'
    ],
    'links' => [
      'opportunity' => 'Opportunity'
    ],
    'labels' => [
      'Create OpportunityGoogle' => 'Create Opportunity Google'
    ],
    'options' => [
      'categoryGoogle' => [
        '' => '',
        'Google Workspace' => 'Google Workspace',
        'Google Cloud Platform' => 'Google Cloud Platform'
      ]
    ]
  ],
  'Orders' => [
    'fields' => [
      'billingCycle' => 'BillingCycle',
      'contractIdExternal' => 'ContractIdExternal',
      'contractType' => 'ContractType',
      'directbilling' => 'Directbilling',
      'discountPricingRules' => 'DiscountPricingRules',
      'discountPricingRulesCurrency' => 'DiscountPricingRules (Currency)',
      'discountPricingRulesConverted' => 'DiscountPricingRules (Converted)',
      'listPrice' => 'ListPrice',
      'listPriceCurrency' => 'ListPrice (Currency)',
      'listPriceConverted' => 'ListPrice (Converted)',
      'markupPricingRules' => 'MarkupPricingRules',
      'pricingType' => 'PricingType',
      'status' => 'Status',
      'subscriptionID' => 'SubscriptionID',
      'subscriptionName' => 'SubscriptionName',
      'subscriptionQuantity' => 'SubscriptionQuantity',
      'subscriptionAmount' => 'SubscriptionAmount',
      'subscriptionAmountCurrency' => 'SubscriptionAmount (Currency)',
      'subscriptionAmountConverted' => 'SubscriptionAmount (Converted)',
      'orderAmount' => 'OrderAmount',
      'orderAmountCurrency' => 'OrderAmount (Currency)',
      'orderAmountConverted' => 'OrderAmount (Converted)',
      'subscriptionAutomaticRenew' => 'SubscriptionAutomaticRenew',
      'endUserAmount' => 'EndUserAmount',
      'endUserAmountCurrency' => 'EndUserAmount (Currency)',
      'endUserAmountConverted' => 'EndUserAmount (Converted)',
      'orderDiscountOnly' => 'OrderDiscountOnly',
      'cancellationAllowedUntilDate' => 'CancellationAllowedUntilDate',
      'termDuration' => 'TermDuration',
      'assignedUserNameExternal' => 'AssignedUserNameExternal',
      'productName' => 'ProductName',
      'accountName' => 'AccountName',
      'vendorAccountName' => 'VendorAccountName',
      'pricingInfo' => 'PricingInfo',
      'estimate' => 'Estimate',
      'processQueue' => 'ProcessQueue',
      'contractStartDate' => 'ContractStartDate',
      'contractEndDate' => 'ContractEndDate',
      'region' => 'Region',
      'externalId' => 'ExternalId'
    ],
    'links' => [],
    'labels' => [
      'Create Orders' => 'Create Orders'
    ],
    'options' => [
      'status' => [],
      'processQueue' => [],
      'region' => []
    ]
  ],
  'PBGeral' => [
    'fields' => [
      'account' => 'Account',
      'trilhaCloud' => 'Trilha Cloud',
      'trilhaIOT' => 'Trilha IOT',
      'trilhaSegurana' => 'Trilha Segurança',
      'technologyStatus' => 'Technology Status',
      'analyticStatus' => 'Analytic Status',
      'financialStatus' => 'Financial Status',
      'marketingStatus' => 'Marketing Status',
      'strategyStatus' => 'Strategy Status',
      'country' => 'País',
      'financialStatusCloud' => 'Financial Status Cloud',
      'organizationalStatusCloud' => 'Organizational Status Cloud',
      'salesAndMarketingStatusCloud' => 'Sales And Marketing Status Cloud',
      'strategyStatusCloud' => 'Strategy Status Cloud',
      'technologystatusCloud' => 'Technology Status Cloud',
      'cloudCategory' => 'Categoria Cloud',
      'module' => 'Módulo',
      'percepiumID' => 'Percepium ID',
      'percepiumStatus' => 'Percepium Status',
      'cybersolvsStatus' => 'Cybersolvs Status',
      'networksStatus' => 'Networks Status',
      'endpointStatus' => 'Endpoint Status',
      'mobilesecStatus' => 'Mobilesec Status',
      'dataStatus' => 'Data Status',
      'peopleStatus' => 'People Status',
      'securityStatus' => 'Security Status',
      'cloudStatus' => 'Cloud Status',
      'fraudStatus' => 'Fraud Status',
      'assesmentStatus' => 'Assesment Status',
      'complianceStatus' => 'Compliance Status',
      'policyStatus' => 'Policy Status',
      'trilhaDataAI' => 'Trilha Data AI',
      'dataAICategory' => 'Data AI Category'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create PBGeral' => 'Crear Practice Builder High Growth - Lista'
    ],
    'options' => [
      'technologyStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'analyticStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'financialStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'marketingStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'strategyStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'financialStatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'organizationalStatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'salesAndMarketingStatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'strategyStatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'technologystatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'cloudCategory' => [
        '' => '',
        'Starter' => 'Starter',
        'Transformer' => 'Transformer',
        'Accelerator' => 'Accelerator',
        'AWS Onboard the Practice' => 'AWS Onboard the Practice',
        'AWS Startups' => 'AWS Startups',
        'MCPP Transition Path' => 'MCPP Transition Path',
        'Google Cloud Practice Startups' => 'Google Cloud Practice Startups',
        'Google Workspace' => 'Google Workspace',
        'Grow Your HPE GreenLake Practice' => 'Grow Your HPE GreenLake Practice',
        'Develop Your Security Practice' => 'Develop Your Security Practice',
        'Grow Your Security Sales' => 'Grow Your Security Sales'
      ],
      'module' => [
        '' => '',
        'Cloud Practice Builder' => 'Cloud Practice Builder',
        'AWS' => 'AWS',
        'Microsoft' => 'Microsoft',
        'Google' => 'Google',
        'HPE Greenlake' => 'HPE Greenlake',
        'Security' => 'Security'
      ],
      'percepiumStatus' => [
        '' => '',
        'Started' => 'Started',
        'Finished' => 'Finished'
      ],
      'cybersolvsStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'networksStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'endpointStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'mobilesecStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'dataStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'peopleStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'securityStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'cloudStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'fraudStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'assesmentStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'complianceStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'policyStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'dataAICategory' => [
        '' => '',
        'Aware' => 'Aware',
        'Ready' => 'Ready',
        'Expert' => 'Expert'
      ]
    ]
  ],
  'PartnerID' => [
    'fields' => [
      'account' => 'Conta',
      'productBrand' => 'Vendor',
      'surestep' => 'Surestep',
      'surestepLevel' => 'Surestep Level',
      'billing' => 'Billing',
      'name' => 'MPN ID',
      'cloudConsumptions' => 'Cloud Consumptions',
      'salesOrders' => 'Sales Orders',
      'type' => 'Tipo',
      'partnerPrograms' => 'Programas de parceiro',
      'partnerProgram' => 'Programa de parceiro',
      'idType' => 'Tipo de ID',
      'source' => 'Source'
    ],
    'links' => [
      'account' => 'Conta',
      'productBrand' => 'Vendor',
      'surestep' => 'Surestep',
      'cloudConsumptions' => 'Cloud Consumptions',
      'salesOrders' => 'Sales Orders',
      'partnerPrograms' => 'Programas de parceiro',
      'partnerProgram' => 'Programa de parceiro'
    ],
    'labels' => [
      'Create PartnerID' => 'Create Partner ID'
    ],
    'options' => [
      'billing' => [
        'Azure' => 'Azure',
        'Office' => 'Office',
        'Cisco' => 'Cisco',
        'AWS' => 'AWS'
      ],
      'type' => [
        'Customer' => 'Customer',
        'Reseller' => 'Reseller',
        'ISVs' => 'ISVs',
        'Service Provider' => 'Service Provider'
      ],
      'idType' => [
        '' => '',
        'MPN ID' => 'MPN ID',
        'Tier 2 MPN ID' => 'Tier 2 MPN ID',
        'Tenant' => 'Tenant',
        'Organization' => 'Organization',
        'Unit Organization' => 'Unit Organization',
        'Account ID' => 'Account ID'
      ],
      'source' => [
        'CIS' => 'CIS',
        'Cloudsolv' => 'Cloudsolv',
        'Microsoft_Partner_Center' => 'Microsoft_Partner_Center',
        '' => ''
      ]
    ]
  ],
  'PartnerProgram' => [
    'fields' => [
      'productBrand' => 'Partner Product Brand',
      'partnerIDs' => 'Partner ID',
      'account' => 'Account'
    ],
    'links' => [
      'productBrand' => 'Partner Product Brand',
      'partnerIDs' => 'Partner ID',
      'account' => 'Account'
    ],
    'labels' => [
      'Create PartnerProgram' => 'Create Partner Program'
    ]
  ],
  'PartnersGoogleCloud' => [
    'fields' => [
      'partnerLevel' => 'Level',
      'account' => 'Account',
      'partner' => 'Partner',
      'partnersGoogleClouds' => 'Partners Google Clouds',
      'googleClouds' => 'Google Clouds',
      'email' => 'Email',
      'fechaefectivaHandshake' => 'Handshake Effective Date',
      'lineaDeCredito' => 'Credit line',
      'opportunities' => 'Opportunities',
      'partnerGoogleCloud' => 'Partner Google Cloud',
      'contact' => 'Contact',
      'opportunity' => 'Opportunity',
      'contacts' => 'Contacts',
      'progresoGoogle' => 'Progreso Google',
      'progresoTDSYNNEX' => 'Progress TD SYNNEX',
      'emailContact' => 'Contact Email',
      'emailPartner' => 'Partner email',
      'documentsSends' => 'Sent documents',
      'opportunitys' => 'Opportunity',
      'accounts' => 'Accouns',
      'accountS' => 'Accounts',
      'expertise' => 'Expertise',
      'sector' => 'Sector',
      'cloudID' => 'Cloud ID',
      'formGCP' => 'Form - GCP',
      'formWorkspace' => 'Form - Workspace',
      'dadoDeAltaConTDSYNNEX' => 'Discharged with TD SYNNEX',
      'gws' => 'Google Workspace',
      'gcp' => 'Google Cloud Platform',
      'gcpLevel' => 'Google Cloud Platform - Level',
      'gwsLevel' => 'Google Workspace - Level',
      'countryAccount' => 'Pais',
      'region' => 'Region',
      'phoneContact' => 'Telefono del Contacto'
    ],
    'links' => [
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks',
      'account' => 'Account',
      'partner' => 'Partner',
      'partnersGoogleClouds' => 'Partners Google Clouds',
      'googleClouds' => 'Google Clouds',
      'opportunities' => 'Opportunities',
      'partnerGoogleCloud' => 'Partner Google Cloud',
      'contact' => 'Contact',
      'opportunity' => 'Opportunity',
      'contacts' => 'Contacts',
      'opportunitys' => 'Opportunity',
      'accounts' => 'Accounts',
      'accountS' => 'Accounts'
    ],
    'labels' => [
      'Create PartnersGoogleCloud' => 'Crear Partner Program - Lista'
    ],
    'options' => [
      'partnerLevel' => [
        'Member' => 'Member',
        'Partner' => 'Partner',
        'Premier Partner' => 'Premier Partner',
        'Onboarding' => 'Onboarding'
      ],
      'progresoGoogle' => [
        'Primer  Contacto' => 'First contact',
        'Primera  Reunión' => 'First meeting',
        'Proceso Enviado Onboarding' => 'Process Sent Onboarding',
        'ID Cloud Enviado' => 'Cloud ID Sent',
        'Listo Handshake' => 'Ready handshake'
      ],
      'progresoTDSYNNEX' => [
        'Documentos Enviados' => 'Documentos Enviados',
        'Linea  Credito' => 'Credit Line',
        'Streamone Google' => 'Streamone Google',
        'CloudSolv' => 'CloudSolv',
        'GWS' => 'GWS',
        'GCP' => 'GCP',
        'Dado de Alta con TDSYNNEX' => 'Dado de Alta con TDSYNNEX',
        'Dado de Alta con TD SYNNEX' => 'Dado de Alta con TD SYNNEX'
      ],
      'expertise' => [
        '' => '',
        'Application Modernization' => 'Application Modernization',
        'Artificial Intelligence' => 'Artificial Intelligence',
        'Data Management' => 'Data Management',
        'Infraestructure Modernization' => 'Infraestructure Modernization',
        'Productivity & Collaboration' => 'Productivity & Collaboration',
        'Security' => 'Security',
        'Smart Analytics' => 'Smart Analytics'
      ],
      'sector' => [
        '' => '',
        'SMB' => 'SMB',
        'Corporate' => 'Corporate',
        'Enterprise' => 'Enterprise',
        'Public Sector ' => 'Public Sector ',
        'Education' => 'Education'
      ],
      'dadoDeAltaConTDSYNNEX' => [
        'Dado de Alta con TD SYNNEX' => 'Dado de Alta con TD SYNNEX',
        'Si ' => 'Si ',
        ' ' => ' Si'
      ],
      'gcpLevel' => [
        'Onboarding' => 'Onboarding',
        'Member' => 'Member',
        'Partner' => 'Partner',
        'Premier Partner' => 'Premier Partner',
        '' => ''
      ],
      'gwsLevel' => [
        'Onboarding' => 'Onboarding',
        'Member' => 'Member',
        'Partner' => 'Partner',
        'Premier Partner' => 'Premier Partner',
        '' => ''
      ]
    ]
  ],
  'PatchNotes' => [
    'fields' => [
      'releasedate' => 'Release Date',
      'version' => 'Version',
      'updatetype' => 'Update Type',
      'updatestatus' => 'Update Status'
    ],
    'links' => [],
    'labels' => [
      'Create PatchNotes' => 'Create Patch Notes'
    ],
    'tooltips' => [
      'releasedate' => 'Indicate when the update will be available.',
      'version' => 'For example, v1.0.1, v2.3, etc.'
    ],
    'options' => [
      'updatetype' => [
        '' => '',
        'New Feature' => 'New Feature',
        'Improvements' => 'Improvements',
        'Bug Fixes' => 'Bug Fixes',
        'Minor Changes' => 'Minor Changes'
      ],
      'updatestatus' => [
        '' => '',
        'Planned' => 'Planned',
        'In Progress' => 'In Progress',
        'Released' => 'Released'
      ]
    ]
  ],
  'Platformaccess' => [
    'fields' => [
      'link' => 'Link'
    ],
    'links' => [],
    'labels' => [
      'Create Platformaccess' => 'Create Platformaccess'
    ]
  ],
  'Portfolio' => [
    'fields' => [
      'target' => 'Target',
      'url' => 'URL'
    ],
    'links' => [],
    'labels' => [
      'Create Portfolio' => 'Criar Portfolio (Calculadora)'
    ]
  ],
  'Progama' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Progama' => 'Create Program'
    ]
  ],
  'Program' => [
    'fields' => [
      'nivel' => 'Nivel',
      'productBrand' => 'Fabricante',
      'account' => 'Conta'
    ],
    'links' => [
      'productBrand' => 'Product Brand',
      'account' => 'Conta'
    ],
    'labels' => [
      'Create Program' => 'Create Program'
    ],
    'options' => [
      'nivel' => [
        'Transformer ' => 'Transformer',
        'Starter ' => 'Starter'
      ]
    ]
  ],
  'ProgramaCloudPracticeBuilder' => [
    'fields' => [],
    'links' => [
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks'
    ],
    'labels' => [
      'Create ProgramaCloudPracticeBuilder' => 'Create Programa - Cloud Practice Builder'
    ]
  ],
  'ProgramaGoogleCloud' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create ProgramaGoogleCloud' => 'Create Programa - Google Cloud'
    ]
  ],
  'Renewals' => [
    'fields' => [
      'account' => 'Account',
      'hasRenewals' => 'has Renewals',
      'renewalsAutoOff30Days' => 'No. of Auto-Renew OFF - Next 30 days',
      'renewalsAutoOff60Days' => 'No. of Auto-Renew OFF - From 31 to 60 days',
      'renewalsAutoOff90Days' => 'No. of Auto-Renew OFF - From 61 to 90 days',
      'renewalsEndCustomers30Days' => 'No. of End Customers - Next 30 days',
      'renewalsEndCustomers60Days' => 'No. of End Customers - From 31 to 60 days',
      'renewalsEndCustomers90Days' => 'No. of End Customers - From 61 to 90 days',
      'renewalsLicenses30Days' => 'No. of Licenses - Next 30 days',
      'renewalsLicenses60Days' => 'No. of Licenses - From 31 to 60 days',
      'renewalsLicenses90Days' => 'No. of Licenses - From 61 to 90 days',
      'renewalsRecommendations90Days' => 'No. of Microsoft Recommendations - Next 90 days',
      'renewalsRecommendationsCopilot90Days' => 'No. of Copilot for M365 Recommendations - Next 90 days',
      'renewalsReservedInstances90Days' => 'No. of Reserved Instances - Next 90 days',
      'renewals90Days' => 'Total Renewals - Next 90 Days',
      'accountRenewals' => 'Conta (Renewals)',
      'accountType' => 'Tipo'
    ],
    'links' => [
      'account' => 'Account',
      'accountRenewals' => 'Conta (Renewals)'
    ],
    'labels' => [
      'Create Renewals' => 'Create Renewal'
    ]
  ],
  'ResultadosFormulariosGoogle' => [
    'fields' => [],
    'links' => [
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks'
    ],
    'labels' => [
      'Create ResultadosFormulariosGoogle' => 'Create Resultados Formularios Google'
    ]
  ],
  'RocketMargins' => [
    'fields' => [],
    'links' => [
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks'
    ],
    'labels' => [
      'Create RocketMargins' => 'Create Margens Rocket'
    ]
  ],
  'Source' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Source' => 'Create Source'
    ]
  ],
  'Sources' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Sources' => 'Create Sources'
    ]
  ],
  'Surestep' => [
    'fields' => [
      'newPartner' => 'New Partner to Activate',
      'activateToInspire' => 'Activate to Inspire',
      'inspireToSkyrocketNominee' => 'Inspire to Skyrocket Nominee',
      'skyrocketNomineeToSkyrocket' => 'Skyrocket Nominee to Skyrocket',
      'account' => 'Account',
      'country' => 'Pais',
      'readyToInspire' => 'Ready to Inspire',
      'readyToSkyrocketNominee' => 'Ready to Skyrocket Nominee',
      'readyToSkyrocket' => 'Ready to Skyrocket',
      'readyToActivate' => 'Ready to Activate',
      'surestepLevel' => 'Surestep Level',
      'partnerID' => 'Partner ID',
      'partnerIDs' => 'Partner IDs',
      'mpnNumber' => 'MPN ID Number',
      'accountNumber' => 'Account Number',
      'lead' => 'Lead',
      'levelVerification' => 'LevelVerification',
      'consumptionDate' => 'Consumption Date',
      'cPB' => 'CPB',
      'account1' => 'Account1',
      'countrySurestep' => 'Country - Surestep'
    ],
    'links' => [
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'tasks' => 'Tasks',
      'account' => 'Account',
      'partnerID' => 'Partner ID',
      'partnerIDs' => 'Partner IDs',
      'lead' => 'Lead',
      'cPB' => 'CPB',
      'account1' => 'Account1'
    ],
    'labels' => [
      'Create Surestep' => 'Crear Partner Program - Lista'
    ],
    'options' => [
      'newPartner' => [
        'Contact Form Completed' => 'Contact Form Completed',
        '1:1 Meeting with Surestep Ambassador' => '1:1 Meeting with Surestep Ambassador',
        'Skill Mapping (Assessment)' => 'Skill Mapping (Assessment)'
      ],
      'activateToInspire' => [
        'TD / SYNNEX Account Number' => 'TD / SYNNEX Account Number',
        'MPN ID' => 'MPN ID',
        'Partner Center Complete Training' => 'Partner Center Complete Training',
        'One Consumption (Last 3 Months)' => 'One Consumption (Last 3 Months)',
        'One Fundamental Certification' => 'One Fundamental Certification',
        '1Q Business Plan Approval and Execution' => '1Q Business Plan Approval and Execution'
      ],
      'inspireToSkyrocketNominee' => [
        'Action Pack Acquisition' => 'Action Pack Acquisition',
        'Silver or Gold Competency' => 'Silver or Gold Competency',
        'Recurrent Consumption (Last Quarter)' => 'Recurrent Consumption (Last Quarter)',
        '1H Business Plan Approval and Execution' => '1H Business Plan Approval and Execution'
      ],
      'skyrocketNomineeToSkyrocket' => [
        'Approval and Nomination (Microsoft Team)' => 'Approval and Nomination (Microsoft Team)',
        'Approval' => 'Approval',
        'Nomination' => 'Nomination'
      ],
      'surestepLevel' => [
        'New Partner' => 'New Partner',
        'Activate' => 'Activate',
        'Inspire' => 'Inspire',
        'SKR' => 'SKR',
        'TopSKR' => 'TopSKR',
        '' => '',
        'In Process' => 'In Process to Activate'
      ],
      'levelVerification' => [
        'New Partner' => 'New Partner',
        'Activate' => 'Activate',
        'Inspire' => 'Inspire',
        'SKR' => 'SKR',
        'TopSKR' => 'TopSKR'
      ],
      'countrySurestep' => []
    ],
    'tooltips' => [
      'readyToActivate' => 'Please, confirm to follow to the next step. You won\'t be able to revert this action after saving, if you don\'t want to go to the next step, please cancel.',
      'readyToInspire' => 'Please, confirm to follow to the next step. You won\'t be able to revert this action after saving, if you don\'t want to go to the next step, please cancel.',
      'readyToSkyrocket' => 'Please, confirm to end the Surestep Process. You won\'t be able to revert this action after saving, if you don\'t want to go to the next step, please cancel.',
      'readyToSkyrocketNominee' => 'Please, confirm to follow to the next step. You won\'t be able to revert this action after saving, if you don\'t want to go to the next step, please cancel.'
    ]
  ],
  'TechnicalSupport' => [
    'fields' => [
      'opportunities' => 'Opportunities'
    ],
    'links' => [
      'opportunities' => 'Opportunities'
    ],
    'labels' => [
      'Create TechnicalSupport' => 'Create TechnicalSupport'
    ]
  ],
  'TourContent' => [
    'fields' => [
      'content' => 'Content',
      'entity' => 'Entity',
      'language' => 'Language',
      'selector' => 'Selector',
      'step' => 'Step',
      'title' => 'Title'
    ],
    'links' => [],
    'labels' => [
      'Create TourContent' => 'Create TourContent'
    ],
    'options' => [
      'language' => [
        'en_US' => 'en_US',
        'pt_BR' => 'pt_BR',
        'es_MX' => 'es_MX',
        'select' => 'Select'
      ]
    ]
  ],
  'VendorAccount' => [
    'fields' => [
      'partnershipType' => 'PartnershipType',
      'productBrand' => 'Product Brand',
      'account' => 'Account',
      'source' => 'Source'
    ],
    'links' => [
      'productBrand' => 'Product Brand',
      'account' => 'Account'
    ],
    'labels' => [
      'Create VendorAccount' => 'Create VendorAccount'
    ],
    'options' => [
      'partnershipType' => [
        'Distributor' => 'Distributor',
        'Reseller' => 'Reseller',
        'Customer' => 'Customer'
      ],
      'source' => [
        'CIS' => 'CIS',
        'Cloudsolv' => 'Cloudsolv',
        'Microsoft_Partner_Center' => 'Microsoft_Partner_Center',
        '' => ''
      ]
    ]
  ],
  'VendorCloudConsumption' => [
    'fields' => [
      'productBrands' => 'Product Brands',
      'category' => 'Category',
      'region' => 'Region',
      'resellerName' => 'Partner',
      'usageperiod' => 'Billing Period',
      'subscriptionId' => 'SubscriptionId',
      'cost' => 'Cost',
      'costCurrency' => 'Cost (Currency)',
      'costConverted' => 'Cost (Converted)',
      'price' => 'Price',
      'priceCurrency' => 'Price (Currency)',
      'priceConverted' => 'Price (Converted)',
      'lastDay1' => 'D-1',
      'lastDay2' => 'D-2',
      'lastDay3' => 'D-3',
      'alertLevel' => 'Alert Level',
      'budgetAlert' => 'Budget Alert',
      'forecast' => 'Forecast',
      'forecastCurrency' => 'Forecast (Currency)',
      'forecastConverted' => 'Forecast (Converted)',
      'endCustomer' => 'End Customer',
      'lastUpdated' => 'Last Updated',
      'description' => 'Updated at:',
      'rocketURL' => 'Rocket',
      'salesOrder' => 'Sales Order',
      'top10' => 'Top 10',
      'customerId' => 'CustomerId',
      'country' => 'Country',
      'billingPeriodConverted' => 'BillingPeriodConverted',
      'resellerId' => 'ResellerId',
      'usage' => 'Usage (Quantity)',
      'invoiceId' => 'InvoiceId',
      'vendorSubscription' => 'Vendor Subscription',
      'partnerName' => 'Partner Name',
      'partnerId' => 'PartnerId',
      'lastUpdate' => 'Last Update'
    ],
    'links' => [
      'productBrands' => 'Product Brands',
      'salesOrder' => 'Sales Order',
      'vendorSubscription' => 'Vendor Subscription'
    ],
    'labels' => [
      'Create VendorCloudConsumption' => 'Create Cloud Consumption Revenue'
    ],
    'options' => [
      'category' => [
        'AWS' => 'AWS',
        'GCP' => 'GCP',
        'AZURE' => 'AZURE',
        'LICENSE' => 'LICENSE',
        '' => '',
        'OFFICE' => 'NCE',
        'OFFICE-USAGE' => 'Legacy'
      ],
      'alertLevel' => [
        'None' => 'None',
        'Yellow' => 'Yellow',
        'Orange' => 'Orange',
        'Red' => 'Red'
      ],
      'country' => [
        'COL' => 'COL',
        'CCA' => 'CCA',
        'ECU' => 'ECU',
        'ARG' => 'ARG',
        'PER' => 'PER',
        'CHI' => 'CHI',
        'BRA' => 'BRA',
        '' => '',
        'MEX' => 'MEX'
      ]
    ]
  ],
  'VendorContract' => [
    'fields' => [
      'periodoImportado' => 'periodoImportado',
      'contratoMs' => 'contratoMs',
      'tipo' => 'tipo',
      'fornecedor' => 'fornecedor',
      'nomeFornecedor' => 'nomeFornecedor',
      'directBilling' => 'directBilling',
      'clienteFaturamento' => 'clienteFaturamento',
      'descricaoCliente' => 'descricaoCliente',
      'descricaoRevendedor' => 'descricaoRevendedor',
      'codItem' => 'codItem',
      'descricaoItem' => 'descricaoItem',
      'chargeType' => 'chargeType',
      'syndicationPartnerSubscriptionNumber' => 'syndicationPartnerSubscriptionNumber',
      'quantidade' => 'quantidade',
      'precoUnitario' => 'precoUnitario',
      'valorTotal' => 'valorTotal',
      'descContrato' => 'descContrato',
      'acresContrato' => 'acresContrato',
      'descRevenda' => 'descRevenda',
      'vlrPercentualComissao' => 'vlrPercentualComissao',
      'valorComissao' => 'valorComissao',
      'resellerUnitPrice' => 'resellerUnitPrice',
      'totalRV' => 'totalRV',
      'endUserUnitPrice' => 'endUserUnitPrice',
      'totalCF' => 'totalCF',
      'tblPreco' => 'tblPreco',
      'orderId' => 'orderId',
      'invoice' => 'invoice',
      'dataAprovManual' => 'dataAprovManual',
      'usuarioAprovManual' => 'usuarioAprovManual',
      'usuario' => 'usuario',
      'horaAprov' => 'horaAprov',
      'facturaVenta' => 'facturaVenta',
      'ordenCompra' => 'ordenCompra',
      'log' => 'log',
      'nfGerada' => 'nfGerada',
      'subCategoria' => 'subCategoria',
      'inicioCobranca' => 'InicioCobranca',
      'fimCobranca' => 'FimCobranca',
      'statusContrato' => 'StatusContrato',
      'paises' => 'Paises',
      'revendedor' => 'revendedor'
    ],
    'links' => [],
    'labels' => [
      'Create VendorContract' => 'Create VendorContract'
    ],
    'options' => [
      'statusContrato' => [
        'Faturado' => 'Faturado',
        'Crédito Vinculado' => 'Crédito Vinculado',
        'Não Validado' => 'Não Validado',
        'NF Devolvida' => 'NF Devolvida',
        'Validado' => 'Validado',
        '' => ''
      ],
      'paises' => [
        'TD SYNNEX CALA, INC' => 'TD SYNNEX CALA, INC',
        'TD SYNNEX CHILE LIMITADA' => 'TD SYNNEX CHILE LIMITADA',
        'TD SYNNEX COLOMBIA' => 'TD SYNNEX COLOMBIA',
        'TD SYNNEX ECUADOR CIA. LTDA.' => 'TD SYNNEX ECUADOR CIA. LTDA.',
        'TD SYNNEX PERU S.A.C.' => 'TD SYNNEX PERU S.A.C.',
        'WESTCON ARGENTINA' => 'WESTCON ARGENTINA'
      ]
    ]
  ],
  'VendorSubscription' => [
    'fields' => [
      'account' => 'Account',
      'vendorSubscriptionId' => 'VendorSubscriptionId',
      'status' => 'Status',
      'quantity' => 'Quantity',
      'offerId' => 'OfferId',
      'unitType' => 'UnitType',
      'hasPurchasableAddons' => 'HasPurchasableAddons',
      'creationDate' => 'CreationDate',
      'effectiveStartDate' => 'EffectiveStartDate',
      'commitmentEndDate' => 'CommitmentEndDate',
      'commitmentEndDateTime' => 'CommitmentEndDateTime',
      'cancellationAllowedUntilDate' => 'CancellationAllowedUntilDate',
      'billingCycleEndDate' => 'BillingCycleEndDate',
      'billingCycleEndDateTime' => 'BillingCycleEndDateTime',
      'autoRenewEnabled' => 'AutoRenewEnabled',
      'billingType' => 'BillingType',
      'billingCycle' => 'BillingCycle',
      'termDuration' => 'TermDuration',
      'renewalTermDuration' => 'RenewalTermDuration',
      'isMicrosoftProduct' => 'IsMicrosoftProduct',
      'partnerId' => 'PartnerId',
      'contractType' => 'ContractType',
      'orderId' => 'OrderId',
      'partnerName' => 'PartnerName',
      'vendorCloudConsumptions' => 'Vendor Cloud Consumptions',
      'publisherName' => 'PublisherName',
      'isTrial' => 'IsTrial',
      'country' => 'Country',
      'offerName' => 'OfferName',
      'externalIDcdp' => 'ExternalIDcdp'
    ],
    'links' => [
      'account' => 'Account',
      'vendorCloudConsumptions' => 'Vendor Cloud Consumptions'
    ],
    'labels' => [
      'Create VendorSubscription' => 'Create VendorSubscription'
    ],
    'options' => [
      'status' => [
        'active' => 'Active',
        'deleted' => 'Deleted',
        'suspended' => 'Suspended',
        'disabled' => 'Disabled',
        'expired' => 'Expired'
      ],
      'country' => [
        'UR' => 'UR',
        'MX' => 'MX',
        'BR' => 'BR',
        'CO' => 'CO',
        'PA' => 'PA',
        'AR' => 'AR',
        'EC' => 'EC',
        'CL' => 'CL',
        'PE' => 'PE',
        '' => ''
      ]
    ]
  ]
];
