var Swal;
Espo.loader.requirePromise('swal').then((sw)=> { Swal = sw });

define('custom:views/Account/edit', ['views/edit'], function (Dep) {
    return Dep.extend({
        setup: function () {
            Dep.prototype.setup.call(this);
        },
        afterRender: function () {
            var emailStatus = false
            var countryStatus = false
            var emailField = document.querySelector('.form-control.email-address')
            var countryField = document.querySelector('[data-name="country"]')



            emailField.addEventListener('blur', () => {
                emailStatus = true
                console.log('First Blur')
                if (emailStatus == true && countryStatus == true) {
                    this.accountDuplicatedModal()

                }
            })

            emailField.addEventListener('input', () => {
                // Reabilita o botão de salvar se estiver desabilitado
                if (document.querySelector('[data-action="save"]').hasAttribute("disabled")) {
                    document.querySelector('[data-action="save"]').removeAttribute("disabled");
                }
            })

            countryField.addEventListener('change', () => {
                countryStatus = true
                console.log('Second Blur')
                if (emailStatus == true && countryStatus == true) {
                    this.accountDuplicatedModal()
                }
            })

            countryField.addEventListener('input', () => {
                // Reabilita o botão de salvar se estiver desabilitado
                if (document.querySelector('[data-action="save"]').hasAttribute("disabled")) {
                    document.querySelector('[data-action="save"]').removeAttribute("disabled");
                }
            })
        },



        accountDuplicatedModal: function () {
            var emailField = document.querySelector('.form-control.email-address')
            var countryField = document.querySelector('[data-name="country"].form-control.main-element')
            console.log(countryField)
            var emailCheck = emailField !== null || emailField !== '' || emailField || undefined;
            var countryCheck = countryField !== null || countryField !== '' || countryField !== undefined;
            if (emailCheck && countryCheck) {
                var email = emailField.value
                var website = email.split('@')[1]
                var country = countryField.value
                this.makeHttpRequest(website, country).then(response => {
                    if (response.list.length > 0) {
                        console.log('Response list lenght > 0 ')
                        Swal.fire({
                            title: 'Atenção!',
                            html:
                                'O domínio inserido já está atribuído a uma Conta. <br> ' +
                                'Para evitar a criação de registros duplicados, por favor, utilize a Conta existente.',
                            icon: "info",
                            iconColor: '#007b78',
                            width: '36em',
                            showConfirmButton: true,
                            confirmButtonColor: '#007b78',
                            cancelButtonColor: '#ad4846',
                            confirmButtonText: 'Ok',
                            allowOutsideClick: false,
                            allowEscapeKey: false,
                            allowEnterKey: false,
                        }).then((res) => {
                            if (res.isConfirmed) {
                                document.querySelector('[data-action="save"]').setAttribute("disabled", "");
                            }
                        })
                    }
                })

            }

        },


        makeHttpRequest: async function (website, country) {
            const url = `api/v1/Account?select=name,country&maxSize=30&offset=0&orderBy=createdAt&order=desc&where[0][type]=startsWith&where[0][attribute]=website&where[0][value]=${website}&where[1][type]=in&where[1][attribute]=country&where[1][value][]=${country}`

            try {
                const response = await new Promise((resolve, reject) => {
                    const xhr = new XMLHttpRequest();

                    xhr.open('GET', url)
                    xhr.setRequestHeader("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=")
                    xhr.addEventListener('readystatechange', function () {
                        if (this.readyState == 4) {
                            resolve(xhr.responseText)
                            if (this.status == 200) {
                                resolve(xhr.responseText)
                            } else {
                                reject
                            }
                        }
                    })
                    xhr.send();
                })
                return JSON.parse(response)

            } catch (error) {
                console.log(error);
                throw error;
            }
        }
    });
});
