/*
 * This file is part of  the extension: Ebla Multiple Link Pro
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

define('ebla-link-pro:views/record/row-actions', 'views/record/row-actions/relationship', function (Dep) {

    return Dep.extend({

        data: function () {
            return _.extend(Dep.prototype.data.call(this), {modelId: this.model.id});
        },

        _getTemplateName: function () {
            if (this.options.mode === 'edit' && this.model.isNewItem) {
                return 'ebla-link-pro:record/row-actions';
            }

            return Dep.prototype._getTemplateName.call(this);
        },

        getActionList: function () {
            const actionsDef = this.options.actions || [];

            const list = [];

            if (actionsDef.includes('view')) {
                list.push({
                    action: 'quickView',
                    label: 'View',
                    data: {
                        id: this.model.id
                    },
                    link: '#' + this.model.name + '/view/' + this.model.id
                });
            }

            if (this.options.acl.edit && actionsDef.includes('edit')) {
                list.push({
                    action: 'quickEdit',
                    label: 'Edit',
                    data: {
                        id: this.model.id
                    },
                    link: '#' + this.model.name + '/edit/' + this.model.id
                });
            }
            if (!this.options.unlinkDisabled && actionsDef.includes('unlink')) {
                list.push({
                    action: 'unlinkRelated',
                    label: 'Unlink',
                    data: {
                        id: this.model.id
                    }
                });
            }

            const isManyToMany = this.getParentView()?.getParentView()?.getParentView()?.isManyToMany;
            if (isManyToMany !== true && this.options.acl.delete && actionsDef.includes('remove')) {
                list.push({
                    action: 'removeRelated',
                    label: 'Remove',
                    data: {
                        id: this.model.id
                    }
                });
            }
            return list;
        }
    });
});
