<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Tools\Project\Api;

use Espo\Core\Acl;
use Espo\Core\Api\Action;
use Espo\Core\Api\Request;
use Espo\Core\Api\Response;
use Espo\Core\Api\ResponseComposer;
use Espo\Core\Exceptions\BadRequest;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Exceptions\NotFound;
use Espo\Modules\Project\Entities\Project;
use Espo\Modules\Project\Tools\Project\GroupReorderService;
use Espo\ORM\EntityManager;

/**
 * @noinspection PhpUnused
 */
class PostReorderGroups implements Action
{
    public function __construct(
        private EntityManager $entityManager,
        private Acl $acl,
        private GroupReorderService $groupReorderService,
    ) {}

    public function process(Request $request): Response
    {
        $id = $request->getRouteParam('id') ?? new BadRequest();
        $ids = $request->getParsedBody()->ids ?? null;

        if (!is_array($ids)) {
            throw new BadRequest("Bad 'ids'.");
        }

        foreach ($ids as $itemId) {
            if (!is_string($itemId)) {
                throw new BadRequest("Bad 'ids'.");
            }
        }

        $project = $this->entityManager->getRDBRepositoryByClass(Project::class)->getById($id);

        if (!$project) {
            throw new NotFound();
        }

        if (!$this->acl->checkEntityEdit($project)) {
            throw new Forbidden("No 'edit' access.");
        }

        $this->groupReorderService->reorder($project, $ids);

        return ResponseComposer::json(true);
    }
}
