<?php
return [
  'aclDefs' => [
    'ActionHistoryRecord' => [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\ActionHistoryRecord\\OwnershipChecker'
    ],
    'Attachment' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Attachment\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Attachment\\OwnershipChecker',
      'portalAccessCheckerClassName' => 'Espo\\Classes\\AclPortal\\Attachment\\AccessChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Attachment\\OwnershipChecker'
    ],
    'AuthToken' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\AuthToken\\AccessChecker'
    ],
    'Email' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Email\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Email\\OwnershipChecker',
      'portalAccessCheckerClassName' => 'Espo\\Classes\\AclPortal\\Email\\AccessChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Email\\OwnershipChecker',
      'assignmentCheckerClassName' => 'Espo\\Classes\\Acl\\Email\\AssignmentChecker',
      'readOwnerUserField' => 'users',
      'linkCheckerClassNameMap' => [
        'parent' => 'Espo\\Classes\\Acl\\Email\\LinkCheckers\\ParentLinkChecker',
        'teams' => 'Espo\\Classes\\Acl\\Email\\LinkCheckers\\TeamsLinkChecker'
      ]
    ],
    'EmailFilter' => [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\EmailFilter\\OwnershipChecker'
    ],
    'Import' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Import\\AccessChecker'
    ],
    'ImportEml' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\ImportEml\\AccessChecker'
    ],
    'ImportError' => [
      'accessCheckerClassName' => 'Espo\\Core\\Acl\\AccessChecker\\AccessCheckers\\Foreign',
      'link' => 'import'
    ],
    'Note' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Note\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Note\\OwnershipChecker',
      'portalAccessCheckerClassName' => 'Espo\\Classes\\AclPortal\\Note\\AccessChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Note\\OwnershipChecker'
    ],
    'Notification' => [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Notification\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Notification\\OwnershipChecker'
    ],
    'Portal' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Portal\\AccessChecker'
    ],
    'ScheduledJob' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\ScheduledJob\\AccessChecker'
    ],
    'Team' => [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Team\\OwnershipChecker'
    ],
    'User' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\User\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\User\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\User\\OwnershipChecker'
    ],
    'Webhook' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Webhook\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Webhook\\OwnershipChecker'
    ],
    'WorkingTimeRange' => [
      'assignmentCheckerClassName' => 'Espo\\Classes\\Acl\\WorkingTimeRange\\AssignmentChecker'
    ],
    'Account' => [
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\Account\\OwnershipChecker'
    ],
    'Call' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Call\\AccessChecker',
      'assignmentCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Meeting\\AssignmentChecker',
      'readOwnerUserField' => 'users',
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'CampaignLogRecord' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\CampaignLogRecord\\OwnershipChecker'
    ],
    'CampaignTrackingUrl' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\CampaignTrackingUrl\\OwnershipChecker'
    ],
    'Case' => [
      'linkCheckerClassNameMap' => [
        'lead' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\LeadLinkChecker',
        'account' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\AccountLinkChecker',
        'contact' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\ContactLinkChecker',
        'contacts' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\ContactLinkChecker'
      ],
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\Case\\OwnershipChecker',
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Contact' => [
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\Contact\\OwnershipChecker',
      'accountLink' => 'accounts'
    ],
    'Document' => [
      'contactLink' => 'contacts',
      'accountLink' => 'accounts'
    ],
    'KnowledgeBaseArticle' => [
      'portalAccessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\KnowledgeBaseArticle\\AccessChecker'
    ],
    'MassEmail' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\MassEmail\\OwnershipChecker',
      'linkCheckerClassNameMap' => [
        'inboundEmail' => 'Espo\\Modules\\Crm\\Classes\\Acl\\MassEmail\\LinkCheckers\\InboundEmailLinkChecker'
      ],
      'accessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\MassEmail\\AccessChecker'
    ],
    'Meeting' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Meeting\\AccessChecker',
      'assignmentCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Meeting\\AssignmentChecker',
      'readOwnerUserField' => 'users',
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Opportunity' => [
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Task' => [
      'linkCheckerClassNameMap' => [
        'parent' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Task\\LinkCheckers\\ParentLinkChecker',
        'account' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Task\\LinkCheckers\\AccountLinkChecker'
      ],
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'BpmnFlowNode' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\Acl\\BpmnFlowNode\\AccessChecker'
    ],
    'BpmnProcess' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\Acl\\BpmnProcess\\OwnershipChecker'
    ],
    'Report' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\Acl\\Report\\AccessChecker',
      'portalAccessCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\AclPortal\\Report\\AccessChecker'
    ],
    'DeliveryOrder' => [
      'accountLink' => 'account'
    ],
    'DeliveryOrderItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'InventoryAdjustmentItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'InventoryNumber' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\InventoryNumber\\AccessChecker'
    ],
    'Invoice' => [
      'accountLink' => 'account'
    ],
    'InvoiceItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'OpportunityItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'PriceBook' => [
      'accountLink' => 'accounts',
      'contactLink' => NULL
    ],
    'PriceRule' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\PriceRule\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\PriceRule\\OwnershipChecker',
      'accessCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\PriceRule\\AccessChecker'
    ],
    'ProductPrice' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\ProductPrice\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\ProductPrice\\OwnershipChecker',
      'accessCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\ProductPrice\\AccessChecker'
    ],
    'PurchaseOrder' => [
      'accountLink' => 'account'
    ],
    'PurchaseOrderItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'Quote' => [
      'accountLink' => 'account'
    ],
    'QuoteItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'ReceiptOrder' => [
      'accountLink' => 'account'
    ],
    'ReceiptOrderItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'ReturnOrder' => [
      'accountLink' => 'account'
    ],
    'ReturnOrderItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'SalesOrder' => [
      'accountLink' => 'account'
    ],
    'SalesOrderItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'SupplierProductPrice' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\SupplierProductPrice\\OwnershipChecker'
    ],
    'TransferOrderItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'ServiceItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'Project' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Project\\Classes\\Acl\\Project\\AccessChecker',
      'linkCheckerClassNameMap' => [
        'members' => 'Espo\\Modules\\Project\\Classes\\Acl\\Project\\LinkCheckers\\Members'
      ]
    ],
    'ProjectColumn' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Project\\Classes\\Acl\\Common\\AccessCheckers\\Foreign',
      'link' => 'board'
    ],
    'ProjectGroup' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Project\\Classes\\Acl\\Common\\AccessCheckers\\Foreign',
      'link' => 'project'
    ],
    'ProjectTask' => [
      'linkCheckerClassNameMap' => [
        'owner' => 'Espo\\Modules\\Project\\Classes\\Acl\\ProjectTask\\LinkCheckers\\Owner'
      ],
      'accessCheckerClassName' => 'Espo\\Modules\\Project\\Classes\\Acl\\ProjectTask\\AccessChecker',
      'assignmentCheckerClassName' => 'Espo\\Modules\\Project\\Classes\\Acl\\ProjectTask\\AssignmentChecker'
    ],
    'AWS' => [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'AWSVersions' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'AccountVBM' => [
      'contactLink' => 'contact',
      'accountLink' => 'account'
    ],
    'Analytics' => [
      'contactLink' => 'contacts',
      'accountLink' => NULL
    ],
    'AssesmentCompany' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'BillingVendor' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'BucketTimer' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CAccountEndCustomer' => [
      'contactLink' => 'contacts',
      'accountLink' => NULL
    ],
    'CPB' => [
      'contactLink' => 'contact',
      'accountLink' => 'accounts'
    ],
    'CloudConsumption' => [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'Contract' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'ContractGoals' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Country' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'DSET' => [
      'contactLink' => 'contact',
      'accountLink' => 'account'
    ],
    'DashboardAccess' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'DataAnalyticsReport' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Distributor' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'DsetAws' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Earn' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'EmailContent' => [
      'contactLink' => NULL,
      'accountLink' => 'accounts'
    ],
    'ExternalFormPost' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'GooglePartnerAdvantage' => [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'Importer' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'IncentivesVendor' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'LeadsPartnerCenter' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Marketing' => [
      'contactLink' => 'contacts',
      'accountLink' => NULL
    ],
    'Messenger' => [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'Migrations' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Notifications' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'NurturingForm' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'OpportunityAWS' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'OpportunityGoogle' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Orders' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'PBGeral' => [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'PartnerID' => [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'PartnersGoogleCloud' => [
      'contactLink' => 'contact',
      'accountLink' => 'account'
    ],
    'PatchNotes' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Portfolio' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'PrizeRoulette' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Program' => [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'Renewals' => [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'RocketMargins' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Sources' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Surestep' => [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'TechnicalSupport' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'TourContent' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'VendorAccount' => [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'VendorCloudConsumption' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'VendorContract' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'VendorSubscription' => [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ]
  ],
  'app' => [
    'acl' => [
      'mandatory' => [
        'scopeLevel' => [
          'Note' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'Portal' => [
            'read' => 'all',
            'edit' => 'no',
            'delete' => 'no',
            'create' => 'no'
          ],
          'Attachment' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'EmailAccount' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'EmailFilter' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'EmailFolder' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'GroupEmailFolder' => [
            'read' => 'team',
            'edit' => 'no',
            'delete' => 'no',
            'create' => 'no'
          ],
          'Preferences' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'no',
            'create' => 'no'
          ],
          'Notification' => [
            'read' => 'own',
            'edit' => 'no',
            'delete' => 'own',
            'create' => 'no'
          ],
          'ActionHistoryRecord' => [
            'read' => 'own'
          ],
          'Role' => false,
          'PortalRole' => false,
          'ImportError' => 'Import',
          'ImportEml' => 'Import',
          'WorkingTimeRange' => 'WorkingTimeCalendar',
          'Stream' => true,
          'MassEmail' => 'Campaign',
          'CampaignLogRecord' => 'Campaign',
          'CampaignTrackingUrl' => 'Campaign',
          'EmailQueueItem' => 'Campaign',
          'Workflow' => false,
          'WorkflowLogRecord' => false,
          'ReportPanel' => false,
          'BpmnFlowNode' => 'BpmnProcess',
          'QuoteItem' => 'Quote',
          'SalesOrderItem' => 'SalesOrder',
          'InvoiceItem' => 'Invoice',
          'PurchaseOrderItem' => 'PurchaseOrder',
          'DeliveryOrderItem' => 'DeliveryOrder',
          'ReceiptOrderItem' => 'ReceiptOrder',
          'TransferOrderItem' => 'TransferOrder',
          'ReturnOrderItem' => 'ReturnOrder',
          'OpportunityItem' => 'Opportunity',
          'InventoryAdjustmentItem' => 'InventoryAdjustment',
          'ProductPrice' => 'PriceBook',
          'PriceRule' => 'PriceBook',
          'SupplierProductPrice' => 'Supplier',
          'ProductAttributeOption' => 'ProductAttribute',
          'ServiceItem' => 'Service',
          'ProjectGroup' => 'Project',
          'ProjectColumn' => 'ProjectBoard',
          'ProjectTask' => 'boolean:Project',
          'ProjectRole' => false,
          'DashboardSet1' => 'DashboardSet',
          'DashboardSet2' => 'DashboardSet',
          'DashboardSet3' => 'DashboardSet',
          'DashboardSet4' => 'DashboardSet',
          'DashboardSet5' => 'DashboardSet',
          'DashboardSet6' => 'DashboardSet',
          'DashboardSet7' => 'DashboardSet',
          'DashboardSet8' => 'DashboardSet',
          'DashboardSet9' => 'DashboardSet',
          'DashboardSet10' => 'DashboardSet',
          'DashboardSet11' => 'DashboardSet',
          'DashboardSet12' => 'DashboardSet',
          'DashboardSet13' => 'DashboardSet',
          'DashboardSet14' => 'DashboardSet',
          'DashboardSet15' => 'DashboardSet',
          'DashboardSet16' => 'DashboardSet',
          'DashboardSet17' => 'DashboardSet',
          'DashboardSet18' => 'DashboardSet',
          'DashboardSet19' => 'DashboardSet',
          'DashboardSet20' => 'DashboardSet',
          'DashboardSet21' => 'DashboardSet',
          'DashboardSet22' => 'DashboardSet',
          'DashboardSet23' => 'DashboardSet',
          'DashboardSet24' => 'DashboardSet',
          'DashboardSet25' => 'DashboardSet',
          'DashboardSet26' => 'DashboardSet',
          'DashboardSet27' => 'DashboardSet',
          'DashboardSet28' => 'DashboardSet',
          'DashboardSet29' => 'DashboardSet',
          'DashboardSet30' => 'DashboardSet',
          'DashboardSet31' => 'DashboardSet',
          'DashboardSet32' => 'DashboardSet',
          'DashboardSet33' => 'DashboardSet',
          'DashboardSet34' => 'DashboardSet',
          'DashboardSet35' => 'DashboardSet',
          'DashboardSet36' => 'DashboardSet',
          'DashboardSet37' => 'DashboardSet',
          'DashboardSet38' => 'DashboardSet',
          'DashboardSet39' => 'DashboardSet',
          'DashboardSet40' => 'DashboardSet',
          'DashboardSet41' => 'DashboardSet',
          'DashboardSet42' => 'DashboardSet',
          'DashboardSet43' => 'DashboardSet',
          'DashboardSet44' => 'DashboardSet',
          'DashboardSet45' => 'DashboardSet',
          'DashboardSet46' => 'DashboardSet',
          'DashboardSet47' => 'DashboardSet',
          'DashboardSet48' => 'DashboardSet',
          'DashboardSet49' => 'DashboardSet',
          'DashboardSet50' => 'DashboardSet',
          'DashboardSet51' => 'DashboardSet',
          'DashboardSet52' => 'DashboardSet',
          'DashboardSet53' => 'DashboardSet',
          'DashboardSet54' => 'DashboardSet',
          'DashboardSet55' => 'DashboardSet',
          'DashboardSet56' => 'DashboardSet',
          'DashboardSet57' => 'DashboardSet',
          'DashboardSet58' => 'DashboardSet',
          'DashboardSet59' => 'DashboardSet',
          'DashboardSet60' => 'DashboardSet',
          'DashboardSet61' => 'DashboardSet',
          'DashboardSet62' => 'DashboardSet',
          'DashboardSet63' => 'DashboardSet',
          'DashboardSet64' => 'DashboardSet',
          'DashboardSet65' => 'DashboardSet',
          'DashboardSet66' => 'DashboardSet',
          'DashboardSet67' => 'DashboardSet',
          'DashboardSet68' => 'DashboardSet',
          'DashboardSet69' => 'DashboardSet',
          'DashboardSet70' => 'DashboardSet',
          'DashboardSet71' => 'DashboardSet',
          'DashboardSet72' => 'DashboardSet',
          'DashboardSet73' => 'DashboardSet',
          'DashboardSet74' => 'DashboardSet',
          'DashboardSet75' => 'DashboardSet',
          'DashboardSet76' => 'DashboardSet',
          'DashboardSet77' => 'DashboardSet',
          'DashboardSet78' => 'DashboardSet',
          'DashboardSet79' => 'DashboardSet',
          'DashboardSet80' => 'DashboardSet'
        ],
        'fieldLevel' => [],
        'scopeFieldLevel' => [
          'EmailAccount' => [
            'assignedUser' => [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'EmailFolder' => [
            'assignedUser' => [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'Email' => [
            'inboundEmails' => false,
            'emailAccounts' => false
          ],
          'User' => [
            'dashboardTemplate' => false,
            'workingTimeCalendar' => [
              'read' => 'yes',
              'edit' => 'no'
            ],
            'password' => false,
            'passwordConfirm' => false,
            'auth2FA' => false,
            'authMethod' => false,
            'apiKey' => false,
            'secretKey' => false,
            'token' => false
          ],
          'ActionHistoryRecord' => [
            'authToken' => false,
            'authLogRecord' => false
          ]
        ]
      ],
      'strictDefault' => [
        'scopeLevel' => [
          'User' => [
            'read' => 'own',
            'edit' => 'no'
          ],
          'Team' => [
            'read' => 'team'
          ],
          'Import' => false,
          'Webhook' => false
        ],
        'fieldLevel' => [],
        'scopeFieldLevel' => [
          'User' => [
            'gender' => false,
            'avatarColor' => [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'Meeting' => [
            'uid' => false
          ],
          'Call' => [
            'uid' => false
          ]
        ]
      ],
      'adminMandatory' => [
        'scopeLevel' => [
          'User' => [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'Team' => [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'Job' => [
            'create' => 'no',
            'read' => 'all',
            'edit' => 'no',
            'delete' => 'all'
          ],
          'Extension' => [
            'create' => 'no',
            'read' => 'all',
            'edit' => 'no',
            'delete' => 'all'
          ],
          'Stream' => true,
          'ImportEml' => 'Import',
          'BpmnFlowchart' => [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all',
            'stream' => 'all'
          ],
          'InventoryTransaction' => [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'PriceRuleCondition' => [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'ProjectGroup' => [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'ProjectColumn' => 'ProjectBoard',
          'ProjectTask' => true
        ]
      ],
      'valuePermissionList' => [
        0 => 'assignmentPermission',
        1 => 'messagePermission',
        2 => 'mentionPermission',
        3 => 'userCalendarPermission',
        4 => 'auditPermission',
        5 => 'exportPermission',
        6 => 'massUpdatePermission',
        7 => 'userPermission',
        8 => 'portalPermission',
        9 => 'groupEmailAccountPermission',
        10 => 'followerManagementPermission',
        11 => 'dataPrivacyPermission'
      ],
      'valuePermissionHighestLevels' => [
        'assignmentPermission' => 'all',
        'userPermission' => 'all',
        'messagePermission' => 'all',
        'portalPermission' => 'yes',
        'groupEmailAccountPermission' => 'all',
        'exportPermission' => 'yes',
        'massUpdatePermission' => 'yes',
        'followerManagementPermission' => 'all',
        'dataPrivacyPermission' => 'yes',
        'auditPermission' => 'yes',
        'mentionPermission' => 'yes',
        'userCalendarPermission' => 'all'
      ],
      'permissionsStrictDefaults' => [
        'assignmentPermission' => 'no',
        'userPermission' => 'no',
        'messagePermission' => 'no',
        'portalPermission' => 'no',
        'groupEmailAccountPermission' => 'no',
        'exportPermission' => 'no',
        'massUpdatePermission' => 'no',
        'followerManagementPermission' => 'no',
        'dataPrivacyPermission' => 'no',
        'auditPermission' => 'no',
        'mentionPermission' => 'no',
        'userCalendarPermission' => 'no'
      ]
    ],
    'aclPortal' => [
      'mandatory' => [
        'scopeLevel' => [
          'User' => [
            'read' => 'own',
            'edit' => 'no',
            'delete' => 'no',
            'stream' => 'no',
            'create' => 'no'
          ],
          'Team' => false,
          'Note' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'Notification' => [
            'read' => 'own',
            'edit' => 'no',
            'delete' => 'own',
            'create' => 'no'
          ],
          'Portal' => false,
          'Attachment' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'ExternalAccount' => false,
          'Role' => false,
          'PortalRole' => false,
          'EmailFilter' => false,
          'EmailFolder' => false,
          'EmailAccount' => false,
          'EmailTemplate' => false,
          'ActionHistoryRecord' => [
            'read' => 'own'
          ],
          'Preferences' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'no',
            'create' => 'no'
          ],
          'MassEmail' => 'Campaign',
          'CampaignLogRecord' => 'Campaign',
          'CampaignTrackingUrl' => 'Campaign',
          'EmailQueueItem' => false,
          'QuoteItem' => 'Quote',
          'SalesOrderItem' => 'SalesOrder',
          'InvoiceItem' => 'Invoice',
          'PurchaseOrderItem' => 'PurchaseOrder',
          'DeliveryOrderItem' => 'DeliveryOrder',
          'ReceiptOrderItem' => 'ReceiptOrder',
          'TransferOrderItem' => 'TransferOrder',
          'ReturnOrderItem' => 'ReturnOrder',
          'OpportunityItem' => 'Opportunity',
          'ProductPrice' => 'PriceBook',
          'ServiceItem' => 'Service'
        ],
        'fieldLevel' => [],
        'scopeFieldLevel' => [
          'Preferences' => [
            'smtpServer' => false,
            'smtpPort' => false,
            'smtpSecurity' => false,
            'smtpUsername' => false,
            'smtpPassword' => false,
            'smtpAuth' => false,
            'receiveAssignmentEmailNotifications' => false,
            'receiveMentionEmailNotifications' => false,
            'defaultReminders' => false,
            'autoFollowEntityTypeList' => false,
            'emailReplyForceHtml' => false,
            'emailReplyToAllByDefault' => false,
            'signature' => false,
            'followCreatedEntities' => false,
            'followEntityOnStreamPost' => false,
            'doNotFillAssignedUserIfNotRequired' => false,
            'useCustomTabList' => false,
            'addCustomTabs' => false,
            'tabList' => false,
            'emailUseExternalClient' => false,
            'assignmentNotificationsIgnoreEntityTypeList' => false,
            'assignmentEmailNotificationsIgnoreEntityTypeList' => false,
            'dashletsOptions' => false,
            'dashboardLayout' => false
          ],
          'Call' => [
            'reminders' => false,
            'uid' => false
          ],
          'Meeting' => [
            'reminders' => false,
            'uid' => false
          ],
          'Note' => [
            'isInternal' => false,
            'isGlobal' => false
          ],
          'Email' => [
            'inboundEmails' => false,
            'emailAccounts' => false
          ],
          'User' => [
            'dashboardTemplate' => false,
            'workingTimeCalendar' => false,
            'password' => false,
            'authMethod' => false,
            'apiKey' => false,
            'secretKey' => false,
            'token' => false,
            'isAdmin' => false,
            'type' => false,
            'contact' => false,
            'accounts' => false,
            'account' => false,
            'portalRoles' => false,
            'portals' => false,
            'roles' => false,
            'defaultTeam' => false,
            'auth2FA' => false,
            'isActive' => false
          ],
          'ActionHistoryRecord' => [
            'authToken' => false,
            'authLogRecord' => false
          ],
          'Case' => [
            'isInternal' => false
          ],
          'Report' => [
            'portals' => false,
            'assignedUser' => false,
            'teams' => false,
            'emailSendingInterval' => false,
            'emailSendingSettingMonth' => false,
            'emailSendingSettingDay' => false,
            'emailSendingSettingWeekdays' => false,
            'emailSendingTime' => false,
            'emailSendingUsers' => false,
            'emailSendingLastDateSent' => false,
            'emailSendingDoNotSendEmptyReport' => false,
            'applyAcl' => false
          ]
        ]
      ],
      'strictDefault' => [
        'scopeLevel' => [],
        'fieldLevel' => [
          'assignedUser' => [
            'read' => 'yes',
            'edit' => 'no'
          ],
          'assignedUsers' => [
            'read' => 'yes',
            'edit' => 'no'
          ],
          'collaborators' => false,
          'teams' => false
        ],
        'scopeFieldLevel' => [
          'User' => [
            'gender' => false
          ],
          'KnowledgeBaseArticle' => [
            'portals' => false,
            'order' => false,
            'status' => false,
            'assignedUser' => false
          ],
          'Call' => [
            'users' => [
              'read' => 'yes',
              'edit' => 'no'
            ],
            'leads' => false
          ],
          'Meeting' => [
            'users' => [
              'read' => 'yes',
              'edit' => 'no'
            ],
            'leads' => false
          ],
          'Case' => [
            'status' => [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'Report' => [
            'modifiedAt' => false,
            'modifiedBy' => false,
            'createdAt' => false,
            'createdBy' => false
          ]
        ]
      ],
      'valuePermissionList' => [
        0 => 'exportPermission',
        1 => 'massUpdatePermission'
      ],
      'permissionsStrictDefaults' => [
        'exportPermission' => 'no',
        'massUpdatePermission' => 'no'
      ],
      'default' => [
        'scopeFieldLevel' => [
          'Report' => [
            'modifiedAt' => false,
            'modifiedBy' => false,
            'createdAt' => false,
            'createdBy' => false
          ]
        ]
      ]
    ],
    'actions' => [
      'convertCurrency' => [
        'implementationClassName' => 'Espo\\Core\\Action\\Actions\\ConvertCurrency'
      ],
      'merge' => [
        'implementationClassName' => 'Espo\\Core\\Action\\Actions\\Merge'
      ]
    ],
    'addressFormats' => [
      1 => [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter1'
      ],
      2 => [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter2'
      ],
      3 => [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter3'
      ],
      4 => [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter4'
      ]
    ],
    'adminPanel' => [
      'system' => [
        'label' => 'System',
        'itemList' => [
          0 => [
            'url' => '#Admin/settings',
            'label' => 'Settings',
            'iconClass' => 'fas fa-cog',
            'description' => 'settings',
            'recordView' => 'views/admin/settings'
          ],
          1 => [
            'url' => '#Admin/userInterface',
            'label' => 'User Interface',
            'iconClass' => 'fas fa-desktop',
            'description' => 'userInterface',
            'recordView' => 'views/admin/user-interface'
          ],
          2 => [
            'url' => '#Admin/authentication',
            'label' => 'Authentication',
            'iconClass' => 'fas fa-sign-in-alt',
            'description' => 'authentication',
            'recordView' => 'views/admin/authentication'
          ],
          3 => [
            'url' => '#ScheduledJob',
            'label' => 'Scheduled Jobs',
            'iconClass' => 'fas fa-clock',
            'description' => 'scheduledJob'
          ],
          4 => [
            'url' => '#Admin/currency',
            'label' => 'Currency',
            'iconClass' => 'fas fa-euro-sign',
            'description' => 'currency',
            'recordView' => 'views/admin/currency'
          ],
          5 => [
            'url' => '#Admin/notifications',
            'label' => 'Notifications',
            'iconClass' => 'fas fa-bell',
            'description' => 'notifications',
            'recordView' => 'views/admin/notifications'
          ],
          6 => [
            'url' => '#Admin/integrations',
            'label' => 'Integrations',
            'iconClass' => 'fas fa-network-wired',
            'description' => 'integrations'
          ],
          7 => [
            'url' => '#Admin/extensions',
            'label' => 'Extensions',
            'iconClass' => 'fas fa-upload',
            'description' => 'extensions'
          ],
          8 => [
            'url' => '#Admin/systemRequirements',
            'label' => 'System Requirements',
            'iconClass' => 'fas fa-server',
            'description' => 'systemRequirements'
          ],
          9 => [
            'url' => '#Admin/jobsSettings',
            'label' => 'Job Settings',
            'iconClass' => 'fas fa-list-ul',
            'description' => 'jobsSettings',
            'recordView' => 'views/admin/jobs-settings'
          ],
          10 => [
            'url' => '#Admin/upgrade',
            'label' => 'Upgrade',
            'iconClass' => 'fas fa-arrow-alt-circle-up',
            'description' => 'upgrade',
            'view' => 'views/admin/upgrade/index'
          ],
          11 => [
            'action' => 'clearCache',
            'label' => 'Clear Cache',
            'iconClass' => 'fas fa-broom',
            'description' => 'clearCache'
          ],
          12 => [
            'action' => 'rebuild',
            'label' => 'Rebuild',
            'iconClass' => 'fas fa-database',
            'description' => 'rebuild'
          ]
        ],
        'order' => 0
      ],
      'users' => [
        'label' => 'Users',
        'itemList' => [
          0 => [
            'url' => '#Admin/users',
            'label' => 'Users',
            'iconClass' => 'fas fa-user',
            'description' => 'users',
            'tabQuickSearch' => true
          ],
          1 => [
            'url' => '#Admin/teams',
            'label' => 'Teams',
            'iconClass' => 'fas fa-users',
            'description' => 'teams',
            'tabQuickSearch' => true
          ],
          2 => [
            'url' => '#Admin/roles',
            'label' => 'Roles',
            'iconClass' => 'fas fa-key',
            'description' => 'roles',
            'tabQuickSearch' => true
          ],
          3 => [
            'url' => '#Admin/authLog',
            'label' => 'Auth Log',
            'iconClass' => 'fas fa-sign-in-alt',
            'description' => 'authLog'
          ],
          4 => [
            'url' => '#Admin/authTokens',
            'label' => 'Auth Tokens',
            'iconClass' => 'fas fa-shield-alt',
            'description' => 'authTokens'
          ],
          5 => [
            'url' => '#Admin/actionHistory',
            'label' => 'Action History',
            'iconClass' => 'fas fa-history',
            'description' => 'actionHistory'
          ],
          6 => [
            'url' => '#Admin/apiUsers',
            'label' => 'API Users',
            'iconClass' => 'fas fa-user-cog',
            'description' => 'apiUsers'
          ]
        ],
        'order' => 5
      ],
      'customization' => [
        'label' => 'Customization',
        'itemList' => [
          0 => [
            'url' => '#Admin/entityManager',
            'label' => 'Entity Manager',
            'iconClass' => 'fas fa-tools',
            'description' => 'entityManager',
            'tabQuickSearch' => true
          ],
          1 => [
            'url' => '#Admin/layouts',
            'label' => 'Layout Manager',
            'iconClass' => 'fas fa-table',
            'description' => 'layoutManager'
          ],
          2 => [
            'url' => '#Admin/labelManager',
            'label' => 'Label Manager',
            'iconClass' => 'fas fa-language',
            'description' => 'labelManager'
          ],
          3 => [
            'url' => '#Admin/templateManager',
            'label' => 'Template Manager',
            'iconClass' => 'fas fa-envelope-open-text',
            'description' => 'templateManager'
          ],
          4 => [
            'url' => '#ReportFilter',
            'label' => 'Report Filters',
            'iconClass' => 'fas fa-filter',
            'description' => 'reportFilters'
          ],
          5 => [
            'url' => '#ReportPanel',
            'label' => 'Report Panels',
            'iconClass' => 'fas fa-chart-area',
            'description' => 'reportPanels'
          ]
        ],
        'order' => 10
      ],
      'email' => [
        'label' => 'Messaging',
        'itemList' => [
          0 => [
            'url' => '#Admin/outboundEmails',
            'label' => 'Outbound Emails',
            'iconClass' => 'fas fa-paper-plane',
            'description' => 'outboundEmails',
            'recordView' => 'views/admin/outbound-emails'
          ],
          1 => [
            'url' => '#Admin/inboundEmails',
            'label' => 'Inbound Emails',
            'iconClass' => 'fas fa-envelope',
            'description' => 'inboundEmails',
            'recordView' => 'views/admin/inbound-emails'
          ],
          2 => [
            'url' => '#Admin/groupEmailAccounts',
            'label' => 'Group Email Accounts',
            'iconClass' => 'fas fa-inbox',
            'description' => 'groupEmailAccounts'
          ],
          3 => [
            'url' => '#Admin/personalEmailAccounts',
            'label' => 'Personal Email Accounts',
            'iconClass' => 'fas fa-inbox',
            'description' => 'personalEmailAccounts'
          ],
          4 => [
            'url' => '#Admin/emailFilters',
            'label' => 'Email Filters',
            'iconClass' => 'fas fa-filter',
            'description' => 'emailFilters'
          ],
          5 => [
            'url' => '#Admin/groupEmailFolders',
            'label' => 'Group Email Folders',
            'iconClass' => 'fas fa-folder',
            'description' => 'groupEmailFolders'
          ],
          6 => [
            'url' => '#Admin/emailTemplates',
            'label' => 'Email Templates',
            'iconClass' => 'fas fa-envelope-square',
            'description' => 'emailTemplates'
          ],
          7 => [
            'url' => '#Admin/sms',
            'label' => 'SMS',
            'iconClass' => 'fas fa-paper-plane',
            'description' => 'sms',
            'recordView' => 'views/admin/sms'
          ]
        ],
        'order' => 15
      ],
      'portal' => [
        'label' => 'Portal',
        'itemList' => [
          0 => [
            'url' => '#Admin/portals',
            'label' => 'Portals',
            'iconClass' => 'fas fa-parking',
            'description' => 'portals'
          ],
          1 => [
            'url' => '#Admin/portalUsers',
            'label' => 'Portal Users',
            'iconClass' => 'fas fa-user',
            'description' => 'portalUsers',
            'tabQuickSearch' => true
          ],
          2 => [
            'url' => '#Admin/portalRoles',
            'label' => 'Portal Roles',
            'iconClass' => 'fas fa-key',
            'description' => 'portalRoles'
          ]
        ],
        'order' => 20
      ],
      'setup' => [
        'label' => 'Setup',
        'itemList' => [
          0 => [
            'url' => '#Admin/workingTimeCalendar',
            'label' => 'Working Time Calendars',
            'iconClass' => 'far fa-calendar-alt',
            'description' => 'workingTimeCalendars',
            'tabQuickSearch' => true
          ],
          1 => [
            'url' => '#Admin/layoutSets',
            'label' => 'Layout Sets',
            'iconClass' => 'fas fa-table',
            'description' => 'layoutSets'
          ],
          2 => [
            'url' => '#Admin/dashboardTemplates',
            'label' => 'Dashboard Templates',
            'iconClass' => 'fas fa-th-large',
            'description' => 'dashboardTemplates'
          ],
          3 => [
            'url' => '#Admin/leadCapture',
            'label' => 'Lead Capture',
            'iconClass' => 'fas fa-id-card',
            'description' => 'leadCapture'
          ],
          4 => [
            'url' => '#Admin/pdfTemplates',
            'label' => 'PDF Templates',
            'iconClass' => 'fas fa-file-pdf',
            'description' => 'pdfTemplates'
          ],
          5 => [
            'url' => '#Admin/webhooks',
            'label' => 'Webhooks',
            'iconClass' => 'fas fa-share-alt icon-rotate-90',
            'description' => 'webhooks'
          ],
          6 => [
            'url' => '#Admin/addressCountries',
            'label' => 'Address Countries',
            'iconClass' => 'far fa-flag',
            'description' => 'addressCountries'
          ],
          7 => [
            'url' => '#Admin/authenticationProviders',
            'label' => 'Authentication Providers',
            'iconClass' => 'fas fa-sign-in-alt',
            'description' => 'authenticationProviders'
          ]
        ],
        'order' => 24
      ],
      'data' => [
        'label' => 'Data',
        'itemList' => [
          0 => [
            'url' => '#Admin/import',
            'label' => 'Import',
            'iconClass' => 'fas fa-file-import',
            'description' => 'import'
          ],
          1 => [
            'url' => '#Admin/attachments',
            'label' => 'Attachments',
            'iconClass' => 'fas fa-paperclip',
            'description' => 'attachments'
          ],
          2 => [
            'url' => '#Admin/jobs',
            'label' => 'Jobs',
            'iconClass' => 'fas fa-list-ul',
            'description' => 'jobs'
          ],
          3 => [
            'url' => '#Admin/emailAddresses',
            'label' => 'Email Addresses',
            'iconClass' => 'fas fa-envelope',
            'description' => 'emailAddresses'
          ],
          4 => [
            'url' => '#Admin/phoneNumbers',
            'label' => 'Phone Numbers',
            'iconClass' => 'fas fa-phone',
            'description' => 'phoneNumbers'
          ],
          5 => [
            'url' => '#Admin/appSecrets',
            'label' => 'App Secrets',
            'iconClass' => 'fas fa-key',
            'description' => 'appSecrets'
          ],
          6 => [
            'url' => '#Admin/appLog',
            'label' => 'App Log',
            'iconClass' => 'fas fa-list',
            'description' => 'appLog'
          ]
        ],
        'order' => 25
      ],
      'misc' => [
        'label' => 'Misc',
        'itemList' => [
          0 => [
            'url' => '#Admin/formulaSandbox',
            'label' => 'Formula Sandbox',
            'iconClass' => 'fas fa-code',
            'description' => 'formulaSandbox',
            'view' => 'views/admin/formula-sandbox/index'
          ]
        ],
        'order' => 26
      ],
      'workflows' => [
        'label' => 'Workflow Manager',
        'itemList' => [
          0 => [
            'url' => '#Workflow',
            'label' => 'Workflow Manager',
            'iconClass' => 'fas fa-code-branch icon-rotate-180',
            'description' => 'workflowManager',
            'tabQuickSearch' => true
          ]
        ],
        'order' => 99
      ],
      'bpmn' => [
        'label' => 'Business Process Management',
        'itemList' => [
          0 => [
            'url' => '#BpmnFlowchart',
            'label' => 'Flowcharts',
            'iconClass' => 'fas fa-project-diagram',
            'description' => 'bpmnFlowcharts',
            'tabQuickSearch' => true
          ],
          1 => [
            'url' => '#BpmnProcess',
            'label' => 'Processes',
            'iconClass' => 'fas fa-cogs',
            'description' => 'bpmnProcesses',
            'tabQuickSearch' => true
          ]
        ],
        'order' => 100
      ],
      'salesPack' => [
        'label' => 'Sales Pack',
        'itemList' => [
          0 => [
            'url' => '#Admin/salesPackSettings',
            'label' => 'Settings',
            'iconClass' => 'fas fa-cog',
            'description' => 'salesPackSettings',
            'recordView' => 'sales:views/settings/record/settings'
          ],
          1 => [
            'url' => '#PriceRuleCondition',
            'label' => 'Price Rule Conditions',
            'iconClass' => 'fas fa-code',
            'description' => 'priceRuleConditions'
          ]
        ]
      ]
    ],
    'api' => [
      'globalMiddlewareClassNameList' => [],
      'routeMiddlewareClassNameListMap' => [],
      'controllerMiddlewareClassNameListMap' => [],
      'controllerActionMiddlewareClassNameListMap' => []
    ],
    'appParams' => [
      'templateEntityTypeList' => [
        'className' => 'Espo\\Classes\\AppParams\\TemplateEntityTypeList'
      ],
      'extensions' => [
        'className' => 'Espo\\Classes\\AppParams\\Extensions'
      ],
      'addressCountryData' => [
        'className' => 'Espo\\Classes\\AppParams\\AddressCountryData'
      ],
      'flowchartEntityTypeList' => [
        'className' => 'Espo\\Modules\\Advanced\\Core\\AppParams\\FlowchartEntityTypeList'
      ],
      'manualWorkflows' => [
        'className' => 'Espo\\Modules\\Advanced\\Classes\\AppParams\\ManualWorkflows'
      ],
      'defaultTaxRateQuote' => [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRateQuote'
      ],
      'defaultTaxRateSalesOrder' => [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRateSalesOrder'
      ],
      'defaultTaxRateInvoice' => [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRateInvoice'
      ],
      'defaultTaxRatePurchaseOrder' => [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRatePurchaseOrder'
      ],
      'userDashboardSetList' => [
        'className' => 'Espo\\Modules\\DubasCustom\\Classes\\AppParams\\UserDashboardSetList'
      ],
      'projectBoards' => [
        'className' => 'Espo\\Modules\\Project\\Classes\\AppParams\\ProjectBoards'
      ],
      'projectRoles' => [
        'className' => 'Espo\\Modules\\Project\\Classes\\AppParams\\ProjectRoles'
      ]
    ],
    'authentication' => [
      'beforeLoginHookClassNameList' => [
        0 => 'Espo\\Core\\Authentication\\Hook\\Hooks\\FailedAttemptsLimit',
        1 => 'Espo\\Core\\Authentication\\Hook\\Hooks\\FailedCodeAttemptsLimit'
      ],
      'onLoginHookClassNameList' => [
        0 => 'Espo\\Core\\Authentication\\Hook\\Hooks\\IpAddressWhitelist'
      ],
      'onFailHookClassNameList' => [],
      'onSuccessHookClassNameList' => [],
      'onSuccessByTokenHookClassNameList' => [],
      'onSecondStepRequiredHookClassNameList' => []
    ],
    'authentication2FAMethods' => [
      'Totp' => [
        'settings' => [
          'isAvailable' => true
        ],
        'userApplyView' => 'views/user-security/modals/totp',
        'loginClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Totp\\TotpLogin',
        'userSetupClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Totp\\TotpUserSetup'
      ],
      'Email' => [
        'settings' => [
          'isAvailable' => true
        ],
        'userApplyView' => 'views/user-security/modals/two-factor-email',
        'loginClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Email\\EmailLogin',
        'userSetupClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Email\\EmailUserSetup'
      ],
      'Sms' => [
        'settings' => [
          'isAvailable' => true
        ],
        'userApplyView' => 'views/user-security/modals/two-factor-sms',
        'loginClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Sms\\SmsLogin',
        'userSetupClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Sms\\SmsUserSetup'
      ]
    ],
    'cleanup' => [
      'reminders' => [
        'className' => 'Espo\\Classes\\Cleanup\\Reminders',
        'order' => 10
      ],
      'webhookQueue' => [
        'className' => 'Espo\\Classes\\Cleanup\\WebhookQueue',
        'order' => 11
      ],
      'twoFactorCodes' => [
        'className' => 'Espo\\Classes\\Cleanup\\TwoFactorCodes'
      ],
      'massActions' => [
        'className' => 'Espo\\Classes\\Cleanup\\MassActions'
      ],
      'exports' => [
        'className' => 'Espo\\Classes\\Cleanup\\Exports'
      ],
      'passwordChangeRequests' => [
        'className' => 'Espo\\Classes\\Cleanup\\PasswordChangeRequests'
      ],
      'subscribers' => [
        'className' => 'Espo\\Classes\\Cleanup\\Subscribers'
      ],
      'audit' => [
        'className' => 'Espo\\Classes\\Cleanup\\Audit'
      ],
      'stars' => [
        'className' => 'Espo\\Classes\\Cleanup\\Stars'
      ],
      'appLog' => [
        'className' => 'Espo\\Classes\\Cleanup\\AppLog'
      ],
      'workflowLog' => [
        'className' => 'Espo\\Modules\\Advanced\\Core\\Cleanup\\WorkflowLog',
        'order' => 20
      ],
      'advancedPack' => [
        'className' => 'Espo\\Modules\\Advanced\\Core\\Cleanup\\Integrity'
      ],
      'salesIntegrity' => [
        'className' => 'Espo\\Modules\\Sales\\Classes\\Cleanup\\Integrity'
      ],
      'subProjectTasks' => [
        'className' => 'Espo\\Modules\\Project\\Classes\\Cleanup\\SubProjectTasks'
      ],
      'projectIntegrity' => [
        'className' => 'Espo\\Modules\\Project\\Classes\\Cleanup\\Integrity'
      ]
    ],
    'client' => [
      'scriptList' => [
        0 => 'client/lib/espo.js',
        1 => 'client/lib/espo-main.js',
        2 => 'client/custom/modules/ebla-link-pro/src/ebla-link-pro-script.js',
        3 => 'client/custom/modules/dubas-custom/lib/init.js',
        4 => 'client/custom/modules/project/lib/init.js',
        5 => 'client/custom/modules/ebla-kanban-multiple/src/ebla-kanban-multiple-script.js'
      ],
      'developerModeScriptList' => [
        0 => 'client/src/loader.js',
        1 => 'client/custom/modules/ebla-link-pro/src/ebla-link-pro-script.js',
        2 => 'client/custom/modules/ebla-kanban-multiple/src/ebla-kanban-multiple-script.js'
      ],
      'linkList' => [
        0 => [
          'href' => 'client/fonts/inter/Inter-Regular.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        1 => [
          'href' => 'client/fonts/inter/Inter-Medium.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        2 => [
          'href' => 'client/fonts/inter/Inter-SemiBold.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        3 => [
          'href' => 'client/fonts/inter/Inter-Bold.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        4 => [
          'href' => 'client/fonts/fa-solid-900.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        5 => [
          'href' => 'client/fonts/fa-regular-400.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ]
      ],
      'developerModeCssList' => [
        0 => 'client/custom/modules/ebla-link-pro/css/ebla-link-pro.css'
      ],
      'cssList' => [
        0 => 'client/custom/modules/ebla-link-pro/css/ebla-link-pro.css',
        1 => 'client/custom/css/style.css'
      ]
    ],
    'clientNavbar' => [
      'items' => [
        'globalSearch' => [
          'view' => 'views/global-search/global-search',
          'class' => 'navbar-form global-search-container',
          'order' => 5,
          'disabled' => false
        ],
        'quickCreate' => [
          'view' => 'views/site/navbar/quick-create',
          'class' => 'dropdown hidden-xs quick-create-container',
          'order' => 10,
          'disabled' => false
        ],
        'notificationBadge' => [
          'view' => 'views/notification/badge',
          'class' => 'dropdown notifications-badge-container',
          'order' => 15,
          'disabled' => false
        ]
      ],
      'menuItems' => [
        'admin' => [
          'order' => 0,
          'groupIndex' => 1,
          'link' => '#Admin',
          'labelTranslation' => 'Global.labels.Administration',
          'accessDataList' => [
            0 => [
              'isAdminOnly' => true
            ]
          ]
        ],
        'preferences' => [
          'order' => 1,
          'groupIndex' => 1,
          'link' => '#Preferences',
          'labelTranslation' => 'Global.labels.Preferences'
        ],
        'lastViewed' => [
          'order' => 0,
          'groupIndex' => 5,
          'link' => '#LastViewed',
          'labelTranslation' => 'Global.scopeNamesPlural.LastViewed',
          'configCheck' => '!actionHistoryDisabled',
          'handler' => 'handlers/navbar-menu',
          'actionFunction' => 'lastViewed'
        ],
        'about' => [
          'order' => 0,
          'groupIndex' => 10,
          'link' => '#About',
          'labelTranslation' => 'Global.labels.About'
        ],
        'logout' => [
          'order' => 1,
          'groupIndex' => 10,
          'labelTranslation' => 'Global.labels.Log Out',
          'handler' => 'handlers/navbar-menu',
          'actionFunction' => 'logout'
        ]
      ]
    ],
    'clientRecord' => [
      'panels' => [
        'activities' => [
          'name' => 'activities',
          'label' => 'Activities',
          'view' => 'crm:views/record/panels/activities',
          'aclScope' => 'Activities'
        ],
        'history' => [
          'name' => 'history',
          'label' => 'History',
          'view' => 'crm:views/record/panels/history',
          'aclScope' => 'Activities'
        ],
        'tasks' => [
          'name' => 'tasks',
          'label' => 'Tasks',
          'view' => 'crm:views/record/panels/tasks',
          'aclScope' => 'Task'
        ]
      ]
    ],
    'clientRoutes' => [
      'AddressMap/view/:entityType/:id/:field' => [
        'params' => [
          'controller' => 'AddressMap',
          'action' => 'view'
        ]
      ],
      'Admin/:page' => [
        'params' => [
          'controller' => 'Admin',
          'action' => 'page'
        ],
        'order' => 1
      ],
      'Admin/:page/:options' => [
        'params' => [
          'controller' => 'Admin',
          'action' => 'page'
        ],
        'order' => 1
      ],
      ':entityType/activities/:id/:targetEntityType' => [
        'params' => [
          'controller' => 'Activities',
          'action' => 'activities'
        ],
        'order' => 1
      ],
      ':entityType/history/:id/:targetEntityType' => [
        'params' => [
          'controller' => 'Activities',
          'action' => 'history'
        ],
        'order' => 1
      ],
      'Report/show/:id' => [
        'params' => [
          'controller' => 'Report',
          'action' => 'show'
        ]
      ]
    ],
    'complexExpression' => [
      'functionList' => [
        0 => [
          'name' => 'EQUAL',
          'insertText' => 'EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        1 => [
          'name' => 'NOT_EQUAL',
          'insertText' => 'NOT_EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        2 => [
          'name' => 'OR',
          'insertText' => 'OR:(EXPR1, EXPR2)',
          'returnType' => 'bool'
        ],
        3 => [
          'name' => 'AND',
          'insertText' => 'AND:(EXPR1, EXPR2)',
          'returnType' => 'bool'
        ],
        4 => [
          'name' => 'NOT',
          'insertText' => 'NOT:(EXPR)',
          'returnType' => 'bool'
        ],
        5 => [
          'name' => 'LIKE',
          'insertText' => 'LIKE:(VALUE, \'pattern%\')',
          'returnType' => 'bool'
        ],
        6 => [
          'name' => 'NOT_LIKE',
          'insertText' => 'NOT_LIKE:(VALUE, \'pattern%\')',
          'returnType' => 'bool'
        ],
        7 => [
          'name' => 'GREATER_THAN',
          'insertText' => 'GREATER_THAN:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        8 => [
          'name' => 'LESS_THAN',
          'insertText' => 'LESS_THAN:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        9 => [
          'name' => 'GREATER_THAN_OR_EQUAL',
          'insertText' => 'GREATER_THAN_OR_EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        10 => [
          'name' => 'LESS_THAN_OR_EQUAL',
          'insertText' => 'LESS_THAN_OR_EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        11 => [
          'name' => 'IS_NULL',
          'insertText' => 'IS_NULL:(VALUE)',
          'returnType' => 'bool'
        ],
        12 => [
          'name' => 'IS_NOT_NULL',
          'insertText' => 'IS_NOT_NULL:(VALUE)',
          'returnType' => 'bool'
        ],
        13 => [
          'name' => 'IN',
          'insertText' => 'IN:(VALUE, VALUE1, VALUE2, VALUE3)',
          'returnType' => 'bool'
        ],
        14 => [
          'name' => 'NOT_IN',
          'insertText' => 'NOT_IN:(VALUE, VALUE1, VALUE2, VALUE3)',
          'returnType' => 'bool'
        ],
        15 => [
          'name' => 'IF',
          'insertText' => 'IF:(CONDITION, THEN_VALUE, ELSE_VALUE)'
        ],
        16 => [
          'name' => 'SWITCH',
          'insertText' => 'SWITCH:(CONDITION1, VALUE1, CONDITION2, VALUE2, ELSE_VALUE)'
        ],
        17 => [
          'name' => 'MAP',
          'insertText' => 'MAP:(EXPR, WHEN_VALUE1, THEN_VALUE1, WHEN_VALUE2, THEN_VALUE2, ELSE_VALUE)'
        ],
        18 => [
          'name' => 'MONTH_NUMBER',
          'insertText' => 'MONTH_NUMBER:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        19 => [
          'name' => 'WEEK_NUMBER_0',
          'insertText' => 'WEEK_NUMBER_0:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        20 => [
          'name' => 'WEEK_NUMBER_1',
          'insertText' => 'WEEK_NUMBER_1:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        21 => [
          'name' => 'DAYOFWEEK',
          'insertText' => 'DAYOFWEEK:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        22 => [
          'name' => 'DAYOFMONTH',
          'insertText' => 'DAYOFMONTH:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        23 => [
          'name' => 'YEAR',
          'insertText' => 'YEAR:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        24 => [
          'name' => 'HOUR',
          'insertText' => 'HOUR:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        25 => [
          'name' => 'MINUTE',
          'insertText' => 'MINUTE:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        26 => [
          'name' => 'MONTH',
          'insertText' => 'MONTH:(DATE_VALUE)',
          'returnType' => 'string'
        ],
        27 => [
          'name' => 'QUARTER',
          'insertText' => 'QUARTER:(DATE_VALUE)',
          'returnType' => 'string'
        ],
        28 => [
          'name' => 'WEEK',
          'insertText' => 'WEEK:(DATE_VALUE)',
          'returnType' => 'string'
        ],
        29 => [
          'name' => 'NOW',
          'insertText' => 'NOW:()',
          'returnType' => 'string'
        ],
        30 => [
          'name' => 'TZ',
          'insertText' => 'TZ:(DATE_VALUE, OFFSET)',
          'returnType' => 'string'
        ],
        31 => [
          'name' => 'UNIX_TIMESTAMP',
          'insertText' => 'UNIX_TIMESTAMP:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        32 => [
          'name' => 'TIMESTAMPDIFF_YEAR',
          'insertText' => 'TIMESTAMPDIFF_YEAR:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        33 => [
          'name' => 'TIMESTAMPDIFF_MONTH',
          'insertText' => 'TIMESTAMPDIFF_MONTH:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        34 => [
          'name' => 'TIMESTAMPDIFF_WEEK',
          'insertText' => 'TIMESTAMPDIFF_WEEK:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        35 => [
          'name' => 'TIMESTAMPDIFF_DAY',
          'insertText' => 'TIMESTAMPDIFF_DAY:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        36 => [
          'name' => 'TIMESTAMPDIFF_HOUR',
          'insertText' => 'TIMESTAMPDIFF_HOUR:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        37 => [
          'name' => 'TIMESTAMPDIFF_MINUTE',
          'insertText' => 'TIMESTAMPDIFF_MINUTE:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        38 => [
          'name' => 'TIMESTAMPDIFF_SECOND',
          'insertText' => 'TIMESTAMPDIFF_SECOND:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        39 => [
          'name' => 'CONCAT',
          'insertText' => 'CONCAT:(STRING1, STRING2)',
          'returnType' => 'string'
        ],
        40 => [
          'name' => 'LEFT',
          'insertText' => 'LEFT:(STRING, NUMBER_OF_CHARACTERS)',
          'returnType' => 'string'
        ],
        41 => [
          'name' => 'LOWER',
          'insertText' => 'LOWER:(STRING)',
          'returnType' => 'string'
        ],
        42 => [
          'name' => 'UPPER',
          'insertText' => 'UPPER:(STRING)',
          'returnType' => 'string'
        ],
        43 => [
          'name' => 'TRIM',
          'insertText' => 'TRIM:(STRING)',
          'returnType' => 'string'
        ],
        44 => [
          'name' => 'CHAR_LENGTH',
          'insertText' => 'CHAR_LENGTH:(STRING)',
          'returnType' => 'int'
        ],
        45 => [
          'name' => 'BINARY',
          'insertText' => 'BINARY:(STRING)',
          'returnType' => 'string'
        ],
        46 => [
          'name' => 'REPLACE',
          'insertText' => 'REPLACE:(HAYSTACK, NEEDLE, REPLACE_WITH)',
          'returnType' => 'string'
        ],
        47 => [
          'name' => 'ADD',
          'insertText' => 'ADD:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        48 => [
          'name' => 'SUB',
          'insertText' => 'SUB:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        49 => [
          'name' => 'MUL',
          'insertText' => 'MUL:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        50 => [
          'name' => 'DIV',
          'insertText' => 'DIV:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        51 => [
          'name' => 'MOD',
          'insertText' => 'MOD:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        52 => [
          'name' => 'FLOOR',
          'insertText' => 'FLOOR:(VALUE)',
          'returnType' => 'int'
        ],
        53 => [
          'name' => 'CEIL',
          'insertText' => 'CEIL:(VALUE)',
          'returnType' => 'int'
        ],
        54 => [
          'name' => 'ROUND',
          'insertText' => 'ROUND:(VALUE, PRECISION)',
          'returnType' => 'float'
        ],
        55 => [
          'name' => 'COUNT',
          'insertText' => 'COUNT:(EXPR)',
          'returnType' => 'int'
        ],
        56 => [
          'name' => 'SUM',
          'insertText' => 'SUM:(EXPR)',
          'returnType' => 'int|float'
        ],
        57 => [
          'name' => 'AVG',
          'insertText' => 'AVG:(EXPR)',
          'returnType' => 'float'
        ],
        58 => [
          'name' => 'MAX',
          'insertText' => 'MAX:(EXPR)',
          'returnType' => 'int|float'
        ],
        59 => [
          'name' => 'MIN',
          'insertText' => 'MIN:(EXPR)',
          'returnType' => 'int|float'
        ]
      ]
    ],
    'config' => [
      'entityTypeListParamList' => [
        0 => 'tabList',
        1 => 'quickCreateList',
        2 => 'globalSearchEntityList',
        3 => 'assignmentEmailNotificationsEntityList',
        4 => 'assignmentNotificationsEntityList',
        5 => 'calendarEntityList',
        6 => 'streamEmailNotificationsEntityList',
        7 => 'activitiesEntityList',
        8 => 'historyEntityList',
        9 => 'streamEmailNotificationsTypeList',
        10 => 'emailKeepParentTeamsEntityList'
      ],
      'params' => [
        'isDeveloperMode' => [
          'readOnly' => true
        ],
        'clientSecurityHeadersDisabled' => [
          'readOnly' => true
        ],
        'clientCspDisabled' => [
          'readOnly' => true
        ],
        'clientCspScriptSourceList' => [
          'readOnly' => true
        ],
        'clientStrictTransportSecurityHeaderDisabled' => [
          'readOnly' => true
        ],
        'clientXFrameOptionsHeaderDisabled' => [
          'readOnly' => true
        ],
        'systemUserId' => [
          'level' => 'admin',
          'readOnly' => true
        ],
        'smtpPassword' => [
          'level' => 'internal'
        ],
        'awsS3Storage' => [
          'level' => 'system'
        ],
        'defaultFileStorage' => [
          'level' => 'admin',
          'readOnly' => true
        ],
        'smsProvider' => [
          'level' => 'admin'
        ],
        'authAnotherUserDisabled' => [
          'level' => 'admin',
          'readOnly' => true
        ],
        'userNameRegularExpression' => [
          'readOnly' => true
        ],
        'workingTimeCalendar' => [
          'level' => 'admin'
        ],
        'ldapPassword' => [
          'level' => 'internal'
        ],
        'oidcClientId' => [
          'level' => 'admin'
        ],
        'oidcClientSecret' => [
          'level' => 'internal'
        ],
        'oidcAuthorizationEndpoint' => [
          'level' => 'admin'
        ],
        'oidcTokenEndpoint' => [
          'level' => 'admin'
        ],
        'oidcJwksEndpoint' => [
          'level' => 'admin'
        ],
        'oidcJwksCachePeriod' => [
          'level' => 'admin'
        ],
        'oidcJwtSignatureAlgorithmList' => [
          'level' => 'admin'
        ],
        'oidcScopes' => [
          'level' => 'admin'
        ],
        'oidcGroupClaim' => [
          'level' => 'admin'
        ],
        'oidcCreateUser' => [
          'level' => 'admin'
        ],
        'oidcUsernameClaim' => [
          'level' => 'admin'
        ],
        'oidcTeamsIds' => [
          'level' => 'admin'
        ],
        'oidcTeamsNames' => [
          'level' => 'admin'
        ],
        'oidcTeamsColumns' => [
          'level' => 'admin'
        ],
        'oidcSync' => [
          'level' => 'admin'
        ],
        'oidcSyncTeams' => [
          'level' => 'admin'
        ],
        'oidcFallback' => [
          'level' => 'admin'
        ],
        'oidcAllowRegularUserFallback' => [
          'level' => 'admin'
        ],
        'oidcAllowAdminUser' => [
          'level' => 'admin'
        ],
        'oidcAuthorizationPrompt' => [
          'level' => 'admin'
        ],
        'oidcAuthorizationMaxAge' => [
          'level' => 'admin'
        ],
        'oidcLogoutUrl' => [
          'level' => 'admin'
        ],
        'apiCorsAllowedMethodList' => [
          'level' => 'admin'
        ],
        'apiCorsAllowedHeaderList' => [
          'level' => 'admin'
        ],
        'apiCorsAllowedOriginList' => [
          'level' => 'admin'
        ],
        'apiCorsMaxAge' => [
          'level' => 'admin'
        ],
        'customExportManifest' => [
          'level' => 'admin'
        ],
        'starsLimit' => [
          'level' => 'admin'
        ],
        'authIpAddressCheck' => [
          'level' => 'superAdmin'
        ],
        'authIpAddressWhitelist' => [
          'level' => 'superAdmin'
        ],
        'authIpAddressCheckExcludedUsers' => [
          'level' => 'superAdmin'
        ],
        'availableReactions' => [
          'level' => 'default'
        ],
        'emailScheduledBatchCount' => [
          'level' => 'admin'
        ],
        'streamEmailWithContentEntityTypeList' => [
          'level' => 'admin'
        ],
        'defaultPriceBook' => [],
        'priceBooksEnabled' => [],
        'inventoryTransactionsEnabled' => [],
        'warehousesEnabled' => [],
        'deliveryOrdersEnabled' => [],
        'receiptOrdersEnabled' => [],
        'inventoryCompressJobPeriod' => [
          'level' => 'admin'
        ],
        'inventoryDetachJobPeriod' => [
          'level' => 'admin'
        ],
        'notActualOrderLockingJobPeriod' => [
          'level' => 'admin'
        ],
        'productVariantMaxCount' => [],
        'salesForbidOrderUnlock' => [
          'level' => 'default'
        ],
        'eInvoiceFormat' => [
          'level' => 'default'
        ],
        'sellerCompanyName' => [
          'level' => 'admin'
        ],
        'sellerElectronicAddressScheme' => [
          'level' => 'admin'
        ],
        'sellerElectronicAddressIdentifier' => [
          'level' => 'admin'
        ],
        'sellerVatNumber' => [
          'level' => 'admin'
        ],
        'sellerTaxRegistrationScheme' => [
          'level' => 'admin'
        ],
        'sellerTaxRegistrationIdentifier' => [
          'level' => 'admin'
        ],
        'sellerAddress' => [
          'level' => 'admin'
        ],
        'sellerContactName' => [
          'level' => 'admin'
        ],
        'sellerContactEmailAddress' => [
          'level' => 'admin'
        ],
        'sellerContactPhoneNumber' => [
          'level' => 'admin'
        ]
      ]
    ],
    'consoleCommands' => [
      'import' => [
        'className' => 'Espo\\Classes\\ConsoleCommands\\Import',
        'listed' => true
      ],
      'clearCache' => [
        'listed' => true,
        'noSystemUser' => true
      ],
      'rebuild' => [
        'listed' => true,
        'noSystemUser' => true,
        'allowedFlags' => [
          0 => 'hard',
          1 => 'y'
        ]
      ],
      'updateAppTimestamp' => [
        'listed' => true,
        'noSystemUser' => true
      ],
      'appInfo' => [
        'listed' => true
      ],
      'setPassword' => [
        'listed' => true
      ],
      'upgrade' => [
        'listed' => true
      ],
      'extension' => [
        'listed' => true
      ],
      'runJob' => [
        'listed' => true,
        'allowedOptions' => [
          0 => 'job',
          1 => 'targetId',
          2 => 'targetType'
        ]
      ],
      'version' => [
        'listed' => true,
        'noSystemUser' => true
      ],
      'createAdminUser' => [
        'className' => 'Espo\\Classes\\ConsoleCommands\\CreateAdminUser',
        'listed' => true
      ],
      'rebuildCategoryPaths' => [
        'className' => 'Espo\\Classes\\ConsoleCommands\\RebuildCategoryPaths',
        'listed' => true
      ],
      'populateArrayValues' => [
        'className' => 'Espo\\Classes\\ConsoleCommands\\PopulateArrayValues',
        'listed' => true
      ],
      'populateNumbers' => [
        'className' => 'Espo\\Classes\\ConsoleCommands\\PopulateNumbers',
        'listed' => false
      ],
      'checkFilePermissions' => [
        'className' => 'Espo\\Classes\\ConsoleCommands\\CheckFilePermissions',
        'listed' => true,
        'noSystemUser' => true
      ],
      'migrate' => [
        'listed' => true,
        'noSystemUser' => true
      ],
      'migrationVersionStep' => [
        'listed' => false,
        'noSystemUser' => true
      ],
      'inventoryAclCheck' => [
        'className' => 'Espo\\Modules\\Sales\\Classes\\ConsoleCommands\\InventoryAclCheck',
        'listed' => false
      ],
      'inventoryCompress' => [
        'className' => 'Espo\\Modules\\Sales\\Classes\\ConsoleCommands\\InventoryCompress',
        'listed' => true
      ],
      'inventoryDetach' => [
        'className' => 'Espo\\Modules\\Sales\\Classes\\ConsoleCommands\\InventoryDetach',
        'listed' => true
      ]
    ],
    'containerServices' => [
      'authTokenManager' => [
        'className' => 'Espo\\Core\\Authentication\\AuthToken\\EspoManager'
      ],
      'ormMetadataData' => [
        'className' => 'Espo\\Core\\Utils\\Metadata\\OrmMetadataData'
      ],
      'classFinder' => [
        'className' => 'Espo\\Core\\Utils\\ClassFinder'
      ],
      'fileStorageManager' => [
        'className' => 'Espo\\Core\\FileStorage\\Manager'
      ],
      'jobManager' => [
        'className' => 'Espo\\Core\\Job\\JobManager'
      ],
      'webSocketSubmission' => [
        'className' => 'Espo\\Core\\WebSocket\\Submission'
      ],
      'crypt' => [
        'className' => 'Espo\\Core\\Utils\\Crypt'
      ],
      'passwordHash' => [
        'className' => 'Espo\\Core\\Utils\\PasswordHash'
      ],
      'number' => [
        'loaderClassName' => 'Espo\\Core\\Loaders\\NumberUtil'
      ],
      'selectBuilderFactory' => [
        'className' => 'Espo\\Core\\Select\\SelectBuilderFactory'
      ],
      'selectManagerFactory' => [
        'className' => 'Espo\\Core\\Select\\SelectManagerFactory'
      ],
      'serviceFactory' => [
        'className' => 'Espo\\Core\\ServiceFactory'
      ],
      'recordServiceContainer' => [
        'className' => 'Espo\\Core\\Record\\ServiceContainer'
      ],
      'templateFileManager' => [
        'className' => 'Espo\\Core\\Utils\\TemplateFileManager'
      ],
      'webhookManager' => [
        'className' => 'Espo\\Core\\Webhook\\Manager'
      ],
      'hookManager' => [
        'className' => 'Espo\\Core\\HookManager'
      ],
      'clientManager' => [
        'className' => 'Espo\\Core\\Utils\\ClientManager'
      ],
      'themeManager' => [
        'className' => 'Espo\\Core\\Utils\\ThemeManager'
      ],
      'fieldUtil' => [
        'className' => 'Espo\\Core\\Utils\\FieldUtil'
      ],
      'emailSender' => [
        'className' => 'Espo\\Core\\Mail\\EmailSender'
      ],
      'mailSender' => [
        'className' => 'Espo\\Core\\Mail\\Sender'
      ],
      'htmlizerFactory' => [
        'className' => 'Espo\\Core\\Htmlizer\\HtmlizerFactory'
      ],
      'fieldValidationManager' => [
        'className' => 'Espo\\Core\\FieldValidation\\FieldValidationManager'
      ],
      'assignmentCheckerManager' => [
        'className' => 'Espo\\Core\\Acl\\AssignmentChecker\\AssignmentCheckerManager'
      ],
      'hasher' => [
        'className' => 'Espo\\Core\\Utils\\Hasher'
      ],
      'emailFilterManager' => [
        'className' => 'Espo\\Core\\Utils\\EmailFilterManager'
      ],
      'externalAccountClientManager' => [
        'className' => 'Espo\\Core\\ExternalAccount\\ClientManager'
      ],
      'formulaManager' => [
        'className' => 'Espo\\Core\\Formula\\Manager'
      ],
      'user' => [
        'settable' => true
      ],
      'streamService' => [
        'className' => 'Espo\\Tools\\Stream\\Service'
      ],
      'workflowManager' => [
        'loaderClassName' => 'Espo\\Modules\\Advanced\\Core\\Loaders\\WorkflowManager'
      ],
      'workflowHelper' => [
        'loaderClassName' => 'Espo\\Modules\\Advanced\\Core\\Loaders\\WorkflowHelper'
      ],
      'signalManager' => [
        'loaderClassName' => 'Espo\\Modules\\Advanced\\Core\\Loaders\\SignalManager'
      ]
    ],
    'currency' => [
      'symbolMap' => [
        'AED' => 'د.إ',
        'AFN' => '؋',
        'ALL' => 'L',
        'ANG' => 'ƒ',
        'AOA' => 'Kz',
        'ARS' => '$',
        'AUD' => '$',
        'AWG' => 'ƒ',
        'AZN' => '₼',
        'BAM' => 'KM',
        'BBD' => '$',
        'BDT' => '৳',
        'BGN' => 'лв',
        'BHD' => '.د.ب',
        'BIF' => 'FBu',
        'BMD' => '$',
        'BND' => '$',
        'BOB' => 'Bs.',
        'BRL' => 'R$',
        'BSD' => '$',
        'BTN' => 'Nu.',
        'BWP' => 'P',
        'BYN' => 'Br',
        'BYR' => 'p.',
        'BZD' => 'BZ$',
        'CAD' => '$',
        'CDF' => 'FC',
        'CHF' => 'Fr.',
        'CLP' => '$',
        'CNY' => '¥',
        'COP' => '$',
        'CRC' => '₡',
        'CUC' => '$',
        'CUP' => '₱',
        'CVE' => '$',
        'CZK' => 'Kč',
        'DJF' => 'Fdj',
        'DKK' => 'kr',
        'DOP' => 'RD$',
        'DZD' => 'دج',
        'EEK' => 'kr',
        'EGP' => '£',
        'ERN' => 'Nfk',
        'ETB' => 'Br',
        'EUR' => '€',
        'FJD' => '$',
        'FKP' => '£',
        'GBP' => '£',
        'GEL' => '₾',
        'GGP' => '£',
        'GHC' => '₵',
        'GHS' => 'GH₵',
        'GIP' => '£',
        'GMD' => 'D',
        'GNF' => 'FG',
        'GTQ' => 'Q',
        'GYD' => '$',
        'HKD' => '$',
        'HNL' => 'L',
        'HRK' => 'kn',
        'HTG' => 'G',
        'HUF' => 'Ft',
        'IDR' => 'Rp',
        'ILS' => '₪',
        'IMP' => '£',
        'INR' => '₹',
        'IQD' => 'ع.د',
        'IRR' => '﷼',
        'ISK' => 'kr',
        'JEP' => '£',
        'JMD' => 'J$',
        'JPY' => '¥',
        'KES' => 'KSh',
        'KGS' => 'лв',
        'KHR' => '៛',
        'KMF' => 'CF',
        'KPW' => '₩',
        'KRW' => '₩',
        'KYD' => '$',
        'KZT' => '₸',
        'LAK' => '₭',
        'LBP' => '£',
        'LKR' => '₨',
        'LRD' => '$',
        'LSL' => 'M',
        'LTL' => 'Lt',
        'LVL' => 'Ls',
        'MAD' => 'MAD',
        'MDL' => 'lei',
        'MGA' => 'Ar',
        'MKD' => 'ден',
        'MMK' => 'K',
        'MNT' => '₮',
        'MOP' => 'MOP$',
        'MUR' => '₨',
        'MVR' => 'Rf',
        'MWK' => 'MK',
        'MXN' => '$',
        'MYR' => 'RM',
        'MZN' => 'MT',
        'NAD' => '$',
        'NGN' => '₦',
        'NIO' => 'C$',
        'NOK' => 'kr',
        'NPR' => '₨',
        'NZD' => '$',
        'OMR' => '﷼',
        'PAB' => 'B/.',
        'PEN' => 'S/.',
        'PGK' => 'K',
        'PHP' => '₱',
        'PKR' => '₨',
        'PLN' => 'zł',
        'PYG' => 'Gs',
        'QAR' => '﷼',
        'RMB' => '￥',
        'RON' => 'lei',
        'RSD' => 'Дин.',
        'RUB' => '₽',
        'RWF' => 'R₣',
        'SAR' => '﷼',
        'SBD' => '$',
        'SCR' => '₨',
        'SDG' => 'ج.س.',
        'SEK' => 'kr',
        'SGD' => '$',
        'SHP' => '£',
        'SLL' => 'Le',
        'SOS' => 'S',
        'SRD' => '$',
        'SSP' => '£',
        'STD' => 'Db',
        'SVC' => '$',
        'SYP' => '£',
        'SZL' => 'E',
        'THB' => '฿',
        'TJS' => 'SM',
        'TMT' => 'T',
        'TND' => 'د.ت',
        'TOP' => 'T$',
        'TRL' => '₤',
        'TRY' => '₺',
        'TTD' => 'TT$',
        'TVD' => '$',
        'TWD' => 'NT$',
        'TZS' => 'TSh',
        'UAH' => '₴',
        'UGX' => 'USh',
        'USD' => '$',
        'UYU' => '$U',
        'UZS' => 'лв',
        'VEF' => 'Bs',
        'VND' => '₫',
        'VUV' => 'VT',
        'WST' => 'WS$',
        'XAF' => 'FCFA',
        'XBT' => 'Ƀ',
        'XCD' => '$',
        'XOF' => 'CFA',
        'XPF' => '₣',
        'YER' => '﷼',
        'ZAR' => 'R',
        'ZWD' => 'Z$',
        'BTC' => '฿'
      ],
      'list' => [
        0 => 'AFN',
        1 => 'AED',
        2 => 'ALL',
        3 => 'ANG',
        4 => 'AOA',
        5 => 'ARS',
        6 => 'AUD',
        7 => 'BAM',
        8 => 'BDT',
        9 => 'BGN',
        10 => 'BHD',
        11 => 'BND',
        12 => 'BOB',
        13 => 'BRL',
        14 => 'BWP',
        15 => 'BYN',
        16 => 'CAD',
        17 => 'CHF',
        18 => 'CLP',
        19 => 'CNY',
        20 => 'COP',
        21 => 'CRC',
        22 => 'CVE',
        23 => 'CZK',
        24 => 'DKK',
        25 => 'DOP',
        26 => 'DZD',
        27 => 'EGP',
        28 => 'EUR',
        29 => 'FJD',
        30 => 'GBP',
        31 => 'GNF',
        32 => 'GTQ',
        33 => 'HKD',
        34 => 'HNL',
        35 => 'HRK',
        36 => 'HUF',
        37 => 'IDR',
        38 => 'ILS',
        39 => 'INR',
        40 => 'IRR',
        41 => 'JMD',
        42 => 'JOD',
        43 => 'JPY',
        44 => 'KES',
        45 => 'KRW',
        46 => 'KWD',
        47 => 'KYD',
        48 => 'KZT',
        49 => 'LBP',
        50 => 'LKR',
        51 => 'MAD',
        52 => 'MDL',
        53 => 'MKD',
        54 => 'MMK',
        55 => 'MUR',
        56 => 'MXN',
        57 => 'MYR',
        58 => 'MZN',
        59 => 'NAD',
        60 => 'NGN',
        61 => 'NIO',
        62 => 'NOK',
        63 => 'NPR',
        64 => 'NZD',
        65 => 'OMR',
        66 => 'PEN',
        67 => 'PGK',
        68 => 'PHP',
        69 => 'PKR',
        70 => 'PLN',
        71 => 'PYG',
        72 => 'QAR',
        73 => 'RON',
        74 => 'RSD',
        75 => 'RUB',
        76 => 'SAR',
        77 => 'SCR',
        78 => 'SEK',
        79 => 'SGD',
        80 => 'SLL',
        81 => 'SVC',
        82 => 'THB',
        83 => 'TND',
        84 => 'TRY',
        85 => 'TTD',
        86 => 'TWD',
        87 => 'TZS',
        88 => 'UAH',
        89 => 'UGX',
        90 => 'USD',
        91 => 'UYU',
        92 => 'UZS',
        93 => 'VND',
        94 => 'XAF',
        95 => 'YER',
        96 => 'ZAR',
        97 => 'ZMW',
        98 => 'ZWL'
      ]
    ],
    'currencyConversion' => [
      'entityConverterClassNameMap' => [
        'Quote' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'SalesOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'Invoice' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'PurchaseOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'DeliveryOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'ReceiptOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'TransferOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'ReturnOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'Opportunity' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'Service' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter'
      ]
    ],
    'databasePlatforms' => [
      'Mysql' => [
        'detailsProviderClassName' => 'Espo\\Core\\Utils\\Database\\DetailsProviders\\MysqlDetailsProvider',
        'dbalConnectionFactoryClassName' => 'Espo\\Core\\Utils\\Database\\Dbal\\Factories\\MysqlConnectionFactory',
        'indexHelperClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\IndexHelpers\\MysqlIndexHelper',
        'columnPreparatorClassName' => 'Espo\\Core\\Utils\\Database\\Schema\\ColumnPreparators\\MysqlColumnPreparator',
        'preRebuildActionClassNameList' => [
          0 => 'Espo\\Core\\Utils\\Database\\Schema\\RebuildActions\\PrepareForFulltextIndex'
        ],
        'postRebuildActionClassNameList' => [],
        'dbalTypeClassNameMap' => [
          'mediumtext' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\MediumtextType',
          'longtext' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\LongtextType',
          'uuid' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\UuidType'
        ]
      ],
      'Postgresql' => [
        'detailsProviderClassName' => 'Espo\\Core\\Utils\\Database\\DetailsProviders\\PostgresqlDetailsProvider',
        'dbalConnectionFactoryClassName' => 'Espo\\Core\\Utils\\Database\\Dbal\\Factories\\PostgresqlConnectionFactory',
        'indexHelperClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\IndexHelpers\\PostgresqlIndexHelper',
        'columnPreparatorClassName' => 'Espo\\Core\\Utils\\Database\\Schema\\ColumnPreparators\\PostgresqlColumnPreparator',
        'dbalTypeClassNameMap' => [
          'uuid' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\UuidType'
        ]
      ]
    ],
    'dateTime' => [
      'dateFormatList' => [
        0 => 'DD.MM.YYYY',
        1 => 'MM/DD/YYYY',
        2 => 'DD/MM/YYYY',
        3 => 'YYYY-MM-DD',
        4 => 'DD. MM. YYYY'
      ],
      'timeFormatList' => [
        0 => 'HH:mm',
        1 => 'hh:mma',
        2 => 'hh:mmA',
        3 => 'hh:mm A',
        4 => 'hh:mm a'
      ]
    ],
    'defaultDashboardLayouts' => [
      'Standard' => [
        0 => [
          'name' => 'My Espo',
          'layout' => [
            0 => [
              'id' => 'defaultActivities',
              'name' => 'Activities',
              'x' => 2,
              'y' => 2,
              'width' => 2,
              'height' => 2
            ],
            1 => [
              'id' => 'defaultStream',
              'name' => 'Stream',
              'x' => 0,
              'y' => 0,
              'width' => 2,
              'height' => 4
            ],
            2 => [
              'id' => 'defaultTasks',
              'name' => 'Tasks',
              'x' => 2,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ]
          ]
        ]
      ]
    ],
    'defaultDashboardOptions' => [
      'Standard' => [
        'defaultStream' => [
          'displayRecords' => 10
        ]
      ]
    ],
    'emailTemplate' => [
      'placeholders' => [
        'today' => [
          'className' => 'Espo\\Tools\\EmailTemplate\\Placeholders\\Today',
          'order' => 0
        ],
        'now' => [
          'className' => 'Espo\\Tools\\EmailTemplate\\Placeholders\\Now',
          'order' => 1
        ],
        'currentYear' => [
          'className' => 'Espo\\Tools\\EmailTemplate\\Placeholders\\CurrentYear',
          'order' => 2
        ]
      ]
    ],
    'entityManager' => [
      'createHookClassNameList' => [
        0 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\PlusCreateHook',
        1 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\EventCreateHook'
      ],
      'deleteHookClassNameList' => [
        0 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\PlusDeleteHook',
        1 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\EventDeleteHook',
        2 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\DeleteHasChildrenLinks'
      ],
      'updateHookClassNameList' => [
        0 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\AssignedUsersUpdateHook',
        1 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\CollaboratorsUpdateHook',
        2 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\StreamUpdateHook'
      ]
    ],
    'entityManagerParams' => [
      'Global' => [
        'stars' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'optimisticConcurrencyControl' => [
          'location' => 'entityDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'preserveAuditLog' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      '@Company' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      '@Person' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true
          ],
          'view' => 'views/admin/entity-manager/fields/acl-account-link'
        ]
      ],
      '@Base' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      '@BasePlus' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      'Account' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Contact' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Lead' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Opportunity' => [
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Document' => [
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Case' => [
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'KnowledgeBaseArticle' => [
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Meeting' => [
        'activityStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'historyStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'completedStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ]
      ],
      'Call' => [
        'activityStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'historyStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'completedStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ]
      ],
      'Task' => [
        'completedStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'TargetList' => [
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      '@Event' => [
        'activityStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'historyStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'completedStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      'Product' => [
        'variantSyncFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/product-variant-sync-field-list',
            'tooltip' => 'productVariantSyncFieldList'
          ]
        ]
      ],
      'SalesOrder' => [
        'softReserveStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'salesOrderSoftReserveStatusList'
          ]
        ],
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'salesOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'salesOrderCanceledStatusList'
          ]
        ],
        'deliveryRequiredStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'deliveryRequiredStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'DeliveryOrder' => [
        'softReserveStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderSoftReserveStatusList'
          ]
        ],
        'reserveStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderReserveStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderCanceledStatusList'
          ]
        ],
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderDoneStatusList'
          ]
        ],
        'failedStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderFailedStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'TransferOrder' => [
        'softReserveStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderSoftReserveStatusList'
          ]
        ],
        'reserveStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderReserveStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderCanceledStatusList'
          ]
        ],
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderDoneStatusList'
          ]
        ],
        'failedStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderFailedStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'PurchaseOrder' => [
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/purchase-order-status-list',
            'tooltip' => 'purchaseOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/purchase-order-status-list',
            'tooltip' => 'purchaseOrderCanceledStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'ReceiptOrder' => [
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/receipt-order-status-list',
            'tooltip' => 'receiptOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/receipt-order-status-list',
            'tooltip' => 'receiptOrderCanceledStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'Quote' => [
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/quote-status-list',
            'tooltip' => 'quoteDoneStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/quote-status-list',
            'tooltip' => 'quoteCanceledStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'Invoice' => [
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/invoice-status-list',
            'tooltip' => 'invoiceDoneStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/invoice-status-list',
            'tooltip' => 'invoiceCanceledStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'ReturnOrder' => [
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/return-order-status-list',
            'tooltip' => 'returnOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/return-order-status-list',
            'tooltip' => 'returnOrderCanceledStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'InventoryAdjustment' => [
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ]
    ],
    'entityTemplateList' => [
      0 => 'Base',
      1 => 'BasePlus',
      2 => 'Event',
      3 => 'Person',
      4 => 'Company'
    ],
    'entityTemplates' => [
      'Base' => [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Base',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Base'
      ],
      'BasePlus' => [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\BasePlus',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\BasePlus'
      ],
      'Event' => [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Event',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Event'
      ],
      'Company' => [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Company',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Company'
      ],
      'Person' => [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Person',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Person'
      ]
    ],
    'export' => [
      'formatList' => [
        0 => 'xlsx',
        1 => 'csv'
      ],
      'formatDefs' => [
        'csv' => [
          'processorClassName' => 'Espo\\Tools\\Export\\Format\\Csv\\Processor',
          'additionalFieldsLoaderClassName' => 'Espo\\Tools\\Export\\Format\\Csv\\AdditionalFieldsLoader',
          'mimeType' => 'text/csv',
          'fileExtension' => 'csv'
        ],
        'xlsx' => [
          'processorClassName' => 'Espo\\Tools\\Export\\Format\\Xlsx\\Processor',
          'processorParamsHandler' => 'Espo\\Tools\\Export\\Format\\Xlsx\\ParamsHandler',
          'additionalFieldsLoaderClassName' => 'Espo\\Tools\\Export\\Format\\Xlsx\\AdditionalFieldsLoader',
          'mimeType' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
          'fileExtension' => 'xlsx',
          'cellValuePreparatorClassNameMap' => [
            'link' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'linkOne' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'linkParent' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'file' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'bool' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Boolean',
            'int' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Integer',
            'float' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Floating',
            'currency' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Currency',
            'currencyConverted' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\CurrencyConverted',
            'personName' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\PersonName',
            'date' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Date',
            'datetime' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\DateTime',
            'datetimeOptional' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\DateTimeOptional',
            'linkMultiple' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\LinkMultiple',
            'attachmentMultiple' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\LinkMultiple',
            'address' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Address',
            'duration' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Duration',
            'enum' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Enumeration',
            'multiEnum' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum',
            'array' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum',
            'checklist' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum',
            'urlMultiple' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum'
          ],
          'params' => [
            'fields' => [
              'lite' => [
                'type' => 'bool',
                'default' => false,
                'tooltip' => true
              ],
              'recordLinks' => [
                'type' => 'bool',
                'default' => false
              ],
              'title' => [
                'type' => 'bool',
                'default' => false,
                'tooltip' => true
              ]
            ],
            'layout' => [
              0 => [
                0 => [
                  'name' => 'lite'
                ],
                1 => [
                  'name' => 'recordLinks'
                ],
                2 => [
                  'name' => 'title'
                ]
              ]
            ],
            'dynamicLogic' => [
              'recordLinks' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isFalse',
                      'attribute' => 'xlsxLite'
                    ]
                  ]
                ]
              ],
              'title' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isFalse',
                      'attribute' => 'xlsxLite'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'gridReportFormatList' => [
        0 => 'xlsx',
        1 => 'csv'
      ]
    ],
    'fieldProcessing' => [
      'readLoaderClassNameList' => [
        0 => 'Espo\\Core\\FieldProcessing\\Link\\HasOneLoader',
        1 => 'Espo\\Core\\FieldProcessing\\Link\\NotJoinedLoader',
        2 => 'Espo\\Core\\FieldProcessing\\LinkMultiple\\Loader',
        3 => 'Espo\\Core\\FieldProcessing\\LinkParent\\Loader',
        4 => 'Espo\\Core\\FieldProcessing\\EmailAddress\\Loader',
        5 => 'Espo\\Core\\FieldProcessing\\PhoneNumber\\Loader',
        6 => 'Espo\\Core\\FieldProcessing\\Stream\\FollowersLoader',
        7 => 'Espo\\Core\\FieldProcessing\\Stars\\StarLoader',
        8 => 'Espo\\Modules\\EblaLinkPro\\Core\\FieldProcessing\\LinkMultiple\\ListLoader'
      ],
      'listLoaderClassNameList' => [
        0 => 'Espo\\Core\\FieldProcessing\\LinkParent\\Loader',
        1 => 'Espo\\Core\\FieldProcessing\\LinkMultiple\\ListLoader'
      ],
      'saverClassNameList' => [
        0 => 'Espo\\Core\\FieldProcessing\\EmailAddress\\Saver',
        1 => 'Espo\\Core\\FieldProcessing\\PhoneNumber\\Saver',
        2 => 'Espo\\Core\\FieldProcessing\\Relation\\Saver',
        3 => 'Espo\\Core\\FieldProcessing\\MultiEnum\\Saver',
        4 => 'Espo\\Core\\FieldProcessing\\File\\Saver',
        5 => 'Espo\\Core\\FieldProcessing\\Wysiwyg\\Saver'
      ]
    ],
    'file' => [
      'extensionMimeTypeMap' => [
        'aac' => [
          0 => 'audio/aac'
        ],
        'abw' => [
          0 => 'application/x-abiword'
        ],
        'arc' => [
          0 => 'application/x-freearc'
        ],
        'avif' => [
          0 => 'image/avif'
        ],
        'avi' => [
          0 => 'video/x-msvideo'
        ],
        'azw' => [
          0 => 'application/vnd.amazon.ebook'
        ],
        'bin' => [
          0 => 'application/octet-stream'
        ],
        'bmp' => [
          0 => 'image/bmp'
        ],
        'bz' => [
          0 => 'application/x-bzip'
        ],
        'bz2' => [
          0 => 'application/x-bzip2'
        ],
        'cda' => [
          0 => 'application/x-cdf'
        ],
        'csh' => [
          0 => 'application/x-csh'
        ],
        'css' => [
          0 => 'text/css'
        ],
        'csv' => [
          0 => 'text/csv'
        ],
        'doc' => [
          0 => 'application/msword'
        ],
        'docx' => [
          0 => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
        ],
        'eot' => [
          0 => 'application/vnd.ms-fontobject'
        ],
        'epub' => [
          0 => 'application/epub+zip'
        ],
        'gz' => [
          0 => 'application/gzip'
        ],
        'gif' => [
          0 => 'image/gif'
        ],
        'htm' => [
          0 => 'text/html'
        ],
        'html' => [
          0 => 'text/html'
        ],
        'ico' => [
          0 => 'image/vnd.microsoft.icon'
        ],
        'ics' => [
          0 => 'text/calendar'
        ],
        'jar' => [
          0 => 'application/java-archive'
        ],
        'jpeg' => [
          0 => 'image/jpeg'
        ],
        'jpg' => [
          0 => 'image/jpeg'
        ],
        'js' => [
          0 => 'text/javascript'
        ],
        'json' => [
          0 => 'application/json'
        ],
        'jsonld' => [
          0 => 'application/ld+json'
        ],
        'mid' => [
          0 => 'audio/midi',
          1 => 'audio/x-midi'
        ],
        'midi' => [
          0 => 'audio/midi',
          1 => 'audio/x-midi'
        ],
        'mjs' => [
          0 => 'text/javascript'
        ],
        'mp3' => [
          0 => 'audio/mpeg'
        ],
        'mp4' => [
          0 => 'video/mp4'
        ],
        'mpeg' => [
          0 => 'video/mpeg'
        ],
        'mpkg' => [
          0 => 'application/vnd.apple.installer+xml'
        ],
        'odp' => [
          0 => 'application/vnd.oasis.opendocument.presentation'
        ],
        'ods' => [
          0 => 'application/vnd.oasis.opendocument.spreadsheet'
        ],
        'odt' => [
          0 => 'application/vnd.oasis.opendocument.text'
        ],
        'oga' => [
          0 => 'audio/ogg'
        ],
        'ogv' => [
          0 => 'video/ogg'
        ],
        'ogx' => [
          0 => 'application/ogg'
        ],
        'opus' => [
          0 => 'audio/opus'
        ],
        'otf' => [
          0 => 'font/otf'
        ],
        'png' => [
          0 => 'image/png'
        ],
        'pdf' => [
          0 => 'application/pdf'
        ],
        'php' => [
          0 => 'application/x-httpd-php'
        ],
        'ppt' => [
          0 => 'application/vnd.ms-powerpoint'
        ],
        'pptx' => [
          0 => 'application/vnd.openxmlformats-officedocument.presentationml.presentation'
        ],
        'rar' => [
          0 => 'application/vnd.rar'
        ],
        'rtf' => [
          0 => 'application/rtf'
        ],
        'sh' => [
          0 => 'application/x-sh'
        ],
        'svg' => [
          0 => 'image/svg+xml'
        ],
        'swf' => [
          0 => 'application/x-shockwave-flash'
        ],
        'tar' => [
          0 => 'application/x-tar'
        ],
        'tif' => [
          0 => 'image/tiff'
        ],
        'tiff' => [
          0 => 'image/tiff'
        ],
        'ts' => [
          0 => 'video/mp2t'
        ],
        'ttf' => [
          0 => 'font/ttf'
        ],
        'txt' => [
          0 => 'text/plain'
        ],
        'vsd' => [
          0 => 'application/vnd.visio'
        ],
        'wav' => [
          0 => 'audio/wav'
        ],
        'weba' => [
          0 => 'audio/webm'
        ],
        'webm' => [
          0 => 'video/webm'
        ],
        'webp' => [
          0 => 'image/webp'
        ],
        'woff' => [
          0 => 'font/woff'
        ],
        'woff2' => [
          0 => 'font/woff2'
        ],
        'xhtml' => [
          0 => 'application/xhtml+xml'
        ],
        'xls' => [
          0 => 'application/vnd.ms-excel'
        ],
        'xlsx' => [
          0 => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
        ],
        'xml' => [
          0 => 'application/xml'
        ],
        'xul' => [
          0 => 'application/vnd.mozilla.xul+xml'
        ],
        'zip' => [
          0 => 'application/zip'
        ],
        '3gp' => [
          0 => 'video/3gpp',
          1 => 'audio/3gpp'
        ],
        '3g2' => [
          0 => 'video/3gpp2',
          1 => 'audio/3gpp2'
        ],
        '7z' => [
          0 => 'application/x-7z-compressed'
        ],
        'md' => [
          0 => 'text/markdown'
        ]
      ],
      'inlineMimeTypeList' => [
        0 => 'application/pdf',
        1 => 'text/plain',
        2 => 'audio/wav',
        3 => 'audio/mpeg',
        4 => 'audio/ogg',
        5 => 'audio/webm',
        6 => 'video/mpeg',
        7 => 'video/mp4',
        8 => 'video/ogg',
        9 => 'video/webm',
        10 => 'image/jpeg',
        11 => 'image/png',
        12 => 'image/gif',
        13 => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        14 => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        15 => 'application/vnd.ms-word',
        16 => 'application/vnd.ms-excel',
        17 => 'application/vnd.oasis.opendocument.text',
        18 => 'application/vnd.oasis.opendocument.spreadsheet',
        19 => 'application/msword',
        20 => 'application/msexcel'
      ]
    ],
    'fileStorage' => [
      'implementationClassNameMap' => [
        'EspoUploadDir' => 'Espo\\Core\\FileStorage\\Storages\\EspoUploadDir',
        'AwsS3' => 'Espo\\Core\\FileStorage\\Storages\\AwsS3'
      ]
    ],
    'formula' => [
      'functionList' => [
        0 => [
          'name' => 'ifThenElse',
          'insertText' => 'ifThenElse(CONDITION, CONSEQUENT, ALTERNATIVE)'
        ],
        1 => [
          'name' => 'ifThen',
          'insertText' => 'ifThen(CONDITION, CONSEQUENT)'
        ],
        2 => [
          'name' => 'list',
          'insertText' => 'list(ITEM_1, ITEM_2)',
          'returnType' => 'array'
        ],
        3 => [
          'name' => 'string\\concatenate',
          'insertText' => 'string\\concatenate(STRING_1, STRING_2)',
          'returnType' => 'string'
        ],
        4 => [
          'name' => 'string\\substring',
          'insertText' => 'string\\substring(STRING, START, LENGTH)',
          'returnType' => 'string'
        ],
        5 => [
          'name' => 'string\\contains',
          'insertText' => 'string\\contains(STRING, NEEDLE)',
          'returnType' => 'bool'
        ],
        6 => [
          'name' => 'string\\pos',
          'insertText' => 'string\\pos(STRING, NEEDLE)',
          'returnType' => 'int'
        ],
        7 => [
          'name' => 'string\\pad',
          'insertText' => 'string\\pad(STRING, LENGTH, PAD_STRING)',
          'returnType' => 'string'
        ],
        8 => [
          'name' => 'string\\test',
          'insertText' => 'string\\test(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'bool'
        ],
        9 => [
          'name' => 'string\\length',
          'insertText' => 'string\\length(STRING)',
          'returnType' => 'int'
        ],
        10 => [
          'name' => 'string\\trim',
          'insertText' => 'string\\trim(STRING)',
          'returnType' => 'string'
        ],
        11 => [
          'name' => 'string\\lowerCase',
          'insertText' => 'string\\lowerCase(STRING)',
          'returnType' => 'string'
        ],
        12 => [
          'name' => 'string\\upperCase',
          'insertText' => 'string\\upperCase(STRING)',
          'returnType' => 'string'
        ],
        13 => [
          'name' => 'string\\match',
          'insertText' => 'string\\match(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'string|null'
        ],
        14 => [
          'name' => 'string\\matchAll',
          'insertText' => 'string\\matchAll(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'string[]|null'
        ],
        15 => [
          'name' => 'string\\matchExtract',
          'insertText' => 'string\\matchExtract(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'string[]|null'
        ],
        16 => [
          'name' => 'string\\replace',
          'insertText' => 'string\\replace(STRING, SEARCH, REPLACE)',
          'returnType' => 'string'
        ],
        17 => [
          'name' => 'string\\split',
          'insertText' => 'string\\split(STRING, SEPARATOR)',
          'returnType' => 'string[]'
        ],
        18 => [
          'name' => 'datetime\\today',
          'insertText' => 'datetime\\today()',
          'returnType' => 'string'
        ],
        19 => [
          'name' => 'datetime\\now',
          'insertText' => 'datetime\\now()',
          'returnType' => 'string'
        ],
        20 => [
          'name' => 'datetime\\format',
          'insertText' => 'datetime\\format(VALUE)',
          'returnType' => 'string'
        ],
        21 => [
          'name' => 'datetime\\date',
          'insertText' => 'datetime\\date(VALUE)',
          'returnType' => 'int'
        ],
        22 => [
          'name' => 'datetime\\month',
          'insertText' => 'datetime\\month(VALUE)',
          'returnType' => 'int'
        ],
        23 => [
          'name' => 'datetime\\year',
          'insertText' => 'datetime\\year(VALUE)',
          'returnType' => 'int'
        ],
        24 => [
          'name' => 'datetime\\hour',
          'insertText' => 'datetime\\hour(VALUE)',
          'returnType' => 'int'
        ],
        25 => [
          'name' => 'datetime\\minute',
          'insertText' => 'datetime\\minute(VALUE)',
          'returnType' => 'int'
        ],
        26 => [
          'name' => 'datetime\\dayOfWeek',
          'insertText' => 'datetime\\dayOfWeek(VALUE)',
          'returnType' => 'int'
        ],
        27 => [
          'name' => 'datetime\\addMinutes',
          'insertText' => 'datetime\\addMinutes(VALUE, MINUTES)',
          'returnType' => 'string'
        ],
        28 => [
          'name' => 'datetime\\addHours',
          'insertText' => 'datetime\\addHours(VALUE, HOURS)',
          'returnType' => 'string'
        ],
        29 => [
          'name' => 'datetime\\addDays',
          'insertText' => 'datetime\\addDays(VALUE, DAYS)',
          'returnType' => 'string'
        ],
        30 => [
          'name' => 'datetime\\addWeeks',
          'insertText' => 'datetime\\addWeeks(VALUE, WEEKS)',
          'returnType' => 'string'
        ],
        31 => [
          'name' => 'datetime\\addMonths',
          'insertText' => 'datetime\\addMonths(VALUE, MONTHS)',
          'returnType' => 'string'
        ],
        32 => [
          'name' => 'datetime\\addYears',
          'insertText' => 'datetime\\addYears(VALUE, YEARS)',
          'returnType' => 'string'
        ],
        33 => [
          'name' => 'datetime\\diff',
          'insertText' => 'datetime\\diff(VALUE_1, VALUE_2, INTERVAL_TYPE)',
          'returnType' => 'int'
        ],
        34 => [
          'name' => 'datetime\\closest',
          'insertText' => 'datetime\\closest(VALUE, TYPE, TARGET, IS_PAST, TIMEZONE)',
          'returnType' => 'string'
        ],
        35 => [
          'name' => 'number\\format',
          'insertText' => 'number\\format(VALUE)',
          'returnType' => 'string'
        ],
        36 => [
          'name' => 'number\\abs',
          'insertText' => 'number\\abs(VALUE)'
        ],
        37 => [
          'name' => 'number\\power',
          'insertText' => 'number\\power(VALUE, EXP)',
          'returnType' => 'int|float'
        ],
        38 => [
          'name' => 'number\\round',
          'insertText' => 'number\\round(VALUE, PRECISION)',
          'returnType' => 'int|float'
        ],
        39 => [
          'name' => 'number\\floor',
          'insertText' => 'number\\floor(VALUE)',
          'returnType' => 'int'
        ],
        40 => [
          'name' => 'number\\ceil',
          'insertText' => 'number\\ceil(VALUE)',
          'returnType' => 'int'
        ],
        41 => [
          'name' => 'number\\randomInt',
          'insertText' => 'number\\randomInt(MIN, MAX)',
          'returnType' => 'int'
        ],
        42 => [
          'name' => 'number\\parseInt',
          'insertText' => 'number\\parseInt(STRING)',
          'returnType' => 'int'
        ],
        43 => [
          'name' => 'number\\parseFloat',
          'insertText' => 'number\\parseFloat(STRING)',
          'returnType' => 'float'
        ],
        44 => [
          'name' => 'entity\\isNew',
          'insertText' => 'entity\\isNew()',
          'returnType' => 'bool'
        ],
        45 => [
          'name' => 'entity\\isAttributeChanged',
          'insertText' => 'entity\\isAttributeChanged(ATTRIBUTE)',
          'returnType' => 'bool'
        ],
        46 => [
          'name' => 'entity\\isAttributeNotChanged',
          'insertText' => 'entity\\isAttributeNotChanged(ATTRIBUTE)',
          'returnType' => 'bool'
        ],
        47 => [
          'name' => 'entity\\attribute',
          'insertText' => 'entity\\attribute(ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        48 => [
          'name' => 'entity\\attributeFetched',
          'insertText' => 'entity\\attributeFetched(ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        49 => [
          'name' => 'entity\\setAttribute',
          'insertText' => 'entity\\setAttribute(ATTRIBUTE, VALUE)',
          'unsafe' => true
        ],
        50 => [
          'name' => 'entity\\clearAttribute',
          'insertText' => 'entity\\clearAttribute(ATTRIBUTE)',
          'unsafe' => true
        ],
        51 => [
          'name' => 'entity\\addLinkMultipleId',
          'insertText' => 'entity\\addLinkMultipleId(LINK, ID)',
          'unsafe' => true
        ],
        52 => [
          'name' => 'entity\\hasLinkMultipleId',
          'insertText' => 'entity\\hasLinkMultipleId(LINK, ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        53 => [
          'name' => 'entity\\removeLinkMultipleId',
          'insertText' => 'entity\\removeLinkMultipleId(LINK, ID)',
          'unsafe' => true
        ],
        54 => [
          'name' => 'entity\\getLinkColumn',
          'insertText' => 'entity\\getLinkColumn(LINK, ID, COLUMN)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        55 => [
          'name' => 'entity\\setLinkMultipleColumn',
          'insertText' => 'entity\\setLinkMultipleColumn(LINK, ID, COLUMN, VALUE)',
          'unsafe' => true
        ],
        56 => [
          'name' => 'entity\\isRelated',
          'insertText' => 'entity\\isRelated(LINK, ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        57 => [
          'name' => 'entity\\sumRelated',
          'insertText' => 'entity\\sumRelated(LINK, FIELD, FILTER)',
          'returnType' => 'int|float',
          'unsafe' => true
        ],
        58 => [
          'name' => 'entity\\countRelated',
          'insertText' => 'entity\\countRelated(LINK, FILTER)',
          'returnType' => 'int',
          'unsafe' => true
        ],
        59 => [
          'name' => 'record\\exists',
          'insertText' => 'record\\exists(ENTITY_TYPE, KEY, VALUE)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        60 => [
          'name' => 'record\\count',
          'insertText' => 'record\\count(ENTITY_TYPE, KEY, VALUE)',
          'returnType' => 'int',
          'unsafe' => true
        ],
        61 => [
          'name' => 'record\\attribute',
          'insertText' => 'record\\attribute(ENTITY_TYPE, ID, ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        62 => [
          'name' => 'record\\findOne',
          'insertText' => 'record\\findOne(ENTITY_TYPE, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        63 => [
          'name' => 'record\\findMany',
          'insertText' => 'record\\findMany(ENTITY_TYPE, LIMIT, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        64 => [
          'name' => 'record\\findRelatedOne',
          'insertText' => 'record\\findRelatedOne(ENTITY_TYPE, ID, LINK, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        65 => [
          'name' => 'record\\findRelatedMany',
          'insertText' => 'record\\findRelatedMany(ENTITY_TYPE, ID, LINK, LIMIT, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string[]',
          'unsafe' => true
        ],
        66 => [
          'name' => 'record\\fetch',
          'insertText' => 'record\\fetch(ENTITY_TYPE, ID)',
          'returnType' => '?object',
          'unsafe' => true
        ],
        67 => [
          'name' => 'record\\relate',
          'insertText' => 'record\\relate(ENTITY_TYPE, ID, LINK, FOREIGN_ID)',
          'unsafe' => true
        ],
        68 => [
          'name' => 'record\\unrelate',
          'insertText' => 'record\\unrelate(ENTITY_TYPE, ID, LINK, FOREIGN_ID)',
          'unsafe' => true
        ],
        69 => [
          'name' => 'record\\create',
          'insertText' => 'record\\create(ENTITY_TYPE, ATTRIBUTE1, VALUE1, ATTRIBUTE2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        70 => [
          'name' => 'record\\update',
          'insertText' => 'record\\update(ENTITY_TYPE, ID, ATTRIBUTE1, VALUE1, ATTRIBUTE2, VALUE2)',
          'unsafe' => true
        ],
        71 => [
          'name' => 'record\\delete',
          'insertText' => 'record\\delete(ENTITY_TYPE, ID)',
          'unsafe' => true
        ],
        72 => [
          'name' => 'record\\relationColumn',
          'insertText' => 'record\\relationColumn(ENTITY_TYPE, ID, LINK, FOREIGN_ID, COLUMN)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        73 => [
          'name' => 'record\\updateRelationColumn',
          'insertText' => 'record\\updateRelationColumn(ENTITY_TYPE, ID, LINK, FOREIGN_ID, COLUMN, VALUE)',
          'unsafe' => true
        ],
        74 => [
          'name' => 'env\\userAttribute',
          'insertText' => 'env\\userAttribute(ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        75 => [
          'name' => 'util\\generateId',
          'insertText' => 'util\\generateId()',
          'returnType' => 'string'
        ],
        76 => [
          'name' => 'util\\generateRecordId',
          'insertText' => 'util\\generateRecordId()',
          'returnType' => 'string'
        ],
        77 => [
          'name' => 'util\\base64Encode',
          'insertText' => 'util\\base64Encode(STRING)',
          'returnType' => 'string'
        ],
        78 => [
          'name' => 'util\\base64Decode',
          'insertText' => 'util\\base64Decode(STRING)',
          'returnType' => 'string'
        ],
        79 => [
          'name' => 'object\\create',
          'insertText' => 'object\\create()',
          'returnType' => 'object'
        ],
        80 => [
          'name' => 'object\\get',
          'insertText' => 'object\\get(OBJECT, KEY)',
          'returnType' => 'mixed'
        ],
        81 => [
          'name' => 'object\\has',
          'insertText' => 'object\\has(OBJECT, KEY)',
          'returnType' => 'bool'
        ],
        82 => [
          'name' => 'object\\set',
          'insertText' => 'object\\set(OBJECT, KEY, VALUE)'
        ],
        83 => [
          'name' => 'object\\clear',
          'insertText' => 'object\\clear(OBJECT, KEY)',
          'returnType' => 'object'
        ],
        84 => [
          'name' => 'object\\cloneDeep',
          'insertText' => 'object\\cloneDeep(OBJECT)',
          'returnType' => 'object'
        ],
        85 => [
          'name' => 'password\\generate',
          'insertText' => 'password\\generate()',
          'returnType' => 'string'
        ],
        86 => [
          'name' => 'password\\hash',
          'insertText' => 'password\\hash(PASSWORD)',
          'returnType' => 'string'
        ],
        87 => [
          'name' => 'array\\includes',
          'insertText' => 'array\\includes(LIST, VALUE)',
          'returnType' => 'bool'
        ],
        88 => [
          'name' => 'array\\push',
          'insertText' => 'array\\push(LIST, VALUE)'
        ],
        89 => [
          'name' => 'array\\length',
          'insertText' => 'array\\length(LIST)',
          'returnType' => 'int'
        ],
        90 => [
          'name' => 'array\\at',
          'insertText' => 'array\\at(LIST, INDEX)',
          'returnType' => 'mixed'
        ],
        91 => [
          'name' => 'array\\join',
          'insertText' => 'array\\join(LIST, SEPARATOR)',
          'returnType' => 'string'
        ],
        92 => [
          'name' => 'array\\indexOf',
          'insertText' => 'array\\indexOf(LIST, ELEMENT)',
          'returnType' => '?int'
        ],
        93 => [
          'name' => 'array\\removeAt',
          'insertText' => 'array\\removeAt(LIST, INDEX)',
          'returnType' => 'array'
        ],
        94 => [
          'name' => 'array\\unique',
          'insertText' => 'array\\unique(LIST)',
          'returnType' => 'array'
        ],
        95 => [
          'name' => 'language\\translate',
          'insertText' => 'language\\translate(LABEL, CATEGORY, SCOPE)',
          'returnType' => 'string'
        ],
        96 => [
          'name' => 'language\\translateOption',
          'insertText' => 'language\\translateOption(OPTION, FIELD, SCOPE)',
          'returnType' => 'string'
        ],
        97 => [
          'name' => 'log\\info',
          'insertText' => 'log\\info(MESSAGE)',
          'unsafe' => true
        ],
        98 => [
          'name' => 'log\\notice',
          'insertText' => 'log\\notice(MESSAGE)',
          'unsafe' => true
        ],
        99 => [
          'name' => 'log\\warning',
          'insertText' => 'log\\warning(MESSAGE)',
          'unsafe' => true
        ],
        100 => [
          'name' => 'log\\error',
          'insertText' => 'log\\error(MESSAGE)',
          'unsafe' => true
        ],
        101 => [
          'name' => 'json\\retrieve',
          'insertText' => 'json\\retrieve(JSON, PATH)',
          'returnType' => 'mixed'
        ],
        102 => [
          'name' => 'json\\encode',
          'insertText' => 'json\\encode(VALUE)',
          'returnType' => 'string'
        ],
        103 => [
          'name' => 'ext\\email\\send',
          'insertText' => 'ext\\email\\send(EMAIL_ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        104 => [
          'name' => 'ext\\sms\\send',
          'insertText' => 'ext\\sms\\send(SMS_ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        105 => [
          'name' => 'ext\\email\\applyTemplate',
          'insertText' => 'ext\\email\\applyTemplate(EMAIL_ID, EMAIL_TEMPLATE_ID)',
          'unsafe' => true
        ],
        106 => [
          'name' => 'ext\\markdown\\transform',
          'insertText' => 'ext\\markdown\\transform(STRING)',
          'returnType' => 'string'
        ],
        107 => [
          'name' => 'ext\\pdf\\generate',
          'insertText' => 'ext\\pdf\\generate(ENTITY_TYPE, ENTITY_ID, TEMPLATE_ID, FILENAME)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        108 => [
          'name' => 'ext\\workingTime\\addWorkingDays',
          'insertText' => 'ext\\workingTime\\addWorkingDays(DATE, DAYS)',
          'returnType' => 'string|null'
        ],
        109 => [
          'name' => 'ext\\workingTime\\findClosestWorkingTime',
          'insertText' => 'ext\\workingTime\\findClosestWorkingTime(DATE)',
          'returnType' => 'string|null'
        ],
        110 => [
          'name' => 'ext\\workingTime\\getSummedWorkingHours',
          'insertText' => 'ext\\workingTime\\getSummedWorkingHours(FROM, TO)',
          'returnType' => 'float'
        ],
        111 => [
          'name' => 'ext\\workingTime\\getWorkingDays',
          'insertText' => 'ext\\workingTime\\getWorkingDays(FROM, TO)',
          'returnType' => 'int'
        ],
        112 => [
          'name' => 'ext\\workingTime\\hasWorkingTime',
          'insertText' => 'ext\\workingTime\\hasWorkingTime(FROM, TO)',
          'returnType' => 'bool'
        ],
        113 => [
          'name' => 'ext\\workingTime\\isWorkingDay',
          'insertText' => 'ext\\workingTime\\isWorkingDay(DATE)',
          'returnType' => 'bool'
        ],
        114 => [
          'name' => 'ext\\user\\sendAccessInfo',
          'insertText' => 'ext\\user\\sendAccessInfo(USER_ID)',
          'unsafe' => true
        ],
        115 => [
          'name' => 'ext\\email\\send',
          'insertText' => 'ext\\email\\send(EMAIL_ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        116 => [
          'name' => 'ext\\currency\\convert',
          'insertText' => 'ext\\currency\\convert(AMOUNT, FROM_CODE)',
          'returnType' => 'string'
        ],
        117 => [
          'name' => 'ext\\acl\\checkEntity',
          'insertText' => 'ext\\acl\\checkEntity(USER_ID, ENTITY_TYPE, ID, ACTION)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        118 => [
          'name' => 'ext\\acl\\checkScope',
          'insertText' => 'ext\\acl\\checkScope(USER_ID, SCOPE, ACTION)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        119 => [
          'name' => 'ext\\acl\\getLevel',
          'insertText' => 'ext\\acl\\getLevel(USER_ID, SCOPE, ACTION)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        120 => [
          'name' => 'ext\\acl\\getPermissionLevel',
          'insertText' => 'ext\\acl\\getPermissionLevel(USER_ID, PERMISSION)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        121 => [
          'name' => 'ext\\account\\findByEmailAddress',
          'insertText' => 'ext\\account\\findByEmailAddress(EMAIL_ADDRESS)',
          'returnType' => 'string'
        ],
        122 => [
          'name' => 'ext\\calendar\\userIsBusy',
          'insertText' => 'ext\\calendar\\userIsBusy(USER_ID, FROM, TO)',
          'returnType' => 'bool'
        ],
        123 => [
          'name' => 'report\\export',
          'insertText' => 'report\\export(REPORT_ID)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        124 => [
          'name' => 'report\\recordAttribute',
          'unsafe' => true
        ],
        125 => [
          'name' => 'bpm\\processEntity\\attribute',
          'insertText' => 'bpm\\processEntity\\attribute(ATTRIBUTE_NAME)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        126 => [
          'name' => 'bpm\\targetEntity\\attribute',
          'insertText' => 'bpm\\targetEntity\\attribute(ATTRIBUTE_NAME)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        127 => [
          'name' => 'bpm\\createdEntity\\attribute',
          'insertText' => 'bpm\\createdEntity\\attribute(ALIAS_ID, ATTRIBUTE_NAME)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        128 => [
          'name' => 'bpm\\broadcastSignal',
          'insertText' => 'bpm\\broadcastSignal(SIGNAL_NAME, [ENTITY_TYPE], [ENTITY_ID])',
          'unsafe' => true
        ],
        129 => [
          'name' => 'bpm\\startProcess',
          'insertText' => 'bpm\\startProcess(FLOWCHART_ID, TARGET_TYPE, TARGET_ID)',
          'unsafe' => true
        ],
        130 => [
          'name' => 'bpm\\caughtErrorCode',
          'insertText' => 'bpm\\caughtErrorCode()',
          'returnType' => '?string',
          'unsafe' => true
        ],
        131 => [
          'name' => 'bpm\\caughtErrorMessage',
          'insertText' => 'bpm\\caughtErrorMessage()',
          'returnType' => '?string',
          'unsafe' => true
        ],
        132 => [
          'name' => 'workflow\\targetEntity\\attribute',
          'insertText' => 'workflow\\targetEntity\\attribute(ATTRIBUTE_NAME)',
          'unsafe' => true
        ],
        133 => [
          'name' => 'workflow\\targetEntity\\attributeFetched',
          'insertText' => 'workflow\\targetEntity\\attributeFetched(ATTRIBUTE_NAME)',
          'unsafe' => true
        ],
        134 => [
          'name' => 'workflow\\trigger',
          'insertText' => 'workflow\\trigger(ENTITY_TYPE, ID, WORKFLOW_ID)',
          'unsafe' => true
        ],
        135 => [
          'name' => 'workflow\\lastHttpResponseBody',
          'insertText' => 'workflow\\lastHttpResponseBody()',
          'returnType' => 'string|null',
          'unsafe' => true
        ],
        136 => [
          'name' => 'workflow\\lastHttpResponseCode',
          'insertText' => 'workflow\\lastHttpResponseCode()',
          'returnType' => 'int|null',
          'unsafe' => true
        ],
        137 => [
          'name' => 'workflow\\signalParam',
          'insertText' => 'workflow\\signalParam(NAME)',
          'returnType' => 'mixed',
          'unsafe' => true
        ]
      ],
      'functionClassNameMap' => [
        'log\\info' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\InfoType',
        'log\\notice' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\NoticeType',
        'log\\warning' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\WarningType',
        'log\\error' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\ErrorType',
        'ext\\acl\\checkEntity' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\CheckEntityType',
        'ext\\acl\\checkScope' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\CheckScopeType',
        'ext\\acl\\getLevel' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\GetLevelType',
        'ext\\acl\\getPermissionLevel' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\GetPermissionLevelType',
        'util\\base64Encode' => 'Espo\\Core\\Formula\\Functions\\UtilGroup\\Base64EncodeType',
        'util\\base64Decode' => 'Espo\\Core\\Formula\\Functions\\UtilGroup\\Base64DecodeType',
        'ext\\account\\findByEmailAddress' => 'Espo\\Modules\\Crm\\Classes\\FormulaFunctions\\ExtGroup\\AccountGroup\\FindByEmailAddressType',
        'ext\\calendar\\userIsBusy' => 'Espo\\Modules\\Crm\\Classes\\FormulaFunctions\\ExtGroup\\CalendarGroup\\UserIsBusyType',
        'processEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\ProcessEntityGroup\\AttributeType',
        'bpm\\broadcastSignal' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\BroadcastSignalType',
        'bpm\\processEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\ProcessEntityGroup\\AttributeType',
        'bpm\\createdEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\CreatedEntityGroup\\AttributeType',
        'bpm\\targetEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeType',
        'bpm\\startProcess' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\StartProcessType',
        'bpm\\caughtErrorMessage' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\CaughtErrorMessage',
        'bpm\\caughtErrorCode' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\CaughtErrorCode',
        'targetEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeType',
        'targetEntity\\attributeFetched' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeFetchedType',
        'targetEntity\\isAttributeChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeChangedType',
        'targetEntity\\isAttributeNotChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeNotChangedType',
        'targetEntity\\isNew' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsNewType',
        'targetEntity\\isRelated' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsRelatedType',
        'targetEntity\\hasLinkMultipleId' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\HasLinkMultipleIdType',
        'workflow\\lastHttpResponseBody' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\LastHttpResponseBodyType',
        'workflow\\lastHttpResponseCode' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\LastHttpResponseCodeType',
        'workflow\\trigger' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\TriggerType',
        'workflow\\targetEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeType',
        'workflow\\targetEntity\\attributeFetched' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeFetchedType',
        'workflow\\targetEntity\\isAttributeChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeChangedType',
        'workflow\\targetEntity\\isAttributeNotChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeNotChangedType',
        'workflow\\signalParam' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\SignalParamType',
        'report\\recordAttribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\ReportGroup\\RecordAttribute',
        'report\\export' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\ReportGroup\\Export',
        'ext\\priceRule\\productAttribute' => 'Espo\\Modules\\Sales\\Classes\\FormulaFunctions\\PriceRule\\ProductAttribute',
        'ext\\priceRule\\accountAttribute' => 'Espo\\Modules\\Sales\\Classes\\FormulaFunctions\\PriceRule\\AccountAttribute'
      ]
    ],
    'hook' => [
      'suppressClassNameList' => []
    ],
    'image' => [
      'allowedFileTypeList' => [
        0 => 'image/jpeg',
        1 => 'image/png',
        2 => 'image/gif',
        3 => 'image/webp',
        4 => 'image/svg+xml'
      ],
      'resizableFileTypeList' => [
        0 => 'image/jpeg',
        1 => 'image/png',
        2 => 'image/gif',
        3 => 'image/webp'
      ],
      'fixOrientationFileTypeList' => [
        0 => 'image/jpeg'
      ],
      'previewFileTypeList' => [
        0 => 'image/jpeg',
        1 => 'image/png',
        2 => 'image/gif',
        3 => 'image/webp',
        4 => 'image/svg+xml'
      ],
      'sizes' => [
        'xxx-small' => [
          0 => 18,
          1 => 18
        ],
        'xx-small' => [
          0 => 32,
          1 => 32
        ],
        'x-small' => [
          0 => 64,
          1 => 64
        ],
        'small' => [
          0 => 128,
          1 => 128
        ],
        'medium' => [
          0 => 256,
          1 => 256
        ],
        'large' => [
          0 => 512,
          1 => 512
        ],
        'x-large' => [
          0 => 864,
          1 => 864
        ],
        'xx-large' => [
          0 => 1024,
          1 => 1024
        ],
        'small-logo' => [
          0 => 181,
          1 => 44
        ]
      ]
    ],
    'jsLibs' => [
      'jquery' => [
        'exposeAs' => '$'
      ],
      'backbone' => [
        'exportsTo' => 'window',
        'exportsAs' => 'Backbone'
      ],
      'bullbone' => [
        'exposeAs' => 'Bull'
      ],
      'handlebars' => [
        'exposeAs' => 'Handlebars'
      ],
      'underscore' => [
        'exposeAs' => '_'
      ],
      'marked' => [],
      'dompurify' => [
        'exposeAs' => 'DOMPurify'
      ],
      'js-base64' => [
        'exportsTo' => 'window',
        'exportsAs' => 'Base64'
      ],
      'moment' => [
        'exportsTo' => 'window',
        'exportsAs' => 'moment'
      ],
      'flotr2' => [
        'path' => 'client/lib/flotr2.js',
        'devPath' => 'client/lib/original/flotr2.js',
        'exportsTo' => 'window',
        'exportsAs' => 'Flotr',
        'sourceMap' => true,
        'aliases' => [
          0 => 'lib!Flotr'
        ]
      ],
      'espo-funnel-chart' => [
        'path' => 'client/lib/espo-funnel-chart.js',
        'exportsTo' => 'window',
        'exportsAs' => 'EspoFunnel'
      ],
      'summernote' => [
        'path' => 'client/lib/summernote.js',
        'devPath' => 'client/lib/original/summernote.js',
        'exportsTo' => '$.fn',
        'exportsAs' => 'summernote',
        'sourceMap' => true
      ],
      'jquery-ui' => [
        'exportsTo' => '$',
        'exportsAs' => 'ui'
      ],
      'jquery-ui-touch-punch' => [
        'exportsTo' => '$',
        'exportsAs' => 'ui'
      ],
      'jquery-textcomplete' => [
        'exportsTo' => '$.fn',
        'exportsAs' => 'textcomplete'
      ],
      'autocomplete' => [
        'exportsTo' => '$.fn',
        'exportsAs' => 'autocomplete'
      ],
      'timepicker' => [
        'exportsTo' => '$.fn',
        'exportsAs' => 'timepicker'
      ],
      'bootstrap-datepicker' => [
        'exportsTo' => '$.fn',
        'exportsAs' => 'datepicker'
      ],
      'selectize' => [
        'path' => 'client/lib/selectize.js',
        'devPath' => 'client/lib/original/selectize.js',
        'exportsTo' => 'window',
        'exportsAs' => 'Selectize'
      ],
      'autonumeric' => [],
      'intl-tel-input' => [
        'exportsTo' => 'window',
        'exportsAs' => 'intlTelInput'
      ],
      'intl-tel-input-utils' => [
        'exportsTo' => 'window',
        'exportsAs' => 'intlTelInputUtils'
      ],
      'intl-tel-input-globals' => [
        'exportsTo' => 'window',
        'exportsAs' => 'intlTelInputGlobals'
      ],
      'cronstrue' => [
        'path' => 'client/lib/cronstrue-i18n.js',
        'devPath' => 'client/lib/original/cronstrue-i18n.js',
        'sourceMap' => true
      ],
      'cropper' => [
        'path' => 'client/lib/cropper.js',
        'exportsTo' => '$.fn',
        'exportsAs' => 'cropper',
        'sourceMap' => true
      ],
      'gridstack' => [
        'exportsTo' => 'window',
        'exportsAs' => 'GridStack'
      ],
      'bootstrap-colorpicker' => [
        'path' => 'client/lib/bootstrap-colorpicker.js',
        'exportsTo' => '$.fn',
        'exportsAs' => 'colorpicker',
        'aliases' => [
          0 => 'lib!Colorpicker'
        ]
      ],
      'exif-js' => [
        'path' => 'client/lib/exif.js',
        'devPath' => 'client/lib/original/exif.js',
        'sourceMap' => true
      ],
      'jsbarcode' => [
        'path' => 'client/lib/JsBarcode.all.js',
        'devPath' => 'client/lib/original/JsBarcode.all.js',
        'exportsTo' => 'window',
        'exportsAs' => 'JsBarcode',
        'sourceMap' => true
      ],
      'qrcodejs' => [
        'path' => 'client/lib/qrcode.js',
        'exportsTo' => 'window',
        'exportsAs' => 'QRCode'
      ],
      'turndown' => [
        'path' => 'client/lib/turndown.browser.umd.js',
        'devPath' => 'client/lib/turndown.browser.umd.js',
        'sourceMap' => true
      ],
      'ace' => [
        'path' => 'client/lib/ace.js',
        'exportsTo' => 'window',
        'exportsAs' => 'ace'
      ],
      'ace-mode-css' => [
        'path' => 'client/lib/ace-mode-css.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/css'
      ],
      'ace-mode-html' => [
        'path' => 'client/lib/ace-mode-html.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/html'
      ],
      'ace-mode-handlebars' => [
        'path' => 'client/lib/ace-mode-handlebars.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/handlebars'
      ],
      'ace-mode-javascript' => [
        'path' => 'client/lib/ace-mode-javascript.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/javascript'
      ],
      'ace-ext-language_tools' => [
        'path' => 'client/lib/ace-ext-language_tools.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/ext/language_tools'
      ],
      'ace-theme-tomorrow_night' => [
        'path' => 'client/lib/ace-theme-tomorrow_night.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/theme/tomorrow_night'
      ],
      'fullcalendar' => [
        'path' => 'client/modules/crm/lib/fullcalendar.js',
        'devPath' => 'client/modules/crm/lib/original/fullcalendar.js',
        'exportsTo' => 'window',
        'exportsAs' => 'FullCalendar',
        'sourceMap' => true
      ],
      '@fullcalendar/moment' => [
        'path' => 'client/modules/crm/lib/fullcalendar-moment.js',
        'devPath' => 'client/modules/crm/lib/original/fullcalendar-moment.js',
        'exportsTo' => 'FullCalendar',
        'exportsAs' => 'Moment',
        'sourceMap' => true
      ],
      '@fullcalendar/moment-timezone' => [
        'path' => 'client/modules/crm/lib/fullcalendar-moment-timezone.js',
        'devPath' => 'client/modules/crm/lib/original/fullcalendar-moment-timezone.js',
        'exportsTo' => 'FullCalendar',
        'exportsAs' => 'MomentTimezone',
        'sourceMap' => true
      ],
      'vis-timeline' => [
        'path' => 'client/modules/crm/lib/vis-timeline.js',
        'devPath' => 'client/modules/crm/lib/original/vis-timeline.js',
        'sourceMap' => true
      ],
      'vis-data' => [
        'path' => 'client/modules/crm/lib/vis-data.js',
        'devPath' => 'client/modules/crm/lib/original/vis-data.js',
        'aliases' => [
          0 => 'vis-data/peer/umd/vis-data.js'
        ],
        'sourceMap' => true
      ],
      'draggable-project' => [
        'path' => 'client/custom/modules/project/lib/draggable-project.js'
      ],
      'vis-timeline-project' => [
        'path' => 'client/custom/modules/project/lib/vis-timeline.js'
      ],
      'vis-data-project' => [
        'path' => 'client/custom/modules/project/lib/vis-data.js'
      ],
      'swal' => [
        'path' => 'client/custom/src/js/swal.js',
        'exportsTo' => 'window',
        'exportsAs' => 'swal',
        'sourceMap' => false
      ]
    ],
    'language' => [
      'list' => [
        0 => 'en_US',
        1 => 'ar_AR',
        2 => 'bg_BG',
        3 => 'en_GB',
        4 => 'es_MX',
        5 => 'cs_CZ',
        6 => 'da_DK',
        7 => 'de_DE',
        8 => 'es_ES',
        9 => 'hr_HR',
        10 => 'hu_HU',
        11 => 'fa_IR',
        12 => 'fr_FR',
        13 => 'id_ID',
        14 => 'it_IT',
        15 => 'lt_LT',
        16 => 'lv_LV',
        17 => 'nb_NO',
        18 => 'nl_NL',
        19 => 'th_TH',
        20 => 'tr_TR',
        21 => 'sk_SK',
        22 => 'sl_SI',
        23 => 'sr_RS',
        24 => 'sv_SE',
        25 => 'ro_RO',
        26 => 'ru_RU',
        27 => 'pl_PL',
        28 => 'pt_BR',
        29 => 'pt_PT',
        30 => 'uk_UA',
        31 => 'vi_VN',
        32 => 'zh_CN',
        33 => 'zh_TW'
      ],
      'aclDependencies' => [
        'Meeting' => [
          'anyScopeList' => [
            0 => 'Call'
          ]
        ],
        'Workflow' => [
          'anyScopeList' => [
            0 => 'BpmnProcess',
            1 => 'BpmnFlowchart'
          ]
        ],
        'BpmnFlowchart' => [
          'anyScopeList' => [
            0 => 'BpmnProcess'
          ]
        ],
        'Opportunity' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'Invoice',
            3 => 'PurchaseOrder',
            4 => 'DeliveryOrder',
            5 => 'ReceiptOrder',
            6 => 'TransferOrder',
            7 => 'ReturnOrder'
          ]
        ],
        'Quote' => [
          'anyScopeList' => [
            0 => 'SalesOrder',
            1 => 'Invoice',
            2 => 'Opportunity',
            3 => 'PurchaseOrder',
            4 => 'DeliveryOrder',
            5 => 'ReceiptOrder',
            6 => 'TransferOrder',
            7 => 'ReturnOrder',
            8 => 'InventoryAdjustment',
            9 => 'Product'
          ]
        ],
        'QuoteItem' => [
          'anyScopeList' => [
            0 => 'Product',
            1 => 'SalesOrder',
            2 => 'Invoice',
            3 => 'Opportunity',
            4 => 'PurchaseOrder',
            5 => 'DeliveryOrder',
            6 => 'ReceiptOrder',
            7 => 'TransferOrder',
            8 => 'ReturnOrder',
            9 => 'InventoryAdjustment'
          ]
        ],
        'SalesOrder' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'Invoice'
          ]
        ],
        'Invoice' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder'
          ]
        ],
        'PurchaseOrder' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'Invoice',
            2 => 'SalesOrder',
            3 => 'ReturnOrder'
          ]
        ],
        'ReturnOrder' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder'
          ]
        ],
        'DeliveryOrder' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'TransferOrder'
          ]
        ],
        'DeliveryOrderItem' => [
          'anyScopeList' => [
            0 => 'ReceiptOrder'
          ]
        ],
        'ReceiptOrder' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'PurchaseOrder'
          ]
        ],
        'Account' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'Invoice'
          ]
        ],
        'Warehouse' => [
          'anyScopeList' => [
            0 => 'SalesOrder',
            1 => 'DeliveryOrder',
            2 => 'ReceiptOrder',
            3 => 'PurchaseOrder',
            4 => 'TransferOrder',
            5 => 'InventoryAdjustment',
            6 => 'InventoryTransaction'
          ]
        ],
        'Product' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'Invoice',
            2 => 'PurchaseOrder',
            3 => 'SalesOrder',
            4 => 'DeliveryOrder',
            5 => 'ReceiptOrder',
            6 => 'TransferOrder',
            7 => 'InventoryTransaction',
            8 => 'InventoryAdjustment',
            9 => 'ReturnOrder',
            10 => 'Warehouse',
            11 => 'PriceBook',
            12 => 'Supplier'
          ]
        ],
        'PriceRule' => [
          'anyScopeList' => [
            0 => 'Product',
            1 => 'ProductPrice',
            2 => 'SupplierProductPrice'
          ]
        ],
        'Service' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'Invoice'
          ]
        ],
        'ProjectBoard' => [
          'anyScopeList' => [
            0 => 'Project'
          ]
        ],
        'ProjectGroup' => [
          'anyScopeList' => [
            0 => 'Project'
          ]
        ],
        'ProjectColumn' => [
          'anyScopeList' => [
            0 => 'Project'
          ]
        ],
        'ProjectTask' => [
          'anyScopeList' => [
            0 => 'Project'
          ]
        ],
        'ProjectRole' => [
          'anyScopeList' => [
            0 => 'Project'
          ]
        ]
      ]
    ],
    'layouts' => [],
    'linkManager' => [
      'createHookClassNameList' => [
        0 => 'Espo\\Tools\\LinkManager\\Hook\\Hooks\\TargetListCreate'
      ],
      'deleteHookClassNameList' => [
        0 => 'Espo\\Tools\\LinkManager\\Hook\\Hooks\\TargetListDelete',
        1 => 'Espo\\Tools\\LinkManager\\Hook\\Hooks\\ForeignFieldDelete'
      ]
    ],
    'mapProviders' => [
      'Google' => [
        'renderer' => 'handlers/map/google-maps-renderer'
      ]
    ],
    'massActions' => [
      'convertCurrency' => [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassConvertCurrency'
      ],
      'follow' => [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassFollow'
      ],
      'unfollow' => [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassUnfollow'
      ],
      'recalculateFormula' => [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassRecalculateFormula'
      ],
      'update' => [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassUpdate'
      ],
      'delete' => [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassDelete'
      ]
    ],
    'metadata' => [
      'frontendHiddenPathList' => [
        0 => [
          0 => 'app',
          1 => 'metadata'
        ],
        1 => [
          0 => 'app',
          1 => 'containerServices'
        ],
        2 => [
          0 => 'app',
          1 => 'portalContainerServices'
        ],
        3 => [
          0 => 'app',
          1 => 'consoleCommands'
        ],
        4 => [
          0 => 'app',
          1 => 'formula',
          2 => 'functionClassNameMap'
        ],
        5 => [
          0 => 'app',
          1 => 'fileStorage',
          2 => 'implementationClassNameMap'
        ],
        6 => [
          0 => 'app',
          1 => 'client'
        ],
        7 => [
          0 => 'app',
          1 => 'language',
          2 => 'aclDependencies'
        ],
        8 => [
          0 => 'app',
          1 => 'templateHelpers'
        ],
        9 => [
          0 => 'app',
          1 => 'appParams'
        ],
        10 => [
          0 => 'app',
          1 => 'cleanup'
        ],
        11 => [
          0 => 'app',
          1 => 'authentication'
        ],
        12 => [
          0 => 'app',
          1 => 'pdfEngines',
          2 => '__ANY__',
          3 => 'implementationClassNameMap'
        ],
        13 => [
          0 => 'app',
          1 => 'addressFormats',
          2 => '__ANY__',
          3 => 'formatterClassName'
        ],
        14 => [
          0 => 'app',
          1 => 'authentication2FAMethods',
          2 => '__ANY__',
          3 => 'loginClassName'
        ],
        15 => [
          0 => 'app',
          1 => 'authentication2FAMethods',
          2 => '__ANY__',
          3 => 'userSetupClassName'
        ],
        16 => [
          0 => 'app',
          1 => 'select'
        ],
        17 => [
          0 => 'app',
          1 => 'massActions',
          2 => '__ANY__',
          3 => 'implementationClassName'
        ],
        18 => [
          0 => 'app',
          1 => 'actions',
          2 => '__ANY__',
          3 => 'implementationClassName'
        ],
        19 => [
          0 => 'app',
          1 => 'fieldProcessing'
        ],
        20 => [
          0 => 'app',
          1 => 'scheduledJobs'
        ],
        21 => [
          0 => 'app',
          1 => 'webSocket',
          2 => 'messagers'
        ],
        22 => [
          0 => 'app',
          1 => 'config'
        ],
        23 => [
          0 => 'app',
          1 => 'rebuild'
        ],
        24 => [
          0 => 'app',
          1 => 'smsProviders',
          2 => '__ANY__',
          3 => 'senderClassName'
        ],
        25 => [
          0 => 'app',
          1 => 'orm'
        ],
        26 => [
          0 => 'app',
          1 => 'relationships'
        ],
        27 => [
          0 => 'app',
          1 => 'linkManager'
        ],
        28 => [
          0 => 'app',
          1 => 'hook'
        ],
        29 => [
          0 => 'app',
          1 => 'api'
        ],
        30 => [
          0 => 'app',
          1 => 'databasePlatforms'
        ],
        31 => [
          0 => 'app',
          1 => 'recordId'
        ],
        32 => [
          0 => 'app',
          1 => 'currencyConversion'
        ],
        33 => [
          0 => 'selectDefs'
        ],
        34 => [
          0 => 'pdfDefs'
        ],
        35 => [
          0 => 'notificationDefs',
          1 => '__ANY__',
          2 => 'assignmentNotificatorClassName'
        ],
        36 => [
          0 => 'authenticationMethods',
          1 => '__ANY__',
          2 => 'implementationClassName'
        ],
        37 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'accessCheckerClassName'
        ],
        38 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'portalAccessCheckerClassName'
        ],
        39 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'ownershipCheckerClassName'
        ],
        40 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'portalOwnershipCheckerClassName'
        ],
        41 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'assignmentCheckerClassName'
        ],
        42 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'linkCheckerClassNameMap'
        ],
        43 => [
          0 => 'app',
          1 => 'calendar',
          2 => 'additionalAttributeList'
        ]
      ],
      'frontendNonAdminHiddenPathList' => [
        0 => [
          0 => 'recordDefs'
        ]
      ],
      'additionalBuilderClassNameList' => [
        0 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\Fields',
        1 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\FilterFields',
        2 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\DeleteIdField',
        3 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\StreamUpdatedAtField'
      ],
      'aclDependencies' => []
    ],
    'orm' => [
      'platforms' => [
        'Mysql' => [
          'queryComposerClassName' => 'Espo\\ORM\\QueryComposer\\MysqlQueryComposer',
          'pdoFactoryClassName' => 'Espo\\ORM\\PDO\\MysqlPDOFactory',
          'functionConverterClassNameMap' => [
            'ABS' => 'Espo\\Core\\ORM\\QueryComposer\\Part\\FunctionConverters\\Abs'
          ]
        ],
        'Postgresql' => [
          'queryComposerClassName' => 'Espo\\ORM\\QueryComposer\\PostgresqlQueryComposer',
          'pdoFactoryClassName' => 'Espo\\ORM\\PDO\\PostgresqlPDOFactory',
          'functionConverterClassNameMap' => [
            'ABS' => 'Espo\\Core\\ORM\\QueryComposer\\Part\\FunctionConverters\\Abs'
          ]
        ]
      ]
    ],
    'pdfEngines' => [
      'Dompdf' => [
        'implementationClassNameMap' => [
          'entity' => 'Espo\\Tools\\Pdf\\Dompdf\\EntityPrinter'
        ],
        'fontFaceList' => [
          0 => 'Courier',
          1 => 'Helvetica',
          2 => 'Times',
          3 => 'Symbol',
          4 => 'ZapfDingbats',
          5 => 'DejaVu Sans',
          6 => 'DejaVu Serif',
          7 => 'DejaVu Sans Mono'
        ]
      ]
    ],
    'portalContainerServices' => [
      'layoutProvider' => [
        'className' => 'Espo\\Tools\\Layout\\PortalLayoutProvider'
      ],
      'themeManager' => [
        'className' => 'Espo\\Core\\Portal\\Utils\\ThemeManager'
      ]
    ],
    'reactions' => [
      'list' => [
        0 => [
          'type' => 'Smile',
          'iconClass' => 'far fa-face-smile'
        ],
        1 => [
          'type' => 'Surprise',
          'iconClass' => 'far fa-face-surprise'
        ],
        2 => [
          'type' => 'Laugh',
          'iconClass' => 'far fa-face-laugh'
        ],
        3 => [
          'type' => 'Meh',
          'iconClass' => 'far fa-face-meh'
        ],
        4 => [
          'type' => 'Sad',
          'iconClass' => 'far fa-face-frown'
        ],
        5 => [
          'type' => 'Love',
          'iconClass' => 'far fa-heart'
        ],
        6 => [
          'type' => 'Like',
          'iconClass' => 'far fa-thumbs-up'
        ],
        7 => [
          'type' => 'Dislike',
          'iconClass' => 'far fa-thumbs-down'
        ]
      ]
    ],
    'rebuild' => [
      'actionClassNameList' => [
        0 => 'Espo\\Core\\Rebuild\\Actions\\AddSystemUser',
        1 => 'Espo\\Core\\Rebuild\\Actions\\AddSystemData',
        2 => 'Espo\\Core\\Rebuild\\Actions\\CurrencyRates',
        3 => 'Espo\\Core\\Rebuild\\Actions\\ScheduledJobs',
        4 => 'Espo\\Core\\Rebuild\\Actions\\ConfigMetadataCheck',
        5 => 'Espo\\Core\\Rebuild\\Actions\\GenerateInstanceId'
      ]
    ],
    'record' => [
      'selectApplierClassNameList' => [
        0 => 'Espo\\Core\\Select\\Applier\\AdditionalAppliers\\IsStarred'
      ]
    ],
    'recordId' => [
      'length' => 24
    ],
    'regExpPatterns' => [
      'noBadCharacters' => [
        'pattern' => '[^<>=]+'
      ],
      'noAsciiSpecialCharacters' => [
        'pattern' => '[^`~!@#$%^&*()_+={}\\[\\]|\\\\:;"\'<,>.?]+'
      ],
      'latinLetters' => [
        'pattern' => '[A-Za-z]+'
      ],
      'latinLettersDigits' => [
        'pattern' => '[A-Za-z0-9]+'
      ],
      'latinLettersDigitsWhitespace' => [
        'pattern' => '[A-Za-z0-9 ]+'
      ],
      'latinLettersWhitespace' => [
        'pattern' => '[A-Za-z ]+'
      ],
      'digits' => [
        'pattern' => '[0-9]+'
      ],
      'id' => [
        'pattern' => '[A-Za-z0-9_=\\-\\.]+',
        'isSystem' => true
      ],
      'phoneNumberLoose' => [
        'pattern' => '[0-9A-Za-z_@:#\\+\\(\\)\\-\\. ]+',
        'isSystem' => true
      ],
      'uriOptionalProtocol' => [
        'pattern' => '([a-zA-Z0-9]+\\:\\/\\/)?[a-zA-Z0-9%\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',]+\\.([a-zA-Z0-9%\\&\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',~])*',
        'isSystem' => true
      ],
      'uri' => [
        'pattern' => '([a-zA-Z0-9]+\\:\\/\\/){1}[a-zA-Z0-9%\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',]+\\.([a-zA-Z0-9%\\&\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',~])*',
        'isSystem' => true
      ]
    ],
    'relationships' => [
      'attachments' => [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\Attachments'
      ],
      'emailEmailAddress' => [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EmailEmailAddress'
      ],
      'entityTeam' => [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EntityTeam'
      ],
      'entityUser' => [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EntityUser'
      ],
      'entityCollaborator' => [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EntityCollaborator'
      ],
      'smsPhoneNumber' => [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\SmsPhoneNumber'
      ]
    ],
    'scheduledJobs' => [
      'ProcessJobGroup' => [
        'name' => 'Process Job Group',
        'isSystem' => true,
        'scheduling' => '* * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobGroup',
        'preparatorClassName' => 'Espo\\Core\\Job\\Preparator\\Preparators\\ProcessJobGroupPreparator'
      ],
      'ProcessJobQueueQ0' => [
        'name' => 'Process Job Queue q0',
        'isSystem' => true,
        'scheduling' => '* * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobQueueQ0'
      ],
      'ProcessJobQueueQ1' => [
        'name' => 'Process Job Queue q1',
        'isSystem' => true,
        'scheduling' => '*/1 * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobQueueQ1'
      ],
      'ProcessJobQueueE0' => [
        'name' => 'Process Job Queue e0',
        'isSystem' => true,
        'scheduling' => '* * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobQueueE0'
      ],
      'Dummy' => [
        'isSystem' => true,
        'scheduling' => '1 */12 * * *',
        'jobClassName' => 'Espo\\Classes\\Jobs\\Dummy'
      ],
      'CheckNewVersion' => [
        'name' => 'Check for New Version',
        'isSystem' => true,
        'scheduling' => '15 5 * * *',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckNewVersion'
      ],
      'CheckNewExtensionVersion' => [
        'name' => 'Check for New Versions of Installed Extensions',
        'isSystem' => true,
        'scheduling' => '25 5 * * *',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckNewExtensionVersion'
      ],
      'Cleanup' => [
        'jobClassName' => 'Espo\\Classes\\Jobs\\Cleanup'
      ],
      'AuthTokenControl' => [
        'jobClassName' => 'Espo\\Classes\\Jobs\\AuthTokenControl'
      ],
      'SendEmailNotifications' => [
        'jobClassName' => 'Espo\\Classes\\Jobs\\SendEmailNotifications'
      ],
      'ProcessWebhookQueue' => [
        'jobClassName' => 'Espo\\Classes\\Jobs\\ProcessWebhookQueue'
      ],
      'CheckEmailAccounts' => [
        'preparatorClassName' => 'Espo\\Classes\\JobPreparators\\CheckEmailAccounts',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckEmailAccounts'
      ],
      'CheckInboundEmails' => [
        'preparatorClassName' => 'Espo\\Classes\\JobPreparators\\CheckInboundEmails',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckInboundEmails'
      ],
      'SendScheduledEmails' => [
        'jobClassName' => 'Espo\\Classes\\Jobs\\SendScheduledEmails'
      ],
      'AdvancedPack' => [
        'isSystem' => true,
        'scheduling' => '3 3 * * *',
        'jobClassName' => 'Espo\\Modules\\Advanced\\Core\\App\\Job'
      ],
      'SalesJob' => [
        'isSystem' => true,
        'scheduling' => '3 5 * * *',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\App\\Job'
      ],
      'InventoryCompress' => [
        'scheduling' => '10 0 * * 6',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\Jobs\\InventoryCompress'
      ],
      'NotActualOrderLocking' => [
        'scheduling' => '10 1 * * 6',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\Jobs\\NotActualOrderLocking'
      ],
      'InventoryDetach' => [
        'scheduling' => '10 2 * * 6',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\Jobs\\InventoryDetach'
      ],
      'ProjectJob' => [
        'isSystem' => true,
        'scheduling' => '0 2 * * *',
        'jobClassName' => 'Espo\\Modules\\Project\\Classes\\App\\Job'
      ]
    ],
    'select' => [
      'whereItemConverterClassNameMap' => [
        'inCategory' => 'Espo\\Core\\Select\\Where\\ItemConverters\\InCategory',
        'isUserFromTeams' => 'Espo\\Core\\Select\\Where\\ItemConverters\\IsUserFromTeams'
      ]
    ],
    'smsProviders' => [],
    'templateHelpers' => [
      'googleMapsImage' => 'Espo\\Classes\\TemplateHelpers\\GoogleMaps',
      'markdownText' => 'Espo\\Classes\\TemplateHelpers\\MarkdownText',
      'tableTag' => 'Espo\\Classes\\TemplateHelpers\\TableTag',
      'trTag' => 'Espo\\Classes\\TemplateHelpers\\TrTag',
      'tdTag' => 'Espo\\Classes\\TemplateHelpers\\TdTag',
      'reportTable' => 'Espo\\Modules\\Advanced\\Core\\TemplateHelpers\\Report'
    ],
    'templates' => [
      'accessInfo' => [
        'scope' => 'User'
      ],
      'accessInfoPortal' => [
        'scope' => 'User'
      ],
      'assignment' => [
        'scopeListConfigParam' => 'assignmentEmailNotificationsEntityList'
      ],
      'mention' => [
        'scope' => 'Note'
      ],
      'noteEmailReceived' => [
        'scope' => 'Note'
      ],
      'notePost' => [
        'scope' => 'Note'
      ],
      'notePostNoParent' => [
        'scope' => 'Note'
      ],
      'noteStatus' => [
        'scope' => 'Note'
      ],
      'passwordChangeLink' => [
        'scope' => 'User'
      ],
      'twoFactorCode' => [
        'scope' => 'User'
      ],
      'invitation' => [
        'scopeList' => [
          0 => 'Meeting',
          1 => 'Call'
        ],
        'module' => 'Crm'
      ],
      'cancellation' => [
        'scopeList' => [
          0 => 'Meeting',
          1 => 'Call'
        ],
        'module' => 'Crm'
      ],
      'reminder' => [
        'scopeList' => [
          0 => 'Meeting',
          1 => 'Call',
          2 => 'Task'
        ],
        'module' => 'Crm'
      ],
      'reportSendingGrid1' => [
        'scope' => 'Report',
        'module' => 'Advanced'
      ],
      'reportSendingGrid2' => [
        'scope' => 'Report',
        'module' => 'Advanced'
      ],
      'reportSendingList' => [
        'scope' => 'Report',
        'module' => 'Advanced'
      ],
      'salesEmailPdf' => [
        'scopeList' => [
          0 => 'Quote',
          1 => 'SalesOrder',
          2 => 'Invoice',
          3 => 'PurchaseOrder',
          4 => 'DeliveryOrder',
          5 => 'ReceiptOrder',
          6 => 'TransferOrder',
          7 => 'ReturnOrder'
        ],
        'module' => 'Sales'
      ]
    ],
    'webSocket' => [
      'categories' => [
        'newNotification' => [],
        'recordUpdate' => [
          'paramList' => [
            0 => 'scope',
            1 => 'id'
          ],
          'accessCheckCommand' => 'AclCheck --userId=:userId --scope=:scope --id=:id --action=read'
        ],
        'streamUpdate' => [
          'paramList' => [
            0 => 'scope',
            1 => 'id'
          ],
          'accessCheckCommand' => 'AclCheck --userId=:userId --scope=:scope --id=:id --action=stream'
        ],
        'popupNotifications.event' => [],
        'inventoryQuantityUpdate' => [
          'accessCheckCommand' => 'InventoryAclCheck --userId=:userId'
        ]
      ],
      'messagers' => [
        'ZeroMQ' => [
          'senderClassName' => 'Espo\\Core\\WebSocket\\ZeroMQSender',
          'subscriberClassName' => 'Espo\\Core\\WebSocket\\ZeroMQSubscriber'
        ]
      ]
    ],
    'calendar' => [
      'additionalAttributeList' => [
        0 => 'color'
      ]
    ],
    'popupNotifications' => [
      'event' => [
        'grouped' => true,
        'providerClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\PopupNotificationsProvider',
        'useWebSocket' => true,
        'portalDisabled' => true,
        'view' => 'crm:views/meeting/popup-notification'
      ]
    ],
    'workflow' => [
      'serviceActions' => [
        'Meeting' => [
          'sendEventInvitations' => [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Meeting\\SendInvitations'
          ]
        ],
        'Call' => [
          'sendEventInvitations' => [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Meeting\\SendInvitations'
          ]
        ],
        'Contact' => [
          'optOut' => [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Person\\OptOut'
          ]
        ],
        'Lead' => [
          'optOut' => [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Person\\OptOut'
          ]
        ],
        'Account' => [
          'optOut' => [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Person\\OptOut'
          ]
        ],
        'User' => [
          'generateAndSendPassword' => [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\User\\GenerateAndSendPassword'
          ]
        ],
        'Quote' => [
          'addQuoteItemList' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ],
        'Invoice' => [
          'addInvoiceItemList' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ],
        'SalesOrder' => [
          'addSalesOrderItemList' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ],
        'Opportunity' => [
          'convertCurrency' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ]
        ],
        'Service' => [
          'addServiceItemList' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ]
      ]
    ],
    'eInvoice' => [
      'formatList' => [
        0 => 'Peppol',
        1 => 'XRechnung',
        2 => 'CiusAtGov',
        3 => 'CiusAtNat',
        4 => 'CiusEsFace',
        5 => 'CiusIt',
        6 => 'CiusRo',
        7 => 'Nlcius'
      ],
      'easCodeList' => [
        0 => '0002',
        1 => '0007',
        2 => '0009',
        3 => '0037',
        4 => '0060',
        5 => '0088',
        6 => '0096',
        7 => '0097',
        8 => '0106',
        9 => '0130',
        10 => '0135',
        11 => '0142',
        12 => '0147',
        13 => '0151',
        14 => '0170',
        15 => '0183',
        16 => '0184',
        17 => '0188',
        18 => '0190',
        19 => '0191',
        20 => '0192',
        21 => '0193',
        22 => '0194',
        23 => '0195',
        24 => '0196',
        25 => '0198',
        26 => '0199',
        27 => '0200',
        28 => '0201',
        29 => '0202',
        30 => '0203',
        31 => '0204',
        32 => '0205',
        33 => '0208',
        34 => '0209',
        35 => '0210',
        36 => '0211',
        37 => '0212',
        38 => '0213',
        39 => '0215',
        40 => '0216',
        41 => '0217',
        42 => '0218',
        43 => '0221',
        44 => '0225',
        45 => '0230',
        46 => '9901',
        47 => '9910',
        48 => '9913',
        49 => '9914',
        50 => '9915',
        51 => '9918',
        52 => '9919',
        53 => '9920',
        54 => '9922',
        55 => '9923',
        56 => '9924',
        57 => '9925',
        58 => '9926',
        59 => '9927',
        60 => '9928',
        61 => '9929',
        62 => '9930',
        63 => '9931',
        64 => '9932',
        65 => '9933',
        66 => '9934',
        67 => '9935',
        68 => '9936',
        69 => '9937',
        70 => '9938',
        71 => '9939',
        72 => '9940',
        73 => '9941',
        74 => '9942',
        75 => '9943',
        76 => '9944',
        77 => '9945',
        78 => '9946',
        79 => '9947',
        80 => '9948',
        81 => '9949',
        82 => '9950',
        83 => '9951',
        84 => '9952',
        85 => '9953',
        86 => '9957',
        87 => '9959',
        88 => 'AN',
        89 => 'AQ',
        90 => 'AS',
        91 => 'AU',
        92 => 'EM'
      ],
      'easNames' => [
        9901 => 'Danish Ministry of the Interior and Health',
        9910 => 'Hungary VAT number',
        9913 => 'Business Registers Network',
        9914 => 'Österreichische Umsatzsteuer-Identifikationsnummer',
        9915 => 'Österreichisches Verwaltungs bzw. Organisationskennzeichen',
        9918 => 'SOCIETY FOR WORLDWIDE INTERBANK FINANCIAL, TELECOMMUNICATION S.W.I.F.T',
        9919 => 'Kennziffer des Unternehmensregisters',
        9920 => 'Agencia Española de Administración Tributaria',
        9922 => 'Andorra VAT number',
        9923 => 'Albania VAT number',
        9924 => 'Bosnia and Herzegovina VAT number',
        9925 => 'Belgium VAT number',
        9926 => 'Bulgaria VAT number',
        9927 => 'Switzerland VAT number',
        9928 => 'Cyprus VAT number',
        9929 => 'Czech Republic VAT number',
        9930 => 'Germany VAT number',
        9931 => 'Estonia VAT number',
        9932 => 'United Kingdom VAT number',
        9933 => 'Greece VAT number',
        9934 => 'Croatia VAT number',
        9935 => 'Ireland VAT number',
        9936 => 'Liechtenstein VAT number',
        9937 => 'Lithuania VAT number',
        9938 => 'Luxemburg VAT number',
        9939 => 'Latvia VAT number',
        9940 => 'Monaco VAT number',
        9941 => 'Montenegro VAT number',
        9942 => 'Macedonia, the former Yugoslav Republic of VAT number',
        9943 => 'Malta VAT number',
        9944 => 'Netherlands VAT number',
        9945 => 'Poland VAT number',
        9946 => 'Portugal VAT number',
        9947 => 'Romania VAT number',
        9948 => 'Serbia VAT number',
        9949 => 'Slovenia VAT number',
        9950 => 'Slovakia VAT number',
        9951 => 'San Marino VAT number',
        9952 => 'Turkey VAT number',
        9953 => 'Holy See (Vatican City State) VAT number',
        9957 => 'French VAT number',
        9959 => 'Employer Identification Number (EIN, USA)',
        '0002' => 'System Information et Repertoire des Entreprise et des Etablissements: SIRENE',
        '0007' => 'Organisationsnummer (Swedish legal entities)',
        '0009' => 'SIRET-CODE',
        '0037' => 'LY-tunnus',
        '0060' => 'Data Universal Numbering System (D-U-N-S Number)',
        '0088' => 'EAN Location Code',
        '0096' => 'DANISH CHAMBER OF COMMERCE Scheme (EDIRA compliant)',
        '0097' => 'FTI - Ediforum Italia, (EDIRA compliant)',
        '0106' => 'Vereniging van Kamers van Koophandel en Fabrieken in Nederland (Association of Chambers of Commerce and Industry in the Netherlands), Scheme (EDIRA compliant)',
        '0130' => 'Directorates of the European Commission',
        '0135' => 'SIA Object Identifiers',
        '0142' => 'SECETI Object Identifiers',
        '0147' => 'Standard Company Code',
        '0151' => 'Australian Business Number (ABN) Scheme',
        '0170' => 'Teikoku Company Code',
        '0183' => 'Numéro d\'identification suisse des enterprises (IDE), Swiss Unique Business Identification Number (UIDB)',
        '0184' => 'DIGSTORG',
        '0188' => 'Corporate Number of The Social Security and Tax Number System',
        '0190' => 'Dutch Originator\'s Identification Number',
        '0191' => 'Centre of Registers and Information Systems of the Ministry of Justice',
        '0192' => 'Enhetsregisteret ved Bronnoysundregisterne',
        '0193' => 'UBL.BE party identifier',
        '0194' => 'KOIOS Open Technical Dictionary',
        '0195' => 'Singapore UEN identifier',
        '0196' => 'Kennitala - Iceland legal id for individuals and legal entities',
        '0198' => 'ERSTORG',
        '0199' => 'Legal Entity Identifier (LEI)',
        '0200' => 'Legal entity code (Lithuania)',
        '0201' => 'Codice Univoco Unità Organizzativa iPA',
        '0202' => 'Indirizzo di Posta Elettronica Certificata',
        '0203' => 'eDelivery Network Participant identifier',
        '0204' => 'Leitweg-ID',
        '0205' => 'CODDEST',
        '0208' => 'Numero d\'entreprise / ondernemingsnummer / Unternehmensnummer',
        '0209' => 'GS1 identification keys',
        '0210' => 'CODICE FISCALE',
        '0211' => 'PARTITA IVA',
        '0212' => 'Finnish Organization Identifier',
        '0213' => 'Finnish Organization Value Add Tax Identifier',
        '0215' => 'Net service ID',
        '0216' => 'OVTcode',
        '0217' => 'The Netherlands Chamber of Commerce and Industry establishment number',
        '0218' => 'Unified registration number (Latvia)',
        '0221' => 'The registered number of the qualified invoice issuer',
        '0225' => 'FRCTC ELECTRONIC ADDRESS',
        '0230' => 'National e-Invoicing Framework',
        'AN' => 'O.F.T.P. (ODETTE File Transfer Protocol)',
        'AQ' => 'X.400 address for mail text',
        'AS' => 'AS2 exchange',
        'AU' => 'File Transfer Protocol',
        'EM' => 'Electronic mail'
      ]
    ]
  ],
  'authenticationMethods' => [
    'ApiKey' => [
      'api' => true,
      'credentialsHeader' => 'X-Api-Key'
    ],
    'Espo' => [
      'portalDefault' => true,
      'settings' => [
        'isAvailable' => true
      ]
    ],
    'Hmac' => [
      'api' => true,
      'credentialsHeader' => 'X-Hmac-Authorization'
    ],
    'LDAP' => [
      'implementationClassName' => 'Espo\\Core\\Authentication\\Ldap\\LdapLogin',
      'portalDefault' => true,
      'settings' => [
        'isAvailable' => true,
        'layout' => [
          'label' => 'LDAP',
          'rows' => [
            0 => [
              0 => [
                'name' => 'ldapHost'
              ],
              1 => [
                'name' => 'ldapPort'
              ]
            ],
            1 => [
              0 => [
                'name' => 'ldapAuth'
              ],
              1 => [
                'name' => 'ldapSecurity'
              ]
            ],
            2 => [
              0 => [
                'name' => 'ldapUsername',
                'fullWidth' => true
              ]
            ],
            3 => [
              0 => [
                'name' => 'ldapPassword'
              ],
              1 => [
                'name' => 'testConnection',
                'customLabel' => NULL,
                'view' => 'views/admin/authentication/fields/test-connection'
              ]
            ],
            4 => [
              0 => [
                'name' => 'ldapUserNameAttribute'
              ],
              1 => [
                'name' => 'ldapUserObjectClass'
              ]
            ],
            5 => [
              0 => [
                'name' => 'ldapAccountCanonicalForm'
              ],
              1 => [
                'name' => 'ldapBindRequiresDn'
              ]
            ],
            6 => [
              0 => [
                'name' => 'ldapBaseDn',
                'fullWidth' => true
              ]
            ],
            7 => [
              0 => [
                'name' => 'ldapUserLoginFilter',
                'fullWidth' => true
              ]
            ],
            8 => [
              0 => [
                'name' => 'ldapAccountDomainName'
              ],
              1 => [
                'name' => 'ldapAccountDomainNameShort'
              ]
            ],
            9 => [
              0 => [
                'name' => 'ldapTryUsernameSplit'
              ],
              1 => [
                'name' => 'ldapOptReferrals'
              ]
            ],
            10 => [
              0 => [
                'name' => 'ldapCreateEspoUser'
              ],
              1 => false
            ],
            11 => [
              0 => [
                'name' => 'ldapUserFirstNameAttribute'
              ],
              1 => [
                'name' => 'ldapUserLastNameAttribute'
              ]
            ],
            12 => [
              0 => [
                'name' => 'ldapUserTitleAttribute'
              ],
              1 => false
            ],
            13 => [
              0 => [
                'name' => 'ldapUserEmailAddressAttribute'
              ],
              1 => [
                'name' => 'ldapUserPhoneNumberAttribute'
              ]
            ],
            14 => [
              0 => [
                'name' => 'ldapUserTeams'
              ],
              1 => [
                'name' => 'ldapUserDefaultTeam'
              ]
            ],
            15 => [
              0 => [
                'name' => 'ldapPortalUserLdapAuth'
              ],
              1 => false
            ],
            16 => [
              0 => [
                'name' => 'ldapPortalUserPortals'
              ],
              1 => [
                'name' => 'ldapPortalUserRoles'
              ]
            ]
          ]
        ],
        'fieldList' => [
          0 => 'ldapHost',
          1 => 'ldapPort',
          2 => 'ldapAuth',
          3 => 'ldapSecurity',
          4 => 'ldapUsername',
          5 => 'ldapPassword',
          6 => 'ldapBindRequiresDn',
          7 => 'ldapUserLoginFilter',
          8 => 'ldapBaseDn',
          9 => 'ldapAccountCanonicalForm',
          10 => 'ldapAccountDomainName',
          11 => 'ldapAccountDomainNameShort',
          12 => 'ldapAccountDomainName',
          13 => 'ldapAccountDomainNameShort',
          14 => 'ldapTryUsernameSplit',
          15 => 'ldapOptReferrals',
          16 => 'ldapCreateEspoUser',
          17 => 'ldapPortalUserLdapAuth'
        ],
        'dynamicLogic' => [
          'fields' => [
            'ldapHost' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'LDAP'
                  ]
                ]
              ]
            ],
            'ldapUserNameAttribute' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'LDAP'
                  ]
                ]
              ]
            ],
            'ldapUserObjectClass' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'LDAP'
                  ]
                ]
              ]
            ],
            'ldapUsername' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ],
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ]
            ],
            'ldapPassword' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ]
            ],
            'testConnection' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ]
            ],
            'ldapAccountDomainName' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'in',
                    'attribute' => 'ldapAccountCanonicalForm',
                    'value' => [
                      0 => 'Backslash',
                      1 => 'Principal'
                    ]
                  ]
                ]
              ]
            ],
            'ldapAccountDomainNameShort' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'in',
                    'attribute' => 'ldapAccountCanonicalForm',
                    'value' => [
                      0 => 'Backslash',
                      1 => 'Principal'
                    ]
                  ]
                ]
              ]
            ],
            'ldapUserTitleAttribute' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserFirstNameAttribute' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserLastNameAttribute' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserEmailAddressAttribute' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserPhoneNumberAttribute' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserTeams' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserDefaultTeam' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapPortalUserPortals' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapPortalUserLdapAuth'
                  ]
                ]
              ]
            ],
            'ldapPortalUserRoles' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapPortalUserLdapAuth'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Oidc' => [
      'implementationClassName' => 'Espo\\Core\\Authentication\\Oidc\\Login',
      'logoutClassName' => 'Espo\\Core\\Authentication\\Oidc\\Logout',
      'login' => [
        'handler' => 'handlers/login/oidc',
        'fallbackConfigParam' => 'oidcFallback'
      ],
      'provider' => [
        'isAvailable' => true
      ],
      'settings' => [
        'isAvailable' => true,
        'layout' => [
          'label' => 'OIDC',
          'rows' => [
            0 => [
              0 => [
                'name' => 'oidcClientId'
              ],
              1 => [
                'name' => 'oidcClientSecret'
              ]
            ],
            1 => [
              0 => [
                'name' => 'oidcAuthorizationRedirectUri',
                'view' => 'views/settings/fields/oidc-redirect-uri',
                'params' => [
                  'readOnly' => true,
                  'copyToClipboard' => true
                ]
              ],
              1 => false
            ],
            2 => [
              0 => [
                'name' => 'oidcAuthorizationEndpoint'
              ],
              1 => [
                'name' => 'oidcTokenEndpoint'
              ]
            ],
            3 => [
              0 => [
                'name' => 'oidcJwksEndpoint'
              ],
              1 => [
                'name' => 'oidcJwtSignatureAlgorithmList'
              ]
            ],
            4 => [
              0 => [
                'name' => 'oidcScopes'
              ],
              1 => [
                'name' => 'oidcUsernameClaim'
              ]
            ],
            5 => [
              0 => [
                'name' => 'oidcCreateUser'
              ],
              1 => [
                'name' => 'oidcSync'
              ]
            ],
            6 => [
              0 => [
                'name' => 'oidcTeams'
              ],
              1 => [
                'name' => 'oidcGroupClaim'
              ]
            ],
            7 => [
              0 => [
                'name' => 'oidcSyncTeams'
              ],
              1 => false
            ],
            8 => [
              0 => [
                'name' => 'oidcFallback'
              ],
              1 => [
                'name' => 'oidcAllowRegularUserFallback'
              ]
            ],
            9 => [
              0 => [
                'name' => 'oidcAllowAdminUser'
              ],
              1 => [
                'name' => 'oidcLogoutUrl'
              ]
            ],
            10 => [
              0 => [
                'name' => 'oidcAuthorizationPrompt'
              ],
              1 => false
            ]
          ]
        ],
        'fieldList' => [
          0 => 'oidcClientId',
          1 => 'oidcClientSecret',
          2 => 'oidcAuthorizationEndpoint',
          3 => 'oidcTokenEndpoint',
          4 => 'oidcJwksEndpoint',
          5 => 'oidcJwtSignatureAlgorithmList',
          6 => 'oidcScopes',
          7 => 'oidcGroupClaim',
          8 => 'oidcCreateUser',
          9 => 'oidcUsernameClaim',
          10 => 'oidcTeams',
          11 => 'oidcSync',
          12 => 'oidcSyncTeams',
          13 => 'oidcAuthorizationRedirectUri',
          14 => 'oidcFallback',
          15 => 'oidcAllowRegularUserFallback',
          16 => 'oidcAllowAdminUser',
          17 => 'oidcLogoutUrl'
        ],
        'dynamicLogic' => [
          'fields' => [
            'oidcClientId' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcAuthorizationEndpoint' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcTokenEndpoint' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcUsernameClaim' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcJwtSignatureAlgorithmList' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcJwksEndpoint' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ],
                  1 => [
                    'type' => 'or',
                    'value' => [
                      0 => [
                        'type' => 'contains',
                        'attribute' => 'oidcJwtSignatureAlgorithmList',
                        'value' => 'RS256'
                      ],
                      1 => [
                        'type' => 'contains',
                        'attribute' => 'oidcJwtSignatureAlgorithmList',
                        'value' => 'RS384'
                      ],
                      2 => [
                        'type' => 'contains',
                        'attribute' => 'oidcJwtSignatureAlgorithmList',
                        'value' => 'RS512'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'oidcAllowRegularUserFallback' => [
              'invalid' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ],
                  1 => [
                    'type' => 'isTrue',
                    'attribute' => 'oidcAllowRegularUserFallback'
                  ],
                  2 => [
                    'type' => 'isFalse',
                    'attribute' => 'oidcFallback'
                  ]
                ]
              ]
            ],
            'oidcAllowAdminUser' => [
              'invalid' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ],
                  1 => [
                    'type' => 'isFalse',
                    'attribute' => 'oidcAllowAdminUser'
                  ],
                  2 => [
                    'type' => 'isFalse',
                    'attribute' => 'oidcFallback'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ]
  ],
  'clientDefs' => [
    'ActionHistoryRecord' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'recordViews' => [
        'list' => 'views/action-history-record/record/list'
      ],
      'modalViews' => [
        'detail' => 'views/action-history-record/modals/detail'
      ]
    ],
    'AddressCountry' => [
      'controller' => 'controllers/record',
      'duplicateDisabled' => true,
      'mergeDisabled' => true,
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'name' => 'populateDefaults',
              'labelTranslation' => 'AddressCountry.strings.populateDefaults',
              'handler' => 'handlers/admin/address-country/populate-defaults',
              'actionFunction' => 'populate'
            ]
          ]
        ]
      ]
    ],
    'AddressMap' => [
      'controller' => 'controllers/address-map'
    ],
    'ApiUser' => [
      'controller' => 'controllers/api-user',
      'views' => [
        'detail' => 'views/user/detail',
        'list' => 'views/api-user/list'
      ],
      'recordViews' => [
        'list' => 'views/user/record/list',
        'detail' => 'views/user/record/detail',
        'edit' => 'views/user/record/edit',
        'detailSmall' => 'views/user/record/detail-quick',
        'editSmall' => 'views/user/record/edit-quick'
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [
          0 => 'avatar',
          1 => 'createdAt',
          2 => 'lastAccess'
        ],
        'detailSmall' => [
          0 => 'avatar',
          1 => 'createdAt'
        ],
        'edit' => [
          0 => 'avatar'
        ],
        'editSmall' => [
          0 => 'avatar'
        ]
      ],
      'filterList' => [],
      'boolFilterList' => []
    ],
    'AppLogRecord' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'mergeDisabled' => true,
      'recordViews' => [
        'list' => 'views/admin/app-log-record/record/list'
      ],
      'filterList' => [
        0 => [
          'name' => 'errors'
        ]
      ]
    ],
    'AppSecret' => [
      'controller' => 'controllers/record',
      'mergeDisabled' => true,
      'exportDisabled' => true,
      'massUpdateDisabled' => true
    ],
    'Attachment' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'recordViews' => [
        'list' => 'views/attachment/record/list',
        'detail' => 'views/attachment/record/detail'
      ],
      'modalViews' => [
        'detail' => 'views/attachment/modals/detail'
      ],
      'filterList' => [
        0 => 'orphan'
      ]
    ],
    'AuthLogRecord' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'list' => 'views/admin/auth-log-record/record/list',
        'detail' => 'views/admin/auth-log-record/record/detail',
        'detailSmall' => 'views/admin/auth-log-record/record/detail-small'
      ],
      'modalViews' => [
        'detail' => 'views/admin/auth-log-record/modals/detail'
      ],
      'filterList' => [
        0 => 'accepted',
        1 => 'denied'
      ],
      'createDisabled' => true,
      'relationshipPanels' => [
        'actionHistoryRecords' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/relationship-view-only'
        ]
      ]
    ],
    'AuthToken' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'list' => 'views/admin/auth-token/record/list',
        'detail' => 'views/admin/auth-token/record/detail',
        'detailSmall' => 'views/admin/auth-token/record/detail-small'
      ],
      'modalViews' => [
        'detail' => 'views/admin/auth-token/modals/detail'
      ],
      'filterList' => [
        0 => 'active',
        1 => 'inactive'
      ],
      'createDisabled' => true,
      'relationshipPanels' => [
        'actionHistoryRecords' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/relationship-view-only'
        ]
      ]
    ],
    'AuthenticationProvider' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'detail' => 'views/authentication-provider/record/detail',
        'edit' => 'views/authentication-provider/record/edit'
      ],
      'searchPanelDisabled' => true,
      'inlineEditDisabled' => true,
      'duplicateDisabled' => true,
      'massUpdateDisabled' => true,
      'massRemoveDisabled' => true,
      'mergeDisabled' => true
    ],
    'Dashboard' => [
      'controller' => 'controllers/dashboard',
      'iconClass' => 'fas fa-th-large'
    ],
    'DashboardTemplate' => [
      'controller' => 'controllers/record',
      'views' => [
        'detail' => 'views/dashboard-template/detail'
      ],
      'recordViews' => [
        'list' => 'views/dashboard-template/record/list'
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'action' => 'deployToUsers',
              'label' => 'Deploy to Users'
            ],
            1 => [
              'action' => 'deployToTeam',
              'label' => 'Deploy to Team'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Dashboard Sets',
              'link' => '#DashboardSet',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'DashboardSet'
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'DynamicLogic' => [
      'itemTypes' => [
        'and' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/group-base',
          'operator' => 'and'
        ],
        'or' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/group-base',
          'operator' => 'or'
        ],
        'not' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/group-not',
          'operator' => 'not'
        ],
        'equals' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '='
        ],
        'notEquals' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&ne;'
        ],
        'greaterThan' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&gt;'
        ],
        'lessThan' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&lt;'
        ],
        'greaterThanOrEquals' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&ge;'
        ],
        'lessThanOrEquals' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&le;'
        ],
        'isEmpty' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '= &empty;'
        ],
        'isNotEmpty' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '&ne; &empty;'
        ],
        'isTrue' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '= 1'
        ],
        'isFalse' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '= 0'
        ],
        'in' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-multiple-values-base',
          'operatorString' => '&isin;'
        ],
        'notIn' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-multiple-values-base',
          'operatorString' => '&notin;'
        ],
        'isToday' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-is-today',
          'operatorString' => '='
        ],
        'inFuture' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-in-future',
          'operatorString' => '&isin;'
        ],
        'inPast' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-in-past',
          'operatorString' => '&isin;'
        ],
        'contains' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-link',
          'operatorString' => '&niv;'
        ],
        'notContains' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-link',
          'operatorString' => '&notni;'
        ],
        'has' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-enum',
          'operatorString' => '&niv;'
        ],
        'notHas' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-enum',
          'operatorString' => '&notni;'
        ],
        'startsWith' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
        ],
        'endsWith' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
        ],
        'matches' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
        ]
      ],
      'fieldTypes' => [
        'bool' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isTrue',
            1 => 'isFalse'
          ]
        ],
        'varchar' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty',
            4 => 'contains',
            5 => 'notContains',
            6 => 'startsWith',
            7 => 'endsWith',
            8 => 'matches'
          ],
          'conditionTypes' => [
            'contains' => [
              'valueType' => 'field',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-base'
            ],
            'notContains' => [
              'valueType' => 'field',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-base'
            ]
          ]
        ],
        'url' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty'
          ]
        ],
        'email' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'phone' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'text' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'contains',
            3 => 'notContains',
            4 => 'matches'
          ],
          'conditionTypes' => [
            'contains' => [
              'valueType' => 'varchar',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
            ],
            'notContains' => [
              'valueType' => 'varchar',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
            ]
          ]
        ],
        'int' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals',
            4 => 'greaterThan',
            5 => 'lessThan',
            6 => 'greaterThanOrEquals',
            7 => 'lessThanOrEquals'
          ]
        ],
        'float' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals',
            4 => 'greaterThan',
            5 => 'lessThan',
            6 => 'greaterThanOrEquals',
            7 => 'lessThanOrEquals'
          ]
        ],
        'currency' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals',
            4 => 'greaterThan',
            5 => 'lessThan',
            6 => 'greaterThanOrEquals',
            7 => 'lessThanOrEquals'
          ]
        ],
        'date' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/date',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'isToday',
            3 => 'inFuture',
            4 => 'inPast',
            5 => 'equals',
            6 => 'notEquals'
          ]
        ],
        'datetime' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/date',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'isToday',
            3 => 'inFuture',
            4 => 'inPast'
          ]
        ],
        'datetimeOptional' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/date',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'isToday',
            3 => 'inFuture',
            4 => 'inPast'
          ]
        ],
        'enum' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/enum',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty',
            4 => 'in',
            5 => 'notIn'
          ]
        ],
        'link' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals'
          ]
        ],
        'linkOne' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals'
          ]
        ],
        'file' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'image' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'linkParent' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link-parent',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals'
          ]
        ],
        'linkMultiple' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link-multiple',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'contains',
            3 => 'notContains'
          ]
        ],
        'foreign' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty'
          ]
        ],
        'id' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'multiEnum' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'has',
            3 => 'notHas'
          ]
        ],
        'array' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'has',
            3 => 'notHas'
          ]
        ],
        'checklist' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'has',
            3 => 'notHas'
          ]
        ],
        'urlMultiple' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'currentUser' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/current-user',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals'
          ]
        ],
        'currentUserTeams' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/current-user-teams',
          'typeList' => [
            0 => 'contains',
            1 => 'notContains'
          ]
        ]
      ],
      'conditionTypes' => [
        'isTrue' => [
          'valueType' => 'empty'
        ],
        'isFalse' => [
          'valueType' => 'empty'
        ],
        'isEmpty' => [
          'valueType' => 'empty'
        ],
        'isNotEmpty' => [
          'valueType' => 'empty'
        ],
        'equals' => [
          'valueType' => 'field'
        ],
        'notEquals' => [
          'valueType' => 'field'
        ],
        'greaterThan' => [
          'valueType' => 'field'
        ],
        'lessThan' => [
          'valueType' => 'field'
        ],
        'greaterThanOrEquals' => [
          'valueType' => 'field'
        ],
        'lessThanOrEquals' => [
          'valueType' => 'field'
        ],
        'in' => [
          'valueType' => 'field'
        ],
        'notIn' => [
          'valueType' => 'field'
        ],
        'contains' => [
          'valueType' => 'custom'
        ],
        'notContains' => [
          'valueType' => 'custom'
        ],
        'inPast' => [
          'valueType' => 'empty'
        ],
        'isFuture' => [
          'valueType' => 'empty'
        ],
        'isToday' => [
          'valueType' => 'empty'
        ],
        'has' => [
          'valueType' => 'field'
        ],
        'notHas' => [
          'valueType' => 'field'
        ],
        'startsWith' => [
          'valueType' => 'varchar'
        ],
        'endsWith' => [
          'valueType' => 'varchar'
        ],
        'matches' => [
          'valueType' => 'varchar'
        ]
      ]
    ],
    'Email' => [
      'controller' => 'controllers/email',
      'acl' => 'acl/email',
      'views' => [
        'list' => 'views/email/list',
        'detail' => 'views/email/detail'
      ],
      'recordViews' => [
        'list' => 'views/email/record/list',
        'detail' => 'views/email/record/detail',
        'edit' => 'views/email/record/edit',
        'editQuick' => 'views/email/record/edit-quick',
        'detailQuick' => 'views/email/record/detail-quick',
        'compose' => 'views/email/record/compose',
        'listRelated' => 'views/email/record/list-related'
      ],
      'modalViews' => [
        'detail' => 'views/email/modals/detail',
        'compose' => 'views/modals/compose-email'
      ],
      'quickCreateModalType' => 'compose',
      'defaultSidePanelView' => 'views/email/record/panels/default-side',
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'event',
            'label' => 'Event',
            'view' => 'views/email/record/panels/event',
            'isForm' => true,
            'hidden' => true
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Compose',
              'action' => 'composeEmail',
              'style' => 'danger',
              'acl' => 'create',
              'className' => 'btn-s-wide',
              'title' => 'Ctrl+Space'
            ]
          ],
          'dropdown' => [
            0 => [
              'name' => 'archiveEmail',
              'label' => 'Archive Email',
              'link' => '#Email/create',
              'acl' => 'create'
            ],
            1 => [
              'name' => 'importEml',
              'label' => 'Import EML',
              'handler' => 'handlers/email/list-actions',
              'checkVisibilityFunction' => 'checkImportEml',
              'actionFunction' => 'importEml'
            ],
            2 => false,
            3 => [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate'
            ],
            4 => [
              'label' => 'Folders',
              'link' => '#EmailFolder',
              'configCheck' => '!emailFoldersDisabled',
              'accessDataList' => [
                0 => [
                  'inPortalDisabled' => true
                ]
              ]
            ],
            5 => [
              'label' => 'Group Folders',
              'link' => '#GroupEmailFolder',
              'configCheck' => '!emailFoldersDisabled',
              'accessDataList' => [
                0 => [
                  'inPortalDisabled' => true
                ],
                1 => [
                  'isAdminOnly' => true
                ]
              ]
            ],
            6 => [
              'label' => 'Filters',
              'link' => '#EmailFilter',
              'accessDataList' => [
                0 => [
                  'inPortalDisabled' => true
                ]
              ]
            ]
          ]
        ],
        'detail' => [
          'dropdown' => [
            0 => [
              'label' => 'Reply',
              'action' => 'reply',
              'acl' => 'read'
            ],
            1 => [
              'label' => 'Reply to All',
              'action' => 'replyToAll',
              'acl' => 'read'
            ],
            2 => [
              'label' => 'Forward',
              'action' => 'forward',
              'acl' => 'read'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'users' => [
          'selectHandler' => 'handlers/email/select-user'
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'replied' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'repliedId',
                  'data' => [
                    'field' => 'replied'
                  ]
                ]
              ]
            ]
          ],
          'replies' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'repliesIds',
                  'data' => [
                    'field' => 'replies'
                  ]
                ]
              ]
            ]
          ],
          'folderString' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'isTrue',
                          'attribute' => 'isUsers'
                        ]
                      ]
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'groupFolderId'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'sendAt' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Draft'
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'event' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'icsEventDateStart'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [],
      'defaultFilterData' => [],
      'boolFilterList' => [],
      'iconClass' => 'fas fa-envelope',
      'layoutBottomPanelsDetailDisabled' => true,
      'layoutDetailDisabled' => true,
      'layoutDetailSmallDisabled' => true,
      'layoutSidePanelsDetailSmallDisabled' => true,
      'layoutSidePanelsEditSmallDisabled' => true
    ],
    'EmailAccount' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'list' => 'views/email-account/record/list',
        'detail' => 'views/email-account/record/detail',
        'edit' => 'views/email-account/record/edit'
      ],
      'views' => [
        'list' => 'views/email-account/list'
      ],
      'inlineEditDisabled' => true,
      'formDependency' => [
        'storeSentEmails' => [
          'map' => [
            'true' => [
              0 => [
                'action' => 'show',
                'fields' => [
                  0 => 'sentFolder'
                ]
              ],
              1 => [
                'action' => 'setRequired',
                'fields' => [
                  0 => 'sentFolder'
                ]
              ]
            ]
          ],
          'default' => [
            0 => [
              'action' => 'hide',
              'fields' => [
                0 => 'sentFolder'
              ]
            ],
            1 => [
              'action' => 'setNotRequired',
              'fields' => [
                0 => 'sentFolder'
              ]
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'smtpUsername' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'useSmtp'
                    ],
                    1 => [
                      'type' => 'isTrue',
                      'attribute' => 'smtpAuth'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'fetchSince' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ],
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'fetchData'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'active'
        ]
      ],
      'relationshipPanels' => [
        'filters' => [
          'select' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-edit-and-remove',
          'unlinkDisabled' => true
        ],
        'emails' => [
          'select' => false,
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'unlinkDisabled' => true
        ]
      ]
    ],
    'EmailAddress' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'exportDisabled' => true,
      'mergeDisabled' => true,
      'filterList' => [
        0 => 'orphan'
      ]
    ],
    'EmailFilter' => [
      'controller' => 'controllers/email-filter',
      'dynamicHandler' => 'handlers/email-filter',
      'modalViews' => [
        'edit' => 'views/email-filter/modals/edit'
      ],
      'recordViews' => [
        'list' => 'views/email-filter/record/list'
      ],
      'inlineEditDisabled' => true,
      'searchPanelDisabled' => false,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Emails',
              'link' => '#Email',
              'style' => 'default',
              'aclScope' => 'Email'
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'dynamicLogic' => [
        'fields' => [
          'parent' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'isGlobal',
                  'type' => 'isFalse'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'isGlobal',
                  'type' => 'isFalse'
                ]
              ]
            ]
          ],
          'emailFolder' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Folder'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Folder'
                ]
              ]
            ]
          ],
          'groupEmailFolder' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Group Folder'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Group Folder'
                ]
              ]
            ]
          ],
          'markAsRead' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'User'
                ]
              ]
            ]
          ],
          'skipNotification' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'User'
                ]
              ]
            ]
          ]
        ],
        'options' => [
          'action' => [
            0 => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'isGlobal',
                  'type' => 'isTrue'
                ]
              ],
              'optionList' => [
                0 => 'Skip'
              ]
            ],
            1 => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'User'
                ]
              ],
              'optionList' => [
                0 => 'Skip',
                1 => 'Move to Folder',
                2 => 'None'
              ]
            ],
            2 => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'InboundEmail'
                ]
              ],
              'optionList' => [
                0 => 'Skip',
                1 => 'Move to Group Folder'
              ]
            ],
            3 => [
              'conditionGroup' => [],
              'optionList' => [
                0 => 'Skip'
              ]
            ]
          ]
        ]
      ]
    ],
    'EmailFolder' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'views/email-folder/list'
      ],
      'recordViews' => [
        'list' => 'views/email-folder/record/list',
        'editQuick' => 'views/email-folder/record/edit-small'
      ],
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Emails',
              'link' => '#Email',
              'style' => 'default',
              'aclScope' => 'Email'
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'EmailTemplate' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'views/email-template/list'
      ],
      'recordViews' => [
        'edit' => 'views/email-template/record/edit',
        'detail' => 'views/email-template/record/detail',
        'editQuick' => 'views/email-template/record/edit-quick'
      ],
      'modalViews' => [
        'select' => 'views/modals/select-records-with-categories'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'information',
            'label' => 'Info',
            'view' => 'views/email-template/record/panels/information'
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'information',
            'label' => 'Info',
            'view' => 'views/email-template/record/panels/information'
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual'
      ],
      'placeholderList' => [
        0 => 'optOutUrl',
        1 => 'optOutLink'
      ],
      'iconClass' => 'fas fa-envelope-square'
    ],
    'EmailTemplateCategory' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#EmailTemplateCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate',
              'style' => 'default'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#EmailTemplateCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate',
              'style' => 'default'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'emailTemplates' => [
          'create' => false
        ],
        'children' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ]
    ],
    'ExternalAccount' => [
      'controller' => 'controllers/external-account'
    ],
    'Global' => [
      'detailActionList' => [
        0 => [
          'name' => 'viewAuditLog',
          'label' => 'View Audit Log',
          'actionFunction' => 'show',
          'checkVisibilityFunction' => 'isAvailable',
          'handler' => 'handlers/record/view-audit-log',
          'groupIndex' => 4
        ],
        1 => [
          'name' => 'viewUserAccess',
          'label' => 'View User Access',
          'actionFunction' => 'show',
          'checkVisibilityFunction' => 'isAvailable',
          'handler' => 'handlers/record/view-user-access',
          'groupIndex' => 4
        ]
      ],
      'menu' => [
        'detail' => [
          'dropdown' => [
            0 => [
              'name' => 'startProcessGlobal',
              'action' => 'startProcessGlobal',
              'label' => 'Start Process',
              'acl' => 'create',
              'aclScope' => 'BpmnProcess',
              'hidden' => true,
              'data' => [
                'handler' => 'advanced:start-process-action-handler'
              ],
              'initFunction' => 'init'
            ]
          ]
        ]
      ],
      'viewSetupHandlers' => [
        'detail' => [
          0 => 'advanced:handlers/manual-workflow'
        ]
      ]
    ],
    'GlobalStream' => [
      'controller' => 'controllers/global-stream',
      'iconClass' => 'fas fa-rss-square'
    ],
    'GroupEmailFolder' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'views/group-email-folder/list'
      ],
      'recordViews' => [
        'list' => 'views/group-email-folder/record/list',
        'editQuick' => 'views/email-folder/record/edit-small'
      ],
      'searchPanelDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'massRemoveDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'name' => 'emails',
              'labelTranslation' => 'Global.scopeNamesPlural.Email',
              'link' => '#Email',
              'style' => 'default',
              'aclScope' => 'Email'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'emails' => [
          'select' => false,
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'unlinkDisabled' => true
        ]
      ]
    ],
    'Home' => [
      'iconClass' => 'fas fa-th-large'
    ],
    'Import' => [
      'controller' => 'controllers/import',
      'acl' => 'acl/import',
      'recordViews' => [
        'list' => 'views/import/record/list',
        'detail' => 'views/import/record/detail'
      ],
      'views' => [
        'list' => 'views/import/list',
        'detail' => 'views/import/detail'
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'imported',
            'label' => 'Imported',
            'view' => 'views/import/record/panels/imported',
            'createDisabled' => true,
            'selectDisabled' => true,
            'unlinkDisabled' => true
          ],
          1 => [
            'name' => 'duplicates',
            'label' => 'Duplicates',
            'view' => 'views/import/record/panels/duplicates',
            'rowActionsView' => 'views/import/record/row-actions/duplicates',
            'createDisabled' => true,
            'selectDisabled' => true,
            'unlinkDisabled' => true
          ],
          2 => [
            'name' => 'updated',
            'label' => 'Updated',
            'view' => 'views/import/record/panels/updated',
            'createDisabled' => true,
            'selectDisabled' => true,
            'unlinkDisabled' => true
          ]
        ]
      ],
      'searchPanelDisabled' => true,
      'relationshipPanels' => [
        'errors' => [
          'unlinkDisabled' => true,
          'actionList' => [
            0 => [
              'name' => 'export',
              'label' => 'Export',
              'handler' => 'handlers/import',
              'actionFunction' => 'errorExport'
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-file-import',
      'dateFormatList' => [
        0 => 'YYYY-MM-DD',
        1 => 'DD-MM-YYYY',
        2 => 'MM-DD-YYYY',
        3 => 'MM/DD/YYYY',
        4 => 'DD/MM/YYYY',
        5 => 'DD.MM.YYYY',
        6 => 'MM.DD.YYYY',
        7 => 'YYYY.MM.DD',
        8 => 'DD. MM. YYYY'
      ],
      'timeFormatList' => [
        0 => 'HH:mm:ss',
        1 => 'HH:mm',
        2 => 'hh:mm a',
        3 => 'hh:mma',
        4 => 'hh:mm A',
        5 => 'hh:mmA',
        6 => 'hh:mm:ss a',
        7 => 'hh:mm:ssa',
        8 => 'hh:mm:ss A',
        9 => 'hh:mm:ssA'
      ]
    ],
    'ImportError' => [
      'controller' => 'controllers/record',
      'acl' => 'acl/foreign',
      'searchPanelDisabled' => true,
      'createDisabled' => true,
      'editDisabled' => true
    ],
    'InboundEmail' => [
      'recordViews' => [
        'detail' => 'views/inbound-email/record/detail',
        'edit' => 'views/inbound-email/record/edit',
        'list' => 'views/inbound-email/record/list'
      ],
      'inlineEditDisabled' => true,
      'formDependency' => [
        'reply' => [
          'map' => [
            'true' => [
              0 => [
                'action' => 'show',
                'fields' => [
                  0 => 'replyEmailTemplate',
                  1 => 'replyFromAddress',
                  2 => 'replyFromName'
                ]
              ],
              1 => [
                'action' => 'setRequired',
                'fields' => [
                  0 => 'replyEmailTemplate'
                ]
              ]
            ]
          ],
          'default' => [
            0 => [
              'action' => 'hide',
              'fields' => [
                0 => 'replyEmailTemplate',
                1 => 'replyFromAddress',
                2 => 'replyFromName'
              ]
            ],
            1 => [
              'action' => 'setNotRequired',
              'fields' => [
                0 => 'replyEmailTemplate'
              ]
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'smtpUsername' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'useSmtp'
                    ],
                    1 => [
                      'type' => 'isTrue',
                      'attribute' => 'smtpAuth'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'fetchSince' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ],
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'fetchData'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ]
          ],
          'isSystem' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true,
      'relationshipPanels' => [
        'filters' => [
          'select' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-edit-and-remove',
          'unlinkDisabled' => true
        ],
        'emails' => [
          'select' => false,
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'unlinkDisabled' => true
        ]
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [],
        'detailSmall' => [],
        'edit' => [],
        'editSmall' => []
      ]
    ],
    'Job' => [
      'modalViews' => [
        'detail' => 'views/admin/job/modals/detail'
      ],
      'recordViews' => [
        'list' => 'views/admin/job/record/list',
        'detailQuick' => 'views/admin/job/record/detail-small'
      ]
    ],
    'LastViewed' => [
      'controller' => 'controllers/last-viewed',
      'views' => [
        'list' => 'views/last-viewed/list'
      ],
      'recordViews' => [
        'list' => 'views/last-viewed/record/list'
      ]
    ],
    'LayoutSet' => [
      'controller' => 'controllers/layout-set',
      'recordViews' => [
        'list' => 'views/layout-set/record/list'
      ],
      'searchPanelDisabled' => true,
      'duplicateDisabled' => true,
      'relationshipPanels' => [
        'teams' => [
          'createDisabled' => true,
          'viewDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ]
      ]
    ],
    'LeadCapture' => [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true,
      'recordViews' => [
        'detail' => 'views/lead-capture/record/detail',
        'list' => 'views/lead-capture/record/list'
      ],
      'dynamicLogic' => [
        'fields' => [
          'targetList' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'subscribeToTargetList'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'subscribeToTargetList'
                ]
              ]
            ]
          ],
          'subscribeContactToTargetList' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'subscribeToTargetList'
                ]
              ]
            ]
          ],
          'optInConfirmationLifetime' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'optInConfirmationSuccessMessage' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'createLeadBeforeOptInConfirmation' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'smtpAccount' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'skipOptInConfirmationIfSubscribed' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'optInConfirmation'
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'targetListId',
                      'data' => [
                        'field' => 'targetList'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'optInConfirmationEmailTemplate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'apiKey' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'phoneNumberCountry' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'fieldList',
                  'value' => 'phoneNumber'
                ]
              ]
            ]
          ],
          'formSuccessText' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formText' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formSuccessRedirectUrl' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formLanguage' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formFrameAncestors' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formCaptcha' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'form' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ],
                1 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ]
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'request',
            'label' => 'Request',
            'isForm' => true,
            'view' => 'views/lead-capture/record/panels/request',
            'notRefreshable' => true
          ],
          1 => [
            'name' => 'form',
            'label' => 'Web Form',
            'isForm' => true,
            'view' => 'views/lead-capture/record/panels/form',
            'notRefreshable' => true
          ]
        ]
      ],
      'relationshipPanels' => [
        'logRecords' => [
          'rowActionsView' => 'views/record/row-actions/view-and-remove',
          'layout' => 'listForLeadCapture',
          'select' => false,
          'create' => false
        ]
      ]
    ],
    'LeadCaptureLogRecord' => [
      'modalViews' => [
        'detail' => 'views/lead-capture-log-record/modals/detail'
      ]
    ],
    'Note' => [
      'controller' => 'controllers/note',
      'collection' => 'collections/note',
      'recordViews' => [
        'edit' => 'views/note/record/edit',
        'editQuick' => 'views/note/record/edit',
        'listRelated' => 'views/stream/record/list'
      ],
      'modalViews' => [
        'edit' => 'views/note/modals/edit'
      ],
      'itemViews' => [
        'Post' => 'views/stream/notes/post',
        'EventConfirmation' => 'crm:views/stream/notes/event-confirmation'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'handlers/note/record-detail-setup'
        ]
      ]
    ],
    'Notification' => [
      'controller' => 'controllers/notification',
      'acl' => 'acl/notification',
      'aclPortal' => 'acl-portal/notification',
      'collection' => 'collections/note',
      'itemViews' => [
        'System' => 'views/notification/items/system',
        'EmailInbox' => 'views/notification/items/email-inbox',
        'EventAttendee' => 'crm:views/notification/items/event-attendee'
      ]
    ],
    'PasswordChangeRequest' => [
      'controller' => 'controllers/password-change-request'
    ],
    'PhoneNumber' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'exportDisabled' => true,
      'mergeDisabled' => true,
      'filterList' => [
        0 => 'orphan'
      ]
    ],
    'Portal' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'list' => 'views/portal/record/list'
      ],
      'relationshipPanels' => [
        'users' => [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only',
          'layout' => 'listSmall',
          'selectPrimaryFilterName' => 'activePortal'
        ],
        'authenticationProvider' => [
          'createDisabled' => true
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'PortalRole' => [
      'recordViews' => [
        'detail' => 'views/portal-role/record/detail',
        'edit' => 'views/portal-role/record/edit',
        'editQuick' => 'views/portal-role/record/edit',
        'list' => 'views/portal-role/record/list'
      ],
      'relationshipPanels' => [
        'users' => [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ]
      ],
      'views' => [
        'list' => 'views/portal-role/list'
      ]
    ],
    'PortalUser' => [
      'controller' => 'controllers/portal-user',
      'views' => [
        'detail' => 'views/user/detail',
        'list' => 'views/portal-user/list'
      ],
      'recordViews' => [
        'list' => 'views/user/record/list',
        'detail' => 'views/user/record/detail',
        'edit' => 'views/user/record/edit',
        'detailSmall' => 'views/user/record/detail-quick',
        'editSmall' => 'views/user/record/edit-quick'
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [
          0 => 'avatar',
          1 => 'createdAt',
          2 => 'lastAccess'
        ],
        'detailSmall' => [
          0 => 'avatar',
          1 => 'createdAt'
        ],
        'edit' => [
          0 => 'avatar'
        ],
        'editSmall' => [
          0 => 'avatar'
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ]
        ]
      ],
      'filterList' => [
        0 => 'activePortal'
      ],
      'boolFilterList' => [],
      'selectDefaultFilters' => [
        'filter' => 'activePortal'
      ],
      'iconClass' => 'far fa-user-circle'
    ],
    'Preferences' => [
      'recordViews' => [
        'edit' => 'views/preferences/record/edit'
      ],
      'views' => [
        'edit' => 'views/preferences/edit'
      ],
      'acl' => 'acl/preferences',
      'aclPortal' => 'acl-portal/preferences',
      'dynamicLogic' => [
        'fields' => [
          'assignmentEmailNotificationsIgnoreEntityTypeList' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'receiveAssignmentEmailNotifications'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Role' => [
      'recordViews' => [
        'detail' => 'views/role/record/detail',
        'edit' => 'views/role/record/edit',
        'editQuick' => 'views/role/record/edit',
        'list' => 'views/role/record/list'
      ],
      'relationshipPanels' => [
        'users' => [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ],
        'teams' => [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ]
      ],
      'views' => [
        'list' => 'views/role/list'
      ]
    ],
    'ScheduledJob' => [
      'controller' => 'controllers/record',
      'relationshipPanels' => [
        'log' => [
          'readOnly' => true,
          'view' => 'views/scheduled-job/record/panels/log',
          'createDisabled' => true,
          'selectDisabled' => true,
          'viewDisabled' => true,
          'unlinkDisabled' => true
        ]
      ],
      'recordViews' => [
        'list' => 'views/scheduled-job/record/list',
        'detail' => 'views/scheduled-job/record/detail'
      ],
      'views' => [
        'list' => 'views/scheduled-job/list'
      ],
      'jobWithTargetList' => [
        0 => 'CheckEmailAccounts',
        1 => 'CheckInboundEmails'
      ],
      'dynamicLogic' => [
        'fields' => [
          'job' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ScheduledJobLogRecord' => [
      'controller' => 'controllers/record'
    ],
    'Stream' => [
      'controller' => 'controllers/stream',
      'iconClass' => 'fas fa-rss'
    ],
    'Team' => [
      'acl' => 'acl/team',
      'defaultSidePanel' => [
        'edit' => false,
        'editSmall' => false
      ],
      'mergeDisabled' => true,
      'massUpdateDisabled' => true,
      'defaultSidePanelFieldLists' => [
        'detail' => [
          0 => 'createdAt'
        ]
      ],
      'relationshipPanels' => [
        'users' => [
          'createDisabled' => true,
          'editDisabled' => true,
          'removeDisabled' => true,
          'layout' => 'listForTeam',
          'selectPrimaryFilterName' => 'active',
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ],
          'rowActionList' => [
            0 => 'changeTeamPosition'
          ],
          'selectMandatoryAttributeList' => [
            0 => 'teamRole'
          ]
        ]
      ],
      'recordViews' => [
        'detail' => 'views/team/record/detail',
        'edit' => 'views/team/record/edit',
        'list' => 'views/team/record/list'
      ],
      'modalViews' => [
        'detail' => 'views/team/modals/detail'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-users'
    ],
    'Template' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'detail' => 'views/template/record/detail',
        'edit' => 'views/template/record/edit'
      ],
      'mergeDisabled' => true,
      'dynamicLogic' => [
        'fields' => [
          'entityType' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'footer' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'printFooter'
                ]
              ]
            ]
          ],
          'footerPosition' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'printFooter'
                ]
              ]
            ]
          ],
          'header' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'printHeader'
                ]
              ]
            ]
          ],
          'headerPosition' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'printHeader'
                ]
              ]
            ]
          ],
          'body' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'pageWidth' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ]
          ],
          'pageHeight' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-file-pdf'
    ],
    'User' => [
      'controller' => 'controllers/user',
      'model' => 'models/user',
      'acl' => 'acl/user',
      'views' => [
        'detail' => 'views/user/detail',
        'list' => 'views/user/list'
      ],
      'recordViews' => [
        'detail' => 'views/user/record/detail',
        'detailSmall' => 'views/user/record/detail-quick',
        'edit' => 'views/user/record/edit',
        'editSmall' => 'views/user/record/edit-quick',
        'list' => 'views/user/record/list'
      ],
      'modalViews' => [
        'selectFollowers' => 'views/user/modals/select-followers',
        'detail' => 'views/user/modals/detail',
        'massUpdate' => 'views/user/modals/mass-update'
      ],
      'rowActionDefs' => [
        'changeTeamPosition' => [
          'labelTranslation' => 'User.actions.changePosition',
          'handler' => 'handlers/user/change-team-position-row-action',
          'groupIndex' => 3
        ],
        'changeProjectRole' => [
          'labelTranslation' => 'Project.actions.changeRole',
          'handler' => 'modules/project/handlers/user/change-project-role-row-action'
        ]
      ],
      'defaultSidePanel' => [
        'detail' => [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ],
        'detailSmall' => [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ],
        'edit' => [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ],
        'editSmall' => [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ]
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [
          0 => 'avatar',
          1 => 'createdAt',
          2 => 'lastAccess',
          3 => 'auth2FA'
        ],
        'detailSmall' => [
          0 => 'avatar',
          1 => 'lastAccess'
        ],
        'edit' => [
          0 => 'avatar'
        ],
        'editSmall' => [
          0 => 'avatar'
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks',
            'view' => 'crm:views/user/record/panels/tasks'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks',
            'view' => 'crm:views/user/record/panels/tasks'
          ]
        ]
      ],
      'relationshipPanels' => [
        'targetLists' => [
          'create' => false,
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ],
        'migrations' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'migrationsaccountManager' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'processOwnerMigrations' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'accountSales' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cAccountSales' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'accountsBdms' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'layoutDefaultSidePanelDisabled' => true,
      'filterList' => [
        0 => 'active',
        1 => [
          'isReportFilter' => true,
          'name' => 'reportFilter669ab1ec9e2cc5afe'
        ],
        2 => [
          'isReportFilter' => true,
          'name' => 'reportFilter669ab1fb8382eba48'
        ],
        3 => [
          'isReportFilter' => true,
          'name' => 'reportFilter669ab2078ca7cc670'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMyTeam'
      ],
      'selectDefaultFilters' => [
        'filter' => 'active'
      ],
      'selectRecords' => [
        'orderBy' => 'userNameOwnFirst'
      ],
      'iconClass' => 'fas fa-user-circle',
      'dynamicLogic' => [
        'fields' => [
          'avatarColor' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'avatarId',
                  'value' => NULL,
                  'data' => [
                    'field' => 'avatar'
                  ]
                ],
                1 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'regular',
                    1 => 'admin',
                    2 => 'api'
                  ]
                ]
              ]
            ]
          ],
          'mobileApp' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Mobile App',
                      'linkId' => '65492a0fbb9a2d5e6'
                    ]
                  ],
                  'value' => '65492a0fbb9a2d5e6'
                ]
              ]
            ]
          ],
          'configApp' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'mobileApp'
                ]
              ]
            ]
          ]
        ],
        'options' => [
          'authMethod' => [
            0 => [
              'optionList' => [
                0 => 'ApiKey',
                1 => 'Hmac'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'api'
                ]
              ]
            ]
          ]
        ],
        'panels' => []
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'bottomPanels' => []
    ],
    'Webhook' => [
      'controller' => 'controllers/record',
      'inlineEditDisabled' => true,
      'recordViews' => [
        'list' => 'views/webhook/record/list'
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.WebhookQueueItem',
              'link' => '#WebhookQueueItem',
              'aclScope' => 'WebhookQueueItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'event' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'secretKey' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'WebhookQueueItem' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'mergeDisabled' => true,
      'exportDisabled' => true,
      'textFilterDisabled' => true
    ],
    'WorkingTimeCalendar' => [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'massRemoveDisabled' => true,
      'iconClass' => 'fas fa-calendar-week',
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'name' => 'ranges',
              'labelTranslation' => 'WorkingTimeCalendar.links.ranges',
              'link' => '#WorkingTimeRange'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'weekday0TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday0'
                ]
              ]
            ]
          ],
          'weekday1TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday1'
                ]
              ]
            ]
          ],
          'weekday2TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday2'
                ]
              ]
            ]
          ],
          'weekday3TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday3'
                ]
              ]
            ]
          ],
          'weekday4TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday4'
                ]
              ]
            ]
          ],
          'weekday5TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday5'
                ]
              ]
            ]
          ],
          'weekday6TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday6'
                ]
              ]
            ]
          ],
          'teams' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'teamsIds'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'WorkingTimeRange' => [
      'controller' => 'controllers/record',
      'viewSetupHandlers' => [
        'record/edit' => [
          0 => 'handlers/working-time-range'
        ]
      ],
      'mergeDisabled' => true,
      'massUpdateDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'name' => 'calendars',
              'label' => 'Calendars',
              'link' => '#WorkingTimeCalendar'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'timeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Working'
                ]
              ]
            ]
          ],
          'users' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'usersIds'
                    ],
                    2 => [
                      'type' => 'isEmpty',
                      'attribute' => 'calendarsIds'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'actual'
      ]
    ],
    'Account' => [
      'controller' => 'controllers/record',
      'aclPortal' => 'crm:acl-portal/account',
      'views' => [
        'detail' => 'crm:views/account/detail',
        'edit' => 'custom:views/Account/edit'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ],
          3 => [
            'isReportPanel' => true,
            'name' => 'reportPanel6480aaffadaabae2e',
            'label' => 'Closed Won - Opportunities',
            'view' => 'advanced:views/report-panel/record/panels/report-panel-side',
            'reportPanelId' => '6480aaffadaabae2e',
            'reportType' => 'Grid',
            'reportEntityType' => 'Opportunity',
            'displayType' => 'Table',
            'displayTotal' => true,
            'displayOnlyTotal' => true,
            'useSiMultiplier' => true,
            'accessDataList' => [
              0 => [
                'scope' => 'Opportunity'
              ]
            ],
            'column' => 'SUM:amountDiscountConverted'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ],
          2 => [
            'isReportPanel' => true,
            'name' => 'reportPanel6724e9e56e840668c',
            'label' => 'Microsoft Recommendations in the next 90 days',
            'view' => 'advanced:views/report-panel/record/panels/report-panel-bottom',
            'reportPanelId' => '6724e9e56e840668c',
            'reportType' => 'List',
            'reportEntityType' => 'SalesOrder',
            'displayType' => 'List',
            'displayTotal' => false,
            'displayOnlyTotal' => false,
            'useSiMultiplier' => true,
            'accessDataList' => [
              0 => [
                'scope' => 'SalesOrder'
              ]
            ],
            'order' => 7
          ],
          3 => [
            'isReportPanel' => true,
            'name' => 'reportPanel667d7510ae2206004',
            'label' => 'Microsoft Renewals in the next 90 days',
            'view' => 'advanced:views/report-panel/record/panels/report-panel-bottom',
            'reportPanelId' => '667d7510ae2206004',
            'reportType' => 'List',
            'reportEntityType' => 'SalesOrder',
            'displayType' => 'List',
            'displayTotal' => false,
            'displayOnlyTotal' => false,
            'useSiMultiplier' => true,
            'accessDataList' => [
              0 => [
                'scope' => 'SalesOrder'
              ]
            ],
            'order' => 7
          ]
        ]
      ],
      'relationshipPanels' => [
        'contacts' => [
          'filterList' => [
            0 => 'all',
            1 => 'accountActive'
          ],
          'layout' => NULL,
          'orderBy' => 'name',
          'createAttributeMap' => [
            'billingAddressCity' => 'addressCity',
            'billingAddressStreet' => 'addressStreet',
            'billingAddressPostalCode' => 'addressPostalCode',
            'billingAddressState' => 'addressState',
            'billingAddressCountry' => 'addressCountry',
            'id' => 'accountId',
            'name' => 'accountName'
          ],
          'selectPrimaryFilterName' => NULL
        ],
        'opportunities' => [
          'layout' => 'listForAccount',
          'createHandler' => 'sales:handlers/account/create-opportunity'
        ],
        'campaignLogRecords' => [
          'rowActionsView' => 'views/record/row-actions/empty',
          'select' => false,
          'create' => false
        ],
        'targetLists' => [
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ],
        'quotes' => [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'salesOrders' => [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'invoices' => [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'deliveryOrders' => [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'purchaseOrders' => [
          'createAction' => 'createRelatedPurchaseOrder',
          'view' => 'sales:views/account/record/panels/purchase-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ],
        'userSales' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cUserSales' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'renewalsMicrosoft' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cRenewalsMicrosoft' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'bdm' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'partnerAssessment' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'recentlyCreated'
        ],
        1 => [
          'isReportFilter' => true,
          'name' => 'reportFilter6660add1bf8c29edd'
        ],
        2 => [
          'isReportFilter' => true,
          'name' => 'reportFilter67c9a61c38980f876'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => [
        'detailConvert' => [
          'type' => 'detail'
        ]
      ],
      'color' => '#edc755',
      'iconClass' => 'fas fa-building',
      'kanbanViewMode' => false,
      'dynamicLogic' => [
        'fields' => [
          'licenseType' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Cisco',
                      'linkId' => '6203cd650d9de63df'
                    ]
                  ],
                  'value' => '6203cd650d9de63df'
                ]
              ]
            ]
          ],
          'industry' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Argentina (Microsoft)',
                      'linkId' => '6217bac9e998125bd'
                    ]
                  ],
                  'value' => '6217bac9e998125bd'
                ]
              ]
            ]
          ],
          'region' => [
            'visible' => NULL
          ],
          'teams' => [
            'visible' => NULL,
            'readOnly' => NULL
          ],
          'assignedUser' => [
            'visible' => NULL
          ],
          'sicCode' => [
            'required' => NULL
          ],
          'website' => [
            'invalid' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'website',
                  'value' => 'gmail.com'
                ]
              ]
            ],
            'visible' => NULL,
            'required' => NULL
          ],
          'accountParent' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'typeOfCompany',
                  'value' => 'Filial'
                ]
              ]
            ]
          ],
          'accounts' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'typeOfCompany',
                  'value' => 'Matriz'
                ]
              ]
            ]
          ],
          'sPMSID' => [
            'visible' => NULL
          ],
          'cisCode' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ]
        ],
        'options' => [
          'country' => NULL
        ],
        'panels' => []
      ]
    ],
    'Activities' => [
      'controller' => 'crm:controllers/activities'
    ],
    'Calendar' => [
      'colors' => [
        'Meeting' => '#558BBD',
        'Call' => '#CF605D',
        'Task' => '#70c173',
        'ProjectTask' => '#73c5c0'
      ],
      'scopeList' => [
        0 => 'Meeting',
        1 => 'Call',
        2 => 'Task'
      ],
      'allDayScopeList' => [
        0 => 'Task'
      ],
      'modeList' => [
        0 => 'month',
        1 => 'agendaWeek',
        2 => 'timeline',
        3 => 'agendaDay'
      ],
      'sharedViewModeList' => [
        0 => 'basicWeek',
        1 => 'month',
        2 => 'basicDay'
      ],
      'additionalColorList' => [
        0 => '#AB78AD',
        1 => '#CC9B45'
      ],
      'iconClass' => 'far fa-calendar-alt',
      'slotDuration' => 30
    ],
    'Call' => [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/call',
      'views' => [
        'detail' => 'crm:views/call/detail'
      ],
      'recordViews' => [
        'list' => 'crm:views/call/record/list',
        'detail' => 'crm:views/call/record/detail',
        'editSmall' => 'crm:views/call/record/edit-small'
      ],
      'modalViews' => [
        'detail' => 'crm:views/meeting/modals/detail'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'crm:handlers/event/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/event/reminders-handler'
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'editSmall' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => false,
            'order' => 3
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => false,
            'order' => 1
          ]
        ],
        'editSmall' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => false,
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'planned'
        ],
        1 => [
          'name' => 'held',
          'style' => 'success'
        ],
        2 => [
          'name' => 'todays'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'activityDefs' => [
        'link' => 'calls',
        'activitiesCreate' => true,
        'historyCreate' => true
      ],
      'forcePatchAttributeDependencyMap' => [
        'dateEnd' => [
          0 => 'dateStart'
        ],
        'dateEndDate' => [
          0 => 'dateStartDate'
        ]
      ],
      'relationshipPanels' => [
        'contacts' => [
          'selectHandler' => 'handlers/select-related/same-account-many'
        ]
      ],
      'additionalLayouts' => [
        'bottomPanelsEditSmall' => [
          'type' => 'bottomPanelsEditSmall'
        ]
      ],
      'iconClass' => 'fas fa-phone',
      'dynamicLogic' => [
        'fields' => [
          'leadCountry' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'leadId',
                  'data' => [
                    'field' => 'lead'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Campaign' => [
      'controller' => 'controllers/record',
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Target Lists',
              'link' => '#TargetList',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'TargetList'
            ]
          ],
          'dropdown' => [
            0 => [
              'label' => 'Mass Emails',
              'link' => '#MassEmail',
              'acl' => 'read',
              'aclScope' => 'MassEmail'
            ],
            1 => [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate'
            ],
            2 => [
              'label' => 'Tracking URLs',
              'labelTranslation' => 'Campaign.links.trackingUrls',
              'link' => '#CampaignTrackingUrl',
              'acl' => 'read',
              'aclScope' => 'CampaignTrackingUrl'
            ]
          ]
        ]
      ],
      'recordViews' => [
        'detail' => 'crm:views/campaign/record/detail'
      ],
      'views' => [
        'detail' => 'crm:views/campaign/detail'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'statistics',
            'label' => 'Statistics',
            'view' => 'crm:views/campaign/record/panels/campaign-stats',
            'hidden' => false,
            'isForm' => true
          ]
        ]
      ],
      'relationshipPanels' => [
        'campaignLogRecords' => [
          'view' => 'crm:views/campaign/record/panels/campaign-log-records',
          'layout' => 'listForCampaign',
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'select' => false,
          'create' => false
        ],
        'massEmails' => [
          'createAttributeMap' => [
            'targetListsIds' => 'targetListsIds',
            'targetListsNames' => 'targetListsNames',
            'excludingTargetListsIds' => 'excludingTargetListsIds',
            'excludingTargetListsNames' => 'excludingTargetListsNames'
          ],
          'createHandler' => 'crm:handlers/campaign/mass-emails-create'
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'dynamicLogic' => [
        'fields' => [
          'targetLists' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Email'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Newsletter'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Mail'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'excludingTargetLists' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Email'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Newsletter'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Mail'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'contactsTemplate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'leadsTemplate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'accountsTemplate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'usersTemplate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'mailMergeOnlyWithAddress' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'mailMerge' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-chart-line'
    ],
    'CampaignLogRecord' => [
      'acl' => 'crm:acl/campaign-tracking-url'
    ],
    'CampaignTrackingUrl' => [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/campaign-tracking-url',
      'recordViews' => [
        'edit' => 'crm:views/campaign-tracking-url/record/edit',
        'editQuick' => 'crm:views/campaign-tracking-url/record/edit-small'
      ],
      'defaultSidePanel' => [
        'edit' => false,
        'editSmall' => false
      ],
      'dynamicLogic' => [
        'fields' => [
          'url' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Redirect'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Redirect'
                ]
              ]
            ]
          ],
          'message' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Show Message'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Show Message'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Case' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'detail' => 'crm:views/case/record/detail'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'close',
          'label' => 'Close',
          'handler' => 'crm:handlers/case/detail-actions',
          'actionFunction' => 'close',
          'checkVisibilityFunction' => 'isCloseAvailable'
        ],
        1 => [
          'name' => 'reject',
          'label' => 'Reject',
          'handler' => 'crm:handlers/case/detail-actions',
          'actionFunction' => 'reject',
          'checkVisibilityFunction' => 'isRejectAvailable'
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/case/record/panels/activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/case/record/panels/activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/case/record/panels/activities',
            'disabled' => true
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'open'
        ],
        1 => [
          'name' => 'closed',
          'style' => 'success'
        ]
      ],
      'relationshipPanels' => [
        'articles' => [
          'createDisabled' => true,
          'editDisabled' => true,
          'removeDisabled' => true,
          'rowActionList' => [
            0 => 'sendInEmail'
          ]
        ],
        'contacts' => [
          'createAttributeMap' => [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'contact' => [
          'createAttributeMap' => [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'selectHandler' => 'handlers/select-related/same-account-many'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'selectDefaultFilters' => [
        'filter' => 'open'
      ],
      'allowInternalNotes' => true,
      'dynamicLogic' => [
        'fields' => [
          'number' => [
            'visible' => NULL
          ],
          'other' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'solicitationEntity',
                  'value' => 'Other'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'solicitationEntity',
                  'value' => 'Other'
                ]
              ]
            ]
          ],
          'slaPrediction' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'eNUBE',
                      'linkId' => '614487be03abac1db'
                    ]
                  ],
                  'value' => '614487be03abac1db'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'eNUBE',
                      'linkId' => '614487be03abac1db'
                    ]
                  ],
                  'value' => '614487be03abac1db'
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'detailPortal' => [
          'type' => 'detail'
        ],
        'detailSmallPortal' => [
          'type' => 'detail'
        ],
        'listPortal' => [
          'type' => 'list'
        ]
      ],
      'iconClass' => 'fas fa-briefcase',
      'kanbanViewMode' => true,
      'color' => NULL
    ],
    'Contact' => [
      'controller' => 'controllers/record',
      'aclPortal' => 'crm:acl-portal/contact',
      'views' => [
        'detail' => 'crm:views/contact/detail'
      ],
      'recordViews' => [
        'detail' => 'crm:views/contact/record/detail',
        'detailQuick' => 'crm:views/contact/record/detail-small'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'relationshipPanels' => [
        'campaignLogRecords' => [
          'rowActionsView' => 'views/record/row-actions/empty',
          'select' => false,
          'create' => false
        ],
        'opportunities' => [
          'layout' => 'listForContact',
          'createAttributeMap' => [
            'accountId' => 'accountId',
            'accountName' => 'accountName',
            'id' => 'contactId',
            'name' => 'contactName'
          ],
          'selectHandler' => 'handlers/select-related/same-account'
        ],
        'cases' => [
          'createAttributeMap' => [
            'accountId' => 'accountId',
            'accountName' => 'accountName',
            'id' => 'contactId',
            'name' => 'contactName'
          ],
          'selectHandler' => 'handlers/select-related/same-account'
        ],
        'targetLists' => [
          'create' => false,
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ],
        'marketing' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'accounts' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'accountEndCustomer' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => [
        'detailConvert' => [
          'type' => 'detail'
        ],
        'listForAccount' => [
          'type' => 'listSmall'
        ]
      ],
      'filterList' => [
        0 => 'portalUsers'
      ],
      'dynamicLogic' => [
        'fields' => [
          'title' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'accountId'
                ]
              ]
            ]
          ],
          'portalUser' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'portalUserId',
                  'data' => [
                    'field' => 'portalUser'
                  ]
                ]
              ]
            ]
          ],
          'partnerID' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Renewal'
                ]
              ]
            ]
          ],
          'customerID' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ]
          ],
          'requestedContact' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'requestedContact'
                ]
              ]
            ]
          ],
          'source' => [
            'visible' => NULL
          ],
          'cMarketing' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'source',
                  'value' => [
                    0 => 'Campaign',
                    1 => 'Manufacturer',
                    2 => 'Meetings'
                  ]
                ]
              ]
            ]
          ],
          'salesContact' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'salesContact'
                ]
              ]
            ]
          ]
        ]
      ],
      'color' => '#a4c5e0',
      'iconClass' => 'fas fa-id-badge',
      'kanbanViewMode' => false
    ],
    'Document' => [
      'aclPortal' => 'crm:acl-portal/document',
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'crm:views/document/list'
      ],
      'modalViews' => [
        'select' => 'crm:views/document/modals/select-records'
      ],
      'viewSetupHandlers' => [
        'list' => [
          0 => 'crm:view-setup-handlers/document/record-list-drag-n-drop'
        ]
      ],
      'filterList' => [
        0 => 'active',
        1 => 'draft'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'selectDefaultFilters' => [
        'filter' => 'active'
      ],
      'iconClass' => 'far fa-file-alt',
      'recordViews' => [
        'editSmall' => 'custom:views/Document/record/edit-small'
      ],
      'dynamicLogic' => [
        'fields' => [
          'avisoEstimativa' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Demo',
                      'linkId' => '6785619145089d834'
                    ]
                  ],
                  'value' => '6785619145089d834'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'DocumentFolder' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#DocumentFolder/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Documents',
              'link' => '#Document',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'Document'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#DocumentFolder',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Documents',
              'link' => '#Document',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'Document'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'children' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ]
    ],
    'EmailQueueItem' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'crm:views/email-queue-item/list'
      ],
      'recordViews' => [
        'list' => 'crm:views/email-queue-item/record/list'
      ],
      'createDisabled' => true,
      'mergeDisabled' => true,
      'massUpdateDisabled' => true
    ],
    'KnowledgeBaseArticle' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'crm:views/knowledge-base-article/list'
      ],
      'recordViews' => [
        'editQuick' => 'crm:views/knowledge-base-article/record/edit-quick',
        'detailQuick' => 'crm:views/knowledge-base-article/record/detail-quick',
        'detail' => 'crm:views/knowledge-base-article/record/detail',
        'edit' => 'crm:views/knowledge-base-article/record/edit',
        'list' => 'crm:views/knowledge-base-article/record/list'
      ],
      'modalViews' => [
        'select' => 'crm:views/knowledge-base-article/modals/select-records'
      ],
      'rowActionDefs' => [
        'moveToTop' => [
          'label' => 'Move to Top',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'moveUp' => [
          'label' => 'Move Up',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'moveDown' => [
          'label' => 'Move Down',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'moveToBottom' => [
          'labelTranslation' => 'KnowledgeBaseArticle.labels.Move to Bottom',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'sendInEmail' => [
          'label' => 'Send in Email',
          'handler' => 'crm:handlers/knowledge-base-article/send-in-email'
        ]
      ],
      'rowActionList' => [
        0 => 'moveToTop',
        1 => 'moveUp',
        2 => 'moveDown',
        3 => 'moveToBottom'
      ],
      'filterList' => [
        0 => [
          'name' => 'published',
          'accessDataList' => [
            0 => [
              'inPortalDisabled' => true
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => [
          'name' => 'onlyMy',
          'accessDataList' => [
            0 => [
              'inPortalDisabled' => true
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'cases' => [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-view-and-unlink'
        ]
      ],
      'additionalLayouts' => [
        'detailPortal' => [
          'type' => 'detail'
        ],
        'detailSmallPortal' => [
          'type' => 'detail'
        ],
        'listPortal' => [
          'type' => 'list'
        ]
      ],
      'iconClass' => 'fas fa-book',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'KnowledgeBaseCategory' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#KnowledgeBaseCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Articles',
              'link' => '#KnowledgeBaseArticle',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'KnowledgeBaseArticle'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#KnowledgeBaseCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Articles',
              'link' => '#KnowledgeBaseArticle',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'KnowledgeBaseArticle'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'children' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ]
    ],
    'Lead' => [
      'controller' => 'crm:controllers/lead',
      'views' => [
        'detail' => 'crm:views/lead/detail'
      ],
      'recordViews' => [
        'detail' => 'crm:views/lead/record/detail'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ],
          1 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          2 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          3 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ],
          1 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          2 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          3 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'editSmall' => [
          0 => [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'relationshipPanels' => [
        'campaignLogRecords' => [
          'rowActionsView' => 'views/record/row-actions/empty',
          'select' => false,
          'create' => false
        ],
        'targetLists' => [
          'create' => false,
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'actual'
        ],
        1 => [
          'name' => 'converted',
          'style' => 'success'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'dynamicLogic' => [
        'fields' => [
          'name' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isEmpty',
                  'attribute' => 'accountName'
                ],
                1 => [
                  'type' => 'isEmpty',
                  'attribute' => 'emailAddress'
                ],
                2 => [
                  'type' => 'isEmpty',
                  'attribute' => 'phoneNumber'
                ]
              ]
            ]
          ],
          'convertedAt' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'status',
                      'value' => 'Converted'
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'convertedAt'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'createSurestep' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'createSurestep'
                ]
              ]
            ]
          ],
          'ciscoProjectWon' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Cisco',
                      'linkId' => '6203cd650d9de63df'
                    ]
                  ],
                  'value' => '6203cd650d9de63df'
                ]
              ]
            ]
          ],
          'alreadyContacted' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Cisco',
                      'linkId' => '6203cd650d9de63df'
                    ]
                  ],
                  'value' => '6203cd650d9de63df'
                ]
              ]
            ]
          ],
          'marketings' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'notEquals',
                      'attribute' => 'source',
                      'value' => NULL
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'convertedTo' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Converted'
                ]
              ]
            ]
          ]
        ],
        'options' => [
          'status' => NULL,
          'source' => NULL,
          'type' => [
            0 => [
              'optionList' => [
                0 => 'Customer',
                1 => 'Reseller',
                2 => 'ISV',
                3 => 'Operadora/ISP',
                4 => 'Fabricante',
                5 => 'TD SYNNEX'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'ISV Experience (Roleta)',
                      'linkId' => '632cc1e1e69b213db'
                    ]
                  ],
                  'value' => '632cc1e1e69b213db'
                ]
              ]
            ]
          ]
        ]
      ],
      'color' => '#d6a2c9',
      'iconClass' => 'fas fa-address-card',
      'kanbanViewMode' => true
    ],
    'MassEmail' => [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/mass-email',
      'recordViews' => [
        'detail' => 'crm:views/mass-email/record/detail',
        'edit' => 'crm:views/mass-email/record/edit',
        'editQuick' => 'crm:views/mass-email/record/edit-small'
      ],
      'views' => [
        'detail' => 'crm:views/mass-email/detail'
      ],
      'defaultSidePanel' => [
        'edit' => false,
        'editSmall' => false
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.EmailQueueItem',
              'link' => '#EmailQueueItem',
              'accessDataList' => [
                0 => [
                  'isAdminOnly' => true
                ]
              ]
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'or',
                      'value' => [
                        0 => [
                          'type' => 'equals',
                          'attribute' => 'status',
                          'value' => 'Complete'
                        ],
                        1 => [
                          'type' => 'equals',
                          'attribute' => 'status',
                          'value' => 'In Process'
                        ],
                        2 => [
                          'type' => 'equals',
                          'attribute' => 'status',
                          'value' => 'Failed'
                        ]
                      ]
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'options' => [
          'status' => [
            0 => [
              'optionList' => [
                0 => 'Draft',
                1 => 'Pending'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Draft',
                    1 => 'Pending'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'actual'
        ],
        1 => [
          'name' => 'complete',
          'style' => 'success'
        ]
      ],
      'relationshipPanels' => [
        'queueItems' => [
          'unlinkDisabled' => true,
          'viewDisabled' => true,
          'editDisabled' => true
        ]
      ]
    ],
    'Meeting' => [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/meeting',
      'views' => [
        'detail' => 'crm:views/meeting/detail'
      ],
      'recordViews' => [
        'list' => 'crm:views/meeting/record/list',
        'detail' => 'crm:views/meeting/record/detail',
        'editSmall' => 'crm:views/meeting/record/edit-small'
      ],
      'modalViews' => [
        'detail' => 'crm:views/meeting/modals/detail'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'crm:handlers/event/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/event/reminders-handler'
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'options' => [
              'fieldList' => [
                0 => 'users',
                1 => 'contacts',
                2 => 'leads'
              ]
            ],
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'editSmall' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'order' => 3
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'order' => 1
          ]
        ],
        'editSmall' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'planned'
        ],
        1 => [
          'name' => 'held',
          'style' => 'success'
        ],
        2 => [
          'name' => 'todays'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'activityDefs' => [
        'link' => 'meetings',
        'activitiesCreate' => true,
        'historyCreate' => true
      ],
      'forcePatchAttributeDependencyMap' => [
        'dateEnd' => [
          0 => 'dateStart'
        ],
        'dateEndDate' => [
          0 => 'dateStartDate'
        ]
      ],
      'relationshipPanels' => [
        'contacts' => [
          'selectHandler' => 'handlers/select-related/same-account-many'
        ]
      ],
      'additionalLayouts' => [
        'bottomPanelsEditSmall' => [
          'type' => 'bottomPanelsEditSmall'
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'duration' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isAllDay'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-calendar-check'
    ],
    'Opportunity' => [
      'controller' => 'controllers/record',
      'modelDefaultsPreparator' => 'crm:handlers/opportunity/defaults-preparator',
      'views' => [
        'detail' => 'custom:views/Opportunity/detail',
        'edit' => 'custom:views/Opportunity/edit'
      ],
      'recordViews' => [
        'edit' => 'custom:views/Opportunity/record/edit',
        'editSmall' => 'crm:views/opportunity/record/edit-small',
        'list' => 'crm:views/opportunity/record/list',
        'kanban' => 'crm:views/opportunity/record/kanban',
        'detail' => 'custom:views/Opportunity/record/detail'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/opportunity/record/panels/activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/opportunity/record/panels/activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true,
            'view' => 'crm:views/opportunity/record/panels/activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ],
          2 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/opportunity/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true,
            'order' => 1
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/opportunity/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true,
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'open'
        ],
        1 => [
          'name' => 'won',
          'style' => 'success'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => [
        'detailConvert' => [
          'type' => 'detail'
        ],
        'listForAccount' => [
          'type' => 'listSmall'
        ],
        'listForContact' => [
          'type' => 'listSmall'
        ]
      ],
      'kanbanViewMode' => true,
      'relationshipPanels' => [
        'contacts' => [
          'createAttributeMap' => [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'createHandler' => 'crm:handlers/opportunity/contacts-create',
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'contact' => [
          'createAttributeMap' => [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'documents' => [
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'quotes' => [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/opportunity/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'selectPrimaryFilterName' => NULL
        ],
        'salesOrders' => [
          'createAction' => 'createRelatedSalesOrder',
          'view' => 'sales:views/opportunity/record/panels/sales-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'invoices' => [
          'createAction' => 'createRelatedInvoice',
          'view' => 'sales:views/opportunity/record/panels/invoices',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'account' => [
          'selectFieldHandler' => 'sales:handlers/opportunity/select-account',
          'selectMandatoryAttributeList' => [
            0 => 'priceBookId',
            1 => 'priceBookName'
          ]
        ],
        'opportunityGoogle' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'accountReseller' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'lastStage' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'stage',
                  'value' => 'Closed Lost'
                ]
              ]
            ]
          ],
          'licenseType' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => [
                    'field' => 'productBrand',
                    'values' => [
                      'productBrandName' => 'Microsoft'
                    ]
                  ],
                  'value' => '625f87f09223468fc'
                ],
                1 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Google CCA',
                      'linkId' => '6434183de37dc38f3'
                    ]
                  ],
                  'value' => '6434183de37dc38f3'
                ],
                1 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Google NOLA',
                      'linkId' => '6434182fafe7d4fe6'
                    ]
                  ],
                  'value' => '6434182fafe7d4fe6'
                ],
                2 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Google SOLA',
                      'linkId' => '643417ce3ea5ac5c4'
                    ]
                  ],
                  'value' => '643417ce3ea5ac5c4'
                ]
              ]
            ]
          ],
          'solutionType' => [
            'visible' => NULL,
            'required' => NULL
          ],
          'dollarType' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Cloud (Microsoft)',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'amountCurrency',
                  'value' => 'BRL'
                ]
              ]
            ]
          ],
          'dollarCIS' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'dollarType',
                  'value' => 'Dólar CIS'
                ]
              ]
            ]
          ],
          'dollarIBM' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'dollarType',
                  'value' => 'Dólar IBM'
                ]
              ]
            ]
          ],
          'region' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => [
                    'field' => 'productBrand',
                    'values' => [
                      'productBrandName' => 'Google'
                    ]
                  ],
                  'value' => '636d036e352aca8bc'
                ]
              ]
            ]
          ],
          'amountDiscount' => [
            'visible' => NULL
          ],
          'cdpOpportunityID' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ]
              ]
            ]
          ],
          'lostReason' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'stage',
                      'value' => 'Cancelada'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'stage',
                      'value' => 'Closed Lost'
                    ]
                  ]
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'stage',
                  'value' => [
                    0 => 'Cancelada',
                    1 => 'Closed Lost'
                  ]
                ]
              ]
            ]
          ],
          'partnerResponsible' => [
            'visible' => NULL
          ],
          'reason' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'stage',
                  'value' => 'Cancelada'
                ]
              ]
            ]
          ],
          'productBrand' => [
            'readOnly' => NULL,
            'required' => NULL
          ],
          'marketing' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'sourceNew',
                  'value' => [
                    0 => 'Campanhas',
                    1 => 'Fabricante',
                    2 => 'Meetings'
                  ]
                ]
              ]
            ],
            'required' => NULL
          ],
          'sourceNew' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notEquals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ],
          'amount' => [
            'visible' => NULL
          ],
          'newcustomer' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'or',
                      'value' => [
                        0 => [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => [
                            'field' => 'teams',
                            'values' => [
                              'linkName' => 'Argentina (Microsoft)',
                              'linkId' => '6217bac9e998125bd'
                            ]
                          ],
                          'value' => '6217bac9e998125bd'
                        ],
                        1 => [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => [
                            'field' => 'teams',
                            'values' => [
                              'linkName' => 'Bolivia (Microsoft)',
                              'linkId' => '6217bad3434b90c8e'
                            ]
                          ],
                          'value' => '6217bad3434b90c8e'
                        ],
                        2 => [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => [
                            'field' => 'teams',
                            'values' => [
                              'linkName' => 'Caribe (Microsoft)',
                              'linkId' => '6217bae5d02a31c67'
                            ]
                          ],
                          'value' => '6217bae5d02a31c67'
                        ],
                        3 => [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => [
                            'field' => 'teams',
                            'values' => [
                              'linkName' => 'CCA (Microsoft)',
                              'linkId' => '6217baf6c5a88a957'
                            ]
                          ],
                          'value' => '6217baf6c5a88a957'
                        ],
                        4 => [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => [
                            'field' => 'teams',
                            'values' => [
                              'linkName' => 'Chile (Microsoft)',
                              'linkId' => '6217bc1cdf861cab6'
                            ]
                          ],
                          'value' => '6217bc1cdf861cab6'
                        ],
                        5 => [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => [
                            'field' => 'teams',
                            'values' => [
                              'linkName' => 'Colombia (Microsoft)',
                              'linkId' => '6217bc253e84db65c'
                            ]
                          ],
                          'value' => '6217bc253e84db65c'
                        ],
                        6 => [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => [
                            'field' => 'teams',
                            'values' => [
                              'linkName' => 'Ecuador (Microsoft)',
                              'linkId' => '6217bc2db2c52349a'
                            ]
                          ],
                          'value' => '6217bc2db2c52349a'
                        ],
                        7 => [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => [
                            'field' => 'teams',
                            'values' => [
                              'linkName' => 'Management (Microsoft)',
                              'linkId' => '64ff7607143543219'
                            ]
                          ],
                          'value' => '64ff7607143543219'
                        ],
                        8 => [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => [
                            'field' => 'teams',
                            'values' => [
                              'linkName' => 'Mexico (Microsoft)',
                              'linkId' => '6216cf950b84911eb'
                            ]
                          ],
                          'value' => '6216cf950b84911eb'
                        ],
                        9 => [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => [
                            'field' => 'teams',
                            'values' => [
                              'linkName' => 'Paraguay (Microsoft)',
                              'linkId' => '63c851e37c1d13fac'
                            ]
                          ],
                          'value' => '63c851e37c1d13fac'
                        ],
                        10 => [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => [
                            'field' => 'teams',
                            'values' => [
                              'linkName' => 'Peru (Microsoft)',
                              'linkId' => '6217bc3d5744311c2'
                            ]
                          ],
                          'value' => '6217bc3d5744311c2'
                        ],
                        11 => [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => [
                            'field' => 'teams',
                            'values' => [
                              'linkName' => 'Uruguay (Microsoft)',
                              'linkId' => '63c851ec4cf85a2e4'
                            ]
                          ],
                          'value' => '63c851ec4cf85a2e4'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'connectedAreasStatus' => [
            'visible' => NULL,
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'connectedAreas'
                ]
              ]
            ]
          ],
          'users' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => [
                        'field' => 'teams',
                        'values' => [
                          'linkName' => 'Cloud Brasil',
                          'linkId' => '6320869fe404e348c'
                        ]
                      ],
                      'value' => '6320869fe404e348c'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'country',
                      'value' => 'Brasil'
                    ],
                    2 => [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => [
                        'field' => 'teams',
                        'values' => [
                          'linkName' => 'Brasil (Geral)',
                          'linkId' => '6217badb36ba2650e'
                        ]
                      ],
                      'value' => '6217badb36ba2650e'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'discountValue' => [
            'invalid' => NULL
          ],
          'billingContact' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'createQuote'
                ]
              ]
            ]
          ],
          'quoteDateReview' => [
            'visible' => NULL
          ],
          'commercialTerms' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ],
          'customer' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'addEndUser'
                ]
              ]
            ]
          ],
          'customerEmail' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'addEndUser'
                ]
              ]
            ]
          ],
          'countryCustomer' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'addEndUser'
                ]
              ]
            ]
          ],
          'teams' => [
            'visible' => NULL,
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams'
                  ]
                ]
              ]
            ]
          ],
          'customerType' => [
            'visible' => NULL,
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ],
          'DR' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => [
                    'field' => 'productBrand',
                    'values' => [
                      'productBrandName' => 'Google'
                    ]
                  ],
                  'value' => '636d036e352aca8bc'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'country',
                      'value' => 'Brasil'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'productBrandId',
                      'data' => [
                        'field' => 'productBrand',
                        'values' => [
                          'productBrandName' => 'Google'
                        ]
                      ],
                      'value' => '636d036e352aca8bc'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'options' => [
          'solutionType' => NULL,
          'stage' => [
            0 => [
              'optionList' => [
                0 => 'Prospecting',
                1 => 'Qualification',
                2 => 'Proposal',
                3 => 'Negotiation',
                4 => 'Implementation',
                5 => 'Migration',
                6 => 'Closed Won',
                7 => 'Closed Lost',
                8 => 'Stand-by',
                9 => 'Cancelada'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Brasil (Microsoft)',
                      'linkId' => '6217badb36ba2650e'
                    ]
                  ],
                  'value' => '6217badb36ba2650e'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => 'Prospecting',
                1 => 'Qualification',
                2 => 'Proposal',
                3 => 'Negotiation',
                4 => 'Implementation',
                5 => 'Migration',
                6 => 'Closed Won',
                7 => 'Closed Lost',
                8 => 'Stand-by',
                9 => 'Cancelada',
                10 => 'In Review'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Cloud (Microsoft)',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ]
              ]
            ],
            2 => [
              'optionList' => [
                0 => 'Prospecting',
                1 => 'Qualification',
                2 => 'Proposal',
                3 => 'Negotiation',
                4 => 'Opportunity Technical Feasibility',
                5 => 'Opportunity Commercial Qualification',
                6 => 'Closed Won',
                7 => 'Closed Lost',
                8 => 'Stand-by',
                9 => 'Cancelada'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => [
                        'field' => 'teams',
                        'values' => [
                          'linkName' => 'Argentina (Microsoft)',
                          'linkId' => '6217bac9e998125bd'
                        ]
                      ],
                      'value' => '6217bac9e998125bd'
                    ],
                    1 => [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => [
                        'field' => 'teams',
                        'values' => [
                          'linkName' => 'Ecuador (Microsoft)',
                          'linkId' => '6217bc2db2c52349a'
                        ]
                      ],
                      'value' => '6217bc2db2c52349a'
                    ],
                    2 => [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => [
                        'field' => 'teams',
                        'values' => [
                          'linkName' => 'Chile (Microsoft)',
                          'linkId' => '6217bc1cdf861cab6'
                        ]
                      ],
                      'value' => '6217bc1cdf861cab6'
                    ],
                    3 => [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => [
                        'field' => 'teams',
                        'values' => [
                          'linkName' => 'Colombia (Microsoft)',
                          'linkId' => '6217bc253e84db65c'
                        ]
                      ],
                      'value' => '6217bc253e84db65c'
                    ],
                    4 => [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => [
                        'field' => 'teams',
                        'values' => [
                          'linkName' => 'Peru (Microsoft)',
                          'linkId' => '6217bc3d5744311c2'
                        ]
                      ],
                      'value' => '6217bc3d5744311c2'
                    ]
                  ]
                ]
              ]
            ],
            3 => [
              'optionList' => [
                0 => 'Prospecting',
                1 => 'Qualification',
                2 => 'Proposal',
                3 => 'Negotiation',
                4 => 'Closed Won',
                5 => 'Closed Lost',
                6 => 'Stand-by',
                7 => 'Cancelada'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Fortinet',
                      'linkId' => '62c2e5392de261577'
                    ]
                  ],
                  'value' => '62c2e5392de261577'
                ]
              ]
            ],
            4 => [
              'optionList' => [
                0 => 'Prospecting',
                1 => 'Qualification',
                2 => 'Proposal',
                3 => 'Closed Won',
                4 => 'Closed Lost',
                5 => 'Stand-by',
                6 => 'Cancelada',
                7 => 'Negotiation'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Google Partner Advantage',
                      'linkId' => '63e166ff7dab9d837'
                    ]
                  ],
                  'value' => '63e166ff7dab9d837'
                ]
              ]
            ]
          ],
          'lostReason' => [
            0 => [
              'optionList' => [
                0 => '',
                1 => 'Concorrente Tier 1',
                2 => 'Concorrente MOSP',
                3 => 'Concorrente (Outro Distribuidor)',
                4 => 'Concorrente EA',
                5 => 'Concorrente (Outro Fabricante)',
                6 => 'WO',
                7 => 'Cadastro Reprovado',
                8 => 'Crédito Reprovado',
                9 => 'Concorrente MPSA',
                10 => 'Concorrente ESD',
                11 => 'Prazo de Pagamento',
                12 => 'Cliente final desistiu da compra',
                13 => 'Fechado com outro Revendedor',
                14 => 'Sem retorno do Revendedor / Cliente final',
                15 => 'Contrato não efetivado (Stellr)',
                16 => 'Opp Duplicada'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => [
                        'field' => 'teams',
                        'values' => [
                          'linkName' => 'Google Brasil',
                          'linkId' => '643418441fabd22dd'
                        ]
                      ],
                      'value' => '643418441fabd22dd'
                    ],
                    1 => [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => [
                        'field' => 'teams',
                        'values' => [
                          'linkName' => 'Cloud Brasil',
                          'linkId' => '6320869fe404e348c'
                        ]
                      ],
                      'value' => '6320869fe404e348c'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'country',
                      'value' => 'Brasil'
                    ]
                  ]
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => '',
                1 => 'Otro proveedor',
                2 => 'Otro partner de Google',
                3 => 'Tiempo de vigencia de propuestaPrecio',
                4 => 'Más adelante',
                5 => 'Licitación perdida'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ],
                1 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Google Brasil',
                      'linkId' => '643418441fabd22dd'
                    ]
                  ],
                  'value' => '643418441fabd22dd'
                ],
                2 => [
                  'type' => 'notEquals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ],
          'licenseType' => [
            0 => [
              'optionList' => [
                0 => 'New Business',
                1 => 'Renewal',
                2 => 'Upgrade'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => [
                        'field' => 'teams',
                        'values' => [
                          'linkName' => 'Google SOLA',
                          'linkId' => '643417ce3ea5ac5c4'
                        ]
                      ],
                      'value' => '643417ce3ea5ac5c4'
                    ],
                    1 => [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => [
                        'field' => 'teams',
                        'values' => [
                          'linkName' => 'Google General',
                          'linkId' => '640f417f9bc453ac3'
                        ]
                      ],
                      'value' => '640f417f9bc453ac3'
                    ]
                  ]
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => 'Azure',
                1 => 'M365',
                2 => 'Dynamics 365',
                3 => 'Software Subscription',
                4 => 'Software Perpetual',
                5 => 'CSP',
                6 => 'NCE',
                7 => 'Open Value',
                8 => 'SPLA',
                9 => 'ESA',
                10 => 'Marketplace',
                11 => 'Services'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => [
                    'field' => 'productBrand',
                    'values' => [
                      'productBrandName' => 'Microsoft'
                    ]
                  ],
                  'value' => '5f0b4703b1bafeb52'
                ]
              ]
            ],
            2 => [
              'optionList' => [
                0 => 'Google Cloud Platform',
                1 => 'Google Workspace',
                2 => 'Commit - GCP',
                3 => 'Commit - WS',
                4 => 'Google Workspace Starter',
                5 => 'Google Workspace Business (1-300 Seats)',
                6 => 'Google Workspace Essentials',
                7 => 'Google Workspace Standard',
                8 => 'Google Workspace Plus',
                9 => 'Google Workspace AppSheet',
                10 => 'Cloud Identity',
                11 => 'Google Vault',
                12 => 'Google Voice',
                13 => 'Google Workspace Business',
                14 => 'Google Workspace Enterprise'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => [
                    'field' => 'productBrand',
                    'values' => [
                      'productBrandName' => 'Google'
                    ]
                  ],
                  'value' => '636d036e352aca8bc'
                ]
              ]
            ],
            3 => [
              'optionList' => [
                0 => 'Pay As You Go',
                1 => 'Marketplace'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => [
                    'field' => 'productBrand',
                    'values' => [
                      'productBrandName' => 'AWS'
                    ]
                  ],
                  'value' => '61c0b27f1ac2732b5'
                ]
              ]
            ]
          ]
        ],
        'panels' => []
      ],
      'color' => '#9fc77e',
      'iconClass' => 'fas fa-dollar-sign',
      'eblaKanbanMultipleIgnoreOptions' => [
        '' => NULL,
        'stage' => [
          0 => 'Migration',
          1 => 'Opportunity Technical Feasibility',
          2 => 'Opportunity Commercial Qualification',
          3 => 'In Review'
        ]
      ],
      'eblaKanbanMultipleFields' => [
        0 => 'stage'
      ]
    ],
    'TargetList' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'optedOut',
            'label' => 'Opted Out',
            'view' => 'crm:views/target-list/record/panels/opted-out'
          ],
          1 => [
            'name' => 'syncWithReports',
            'label' => 'Sync with Reports',
            'view' => 'advanced:views/target-list/record/panels/sync-with-reports',
            'notRefreshable' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'syncWithReports',
            'label' => 'Sync with Reports',
            'view' => 'advanced:views/target-list/record/panels/sync-with-reports',
            'notRefreshable' => true,
            'isForm' => true
          ]
        ]
      ],
      'recordViews' => [
        'detail' => 'crm:views/target-list/record/detail'
      ],
      'relationshipPanels' => [
        'contacts' => [
          'actionList' => [
            0 => [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => [
                'link' => 'contacts'
              ]
            ],
            1 => [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => [
                'link' => 'contacts'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'leads' => [
          'actionList' => [
            0 => [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => [
                'link' => 'leads'
              ]
            ],
            1 => [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => [
                'link' => 'leads'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'accounts' => [
          'actionList' => [
            0 => [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => [
                'link' => 'accounts'
              ]
            ],
            1 => [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => [
                'link' => 'accounts'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'users' => [
          'create' => false,
          'actionList' => [
            0 => [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => [
                'link' => 'users'
              ]
            ],
            1 => [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => [
                'link' => 'users'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'syncWithReports' => [
          'createDisabled' => true
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'entryCount' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'optedOutCount' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-crosshairs',
      'formDependency' => [
        'syncWithReportsEnabled' => [
          'map' => [
            'true' => [
              0 => [
                'action' => 'show',
                'fields' => [
                  0 => 'syncWithReports',
                  1 => 'syncWithReportsUnlink'
                ]
              ]
            ]
          ],
          'default' => [
            0 => [
              'action' => 'hide',
              'fields' => [
                0 => 'syncWithReports',
                1 => 'syncWithReportsUnlink'
              ]
            ]
          ]
        ]
      ]
    ],
    'Task' => [
      'controller' => 'crm:controllers/task',
      'recordViews' => [
        'list' => 'crm:views/task/record/list',
        'detail' => 'crm:views/task/record/detail'
      ],
      'views' => [
        'list' => 'crm:views/task/list',
        'detail' => 'crm:views/task/detail'
      ],
      'modalViews' => [
        'detail' => 'crm:views/task/modals/detail'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'crm:handlers/task/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/task/reminders-handler'
        ]
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'label' => 'Complete',
              'name' => 'setCompletedMain',
              'iconHtml' => '<span class="fas fa-check fa-sm"></span>',
              'acl' => 'edit',
              'handler' => 'crm:handlers/task/menu',
              'actionFunction' => 'complete',
              'checkVisibilityFunction' => 'isCompleteAvailable'
            ]
          ]
        ]
      ],
      'modalDetailActionList' => [
        0 => [
          'name' => 'complete',
          'label' => 'Complete',
          'acl' => 'edit',
          'handler' => 'crm:handlers/task/detail-actions',
          'actionFunction' => 'complete',
          'checkVisibilityFunction' => 'isCompleteAvailable'
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'dateCompleted' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Completed'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ],
        2 => [
          'name' => 'todays'
        ],
        3 => [
          'name' => 'overdue',
          'style' => 'danger'
        ],
        4 => [
          'name' => 'deferred'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-tasks',
      'kanbanViewMode' => true,
      'eblaKanbanMultipleFields' => NULL
    ],
    'BpmnFlowNode' => [
      'mergeDisabled' => true,
      'exportDisabled' => true,
      'massUpdateDisabled' => true,
      'massRemoveDisabled' => true
    ],
    'BpmnFlowchart' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'detail' => 'advanced:views/bpmn-flowchart/record/detail',
        'edit' => 'advanced:views/bpmn-flowchart/record/edit'
      ],
      'mergeDisabled' => true,
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'label' => 'Processes',
              'link' => '#BpmnProcess',
              'acl' => 'read',
              'aclScope' => 'BpmnProcess'
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'relationshipPanels' => [
        'processes' => [
          'create' => false,
          'select' => false,
          'unlinkDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/view-only'
        ]
      ],
      'iconClass' => 'fas fa-project-diagram',
      'dynamicLogic' => [
        'fields' => [
          'targetType' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'elements' => [
        'eventStartConditional' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'isInterrupting' => [
              'type' => 'bool'
            ],
            'triggerType' => [
              'type' => 'enum',
              'options' => [
                0 => 'afterRecordCreated',
                1 => 'afterRecordUpdated',
                2 => 'afterRecordSaved'
              ]
            ],
            'conditions' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/conditions'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'triggerType'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'isInterrupting'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'label' => 'Conditions',
              'name' => 'conditions',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'conditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'defaults' => [
            'triggerType' => 'afterRecordCreated',
            'isInterrupting' => false
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/event-start-conditional-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/event-start-conditional-edit'
        ],
        'eventStartTimer' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'isInterrupting' => [
              'type' => 'bool'
            ],
            'timer' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/timer'
            ],
            'targetReport' => [
              'type' => 'link',
              'entity' => 'Report',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/target-report',
              'tooltip' => true
            ],
            'scheduling' => [
              'type' => 'varchar',
              'maxLength' => 16,
              'tooltip' => true
            ],
            'schedulingApplyTimezone' => [
              'type' => 'bool',
              'default' => false,
              'tooltip' => true
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'targetReport'
                  ],
                  1 => [
                    'name' => 'scheduling'
                  ]
                ],
                1 => [
                  0 => [
                    'name' => 'isInterrupting'
                  ],
                  1 => [
                    'name' => 'schedulingApplyTimezone'
                  ]
                ],
                2 => [
                  0 => [
                    'name' => 'timer',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'defaults' => [
            'isInterrupting' => false,
            'timerBase' => NULL,
            'timerShift' => 0,
            'timerShiftUnits' => 'minutes',
            'timerShiftOperator' => 'plus',
            'timerFormula' => NULL,
            'targetReportId' => NULL,
            'scheduling' => '0 0 * * *',
            'schedulingApplyTimezone' => false
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/event-start-timer-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/event-start-timer-edit'
        ],
        'eventStartError' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'errorCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'errorCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventStartEscalation' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'isInterrupting' => [
              'type' => 'bool'
            ],
            'escalationCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => [
            'escalationCode' => NULL,
            'isInterrupting' => false
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'isInterrupting'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventStartSignal' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'isInterrupting' => [
              'type' => 'bool'
            ],
            'signal' => [
              'type' => 'varchar',
              'maxLength' => 200,
              'trim' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/signal'
            ]
          ],
          'defaults' => [
            'signal' => NULL,
            'isInterrupting' => false
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'isInterrupting'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/event-start-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/event-start-signal-edit'
        ],
        'eventStart' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventStartCompensation' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventEnd' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventEndTerminate' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventEndError' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'errorCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'errorCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventEndEscalation' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'escalationCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => [
            'escalationCode' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventEndSignal' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'signal' => [
              'type' => 'varchar',
              'maxLength' => 200,
              'trim' => true
            ]
          ],
          'defaults' => [
            'signal' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateSignalThrow' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'signal' => [
              'type' => 'varchar',
              'maxLength' => 200,
              'trim' => true
            ]
          ],
          'defaults' => [
            'signal' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateSignalCatch' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'signal' => [
              'type' => 'varchar',
              'maxLength' => 200,
              'trim' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/signal'
            ]
          ],
          'defaults' => [
            'signal' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateCompensationThrow' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'activityId' => [
              'type' => 'varchar',
              'maxLength' => 36,
              'trim' => true,
              'tooltip' => 'compensateActivityId'
            ]
          ],
          'defaults' => [
            'activityId' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text'
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'activityId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventEndCompensation' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'activityId' => [
              'type' => 'varchar',
              'maxLength' => 36,
              'trim' => true,
              'tooltip' => 'compensateActivityId'
            ]
          ],
          'defaults' => [
            'activityId' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text'
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'activityId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateMessageCatch' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'messageType' => [
              'type' => 'enum',
              'options' => 'Email'
            ],
            'repliedTo' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-replied-to'
            ],
            'relatedTo' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-related-to'
            ],
            'conditionsFormula' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-conditions-formula'
            ]
          ],
          'defaults' => [
            'repliedTo' => NULL,
            'relatedTo' => NULL,
            'messageType' => 'Email'
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'repliedTo'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'relatedTo'
                  ],
                  1 => false
                ],
                2 => [
                  0 => [
                    'name' => 'conditionsFormula'
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'dynamicLogic' => [
            'fields' => [
              'relatedTo' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isEmpty',
                      'attribute' => 'repliedTo'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateEscalationThrow' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'escalationCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => [
            'escalationCode' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateCompensationBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventIntermediateMessageBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'cancelActivity' => [
              'type' => 'bool'
            ],
            'messageType' => [
              'type' => 'enum',
              'options' => 'Email'
            ],
            'repliedTo' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-replied-to'
            ],
            'relatedTo' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-related-to'
            ],
            'conditionsFormula' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-conditions-formula'
            ]
          ],
          'defaults' => [
            'cancelActivity' => false,
            'repliedTo' => NULL,
            'relatedTo' => NULL,
            'messageType' => 'Email'
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'repliedTo'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'relatedTo'
                  ],
                  1 => false
                ],
                2 => [
                  0 => [
                    'name' => 'conditionsFormula'
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'dynamicLogic' => [
            'fields' => [
              'relatedTo' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isEmpty',
                      'attribute' => 'repliedTo'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateSignalBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'cancelActivity' => [
              'type' => 'bool'
            ],
            'signal' => [
              'type' => 'varchar',
              'maxLength' => 200,
              'trim' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/signal'
            ]
          ],
          'defaults' => [
            'signal' => NULL,
            'cancelActivity' => false
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateEscalationBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'cancelActivity' => [
              'type' => 'bool'
            ],
            'escalationCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateErrorBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'errorCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'errorCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateConditionalBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'cancelActivity' => [
              'type' => 'bool'
            ],
            'conditions' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/conditions'
            ]
          ],
          'defaults' => [
            'cancelActivity' => false
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'label' => 'Conditions',
              'name' => 'conditions',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'conditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateTimerBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'cancelActivity' => [
              'type' => 'bool'
            ],
            'timer' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/timer'
            ]
          ],
          'defaults' => [
            'cancelActivity' => false,
            'timerBase' => NULL,
            'timerShift' => 0,
            'timerShiftUnits' => 'minutes',
            'timerShiftOperator' => 'plus',
            'timerFormula' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'timer',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateConditionalCatch' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'conditions' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/conditions'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'label' => 'Conditions',
              'name' => 'conditions',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'conditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventIntermediateTimerCatch' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'timer' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/timer'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'timer',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'defaults' => [
            'timerBase' => NULL,
            'timerShift' => 0,
            'timerShiftUnits' => 'minutes',
            'timerShiftOperator' => 'plus',
            'timerFormula' => NULL
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'gatewayExclusive' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'defaultFlowId' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/default-flow-id'
            ],
            'flowsConditions' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/flows-conditions'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'divergent',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'defaultFlowId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'label' => 'Flows Conditions',
              'name' => 'flowsConditions',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'flowsConditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-edit'
        ],
        'gatewayInclusive' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'defaultFlowId' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/default-flow-id'
            ],
            'flowsConditions' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/flows-conditions'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'divergent',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'defaultFlowId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'label' => 'Flows Conditions',
              'name' => 'flowsConditions',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'flowsConditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-edit'
        ],
        'gatewayParallel' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'gatewayEventBased' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'task' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'actions' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/actions',
              'actionTypeList' => [
                0 => 'createEntity',
                1 => 'createRelatedEntity',
                2 => 'updateEntity',
                3 => 'updateRelatedEntity',
                4 => 'updateCreatedEntity',
                5 => 'updateProcessEntity',
                6 => 'relateWithEntity',
                7 => 'unrelateFromEntity',
                8 => 'applyAssignmentRule',
                9 => 'createNotification',
                10 => 'makeFollowed',
                11 => 'triggerWorkflow',
                12 => 'runService',
                13 => 'sendRequest',
                14 => 'executeFormula'
              ]
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'label' => 'Actions',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'actions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            3 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'id',
                    'options' => [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'taskScript' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'formula' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-script-formula'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'formula',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            3 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'id',
                    'options' => [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'taskUser' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'name' => [
              'type' => 'varchar',
              'trim' => true,
              'tooltip' => 'userTaskName'
            ],
            'instructions' => [
              'type' => 'text',
              'trim' => true,
              'tooltip' => 'userTaskInstructions'
            ],
            'description' => [
              'type' => 'text'
            ],
            'actionType' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-user-action-type',
              'translation' => 'BpmnUserTask.options.actionType'
            ],
            'target' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-user-target',
              'tooltip' => true
            ],
            'assignmentType' => [
              'type' => 'enum',
              'options' => [
                0 => '',
                1 => 'processAssignedUser',
                2 => 'specifiedUser',
                3 => 'rule:Round-Robin',
                4 => 'rule:Least-Busy'
              ],
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-user-assignment-type'
            ],
            'targetUser' => [
              'type' => 'link',
              'entity' => 'User'
            ],
            'targetTeam' => [
              'type' => 'link',
              'entity' => 'Team'
            ],
            'targetUserPosition' => [
              'type' => 'enum',
              'entity' => 'Report',
              'view' => 'advanced:views/workflow/fields/target-user-position'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'actionType'
                  ],
                  1 => [
                    'name' => 'target'
                  ]
                ],
                1 => [
                  0 => [
                    'name' => 'name'
                  ],
                  1 => false
                ],
                2 => [
                  0 => [
                    'name' => 'instructions'
                  ]
                ],
                3 => [
                  0 => [
                    'name' => 'assignmentType'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'assignmentRule',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'targetUser'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'targetTeam'
                  ],
                  1 => [
                    'name' => 'targetUserPosition'
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            4 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'id',
                    'options' => [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'defaults' => [
            'actionType' => 'Approve',
            'assignmentType' => 'processAssignedUser',
            'instructions' => NULL,
            'name' => NULL,
            'targetTeamId' => NULL,
            'target' => ''
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/task-user-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/task-user-edit'
        ],
        'taskSendMessage' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'messageType' => [
              'type' => 'enum',
              'options' => [
                0 => 'Email'
              ]
            ],
            'from' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-from',
              'options' => [
                0 => 'system',
                1 => 'specifiedEmailAddress',
                2 => 'processAssignedUser'
              ]
            ],
            'to' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-to',
              'options' => [
                0 => 'processAssignedUser',
                1 => 'specifiedTeams',
                2 => 'specifiedUsers',
                3 => 'specifiedContacts',
                4 => 'specifiedEmailAddress'
              ]
            ],
            'replyTo' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-reply-to',
              'options' => [
                0 => '',
                1 => 'system',
                2 => 'specifiedEmailAddress',
                3 => 'processAssignedUser'
              ]
            ],
            'cc' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-reply-to',
              'options' => [
                0 => '',
                1 => 'system',
                2 => 'specifiedEmailAddress',
                3 => 'processAssignedUser'
              ]
            ],
            'fromEmailAddress' => [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'toEmailAddress' => [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'replyToEmailAddress' => [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'ccEmailAddress' => [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'toSpecifiedTeams' => [
              'type' => 'linkMultiple',
              'entity' => 'Team'
            ],
            'toSpecifiedUsers' => [
              'type' => 'linkMultiple',
              'entity' => 'User'
            ],
            'toSpecifiedContacts' => [
              'type' => 'linkMultiple',
              'entity' => 'Contact'
            ],
            'emailTemplate' => [
              'type' => 'link',
              'entity' => 'EmailTemplate'
            ],
            'doNotStore' => [
              'type' => 'bool'
            ],
            'optOutLink' => [
              'type' => 'bool'
            ],
            'attachmentsVariable' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'messageType'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'from'
                  ],
                  1 => [
                    'name' => 'fromEmailAddress'
                  ]
                ],
                2 => [
                  0 => [
                    'name' => 'to'
                  ],
                  1 => [
                    'name' => 'toEmailAddress'
                  ]
                ],
                3 => [
                  0 => [
                    'name' => 'toSpecifiedTeams'
                  ],
                  1 => false
                ],
                4 => [
                  0 => [
                    'name' => 'toSpecifiedUsers'
                  ],
                  1 => false
                ],
                5 => [
                  0 => [
                    'name' => 'toSpecifiedContacts'
                  ],
                  1 => false
                ],
                6 => [
                  0 => [
                    'name' => 'cc'
                  ],
                  1 => [
                    'name' => 'ccEmailAddress'
                  ]
                ],
                7 => [
                  0 => [
                    'name' => 'replyTo'
                  ],
                  1 => [
                    'name' => 'replyToEmailAddress'
                  ]
                ],
                8 => [
                  0 => [
                    'name' => 'emailTemplate'
                  ],
                  1 => false
                ],
                9 => [
                  0 => [
                    'name' => 'doNotStore'
                  ],
                  1 => [
                    'name' => 'optOutLink'
                  ]
                ],
                10 => [
                  0 => [
                    'name' => 'attachmentsVariable'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            3 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'id',
                    'options' => [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/task-send-message-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/task-send-message-edit',
          'defaults' => [
            'doNotStore' => false,
            'from' => 'system',
            'to' => 'processAssignedUser',
            'replyTo' => NULL,
            'cc' => NULL,
            'messageType' => 'Email',
            'optOutLink' => false,
            'attachmentsVariable' => NULL
          ]
        ],
        'callActivity' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'callableType' => [
              'type' => 'enum',
              'options' => [
                0 => 'Process'
              ],
              'required' => true
            ],
            'target' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/call-activity-target',
              'tooltip' => true
            ],
            'targetIdExpression' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/target-id-expression',
              'tooltip' => true
            ],
            'returnCollectionVariable' => [
              'type' => 'varchar',
              'trim' => true,
              'tooltip' => true,
              'options' => [
                0 => 'resultCollection'
              ]
            ],
            'isMultiInstance' => [
              'type' => 'bool'
            ],
            'isSequential' => [
              'type' => 'bool'
            ],
            'loopCollectionExpression' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/loop-collection-expression',
              'tooltip' => true
            ],
            'flowchart' => [
              'type' => 'link',
              'entity' => 'BpmnFlowchart',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/call-activity-flowchart'
            ],
            'returnVariableList' => [
              'type' => 'array',
              'noEmptyString' => true,
              'tooltip' => true
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'defaults' => [
            'callableType' => 'Process',
            'target' => '',
            'returnVariableList' => [],
            'returnCollectionVariable' => NULL,
            'targetIdExpression' => NULL,
            'isMultiInstance' => false,
            'isSequential' => false
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'callableType'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'target'
                  ],
                  1 => false
                ],
                2 => [
                  0 => [
                    'name' => 'targetIdExpression'
                  ]
                ],
                3 => [
                  0 => [
                    'name' => 'flowchart'
                  ],
                  1 => false
                ],
                4 => [
                  0 => [
                    'name' => 'isMultiInstance'
                  ],
                  1 => false
                ],
                5 => [
                  0 => [
                    'name' => 'isSequential'
                  ],
                  1 => false
                ],
                6 => [
                  0 => [
                    'name' => 'loopCollectionExpression'
                  ]
                ],
                7 => [
                  0 => [
                    'name' => 'returnVariableList'
                  ],
                  1 => [
                    'name' => 'returnCollectionVariable'
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            3 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'id',
                    'options' => [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'dynamicLogic' => [
            'fields' => [
              'flowchart' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'callableType',
                      'value' => 'Process'
                    ]
                  ]
                ],
                'required' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'callableType',
                      'value' => 'Process'
                    ]
                  ]
                ]
              ],
              'returnVariableList' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'callableType',
                      'value' => 'Process'
                    ]
                  ]
                ]
              ],
              'loopCollectionExpression' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ],
                'required' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'returnCollectionVariable' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'isSequential' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'targetIdExpression' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ],
                'required' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/call-activity-edit'
        ],
        'subProcess' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'target' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-target',
              'tooltip' => true
            ],
            'targetType' => [
              'type' => 'varchar'
            ],
            'targetIdExpression' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/target-id-expression',
              'tooltip' => true
            ],
            'returnVariableList' => [
              'type' => 'array',
              'noEmptyString' => true,
              'tooltip' => true
            ],
            'returnCollectionVariable' => [
              'type' => 'varchar',
              'trim' => true,
              'tooltip' => true,
              'options' => [
                0 => 'resultCollection'
              ]
            ],
            'isExpanded' => [
              'type' => 'bool'
            ],
            'triggeredByEvent' => [
              'type' => 'bool'
            ],
            'isMultiInstance' => [
              'type' => 'bool'
            ],
            'isSequential' => [
              'type' => 'bool'
            ],
            'loopCollectionExpression' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/loop-collection-expression',
              'tooltip' => true
            ],
            'flowchartVisualization' => [
              'type' => 'base',
              'readOnly' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-flowchart'
            ],
            'dataList' => [
              'type' => 'jsonArray'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'defaults' => [
            'isExpanded' => true,
            'triggeredByEvent' => false,
            'loopCollectionExpression' => NULL,
            'dataList' => [],
            'target' => '',
            'returnVariableList' => [],
            'returnCollectionVariable' => NULL,
            'targetIdExpression' => NULL,
            'isMultiInstance' => false,
            'isSequential' => false
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'target'
                  ],
                  1 => [
                    'name' => 'targetType'
                  ]
                ],
                1 => [
                  0 => [
                    'name' => 'targetIdExpression'
                  ]
                ],
                2 => [
                  0 => [
                    'name' => 'isMultiInstance'
                  ],
                  1 => false
                ],
                3 => [
                  0 => [
                    'name' => 'isSequential'
                  ],
                  1 => false
                ],
                4 => [
                  0 => [
                    'name' => 'loopCollectionExpression'
                  ]
                ],
                5 => [
                  0 => [
                    'name' => 'returnVariableList'
                  ],
                  1 => [
                    'name' => 'returnCollectionVariable'
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'flowchartVisualization',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'flowchartVisualization',
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            4 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'id',
                    'options' => [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'dynamicLogic' => [
            'fields' => [
              'loopCollectionExpression' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ],
                'required' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'returnCollectionVariable' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'isSequential' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'targetIdExpression' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ],
                'required' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-edit'
        ],
        'eventSubProcess' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'target' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-target',
              'tooltip' => true
            ],
            'targetType' => [
              'type' => 'varchar'
            ],
            'isExpanded' => [
              'type' => 'bool'
            ],
            'triggeredByEvent' => [
              'type' => 'bool'
            ],
            'flowchartVisualization' => [
              'type' => 'base',
              'readOnly' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-flowchart'
            ],
            'dataList' => [
              'type' => 'jsonArray'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'defaults' => [
            'isExpanded' => true,
            'triggeredByEvent' => true,
            'dataList' => [],
            'target' => ''
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'target'
                  ],
                  1 => [
                    'name' => 'targetType'
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'flowchartVisualization',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'flowchartVisualization',
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-edit'
        ],
        'flow' => [
          'fields' => [
            'text' => [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => [
              'type' => 'text'
            ],
            'startDirection' => [
              'type' => 'enum',
              'options' => [
                0 => '',
                1 => 'r',
                2 => 'd',
                3 => 'l',
                4 => 'u'
              ],
              'view' => 'advanced:views/bpmn-flowchart-element/fields/start-direction'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'startDirection'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ]
      ]
    ],
    'BpmnProcess' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'detail' => 'advanced:views/bpmn-process/record/detail',
        'edit' => 'advanced:views/bpmn-process/record/edit',
        'detailQuick' => 'advanced:views/bpmn-process/record/detail-quick',
        'editQuick' => 'advanced:views/bpmn-process/record/edit-quick',
        'list' => 'advanced:views/bpmn-process/record/list'
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'label' => 'Flowcharts',
              'link' => '#BpmnFlowchart',
              'acl' => 'read',
              'aclScope' => 'BpmnFlowchart'
            ],
            1 => [
              'label' => 'User Tasks',
              'link' => '#BpmnUserTask',
              'acl' => 'read',
              'aclScope' => 'BpmnUserTask'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'endedAt' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Ended'
                ]
              ]
            ]
          ],
          'status' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'name' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'parentProcess' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'parentProcessId',
                  'data' => [
                    'field' => 'parentProcess'
                  ]
                ]
              ]
            ]
          ],
          'flowchartVisualization' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ],
                1 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'notEquals',
                      'attribute' => 'status',
                      'value' => 'Created'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'targetType' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'flowchart' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'target' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ],
                    1 => [
                      'type' => 'isEmpty',
                      'attribute' => 'targetType',
                      'data' => [
                        'field' => 'targetType'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'flowNodes' => [
          'rowActionsView' => 'advanced:views/bpmn-flow-node/record/row-actions/default',
          'recordListView' => 'advanced:views/bpmn-flow-node/record/list',
          'select' => false,
          'create' => false,
          'unlinkDisabled' => true,
          'view' => 'advanced:views/bpmn-process/record/panels/flow-nodes'
        ],
        'userTasks' => [
          'rowActionsView' => 'views/record/row-actions/empty',
          'unlinkDisabled' => true,
          'select' => false,
          'create' => false
        ]
      ],
      'filterList' => [
        0 => 'actual',
        1 => 'ended'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-cogs'
    ],
    'BpmnUserTask' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'recordViews' => [
        'detail' => 'advanced:views/bpmn-user-task/record/detail'
      ],
      'views' => [
        'detail' => 'advanced:views/bpmn-user-task/detail'
      ],
      'dynamicLogic' => [
        'options' => [
          'resolution' => [
            0 => [
              'optionList' => [
                0 => '',
                1 => 'Approved',
                2 => 'Rejected'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'actionType',
                  'value' => 'Approve'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => '',
                1 => 'Reviewed'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'actionType',
                  'value' => 'Review'
                ]
              ]
            ],
            2 => [
              'optionList' => [
                0 => '',
                1 => 'Completed',
                2 => 'Failed'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'actionType',
                  'value' => 'Accomplish'
                ]
              ]
            ]
          ]
        ],
        'fields' => [
          'resolution' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isResolved'
                    ],
                    1 => [
                      'type' => 'isTrue',
                      'attribute' => 'isCanceled'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'resolutionNote' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'resolution'
                ],
                1 => [
                  'type' => 'isFalse',
                  'attribute' => 'isFailed'
                ]
              ]
            ]
          ],
          'instructions' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'instructions'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'resolved',
          'style' => 'success'
        ],
        2 => [
          'name' => 'canceled'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-user-cog'
    ],
    'Report' => [
      'controller' => 'advanced:controllers/report',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'boolFilters' => [
        0 => 'onlyMy'
      ],
      'recordViews' => [
        'list' => 'advanced:views/report/record/list',
        'detail' => 'advanced:views/report/record/detail',
        'edit' => 'advanced:views/report/record/edit'
      ],
      'views' => [
        'list' => 'advanced:views/report/list',
        'result' => 'advanced:views/report/result',
        'detail' => 'advanced:views/report/detail'
      ],
      'modalViews' => [
        'select' => 'advanced:views/report/modals/select-records'
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [
          0 => ':assignedUser',
          1 => 'teams',
          2 => 'portals'
        ],
        'edit' => [
          0 => ':assignedUser',
          1 => 'teams',
          2 => 'portals'
        ]
      ],
      'createDisabled' => false,
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'label' => 'Create Joint Grid Report',
              'link' => '#Report/create/type=JointGrid',
              'acl' => 'create'
            ],
            1 => [
              'label' => 'Manage Categories',
              'link' => '#ReportCategory',
              'acl' => 'edit',
              'aclScope' => 'ReportCategory'
            ]
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'report',
            'label' => 'Report',
            'view' => 'advanced:views/report/record/panels/report'
          ]
        ]
      ],
      'filterList' => [
        0 => 'grid',
        1 => 'list'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'emailSending',
            'label' => 'EmailSending',
            'view' => 'advanced:views/report/record/panels/email-sending',
            'options' => [
              'fields' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'fieldList' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'inlineEditDisabled' => true,
              'mode' => 'detail'
            ],
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'emailSending',
            'label' => 'EmailSending',
            'view' => 'views/record/panels/side',
            'options' => [
              'fields' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'fieldList' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'mode' => 'edit'
            ],
            'isForm' => true
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'applyAcl' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Grid'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-chart-bar'
    ],
    'ReportCategory' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#ReportCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Reports',
              'link' => '#Report',
              'acl' => 'read',
              'aclScope' => 'Report',
              'style' => 'default'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#ReportCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Reports',
              'link' => '#Report',
              'acl' => 'read',
              'aclScope' => 'Report',
              'style' => 'default'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'reports' => [
          'create' => false
        ]
      ]
    ],
    'ReportFilter' => [
      'controller' => 'controllers/record',
      'dynamicHandler' => 'advanced:dynamic-handlers/report-filter',
      'views' => [
        'list' => 'advanced:views/report-filter/list'
      ],
      'recordViews' => [
        'list' => 'advanced:views/report-filter/record/list',
        'edit' => 'advanced:views/report-filter/record/edit',
        'editSmall' => 'advanced:views/report-filter/record/edit-small'
      ],
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Rebuild Filters',
              'name' => 'rebuildFilters',
              'action' => 'rebuildFilters'
            ]
          ]
        ]
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [],
        'edit' => [],
        'detailSmall' => [],
        'editSmall' => []
      ],
      'dynamicLogic' => [
        'fields' => [
          'report' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'entityType' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'ReportPanel' => [
      'controller' => 'controllers/record',
      'dynamicHandler' => 'advanced:dynamic-handlers/report-panel',
      'views' => [
        'list' => 'advanced:views/report-panel/list'
      ],
      'recordViews' => [
        'list' => 'advanced:views/report-panel/record/list',
        'edit' => 'advanced:views/report-panel/record/edit',
        'editSmall' => 'advanced:views/report-panel/record/edit-small'
      ],
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Rebuild Panels',
              'name' => 'rebuildPanels',
              'action' => 'rebuildPanels'
            ]
          ]
        ]
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [],
        'edit' => [],
        'detailSmall' => [],
        'editSmall' => []
      ],
      'dynamicLogic' => [
        'fields' => [
          'report' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'entityType' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'Workflow' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'detail' => 'advanced:views/workflow/record/detail',
        'edit' => 'advanced:views/workflow/record/edit',
        'list' => 'advanced:views/workflow/record/list'
      ],
      'views' => [
        'list' => 'advanced:views/workflow/list'
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'label' => 'Workflows Log',
              'link' => '#WorkflowLogRecord'
            ],
            1 => [
              'label' => 'Manage Categories',
              'link' => '#WorkflowCategory',
              'acl' => 'edit',
              'aclScope' => 'WorkflowCategory'
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'dynamicLogic' => [
        'fields' => [
          'entityType' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'type' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'signalName' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'signal'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'signal'
                ]
              ]
            ]
          ],
          'manualLabel' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualTeams' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualDynamicLogic' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ],
                1 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'manualAccessRequired' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualElementType' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualConfirmation' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualConfirmationText' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ],
                1 => [
                  'type' => 'isTrue',
                  'attribute' => 'manualConfirmation'
                ]
              ]
            ]
          ],
          'manualStyle' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ],
                1 => [
                  'type' => 'in',
                  'attribute' => 'manualElementType',
                  'value' => 'Button'
                ]
              ]
            ]
          ],
          'schedulingApplyTimezone' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'scheduled'
                ]
              ]
            ]
          ],
          'processOrder' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'afterRecordCreated',
                    1 => 'afterRecordUpdated',
                    2 => 'afterRecordSaved',
                    3 => 'scheduled',
                    4 => 'signal'
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'manual' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'WorkflowCategory' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#WorkflowCategory/list',
              'acl' => 'read'
            ],
            1 => [
              'label' => 'Workflows',
              'labelTranslation' => 'Global.scopeNamesPlural.Workflow',
              'link' => '#Workflow',
              'acl' => 'read',
              'aclScope' => 'Workflow'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#WorkflowCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Workflows',
              'labelTranslation' => 'Global.scopeNamesPlural.Workflow',
              'link' => '#Workflow',
              'acl' => 'read',
              'aclScope' => 'Workflow'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'workflows' => [
          'create' => false
        ]
      ]
    ],
    'WorkflowLogRecord' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'advanced:views/workflow-log-record/list'
      ],
      'recordViews' => [
        'list' => 'advanced:views/workflow-log-record/record/list'
      ]
    ],
    'DeliveryOrder' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'DeliveryOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'DeliveryOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Quote.labels.Templates',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.DeliveryOrderItem',
              'link' => '#DeliveryOrderItem',
              'acl' => 'read',
              'aclScope' => 'DeliveryOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'account' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'salesOrder' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'In Progress',
                            1 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ],
        'detailCreateFromSalesOrder' => [
          'type' => 'detail',
          'allFields' => true
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-shipping-fast'
    ],
    'DeliveryOrderItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.DeliveryOrder',
              'link' => '#DeliveryOrder',
              'acl' => 'read',
              'aclScope' => 'DeliveryOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryNumber' => [
          'selectHandler' => 'sales:handlers/delivery-order-item/select-inventory-number',
          'createDisabled' => true,
          'selectLayout' => 'listForProduct',
          'selectOrderBy' => 'createdAt',
          'selectOrderDirection' => 'asc'
        ]
      ]
    ],
    'InventoryAdjustment' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'duplicateDisabled' => true,
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            1 => [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryAdjustmentItem',
              'link' => '#InventoryAdjustmentItem',
              'acl' => 'read',
              'aclScope' => 'InventoryAdjustmentItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isDone'
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isDone'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => [],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-plus-circle'
    ],
    'InventoryAdjustmentItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryAdjustment',
              'link' => '#InventoryAdjustment',
              'acl' => 'read',
              'aclScope' => 'InventoryAdjustment'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ],
        'listForProduct' => [
          'type' => 'listSmall'
        ]
      ],
      'relationshipPanels' => [
        'inventoryNumber' => [
          'selectHandler' => 'sales:handlers/delivery-order-item/select-inventory-number',
          'selectLayout' => 'listForProduct',
          'createHandler' => 'sales:handlers/inventory-adjustment-item/create-inventory-number'
        ]
      ]
    ],
    'InventoryNumber' => [
      'controller' => 'controllers/record',
      'mergeDisabled' => true,
      'viewSetupHandlers' => [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/inventory-number/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/inventory-number/setup-record-detail'
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'onHand'
        ]
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'name' => 'viewHistory',
              'action' => 'viewHistory',
              'label' => 'View History',
              'data' => [
                'handler' => 'sales:handlers/inventory-number/view-history-handler'
              ]
            ]
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/inventory-number/record/panels/warehouses-quantity'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/inventory-number/record/panels/warehouses-quantity'
          ]
        ]
      ],
      'relationshipPanels' => [
        'product' => [
          'createDisabled' => true,
          'selectMandatoryAttributeList' => [
            0 => 'inventoryNumberType',
            1 => 'expirationDays'
          ],
          'selectHandler' => 'sales:handlers/inventory-number/select-product',
          'selectPrimaryFilterName' => 'available',
          'selectFieldHandler' => 'sales:handlers/inventory-number/select-field-product'
        ],
        'inventoryTransactions' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'removeDisabled' => true,
          'editDisabled' => true,
          'createAttributeMap' => [
            'productId' => 'productId',
            'productName' => 'productName'
          ]
        ]
      ],
      'additionalLayouts' => [
        'listForProduct' => [
          'type' => 'listSmall'
        ],
        'listForTemplateProduct' => [
          'type' => 'listSmall'
        ],
        'listForWarehouse' => [
          'type' => 'listSmall'
        ]
      ],
      'dynamicLogic' => [
        'panels' => [
          'quantity' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'id',
                  'type' => 'isNotEmpty'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-barcode'
    ],
    'InventoryTransaction' => [
      'controller' => 'controllers/record',
      'viewSetupHandlers' => [
        'list' => [
          0 => 'sales:handlers/info'
        ]
      ],
      'relationshipPanels' => [
        'product' => [
          'selectPrimaryFilterName' => 'inventory',
          'createDisabled' => true
        ],
        'inventoryNumber' => [
          'selectHandler' => 'sales:handlers/inventory-transaction/select-inventory-number'
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'parent' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryNumber' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Transfer',
                    1 => 'Reserve'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'inlineEditDisabled' => true,
      'massUpdateDisabled' => true,
      'convertCurrencyDisabled' => true,
      'mergeDisabled' => true,
      'layoutMassUpdateDisabled' => true,
      'layoutBottomPanelsDetailDisabled' => true,
      'layoutSidePanelsDetailDisabled' => true,
      'layoutSidePanelsEditDisabled' => true,
      'layoutSidePanelsDetailSmallDisabled' => true,
      'layoutSidePanelsEditSmallDisabled' => true,
      'iconClass' => 'fas fa-retweet'
    ],
    'Invoice' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'paid',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/invoice/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'Invoice',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'Invoice',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ],
        2 => [
          'name' => 'eInvoice',
          'label' => 'E-Invoice',
          'handler' => 'sales:handlers/invoice/e-invoice',
          'checkVisibilityFunction' => 'isAvailable',
          'actionFunction' => 'action',
          'groupIndex' => 6
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'relationshipPanels' => [
        'tax' => [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.InvoiceItem',
              'link' => '#InvoiceItem',
              'acl' => 'read',
              'aclScope' => 'InvoiceItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'account' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'opportunityId',
                      'data' => [
                        'field' => 'opportunity'
                      ]
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => [
                        'field' => 'quote'
                      ]
                    ],
                    2 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'quote' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => [
                        'field' => 'salesOrder'
                      ]
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'salesOrder' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'opportunity' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => [
                        'field' => 'quote'
                      ]
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Confirmed',
                            1 => 'Paid'
                          ]
                        ],
                        1 => [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-receipt'
    ],
    'InvoiceItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Invoices',
              'link' => '#Invoice',
              'acl' => 'read',
              'aclScope' => 'Invoice'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL
    ],
    'OpportunityItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/opportunity-item',
      'createDisabled' => true,
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Opportunities',
              'link' => '#Opportunity',
              'acl' => 'read',
              'aclScope' => 'Opportunity'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'dynamicLogic' => [
        'options' => [
          'licenseType' => [
            0 => [
              'optionList' => [
                0 => 'AWS'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'brand',
                  'value' => 'AWS'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => 'New Business',
                1 => 'Renewal',
                2 => 'Upgrade'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'brand',
                  'value' => 'Google'
                ]
              ]
            ]
          ],
          'contractType' => NULL,
          'solutionType' => NULL
        ],
        'fields' => [
          'licenseType' => [
            'visible' => NULL
          ],
          'amountDiscountItem' => [
            'visible' => NULL
          ],
          'listPrice' => [
            'visible' => NULL
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL,
      'relationshipPanels' => [
        'productBrand' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'PriceBook' => [
      'controller' => 'controllers/record',
      'viewSetupHandlers' => [
        'list' => [
          0 => 'sales:handlers/info'
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ProductPrice',
              'link' => '#ProductPrice',
              'acl' => 'read',
              'aclScope' => 'ProductPrice',
              'configCheck' => 'priceBooksEnabled'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'prices' => [
          'layout' => 'listForPriceBook',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ],
        'rules' => [
          'layout' => 'listForPriceBook',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'selectDefaultFilters' => [
        'filter' => 'active'
      ],
      'mergeDisabled' => true,
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'PriceRule' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/price-rule',
      'filterList' => [
        0 => 'active'
      ],
      'textFilterDisabled' => true,
      'dynamicLogic' => [
        'fields' => [
          'supplier' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'basedOn',
                  'value' => [
                    0 => 'Supplier'
                  ]
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'basedOn',
                  'value' => [
                    0 => 'Supplier'
                  ]
                ]
              ]
            ]
          ],
          'productCategory' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Product Category'
                  ]
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Product Category'
                  ]
                ]
              ]
            ]
          ],
          'conditionSelect' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Conditional'
                  ]
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Conditional'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'mergeDisabled' => true
    ],
    'PriceRuleCondition' => [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true
    ],
    'Product' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'sales:views/product/list'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/product/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/product/setup-record-detail'
        ]
      ],
      'modalViews' => [
        'select' => 'views/modals/select-records-with-categories'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'viewPrice',
          'label' => 'View Price',
          'handler' => 'sales:handlers/product/view-price-action',
          'data' => [
            'handler' => 'sales:handlers/product/view-price-action'
          ],
          'actionFunction' => 'process',
          'checkVisibilityFunction' => 'isVisible',
          'configCheck' => 'priceBooksEnabled'
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'label' => 'Categories',
              'link' => '#ProductCategory',
              'acl' => 'edit',
              'aclScope' => 'ProductCategory'
            ],
            1 => [
              'label' => 'Brands',
              'link' => '#ProductBrand',
              'acl' => 'read',
              'aclScope' => 'ProductBrand'
            ],
            2 => [
              'labelTranslation' => 'Product.links.attributes',
              'link' => '#ProductAttribute',
              'acl' => 'read',
              'aclScope' => 'ProductAttribute'
            ],
            3 => false,
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.PriceBook',
              'link' => '#PriceBook',
              'acl' => 'read',
              'aclScope' => 'PriceBook',
              'configCheck' => 'priceBooksEnabled'
            ],
            5 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Supplier',
              'link' => '#Supplier',
              'acl' => 'read',
              'aclScope' => 'Supplier'
            ],
            6 => false,
            7 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            8 => [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryNumber',
              'link' => '#InventoryNumber',
              'acl' => 'read',
              'aclScope' => 'InventoryNumber',
              'configCheck' => 'inventoryTransactionsEnabled'
            ],
            9 => [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryAdjustment',
              'link' => '#InventoryAdjustment',
              'acl' => 'read',
              'aclScope' => 'InventoryAdjustment',
              'configCheck' => 'inventoryTransactionsEnabled'
            ],
            10 => false,
            11 => [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryTransaction',
              'link' => '#InventoryTransaction',
              'acl' => 'read',
              'aclScope' => 'InventoryTransaction',
              'configCheck' => 'inventoryTransactionsEnabled'
            ]
          ]
        ]
      ],
      'massActionList' => [
        0 => 'updatePrice'
      ],
      'checkAllResultMassActionList' => [
        0 => 'updatePrice'
      ],
      'massActionDefs' => [
        'updatePrice' => [
          'handler' => 'sales:handlers/product-price/mass-update-price',
          'initFunction' => 'init',
          'actionFunction' => 'process',
          'acl' => 'edit',
          'aclScope' => 'Product'
        ]
      ],
      'filterList' => [
        0 => 'available'
      ],
      'dynamicLogic' => [
        'fields' => [
          'pricingFactor' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'pricingType',
                  'value' => [
                    0 => 'Discount from List',
                    1 => 'Markup over Cost',
                    2 => 'Profit Margin'
                  ]
                ]
              ]
            ]
          ],
          'unitPrice' => [
            'readOnly' => NULL
          ],
          'inventoryNumberType' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'expirationDays' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isInventory'
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'inventoryNumberType'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'removalStrategy' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isInventory'
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'inventoryNumberType'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'quantity' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityReserved' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityOnHand' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantitySoftReserved' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityInTransit' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityOnOrder' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'type' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'ciscoArchitecture' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'brandId',
                  'data' => [
                    'field' => 'brand',
                    'values' => [
                      'brandName' => 'Cisco'
                    ]
                  ],
                  'value' => '61c0b2851be829762'
                ]
              ]
            ]
          ],
          'partNumber' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'brandId',
                  'data' => [
                    'field' => 'brand',
                    'values' => [
                      'brandName' => 'Microsoft'
                    ]
                  ],
                  'value' => '5f0b4703b1bafeb52'
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'inventoryNumbers' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryNumberType'
                ]
              ]
            ]
          ],
          'quantity' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'inventoryAdjustmentItems' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ],
                1 => [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Template'
                  ]
                ]
              ]
            ]
          ]
        ],
        'options' => [
          'type' => [
            0 => [
              'optionList' => [
                0 => 'Regular',
                1 => 'Template'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'isEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'dynamicHandler' => 'sales:product-dynamic-handler',
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/product/record/panels/warehouses-quantity'
          ],
          1 => [
            'name' => 'orderItems',
            'label' => 'Orders',
            'view' => 'sales:views/product/record/panels/order-items',
            'recordListView' => 'sales:views/quote-item/record/list-union'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/product/record/panels/warehouses-quantity'
          ]
        ]
      ],
      'relationshipPanels' => [
        'prices' => [
          'layout' => 'listForProduct',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'createHandler' => 'sales:handlers/product/add-price',
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ],
        'supplierPrices' => [
          'layout' => 'listForProduct',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ],
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'inventoryNumbers' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'onHand'
          ],
          'layout' => 'listForProduct',
          'view' => 'sales:views/product/record/panels/inventory-numbers',
          'createHandler' => 'sales:handlers/product/create-inventory-number'
        ],
        'variants' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listVariant',
          'view' => 'sales:views/product/record/panels/variants',
          'primaryFilter' => 'allVariants',
          'filterList' => [
            0 => 'allVariants',
            1 => 'availableVariants'
          ],
          'orderBy' => 'variantOrder'
        ],
        'inventoryAdjustmentItems' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'removeDisabled' => true,
          'primaryFilter' => 'completed',
          'layout' => 'listForProduct',
          'orderBy' => 'createdAt',
          'orderDirection' => 'desc'
        ]
      ],
      'iconClass' => 'fas fa-cube',
      'additionalLayouts' => [
        'listForAdd' => [
          'type' => 'listSmall'
        ],
        'listForAddInventory' => [
          'type' => 'listSmall'
        ],
        'listForWarehouse' => [
          'type' => 'listSmall'
        ],
        'listVariant' => [
          'type' => 'listSmall'
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'ProductAttribute' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'list' => 'sales:views/product-attribute/record/list'
      ],
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'relationshipPanels' => [
        'options' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'view' => 'sales:views/product-attribute/record/panels/options',
          'recordListView' => 'sales:views/product-attribute-option/record/list-for-attribute',
          'rowActionsView' => 'sales:views/product-attribute/record/row-actions/default',
          'orderBy' => 'order',
          'orderDirection' => 'asc',
          'layout' => 'listForAttribute'
        ],
        'products' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'order' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ProductAttributeOption' => [
      'controller' => 'controllers/record',
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'relationshipPanels' => [
        'products' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ],
        'productVariants' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'order' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ProductBrand' => [
      'controller' => 'controllers/record',
      'relationshipPanels' => [
        'partnerAssessments' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'opportunityItems' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'ProductCategory' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#ProductCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Products',
              'link' => '#Product',
              'acl' => 'read',
              'aclScope' => 'Product',
              'style' => 'default'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#ProductCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Products',
              'link' => '#Product',
              'acl' => 'read',
              'aclScope' => 'Product',
              'style' => 'default'
            ]
          ]
        ]
      ]
    ],
    'ProductPrice' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/product-price',
      'filterList' => [
        0 => 'active'
      ],
      'textFilterDisabled' => true,
      'mergeDisabled' => true,
      'massActionList' => [
        0 => 'updatePrice'
      ],
      'checkAllResultMassActionList' => [
        0 => 'updatePrice'
      ],
      'massActionDefs' => [
        'updatePrice' => [
          'handler' => 'sales:handlers/product-price/mass-update-price',
          'initFunction' => 'init',
          'actionFunction' => 'process',
          'acl' => 'edit',
          'aclScope' => 'PriceBook'
        ]
      ]
    ],
    'PurchaseOrder' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'PurchaseOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'PurchaseOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'name' => 'createReceipt',
              'action' => 'createReceipt',
              'label' => 'Create Receipt',
              'acl' => 'create',
              'aclScope' => 'ReceiptOrder',
              'iconHtml' => '<span class="fas fa-dolly-flatbed"></span>',
              'data' => [
                'handler' => 'sales:handlers/purchase-order/receipt-button'
              ],
              'initFunction' => 'init'
            ]
          ]
        ],
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Supplier',
              'link' => '#Supplier',
              'acl' => 'read',
              'aclScope' => 'Supplier'
            ],
            5 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ReceiptOrder',
              'link' => '#ReceiptOrder',
              'acl' => 'read',
              'aclScope' => 'ReceiptOrder'
            ],
            6 => [
              'labelTranslation' => 'Global.scopeNamesPlural.PurchaseOrderItem',
              'link' => '#PurchaseOrderItem',
              'acl' => 'read',
              'aclScope' => 'PurchaseOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Released',
                            1 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ],
        'receiptOrders' => [
          'createAction' => 'createRelatedReceiptOrder',
          'view' => 'sales:views/purchase-order/record/panels/receipt-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'tax' => [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:purchase-order-calculation-handler',
      'iconClass' => 'fas fa-cart-plus fa-flip-horizontal'
    ],
    'PurchaseOrderItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Purchase Orders',
              'link' => '#PurchaseOrder',
              'acl' => 'read',
              'aclScope' => 'PurchaseOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'Quote' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'approved',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.QuoteItem',
              'link' => '#QuoteItem',
              'acl' => 'read',
              'aclScope' => 'QuoteItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'dateInvoiced' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Approved'
                ]
              ]
            ]
          ],
          'account' => [
            'readOnly' => NULL
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Approved'
                          ]
                        ],
                        1 => [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ],
          'version' => [
            'visible' => NULL
          ]
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ]
      ],
      'relationshipPanels' => [
        'salesOrders' => [
          'createAction' => 'createRelatedSalesOrder',
          'view' => 'sales:views/quote/record/panels/sales-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'invoices' => [
          'createAction' => 'createRelatedInvoice',
          'view' => 'sales:views/quote/record/panels/invoices',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'tax' => [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ],
        'opportunity' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-file-invoice-dollar',
      'kanbanViewMode' => true,
      'color' => NULL
    ],
    'QuoteItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Quotes',
              'link' => '#Quote',
              'acl' => 'read',
              'aclScope' => 'Quote'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL
    ],
    'ReceiptOrder' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'ReceiptOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'ReceiptOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ],
        2 => [
          'handler' => 'sales:handlers/receipt-order/import-serial-numbers-button',
          'name' => 'importSerialNumbers',
          'label' => 'Import Serial Numbers',
          'acl' => 'edit',
          'checkVisibilityFunction' => 'isVisible'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ],
          1 => [
            'name' => 'receivedItems',
            'label' => 'Received Inventory',
            'view' => 'sales:views/receipt-order/record/panels/received-items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ],
          1 => [
            'name' => 'receivedItems',
            'label' => 'Received Inventory',
            'view' => 'sales:views/receipt-order/record/panels/received-items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Quote.labels.Templates',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ReceiptOrderItem',
              'link' => '#ReceiptOrderItem',
              'acl' => 'read',
              'aclScope' => 'ReceiptOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'account' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => [
                        'field' => 'purchaseOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'returnOrder' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => [
                        'field' => 'purchaseOrder'
                      ]
                    ],
                    2 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'supplierId',
                      'data' => [
                        'field' => 'supplier'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => [
                        'field' => 'purchaseOrder'
                      ]
                    ],
                    1 => [
                      'type' => 'isEmpty',
                      'attribute' => 'supplierId',
                      'data' => [
                        'field' => 'supplier'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'supplier' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => [
                        'field' => 'purchaseOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isEmpty',
                  'attribute' => 'returnOrderId',
                  'data' => [
                    'field' => 'returnOrder'
                  ]
                ]
              ]
            ]
          ],
          'purchaseOrder' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isEmpty',
                  'attribute' => 'returnOrderId',
                  'data' => [
                    'field' => 'returnOrder'
                  ]
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ],
                        2 => [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'receivedItemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Completed'
                  ]
                ],
                1 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ],
                2 => [
                  'type' => 'isTrue',
                  'attribute' => 'isDone'
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ],
        'detailCreateFromPurchaseOrder' => [
          'type' => 'detail',
          'allFields' => true
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-truck-loading'
    ],
    'ReceiptOrderItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ReceiptOrder',
              'link' => '#ReceiptOrder',
              'acl' => 'read',
              'aclScope' => 'ReceiptOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'ReturnOrder' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'ReturnOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'ReturnOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'name' => 'createReceipt',
              'action' => 'createReceipt',
              'label' => 'Create Receipt',
              'acl' => 'create',
              'aclScope' => 'ReceiptOrder',
              'iconHtml' => '<span class="fas fa-dolly-flatbed"></span>',
              'data' => [
                'handler' => 'sales:handlers/purchase-order/receipt-button'
              ],
              'initFunction' => 'init'
            ]
          ]
        ],
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ReturnOrderItem',
              'link' => '#ReturnOrderItem',
              'acl' => 'read',
              'aclScope' => 'ReturnOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Released',
                            1 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ],
        'receiptOrders' => [
          'createAction' => 'createRelatedReceiptOrder',
          'view' => 'sales:views/return-order/record/panels/receipt-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'tax' => [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-arrow-alt-circle-left'
    ],
    'ReturnOrderItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ReturnOrder',
              'link' => '#ReturnOrder',
              'acl' => 'read',
              'aclScope' => 'ReturnOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryNumber' => [
          'selectHandler' => 'sales:handlers/return-order-item/select-inventory-number',
          'createDisabled' => true,
          'selectLayout' => 'listForProduct'
        ]
      ]
    ],
    'SalesOrder' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ],
        2 => [
          'isReportFilter' => true,
          'name' => 'reportFilter664d0b06517450b14'
        ],
        3 => [
          'isReportFilter' => true,
          'name' => 'reportFilter664d0e340882520f7'
        ],
        4 => [
          'isReportFilter' => true,
          'name' => 'reportFilter664d0e6ceb98d29e4'
        ],
        5 => [
          'isReportFilter' => true,
          'name' => 'reportFilter664d0eba732cf5106'
        ],
        6 => [
          'isReportFilter' => true,
          'name' => 'reportFilter664d0fd3e3ead8274'
        ],
        7 => [
          'isReportFilter' => true,
          'name' => 'reportFilter664d101ecb1f34383'
        ],
        8 => [
          'isReportFilter' => true,
          'name' => 'reportFilter664d1038e67c31c3c'
        ],
        9 => [
          'isReportFilter' => true,
          'name' => 'reportFilter664dfdebb84637a58'
        ],
        10 => [
          'isReportFilter' => true,
          'name' => 'reportFilter664e33d0e85544c6c'
        ],
        11 => [
          'isReportFilter' => true,
          'name' => 'reportFilter66831cbe23b6204fe'
        ],
        12 => [
          'isReportFilter' => true,
          'name' => 'reportFilter669153f230b85ba6a'
        ],
        13 => [
          'isReportFilter' => true,
          'name' => 'reportFilter66916dc409c1b86f7'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'SalesOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'SalesOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'name' => 'createDelivery',
              'action' => 'createDelivery',
              'label' => 'Create Delivery',
              'acl' => 'create',
              'aclScope' => 'DeliveryOrder',
              'iconHtml' => '<span class="fas fa-shipping-fast"></span>',
              'data' => [
                'handler' => 'sales:handlers/sales-order/delivery-button'
              ],
              'initFunction' => 'init'
            ]
          ]
        ],
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.DeliveryOrder',
              'link' => '#DeliveryOrder',
              'acl' => 'read',
              'aclScope' => 'DeliveryOrder',
              'configCheck' => 'deliveryOrdersEnabled'
            ],
            5 => [
              'labelTranslation' => 'Global.scopeNamesPlural.SalesOrderItem',
              'link' => '#SalesOrderItem',
              'acl' => 'read',
              'aclScope' => 'SalesOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'dateInvoiced' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Completed'
                ]
              ]
            ]
          ],
          'account' => [
            'readOnly' => NULL
          ],
          'opportunity' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => [
                        'field' => 'quote'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'quote' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ],
          'isDeliveryCreated' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'contractEndDateDays' => [
            'visible' => NULL
          ],
          'contractLastRenovation' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'contractLastRenovation'
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ]
      ],
      'relationshipPanels' => [
        'invoices' => [
          'createAction' => 'createRelatedInvoice',
          'view' => 'sales:views/sales-order/record/panels/invoices',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'deliveryOrders' => [
          'createAction' => 'createRelatedDeliveryOrder',
          'view' => 'sales:views/sales-order/record/panels/delivery-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'returnOrders' => [
          'createAction' => 'createRelatedReturnOrder',
          'view' => 'sales:views/sales-order/record/panels/return-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ],
        'tax' => [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-clipboard-list',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'SalesOrderItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Sales Orders',
              'link' => '#SalesOrder',
              'acl' => 'read',
              'aclScope' => 'SalesOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL
    ],
    'ShippingProvider' => [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => false
    ],
    'Supplier' => [
      'controller' => 'controllers/record',
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.SupplierProductPrice',
              'link' => '#SupplierProductPrice',
              'acl' => 'read',
              'aclScope' => 'SupplierProductPrice'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'purchaseOrders' => [
          'layout' => 'listForAccount',
          'unlinkDisabled' => true,
          'selectDisabled' => true
        ],
        'prices' => [
          'layout' => 'listForSupplier',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'selectDefaultFilters' => [
        'filter' => 'active'
      ]
    ],
    'SupplierProductPrice' => [
      'controller' => 'controllers/record',
      'filterList' => [
        0 => 'active'
      ],
      'textFilterDisabled' => true,
      'mergeDisabled' => true,
      'massActionList' => [
        0 => 'updatePrice'
      ],
      'checkAllResultMassActionList' => [
        0 => 'updatePrice'
      ],
      'massActionDefs' => [
        'updatePrice' => [
          'handler' => 'sales:handlers/product-price/mass-update-price',
          'initFunction' => 'init',
          'actionFunction' => 'process',
          'acl' => 'edit',
          'aclScope' => 'Supplier'
        ]
      ]
    ],
    'Tax' => [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true
    ],
    'TransferOrder' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'TransferOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'TransferOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Quote.labels.Templates',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.TransferOrderItem',
              'link' => '#TransferOrderItem',
              'acl' => 'read',
              'aclScope' => 'TransferOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ],
                        2 => [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-dolly fa-flip-horizontal'
    ],
    'TransferOrderItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.TransferOrder',
              'link' => '#TransferOrder',
              'acl' => 'read',
              'aclScope' => 'TransferOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryNumber' => [
          'selectHandler' => 'sales:handlers/delivery-order-item/select-inventory-number',
          'createDisabled' => true,
          'selectLayout' => 'listForProduct'
        ]
      ]
    ],
    'Warehouse' => [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => false,
      'filterList' => [
        0 => 'active'
      ],
      'selectDefaultFilters' => [
        'filter' => 'active'
      ],
      'viewSetupHandlers' => [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/warehouse/setup-record-detail'
        ]
      ],
      'mergeDisabled' => true,
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.TransferOrder',
              'link' => '#TransferOrder',
              'acl' => 'read',
              'aclScope' => 'TransferOrder'
            ]
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'products',
            'view' => 'sales:views/warehouse/record/panels/products'
          ],
          1 => [
            'name' => 'inventoryNumbers',
            'view' => 'sales:views/warehouse/record/panels/inventory-numbers'
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ],
      'iconClass' => 'fas fa-warehouse'
    ],
    'App' => [
      'navbarView' => 'dubas-custom:views/site/navbar'
    ],
    'DashboardSet' => [
      'controller' => 'controllers/record',
      'dynamicLogic' => [
        'fields' => [
          'iconClass' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Service' => [
      'controller' => 'controllers/record',
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/opportunity/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ]
        ]
      ],
      'filterList' => [],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'listSmall'
        ]
      ],
      'kanbanViewMode' => true,
      'color' => '#9fc77e',
      'iconClass' => 'fas fa-cube',
      'dynamicLogic' => [
        'fields' => [
          'cancelReason' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'stage',
                  'value' => [
                    0 => 'Criação Indevida',
                    1 => 'Perdido / Cancelado'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ServiceItem' => [
      'controller' => 'controllers/record',
      'acl' => 'dubas-custom:acl/service-item',
      'createDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Services',
              'link' => '#Service',
              'acl' => 'read',
              'aclScope' => 'Service'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'width',
            3 => 'link',
            4 => 'view',
            5 => 'customLabel'
          ]
        ]
      ]
    ],
    'Project' => [
      'controller' => 'controllers/record',
      'acl' => 'modules/project/acl/project',
      'detailViewModeList' => [
        0 => 'detail',
        1 => 'plan',
        2 => 'board',
        3 => 'gantt'
      ],
      'detailViewModeIsStorable' => true,
      'detailActionList' => [
        0 => [
          'name' => 'viewSettings',
          'acl' => 'edit',
          'label' => 'Settings',
          'groupIndex' => 8,
          'handler' => 'modules/project/handlers/project/detail-action',
          'actionFunction' => 'viewSettings'
        ],
        1 => [
          'name' => 'cloneProject',
          'label' => 'Clone',
          'groupIndex' => 9,
          'handler' => 'modules/project/handlers/project/detail-action',
          'actionFunction' => 'clone',
          'checkVisibilityFunction' => 'hasClone'
        ]
      ],
      'mergeDisabled' => true,
      'duplicateDisabled' => true,
      'recordViews' => [
        'plan' => 'modules/project/views/project/record/plan',
        'board' => 'modules/project/views/project/record/board',
        'gantt' => 'modules/project/views/project/record/gantt'
      ],
      'viewSetupHandlers' => [
        'detail' => [
          0 => 'modules/project/handlers/project/detail'
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'label' => 'Boards',
              'link' => '#ProjectBoard',
              'aclScope' => 'ProjectBoard'
            ],
            1 => [
              'label' => 'Roles',
              'link' => '#ProjectRole',
              'aclScope' => 'ProjectRole'
            ]
          ]
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'actual'
        ],
        1 => [
          'name' => 'closed',
          'style' => 'success'
        ]
      ],
      'boolFilterList' => [
        0 => 'own',
        1 => 'member'
      ],
      'relationshipPanels' => [
        'board' => [
          'selectPrimaryFilterName' => 'actual'
        ],
        'activeGroup' => [
          'createDisabled' => true,
          'selectHandler' => 'modules/project/handlers/project/relationships/select-active-group',
          'selectLayout' => 'listForSelect'
        ],
        'members' => [
          'selectHandler' => 'modules/project/handlers/project/select-members',
          'selectDisabled' => true,
          'createDisabled' => true,
          'removeDisabled' => true,
          'editDisabled' => true,
          'actionList' => [
            0 => [
              'name' => 'selectWithRole',
              'label' => 'Select',
              'handler' => 'modules/project/handlers/project/select-members-action',
              'actionFunction' => 'select',
              'acl' => 'edit'
            ]
          ],
          'rowActionList' => [
            0 => 'changeProjectRole'
          ],
          'layout' => 'listForProject',
          'orderBy' => 'projectRole'
        ],
        'tasks' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listSmallForProject',
          'filterList' => [
            0 => 'all',
            1 => 'actual',
            2 => 'completed',
            3 => 'actualParent',
            4 => 'completedParent'
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'activeGroup' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-list-alt',
      'color' => NULL,
      'kanbanViewMode' => false
    ],
    'ProjectBoard' => [
      'controller' => 'controllers/record',
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'filterList' => [
        0 => [
          'name' => 'actual'
        ]
      ],
      'relationshipPanels' => [
        'columns' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForBoard',
          'rowActionList' => [
            0 => 'moveUp',
            1 => 'moveDown'
          ]
        ]
      ]
    ],
    'ProjectColumn' => [
      'controller' => 'controllers/record',
      'acl' => 'modules/project/acl/project-column',
      'createDisabled' => true,
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'rowActionDefs' => [
        'moveUp' => [
          'label' => 'Move Up',
          'groupIndex' => 3,
          'handler' => 'modules/project/handlers/project-column/row-actions/move-up'
        ],
        'moveDown' => [
          'label' => 'Move Down',
          'groupIndex' => 3,
          'handler' => 'modules/project/handlers/project-column/row-actions/move-down'
        ]
      ]
    ],
    'ProjectGroup' => [
      'controller' => 'controllers/record',
      'acl' => 'modules/project/acl/project-group',
      'createDisabled' => true,
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true
    ],
    'ProjectRole' => [
      'controller' => 'controllers/record',
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'massRemoveDisabled' => true,
      'viewSetupHandlers' => [
        'record/edit' => [
          0 => 'modules/project/handlers/project-role/setup-record-edit'
        ]
      ]
    ],
    'ProjectTask' => [
      'controller' => 'controllers/record',
      'modelDefaultsPreparator' => 'modules/project/handlers/project-task/defaults-preparator',
      'acl' => 'modules/project/acl/project-task',
      'mergeDisabled' => true,
      'viewSetupHandlers' => [
        'record/list' => [
          0 => 'modules/project/handlers/project-task/record-list'
        ],
        'record/detail' => [
          0 => 'modules/project/handlers/project-task/record'
        ],
        'record/edit' => [
          0 => 'modules/project/handlers/project-task/record'
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'actual'
        ],
        1 => [
          'name' => 'actualParent'
        ],
        2 => [
          'name' => 'completed',
          'style' => 'success'
        ],
        3 => [
          'name' => 'completedParent',
          'style' => 'success'
        ],
        4 => [
          'name' => 'todays'
        ],
        5 => [
          'name' => 'overdue',
          'style' => 'danger'
        ]
      ],
      'additionalLayouts' => [
        'listForProject' => [
          'type' => 'list'
        ],
        'listForTask' => [
          'type' => 'list'
        ],
        'listSmallForProject' => [
          'type' => 'list'
        ],
        'kanbanForProject' => [
          'type' => 'kanban'
        ]
      ],
      'detailActionList' => [
        0 => [
          'name' => 'setCompleted',
          'label' => 'Complete',
          'groupIndex' => 1,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'complete',
          'checkVisibilityFunction' => 'hasComplete'
        ],
        1 => [
          'name' => 'setCanceled',
          'label' => 'Cancel',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'cancel',
          'checkVisibilityFunction' => 'hasCancel'
        ],
        2 => [
          'name' => 'changeColumn',
          'label' => 'Change Column',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'changeColumn',
          'checkVisibilityFunction' => 'hasChangeColumn'
        ],
        3 => [
          'name' => 'selfAssign',
          'label' => 'Self-Assign',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'selfAssign',
          'checkVisibilityFunction' => 'hasSelfAssign'
        ]
      ],
      'modalDetailActionList' => [
        0 => [
          'name' => 'setCompleted',
          'label' => 'Complete',
          'groupIndex' => 1,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'complete',
          'checkVisibilityFunction' => 'hasComplete'
        ],
        1 => [
          'name' => 'setCanceled',
          'label' => 'Cancel',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'cancel',
          'checkVisibilityFunction' => 'hasCancel'
        ],
        2 => [
          'name' => 'changeColumn',
          'label' => 'Change Column',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'changeColumn',
          'checkVisibilityFunction' => 'hasChangeColumn'
        ],
        3 => [
          'name' => 'selfAssign',
          'label' => 'Self-Assign',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'selfAssign',
          'checkVisibilityFunction' => 'hasSelfAssign'
        ],
        4 => [
          'name' => 'remove',
          'label' => 'Remove',
          'groupIndex' => 3,
          'acl' => 'delete'
        ]
      ],
      'rowActionList' => [
        0 => 'complete'
      ],
      'rowActionDefs' => [
        'complete' => [
          'labelTranslation' => 'ProjectTask.actions.complete',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/row-action-complete'
        ],
        'changeColumn' => [
          'labelTranslation' => 'ProjectTask.actions.changeColumn',
          'groupIndex' => 3,
          'handler' => 'modules/project/handlers/project-task/row-action-change-column'
        ],
        'selfAssign' => [
          'label' => 'Self-Assign',
          'groupIndex' => 3,
          'handler' => 'modules/project/handlers/project-task/row-action-self-assign'
        ],
        'moveToTop' => [
          'labelTranslation' => 'ProjectTask.actions.moveToTop',
          'acl' => 'edit',
          'groupIndex' => 4,
          'handler' => 'modules/project/handlers/project-task/row-action-move'
        ],
        'moveToBottom' => [
          'labelTranslation' => 'ProjectTask.actions.moveToBottom',
          'acl' => 'edit',
          'groupIndex' => 4,
          'handler' => 'modules/project/handlers/project-task/row-action-move'
        ]
      ],
      'massActionList' => [
        0 => 'complete'
      ],
      'massActionDefs' => [
        'complete' => [
          'acl' => 'edit',
          'handler' => 'modules/project/handlers/project-task/mass-action',
          'actionFunction' => 'complete',
          'groupIndex' => 1
        ]
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'name' => 'setCompleted',
              'label' => 'Complete',
              'iconClass' => 'fas fa-check fa-sm',
              'handler' => 'modules/project/handlers/project-task/record-action',
              'actionFunction' => 'complete',
              'checkVisibilityFunction' => 'hasComplete'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'project' => [
          'selectMandatoryAttributeList' => [
            0 => 'boardId',
            1 => 'firstColumnId'
          ],
          'selectFieldHandler' => 'modules/project/handlers/project-task/select-project'
        ],
        'group' => [
          'selectHandler' => 'modules/project/handlers/project-task/select-group',
          'selectLayout' => 'listForSelect'
        ],
        'parentTask' => [
          'createDisabled' => true
        ],
        'subTasks' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createRequiredAccess' => 'edit',
          'createAttributeMap' => [
            'projectId' => 'projectId',
            'projectName' => 'projectName'
          ],
          'rowActionList' => [
            0 => 'complete',
            1 => 'changeColumn',
            2 => 'selfAssign'
          ],
          'createHandler' => 'modules/project/handlers/project-task/create-sub-task',
          'orderBy' => 'order',
          'orderDirection' => 'asc',
          'layout' => 'listForTask',
          'filterList' => [
            0 => 'all',
            1 => 'actual'
          ]
        ],
        'fromTasks' => [
          'createDisabled' => true,
          'selectHandler' => 'modules/project/handlers/project-task/select-from-tasks',
          'selectPrimaryFilterName' => 'actual',
          'selectOrderBy' => 'combinedOrder',
          'selectOrderDirection' => 'asc'
        ],
        'owner' => [
          'selectHandler' => 'modules/project/handlers/project-task/select-owner'
        ],
        'assignedUser' => [
          'selectHandler' => 'modules/project/handlers/project-task/select-owner'
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'parentTask' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'attribute' => 'parentTaskId',
                      'type' => 'isNotEmpty',
                      'data' => [
                        'field' => 'parentTask'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'group' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'projectId',
                      'data' => [
                        'field' => 'project'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'parentTaskId',
                      'data' => [
                        'field' => 'parentTask'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'column' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'projectId',
                  'data' => [
                    'field' => 'project'
                  ]
                ]
              ]
            ]
          ],
          'hours' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Milestone'
                  ]
                ]
              ]
            ]
          ],
          'points' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Milestone'
                  ]
                ]
              ]
            ]
          ],
          'priority' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Milestone'
                  ]
                ]
              ]
            ]
          ],
          'completedAt' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Completed'
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'subTasks' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'parentTaskId',
                  'type' => 'isEmpty',
                  'data' => [
                    'field' => 'parentTask'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy',
        1 => 'own'
      ],
      'iconClass' => 'fas fa-check-double',
      'color' => NULL,
      'kanbanViewMode' => false
    ],
    'AWS' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ],
          2 => [
            'name' => 'tasks',
            'label' => 'Tasks',
            'view' => 'crm:views/record/panels/tasks',
            'aclScope' => 'Task'
          ]
        ]
      ],
      'iconClass' => 'fas fa-cloud',
      'color' => '#ff9a00',
      'dynamicLogic' => [
        'options' => [
          'tier' => NULL,
          'levelCheck' => [
            0 => [
              'optionList' => [
                0 => 'Ready to Select'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheck',
                  'value' => 'Ready to Select'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => 'Ready to Advanced'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheck',
                  'value' => 'Ready to Advanced'
                ]
              ]
            ],
            2 => [
              'optionList' => [
                0 => 'Ready to Premier'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheck',
                  'value' => 'Ready to Premier'
                ]
              ]
            ]
          ],
          'levelCheckThinkBig' => [
            0 => [
              'optionList' => [
                0 => 'Think Big for Select'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckThinkBig',
                  'value' => 'Think Big for Select'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => 'Think Big for Advanced'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckThinkBig',
                  'value' => 'Think Big for Advanced'
                ]
              ]
            ]
          ],
          'levelCheckCustomerSuccessThinkBig' => [
            0 => [
              'optionList' => [
                0 => 'Think Big for Advanced'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckCustomerSuccessThinkBig',
                  'value' => 'Think Big for Advanced'
                ]
              ]
            ]
          ],
          'levelCheckExperience' => [
            0 => [
              'optionList' => [
                0 => 'Ready to Select'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckExperience',
                  'value' => 'Ready to Select'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => 'Ready to Advanced'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckExperience',
                  'value' => 'Ready to Advanced'
                ]
              ]
            ],
            2 => [
              'optionList' => [
                0 => 'Ready to Premium'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckExperience',
                  'value' => 'Ready to Premium'
                ]
              ]
            ]
          ],
          'levelCheckExperienceThinkBig' => [
            0 => [
              'optionList' => [
                0 => 'Think Big for Select'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckExperienceThinkBig',
                  'value' => 'Think Big for Select'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => 'Think Big for Advanced'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckExperienceThinkBig',
                  'value' => 'Think Big for Advanced'
                ]
              ]
            ]
          ],
          'levelCheckKnowledge' => [
            0 => [
              'optionList' => [
                0 => 'Ready to Select'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckKnowledge',
                  'value' => 'Ready to Select'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => 'Ready to Advanced'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckKnowledge',
                  'value' => 'Ready to Advanced'
                ]
              ]
            ],
            2 => [
              'optionList' => [
                0 => 'Ready to Premier'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckKnowledge',
                  'value' => 'Ready to Premier'
                ]
              ]
            ]
          ],
          'levelCheckKnowledgeThinkBig' => [
            0 => [
              'optionList' => [
                0 => 'Think Big for Select'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckKnowledgeThinkBig',
                  'value' => 'Think Big for Select'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => 'Think Big for Advanced'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckKnowledgeThinkBig',
                  'value' => 'Think Big for Advanced'
                ]
              ]
            ]
          ],
          'levelCheckCustomerSuccess' => [
            0 => [
              'optionList' => [
                0 => 'Ready to Advanced'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckCustomerSuccess',
                  'value' => 'Ready to Advanced'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => 'Ready to Premier'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'levelCheckCustomerSuccess',
                  'value' => 'Ready to Premier'
                ]
              ]
            ]
          ]
        ],
        'fields' => [
          'aWSTechnicalCertifiedIndividualsAssociate' => [
            'visible' => NULL
          ],
          'aWSTechnicalCertifiedIndividualsProOrSpecialty' => [
            'visible' => NULL
          ],
          'countCompetency' => [
            'visible' => NULL
          ],
          'levelCheckCustomerSuccessThinkBig' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckCustomerSuccessThinkBig'
                ]
              ]
            ]
          ],
          'levelCheck' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheck'
                ]
              ]
            ]
          ],
          'levelCheckCustomerSuccess' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckCustomerSuccess'
                ]
              ]
            ]
          ],
          'levelCheckExperience' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckExperience'
                ]
              ]
            ]
          ],
          'levelCheckExperienceThinkBig' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckExperienceThinkBig'
                ]
              ]
            ]
          ],
          'levelCheckKnowledge' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckKnowledge'
                ]
              ]
            ]
          ],
          'levelCheckKnowledgeThinkBig' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckKnowledgeThinkBig'
                ]
              ]
            ]
          ],
          'levelCheckThinkBig' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckThinkBig'
                ]
              ]
            ]
          ],
          'specialities' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'specialities'
                ]
              ]
            ]
          ],
          'competency' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'competency'
                ]
              ]
            ]
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'isReportPanel' => true,
            'name' => 'reportPanel6679c7a81d16a904c',
            'label' => 'Cuentas - AWS',
            'view' => 'advanced:views/report-panel/record/panels/report-panel-bottom',
            'reportPanelId' => '6679c7a81d16a904c',
            'reportType' => 'List',
            'reportEntityType' => 'Account',
            'displayType' => 'List',
            'displayTotal' => false,
            'displayOnlyTotal' => false,
            'useSiMultiplier' => true,
            'accessDataList' => [
              0 => [
                'scope' => 'Account'
              ]
            ],
            'order' => 7
          ]
        ]
      ],
      'kanbanViewMode' => false
    ],
    'AWSVersions' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-align-left'
    ],
    'AccountVBM' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-caret-square-right'
    ],
    'Analytics' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-chart-pie',
      'views' => [
        'detail' => 'custom:views/Analytics/detail'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'dynamicLogic' => [
        'fields' => [
          'teams' => [
            'visible' => NULL
          ]
        ]
      ]
    ],
    'AssesmentCompany' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ],
          2 => [
            'name' => 'tasks',
            'label' => 'Tasks',
            'view' => 'crm:views/record/panels/tasks',
            'aclScope' => 'Task'
          ]
        ]
      ]
    ],
    'BucketTimer' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'CAccountEndCustomer' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ],
          2 => [
            'name' => 'tasks',
            'label' => 'Tasks',
            'view' => 'crm:views/record/panels/tasks',
            'aclScope' => 'Task'
          ]
        ]
      ],
      'relationshipPanels' => [
        'contacts' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'CPB' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-clipboard-list',
      'kanbanViewMode' => false,
      'color' => '#08bed5'
    ],
    'CloudConsumption' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-cloud-upload-alt',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'Contract' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-file-invoice',
      'filterList' => [
        0 => [
          'isReportFilter' => true,
          'name' => 'reportFilter6686eac9c5a60065c',
          'accessDataList' => [
            0 => [
              'teamIdList' => [
                0 => '614487be03abac1db'
              ]
            ]
          ]
        ],
        1 => [
          'isReportFilter' => true,
          'name' => 'reportFilter6686ead1b861b28d9',
          'accessDataList' => [
            0 => [
              'teamIdList' => [
                0 => '614487be03abac1db'
              ]
            ]
          ]
        ],
        2 => [
          'isReportFilter' => true,
          'name' => 'reportFilter6686eae14885b6a3a',
          'accessDataList' => [
            0 => [
              'teamIdList' => [
                0 => '614487be03abac1db'
              ]
            ]
          ]
        ],
        3 => [
          'isReportFilter' => true,
          'name' => 'reportFilter6686eae8f245d4139',
          'accessDataList' => [
            0 => [
              'teamIdList' => [
                0 => '614487be03abac1db'
              ]
            ]
          ]
        ]
      ]
    ],
    'ContractGoals' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-crosshairs',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'Country' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'DSET' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'DashboardAccess' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-chart-pie'
    ],
    'DashboardSet13' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Oportunidades ',
          'layout' => [
            0 => [
              'id' => 'DashboardSet13__d536975',
              'name' => 'Report',
              'x' => 0,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            1 => [
              'id' => 'DashboardSet13__d429999',
              'name' => 'Report',
              'x' => 1,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            2 => [
              'id' => 'DashboardSet13__d79262',
              'name' => 'Report',
              'x' => 2,
              'y' => '0',
              'width' => 2,
              'height' => '1'
            ],
            3 => [
              'id' => 'DashboardSet13__d385605',
              'name' => 'Report',
              'x' => 0,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            4 => [
              'id' => 'DashboardSet13__d902640',
              'name' => 'Report',
              'x' => 1,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            5 => [
              'id' => 'DashboardSet13__d28811',
              'name' => 'Report',
              'x' => 2,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            6 => [
              'id' => 'DashboardSet13__d843929',
              'name' => 'Report',
              'x' => 3,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            7 => [
              'id' => 'DashboardSet13__d32063',
              'name' => 'Report',
              'x' => 0,
              'y' => '2',
              'width' => 3,
              'height' => '2'
            ],
            8 => [
              'id' => 'DashboardSet13__d905801',
              'name' => 'Report',
              'x' => 3,
              'y' => '2',
              'width' => 1,
              'height' => '2'
            ],
            9 => [
              'id' => 'DashboardSet13__d257209',
              'name' => 'Report',
              'x' => 0,
              'y' => '4',
              'width' => 3,
              'height' => '2'
            ],
            10 => [
              'id' => 'DashboardSet13__d983820',
              'name' => 'Report',
              'x' => 3,
              'y' => '4',
              'width' => 1,
              'height' => '2'
            ],
            11 => [
              'id' => 'DashboardSet13__d808264',
              'name' => 'Report',
              'x' => 0,
              'y' => '6',
              'width' => 2,
              'height' => '2'
            ],
            12 => [
              'id' => 'DashboardSet13__d856827',
              'name' => 'Report',
              'x' => 2,
              'y' => '6',
              'width' => 2,
              'height' => '2'
            ]
          ],
          'id' => '5152227'
        ],
        1 => [
          'name' => 'Partner Program X Opps ',
          'layout' => [
            0 => [
              'id' => 'DashboardSet13__d246985',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '4371976'
        ]
      ]
    ],
    'DashboardSet14' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Canales',
          'layout' => [
            0 => [
              'id' => 'DashboardSet14__d188367',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet14__d240377',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet14__d837203',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet14__d845131',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet14__d464894',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet14__d630874',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet14__d638983',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 3
            ],
            7 => [
              'id' => 'DashboardSet14__d903216',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 2,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet14__d776187',
              'name' => 'Report',
              'x' => 2,
              'y' => 5,
              'width' => 2,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet14__d100687',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 3
            ],
            10 => [
              'id' => 'DashboardSet14__d904570',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 3
            ]
          ],
          'id' => '1283282'
        ]
      ]
    ],
    'DashboardSet15' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'General',
          'layout' => [
            0 => [
              'id' => 'DashboardSet15__d57190',
              'name' => 'Report',
              'x' => 0,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            1 => [
              'id' => 'DashboardSet15__d965489',
              'name' => 'Report',
              'x' => 1,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            2 => [
              'id' => 'DashboardSet15__d79262',
              'name' => 'Report',
              'x' => 2,
              'y' => '0',
              'width' => 2,
              'height' => '1'
            ],
            3 => [
              'id' => 'DashboardSet15__d385605',
              'name' => 'Report',
              'x' => 0,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            4 => [
              'id' => 'DashboardSet15__d975738',
              'name' => 'Report',
              'x' => 1,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            5 => [
              'id' => 'DashboardSet15__d28811',
              'name' => 'Report',
              'x' => 2,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            6 => [
              'id' => 'DashboardSet15__d843929',
              'name' => 'Report',
              'x' => 3,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            7 => [
              'id' => 'DashboardSet15__d225799',
              'name' => 'Report',
              'x' => 0,
              'y' => '2',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            8 => [
              'id' => 'DashboardSet15__d313587',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => '2',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            9 => [
              'id' => 'DashboardSet15__d118315',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => '2',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            10 => [
              'id' => 'DashboardSet15__d553674',
              'name' => 'Report',
              'x' => 2,
              'y' => '2',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            11 => [
              'id' => 'DashboardSet15__d283535',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => '2',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            12 => [
              'id' => 'DashboardSet15__d690932',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => '2',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            13 => [
              'id' => 'DashboardSet15__d32063',
              'name' => 'Report',
              'x' => 0,
              'y' => '3',
              'width' => 3,
              'height' => '2'
            ],
            14 => [
              'id' => 'DashboardSet15__d875879',
              'name' => 'Report',
              'x' => 3,
              'y' => '3',
              'width' => 1,
              'height' => '2'
            ],
            15 => [
              'id' => 'DashboardSet15__d317494',
              'name' => 'Report',
              'x' => 0,
              'y' => '5',
              'width' => 3,
              'height' => '2'
            ],
            16 => [
              'id' => 'DashboardSet15__d258643',
              'name' => 'Report',
              'x' => 3,
              'y' => '5',
              'width' => 1,
              'height' => '2'
            ],
            17 => [
              'id' => 'DashboardSet15__d995949',
              'name' => 'Report',
              'x' => 0,
              'y' => '7',
              'width' => 2,
              'height' => '2'
            ],
            18 => [
              'id' => 'DashboardSet15__d615645',
              'name' => 'Report',
              'x' => 2,
              'y' => '7',
              'width' => 2,
              'height' => '2'
            ]
          ],
          'id' => '5152227'
        ],
        1 => [
          'name' => 'SOLA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet15__d917969',
              'name' => 'Report',
              'x' => 0,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            1 => [
              'id' => 'DashboardSet15__d482080',
              'name' => 'Report',
              'x' => 1,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            2 => [
              'id' => 'DashboardSet15__d968539',
              'name' => 'Report',
              'x' => 2,
              'y' => '0',
              'width' => 2,
              'height' => '1'
            ],
            3 => [
              'id' => 'DashboardSet15__d595668',
              'name' => 'Report',
              'x' => 0,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            4 => [
              'id' => 'DashboardSet15__d399031',
              'name' => 'Report',
              'x' => 1,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            5 => [
              'id' => 'DashboardSet15__d296342',
              'name' => 'Report',
              'x' => 2,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            6 => [
              'id' => 'DashboardSet15__d945567',
              'name' => 'Report',
              'x' => 3,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            7 => [
              'id' => 'DashboardSet15__d310450',
              'name' => 'Report',
              'x' => 0,
              'y' => '2',
              'width' => 3,
              'height' => '2'
            ],
            8 => [
              'id' => 'DashboardSet15__d802816',
              'name' => 'Report',
              'x' => 3,
              'y' => '2',
              'width' => 1,
              'height' => '2'
            ],
            9 => [
              'id' => 'DashboardSet15__d661002',
              'name' => 'Report',
              'x' => 0,
              'y' => '4',
              'width' => 3,
              'height' => '2'
            ],
            10 => [
              'id' => 'DashboardSet15__d892543',
              'name' => 'Report',
              'x' => 3,
              'y' => '4',
              'width' => 1,
              'height' => '2'
            ],
            11 => [
              'id' => 'DashboardSet15__d630732',
              'name' => 'Report',
              'x' => 0,
              'y' => '6',
              'width' => 2,
              'height' => '2'
            ],
            12 => [
              'id' => 'DashboardSet15__d557297',
              'name' => 'Report',
              'x' => 2,
              'y' => '6',
              'width' => 2,
              'height' => '2'
            ]
          ],
          'id' => '1820250'
        ],
        2 => [
          'name' => 'NOLA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet15__d487422',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet15__d766440',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet15__d974316',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet15__d471625',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet15__d575051',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet15__d586221',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet15__d875389',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet15__d368232',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet15__d774535',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet15__d574213',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet15__d209469',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet15__d627525',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet15__d352356',
              'name' => 'Report',
              'x' => 2,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '1382877'
        ],
        3 => [
          'name' => 'CCA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet15__d160278',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet15__d743127',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet15__d771137',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet15__d566169',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet15__d528378',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet15__d363875',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet15__d854265',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet15__d387787',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet15__d64136',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet15__d691113',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet15__d518116',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet15__d719542',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet15__d460692',
              'name' => 'Report',
              'x' => 2,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '4950620'
        ],
        4 => [
          'name' => 'Brasil',
          'layout' => [
            0 => [
              'id' => 'DashboardSet15__d262135',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet15__d282587',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet15__d343819',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet15__d462673',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet15__d273107',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet15__d852791',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet15__d625585',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet15__d913949',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet15__d506927',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet15__d325506',
              'name' => 'Report',
              'x' => 2,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet15__d821142',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet15__d308077',
              'name' => 'Report',
              'x' => 2,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '8757484'
        ],
        5 => [
          'name' => 'Mexico',
          'layout' => [
            0 => [
              'id' => 'DashboardSet15__d168758',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet15__d539406',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet15__d601536',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet15__d543351',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet15__d996045',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet15__d944582',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet15__d637081',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet15__d805702',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet15__d163586',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet15__d815644',
              'name' => 'Report',
              'x' => 2,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet15__d986899',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet15__d596881',
              'name' => 'Report',
              'x' => 2,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '5571679'
        ],
        6 => [
          'name' => 'Partner Program X Opps',
          'layout' => [
            0 => [
              'id' => 'DashboardSet15__d871824',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '7226320'
        ]
      ]
    ],
    'DashboardSet16' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'AWS – Canales',
          'layout' => [
            0 => [
              'id' => 'DashboardSet16__d212215',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet16__d136119',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet16__d467471',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet16__d322754',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet16__d637722',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet16__d184968',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet16__d765870',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet16__d181494',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet16__d373248',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet16__d422019',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet16__d169757',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet16__d30732',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet16__d31895',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet16__d328354',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet16__d942506',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet16__d482881',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => [
              'id' => 'DashboardSet16__d758569',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet16__d182068',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet16__d72577',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet16__d163067',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet16__d709671',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet16__d567514',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '7696764'
        ],
        1 => [
          'name' => 'Partner Program x Opps',
          'layout' => [
            0 => [
              'id' => 'DashboardSet16__d321581',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 6
            ]
          ],
          'id' => '9679440'
        ]
      ]
    ],
    'DashboardSet28' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Oportunidades',
          'layout' => [
            0 => [
              'id' => 'DashboardSet28__d767476',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet28__d920219',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet28__d95779',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet28__d689950',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet28__d885007',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet28__d261850',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet28__d61923',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet28__d335596',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet28__d183545',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ]
          ],
          'id' => '2063684'
        ],
        1 => [
          'name' => 'Surestep x Opps',
          'layout' => [
            0 => [
              'id' => 'DashboardSet28__d348271',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '7404505'
        ]
      ]
    ],
    'DashboardSet33' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Opps LAC',
          'layout' => [
            0 => [
              'id' => 'DashboardSet33__d629804',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet33__d526240',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet33__d683869',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet33__d647437',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet33__d469632',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet33__d343697',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet33__d412085',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet33__d891781',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet33__d28874',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet33__d19878',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet33__d550027',
              'name' => 'Report',
              'x' => 1,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet33__d816010',
              'name' => 'Report',
              'x' => 2,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet33__d159456',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet33__d526300',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            14 => [
              'id' => 'DashboardSet33__d156097',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 2,
              'height' => 3
            ],
            15 => [
              'id' => 'DashboardSet33__d740741',
              'name' => 'Report',
              'x' => 2,
              'y' => 8,
              'width' => 2,
              'height' => 3
            ],
            16 => [
              'id' => 'DashboardSet33__d625559',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            17 => [
              'id' => 'DashboardSet33__d129675',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            18 => [
              'id' => 'DashboardSet33__d694276',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            19 => [
              'id' => 'DashboardSet33__d10632',
              'name' => 'Report',
              'x' => 2,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            20 => [
              'id' => 'DashboardSet33__d581688',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet33__d801458',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            22 => [
              'id' => 'DashboardSet33__d796503',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '4707271'
        ],
        1 => [
          'name' => 'Arg',
          'layout' => [
            0 => [
              'id' => 'DashboardSet33__d423396',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet33__d479155',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet33__d878076',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet33__d180575',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet33__d2604',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet33__d895558',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet33__d860370',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet33__d379186',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet33__d859520',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet33__d826472',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet33__d789014',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet33__d495550',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet33__d512454',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet33__d778329',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '6858189'
        ],
        2 => [
          'name' => 'Bol',
          'layout' => [
            0 => [
              'id' => 'DashboardSet33__d616467',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet33__d171583',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet33__d379603',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet33__d829530',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet33__d802211',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet33__d796138',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet33__d268027',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet33__d766491',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet33__d429605',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet33__d774217',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet33__d183747',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet33__d844224',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet33__d545051',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet33__d853472',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '4908674'
        ],
        3 => [
          'name' => 'Bra',
          'layout' => [
            0 => [
              'id' => 'DashboardSet33__d951918',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet33__d889850',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet33__d202635',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet33__d317728',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet33__d29031',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet33__d304980',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet33__d992768',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet33__d774597',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet33__d234460',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet33__d518108',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet33__d776535',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet33__d606526',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet33__d935494',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet33__d443790',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '3190606'
        ],
        4 => [
          'name' => 'CCA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet33__d358086',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet33__d252806',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet33__d352130',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet33__d507537',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet33__d304255',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet33__d51476',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet33__d753032',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet33__d383120',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet33__d628214',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet33__d705586',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet33__d331429',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet33__d377039',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet33__d108704',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet33__d275780',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '8229566'
        ],
        5 => [
          'name' => 'Chi',
          'layout' => [
            0 => [
              'id' => 'DashboardSet33__d13403',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet33__d771952',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet33__d36589',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet33__d247281',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet33__d649353',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet33__d956628',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet33__d998346',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet33__d116155',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet33__d31951',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet33__d667347',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet33__d841861',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet33__d362938',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet33__d174415',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet33__d888084',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '4295488'
        ],
        6 => [
          'name' => 'Col',
          'layout' => [
            0 => [
              'id' => 'DashboardSet33__d917187',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet33__d816238',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet33__d406322',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet33__d804561',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet33__d725049',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet33__d278154',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet33__d106753',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet33__d631420',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet33__d234717',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet33__d616862',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet33__d676829',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet33__d979209',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet33__d213406',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet33__d693098',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '2076232'
        ],
        7 => [
          'name' => 'Ecu',
          'layout' => [
            0 => [
              'id' => 'DashboardSet33__d254568',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet33__d230370',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet33__d940583',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet33__d783814',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet33__d507505',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet33__d873855',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet33__d507930',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet33__d455727',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet33__d898128',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet33__d231366',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet33__d443499',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet33__d83665',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet33__d386675',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet33__d743659',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '5568369'
        ],
        8 => [
          'name' => 'Uru',
          'layout' => [
            0 => [
              'id' => 'DashboardSet33__d806809',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet33__d901530',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet33__d923512',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet33__d780356',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet33__d584738',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet33__d446444',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet33__d114305',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet33__d554959',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet33__d2519',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet33__d656565',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet33__d165886',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet33__d955940',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet33__d731374',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet33__d406395',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 4
            ]
          ],
          'id' => '6294014'
        ],
        9 => [
          'name' => 'Par',
          'layout' => [
            0 => [
              'id' => 'DashboardSet33__d878128',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 4
            ],
            1 => [
              'id' => 'DashboardSet33__d714759',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            2 => [
              'id' => 'DashboardSet33__d912682',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet33__d959941',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            4 => [
              'id' => 'DashboardSet33__d909732',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet33__d987900',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet33__d999384',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet33__d518175',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet33__d436987',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet33__d821902',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet33__d807288',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet33__d554539',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet33__d831355',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet33__d591433',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ]
          ],
          'id' => '8804820'
        ],
        10 => [
          'name' => 'Opps LAC & Surestep',
          'layout' => [
            0 => [
              'id' => 'DashboardSet33__d349397',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '3852770'
        ]
      ]
    ],
    'DashboardSet34' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Surestep',
          'layout' => [
            0 => [
              'id' => 'DashboardSet34__d410610',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => [
              'id' => 'DashboardSet34__d774213',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => [
              'id' => 'DashboardSet34__d384224',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet34__d41068',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => [
              'id' => 'DashboardSet34__d273153',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet34__d45629',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet34__d892037',
              'name' => 'Report',
              'x' => 1,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet34__d468356',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet34__d34363',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 1,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet34__d530335',
              'name' => 'Report',
              'x' => 1,
              'y' => 8,
              'width' => 3,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet34__d644120',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ]
          ],
          'id' => '8856502'
        ],
        1 => [
          'name' => 'Arg',
          'layout' => [
            0 => [
              'id' => 'DashboardSet34__d252758',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => [
              'id' => 'DashboardSet34__d760480',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => [
              'id' => 'DashboardSet34__d318481',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet34__d511220',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => [
              'id' => 'DashboardSet34__d212462',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet34__d186584',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet34__d720120',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet34__d365108',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet34__d426064',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '1810792'
        ],
        2 => [
          'name' => 'Bol',
          'layout' => [
            0 => [
              'id' => 'DashboardSet34__d901660',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => [
              'id' => 'DashboardSet34__d861901',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => [
              'id' => 'DashboardSet34__d625989',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet34__d355808',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => [
              'id' => 'DashboardSet34__d585575',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet34__d306512',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet34__d42967',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet34__d918586',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet34__d855242',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '8519274'
        ],
        3 => [
          'name' => 'Bra',
          'layout' => [
            0 => [
              'id' => 'DashboardSet34__d812471',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => [
              'id' => 'DashboardSet34__d301665',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => [
              'id' => 'DashboardSet34__d450290',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet34__d341647',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => [
              'id' => 'DashboardSet34__d434542',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet34__d698954',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet34__d473819',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet34__d975044',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet34__d14781',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '6019153'
        ],
        4 => [
          'name' => 'CCA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet34__d200442',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => [
              'id' => 'DashboardSet34__d155528',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => [
              'id' => 'DashboardSet34__d536511',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet34__d405784',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => [
              'id' => 'DashboardSet34__d955152',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet34__d994024',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet34__d252263',
              'name' => 'Report',
              'x' => 1,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet34__d92104',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet34__d741587',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 1,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet34__d871706',
              'name' => 'Report',
              'x' => 1,
              'y' => 8,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '1960430'
        ],
        5 => [
          'name' => 'Chi',
          'layout' => [
            0 => [
              'id' => 'DashboardSet34__d295819',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => [
              'id' => 'DashboardSet34__d261655',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => [
              'id' => 'DashboardSet34__d886099',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet34__d863748',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => [
              'id' => 'DashboardSet34__d995203',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet34__d994428',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet34__d31050',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet34__d546417',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet34__d526505',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '8374551'
        ],
        6 => [
          'name' => 'Col',
          'layout' => [
            0 => [
              'id' => 'DashboardSet34__d730589',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => [
              'id' => 'DashboardSet34__d282730',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => [
              'id' => 'DashboardSet34__d460605',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet34__d87769',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => [
              'id' => 'DashboardSet34__d538177',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet34__d349823',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet34__d864232',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet34__d589644',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet34__d113843',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '9151116'
        ],
        7 => [
          'name' => 'Ecu',
          'layout' => [
            0 => [
              'id' => 'DashboardSet34__d357644',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => [
              'id' => 'DashboardSet34__d46613',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => [
              'id' => 'DashboardSet34__d686015',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet34__d527351',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => [
              'id' => 'DashboardSet34__d140150',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet34__d936286',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet34__d431512',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet34__d618043',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet34__d912452',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '3622865'
        ],
        8 => [
          'name' => 'Mex',
          'layout' => [
            0 => [
              'id' => 'DashboardSet34__d57175',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => [
              'id' => 'DashboardSet34__d866483',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => [
              'id' => 'DashboardSet34__d422017',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet34__d370298',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => [
              'id' => 'DashboardSet34__d623625',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet34__d591590',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet34__d424351',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet34__d694719',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet34__d28487',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '8678416'
        ]
      ]
    ],
    'DashboardSet35' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Surestep',
          'layout' => [
            0 => [
              'id' => 'DashboardSet35__d410610',
              'name' => 'Report',
              'x' => 0,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            1 => [
              'id' => 'DashboardSet35__d774213',
              'name' => 'Report',
              'x' => 1,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            2 => [
              'id' => 'DashboardSet35__d384224',
              'name' => 'Report',
              'x' => 2,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            3 => [
              'id' => 'DashboardSet35__d41068',
              'name' => 'Report',
              'x' => 3,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            4 => [
              'id' => 'DashboardSet35__d34363',
              'name' => 'Report',
              'x' => 0,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            5 => [
              'id' => 'DashboardSet35__d530335',
              'name' => 'Report',
              'x' => 1,
              'y' => '1',
              'width' => 3,
              'height' => '1'
            ],
            6 => [
              'id' => 'DashboardSet35__d644120',
              'name' => 'Report',
              'x' => 0,
              'y' => '2',
              'width' => 4,
              'height' => '2'
            ]
          ],
          'id' => '8856502'
        ]
      ]
    ],
    'DashboardSet36' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Arg',
          'layout' => [
            0 => [
              'id' => 'DashboardSet36__d833051',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '5355868'
        ]
      ]
    ],
    'DashboardSet37' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Rocket Brasil',
          'layout' => [
            0 => [
              'id' => 'DashboardSet37__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet38' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Rocket CCA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet38__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet39' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Rocket Chile',
          'layout' => [
            0 => [
              'id' => 'DashboardSet39__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet40' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Rocket Colombia',
          'layout' => [
            0 => [
              'id' => 'DashboardSet40__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet41' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Rocket Ecuador',
          'layout' => [
            0 => [
              'id' => 'DashboardSet41__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet42' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Rocket ',
          'layout' => [
            0 => [
              'id' => 'DashboardSet42__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ],
        1 => [
          'name' => 'Rocket Top 10 Resellers',
          'layout' => [
            0 => [
              'id' => 'DashboardSet42__d383500',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 9
            ]
          ],
          'id' => '1971746'
        ]
      ]
    ],
    'DashboardSet43' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Rocket Peru',
          'layout' => [
            0 => [
              'id' => 'DashboardSet43__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet44' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Dashboard - Cloud',
          'layout' => [
            0 => [
              'id' => 'DashboardSet44__d211532',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 3.75
            ]
          ],
          'id' => '1942151'
        ],
        1 => [
          'name' => 'Dashboard - Data IA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet44__d125535',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 4
            ]
          ],
          'id' => '4759029'
        ],
        2 => [
          'name' => 'Dashboard - CyberSecurity',
          'layout' => [
            0 => [
              'id' => 'DashboardSet44__d191450',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 4
            ]
          ],
          'id' => '121809'
        ]
      ]
    ],
    'DashboardSet47' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Oportunidades',
          'layout' => [
            0 => [
              'id' => 'DashboardSet47__d57190',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet47__d965489',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet47__d79262',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet47__d385605',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet47__d975738',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet47__d32063',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet47__d258643',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet47__d317494',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet47__d51703',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet47__d615645',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet47__d336598',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet47__d231313',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet47__d756242',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet47__d285244',
              'name' => 'Report',
              'x' => 2,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '5152227'
        ]
      ]
    ],
    'DashboardSet48' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'LAC',
          'layout' => [
            0 => [
              'id' => 'DashboardSet48__d57190',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet48__d965489',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet48__d79262',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet48__d385605',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet48__d975738',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet48__d32063',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet48__d258643',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet48__d317494',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet48__d51703',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet48__d615645',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet48__d336598',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet48__d231313',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet48__d756242',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet48__d285244',
              'name' => 'Report',
              'x' => 2,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '5152227'
        ],
        1 => [
          'name' => 'MCA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet48__d274234',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet48__d388961',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet48__d501079',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet48__d888540',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet48__d67287',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet48__d889914',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet48__d414549',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet48__d206979',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet48__d91521',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet48__d672283',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet48__d251826',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet48__d26260',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet48__d977578',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet48__d30377',
              'name' => 'Report',
              'x' => 2,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '518485'
        ],
        2 => [
          'name' => 'SOLA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet48__d917969',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet48__d482080',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet48__d745400',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet48__d595668',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet48__d399031',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet48__d310450',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet48__d802816',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet48__d661002',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet48__d892543',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet48__d998703',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet48__d630732',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet48__d159989',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet48__d109271',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet48__d557297',
              'name' => 'Report',
              'x' => 2,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '1820250'
        ],
        3 => [
          'name' => 'NOLA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet48__d487422',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet48__d766440',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet48__d974316',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 2
            ],
            3 => [
              'id' => 'DashboardSet48__d471625',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet48__d575051',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet48__d368232',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet48__d774535',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet48__d574213',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet48__d209469',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet48__d627525',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            10 => [
              'id' => 'DashboardSet48__d746898',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            11 => [
              'id' => 'DashboardSet48__d586221',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            12 => [
              'id' => 'DashboardSet48__d352356',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ],
            13 => [
              'id' => 'DashboardSet48__d875389',
              'name' => 'Report',
              'x' => 2,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '1382877'
        ],
        4 => [
          'name' => 'Partner Program X Opps',
          'layout' => [
            0 => [
              'id' => 'DashboardSet48__d854023',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '166980'
        ]
      ]
    ],
    'DashboardSet5' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'LAC',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d609168',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d212215',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d136119',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d467471',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d322754',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet5__d125778',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet5__d637722',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet5__d184968',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d765870',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d181494',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d373248',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d662372',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d477371',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d30732',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d31895',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d328354',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            16 => [
              'id' => 'DashboardSet5__d942506',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            17 => [
              'id' => 'DashboardSet5__d434684',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 1,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d626237',
              'name' => 'Report',
              'x' => 1,
              'y' => 8,
              'width' => 1,
              'height' => 1
            ],
            19 => [
              'id' => 'DashboardSet5__d31322',
              'name' => 'Report',
              'x' => 2,
              'y' => 8,
              'width' => 1,
              'height' => 1
            ],
            20 => [
              'id' => 'DashboardSet5__d987303',
              'name' => 'Report',
              'x' => 3,
              'y' => 8,
              'width' => 1,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet5__d785880',
              'name' => 'Report',
              'x' => 1,
              'y' => 9,
              'width' => 1,
              'height' => 1
            ],
            22 => [
              'id' => 'DashboardSet5__d816388',
              'name' => 'Report',
              'x' => 2,
              'y' => 9,
              'width' => 1,
              'height' => 1
            ],
            23 => [
              'id' => 'DashboardSet5__d19415',
              'name' => 'Report',
              'x' => 3,
              'y' => 9,
              'width' => 1,
              'height' => 1
            ],
            24 => [
              'id' => 'DashboardSet5__d747656',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 2,
              'height' => 2
            ],
            25 => [
              'id' => 'DashboardSet5__d627864',
              'name' => 'Report',
              'x' => 2,
              'y' => 10,
              'width' => 2,
              'height' => 2
            ],
            26 => [
              'id' => 'DashboardSet5__d322454',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            27 => [
              'id' => 'DashboardSet5__d230806',
              'name' => 'Report',
              'x' => 2,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            28 => [
              'id' => 'DashboardSet5__d482881',
              'name' => 'Report',
              'x' => 0,
              'y' => 14,
              'width' => 2,
              'height' => 2
            ],
            29 => [
              'id' => 'DashboardSet5__d648871',
              'name' => 'Report',
              'x' => 2,
              'y' => 14,
              'width' => 2,
              'height' => 2
            ],
            30 => [
              'id' => 'DashboardSet5__d72577',
              'name' => 'Report',
              'x' => 0,
              'y' => 16,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            31 => [
              'id' => 'DashboardSet5__d260622',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 16,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            32 => [
              'id' => 'DashboardSet5__d758569',
              'name' => 'Report',
              'x' => 0,
              'y' => 18,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            33 => [
              'id' => 'DashboardSet5__d930104',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 18,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            34 => [
              'id' => 'DashboardSet5__d295112',
              'name' => 'Report',
              'x' => 0,
              'y' => 20,
              'width' => 4,
              'height' => 1
            ]
          ],
          'id' => '7696764'
        ],
        1 => [
          'name' => 'MCA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d165463',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d976807',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d3339',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d642140',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d94116',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet5__d575664',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            6 => [
              'id' => 'DashboardSet5__d641576',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet5__d868442',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d909543',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d13973',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d517145',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d871098',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d552250',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d446964',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d651789',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d149835',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            16 => [
              'id' => 'DashboardSet5__d828716',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet5__d92384',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d605709',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet5__d530501',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet5__d974453',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            21 => [
              'id' => 'DashboardSet5__d167388',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '8798178'
        ],
        2 => [
          'name' => 'SOLA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d788396',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d194506',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d472866',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d781222',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d88428',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet5__d329914',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet5__d590840',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet5__d421031',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d318408',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d429511',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d396350',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d787437',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d247188',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d200847',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d891294',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d765274',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => [
              'id' => 'DashboardSet5__d201290',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet5__d388109',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d469617',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet5__d715433',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet5__d687945',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet5__d257502',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '9961055'
        ],
        3 => [
          'name' => 'NOLA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d49937',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d597323',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d800139',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d528640',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d323207',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet5__d137854',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet5__d253042',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet5__d747449',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d12112',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d720675',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d999254',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d709792',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d957873',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d79883',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d813104',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d264062',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => [
              'id' => 'DashboardSet5__d707794',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet5__d689210',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d758453',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet5__d41877',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet5__d395095',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet5__d813696',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '3334633'
        ],
        4 => [
          'name' => 'Arg',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d803076',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d226520',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d482943',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d413606',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d438215',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet5__d278742',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet5__d600448',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet5__d7450',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d657433',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d756989',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d679941',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d582257',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d924388',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d260445',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d321150',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d15820',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => [
              'id' => 'DashboardSet5__d946720',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet5__d825072',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d803722',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet5__d377497',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet5__d198705',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet5__d442158',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '7194714'
        ],
        5 => [
          'name' => 'Bra',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d459068',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d536441',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d317232',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d925332',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d999014',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet5__d88202',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet5__d247534',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet5__d147409',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d814384',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d676052',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d237346',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d149192',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d10299',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d114706',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d292199',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d567196',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => [
              'id' => 'DashboardSet5__d510364',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet5__d881532',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d736995',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet5__d3934',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet5__d99834',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet5__d758782',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '4050188'
        ],
        6 => [
          'name' => 'Chi',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d119053',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d981068',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d646618',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d667334',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d711127',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet5__d472777',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet5__d459264',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet5__d986172',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d841681',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d28311',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d895370',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d742947',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d654007',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d144181',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d237242',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d53053',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => [
              'id' => 'DashboardSet5__d885487',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet5__d795422',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d285381',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet5__d968274',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet5__d625748',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet5__d653913',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '5640935'
        ],
        7 => [
          'name' => 'Col',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d688992',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d540592',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d654029',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d654157',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d530972',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet5__d544112',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet5__d564162',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet5__d393646',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d298678',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d290226',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d590300',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d744657',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d589144',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d461513',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d892691',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d612953',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => [
              'id' => 'DashboardSet5__d679489',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet5__d754228',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d381905',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet5__d160226',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet5__d781990',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet5__d557713',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '3460549'
        ],
        8 => [
          'name' => 'Ecu',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d699136',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d244065',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d201916',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d407571',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d16517',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet5__d422513',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet5__d629862',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet5__d60946',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d943013',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d634012',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d360560',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d628395',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d464477',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d824340',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d898355',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d442641',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => [
              'id' => 'DashboardSet5__d665279',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet5__d935300',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d637905',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet5__d60903',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet5__d38690',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet5__d757980',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '6812945'
        ],
        9 => [
          'name' => 'Mex',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d719849',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d562183',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d908693',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d907124',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d798545',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet5__d676308',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet5__d137357',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet5__d81622',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d384718',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d612042',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d72674',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d573912',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d457304',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d245020',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d221100',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d101972',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => [
              'id' => 'DashboardSet5__d269239',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet5__d579366',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d365218',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet5__d794054',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet5__d637120',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet5__d227525',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '7910186'
        ],
        10 => [
          'name' => 'Par',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d98049',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d158528',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d812890',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d928955',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d631438',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet5__d42299',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet5__d800326',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet5__d298590',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d706757',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d289672',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d597629',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d802907',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d335691',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d38601',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d631667',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d540927',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => [
              'id' => 'DashboardSet5__d648101',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet5__d49746',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d316600',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet5__d517138',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet5__d331907',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet5__d63059',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '1660058'
        ],
        11 => [
          'name' => 'Per',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d139095',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d858324',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d56157',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d548474',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d245709',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet5__d939140',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet5__d624464',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet5__d303867',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d952888',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d198637',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d812805',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d51149',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d518337',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d13799',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d908686',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d999265',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => [
              'id' => 'DashboardSet5__d780933',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet5__d807294',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d284484',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet5__d399690',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet5__d843206',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet5__d352621',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '4329007'
        ],
        12 => [
          'name' => 'Uru',
          'layout' => [
            0 => [
              'id' => 'DashboardSet5__d636338',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet5__d801629',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet5__d544744',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet5__d80389',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet5__d205874',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => [
              'id' => 'DashboardSet5__d750636',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet5__d165693',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet5__d932439',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet5__d181952',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet5__d798808',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet5__d659403',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => [
              'id' => 'DashboardSet5__d740298',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => [
              'id' => 'DashboardSet5__d478800',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => [
              'id' => 'DashboardSet5__d236120',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => [
              'id' => 'DashboardSet5__d317138',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => [
              'id' => 'DashboardSet5__d90947',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => [
              'id' => 'DashboardSet5__d94246',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => [
              'id' => 'DashboardSet5__d244707',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => [
              'id' => 'DashboardSet5__d121958',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => [
              'id' => 'DashboardSet5__d881401',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => [
              'id' => 'DashboardSet5__d314451',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => [
              'id' => 'DashboardSet5__d561829',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '2801138'
        ]
      ]
    ],
    'DashboardSet50' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Rocket Uruguay',
          'layout' => [
            0 => [
              'id' => 'DashboardSet50__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet53' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Entrenamientos',
          'layout' => [
            0 => [
              'id' => 'DashboardSet53__d118760',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 4.75
            ]
          ],
          'id' => '447127'
        ]
      ]
    ],
    'DashboardSet56' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Facturación Canales',
          'layout' => [
            0 => [
              'id' => 'DashboardSet56__d229094',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 6
            ]
          ],
          'id' => '2357377'
        ]
      ]
    ],
    'DashboardSet57' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'DSET LIGHT - AWS PBI',
          'layout' => [
            0 => [
              'id' => 'DashboardSet57__d144337',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 6
            ]
          ],
          'id' => '8334466'
        ]
      ]
    ],
    'DashboardSet58' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Assessment',
          'layout' => [
            0 => [
              'id' => 'DashboardSet58__d938419',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 6
            ]
          ],
          'id' => '2547367'
        ]
      ]
    ],
    'DashboardSet6' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Arg',
          'layout' => [
            0 => [
              'id' => 'DashboardSet6__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ],
        1 => [
          'name' => 'Bra',
          'layout' => [
            0 => [
              'id' => 'DashboardSet6__d623311',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '318113'
        ],
        2 => [
          'name' => 'CCA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet6__d678621',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '755700'
        ],
        3 => [
          'name' => 'Chi',
          'layout' => [
            0 => [
              'id' => 'DashboardSet6__d683289',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '3385285'
        ],
        4 => [
          'name' => 'Col',
          'layout' => [
            0 => [
              'id' => 'DashboardSet6__d822744',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8370999'
        ],
        5 => [
          'name' => 'Ecu',
          'layout' => [
            0 => [
              'id' => 'DashboardSet6__d898239',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '4634755'
        ],
        6 => [
          'name' => 'Mex',
          'layout' => [
            0 => [
              'id' => 'DashboardSet6__d266440',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8308289'
        ],
        7 => [
          'name' => 'Per',
          'layout' => [
            0 => [
              'id' => 'DashboardSet6__d769194',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '9340700'
        ],
        8 => [
          'name' => 'Uru',
          'layout' => [
            0 => [
              'id' => 'DashboardSet6__d971406',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '4524500'
        ]
      ]
    ],
    'DashboardSet62' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Results- Data AI',
          'layout' => [
            0 => [
              'id' => 'DashboardSet62__d478231',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '3377228'
        ]
      ]
    ],
    'DashboardSet7' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Arg',
          'layout' => [
            0 => [
              'id' => 'DashboardSet7__d492078',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 7
            ]
          ],
          'id' => '1171085'
        ],
        1 => [
          'name' => 'Bra',
          'layout' => [
            0 => [
              'id' => 'DashboardSet7__d327882',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 13
            ]
          ],
          'id' => '8700226'
        ],
        2 => [
          'name' => 'CCA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet7__d611832',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 13
            ]
          ],
          'id' => '5990840'
        ],
        3 => [
          'name' => 'Col',
          'layout' => [
            0 => [
              'id' => 'DashboardSet7__d736822',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 13
            ]
          ],
          'id' => '2343338'
        ]
      ]
    ],
    'DashboardSet70' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Google - Assessment',
          'layout' => [
            0 => [
              'id' => 'DashboardSet70__d840076',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 7
            ]
          ],
          'id' => '9793729'
        ]
      ]
    ],
    'DashboardSet79' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'Oportunidades',
          'layout' => [
            0 => [
              'id' => 'DashboardSet79__d767476',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet79__d859647',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet79__d418357',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet79__d261850',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet79__d61923',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 1.3333333333333333,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet79__d689950',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet79__d920219',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => [
              'id' => 'DashboardSet79__d940919',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => [
              'id' => 'DashboardSet79__d811148',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            9 => [
              'id' => 'DashboardSet79__d95779',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 1.3333333333333333,
              'height' => 1
            ],
            10 => [
              'id' => 'DashboardSet79__d183545',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2,
              'height' => 1.75
            ],
            11 => [
              'id' => 'DashboardSet79__d545236',
              'name' => 'Report',
              'x' => 2,
              'y' => 2,
              'width' => 2,
              'height' => 1.75
            ],
            12 => [
              'id' => 'DashboardSet79__d438061',
              'name' => 'Report',
              'x' => 0,
              'y' => 3.75,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '2063684'
        ],
        1 => [
          'name' => 'Surestep x Opps',
          'layout' => [
            0 => [
              'id' => 'DashboardSet79__d348271',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '7404505'
        ]
      ]
    ],
    'DashboardSet80' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'CyberSecurity - Assessment',
          'layout' => [
            0 => [
              'id' => 'DashboardSet80__d464795',
              'name' => 'DowloadPbi',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1.5
            ],
            1 => [
              'id' => 'DashboardSet80__d685610',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 1.5,
              'width' => 4,
              'height' => 5.25
            ]
          ],
          'id' => '8902764'
        ]
      ]
    ],
    'DashboardSet9' => [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => [
          'name' => 'General',
          'layout' => [
            0 => [
              'id' => 'DashboardSet9__d837203',
              'name' => 'Report',
              'x' => 0,
              'y' => '0',
              'width' => 2,
              'height' => '1'
            ],
            1 => [
              'id' => 'DashboardSet9__d77904',
              'name' => 'Report',
              'x' => 2,
              'y' => '0',
              'width' => 2,
              'height' => '1'
            ],
            2 => [
              'id' => 'DashboardSet9__d386994',
              'name' => 'Report',
              'x' => 0,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            3 => [
              'id' => 'DashboardSet9__d845131',
              'name' => 'Report',
              'x' => 1,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            4 => [
              'id' => 'DashboardSet9__d464894',
              'name' => 'Report',
              'x' => 2,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            5 => [
              'id' => 'DashboardSet9__d630874',
              'name' => 'Report',
              'x' => 3,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            6 => [
              'id' => 'DashboardSet9__d638983',
              'name' => 'Report',
              'x' => 0,
              'y' => '2',
              'width' => 4,
              'height' => '3'
            ],
            7 => [
              'id' => 'DashboardSet9__d982171',
              'name' => 'Report',
              'x' => 0,
              'y' => '5',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            8 => [
              'id' => 'DashboardSet9__d361258',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => '5',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            9 => [
              'id' => 'DashboardSet9__d440211',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => '5',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            10 => [
              'id' => 'DashboardSet9__d116506',
              'name' => 'Report',
              'x' => 2,
              'y' => '5',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            11 => [
              'id' => 'DashboardSet9__d539142',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => '5',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            12 => [
              'id' => 'DashboardSet9__d780485',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => '5',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            13 => [
              'id' => 'DashboardSet9__d903216',
              'name' => 'Report',
              'x' => 0,
              'y' => '6',
              'width' => 2,
              'height' => '2'
            ],
            14 => [
              'id' => 'DashboardSet9__d776187',
              'name' => 'Report',
              'x' => 2,
              'y' => '6',
              'width' => 2,
              'height' => '2'
            ],
            15 => [
              'id' => 'DashboardSet9__d688697',
              'name' => 'Report',
              'x' => 0,
              'y' => '8',
              'width' => 0.6666666666666666,
              'height' => '3'
            ],
            16 => [
              'id' => 'DashboardSet9__d676188',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => '8',
              'width' => 3.3333333333333335,
              'height' => '3'
            ]
          ],
          'id' => '1283282'
        ],
        1 => [
          'name' => 'SOLA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet9__d409602',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet9__d103594',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet9__d305194',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet9__d203244',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet9__d333497',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet9__d662694',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet9__d710093',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 3
            ],
            7 => [
              'id' => 'DashboardSet9__d57178',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 2,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet9__d579646',
              'name' => 'Report',
              'x' => 2,
              'y' => 5,
              'width' => 2,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet9__d564208',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 3
            ],
            10 => [
              'id' => 'DashboardSet9__d741740',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 3
            ]
          ],
          'id' => '4136318'
        ],
        2 => [
          'name' => 'NOLA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet9__d698588',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet9__d509447',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet9__d659100',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet9__d17594',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet9__d815947',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet9__d349904',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet9__d781956',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 3
            ],
            7 => [
              'id' => 'DashboardSet9__d145200',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 2,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet9__d418075',
              'name' => 'Report',
              'x' => 2,
              'y' => 5,
              'width' => 2,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet9__d517985',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 3
            ],
            10 => [
              'id' => 'DashboardSet9__d14553',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 3
            ]
          ],
          'id' => '919504'
        ],
        3 => [
          'name' => 'CCA',
          'layout' => [
            0 => [
              'id' => 'DashboardSet9__d953803',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet9__d645812',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet9__d452221',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet9__d81072',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet9__d851463',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet9__d532501',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet9__d845920',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 3
            ],
            7 => [
              'id' => 'DashboardSet9__d174263',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 2,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet9__d829795',
              'name' => 'Report',
              'x' => 2,
              'y' => 5,
              'width' => 2,
              'height' => 2
            ],
            9 => [
              'id' => 'DashboardSet9__d178305',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 3
            ],
            10 => [
              'id' => 'DashboardSet9__d598262',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 3
            ]
          ],
          'id' => '3418533'
        ],
        4 => [
          'name' => 'Brasil',
          'layout' => [
            0 => [
              'id' => 'DashboardSet9__d742442',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet9__d532398',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet9__d56976',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet9__d795915',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet9__d44876',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet9__d85895',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet9__d158700',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet9__d447171',
              'name' => 'Report',
              'x' => 2,
              'y' => 2,
              'width' => 2,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet9__d288180',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 3
            ],
            9 => [
              'id' => 'DashboardSet9__d910575',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 3
            ]
          ],
          'id' => '1967340'
        ],
        5 => [
          'name' => 'Mexico',
          'layout' => [
            0 => [
              'id' => 'DashboardSet9__d62624',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            1 => [
              'id' => 'DashboardSet9__d36088',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            2 => [
              'id' => 'DashboardSet9__d957937',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => [
              'id' => 'DashboardSet9__d530976',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => [
              'id' => 'DashboardSet9__d419884',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => [
              'id' => 'DashboardSet9__d126290',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => [
              'id' => 'DashboardSet9__d86248',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2,
              'height' => 2
            ],
            7 => [
              'id' => 'DashboardSet9__d786191',
              'name' => 'Report',
              'x' => 2,
              'y' => 2,
              'width' => 2,
              'height' => 2
            ],
            8 => [
              'id' => 'DashboardSet9__d676869',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 3
            ],
            9 => [
              'id' => 'DashboardSet9__d599232',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 3
            ]
          ],
          'id' => '6860815'
        ]
      ]
    ],
    'DataAnalyticsReport' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'views' => [
        'list' => 'custom:views/DataAnalyticsReport/list'
      ]
    ],
    'Distributor' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'DsetAws' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'views' => [
        'list' => 'custom:views/DsetAws/list'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-cloud-download-alt'
    ],
    'Earn' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'EmailContent' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-mail-bulk',
      'color' => NULL,
      'dynamicLogic' => [
        'fields' => [
          'done' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Completed'
                ],
                1 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'country'
                ],
                2 => [
                  'type' => 'notEquals',
                  'attribute' => 'name',
                  'value' => 'Add Email Content'
                ],
                3 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'scheduled'
                ]
              ]
            ],
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'inPast',
                  'attribute' => 'scheduled'
                ],
                1 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'status',
                      'value' => 'Sent'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'status',
                      'value' => 'Canceled'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'sendExample' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'promoTitle'
                ],
                1 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'title'
                ]
              ]
            ]
          ],
          'name' => [
            'required' => NULL
          ],
          'content' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notEquals',
                  'attribute' => 'status',
                  'value' => 'Created'
                ]
              ]
            ]
          ],
          'scheduled' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Completed'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'status',
                      'value' => 'Sent'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'endDate' => [
            'required' => NULL
          ],
          'startDate' => [
            'required' => NULL
          ],
          'title' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notEquals',
                  'attribute' => 'status',
                  'value' => 'Created'
                ]
              ]
            ]
          ],
          'promoTitle' => [
            'required' => NULL
          ],
          'emailAddress' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'sendExample'
                ]
              ]
            ]
          ]
        ],
        'options' => [
          'status' => [
            0 => [
              'optionList' => [
                0 => 'Started',
                1 => 'Completed',
                2 => 'Canceled'
              ],
              'conditionGroup' => NULL
            ]
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'isReportPanel' => true,
            'name' => 'reportPanel6670a799e57beabf5',
            'label' => 'History',
            'view' => 'advanced:views/report-panel/record/panels/report-panel-bottom',
            'reportPanelId' => '6670a799e57beabf5',
            'reportType' => 'List',
            'reportEntityType' => 'Email',
            'displayType' => 'List',
            'displayTotal' => false,
            'displayOnlyTotal' => false,
            'useSiMultiplier' => true,
            'accessDataList' => [
              0 => [
                'scope' => 'Email'
              ]
            ],
            'order' => 0,
            'sticked' => true
          ]
        ]
      ],
      'kanbanViewMode' => false
    ],
    'ExternalFormPost' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'GooglePartnerAdvantage' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ],
          2 => [
            'name' => 'tasks',
            'label' => 'Tasks',
            'view' => 'crm:views/record/panels/tasks',
            'aclScope' => 'Task'
          ]
        ]
      ],
      'iconClass' => 'fas fa-cloud',
      'kanbanViewMode' => true,
      'color' => NULL,
      'dynamicLogic' => [
        'fields' => [
          'stage' => [
            'readOnly' => NULL
          ],
          'lostReason' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'stage',
                  'value' => 'Lost'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'stage',
                  'value' => 'Lost'
                ]
              ]
            ]
          ],
          'closeDate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'stage',
                  'value' => [
                    0 => 'Lost',
                    1 => 'Closed'
                  ]
                ],
                1 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'closeDate'
                ]
              ]
            ]
          ],
          'reason' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'stage',
                  'value' => 'Lost'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'lostReason',
                  'value' => 'Outro'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'stage',
                  'value' => 'Lost'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'lostReason',
                  'value' => 'Outro'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Importer' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-cube',
      'dynamicLogic' => [
        'fields' => [
          'outputFile' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'outputFileId',
                  'data' => [
                    'field' => 'outputFile'
                  ]
                ]
              ]
            ]
          ],
          'status' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notEquals',
                  'attribute' => 'status',
                  'value' => 'Created'
                ]
              ]
            ]
          ],
          'templateURL' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Oportunidades Brasil'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'LeadsPartnerCenter' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'color' => '#3f3bd1',
      'iconClass' => 'fas fa-user-friends'
    ],
    'Marketing' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-archive',
      'dynamicLogic' => [
        'fields' => [
          'endingDate' => [
            'invalid' => NULL
          ],
          'category' => [
            'visible' => NULL
          ],
          'profitReal' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ],
          'profit' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notHas',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'relationshipPanels' => [
        'contacts' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'Messenger' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-network-wired'
    ],
    'Migrations' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'recordViews' => [
        'detail' => 'views/templates/event/record/detail'
      ],
      'activityDefs' => [
        'activitiesCreate' => true,
        'historyCreate' => true
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => true,
            'order' => 3
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => true,
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'planned'
        ],
        1 => [
          'name' => 'held',
          'style' => 'success'
        ],
        2 => [
          'name' => 'todays'
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'duration' => [
            'readOnly' => NULL
          ],
          'cancellationReason' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'status',
                      'value' => 'Cancelled'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Cancelado'
                    ]
                  ]
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'status',
                      'value' => 'Cancelled'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Cancelado'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'completedIn' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Held'
                ]
              ]
            ]
          ],
          'dueDate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'dueDate'
                ]
              ]
            ]
          ],
          'lostReason' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'lostReason'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Cancelled'
                ]
              ]
            ]
          ],
          'checklistCSC' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Jira | SSCLOUD'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Consumo Estimado Concluído'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Cancelado'
                    ]
                  ]
                ],
                1 => [
                  'type' => 'has',
                  'attribute' => 'label',
                  'value' => 'AWS'
                ]
              ]
            ]
          ],
          'checklistConsumo' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Acompanhamento | Consumo'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Consumo Estimado Concluído'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Cancelado'
                    ],
                    3 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Acompanhamento | Consumo'
                    ],
                    4 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Consumo Estimado Concluído'
                    ],
                    5 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Cancelado'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'checklistMigration' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Fechado | Movimentação de Billing'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Sales | BDM'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Validação Pré-vendas | CoE'
                    ],
                    3 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Jira | SSCLOUD'
                    ],
                    4 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Consumo Estimado Concluído'
                    ],
                    5 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Cancelado'
                    ]
                  ]
                ],
                1 => [
                  'type' => 'has',
                  'attribute' => 'label',
                  'value' => 'AWS'
                ]
              ]
            ]
          ],
          'checklistPreSales' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Validação Pré-vendas | CoE'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Jira | SSCLOUD'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Cancelado'
                    ],
                    3 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Consumo Estimado Concluído'
                    ]
                  ]
                ],
                1 => [
                  'type' => 'has',
                  'attribute' => 'label',
                  'value' => 'AWS'
                ]
              ]
            ]
          ],
          'jiraCSC' => [
            'visible' => NULL
          ],
          'partialAmount' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Acompanhamento | Consumo'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucket',
                      'value' => 'Consumo Estimado Concluído'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'bucket' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'label',
                  'value' => 'AWS'
                ]
              ]
            ]
          ],
          'bucketMicrosoft' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'label',
                  'value' => 'Microsoft'
                ]
              ]
            ]
          ],
          'checklistMicrosoft1' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Upside | Pipeline'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Pré-migração'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Execução T1/DIST (Time SSCLOUD JIRA)'
                    ],
                    3 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Execução MOSP/EA (Time Serviços)'
                    ],
                    4 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Acompanhamento | Consumo'
                    ],
                    5 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Consumo Estimado Concluído'
                    ],
                    6 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Cancelado'
                    ]
                  ]
                ],
                1 => [
                  'type' => 'has',
                  'attribute' => 'label',
                  'value' => 'Microsoft'
                ]
              ]
            ]
          ],
          'checklistMicrosoft2' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Pré-migração'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Execução T1/DIST (Time SSCLOUD JIRA)'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Execução MOSP/EA (Time Serviços)'
                    ],
                    3 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Acompanhamento | Consumo'
                    ],
                    4 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Consumo Estimado Concluído'
                    ],
                    5 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Cancelado'
                    ]
                  ]
                ],
                1 => [
                  'type' => 'has',
                  'attribute' => 'label',
                  'value' => 'Microsoft'
                ]
              ]
            ]
          ],
          'checklistMicrosoft3' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Execução T1/DIST (Time SSCLOUD JIRA)'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Acompanhamento | Consumo'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Consumo Estimado Concluído'
                    ],
                    3 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Cancelado'
                    ]
                  ]
                ],
                1 => [
                  'type' => 'has',
                  'attribute' => 'label',
                  'value' => 'Microsoft'
                ],
                2 => [
                  'type' => 'equals',
                  'attribute' => 'migrationOrigin',
                  'value' => 'T1/DIST'
                ]
              ]
            ]
          ],
          'checklistMicrosoft4' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Execução MOSP/EA (Time Serviços)'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Acompanhamento | Consumo'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Consumo Estimado Concluído'
                    ],
                    3 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Cancelado'
                    ]
                  ]
                ],
                1 => [
                  'type' => 'has',
                  'attribute' => 'label',
                  'value' => 'Microsoft'
                ],
                2 => [
                  'type' => 'equals',
                  'attribute' => 'migrationOrigin',
                  'value' => 'MOSP/EA'
                ]
              ]
            ]
          ],
          'checklistMicrosoft5' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Pré-migração'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Execução MOSP/EA (Time Serviços)'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Acompanhamento | Consumo'
                    ],
                    3 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Consumo Estimado Concluído'
                    ],
                    4 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Cancelado'
                    ]
                  ]
                ],
                1 => [
                  'type' => 'has',
                  'attribute' => 'label',
                  'value' => 'Microsoft'
                ],
                2 => [
                  'type' => 'equals',
                  'attribute' => 'migrationOrigin',
                  'value' => 'MOSP/EA'
                ]
              ]
            ]
          ],
          'checklistMicrosoft' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Upside | Pipeline'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Pré-migração'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Execução MOSP/EA (Time Serviços)'
                    ],
                    3 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Acompanhamento | Consumo'
                    ],
                    4 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Consumo Estimado Concluído'
                    ],
                    5 => [
                      'type' => 'equals',
                      'attribute' => 'bucketMicrosoft',
                      'value' => 'Cancelado'
                    ]
                  ]
                ],
                1 => [
                  'type' => 'has',
                  'attribute' => 'label',
                  'value' => 'Microsoft'
                ],
                2 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'migrationOrigin',
                      'value' => NULL
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'migrationOrigin',
                      'value' => 'MOSP/EA'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-columns',
      'color' => NULL,
      'sidePanels' => [
        'detail' => [
          0 => [
            'isReportPanel' => true,
            'name' => 'reportPanel67326a31a79ec416a',
            'label' => 'Duração do Bucket (Dias)',
            'view' => 'advanced:views/report-panel/record/panels/report-panel-side',
            'reportPanelId' => '67326a31a79ec416a',
            'reportType' => 'List',
            'reportEntityType' => 'BucketTimer',
            'displayType' => 'List',
            'displayTotal' => false,
            'displayOnlyTotal' => false,
            'useSiMultiplier' => true,
            'accessDataList' => [
              0 => [
                'scope' => 'BucketTimer'
              ]
            ]
          ]
        ]
      ],
      'kanbanViewMode' => true,
      'forcePatchAttributeDependencyMap' => [
        'dateEnd' => [
          0 => 'dateStart'
        ],
        'dateEndDate' => [
          0 => 'dateStartDate'
        ]
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'crm:handlers/event/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/event/reminders-handler'
        ]
      ],
      'relationshipPanels' => [
        'bdmCloud' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'accountManager' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'processOwner' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'eblaKanbanMultipleFields' => [
        0 => 'bucket',
        1 => 'bucketMicrosoft'
      ],
      'eblaKanbanMultipleIgnoreOptions' => [
        'bucketMicrosoft' => [
          0 => 'Consumo Estimado Concluído',
          1 => ''
        ],
        'bucket' => [
          0 => 'Consumo Estimado Concluído',
          1 => ''
        ]
      ]
    ],
    'Notifications' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'far fa-sticky-note'
    ],
    'NurturingForm' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-poll'
    ],
    'OpportunityAWS' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'OpportunityGoogle' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'relationshipPanels' => [
        'opportunity' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'Orders' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'PBGeral' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-clipboard-list',
      'dynamicLogic' => [
        'options' => [
          'cloudCategory' => [
            0 => [
              'optionList' => [
                0 => 'Starter',
                1 => 'Transformer',
                2 => 'Accelerator'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'module',
                  'value' => 'Cloud Practice Builder'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => 'AWS Startups',
                1 => 'AWS Onboard the Practice'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'module',
                  'value' => 'AWS'
                ]
              ]
            ],
            2 => [
              'optionList' => [
                0 => 'MCPP Transition Path'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'module',
                  'value' => 'Microsoft'
                ]
              ]
            ],
            3 => [
              'optionList' => [
                0 => 'Google Workspace',
                1 => 'Google Cloud Practice Startups'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'module',
                  'value' => 'Google'
                ]
              ]
            ],
            4 => [
              'optionList' => [
                0 => 'Grow Your HPE GreenLake Practice'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'module',
                  'value' => 'HPE Greenlake'
                ]
              ]
            ],
            5 => [
              'optionList' => [
                0 => 'Develop Your Security Practice',
                1 => 'Grow Your Security Sales'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'module',
                  'value' => 'Security'
                ]
              ]
            ]
          ]
        ],
        'fields' => [
          'cloudCategory' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'module'
                ]
              ]
            ],
            'required' => NULL
          ]
        ]
      ]
    ],
    'PartnerID' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL
    ],
    'PartnersGoogleCloud' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ],
          2 => [
            'name' => 'tasks',
            'label' => 'Tasks',
            'view' => 'crm:views/record/panels/tasks',
            'aclScope' => 'Task'
          ]
        ]
      ],
      'color' => '#ea4335',
      'iconClass' => 'fas fa-project-diagram',
      'kanbanViewMode' => true
    ],
    'PatchNotes' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'far fa-sticky-note',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'Portfolio' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-archive',
      'recordViews' => [
        'detail' => 'custom:views/Portfolio/detail'
      ],
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'Program' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-desktop'
    ],
    'Renewals' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-file-invoice-dollar',
      'relationshipPanels' => [
        'accountRenewals' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'RocketMargins' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ],
          2 => [
            'name' => 'tasks',
            'label' => 'Tasks',
            'view' => 'crm:views/record/panels/tasks',
            'aclScope' => 'Task'
          ]
        ]
      ],
      'iconClass' => 'fas fa-rocket'
    ],
    'Sources' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'Surestep' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ],
          2 => [
            'name' => 'tasks',
            'label' => 'Tasks',
            'view' => 'crm:views/record/panels/tasks',
            'aclScope' => 'Task'
          ]
        ]
      ],
      'iconClass' => 'fas fa-clipboard-list',
      'dynamicLogic' => [
        'fields' => [
          'readyToActivate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'newPartner',
                  'value' => 'Contact Form Completed'
                ],
                1 => [
                  'type' => 'has',
                  'attribute' => 'newPartner',
                  'value' => '1:1 Meeting with Surestep Ambassador'
                ],
                2 => [
                  'type' => 'has',
                  'attribute' => 'newPartner',
                  'value' => 'Skill Mapping (Assessment)'
                ]
              ]
            ],
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'readyToActivate'
                ]
              ]
            ]
          ],
          'readyToInspire' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'has',
                      'attribute' => 'activateToInspire',
                      'value' => 'TD / SYNNEX Account Number'
                    ],
                    1 => [
                      'type' => 'has',
                      'attribute' => 'activateToInspire',
                      'value' => 'MPN ID'
                    ],
                    2 => [
                      'type' => 'has',
                      'attribute' => 'activateToInspire',
                      'value' => 'Partner Center Complete Training'
                    ],
                    3 => [
                      'type' => 'has',
                      'attribute' => 'activateToInspire',
                      'value' => 'One Consumption (Last 3 Months)'
                    ],
                    4 => [
                      'type' => 'has',
                      'attribute' => 'activateToInspire',
                      'value' => 'One Fundamental Certification'
                    ],
                    5 => [
                      'type' => 'has',
                      'attribute' => 'activateToInspire',
                      'value' => '1Q Business Plan Approval and Execution'
                    ]
                  ]
                ],
                1 => [
                  'type' => 'isTrue',
                  'attribute' => 'readyToActivate'
                ],
                2 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Brasil (Microsoft)',
                      'linkId' => '63fe2e975c350b246'
                    ]
                  ],
                  'value' => '63fe2e975c350b246'
                ]
              ]
            ],
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'readyToInspire'
                ]
              ]
            ]
          ],
          'readyToSkyrocketNominee' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'has',
                      'attribute' => 'inspireToSkyrocketNominee',
                      'value' => 'Action Pack Acquisition'
                    ],
                    1 => [
                      'type' => 'has',
                      'attribute' => 'inspireToSkyrocketNominee',
                      'value' => 'Silver or Gold Competency'
                    ],
                    2 => [
                      'type' => 'has',
                      'attribute' => 'inspireToSkyrocketNominee',
                      'value' => 'Recurrent Consumption (Last Quarter)'
                    ],
                    3 => [
                      'type' => 'has',
                      'attribute' => 'inspireToSkyrocketNominee',
                      'value' => '1H Business Plan Approval and Execution'
                    ]
                  ]
                ],
                1 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'readyToActivate'
                    ],
                    1 => [
                      'type' => 'isTrue',
                      'attribute' => 'readyToInspire'
                    ]
                  ]
                ]
              ]
            ],
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'readyToSkyrocketNominee'
                ]
              ]
            ]
          ],
          'readyToSkyrocket' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'inspireToSkyrocketNominee',
                  'value' => 'Action Pack Acquisition'
                ],
                1 => [
                  'type' => 'has',
                  'attribute' => 'inspireToSkyrocketNominee',
                  'value' => 'Silver or Gold Competency'
                ],
                2 => [
                  'type' => 'has',
                  'attribute' => 'inspireToSkyrocketNominee',
                  'value' => 'Recurrent Consumption (Last Quarter)'
                ],
                3 => [
                  'type' => 'has',
                  'attribute' => 'inspireToSkyrocketNominee',
                  'value' => '1H Business Plan Approval and Execution'
                ],
                4 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'readyToActivate'
                    ],
                    1 => [
                      'type' => 'isTrue',
                      'attribute' => 'readyToInspire'
                    ],
                    2 => [
                      'type' => 'isTrue',
                      'attribute' => 'readyToSkyrocketNominee'
                    ]
                  ]
                ]
              ]
            ],
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'readyToSkyrocket'
                ]
              ]
            ]
          ],
          'newPartner' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'readyToActivate'
                ]
              ]
            ]
          ],
          'activateToInspire' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'readyToInspire'
                ]
              ]
            ]
          ],
          'inspireToSkyrocketNominee' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'readyToSkyrocketNominee'
                ]
              ]
            ]
          ],
          'skyrocketNomineeToSkyrocket' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'readyToSkyrocket'
                ]
              ]
            ]
          ],
          'surestepLevel' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'surestepLevel',
                  'value' => [
                    0 => 'Activate',
                    1 => 'Inspire',
                    2 => 'SKR',
                    3 => 'TopSKR',
                    4 => 'In Process'
                  ]
                ]
              ]
            ]
          ],
          'mpnNumber' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'activateToInspire',
                  'value' => 'MPN ID'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'activateToInspire',
                  'value' => 'MPN ID'
                ]
              ]
            ]
          ],
          'accountNumber' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'activateToInspire',
                  'value' => 'TD / SYNNEX Account Number'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'activateToInspire',
                  'value' => 'TD / SYNNEX Account Number'
                ]
              ]
            ]
          ],
          'description' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'description'
                ]
              ]
            ]
          ],
          'consumptionDate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'activateToInspire',
                  'value' => 'One Consumption (Last 3 Months)'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'activateToInspire',
                  'value' => 'One Consumption (Last 3 Months)'
                ]
              ]
            ]
          ]
        ],
        'options' => [
          'activateToInspire' => [
            0 => [
              'optionList' => [
                0 => 'TD / SYNNEX Account Number',
                1 => 'MPN ID',
                2 => 'Partner Center Complete Training',
                3 => 'One Consumption (Last 3 Months)'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Brasil (Microsoft)',
                      'linkId' => '63fe2e975c350b246'
                    ]
                  ],
                  'value' => '63fe2e975c350b246'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => 'TD / SYNNEX Account Number',
                1 => 'MPN ID',
                2 => 'Partner Center Complete Training',
                3 => 'One Consumption (Last 3 Months)',
                4 => 'One Fundamental Certification',
                5 => '1Q Business Plan Approval and Execution'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Brasil (Microsoft)',
                      'linkId' => '63fe2e975c350b246'
                    ]
                  ],
                  'value' => '63fe2e975c350b246'
                ]
              ]
            ]
          ],
          'surestepLevel' => [
            0 => [
              'optionList' => [
                0 => '',
                1 => 'New Partner',
                2 => 'In Process',
                3 => 'Activate'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Brasil (Geral)',
                      'linkId' => '6217badb36ba2650e'
                    ]
                  ],
                  'value' => '6217badb36ba2650e'
                ],
                1 => [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => [
                    'field' => 'teams',
                    'values' => [
                      'linkName' => 'Brasil (Microsoft)',
                      'linkId' => '63fe2e975c350b246'
                    ]
                  ],
                  'value' => '63fe2e975c350b246'
                ]
              ]
            ]
          ]
        ]
      ],
      'kanbanViewMode' => true,
      'color' => '#00207a'
    ],
    'TechnicalSupport' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'TourContent' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-info-circle'
    ],
    'VendorAccount' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'VendorCloudConsumption' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL,
      'dynamicLogic' => [
        'fields' => [
          'salesOrder' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'category',
                      'value' => 'AZURE'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'category',
                      'value' => 'LICENSE'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'VendorContract' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'VendorSubscription' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL
    ]
  ],
  'dashlets' => [
    'Emails' => [
      'view' => 'views/dashlets/emails',
      'aclScope' => 'Email',
      'entityType' => 'Email',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'folder' => [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/emails/folder'
          ]
        ],
        'defaults' => [
          'orderBy' => 'dateSent',
          'order' => 'desc',
          'displayRecords' => 5,
          'folder' => NULL,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'subject',
                  'link' => true
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateSent',
                  'view' => 'views/fields/datetime-short'
                ],
                1 => [
                  'name' => 'personStringData',
                  'view' => 'views/email/fields/person-string-data-for-expanded'
                ]
              ]
            ]
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'folder'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Iframe' => [
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar'
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'url' => [
            'type' => 'url',
            'required' => true
          ]
        ],
        'defaults' => [
          'autorefreshInterval' => 0
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'url'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Memo' => [
      'view' => 'views/dashlets/memo',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar'
          ],
          'text' => [
            'type' => 'text'
          ]
        ],
        'defaults' => [],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'text'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Records' => [
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 40
          ],
          'entityType' => [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/records/entity-type',
            'translation' => 'Global.scopeNames'
          ],
          'primaryFilter' => [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/records/primary-filter'
          ],
          'boolFilterList' => [
            'type' => 'multiEnum',
            'view' => 'views/dashlets/fields/records/bool-filter-list'
          ],
          'sortBy' => [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/records/sort-by'
          ],
          'sortDirection' => [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/records/sort-direction',
            'options' => [
              0 => 'asc',
              1 => 'desc'
            ],
            'translation' => 'DashletOptions.options.sortDirection'
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'displayRecords' => 10,
          'autorefreshInterval' => 0.5,
          'expandedLayout' => [
            'rows' => []
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'entityType'
                ],
                1 => false
              ],
              2 => [
                0 => [
                  'name' => 'primaryFilter'
                ],
                1 => [
                  'name' => 'sortBy'
                ]
              ],
              3 => [
                0 => [
                  'name' => 'boolFilterList'
                ],
                1 => [
                  'name' => 'sortDirection'
                ]
              ],
              4 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              5 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Stream' => [
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'skipOwn' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'defaults' => [
          'displayRecords' => 10,
          'autorefreshInterval' => 0.5,
          'skipOwn' => false
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'skipOwn'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Activities' => [
      'view' => 'crm:views/dashlets/activities',
      'options' => [
        'view' => 'crm:views/dashlets/options/activities',
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'enabledScopeList' => [
            'type' => 'multiEnum',
            'translation' => 'Global.scopeNamesPlural',
            'required' => true
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'futureDays' => [
            'type' => 'int',
            'min' => 0,
            'required' => true
          ],
          'includeShared' => [
            'type' => 'bool'
          ]
        ],
        'defaults' => [
          'displayRecords' => 10,
          'autorefreshInterval' => 0.5,
          'futureDays' => 3,
          'enabledScopeList' => [
            0 => 'Meeting',
            1 => 'Call',
            2 => 'Task'
          ],
          'includeShared' => false
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'enabledScopeList'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'futureDays'
                ],
                1 => [
                  'name' => 'includeShared'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Calendar' => [
      'view' => 'crm:views/dashlets/calendar',
      'aclScope' => 'Calendar',
      'options' => [
        'view' => 'crm:views/dashlets/options/calendar',
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'enabledScopeList' => [
            'type' => 'multiEnum',
            'translation' => 'Global.scopeNamesPlural',
            'required' => true
          ],
          'mode' => [
            'type' => 'enum',
            'options' => [
              0 => 'basicWeek',
              1 => 'agendaWeek',
              2 => 'timeline',
              3 => 'month',
              4 => 'basicDay',
              5 => 'agendaDay'
            ]
          ],
          'users' => [
            'type' => 'linkMultiple',
            'entity' => 'User',
            'view' => 'crm:views/calendar/fields/users',
            'sortable' => true
          ],
          'teams' => [
            'type' => 'linkMultiple',
            'entity' => 'Team',
            'view' => 'crm:views/calendar/fields/teams'
          ]
        ],
        'defaults' => [
          'autorefreshInterval' => 0.5,
          'mode' => 'basicWeek',
          'enabledScopeList' => [
            0 => 'Meeting',
            1 => 'Call',
            2 => 'Task'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'mode'
                ],
                1 => [
                  'name' => 'enabledScopeList'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'users'
                ],
                1 => false
              ],
              3 => [
                0 => [
                  'name' => 'teams'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Calls' => [
      'view' => 'crm:views/dashlets/calls',
      'aclScope' => 'Call',
      'entityType' => 'Call',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'dateStart',
          'order' => 'asc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateStart'
                ],
                1 => [
                  'name' => 'parent'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'planned',
            'advanced' => [
              1 => [
                'type' => 'or',
                'value' => [
                  1 => [
                    'type' => 'today',
                    'field' => 'dateStart',
                    'dateTime' => true
                  ],
                  2 => [
                    'type' => 'future',
                    'field' => 'dateEnd',
                    'dateTime' => true
                  ],
                  3 => [
                    'type' => 'lastXDays',
                    'field' => 'dateStart',
                    'value' => 5,
                    'dateTime' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Cases' => [
      'view' => 'views/dashlets/abstract/record-list',
      'aclScope' => 'Case',
      'entityType' => 'Case',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'number',
          'order' => 'desc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'number'
                ],
                1 => [
                  'name' => 'name',
                  'link' => true
                ],
                2 => [
                  'name' => 'type'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'status'
                ],
                1 => [
                  'name' => 'priority'
                ],
                2 => [
                  'name' => 'account'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'open'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Leads' => [
      'view' => 'views/dashlets/abstract/record-list',
      'aclScope' => 'Lead',
      'entityType' => 'Lead',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'createdAt',
          'order' => 'desc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ],
                1 => [
                  'name' => 'addressCity'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'status'
                ],
                1 => [
                  'name' => 'source'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'actual'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Meetings' => [
      'view' => 'crm:views/dashlets/meetings',
      'aclScope' => 'Meeting',
      'entityType' => 'Meeting',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'dateStart',
          'order' => 'asc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateStart'
                ],
                1 => [
                  'name' => 'parent'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'planned',
            'advanced' => [
              1 => [
                'type' => 'or',
                'value' => [
                  1 => [
                    'type' => 'today',
                    'field' => 'dateStart',
                    'dateTime' => true
                  ],
                  2 => [
                    'type' => 'future',
                    'field' => 'dateEnd',
                    'dateTime' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Opportunities' => [
      'view' => 'views/dashlets/abstract/record-list',
      'aclScope' => 'Opportunity',
      'entityType' => 'Opportunity',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'closeDate',
          'order' => 'asc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => [
                  'name' => 'stage'
                ],
                1 => [
                  'name' => 'amount'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'open'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'OpportunitiesByLeadSource' => [
      'view' => 'crm:views/dashlets/opportunities-by-lead-source',
      'aclScope' => 'Opportunity',
      'options' => [
        'view' => 'crm:views/dashlets/options/chart',
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'dateFrom' => [
            'type' => 'date',
            'required' => true
          ],
          'dateTo' => [
            'type' => 'date',
            'required' => true
          ],
          'dateFilter' => [
            'type' => 'enum',
            'options' => [
              0 => 'currentYear',
              1 => 'currentQuarter',
              2 => 'currentMonth',
              3 => 'currentFiscalYear',
              4 => 'currentFiscalQuarter',
              5 => 'ever',
              6 => 'between'
            ],
            'default' => 'currentYear',
            'translation' => 'Global.options.dateSearchRanges'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateFilter'
                ],
                1 => false
              ],
              2 => [
                0 => [
                  'name' => 'dateFrom'
                ],
                1 => [
                  'name' => 'dateTo'
                ]
              ]
            ]
          ]
        ],
        'defaults' => [
          'dateFilter' => 'currentYear'
        ]
      ]
    ],
    'OpportunitiesByStage' => [
      'view' => 'crm:views/dashlets/opportunities-by-stage',
      'aclScope' => 'Opportunity',
      'options' => [
        'view' => 'crm:views/dashlets/options/chart',
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'dateFrom' => [
            'type' => 'date',
            'required' => true
          ],
          'dateTo' => [
            'type' => 'date',
            'required' => true
          ],
          'dateFilter' => [
            'type' => 'enum',
            'options' => [
              0 => 'currentYear',
              1 => 'currentQuarter',
              2 => 'currentMonth',
              3 => 'currentFiscalYear',
              4 => 'currentFiscalQuarter',
              5 => 'ever',
              6 => 'between'
            ],
            'default' => 'currentYear',
            'translation' => 'Global.options.dateSearchRanges'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateFilter'
                ],
                1 => false
              ],
              2 => [
                0 => [
                  'name' => 'dateFrom'
                ],
                1 => [
                  'name' => 'dateTo'
                ]
              ]
            ]
          ]
        ],
        'defaults' => [
          'dateFilter' => 'currentYear'
        ]
      ]
    ],
    'SalesByMonth' => [
      'view' => 'crm:views/dashlets/sales-by-month',
      'aclScope' => 'Opportunity',
      'options' => [
        'view' => 'crm:views/dashlets/options/chart',
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'dateFrom' => [
            'type' => 'date',
            'required' => true
          ],
          'dateTo' => [
            'type' => 'date',
            'required' => true
          ],
          'dateFilter' => [
            'type' => 'enum',
            'options' => [
              0 => 'currentYear',
              1 => 'currentQuarter',
              2 => 'currentFiscalYear',
              3 => 'currentFiscalQuarter',
              4 => 'between'
            ],
            'default' => 'currentYear',
            'translation' => 'Global.options.dateSearchRanges'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateFilter'
                ],
                1 => false
              ],
              2 => [
                0 => [
                  'name' => 'dateFrom'
                ],
                1 => [
                  'name' => 'dateTo'
                ]
              ]
            ]
          ]
        ],
        'defaults' => [
          'dateFilter' => 'currentYear'
        ]
      ]
    ],
    'SalesPipeline' => [
      'view' => 'crm:views/dashlets/sales-pipeline',
      'aclScope' => 'Opportunity',
      'options' => [
        'view' => 'crm:views/dashlets/options/sales-pipeline',
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'dateFrom' => [
            'type' => 'date',
            'required' => true
          ],
          'dateTo' => [
            'type' => 'date',
            'required' => true
          ],
          'dateFilter' => [
            'type' => 'enum',
            'options' => [
              0 => 'currentYear',
              1 => 'currentQuarter',
              2 => 'currentMonth',
              3 => 'currentFiscalYear',
              4 => 'currentFiscalQuarter',
              5 => 'ever',
              6 => 'between'
            ],
            'default' => 'currentYear',
            'translation' => 'Global.options.dateSearchRanges'
          ],
          'useLastStage' => [
            'type' => 'bool'
          ],
          'team' => [
            'type' => 'link',
            'entity' => 'Team',
            'view' => 'crm:views/dashlets/options/sales-pipeline/fields/team'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title',
                  'span' => 2
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateFilter'
                ],
                1 => [
                  'name' => 'useLastStage'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'dateFrom'
                ],
                1 => [
                  'name' => 'dateTo'
                ]
              ],
              3 => [
                0 => [
                  'name' => 'team'
                ],
                1 => false
              ]
            ]
          ]
        ],
        'defaults' => [
          'dateFilter' => 'currentYear',
          'teamId' => NULL,
          'teamName' => NULL
        ]
      ]
    ],
    'Tasks' => [
      'view' => 'crm:views/dashlets/tasks',
      'aclScope' => 'Task',
      'entityType' => 'Task',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'dateUpcoming',
          'order' => 'asc',
          'displayRecords' => 5,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => [
                  'name' => 'status'
                ],
                1 => [
                  'name' => 'dateEnd'
                ],
                2 => [
                  'name' => 'parent'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'actualStartingNotInFuture'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout',
                  'fullWidth' => true
                ]
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'BpmnUserTasks' => [
      'view' => 'advanced:views/dashlets/bpmn-user-tasks',
      'aclScope' => 'BpmnUserTask',
      'entityType' => 'BpmnUserTask',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'enumInt',
            'options' => [
              0 => 3,
              1 => 4,
              2 => 5,
              3 => 10,
              4 => 15,
              5 => 20,
              6 => 30
            ]
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'createdAt',
          'order' => 'desc',
          'displayRecords' => 5,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'actual'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Report' => [
      'view' => 'advanced:views/dashlets/report',
      'aclScope' => 'Report',
      'options' => [
        'view' => 'advanced:views/dashlets/options/report',
        'fields' => [
          'title' => [
            'type' => 'varchar'
          ],
          'report' => [
            'type' => 'link',
            'entity' => 'Report',
            'required' => true,
            'view' => 'advanced:views/report/fields/dashlet-select'
          ],
          'column' => [
            'type' => 'enum',
            'options' => []
          ],
          'displayType' => [
            'type' => 'enum',
            'default' => '',
            'options' => [
              0 => '',
              1 => 'Chart',
              2 => 'List',
              3 => 'Chart-Total',
              4 => 'Total',
              5 => 'Table'
            ],
            'translation' => 'Report.options.dashletDisplayType',
            'view' => 'advanced:views/dashlets/fields/display-type'
          ],
          'useSiMultiplier' => [
            'type' => 'bool'
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ]
        ],
        'defaults' => [
          'autorefreshInterval' => 0,
          'useSiMultiplier' => true,
          'displayType' => ''
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'report'
                ],
                1 => [
                  'name' => 'column'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'autorefreshInterval'
                ],
                1 => false
              ],
              3 => [
                0 => [
                  'name' => 'displayType'
                ],
                1 => false
              ],
              4 => [
                0 => [
                  'name' => 'useSiMultiplier'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'ProjectTask' => [
      'view' => 'modules/project/views/dashlets/project-tasks',
      'aclScope' => 'ProjectTask',
      'entityType' => 'ProjectTask',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ],
          'futureDays' => [
            'type' => 'int',
            'min' => 0
          ],
          'includeOwn' => [
            'type' => 'bool'
          ]
        ],
        'defaults' => [
          'orderBy' => 'timeline',
          'order' => 'asc',
          'displayRecords' => 10,
          'populateAssignedUser' => true,
          'futureDays' => NULL,
          'includeOwn' => false,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => [
                  'name' => 'column'
                ],
                1 => [
                  'name' => 'timeline'
                ],
                2 => [
                  'name' => 'project'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'actual'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'futureDays'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => [
                  'name' => 'includeOwn'
                ]
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Analytics' => [
      'view' => 'custom:views/AnalyticsDashboard/detail'
    ],
    'DowloadPbi' => [
      'view' => 'custom:views/dashlets/DownloadPbi',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'link' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'link'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Rocket' => [
      'view' => 'custom:views/Rocket/detail',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'ClientID' => [
            'type' => 'varchar',
            'required' => true
          ],
          'ClientSecret' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'ClientID'
                ],
                1 => [
                  'name' => 'ClientSecret'
                ]
              ]
            ]
          ]
        ]
      ]
    ]
  ],
  'entityAcl' => [
    'AppSecret' => [
      'fields' => [
        'value' => [
          'internal' => true
        ]
      ]
    ],
    'Attachment' => [
      'fields' => [
        'storage' => [
          'readOnly' => true
        ],
        'source' => [
          'readOnly' => true
        ],
        'sourceId' => [
          'readOnly' => true
        ]
      ]
    ],
    'AuthLogRecord' => [
      'fields' => [
        'username' => [
          'readOnly' => true
        ],
        'portal' => [
          'readOnly' => true
        ],
        'user' => [
          'readOnly' => true
        ],
        'ipAddress' => [
          'readOnly' => true
        ],
        'authToken' => [
          'readOnly' => true
        ],
        'isDenied' => [
          'readOnly' => true
        ],
        'denialReason' => [
          'readOnly' => true
        ],
        'microtime' => [
          'readOnly' => true
        ],
        'requestUrl' => [
          'readOnly' => true
        ],
        'requestMethod' => [
          'readOnly' => true
        ]
      ]
    ],
    'AuthToken' => [
      'fields' => [
        'hash' => [
          'forbidden' => true,
          'readOnly' => true
        ],
        'token' => [
          'forbidden' => true,
          'readOnly' => true
        ],
        'secret' => [
          'forbidden' => true,
          'readOnly' => true
        ],
        'portal' => [
          'readOnly' => true
        ],
        'user' => [
          'readOnly' => true
        ],
        'ipAddress' => [
          'readOnly' => true
        ],
        'lastAccess' => [
          'readOnly' => true
        ],
        'createdAt' => [
          'readOnly' => true
        ],
        'modifiedAt' => [
          'readOnly' => true
        ]
      ]
    ],
    'Email' => [
      'fields' => [
        'users' => [
          'readOnly' => true
        ],
        'messageId' => [
          'readOnly' => true
        ],
        'tasks' => [
          'readOnly' => true
        ]
      ],
      'links' => [
        'users' => [
          'nonAdminReadOnly' => true
        ],
        'tasks' => [
          'readOnly' => true
        ]
      ]
    ],
    'EmailAccount' => [
      'fields' => [
        'password' => [
          'internal' => true
        ],
        'smtpPassword' => [
          'internal' => true
        ],
        'imapHandler' => [
          'forbidden' => true
        ],
        'smtpHandler' => [
          'forbidden' => true
        ],
        'fetchData' => [
          'readOnly' => true
        ]
      ]
    ],
    'InboundEmail' => [
      'fields' => [
        'password' => [
          'internal' => true
        ],
        'smtpPassword' => [
          'internal' => true
        ],
        'imapHandler' => [
          'internal' => true
        ],
        'smtpHandler' => [
          'internal' => true
        ],
        'fetchData' => [
          'readOnly' => true
        ]
      ]
    ],
    'Note' => [
      'links' => [
        'teams' => [
          'readOnly' => true
        ],
        'users' => [
          'readOnly' => true
        ]
      ]
    ],
    'Preferences' => [
      'fields' => [
        'data' => [
          'forbidden' => true
        ]
      ]
    ],
    'User' => [
      'fields' => [
        'userName' => [
          'nonAdminReadOnly' => true
        ],
        'apiKey' => [
          'onlyAdmin' => true,
          'readOnly' => true,
          'nonAdminReadOnly' => true
        ],
        'password' => [
          'internal' => true,
          'nonAdminReadOnly' => true
        ],
        'passwordConfirm' => [
          'internal' => true,
          'nonAdminReadOnly' => true
        ],
        'authLogRecordId' => [
          'forbidden' => true
        ],
        'authMethod' => [
          'onlyAdmin' => true
        ],
        'secretKey' => [
          'readOnly' => true,
          'onlyAdmin' => true
        ],
        'isActive' => [
          'nonAdminReadOnly' => true
        ],
        'emailAddress' => [
          'nonAdminReadOnly' => true
        ],
        'teams' => [
          'nonAdminReadOnly' => true
        ],
        'defaultTeam' => [
          'nonAdminReadOnly' => true
        ],
        'roles' => [
          'nonAdminReadOnly' => true
        ],
        'portals' => [
          'nonAdminReadOnly' => true
        ],
        'portalRoles' => [
          'nonAdminReadOnly' => true
        ],
        'contact' => [
          'nonAdminReadOnly' => true
        ],
        'workingTimeCalendar' => [
          'nonAdminReadOnly' => true
        ],
        'layoutSet' => [
          'onlyAdmin' => true
        ],
        'accounts' => [
          'nonAdminReadOnly' => true
        ],
        'type' => [
          'nonAdminReadOnly' => true
        ],
        'auth2FA' => [
          'onlyAdmin' => true
        ],
        'userData' => [
          'forbidden' => true
        ],
        'deleteId' => [
          'forbidden' => true
        ]
      ],
      'links' => [
        'teams' => [
          'nonAdminReadOnly' => true
        ],
        'roles' => [
          'onlyAdmin' => true
        ],
        'workingTimeRanges' => [
          'nonAdminReadOnly' => true
        ],
        'portalRoles' => [
          'onlyAdmin' => true
        ],
        'accounts' => [
          'onlyAdmin' => true
        ],
        'defaultTeam' => [
          'onlyAdmin' => true
        ],
        'dashboardTemplate' => [
          'onlyAdmin' => true
        ],
        'userData' => [
          'forbidden' => true
        ],
        'projects' => [
          'readOnly' => true
        ]
      ]
    ],
    'Webhook' => [
      'fields' => [
        'user' => [
          'onlyAdmin' => true
        ],
        'secretKey' => [
          'readOnly' => true
        ]
      ]
    ],
    'Case' => [
      'fields' => [
        'inboundEmail' => [
          'readOnly' => true
        ]
      ],
      'links' => [
        'inboundEmail' => [
          'readOnly' => true
        ],
        'collaborators' => [
          'readOnly' => true
        ]
      ]
    ],
    'Contact' => [
      'fields' => [
        'inboundEmail' => [
          'readOnly' => true
        ],
        'portalUser' => [
          'readOnly' => true
        ]
      ]
    ],
    'KnowledgeBaseArticle' => [
      'fields' => [
        'order' => [
          'readOnly' => true
        ]
      ]
    ],
    'Task' => [
      'fields' => [
        'email' => [
          'readOnly' => true
        ]
      ],
      'links' => [
        'collaborators' => [
          'readOnly' => true
        ]
      ]
    ],
    'BpmnFlowchart' => [
      'fields' => [
        'elementsDataHash' => [
          'readOnly' => true
        ],
        'eventStartIdList' => [
          'readOnly' => true
        ]
      ]
    ],
    'BpmnProcess' => [
      'fields' => [
        'flowchartElementsDataHash' => [
          'readOnly' => true
        ],
        'workflowId' => [
          'readOnly' => true
        ],
        'parentProcess' => [
          'readOnly' => true
        ],
        'flowchartData' => [
          'readOnly' => true
        ],
        'createdEntitiesData' => [
          'readOnly' => true
        ],
        'variables' => [
          'readOnly' => true
        ],
        'endedAt' => [
          'readOnly' => true
        ],
        'status' => [
          'readOnly' => true
        ],
        'parentProcessFlowNode' => [
          'readOnly' => true
        ]
      ],
      'links' => [
        'parentProcess' => [
          'readOnly' => true
        ],
        'childProcesses' => [
          'readOnly' => true
        ]
      ]
    ],
    'Report' => [
      'fields' => [
        'internalClassName' => [
          'internal' => true
        ]
      ],
      'links' => [
        'portals' => [
          'internal' => true
        ]
      ]
    ],
    'Workflow' => [
      'fields' => [
        'isInternal' => [
          'readOnly' => true
        ]
      ]
    ],
    'DeliveryOrder' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'InventoryAdjustment' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'InventoryNumber' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ]
      ]
    ],
    'Invoice' => [
      'links' => [
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'Product' => [
      'links' => [
        'prices' => [
          'readOnly' => true
        ],
        'supplierPrices' => [
          'readOnly' => true
        ],
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'attributes' => [
          'readOnly' => true
        ],
        'attributeOptions' => [
          'readOnly' => true
        ],
        'variantAttributeOptions' => [
          'readOnly' => true
        ],
        'variants' => [
          'readOnly' => true
        ],
        'inventoryAdjustmentItems' => [
          'readOnly' => true
        ]
      ]
    ],
    'ProductAttribute' => [
      'links' => [
        'products' => [
          'readOnly' => true
        ]
      ]
    ],
    'ProductAttributeOption' => [
      'links' => [
        'products' => [
          'readOnly' => true
        ],
        'productVariants' => [
          'readOnly' => true
        ]
      ]
    ],
    'PurchaseOrder' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'receiptOrders' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'Quote' => [
      'links' => [
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'ReceiptOrder' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ],
        'receivedItems' => [
          'readOnly' => true
        ]
      ]
    ],
    'ReturnOrder' => [
      'links' => [
        'receiptOrders' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'SalesOrder' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'deliveryOrders' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'TransferOrder' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'Warehouse' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ]
      ]
    ],
    'Service' => [
      'links' => [
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'Project' => [
      'links' => [
        'tasks' => [
          'readOnly' => true
        ]
      ]
    ],
    'ProjectBoard' => [
      'links' => [
        'columns' => [
          'readOnly' => true
        ],
        'projects' => [
          'readOnly' => true
        ]
      ]
    ],
    'ProjectColumn' => [
      'links' => [
        'tasks' => [
          'readOnly' => true
        ]
      ]
    ],
    'ProjectGroup' => [
      'links' => [
        'tasks' => [
          'readOnly' => true
        ]
      ]
    ],
    'ProjectTask' => [
      'fields' => [
        'status' => [
          'readOnly' => true
        ]
      ],
      'links' => [
        'subTasks' => [
          'readOnly' => true
        ],
        'fromTasks' => [
          'readOnly' => true
        ],
        'toTasks' => [
          'readOnly' => true
        ]
      ]
    ]
  ],
  'entityDefs' => [
    'ActionHistoryRecord' => [
      'fields' => [
        'number' => [
          'type' => 'autoincrement',
          'index' => true,
          'dbType' => 'bigint'
        ],
        'targetType' => [
          'type' => 'varchar',
          'view' => 'views/action-history-record/fields/target-type',
          'translation' => 'Global.scopeNames'
        ],
        'target' => [
          'type' => 'linkParent',
          'view' => 'views/action-history-record/fields/target'
        ],
        'data' => [
          'type' => 'jsonObject'
        ],
        'action' => [
          'type' => 'enum',
          'options' => [
            0 => 'read',
            1 => 'update',
            2 => 'create',
            3 => 'delete'
          ]
        ],
        'createdAt' => [
          'type' => 'datetime',
          'hasSeconds' => true
        ],
        'user' => [
          'type' => 'link',
          'view' => 'views/fields/user'
        ],
        'userType' => [
          'type' => 'foreign',
          'link' => 'user',
          'field' => 'type',
          'view' => 'views/fields/foreign-enum',
          'notStorable' => true
        ],
        'ipAddress' => [
          'type' => 'varchar',
          'maxLength' => 39
        ],
        'authToken' => [
          'type' => 'link'
        ],
        'authLogRecord' => [
          'type' => 'link'
        ]
      ],
      'links' => [
        'user' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'target' => [
          'type' => 'belongsToParent'
        ],
        'authToken' => [
          'type' => 'belongsTo',
          'entity' => 'AuthToken',
          'foreignName' => 'id',
          'foreign' => 'actionHistoryRecords'
   