<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: a67be8f75bc1974a987315ddc1024a78
 ************************************************************************************/

namespace Espo\Modules\Sales\Classes\FieldLoaders\Opportunity;

use Espo\Core\FieldProcessing\Loader;
use Espo\Core\FieldProcessing\Loader\Params;
use Espo\Modules\Crm\Entities\Opportunity;
use Espo\Modules\Sales\Entities\OpportunityItem;
use Espo\ORM\Entity;
use Espo\ORM\EntityManager;

/**
 * @implements Loader<Opportunity>
 */
class ItemListLoader implements Loader
{
    public function __construct(private EntityManager $entityManager)
    {}

    public function process(Entity $entity, Params $params): void
    {
        $itemList = $this->entityManager
            ->getRDBRepository(OpportunityItem::ENTITY_TYPE)
            ->where(['opportunityId' => $entity->getId()])
            ->order('order')
            ->find();

        $itemDataList = $itemList->getValueMapList();

        $entity->set('itemList', $itemDataList);

        if (!$entity->hasFetched('itemList')) {
            $entity->setFetched('itemList', $itemDataList);
        }
    }
}

