<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Tools\Project;

use Espo\Entities\User;
use Espo\Modules\Project\Entities\ProjectRole;
use Espo\Modules\Project\Entities\ProjectTask;
use Espo\ORM\EntityManager;

class MemberTaskAccessChecker
{
    public function __construct(
        private MemberRoleProvider $memberRoleProvider,
        private EntityManager $entityManager,
    ) {}

    public function checkColumnEdit(User $user, ProjectTask $task): bool
    {
        if (!$task->getProjectId()) {
            return false;
        }

        $roleData = $this->memberRoleProvider->get($user, $task->getProjectId());

        if (!$roleData) {
            return false;
        }

        if ($task->getParentTaskId()) {
            $parentTask = $this->entityManager
                ->getRDBRepositoryByClass(ProjectTask::class)
                ->getById($task->getParentTaskId());

            if ($parentTask && $this->checkColumnEdit($user, $parentTask)) {
                return true;
            }
        }

        $permission = $roleData->getTaskColumnEdit();

        if ($permission === ProjectRole::LEVEL_ALL) {
            return true;
        }

        if ($permission === ProjectRole::LEVEL_ASSIGNED) {
            return $task->getAssignedUserId() === $user->getId() ||
                $task->getOwnerId() === $user->getId();
        }

        if ($permission === ProjectRole::LEVEL_OWN) {
            return $task->getOwnerId() === $user->getId();
        }

        return false;
    }
}
