<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Select\Project\Access;

use Espo\Core\Acl;
use Espo\Core\Select\AccessControl\FilterResolver as FilterResolverInterface;
use Espo\Modules\Project\Entities\Project;

class FilterResolver implements FilterResolverInterface
{
    public function __construct(private Acl $acl)
    {}

    public function resolve(): ?string
    {
        if (!$this->acl->checkScope(Project::ENTITY_TYPE)) {
            return 'no';
        }

        if ($this->acl->checkReadNo(Project::ENTITY_TYPE)) {
            return 'member';
        }

        if ($this->acl->checkReadAll(Project::ENTITY_TYPE)) {
            return 'all';
        }

        return 'member';
    }
}
