<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Classes\Acl\Project\LinkCheckers;

use Espo\Core\Acl\LinkChecker;
use Espo\Core\Acl\Permission;
use Espo\Core\AclManager;
use Espo\Entities\User;
use Espo\Modules\Project\Entities\Project;
use Espo\Modules\Project\Tools\Project\MemberRoleProvider;
use Espo\ORM\Entity;

/**
 * @implements LinkChecker<Project, User>
 */
class Members implements LinkChecker
{
    public function __construct(
        private AclManager $aclManager,
        private MemberRoleProvider $memberRoleProvider,
    ) {}

    public function check(User $user, Entity $entity, Entity $foreignEntity): bool
    {
        $role = $this->memberRoleProvider->get($user, $entity->getId());

        if (
            !$user->isAdmin() &&
            $role?->role !== Project::ROLE_OWNER
        ) {
            return false;
        }

        return $this->aclManager->checkUserPermission($user, $foreignEntity, Permission::ASSIGNMENT);
    }
}
