/************************************************************************
 * This file is part of TD SYNNEX MCA.
 *
 * TD SYNNEX MCA – Open Source CRM application.
 * Copyright (C) 2014-2024 Yurii Kuznietsov, Taras Machyshyn, Oleksii Avramenko
 * Website: https://www.espocrm.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "TD SYNNEX MCA" word.
 ************************************************************************/

define('views/admin/auth-token/record/row-actions/default', ['views/record/row-actions/default'], function (Dep) {

    return Dep.extend({

        setup: function () {
            Dep.prototype.setup.call(this);

            this.listenTo(this.model, 'change:isActive', () => {
                setTimeout(() => {
                    this.reRender();
                }, 10);
            });
        },

        getActionList: function () {
            var list = [];

            list.push({
                action: 'quickView',
                label: 'View',
                data: {
                    id: this.model.id
                }
            });

            if (this.model.get('isActive')) {
                list.push({
                    action: 'setInactive',
                    label: 'Set Inactive',
                    data: {
                        id: this.model.id
                    }
                });
            }

            list.push({
                action: 'quickRemove',
                label: 'Remove',
                data: {
                    id: this.model.id
                }
            });

            return list;
        },
    });
});
