/**
 * vis-timeline and vis-graph2d
 * https://visjs.github.io/vis-timeline/
 *
 * Create a fully customizable, interactive timeline with items and ranges.
 *
 * @version 7.7.2
 * @date    2023-03-22T11:14:31.874Z
 *
 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
 *
 * @license
 * vis.js is dual licensed under both
 *
 *   1. The Apache 2.0 License
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   and
 *
 *   2. The MIT License
 *      http://opensource.org/licenses/MIT
 *
 * vis.js may be distributed under either license.
 */

(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('moment'), require('vis-data/peer/umd/vis-data.js')) :
	typeof define === 'function' && define.amd ? define(['exports', 'moment', 'vis-data/peer/umd/vis-data.js'], factory) :
	(global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.vis = global.vis || {}, global.moment, global.vis));
})(this, (function (exports, moment$3, esnext) {
	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function getDefaultExportFromCjs (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	var constructExports = {};
	var construct$4 = {
	  get exports(){ return constructExports; },
	  set exports(v){ constructExports = v; },
	};

	var check = function (it) {
	  return it && it.Math == Math && it;
	};

	// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
	var global$j =
	  // eslint-disable-next-line es/no-global-this -- safe
	  check(typeof globalThis == 'object' && globalThis) ||
	  check(typeof window == 'object' && window) ||
	  // eslint-disable-next-line no-restricted-globals -- safe
	  check(typeof self == 'object' && self) ||
	  check(typeof commonjsGlobal == 'object' && commonjsGlobal) ||
	  // eslint-disable-next-line no-new-func -- fallback
	  (function () { return this; })() || Function('return this')();

	var fails$u = function (exec) {
	  try {
	    return !!exec();
	  } catch (error) {
	    return true;
	  }
	};

	var fails$t = fails$u;

	var functionBindNative = !fails$t(function () {
	  // eslint-disable-next-line es/no-function-prototype-bind -- safe
	  var test = (function () { /* empty */ }).bind();
	  // eslint-disable-next-line no-prototype-builtins -- safe
	  return typeof test != 'function' || test.hasOwnProperty('prototype');
	});

	var NATIVE_BIND$4 = functionBindNative;

	var FunctionPrototype$3 = Function.prototype;
	var apply$5 = FunctionPrototype$3.apply;
	var call$e = FunctionPrototype$3.call;

	// eslint-disable-next-line es/no-reflect -- safe
	var functionApply = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND$4 ? call$e.bind(apply$5) : function () {
	  return call$e.apply(apply$5, arguments);
	});

	var NATIVE_BIND$3 = functionBindNative;

	var FunctionPrototype$2 = Function.prototype;
	var call$d = FunctionPrototype$2.call;
	var uncurryThisWithBind = NATIVE_BIND$3 && FunctionPrototype$2.bind.bind(call$d, call$d);

	var functionUncurryThis = NATIVE_BIND$3 ? uncurryThisWithBind : function (fn) {
	  return function () {
	    return call$d.apply(fn, arguments);
	  };
	};

	var uncurryThis$w = functionUncurryThis;

	var toString$d = uncurryThis$w({}.toString);
	var stringSlice$1 = uncurryThis$w(''.slice);

	var classofRaw$2 = function (it) {
	  return stringSlice$1(toString$d(it), 8, -1);
	};

	var classofRaw$1 = classofRaw$2;
	var uncurryThis$v = functionUncurryThis;

	var functionUncurryThisClause = function (fn) {
	  // Nashorn bug:
	  //   https://github.com/zloirock/core-js/issues/1128
	  //   https://github.com/zloirock/core-js/issues/1130
	  if (classofRaw$1(fn) === 'Function') return uncurryThis$v(fn);
	};

	var documentAll$2 = typeof document == 'object' && document.all;

	// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
	// eslint-disable-next-line unicorn/no-typeof-undefined -- required for testing
	var IS_HTMLDDA = typeof documentAll$2 == 'undefined' && documentAll$2 !== undefined;

	var documentAll_1 = {
	  all: documentAll$2,
	  IS_HTMLDDA: IS_HTMLDDA
	};

	var $documentAll$1 = documentAll_1;

	var documentAll$1 = $documentAll$1.all;

	// `IsCallable` abstract operation
	// https://tc39.es/ecma262/#sec-iscallable
	var isCallable$i = $documentAll$1.IS_HTMLDDA ? function (argument) {
	  return typeof argument == 'function' || argument === documentAll$1;
	} : function (argument) {
	  return typeof argument == 'function';
	};

	var objectGetOwnPropertyDescriptor = {};

	var fails$s = fails$u;

	// Detect IE8's incomplete defineProperty implementation
	var descriptors = !fails$s(function () {
	  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
	  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] != 7;
	});

	var NATIVE_BIND$2 = functionBindNative;

	var call$c = Function.prototype.call;

	var functionCall = NATIVE_BIND$2 ? call$c.bind(call$c) : function () {
	  return call$c.apply(call$c, arguments);
	};

	var objectPropertyIsEnumerable = {};

	var $propertyIsEnumerable$2 = {}.propertyIsEnumerable;
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var getOwnPropertyDescriptor$6 = Object.getOwnPropertyDescriptor;

	// Nashorn ~ JDK8 bug
	var NASHORN_BUG = getOwnPropertyDescriptor$6 && !$propertyIsEnumerable$2.call({ 1: 2 }, 1);

	// `Object.prototype.propertyIsEnumerable` method implementation
	// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
	objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
	  var descriptor = getOwnPropertyDescriptor$6(this, V);
	  return !!descriptor && descriptor.enumerable;
	} : $propertyIsEnumerable$2;

	var createPropertyDescriptor$5 = function (bitmap, value) {
	  return {
	    enumerable: !(bitmap & 1),
	    configurable: !(bitmap & 2),
	    writable: !(bitmap & 4),
	    value: value
	  };
	};

	var uncurryThis$u = functionUncurryThis;
	var fails$r = fails$u;
	var classof$d = classofRaw$2;

	var $Object$4 = Object;
	var split = uncurryThis$u(''.split);

	// fallback for non-array-like ES3 and non-enumerable old V8 strings
	var indexedObject = fails$r(function () {
	  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
	  // eslint-disable-next-line no-prototype-builtins -- safe
	  return !$Object$4('z').propertyIsEnumerable(0);
	}) ? function (it) {
	  return classof$d(it) == 'String' ? split(it, '') : $Object$4(it);
	} : $Object$4;

	// we can't use just `it == null` since of `document.all` special case
	// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot-aec
	var isNullOrUndefined$4 = function (it) {
	  return it === null || it === undefined;
	};

	var isNullOrUndefined$3 = isNullOrUndefined$4;

	var $TypeError$g = TypeError;

	// `RequireObjectCoercible` abstract operation
	// https://tc39.es/ecma262/#sec-requireobjectcoercible
	var requireObjectCoercible$6 = function (it) {
	  if (isNullOrUndefined$3(it)) throw $TypeError$g("Can't call method on " + it);
	  return it;
	};

	// toObject with fallback for non-array-like ES3 strings
	var IndexedObject$3 = indexedObject;
	var requireObjectCoercible$5 = requireObjectCoercible$6;

	var toIndexedObject$b = function (it) {
	  return IndexedObject$3(requireObjectCoercible$5(it));
	};

	var isCallable$h = isCallable$i;
	var $documentAll = documentAll_1;

	var documentAll = $documentAll.all;

	var isObject$g = $documentAll.IS_HTMLDDA ? function (it) {
	  return typeof it == 'object' ? it !== null : isCallable$h(it) || it === documentAll;
	} : function (it) {
	  return typeof it == 'object' ? it !== null : isCallable$h(it);
	};

	var path$r = {};

	var path$q = path$r;
	var global$i = global$j;
	var isCallable$g = isCallable$i;

	var aFunction = function (variable) {
	  return isCallable$g(variable) ? variable : undefined;
	};

	var getBuiltIn$c = function (namespace, method) {
	  return arguments.length < 2 ? aFunction(path$q[namespace]) || aFunction(global$i[namespace])
	    : path$q[namespace] && path$q[namespace][method] || global$i[namespace] && global$i[namespace][method];
	};

	var uncurryThis$t = functionUncurryThis;

	var objectIsPrototypeOf = uncurryThis$t({}.isPrototypeOf);

	var engineUserAgent = typeof navigator != 'undefined' && String(navigator.userAgent) || '';

	var global$h = global$j;
	var userAgent$2 = engineUserAgent;

	var process$1 = global$h.process;
	var Deno = global$h.Deno;
	var versions = process$1 && process$1.versions || Deno && Deno.version;
	var v8 = versions && versions.v8;
	var match, version;

	if (v8) {
	  match = v8.split('.');
	  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
	  // but their correct versions are not interesting for us
	  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
	}

	// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
	// so check `userAgent` even if `.v8` exists, but 0
	if (!version && userAgent$2) {
	  match = userAgent$2.match(/Edge\/(\d+)/);
	  if (!match || match[1] >= 74) {
	    match = userAgent$2.match(/Chrome\/(\d+)/);
	    if (match) version = +match[1];
	  }
	}

	var engineV8Version = version;

	/* eslint-disable es/no-symbol -- required for testing */

	var V8_VERSION$2 = engineV8Version;
	var fails$q = fails$u;

	// eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing
	var symbolConstructorDetection = !!Object.getOwnPropertySymbols && !fails$q(function () {
	  var symbol = Symbol();
	  // Chrome 38 Symbol has incorrect toString conversion
	  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
	  return !String(symbol) || !(Object(symbol) instanceof Symbol) ||
	    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
	    !Symbol.sham && V8_VERSION$2 && V8_VERSION$2 < 41;
	});

	/* eslint-disable es/no-symbol -- required for testing */

	var NATIVE_SYMBOL$5 = symbolConstructorDetection;

	var useSymbolAsUid = NATIVE_SYMBOL$5
	  && !Symbol.sham
	  && typeof Symbol.iterator == 'symbol';

	var getBuiltIn$b = getBuiltIn$c;
	var isCallable$f = isCallable$i;
	var isPrototypeOf$m = objectIsPrototypeOf;
	var USE_SYMBOL_AS_UID$1 = useSymbolAsUid;

	var $Object$3 = Object;

	var isSymbol$5 = USE_SYMBOL_AS_UID$1 ? function (it) {
	  return typeof it == 'symbol';
	} : function (it) {
	  var $Symbol = getBuiltIn$b('Symbol');
	  return isCallable$f($Symbol) && isPrototypeOf$m($Symbol.prototype, $Object$3(it));
	};

	var $String$4 = String;

	var tryToString$6 = function (argument) {
	  try {
	    return $String$4(argument);
	  } catch (error) {
	    return 'Object';
	  }
	};

	var isCallable$e = isCallable$i;
	var tryToString$5 = tryToString$6;

	var $TypeError$f = TypeError;

	// `Assert: IsCallable(argument) is true`
	var aCallable$7 = function (argument) {
	  if (isCallable$e(argument)) return argument;
	  throw $TypeError$f(tryToString$5(argument) + ' is not a function');
	};

	var aCallable$6 = aCallable$7;
	var isNullOrUndefined$2 = isNullOrUndefined$4;

	// `GetMethod` abstract operation
	// https://tc39.es/ecma262/#sec-getmethod
	var getMethod$3 = function (V, P) {
	  var func = V[P];
	  return isNullOrUndefined$2(func) ? undefined : aCallable$6(func);
	};

	var call$b = functionCall;
	var isCallable$d = isCallable$i;
	var isObject$f = isObject$g;

	var $TypeError$e = TypeError;

	// `OrdinaryToPrimitive` abstract operation
	// https://tc39.es/ecma262/#sec-ordinarytoprimitive
	var ordinaryToPrimitive$1 = function (input, pref) {
	  var fn, val;
	  if (pref === 'string' && isCallable$d(fn = input.toString) && !isObject$f(val = call$b(fn, input))) return val;
	  if (isCallable$d(fn = input.valueOf) && !isObject$f(val = call$b(fn, input))) return val;
	  if (pref !== 'string' && isCallable$d(fn = input.toString) && !isObject$f(val = call$b(fn, input))) return val;
	  throw $TypeError$e("Can't convert object to primitive value");
	};

	var sharedExports = {};
	var shared$7 = {
	  get exports(){ return sharedExports; },
	  set exports(v){ sharedExports = v; },
	};

	var global$g = global$j;

	// eslint-disable-next-line es/no-object-defineproperty -- safe
	var defineProperty$f = Object.defineProperty;

	var defineGlobalProperty$1 = function (key, value) {
	  try {
	    defineProperty$f(global$g, key, { value: value, configurable: true, writable: true });
	  } catch (error) {
	    global$g[key] = value;
	  } return value;
	};

	var global$f = global$j;
	var defineGlobalProperty = defineGlobalProperty$1;

	var SHARED = '__core-js_shared__';
	var store$3 = global$f[SHARED] || defineGlobalProperty(SHARED, {});

	var sharedStore = store$3;

	var store$2 = sharedStore;

	(shared$7.exports = function (key, value) {
	  return store$2[key] || (store$2[key] = value !== undefined ? value : {});
	})('versions', []).push({
	  version: '3.29.0',
	  mode: 'pure' ,
	  copyright: '© 2014-2023 Denis Pushkarev (zloirock.ru)',
	  license: 'https://github.com/zloirock/core-js/blob/v3.29.0/LICENSE',
	  source: 'https://github.com/zloirock/core-js'
	});

	var requireObjectCoercible$4 = requireObjectCoercible$6;

	var $Object$2 = Object;

	// `ToObject` abstract operation
	// https://tc39.es/ecma262/#sec-toobject
	var toObject$d = function (argument) {
	  return $Object$2(requireObjectCoercible$4(argument));
	};

	var uncurryThis$s = functionUncurryThis;
	var toObject$c = toObject$d;

	var hasOwnProperty = uncurryThis$s({}.hasOwnProperty);

	// `HasOwnProperty` abstract operation
	// https://tc39.es/ecma262/#sec-hasownproperty
	// eslint-disable-next-line es/no-object-hasown -- safe
	var hasOwnProperty_1 = Object.hasOwn || function hasOwn(it, key) {
	  return hasOwnProperty(toObject$c(it), key);
	};

	var uncurryThis$r = functionUncurryThis;

	var id$1 = 0;
	var postfix = Math.random();
	var toString$c = uncurryThis$r(1.0.toString);

	var uid$4 = function (key) {
	  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString$c(++id$1 + postfix, 36);
	};

	var global$e = global$j;
	var shared$6 = sharedExports;
	var hasOwn$e = hasOwnProperty_1;
	var uid$3 = uid$4;
	var NATIVE_SYMBOL$4 = symbolConstructorDetection;
	var USE_SYMBOL_AS_UID = useSymbolAsUid;

	var Symbol$5 = global$e.Symbol;
	var WellKnownSymbolsStore$2 = shared$6('wks');
	var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol$5['for'] || Symbol$5 : Symbol$5 && Symbol$5.withoutSetter || uid$3;

	var wellKnownSymbol$l = function (name) {
	  if (!hasOwn$e(WellKnownSymbolsStore$2, name)) {
	    WellKnownSymbolsStore$2[name] = NATIVE_SYMBOL$4 && hasOwn$e(Symbol$5, name)
	      ? Symbol$5[name]
	      : createWellKnownSymbol('Symbol.' + name);
	  } return WellKnownSymbolsStore$2[name];
	};

	var call$a = functionCall;
	var isObject$e = isObject$g;
	var isSymbol$4 = isSymbol$5;
	var getMethod$2 = getMethod$3;
	var ordinaryToPrimitive = ordinaryToPrimitive$1;
	var wellKnownSymbol$k = wellKnownSymbol$l;

	var $TypeError$d = TypeError;
	var TO_PRIMITIVE = wellKnownSymbol$k('toPrimitive');

	// `ToPrimitive` abstract operation
	// https://tc39.es/ecma262/#sec-toprimitive
	var toPrimitive$7 = function (input, pref) {
	  if (!isObject$e(input) || isSymbol$4(input)) return input;
	  var exoticToPrim = getMethod$2(input, TO_PRIMITIVE);
	  var result;
	  if (exoticToPrim) {
	    if (pref === undefined) pref = 'default';
	    result = call$a(exoticToPrim, input, pref);
	    if (!isObject$e(result) || isSymbol$4(result)) return result;
	    throw $TypeError$d("Can't convert object to primitive value");
	  }
	  if (pref === undefined) pref = 'number';
	  return ordinaryToPrimitive(input, pref);
	};

	var toPrimitive$6 = toPrimitive$7;
	var isSymbol$3 = isSymbol$5;

	// `ToPropertyKey` abstract operation
	// https://tc39.es/ecma262/#sec-topropertykey
	var toPropertyKey$4 = function (argument) {
	  var key = toPrimitive$6(argument, 'string');
	  return isSymbol$3(key) ? key : key + '';
	};

	var global$d = global$j;
	var isObject$d = isObject$g;

	var document$1 = global$d.document;
	// typeof document.createElement is 'object' in old IE
	var EXISTS$1 = isObject$d(document$1) && isObject$d(document$1.createElement);

	var documentCreateElement$1 = function (it) {
	  return EXISTS$1 ? document$1.createElement(it) : {};
	};

	var DESCRIPTORS$i = descriptors;
	var fails$p = fails$u;
	var createElement = documentCreateElement$1;

	// Thanks to IE8 for its funny defineProperty
	var ie8DomDefine = !DESCRIPTORS$i && !fails$p(function () {
	  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
	  return Object.defineProperty(createElement('div'), 'a', {
	    get: function () { return 7; }
	  }).a != 7;
	});

	var DESCRIPTORS$h = descriptors;
	var call$9 = functionCall;
	var propertyIsEnumerableModule$2 = objectPropertyIsEnumerable;
	var createPropertyDescriptor$4 = createPropertyDescriptor$5;
	var toIndexedObject$a = toIndexedObject$b;
	var toPropertyKey$3 = toPropertyKey$4;
	var hasOwn$d = hasOwnProperty_1;
	var IE8_DOM_DEFINE$1 = ie8DomDefine;

	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var $getOwnPropertyDescriptor$2 = Object.getOwnPropertyDescriptor;

	// `Object.getOwnPropertyDescriptor` method
	// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
	objectGetOwnPropertyDescriptor.f = DESCRIPTORS$h ? $getOwnPropertyDescriptor$2 : function getOwnPropertyDescriptor(O, P) {
	  O = toIndexedObject$a(O);
	  P = toPropertyKey$3(P);
	  if (IE8_DOM_DEFINE$1) try {
	    return $getOwnPropertyDescriptor$2(O, P);
	  } catch (error) { /* empty */ }
	  if (hasOwn$d(O, P)) return createPropertyDescriptor$4(!call$9(propertyIsEnumerableModule$2.f, O, P), O[P]);
	};

	var fails$o = fails$u;
	var isCallable$c = isCallable$i;

	var replacement = /#|\.prototype\./;

	var isForced$1 = function (feature, detection) {
	  var value = data[normalize(feature)];
	  return value == POLYFILL ? true
	    : value == NATIVE ? false
	    : isCallable$c(detection) ? fails$o(detection)
	    : !!detection;
	};

	var normalize = isForced$1.normalize = function (string) {
	  return String(string).replace(replacement, '.').toLowerCase();
	};

	var data = isForced$1.data = {};
	var NATIVE = isForced$1.NATIVE = 'N';
	var POLYFILL = isForced$1.POLYFILL = 'P';

	var isForced_1 = isForced$1;

	var uncurryThis$q = functionUncurryThisClause;
	var aCallable$5 = aCallable$7;
	var NATIVE_BIND$1 = functionBindNative;

	var bind$f = uncurryThis$q(uncurryThis$q.bind);

	// optional / simple context binding
	var functionBindContext = function (fn, that) {
	  aCallable$5(fn);
	  return that === undefined ? fn : NATIVE_BIND$1 ? bind$f(fn, that) : function (/* ...args */) {
	    return fn.apply(that, arguments);
	  };
	};

	var objectDefineProperty = {};

	var DESCRIPTORS$g = descriptors;
	var fails$n = fails$u;

	// V8 ~ Chrome 36-
	// https://bugs.chromium.org/p/v8/issues/detail?id=3334
	var v8PrototypeDefineBug = DESCRIPTORS$g && fails$n(function () {
	  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
	  return Object.defineProperty(function () { /* empty */ }, 'prototype', {
	    value: 42,
	    writable: false
	  }).prototype != 42;
	});

	var isObject$c = isObject$g;

	var $String$3 = String;
	var $TypeError$c = TypeError;

	// `Assert: Type(argument) is Object`
	var anObject$b = function (argument) {
	  if (isObject$c(argument)) return argument;
	  throw $TypeError$c($String$3(argument) + ' is not an object');
	};

	var DESCRIPTORS$f = descriptors;
	var IE8_DOM_DEFINE = ie8DomDefine;
	var V8_PROTOTYPE_DEFINE_BUG$1 = v8PrototypeDefineBug;
	var anObject$a = anObject$b;
	var toPropertyKey$2 = toPropertyKey$4;

	var $TypeError$b = TypeError;
	// eslint-disable-next-line es/no-object-defineproperty -- safe
	var $defineProperty$1 = Object.defineProperty;
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var $getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor;
	var ENUMERABLE = 'enumerable';
	var CONFIGURABLE$1 = 'configurable';
	var WRITABLE = 'writable';

	// `Object.defineProperty` method
	// https://tc39.es/ecma262/#sec-object.defineproperty
	objectDefineProperty.f = DESCRIPTORS$f ? V8_PROTOTYPE_DEFINE_BUG$1 ? function defineProperty(O, P, Attributes) {
	  anObject$a(O);
	  P = toPropertyKey$2(P);
	  anObject$a(Attributes);
	  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
	    var current = $getOwnPropertyDescriptor$1(O, P);
	    if (current && current[WRITABLE]) {
	      O[P] = Attributes.value;
	      Attributes = {
	        configurable: CONFIGURABLE$1 in Attributes ? Attributes[CONFIGURABLE$1] : current[CONFIGURABLE$1],
	        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
	        writable: false
	      };
	    }
	  } return $defineProperty$1(O, P, Attributes);
	} : $defineProperty$1 : function defineProperty(O, P, Attributes) {
	  anObject$a(O);
	  P = toPropertyKey$2(P);
	  anObject$a(Attributes);
	  if (IE8_DOM_DEFINE) try {
	    return $defineProperty$1(O, P, Attributes);
	  } catch (error) { /* empty */ }
	  if ('get' in Attributes || 'set' in Attributes) throw $TypeError$b('Accessors not supported');
	  if ('value' in Attributes) O[P] = Attributes.value;
	  return O;
	};

	var DESCRIPTORS$e = descriptors;
	var definePropertyModule$3 = objectDefineProperty;
	var createPropertyDescriptor$3 = createPropertyDescriptor$5;

	var createNonEnumerableProperty$6 = DESCRIPTORS$e ? function (object, key, value) {
	  return definePropertyModule$3.f(object, key, createPropertyDescriptor$3(1, value));
	} : function (object, key, value) {
	  object[key] = value;
	  return object;
	};

	var global$c = global$j;
	var apply$4 = functionApply;
	var uncurryThis$p = functionUncurryThisClause;
	var isCallable$b = isCallable$i;
	var getOwnPropertyDescriptor$5 = objectGetOwnPropertyDescriptor.f;
	var isForced = isForced_1;
	var path$p = path$r;
	var bind$e = functionBindContext;
	var createNonEnumerableProperty$5 = createNonEnumerableProperty$6;
	var hasOwn$c = hasOwnProperty_1;

	var wrapConstructor = function (NativeConstructor) {
	  var Wrapper = function (a, b, c) {
	    if (this instanceof Wrapper) {
	      switch (arguments.length) {
	        case 0: return new NativeConstructor();
	        case 1: return new NativeConstructor(a);
	        case 2: return new NativeConstructor(a, b);
	      } return new NativeConstructor(a, b, c);
	    } return apply$4(NativeConstructor, this, arguments);
	  };
	  Wrapper.prototype = NativeConstructor.prototype;
	  return Wrapper;
	};

	/*
	  options.target         - name of the target object
	  options.global         - target is the global object
	  options.stat           - export as static methods of target
	  options.proto          - export as prototype methods of target
	  options.real           - real prototype method for the `pure` version
	  options.forced         - export even if the native feature is available
	  options.bind           - bind methods to the target, required for the `pure` version
	  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
	  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
	  options.sham           - add a flag to not completely full polyfills
	  options.enumerable     - export as enumerable property
	  options.dontCallGetSet - prevent calling a getter on target
	  options.name           - the .name of the function if it does not match the key
	*/
	var _export = function (options, source) {
	  var TARGET = options.target;
	  var GLOBAL = options.global;
	  var STATIC = options.stat;
	  var PROTO = options.proto;

	  var nativeSource = GLOBAL ? global$c : STATIC ? global$c[TARGET] : (global$c[TARGET] || {}).prototype;

	  var target = GLOBAL ? path$p : path$p[TARGET] || createNonEnumerableProperty$5(path$p, TARGET, {})[TARGET];
	  var targetPrototype = target.prototype;

	  var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
	  var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;

	  for (key in source) {
	    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
	    // contains in native
	    USE_NATIVE = !FORCED && nativeSource && hasOwn$c(nativeSource, key);

	    targetProperty = target[key];

	    if (USE_NATIVE) if (options.dontCallGetSet) {
	      descriptor = getOwnPropertyDescriptor$5(nativeSource, key);
	      nativeProperty = descriptor && descriptor.value;
	    } else nativeProperty = nativeSource[key];

	    // export native or implementation
	    sourceProperty = (USE_NATIVE && nativeProperty) ? nativeProperty : source[key];

	    if (USE_NATIVE && typeof targetProperty == typeof sourceProperty) continue;

	    // bind methods to global for calling from export context
	    if (options.bind && USE_NATIVE) resultProperty = bind$e(sourceProperty, global$c);
	    // wrap global constructors for prevent changes in this version
	    else if (options.wrap && USE_NATIVE) resultProperty = wrapConstructor(sourceProperty);
	    // make static versions for prototype methods
	    else if (PROTO && isCallable$b(sourceProperty)) resultProperty = uncurryThis$p(sourceProperty);
	    // default case
	    else resultProperty = sourceProperty;

	    // add a flag to not completely full polyfills
	    if (options.sham || (sourceProperty && sourceProperty.sham) || (targetProperty && targetProperty.sham)) {
	      createNonEnumerableProperty$5(resultProperty, 'sham', true);
	    }

	    createNonEnumerableProperty$5(target, key, resultProperty);

	    if (PROTO) {
	      VIRTUAL_PROTOTYPE = TARGET + 'Prototype';
	      if (!hasOwn$c(path$p, VIRTUAL_PROTOTYPE)) {
	        createNonEnumerableProperty$5(path$p, VIRTUAL_PROTOTYPE, {});
	      }
	      // export virtual prototype methods
	      createNonEnumerableProperty$5(path$p[VIRTUAL_PROTOTYPE], key, sourceProperty);
	      // export real prototype methods
	      if (options.real && targetPrototype && (FORCED || !targetPrototype[key])) {
	        createNonEnumerableProperty$5(targetPrototype, key, sourceProperty);
	      }
	    }
	  }
	};

	var uncurryThis$o = functionUncurryThis;

	var arraySlice$5 = uncurryThis$o([].slice);

	var uncurryThis$n = functionUncurryThis;
	var aCallable$4 = aCallable$7;
	var isObject$b = isObject$g;
	var hasOwn$b = hasOwnProperty_1;
	var arraySlice$4 = arraySlice$5;
	var NATIVE_BIND = functionBindNative;

	var $Function = Function;
	var concat$6 = uncurryThis$n([].concat);
	var join = uncurryThis$n([].join);
	var factories = {};

	var construct$3 = function (C, argsLength, args) {
	  if (!hasOwn$b(factories, argsLength)) {
	    for (var list = [], i = 0; i < argsLength; i++) list[i] = 'a[' + i + ']';
	    factories[argsLength] = $Function('C,a', 'return new C(' + join(list, ',') + ')');
	  } return factories[argsLength](C, args);
	};

	// `Function.prototype.bind` method implementation
	// https://tc39.es/ecma262/#sec-function.prototype.bind
	// eslint-disable-next-line es/no-function-prototype-bind -- detection
	var functionBind = NATIVE_BIND ? $Function.bind : function bind(that /* , ...args */) {
	  var F = aCallable$4(this);
	  var Prototype = F.prototype;
	  var partArgs = arraySlice$4(arguments, 1);
	  var boundFunction = function bound(/* args... */) {
	    var args = concat$6(partArgs, arraySlice$4(arguments));
	    return this instanceof boundFunction ? construct$3(F, args.length, args) : F.apply(that, args);
	  };
	  if (isObject$b(Prototype)) boundFunction.prototype = Prototype;
	  return boundFunction;
	};

	var wellKnownSymbol$j = wellKnownSymbol$l;

	var TO_STRING_TAG$3 = wellKnownSymbol$j('toStringTag');
	var test$2 = {};

	test$2[TO_STRING_TAG$3] = 'z';

	var toStringTagSupport = String(test$2) === '[object z]';

	var TO_STRING_TAG_SUPPORT$2 = toStringTagSupport;
	var isCallable$a = isCallable$i;
	var classofRaw = classofRaw$2;
	var wellKnownSymbol$i = wellKnownSymbol$l;

	var TO_STRING_TAG$2 = wellKnownSymbol$i('toStringTag');
	var $Object$1 = Object;

	// ES3 wrong here
	var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) == 'Arguments';

	// fallback for IE11 Script Access Denied error
	var tryGet = function (it, key) {
	  try {
	    return it[key];
	  } catch (error) { /* empty */ }
	};

	// getting tag from ES6+ `Object.prototype.toString`
	var classof$c = TO_STRING_TAG_SUPPORT$2 ? classofRaw : function (it) {
	  var O, tag, result;
	  return it === undefined ? 'Undefined' : it === null ? 'Null'
	    // @@toStringTag case
	    : typeof (tag = tryGet(O = $Object$1(it), TO_STRING_TAG$2)) == 'string' ? tag
	    // builtinTag case
	    : CORRECT_ARGUMENTS ? classofRaw(O)
	    // ES3 arguments fallback
	    : (result = classofRaw(O)) == 'Object' && isCallable$a(O.callee) ? 'Arguments' : result;
	};

	var uncurryThis$m = functionUncurryThis;
	var isCallable$9 = isCallable$i;
	var store$1 = sharedStore;

	var functionToString = uncurryThis$m(Function.toString);

	// this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper
	if (!isCallable$9(store$1.inspectSource)) {
	  store$1.inspectSource = function (it) {
	    return functionToString(it);
	  };
	}

	var inspectSource$1 = store$1.inspectSource;

	var uncurryThis$l = functionUncurryThis;
	var fails$m = fails$u;
	var isCallable$8 = isCallable$i;
	var classof$b = classof$c;
	var getBuiltIn$a = getBuiltIn$c;
	var inspectSource = inspectSource$1;

	var noop = function () { /* empty */ };
	var empty = [];
	var construct$2 = getBuiltIn$a('Reflect', 'construct');
	var constructorRegExp = /^\s*(?:class|function)\b/;
	var exec$2 = uncurryThis$l(constructorRegExp.exec);
	var INCORRECT_TO_STRING = !constructorRegExp.exec(noop);

	var isConstructorModern = function isConstructor(argument) {
	  if (!isCallable$8(argument)) return false;
	  try {
	    construct$2(noop, empty, argument);
	    return true;
	  } catch (error) {
	    return false;
	  }
	};

	var isConstructorLegacy = function isConstructor(argument) {
	  if (!isCallable$8(argument)) return false;
	  switch (classof$b(argument)) {
	    case 'AsyncFunction':
	    case 'GeneratorFunction':
	    case 'AsyncGeneratorFunction': return false;
	  }
	  try {
	    // we can't check .prototype since constructors produced by .bind haven't it
	    // `Function#toString` throws on some built-it function in some legacy engines
	    // (for example, `DOMQuad` and similar in FF41-)
	    return INCORRECT_TO_STRING || !!exec$2(constructorRegExp, inspectSource(argument));
	  } catch (error) {
	    return true;
	  }
	};

	isConstructorLegacy.sham = true;

	// `IsConstructor` abstract operation
	// https://tc39.es/ecma262/#sec-isconstructor
	var isConstructor$4 = !construct$2 || fails$m(function () {
	  var called;
	  return isConstructorModern(isConstructorModern.call)
	    || !isConstructorModern(Object)
	    || !isConstructorModern(function () { called = true; })
	    || called;
	}) ? isConstructorLegacy : isConstructorModern;

	var isConstructor$3 = isConstructor$4;
	var tryToString$4 = tryToString$6;

	var $TypeError$a = TypeError;

	// `Assert: IsConstructor(argument) is true`
	var aConstructor$1 = function (argument) {
	  if (isConstructor$3(argument)) return argument;
	  throw $TypeError$a(tryToString$4(argument) + ' is not a constructor');
	};

	var objectDefineProperties = {};

	var ceil = Math.ceil;
	var floor$1 = Math.floor;

	// `Math.trunc` method
	// https://tc39.es/ecma262/#sec-math.trunc
	// eslint-disable-next-line es/no-math-trunc -- safe
	var mathTrunc = Math.trunc || function trunc(x) {
	  var n = +x;
	  return (n > 0 ? floor$1 : ceil)(n);
	};

	var trunc = mathTrunc;

	// `ToIntegerOrInfinity` abstract operation
	// https://tc39.es/ecma262/#sec-tointegerorinfinity
	var toIntegerOrInfinity$5 = function (argument) {
	  var number = +argument;
	  // eslint-disable-next-line no-self-compare -- NaN check
	  return number !== number || number === 0 ? 0 : trunc(number);
	};

	var toIntegerOrInfinity$4 = toIntegerOrInfinity$5;

	var max$3 = Math.max;
	var min$2 = Math.min;

	// Helper for a popular repeating case of the spec:
	// Let integer be ? ToInteger(index).
	// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
	var toAbsoluteIndex$5 = function (index, length) {
	  var integer = toIntegerOrInfinity$4(index);
	  return integer < 0 ? max$3(integer + length, 0) : min$2(integer, length);
	};

	var toIntegerOrInfinity$3 = toIntegerOrInfinity$5;

	var min$1 = Math.min;

	// `ToLength` abstract operation
	// https://tc39.es/ecma262/#sec-tolength
	var toLength$1 = function (argument) {
	  return argument > 0 ? min$1(toIntegerOrInfinity$3(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
	};

	var toLength = toLength$1;

	// `LengthOfArrayLike` abstract operation
	// https://tc39.es/ecma262/#sec-lengthofarraylike
	var lengthOfArrayLike$b = function (obj) {
	  return toLength(obj.length);
	};

	var toIndexedObject$9 = toIndexedObject$b;
	var toAbsoluteIndex$4 = toAbsoluteIndex$5;
	var lengthOfArrayLike$a = lengthOfArrayLike$b;

	// `Array.prototype.{ indexOf, includes }` methods implementation
	var createMethod$5 = function (IS_INCLUDES) {
	  return function ($this, el, fromIndex) {
	    var O = toIndexedObject$9($this);
	    var length = lengthOfArrayLike$a(O);
	    var index = toAbsoluteIndex$4(fromIndex, length);
	    var value;
	    // Array#includes uses SameValueZero equality algorithm
	    // eslint-disable-next-line no-self-compare -- NaN check
	    if (IS_INCLUDES && el != el) while (length > index) {
	      value = O[index++];
	      // eslint-disable-next-line no-self-compare -- NaN check
	      if (value != value) return true;
	    // Array#indexOf ignores holes, Array#includes - not
	    } else for (;length > index; index++) {
	      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
	    } return !IS_INCLUDES && -1;
	  };
	};

	var arrayIncludes = {
	  // `Array.prototype.includes` method
	  // https://tc39.es/ecma262/#sec-array.prototype.includes
	  includes: createMethod$5(true),
	  // `Array.prototype.indexOf` method
	  // https://tc39.es/ecma262/#sec-array.prototype.indexof
	  indexOf: createMethod$5(false)
	};

	var hiddenKeys$6 = {};

	var uncurryThis$k = functionUncurryThis;
	var hasOwn$a = hasOwnProperty_1;
	var toIndexedObject$8 = toIndexedObject$b;
	var indexOf$4 = arrayIncludes.indexOf;
	var hiddenKeys$5 = hiddenKeys$6;

	var push$6 = uncurryThis$k([].push);

	var objectKeysInternal = function (object, names) {
	  var O = toIndexedObject$8(object);
	  var i = 0;
	  var result = [];
	  var key;
	  for (key in O) !hasOwn$a(hiddenKeys$5, key) && hasOwn$a(O, key) && push$6(result, key);
	  // Don't enum bug & hidden keys
	  while (names.length > i) if (hasOwn$a(O, key = names[i++])) {
	    ~indexOf$4(result, key) || push$6(result, key);
	  }
	  return result;
	};

	// IE8- don't enum bug keys
	var enumBugKeys$3 = [
	  'constructor',
	  'hasOwnProperty',
	  'isPrototypeOf',
	  'propertyIsEnumerable',
	  'toLocaleString',
	  'toString',
	  'valueOf'
	];

	var internalObjectKeys$1 = objectKeysInternal;
	var enumBugKeys$2 = enumBugKeys$3;

	// `Object.keys` method
	// https://tc39.es/ecma262/#sec-object.keys
	// eslint-disable-next-line es/no-object-keys -- safe
	var objectKeys$4 = Object.keys || function keys(O) {
	  return internalObjectKeys$1(O, enumBugKeys$2);
	};

	var DESCRIPTORS$d = descriptors;
	var V8_PROTOTYPE_DEFINE_BUG = v8PrototypeDefineBug;
	var definePropertyModule$2 = objectDefineProperty;
	var anObject$9 = anObject$b;
	var toIndexedObject$7 = toIndexedObject$b;
	var objectKeys$3 = objectKeys$4;

	// `Object.defineProperties` method
	// https://tc39.es/ecma262/#sec-object.defineproperties
	// eslint-disable-next-line es/no-object-defineproperties -- safe
	objectDefineProperties.f = DESCRIPTORS$d && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
	  anObject$9(O);
	  var props = toIndexedObject$7(Properties);
	  var keys = objectKeys$3(Properties);
	  var length = keys.length;
	  var index = 0;
	  var key;
	  while (length > index) definePropertyModule$2.f(O, key = keys[index++], props[key]);
	  return O;
	};

	var getBuiltIn$9 = getBuiltIn$c;

	var html$1 = getBuiltIn$9('document', 'documentElement');

	var shared$5 = sharedExports;
	var uid$2 = uid$4;

	var keys$3 = shared$5('keys');

	var sharedKey$4 = function (key) {
	  return keys$3[key] || (keys$3[key] = uid$2(key));
	};

	/* global ActiveXObject -- old IE, WSH */

	var anObject$8 = anObject$b;
	var definePropertiesModule$1 = objectDefineProperties;
	var enumBugKeys$1 = enumBugKeys$3;
	var hiddenKeys$4 = hiddenKeys$6;
	var html = html$1;
	var documentCreateElement = documentCreateElement$1;
	var sharedKey$3 = sharedKey$4;

	var GT = '>';
	var LT = '<';
	var PROTOTYPE$1 = 'prototype';
	var SCRIPT = 'script';
	var IE_PROTO$1 = sharedKey$3('IE_PROTO');

	var EmptyConstructor = function () { /* empty */ };

	var scriptTag = function (content) {
	  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
	};

	// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
	var NullProtoObjectViaActiveX = function (activeXDocument) {
	  activeXDocument.write(scriptTag(''));
	  activeXDocument.close();
	  var temp = activeXDocument.parentWindow.Object;
	  activeXDocument = null; // avoid memory leak
	  return temp;
	};

	// Create object with fake `null` prototype: use iframe Object with cleared prototype
	var NullProtoObjectViaIFrame = function () {
	  // Thrash, waste and sodomy: IE GC bug
	  var iframe = documentCreateElement('iframe');
	  var JS = 'java' + SCRIPT + ':';
	  var iframeDocument;
	  iframe.style.display = 'none';
	  html.appendChild(iframe);
	  // https://github.com/zloirock/core-js/issues/475
	  iframe.src = String(JS);
	  iframeDocument = iframe.contentWindow.document;
	  iframeDocument.open();
	  iframeDocument.write(scriptTag('document.F=Object'));
	  iframeDocument.close();
	  return iframeDocument.F;
	};

	// Check for document.domain and active x support
	// No need to use active x approach when document.domain is not set
	// see https://github.com/es-shims/es5-shim/issues/150
	// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
	// avoid IE GC bug
	var activeXDocument;
	var NullProtoObject = function () {
	  try {
	    activeXDocument = new ActiveXObject('htmlfile');
	  } catch (error) { /* ignore */ }
	  NullProtoObject = typeof document != 'undefined'
	    ? document.domain && activeXDocument
	      ? NullProtoObjectViaActiveX(activeXDocument) // old IE
	      : NullProtoObjectViaIFrame()
	    : NullProtoObjectViaActiveX(activeXDocument); // WSH
	  var length = enumBugKeys$1.length;
	  while (length--) delete NullProtoObject[PROTOTYPE$1][enumBugKeys$1[length]];
	  return NullProtoObject();
	};

	hiddenKeys$4[IE_PROTO$1] = true;

	// `Object.create` method
	// https://tc39.es/ecma262/#sec-object.create
	// eslint-disable-next-line es/no-object-create -- safe
	var objectCreate = Object.create || function create(O, Properties) {
	  var result;
	  if (O !== null) {
	    EmptyConstructor[PROTOTYPE$1] = anObject$8(O);
	    result = new EmptyConstructor();
	    EmptyConstructor[PROTOTYPE$1] = null;
	    // add "__proto__" for Object.getPrototypeOf polyfill
	    result[IE_PROTO$1] = O;
	  } else result = NullProtoObject();
	  return Properties === undefined ? result : definePropertiesModule$1.f(result, Properties);
	};

	var $$M = _export;
	var getBuiltIn$8 = getBuiltIn$c;
	var apply$3 = functionApply;
	var bind$d = functionBind;
	var aConstructor = aConstructor$1;
	var anObject$7 = anObject$b;
	var isObject$a = isObject$g;
	var create$b = objectCreate;
	var fails$l = fails$u;

	var nativeConstruct = getBuiltIn$8('Reflect', 'construct');
	var ObjectPrototype$2 = Object.prototype;
	var push$5 = [].push;

	// `Reflect.construct` method
	// https://tc39.es/ecma262/#sec-reflect.construct
	// MS Edge supports only 2 arguments and argumentsList argument is optional
	// FF Nightly sets third argument as `new.target`, but does not create `this` from it
	var NEW_TARGET_BUG = fails$l(function () {
	  function F() { /* empty */ }
	  return !(nativeConstruct(function () { /* empty */ }, [], F) instanceof F);
	});

	var ARGS_BUG = !fails$l(function () {
	  nativeConstruct(function () { /* empty */ });
	});

	var FORCED$8 = NEW_TARGET_BUG || ARGS_BUG;

	$$M({ target: 'Reflect', stat: true, forced: FORCED$8, sham: FORCED$8 }, {
	  construct: function construct(Target, args /* , newTarget */) {
	    aConstructor(Target);
	    anObject$7(args);
	    var newTarget = arguments.length < 3 ? Target : aConstructor(arguments[2]);
	    if (ARGS_BUG && !NEW_TARGET_BUG) return nativeConstruct(Target, args, newTarget);
	    if (Target == newTarget) {
	      // w/o altered newTarget, optimization for 0-4 arguments
	      switch (args.length) {
	        case 0: return new Target();
	        case 1: return new Target(args[0]);
	        case 2: return new Target(args[0], args[1]);
	        case 3: return new Target(args[0], args[1], args[2]);
	        case 4: return new Target(args[0], args[1], args[2], args[3]);
	      }
	      // w/o altered newTarget, lot of arguments case
	      var $args = [null];
	      apply$3(push$5, $args, args);
	      return new (apply$3(bind$d, Target, $args))();
	    }
	    // with altered newTarget, not support built-in constructors
	    var proto = newTarget.prototype;
	    var instance = create$b(isObject$a(proto) ? proto : ObjectPrototype$2);
	    var result = apply$3(Target, instance, args);
	    return isObject$a(result) ? result : instance;
	  }
	});

	var path$o = path$r;

	var construct$1 = path$o.Reflect.construct;

	var parent$12 = construct$1;

	var construct = parent$12;

	(function (module) {
		module.exports = construct;
	} (construct$4));

	var _Reflect$construct = /*@__PURE__*/getDefaultExportFromCjs(constructExports);

	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	var definePropertyExports$3 = {};
	var defineProperty$e = {
	  get exports(){ return definePropertyExports$3; },
	  set exports(v){ definePropertyExports$3 = v; },
	};

	var definePropertyExports$2 = {};
	var defineProperty$d = {
	  get exports(){ return definePropertyExports$2; },
	  set exports(v){ definePropertyExports$2 = v; },
	};

	var definePropertyExports$1 = {};
	var defineProperty$c = {
	  get exports(){ return definePropertyExports$1; },
	  set exports(v){ definePropertyExports$1 = v; },
	};

	var $$L = _export;
	var DESCRIPTORS$c = descriptors;
	var defineProperty$b = objectDefineProperty.f;

	// `Object.defineProperty` method
	// https://tc39.es/ecma262/#sec-object.defineproperty
	// eslint-disable-next-line es/no-object-defineproperty -- safe
	$$L({ target: 'Object', stat: true, forced: Object.defineProperty !== defineProperty$b, sham: !DESCRIPTORS$c }, {
	  defineProperty: defineProperty$b
	});

	var path$n = path$r;

	var Object$4 = path$n.Object;

	var defineProperty$a = defineProperty$c.exports = function defineProperty(it, key, desc) {
	  return Object$4.defineProperty(it, key, desc);
	};

	if (Object$4.defineProperty.sham) defineProperty$a.sham = true;

	var parent$11 = definePropertyExports$1;

	var defineProperty$9 = parent$11;

	var parent$10 = defineProperty$9;

	var defineProperty$8 = parent$10;

	var parent$$ = defineProperty$8;

	var defineProperty$7 = parent$$;

	(function (module) {
		module.exports = defineProperty$7;
	} (defineProperty$d));

	(function (module) {
		module.exports = definePropertyExports$2;
	} (defineProperty$e));

	var _Object$defineProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(definePropertyExports$3);

	var symbolExports$2 = {};
	var symbol$6 = {
	  get exports(){ return symbolExports$2; },
	  set exports(v){ symbolExports$2 = v; },
	};

	var symbolExports$1 = {};
	var symbol$5 = {
	  get exports(){ return symbolExports$1; },
	  set exports(v){ symbolExports$1 = v; },
	};

	var classof$a = classofRaw$2;

	// `IsArray` abstract operation
	// https://tc39.es/ecma262/#sec-isarray
	// eslint-disable-next-line es/no-array-isarray -- safe
	var isArray$e = Array.isArray || function isArray(argument) {
	  return classof$a(argument) == 'Array';
	};

	var $TypeError$9 = TypeError;
	var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF; // 2 ** 53 - 1 == 9007199254740991

	var doesNotExceedSafeInteger$2 = function (it) {
	  if (it > MAX_SAFE_INTEGER) throw $TypeError$9('Maximum allowed index exceeded');
	  return it;
	};

	var toPropertyKey$1 = toPropertyKey$4;
	var definePropertyModule$1 = objectDefineProperty;
	var createPropertyDescriptor$2 = createPropertyDescriptor$5;

	var createProperty$6 = function (object, key, value) {
	  var propertyKey = toPropertyKey$1(key);
	  if (propertyKey in object) definePropertyModule$1.f(object, propertyKey, createPropertyDescriptor$2(0, value));
	  else object[propertyKey] = value;
	};

	var isArray$d = isArray$e;
	var isConstructor$2 = isConstructor$4;
	var isObject$9 = isObject$g;
	var wellKnownSymbol$h = wellKnownSymbol$l;

	var SPECIES$3 = wellKnownSymbol$h('species');
	var $Array$3 = Array;

	// a part of `ArraySpeciesCreate` abstract operation
	// https://tc39.es/ecma262/#sec-arrayspeciescreate
	var arraySpeciesConstructor$1 = function (originalArray) {
	  var C;
	  if (isArray$d(originalArray)) {
	    C = originalArray.constructor;
	    // cross-realm fallback
	    if (isConstructor$2(C) && (C === $Array$3 || isArray$d(C.prototype))) C = undefined;
	    else if (isObject$9(C)) {
	      C = C[SPECIES$3];
	      if (C === null) C = undefined;
	    }
	  } return C === undefined ? $Array$3 : C;
	};

	var arraySpeciesConstructor = arraySpeciesConstructor$1;

	// `ArraySpeciesCreate` abstract operation
	// https://tc39.es/ecma262/#sec-arrayspeciescreate
	var arraySpeciesCreate$3 = function (originalArray, length) {
	  return new (arraySpeciesConstructor(originalArray))(length === 0 ? 0 : length);
	};

	var fails$k = fails$u;
	var wellKnownSymbol$g = wellKnownSymbol$l;
	var V8_VERSION$1 = engineV8Version;

	var SPECIES$2 = wellKnownSymbol$g('species');

	var arrayMethodHasSpeciesSupport$5 = function (METHOD_NAME) {
	  // We can't use this feature detection in V8 since it causes
	  // deoptimization and serious performance degradation
	  // https://github.com/zloirock/core-js/issues/677
	  return V8_VERSION$1 >= 51 || !fails$k(function () {
	    var array = [];
	    var constructor = array.constructor = {};
	    constructor[SPECIES$2] = function () {
	      return { foo: 1 };
	    };
	    return array[METHOD_NAME](Boolean).foo !== 1;
	  });
	};

	var $$K = _export;
	var fails$j = fails$u;
	var isArray$c = isArray$e;
	var isObject$8 = isObject$g;
	var toObject$b = toObject$d;
	var lengthOfArrayLike$9 = lengthOfArrayLike$b;
	var doesNotExceedSafeInteger$1 = doesNotExceedSafeInteger$2;
	var createProperty$5 = createProperty$6;
	var arraySpeciesCreate$2 = arraySpeciesCreate$3;
	var arrayMethodHasSpeciesSupport$4 = arrayMethodHasSpeciesSupport$5;
	var wellKnownSymbol$f = wellKnownSymbol$l;
	var V8_VERSION = engineV8Version;

	var IS_CONCAT_SPREADABLE = wellKnownSymbol$f('isConcatSpreadable');

	// We can't use this feature detection in V8 since it causes
	// deoptimization and serious performance degradation
	// https://github.com/zloirock/core-js/issues/679
	var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION >= 51 || !fails$j(function () {
	  var array = [];
	  array[IS_CONCAT_SPREADABLE] = false;
	  return array.concat()[0] !== array;
	});

	var isConcatSpreadable = function (O) {
	  if (!isObject$8(O)) return false;
	  var spreadable = O[IS_CONCAT_SPREADABLE];
	  return spreadable !== undefined ? !!spreadable : isArray$c(O);
	};

	var FORCED$7 = !IS_CONCAT_SPREADABLE_SUPPORT || !arrayMethodHasSpeciesSupport$4('concat');

	// `Array.prototype.concat` method
	// https://tc39.es/ecma262/#sec-array.prototype.concat
	// with adding support of @@isConcatSpreadable and @@species
	$$K({ target: 'Array', proto: true, arity: 1, forced: FORCED$7 }, {
	  // eslint-disable-next-line no-unused-vars -- required for `.length`
	  concat: function concat(arg) {
	    var O = toObject$b(this);
	    var A = arraySpeciesCreate$2(O, 0);
	    var n = 0;
	    var i, k, length, len, E;
	    for (i = -1, length = arguments.length; i < length; i++) {
	      E = i === -1 ? O : arguments[i];
	      if (isConcatSpreadable(E)) {
	        len = lengthOfArrayLike$9(E);
	        doesNotExceedSafeInteger$1(n + len);
	        for (k = 0; k < len; k++, n++) if (k in E) createProperty$5(A, n, E[k]);
	      } else {
	        doesNotExceedSafeInteger$1(n + 1);
	        createProperty$5(A, n++, E);
	      }
	    }
	    A.length = n;
	    return A;
	  }
	});

	var classof$9 = classof$c;

	var $String$2 = String;

	var toString$b = function (argument) {
	  if (classof$9(argument) === 'Symbol') throw TypeError('Cannot convert a Symbol value to a string');
	  return $String$2(argument);
	};

	var objectGetOwnPropertyNames = {};

	var internalObjectKeys = objectKeysInternal;
	var enumBugKeys = enumBugKeys$3;

	var hiddenKeys$3 = enumBugKeys.concat('length', 'prototype');

	// `Object.getOwnPropertyNames` method
	// https://tc39.es/ecma262/#sec-object.getownpropertynames
	// eslint-disable-next-line es/no-object-getownpropertynames -- safe
	objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
	  return internalObjectKeys(O, hiddenKeys$3);
	};

	var objectGetOwnPropertyNamesExternal = {};

	var toAbsoluteIndex$3 = toAbsoluteIndex$5;
	var lengthOfArrayLike$8 = lengthOfArrayLike$b;
	var createProperty$4 = createProperty$6;

	var $Array$2 = Array;
	var max$2 = Math.max;

	var arraySliceSimple = function (O, start, end) {
	  var length = lengthOfArrayLike$8(O);
	  var k = toAbsoluteIndex$3(start, length);
	  var fin = toAbsoluteIndex$3(end === undefined ? length : end, length);
	  var result = $Array$2(max$2(fin - k, 0));
	  for (var n = 0; k < fin; k++, n++) createProperty$4(result, n, O[k]);
	  result.length = n;
	  return result;
	};

	/* eslint-disable es/no-object-getownpropertynames -- safe */

	var classof$8 = classofRaw$2;
	var toIndexedObject$6 = toIndexedObject$b;
	var $getOwnPropertyNames$1 = objectGetOwnPropertyNames.f;
	var arraySlice$3 = arraySliceSimple;

	var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
	  ? Object.getOwnPropertyNames(window) : [];

	var getWindowNames = function (it) {
	  try {
	    return $getOwnPropertyNames$1(it);
	  } catch (error) {
	    return arraySlice$3(windowNames);
	  }
	};

	// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
	objectGetOwnPropertyNamesExternal.f = function getOwnPropertyNames(it) {
	  return windowNames && classof$8(it) == 'Window'
	    ? getWindowNames(it)
	    : $getOwnPropertyNames$1(toIndexedObject$6(it));
	};

	var objectGetOwnPropertySymbols = {};

	// eslint-disable-next-line es/no-object-getownpropertysymbols -- safe
	objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;

	var createNonEnumerableProperty$4 = createNonEnumerableProperty$6;

	var defineBuiltIn$5 = function (target, key, value, options) {
	  if (options && options.enumerable) target[key] = value;
	  else createNonEnumerableProperty$4(target, key, value);
	  return target;
	};

	var defineProperty$6 = objectDefineProperty;

	var defineBuiltInAccessor$3 = function (target, name, descriptor) {
	  return defineProperty$6.f(target, name, descriptor);
	};

	var wellKnownSymbolWrapped = {};

	var wellKnownSymbol$e = wellKnownSymbol$l;

	wellKnownSymbolWrapped.f = wellKnownSymbol$e;

	var path$m = path$r;
	var hasOwn$9 = hasOwnProperty_1;
	var wrappedWellKnownSymbolModule$1 = wellKnownSymbolWrapped;
	var defineProperty$5 = objectDefineProperty.f;

	var wellKnownSymbolDefine = function (NAME) {
	  var Symbol = path$m.Symbol || (path$m.Symbol = {});
	  if (!hasOwn$9(Symbol, NAME)) defineProperty$5(Symbol, NAME, {
	    value: wrappedWellKnownSymbolModule$1.f(NAME)
	  });
	};

	var call$8 = functionCall;
	var getBuiltIn$7 = getBuiltIn$c;
	var wellKnownSymbol$d = wellKnownSymbol$l;
	var defineBuiltIn$4 = defineBuiltIn$5;

	var symbolDefineToPrimitive = function () {
	  var Symbol = getBuiltIn$7('Symbol');
	  var SymbolPrototype = Symbol && Symbol.prototype;
	  var valueOf = SymbolPrototype && SymbolPrototype.valueOf;
	  var TO_PRIMITIVE = wellKnownSymbol$d('toPrimitive');

	  if (SymbolPrototype && !SymbolPrototype[TO_PRIMITIVE]) {
	    // `Symbol.prototype[@@toPrimitive]` method
	    // https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
	    // eslint-disable-next-line no-unused-vars -- required for .length
	    defineBuiltIn$4(SymbolPrototype, TO_PRIMITIVE, function (hint) {
	      return call$8(valueOf, this);
	    }, { arity: 1 });
	  }
	};

	var TO_STRING_TAG_SUPPORT$1 = toStringTagSupport;
	var classof$7 = classof$c;

	// `Object.prototype.toString` method implementation
	// https://tc39.es/ecma262/#sec-object.prototype.tostring
	var objectToString = TO_STRING_TAG_SUPPORT$1 ? {}.toString : function toString() {
	  return '[object ' + classof$7(this) + ']';
	};

	var TO_STRING_TAG_SUPPORT = toStringTagSupport;
	var defineProperty$4 = objectDefineProperty.f;
	var createNonEnumerableProperty$3 = createNonEnumerableProperty$6;
	var hasOwn$8 = hasOwnProperty_1;
	var toString$a = objectToString;
	var wellKnownSymbol$c = wellKnownSymbol$l;

	var TO_STRING_TAG$1 = wellKnownSymbol$c('toStringTag');

	var setToStringTag$6 = function (it, TAG, STATIC, SET_METHOD) {
	  if (it) {
	    var target = STATIC ? it : it.prototype;
	    if (!hasOwn$8(target, TO_STRING_TAG$1)) {
	      defineProperty$4(target, TO_STRING_TAG$1, { configurable: true, value: TAG });
	    }
	    if (SET_METHOD && !TO_STRING_TAG_SUPPORT) {
	      createNonEnumerableProperty$3(target, 'toString', toString$a);
	    }
	  }
	};

	var global$b = global$j;
	var isCallable$7 = isCallable$i;

	var WeakMap$1 = global$b.WeakMap;

	var weakMapBasicDetection = isCallable$7(WeakMap$1) && /native code/.test(String(WeakMap$1));

	var NATIVE_WEAK_MAP = weakMapBasicDetection;
	var global$a = global$j;
	var isObject$7 = isObject$g;
	var createNonEnumerableProperty$2 = createNonEnumerableProperty$6;
	var hasOwn$7 = hasOwnProperty_1;
	var shared$4 = sharedStore;
	var sharedKey$2 = sharedKey$4;
	var hiddenKeys$2 = hiddenKeys$6;

	var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
	var TypeError$2 = global$a.TypeError;
	var WeakMap = global$a.WeakMap;
	var set$3, get, has;

	var enforce = function (it) {
	  return has(it) ? get(it) : set$3(it, {});
	};

	var getterFor = function (TYPE) {
	  return function (it) {
	    var state;
	    if (!isObject$7(it) || (state = get(it)).type !== TYPE) {
	      throw TypeError$2('Incompatible receiver, ' + TYPE + ' required');
	    } return state;
	  };
	};

	if (NATIVE_WEAK_MAP || shared$4.state) {
	  var store = shared$4.state || (shared$4.state = new WeakMap());
	  /* eslint-disable no-self-assign -- prototype methods protection */
	  store.get = store.get;
	  store.has = store.has;
	  store.set = store.set;
	  /* eslint-enable no-self-assign -- prototype methods protection */
	  set$3 = function (it, metadata) {
	    if (store.has(it)) throw TypeError$2(OBJECT_ALREADY_INITIALIZED);
	    metadata.facade = it;
	    store.set(it, metadata);
	    return metadata;
	  };
	  get = function (it) {
	    return store.get(it) || {};
	  };
	  has = function (it) {
	    return store.has(it);
	  };
	} else {
	  var STATE = sharedKey$2('state');
	  hiddenKeys$2[STATE] = true;
	  set$3 = function (it, metadata) {
	    if (hasOwn$7(it, STATE)) throw TypeError$2(OBJECT_ALREADY_INITIALIZED);
	    metadata.facade = it;
	    createNonEnumerableProperty$2(it, STATE, metadata);
	    return metadata;
	  };
	  get = function (it) {
	    return hasOwn$7(it, STATE) ? it[STATE] : {};
	  };
	  has = function (it) {
	    return hasOwn$7(it, STATE);
	  };
	}

	var internalState = {
	  set: set$3,
	  get: get,
	  has: has,
	  enforce: enforce,
	  getterFor: getterFor
	};

	var bind$c = functionBindContext;
	var uncurryThis$j = functionUncurryThis;
	var IndexedObject$2 = indexedObject;
	var toObject$a = toObject$d;
	var lengthOfArrayLike$7 = lengthOfArrayLike$b;
	var arraySpeciesCreate$1 = arraySpeciesCreate$3;

	var push$4 = uncurryThis$j([].push);

	// `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterReject }` methods implementation
	var createMethod$4 = function (TYPE) {
	  var IS_MAP = TYPE == 1;
	  var IS_FILTER = TYPE == 2;
	  var IS_SOME = TYPE == 3;
	  var IS_EVERY = TYPE == 4;
	  var IS_FIND_INDEX = TYPE == 6;
	  var IS_FILTER_REJECT = TYPE == 7;
	  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
	  return function ($this, callbackfn, that, specificCreate) {
	    var O = toObject$a($this);
	    var self = IndexedObject$2(O);
	    var boundFunction = bind$c(callbackfn, that);
	    var length = lengthOfArrayLike$7(self);
	    var index = 0;
	    var create = specificCreate || arraySpeciesCreate$1;
	    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_REJECT ? create($this, 0) : undefined;
	    var value, result;
	    for (;length > index; index++) if (NO_HOLES || index in self) {
	      value = self[index];
	      result = boundFunction(value, index, O);
	      if (TYPE) {
	        if (IS_MAP) target[index] = result; // map
	        else if (result) switch (TYPE) {
	          case 3: return true;              // some
	          case 5: return value;             // find
	          case 6: return index;             // findIndex
	          case 2: push$4(target, value);      // filter
	        } else switch (TYPE) {
	          case 4: return false;             // every
	          case 7: push$4(target, value);      // filterReject
	        }
	      }
	    }
	    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
	  };
	};

	var arrayIteration = {
	  // `Array.prototype.forEach` method
	  // https://tc39.es/ecma262/#sec-array.prototype.foreach
	  forEach: createMethod$4(0),
	  // `Array.prototype.map` method
	  // https://tc39.es/ecma262/#sec-array.prototype.map
	  map: createMethod$4(1),
	  // `Array.prototype.filter` method
	  // https://tc39.es/ecma262/#sec-array.prototype.filter
	  filter: createMethod$4(2),
	  // `Array.prototype.some` method
	  // https://tc39.es/ecma262/#sec-array.prototype.some
	  some: createMethod$4(3),
	  // `Array.prototype.every` method
	  // https://tc39.es/ecma262/#sec-array.prototype.every
	  every: createMethod$4(4),
	  // `Array.prototype.find` method
	  // https://tc39.es/ecma262/#sec-array.prototype.find
	  find: createMethod$4(5),
	  // `Array.prototype.findIndex` method
	  // https://tc39.es/ecma262/#sec-array.prototype.findIndex
	  findIndex: createMethod$4(6),
	  // `Array.prototype.filterReject` method
	  // https://github.com/tc39/proposal-array-filtering
	  filterReject: createMethod$4(7)
	};

	var $$J = _export;
	var global$9 = global$j;
	var call$7 = functionCall;
	var uncurryThis$i = functionUncurryThis;
	var DESCRIPTORS$b = descriptors;
	var NATIVE_SYMBOL$3 = symbolConstructorDetection;
	var fails$i = fails$u;
	var hasOwn$6 = hasOwnProperty_1;
	var isPrototypeOf$l = objectIsPrototypeOf;
	var anObject$6 = anObject$b;
	var toIndexedObject$5 = toIndexedObject$b;
	var toPropertyKey = toPropertyKey$4;
	var $toString = toString$b;
	var createPropertyDescriptor$1 = createPropertyDescriptor$5;
	var nativeObjectCreate = objectCreate;
	var objectKeys$2 = objectKeys$4;
	var getOwnPropertyNamesModule$2 = objectGetOwnPropertyNames;
	var getOwnPropertyNamesExternal = objectGetOwnPropertyNamesExternal;
	var getOwnPropertySymbolsModule$3 = objectGetOwnPropertySymbols;
	var getOwnPropertyDescriptorModule$1 = objectGetOwnPropertyDescriptor;
	var definePropertyModule = objectDefineProperty;
	var definePropertiesModule = objectDefineProperties;
	var propertyIsEnumerableModule$1 = objectPropertyIsEnumerable;
	var defineBuiltIn$3 = defineBuiltIn$5;
	var defineBuiltInAccessor$2 = defineBuiltInAccessor$3;
	var shared$3 = sharedExports;
	var sharedKey$1 = sharedKey$4;
	var hiddenKeys$1 = hiddenKeys$6;
	var uid$1 = uid$4;
	var wellKnownSymbol$b = wellKnownSymbol$l;
	var wrappedWellKnownSymbolModule = wellKnownSymbolWrapped;
	var defineWellKnownSymbol$l = wellKnownSymbolDefine;
	var defineSymbolToPrimitive$1 = symbolDefineToPrimitive;
	var setToStringTag$5 = setToStringTag$6;
	var InternalStateModule$4 = internalState;
	var $forEach$1 = arrayIteration.forEach;

	var HIDDEN = sharedKey$1('hidden');
	var SYMBOL = 'Symbol';
	var PROTOTYPE = 'prototype';

	var setInternalState$4 = InternalStateModule$4.set;
	var getInternalState$2 = InternalStateModule$4.getterFor(SYMBOL);

	var ObjectPrototype$1 = Object[PROTOTYPE];
	var $Symbol = global$9.Symbol;
	var SymbolPrototype = $Symbol && $Symbol[PROTOTYPE];
	var TypeError$1 = global$9.TypeError;
	var QObject = global$9.QObject;
	var nativeGetOwnPropertyDescriptor$1 = getOwnPropertyDescriptorModule$1.f;
	var nativeDefineProperty = definePropertyModule.f;
	var nativeGetOwnPropertyNames = getOwnPropertyNamesExternal.f;
	var nativePropertyIsEnumerable = propertyIsEnumerableModule$1.f;
	var push$3 = uncurryThis$i([].push);

	var AllSymbols = shared$3('symbols');
	var ObjectPrototypeSymbols = shared$3('op-symbols');
	var WellKnownSymbolsStore$1 = shared$3('wks');

	// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
	var USE_SETTER = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;

	// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
	var setSymbolDescriptor = DESCRIPTORS$b && fails$i(function () {
	  return nativeObjectCreate(nativeDefineProperty({}, 'a', {
	    get: function () { return nativeDefineProperty(this, 'a', { value: 7 }).a; }
	  })).a != 7;
	}) ? function (O, P, Attributes) {
	  var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor$1(ObjectPrototype$1, P);
	  if (ObjectPrototypeDescriptor) delete ObjectPrototype$1[P];
	  nativeDefineProperty(O, P, Attributes);
	  if (ObjectPrototypeDescriptor && O !== ObjectPrototype$1) {
	    nativeDefineProperty(ObjectPrototype$1, P, ObjectPrototypeDescriptor);
	  }
	} : nativeDefineProperty;

	var wrap = function (tag, description) {
	  var symbol = AllSymbols[tag] = nativeObjectCreate(SymbolPrototype);
	  setInternalState$4(symbol, {
	    type: SYMBOL,
	    tag: tag,
	    description: description
	  });
	  if (!DESCRIPTORS$b) symbol.description = description;
	  return symbol;
	};

	var $defineProperty = function defineProperty(O, P, Attributes) {
	  if (O === ObjectPrototype$1) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
	  anObject$6(O);
	  var key = toPropertyKey(P);
	  anObject$6(Attributes);
	  if (hasOwn$6(AllSymbols, key)) {
	    if (!Attributes.enumerable) {
	      if (!hasOwn$6(O, HIDDEN)) nativeDefineProperty(O, HIDDEN, createPropertyDescriptor$1(1, {}));
	      O[HIDDEN][key] = true;
	    } else {
	      if (hasOwn$6(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
	      Attributes = nativeObjectCreate(Attributes, { enumerable: createPropertyDescriptor$1(0, false) });
	    } return setSymbolDescriptor(O, key, Attributes);
	  } return nativeDefineProperty(O, key, Attributes);
	};

	var $defineProperties = function defineProperties(O, Properties) {
	  anObject$6(O);
	  var properties = toIndexedObject$5(Properties);
	  var keys = objectKeys$2(properties).concat($getOwnPropertySymbols(properties));
	  $forEach$1(keys, function (key) {
	    if (!DESCRIPTORS$b || call$7($propertyIsEnumerable$1, properties, key)) $defineProperty(O, key, properties[key]);
	  });
	  return O;
	};

	var $create = function create(O, Properties) {
	  return Properties === undefined ? nativeObjectCreate(O) : $defineProperties(nativeObjectCreate(O), Properties);
	};

	var $propertyIsEnumerable$1 = function propertyIsEnumerable(V) {
	  var P = toPropertyKey(V);
	  var enumerable = call$7(nativePropertyIsEnumerable, this, P);
	  if (this === ObjectPrototype$1 && hasOwn$6(AllSymbols, P) && !hasOwn$6(ObjectPrototypeSymbols, P)) return false;
	  return enumerable || !hasOwn$6(this, P) || !hasOwn$6(AllSymbols, P) || hasOwn$6(this, HIDDEN) && this[HIDDEN][P]
	    ? enumerable : true;
	};

	var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
	  var it = toIndexedObject$5(O);
	  var key = toPropertyKey(P);
	  if (it === ObjectPrototype$1 && hasOwn$6(AllSymbols, key) && !hasOwn$6(ObjectPrototypeSymbols, key)) return;
	  var descriptor = nativeGetOwnPropertyDescriptor$1(it, key);
	  if (descriptor && hasOwn$6(AllSymbols, key) && !(hasOwn$6(it, HIDDEN) && it[HIDDEN][key])) {
	    descriptor.enumerable = true;
	  }
	  return descriptor;
	};

	var $getOwnPropertyNames = function getOwnPropertyNames(O) {
	  var names = nativeGetOwnPropertyNames(toIndexedObject$5(O));
	  var result = [];
	  $forEach$1(names, function (key) {
	    if (!hasOwn$6(AllSymbols, key) && !hasOwn$6(hiddenKeys$1, key)) push$3(result, key);
	  });
	  return result;
	};

	var $getOwnPropertySymbols = function (O) {
	  var IS_OBJECT_PROTOTYPE = O === ObjectPrototype$1;
	  var names = nativeGetOwnPropertyNames(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject$5(O));
	  var result = [];
	  $forEach$1(names, function (key) {
	    if (hasOwn$6(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || hasOwn$6(ObjectPrototype$1, key))) {
	      push$3(result, AllSymbols[key]);
	    }
	  });
	  return result;
	};

	// `Symbol` constructor
	// https://tc39.es/ecma262/#sec-symbol-constructor
	if (!NATIVE_SYMBOL$3) {
	  $Symbol = function Symbol() {
	    if (isPrototypeOf$l(SymbolPrototype, this)) throw TypeError$1('Symbol is not a constructor');
	    var description = !arguments.length || arguments[0] === undefined ? undefined : $toString(arguments[0]);
	    var tag = uid$1(description);
	    var setter = function (value) {
	      if (this === ObjectPrototype$1) call$7(setter, ObjectPrototypeSymbols, value);
	      if (hasOwn$6(this, HIDDEN) && hasOwn$6(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
	      setSymbolDescriptor(this, tag, createPropertyDescriptor$1(1, value));
	    };
	    if (DESCRIPTORS$b && USE_SETTER) setSymbolDescriptor(ObjectPrototype$1, tag, { configurable: true, set: setter });
	    return wrap(tag, description);
	  };

	  SymbolPrototype = $Symbol[PROTOTYPE];

	  defineBuiltIn$3(SymbolPrototype, 'toString', function toString() {
	    return getInternalState$2(this).tag;
	  });

	  defineBuiltIn$3($Symbol, 'withoutSetter', function (description) {
	    return wrap(uid$1(description), description);
	  });

	  propertyIsEnumerableModule$1.f = $propertyIsEnumerable$1;
	  definePropertyModule.f = $defineProperty;
	  definePropertiesModule.f = $defineProperties;
	  getOwnPropertyDescriptorModule$1.f = $getOwnPropertyDescriptor;
	  getOwnPropertyNamesModule$2.f = getOwnPropertyNamesExternal.f = $getOwnPropertyNames;
	  getOwnPropertySymbolsModule$3.f = $getOwnPropertySymbols;

	  wrappedWellKnownSymbolModule.f = function (name) {
	    return wrap(wellKnownSymbol$b(name), name);
	  };

	  if (DESCRIPTORS$b) {
	    // https://github.com/tc39/proposal-Symbol-description
	    defineBuiltInAccessor$2(SymbolPrototype, 'description', {
	      configurable: true,
	      get: function description() {
	        return getInternalState$2(this).description;
	      }
	    });
	  }
	}

	$$J({ global: true, constructor: true, wrap: true, forced: !NATIVE_SYMBOL$3, sham: !NATIVE_SYMBOL$3 }, {
	  Symbol: $Symbol
	});

	$forEach$1(objectKeys$2(WellKnownSymbolsStore$1), function (name) {
	  defineWellKnownSymbol$l(name);
	});

	$$J({ target: SYMBOL, stat: true, forced: !NATIVE_SYMBOL$3 }, {
	  useSetter: function () { USE_SETTER = true; },
	  useSimple: function () { USE_SETTER = false; }
	});

	$$J({ target: 'Object', stat: true, forced: !NATIVE_SYMBOL$3, sham: !DESCRIPTORS$b }, {
	  // `Object.create` method
	  // https://tc39.es/ecma262/#sec-object.create
	  create: $create,
	  // `Object.defineProperty` method
	  // https://tc39.es/ecma262/#sec-object.defineproperty
	  defineProperty: $defineProperty,
	  // `Object.defineProperties` method
	  // https://tc39.es/ecma262/#sec-object.defineproperties
	  defineProperties: $defineProperties,
	  // `Object.getOwnPropertyDescriptor` method
	  // https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
	  getOwnPropertyDescriptor: $getOwnPropertyDescriptor
	});

	$$J({ target: 'Object', stat: true, forced: !NATIVE_SYMBOL$3 }, {
	  // `Object.getOwnPropertyNames` method
	  // https://tc39.es/ecma262/#sec-object.getownpropertynames
	  getOwnPropertyNames: $getOwnPropertyNames
	});

	// `Symbol.prototype[@@toPrimitive]` method
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
	defineSymbolToPrimitive$1();

	// `Symbol.prototype[@@toStringTag]` property
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
	setToStringTag$5($Symbol, SYMBOL);

	hiddenKeys$1[HIDDEN] = true;

	var NATIVE_SYMBOL$2 = symbolConstructorDetection;

	/* eslint-disable es/no-symbol -- safe */
	var symbolRegistryDetection = NATIVE_SYMBOL$2 && !!Symbol['for'] && !!Symbol.keyFor;

	var $$I = _export;
	var getBuiltIn$6 = getBuiltIn$c;
	var hasOwn$5 = hasOwnProperty_1;
	var toString$9 = toString$b;
	var shared$2 = sharedExports;
	var NATIVE_SYMBOL_REGISTRY$1 = symbolRegistryDetection;

	var StringToSymbolRegistry = shared$2('string-to-symbol-registry');
	var SymbolToStringRegistry$1 = shared$2('symbol-to-string-registry');

	// `Symbol.for` method
	// https://tc39.es/ecma262/#sec-symbol.for
	$$I({ target: 'Symbol', stat: true, forced: !NATIVE_SYMBOL_REGISTRY$1 }, {
	  'for': function (key) {
	    var string = toString$9(key);
	    if (hasOwn$5(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
	    var symbol = getBuiltIn$6('Symbol')(string);
	    StringToSymbolRegistry[string] = symbol;
	    SymbolToStringRegistry$1[symbol] = string;
	    return symbol;
	  }
	});

	var $$H = _export;
	var hasOwn$4 = hasOwnProperty_1;
	var isSymbol$2 = isSymbol$5;
	var tryToString$3 = tryToString$6;
	var shared$1 = sharedExports;
	var NATIVE_SYMBOL_REGISTRY = symbolRegistryDetection;

	var SymbolToStringRegistry = shared$1('symbol-to-string-registry');

	// `Symbol.keyFor` method
	// https://tc39.es/ecma262/#sec-symbol.keyfor
	$$H({ target: 'Symbol', stat: true, forced: !NATIVE_SYMBOL_REGISTRY }, {
	  keyFor: function keyFor(sym) {
	    if (!isSymbol$2(sym)) throw TypeError(tryToString$3(sym) + ' is not a symbol');
	    if (hasOwn$4(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
	  }
	});

	var uncurryThis$h = functionUncurryThis;
	var isArray$b = isArray$e;
	var isCallable$6 = isCallable$i;
	var classof$6 = classofRaw$2;
	var toString$8 = toString$b;

	var push$2 = uncurryThis$h([].push);

	var getJsonReplacerFunction = function (replacer) {
	  if (isCallable$6(replacer)) return replacer;
	  if (!isArray$b(replacer)) return;
	  var rawLength = replacer.length;
	  var keys = [];
	  for (var i = 0; i < rawLength; i++) {
	    var element = replacer[i];
	    if (typeof element == 'string') push$2(keys, element);
	    else if (typeof element == 'number' || classof$6(element) == 'Number' || classof$6(element) == 'String') push$2(keys, toString$8(element));
	  }
	  var keysLength = keys.length;
	  var root = true;
	  return function (key, value) {
	    if (root) {
	      root = false;
	      return value;
	    }
	    if (isArray$b(this)) return value;
	    for (var j = 0; j < keysLength; j++) if (keys[j] === key) return value;
	  };
	};

	var $$G = _export;
	var getBuiltIn$5 = getBuiltIn$c;
	var apply$2 = functionApply;
	var call$6 = functionCall;
	var uncurryThis$g = functionUncurryThis;
	var fails$h = fails$u;
	var isCallable$5 = isCallable$i;
	var isSymbol$1 = isSymbol$5;
	var arraySlice$2 = arraySlice$5;
	var getReplacerFunction = getJsonReplacerFunction;
	var NATIVE_SYMBOL$1 = symbolConstructorDetection;

	var $String$1 = String;
	var $stringify = getBuiltIn$5('JSON', 'stringify');
	var exec$1 = uncurryThis$g(/./.exec);
	var charAt$3 = uncurryThis$g(''.charAt);
	var charCodeAt$1 = uncurryThis$g(''.charCodeAt);
	var replace$1 = uncurryThis$g(''.replace);
	var numberToString = uncurryThis$g(1.0.toString);

	var tester = /[\uD800-\uDFFF]/g;
	var low = /^[\uD800-\uDBFF]$/;
	var hi = /^[\uDC00-\uDFFF]$/;

	var WRONG_SYMBOLS_CONVERSION = !NATIVE_SYMBOL$1 || fails$h(function () {
	  var symbol = getBuiltIn$5('Symbol')();
	  // MS Edge converts symbol values to JSON as {}
	  return $stringify([symbol]) != '[null]'
	    // WebKit converts symbol values to JSON as null
	    || $stringify({ a: symbol }) != '{}'
	    // V8 throws on boxed symbols
	    || $stringify(Object(symbol)) != '{}';
	});

	// https://github.com/tc39/proposal-well-formed-stringify
	var ILL_FORMED_UNICODE = fails$h(function () {
	  return $stringify('\uDF06\uD834') !== '"\\udf06\\ud834"'
	    || $stringify('\uDEAD') !== '"\\udead"';
	});

	var stringifyWithSymbolsFix = function (it, replacer) {
	  var args = arraySlice$2(arguments);
	  var $replacer = getReplacerFunction(replacer);
	  if (!isCallable$5($replacer) && (it === undefined || isSymbol$1(it))) return; // IE8 returns string on undefined
	  args[1] = function (key, value) {
	    // some old implementations (like WebKit) could pass numbers as keys
	    if (isCallable$5($replacer)) value = call$6($replacer, this, $String$1(key), value);
	    if (!isSymbol$1(value)) return value;
	  };
	  return apply$2($stringify, null, args);
	};

	var fixIllFormed = function (match, offset, string) {
	  var prev = charAt$3(string, offset - 1);
	  var next = charAt$3(string, offset + 1);
	  if ((exec$1(low, match) && !exec$1(hi, next)) || (exec$1(hi, match) && !exec$1(low, prev))) {
	    return '\\u' + numberToString(charCodeAt$1(match, 0), 16);
	  } return match;
	};

	if ($stringify) {
	  // `JSON.stringify` method
	  // https://tc39.es/ecma262/#sec-json.stringify
	  $$G({ target: 'JSON', stat: true, arity: 3, forced: WRONG_SYMBOLS_CONVERSION || ILL_FORMED_UNICODE }, {
	    // eslint-disable-next-line no-unused-vars -- required for `.length`
	    stringify: function stringify(it, replacer, space) {
	      var args = arraySlice$2(arguments);
	      var result = apply$2(WRONG_SYMBOLS_CONVERSION ? stringifyWithSymbolsFix : $stringify, null, args);
	      return ILL_FORMED_UNICODE && typeof result == 'string' ? replace$1(result, tester, fixIllFormed) : result;
	    }
	  });
	}

	var $$F = _export;
	var NATIVE_SYMBOL = symbolConstructorDetection;
	var fails$g = fails$u;
	var getOwnPropertySymbolsModule$2 = objectGetOwnPropertySymbols;
	var toObject$9 = toObject$d;

	// V8 ~ Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
	// https://bugs.chromium.org/p/v8/issues/detail?id=3443
	var FORCED$6 = !NATIVE_SYMBOL || fails$g(function () { getOwnPropertySymbolsModule$2.f(1); });

	// `Object.getOwnPropertySymbols` method
	// https://tc39.es/ecma262/#sec-object.getownpropertysymbols
	$$F({ target: 'Object', stat: true, forced: FORCED$6 }, {
	  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
	    var $getOwnPropertySymbols = getOwnPropertySymbolsModule$2.f;
	    return $getOwnPropertySymbols ? $getOwnPropertySymbols(toObject$9(it)) : [];
	  }
	});

	var defineWellKnownSymbol$k = wellKnownSymbolDefine;

	// `Symbol.asyncIterator` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.asynciterator
	defineWellKnownSymbol$k('asyncIterator');

	var defineWellKnownSymbol$j = wellKnownSymbolDefine;

	// `Symbol.hasInstance` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.hasinstance
	defineWellKnownSymbol$j('hasInstance');

	var defineWellKnownSymbol$i = wellKnownSymbolDefine;

	// `Symbol.isConcatSpreadable` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.isconcatspreadable
	defineWellKnownSymbol$i('isConcatSpreadable');

	var defineWellKnownSymbol$h = wellKnownSymbolDefine;

	// `Symbol.iterator` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.iterator
	defineWellKnownSymbol$h('iterator');

	var defineWellKnownSymbol$g = wellKnownSymbolDefine;

	// `Symbol.match` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.match
	defineWellKnownSymbol$g('match');

	var defineWellKnownSymbol$f = wellKnownSymbolDefine;

	// `Symbol.matchAll` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.matchall
	defineWellKnownSymbol$f('matchAll');

	var defineWellKnownSymbol$e = wellKnownSymbolDefine;

	// `Symbol.replace` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.replace
	defineWellKnownSymbol$e('replace');

	var defineWellKnownSymbol$d = wellKnownSymbolDefine;

	// `Symbol.search` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.search
	defineWellKnownSymbol$d('search');

	var defineWellKnownSymbol$c = wellKnownSymbolDefine;

	// `Symbol.species` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.species
	defineWellKnownSymbol$c('species');

	var defineWellKnownSymbol$b = wellKnownSymbolDefine;

	// `Symbol.split` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.split
	defineWellKnownSymbol$b('split');

	var defineWellKnownSymbol$a = wellKnownSymbolDefine;
	var defineSymbolToPrimitive = symbolDefineToPrimitive;

	// `Symbol.toPrimitive` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.toprimitive
	defineWellKnownSymbol$a('toPrimitive');

	// `Symbol.prototype[@@toPrimitive]` method
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
	defineSymbolToPrimitive();

	var getBuiltIn$4 = getBuiltIn$c;
	var defineWellKnownSymbol$9 = wellKnownSymbolDefine;
	var setToStringTag$4 = setToStringTag$6;

	// `Symbol.toStringTag` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.tostringtag
	defineWellKnownSymbol$9('toStringTag');

	// `Symbol.prototype[@@toStringTag]` property
	// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
	setToStringTag$4(getBuiltIn$4('Symbol'), 'Symbol');

	var defineWellKnownSymbol$8 = wellKnownSymbolDefine;

	// `Symbol.unscopables` well-known symbol
	// https://tc39.es/ecma262/#sec-symbol.unscopables
	defineWellKnownSymbol$8('unscopables');

	var global$8 = global$j;
	var setToStringTag$3 = setToStringTag$6;

	// JSON[@@toStringTag] property
	// https://tc39.es/ecma262/#sec-json-@@tostringtag
	setToStringTag$3(global$8.JSON, 'JSON', true);

	var path$l = path$r;

	var symbol$4 = path$l.Symbol;

	var iterators = {};

	var DESCRIPTORS$a = descriptors;
	var hasOwn$3 = hasOwnProperty_1;

	var FunctionPrototype$1 = Function.prototype;
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var getDescriptor = DESCRIPTORS$a && Object.getOwnPropertyDescriptor;

	var EXISTS = hasOwn$3(FunctionPrototype$1, 'name');
	// additional protection from minified / mangled / dropped function names
	var PROPER = EXISTS && (function something() { /* empty */ }).name === 'something';
	var CONFIGURABLE = EXISTS && (!DESCRIPTORS$a || (DESCRIPTORS$a && getDescriptor(FunctionPrototype$1, 'name').configurable));

	var functionName = {
	  EXISTS: EXISTS,
	  PROPER: PROPER,
	  CONFIGURABLE: CONFIGURABLE
	};

	var fails$f = fails$u;

	var correctPrototypeGetter = !fails$f(function () {
	  function F() { /* empty */ }
	  F.prototype.constructor = null;
	  // eslint-disable-next-line es/no-object-getprototypeof -- required for testing
	  return Object.getPrototypeOf(new F()) !== F.prototype;
	});

	var hasOwn$2 = hasOwnProperty_1;
	var isCallable$4 = isCallable$i;
	var toObject$8 = toObject$d;
	var sharedKey = sharedKey$4;
	var CORRECT_PROTOTYPE_GETTER$1 = correctPrototypeGetter;

	var IE_PROTO = sharedKey('IE_PROTO');
	var $Object = Object;
	var ObjectPrototype = $Object.prototype;

	// `Object.getPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.getprototypeof
	// eslint-disable-next-line es/no-object-getprototypeof -- safe
	var objectGetPrototypeOf = CORRECT_PROTOTYPE_GETTER$1 ? $Object.getPrototypeOf : function (O) {
	  var object = toObject$8(O);
	  if (hasOwn$2(object, IE_PROTO)) return object[IE_PROTO];
	  var constructor = object.constructor;
	  if (isCallable$4(constructor) && object instanceof constructor) {
	    return constructor.prototype;
	  } return object instanceof $Object ? ObjectPrototype : null;
	};

	var fails$e = fails$u;
	var isCallable$3 = isCallable$i;
	var isObject$6 = isObject$g;
	var create$a = objectCreate;
	var getPrototypeOf$8 = objectGetPrototypeOf;
	var defineBuiltIn$2 = defineBuiltIn$5;
	var wellKnownSymbol$a = wellKnownSymbol$l;

	var ITERATOR$6 = wellKnownSymbol$a('iterator');
	var BUGGY_SAFARI_ITERATORS$1 = false;

	// `%IteratorPrototype%` object
	// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
	var IteratorPrototype$1, PrototypeOfArrayIteratorPrototype, arrayIterator;

	/* eslint-disable es/no-array-prototype-keys -- safe */
	if ([].keys) {
	  arrayIterator = [].keys();
	  // Safari 8 has buggy iterators w/o `next`
	  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS$1 = true;
	  else {
	    PrototypeOfArrayIteratorPrototype = getPrototypeOf$8(getPrototypeOf$8(arrayIterator));
	    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype$1 = PrototypeOfArrayIteratorPrototype;
	  }
	}

	var NEW_ITERATOR_PROTOTYPE = !isObject$6(IteratorPrototype$1) || fails$e(function () {
	  var test = {};
	  // FF44- legacy iterators case
	  return IteratorPrototype$1[ITERATOR$6].call(test) !== test;
	});

	if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype$1 = {};
	else IteratorPrototype$1 = create$a(IteratorPrototype$1);

	// `%IteratorPrototype%[@@iterator]()` method
	// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
	if (!isCallable$3(IteratorPrototype$1[ITERATOR$6])) {
	  defineBuiltIn$2(IteratorPrototype$1, ITERATOR$6, function () {
	    return this;
	  });
	}

	var iteratorsCore = {
	  IteratorPrototype: IteratorPrototype$1,
	  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS$1
	};

	var IteratorPrototype = iteratorsCore.IteratorPrototype;
	var create$9 = objectCreate;
	var createPropertyDescriptor = createPropertyDescriptor$5;
	var setToStringTag$2 = setToStringTag$6;
	var Iterators$5 = iterators;

	var returnThis$1 = function () { return this; };

	var iteratorCreateConstructor = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
	  var TO_STRING_TAG = NAME + ' Iterator';
	  IteratorConstructor.prototype = create$9(IteratorPrototype, { next: createPropertyDescriptor(+!ENUMERABLE_NEXT, next) });
	  setToStringTag$2(IteratorConstructor, TO_STRING_TAG, false, true);
	  Iterators$5[TO_STRING_TAG] = returnThis$1;
	  return IteratorConstructor;
	};

	var uncurryThis$f = functionUncurryThis;
	var aCallable$3 = aCallable$7;

	var functionUncurryThisAccessor = function (object, key, method) {
	  try {
	    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	    return uncurryThis$f(aCallable$3(Object.getOwnPropertyDescriptor(object, key)[method]));
	  } catch (error) { /* empty */ }
	};

	var isCallable$2 = isCallable$i;

	var $String = String;
	var $TypeError$8 = TypeError;

	var aPossiblePrototype$1 = function (argument) {
	  if (typeof argument == 'object' || isCallable$2(argument)) return argument;
	  throw $TypeError$8("Can't set " + $String(argument) + ' as a prototype');
	};

	/* eslint-disable no-proto -- safe */

	var uncurryThisAccessor = functionUncurryThisAccessor;
	var anObject$5 = anObject$b;
	var aPossiblePrototype = aPossiblePrototype$1;

	// `Object.setPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.setprototypeof
	// Works with __proto__ only. Old v8 can't work with null proto objects.
	// eslint-disable-next-line es/no-object-setprototypeof -- safe
	var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
	  var CORRECT_SETTER = false;
	  var test = {};
	  var setter;
	  try {
	    setter = uncurryThisAccessor(Object.prototype, '__proto__', 'set');
	    setter(test, []);
	    CORRECT_SETTER = test instanceof Array;
	  } catch (error) { /* empty */ }
	  return function setPrototypeOf(O, proto) {
	    anObject$5(O);
	    aPossiblePrototype(proto);
	    if (CORRECT_SETTER) setter(O, proto);
	    else O.__proto__ = proto;
	    return O;
	  };
	}() : undefined);

	var $$E = _export;
	var call$5 = functionCall;
	var FunctionName = functionName;
	var createIteratorConstructor = iteratorCreateConstructor;
	var getPrototypeOf$7 = objectGetPrototypeOf;
	var setToStringTag$1 = setToStringTag$6;
	var defineBuiltIn$1 = defineBuiltIn$5;
	var wellKnownSymbol$9 = wellKnownSymbol$l;
	var Iterators$4 = iterators;
	var IteratorsCore = iteratorsCore;

	var PROPER_FUNCTION_NAME$1 = FunctionName.PROPER;
	var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
	var ITERATOR$5 = wellKnownSymbol$9('iterator');
	var KEYS = 'keys';
	var VALUES = 'values';
	var ENTRIES = 'entries';

	var returnThis = function () { return this; };

	var iteratorDefine = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
	  createIteratorConstructor(IteratorConstructor, NAME, next);

	  var getIterationMethod = function (KIND) {
	    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
	    if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
	    switch (KIND) {
	      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
	      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
	      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
	    } return function () { return new IteratorConstructor(this); };
	  };

	  var TO_STRING_TAG = NAME + ' Iterator';
	  var INCORRECT_VALUES_NAME = false;
	  var IterablePrototype = Iterable.prototype;
	  var nativeIterator = IterablePrototype[ITERATOR$5]
	    || IterablePrototype['@@iterator']
	    || DEFAULT && IterablePrototype[DEFAULT];
	  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
	  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
	  var CurrentIteratorPrototype, methods, KEY;

	  // fix native
	  if (anyNativeIterator) {
	    CurrentIteratorPrototype = getPrototypeOf$7(anyNativeIterator.call(new Iterable()));
	    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
	      // Set @@toStringTag to native iterators
	      setToStringTag$1(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
	      Iterators$4[TO_STRING_TAG] = returnThis;
	    }
	  }

	  // fix Array.prototype.{ values, @@iterator }.name in V8 / FF
	  if (PROPER_FUNCTION_NAME$1 && DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
	    {
	      INCORRECT_VALUES_NAME = true;
	      defaultIterator = function values() { return call$5(nativeIterator, this); };
	    }
	  }

	  // export additional methods
	  if (DEFAULT) {
	    methods = {
	      values: getIterationMethod(VALUES),
	      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
	      entries: getIterationMethod(ENTRIES)
	    };
	    if (FORCED) for (KEY in methods) {
	      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
	        defineBuiltIn$1(IterablePrototype, KEY, methods[KEY]);
	      }
	    } else $$E({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
	  }

	  // define iterator
	  if ((FORCED) && IterablePrototype[ITERATOR$5] !== defaultIterator) {
	    defineBuiltIn$1(IterablePrototype, ITERATOR$5, defaultIterator, { name: DEFAULT });
	  }
	  Iterators$4[NAME] = defaultIterator;

	  return methods;
	};

	// `CreateIterResultObject` abstract operation
	// https://tc39.es/ecma262/#sec-createiterresultobject
	var createIterResultObject$3 = function (value, done) {
	  return { value: value, done: done };
	};

	var toIndexedObject$4 = toIndexedObject$b;
	var Iterators$3 = iterators;
	var InternalStateModule$3 = internalState;
	objectDefineProperty.f;
	var defineIterator$2 = iteratorDefine;
	var createIterResultObject$2 = createIterResultObject$3;

	var ARRAY_ITERATOR = 'Array Iterator';
	var setInternalState$3 = InternalStateModule$3.set;
	var getInternalState$1 = InternalStateModule$3.getterFor(ARRAY_ITERATOR);

	// `Array.prototype.entries` method
	// https://tc39.es/ecma262/#sec-array.prototype.entries
	// `Array.prototype.keys` method
	// https://tc39.es/ecma262/#sec-array.prototype.keys
	// `Array.prototype.values` method
	// https://tc39.es/ecma262/#sec-array.prototype.values
	// `Array.prototype[@@iterator]` method
	// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
	// `CreateArrayIterator` internal method
	// https://tc39.es/ecma262/#sec-createarrayiterator
	defineIterator$2(Array, 'Array', function (iterated, kind) {
	  setInternalState$3(this, {
	    type: ARRAY_ITERATOR,
	    target: toIndexedObject$4(iterated), // target
	    index: 0,                          // next index
	    kind: kind                         // kind
	  });
	// `%ArrayIteratorPrototype%.next` method
	// https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
	}, function () {
	  var state = getInternalState$1(this);
	  var target = state.target;
	  var kind = state.kind;
	  var index = state.index++;
	  if (!target || index >= target.length) {
	    state.target = undefined;
	    return createIterResultObject$2(undefined, true);
	  }
	  if (kind == 'keys') return createIterResultObject$2(index, false);
	  if (kind == 'values') return createIterResultObject$2(target[index], false);
	  return createIterResultObject$2([index, target[index]], false);
	}, 'values');

	// argumentsList[@@iterator] is %ArrayProto_values%
	// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
	// https://tc39.es/ecma262/#sec-createmappedargumentsobject
	Iterators$3.Arguments = Iterators$3.Array;

	// iterable DOM collections
	// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
	var domIterables = {
	  CSSRuleList: 0,
	  CSSStyleDeclaration: 0,
	  CSSValueList: 0,
	  ClientRectList: 0,
	  DOMRectList: 0,
	  DOMStringList: 0,
	  DOMTokenList: 1,
	  DataTransferItemList: 0,
	  FileList: 0,
	  HTMLAllCollection: 0,
	  HTMLCollection: 0,
	  HTMLFormElement: 0,
	  HTMLSelectElement: 0,
	  MediaList: 0,
	  MimeTypeArray: 0,
	  NamedNodeMap: 0,
	  NodeList: 1,
	  PaintRequestList: 0,
	  Plugin: 0,
	  PluginArray: 0,
	  SVGLengthList: 0,
	  SVGNumberList: 0,
	  SVGPathSegList: 0,
	  SVGPointList: 0,
	  SVGStringList: 0,
	  SVGTransformList: 0,
	  SourceBufferList: 0,
	  StyleSheetList: 0,
	  TextTrackCueList: 0,
	  TextTrackList: 0,
	  TouchList: 0
	};

	var DOMIterables$1 = domIterables;
	var global$7 = global$j;
	var classof$5 = classof$c;
	var createNonEnumerableProperty$1 = createNonEnumerableProperty$6;
	var Iterators$2 = iterators;
	var wellKnownSymbol$8 = wellKnownSymbol$l;

	var TO_STRING_TAG = wellKnownSymbol$8('toStringTag');

	for (var COLLECTION_NAME in DOMIterables$1) {
	  var Collection = global$7[COLLECTION_NAME];
	  var CollectionPrototype = Collection && Collection.prototype;
	  if (CollectionPrototype && classof$5(CollectionPrototype) !== TO_STRING_TAG) {
	    createNonEnumerableProperty$1(CollectionPrototype, TO_STRING_TAG, COLLECTION_NAME);
	  }
	  Iterators$2[COLLECTION_NAME] = Iterators$2.Array;
	}

	var parent$_ = symbol$4;


	var symbol$3 = parent$_;

	var defineWellKnownSymbol$7 = wellKnownSymbolDefine;

	// `Symbol.dispose` well-known symbol
	// https://github.com/tc39/proposal-explicit-resource-management
	defineWellKnownSymbol$7('dispose');

	var parent$Z = symbol$3;



	var symbol$2 = parent$Z;

	var defineWellKnownSymbol$6 = wellKnownSymbolDefine;

	// `Symbol.asyncDispose` well-known symbol
	// https://github.com/tc39/proposal-async-explicit-resource-management
	defineWellKnownSymbol$6('asyncDispose');

	var $$D = _export;
	var getBuiltIn$3 = getBuiltIn$c;
	var uncurryThis$e = functionUncurryThis;

	var Symbol$4 = getBuiltIn$3('Symbol');
	var keyFor = Symbol$4.keyFor;
	var thisSymbolValue$1 = uncurryThis$e(Symbol$4.prototype.valueOf);

	// `Symbol.isRegistered` method
	// https://tc39.es/proposal-symbol-predicates/#sec-symbol-isregistered
	$$D({ target: 'Symbol', stat: true }, {
	  isRegistered: function isRegistered(value) {
	    try {
	      return keyFor(thisSymbolValue$1(value)) !== undefined;
	    } catch (error) {
	      return false;
	    }
	  }
	});

	var $$C = _export;
	var shared = sharedExports;
	var getBuiltIn$2 = getBuiltIn$c;
	var uncurryThis$d = functionUncurryThis;
	var isSymbol = isSymbol$5;
	var wellKnownSymbol$7 = wellKnownSymbol$l;

	var Symbol$3 = getBuiltIn$2('Symbol');
	var $isWellKnown = Symbol$3.isWellKnown;
	var getOwnPropertyNames = getBuiltIn$2('Object', 'getOwnPropertyNames');
	var thisSymbolValue = uncurryThis$d(Symbol$3.prototype.valueOf);
	var WellKnownSymbolsStore = shared('wks');

	for (var i$1 = 0, symbolKeys = getOwnPropertyNames(Symbol$3), symbolKeysLength = symbolKeys.length; i$1 < symbolKeysLength; i$1++) {
	  // some old engines throws on access to some keys like `arguments` or `caller`
	  try {
	    var symbolKey = symbolKeys[i$1];
	    if (isSymbol(Symbol$3[symbolKey])) wellKnownSymbol$7(symbolKey);
	  } catch (error) { /* empty */ }
	}

	// `Symbol.isWellKnown` method
	// https://tc39.es/proposal-symbol-predicates/#sec-symbol-iswellknown
	// We should patch it for newly added well-known symbols. If it's not required, this module just will not be injected
	$$C({ target: 'Symbol', stat: true, forced: true }, {
	  isWellKnown: function isWellKnown(value) {
	    if ($isWellKnown && $isWellKnown(value)) return true;
	    try {
	      var symbol = thisSymbolValue(value);
	      for (var j = 0, keys = getOwnPropertyNames(WellKnownSymbolsStore), keysLength = keys.length; j < keysLength; j++) {
	        if (WellKnownSymbolsStore[keys[j]] == symbol) return true;
	      }
	    } catch (error) { /* empty */ }
	    return false;
	  }
	});

	var defineWellKnownSymbol$5 = wellKnownSymbolDefine;

	// `Symbol.matcher` well-known symbol
	// https://github.com/tc39/proposal-pattern-matching
	defineWellKnownSymbol$5('matcher');

	var defineWellKnownSymbol$4 = wellKnownSymbolDefine;

	// `Symbol.metadataKey` well-known symbol
	// https://github.com/tc39/proposal-decorator-metadata
	defineWellKnownSymbol$4('metadataKey');

	var defineWellKnownSymbol$3 = wellKnownSymbolDefine;

	// `Symbol.observable` well-known symbol
	// https://github.com/tc39/proposal-observable
	defineWellKnownSymbol$3('observable');

	// TODO: Remove from `core-js@4`
	var defineWellKnownSymbol$2 = wellKnownSymbolDefine;

	// `Symbol.metadata` well-known symbol
	// https://github.com/tc39/proposal-decorators
	defineWellKnownSymbol$2('metadata');

	// TODO: remove from `core-js@4`
	var defineWellKnownSymbol$1 = wellKnownSymbolDefine;

	// `Symbol.patternMatch` well-known symbol
	// https://github.com/tc39/proposal-pattern-matching
	defineWellKnownSymbol$1('patternMatch');

	// TODO: remove from `core-js@4`
	var defineWellKnownSymbol = wellKnownSymbolDefine;

	defineWellKnownSymbol('replaceAll');

	var parent$Y = symbol$2;






	// TODO: Remove from `core-js@4`




	var symbol$1 = parent$Y;

	(function (module) {
		module.exports = symbol$1;
	} (symbol$5));

	(function (module) {
		module.exports = symbolExports$1;
	} (symbol$6));

	var _Symbol$1 = /*@__PURE__*/getDefaultExportFromCjs(symbolExports$2);

	var iteratorExports$1 = {};
	var iterator$5 = {
	  get exports(){ return iteratorExports$1; },
	  set exports(v){ iteratorExports$1 = v; },
	};

	var iteratorExports = {};
	var iterator$4 = {
	  get exports(){ return iteratorExports; },
	  set exports(v){ iteratorExports = v; },
	};

	var uncurryThis$c = functionUncurryThis;
	var toIntegerOrInfinity$2 = toIntegerOrInfinity$5;
	var toString$7 = toString$b;
	var requireObjectCoercible$3 = requireObjectCoercible$6;

	var charAt$2 = uncurryThis$c(''.charAt);
	var charCodeAt = uncurryThis$c(''.charCodeAt);
	var stringSlice = uncurryThis$c(''.slice);

	var createMethod$3 = function (CONVERT_TO_STRING) {
	  return function ($this, pos) {
	    var S = toString$7(requireObjectCoercible$3($this));
	    var position = toIntegerOrInfinity$2(pos);
	    var size = S.length;
	    var first, second;
	    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
	    first = charCodeAt(S, position);
	    return first < 0xD800 || first > 0xDBFF || position + 1 === size
	      || (second = charCodeAt(S, position + 1)) < 0xDC00 || second > 0xDFFF
	        ? CONVERT_TO_STRING
	          ? charAt$2(S, position)
	          : first
	        : CONVERT_TO_STRING
	          ? stringSlice(S, position, position + 2)
	          : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
	  };
	};

	var stringMultibyte = {
	  // `String.prototype.codePointAt` method
	  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
	  codeAt: createMethod$3(false),
	  // `String.prototype.at` method
	  // https://github.com/mathiasbynens/String.prototype.at
	  charAt: createMethod$3(true)
	};

	var charAt$1 = stringMultibyte.charAt;
	var toString$6 = toString$b;
	var InternalStateModule$2 = internalState;
	var defineIterator$1 = iteratorDefine;
	var createIterResultObject$1 = createIterResultObject$3;

	var STRING_ITERATOR = 'String Iterator';
	var setInternalState$2 = InternalStateModule$2.set;
	var getInternalState = InternalStateModule$2.getterFor(STRING_ITERATOR);

	// `String.prototype[@@iterator]` method
	// https://tc39.es/ecma262/#sec-string.prototype-@@iterator
	defineIterator$1(String, 'String', function (iterated) {
	  setInternalState$2(this, {
	    type: STRING_ITERATOR,
	    string: toString$6(iterated),
	    index: 0
	  });
	// `%StringIteratorPrototype%.next` method
	// https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
	}, function next() {
	  var state = getInternalState(this);
	  var string = state.string;
	  var index = state.index;
	  var point;
	  if (index >= string.length) return createIterResultObject$1(undefined, true);
	  point = charAt$1(string, index);
	  state.index += point.length;
	  return createIterResultObject$1(point, false);
	});

	var WrappedWellKnownSymbolModule$1 = wellKnownSymbolWrapped;

	var iterator$3 = WrappedWellKnownSymbolModule$1.f('iterator');

	var parent$X = iterator$3;


	var iterator$2 = parent$X;

	var parent$W = iterator$2;

	var iterator$1 = parent$W;

	var parent$V = iterator$1;

	var iterator = parent$V;

	(function (module) {
		module.exports = iterator;
	} (iterator$4));

	(function (module) {
		module.exports = iteratorExports;
	} (iterator$5));

	var _Symbol$iterator = /*@__PURE__*/getDefaultExportFromCjs(iteratorExports$1);

	function _typeof(obj) {
	  "@babel/helpers - typeof";

	  return _typeof = "function" == typeof _Symbol$1 && "symbol" == typeof _Symbol$iterator ? function (obj) {
	    return typeof obj;
	  } : function (obj) {
	    return obj && "function" == typeof _Symbol$1 && obj.constructor === _Symbol$1 && obj !== _Symbol$1.prototype ? "symbol" : typeof obj;
	  }, _typeof(obj);
	}

	var toPrimitiveExports$1 = {};
	var toPrimitive$5 = {
	  get exports(){ return toPrimitiveExports$1; },
	  set exports(v){ toPrimitiveExports$1 = v; },
	};

	var toPrimitiveExports = {};
	var toPrimitive$4 = {
	  get exports(){ return toPrimitiveExports; },
	  set exports(v){ toPrimitiveExports = v; },
	};

	var WrappedWellKnownSymbolModule = wellKnownSymbolWrapped;

	var toPrimitive$3 = WrappedWellKnownSymbolModule.f('toPrimitive');

	var parent$U = toPrimitive$3;

	var toPrimitive$2 = parent$U;

	var parent$T = toPrimitive$2;

	var toPrimitive$1 = parent$T;

	var parent$S = toPrimitive$1;

	var toPrimitive = parent$S;

	(function (module) {
		module.exports = toPrimitive;
	} (toPrimitive$4));

	(function (module) {
		module.exports = toPrimitiveExports;
	} (toPrimitive$5));

	var _Symbol$toPrimitive = /*@__PURE__*/getDefaultExportFromCjs(toPrimitiveExports$1);

	function _toPrimitive(input, hint) {
	  if (_typeof(input) !== "object" || input === null) return input;
	  var prim = input[_Symbol$toPrimitive];
	  if (prim !== undefined) {
	    var res = prim.call(input, hint || "default");
	    if (_typeof(res) !== "object") return res;
	    throw new TypeError("@@toPrimitive must return a primitive value.");
	  }
	  return (hint === "string" ? String : Number)(input);
	}

	function _toPropertyKey(arg) {
	  var key = _toPrimitive(arg, "string");
	  return _typeof(key) === "symbol" ? key : String(key);
	}

	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;
	    _Object$defineProperty$1(target, _toPropertyKey(descriptor.key), descriptor);
	  }
	}
	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);
	  _Object$defineProperty$1(Constructor, "prototype", {
	    writable: false
	  });
	  return Constructor;
	}

	function _assertThisInitialized$1(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }
	  return self;
	}

	var createExports$2 = {};
	var create$8 = {
	  get exports(){ return createExports$2; },
	  set exports(v){ createExports$2 = v; },
	};

	var createExports$1 = {};
	var create$7 = {
	  get exports(){ return createExports$1; },
	  set exports(v){ createExports$1 = v; },
	};

	// TODO: Remove from `core-js@4`
	var $$B = _export;
	var DESCRIPTORS$9 = descriptors;
	var create$6 = objectCreate;

	// `Object.create` method
	// https://tc39.es/ecma262/#sec-object.create
	$$B({ target: 'Object', stat: true, sham: !DESCRIPTORS$9 }, {
	  create: create$6
	});

	var path$k = path$r;

	var Object$3 = path$k.Object;

	var create$5 = function create(P, D) {
	  return Object$3.create(P, D);
	};

	var parent$R = create$5;

	var create$4 = parent$R;

	var parent$Q = create$4;

	var create$3 = parent$Q;

	var parent$P = create$3;

	var create$2 = parent$P;

	(function (module) {
		module.exports = create$2;
	} (create$7));

	(function (module) {
		module.exports = createExports$1;
	} (create$8));

	var _Object$create$1 = /*@__PURE__*/getDefaultExportFromCjs(createExports$2);

	var setPrototypeOfExports$1 = {};
	var setPrototypeOf$6 = {
	  get exports(){ return setPrototypeOfExports$1; },
	  set exports(v){ setPrototypeOfExports$1 = v; },
	};

	var setPrototypeOfExports = {};
	var setPrototypeOf$5 = {
	  get exports(){ return setPrototypeOfExports; },
	  set exports(v){ setPrototypeOfExports = v; },
	};

	var $$A = _export;
	var setPrototypeOf$4 = objectSetPrototypeOf;

	// `Object.setPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.setprototypeof
	$$A({ target: 'Object', stat: true }, {
	  setPrototypeOf: setPrototypeOf$4
	});

	var path$j = path$r;

	var setPrototypeOf$3 = path$j.Object.setPrototypeOf;

	var parent$O = setPrototypeOf$3;

	var setPrototypeOf$2 = parent$O;

	var parent$N = setPrototypeOf$2;

	var setPrototypeOf$1 = parent$N;

	var parent$M = setPrototypeOf$1;

	var setPrototypeOf = parent$M;

	(function (module) {
		module.exports = setPrototypeOf;
	} (setPrototypeOf$5));

	(function (module) {
		module.exports = setPrototypeOfExports;
	} (setPrototypeOf$6));

	var _Object$setPrototypeOf = /*@__PURE__*/getDefaultExportFromCjs(setPrototypeOfExports$1);

	var bindExports$2 = {};
	var bind$b = {
	  get exports(){ return bindExports$2; },
	  set exports(v){ bindExports$2 = v; },
	};

	var bindExports$1 = {};
	var bind$a = {
	  get exports(){ return bindExports$1; },
	  set exports(v){ bindExports$1 = v; },
	};

	// TODO: Remove from `core-js@4`
	var $$z = _export;
	var bind$9 = functionBind;

	// `Function.prototype.bind` method
	// https://tc39.es/ecma262/#sec-function.prototype.bind
	// eslint-disable-next-line es/no-function-prototype-bind -- detection
	$$z({ target: 'Function', proto: true, forced: Function.bind !== bind$9 }, {
	  bind: bind$9
	});

	var path$i = path$r;

	var entryVirtual$k = function (CONSTRUCTOR) {
	  return path$i[CONSTRUCTOR + 'Prototype'];
	};

	var entryVirtual$j = entryVirtual$k;

	var bind$8 = entryVirtual$j('Function').bind;

	var isPrototypeOf$k = objectIsPrototypeOf;
	var method$h = bind$8;

	var FunctionPrototype = Function.prototype;

	var bind$7 = function (it) {
	  var own = it.bind;
	  return it === FunctionPrototype || (isPrototypeOf$k(FunctionPrototype, it) && own === FunctionPrototype.bind) ? method$h : own;
	};

	var parent$L = bind$7;

	var bind$6 = parent$L;

	var parent$K = bind$6;

	var bind$5 = parent$K;

	var parent$J = bind$5;

	var bind$4 = parent$J;

	(function (module) {
		module.exports = bind$4;
	} (bind$a));

	(function (module) {
		module.exports = bindExports$1;
	} (bind$b));

	var _bindInstanceProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(bindExports$2);

	function _setPrototypeOf(o, p) {
	  var _context;
	  _setPrototypeOf = _Object$setPrototypeOf ? _bindInstanceProperty$1(_context = _Object$setPrototypeOf).call(_context) : function _setPrototypeOf(o, p) {
	    o.__proto__ = p;
	    return o;
	  };
	  return _setPrototypeOf(o, p);
	}

	function _inherits(subClass, superClass) {
	  if (typeof superClass !== "function" && superClass !== null) {
	    throw new TypeError("Super expression must either be null or a function");
	  }
	  subClass.prototype = _Object$create$1(superClass && superClass.prototype, {
	    constructor: {
	      value: subClass,
	      writable: true,
	      configurable: true
	    }
	  });
	  _Object$defineProperty$1(subClass, "prototype", {
	    writable: false
	  });
	  if (superClass) _setPrototypeOf(subClass, superClass);
	}

	function _possibleConstructorReturn(self, call) {
	  if (call && (_typeof(call) === "object" || typeof call === "function")) {
	    return call;
	  } else if (call !== void 0) {
	    throw new TypeError("Derived constructors may only return object or undefined");
	  }
	  return _assertThisInitialized$1(self);
	}

	var getPrototypeOfExports$2 = {};
	var getPrototypeOf$6 = {
	  get exports(){ return getPrototypeOfExports$2; },
	  set exports(v){ getPrototypeOfExports$2 = v; },
	};

	var getPrototypeOfExports$1 = {};
	var getPrototypeOf$5 = {
	  get exports(){ return getPrototypeOfExports$1; },
	  set exports(v){ getPrototypeOfExports$1 = v; },
	};

	var $$y = _export;
	var fails$d = fails$u;
	var toObject$7 = toObject$d;
	var nativeGetPrototypeOf = objectGetPrototypeOf;
	var CORRECT_PROTOTYPE_GETTER = correctPrototypeGetter;

	var FAILS_ON_PRIMITIVES$2 = fails$d(function () { nativeGetPrototypeOf(1); });

	// `Object.getPrototypeOf` method
	// https://tc39.es/ecma262/#sec-object.getprototypeof
	$$y({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES$2, sham: !CORRECT_PROTOTYPE_GETTER }, {
	  getPrototypeOf: function getPrototypeOf(it) {
	    return nativeGetPrototypeOf(toObject$7(it));
	  }
	});

	var path$h = path$r;

	var getPrototypeOf$4 = path$h.Object.getPrototypeOf;

	var parent$I = getPrototypeOf$4;

	var getPrototypeOf$3 = parent$I;

	var parent$H = getPrototypeOf$3;

	var getPrototypeOf$2 = parent$H;

	var parent$G = getPrototypeOf$2;

	var getPrototypeOf$1 = parent$G;

	(function (module) {
		module.exports = getPrototypeOf$1;
	} (getPrototypeOf$5));

	(function (module) {
		module.exports = getPrototypeOfExports$1;
	} (getPrototypeOf$6));

	var _Object$getPrototypeOf$1 = /*@__PURE__*/getDefaultExportFromCjs(getPrototypeOfExports$2);

	function _getPrototypeOf(o) {
	  var _context;
	  _getPrototypeOf = _Object$setPrototypeOf ? _bindInstanceProperty$1(_context = _Object$getPrototypeOf$1).call(_context) : function _getPrototypeOf(o) {
	    return o.__proto__ || _Object$getPrototypeOf$1(o);
	  };
	  return _getPrototypeOf(o);
	}

	var isArrayExports$2 = {};
	var isArray$a = {
	  get exports(){ return isArrayExports$2; },
	  set exports(v){ isArrayExports$2 = v; },
	};

	var $$x = _export;
	var isArray$9 = isArray$e;

	// `Array.isArray` method
	// https://tc39.es/ecma262/#sec-array.isarray
	$$x({ target: 'Array', stat: true }, {
	  isArray: isArray$9
	});

	var path$g = path$r;

	var isArray$8 = path$g.Array.isArray;

	var parent$F = isArray$8;

	var isArray$7 = parent$F;

	(function (module) {
		module.exports = isArray$7;
	} (isArray$a));

	var _Array$isArray$1 = /*@__PURE__*/getDefaultExportFromCjs(isArrayExports$2);

	var bindExports = {};
	var bind$3 = {
	  get exports(){ return bindExports; },
	  set exports(v){ bindExports = v; },
	};

	(function (module) {
		module.exports = bind$6;
	} (bind$3));

	var _bindInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(bindExports);

	var setTimeoutExports = {};
	var setTimeout$3 = {
	  get exports(){ return setTimeoutExports; },
	  set exports(v){ setTimeoutExports = v; },
	};

	/* global Bun -- Deno case */

	var engineIsBun = typeof Bun == 'function' && Bun && typeof Bun.version == 'string';

	var $TypeError$7 = TypeError;

	var validateArgumentsLength$1 = function (passed, required) {
	  if (passed < required) throw $TypeError$7('Not enough arguments');
	  return passed;
	};

	var global$6 = global$j;
	var apply$1 = functionApply;
	var isCallable$1 = isCallable$i;
	var ENGINE_IS_BUN = engineIsBun;
	var USER_AGENT = engineUserAgent;
	var arraySlice$1 = arraySlice$5;
	var validateArgumentsLength = validateArgumentsLength$1;

	var Function$1 = global$6.Function;
	// dirty IE9- and Bun 0.3.0- checks
	var WRAP = /MSIE .\./.test(USER_AGENT) || ENGINE_IS_BUN && (function () {
	  var version = global$6.Bun.version.split('.');
	  return version.length < 3 || version[0] == 0 && (version[1] < 3 || version[1] == 3 && version[2] == 0);
	})();

	// IE9- / Bun 0.3.0- setTimeout / setInterval / setImmediate additional parameters fix
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#timers
	// https://github.com/oven-sh/bun/issues/1633
	var schedulersFix$2 = function (scheduler, hasTimeArg) {
	  var firstParamIndex = hasTimeArg ? 2 : 1;
	  return WRAP ? function (handler, timeout /* , ...arguments */) {
	    var boundArgs = validateArgumentsLength(arguments.length, 1) > firstParamIndex;
	    var fn = isCallable$1(handler) ? handler : Function$1(handler);
	    var params = boundArgs ? arraySlice$1(arguments, firstParamIndex) : [];
	    var callback = boundArgs ? function () {
	      apply$1(fn, this, params);
	    } : fn;
	    return hasTimeArg ? scheduler(callback, timeout) : scheduler(callback);
	  } : scheduler;
	};

	var $$w = _export;
	var global$5 = global$j;
	var schedulersFix$1 = schedulersFix$2;

	var setInterval$2 = schedulersFix$1(global$5.setInterval, true);

	// Bun / IE9- setInterval additional parameters fix
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-setinterval
	$$w({ global: true, bind: true, forced: global$5.setInterval !== setInterval$2 }, {
	  setInterval: setInterval$2
	});

	var $$v = _export;
	var global$4 = global$j;
	var schedulersFix = schedulersFix$2;

	var setTimeout$2 = schedulersFix(global$4.setTimeout, true);

	// Bun / IE9- setTimeout additional parameters fix
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-settimeout
	$$v({ global: true, bind: true, forced: global$4.setTimeout !== setTimeout$2 }, {
	  setTimeout: setTimeout$2
	});

	var path$f = path$r;

	var setTimeout$1 = path$f.setTimeout;

	(function (module) {
		module.exports = setTimeout$1;
	} (setTimeout$3));

	var _setTimeout = /*@__PURE__*/getDefaultExportFromCjs(setTimeoutExports);

	var forEachExports = {};
	var forEach$6 = {
	  get exports(){ return forEachExports; },
	  set exports(v){ forEachExports = v; },
	};

	var fails$c = fails$u;

	var arrayMethodIsStrict$6 = function (METHOD_NAME, argument) {
	  var method = [][METHOD_NAME];
	  return !!method && fails$c(function () {
	    // eslint-disable-next-line no-useless-call -- required for testing
	    method.call(null, argument || function () { return 1; }, 1);
	  });
	};

	var $forEach = arrayIteration.forEach;
	var arrayMethodIsStrict$5 = arrayMethodIsStrict$6;

	var STRICT_METHOD$3 = arrayMethodIsStrict$5('forEach');

	// `Array.prototype.forEach` method implementation
	// https://tc39.es/ecma262/#sec-array.prototype.foreach
	var arrayForEach = !STRICT_METHOD$3 ? function forEach(callbackfn /* , thisArg */) {
	  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	// eslint-disable-next-line es/no-array-prototype-foreach -- safe
	} : [].forEach;

	var $$u = _export;
	var forEach$5 = arrayForEach;

	// `Array.prototype.forEach` method
	// https://tc39.es/ecma262/#sec-array.prototype.foreach
	// eslint-disable-next-line es/no-array-prototype-foreach -- safe
	$$u({ target: 'Array', proto: true, forced: [].forEach != forEach$5 }, {
	  forEach: forEach$5
	});

	var entryVirtual$i = entryVirtual$k;

	var forEach$4 = entryVirtual$i('Array').forEach;

	var parent$E = forEach$4;

	var forEach$3 = parent$E;

	var classof$4 = classof$c;
	var hasOwn$1 = hasOwnProperty_1;
	var isPrototypeOf$j = objectIsPrototypeOf;
	var method$g = forEach$3;

	var ArrayPrototype$g = Array.prototype;

	var DOMIterables = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var forEach$2 = function (it) {
	  var own = it.forEach;
	  return it === ArrayPrototype$g || (isPrototypeOf$j(ArrayPrototype$g, it) && own === ArrayPrototype$g.forEach)
	    || hasOwn$1(DOMIterables, classof$4(it)) ? method$g : own;
	};

	(function (module) {
		module.exports = forEach$2;
	} (forEach$6));

	var _forEachInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(forEachExports);

	// first check if moment.js is already loaded in the browser window, if so,
	// use this instance. Else, load via commonjs.
	//
	// Note: This doesn't work in ESM.
	var moment$2 = typeof window !== 'undefined' && window['moment'] || moment$3;

	var getOwnPropertySymbolsExports = {};
	var getOwnPropertySymbols$2 = {
	  get exports(){ return getOwnPropertySymbolsExports; },
	  set exports(v){ getOwnPropertySymbolsExports = v; },
	};

	var path$e = path$r;

	var getOwnPropertySymbols$1 = path$e.Object.getOwnPropertySymbols;

	var parent$D = getOwnPropertySymbols$1;

	var getOwnPropertySymbols = parent$D;

	(function (module) {
		module.exports = getOwnPropertySymbols;
	} (getOwnPropertySymbols$2));

	var _Object$getOwnPropertySymbols = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertySymbolsExports);

	var filterExports = {};
	var filter$3 = {
	  get exports(){ return filterExports; },
	  set exports(v){ filterExports = v; },
	};

	var $$t = _export;
	var $filter = arrayIteration.filter;
	var arrayMethodHasSpeciesSupport$3 = arrayMethodHasSpeciesSupport$5;

	var HAS_SPECIES_SUPPORT$3 = arrayMethodHasSpeciesSupport$3('filter');

	// `Array.prototype.filter` method
	// https://tc39.es/ecma262/#sec-array.prototype.filter
	// with adding support of @@species
	$$t({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT$3 }, {
	  filter: function filter(callbackfn /* , thisArg */) {
	    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$h = entryVirtual$k;

	var filter$2 = entryVirtual$h('Array').filter;

	var isPrototypeOf$i = objectIsPrototypeOf;
	var method$f = filter$2;

	var ArrayPrototype$f = Array.prototype;

	var filter$1 = function (it) {
	  var own = it.filter;
	  return it === ArrayPrototype$f || (isPrototypeOf$i(ArrayPrototype$f, it) && own === ArrayPrototype$f.filter) ? method$f : own;
	};

	var parent$C = filter$1;

	var filter = parent$C;

	(function (module) {
		module.exports = filter;
	} (filter$3));

	var _filterInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(filterExports);

	var getOwnPropertyDescriptorExports$1 = {};
	var getOwnPropertyDescriptor$4 = {
	  get exports(){ return getOwnPropertyDescriptorExports$1; },
	  set exports(v){ getOwnPropertyDescriptorExports$1 = v; },
	};

	var getOwnPropertyDescriptorExports = {};
	var getOwnPropertyDescriptor$3 = {
	  get exports(){ return getOwnPropertyDescriptorExports; },
	  set exports(v){ getOwnPropertyDescriptorExports = v; },
	};

	var $$s = _export;
	var fails$b = fails$u;
	var toIndexedObject$3 = toIndexedObject$b;
	var nativeGetOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
	var DESCRIPTORS$8 = descriptors;

	var FORCED$5 = !DESCRIPTORS$8 || fails$b(function () { nativeGetOwnPropertyDescriptor(1); });

	// `Object.getOwnPropertyDescriptor` method
	// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
	$$s({ target: 'Object', stat: true, forced: FORCED$5, sham: !DESCRIPTORS$8 }, {
	  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
	    return nativeGetOwnPropertyDescriptor(toIndexedObject$3(it), key);
	  }
	});

	var path$d = path$r;

	var Object$2 = path$d.Object;

	var getOwnPropertyDescriptor$2 = getOwnPropertyDescriptor$3.exports = function getOwnPropertyDescriptor(it, key) {
	  return Object$2.getOwnPropertyDescriptor(it, key);
	};

	if (Object$2.getOwnPropertyDescriptor.sham) getOwnPropertyDescriptor$2.sham = true;

	var parent$B = getOwnPropertyDescriptorExports;

	var getOwnPropertyDescriptor$1 = parent$B;

	(function (module) {
		module.exports = getOwnPropertyDescriptor$1;
	} (getOwnPropertyDescriptor$4));

	var _Object$getOwnPropertyDescriptor = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyDescriptorExports$1);

	var getOwnPropertyDescriptorsExports = {};
	var getOwnPropertyDescriptors$2 = {
	  get exports(){ return getOwnPropertyDescriptorsExports; },
	  set exports(v){ getOwnPropertyDescriptorsExports = v; },
	};

	var getBuiltIn$1 = getBuiltIn$c;
	var uncurryThis$b = functionUncurryThis;
	var getOwnPropertyNamesModule$1 = objectGetOwnPropertyNames;
	var getOwnPropertySymbolsModule$1 = objectGetOwnPropertySymbols;
	var anObject$4 = anObject$b;

	var concat$5 = uncurryThis$b([].concat);

	// all object keys, includes non-enumerable and symbols
	var ownKeys$7 = getBuiltIn$1('Reflect', 'ownKeys') || function ownKeys(it) {
	  var keys = getOwnPropertyNamesModule$1.f(anObject$4(it));
	  var getOwnPropertySymbols = getOwnPropertySymbolsModule$1.f;
	  return getOwnPropertySymbols ? concat$5(keys, getOwnPropertySymbols(it)) : keys;
	};

	var $$r = _export;
	var DESCRIPTORS$7 = descriptors;
	var ownKeys$6 = ownKeys$7;
	var toIndexedObject$2 = toIndexedObject$b;
	var getOwnPropertyDescriptorModule = objectGetOwnPropertyDescriptor;
	var createProperty$3 = createProperty$6;

	// `Object.getOwnPropertyDescriptors` method
	// https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
	$$r({ target: 'Object', stat: true, sham: !DESCRIPTORS$7 }, {
	  getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
	    var O = toIndexedObject$2(object);
	    var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
	    var keys = ownKeys$6(O);
	    var result = {};
	    var index = 0;
	    var key, descriptor;
	    while (keys.length > index) {
	      descriptor = getOwnPropertyDescriptor(O, key = keys[index++]);
	      if (descriptor !== undefined) createProperty$3(result, key, descriptor);
	    }
	    return result;
	  }
	});

	var path$c = path$r;

	var getOwnPropertyDescriptors$1 = path$c.Object.getOwnPropertyDescriptors;

	var parent$A = getOwnPropertyDescriptors$1;

	var getOwnPropertyDescriptors = parent$A;

	(function (module) {
		module.exports = getOwnPropertyDescriptors;
	} (getOwnPropertyDescriptors$2));

	var _Object$getOwnPropertyDescriptors = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyDescriptorsExports);

	var definePropertiesExports$1 = {};
	var defineProperties$4 = {
	  get exports(){ return definePropertiesExports$1; },
	  set exports(v){ definePropertiesExports$1 = v; },
	};

	var definePropertiesExports = {};
	var defineProperties$3 = {
	  get exports(){ return definePropertiesExports; },
	  set exports(v){ definePropertiesExports = v; },
	};

	var $$q = _export;
	var DESCRIPTORS$6 = descriptors;
	var defineProperties$2 = objectDefineProperties.f;

	// `Object.defineProperties` method
	// https://tc39.es/ecma262/#sec-object.defineproperties
	// eslint-disable-next-line es/no-object-defineproperties -- safe
	$$q({ target: 'Object', stat: true, forced: Object.defineProperties !== defineProperties$2, sham: !DESCRIPTORS$6 }, {
	  defineProperties: defineProperties$2
	});

	var path$b = path$r;

	var Object$1 = path$b.Object;

	var defineProperties$1 = defineProperties$3.exports = function defineProperties(T, D) {
	  return Object$1.defineProperties(T, D);
	};

	if (Object$1.defineProperties.sham) defineProperties$1.sham = true;

	var parent$z = definePropertiesExports;

	var defineProperties = parent$z;

	(function (module) {
		module.exports = defineProperties;
	} (defineProperties$4));

	var _Object$defineProperties = /*@__PURE__*/getDefaultExportFromCjs(definePropertiesExports$1);

	function _defineProperty(obj, key, value) {
	  key = _toPropertyKey(key);
	  if (key in obj) {
	    _Object$defineProperty$1(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }
	  return obj;
	}

	var mapExports = {};
	var map$3 = {
	  get exports(){ return mapExports; },
	  set exports(v){ mapExports = v; },
	};

	var $$p = _export;
	var $map = arrayIteration.map;
	var arrayMethodHasSpeciesSupport$2 = arrayMethodHasSpeciesSupport$5;

	var HAS_SPECIES_SUPPORT$2 = arrayMethodHasSpeciesSupport$2('map');

	// `Array.prototype.map` method
	// https://tc39.es/ecma262/#sec-array.prototype.map
	// with adding support of @@species
	$$p({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT$2 }, {
	  map: function map(callbackfn /* , thisArg */) {
	    return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$g = entryVirtual$k;

	var map$2 = entryVirtual$g('Array').map;

	var isPrototypeOf$h = objectIsPrototypeOf;
	var method$e = map$2;

	var ArrayPrototype$e = Array.prototype;

	var map$1 = function (it) {
	  var own = it.map;
	  return it === ArrayPrototype$e || (isPrototypeOf$h(ArrayPrototype$e, it) && own === ArrayPrototype$e.map) ? method$e : own;
	};

	var parent$y = map$1;

	var map = parent$y;

	(function (module) {
		module.exports = map;
	} (map$3));

	var _mapInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(mapExports);

	var reduceExports = {};
	var reduce$3 = {
	  get exports(){ return reduceExports; },
	  set exports(v){ reduceExports = v; },
	};

	var aCallable$2 = aCallable$7;
	var toObject$6 = toObject$d;
	var IndexedObject$1 = indexedObject;
	var lengthOfArrayLike$6 = lengthOfArrayLike$b;

	var $TypeError$6 = TypeError;

	// `Array.prototype.{ reduce, reduceRight }` methods implementation
	var createMethod$2 = function (IS_RIGHT) {
	  return function (that, callbackfn, argumentsLength, memo) {
	    aCallable$2(callbackfn);
	    var O = toObject$6(that);
	    var self = IndexedObject$1(O);
	    var length = lengthOfArrayLike$6(O);
	    var index = IS_RIGHT ? length - 1 : 0;
	    var i = IS_RIGHT ? -1 : 1;
	    if (argumentsLength < 2) while (true) {
	      if (index in self) {
	        memo = self[index];
	        index += i;
	        break;
	      }
	      index += i;
	      if (IS_RIGHT ? index < 0 : length <= index) {
	        throw $TypeError$6('Reduce of empty array with no initial value');
	      }
	    }
	    for (;IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
	      memo = callbackfn(memo, self[index], index, O);
	    }
	    return memo;
	  };
	};

	var arrayReduce = {
	  // `Array.prototype.reduce` method
	  // https://tc39.es/ecma262/#sec-array.prototype.reduce
	  left: createMethod$2(false),
	  // `Array.prototype.reduceRight` method
	  // https://tc39.es/ecma262/#sec-array.prototype.reduceright
	  right: createMethod$2(true)
	};

	var classof$3 = classofRaw$2;

	var engineIsNode = typeof process != 'undefined' && classof$3(process) == 'process';

	var $$o = _export;
	var $reduce = arrayReduce.left;
	var arrayMethodIsStrict$4 = arrayMethodIsStrict$6;
	var CHROME_VERSION = engineV8Version;
	var IS_NODE = engineIsNode;

	// Chrome 80-82 has a critical bug
	// https://bugs.chromium.org/p/chromium/issues/detail?id=1049982
	var CHROME_BUG = !IS_NODE && CHROME_VERSION > 79 && CHROME_VERSION < 83;
	var FORCED$4 = CHROME_BUG || !arrayMethodIsStrict$4('reduce');

	// `Array.prototype.reduce` method
	// https://tc39.es/ecma262/#sec-array.prototype.reduce
	$$o({ target: 'Array', proto: true, forced: FORCED$4 }, {
	  reduce: function reduce(callbackfn /* , initialValue */) {
	    var length = arguments.length;
	    return $reduce(this, callbackfn, length, length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$f = entryVirtual$k;

	var reduce$2 = entryVirtual$f('Array').reduce;

	var isPrototypeOf$g = objectIsPrototypeOf;
	var method$d = reduce$2;

	var ArrayPrototype$d = Array.prototype;

	var reduce$1 = function (it) {
	  var own = it.reduce;
	  return it === ArrayPrototype$d || (isPrototypeOf$g(ArrayPrototype$d, it) && own === ArrayPrototype$d.reduce) ? method$d : own;
	};

	var parent$x = reduce$1;

	var reduce = parent$x;

	(function (module) {
		module.exports = reduce;
	} (reduce$3));

	var _reduceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(reduceExports);

	var keysExports = {};
	var keys$2 = {
	  get exports(){ return keysExports; },
	  set exports(v){ keysExports = v; },
	};

	var $$n = _export;
	var toObject$5 = toObject$d;
	var nativeKeys = objectKeys$4;
	var fails$a = fails$u;

	var FAILS_ON_PRIMITIVES$1 = fails$a(function () { nativeKeys(1); });

	// `Object.keys` method
	// https://tc39.es/ecma262/#sec-object.keys
	$$n({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES$1 }, {
	  keys: function keys(it) {
	    return nativeKeys(toObject$5(it));
	  }
	});

	var path$a = path$r;

	var keys$1 = path$a.Object.keys;

	var parent$w = keys$1;

	var keys = parent$w;

	(function (module) {
		module.exports = keys;
	} (keys$2));

	var _Object$keys = /*@__PURE__*/getDefaultExportFromCjs(keysExports);

	var definePropertyExports = {};
	var defineProperty$3 = {
	  get exports(){ return definePropertyExports; },
	  set exports(v){ definePropertyExports = v; },
	};

	(function (module) {
		module.exports = defineProperty$9;
	} (defineProperty$3));

	var _Object$defineProperty = /*@__PURE__*/getDefaultExportFromCjs(definePropertyExports);

	var fromExports$2 = {};
	var from$7 = {
	  get exports(){ return fromExports$2; },
	  set exports(v){ fromExports$2 = v; },
	};

	var call$4 = functionCall;
	var anObject$3 = anObject$b;
	var getMethod$1 = getMethod$3;

	var iteratorClose$2 = function (iterator, kind, value) {
	  var innerResult, innerError;
	  anObject$3(iterator);
	  try {
	    innerResult = getMethod$1(iterator, 'return');
	    if (!innerResult) {
	      if (kind === 'throw') throw value;
	      return value;
	    }
	    innerResult = call$4(innerResult, iterator);
	  } catch (error) {
	    innerError = true;
	    innerResult = error;
	  }
	  if (kind === 'throw') throw value;
	  if (innerError) throw innerResult;
	  anObject$3(innerResult);
	  return value;
	};

	var anObject$2 = anObject$b;
	var iteratorClose$1 = iteratorClose$2;

	// call something on iterator step with safe closing on error
	var callWithSafeIterationClosing$1 = function (iterator, fn, value, ENTRIES) {
	  try {
	    return ENTRIES ? fn(anObject$2(value)[0], value[1]) : fn(value);
	  } catch (error) {
	    iteratorClose$1(iterator, 'throw', error);
	  }
	};

	var wellKnownSymbol$6 = wellKnownSymbol$l;
	var Iterators$1 = iterators;

	var ITERATOR$4 = wellKnownSymbol$6('iterator');
	var ArrayPrototype$c = Array.prototype;

	// check on default Array iterator
	var isArrayIteratorMethod$2 = function (it) {
	  return it !== undefined && (Iterators$1.Array === it || ArrayPrototype$c[ITERATOR$4] === it);
	};

	var classof$2 = classof$c;
	var getMethod = getMethod$3;
	var isNullOrUndefined$1 = isNullOrUndefined$4;
	var Iterators = iterators;
	var wellKnownSymbol$5 = wellKnownSymbol$l;

	var ITERATOR$3 = wellKnownSymbol$5('iterator');

	var getIteratorMethod$9 = function (it) {
	  if (!isNullOrUndefined$1(it)) return getMethod(it, ITERATOR$3)
	    || getMethod(it, '@@iterator')
	    || Iterators[classof$2(it)];
	};

	var call$3 = functionCall;
	var aCallable$1 = aCallable$7;
	var anObject$1 = anObject$b;
	var tryToString$2 = tryToString$6;
	var getIteratorMethod$8 = getIteratorMethod$9;

	var $TypeError$5 = TypeError;

	var getIterator$2 = function (argument, usingIterator) {
	  var iteratorMethod = arguments.length < 2 ? getIteratorMethod$8(argument) : usingIterator;
	  if (aCallable$1(iteratorMethod)) return anObject$1(call$3(iteratorMethod, argument));
	  throw $TypeError$5(tryToString$2(argument) + ' is not iterable');
	};

	var bind$2 = functionBindContext;
	var call$2 = functionCall;
	var toObject$4 = toObject$d;
	var callWithSafeIterationClosing = callWithSafeIterationClosing$1;
	var isArrayIteratorMethod$1 = isArrayIteratorMethod$2;
	var isConstructor$1 = isConstructor$4;
	var lengthOfArrayLike$5 = lengthOfArrayLike$b;
	var createProperty$2 = createProperty$6;
	var getIterator$1 = getIterator$2;
	var getIteratorMethod$7 = getIteratorMethod$9;

	var $Array$1 = Array;

	// `Array.from` method implementation
	// https://tc39.es/ecma262/#sec-array.from
	var arrayFrom = function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {
	  var O = toObject$4(arrayLike);
	  var IS_CONSTRUCTOR = isConstructor$1(this);
	  var argumentsLength = arguments.length;
	  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
	  var mapping = mapfn !== undefined;
	  if (mapping) mapfn = bind$2(mapfn, argumentsLength > 2 ? arguments[2] : undefined);
	  var iteratorMethod = getIteratorMethod$7(O);
	  var index = 0;
	  var length, result, step, iterator, next, value;
	  // if the target is not iterable or it's an array with the default iterator - use a simple case
	  if (iteratorMethod && !(this === $Array$1 && isArrayIteratorMethod$1(iteratorMethod))) {
	    iterator = getIterator$1(O, iteratorMethod);
	    next = iterator.next;
	    result = IS_CONSTRUCTOR ? new this() : [];
	    for (;!(step = call$2(next, iterator)).done; index++) {
	      value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true) : step.value;
	      createProperty$2(result, index, value);
	    }
	  } else {
	    length = lengthOfArrayLike$5(O);
	    result = IS_CONSTRUCTOR ? new this(length) : $Array$1(length);
	    for (;length > index; index++) {
	      value = mapping ? mapfn(O[index], index) : O[index];
	      createProperty$2(result, index, value);
	    }
	  }
	  result.length = index;
	  return result;
	};

	var wellKnownSymbol$4 = wellKnownSymbol$l;

	var ITERATOR$2 = wellKnownSymbol$4('iterator');
	var SAFE_CLOSING = false;

	try {
	  var called = 0;
	  var iteratorWithReturn = {
	    next: function () {
	      return { done: !!called++ };
	    },
	    'return': function () {
	      SAFE_CLOSING = true;
	    }
	  };
	  iteratorWithReturn[ITERATOR$2] = function () {
	    return this;
	  };
	  // eslint-disable-next-line es/no-array-from, no-throw-literal -- required for testing
	  Array.from(iteratorWithReturn, function () { throw 2; });
	} catch (error) { /* empty */ }

	var checkCorrectnessOfIteration$1 = function (exec, SKIP_CLOSING) {
	  if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
	  var ITERATION_SUPPORT = false;
	  try {
	    var object = {};
	    object[ITERATOR$2] = function () {
	      return {
	        next: function () {
	          return { done: ITERATION_SUPPORT = true };
	        }
	      };
	    };
	    exec(object);
	  } catch (error) { /* empty */ }
	  return ITERATION_SUPPORT;
	};

	var $$m = _export;
	var from$6 = arrayFrom;
	var checkCorrectnessOfIteration = checkCorrectnessOfIteration$1;

	var INCORRECT_ITERATION = !checkCorrectnessOfIteration(function (iterable) {
	  // eslint-disable-next-line es/no-array-from -- required for testing
	  Array.from(iterable);
	});

	// `Array.from` method
	// https://tc39.es/ecma262/#sec-array.from
	$$m({ target: 'Array', stat: true, forced: INCORRECT_ITERATION }, {
	  from: from$6
	});

	var path$9 = path$r;

	var from$5 = path$9.Array.from;

	var parent$v = from$5;

	var from$4 = parent$v;

	(function (module) {
		module.exports = from$4;
	} (from$7));

	var _Array$from$1 = /*@__PURE__*/getDefaultExportFromCjs(fromExports$2);

	var getIteratorMethodExports$1 = {};
	var getIteratorMethod$6 = {
	  get exports(){ return getIteratorMethodExports$1; },
	  set exports(v){ getIteratorMethodExports$1 = v; },
	};

	var getIteratorMethodExports = {};
	var getIteratorMethod$5 = {
	  get exports(){ return getIteratorMethodExports; },
	  set exports(v){ getIteratorMethodExports = v; },
	};

	var getIteratorMethod$4 = getIteratorMethod$9;

	var getIteratorMethod_1 = getIteratorMethod$4;

	var parent$u = getIteratorMethod_1;


	var getIteratorMethod$3 = parent$u;

	var parent$t = getIteratorMethod$3;

	var getIteratorMethod$2 = parent$t;

	var parent$s = getIteratorMethod$2;

	var getIteratorMethod$1 = parent$s;

	(function (module) {
		module.exports = getIteratorMethod$1;
	} (getIteratorMethod$5));

	(function (module) {
		module.exports = getIteratorMethodExports;
	} (getIteratorMethod$6));

	var _getIteratorMethod = /*@__PURE__*/getDefaultExportFromCjs(getIteratorMethodExports$1);

	var isArrayExports$1 = {};
	var isArray$6 = {
	  get exports(){ return isArrayExports$1; },
	  set exports(v){ isArrayExports$1 = v; },
	};

	var isArrayExports = {};
	var isArray$5 = {
	  get exports(){ return isArrayExports; },
	  set exports(v){ isArrayExports = v; },
	};

	var parent$r = isArray$7;

	var isArray$4 = parent$r;

	var parent$q = isArray$4;

	var isArray$3 = parent$q;

	(function (module) {
		module.exports = isArray$3;
	} (isArray$5));

	(function (module) {
		module.exports = isArrayExports;
	} (isArray$6));

	var _Array$isArray = /*@__PURE__*/getDefaultExportFromCjs(isArrayExports$1);

	function _arrayWithHoles(arr) {
	  if (_Array$isArray(arr)) return arr;
	}

	function _iterableToArrayLimit(arr, i) {
	  var _i = null == arr ? null : "undefined" != typeof _Symbol$1 && _getIteratorMethod(arr) || arr["@@iterator"];
	  if (null != _i) {
	    var _s,
	      _e,
	      _x,
	      _r,
	      _arr = [],
	      _n = !0,
	      _d = !1;
	    try {
	      if (_x = (_i = _i.call(arr)).next, 0 === i) {
	        if (Object(_i) !== _i) return;
	        _n = !1;
	      } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0);
	    } catch (err) {
	      _d = !0, _e = err;
	    } finally {
	      try {
	        if (!_n && null != _i["return"] && (_r = _i["return"](), Object(_r) !== _r)) return;
	      } finally {
	        if (_d) throw _e;
	      }
	    }
	    return _arr;
	  }
	}

	var sliceExports$2 = {};
	var slice$7 = {
	  get exports(){ return sliceExports$2; },
	  set exports(v){ sliceExports$2 = v; },
	};

	var sliceExports$1 = {};
	var slice$6 = {
	  get exports(){ return sliceExports$1; },
	  set exports(v){ sliceExports$1 = v; },
	};

	var $$l = _export;
	var isArray$2 = isArray$e;
	var isConstructor = isConstructor$4;
	var isObject$5 = isObject$g;
	var toAbsoluteIndex$2 = toAbsoluteIndex$5;
	var lengthOfArrayLike$4 = lengthOfArrayLike$b;
	var toIndexedObject$1 = toIndexedObject$b;
	var createProperty$1 = createProperty$6;
	var wellKnownSymbol$3 = wellKnownSymbol$l;
	var arrayMethodHasSpeciesSupport$1 = arrayMethodHasSpeciesSupport$5;
	var nativeSlice = arraySlice$5;

	var HAS_SPECIES_SUPPORT$1 = arrayMethodHasSpeciesSupport$1('slice');

	var SPECIES$1 = wellKnownSymbol$3('species');
	var $Array = Array;
	var max$1 = Math.max;

	// `Array.prototype.slice` method
	// https://tc39.es/ecma262/#sec-array.prototype.slice
	// fallback for not array-like ES3 strings and DOM objects
	$$l({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT$1 }, {
	  slice: function slice(start, end) {
	    var O = toIndexedObject$1(this);
	    var length = lengthOfArrayLike$4(O);
	    var k = toAbsoluteIndex$2(start, length);
	    var fin = toAbsoluteIndex$2(end === undefined ? length : end, length);
	    // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible
	    var Constructor, result, n;
	    if (isArray$2(O)) {
	      Constructor = O.constructor;
	      // cross-realm fallback
	      if (isConstructor(Constructor) && (Constructor === $Array || isArray$2(Constructor.prototype))) {
	        Constructor = undefined;
	      } else if (isObject$5(Constructor)) {
	        Constructor = Constructor[SPECIES$1];
	        if (Constructor === null) Constructor = undefined;
	      }
	      if (Constructor === $Array || Constructor === undefined) {
	        return nativeSlice(O, k, fin);
	      }
	    }
	    result = new (Constructor === undefined ? $Array : Constructor)(max$1(fin - k, 0));
	    for (n = 0; k < fin; k++, n++) if (k in O) createProperty$1(result, n, O[k]);
	    result.length = n;
	    return result;
	  }
	});

	var entryVirtual$e = entryVirtual$k;

	var slice$5 = entryVirtual$e('Array').slice;

	var isPrototypeOf$f = objectIsPrototypeOf;
	var method$c = slice$5;

	var ArrayPrototype$b = Array.prototype;

	var slice$4 = function (it) {
	  var own = it.slice;
	  return it === ArrayPrototype$b || (isPrototypeOf$f(ArrayPrototype$b, it) && own === ArrayPrototype$b.slice) ? method$c : own;
	};

	var parent$p = slice$4;

	var slice$3 = parent$p;

	var parent$o = slice$3;

	var slice$2 = parent$o;

	var parent$n = slice$2;

	var slice$1 = parent$n;

	(function (module) {
		module.exports = slice$1;
	} (slice$6));

	(function (module) {
		module.exports = sliceExports$1;
	} (slice$7));

	var _sliceInstanceProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(sliceExports$2);

	var fromExports$1 = {};
	var from$3 = {
	  get exports(){ return fromExports$1; },
	  set exports(v){ fromExports$1 = v; },
	};

	var fromExports = {};
	var from$2 = {
	  get exports(){ return fromExports; },
	  set exports(v){ fromExports = v; },
	};

	var parent$m = from$4;

	var from$1 = parent$m;

	var parent$l = from$1;

	var from = parent$l;

	(function (module) {
		module.exports = from;
	} (from$2));

	(function (module) {
		module.exports = fromExports;
	} (from$3));

	var _Array$from = /*@__PURE__*/getDefaultExportFromCjs(fromExports$1);

	function _arrayLikeToArray$7(arr, len) {
	  if (len == null || len > arr.length) len = arr.length;
	  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
	  return arr2;
	}

	function _unsupportedIterableToArray$7(o, minLen) {
	  var _context;
	  if (!o) return;
	  if (typeof o === "string") return _arrayLikeToArray$7(o, minLen);
	  var n = _sliceInstanceProperty$1(_context = Object.prototype.toString.call(o)).call(_context, 8, -1);
	  if (n === "Object" && o.constructor) n = o.constructor.name;
	  if (n === "Map" || n === "Set") return _Array$from(o);
	  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$7(o, minLen);
	}

	function _nonIterableRest() {
	  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	function _slicedToArray(arr, i) {
	  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray$7(arr, i) || _nonIterableRest();
	}

	function _arrayWithoutHoles(arr) {
	  if (_Array$isArray(arr)) return _arrayLikeToArray$7(arr);
	}

	function _iterableToArray(iter) {
	  if (typeof _Symbol$1 !== "undefined" && _getIteratorMethod(iter) != null || iter["@@iterator"] != null) return _Array$from(iter);
	}

	function _nonIterableSpread() {
	  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	function _toConsumableArray(arr) {
	  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray$7(arr) || _nonIterableSpread();
	}

	var symbolExports = {};
	var symbol = {
	  get exports(){ return symbolExports; },
	  set exports(v){ symbolExports = v; },
	};

	(function (module) {
		module.exports = symbol$3;
	} (symbol));

	var _Symbol = /*@__PURE__*/getDefaultExportFromCjs(symbolExports);

	var concatExports = {};
	var concat$4 = {
	  get exports(){ return concatExports; },
	  set exports(v){ concatExports = v; },
	};

	var entryVirtual$d = entryVirtual$k;

	var concat$3 = entryVirtual$d('Array').concat;

	var isPrototypeOf$e = objectIsPrototypeOf;
	var method$b = concat$3;

	var ArrayPrototype$a = Array.prototype;

	var concat$2 = function (it) {
	  var own = it.concat;
	  return it === ArrayPrototype$a || (isPrototypeOf$e(ArrayPrototype$a, it) && own === ArrayPrototype$a.concat) ? method$b : own;
	};

	var parent$k = concat$2;

	var concat$1 = parent$k;

	(function (module) {
		module.exports = concat$1;
	} (concat$4));

	var _concatInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(concatExports);

	var sliceExports = {};
	var slice = {
	  get exports(){ return sliceExports; },
	  set exports(v){ sliceExports = v; },
	};

	(function (module) {
		module.exports = slice$3;
	} (slice));

	var _sliceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(sliceExports);

	var ownKeysExports = {};
	var ownKeys$5 = {
	  get exports(){ return ownKeysExports; },
	  set exports(v){ ownKeysExports = v; },
	};

	var $$k = _export;
	var ownKeys$4 = ownKeys$7;

	// `Reflect.ownKeys` method
	// https://tc39.es/ecma262/#sec-reflect.ownkeys
	$$k({ target: 'Reflect', stat: true }, {
	  ownKeys: ownKeys$4
	});

	var path$8 = path$r;

	var ownKeys$3 = path$8.Reflect.ownKeys;

	var parent$j = ownKeys$3;

	var ownKeys$2 = parent$j;

	(function (module) {
		module.exports = ownKeys$2;
	} (ownKeys$5));

	var _Reflect$ownKeys = /*@__PURE__*/getDefaultExportFromCjs(ownKeysExports);

	var nowExports = {};
	var now$3 = {
	  get exports(){ return nowExports; },
	  set exports(v){ nowExports = v; },
	};

	// TODO: Remove from `core-js@4`
	var $$j = _export;
	var uncurryThis$a = functionUncurryThis;

	var $Date = Date;
	var thisTimeValue = uncurryThis$a($Date.prototype.getTime);

	// `Date.now` method
	// https://tc39.es/ecma262/#sec-date.now
	$$j({ target: 'Date', stat: true }, {
	  now: function now() {
	    return thisTimeValue(new $Date());
	  }
	});

	var path$7 = path$r;

	var now$2 = path$7.Date.now;

	var parent$i = now$2;

	var now$1 = parent$i;

	(function (module) {
		module.exports = now$1;
	} (now$3));

	var _Date$now = /*@__PURE__*/getDefaultExportFromCjs(nowExports);

	var reverseExports = {};
	var reverse$3 = {
	  get exports(){ return reverseExports; },
	  set exports(v){ reverseExports = v; },
	};

	var $$i = _export;
	var uncurryThis$9 = functionUncurryThis;
	var isArray$1 = isArray$e;

	var nativeReverse = uncurryThis$9([].reverse);
	var test$1 = [1, 2];

	// `Array.prototype.reverse` method
	// https://tc39.es/ecma262/#sec-array.prototype.reverse
	// fix for Safari 12.0 bug
	// https://bugs.webkit.org/show_bug.cgi?id=188794
	$$i({ target: 'Array', proto: true, forced: String(test$1) === String(test$1.reverse()) }, {
	  reverse: function reverse() {
	    // eslint-disable-next-line no-self-assign -- dirty hack
	    if (isArray$1(this)) this.length = this.length;
	    return nativeReverse(this);
	  }
	});

	var entryVirtual$c = entryVirtual$k;

	var reverse$2 = entryVirtual$c('Array').reverse;

	var isPrototypeOf$d = objectIsPrototypeOf;
	var method$a = reverse$2;

	var ArrayPrototype$9 = Array.prototype;

	var reverse$1 = function (it) {
	  var own = it.reverse;
	  return it === ArrayPrototype$9 || (isPrototypeOf$d(ArrayPrototype$9, it) && own === ArrayPrototype$9.reverse) ? method$a : own;
	};

	var parent$h = reverse$1;

	var reverse = parent$h;

	(function (module) {
		module.exports = reverse;
	} (reverse$3));

	var _reverseInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(reverseExports);

	var spliceExports = {};
	var splice$3 = {
	  get exports(){ return spliceExports; },
	  set exports(v){ spliceExports = v; },
	};

	var DESCRIPTORS$5 = descriptors;
	var isArray = isArray$e;

	var $TypeError$4 = TypeError;
	// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
	var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

	// Safari < 13 does not throw an error in this case
	var SILENT_ON_NON_WRITABLE_LENGTH_SET = DESCRIPTORS$5 && !function () {
	  // makes no sense without proper strict mode support
	  if (this !== undefined) return true;
	  try {
	    // eslint-disable-next-line es/no-object-defineproperty -- safe
	    Object.defineProperty([], 'length', { writable: false }).length = 1;
	  } catch (error) {
	    return error instanceof TypeError;
	  }
	}();

	var arraySetLength = SILENT_ON_NON_WRITABLE_LENGTH_SET ? function (O, length) {
	  if (isArray(O) && !getOwnPropertyDescriptor(O, 'length').writable) {
	    throw $TypeError$4('Cannot set read only .length');
	  } return O.length = length;
	} : function (O, length) {
	  return O.length = length;
	};

	var tryToString$1 = tryToString$6;

	var $TypeError$3 = TypeError;

	var deletePropertyOrThrow$2 = function (O, P) {
	  if (!delete O[P]) throw $TypeError$3('Cannot delete property ' + tryToString$1(P) + ' of ' + tryToString$1(O));
	};

	var $$h = _export;
	var toObject$3 = toObject$d;
	var toAbsoluteIndex$1 = toAbsoluteIndex$5;
	var toIntegerOrInfinity$1 = toIntegerOrInfinity$5;
	var lengthOfArrayLike$3 = lengthOfArrayLike$b;
	var setArrayLength = arraySetLength;
	var doesNotExceedSafeInteger = doesNotExceedSafeInteger$2;
	var arraySpeciesCreate = arraySpeciesCreate$3;
	var createProperty = createProperty$6;
	var deletePropertyOrThrow$1 = deletePropertyOrThrow$2;
	var arrayMethodHasSpeciesSupport = arrayMethodHasSpeciesSupport$5;

	var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('splice');

	var max = Math.max;
	var min = Math.min;

	// `Array.prototype.splice` method
	// https://tc39.es/ecma262/#sec-array.prototype.splice
	// with adding support of @@species
	$$h({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
	  splice: function splice(start, deleteCount /* , ...items */) {
	    var O = toObject$3(this);
	    var len = lengthOfArrayLike$3(O);
	    var actualStart = toAbsoluteIndex$1(start, len);
	    var argumentsLength = arguments.length;
	    var insertCount, actualDeleteCount, A, k, from, to;
	    if (argumentsLength === 0) {
	      insertCount = actualDeleteCount = 0;
	    } else if (argumentsLength === 1) {
	      insertCount = 0;
	      actualDeleteCount = len - actualStart;
	    } else {
	      insertCount = argumentsLength - 2;
	      actualDeleteCount = min(max(toIntegerOrInfinity$1(deleteCount), 0), len - actualStart);
	    }
	    doesNotExceedSafeInteger(len + insertCount - actualDeleteCount);
	    A = arraySpeciesCreate(O, actualDeleteCount);
	    for (k = 0; k < actualDeleteCount; k++) {
	      from = actualStart + k;
	      if (from in O) createProperty(A, k, O[from]);
	    }
	    A.length = actualDeleteCount;
	    if (insertCount < actualDeleteCount) {
	      for (k = actualStart; k < len - actualDeleteCount; k++) {
	        from = k + actualDeleteCount;
	        to = k + insertCount;
	        if (from in O) O[to] = O[from];
	        else deletePropertyOrThrow$1(O, to);
	      }
	      for (k = len; k > len - actualDeleteCount + insertCount; k--) deletePropertyOrThrow$1(O, k - 1);
	    } else if (insertCount > actualDeleteCount) {
	      for (k = len - actualDeleteCount; k > actualStart; k--) {
	        from = k + actualDeleteCount - 1;
	        to = k + insertCount - 1;
	        if (from in O) O[to] = O[from];
	        else deletePropertyOrThrow$1(O, to);
	      }
	    }
	    for (k = 0; k < insertCount; k++) {
	      O[k + actualStart] = arguments[k + 2];
	    }
	    setArrayLength(O, len - actualDeleteCount + insertCount);
	    return A;
	  }
	});

	var entryVirtual$b = entryVirtual$k;

	var splice$2 = entryVirtual$b('Array').splice;

	var isPrototypeOf$c = objectIsPrototypeOf;
	var method$9 = splice$2;

	var ArrayPrototype$8 = Array.prototype;

	var splice$1 = function (it) {
	  var own = it.splice;
	  return it === ArrayPrototype$8 || (isPrototypeOf$c(ArrayPrototype$8, it) && own === ArrayPrototype$8.splice) ? method$9 : own;
	};

	var parent$g = splice$1;

	var splice = parent$g;

	(function (module) {
		module.exports = splice;
	} (splice$3));

	var _spliceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(spliceExports);

	var assignExports = {};
	var assign$5 = {
	  get exports(){ return assignExports; },
	  set exports(v){ assignExports = v; },
	};

	var DESCRIPTORS$4 = descriptors;
	var uncurryThis$8 = functionUncurryThis;
	var call$1 = functionCall;
	var fails$9 = fails$u;
	var objectKeys$1 = objectKeys$4;
	var getOwnPropertySymbolsModule = objectGetOwnPropertySymbols;
	var propertyIsEnumerableModule = objectPropertyIsEnumerable;
	var toObject$2 = toObject$d;
	var IndexedObject = indexedObject;

	// eslint-disable-next-line es/no-object-assign -- safe
	var $assign = Object.assign;
	// eslint-disable-next-line es/no-object-defineproperty -- required for testing
	var defineProperty$2 = Object.defineProperty;
	var concat = uncurryThis$8([].concat);

	// `Object.assign` method
	// https://tc39.es/ecma262/#sec-object.assign
	var objectAssign = !$assign || fails$9(function () {
	  // should have correct order of operations (Edge bug)
	  if (DESCRIPTORS$4 && $assign({ b: 1 }, $assign(defineProperty$2({}, 'a', {
	    enumerable: true,
	    get: function () {
	      defineProperty$2(this, 'b', {
	        value: 3,
	        enumerable: false
	      });
	    }
	  }), { b: 2 })).b !== 1) return true;
	  // should work with symbols and should have deterministic property order (V8 bug)
	  var A = {};
	  var B = {};
	  // eslint-disable-next-line es/no-symbol -- safe
	  var symbol = Symbol();
	  var alphabet = 'abcdefghijklmnopqrst';
	  A[symbol] = 7;
	  alphabet.split('').forEach(function (chr) { B[chr] = chr; });
	  return $assign({}, A)[symbol] != 7 || objectKeys$1($assign({}, B)).join('') != alphabet;
	}) ? function assign(target, source) { // eslint-disable-line no-unused-vars -- required for `.length`
	  var T = toObject$2(target);
	  var argumentsLength = arguments.length;
	  var index = 1;
	  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
	  var propertyIsEnumerable = propertyIsEnumerableModule.f;
	  while (argumentsLength > index) {
	    var S = IndexedObject(arguments[index++]);
	    var keys = getOwnPropertySymbols ? concat(objectKeys$1(S), getOwnPropertySymbols(S)) : objectKeys$1(S);
	    var length = keys.length;
	    var j = 0;
	    var key;
	    while (length > j) {
	      key = keys[j++];
	      if (!DESCRIPTORS$4 || call$1(propertyIsEnumerable, S, key)) T[key] = S[key];
	    }
	  } return T;
	} : $assign;

	var $$g = _export;
	var assign$4 = objectAssign;

	// `Object.assign` method
	// https://tc39.es/ecma262/#sec-object.assign
	// eslint-disable-next-line es/no-object-assign -- required for testing
	$$g({ target: 'Object', stat: true, arity: 2, forced: Object.assign !== assign$4 }, {
	  assign: assign$4
	});

	var path$6 = path$r;

	var assign$3 = path$6.Object.assign;

	var parent$f = assign$3;

	var assign$2 = parent$f;

	(function (module) {
		module.exports = assign$2;
	} (assign$5));

	var _Object$assign = /*@__PURE__*/getDefaultExportFromCjs(assignExports);

	var includesExports = {};
	var includes$4 = {
	  get exports(){ return includesExports; },
	  set exports(v){ includesExports = v; },
	};

	var $$f = _export;
	var $includes = arrayIncludes.includes;
	var fails$8 = fails$u;

	// FF99+ bug
	var BROKEN_ON_SPARSE = fails$8(function () {
	  // eslint-disable-next-line es/no-array-prototype-includes -- detection
	  return !Array(1).includes();
	});

	// `Array.prototype.includes` method
	// https://tc39.es/ecma262/#sec-array.prototype.includes
	$$f({ target: 'Array', proto: true, forced: BROKEN_ON_SPARSE }, {
	  includes: function includes(el /* , fromIndex = 0 */) {
	    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$a = entryVirtual$k;

	var includes$3 = entryVirtual$a('Array').includes;

	var isObject$4 = isObject$g;
	var classof$1 = classofRaw$2;
	var wellKnownSymbol$2 = wellKnownSymbol$l;

	var MATCH$1 = wellKnownSymbol$2('match');

	// `IsRegExp` abstract operation
	// https://tc39.es/ecma262/#sec-isregexp
	var isRegexp = function (it) {
	  var isRegExp;
	  return isObject$4(it) && ((isRegExp = it[MATCH$1]) !== undefined ? !!isRegExp : classof$1(it) == 'RegExp');
	};

	var isRegExp = isRegexp;

	var $TypeError$2 = TypeError;

	var notARegexp = function (it) {
	  if (isRegExp(it)) {
	    throw $TypeError$2("The method doesn't accept regular expressions");
	  } return it;
	};

	var wellKnownSymbol$1 = wellKnownSymbol$l;

	var MATCH = wellKnownSymbol$1('match');

	var correctIsRegexpLogic = function (METHOD_NAME) {
	  var regexp = /./;
	  try {
	    '/./'[METHOD_NAME](regexp);
	  } catch (error1) {
	    try {
	      regexp[MATCH] = false;
	      return '/./'[METHOD_NAME](regexp);
	    } catch (error2) { /* empty */ }
	  } return false;
	};

	var $$e = _export;
	var uncurryThis$7 = functionUncurryThis;
	var notARegExp = notARegexp;
	var requireObjectCoercible$2 = requireObjectCoercible$6;
	var toString$5 = toString$b;
	var correctIsRegExpLogic = correctIsRegexpLogic;

	var stringIndexOf = uncurryThis$7(''.indexOf);

	// `String.prototype.includes` method
	// https://tc39.es/ecma262/#sec-string.prototype.includes
	$$e({ target: 'String', proto: true, forced: !correctIsRegExpLogic('includes') }, {
	  includes: function includes(searchString /* , position = 0 */) {
	    return !!~stringIndexOf(
	      toString$5(requireObjectCoercible$2(this)),
	      toString$5(notARegExp(searchString)),
	      arguments.length > 1 ? arguments[1] : undefined
	    );
	  }
	});

	var entryVirtual$9 = entryVirtual$k;

	var includes$2 = entryVirtual$9('String').includes;

	var isPrototypeOf$b = objectIsPrototypeOf;
	var arrayMethod = includes$3;
	var stringMethod = includes$2;

	var ArrayPrototype$7 = Array.prototype;
	var StringPrototype$2 = String.prototype;

	var includes$1 = function (it) {
	  var own = it.includes;
	  if (it === ArrayPrototype$7 || (isPrototypeOf$b(ArrayPrototype$7, it) && own === ArrayPrototype$7.includes)) return arrayMethod;
	  if (typeof it == 'string' || it === StringPrototype$2 || (isPrototypeOf$b(StringPrototype$2, it) && own === StringPrototype$2.includes)) {
	    return stringMethod;
	  } return own;
	};

	var parent$e = includes$1;

	var includes = parent$e;

	(function (module) {
		module.exports = includes;
	} (includes$4));

	var _includesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(includesExports);

	var getPrototypeOfExports = {};
	var getPrototypeOf = {
	  get exports(){ return getPrototypeOfExports; },
	  set exports(v){ getPrototypeOfExports = v; },
	};

	(function (module) {
		module.exports = getPrototypeOf$3;
	} (getPrototypeOf));

	var _Object$getPrototypeOf = /*@__PURE__*/getDefaultExportFromCjs(getPrototypeOfExports);

	var valuesExports = {};
	var values$2 = {
	  get exports(){ return valuesExports; },
	  set exports(v){ valuesExports = v; },
	};

	var DESCRIPTORS$3 = descriptors;
	var uncurryThis$6 = functionUncurryThis;
	var objectKeys = objectKeys$4;
	var toIndexedObject = toIndexedObject$b;
	var $propertyIsEnumerable = objectPropertyIsEnumerable.f;

	var propertyIsEnumerable = uncurryThis$6($propertyIsEnumerable);
	var push$1 = uncurryThis$6([].push);

	// `Object.{ entries, values }` methods implementation
	var createMethod$1 = function (TO_ENTRIES) {
	  return function (it) {
	    var O = toIndexedObject(it);
	    var keys = objectKeys(O);
	    var length = keys.length;
	    var i = 0;
	    var result = [];
	    var key;
	    while (length > i) {
	      key = keys[i++];
	      if (!DESCRIPTORS$3 || propertyIsEnumerable(O, key)) {
	        push$1(result, TO_ENTRIES ? [key, O[key]] : O[key]);
	      }
	    }
	    return result;
	  };
	};

	var objectToArray = {
	  // `Object.entries` method
	  // https://tc39.es/ecma262/#sec-object.entries
	  entries: createMethod$1(true),
	  // `Object.values` method
	  // https://tc39.es/ecma262/#sec-object.values
	  values: createMethod$1(false)
	};

	var $$d = _export;
	var $values = objectToArray.values;

	// `Object.values` method
	// https://tc39.es/ecma262/#sec-object.values
	$$d({ target: 'Object', stat: true }, {
	  values: function values(O) {
	    return $values(O);
	  }
	});

	var path$5 = path$r;

	var values$1 = path$5.Object.values;

	var parent$d = values$1;

	var values = parent$d;

	(function (module) {
		module.exports = values;
	} (values$2));

	var _Object$values2 = /*@__PURE__*/getDefaultExportFromCjs(valuesExports);

	var _parseIntExports = {};
	var _parseInt$3 = {
	  get exports(){ return _parseIntExports; },
	  set exports(v){ _parseIntExports = v; },
	};

	// a string of all valid unicode whitespaces
	var whitespaces$4 = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' +
	  '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

	var uncurryThis$5 = functionUncurryThis;
	var requireObjectCoercible$1 = requireObjectCoercible$6;
	var toString$4 = toString$b;
	var whitespaces$3 = whitespaces$4;

	var replace = uncurryThis$5(''.replace);
	var ltrim = RegExp('^[' + whitespaces$3 + ']+');
	var rtrim = RegExp('(^|[^' + whitespaces$3 + '])[' + whitespaces$3 + ']+$');

	// `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation
	var createMethod = function (TYPE) {
	  return function ($this) {
	    var string = toString$4(requireObjectCoercible$1($this));
	    if (TYPE & 1) string = replace(string, ltrim, '');
	    if (TYPE & 2) string = replace(string, rtrim, '$1');
	    return string;
	  };
	};

	var stringTrim = {
	  // `String.prototype.{ trimLeft, trimStart }` methods
	  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
	  start: createMethod(1),
	  // `String.prototype.{ trimRight, trimEnd }` methods
	  // https://tc39.es/ecma262/#sec-string.prototype.trimend
	  end: createMethod(2),
	  // `String.prototype.trim` method
	  // https://tc39.es/ecma262/#sec-string.prototype.trim
	  trim: createMethod(3)
	};

	var global$3 = global$j;
	var fails$7 = fails$u;
	var uncurryThis$4 = functionUncurryThis;
	var toString$3 = toString$b;
	var trim$5 = stringTrim.trim;
	var whitespaces$2 = whitespaces$4;

	var $parseInt$1 = global$3.parseInt;
	var Symbol$2 = global$3.Symbol;
	var ITERATOR$1 = Symbol$2 && Symbol$2.iterator;
	var hex = /^[+-]?0x/i;
	var exec = uncurryThis$4(hex.exec);
	var FORCED$3 = $parseInt$1(whitespaces$2 + '08') !== 8 || $parseInt$1(whitespaces$2 + '0x16') !== 22
	  // MS Edge 18- broken with boxed symbols
	  || (ITERATOR$1 && !fails$7(function () { $parseInt$1(Object(ITERATOR$1)); }));

	// `parseInt` method
	// https://tc39.es/ecma262/#sec-parseint-string-radix
	var numberParseInt = FORCED$3 ? function parseInt(string, radix) {
	  var S = trim$5(toString$3(string));
	  return $parseInt$1(S, (radix >>> 0) || (exec(hex, S) ? 16 : 10));
	} : $parseInt$1;

	var $$c = _export;
	var $parseInt = numberParseInt;

	// `parseInt` method
	// https://tc39.es/ecma262/#sec-parseint-string-radix
	$$c({ global: true, forced: parseInt != $parseInt }, {
	  parseInt: $parseInt
	});

	var path$4 = path$r;

	var _parseInt$2 = path$4.parseInt;

	var parent$c = _parseInt$2;

	var _parseInt$1 = parent$c;

	(function (module) {
		module.exports = _parseInt$1;
	} (_parseInt$3));

	var _parseInt = /*@__PURE__*/getDefaultExportFromCjs(_parseIntExports);

	var indexOfExports = {};
	var indexOf$3 = {
	  get exports(){ return indexOfExports; },
	  set exports(v){ indexOfExports = v; },
	};

	/* eslint-disable es/no-array-prototype-indexof -- required for testing */
	var $$b = _export;
	var uncurryThis$3 = functionUncurryThisClause;
	var $indexOf = arrayIncludes.indexOf;
	var arrayMethodIsStrict$3 = arrayMethodIsStrict$6;

	var nativeIndexOf = uncurryThis$3([].indexOf);

	var NEGATIVE_ZERO = !!nativeIndexOf && 1 / nativeIndexOf([1], 1, -0) < 0;
	var FORCED$2 = NEGATIVE_ZERO || !arrayMethodIsStrict$3('indexOf');

	// `Array.prototype.indexOf` method
	// https://tc39.es/ecma262/#sec-array.prototype.indexof
	$$b({ target: 'Array', proto: true, forced: FORCED$2 }, {
	  indexOf: function indexOf(searchElement /* , fromIndex = 0 */) {
	    var fromIndex = arguments.length > 1 ? arguments[1] : undefined;
	    return NEGATIVE_ZERO
	      // convert -0 to +0
	      ? nativeIndexOf(this, searchElement, fromIndex) || 0
	      : $indexOf(this, searchElement, fromIndex);
	  }
	});

	var entryVirtual$8 = entryVirtual$k;

	var indexOf$2 = entryVirtual$8('Array').indexOf;

	var isPrototypeOf$a = objectIsPrototypeOf;
	var method$8 = indexOf$2;

	var ArrayPrototype$6 = Array.prototype;

	var indexOf$1 = function (it) {
	  var own = it.indexOf;
	  return it === ArrayPrototype$6 || (isPrototypeOf$a(ArrayPrototype$6, it) && own === ArrayPrototype$6.indexOf) ? method$8 : own;
	};

	var parent$b = indexOf$1;

	var indexOf = parent$b;

	(function (module) {
		module.exports = indexOf;
	} (indexOf$3));

	var _indexOfInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(indexOfExports);

	var trimExports = {};
	var trim$4 = {
	  get exports(){ return trimExports; },
	  set exports(v){ trimExports = v; },
	};

	var PROPER_FUNCTION_NAME = functionName.PROPER;
	var fails$6 = fails$u;
	var whitespaces$1 = whitespaces$4;

	var non = '\u200B\u0085\u180E';

	// check that a method works with the correct list
	// of whitespaces and has a correct name
	var stringTrimForced = function (METHOD_NAME) {
	  return fails$6(function () {
	    return !!whitespaces$1[METHOD_NAME]()
	      || non[METHOD_NAME]() !== non
	      || (PROPER_FUNCTION_NAME && whitespaces$1[METHOD_NAME].name !== METHOD_NAME);
	  });
	};

	var $$a = _export;
	var $trim = stringTrim.trim;
	var forcedStringTrimMethod = stringTrimForced;

	// `String.prototype.trim` method
	// https://tc39.es/ecma262/#sec-string.prototype.trim
	$$a({ target: 'String', proto: true, forced: forcedStringTrimMethod('trim') }, {
	  trim: function trim() {
	    return $trim(this);
	  }
	});

	var entryVirtual$7 = entryVirtual$k;

	var trim$3 = entryVirtual$7('String').trim;

	var isPrototypeOf$9 = objectIsPrototypeOf;
	var method$7 = trim$3;

	var StringPrototype$1 = String.prototype;

	var trim$2 = function (it) {
	  var own = it.trim;
	  return typeof it == 'string' || it === StringPrototype$1
	    || (isPrototypeOf$9(StringPrototype$1, it) && own === StringPrototype$1.trim) ? method$7 : own;
	};

	var parent$a = trim$2;

	var trim$1 = parent$a;

	(function (module) {
		module.exports = trim$1;
	} (trim$4));

	var _trimInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(trimExports);

	var createExports = {};
	var create$1 = {
	  get exports(){ return createExports; },
	  set exports(v){ createExports = v; },
	};

	(function (module) {
		module.exports = create$4;
	} (create$1));

	var _Object$create = /*@__PURE__*/getDefaultExportFromCjs(createExports);

	var stringifyExports = {};
	var stringify$2 = {
	  get exports(){ return stringifyExports; },
	  set exports(v){ stringifyExports = v; },
	};

	var path$3 = path$r;
	var apply = functionApply;

	// eslint-disable-next-line es/no-json -- safe
	if (!path$3.JSON) path$3.JSON = { stringify: JSON.stringify };

	// eslint-disable-next-line no-unused-vars -- required for `.length`
	var stringify$1 = function stringify(it, replacer, space) {
	  return apply(path$3.JSON.stringify, null, arguments);
	};

	var parent$9 = stringify$1;

	var stringify = parent$9;

	(function (module) {
		module.exports = stringify;
	} (stringify$2));

	var _JSON$stringify = /*@__PURE__*/getDefaultExportFromCjs(stringifyExports);

	var fillExports = {};
	var fill$4 = {
	  get exports(){ return fillExports; },
	  set exports(v){ fillExports = v; },
	};

	var toObject$1 = toObject$d;
	var toAbsoluteIndex = toAbsoluteIndex$5;
	var lengthOfArrayLike$2 = lengthOfArrayLike$b;

	// `Array.prototype.fill` method implementation
	// https://tc39.es/ecma262/#sec-array.prototype.fill
	var arrayFill = function fill(value /* , start = 0, end = @length */) {
	  var O = toObject$1(this);
	  var length = lengthOfArrayLike$2(O);
	  var argumentsLength = arguments.length;
	  var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
	  var end = argumentsLength > 2 ? arguments[2] : undefined;
	  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);
	  while (endPos > index) O[index++] = value;
	  return O;
	};

	var $$9 = _export;
	var fill$3 = arrayFill;

	// `Array.prototype.fill` method
	// https://tc39.es/ecma262/#sec-array.prototype.fill
	$$9({ target: 'Array', proto: true }, {
	  fill: fill$3
	});

	var entryVirtual$6 = entryVirtual$k;

	var fill$2 = entryVirtual$6('Array').fill;

	var isPrototypeOf$8 = objectIsPrototypeOf;
	var method$6 = fill$2;

	var ArrayPrototype$5 = Array.prototype;

	var fill$1 = function (it) {
	  var own = it.fill;
	  return it === ArrayPrototype$5 || (isPrototypeOf$8(ArrayPrototype$5, it) && own === ArrayPrototype$5.fill) ? method$6 : own;
	};

	var parent$8 = fill$1;

	var fill = parent$8;

	(function (module) {
		module.exports = fill;
	} (fill$4));

	var _fillInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(fillExports);

	var componentEmitterExports = {};
	var componentEmitter = {
	  get exports(){ return componentEmitterExports; },
	  set exports(v){ componentEmitterExports = v; },
	};

	(function (module) {
		/**
		 * Expose `Emitter`.
		 */

		{
		  module.exports = Emitter;
		}

		/**
		 * Initialize a new `Emitter`.
		 *
		 * @api public
		 */

		function Emitter(obj) {
		  if (obj) return mixin(obj);
		}
		/**
		 * Mixin the emitter properties.
		 *
		 * @param {Object} obj
		 * @return {Object}
		 * @api private
		 */

		function mixin(obj) {
		  for (var key in Emitter.prototype) {
		    obj[key] = Emitter.prototype[key];
		  }
		  return obj;
		}

		/**
		 * Listen on the given `event` with `fn`.
		 *
		 * @param {String} event
		 * @param {Function} fn
		 * @return {Emitter}
		 * @api public
		 */

		Emitter.prototype.on =
		Emitter.prototype.addEventListener = function(event, fn){
		  this._callbacks = this._callbacks || {};
		  (this._callbacks['$' + event] = this._callbacks['$' + event] || [])
		    .push(fn);
		  return this;
		};

		/**
		 * Adds an `event` listener that will be invoked a single
		 * time then automatically removed.
		 *
		 * @param {String} event
		 * @param {Function} fn
		 * @return {Emitter}
		 * @api public
		 */

		Emitter.prototype.once = function(event, fn){
		  function on() {
		    this.off(event, on);
		    fn.apply(this, arguments);
		  }

		  on.fn = fn;
		  this.on(event, on);
		  return this;
		};

		/**
		 * Remove the given callback for `event` or all
		 * registered callbacks.
		 *
		 * @param {String} event
		 * @param {Function} fn
		 * @return {Emitter}
		 * @api public
		 */

		Emitter.prototype.off =
		Emitter.prototype.removeListener =
		Emitter.prototype.removeAllListeners =
		Emitter.prototype.removeEventListener = function(event, fn){
		  this._callbacks = this._callbacks || {};

		  // all
		  if (0 == arguments.length) {
		    this._callbacks = {};
		    return this;
		  }

		  // specific event
		  var callbacks = this._callbacks['$' + event];
		  if (!callbacks) return this;

		  // remove all handlers
		  if (1 == arguments.length) {
		    delete this._callbacks['$' + event];
		    return this;
		  }

		  // remove specific handler
		  var cb;
		  for (var i = 0; i < callbacks.length; i++) {
		    cb = callbacks[i];
		    if (cb === fn || cb.fn === fn) {
		      callbacks.splice(i, 1);
		      break;
		    }
		  }

		  // Remove event specific arrays for event types that no
		  // one is subscribed for to avoid memory leak.
		  if (callbacks.length === 0) {
		    delete this._callbacks['$' + event];
		  }

		  return this;
		};

		/**
		 * Emit `event` with the given args.
		 *
		 * @param {String} event
		 * @param {Mixed} ...
		 * @return {Emitter}
		 */

		Emitter.prototype.emit = function(event){
		  this._callbacks = this._callbacks || {};

		  var args = new Array(arguments.length - 1)
		    , callbacks = this._callbacks['$' + event];

		  for (var i = 1; i < arguments.length; i++) {
		    args[i - 1] = arguments[i];
		  }

		  if (callbacks) {
		    callbacks = callbacks.slice(0);
		    for (var i = 0, len = callbacks.length; i < len; ++i) {
		      callbacks[i].apply(this, args);
		    }
		  }

		  return this;
		};

		/**
		 * Return array of callbacks for `event`.
		 *
		 * @param {String} event
		 * @return {Array}
		 * @api public
		 */

		Emitter.prototype.listeners = function(event){
		  this._callbacks = this._callbacks || {};
		  return this._callbacks['$' + event] || [];
		};

		/**
		 * Check if this emitter has `event` handlers.
		 *
		 * @param {String} event
		 * @return {Boolean}
		 * @api public
		 */

		Emitter.prototype.hasListeners = function(event){
		  return !! this.listeners(event).length;
		};
	} (componentEmitter));

	var Emitter = componentEmitterExports;

	/*! Hammer.JS - v2.0.17-rc - 2019-12-16
	 * http://naver.github.io/egjs
	 *
	 * Forked By Naver egjs
	 * Copyright (c) hammerjs
	 * Licensed under the MIT license */
	function _extends() {
	  _extends = Object.assign || function (target) {
	    for (var i = 1; i < arguments.length; i++) {
	      var source = arguments[i];

	      for (var key in source) {
	        if (Object.prototype.hasOwnProperty.call(source, key)) {
	          target[key] = source[key];
	        }
	      }
	    }

	    return target;
	  };

	  return _extends.apply(this, arguments);
	}

	function _inheritsLoose(subClass, superClass) {
	  subClass.prototype = Object.create(superClass.prototype);
	  subClass.prototype.constructor = subClass;
	  subClass.__proto__ = superClass;
	}

	function _assertThisInitialized(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }

	  return self;
	}

	/**
	 * @private
	 * extend object.
	 * means that properties in dest will be overwritten by the ones in src.
	 * @param {Object} target
	 * @param {...Object} objects_to_assign
	 * @returns {Object} target
	 */
	var assign;

	if (typeof Object.assign !== 'function') {
	  assign = function assign(target) {
	    if (target === undefined || target === null) {
	      throw new TypeError('Cannot convert undefined or null to object');
	    }

	    var output = Object(target);

	    for (var index = 1; index < arguments.length; index++) {
	      var source = arguments[index];

	      if (source !== undefined && source !== null) {
	        for (var nextKey in source) {
	          if (source.hasOwnProperty(nextKey)) {
	            output[nextKey] = source[nextKey];
	          }
	        }
	      }
	    }

	    return output;
	  };
	} else {
	  assign = Object.assign;
	}

	var assign$1 = assign;

	var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];
	var TEST_ELEMENT = typeof document === "undefined" ? {
	  style: {}
	} : document.createElement('div');
	var TYPE_FUNCTION = 'function';
	var round = Math.round,
	    abs = Math.abs;
	var now = Date.now;

	/**
	 * @private
	 * get the prefixed property
	 * @param {Object} obj
	 * @param {String} property
	 * @returns {String|Undefined} prefixed
	 */

	function prefixed(obj, property) {
	  var prefix;
	  var prop;
	  var camelProp = property[0].toUpperCase() + property.slice(1);
	  var i = 0;

	  while (i < VENDOR_PREFIXES.length) {
	    prefix = VENDOR_PREFIXES[i];
	    prop = prefix ? prefix + camelProp : property;

	    if (prop in obj) {
	      return prop;
	    }

	    i++;
	  }

	  return undefined;
	}

	/* eslint-disable no-new-func, no-nested-ternary */
	var win;

	if (typeof window === "undefined") {
	  // window is undefined in node.js
	  win = {};
	} else {
	  win = window;
	}

	var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, 'touchAction');
	var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined;
	function getTouchActionProps() {
	  if (!NATIVE_TOUCH_ACTION) {
	    return false;
	  }

	  var touchMap = {};
	  var cssSupports = win.CSS && win.CSS.supports;
	  ['auto', 'manipulation', 'pan-y', 'pan-x', 'pan-x pan-y', 'none'].forEach(function (val) {
	    // If css.supports is not supported but there is native touch-action assume it supports
	    // all values. This is the case for IE 10 and 11.
	    return touchMap[val] = cssSupports ? win.CSS.supports('touch-action', val) : true;
	  });
	  return touchMap;
	}

	var TOUCH_ACTION_COMPUTE = 'compute';
	var TOUCH_ACTION_AUTO = 'auto';
	var TOUCH_ACTION_MANIPULATION = 'manipulation'; // not implemented

	var TOUCH_ACTION_NONE = 'none';
	var TOUCH_ACTION_PAN_X = 'pan-x';
	var TOUCH_ACTION_PAN_Y = 'pan-y';
	var TOUCH_ACTION_MAP = getTouchActionProps();

	var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;
	var SUPPORT_TOUCH = 'ontouchstart' in win;
	var SUPPORT_POINTER_EVENTS = prefixed(win, 'PointerEvent') !== undefined;
	var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);
	var INPUT_TYPE_TOUCH = 'touch';
	var INPUT_TYPE_PEN = 'pen';
	var INPUT_TYPE_MOUSE = 'mouse';
	var INPUT_TYPE_KINECT = 'kinect';
	var COMPUTE_INTERVAL = 25;
	var INPUT_START = 1;
	var INPUT_MOVE = 2;
	var INPUT_END = 4;
	var INPUT_CANCEL = 8;
	var DIRECTION_NONE = 1;
	var DIRECTION_LEFT = 2;
	var DIRECTION_RIGHT = 4;
	var DIRECTION_UP = 8;
	var DIRECTION_DOWN = 16;
	var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
	var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
	var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;
	var PROPS_XY = ['x', 'y'];
	var PROPS_CLIENT_XY = ['clientX', 'clientY'];

	/**
	 * @private
	 * walk objects and arrays
	 * @param {Object} obj
	 * @param {Function} iterator
	 * @param {Object} context
	 */
	function each(obj, iterator, context) {
	  var i;

	  if (!obj) {
	    return;
	  }

	  if (obj.forEach) {
	    obj.forEach(iterator, context);
	  } else if (obj.length !== undefined) {
	    i = 0;

	    while (i < obj.length) {
	      iterator.call(context, obj[i], i, obj);
	      i++;
	    }
	  } else {
	    for (i in obj) {
	      obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);
	    }
	  }
	}

	/**
	 * @private
	 * let a boolean value also be a function that must return a boolean
	 * this first item in args will be used as the context
	 * @param {Boolean|Function} val
	 * @param {Array} [args]
	 * @returns {Boolean}
	 */

	function boolOrFn(val, args) {
	  if (typeof val === TYPE_FUNCTION) {
	    return val.apply(args ? args[0] || undefined : undefined, args);
	  }

	  return val;
	}

	/**
	 * @private
	 * small indexOf wrapper
	 * @param {String} str
	 * @param {String} find
	 * @returns {Boolean} found
	 */
	function inStr(str, find) {
	  return str.indexOf(find) > -1;
	}

	/**
	 * @private
	 * when the touchActions are collected they are not a valid value, so we need to clean things up. *
	 * @param {String} actions
	 * @returns {*}
	 */

	function cleanTouchActions(actions) {
	  // none
	  if (inStr(actions, TOUCH_ACTION_NONE)) {
	    return TOUCH_ACTION_NONE;
	  }

	  var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);
	  var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y); // if both pan-x and pan-y are set (different recognizers
	  // for different directions, e.g. horizontal pan but vertical swipe?)
	  // we need none (as otherwise with pan-x pan-y combined none of these
	  // recognizers will work, since the browser would handle all panning

	  if (hasPanX && hasPanY) {
	    return TOUCH_ACTION_NONE;
	  } // pan-x OR pan-y


	  if (hasPanX || hasPanY) {
	    return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;
	  } // manipulation


	  if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {
	    return TOUCH_ACTION_MANIPULATION;
	  }

	  return TOUCH_ACTION_AUTO;
	}

	/**
	 * @private
	 * Touch Action
	 * sets the touchAction property or uses the js alternative
	 * @param {Manager} manager
	 * @param {String} value
	 * @constructor
	 */

	var TouchAction =
	/*#__PURE__*/
	function () {
	  function TouchAction(manager, value) {
	    this.manager = manager;
	    this.set(value);
	  }
	  /**
	   * @private
	   * set the touchAction value on the element or enable the polyfill
	   * @param {String} value
	   */


	  var _proto = TouchAction.prototype;

	  _proto.set = function set(value) {
	    // find out the touch-action by the event handlers
	    if (value === TOUCH_ACTION_COMPUTE) {
	      value = this.compute();
	    }

	    if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {
	      this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;
	    }

	    this.actions = value.toLowerCase().trim();
	  };
	  /**
	   * @private
	   * just re-set the touchAction value
	   */


	  _proto.update = function update() {
	    this.set(this.manager.options.touchAction);
	  };
	  /**
	   * @private
	   * compute the value for the touchAction property based on the recognizer's settings
	   * @returns {String} value
	   */


	  _proto.compute = function compute() {
	    var actions = [];
	    each(this.manager.recognizers, function (recognizer) {
	      if (boolOrFn(recognizer.options.enable, [recognizer])) {
	        actions = actions.concat(recognizer.getTouchAction());
	      }
	    });
	    return cleanTouchActions(actions.join(' '));
	  };
	  /**
	   * @private
	   * this method is called on each input cycle and provides the preventing of the browser behavior
	   * @param {Object} input
	   */


	  _proto.preventDefaults = function preventDefaults(input) {
	    var srcEvent = input.srcEvent;
	    var direction = input.offsetDirection; // if the touch action did prevented once this session

	    if (this.manager.session.prevented) {
	      srcEvent.preventDefault();
	      return;
	    }

	    var actions = this.actions;
	    var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];
	    var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];
	    var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];

	    if (hasNone) {
	      // do not prevent defaults if this is a tap gesture
	      var isTapPointer = input.pointers.length === 1;
	      var isTapMovement = input.distance < 2;
	      var isTapTouchTime = input.deltaTime < 250;

	      if (isTapPointer && isTapMovement && isTapTouchTime) {
	        return;
	      }
	    }

	    if (hasPanX && hasPanY) {
	      // `pan-x pan-y` means browser handles all scrolling/panning, do not prevent
	      return;
	    }

	    if (hasNone || hasPanY && direction & DIRECTION_HORIZONTAL || hasPanX && direction & DIRECTION_VERTICAL) {
	      return this.preventSrc(srcEvent);
	    }
	  };
	  /**
	   * @private
	   * call preventDefault to prevent the browser's default behavior (scrolling in most cases)
	   * @param {Object} srcEvent
	   */


	  _proto.preventSrc = function preventSrc(srcEvent) {
	    this.manager.session.prevented = true;
	    srcEvent.preventDefault();
	  };

	  return TouchAction;
	}();

	/**
	 * @private
	 * find if a node is in the given parent
	 * @method hasParent
	 * @param {HTMLElement} node
	 * @param {HTMLElement} parent
	 * @return {Boolean} found
	 */
	function hasParent$1(node, parent) {
	  while (node) {
	    if (node === parent) {
	      return true;
	    }

	    node = node.parentNode;
	  }

	  return false;
	}

	/**
	 * @private
	 * get the center of all the pointers
	 * @param {Array} pointers
	 * @return {Object} center contains `x` and `y` properties
	 */

	function getCenter(pointers) {
	  var pointersLength = pointers.length; // no need to loop when only one touch

	  if (pointersLength === 1) {
	    return {
	      x: round(pointers[0].clientX),
	      y: round(pointers[0].clientY)
	    };
	  }

	  var x = 0;
	  var y = 0;
	  var i = 0;

	  while (i < pointersLength) {
	    x += pointers[i].clientX;
	    y += pointers[i].clientY;
	    i++;
	  }

	  return {
	    x: round(x / pointersLength),
	    y: round(y / pointersLength)
	  };
	}

	/**
	 * @private
	 * create a simple clone from the input used for storage of firstInput and firstMultiple
	 * @param {Object} input
	 * @returns {Object} clonedInputData
	 */

	function simpleCloneInputData(input) {
	  // make a simple copy of the pointers because we will get a reference if we don't
	  // we only need clientXY for the calculations
	  var pointers = [];
	  var i = 0;

	  while (i < input.pointers.length) {
	    pointers[i] = {
	      clientX: round(input.pointers[i].clientX),
	      clientY: round(input.pointers[i].clientY)
	    };
	    i++;
	  }

	  return {
	    timeStamp: now(),
	    pointers: pointers,
	    center: getCenter(pointers),
	    deltaX: input.deltaX,
	    deltaY: input.deltaY
	  };
	}

	/**
	 * @private
	 * calculate the absolute distance between two points
	 * @param {Object} p1 {x, y}
	 * @param {Object} p2 {x, y}
	 * @param {Array} [props] containing x and y keys
	 * @return {Number} distance
	 */

	function getDistance(p1, p2, props) {
	  if (!props) {
	    props = PROPS_XY;
	  }

	  var x = p2[props[0]] - p1[props[0]];
	  var y = p2[props[1]] - p1[props[1]];
	  return Math.sqrt(x * x + y * y);
	}

	/**
	 * @private
	 * calculate the angle between two coordinates
	 * @param {Object} p1
	 * @param {Object} p2
	 * @param {Array} [props] containing x and y keys
	 * @return {Number} angle
	 */

	function getAngle(p1, p2, props) {
	  if (!props) {
	    props = PROPS_XY;
	  }

	  var x = p2[props[0]] - p1[props[0]];
	  var y = p2[props[1]] - p1[props[1]];
	  return Math.atan2(y, x) * 180 / Math.PI;
	}

	/**
	 * @private
	 * get the direction between two points
	 * @param {Number} x
	 * @param {Number} y
	 * @return {Number} direction
	 */

	function getDirection(x, y) {
	  if (x === y) {
	    return DIRECTION_NONE;
	  }

	  if (abs(x) >= abs(y)) {
	    return x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
	  }

	  return y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
	}

	function computeDeltaXY(session, input) {
	  var center = input.center; // let { offsetDelta:offset = {}, prevDelta = {}, prevInput = {} } = session;
	  // jscs throwing error on defalut destructured values and without defaults tests fail

	  var offset = session.offsetDelta || {};
	  var prevDelta = session.prevDelta || {};
	  var prevInput = session.prevInput || {};

	  if (input.eventType === INPUT_START || prevInput.eventType === INPUT_END) {
	    prevDelta = session.prevDelta = {
	      x: prevInput.deltaX || 0,
	      y: prevInput.deltaY || 0
	    };
	    offset = session.offsetDelta = {
	      x: center.x,
	      y: center.y
	    };
	  }

	  input.deltaX = prevDelta.x + (center.x - offset.x);
	  input.deltaY = prevDelta.y + (center.y - offset.y);
	}

	/**
	 * @private
	 * calculate the velocity between two points. unit is in px per ms.
	 * @param {Number} deltaTime
	 * @param {Number} x
	 * @param {Number} y
	 * @return {Object} velocity `x` and `y`
	 */
	function getVelocity(deltaTime, x, y) {
	  return {
	    x: x / deltaTime || 0,
	    y: y / deltaTime || 0
	  };
	}

	/**
	 * @private
	 * calculate the scale factor between two pointersets
	 * no scale is 1, and goes down to 0 when pinched together, and bigger when pinched out
	 * @param {Array} start array of pointers
	 * @param {Array} end array of pointers
	 * @return {Number} scale
	 */

	function getScale(start, end) {
	  return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start[0], start[1], PROPS_CLIENT_XY);
	}

	/**
	 * @private
	 * calculate the rotation degrees between two pointersets
	 * @param {Array} start array of pointers
	 * @param {Array} end array of pointers
	 * @return {Number} rotation
	 */

	function getRotation(start, end) {
	  return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start[1], start[0], PROPS_CLIENT_XY);
	}

	/**
	 * @private
	 * velocity is calculated every x ms
	 * @param {Object} session
	 * @param {Object} input
	 */

	function computeIntervalInputData(session, input) {
	  var last = session.lastInterval || input;
	  var deltaTime = input.timeStamp - last.timeStamp;
	  var velocity;
	  var velocityX;
	  var velocityY;
	  var direction;

	  if (input.eventType !== INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined)) {
	    var deltaX = input.deltaX - last.deltaX;
	    var deltaY = input.deltaY - last.deltaY;
	    var v = getVelocity(deltaTime, deltaX, deltaY);
	    velocityX = v.x;
	    velocityY = v.y;
	    velocity = abs(v.x) > abs(v.y) ? v.x : v.y;
	    direction = getDirection(deltaX, deltaY);
	    session.lastInterval = input;
	  } else {
	    // use latest velocity info if it doesn't overtake a minimum period
	    velocity = last.velocity;
	    velocityX = last.velocityX;
	    velocityY = last.velocityY;
	    direction = last.direction;
	  }

	  input.velocity = velocity;
	  input.velocityX = velocityX;
	  input.velocityY = velocityY;
	  input.direction = direction;
	}

	/**
	* @private
	 * extend the data with some usable properties like scale, rotate, velocity etc
	 * @param {Object} manager
	 * @param {Object} input
	 */

	function computeInputData(manager, input) {
	  var session = manager.session;
	  var pointers = input.pointers;
	  var pointersLength = pointers.length; // store the first input to calculate the distance and direction

	  if (!session.firstInput) {
	    session.firstInput = simpleCloneInputData(input);
	  } // to compute scale and rotation we need to store the multiple touches


	  if (pointersLength > 1 && !session.firstMultiple) {
	    session.firstMultiple = simpleCloneInputData(input);
	  } else if (pointersLength === 1) {
	    session.firstMultiple = false;
	  }

	  var firstInput = session.firstInput,
	      firstMultiple = session.firstMultiple;
	  var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;
	  var center = input.center = getCenter(pointers);
	  input.timeStamp = now();
	  input.deltaTime = input.timeStamp - firstInput.timeStamp;
	  input.angle = getAngle(offsetCenter, center);
	  input.distance = getDistance(offsetCenter, center);
	  computeDeltaXY(session, input);
	  input.offsetDirection = getDirection(input.deltaX, input.deltaY);
	  var overallVelocity = getVelocity(input.deltaTime, input.deltaX, input.deltaY);
	  input.overallVelocityX = overallVelocity.x;
	  input.overallVelocityY = overallVelocity.y;
	  input.overallVelocity = abs(overallVelocity.x) > abs(overallVelocity.y) ? overallVelocity.x : overallVelocity.y;
	  input.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;
	  input.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;
	  input.maxPointers = !session.prevInput ? input.pointers.length : input.pointers.length > session.prevInput.maxPointers ? input.pointers.length : session.prevInput.maxPointers;
	  computeIntervalInputData(session, input); // find the correct target

	  var target = manager.element;
	  var srcEvent = input.srcEvent;
	  var srcEventTarget;

	  if (srcEvent.composedPath) {
	    srcEventTarget = srcEvent.composedPath()[0];
	  } else if (srcEvent.path) {
	    srcEventTarget = srcEvent.path[0];
	  } else {
	    srcEventTarget = srcEvent.target;
	  }

	  if (hasParent$1(srcEventTarget, target)) {
	    target = srcEventTarget;
	  }

	  input.target = target;
	}

	/**
	 * @private
	 * handle input events
	 * @param {Manager} manager
	 * @param {String} eventType
	 * @param {Object} input
	 */

	function inputHandler(manager, eventType, input) {
	  var pointersLen = input.pointers.length;
	  var changedPointersLen = input.changedPointers.length;
	  var isFirst = eventType & INPUT_START && pointersLen - changedPointersLen === 0;
	  var isFinal = eventType & (INPUT_END | INPUT_CANCEL) && pointersLen - changedPointersLen === 0;
	  input.isFirst = !!isFirst;
	  input.isFinal = !!isFinal;

	  if (isFirst) {
	    manager.session = {};
	  } // source event is the normalized value of the domEvents
	  // like 'touchstart, mouseup, pointerdown'


	  input.eventType = eventType; // compute scale, rotation etc

	  computeInputData(manager, input); // emit secret event

	  manager.emit('hammer.input', input);
	  manager.recognize(input);
	  manager.session.prevInput = input;
	}

	/**
	 * @private
	 * split string on whitespace
	 * @param {String} str
	 * @returns {Array} words
	 */
	function splitStr(str) {
	  return str.trim().split(/\s+/g);
	}

	/**
	 * @private
	 * addEventListener with multiple events at once
	 * @param {EventTarget} target
	 * @param {String} types
	 * @param {Function} handler
	 */

	function addEventListeners(target, types, handler) {
	  each(splitStr(types), function (type) {
	    target.addEventListener(type, handler, false);
	  });
	}

	/**
	 * @private
	 * removeEventListener with multiple events at once
	 * @param {EventTarget} target
	 * @param {String} types
	 * @param {Function} handler
	 */

	function removeEventListeners(target, types, handler) {
	  each(splitStr(types), function (type) {
	    target.removeEventListener(type, handler, false);
	  });
	}

	/**
	 * @private
	 * get the window object of an element
	 * @param {HTMLElement} element
	 * @returns {DocumentView|Window}
	 */
	function getWindowForElement(element) {
	  var doc = element.ownerDocument || element;
	  return doc.defaultView || doc.parentWindow || window;
	}

	/**
	 * @private
	 * create new input type manager
	 * @param {Manager} manager
	 * @param {Function} callback
	 * @returns {Input}
	 * @constructor
	 */

	var Input =
	/*#__PURE__*/
	function () {
	  function Input(manager, callback) {
	    var self = this;
	    this.manager = manager;
	    this.callback = callback;
	    this.element = manager.element;
	    this.target = manager.options.inputTarget; // smaller wrapper around the handler, for the scope and the enabled state of the manager,
	    // so when disabled the input events are completely bypassed.

	    this.domHandler = function (ev) {
	      if (boolOrFn(manager.options.enable, [manager])) {
	        self.handler(ev);
	      }
	    };

	    this.init();
	  }
	  /**
	   * @private
	   * should handle the inputEvent data and trigger the callback
	   * @virtual
	   */


	  var _proto = Input.prototype;

	  _proto.handler = function handler() {};
	  /**
	   * @private
	   * bind the events
	   */


	  _proto.init = function init() {
	    this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
	    this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
	    this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
	  };
	  /**
	   * @private
	   * unbind the events
	   */


	  _proto.destroy = function destroy() {
	    this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
	    this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
	    this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
	  };

	  return Input;
	}();

	/**
	 * @private
	 * find if a array contains the object using indexOf or a simple polyFill
	 * @param {Array} src
	 * @param {String} find
	 * @param {String} [findByKey]
	 * @return {Boolean|Number} false when not found, or the index
	 */
	function inArray(src, find, findByKey) {
	  if (src.indexOf && !findByKey) {
	    return src.indexOf(find);
	  } else {
	    var i = 0;

	    while (i < src.length) {
	      if (findByKey && src[i][findByKey] == find || !findByKey && src[i] === find) {
	        // do not use === here, test fails
	        return i;
	      }

	      i++;
	    }

	    return -1;
	  }
	}

	var POINTER_INPUT_MAP = {
	  pointerdown: INPUT_START,
	  pointermove: INPUT_MOVE,
	  pointerup: INPUT_END,
	  pointercancel: INPUT_CANCEL,
	  pointerout: INPUT_CANCEL
	}; // in IE10 the pointer types is defined as an enum

	var IE10_POINTER_TYPE_ENUM = {
	  2: INPUT_TYPE_TOUCH,
	  3: INPUT_TYPE_PEN,
	  4: INPUT_TYPE_MOUSE,
	  5: INPUT_TYPE_KINECT // see https://twitter.com/jacobrossi/status/480596438489890816

	};
	var POINTER_ELEMENT_EVENTS = 'pointerdown';
	var POINTER_WINDOW_EVENTS = 'pointermove pointerup pointercancel'; // IE10 has prefixed support, and case-sensitive

	if (win.MSPointerEvent && !win.PointerEvent) {
	  POINTER_ELEMENT_EVENTS = 'MSPointerDown';
	  POINTER_WINDOW_EVENTS = 'MSPointerMove MSPointerUp MSPointerCancel';
	}
	/**
	 * @private
	 * Pointer events input
	 * @constructor
	 * @extends Input
	 */


	var PointerEventInput =
	/*#__PURE__*/
	function (_Input) {
	  _inheritsLoose(PointerEventInput, _Input);

	  function PointerEventInput() {
	    var _this;

	    var proto = PointerEventInput.prototype;
	    proto.evEl = POINTER_ELEMENT_EVENTS;
	    proto.evWin = POINTER_WINDOW_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.store = _this.manager.session.pointerEvents = [];
	    return _this;
	  }
	  /**
	   * @private
	   * handle mouse events
	   * @param {Object} ev
	   */


	  var _proto = PointerEventInput.prototype;

	  _proto.handler = function handler(ev) {
	    var store = this.store;
	    var removePointer = false;
	    var eventTypeNormalized = ev.type.toLowerCase().replace('ms', '');
	    var eventType = POINTER_INPUT_MAP[eventTypeNormalized];
	    var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;
	    var isTouch = pointerType === INPUT_TYPE_TOUCH; // get index of the event in the store

	    var storeIndex = inArray(store, ev.pointerId, 'pointerId'); // start and mouse must be down

	    if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {
	      if (storeIndex < 0) {
	        store.push(ev);
	        storeIndex = store.length - 1;
	      }
	    } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
	      removePointer = true;
	    } // it not found, so the pointer hasn't been down (so it's probably a hover)


	    if (storeIndex < 0) {
	      return;
	    } // update the event in the store


	    store[storeIndex] = ev;
	    this.callback(this.manager, eventType, {
	      pointers: store,
	      changedPointers: [ev],
	      pointerType: pointerType,
	      srcEvent: ev
	    });

	    if (removePointer) {
	      // remove from the store
	      store.splice(storeIndex, 1);
	    }
	  };

	  return PointerEventInput;
	}(Input);

	/**
	 * @private
	 * convert array-like objects to real arrays
	 * @param {Object} obj
	 * @returns {Array}
	 */
	function toArray$1(obj) {
	  return Array.prototype.slice.call(obj, 0);
	}

	/**
	 * @private
	 * unique array with objects based on a key (like 'id') or just by the array's value
	 * @param {Array} src [{id:1},{id:2},{id:1}]
	 * @param {String} [key]
	 * @param {Boolean} [sort=False]
	 * @returns {Array} [{id:1},{id:2}]
	 */

	function uniqueArray(src, key, sort) {
	  var results = [];
	  var values = [];
	  var i = 0;

	  while (i < src.length) {
	    var val = key ? src[i][key] : src[i];

	    if (inArray(values, val) < 0) {
	      results.push(src[i]);
	    }

	    values[i] = val;
	    i++;
	  }

	  if (sort) {
	    if (!key) {
	      results = results.sort();
	    } else {
	      results = results.sort(function (a, b) {
	        return a[key] > b[key];
	      });
	    }
	  }

	  return results;
	}

	var TOUCH_INPUT_MAP = {
	  touchstart: INPUT_START,
	  touchmove: INPUT_MOVE,
	  touchend: INPUT_END,
	  touchcancel: INPUT_CANCEL
	};
	var TOUCH_TARGET_EVENTS = 'touchstart touchmove touchend touchcancel';
	/**
	 * @private
	 * Multi-user touch events input
	 * @constructor
	 * @extends Input
	 */

	var TouchInput =
	/*#__PURE__*/
	function (_Input) {
	  _inheritsLoose(TouchInput, _Input);

	  function TouchInput() {
	    var _this;

	    TouchInput.prototype.evTarget = TOUCH_TARGET_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.targetIds = {}; // this.evTarget = TOUCH_TARGET_EVENTS;

	    return _this;
	  }

	  var _proto = TouchInput.prototype;

	  _proto.handler = function handler(ev) {
	    var type = TOUCH_INPUT_MAP[ev.type];
	    var touches = getTouches.call(this, ev, type);

	    if (!touches) {
	      return;
	    }

	    this.callback(this.manager, type, {
	      pointers: touches[0],
	      changedPointers: touches[1],
	      pointerType: INPUT_TYPE_TOUCH,
	      srcEvent: ev
	    });
	  };

	  return TouchInput;
	}(Input);

	function getTouches(ev, type) {
	  var allTouches = toArray$1(ev.touches);
	  var targetIds = this.targetIds; // when there is only one touch, the process can be simplified

	  if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {
	    targetIds[allTouches[0].identifier] = true;
	    return [allTouches, allTouches];
	  }

	  var i;
	  var targetTouches;
	  var changedTouches = toArray$1(ev.changedTouches);
	  var changedTargetTouches = [];
	  var target = this.target; // get target touches from touches

	  targetTouches = allTouches.filter(function (touch) {
	    return hasParent$1(touch.target, target);
	  }); // collect touches

	  if (type === INPUT_START) {
	    i = 0;

	    while (i < targetTouches.length) {
	      targetIds[targetTouches[i].identifier] = true;
	      i++;
	    }
	  } // filter changed touches to only contain touches that exist in the collected target ids


	  i = 0;

	  while (i < changedTouches.length) {
	    if (targetIds[changedTouches[i].identifier]) {
	      changedTargetTouches.push(changedTouches[i]);
	    } // cleanup removed touches


	    if (type & (INPUT_END | INPUT_CANCEL)) {
	      delete targetIds[changedTouches[i].identifier];
	    }

	    i++;
	  }

	  if (!changedTargetTouches.length) {
	    return;
	  }

	  return [// merge targetTouches with changedTargetTouches so it contains ALL touches, including 'end' and 'cancel'
	  uniqueArray(targetTouches.concat(changedTargetTouches), 'identifier', true), changedTargetTouches];
	}

	var MOUSE_INPUT_MAP = {
	  mousedown: INPUT_START,
	  mousemove: INPUT_MOVE,
	  mouseup: INPUT_END
	};
	var MOUSE_ELEMENT_EVENTS = 'mousedown';
	var MOUSE_WINDOW_EVENTS = 'mousemove mouseup';
	/**
	 * @private
	 * Mouse events input
	 * @constructor
	 * @extends Input
	 */

	var MouseInput =
	/*#__PURE__*/
	function (_Input) {
	  _inheritsLoose(MouseInput, _Input);

	  function MouseInput() {
	    var _this;

	    var proto = MouseInput.prototype;
	    proto.evEl = MOUSE_ELEMENT_EVENTS;
	    proto.evWin = MOUSE_WINDOW_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.pressed = false; // mousedown state

	    return _this;
	  }
	  /**
	   * @private
	   * handle mouse events
	   * @param {Object} ev
	   */


	  var _proto = MouseInput.prototype;

	  _proto.handler = function handler(ev) {
	    var eventType = MOUSE_INPUT_MAP[ev.type]; // on start we want to have the left mouse button down

	    if (eventType & INPUT_START && ev.button === 0) {
	      this.pressed = true;
	    }

	    if (eventType & INPUT_MOVE && ev.which !== 1) {
	      eventType = INPUT_END;
	    } // mouse must be down


	    if (!this.pressed) {
	      return;
	    }

	    if (eventType & INPUT_END) {
	      this.pressed = false;
	    }

	    this.callback(this.manager, eventType, {
	      pointers: [ev],
	      changedPointers: [ev],
	      pointerType: INPUT_TYPE_MOUSE,
	      srcEvent: ev
	    });
	  };

	  return MouseInput;
	}(Input);

	/**
	 * @private
	 * Combined touch and mouse input
	 *
	 * Touch has a higher priority then mouse, and while touching no mouse events are allowed.
	 * This because touch devices also emit mouse events while doing a touch.
	 *
	 * @constructor
	 * @extends Input
	 */

	var DEDUP_TIMEOUT = 2500;
	var DEDUP_DISTANCE = 25;

	function setLastTouch(eventData) {
	  var _eventData$changedPoi = eventData.changedPointers,
	      touch = _eventData$changedPoi[0];

	  if (touch.identifier === this.primaryTouch) {
	    var lastTouch = {
	      x: touch.clientX,
	      y: touch.clientY
	    };
	    var lts = this.lastTouches;
	    this.lastTouches.push(lastTouch);

	    var removeLastTouch = function removeLastTouch() {
	      var i = lts.indexOf(lastTouch);

	      if (i > -1) {
	        lts.splice(i, 1);
	      }
	    };

	    setTimeout(removeLastTouch, DEDUP_TIMEOUT);
	  }
	}

	function recordTouches(eventType, eventData) {
	  if (eventType & INPUT_START) {
	    this.primaryTouch = eventData.changedPointers[0].identifier;
	    setLastTouch.call(this, eventData);
	  } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
	    setLastTouch.call(this, eventData);
	  }
	}

	function isSyntheticEvent(eventData) {
	  var x = eventData.srcEvent.clientX;
	  var y = eventData.srcEvent.clientY;

	  for (var i = 0; i < this.lastTouches.length; i++) {
	    var t = this.lastTouches[i];
	    var dx = Math.abs(x - t.x);
	    var dy = Math.abs(y - t.y);

	    if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {
	      return true;
	    }
	  }

	  return false;
	}

	var TouchMouseInput =
	/*#__PURE__*/
	function () {
	  var TouchMouseInput =
	  /*#__PURE__*/
	  function (_Input) {
	    _inheritsLoose(TouchMouseInput, _Input);

	    function TouchMouseInput(_manager, callback) {
	      var _this;

	      _this = _Input.call(this, _manager, callback) || this;

	      _this.handler = function (manager, inputEvent, inputData) {
	        var isTouch = inputData.pointerType === INPUT_TYPE_TOUCH;
	        var isMouse = inputData.pointerType === INPUT_TYPE_MOUSE;

	        if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {
	          return;
	        } // when we're in a touch event, record touches to  de-dupe synthetic mouse event


	        if (isTouch) {
	          recordTouches.call(_assertThisInitialized(_assertThisInitialized(_this)), inputEvent, inputData);
	        } else if (isMouse && isSyntheticEvent.call(_assertThisInitialized(_assertThisInitialized(_this)), inputData)) {
	          return;
	        }

	        _this.callback(manager, inputEvent, inputData);
	      };

	      _this.touch = new TouchInput(_this.manager, _this.handler);
	      _this.mouse = new MouseInput(_this.manager, _this.handler);
	      _this.primaryTouch = null;
	      _this.lastTouches = [];
	      return _this;
	    }
	    /**
	     * @private
	     * handle mouse and touch events
	     * @param {Hammer} manager
	     * @param {String} inputEvent
	     * @param {Object} inputData
	     */


	    var _proto = TouchMouseInput.prototype;

	    /**
	     * @private
	     * remove the event listeners
	     */
	    _proto.destroy = function destroy() {
	      this.touch.destroy();
	      this.mouse.destroy();
	    };

	    return TouchMouseInput;
	  }(Input);

	  return TouchMouseInput;
	}();

	/**
	 * @private
	 * create new input type manager
	 * called by the Manager constructor
	 * @param {Hammer} manager
	 * @returns {Input}
	 */

	function createInputInstance(manager) {
	  var Type; // let inputClass = manager.options.inputClass;

	  var inputClass = manager.options.inputClass;

	  if (inputClass) {
	    Type = inputClass;
	  } else if (SUPPORT_POINTER_EVENTS) {
	    Type = PointerEventInput;
	  } else if (SUPPORT_ONLY_TOUCH) {
	    Type = TouchInput;
	  } else if (!SUPPORT_TOUCH) {
	    Type = MouseInput;
	  } else {
	    Type = TouchMouseInput;
	  }

	  return new Type(manager, inputHandler);
	}

	/**
	 * @private
	 * if the argument is an array, we want to execute the fn on each entry
	 * if it aint an array we don't want to do a thing.
	 * this is used by all the methods that accept a single and array argument.
	 * @param {*|Array} arg
	 * @param {String} fn
	 * @param {Object} [context]
	 * @returns {Boolean}
	 */

	function invokeArrayArg(arg, fn, context) {
	  if (Array.isArray(arg)) {
	    each(arg, context[fn], context);
	    return true;
	  }

	  return false;
	}

	var STATE_POSSIBLE = 1;
	var STATE_BEGAN = 2;
	var STATE_CHANGED = 4;
	var STATE_ENDED = 8;
	var STATE_RECOGNIZED = STATE_ENDED;
	var STATE_CANCELLED = 16;
	var STATE_FAILED = 32;

	/**
	 * @private
	 * get a unique id
	 * @returns {number} uniqueId
	 */
	var _uniqueId = 1;
	function uniqueId() {
	  return _uniqueId++;
	}

	/**
	 * @private
	 * get a recognizer by name if it is bound to a manager
	 * @param {Recognizer|String} otherRecognizer
	 * @param {Recognizer} recognizer
	 * @returns {Recognizer}
	 */
	function getRecognizerByNameIfManager(otherRecognizer, recognizer) {
	  var manager = recognizer.manager;

	  if (manager) {
	    return manager.get(otherRecognizer);
	  }

	  return otherRecognizer;
	}

	/**
	 * @private
	 * get a usable string, used as event postfix
	 * @param {constant} state
	 * @returns {String} state
	 */

	function stateStr(state) {
	  if (state & STATE_CANCELLED) {
	    return 'cancel';
	  } else if (state & STATE_ENDED) {
	    return 'end';
	  } else if (state & STATE_CHANGED) {
	    return 'move';
	  } else if (state & STATE_BEGAN) {
	    return 'start';
	  }

	  return '';
	}

	/**
	 * @private
	 * Recognizer flow explained; *
	 * All recognizers have the initial state of POSSIBLE when a input session starts.
	 * The definition of a input session is from the first input until the last input, with all it's movement in it. *
	 * Example session for mouse-input: mousedown -> mousemove -> mouseup
	 *
	 * On each recognizing cycle (see Manager.recognize) the .recognize() method is executed
	 * which determines with state it should be.
	 *
	 * If the recognizer has the state FAILED, CANCELLED or RECOGNIZED (equals ENDED), it is reset to
	 * POSSIBLE to give it another change on the next cycle.
	 *
	 *               Possible
	 *                  |
	 *            +-----+---------------+
	 *            |                     |
	 *      +-----+-----+               |
	 *      |           |               |
	 *   Failed      Cancelled          |
	 *                          +-------+------+
	 *                          |              |
	 *                      Recognized       Began
	 *                                         |
	 *                                      Changed
	 *                                         |
	 *                                  Ended/Recognized
	 */

	/**
	 * @private
	 * Recognizer
	 * Every recognizer needs to extend from this class.
	 * @constructor
	 * @param {Object} options
	 */

	var Recognizer =
	/*#__PURE__*/
	function () {
	  function Recognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    this.options = _extends({
	      enable: true
	    }, options);
	    this.id = uniqueId();
	    this.manager = null; // default is enable true

	    this.state = STATE_POSSIBLE;
	    this.simultaneous = {};
	    this.requireFail = [];
	  }
	  /**
	   * @private
	   * set options
	   * @param {Object} options
	   * @return {Recognizer}
	   */


	  var _proto = Recognizer.prototype;

	  _proto.set = function set(options) {
	    assign$1(this.options, options); // also update the touchAction, in case something changed about the directions/enabled state

	    this.manager && this.manager.touchAction.update();
	    return this;
	  };
	  /**
	   * @private
	   * recognize simultaneous with an other recognizer.
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.recognizeWith = function recognizeWith(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'recognizeWith', this)) {
	      return this;
	    }

	    var simultaneous = this.simultaneous;
	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

	    if (!simultaneous[otherRecognizer.id]) {
	      simultaneous[otherRecognizer.id] = otherRecognizer;
	      otherRecognizer.recognizeWith(this);
	    }

	    return this;
	  };
	  /**
	   * @private
	   * drop the simultaneous link. it doesnt remove the link on the other recognizer.
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.dropRecognizeWith = function dropRecognizeWith(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'dropRecognizeWith', this)) {
	      return this;
	    }

	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
	    delete this.simultaneous[otherRecognizer.id];
	    return this;
	  };
	  /**
	   * @private
	   * recognizer can only run when an other is failing
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.requireFailure = function requireFailure(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'requireFailure', this)) {
	      return this;
	    }

	    var requireFail = this.requireFail;
	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

	    if (inArray(requireFail, otherRecognizer) === -1) {
	      requireFail.push(otherRecognizer);
	      otherRecognizer.requireFailure(this);
	    }

	    return this;
	  };
	  /**
	   * @private
	   * drop the requireFailure link. it does not remove the link on the other recognizer.
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.dropRequireFailure = function dropRequireFailure(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'dropRequireFailure', this)) {
	      return this;
	    }

	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
	    var index = inArray(this.requireFail, otherRecognizer);

	    if (index > -1) {
	      this.requireFail.splice(index, 1);
	    }

	    return this;
	  };
	  /**
	   * @private
	   * has require failures boolean
	   * @returns {boolean}
	   */


	  _proto.hasRequireFailures = function hasRequireFailures() {
	    return this.requireFail.length > 0;
	  };
	  /**
	   * @private
	   * if the recognizer can recognize simultaneous with an other recognizer
	   * @param {Recognizer} otherRecognizer
	   * @returns {Boolean}
	   */


	  _proto.canRecognizeWith = function canRecognizeWith(otherRecognizer) {
	    return !!this.simultaneous[otherRecognizer.id];
	  };
	  /**
	   * @private
	   * You should use `tryEmit` instead of `emit` directly to check
	   * that all the needed recognizers has failed before emitting.
	   * @param {Object} input
	   */


	  _proto.emit = function emit(input) {
	    var self = this;
	    var state = this.state;

	    function emit(event) {
	      self.manager.emit(event, input);
	    } // 'panstart' and 'panmove'


	    if (state < STATE_ENDED) {
	      emit(self.options.event + stateStr(state));
	    }

	    emit(self.options.event); // simple 'eventName' events

	    if (input.additionalEvent) {
	      // additional event(panleft, panright, pinchin, pinchout...)
	      emit(input.additionalEvent);
	    } // panend and pancancel


	    if (state >= STATE_ENDED) {
	      emit(self.options.event + stateStr(state));
	    }
	  };
	  /**
	   * @private
	   * Check that all the require failure recognizers has failed,
	   * if true, it emits a gesture event,
	   * otherwise, setup the state to FAILED.
	   * @param {Object} input
	   */


	  _proto.tryEmit = function tryEmit(input) {
	    if (this.canEmit()) {
	      return this.emit(input);
	    } // it's failing anyway


	    this.state = STATE_FAILED;
	  };
	  /**
	   * @private
	   * can we emit?
	   * @returns {boolean}
	   */


	  _proto.canEmit = function canEmit() {
	    var i = 0;

	    while (i < this.requireFail.length) {
	      if (!(this.requireFail[i].state & (STATE_FAILED | STATE_POSSIBLE))) {
	        return false;
	      }

	      i++;
	    }

	    return true;
	  };
	  /**
	   * @private
	   * update the recognizer
	   * @param {Object} inputData
	   */


	  _proto.recognize = function recognize(inputData) {
	    // make a new copy of the inputData
	    // so we can change the inputData without messing up the other recognizers
	    var inputDataClone = assign$1({}, inputData); // is is enabled and allow recognizing?

	    if (!boolOrFn(this.options.enable, [this, inputDataClone])) {
	      this.reset();
	      this.state = STATE_FAILED;
	      return;
	    } // reset when we've reached the end


	    if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {
	      this.state = STATE_POSSIBLE;
	    }

	    this.state = this.process(inputDataClone); // the recognizer has recognized a gesture
	    // so trigger an event

	    if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {
	      this.tryEmit(inputDataClone);
	    }
	  };
	  /**
	   * @private
	   * return the state of the recognizer
	   * the actual recognizing happens in this method
	   * @virtual
	   * @param {Object} inputData
	   * @returns {constant} STATE
	   */

	  /* jshint ignore:start */


	  _proto.process = function process(inputData) {};
	  /* jshint ignore:end */

	  /**
	   * @private
	   * return the preferred touch-action
	   * @virtual
	   * @returns {Array}
	   */


	  _proto.getTouchAction = function getTouchAction() {};
	  /**
	   * @private
	   * called when the gesture isn't allowed to recognize
	   * like when another is being recognized or it is disabled
	   * @virtual
	   */


	  _proto.reset = function reset() {};

	  return Recognizer;
	}();

	/**
	 * @private
	 * A tap is recognized when the pointer is doing a small tap/click. Multiple taps are recognized if they occur
	 * between the given interval and position. The delay option can be used to recognize multi-taps without firing
	 * a single tap.
	 *
	 * The eventData from the emitted event contains the property `tapCount`, which contains the amount of
	 * multi-taps being recognized.
	 * @constructor
	 * @extends Recognizer
	 */

	var TapRecognizer =
	/*#__PURE__*/
	function (_Recognizer) {
	  _inheritsLoose(TapRecognizer, _Recognizer);

	  function TapRecognizer(options) {
	    var _this;

	    if (options === void 0) {
	      options = {};
	    }

	    _this = _Recognizer.call(this, _extends({
	      event: 'tap',
	      pointers: 1,
	      taps: 1,
	      interval: 300,
	      // max time between the multi-tap taps
	      time: 250,
	      // max time of the pointer to be down (like finger on the screen)
	      threshold: 9,
	      // a minimal movement is ok, but keep it low
	      posThreshold: 10
	    }, options)) || this; // previous time and center,
	    // used for tap counting

	    _this.pTime = false;
	    _this.pCenter = false;
	    _this._timer = null;
	    _this._input = null;
	    _this.count = 0;
	    return _this;
	  }

	  var _proto = TapRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_MANIPULATION];
	  };

	  _proto.process = function process(input) {
	    var _this2 = this;

	    var options = this.options;
	    var validPointers = input.pointers.length === options.pointers;
	    var validMovement = input.distance < options.threshold;
	    var validTouchTime = input.deltaTime < options.time;
	    this.reset();

	    if (input.eventType & INPUT_START && this.count === 0) {
	      return this.failTimeout();
	    } // we only allow little movement
	    // and we've reached an end event, so a tap is possible


	    if (validMovement && validTouchTime && validPointers) {
	      if (input.eventType !== INPUT_END) {
	        return this.failTimeout();
	      }

	      var validInterval = this.pTime ? input.timeStamp - this.pTime < options.interval : true;
	      var validMultiTap = !this.pCenter || getDistance(this.pCenter, input.center) < options.posThreshold;
	      this.pTime = input.timeStamp;
	      this.pCenter = input.center;

	      if (!validMultiTap || !validInterval) {
	        this.count = 1;
	      } else {
	        this.count += 1;
	      }

	      this._input = input; // if tap count matches we have recognized it,
	      // else it has began recognizing...

	      var tapCount = this.count % options.taps;

	      if (tapCount === 0) {
	        // no failing requirements, immediately trigger the tap event
	        // or wait as long as the multitap interval to trigger
	        if (!this.hasRequireFailures()) {
	          return STATE_RECOGNIZED;
	        } else {
	          this._timer = setTimeout(function () {
	            _this2.state = STATE_RECOGNIZED;

	            _this2.tryEmit();
	          }, options.interval);
	          return STATE_BEGAN;
	        }
	      }
	    }

	    return STATE_FAILED;
	  };

	  _proto.failTimeout = function failTimeout() {
	    var _this3 = this;

	    this._timer = setTimeout(function () {
	      _this3.state = STATE_FAILED;
	    }, this.options.interval);
	    return STATE_FAILED;
	  };

	  _proto.reset = function reset() {
	    clearTimeout(this._timer);
	  };

	  _proto.emit = function emit() {
	    if (this.state === STATE_RECOGNIZED) {
	      this._input.tapCount = this.count;
	      this.manager.emit(this.options.event, this._input);
	    }
	  };

	  return TapRecognizer;
	}(Recognizer);

	/**
	 * @private
	 * This recognizer is just used as a base for the simple attribute recognizers.
	 * @constructor
	 * @extends Recognizer
	 */

	var AttrRecognizer =
	/*#__PURE__*/
	function (_Recognizer) {
	  _inheritsLoose(AttrRecognizer, _Recognizer);

	  function AttrRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _Recognizer.call(this, _extends({
	      pointers: 1
	    }, options)) || this;
	  }
	  /**
	   * @private
	   * Used to check if it the recognizer receives valid input, like input.distance > 10.
	   * @memberof AttrRecognizer
	   * @param {Object} input
	   * @returns {Boolean} recognized
	   */


	  var _proto = AttrRecognizer.prototype;

	  _proto.attrTest = function attrTest(input) {
	    var optionPointers = this.options.pointers;
	    return optionPointers === 0 || input.pointers.length === optionPointers;
	  };
	  /**
	   * @private
	   * Process the input and return the state for the recognizer
	   * @memberof AttrRecognizer
	   * @param {Object} input
	   * @returns {*} State
	   */


	  _proto.process = function process(input) {
	    var state = this.state;
	    var eventType = input.eventType;
	    var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);
	    var isValid = this.attrTest(input); // on cancel input and we've recognized before, return STATE_CANCELLED

	    if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {
	      return state | STATE_CANCELLED;
	    } else if (isRecognized || isValid) {
	      if (eventType & INPUT_END) {
	        return state | STATE_ENDED;
	      } else if (!(state & STATE_BEGAN)) {
	        return STATE_BEGAN;
	      }

	      return state | STATE_CHANGED;
	    }

	    return STATE_FAILED;
	  };

	  return AttrRecognizer;
	}(Recognizer);

	/**
	 * @private
	 * direction cons to string
	 * @param {constant} direction
	 * @returns {String}
	 */

	function directionStr(direction) {
	  if (direction === DIRECTION_DOWN) {
	    return 'down';
	  } else if (direction === DIRECTION_UP) {
	    return 'up';
	  } else if (direction === DIRECTION_LEFT) {
	    return 'left';
	  } else if (direction === DIRECTION_RIGHT) {
	    return 'right';
	  }

	  return '';
	}

	/**
	 * @private
	 * Pan
	 * Recognized when the pointer is down and moved in the allowed direction.
	 * @constructor
	 * @extends AttrRecognizer
	 */

	var PanRecognizer =
	/*#__PURE__*/
	function (_AttrRecognizer) {
	  _inheritsLoose(PanRecognizer, _AttrRecognizer);

	  function PanRecognizer(options) {
	    var _this;

	    if (options === void 0) {
	      options = {};
	    }

	    _this = _AttrRecognizer.call(this, _extends({
	      event: 'pan',
	      threshold: 10,
	      pointers: 1,
	      direction: DIRECTION_ALL
	    }, options)) || this;
	    _this.pX = null;
	    _this.pY = null;
	    return _this;
	  }

	  var _proto = PanRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    var direction = this.options.direction;
	    var actions = [];

	    if (direction & DIRECTION_HORIZONTAL) {
	      actions.push(TOUCH_ACTION_PAN_Y);
	    }

	    if (direction & DIRECTION_VERTICAL) {
	      actions.push(TOUCH_ACTION_PAN_X);
	    }

	    return actions;
	  };

	  _proto.directionTest = function directionTest(input) {
	    var options = this.options;
	    var hasMoved = true;
	    var distance = input.distance;
	    var direction = input.direction;
	    var x = input.deltaX;
	    var y = input.deltaY; // lock to axis?

	    if (!(direction & options.direction)) {
	      if (options.direction & DIRECTION_HORIZONTAL) {
	        direction = x === 0 ? DIRECTION_NONE : x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
	        hasMoved = x !== this.pX;
	        distance = Math.abs(input.deltaX);
	      } else {
	        direction = y === 0 ? DIRECTION_NONE : y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
	        hasMoved = y !== this.pY;
	        distance = Math.abs(input.deltaY);
	      }
	    }

	    input.direction = direction;
	    return hasMoved && distance > options.threshold && direction & options.direction;
	  };

	  _proto.attrTest = function attrTest(input) {
	    return AttrRecognizer.prototype.attrTest.call(this, input) && ( // replace with a super call
	    this.state & STATE_BEGAN || !(this.state & STATE_BEGAN) && this.directionTest(input));
	  };

	  _proto.emit = function emit(input) {
	    this.pX = input.deltaX;
	    this.pY = input.deltaY;
	    var direction = directionStr(input.direction);

	    if (direction) {
	      input.additionalEvent = this.options.event + direction;
	    }

	    _AttrRecognizer.prototype.emit.call(this, input);
	  };

	  return PanRecognizer;
	}(AttrRecognizer);

	/**
	 * @private
	 * Swipe
	 * Recognized when the pointer is moving fast (velocity), with enough distance in the allowed direction.
	 * @constructor
	 * @extends AttrRecognizer
	 */

	var SwipeRecognizer =
	/*#__PURE__*/
	function (_AttrRecognizer) {
	  _inheritsLoose(SwipeRecognizer, _AttrRecognizer);

	  function SwipeRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _AttrRecognizer.call(this, _extends({
	      event: 'swipe',
	      threshold: 10,
	      velocity: 0.3,
	      direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,
	      pointers: 1
	    }, options)) || this;
	  }

	  var _proto = SwipeRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return PanRecognizer.prototype.getTouchAction.call(this);
	  };

	  _proto.attrTest = function attrTest(input) {
	    var direction = this.options.direction;
	    var velocity;

	    if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {
	      velocity = input.overallVelocity;
	    } else if (direction & DIRECTION_HORIZONTAL) {
	      velocity = input.overallVelocityX;
	    } else if (direction & DIRECTION_VERTICAL) {
	      velocity = input.overallVelocityY;
	    }

	    return _AttrRecognizer.prototype.attrTest.call(this, input) && direction & input.offsetDirection && input.distance > this.options.threshold && input.maxPointers === this.options.pointers && abs(velocity) > this.options.velocity && input.eventType & INPUT_END;
	  };

	  _proto.emit = function emit(input) {
	    var direction = directionStr(input.offsetDirection);

	    if (direction) {
	      this.manager.emit(this.options.event + direction, input);
	    }

	    this.manager.emit(this.options.event, input);
	  };

	  return SwipeRecognizer;
	}(AttrRecognizer);

	/**
	 * @private
	 * Pinch
	 * Recognized when two or more pointers are moving toward (zoom-in) or away from each other (zoom-out).
	 * @constructor
	 * @extends AttrRecognizer
	 */

	var PinchRecognizer =
	/*#__PURE__*/
	function (_AttrRecognizer) {
	  _inheritsLoose(PinchRecognizer, _AttrRecognizer);

	  function PinchRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _AttrRecognizer.call(this, _extends({
	      event: 'pinch',
	      threshold: 0,
	      pointers: 2
	    }, options)) || this;
	  }

	  var _proto = PinchRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_NONE];
	  };

	  _proto.attrTest = function attrTest(input) {
	    return _AttrRecognizer.prototype.attrTest.call(this, input) && (Math.abs(input.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);
	  };

	  _proto.emit = function emit(input) {
	    if (input.scale !== 1) {
	      var inOut = input.scale < 1 ? 'in' : 'out';
	      input.additionalEvent = this.options.event + inOut;
	    }

	    _AttrRecognizer.prototype.emit.call(this, input);
	  };

	  return PinchRecognizer;
	}(AttrRecognizer);

	/**
	 * @private
	 * Rotate
	 * Recognized when two or more pointer are moving in a circular motion.
	 * @constructor
	 * @extends AttrRecognizer
	 */

	var RotateRecognizer =
	/*#__PURE__*/
	function (_AttrRecognizer) {
	  _inheritsLoose(RotateRecognizer, _AttrRecognizer);

	  function RotateRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _AttrRecognizer.call(this, _extends({
	      event: 'rotate',
	      threshold: 0,
	      pointers: 2
	    }, options)) || this;
	  }

	  var _proto = RotateRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_NONE];
	  };

	  _proto.attrTest = function attrTest(input) {
	    return _AttrRecognizer.prototype.attrTest.call(this, input) && (Math.abs(input.rotation) > this.options.threshold || this.state & STATE_BEGAN);
	  };

	  return RotateRecognizer;
	}(AttrRecognizer);

	/**
	 * @private
	 * Press
	 * Recognized when the pointer is down for x ms without any movement.
	 * @constructor
	 * @extends Recognizer
	 */

	var PressRecognizer =
	/*#__PURE__*/
	function (_Recognizer) {
	  _inheritsLoose(PressRecognizer, _Recognizer);

	  function PressRecognizer(options) {
	    var _this;

	    if (options === void 0) {
	      options = {};
	    }

	    _this = _Recognizer.call(this, _extends({
	      event: 'press',
	      pointers: 1,
	      time: 251,
	      // minimal time of the pointer to be pressed
	      threshold: 9
	    }, options)) || this;
	    _this._timer = null;
	    _this._input = null;
	    return _this;
	  }

	  var _proto = PressRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_AUTO];
	  };

	  _proto.process = function process(input) {
	    var _this2 = this;

	    var options = this.options;
	    var validPointers = input.pointers.length === options.pointers;
	    var validMovement = input.distance < options.threshold;
	    var validTime = input.deltaTime > options.time;
	    this._input = input; // we only allow little movement
	    // and we've reached an end event, so a tap is possible

	    if (!validMovement || !validPointers || input.eventType & (INPUT_END | INPUT_CANCEL) && !validTime) {
	      this.reset();
	    } else if (input.eventType & INPUT_START) {
	      this.reset();
	      this._timer = setTimeout(function () {
	        _this2.state = STATE_RECOGNIZED;

	        _this2.tryEmit();
	      }, options.time);
	    } else if (input.eventType & INPUT_END) {
	      return STATE_RECOGNIZED;
	    }

	    return STATE_FAILED;
	  };

	  _proto.reset = function reset() {
	    clearTimeout(this._timer);
	  };

	  _proto.emit = function emit(input) {
	    if (this.state !== STATE_RECOGNIZED) {
	      return;
	    }

	    if (input && input.eventType & INPUT_END) {
	      this.manager.emit(this.options.event + "up", input);
	    } else {
	      this._input.timeStamp = now();
	      this.manager.emit(this.options.event, this._input);
	    }
	  };

	  return PressRecognizer;
	}(Recognizer);

	var defaults = {
	  /**
	   * @private
	   * set if DOM events are being triggered.
	   * But this is slower and unused by simple implementations, so disabled by default.
	   * @type {Boolean}
	   * @default false
	   */
	  domEvents: false,

	  /**
	   * @private
	   * The value for the touchAction property/fallback.
	   * When set to `compute` it will magically set the correct value based on the added recognizers.
	   * @type {String}
	   * @default compute
	   */
	  touchAction: TOUCH_ACTION_COMPUTE,

	  /**
	   * @private
	   * @type {Boolean}
	   * @default true
	   */
	  enable: true,

	  /**
	   * @private
	   * EXPERIMENTAL FEATURE -- can be removed/changed
	   * Change the parent input target element.
	   * If Null, then it is being set the to main element.
	   * @type {Null|EventTarget}
	   * @default null
	   */
	  inputTarget: null,

	  /**
	   * @private
	   * force an input class
	   * @type {Null|Function}
	   * @default null
	   */
	  inputClass: null,

	  /**
	   * @private
	   * Some CSS properties can be used to improve the working of Hammer.
	   * Add them to this method and they will be set when creating a new Manager.
	   * @namespace
	   */
	  cssProps: {
	    /**
	     * @private
	     * Disables text selection to improve the dragging gesture. Mainly for desktop browsers.
	     * @type {String}
	     * @default 'none'
	     */
	    userSelect: "none",

	    /**
	     * @private
	     * Disable the Windows Phone grippers when pressing an element.
	     * @type {String}
	     * @default 'none'
	     */
	    touchSelect: "none",

	    /**
	     * @private
	     * Disables the default callout shown when you touch and hold a touch target.
	     * On iOS, when you touch and hold a touch target such as a link, Safari displays
	     * a callout containing information about the link. This property allows you to disable that callout.
	     * @type {String}
	     * @default 'none'
	     */
	    touchCallout: "none",

	    /**
	     * @private
	     * Specifies whether zooming is enabled. Used by IE10>
	     * @type {String}
	     * @default 'none'
	     */
	    contentZooming: "none",

	    /**
	     * @private
	     * Specifies that an entire element should be draggable instead of its contents. Mainly for desktop browsers.
	     * @type {String}
	     * @default 'none'
	     */
	    userDrag: "none",

	    /**
	     * @private
	     * Overrides the highlight color shown when the user taps a link or a JavaScript
	     * clickable element in iOS. This property obeys the alpha value, if specified.
	     * @type {String}
	     * @default 'rgba(0,0,0,0)'
	     */
	    tapHighlightColor: "rgba(0,0,0,0)"
	  }
	};
	/**
	 * @private
	 * Default recognizer setup when calling `Hammer()`
	 * When creating a new Manager these will be skipped.
	 * This is separated with other defaults because of tree-shaking.
	 * @type {Array}
	 */

	var preset = [[RotateRecognizer, {
	  enable: false
	}], [PinchRecognizer, {
	  enable: false
	}, ['rotate']], [SwipeRecognizer, {
	  direction: DIRECTION_HORIZONTAL
	}], [PanRecognizer, {
	  direction: DIRECTION_HORIZONTAL
	}, ['swipe']], [TapRecognizer], [TapRecognizer, {
	  event: 'doubletap',
	  taps: 2
	}, ['tap']], [PressRecognizer]];

	var STOP = 1;
	var FORCED_STOP = 2;
	/**
	 * @private
	 * add/remove the css properties as defined in manager.options.cssProps
	 * @param {Manager} manager
	 * @param {Boolean} add
	 */

	function toggleCssProps(manager, add) {
	  var element = manager.element;

	  if (!element.style) {
	    return;
	  }

	  var prop;
	  each(manager.options.cssProps, function (value, name) {
	    prop = prefixed(element.style, name);

	    if (add) {
	      manager.oldCssProps[prop] = element.style[prop];
	      element.style[prop] = value;
	    } else {
	      element.style[prop] = manager.oldCssProps[prop] || "";
	    }
	  });

	  if (!add) {
	    manager.oldCssProps = {};
	  }
	}
	/**
	 * @private
	 * trigger dom event
	 * @param {String} event
	 * @param {Object} data
	 */


	function triggerDomEvent(event, data) {
	  var gestureEvent = document.createEvent("Event");
	  gestureEvent.initEvent(event, true, true);
	  gestureEvent.gesture = data;
	  data.target.dispatchEvent(gestureEvent);
	}
	/**
	* @private
	 * Manager
	 * @param {HTMLElement} element
	 * @param {Object} [options]
	 * @constructor
	 */


	var Manager =
	/*#__PURE__*/
	function () {
	  function Manager(element, options) {
	    var _this = this;

	    this.options = assign$1({}, defaults, options || {});
	    this.options.inputTarget = this.options.inputTarget || element;
	    this.handlers = {};
	    this.session = {};
	    this.recognizers = [];
	    this.oldCssProps = {};
	    this.element = element;
	    this.input = createInputInstance(this);
	    this.touchAction = new TouchAction(this, this.options.touchAction);
	    toggleCssProps(this, true);
	    each(this.options.recognizers, function (item) {
	      var recognizer = _this.add(new item[0](item[1]));

	      item[2] && recognizer.recognizeWith(item[2]);
	      item[3] && recognizer.requireFailure(item[3]);
	    }, this);
	  }
	  /**
	   * @private
	   * set options
	   * @param {Object} options
	   * @returns {Manager}
	   */


	  var _proto = Manager.prototype;

	  _proto.set = function set(options) {
	    assign$1(this.options, options); // Options that need a little more setup

	    if (options.touchAction) {
	      this.touchAction.update();
	    }

	    if (options.inputTarget) {
	      // Clean up existing event listeners and reinitialize
	      this.input.destroy();
	      this.input.target = options.inputTarget;
	      this.input.init();
	    }

	    return this;
	  };
	  /**
	   * @private
	   * stop recognizing for this session.
	   * This session will be discarded, when a new [input]start event is fired.
	   * When forced, the recognizer cycle is stopped immediately.
	   * @param {Boolean} [force]
	   */


	  _proto.stop = function stop(force) {
	    this.session.stopped = force ? FORCED_STOP : STOP;
	  };
	  /**
	   * @private
	   * run the recognizers!
	   * called by the inputHandler function on every movement of the pointers (touches)
	   * it walks through all the recognizers and tries to detect the gesture that is being made
	   * @param {Object} inputData
	   */


	  _proto.recognize = function recognize(inputData) {
	    var session = this.session;

	    if (session.stopped) {
	      return;
	    } // run the touch-action polyfill


	    this.touchAction.preventDefaults(inputData);
	    var recognizer;
	    var recognizers = this.recognizers; // this holds the recognizer that is being recognized.
	    // so the recognizer's state needs to be BEGAN, CHANGED, ENDED or RECOGNIZED
	    // if no recognizer is detecting a thing, it is set to `null`

	    var curRecognizer = session.curRecognizer; // reset when the last recognizer is recognized
	    // or when we're in a new session

	    if (!curRecognizer || curRecognizer && curRecognizer.state & STATE_RECOGNIZED) {
	      session.curRecognizer = null;
	      curRecognizer = null;
	    }

	    var i = 0;

	    while (i < recognizers.length) {
	      recognizer = recognizers[i]; // find out if we are allowed try to recognize the input for this one.
	      // 1.   allow if the session is NOT forced stopped (see the .stop() method)
	      // 2.   allow if we still haven't recognized a gesture in this session, or the this recognizer is the one
	      //      that is being recognized.
	      // 3.   allow if the recognizer is allowed to run simultaneous with the current recognized recognizer.
	      //      this can be setup with the `recognizeWith()` method on the recognizer.

	      if (session.stopped !== FORCED_STOP && ( // 1
	      !curRecognizer || recognizer === curRecognizer || // 2
	      recognizer.canRecognizeWith(curRecognizer))) {
	        // 3
	        recognizer.recognize(inputData);
	      } else {
	        recognizer.reset();
	      } // if the recognizer has been recognizing the input as a valid gesture, we want to store this one as the
	      // current active recognizer. but only if we don't already have an active recognizer


	      if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {
	        session.curRecognizer = recognizer;
	        curRecognizer = recognizer;
	      }

	      i++;
	    }
	  };
	  /**
	   * @private
	   * get a recognizer by its event name.
	   * @param {Recognizer|String} recognizer
	   * @returns {Recognizer|Null}
	   */


	  _proto.get = function get(recognizer) {
	    if (recognizer instanceof Recognizer) {
	      return recognizer;
	    }

	    var recognizers = this.recognizers;

	    for (var i = 0; i < recognizers.length; i++) {
	      if (recognizers[i].options.event === recognizer) {
	        return recognizers[i];
	      }
	    }

	    return null;
	  };
	  /**
	   * @private add a recognizer to the manager
	   * existing recognizers with the same event name will be removed
	   * @param {Recognizer} recognizer
	   * @returns {Recognizer|Manager}
	   */


	  _proto.add = function add(recognizer) {
	    if (invokeArrayArg(recognizer, "add", this)) {
	      return this;
	    } // remove existing


	    var existing = this.get(recognizer.options.event);

	    if (existing) {
	      this.remove(existing);
	    }

	    this.recognizers.push(recognizer);
	    recognizer.manager = this;
	    this.touchAction.update();
	    return recognizer;
	  };
	  /**
	   * @private
	   * remove a recognizer by name or instance
	   * @param {Recognizer|String} recognizer
	   * @returns {Manager}
	   */


	  _proto.remove = function remove(recognizer) {
	    if (invokeArrayArg(recognizer, "remove", this)) {
	      return this;
	    }

	    var targetRecognizer = this.get(recognizer); // let's make sure this recognizer exists

	    if (recognizer) {
	      var recognizers = this.recognizers;
	      var index = inArray(recognizers, targetRecognizer);

	      if (index !== -1) {
	        recognizers.splice(index, 1);
	        this.touchAction.update();
	      }
	    }

	    return this;
	  };
	  /**
	   * @private
	   * bind event
	   * @param {String} events
	   * @param {Function} handler
	   * @returns {EventEmitter} this
	   */


	  _proto.on = function on(events, handler) {
	    if (events === undefined || handler === undefined) {
	      return this;
	    }

	    var handlers = this.handlers;
	    each(splitStr(events), function (event) {
	      handlers[event] = handlers[event] || [];
	      handlers[event].push(handler);
	    });
	    return this;
	  };
	  /**
	   * @private unbind event, leave emit blank to remove all handlers
	   * @param {String} events
	   * @param {Function} [handler]
	   * @returns {EventEmitter} this
	   */


	  _proto.off = function off(events, handler) {
	    if (events === undefined) {
	      return this;
	    }

	    var handlers = this.handlers;
	    each(splitStr(events), function (event) {
	      if (!handler) {
	        delete handlers[event];
	      } else {
	        handlers[event] && handlers[event].splice(inArray(handlers[event], handler), 1);
	      }
	    });
	    return this;
	  };
	  /**
	   * @private emit event to the listeners
	   * @param {String} event
	   * @param {Object} data
	   */


	  _proto.emit = function emit(event, data) {
	    // we also want to trigger dom events
	    if (this.options.domEvents) {
	      triggerDomEvent(event, data);
	    } // no handlers, so skip it all


	    var handlers = this.handlers[event] && this.handlers[event].slice();

	    if (!handlers || !handlers.length) {
	      return;
	    }

	    data.type = event;

	    data.preventDefault = function () {
	      data.srcEvent.preventDefault();
	    };

	    var i = 0;

	    while (i < handlers.length) {
	      handlers[i](data);
	      i++;
	    }
	  };
	  /**
	   * @private
	   * destroy the manager and unbinds all events
	   * it doesn't unbind dom events, that is the user own responsibility
	   */


	  _proto.destroy = function destroy() {
	    this.element && toggleCssProps(this, false);
	    this.handlers = {};
	    this.session = {};
	    this.input.destroy();
	    this.element = null;
	  };

	  return Manager;
	}();

	var SINGLE_TOUCH_INPUT_MAP = {
	  touchstart: INPUT_START,
	  touchmove: INPUT_MOVE,
	  touchend: INPUT_END,
	  touchcancel: INPUT_CANCEL
	};
	var SINGLE_TOUCH_TARGET_EVENTS = 'touchstart';
	var SINGLE_TOUCH_WINDOW_EVENTS = 'touchstart touchmove touchend touchcancel';
	/**
	 * @private
	 * Touch events input
	 * @constructor
	 * @extends Input
	 */

	var SingleTouchInput =
	/*#__PURE__*/
	function (_Input) {
	  _inheritsLoose(SingleTouchInput, _Input);

	  function SingleTouchInput() {
	    var _this;

	    var proto = SingleTouchInput.prototype;
	    proto.evTarget = SINGLE_TOUCH_TARGET_EVENTS;
	    proto.evWin = SINGLE_TOUCH_WINDOW_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.started = false;
	    return _this;
	  }

	  var _proto = SingleTouchInput.prototype;

	  _proto.handler = function handler(ev) {
	    var type = SINGLE_TOUCH_INPUT_MAP[ev.type]; // should we handle the touch events?

	    if (type === INPUT_START) {
	      this.started = true;
	    }

	    if (!this.started) {
	      return;
	    }

	    var touches = normalizeSingleTouches.call(this, ev, type); // when done, reset the started state

	    if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {
	      this.started = false;
	    }

	    this.callback(this.manager, type, {
	      pointers: touches[0],
	      changedPointers: touches[1],
	      pointerType: INPUT_TYPE_TOUCH,
	      srcEvent: ev
	    });
	  };

	  return SingleTouchInput;
	}(Input);

	function normalizeSingleTouches(ev, type) {
	  var all = toArray$1(ev.touches);
	  var changed = toArray$1(ev.changedTouches);

	  if (type & (INPUT_END | INPUT_CANCEL)) {
	    all = uniqueArray(all.concat(changed), 'identifier', true);
	  }

	  return [all, changed];
	}

	/**
	 * @private
	 * wrap a method with a deprecation warning and stack trace
	 * @param {Function} method
	 * @param {String} name
	 * @param {String} message
	 * @returns {Function} A new function wrapping the supplied method.
	 */
	function deprecate(method, name, message) {
	  var deprecationMessage = "DEPRECATED METHOD: " + name + "\n" + message + " AT \n";
	  return function () {
	    var e = new Error('get-stack-trace');
	    var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, '').replace(/^\s+at\s+/gm, '').replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@') : 'Unknown Stack Trace';
	    var log = window.console && (window.console.warn || window.console.log);

	    if (log) {
	      log.call(window.console, deprecationMessage, stack);
	    }

	    return method.apply(this, arguments);
	  };
	}

	/**
	 * @private
	 * extend object.
	 * means that properties in dest will be overwritten by the ones in src.
	 * @param {Object} dest
	 * @param {Object} src
	 * @param {Boolean} [merge=false]
	 * @returns {Object} dest
	 */

	var extend$1 = deprecate(function (dest, src, merge) {
	  var keys = Object.keys(src);
	  var i = 0;

	  while (i < keys.length) {
	    if (!merge || merge && dest[keys[i]] === undefined) {
	      dest[keys[i]] = src[keys[i]];
	    }

	    i++;
	  }

	  return dest;
	}, 'extend', 'Use `assign`.');

	/**
	 * @private
	 * merge the values from src in the dest.
	 * means that properties that exist in dest will not be overwritten by src
	 * @param {Object} dest
	 * @param {Object} src
	 * @returns {Object} dest
	 */

	var merge$1 = deprecate(function (dest, src) {
	  return extend$1(dest, src, true);
	}, 'merge', 'Use `assign`.');

	/**
	 * @private
	 * simple class inheritance
	 * @param {Function} child
	 * @param {Function} base
	 * @param {Object} [properties]
	 */

	function inherit(child, base, properties) {
	  var baseP = base.prototype;
	  var childP;
	  childP = child.prototype = Object.create(baseP);
	  childP.constructor = child;
	  childP._super = baseP;

	  if (properties) {
	    assign$1(childP, properties);
	  }
	}

	/**
	 * @private
	 * simple function bind
	 * @param {Function} fn
	 * @param {Object} context
	 * @returns {Function}
	 */
	function bindFn(fn, context) {
	  return function boundFn() {
	    return fn.apply(context, arguments);
	  };
	}

	/**
	 * @private
	 * Simple way to create a manager with a default set of recognizers.
	 * @param {HTMLElement} element
	 * @param {Object} [options]
	 * @constructor
	 */

	var Hammer$3 =
	/*#__PURE__*/
	function () {
	  var Hammer =
	  /**
	    * @private
	    * @const {string}
	    */
	  function Hammer(element, options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return new Manager(element, _extends({
	      recognizers: preset.concat()
	    }, options));
	  };

	  Hammer.VERSION = "2.0.17-rc";
	  Hammer.DIRECTION_ALL = DIRECTION_ALL;
	  Hammer.DIRECTION_DOWN = DIRECTION_DOWN;
	  Hammer.DIRECTION_LEFT = DIRECTION_LEFT;
	  Hammer.DIRECTION_RIGHT = DIRECTION_RIGHT;
	  Hammer.DIRECTION_UP = DIRECTION_UP;
	  Hammer.DIRECTION_HORIZONTAL = DIRECTION_HORIZONTAL;
	  Hammer.DIRECTION_VERTICAL = DIRECTION_VERTICAL;
	  Hammer.DIRECTION_NONE = DIRECTION_NONE;
	  Hammer.DIRECTION_DOWN = DIRECTION_DOWN;
	  Hammer.INPUT_START = INPUT_START;
	  Hammer.INPUT_MOVE = INPUT_MOVE;
	  Hammer.INPUT_END = INPUT_END;
	  Hammer.INPUT_CANCEL = INPUT_CANCEL;
	  Hammer.STATE_POSSIBLE = STATE_POSSIBLE;
	  Hammer.STATE_BEGAN = STATE_BEGAN;
	  Hammer.STATE_CHANGED = STATE_CHANGED;
	  Hammer.STATE_ENDED = STATE_ENDED;
	  Hammer.STATE_RECOGNIZED = STATE_RECOGNIZED;
	  Hammer.STATE_CANCELLED = STATE_CANCELLED;
	  Hammer.STATE_FAILED = STATE_FAILED;
	  Hammer.Manager = Manager;
	  Hammer.Input = Input;
	  Hammer.TouchAction = TouchAction;
	  Hammer.TouchInput = TouchInput;
	  Hammer.MouseInput = MouseInput;
	  Hammer.PointerEventInput = PointerEventInput;
	  Hammer.TouchMouseInput = TouchMouseInput;
	  Hammer.SingleTouchInput = SingleTouchInput;
	  Hammer.Recognizer = Recognizer;
	  Hammer.AttrRecognizer = AttrRecognizer;
	  Hammer.Tap = TapRecognizer;
	  Hammer.Pan = PanRecognizer;
	  Hammer.Swipe = SwipeRecognizer;
	  Hammer.Pinch = PinchRecognizer;
	  Hammer.Rotate = RotateRecognizer;
	  Hammer.Press = PressRecognizer;
	  Hammer.on = addEventListeners;
	  Hammer.off = removeEventListeners;
	  Hammer.each = each;
	  Hammer.merge = merge$1;
	  Hammer.extend = extend$1;
	  Hammer.bindFn = bindFn;
	  Hammer.assign = assign$1;
	  Hammer.inherit = inherit;
	  Hammer.bindFn = bindFn;
	  Hammer.prefixed = prefixed;
	  Hammer.toArray = toArray$1;
	  Hammer.inArray = inArray;
	  Hammer.uniqueArray = uniqueArray;
	  Hammer.splitStr = splitStr;
	  Hammer.boolOrFn = boolOrFn;
	  Hammer.hasParent = hasParent$1;
	  Hammer.addEventListeners = addEventListeners;
	  Hammer.removeEventListeners = removeEventListeners;
	  Hammer.defaults = assign$1({}, defaults, {
	    preset: preset
	  });
	  return Hammer;
	}();

	//  style loader but by script tag, not by the loader.

	Hammer$3.defaults;

	var Hammer$4 = Hammer$3;

	function ownKeys$1(object, enumerableOnly) { var keys = _Object$keys(object); if (_Object$getOwnPropertySymbols) { var symbols = _Object$getOwnPropertySymbols(object); enumerableOnly && (symbols = _filterInstanceProperty(symbols).call(symbols, function (sym) { return _Object$getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
	function _objectSpread$1(target) { for (var i = 1; i < arguments.length; i++) { var _context22, _context23; var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? _forEachInstanceProperty(_context22 = ownKeys$1(Object(source), !0)).call(_context22, function (key) { _defineProperty(target, key, source[key]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(target, _Object$getOwnPropertyDescriptors(source)) : _forEachInstanceProperty(_context23 = ownKeys$1(Object(source))).call(_context23, function (key) { _Object$defineProperty(target, key, _Object$getOwnPropertyDescriptor(source, key)); }); } return target; }
	function _createForOfIteratorHelper$6(o, allowArrayLike) { var it = typeof _Symbol !== "undefined" && _getIteratorMethod(o) || o["@@iterator"]; if (!it) { if (_Array$isArray$1(o) || (it = _unsupportedIterableToArray$6(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
	function _unsupportedIterableToArray$6(o, minLen) { var _context21; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$6(o, minLen); var n = _sliceInstanceProperty(_context21 = Object.prototype.toString.call(o)).call(_context21, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return _Array$from$1(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$6(o, minLen); }
	function _arrayLikeToArray$6(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

	/**
	 * Use this symbol to delete properies in deepObjectAssign.
	 */
	var DELETE = _Symbol("DELETE");
	/**
	 * Pure version of deepObjectAssign, it doesn't modify any of it's arguments.
	 *
	 * @param base - The base object that fullfils the whole interface T.
	 * @param updates - Updates that may change or delete props.
	 * @returns A brand new instance with all the supplied objects deeply merged.
	 */
	function pureDeepObjectAssign(base) {
	  var _context;
	  for (var _len = arguments.length, updates = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	    updates[_key - 1] = arguments[_key];
	  }
	  return deepObjectAssign.apply(void 0, _concatInstanceProperty(_context = [{}, base]).call(_context, updates));
	}
	/**
	 * Deep version of object assign with additional deleting by the DELETE symbol.
	 *
	 * @param values - Objects to be deeply merged.
	 * @returns The first object from values.
	 */
	function deepObjectAssign() {
	  var merged = deepObjectAssignNonentry.apply(void 0, arguments);
	  stripDelete(merged);
	  return merged;
	}
	/**
	 * Deep version of object assign with additional deleting by the DELETE symbol.
	 *
	 * @remarks
	 * This doesn't strip the DELETE symbols so they may end up in the final object.
	 * @param values - Objects to be deeply merged.
	 * @returns The first object from values.
	 */
	function deepObjectAssignNonentry() {
	  for (var _len2 = arguments.length, values = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
	    values[_key2] = arguments[_key2];
	  }
	  if (values.length < 2) {
	    return values[0];
	  } else if (values.length > 2) {
	    var _context2;
	    return deepObjectAssignNonentry.apply(void 0, _concatInstanceProperty(_context2 = [deepObjectAssign(values[0], values[1])]).call(_context2, _toConsumableArray(_sliceInstanceProperty(values).call(values, 2))));
	  }
	  var a = values[0];
	  var b = values[1];
	  var _iterator = _createForOfIteratorHelper$6(_Reflect$ownKeys(b)),
	    _step;
	  try {
	    for (_iterator.s(); !(_step = _iterator.n()).done;) {
	      var prop = _step.value;
	      if (!Object.prototype.propertyIsEnumerable.call(b, prop)) ;else if (b[prop] === DELETE) {
	        delete a[prop];
	      } else if (a[prop] !== null && b[prop] !== null && _typeof(a[prop]) === "object" && _typeof(b[prop]) === "object" && !_Array$isArray$1(a[prop]) && !_Array$isArray$1(b[prop])) {
	        a[prop] = deepObjectAssignNonentry(a[prop], b[prop]);
	      } else {
	        a[prop] = clone(b[prop]);
	      }
	    }
	  } catch (err) {
	    _iterator.e(err);
	  } finally {
	    _iterator.f();
	  }
	  return a;
	}
	/**
	 * Deep clone given object or array. In case of primitive simply return.
	 *
	 * @param a - Anything.
	 * @returns Deep cloned object/array or unchanged a.
	 */
	function clone(a) {
	  if (_Array$isArray$1(a)) {
	    return _mapInstanceProperty(a).call(a, function (value) {
	      return clone(value);
	    });
	  } else if (_typeof(a) === "object" && a !== null) {
	    return deepObjectAssignNonentry({}, a);
	  } else {
	    return a;
	  }
	}
	/**
	 * Strip DELETE from given object.
	 *
	 * @param a - Object which may contain DELETE but won't after this is executed.
	 */
	function stripDelete(a) {
	  for (var _i = 0, _Object$keys$1 = _Object$keys(a); _i < _Object$keys$1.length; _i++) {
	    var prop = _Object$keys$1[_i];
	    if (a[prop] === DELETE) {
	      delete a[prop];
	    } else if (_typeof(a[prop]) === "object" && a[prop] !== null) {
	      stripDelete(a[prop]);
	    }
	  }
	}

	/**
	 * Seedable, fast and reasonably good (not crypto but more than okay for our
	 * needs) random number generator.
	 *
	 * @remarks
	 * Adapted from {@link https://web.archive.org/web/20110429100736/http://baagoe.com:80/en/RandomMusings/javascript}.
	 * Original algorithm created by Johannes Baagøe \<baagoe\@baagoe.com\> in 2010.
	 */
	/**
	 * Create a seeded pseudo random generator based on Alea by Johannes Baagøe.
	 *
	 * @param seed - All supplied arguments will be used as a seed. In case nothing
	 * is supplied the current time will be used to seed the generator.
	 * @returns A ready to use seeded generator.
	 */
	function Alea() {
	  for (var _len3 = arguments.length, seed = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
	    seed[_key3] = arguments[_key3];
	  }
	  return AleaImplementation(seed.length ? seed : [_Date$now()]);
	}
	/**
	 * An implementation of [[Alea]] without user input validation.
	 *
	 * @param seed - The data that will be used to seed the generator.
	 * @returns A ready to use seeded generator.
	 */
	function AleaImplementation(seed) {
	  var _mashSeed = mashSeed(seed),
	    _mashSeed2 = _slicedToArray(_mashSeed, 3),
	    s0 = _mashSeed2[0],
	    s1 = _mashSeed2[1],
	    s2 = _mashSeed2[2];
	  var c = 1;
	  var random = function random() {
	    var t = 2091639 * s0 + c * 2.3283064365386963e-10; // 2^-32
	    s0 = s1;
	    s1 = s2;
	    return s2 = t - (c = t | 0);
	  };
	  random.uint32 = function () {
	    return random() * 0x100000000;
	  }; // 2^32
	  random.fract53 = function () {
	    return random() + (random() * 0x200000 | 0) * 1.1102230246251565e-16;
	  }; // 2^-53
	  random.algorithm = "Alea";
	  random.seed = seed;
	  random.version = "0.9";
	  return random;
	}
	/**
	 * Turn arbitrary data into values [[AleaImplementation]] can use to generate
	 * random numbers.
	 *
	 * @param seed - Arbitrary data that will be used as the seed.
	 * @returns Three numbers to use as initial values for [[AleaImplementation]].
	 */
	function mashSeed() {
	  var mash = Mash();
	  var s0 = mash(" ");
	  var s1 = mash(" ");
	  var s2 = mash(" ");
	  for (var i = 0; i < arguments.length; i++) {
	    s0 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);
	    if (s0 < 0) {
	      s0 += 1;
	    }
	    s1 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);
	    if (s1 < 0) {
	      s1 += 1;
	    }
	    s2 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);
	    if (s2 < 0) {
	      s2 += 1;
	    }
	  }
	  return [s0, s1, s2];
	}
	/**
	 * Create a new mash function.
	 *
	 * @returns A nonpure function that takes arbitrary [[Mashable]] data and turns
	 * them into numbers.
	 */
	function Mash() {
	  var n = 0xefc8249d;
	  return function (data) {
	    var string = data.toString();
	    for (var i = 0; i < string.length; i++) {
	      n += string.charCodeAt(i);
	      var h = 0.02519603282416938 * n;
	      n = h >>> 0;
	      h -= n;
	      h *= n;
	      n = h >>> 0;
	      h -= n;
	      n += h * 0x100000000; // 2^32
	    }

	    return (n >>> 0) * 2.3283064365386963e-10; // 2^-32
	  };
	}

	/**
	 * Setup a mock hammer.js object, for unit testing.
	 *
	 * Inspiration: https://github.com/uber/deck.gl/pull/658
	 *
	 * @returns {{on: noop, off: noop, destroy: noop, emit: noop, get: get}}
	 */
	function hammerMock$1() {
	  var noop = function noop() {};
	  return {
	    on: noop,
	    off: noop,
	    destroy: noop,
	    emit: noop,
	    get: function get() {
	      return {
	        set: noop
	      };
	    }
	  };
	}
	var Hammer$1 = typeof window !== "undefined" ? window.Hammer || Hammer$4 : function () {
	  // hammer.js is only available in a browser, not in node.js. Replacing it with a mock object.
	  return hammerMock$1();
	};

	/**
	 * Turn an element into an clickToUse element.
	 * When not active, the element has a transparent overlay. When the overlay is
	 * clicked, the mode is changed to active.
	 * When active, the element is displayed with a blue border around it, and
	 * the interactive contents of the element can be used. When clicked outside
	 * the element, the elements mode is changed to inactive.
	 *
	 * @param {Element} container
	 * @class Activator
	 */
	function Activator$1(container) {
	  var _this = this,
	    _context3;
	  this._cleanupQueue = [];
	  this.active = false;
	  this._dom = {
	    container: container,
	    overlay: document.createElement("div")
	  };
	  this._dom.overlay.classList.add("vis-overlay");
	  this._dom.container.appendChild(this._dom.overlay);
	  this._cleanupQueue.push(function () {
	    _this._dom.overlay.parentNode.removeChild(_this._dom.overlay);
	  });
	  var hammer = Hammer$1(this._dom.overlay);
	  hammer.on("tap", _bindInstanceProperty(_context3 = this._onTapOverlay).call(_context3, this));
	  this._cleanupQueue.push(function () {
	    hammer.destroy();
	    // FIXME: cleaning up hammer instances doesn't work (Timeline not removed
	    // from memory)
	  });

	  // block all touch events (except tap)
	  var events = ["tap", "doubletap", "press", "pinch", "pan", "panstart", "panmove", "panend"];
	  _forEachInstanceProperty(events).call(events, function (event) {
	    hammer.on(event, function (event) {
	      event.srcEvent.stopPropagation();
	    });
	  });

	  // attach a click event to the window, in order to deactivate when clicking outside the timeline
	  if (document && document.body) {
	    this._onClick = function (event) {
	      if (!_hasParent$1(event.target, container)) {
	        _this.deactivate();
	      }
	    };
	    document.body.addEventListener("click", this._onClick);
	    this._cleanupQueue.push(function () {
	      document.body.removeEventListener("click", _this._onClick);
	    });
	  }

	  // prepare escape key listener for deactivating when active
	  this._escListener = function (event) {
	    if ("key" in event ? event.key === "Escape" : event.keyCode === 27 /* the keyCode is for IE11 */) {
	      _this.deactivate();
	    }
	  };
	}

	// turn into an event emitter
	Emitter(Activator$1.prototype);

	// The currently active activator
	Activator$1.current = null;

	/**
	 * Destroy the activator. Cleans up all created DOM and event listeners
	 */
	Activator$1.prototype.destroy = function () {
	  var _context4, _context5;
	  this.deactivate();
	  var _iterator2 = _createForOfIteratorHelper$6(_reverseInstanceProperty(_context4 = _spliceInstanceProperty(_context5 = this._cleanupQueue).call(_context5, 0)).call(_context4)),
	    _step2;
	  try {
	    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
	      var callback = _step2.value;
	      callback();
	    }
	  } catch (err) {
	    _iterator2.e(err);
	  } finally {
	    _iterator2.f();
	  }
	};

	/**
	 * Activate the element
	 * Overlay is hidden, element is decorated with a blue shadow border
	 */
	Activator$1.prototype.activate = function () {
	  // we allow only one active activator at a time
	  if (Activator$1.current) {
	    Activator$1.current.deactivate();
	  }
	  Activator$1.current = this;
	  this.active = true;
	  this._dom.overlay.style.display = "none";
	  this._dom.container.classList.add("vis-active");
	  this.emit("change");
	  this.emit("activate");

	  // ugly hack: bind ESC after emitting the events, as the Network rebinds all
	  // keyboard events on a 'change' event
	  document.body.addEventListener("keydown", this._escListener);
	};

	/**
	 * Deactivate the element
	 * Overlay is displayed on top of the element
	 */
	Activator$1.prototype.deactivate = function () {
	  this.active = false;
	  this._dom.overlay.style.display = "block";
	  this._dom.container.classList.remove("vis-active");
	  document.body.removeEventListener("keydown", this._escListener);
	  this.emit("change");
	  this.emit("deactivate");
	};

	/**
	 * Handle a tap event: activate the container
	 *
	 * @param {Event}  event   The event
	 * @private
	 */
	Activator$1.prototype._onTapOverlay = function (event) {
	  // activate the container
	  this.activate();
	  event.srcEvent.stopPropagation();
	};

	/**
	 * Test whether the element has the requested parent element somewhere in
	 * its chain of parent nodes.
	 *
	 * @param {HTMLElement} element
	 * @param {HTMLElement} parent
	 * @returns {boolean} Returns true when the parent is found somewhere in the
	 *                    chain of parent nodes.
	 * @private
	 */
	function _hasParent$1(element, parent) {
	  while (element) {
	    if (element === parent) {
	      return true;
	    }
	    element = element.parentNode;
	  }
	  return false;
	}

	// utility functions
	// parse ASP.Net Date pattern,
	// for example '/Date(1198908717056)/' or '/Date(1198908717056-0700)/'
	// code from http://momentjs.com/
	var ASPDateRegex$1 = /^\/?Date\((-?\d+)/i;
	// Color REs
	var fullHexRE = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i;
	var shortHexRE = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
	var rgbRE = /^rgb\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *\)$/i;
	var rgbaRE = /^rgba\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *([01]|0?\.\d+) *\)$/i;
	/**
	 * Test whether given object is a number.
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if number, false otherwise.
	 */
	function isNumber(value) {
	  return value instanceof Number || typeof value === "number";
	}
	/**
	 * Remove everything in the DOM object.
	 *
	 * @param DOMobject - Node whose child nodes will be recursively deleted.
	 */
	function recursiveDOMDelete(DOMobject) {
	  if (DOMobject) {
	    while (DOMobject.hasChildNodes() === true) {
	      var child = DOMobject.firstChild;
	      if (child) {
	        recursiveDOMDelete(child);
	        DOMobject.removeChild(child);
	      }
	    }
	  }
	}
	/**
	 * Test whether given object is a string.
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if string, false otherwise.
	 */
	function isString(value) {
	  return value instanceof String || typeof value === "string";
	}
	/**
	 * Test whether given object is a object (not primitive or null).
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if not null object, false otherwise.
	 */
	function isObject$3(value) {
	  return _typeof(value) === "object" && value !== null;
	}
	/**
	 * Test whether given object is a Date, or a String containing a Date.
	 *
	 * @param value - Input value of unknown type.
	 * @returns True if Date instance or string date representation, false otherwise.
	 */
	function isDate(value) {
	  if (value instanceof Date) {
	    return true;
	  } else if (isString(value)) {
	    // test whether this string contains a date
	    var match = ASPDateRegex$1.exec(value);
	    if (match) {
	      return true;
	    } else if (!isNaN(Date.parse(value))) {
	      return true;
	    }
	  }
	  return false;
	}
	/**
	 * Copy property from b to a if property present in a.
	 * If property in b explicitly set to null, delete it if `allowDeletion` set.
	 *
	 * Internal helper routine, should not be exported. Not added to `exports` for that reason.
	 *
	 * @param a - Target object.
	 * @param b - Source object.
	 * @param prop - Name of property to copy from b to a.
	 * @param allowDeletion - If true, delete property in a if explicitly set to null in b.
	 */
	function copyOrDelete(a, b, prop, allowDeletion) {
	  var doDeletion = false;
	  if (allowDeletion === true) {
	    doDeletion = b[prop] === null && a[prop] !== undefined;
	  }
	  if (doDeletion) {
	    delete a[prop];
	  } else {
	    a[prop] = b[prop]; // Remember, this is a reference copy!
	  }
	}
	/**
	 * Fill an object with a possibly partially defined other object.
	 *
	 * Only copies values for the properties already present in a.
	 * That means an object is not created on a property if only the b object has it.
	 *
	 * @param a - The object that will have it's properties updated.
	 * @param b - The object with property updates.
	 * @param allowDeletion - If true, delete properties in a that are explicitly set to null in b.
	 */
	function fillIfDefined(a, b) {
	  var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  // NOTE: iteration of properties of a
	  // NOTE: prototype properties iterated over as well
	  for (var prop in a) {
	    if (b[prop] !== undefined) {
	      if (b[prop] === null || _typeof(b[prop]) !== "object") {
	        // Note: typeof null === 'object'
	        copyOrDelete(a, b, prop, allowDeletion);
	      } else {
	        var aProp = a[prop];
	        var bProp = b[prop];
	        if (isObject$3(aProp) && isObject$3(bProp)) {
	          fillIfDefined(aProp, bProp, allowDeletion);
	        }
	      }
	    }
	  }
	}
	/**
	 * Copy the values of all of the enumerable own properties from one or more source objects to a
	 * target object. Returns the target object.
	 *
	 * @param target - The target object to copy to.
	 * @param source - The source object from which to copy properties.
	 * @returns The target object.
	 */
	var extend = _Object$assign;
	/**
	 * Extend object a with selected properties of object b or a series of objects.
	 *
	 * @remarks
	 * Only properties with defined values are copied.
	 * @param props - Properties to be copied to a.
	 * @param a - The target.
	 * @param others - The sources.
	 * @returns Argument a.
	 */
	function selectiveExtend(props, a) {
	  if (!_Array$isArray$1(props)) {
	    throw new Error("Array with property names expected as first argument");
	  }
	  for (var _len4 = arguments.length, others = new Array(_len4 > 2 ? _len4 - 2 : 0), _key4 = 2; _key4 < _len4; _key4++) {
	    others[_key4 - 2] = arguments[_key4];
	  }
	  for (var _i2 = 0, _others = others; _i2 < _others.length; _i2++) {
	    var other = _others[_i2];
	    for (var p = 0; p < props.length; p++) {
	      var prop = props[p];
	      if (other && Object.prototype.hasOwnProperty.call(other, prop)) {
	        a[prop] = other[prop];
	      }
	    }
	  }
	  return a;
	}
	/**
	 * Extend object a with selected properties of object b.
	 * Only properties with defined values are copied.
	 *
	 * @remarks
	 * Previous version of this routine implied that multiple source objects could
	 * be used; however, the implementation was **wrong**. Since multiple (\>1)
	 * sources weren't used anywhere in the `vis.js` code, this has been removed
	 * @param props - Names of first-level properties to copy over.
	 * @param a - Target object.
	 * @param b - Source object.
	 * @param allowDeletion - If true, delete property in a if explicitly set to null in b.
	 * @returns Argument a.
	 */
	function selectiveDeepExtend(props, a, b) {
	  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	  // TODO: add support for Arrays to deepExtend
	  if (_Array$isArray$1(b)) {
	    throw new TypeError("Arrays are not supported by deepExtend");
	  }
	  for (var p = 0; p < props.length; p++) {
	    var prop = props[p];
	    if (Object.prototype.hasOwnProperty.call(b, prop)) {
	      if (b[prop] && b[prop].constructor === Object) {
	        if (a[prop] === undefined) {
	          a[prop] = {};
	        }
	        if (a[prop].constructor === Object) {
	          deepExtend(a[prop], b[prop], false, allowDeletion);
	        } else {
	          copyOrDelete(a, b, prop, allowDeletion);
	        }
	      } else if (_Array$isArray$1(b[prop])) {
	        throw new TypeError("Arrays are not supported by deepExtend");
	      } else {
	        copyOrDelete(a, b, prop, allowDeletion);
	      }
	    }
	  }
	  return a;
	}
	/**
	 * Extend object `a` with properties of object `b`, ignoring properties which
	 * are explicitly specified to be excluded.
	 *
	 * @remarks
	 * The properties of `b` are considered for copying. Properties which are
	 * themselves objects are are also extended. Only properties with defined
	 * values are copied.
	 * @param propsToExclude - Names of properties which should *not* be copied.
	 * @param a - Object to extend.
	 * @param b - Object to take properties from for extension.
	 * @param allowDeletion - If true, delete properties in a that are explicitly
	 * set to null in b.
	 * @returns Argument a.
	 */
	function selectiveNotDeepExtend(propsToExclude, a, b) {
	  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	  // TODO: add support for Arrays to deepExtend
	  // NOTE: array properties have an else-below; apparently, there is a problem here.
	  if (_Array$isArray$1(b)) {
	    throw new TypeError("Arrays are not supported by deepExtend");
	  }
	  for (var prop in b) {
	    if (!Object.prototype.hasOwnProperty.call(b, prop)) {
	      continue;
	    } // Handle local properties only
	    if (_includesInstanceProperty(propsToExclude).call(propsToExclude, prop)) {
	      continue;
	    } // In exclusion list, skip
	    if (b[prop] && b[prop].constructor === Object) {
	      if (a[prop] === undefined) {
	        a[prop] = {};
	      }
	      if (a[prop].constructor === Object) {
	        deepExtend(a[prop], b[prop]); // NOTE: allowDeletion not propagated!
	      } else {
	        copyOrDelete(a, b, prop, allowDeletion);
	      }
	    } else if (_Array$isArray$1(b[prop])) {
	      a[prop] = [];
	      for (var i = 0; i < b[prop].length; i++) {
	        a[prop].push(b[prop][i]);
	      }
	    } else {
	      copyOrDelete(a, b, prop, allowDeletion);
	    }
	  }
	  return a;
	}
	/**
	 * Deep extend an object a with the properties of object b.
	 *
	 * @param a - Target object.
	 * @param b - Source object.
	 * @param protoExtend - If true, the prototype values will also be extended.
	 * (That is the options objects that inherit from others will also get the
	 * inherited options).
	 * @param allowDeletion - If true, the values of fields that are null will be deleted.
	 * @returns Argument a.
	 */
	function deepExtend(a, b) {
	  var protoExtend = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	  for (var prop in b) {
	    if (Object.prototype.hasOwnProperty.call(b, prop) || protoExtend === true) {
	      if (_typeof(b[prop]) === "object" && b[prop] !== null && _Object$getPrototypeOf(b[prop]) === Object.prototype) {
	        if (a[prop] === undefined) {
	          a[prop] = deepExtend({}, b[prop], protoExtend); // NOTE: allowDeletion not propagated!
	        } else if (_typeof(a[prop]) === "object" && a[prop] !== null && _Object$getPrototypeOf(a[prop]) === Object.prototype) {
	          deepExtend(a[prop], b[prop], protoExtend); // NOTE: allowDeletion not propagated!
	        } else {
	          copyOrDelete(a, b, prop, allowDeletion);
	        }
	      } else if (_Array$isArray$1(b[prop])) {
	        var _context6;
	        a[prop] = _sliceInstanceProperty(_context6 = b[prop]).call(_context6);
	      } else {
	        copyOrDelete(a, b, prop, allowDeletion);
	      }
	    }
	  }
	  return a;
	}
	/**
	 * Test whether all elements in two arrays are equal.
	 *
	 * @param a - First array.
	 * @param b - Second array.
	 * @returns True if both arrays have the same length and same elements (1 = '1').
	 */
	function equalArray(a, b) {
	  if (a.length !== b.length) {
	    return false;
	  }
	  for (var i = 0, len = a.length; i < len; i++) {
	    if (a[i] != b[i]) {
	      return false;
	    }
	  }
	  return true;
	}
	/**
	 * Get the type of an object, for example exports.getType([]) returns 'Array'.
	 *
	 * @param object - Input value of unknown type.
	 * @returns Detected type.
	 */
	function getType(object) {
	  var type = _typeof(object);
	  if (type === "object") {
	    if (object === null) {
	      return "null";
	    }
	    if (object instanceof Boolean) {
	      return "Boolean";
	    }
	    if (object instanceof Number) {
	      return "Number";
	    }
	    if (object instanceof String) {
	      return "String";
	    }
	    if (_Array$isArray$1(object)) {
	      return "Array";
	    }
	    if (object instanceof Date) {
	      return "Date";
	    }
	    return "Object";
	  }
	  if (type === "number") {
	    return "Number";
	  }
	  if (type === "boolean") {
	    return "Boolean";
	  }
	  if (type === "string") {
	    return "String";
	  }
	  if (type === undefined) {
	    return "undefined";
	  }
	  return type;
	}
	/**
	 * Used to extend an array and copy it. This is used to propagate paths recursively.
	 *
	 * @param arr - First part.
	 * @param newValue - The value to be aadded into the array.
	 * @returns A new array with all items from arr and newValue (which is last).
	 */
	function copyAndExtendArray(arr, newValue) {
	  var _context7;
	  return _concatInstanceProperty(_context7 = []).call(_context7, _toConsumableArray(arr), [newValue]);
	}
	/**
	 * Used to extend an array and copy it. This is used to propagate paths recursively.
	 *
	 * @param arr - The array to be copied.
	 * @returns Shallow copy of arr.
	 */
	function copyArray(arr) {
	  return _sliceInstanceProperty(arr).call(arr);
	}
	/**
	 * Retrieve the absolute left value of a DOM element.
	 *
	 * @param elem - A dom element, for example a div.
	 * @returns The absolute left position of this element in the browser page.
	 */
	function getAbsoluteLeft(elem) {
	  return elem.getBoundingClientRect().left;
	}
	/**
	 * Retrieve the absolute right value of a DOM element.
	 *
	 * @param elem - A dom element, for example a div.
	 * @returns The absolute right position of this element in the browser page.
	 */
	function getAbsoluteRight(elem) {
	  return elem.getBoundingClientRect().right;
	}
	/**
	 * Retrieve the absolute top value of a DOM element.
	 *
	 * @param elem - A dom element, for example a div.
	 * @returns The absolute top position of this element in the browser page.
	 */
	function getAbsoluteTop(elem) {
	  return elem.getBoundingClientRect().top;
	}
	/**
	 * Add a className to the given elements style.
	 *
	 * @param elem - The element to which the classes will be added.
	 * @param classNames - Space separated list of classes.
	 */
	function addClassName(elem, classNames) {
	  var classes = elem.className.split(" ");
	  var newClasses = classNames.split(" ");
	  classes = _concatInstanceProperty(classes).call(classes, _filterInstanceProperty(newClasses).call(newClasses, function (className) {
	    return !_includesInstanceProperty(classes).call(classes, className);
	  }));
	  elem.className = classes.join(" ");
	}
	/**
	 * Remove a className from the given elements style.
	 *
	 * @param elem - The element from which the classes will be removed.
	 * @param classNames - Space separated list of classes.
	 */
	function removeClassName(elem, classNames) {
	  var classes = elem.className.split(" ");
	  var oldClasses = classNames.split(" ");
	  classes = _filterInstanceProperty(classes).call(classes, function (className) {
	    return !_includesInstanceProperty(oldClasses).call(oldClasses, className);
	  });
	  elem.className = classes.join(" ");
	}
	/**
	 * For each method for both arrays and objects.
	 * In case of an array, the built-in Array.forEach() is applied (**No, it's not!**).
	 * In case of an Object, the method loops over all properties of the object.
	 *
	 * @param object - An Object or Array to be iterated over.
	 * @param callback - Array.forEach-like callback.
	 */
	function forEach$1(object, callback) {
	  if (_Array$isArray$1(object)) {
	    // array
	    var len = object.length;
	    for (var i = 0; i < len; i++) {
	      callback(object[i], i, object);
	    }
	  } else {
	    // object
	    for (var key in object) {
	      if (Object.prototype.hasOwnProperty.call(object, key)) {
	        callback(object[key], key, object);
	      }
	    }
	  }
	}
	/**
	 * Convert an object into an array: all objects properties are put into the array. The resulting array is unordered.
	 *
	 * @param o - Object that contains the properties and methods.
	 * @returns An array of unordered values.
	 */
	var toArray = _Object$values2;
	/**
	 * Update a property in an object.
	 *
	 * @param object - The object whose property will be updated.
	 * @param key - Name of the property to be updated.
	 * @param value - The new value to be assigned.
	 * @returns Whether the value was updated (true) or already strictly the same in the original object (false).
	 */
	function updateProperty(object, key, value) {
	  if (object[key] !== value) {
	    object[key] = value;
	    return true;
	  } else {
	    return false;
	  }
	}
	/**
	 * Throttle the given function to be only executed once per animation frame.
	 *
	 * @param fn - The original function.
	 * @returns The throttled function.
	 */
	function throttle(fn) {
	  var scheduled = false;
	  return function () {
	    if (!scheduled) {
	      scheduled = true;
	      requestAnimationFrame(function () {
	        scheduled = false;
	        fn();
	      });
	    }
	  };
	}
	/**
	 * Add and event listener. Works for all browsers.
	 *
	 * @param element - The element to bind the event listener to.
	 * @param action - Same as Element.addEventListener(action, —, —).
	 * @param listener - Same as Element.addEventListener(—, listener, —).
	 * @param useCapture - Same as Element.addEventListener(—, —, useCapture).
	 */
	function addEventListener(element, action, listener, useCapture) {
	  if (element.addEventListener) {
	    var _context8;
	    if (useCapture === undefined) {
	      useCapture = false;
	    }
	    if (action === "mousewheel" && _includesInstanceProperty(_context8 = navigator.userAgent).call(_context8, "Firefox")) {
	      action = "DOMMouseScroll"; // For Firefox
	    }

	    element.addEventListener(action, listener, useCapture);
	  } else {
	    // @TODO: IE types? Does anyone care?
	    element.attachEvent("on" + action, listener); // IE browsers
	  }
	}
	/**
	 * Remove an event listener from an element.
	 *
	 * @param element - The element to bind the event listener to.
	 * @param action - Same as Element.removeEventListener(action, —, —).
	 * @param listener - Same as Element.removeEventListener(—, listener, —).
	 * @param useCapture - Same as Element.removeEventListener(—, —, useCapture).
	 */
	function removeEventListener(element, action, listener, useCapture) {
	  if (element.removeEventListener) {
	    var _context9;
	    // non-IE browsers
	    if (useCapture === undefined) {
	      useCapture = false;
	    }
	    if (action === "mousewheel" && _includesInstanceProperty(_context9 = navigator.userAgent).call(_context9, "Firefox")) {
	      action = "DOMMouseScroll"; // For Firefox
	    }

	    element.removeEventListener(action, listener, useCapture);
	  } else {
	    // @TODO: IE types? Does anyone care?
	    element.detachEvent("on" + action, listener); // IE browsers
	  }
	}
	/**
	 * Cancels the event's default action if it is cancelable, without stopping further propagation of the event.
	 *
	 * @param event - The event whose default action should be prevented.
	 */
	function preventDefault(event) {
	  if (!event) {
	    event = window.event;
	  }
	  if (!event) ;else if (event.preventDefault) {
	    event.preventDefault(); // non-IE browsers
	  } else {
	    // @TODO: IE types? Does anyone care?
	    event.returnValue = false; // IE browsers
	  }
	}
	/**
	 * Get HTML element which is the target of the event.
	 *
	 * @param event - The event.
	 * @returns The element or null if not obtainable.
	 */
	function getTarget() {
	  var event = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window.event;
	  // code from http://www.quirksmode.org/js/events_properties.html
	  // @TODO: EventTarget can be almost anything, is it okay to return only Elements?
	  var target = null;
	  if (!event) ;else if (event.target) {
	    target = event.target;
	  } else if (event.srcElement) {
	    target = event.srcElement;
	  }
	  if (!(target instanceof Element)) {
	    return null;
	  }
	  if (target.nodeType != null && target.nodeType == 3) {
	    // defeat Safari bug
	    target = target.parentNode;
	    if (!(target instanceof Element)) {
	      return null;
	    }
	  }
	  return target;
	}
	/**
	 * Check if given element contains given parent somewhere in the DOM tree.
	 *
	 * @param element - The element to be tested.
	 * @param parent - The ancestor (not necessarily parent) of the element.
	 * @returns True if parent is an ancestor of the element, false otherwise.
	 */
	function hasParent(element, parent) {
	  var elem = element;
	  while (elem) {
	    if (elem === parent) {
	      return true;
	    } else if (elem.parentNode) {
	      elem = elem.parentNode;
	    } else {
	      return false;
	    }
	  }
	  return false;
	}
	var option = {
	  /**
	   * Convert a value into a boolean.
	   *
	   * @param value - Value to be converted intoboolean, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns Corresponding boolean value, if none then the default value, if none then null.
	   */
	  asBoolean: function asBoolean(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }
	    if (value != null) {
	      return value != false;
	    }
	    return defaultValue || null;
	  },
	  /**
	   * Convert a value into a number.
	   *
	   * @param value - Value to be converted intonumber, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns Corresponding **boxed** number value, if none then the default value, if none then null.
	   */
	  asNumber: function asNumber(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }
	    if (value != null) {
	      return Number(value) || defaultValue || null;
	    }
	    return defaultValue || null;
	  },
	  /**
	   * Convert a value into a string.
	   *
	   * @param value - Value to be converted intostring, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns Corresponding **boxed** string value, if none then the default value, if none then null.
	   */
	  asString: function asString(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }
	    if (value != null) {
	      return String(value);
	    }
	    return defaultValue || null;
	  },
	  /**
	   * Convert a value into a size.
	   *
	   * @param value - Value to be converted intosize, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns Corresponding string value (number + 'px'), if none then the default value, if none then null.
	   */
	  asSize: function asSize(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }
	    if (isString(value)) {
	      return value;
	    } else if (isNumber(value)) {
	      return value + "px";
	    } else {
	      return defaultValue || null;
	    }
	  },
	  /**
	   * Convert a value into a DOM Element.
	   *
	   * @param value - Value to be converted into DOM Element, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   * @returns The DOM Element, if none then the default value, if none then null.
	   */
	  asElement: function asElement(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }
	    return value || defaultValue || null;
	  }
	};
	/**
	 * Convert hex color string into RGB color object.
	 *
	 * @remarks
	 * {@link http://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb}
	 * @param hex - Hex color string (3 or 6 digits, with or without #).
	 * @returns RGB color object.
	 */
	function hexToRGB(hex) {
	  var result;
	  switch (hex.length) {
	    case 3:
	    case 4:
	      result = shortHexRE.exec(hex);
	      return result ? {
	        r: _parseInt(result[1] + result[1], 16),
	        g: _parseInt(result[2] + result[2], 16),
	        b: _parseInt(result[3] + result[3], 16)
	      } : null;
	    case 6:
	    case 7:
	      result = fullHexRE.exec(hex);
	      return result ? {
	        r: _parseInt(result[1], 16),
	        g: _parseInt(result[2], 16),
	        b: _parseInt(result[3], 16)
	      } : null;
	    default:
	      return null;
	  }
	}
	/**
	 * This function takes string color in hex or RGB format and adds the opacity, RGBA is passed through unchanged.
	 *
	 * @param color - The color string (hex, RGB, RGBA).
	 * @param opacity - The new opacity.
	 * @returns RGBA string, for example 'rgba(255, 0, 127, 0.3)'.
	 */
	function overrideOpacity(color, opacity) {
	  if (_includesInstanceProperty(color).call(color, "rgba")) {
	    return color;
	  } else if (_includesInstanceProperty(color).call(color, "rgb")) {
	    var rgb = color.substr(_indexOfInstanceProperty(color).call(color, "(") + 1).replace(")", "").split(",");
	    return "rgba(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + "," + opacity + ")";
	  } else {
	    var _rgb = hexToRGB(color);
	    if (_rgb == null) {
	      return color;
	    } else {
	      return "rgba(" + _rgb.r + "," + _rgb.g + "," + _rgb.b + "," + opacity + ")";
	    }
	  }
	}
	/**
	 * Convert RGB \<0, 255\> into hex color string.
	 *
	 * @param red - Red channel.
	 * @param green - Green channel.
	 * @param blue - Blue channel.
	 * @returns Hex color string (for example: '#0acdc0').
	 */
	function RGBToHex(red, green, blue) {
	  var _context10;
	  return "#" + _sliceInstanceProperty(_context10 = ((1 << 24) + (red << 16) + (green << 8) + blue).toString(16)).call(_context10, 1);
	}
	/**
	 * Parse a color property into an object with border, background, and highlight colors.
	 *
	 * @param inputColor - Shorthand color string or input color object.
	 * @param defaultColor - Full color object to fill in missing values in inputColor.
	 * @returns Color object.
	 */
	function parseColor(inputColor, defaultColor) {
	  if (isString(inputColor)) {
	    var colorStr = inputColor;
	    if (isValidRGB(colorStr)) {
	      var _context11;
	      var rgb = _mapInstanceProperty(_context11 = colorStr.substr(4).substr(0, colorStr.length - 5).split(",")).call(_context11, function (value) {
	        return _parseInt(value);
	      });
	      colorStr = RGBToHex(rgb[0], rgb[1], rgb[2]);
	    }
	    if (isValidHex(colorStr) === true) {
	      var hsv = hexToHSV(colorStr);
	      var lighterColorHSV = {
	        h: hsv.h,
	        s: hsv.s * 0.8,
	        v: Math.min(1, hsv.v * 1.02)
	      };
	      var darkerColorHSV = {
	        h: hsv.h,
	        s: Math.min(1, hsv.s * 1.25),
	        v: hsv.v * 0.8
	      };
	      var darkerColorHex = HSVToHex(darkerColorHSV.h, darkerColorHSV.s, darkerColorHSV.v);
	      var lighterColorHex = HSVToHex(lighterColorHSV.h, lighterColorHSV.s, lighterColorHSV.v);
	      return {
	        background: colorStr,
	        border: darkerColorHex,
	        highlight: {
	          background: lighterColorHex,
	          border: darkerColorHex
	        },
	        hover: {
	          background: lighterColorHex,
	          border: darkerColorHex
	        }
	      };
	    } else {
	      return {
	        background: colorStr,
	        border: colorStr,
	        highlight: {
	          background: colorStr,
	          border: colorStr
	        },
	        hover: {
	          background: colorStr,
	          border: colorStr
	        }
	      };
	    }
	  } else {
	    if (defaultColor) {
	      var color = {
	        background: inputColor.background || defaultColor.background,
	        border: inputColor.border || defaultColor.border,
	        highlight: isString(inputColor.highlight) ? {
	          border: inputColor.highlight,
	          background: inputColor.highlight
	        } : {
	          background: inputColor.highlight && inputColor.highlight.background || defaultColor.highlight.background,
	          border: inputColor.highlight && inputColor.highlight.border || defaultColor.highlight.border
	        },
	        hover: isString(inputColor.hover) ? {
	          border: inputColor.hover,
	          background: inputColor.hover
	        } : {
	          border: inputColor.hover && inputColor.hover.border || defaultColor.hover.border,
	          background: inputColor.hover && inputColor.hover.background || defaultColor.hover.background
	        }
	      };
	      return color;
	    } else {
	      var _color = {
	        background: inputColor.background || undefined,
	        border: inputColor.border || undefined,
	        highlight: isString(inputColor.highlight) ? {
	          border: inputColor.highlight,
	          background: inputColor.highlight
	        } : {
	          background: inputColor.highlight && inputColor.highlight.background || undefined,
	          border: inputColor.highlight && inputColor.highlight.border || undefined
	        },
	        hover: isString(inputColor.hover) ? {
	          border: inputColor.hover,
	          background: inputColor.hover
	        } : {
	          border: inputColor.hover && inputColor.hover.border || undefined,
	          background: inputColor.hover && inputColor.hover.background || undefined
	        }
	      };
	      return _color;
	    }
	  }
	}
	/**
	 * Convert RGB \<0, 255\> into HSV object.
	 *
	 * @remarks
	 * {@link http://www.javascripter.net/faq/rgb2hsv.htm}
	 * @param red - Red channel.
	 * @param green - Green channel.
	 * @param blue - Blue channel.
	 * @returns HSV color object.
	 */
	function RGBToHSV(red, green, blue) {
	  red = red / 255;
	  green = green / 255;
	  blue = blue / 255;
	  var minRGB = Math.min(red, Math.min(green, blue));
	  var maxRGB = Math.max(red, Math.max(green, blue));
	  // Black-gray-white
	  if (minRGB === maxRGB) {
	    return {
	      h: 0,
	      s: 0,
	      v: minRGB
	    };
	  }
	  // Colors other than black-gray-white:
	  var d = red === minRGB ? green - blue : blue === minRGB ? red - green : blue - red;
	  var h = red === minRGB ? 3 : blue === minRGB ? 1 : 5;
	  var hue = 60 * (h - d / (maxRGB - minRGB)) / 360;
	  var saturation = (maxRGB - minRGB) / maxRGB;
	  var value = maxRGB;
	  return {
	    h: hue,
	    s: saturation,
	    v: value
	  };
	}
	var cssUtil = {
	  // split a string with css styles into an object with key/values
	  split: function split(cssText) {
	    var _context12;
	    var styles = {};
	    _forEachInstanceProperty(_context12 = cssText.split(";")).call(_context12, function (style) {
	      if (_trimInstanceProperty(style).call(style) != "") {
	        var _context13, _context14;
	        var parts = style.split(":");
	        var key = _trimInstanceProperty(_context13 = parts[0]).call(_context13);
	        var value = _trimInstanceProperty(_context14 = parts[1]).call(_context14);
	        styles[key] = value;
	      }
	    });
	    return styles;
	  },
	  // build a css text string from an object with key/values
	  join: function join(styles) {
	    var _context15;
	    return _mapInstanceProperty(_context15 = _Object$keys(styles)).call(_context15, function (key) {
	      return key + ": " + styles[key];
	    }).join("; ");
	  }
	};
	/**
	 * Append a string with css styles to an element.
	 *
	 * @param element - The element that will receive new styles.
	 * @param cssText - The styles to be appended.
	 */
	function addCssText(element, cssText) {
	  var currentStyles = cssUtil.split(element.style.cssText);
	  var newStyles = cssUtil.split(cssText);
	  var styles = _objectSpread$1(_objectSpread$1({}, currentStyles), newStyles);
	  element.style.cssText = cssUtil.join(styles);
	}
	/**
	 * Remove a string with css styles from an element.
	 *
	 * @param element - The element from which styles should be removed.
	 * @param cssText - The styles to be removed.
	 */
	function removeCssText(element, cssText) {
	  var styles = cssUtil.split(element.style.cssText);
	  var removeStyles = cssUtil.split(cssText);
	  for (var key in removeStyles) {
	    if (Object.prototype.hasOwnProperty.call(removeStyles, key)) {
	      delete styles[key];
	    }
	  }
	  element.style.cssText = cssUtil.join(styles);
	}
	/**
	 * Convert HSV \<0, 1\> into RGB color object.
	 *
	 * @remarks
	 * {@link https://gist.github.com/mjijackson/5311256}
	 * @param h - Hue.
	 * @param s - Saturation.
	 * @param v - Value.
	 * @returns RGB color object.
	 */
	function HSVToRGB(h, s, v) {
	  var r;
	  var g;
	  var b;
	  var i = Math.floor(h * 6);
	  var f = h * 6 - i;
	  var p = v * (1 - s);
	  var q = v * (1 - f * s);
	  var t = v * (1 - (1 - f) * s);
	  switch (i % 6) {
	    case 0:
	      r = v, g = t, b = p;
	      break;
	    case 1:
	      r = q, g = v, b = p;
	      break;
	    case 2:
	      r = p, g = v, b = t;
	      break;
	    case 3:
	      r = p, g = q, b = v;
	      break;
	    case 4:
	      r = t, g = p, b = v;
	      break;
	    case 5:
	      r = v, g = p, b = q;
	      break;
	  }
	  return {
	    r: Math.floor(r * 255),
	    g: Math.floor(g * 255),
	    b: Math.floor(b * 255)
	  };
	}
	/**
	 * Convert HSV \<0, 1\> into hex color string.
	 *
	 * @param h - Hue.
	 * @param s - Saturation.
	 * @param v - Value.
	 * @returns Hex color string.
	 */
	function HSVToHex(h, s, v) {
	  var rgb = HSVToRGB(h, s, v);
	  return RGBToHex(rgb.r, rgb.g, rgb.b);
	}
	/**
	 * Convert hex color string into HSV \<0, 1\>.
	 *
	 * @param hex - Hex color string.
	 * @returns HSV color object.
	 */
	function hexToHSV(hex) {
	  var rgb = hexToRGB(hex);
	  if (!rgb) {
	    throw new TypeError("'".concat(hex, "' is not a valid color."));
	  }
	  return RGBToHSV(rgb.r, rgb.g, rgb.b);
	}
	/**
	 * Validate hex color string.
	 *
	 * @param hex - Unknown string that may contain a color.
	 * @returns True if the string is valid, false otherwise.
	 */
	function isValidHex(hex) {
	  var isOk = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex);
	  return isOk;
	}
	/**
	 * Validate RGB color string.
	 *
	 * @param rgb - Unknown string that may contain a color.
	 * @returns True if the string is valid, false otherwise.
	 */
	function isValidRGB(rgb) {
	  return rgbRE.test(rgb);
	}
	/**
	 * Validate RGBA color string.
	 *
	 * @param rgba - Unknown string that may contain a color.
	 * @returns True if the string is valid, false otherwise.
	 */
	function isValidRGBA(rgba) {
	  return rgbaRE.test(rgba);
	}
	/**
	 * This recursively redirects the prototype of JSON objects to the referenceObject.
	 * This is used for default options.
	 *
	 * @param fields - Names of properties to be bridged.
	 * @param referenceObject - The original object.
	 * @returns A new object inheriting from the referenceObject.
	 */
	function selectiveBridgeObject(fields, referenceObject) {
	  if (referenceObject !== null && _typeof(referenceObject) === "object") {
	    // !!! typeof null === 'object'
	    var objectTo = _Object$create(referenceObject);
	    for (var i = 0; i < fields.length; i++) {
	      if (Object.prototype.hasOwnProperty.call(referenceObject, fields[i])) {
	        if (_typeof(referenceObject[fields[i]]) == "object") {
	          objectTo[fields[i]] = bridgeObject(referenceObject[fields[i]]);
	        }
	      }
	    }
	    return objectTo;
	  } else {
	    return null;
	  }
	}
	/**
	 * This recursively redirects the prototype of JSON objects to the referenceObject.
	 * This is used for default options.
	 *
	 * @param referenceObject - The original object.
	 * @returns The Element if the referenceObject is an Element, or a new object inheriting from the referenceObject.
	 */
	function bridgeObject(referenceObject) {
	  if (referenceObject === null || _typeof(referenceObject) !== "object") {
	    return null;
	  }
	  if (referenceObject instanceof Element) {
	    // Avoid bridging DOM objects
	    return referenceObject;
	  }
	  var objectTo = _Object$create(referenceObject);
	  for (var i in referenceObject) {
	    if (Object.prototype.hasOwnProperty.call(referenceObject, i)) {
	      if (_typeof(referenceObject[i]) == "object") {
	        objectTo[i] = bridgeObject(referenceObject[i]);
	      }
	    }
	  }
	  return objectTo;
	}
	/**
	 * This method provides a stable sort implementation, very fast for presorted data.
	 *
	 * @param a - The array to be sorted (in-place).
	 * @param compare - An order comparator.
	 * @returns The argument a.
	 */
	function insertSort(a, compare) {
	  for (var i = 0; i < a.length; i++) {
	    var k = a[i];
	    var j = void 0;
	    for (j = i; j > 0 && compare(k, a[j - 1]) < 0; j--) {
	      a[j] = a[j - 1];
	    }
	    a[j] = k;
	  }
	  return a;
	}
	/**
	 * This is used to set the options of subobjects in the options object.
	 *
	 * A requirement of these subobjects is that they have an 'enabled' element
	 * which is optional for the user but mandatory for the program.
	 *
	 * The added value here of the merge is that option 'enabled' is set as required.
	 *
	 * @param mergeTarget - Either this.options or the options used for the groups.
	 * @param options - Options.
	 * @param option - Option key in the options argument.
	 * @param globalOptions - Global options, passed in to determine value of option 'enabled'.
	 */
	function mergeOptions(mergeTarget, options, option) {
	  var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
	  // Local helpers
	  var isPresent = function isPresent(obj) {
	    return obj !== null && obj !== undefined;
	  };
	  var isObject = function isObject(obj) {
	    return obj !== null && _typeof(obj) === "object";
	  };
	  // https://stackoverflow.com/a/34491287/1223531
	  var isEmpty = function isEmpty(obj) {
	    for (var x in obj) {
	      if (Object.prototype.hasOwnProperty.call(obj, x)) {
	        return false;
	      }
	    }
	    return true;
	  };
	  // Guards
	  if (!isObject(mergeTarget)) {
	    throw new Error("Parameter mergeTarget must be an object");
	  }
	  if (!isObject(options)) {
	    throw new Error("Parameter options must be an object");
	  }
	  if (!isPresent(option)) {
	    throw new Error("Parameter option must have a value");
	  }
	  if (!isObject(globalOptions)) {
	    throw new Error("Parameter globalOptions must be an object");
	  }
	  //
	  // Actual merge routine, separated from main logic
	  // Only a single level of options is merged. Deeper levels are ref'd. This may actually be an issue.
	  //
	  var doMerge = function doMerge(target, options, option) {
	    if (!isObject(target[option])) {
	      target[option] = {};
	    }
	    var src = options[option];
	    var dst = target[option];
	    for (var prop in src) {
	      if (Object.prototype.hasOwnProperty.call(src, prop)) {
	        dst[prop] = src[prop];
	      }
	    }
	  };
	  // Local initialization
	  var srcOption = options[option];
	  var globalPassed = isObject(globalOptions) && !isEmpty(globalOptions);
	  var globalOption = globalPassed ? globalOptions[option] : undefined;
	  var globalEnabled = globalOption ? globalOption.enabled : undefined;
	  /////////////////////////////////////////
	  // Main routine
	  /////////////////////////////////////////
	  if (srcOption === undefined) {
	    return; // Nothing to do
	  }

	  if (typeof srcOption === "boolean") {
	    if (!isObject(mergeTarget[option])) {
	      mergeTarget[option] = {};
	    }
	    mergeTarget[option].enabled = srcOption;
	    return;
	  }
	  if (srcOption === null && !isObject(mergeTarget[option])) {
	    // If possible, explicit copy from globals
	    if (isPresent(globalOption)) {
	      mergeTarget[option] = _Object$create(globalOption);
	    } else {
	      return; // Nothing to do
	    }
	  }

	  if (!isObject(srcOption)) {
	    return;
	  }
	  //
	  // Ensure that 'enabled' is properly set. It is required internally
	  // Note that the value from options will always overwrite the existing value
	  //
	  var enabled = true; // default value
	  if (srcOption.enabled !== undefined) {
	    enabled = srcOption.enabled;
	  } else {
	    // Take from globals, if present
	    if (globalEnabled !== undefined) {
	      enabled = globalOption.enabled;
	    }
	  }
	  doMerge(mergeTarget, options, option);
	  mergeTarget[option].enabled = enabled;
	}
	/**
	 * This function does a binary search for a visible item in a sorted list. If we find a visible item, the code that uses
	 * this function will then iterate in both directions over this sorted list to find all visible items.
	 *
	 * @param orderedItems - Items ordered by start.
	 * @param comparator - -1 is lower, 0 is equal, 1 is higher.
	 * @param field - Property name on an item (That is item[field]).
	 * @param field2 - Second property name on an item (That is item[field][field2]).
	 * @returns Index of the found item or -1 if nothing was found.
	 */
	function binarySearchCustom(orderedItems, comparator, field, field2) {
	  var maxIterations = 10000;
	  var iteration = 0;
	  var low = 0;
	  var high = orderedItems.length - 1;
	  while (low <= high && iteration < maxIterations) {
	    var middle = Math.floor((low + high) / 2);
	    var item = orderedItems[middle];
	    var value = field2 === undefined ? item[field] : item[field][field2];
	    var searchResult = comparator(value);
	    if (searchResult == 0) {
	      // jihaa, found a visible item!
	      return middle;
	    } else if (searchResult == -1) {
	      // it is too small --> increase low
	      low = middle + 1;
	    } else {
	      // it is too big --> decrease high
	      high = middle - 1;
	    }
	    iteration++;
	  }
	  return -1;
	}
	/**
	 * This function does a binary search for a specific value in a sorted array.
	 * If it does not exist but is in between of two values, we return either the
	 * one before or the one after, depending on user input If it is found, we
	 * return the index, else -1.
	 *
	 * @param orderedItems - Sorted array.
	 * @param target - The searched value.
	 * @param field - Name of the property in items to be searched.
	 * @param sidePreference - If the target is between two values, should the index of the before or the after be returned?
	 * @param comparator - An optional comparator, returning -1, 0, 1 for \<, ===, \>.
	 * @returns The index of found value or -1 if nothing was found.
	 */
	function binarySearchValue(orderedItems, target, field, sidePreference, comparator) {
	  var maxIterations = 10000;
	  var iteration = 0;
	  var low = 0;
	  var high = orderedItems.length - 1;
	  var prevValue;
	  var value;
	  var nextValue;
	  var middle;
	  comparator = comparator != undefined ? comparator : function (a, b) {
	    return a == b ? 0 : a < b ? -1 : 1;
	  };
	  while (low <= high && iteration < maxIterations) {
	    // get a new guess
	    middle = Math.floor(0.5 * (high + low));
	    prevValue = orderedItems[Math.max(0, middle - 1)][field];
	    value = orderedItems[middle][field];
	    nextValue = orderedItems[Math.min(orderedItems.length - 1, middle + 1)][field];
	    if (comparator(value, target) == 0) {
	      // we found the target
	      return middle;
	    } else if (comparator(prevValue, target) < 0 && comparator(value, target) > 0) {
	      // target is in between of the previous and the current
	      return sidePreference == "before" ? Math.max(0, middle - 1) : middle;
	    } else if (comparator(value, target) < 0 && comparator(nextValue, target) > 0) {
	      // target is in between of the current and the next
	      return sidePreference == "before" ? middle : Math.min(orderedItems.length - 1, middle + 1);
	    } else {
	      // didnt find the target, we need to change our boundaries.
	      if (comparator(value, target) < 0) {
	        // it is too small --> increase low
	        low = middle + 1;
	      } else {
	        // it is too big --> decrease high
	        high = middle - 1;
	      }
	    }
	    iteration++;
	  }
	  // didnt find anything. Return -1.
	  return -1;
	}
	/*
	 * Easing Functions.
	 * Only considering the t value for the range [0, 1] => [0, 1].
	 *
	 * Inspiration: from http://gizma.com/easing/
	 * https://gist.github.com/gre/1650294
	 */
	var easingFunctions = {
	  /**
	   * Provides no easing and no acceleration.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  linear: function linear(t) {
	    return t;
	  },
	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInQuad: function easeInQuad(t) {
	    return t * t;
	  },
	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeOutQuad: function easeOutQuad(t) {
	    return t * (2 - t);
	  },
	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInOutQuad: function easeInOutQuad(t) {
	    return t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
	  },
	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInCubic: function easeInCubic(t) {
	    return t * t * t;
	  },
	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeOutCubic: function easeOutCubic(t) {
	    return --t * t * t + 1;
	  },
	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInOutCubic: function easeInOutCubic(t) {
	    return t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
	  },
	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInQuart: function easeInQuart(t) {
	    return t * t * t * t;
	  },
	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeOutQuart: function easeOutQuart(t) {
	    return 1 - --t * t * t * t;
	  },
	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInOutQuart: function easeInOutQuart(t) {
	    return t < 0.5 ? 8 * t * t * t * t : 1 - 8 * --t * t * t * t;
	  },
	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInQuint: function easeInQuint(t) {
	    return t * t * t * t * t;
	  },
	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeOutQuint: function easeOutQuint(t) {
	    return 1 + --t * t * t * t * t;
	  },
	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   * @returns Value at time t.
	   */
	  easeInOutQuint: function easeInOutQuint(t) {
	    return t < 0.5 ? 16 * t * t * t * t * t : 1 + 16 * --t * t * t * t * t;
	  }
	};
	/**
	 * Experimentaly compute the width of the scrollbar for this browser.
	 *
	 * @returns The width in pixels.
	 */
	function getScrollBarWidth() {
	  var inner = document.createElement("p");
	  inner.style.width = "100%";
	  inner.style.height = "200px";
	  var outer = document.createElement("div");
	  outer.style.position = "absolute";
	  outer.style.top = "0px";
	  outer.style.left = "0px";
	  outer.style.visibility = "hidden";
	  outer.style.width = "200px";
	  outer.style.height = "150px";
	  outer.style.overflow = "hidden";
	  outer.appendChild(inner);
	  document.body.appendChild(outer);
	  var w1 = inner.offsetWidth;
	  outer.style.overflow = "scroll";
	  var w2 = inner.offsetWidth;
	  if (w1 == w2) {
	    w2 = outer.clientWidth;
	  }
	  document.body.removeChild(outer);
	  return w1 - w2;
	}
	// @TODO: This doesn't work properly.
	// It works only for single property objects,
	// otherwise it combines all of the types in a union.
	// export function topMost<K1 extends string, V1> (
	//   pile: Record<K1, undefined | V1>[],
	//   accessors: K1 | [K1]
	// ): undefined | V1
	// export function topMost<K1 extends string, K2 extends string, V1, V2> (
	//   pile: Record<K1, undefined | V1 | Record<K2, undefined | V2>>[],
	//   accessors: [K1, K2]
	// ): undefined | V1 | V2
	// export function topMost<K1 extends string, K2 extends string, K3 extends string, V1, V2, V3> (
	//   pile: Record<K1, undefined | V1 | Record<K2, undefined | V2 | Record<K3, undefined | V3>>>[],
	//   accessors: [K1, K2, K3]
	// ): undefined | V1 | V2 | V3
	/**
	 * Get the top most property value from a pile of objects.
	 *
	 * @param pile - Array of objects, no required format.
	 * @param accessors - Array of property names.
	 * For example `object['foo']['bar']` → `['foo', 'bar']`.
	 * @returns Value of the property with given accessors path from the first pile item where it's not undefined.
	 */
	function topMost(pile, accessors) {
	  var candidate;
	  if (!_Array$isArray$1(accessors)) {
	    accessors = [accessors];
	  }
	  var _iterator3 = _createForOfIteratorHelper$6(pile),
	    _step3;
	  try {
	    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
	      var member = _step3.value;
	      if (member) {
	        candidate = member[accessors[0]];
	        for (var i = 1; i < accessors.length; i++) {
	          if (candidate) {
	            candidate = candidate[accessors[i]];
	          }
	        }
	        if (typeof candidate !== "undefined") {
	          break;
	        }
	      }
	    }
	  } catch (err) {
	    _iterator3.e(err);
	  } finally {
	    _iterator3.f();
	  }
	  return candidate;
	}
	var htmlColors$1 = {
	  black: "#000000",
	  navy: "#000080",
	  darkblue: "#00008B",
	  mediumblue: "#0000CD",
	  blue: "#0000FF",
	  darkgreen: "#006400",
	  green: "#008000",
	  teal: "#008080",
	  darkcyan: "#008B8B",
	  deepskyblue: "#00BFFF",
	  darkturquoise: "#00CED1",
	  mediumspringgreen: "#00FA9A",
	  lime: "#00FF00",
	  springgreen: "#00FF7F",
	  aqua: "#00FFFF",
	  cyan: "#00FFFF",
	  midnightblue: "#191970",
	  dodgerblue: "#1E90FF",
	  lightseagreen: "#20B2AA",
	  forestgreen: "#228B22",
	  seagreen: "#2E8B57",
	  darkslategray: "#2F4F4F",
	  limegreen: "#32CD32",
	  mediumseagreen: "#3CB371",
	  turquoise: "#40E0D0",
	  royalblue: "#4169E1",
	  steelblue: "#4682B4",
	  darkslateblue: "#483D8B",
	  mediumturquoise: "#48D1CC",
	  indigo: "#4B0082",
	  darkolivegreen: "#556B2F",
	  cadetblue: "#5F9EA0",
	  cornflowerblue: "#6495ED",
	  mediumaquamarine: "#66CDAA",
	  dimgray: "#696969",
	  slateblue: "#6A5ACD",
	  olivedrab: "#6B8E23",
	  slategray: "#708090",
	  lightslategray: "#778899",
	  mediumslateblue: "#7B68EE",
	  lawngreen: "#7CFC00",
	  chartreuse: "#7FFF00",
	  aquamarine: "#7FFFD4",
	  maroon: "#800000",
	  purple: "#800080",
	  olive: "#808000",
	  gray: "#808080",
	  skyblue: "#87CEEB",
	  lightskyblue: "#87CEFA",
	  blueviolet: "#8A2BE2",
	  darkred: "#8B0000",
	  darkmagenta: "#8B008B",
	  saddlebrown: "#8B4513",
	  darkseagreen: "#8FBC8F",
	  lightgreen: "#90EE90",
	  mediumpurple: "#9370D8",
	  darkviolet: "#9400D3",
	  palegreen: "#98FB98",
	  darkorchid: "#9932CC",
	  yellowgreen: "#9ACD32",
	  sienna: "#A0522D",
	  brown: "#A52A2A",
	  darkgray: "#A9A9A9",
	  lightblue: "#ADD8E6",
	  greenyellow: "#ADFF2F",
	  paleturquoise: "#AFEEEE",
	  lightsteelblue: "#B0C4DE",
	  powderblue: "#B0E0E6",
	  firebrick: "#B22222",
	  darkgoldenrod: "#B8860B",
	  mediumorchid: "#BA55D3",
	  rosybrown: "#BC8F8F",
	  darkkhaki: "#BDB76B",
	  silver: "#C0C0C0",
	  mediumvioletred: "#C71585",
	  indianred: "#CD5C5C",
	  peru: "#CD853F",
	  chocolate: "#D2691E",
	  tan: "#D2B48C",
	  lightgrey: "#D3D3D3",
	  palevioletred: "#D87093",
	  thistle: "#D8BFD8",
	  orchid: "#DA70D6",
	  goldenrod: "#DAA520",
	  crimson: "#DC143C",
	  gainsboro: "#DCDCDC",
	  plum: "#DDA0DD",
	  burlywood: "#DEB887",
	  lightcyan: "#E0FFFF",
	  lavender: "#E6E6FA",
	  darksalmon: "#E9967A",
	  violet: "#EE82EE",
	  palegoldenrod: "#EEE8AA",
	  lightcoral: "#F08080",
	  khaki: "#F0E68C",
	  aliceblue: "#F0F8FF",
	  honeydew: "#F0FFF0",
	  azure: "#F0FFFF",
	  sandybrown: "#F4A460",
	  wheat: "#F5DEB3",
	  beige: "#F5F5DC",
	  whitesmoke: "#F5F5F5",
	  mintcream: "#F5FFFA",
	  ghostwhite: "#F8F8FF",
	  salmon: "#FA8072",
	  antiquewhite: "#FAEBD7",
	  linen: "#FAF0E6",
	  lightgoldenrodyellow: "#FAFAD2",
	  oldlace: "#FDF5E6",
	  red: "#FF0000",
	  fuchsia: "#FF00FF",
	  magenta: "#FF00FF",
	  deeppink: "#FF1493",
	  orangered: "#FF4500",
	  tomato: "#FF6347",
	  hotpink: "#FF69B4",
	  coral: "#FF7F50",
	  darkorange: "#FF8C00",
	  lightsalmon: "#FFA07A",
	  orange: "#FFA500",
	  lightpink: "#FFB6C1",
	  pink: "#FFC0CB",
	  gold: "#FFD700",
	  peachpuff: "#FFDAB9",
	  navajowhite: "#FFDEAD",
	  moccasin: "#FFE4B5",
	  bisque: "#FFE4C4",
	  mistyrose: "#FFE4E1",
	  blanchedalmond: "#FFEBCD",
	  papayawhip: "#FFEFD5",
	  lavenderblush: "#FFF0F5",
	  seashell: "#FFF5EE",
	  cornsilk: "#FFF8DC",
	  lemonchiffon: "#FFFACD",
	  floralwhite: "#FFFAF0",
	  snow: "#FFFAFA",
	  yellow: "#FFFF00",
	  lightyellow: "#FFFFE0",
	  ivory: "#FFFFF0",
	  white: "#FFFFFF"
	};

	/**
	 * @param {number} [pixelRatio=1]
	 */
	var ColorPicker$1 = /*#__PURE__*/function () {
	  /**
	   * @param {number} [pixelRatio=1]
	   */
	  function ColorPicker$1() {
	    var pixelRatio = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
	    _classCallCheck(this, ColorPicker$1);
	    this.pixelRatio = pixelRatio;
	    this.generated = false;
	    this.centerCoordinates = {
	      x: 289 / 2,
	      y: 289 / 2
	    };
	    this.r = 289 * 0.49;
	    this.color = {
	      r: 255,
	      g: 255,
	      b: 255,
	      a: 1.0
	    };
	    this.hueCircle = undefined;
	    this.initialColor = {
	      r: 255,
	      g: 255,
	      b: 255,
	      a: 1.0
	    };
	    this.previousColor = undefined;
	    this.applied = false;

	    // bound by
	    this.updateCallback = function () {};
	    this.closeCallback = function () {};

	    // create all DOM elements
	    this._create();
	  }

	  /**
	   * this inserts the colorPicker into a div from the DOM
	   *
	   * @param {Element} container
	   */
	  _createClass(ColorPicker$1, [{
	    key: "insertTo",
	    value: function insertTo(container) {
	      if (this.hammer !== undefined) {
	        this.hammer.destroy();
	        this.hammer = undefined;
	      }
	      this.container = container;
	      this.container.appendChild(this.frame);
	      this._bindHammer();
	      this._setSize();
	    }

	    /**
	     * the callback is executed on apply and save. Bind it to the application
	     *
	     * @param {Function} callback
	     */
	  }, {
	    key: "setUpdateCallback",
	    value: function setUpdateCallback(callback) {
	      if (typeof callback === "function") {
	        this.updateCallback = callback;
	      } else {
	        throw new Error("Function attempted to set as colorPicker update callback is not a function.");
	      }
	    }

	    /**
	     * the callback is executed on apply and save. Bind it to the application
	     *
	     * @param {Function} callback
	     */
	  }, {
	    key: "setCloseCallback",
	    value: function setCloseCallback(callback) {
	      if (typeof callback === "function") {
	        this.closeCallback = callback;
	      } else {
	        throw new Error("Function attempted to set as colorPicker closing callback is not a function.");
	      }
	    }

	    /**
	     *
	     * @param {string} color
	     * @returns {string}
	     * @private
	     */
	  }, {
	    key: "_isColorString",
	    value: function _isColorString(color) {
	      if (typeof color === "string") {
	        return htmlColors$1[color];
	      }
	    }

	    /**
	     * Set the color of the colorPicker
	     * Supported formats:
	     * 'red'                   --> HTML color string
	     * '#ffffff'               --> hex string
	     * 'rgb(255,255,255)'      --> rgb string
	     * 'rgba(255,255,255,1.0)' --> rgba string
	     * {r:255,g:255,b:255}     --> rgb object
	     * {r:255,g:255,b:255,a:1.0} --> rgba object
	     *
	     * @param {string | object} color
	     * @param {boolean} [setInitial=true]
	     */
	  }, {
	    key: "setColor",
	    value: function setColor(color) {
	      var setInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	      if (color === "none") {
	        return;
	      }
	      var rgba;

	      // if a html color shorthand is used, convert to hex
	      var htmlColor = this._isColorString(color);
	      if (htmlColor !== undefined) {
	        color = htmlColor;
	      }

	      // check format
	      if (isString(color) === true) {
	        if (isValidRGB(color) === true) {
	          var rgbaArray = color.substr(4).substr(0, color.length - 5).split(",");
	          rgba = {
	            r: rgbaArray[0],
	            g: rgbaArray[1],
	            b: rgbaArray[2],
	            a: 1.0
	          };
	        } else if (isValidRGBA(color) === true) {
	          var _rgbaArray = color.substr(5).substr(0, color.length - 6).split(",");
	          rgba = {
	            r: _rgbaArray[0],
	            g: _rgbaArray[1],
	            b: _rgbaArray[2],
	            a: _rgbaArray[3]
	          };
	        } else if (isValidHex(color) === true) {
	          var rgbObj = hexToRGB(color);
	          rgba = {
	            r: rgbObj.r,
	            g: rgbObj.g,
	            b: rgbObj.b,
	            a: 1.0
	          };
	        }
	      } else {
	        if (color instanceof Object) {
	          if (color.r !== undefined && color.g !== undefined && color.b !== undefined) {
	            var alpha = color.a !== undefined ? color.a : "1.0";
	            rgba = {
	              r: color.r,
	              g: color.g,
	              b: color.b,
	              a: alpha
	            };
	          }
	        }
	      }

	      // set color
	      if (rgba === undefined) {
	        throw new Error("Unknown color passed to the colorPicker. Supported are strings: rgb, hex, rgba. Object: rgb ({r:r,g:g,b:b,[a:a]}). Supplied: " + _JSON$stringify(color));
	      } else {
	        this._setColor(rgba, setInitial);
	      }
	    }

	    /**
	     * this shows the color picker.
	     * The hue circle is constructed once and stored.
	     */
	  }, {
	    key: "show",
	    value: function show() {
	      if (this.closeCallback !== undefined) {
	        this.closeCallback();
	        this.closeCallback = undefined;
	      }
	      this.applied = false;
	      this.frame.style.display = "block";
	      this._generateHueCircle();
	    }

	    // ------------------------------------------ PRIVATE ----------------------------- //

	    /**
	     * Hide the picker. Is called by the cancel button.
	     * Optional boolean to store the previous color for easy access later on.
	     *
	     * @param {boolean} [storePrevious=true]
	     * @private
	     */
	  }, {
	    key: "_hide",
	    value: function _hide() {
	      var _this2 = this;
	      var storePrevious = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
	      // store the previous color for next time;
	      if (storePrevious === true) {
	        this.previousColor = _Object$assign({}, this.color);
	      }
	      if (this.applied === true) {
	        this.updateCallback(this.initialColor);
	      }
	      this.frame.style.display = "none";

	      // call the closing callback, restoring the onclick method.
	      // this is in a setTimeout because it will trigger the show again before the click is done.
	      _setTimeout(function () {
	        if (_this2.closeCallback !== undefined) {
	          _this2.closeCallback();
	          _this2.closeCallback = undefined;
	        }
	      }, 0);
	    }

	    /**
	     * bound to the save button. Saves and hides.
	     *
	     * @private
	     */
	  }, {
	    key: "_save",
	    value: function _save() {
	      this.updateCallback(this.color);
	      this.applied = false;
	      this._hide();
	    }

	    /**
	     * Bound to apply button. Saves but does not close. Is undone by the cancel button.
	     *
	     * @private
	     */
	  }, {
	    key: "_apply",
	    value: function _apply() {
	      this.applied = true;
	      this.updateCallback(this.color);
	      this._updatePicker(this.color);
	    }

	    /**
	     * load the color from the previous session.
	     *
	     * @private
	     */
	  }, {
	    key: "_loadLast",
	    value: function _loadLast() {
	      if (this.previousColor !== undefined) {
	        this.setColor(this.previousColor, false);
	      } else {
	        alert("There is no last color to load...");
	      }
	    }

	    /**
	     * set the color, place the picker
	     *
	     * @param {object} rgba
	     * @param {boolean} [setInitial=true]
	     * @private
	     */
	  }, {
	    key: "_setColor",
	    value: function _setColor(rgba) {
	      var setInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	      // store the initial color
	      if (setInitial === true) {
	        this.initialColor = _Object$assign({}, rgba);
	      }
	      this.color = rgba;
	      var hsv = RGBToHSV(rgba.r, rgba.g, rgba.b);
	      var angleConvert = 2 * Math.PI;
	      var radius = this.r * hsv.s;
	      var x = this.centerCoordinates.x + radius * Math.sin(angleConvert * hsv.h);
	      var y = this.centerCoordinates.y + radius * Math.cos(angleConvert * hsv.h);
	      this.colorPickerSelector.style.left = x - 0.5 * this.colorPickerSelector.clientWidth + "px";
	      this.colorPickerSelector.style.top = y - 0.5 * this.colorPickerSelector.clientHeight + "px";
	      this._updatePicker(rgba);
	    }

	    /**
	     * bound to opacity control
	     *
	     * @param {number} value
	     * @private
	     */
	  }, {
	    key: "_setOpacity",
	    value: function _setOpacity(value) {
	      this.color.a = value / 100;
	      this._updatePicker(this.color);
	    }

	    /**
	     * bound to brightness control
	     *
	     * @param {number} value
	     * @private
	     */
	  }, {
	    key: "_setBrightness",
	    value: function _setBrightness(value) {
	      var hsv = RGBToHSV(this.color.r, this.color.g, this.color.b);
	      hsv.v = value / 100;
	      var rgba = HSVToRGB(hsv.h, hsv.s, hsv.v);
	      rgba["a"] = this.color.a;
	      this.color = rgba;
	      this._updatePicker();
	    }

	    /**
	     * update the color picker. A black circle overlays the hue circle to mimic the brightness decreasing.
	     *
	     * @param {object} rgba
	     * @private
	     */
	  }, {
	    key: "_updatePicker",
	    value: function _updatePicker() {
	      var rgba = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.color;
	      var hsv = RGBToHSV(rgba.r, rgba.g, rgba.b);
	      var ctx = this.colorPickerCanvas.getContext("2d");
	      if (this.pixelRation === undefined) {
	        this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
	      }
	      ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);

	      // clear the canvas
	      var w = this.colorPickerCanvas.clientWidth;
	      var h = this.colorPickerCanvas.clientHeight;
	      ctx.clearRect(0, 0, w, h);
	      ctx.putImageData(this.hueCircle, 0, 0);
	      ctx.fillStyle = "rgba(0,0,0," + (1 - hsv.v) + ")";
	      ctx.circle(this.centerCoordinates.x, this.centerCoordinates.y, this.r);
	      _fillInstanceProperty(ctx).call(ctx);
	      this.brightnessRange.value = 100 * hsv.v;
	      this.opacityRange.value = 100 * rgba.a;
	      this.initialColorDiv.style.backgroundColor = "rgba(" + this.initialColor.r + "," + this.initialColor.g + "," + this.initialColor.b + "," + this.initialColor.a + ")";
	      this.newColorDiv.style.backgroundColor = "rgba(" + this.color.r + "," + this.color.g + "," + this.color.b + "," + this.color.a + ")";
	    }

	    /**
	     * used by create to set the size of the canvas.
	     *
	     * @private
	     */
	  }, {
	    key: "_setSize",
	    value: function _setSize() {
	      this.colorPickerCanvas.style.width = "100%";
	      this.colorPickerCanvas.style.height = "100%";
	      this.colorPickerCanvas.width = 289 * this.pixelRatio;
	      this.colorPickerCanvas.height = 289 * this.pixelRatio;
	    }

	    /**
	     * create all dom elements
	     * TODO: cleanup, lots of similar dom elements
	     *
	     * @private
	     */
	  }, {
	    key: "_create",
	    value: function _create() {
	      var _context16, _context17, _context18, _context19;
	      this.frame = document.createElement("div");
	      this.frame.className = "vis-color-picker";
	      this.colorPickerDiv = document.createElement("div");
	      this.colorPickerSelector = document.createElement("div");
	      this.colorPickerSelector.className = "vis-selector";
	      this.colorPickerDiv.appendChild(this.colorPickerSelector);
	      this.colorPickerCanvas = document.createElement("canvas");
	      this.colorPickerDiv.appendChild(this.colorPickerCanvas);
	      if (!this.colorPickerCanvas.getContext) {
	        var noCanvas = document.createElement("DIV");
	        noCanvas.style.color = "red";
	        noCanvas.style.fontWeight = "bold";
	        noCanvas.style.padding = "10px";
	        noCanvas.innerText = "Error: your browser does not support HTML canvas";
	        this.colorPickerCanvas.appendChild(noCanvas);
	      } else {
	        var ctx = this.colorPickerCanvas.getContext("2d");
	        this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
	        this.colorPickerCanvas.getContext("2d").setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);
	      }
	      this.colorPickerDiv.className = "vis-color";
	      this.opacityDiv = document.createElement("div");
	      this.opacityDiv.className = "vis-opacity";
	      this.brightnessDiv = document.createElement("div");
	      this.brightnessDiv.className = "vis-brightness";
	      this.arrowDiv = document.createElement("div");
	      this.arrowDiv.className = "vis-arrow";
	      this.opacityRange = document.createElement("input");
	      try {
	        this.opacityRange.type = "range"; // Not supported on IE9
	        this.opacityRange.min = "0";
	        this.opacityRange.max = "100";
	      } catch (err) {
	        // TODO: Add some error handling.
	      }
	      this.opacityRange.value = "100";
	      this.opacityRange.className = "vis-range";
	      this.brightnessRange = document.createElement("input");
	      try {
	        this.brightnessRange.type = "range"; // Not supported on IE9
	        this.brightnessRange.min = "0";
	        this.brightnessRange.max = "100";
	      } catch (err) {
	        // TODO: Add some error handling.
	      }
	      this.brightnessRange.value = "100";
	      this.brightnessRange.className = "vis-range";
	      this.opacityDiv.appendChild(this.opacityRange);
	      this.brightnessDiv.appendChild(this.brightnessRange);
	      var me = this;
	      this.opacityRange.onchange = function () {
	        me._setOpacity(this.value);
	      };
	      this.opacityRange.oninput = function () {
	        me._setOpacity(this.value);
	      };
	      this.brightnessRange.onchange = function () {
	        me._setBrightness(this.value);
	      };
	      this.brightnessRange.oninput = function () {
	        me._setBrightness(this.value);
	      };
	      this.brightnessLabel = document.createElement("div");
	      this.brightnessLabel.className = "vis-label vis-brightness";
	      this.brightnessLabel.innerText = "brightness:";
	      this.opacityLabel = document.createElement("div");
	      this.opacityLabel.className = "vis-label vis-opacity";
	      this.opacityLabel.innerText = "opacity:";
	      this.newColorDiv = document.createElement("div");
	      this.newColorDiv.className = "vis-new-color";
	      this.newColorDiv.innerText = "new";
	      this.initialColorDiv = document.createElement("div");
	      this.initialColorDiv.className = "vis-initial-color";
	      this.initialColorDiv.innerText = "initial";
	      this.cancelButton = document.createElement("div");
	      this.cancelButton.className = "vis-button vis-cancel";
	      this.cancelButton.innerText = "cancel";
	      this.cancelButton.onclick = _bindInstanceProperty(_context16 = this._hide).call(_context16, this, false);
	      this.applyButton = document.createElement("div");
	      this.applyButton.className = "vis-button vis-apply";
	      this.applyButton.innerText = "apply";
	      this.applyButton.onclick = _bindInstanceProperty(_context17 = this._apply).call(_context17, this);
	      this.saveButton = document.createElement("div");
	      this.saveButton.className = "vis-button vis-save";
	      this.saveButton.innerText = "save";
	      this.saveButton.onclick = _bindInstanceProperty(_context18 = this._save).call(_context18, this);
	      this.loadButton = document.createElement("div");
	      this.loadButton.className = "vis-button vis-load";
	      this.loadButton.innerText = "load last";
	      this.loadButton.onclick = _bindInstanceProperty(_context19 = this._loadLast).call(_context19, this);
	      this.frame.appendChild(this.colorPickerDiv);
	      this.frame.appendChild(this.arrowDiv);
	      this.frame.appendChild(this.brightnessLabel);
	      this.frame.appendChild(this.brightnessDiv);
	      this.frame.appendChild(this.opacityLabel);
	      this.frame.appendChild(this.opacityDiv);
	      this.frame.appendChild(this.newColorDiv);
	      this.frame.appendChild(this.initialColorDiv);
	      this.frame.appendChild(this.cancelButton);
	      this.frame.appendChild(this.applyButton);
	      this.frame.appendChild(this.saveButton);
	      this.frame.appendChild(this.loadButton);
	    }

	    /**
	     * bind hammer to the color picker
	     *
	     * @private
	     */
	  }, {
	    key: "_bindHammer",
	    value: function _bindHammer() {
	      var _this3 = this;
	      this.drag = {};
	      this.pinch = {};
	      this.hammer = new Hammer$1(this.colorPickerCanvas);
	      this.hammer.get("pinch").set({
	        enable: true
	      });
	      this.hammer.on("hammer.input", function (event) {
	        if (event.isFirst) {
	          _this3._moveSelector(event);
	        }
	      });
	      this.hammer.on("tap", function (event) {
	        _this3._moveSelector(event);
	      });
	      this.hammer.on("panstart", function (event) {
	        _this3._moveSelector(event);
	      });
	      this.hammer.on("panmove", function (event) {
	        _this3._moveSelector(event);
	      });
	      this.hammer.on("panend", function (event) {
	        _this3._moveSelector(event);
	      });
	    }

	    /**
	     * generate the hue circle. This is relatively heavy (200ms) and is done only once on the first time it is shown.
	     *
	     * @private
	     */
	  }, {
	    key: "_generateHueCircle",
	    value: function _generateHueCircle() {
	      if (this.generated === false) {
	        var ctx = this.colorPickerCanvas.getContext("2d");
	        if (this.pixelRation === undefined) {
	          this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
	        }
	        ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);

	        // clear the canvas
	        var w = this.colorPickerCanvas.clientWidth;
	        var h = this.colorPickerCanvas.clientHeight;
	        ctx.clearRect(0, 0, w, h);

	        // draw hue circle
	        var x, y, hue, sat;
	        this.centerCoordinates = {
	          x: w * 0.5,
	          y: h * 0.5
	        };
	        this.r = 0.49 * w;
	        var angleConvert = 2 * Math.PI / 360;
	        var hfac = 1 / 360;
	        var sfac = 1 / this.r;
	        var rgb;
	        for (hue = 0; hue < 360; hue++) {
	          for (sat = 0; sat < this.r; sat++) {
	            x = this.centerCoordinates.x + sat * Math.sin(angleConvert * hue);
	            y = this.centerCoordinates.y + sat * Math.cos(angleConvert * hue);
	            rgb = HSVToRGB(hue * hfac, sat * sfac, 1);
	            ctx.fillStyle = "rgb(" + rgb.r + "," + rgb.g + "," + rgb.b + ")";
	            ctx.fillRect(x - 0.5, y - 0.5, 2, 2);
	          }
	        }
	        ctx.strokeStyle = "rgba(0,0,0,1)";
	        ctx.circle(this.centerCoordinates.x, this.centerCoordinates.y, this.r);
	        ctx.stroke();
	        this.hueCircle = ctx.getImageData(0, 0, w, h);
	      }
	      this.generated = true;
	    }

	    /**
	     * move the selector. This is called by hammer functions.
	     *
	     * @param {Event}  event   The event
	     * @private
	     */
	  }, {
	    key: "_moveSelector",
	    value: function _moveSelector(event) {
	      var rect = this.colorPickerDiv.getBoundingClientRect();
	      var left = event.center.x - rect.left;
	      var top = event.center.y - rect.top;
	      var centerY = 0.5 * this.colorPickerDiv.clientHeight;
	      var centerX = 0.5 * this.colorPickerDiv.clientWidth;
	      var x = left - centerX;
	      var y = top - centerY;
	      var angle = Math.atan2(x, y);
	      var radius = 0.98 * Math.min(Math.sqrt(x * x + y * y), centerX);
	      var newTop = Math.cos(angle) * radius + centerY;
	      var newLeft = Math.sin(angle) * radius + centerX;
	      this.colorPickerSelector.style.top = newTop - 0.5 * this.colorPickerSelector.clientHeight + "px";
	      this.colorPickerSelector.style.left = newLeft - 0.5 * this.colorPickerSelector.clientWidth + "px";

	      // set color
	      var h = angle / (2 * Math.PI);
	      h = h < 0 ? h + 1 : h;
	      var s = radius / this.r;
	      var hsv = RGBToHSV(this.color.r, this.color.g, this.color.b);
	      hsv.h = h;
	      hsv.s = s;
	      var rgba = HSVToRGB(hsv.h, hsv.s, hsv.v);
	      rgba["a"] = this.color.a;
	      this.color = rgba;

	      // update previews
	      this.initialColorDiv.style.backgroundColor = "rgba(" + this.initialColor.r + "," + this.initialColor.g + "," + this.initialColor.b + "," + this.initialColor.a + ")";
	      this.newColorDiv.style.backgroundColor = "rgba(" + this.color.r + "," + this.color.g + "," + this.color.b + "," + this.color.a + ")";
	    }
	  }]);
	  return ColorPicker$1;
	}();
	/**
	 * Wrap given text (last argument) in HTML elements (all preceding arguments).
	 *
	 * @param {...any} rest - List of tag names followed by inner text.
	 * @returns An element or a text node.
	 */
	function wrapInTag() {
	  for (var _len5 = arguments.length, rest = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
	    rest[_key5] = arguments[_key5];
	  }
	  if (rest.length < 1) {
	    throw new TypeError("Invalid arguments.");
	  } else if (rest.length === 1) {
	    return document.createTextNode(rest[0]);
	  } else {
	    var element = document.createElement(rest[0]);
	    element.appendChild(wrapInTag.apply(void 0, _toConsumableArray(_sliceInstanceProperty(rest).call(rest, 1))));
	    return element;
	  }
	}

	/**
	 * The way this works is for all properties of this.possible options, you can supply the property name in any form to list the options.
	 * Boolean options are recognised as Boolean
	 * Number options should be written as array: [default value, min value, max value, stepsize]
	 * Colors should be written as array: ['color', '#ffffff']
	 * Strings with should be written as array: [option1, option2, option3, ..]
	 *
	 * The options are matched with their counterparts in each of the modules and the values used in the configuration are
	 */
	var Configurator$1 = /*#__PURE__*/function () {
	  /**
	   * @param {object} parentModule        | the location where parentModule.setOptions() can be called
	   * @param {object} defaultContainer    | the default container of the module
	   * @param {object} configureOptions    | the fully configured and predefined options set found in allOptions.js
	   * @param {number} pixelRatio          | canvas pixel ratio
	   * @param {Function} hideOption        | custom logic to dynamically hide options
	   */
	  function Configurator$1(parentModule, defaultContainer, configureOptions) {
	    var pixelRatio = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
	    var hideOption = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : function () {
	      return false;
	    };
	    _classCallCheck(this, Configurator$1);
	    this.parent = parentModule;
	    this.changedOptions = [];
	    this.container = defaultContainer;
	    this.allowCreation = false;
	    this.hideOption = hideOption;
	    this.options = {};
	    this.initialized = false;
	    this.popupCounter = 0;
	    this.defaultOptions = {
	      enabled: false,
	      filter: true,
	      container: undefined,
	      showButton: true
	    };
	    _Object$assign(this.options, this.defaultOptions);
	    this.configureOptions = configureOptions;
	    this.moduleOptions = {};
	    this.domElements = [];
	    this.popupDiv = {};
	    this.popupLimit = 5;
	    this.popupHistory = {};
	    this.colorPicker = new ColorPicker$1(pixelRatio);
	    this.wrapper = undefined;
	  }

	  /**
	   * refresh all options.
	   * Because all modules parse their options by themselves, we just use their options. We copy them here.
	   *
	   * @param {object} options
	   */
	  _createClass(Configurator$1, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options !== undefined) {
	        // reset the popup history because the indices may have been changed.
	        this.popupHistory = {};
	        this._removePopup();
	        var enabled = true;
	        if (typeof options === "string") {
	          this.options.filter = options;
	        } else if (_Array$isArray$1(options)) {
	          this.options.filter = options.join();
	        } else if (_typeof(options) === "object") {
	          if (options == null) {
	            throw new TypeError("options cannot be null");
	          }
	          if (options.container !== undefined) {
	            this.options.container = options.container;
	          }
	          if (_filterInstanceProperty(options) !== undefined) {
	            this.options.filter = _filterInstanceProperty(options);
	          }
	          if (options.showButton !== undefined) {
	            this.options.showButton = options.showButton;
	          }
	          if (options.enabled !== undefined) {
	            enabled = options.enabled;
	          }
	        } else if (typeof options === "boolean") {
	          this.options.filter = true;
	          enabled = options;
	        } else if (typeof options === "function") {
	          this.options.filter = options;
	          enabled = true;
	        }
	        if (_filterInstanceProperty(this.options) === false) {
	          enabled = false;
	        }
	        this.options.enabled = enabled;
	      }
	      this._clean();
	    }

	    /**
	     *
	     * @param {object} moduleOptions
	     */
	  }, {
	    key: "setModuleOptions",
	    value: function setModuleOptions(moduleOptions) {
	      this.moduleOptions = moduleOptions;
	      if (this.options.enabled === true) {
	        this._clean();
	        if (this.options.container !== undefined) {
	          this.container = this.options.container;
	        }
	        this._create();
	      }
	    }

	    /**
	     * Create all DOM elements
	     *
	     * @private
	     */
	  }, {
	    key: "_create",
	    value: function _create() {
	      this._clean();
	      this.changedOptions = [];
	      var filter = _filterInstanceProperty(this.options);
	      var counter = 0;
	      var show = false;
	      for (var _option in this.configureOptions) {
	        if (Object.prototype.hasOwnProperty.call(this.configureOptions, _option)) {
	          this.allowCreation = false;
	          show = false;
	          if (typeof filter === "function") {
	            show = filter(_option, []);
	            show = show || this._handleObject(this.configureOptions[_option], [_option], true);
	          } else if (filter === true || _indexOfInstanceProperty(filter).call(filter, _option) !== -1) {
	            show = true;
	          }
	          if (show !== false) {
	            this.allowCreation = true;

	            // linebreak between categories
	            if (counter > 0) {
	              this._makeItem([]);
	            }
	            // a header for the category
	            this._makeHeader(_option);

	            // get the sub options
	            this._handleObject(this.configureOptions[_option], [_option]);
	          }
	          counter++;
	        }
	      }
	      this._makeButton();
	      this._push();
	      //~ this.colorPicker.insertTo(this.container);
	    }

	    /**
	     * draw all DOM elements on the screen
	     *
	     * @private
	     */
	  }, {
	    key: "_push",
	    value: function _push() {
	      this.wrapper = document.createElement("div");
	      this.wrapper.className = "vis-configuration-wrapper";
	      this.container.appendChild(this.wrapper);
	      for (var i = 0; i < this.domElements.length; i++) {
	        this.wrapper.appendChild(this.domElements[i]);
	      }
	      this._showPopupIfNeeded();
	    }

	    /**
	     * delete all DOM elements
	     *
	     * @private
	     */
	  }, {
	    key: "_clean",
	    value: function _clean() {
	      for (var i = 0; i < this.domElements.length; i++) {
	        this.wrapper.removeChild(this.domElements[i]);
	      }
	      if (this.wrapper !== undefined) {
	        this.container.removeChild(this.wrapper);
	        this.wrapper = undefined;
	      }
	      this.domElements = [];
	      this._removePopup();
	    }

	    /**
	     * get the value from the actualOptions if it exists
	     *
	     * @param {Array} path    | where to look for the actual option
	     * @returns {*}
	     * @private
	     */
	  }, {
	    key: "_getValue",
	    value: function _getValue(path) {
	      var base = this.moduleOptions;
	      for (var i = 0; i < path.length; i++) {
	        if (base[path[i]] !== undefined) {
	          base = base[path[i]];
	        } else {
	          base = undefined;
	          break;
	        }
	      }
	      return base;
	    }

	    /**
	     * all option elements are wrapped in an item
	     *
	     * @param {Array} path    | where to look for the actual option
	     * @param {Array.<Element>} domElements
	     * @returns {number}
	     * @private
	     */
	  }, {
	    key: "_makeItem",
	    value: function _makeItem(path) {
	      if (this.allowCreation === true) {
	        var item = document.createElement("div");
	        item.className = "vis-configuration vis-config-item vis-config-s" + path.length;
	        for (var _len6 = arguments.length, domElements = new Array(_len6 > 1 ? _len6 - 1 : 0), _key6 = 1; _key6 < _len6; _key6++) {
	          domElements[_key6 - 1] = arguments[_key6];
	        }
	        _forEachInstanceProperty(domElements).call(domElements, function (element) {
	          item.appendChild(element);
	        });
	        this.domElements.push(item);
	        return this.domElements.length;
	      }
	      return 0;
	    }

	    /**
	     * header for major subjects
	     *
	     * @param {string} name
	     * @private
	     */
	  }, {
	    key: "_makeHeader",
	    value: function _makeHeader(name) {
	      var div = document.createElement("div");
	      div.className = "vis-configuration vis-config-header";
	      div.innerText = name;
	      this._makeItem([], div);
	    }

	    /**
	     * make a label, if it is an object label, it gets different styling.
	     *
	     * @param {string} name
	     * @param {Array} path    | where to look for the actual option
	     * @param {string} objectLabel
	     * @returns {HTMLElement}
	     * @private
	     */
	  }, {
	    key: "_makeLabel",
	    value: function _makeLabel(name, path) {
	      var objectLabel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      var div = document.createElement("div");
	      div.className = "vis-configuration vis-config-label vis-config-s" + path.length;
	      if (objectLabel === true) {
	        while (div.firstChild) {
	          div.removeChild(div.firstChild);
	        }
	        div.appendChild(wrapInTag("i", "b", name));
	      } else {
	        div.innerText = name + ":";
	      }
	      return div;
	    }

	    /**
	     * make a dropdown list for multiple possible string optoins
	     *
	     * @param {Array.<number>} arr
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_makeDropdown",
	    value: function _makeDropdown(arr, value, path) {
	      var select = document.createElement("select");
	      select.className = "vis-configuration vis-config-select";
	      var selectedValue = 0;
	      if (value !== undefined) {
	        if (_indexOfInstanceProperty(arr).call(arr, value) !== -1) {
	          selectedValue = _indexOfInstanceProperty(arr).call(arr, value);
	        }
	      }
	      for (var i = 0; i < arr.length; i++) {
	        var _option2 = document.createElement("option");
	        _option2.value = arr[i];
	        if (i === selectedValue) {
	          _option2.selected = "selected";
	        }
	        _option2.innerText = arr[i];
	        select.appendChild(_option2);
	      }
	      var me = this;
	      select.onchange = function () {
	        me._update(this.value, path);
	      };
	      var label = this._makeLabel(path[path.length - 1], path);
	      this._makeItem(path, label, select);
	    }

	    /**
	     * make a range object for numeric options
	     *
	     * @param {Array.<number>} arr
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_makeRange",
	    value: function _makeRange(arr, value, path) {
	      var defaultValue = arr[0];
	      var min = arr[1];
	      var max = arr[2];
	      var step = arr[3];
	      var range = document.createElement("input");
	      range.className = "vis-configuration vis-config-range";
	      try {
	        range.type = "range"; // not supported on IE9
	        range.min = min;
	        range.max = max;
	      } catch (err) {
	        // TODO: Add some error handling.
	      }
	      range.step = step;

	      // set up the popup settings in case they are needed.
	      var popupString = "";
	      var popupValue = 0;
	      if (value !== undefined) {
	        var factor = 1.2;
	        if (value < 0 && value * factor < min) {
	          range.min = Math.ceil(value * factor);
	          popupValue = range.min;
	          popupString = "range increased";
	        } else if (value / factor < min) {
	          range.min = Math.ceil(value / factor);
	          popupValue = range.min;
	          popupString = "range increased";
	        }
	        if (value * factor > max && max !== 1) {
	          range.max = Math.ceil(value * factor);
	          popupValue = range.max;
	          popupString = "range increased";
	        }
	        range.value = value;
	      } else {
	        range.value = defaultValue;
	      }
	      var input = document.createElement("input");
	      input.className = "vis-configuration vis-config-rangeinput";
	      input.value = range.value;
	      var me = this;
	      range.onchange = function () {
	        input.value = this.value;
	        me._update(Number(this.value), path);
	      };
	      range.oninput = function () {
	        input.value = this.value;
	      };
	      var label = this._makeLabel(path[path.length - 1], path);
	      var itemIndex = this._makeItem(path, label, range, input);

	      // if a popup is needed AND it has not been shown for this value, show it.
	      if (popupString !== "" && this.popupHistory[itemIndex] !== popupValue) {
	        this.popupHistory[itemIndex] = popupValue;
	        this._setupPopup(popupString, itemIndex);
	      }
	    }

	    /**
	     * make a button object
	     *
	     * @private
	     */
	  }, {
	    key: "_makeButton",
	    value: function _makeButton() {
	      var _this4 = this;
	      if (this.options.showButton === true) {
	        var generateButton = document.createElement("div");
	        generateButton.className = "vis-configuration vis-config-button";
	        generateButton.innerText = "generate options";
	        generateButton.onclick = function () {
	          _this4._printOptions();
	        };
	        generateButton.onmouseover = function () {
	          generateButton.className = "vis-configuration vis-config-button hover";
	        };
	        generateButton.onmouseout = function () {
	          generateButton.className = "vis-configuration vis-config-button";
	        };
	        this.optionsContainer = document.createElement("div");
	        this.optionsContainer.className = "vis-configuration vis-config-option-container";
	        this.domElements.push(this.optionsContainer);
	        this.domElements.push(generateButton);
	      }
	    }

	    /**
	     * prepare the popup
	     *
	     * @param {string} string
	     * @param {number} index
	     * @private
	     */
	  }, {
	    key: "_setupPopup",
	    value: function _setupPopup(string, index) {
	      var _this5 = this;
	      if (this.initialized === true && this.allowCreation === true && this.popupCounter < this.popupLimit) {
	        var div = document.createElement("div");
	        div.id = "vis-configuration-popup";
	        div.className = "vis-configuration-popup";
	        div.innerText = string;
	        div.onclick = function () {
	          _this5._removePopup();
	        };
	        this.popupCounter += 1;
	        this.popupDiv = {
	          html: div,
	          index: index
	        };
	      }
	    }

	    /**
	     * remove the popup from the dom
	     *
	     * @private
	     */
	  }, {
	    key: "_removePopup",
	    value: function _removePopup() {
	      if (this.popupDiv.html !== undefined) {
	        this.popupDiv.html.parentNode.removeChild(this.popupDiv.html);
	        clearTimeout(this.popupDiv.hideTimeout);
	        clearTimeout(this.popupDiv.deleteTimeout);
	        this.popupDiv = {};
	      }
	    }

	    /**
	     * Show the popup if it is needed.
	     *
	     * @private
	     */
	  }, {
	    key: "_showPopupIfNeeded",
	    value: function _showPopupIfNeeded() {
	      var _this6 = this;
	      if (this.popupDiv.html !== undefined) {
	        var correspondingElement = this.domElements[this.popupDiv.index];
	        var rect = correspondingElement.getBoundingClientRect();
	        this.popupDiv.html.style.left = rect.left + "px";
	        this.popupDiv.html.style.top = rect.top - 30 + "px"; // 30 is the height;
	        document.body.appendChild(this.popupDiv.html);
	        this.popupDiv.hideTimeout = _setTimeout(function () {
	          _this6.popupDiv.html.style.opacity = 0;
	        }, 1500);
	        this.popupDiv.deleteTimeout = _setTimeout(function () {
	          _this6._removePopup();
	        }, 1800);
	      }
	    }

	    /**
	     * make a checkbox for boolean options.
	     *
	     * @param {number} defaultValue
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_makeCheckbox",
	    value: function _makeCheckbox(defaultValue, value, path) {
	      var checkbox = document.createElement("input");
	      checkbox.type = "checkbox";
	      checkbox.className = "vis-configuration vis-config-checkbox";
	      checkbox.checked = defaultValue;
	      if (value !== undefined) {
	        checkbox.checked = value;
	        if (value !== defaultValue) {
	          if (_typeof(defaultValue) === "object") {
	            if (value !== defaultValue.enabled) {
	              this.changedOptions.push({
	                path: path,
	                value: value
	              });
	            }
	          } else {
	            this.changedOptions.push({
	              path: path,
	              value: value
	            });
	          }
	        }
	      }
	      var me = this;
	      checkbox.onchange = function () {
	        me._update(this.checked, path);
	      };
	      var label = this._makeLabel(path[path.length - 1], path);
	      this._makeItem(path, label, checkbox);
	    }

	    /**
	     * make a text input field for string options.
	     *
	     * @param {number} defaultValue
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_makeTextInput",
	    value: function _makeTextInput(defaultValue, value, path) {
	      var checkbox = document.createElement("input");
	      checkbox.type = "text";
	      checkbox.className = "vis-configuration vis-config-text";
	      checkbox.value = value;
	      if (value !== defaultValue) {
	        this.changedOptions.push({
	          path: path,
	          value: value
	        });
	      }
	      var me = this;
	      checkbox.onchange = function () {
	        me._update(this.value, path);
	      };
	      var label = this._makeLabel(path[path.length - 1], path);
	      this._makeItem(path, label, checkbox);
	    }

	    /**
	     * make a color field with a color picker for color fields
	     *
	     * @param {Array.<number>} arr
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_makeColorField",
	    value: function _makeColorField(arr, value, path) {
	      var _this7 = this;
	      var defaultColor = arr[1];
	      var div = document.createElement("div");
	      value = value === undefined ? defaultColor : value;
	      if (value !== "none") {
	        div.className = "vis-configuration vis-config-colorBlock";
	        div.style.backgroundColor = value;
	      } else {
	        div.className = "vis-configuration vis-config-colorBlock none";
	      }
	      value = value === undefined ? defaultColor : value;
	      div.onclick = function () {
	        _this7._showColorPicker(value, div, path);
	      };
	      var label = this._makeLabel(path[path.length - 1], path);
	      this._makeItem(path, label, div);
	    }

	    /**
	     * used by the color buttons to call the color picker.
	     *
	     * @param {number} value
	     * @param {HTMLElement} div
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_showColorPicker",
	    value: function _showColorPicker(value, div, path) {
	      var _this8 = this;
	      // clear the callback from this div
	      div.onclick = function () {};
	      this.colorPicker.insertTo(div);
	      this.colorPicker.show();
	      this.colorPicker.setColor(value);
	      this.colorPicker.setUpdateCallback(function (color) {
	        var colorString = "rgba(" + color.r + "," + color.g + "," + color.b + "," + color.a + ")";
	        div.style.backgroundColor = colorString;
	        _this8._update(colorString, path);
	      });

	      // on close of the colorpicker, restore the callback.
	      this.colorPicker.setCloseCallback(function () {
	        div.onclick = function () {
	          _this8._showColorPicker(value, div, path);
	        };
	      });
	    }

	    /**
	     * parse an object and draw the correct items
	     *
	     * @param {object} obj
	     * @param {Array} [path=[]]    | where to look for the actual option
	     * @param {boolean} [checkOnly=false]
	     * @returns {boolean}
	     * @private
	     */
	  }, {
	    key: "_handleObject",
	    value: function _handleObject(obj) {
	      var path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
	      var checkOnly = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      var show = false;
	      var filter = _filterInstanceProperty(this.options);
	      var visibleInSet = false;
	      for (var subObj in obj) {
	        if (Object.prototype.hasOwnProperty.call(obj, subObj)) {
	          show = true;
	          var item = obj[subObj];
	          var newPath = copyAndExtendArray(path, subObj);
	          if (typeof filter === "function") {
	            show = filter(subObj, path);

	            // if needed we must go deeper into the object.
	            if (show === false) {
	              if (!_Array$isArray$1(item) && typeof item !== "string" && typeof item !== "boolean" && item instanceof Object) {
	                this.allowCreation = false;
	                show = this._handleObject(item, newPath, true);
	                this.allowCreation = checkOnly === false;
	              }
	            }
	          }
	          if (show !== false) {
	            visibleInSet = true;
	            var value = this._getValue(newPath);
	            if (_Array$isArray$1(item)) {
	              this._handleArray(item, value, newPath);
	            } else if (typeof item === "string") {
	              this._makeTextInput(item, value, newPath);
	            } else if (typeof item === "boolean") {
	              this._makeCheckbox(item, value, newPath);
	            } else if (item instanceof Object) {
	              // skip the options that are not enabled
	              if (!this.hideOption(path, subObj, this.moduleOptions)) {
	                // initially collapse options with an disabled enabled option.
	                if (item.enabled !== undefined) {
	                  var enabledPath = copyAndExtendArray(newPath, "enabled");
	                  var enabledValue = this._getValue(enabledPath);
	                  if (enabledValue === true) {
	                    var label = this._makeLabel(subObj, newPath, true);
	                    this._makeItem(newPath, label);
	                    visibleInSet = this._handleObject(item, newPath) || visibleInSet;
	                  } else {
	                    this._makeCheckbox(item, enabledValue, newPath);
	                  }
	                } else {
	                  var _label = this._makeLabel(subObj, newPath, true);
	                  this._makeItem(newPath, _label);
	                  visibleInSet = this._handleObject(item, newPath) || visibleInSet;
	                }
	              }
	            } else {
	              console.error("dont know how to handle", item, subObj, newPath);
	            }
	          }
	        }
	      }
	      return visibleInSet;
	    }

	    /**
	     * handle the array type of option
	     *
	     * @param {Array.<number>} arr
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_handleArray",
	    value: function _handleArray(arr, value, path) {
	      if (typeof arr[0] === "string" && arr[0] === "color") {
	        this._makeColorField(arr, value, path);
	        if (arr[1] !== value) {
	          this.changedOptions.push({
	            path: path,
	            value: value
	          });
	        }
	      } else if (typeof arr[0] === "string") {
	        this._makeDropdown(arr, value, path);
	        if (arr[0] !== value) {
	          this.changedOptions.push({
	            path: path,
	            value: value
	          });
	        }
	      } else if (typeof arr[0] === "number") {
	        this._makeRange(arr, value, path);
	        if (arr[0] !== value) {
	          this.changedOptions.push({
	            path: path,
	            value: Number(value)
	          });
	        }
	      }
	    }

	    /**
	     * called to update the network with the new settings.
	     *
	     * @param {number} value
	     * @param {Array} path    | where to look for the actual option
	     * @private
	     */
	  }, {
	    key: "_update",
	    value: function _update(value, path) {
	      var options = this._constructOptions(value, path);
	      if (this.parent.body && this.parent.body.emitter && this.parent.body.emitter.emit) {
	        this.parent.body.emitter.emit("configChange", options);
	      }
	      this.initialized = true;
	      this.parent.setOptions(options);
	    }

	    /**
	     *
	     * @param {string | boolean} value
	     * @param {Array.<string>} path
	     * @param {{}} optionsObj
	     * @returns {{}}
	     * @private
	     */
	  }, {
	    key: "_constructOptions",
	    value: function _constructOptions(value, path) {
	      var optionsObj = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	      var pointer = optionsObj;

	      // when dropdown boxes can be string or boolean, we typecast it into correct types
	      value = value === "true" ? true : value;
	      value = value === "false" ? false : value;
	      for (var i = 0; i < path.length; i++) {
	        if (path[i] !== "global") {
	          if (pointer[path[i]] === undefined) {
	            pointer[path[i]] = {};
	          }
	          if (i !== path.length - 1) {
	            pointer = pointer[path[i]];
	          } else {
	            pointer[path[i]] = value;
	          }
	        }
	      }
	      return optionsObj;
	    }

	    /**
	     * @private
	     */
	  }, {
	    key: "_printOptions",
	    value: function _printOptions() {
	      var options = this.getOptions();
	      while (this.optionsContainer.firstChild) {
	        this.optionsContainer.removeChild(this.optionsContainer.firstChild);
	      }
	      this.optionsContainer.appendChild(wrapInTag("pre", "const options = " + _JSON$stringify(options, null, 2)));
	    }

	    /**
	     *
	     * @returns {{}} options
	     */
	  }, {
	    key: "getOptions",
	    value: function getOptions() {
	      var options = {};
	      for (var i = 0; i < this.changedOptions.length; i++) {
	        this._constructOptions(this.changedOptions[i].value, this.changedOptions[i].path, options);
	      }
	      return options;
	    }
	  }]);
	  return Configurator$1;
	}();
	/**
	 * Popup is a class to create a popup window with some text
	 */
	var Popup$1 = /*#__PURE__*/function () {
	  /**
	   * @param {Element} container       The container object.
	   * @param {string}  overflowMethod  How the popup should act to overflowing ('flip' or 'cap')
	   */
	  function Popup$1(container, overflowMethod) {
	    _classCallCheck(this, Popup$1);
	    this.container = container;
	    this.overflowMethod = overflowMethod || "cap";
	    this.x = 0;
	    this.y = 0;
	    this.padding = 5;
	    this.hidden = false;

	    // create the frame
	    this.frame = document.createElement("div");
	    this.frame.className = "vis-tooltip";
	    this.container.appendChild(this.frame);
	  }

	  /**
	   * @param {number} x   Horizontal position of the popup window
	   * @param {number} y   Vertical position of the popup window
	   */
	  _createClass(Popup$1, [{
	    key: "setPosition",
	    value: function setPosition(x, y) {
	      this.x = _parseInt(x);
	      this.y = _parseInt(y);
	    }

	    /**
	     * Set the content for the popup window. This can be HTML code or text.
	     *
	     * @param {string | Element} content
	     */
	  }, {
	    key: "setText",
	    value: function setText(content) {
	      if (content instanceof Element) {
	        while (this.frame.firstChild) {
	          this.frame.removeChild(this.frame.firstChild);
	        }
	        this.frame.appendChild(content);
	      } else {
	        // String containing literal text, element has to be used for HTML due to
	        // XSS risks associated with innerHTML (i.e. prevent XSS by accident).
	        this.frame.innerText = content;
	      }
	    }

	    /**
	     * Show the popup window
	     *
	     * @param {boolean} [doShow]    Show or hide the window
	     */
	  }, {
	    key: "show",
	    value: function show(doShow) {
	      if (doShow === undefined) {
	        doShow = true;
	      }
	      if (doShow === true) {
	        var height = this.frame.clientHeight;
	        var width = this.frame.clientWidth;
	        var maxHeight = this.frame.parentNode.clientHeight;
	        var maxWidth = this.frame.parentNode.clientWidth;
	        var left = 0,
	          top = 0;
	        if (this.overflowMethod == "flip") {
	          var isLeft = false,
	            isTop = true; // Where around the position it's located

	          if (this.y - height < this.padding) {
	            isTop = false;
	          }
	          if (this.x + width > maxWidth - this.padding) {
	            isLeft = true;
	          }
	          if (isLeft) {
	            left = this.x - width;
	          } else {
	            left = this.x;
	          }
	          if (isTop) {
	            top = this.y - height;
	          } else {
	            top = this.y;
	          }
	        } else {
	          top = this.y - height;
	          if (top + height + this.padding > maxHeight) {
	            top = maxHeight - height - this.padding;
	          }
	          if (top < this.padding) {
	            top = this.padding;
	          }
	          left = this.x;
	          if (left + width + this.padding > maxWidth) {
	            left = maxWidth - width - this.padding;
	          }
	          if (left < this.padding) {
	            left = this.padding;
	          }
	        }
	        this.frame.style.left = left + "px";
	        this.frame.style.top = top + "px";
	        this.frame.style.visibility = "visible";
	        this.hidden = false;
	      } else {
	        this.hide();
	      }
	    }

	    /**
	     * Hide the popup window
	     */
	  }, {
	    key: "hide",
	    value: function hide() {
	      this.hidden = true;
	      this.frame.style.left = "0";
	      this.frame.style.top = "0";
	      this.frame.style.visibility = "hidden";
	    }

	    /**
	     * Remove the popup window
	     */
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.frame.parentNode.removeChild(this.frame); // Remove element from DOM
	    }
	  }]);
	  return Popup$1;
	}();
	var errorFound$1 = false;
	var allOptions$3;
	var VALIDATOR_PRINT_STYLE$1 = "background: #FFeeee; color: #dd0000";

	/**
	 *  Used to validate options.
	 */
	var Validator$1 = /*#__PURE__*/function () {
	  function Validator$1() {
	    _classCallCheck(this, Validator$1);
	  }
	  _createClass(Validator$1, null, [{
	    key: "validate",
	    value:
	    /**
	     * Main function to be called
	     *
	     * @param {object} options
	     * @param {object} referenceOptions
	     * @param {object} subObject
	     * @returns {boolean}
	     * @static
	     */
	    function validate(options, referenceOptions, subObject) {
	      errorFound$1 = false;
	      allOptions$3 = referenceOptions;
	      var usedOptions = referenceOptions;
	      if (subObject !== undefined) {
	        usedOptions = referenceOptions[subObject];
	      }
	      Validator$1.parse(options, usedOptions, []);
	      return errorFound$1;
	    }

	    /**
	     * Will traverse an object recursively and check every value
	     *
	     * @param {object} options
	     * @param {object} referenceOptions
	     * @param {Array} path    | where to look for the actual option
	     * @static
	     */
	  }, {
	    key: "parse",
	    value: function parse(options, referenceOptions, path) {
	      for (var _option3 in options) {
	        if (Object.prototype.hasOwnProperty.call(options, _option3)) {
	          Validator$1.check(_option3, options, referenceOptions, path);
	        }
	      }
	    }

	    /**
	     * Check every value. If the value is an object, call the parse function on that object.
	     *
	     * @param {string} option
	     * @param {object} options
	     * @param {object} referenceOptions
	     * @param {Array} path    | where to look for the actual option
	     * @static
	     */
	  }, {
	    key: "check",
	    value: function check(option, options, referenceOptions, path) {
	      if (referenceOptions[option] === undefined && referenceOptions.__any__ === undefined) {
	        Validator$1.getSuggestion(option, referenceOptions, path);
	        return;
	      }
	      var referenceOption = option;
	      var is_object = true;
	      if (referenceOptions[option] === undefined && referenceOptions.__any__ !== undefined) {
	        // NOTE: This only triggers if the __any__ is in the top level of the options object.
	        //       THAT'S A REALLY BAD PLACE TO ALLOW IT!!!!
	        // TODO: Examine if needed, remove if possible

	        // __any__ is a wildcard. Any value is accepted and will be further analysed by reference.
	        referenceOption = "__any__";

	        // if the any-subgroup is not a predefined object in the configurator,
	        // we do not look deeper into the object.
	        is_object = Validator$1.getType(options[option]) === "object";
	      }
	      var refOptionObj = referenceOptions[referenceOption];
	      if (is_object && refOptionObj.__type__ !== undefined) {
	        refOptionObj = refOptionObj.__type__;
	      }
	      Validator$1.checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path);
	    }

	    /**
	     *
	     * @param {string}  option           | the option property
	     * @param {object}  options          | The supplied options object
	     * @param {object}  referenceOptions | The reference options containing all options and their allowed formats
	     * @param {string}  referenceOption  | Usually this is the same as option, except when handling an __any__ tag.
	     * @param {string}  refOptionObj     | This is the type object from the reference options
	     * @param {Array}   path             | where in the object is the option
	     * @static
	     */
	  }, {
	    key: "checkFields",
	    value: function checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path) {
	      var log = function log(message) {
	        console.error("%c" + message + Validator$1.printLocation(path, option), VALIDATOR_PRINT_STYLE$1);
	      };
	      var optionType = Validator$1.getType(options[option]);
	      var refOptionType = refOptionObj[optionType];
	      if (refOptionType !== undefined) {
	        // if the type is correct, we check if it is supposed to be one of a few select values
	        if (Validator$1.getType(refOptionType) === "array" && _indexOfInstanceProperty(refOptionType).call(refOptionType, options[option]) === -1) {
	          log('Invalid option detected in "' + option + '".' + " Allowed values are:" + Validator$1.print(refOptionType) + ' not "' + options[option] + '". ');
	          errorFound$1 = true;
	        } else if (optionType === "object" && referenceOption !== "__any__") {
	          path = copyAndExtendArray(path, option);
	          Validator$1.parse(options[option], referenceOptions[referenceOption], path);
	        }
	      } else if (refOptionObj["any"] === undefined) {
	        // type of the field is incorrect and the field cannot be any
	        log('Invalid type received for "' + option + '". Expected: ' + Validator$1.print(_Object$keys(refOptionObj)) + ". Received [" + optionType + '] "' + options[option] + '"');
	        errorFound$1 = true;
	      }
	    }

	    /**
	     *
	     * @param {object | boolean | number | string | Array.<number> | Date | Node | Moment | undefined | null} object
	     * @returns {string}
	     * @static
	     */
	  }, {
	    key: "getType",
	    value: function getType(object) {
	      var type = _typeof(object);
	      if (type === "object") {
	        if (object === null) {
	          return "null";
	        }
	        if (object instanceof Boolean) {
	          return "boolean";
	        }
	        if (object instanceof Number) {
	          return "number";
	        }
	        if (object instanceof String) {
	          return "string";
	        }
	        if (_Array$isArray$1(object)) {
	          return "array";
	        }
	        if (object instanceof Date) {
	          return "date";
	        }
	        if (object.nodeType !== undefined) {
	          return "dom";
	        }
	        if (object._isAMomentObject === true) {
	          return "moment";
	        }
	        return "object";
	      } else if (type === "number") {
	        return "number";
	      } else if (type === "boolean") {
	        return "boolean";
	      } else if (type === "string") {
	        return "string";
	      } else if (type === undefined) {
	        return "undefined";
	      }
	      return type;
	    }

	    /**
	     * @param {string} option
	     * @param {object} options
	     * @param {Array.<string>} path
	     * @static
	     */
	  }, {
	    key: "getSuggestion",
	    value: function getSuggestion(option, options, path) {
	      var localSearch = Validator$1.findInOptions(option, options, path, false);
	      var globalSearch = Validator$1.findInOptions(option, allOptions$3, [], true);
	      var localSearchThreshold = 8;
	      var globalSearchThreshold = 4;
	      var msg;
	      if (localSearch.indexMatch !== undefined) {
	        msg = " in " + Validator$1.printLocation(localSearch.path, option, "") + 'Perhaps it was incomplete? Did you mean: "' + localSearch.indexMatch + '"?\n\n';
	      } else if (globalSearch.distance <= globalSearchThreshold && localSearch.distance > globalSearch.distance) {
	        msg = " in " + Validator$1.printLocation(localSearch.path, option, "") + "Perhaps it was misplaced? Matching option found at: " + Validator$1.printLocation(globalSearch.path, globalSearch.closestMatch, "");
	      } else if (localSearch.distance <= localSearchThreshold) {
	        msg = '. Did you mean "' + localSearch.closestMatch + '"?' + Validator$1.printLocation(localSearch.path, option);
	      } else {
	        msg = ". Did you mean one of these: " + Validator$1.print(_Object$keys(options)) + Validator$1.printLocation(path, option);
	      }
	      console.error('%cUnknown option detected: "' + option + '"' + msg, VALIDATOR_PRINT_STYLE$1);
	      errorFound$1 = true;
	    }

	    /**
	     * traverse the options in search for a match.
	     *
	     * @param {string} option
	     * @param {object} options
	     * @param {Array} path    | where to look for the actual option
	     * @param {boolean} [recursive=false]
	     * @returns {{closestMatch: string, path: Array, distance: number}}
	     * @static
	     */
	  }, {
	    key: "findInOptions",
	    value: function findInOptions(option, options, path) {
	      var recursive = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	      var min = 1e9;
	      var closestMatch = "";
	      var closestMatchPath = [];
	      var lowerCaseOption = option.toLowerCase();
	      var indexMatch = undefined;
	      for (var op in options) {
	        var distance = void 0;
	        if (options[op].__type__ !== undefined && recursive === true) {
	          var result = Validator$1.findInOptions(option, options[op], copyAndExtendArray(path, op));
	          if (min > result.distance) {
	            closestMatch = result.closestMatch;
	            closestMatchPath = result.path;
	            min = result.distance;
	            indexMatch = result.indexMatch;
	          }
	        } else {
	          var _context20;
	          if (_indexOfInstanceProperty(_context20 = op.toLowerCase()).call(_context20, lowerCaseOption) !== -1) {
	            indexMatch = op;
	          }
	          distance = Validator$1.levenshteinDistance(option, op);
	          if (min > distance) {
	            closestMatch = op;
	            closestMatchPath = copyArray(path);
	            min = distance;
	          }
	        }
	      }
	      return {
	        closestMatch: closestMatch,
	        path: closestMatchPath,
	        distance: min,
	        indexMatch: indexMatch
	      };
	    }

	    /**
	     * @param {Array.<string>} path
	     * @param {object} option
	     * @param {string} prefix
	     * @returns {string}
	     * @static
	     */
	  }, {
	    key: "printLocation",
	    value: function printLocation(path, option) {
	      var prefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "Problem value found at: \n";
	      var str = "\n\n" + prefix + "options = {\n";
	      for (var i = 0; i < path.length; i++) {
	        for (var j = 0; j < i + 1; j++) {
	          str += "  ";
	        }
	        str += path[i] + ": {\n";
	      }
	      for (var _j = 0; _j < path.length + 1; _j++) {
	        str += "  ";
	      }
	      str += option + "\n";
	      for (var _i3 = 0; _i3 < path.length + 1; _i3++) {
	        for (var _j2 = 0; _j2 < path.length - _i3; _j2++) {
	          str += "  ";
	        }
	        str += "}\n";
	      }
	      return str + "\n\n";
	    }

	    /**
	     * @param {object} options
	     * @returns {string}
	     * @static
	     */
	  }, {
	    key: "print",
	    value: function print(options) {
	      return _JSON$stringify(options).replace(/(")|(\[)|(\])|(,"__type__")/g, "").replace(/(,)/g, ", ");
	    }

	    /**
	     *  Compute the edit distance between the two given strings
	     * http://en.wikibooks.org/wiki/Algorithm_Implementation/Strings/Levenshtein_distance#JavaScript
	     *
	     * Copyright (c) 2011 Andrei Mackenzie
	     *
	     * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
	     *
	     * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
	     *
	     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
	     *
	     * @param {string} a
	     * @param {string} b
	     * @returns {Array.<Array.<number>>}}
	     * @static
	     */
	  }, {
	    key: "levenshteinDistance",
	    value: function levenshteinDistance(a, b) {
	      if (a.length === 0) return b.length;
	      if (b.length === 0) return a.length;
	      var matrix = [];

	      // increment along the first column of each row
	      var i;
	      for (i = 0; i <= b.length; i++) {
	        matrix[i] = [i];
	      }

	      // increment each column in the first row
	      var j;
	      for (j = 0; j <= a.length; j++) {
	        matrix[0][j] = j;
	      }

	      // Fill in the rest of the matrix
	      for (i = 1; i <= b.length; i++) {
	        for (j = 1; j <= a.length; j++) {
	          if (b.charAt(i - 1) == a.charAt(j - 1)) {
	            matrix[i][j] = matrix[i - 1][j - 1];
	          } else {
	            matrix[i][j] = Math.min(matrix[i - 1][j - 1] + 1,
	            // substitution
	            Math.min(matrix[i][j - 1] + 1,
	            // insertion
	            matrix[i - 1][j] + 1)); // deletion
	          }
	        }
	      }

	      return matrix[b.length][a.length];
	    }
	  }]);
	  return Validator$1;
	}();
	var Activator$2 = Activator$1;
	var ColorPicker$2 = ColorPicker$1;
	var Configurator$2 = Configurator$1;
	var Hammer$2 = Hammer$1;
	var Popup$2 = Popup$1;
	var VALIDATOR_PRINT_STYLE = VALIDATOR_PRINT_STYLE$1;
	var Validator$2 = Validator$1;

	var util$2 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		Activator: Activator$2,
		Alea: Alea,
		ColorPicker: ColorPicker$2,
		Configurator: Configurator$2,
		DELETE: DELETE,
		HSVToHex: HSVToHex,
		HSVToRGB: HSVToRGB,
		Hammer: Hammer$2,
		Popup: Popup$2,
		RGBToHSV: RGBToHSV,
		RGBToHex: RGBToHex,
		VALIDATOR_PRINT_STYLE: VALIDATOR_PRINT_STYLE,
		Validator: Validator$2,
		addClassName: addClassName,
		addCssText: addCssText,
		addEventListener: addEventListener,
		binarySearchCustom: binarySearchCustom,
		binarySearchValue: binarySearchValue,
		bridgeObject: bridgeObject,
		copyAndExtendArray: copyAndExtendArray,
		copyArray: copyArray,
		deepExtend: deepExtend,
		deepObjectAssign: deepObjectAssign,
		easingFunctions: easingFunctions,
		equalArray: equalArray,
		extend: extend,
		fillIfDefined: fillIfDefined,
		forEach: forEach$1,
		getAbsoluteLeft: getAbsoluteLeft,
		getAbsoluteRight: getAbsoluteRight,
		getAbsoluteTop: getAbsoluteTop,
		getScrollBarWidth: getScrollBarWidth,
		getTarget: getTarget,
		getType: getType,
		hasParent: hasParent,
		hexToHSV: hexToHSV,
		hexToRGB: hexToRGB,
		insertSort: insertSort,
		isDate: isDate,
		isNumber: isNumber,
		isObject: isObject$3,
		isString: isString,
		isValidHex: isValidHex,
		isValidRGB: isValidRGB,
		isValidRGBA: isValidRGBA,
		mergeOptions: mergeOptions,
		option: option,
		overrideOpacity: overrideOpacity,
		parseColor: parseColor,
		preventDefault: preventDefault,
		pureDeepObjectAssign: pureDeepObjectAssign,
		recursiveDOMDelete: recursiveDOMDelete,
		removeClassName: removeClassName,
		removeCssText: removeCssText,
		removeEventListener: removeEventListener,
		selectiveBridgeObject: selectiveBridgeObject,
		selectiveDeepExtend: selectiveDeepExtend,
		selectiveExtend: selectiveExtend,
		selectiveNotDeepExtend: selectiveNotDeepExtend,
		throttle: throttle,
		toArray: toArray,
		topMost: topMost,
		updateProperty: updateProperty
	});

	var libExports$1 = {};
	var lib$1 = {
	  get exports(){ return libExports$1; },
	  set exports(v){ libExports$1 = v; },
	};

	var _default$1 = {};

	var libExports = {};
	var lib = {
	  get exports(){ return libExports; },
	  set exports(v){ libExports = v; },
	};

	var _default = {};

	/**
	 * cssfilter
	 *
	 * @author 老雷<leizongmin@gmail.com>
	 */

	function getDefaultWhiteList$1 () {
	  // 白名单值说明：
	  // true: 允许该属性
	  // Function: function (val) { } 返回true表示允许该属性，其他值均表示不允许
	  // RegExp: regexp.test(val) 返回true表示允许该属性，其他值均表示不允许
	  // 除上面列出的值外均表示不允许
	  var whiteList = {};

	  whiteList['align-content'] = false; // default: auto
	  whiteList['align-items'] = false; // default: auto
	  whiteList['align-self'] = false; // default: auto
	  whiteList['alignment-adjust'] = false; // default: auto
	  whiteList['alignment-baseline'] = false; // default: baseline
	  whiteList['all'] = false; // default: depending on individual properties
	  whiteList['anchor-point'] = false; // default: none
	  whiteList['animation'] = false; // default: depending on individual properties
	  whiteList['animation-delay'] = false; // default: 0
	  whiteList['animation-direction'] = false; // default: normal
	  whiteList['animation-duration'] = false; // default: 0
	  whiteList['animation-fill-mode'] = false; // default: none
	  whiteList['animation-iteration-count'] = false; // default: 1
	  whiteList['animation-name'] = false; // default: none
	  whiteList['animation-play-state'] = false; // default: running
	  whiteList['animation-timing-function'] = false; // default: ease
	  whiteList['azimuth'] = false; // default: center
	  whiteList['backface-visibility'] = false; // default: visible
	  whiteList['background'] = true; // default: depending on individual properties
	  whiteList['background-attachment'] = true; // default: scroll
	  whiteList['background-clip'] = true; // default: border-box
	  whiteList['background-color'] = true; // default: transparent
	  whiteList['background-image'] = true; // default: none
	  whiteList['background-origin'] = true; // default: padding-box
	  whiteList['background-position'] = true; // default: 0% 0%
	  whiteList['background-repeat'] = true; // default: repeat
	  whiteList['background-size'] = true; // default: auto
	  whiteList['baseline-shift'] = false; // default: baseline
	  whiteList['binding'] = false; // default: none
	  whiteList['bleed'] = false; // default: 6pt
	  whiteList['bookmark-label'] = false; // default: content()
	  whiteList['bookmark-level'] = false; // default: none
	  whiteList['bookmark-state'] = false; // default: open
	  whiteList['border'] = true; // default: depending on individual properties
	  whiteList['border-bottom'] = true; // default: depending on individual properties
	  whiteList['border-bottom-color'] = true; // default: current color
	  whiteList['border-bottom-left-radius'] = true; // default: 0
	  whiteList['border-bottom-right-radius'] = true; // default: 0
	  whiteList['border-bottom-style'] = true; // default: none
	  whiteList['border-bottom-width'] = true; // default: medium
	  whiteList['border-collapse'] = true; // default: separate
	  whiteList['border-color'] = true; // default: depending on individual properties
	  whiteList['border-image'] = true; // default: none
	  whiteList['border-image-outset'] = true; // default: 0
	  whiteList['border-image-repeat'] = true; // default: stretch
	  whiteList['border-image-slice'] = true; // default: 100%
	  whiteList['border-image-source'] = true; // default: none
	  whiteList['border-image-width'] = true; // default: 1
	  whiteList['border-left'] = true; // default: depending on individual properties
	  whiteList['border-left-color'] = true; // default: current color
	  whiteList['border-left-style'] = true; // default: none
	  whiteList['border-left-width'] = true; // default: medium
	  whiteList['border-radius'] = true; // default: 0
	  whiteList['border-right'] = true; // default: depending on individual properties
	  whiteList['border-right-color'] = true; // default: current color
	  whiteList['border-right-style'] = true; // default: none
	  whiteList['border-right-width'] = true; // default: medium
	  whiteList['border-spacing'] = true; // default: 0
	  whiteList['border-style'] = true; // default: depending on individual properties
	  whiteList['border-top'] = true; // default: depending on individual properties
	  whiteList['border-top-color'] = true; // default: current color
	  whiteList['border-top-left-radius'] = true; // default: 0
	  whiteList['border-top-right-radius'] = true; // default: 0
	  whiteList['border-top-style'] = true; // default: none
	  whiteList['border-top-width'] = true; // default: medium
	  whiteList['border-width'] = true; // default: depending on individual properties
	  whiteList['bottom'] = false; // default: auto
	  whiteList['box-decoration-break'] = true; // default: slice
	  whiteList['box-shadow'] = true; // default: none
	  whiteList['box-sizing'] = true; // default: content-box
	  whiteList['box-snap'] = true; // default: none
	  whiteList['box-suppress'] = true; // default: show
	  whiteList['break-after'] = true; // default: auto
	  whiteList['break-before'] = true; // default: auto
	  whiteList['break-inside'] = true; // default: auto
	  whiteList['caption-side'] = false; // default: top
	  whiteList['chains'] = false; // default: none
	  whiteList['clear'] = true; // default: none
	  whiteList['clip'] = false; // default: auto
	  whiteList['clip-path'] = false; // default: none
	  whiteList['clip-rule'] = false; // default: nonzero
	  whiteList['color'] = true; // default: implementation dependent
	  whiteList['color-interpolation-filters'] = true; // default: auto
	  whiteList['column-count'] = false; // default: auto
	  whiteList['column-fill'] = false; // default: balance
	  whiteList['column-gap'] = false; // default: normal
	  whiteList['column-rule'] = false; // default: depending on individual properties
	  whiteList['column-rule-color'] = false; // default: current color
	  whiteList['column-rule-style'] = false; // default: medium
	  whiteList['column-rule-width'] = false; // default: medium
	  whiteList['column-span'] = false; // default: none
	  whiteList['column-width'] = false; // default: auto
	  whiteList['columns'] = false; // default: depending on individual properties
	  whiteList['contain'] = false; // default: none
	  whiteList['content'] = false; // default: normal
	  whiteList['counter-increment'] = false; // default: none
	  whiteList['counter-reset'] = false; // default: none
	  whiteList['counter-set'] = false; // default: none
	  whiteList['crop'] = false; // default: auto
	  whiteList['cue'] = false; // default: depending on individual properties
	  whiteList['cue-after'] = false; // default: none
	  whiteList['cue-before'] = false; // default: none
	  whiteList['cursor'] = false; // default: auto
	  whiteList['direction'] = false; // default: ltr
	  whiteList['display'] = true; // default: depending on individual properties
	  whiteList['display-inside'] = true; // default: auto
	  whiteList['display-list'] = true; // default: none
	  whiteList['display-outside'] = true; // default: inline-level
	  whiteList['dominant-baseline'] = false; // default: auto
	  whiteList['elevation'] = false; // default: level
	  whiteList['empty-cells'] = false; // default: show
	  whiteList['filter'] = false; // default: none
	  whiteList['flex'] = false; // default: depending on individual properties
	  whiteList['flex-basis'] = false; // default: auto
	  whiteList['flex-direction'] = false; // default: row
	  whiteList['flex-flow'] = false; // default: depending on individual properties
	  whiteList['flex-grow'] = false; // default: 0
	  whiteList['flex-shrink'] = false; // default: 1
	  whiteList['flex-wrap'] = false; // default: nowrap
	  whiteList['float'] = false; // default: none
	  whiteList['float-offset'] = false; // default: 0 0
	  whiteList['flood-color'] = false; // default: black
	  whiteList['flood-opacity'] = false; // default: 1
	  whiteList['flow-from'] = false; // default: none
	  whiteList['flow-into'] = false; // default: none
	  whiteList['font'] = true; // default: depending on individual properties
	  whiteList['font-family'] = true; // default: implementation dependent
	  whiteList['font-feature-settings'] = true; // default: normal
	  whiteList['font-kerning'] = true; // default: auto
	  whiteList['font-language-override'] = true; // default: normal
	  whiteList['font-size'] = true; // default: medium
	  whiteList['font-size-adjust'] = true; // default: none
	  whiteList['font-stretch'] = true; // default: normal
	  whiteList['font-style'] = true; // default: normal
	  whiteList['font-synthesis'] = true; // default: weight style
	  whiteList['font-variant'] = true; // default: normal
	  whiteList['font-variant-alternates'] = true; // default: normal
	  whiteList['font-variant-caps'] = true; // default: normal
	  whiteList['font-variant-east-asian'] = true; // default: normal
	  whiteList['font-variant-ligatures'] = true; // default: normal
	  whiteList['font-variant-numeric'] = true; // default: normal
	  whiteList['font-variant-position'] = true; // default: normal
	  whiteList['font-weight'] = true; // default: normal
	  whiteList['grid'] = false; // default: depending on individual properties
	  whiteList['grid-area'] = false; // default: depending on individual properties
	  whiteList['grid-auto-columns'] = false; // default: auto
	  whiteList['grid-auto-flow'] = false; // default: none
	  whiteList['grid-auto-rows'] = false; // default: auto
	  whiteList['grid-column'] = false; // default: depending on individual properties
	  whiteList['grid-column-end'] = false; // default: auto
	  whiteList['grid-column-start'] = false; // default: auto
	  whiteList['grid-row'] = false; // default: depending on individual properties
	  whiteList['grid-row-end'] = false; // default: auto
	  whiteList['grid-row-start'] = false; // default: auto
	  whiteList['grid-template'] = false; // default: depending on individual properties
	  whiteList['grid-template-areas'] = false; // default: none
	  whiteList['grid-template-columns'] = false; // default: none
	  whiteList['grid-template-rows'] = false; // default: none
	  whiteList['hanging-punctuation'] = false; // default: none
	  whiteList['height'] = true; // default: auto
	  whiteList['hyphens'] = false; // default: manual
	  whiteList['icon'] = false; // default: auto
	  whiteList['image-orientation'] = false; // default: auto
	  whiteList['image-resolution'] = false; // default: normal
	  whiteList['ime-mode'] = false; // default: auto
	  whiteList['initial-letters'] = false; // default: normal
	  whiteList['inline-box-align'] = false; // default: last
	  whiteList['justify-content'] = false; // default: auto
	  whiteList['justify-items'] = false; // default: auto
	  whiteList['justify-self'] = false; // default: auto
	  whiteList['left'] = false; // default: auto
	  whiteList['letter-spacing'] = true; // default: normal
	  whiteList['lighting-color'] = true; // default: white
	  whiteList['line-box-contain'] = false; // default: block inline replaced
	  whiteList['line-break'] = false; // default: auto
	  whiteList['line-grid'] = false; // default: match-parent
	  whiteList['line-height'] = false; // default: normal
	  whiteList['line-snap'] = false; // default: none
	  whiteList['line-stacking'] = false; // default: depending on individual properties
	  whiteList['line-stacking-ruby'] = false; // default: exclude-ruby
	  whiteList['line-stacking-shift'] = false; // default: consider-shifts
	  whiteList['line-stacking-strategy'] = false; // default: inline-line-height
	  whiteList['list-style'] = true; // default: depending on individual properties
	  whiteList['list-style-image'] = true; // default: none
	  whiteList['list-style-position'] = true; // default: outside
	  whiteList['list-style-type'] = true; // default: disc
	  whiteList['margin'] = true; // default: depending on individual properties
	  whiteList['margin-bottom'] = true; // default: 0
	  whiteList['margin-left'] = true; // default: 0
	  whiteList['margin-right'] = true; // default: 0
	  whiteList['margin-top'] = true; // default: 0
	  whiteList['marker-offset'] = false; // default: auto
	  whiteList['marker-side'] = false; // default: list-item
	  whiteList['marks'] = false; // default: none
	  whiteList['mask'] = false; // default: border-box
	  whiteList['mask-box'] = false; // default: see individual properties
	  whiteList['mask-box-outset'] = false; // default: 0
	  whiteList['mask-box-repeat'] = false; // default: stretch
	  whiteList['mask-box-slice'] = false; // default: 0 fill
	  whiteList['mask-box-source'] = false; // default: none
	  whiteList['mask-box-width'] = false; // default: auto
	  whiteList['mask-clip'] = false; // default: border-box
	  whiteList['mask-image'] = false; // default: none
	  whiteList['mask-origin'] = false; // default: border-box
	  whiteList['mask-position'] = false; // default: center
	  whiteList['mask-repeat'] = false; // default: no-repeat
	  whiteList['mask-size'] = false; // default: border-box
	  whiteList['mask-source-type'] = false; // default: auto
	  whiteList['mask-type'] = false; // default: luminance
	  whiteList['max-height'] = true; // default: none
	  whiteList['max-lines'] = false; // default: none
	  whiteList['max-width'] = true; // default: none
	  whiteList['min-height'] = true; // default: 0
	  whiteList['min-width'] = true; // default: 0
	  whiteList['move-to'] = false; // default: normal
	  whiteList['nav-down'] = false; // default: auto
	  whiteList['nav-index'] = false; // default: auto
	  whiteList['nav-left'] = false; // default: auto
	  whiteList['nav-right'] = false; // default: auto
	  whiteList['nav-up'] = false; // default: auto
	  whiteList['object-fit'] = false; // default: fill
	  whiteList['object-position'] = false; // default: 50% 50%
	  whiteList['opacity'] = false; // default: 1
	  whiteList['order'] = false; // default: 0
	  whiteList['orphans'] = false; // default: 2
	  whiteList['outline'] = false; // default: depending on individual properties
	  whiteList['outline-color'] = false; // default: invert
	  whiteList['outline-offset'] = false; // default: 0
	  whiteList['outline-style'] = false; // default: none
	  whiteList['outline-width'] = false; // default: medium
	  whiteList['overflow'] = false; // default: depending on individual properties
	  whiteList['overflow-wrap'] = false; // default: normal
	  whiteList['overflow-x'] = false; // default: visible
	  whiteList['overflow-y'] = false; // default: visible
	  whiteList['padding'] = true; // default: depending on individual properties
	  whiteList['padding-bottom'] = true; // default: 0
	  whiteList['padding-left'] = true; // default: 0
	  whiteList['padding-right'] = true; // default: 0
	  whiteList['padding-top'] = true; // default: 0
	  whiteList['page'] = false; // default: auto
	  whiteList['page-break-after'] = false; // default: auto
	  whiteList['page-break-before'] = false; // default: auto
	  whiteList['page-break-inside'] = false; // default: auto
	  whiteList['page-policy'] = false; // default: start
	  whiteList['pause'] = false; // default: implementation dependent
	  whiteList['pause-after'] = false; // default: implementation dependent
	  whiteList['pause-before'] = false; // default: implementation dependent
	  whiteList['perspective'] = false; // default: none
	  whiteList['perspective-origin'] = false; // default: 50% 50%
	  whiteList['pitch'] = false; // default: medium
	  whiteList['pitch-range'] = false; // default: 50
	  whiteList['play-during'] = false; // default: auto
	  whiteList['position'] = false; // default: static
	  whiteList['presentation-level'] = false; // default: 0
	  whiteList['quotes'] = false; // default: text
	  whiteList['region-fragment'] = false; // default: auto
	  whiteList['resize'] = false; // default: none
	  whiteList['rest'] = false; // default: depending on individual properties
	  whiteList['rest-after'] = false; // default: none
	  whiteList['rest-before'] = false; // default: none
	  whiteList['richness'] = false; // default: 50
	  whiteList['right'] = false; // default: auto
	  whiteList['rotation'] = false; // default: 0
	  whiteList['rotation-point'] = false; // default: 50% 50%
	  whiteList['ruby-align'] = false; // default: auto
	  whiteList['ruby-merge'] = false; // default: separate
	  whiteList['ruby-position'] = false; // default: before
	  whiteList['shape-image-threshold'] = false; // default: 0.0
	  whiteList['shape-outside'] = false; // default: none
	  whiteList['shape-margin'] = false; // default: 0
	  whiteList['size'] = false; // default: auto
	  whiteList['speak'] = false; // default: auto
	  whiteList['speak-as'] = false; // default: normal
	  whiteList['speak-header'] = false; // default: once
	  whiteList['speak-numeral'] = false; // default: continuous
	  whiteList['speak-punctuation'] = false; // default: none
	  whiteList['speech-rate'] = false; // default: medium
	  whiteList['stress'] = false; // default: 50
	  whiteList['string-set'] = false; // default: none
	  whiteList['tab-size'] = false; // default: 8
	  whiteList['table-layout'] = false; // default: auto
	  whiteList['text-align'] = true; // default: start
	  whiteList['text-align-last'] = true; // default: auto
	  whiteList['text-combine-upright'] = true; // default: none
	  whiteList['text-decoration'] = true; // default: none
	  whiteList['text-decoration-color'] = true; // default: currentColor
	  whiteList['text-decoration-line'] = true; // default: none
	  whiteList['text-decoration-skip'] = true; // default: objects
	  whiteList['text-decoration-style'] = true; // default: solid
	  whiteList['text-emphasis'] = true; // default: depending on individual properties
	  whiteList['text-emphasis-color'] = true; // default: currentColor
	  whiteList['text-emphasis-position'] = true; // default: over right
	  whiteList['text-emphasis-style'] = true; // default: none
	  whiteList['text-height'] = true; // default: auto
	  whiteList['text-indent'] = true; // default: 0
	  whiteList['text-justify'] = true; // default: auto
	  whiteList['text-orientation'] = true; // default: mixed
	  whiteList['text-overflow'] = true; // default: clip
	  whiteList['text-shadow'] = true; // default: none
	  whiteList['text-space-collapse'] = true; // default: collapse
	  whiteList['text-transform'] = true; // default: none
	  whiteList['text-underline-position'] = true; // default: auto
	  whiteList['text-wrap'] = true; // default: normal
	  whiteList['top'] = false; // default: auto
	  whiteList['transform'] = false; // default: none
	  whiteList['transform-origin'] = false; // default: 50% 50% 0
	  whiteList['transform-style'] = false; // default: flat
	  whiteList['transition'] = false; // default: depending on individual properties
	  whiteList['transition-delay'] = false; // default: 0s
	  whiteList['transition-duration'] = false; // default: 0s
	  whiteList['transition-property'] = false; // default: all
	  whiteList['transition-timing-function'] = false; // default: ease
	  whiteList['unicode-bidi'] = false; // default: normal
	  whiteList['vertical-align'] = false; // default: baseline
	  whiteList['visibility'] = false; // default: visible
	  whiteList['voice-balance'] = false; // default: center
	  whiteList['voice-duration'] = false; // default: auto
	  whiteList['voice-family'] = false; // default: implementation dependent
	  whiteList['voice-pitch'] = false; // default: medium
	  whiteList['voice-range'] = false; // default: medium
	  whiteList['voice-rate'] = false; // default: normal
	  whiteList['voice-stress'] = false; // default: normal
	  whiteList['voice-volume'] = false; // default: medium
	  whiteList['volume'] = false; // default: medium
	  whiteList['white-space'] = false; // default: normal
	  whiteList['widows'] = false; // default: 2
	  whiteList['width'] = true; // default: auto
	  whiteList['will-change'] = false; // default: auto
	  whiteList['word-break'] = true; // default: normal
	  whiteList['word-spacing'] = true; // default: normal
	  whiteList['word-wrap'] = true; // default: normal
	  whiteList['wrap-flow'] = false; // default: auto
	  whiteList['wrap-through'] = false; // default: wrap
	  whiteList['writing-mode'] = false; // default: horizontal-tb
	  whiteList['z-index'] = false; // default: auto

	  return whiteList;
	}


	/**
	 * 匹配到白名单上的一个属性时
	 *
	 * @param {String} name
	 * @param {String} value
	 * @param {Object} options
	 * @return {String}
	 */
	function onAttr (name, value, options) {
	  // do nothing
	}

	/**
	 * 匹配到不在白名单上的一个属性时
	 *
	 * @param {String} name
	 * @param {String} value
	 * @param {Object} options
	 * @return {String}
	 */
	function onIgnoreAttr (name, value, options) {
	  // do nothing
	}

	var REGEXP_URL_JAVASCRIPT = /javascript\s*\:/img;

	/**
	 * 过滤属性值
	 *
	 * @param {String} name
	 * @param {String} value
	 * @return {String}
	 */
	function safeAttrValue$1(name, value) {
	  if (REGEXP_URL_JAVASCRIPT.test(value)) return '';
	  return value;
	}


	_default.whiteList = getDefaultWhiteList$1();
	_default.getDefaultWhiteList = getDefaultWhiteList$1;
	_default.onAttr = onAttr;
	_default.onIgnoreAttr = onIgnoreAttr;
	_default.safeAttrValue = safeAttrValue$1;

	var util$1 = {
	  indexOf: function (arr, item) {
	    var i, j;
	    if (Array.prototype.indexOf) {
	      return arr.indexOf(item);
	    }
	    for (i = 0, j = arr.length; i < j; i++) {
	      if (arr[i] === item) {
	        return i;
	      }
	    }
	    return -1;
	  },
	  forEach: function (arr, fn, scope) {
	    var i, j;
	    if (Array.prototype.forEach) {
	      return arr.forEach(fn, scope);
	    }
	    for (i = 0, j = arr.length; i < j; i++) {
	      fn.call(scope, arr[i], i, arr);
	    }
	  },
	  trim: function (str) {
	    if (String.prototype.trim) {
	      return str.trim();
	    }
	    return str.replace(/(^\s*)|(\s*$)/g, '');
	  },
	  trimRight: function (str) {
	    if (String.prototype.trimRight) {
	      return str.trimRight();
	    }
	    return str.replace(/(\s*$)/g, '');
	  }
	};

	/**
	 * cssfilter
	 *
	 * @author 老雷<leizongmin@gmail.com>
	 */

	var _$3 = util$1;


	/**
	 * 解析style
	 *
	 * @param {String} css
	 * @param {Function} onAttr 处理属性的函数
	 *   参数格式： function (sourcePosition, position, name, value, source)
	 * @return {String}
	 */
	function parseStyle$1 (css, onAttr) {
	  css = _$3.trimRight(css);
	  if (css[css.length - 1] !== ';') css += ';';
	  var cssLength = css.length;
	  var isParenthesisOpen = false;
	  var lastPos = 0;
	  var i = 0;
	  var retCSS = '';

	  function addNewAttr () {
	    // 如果没有正常的闭合圆括号，则直接忽略当前属性
	    if (!isParenthesisOpen) {
	      var source = _$3.trim(css.slice(lastPos, i));
	      var j = source.indexOf(':');
	      if (j !== -1) {
	        var name = _$3.trim(source.slice(0, j));
	        var value = _$3.trim(source.slice(j + 1));
	        // 必须有属性名称
	        if (name) {
	          var ret = onAttr(lastPos, retCSS.length, name, value, source);
	          if (ret) retCSS += ret + '; ';
	        }
	      }
	    }
	    lastPos = i + 1;
	  }

	  for (; i < cssLength; i++) {
	    var c = css[i];
	    if (c === '/' && css[i + 1] === '*') {
	      // 备注开始
	      var j = css.indexOf('*/', i + 2);
	      // 如果没有正常的备注结束，则后面的部分全部跳过
	      if (j === -1) break;
	      // 直接将当前位置调到备注结尾，并且初始化状态
	      i = j + 1;
	      lastPos = i + 1;
	      isParenthesisOpen = false;
	    } else if (c === '(') {
	      isParenthesisOpen = true;
	    } else if (c === ')') {
	      isParenthesisOpen = false;
	    } else if (c === ';') {
	      if (isParenthesisOpen) ; else {
	        addNewAttr();
	      }
	    } else if (c === '\n') {
	      addNewAttr();
	    }
	  }

	  return _$3.trim(retCSS);
	}

	var parser$2 = parseStyle$1;

	/**
	 * cssfilter
	 *
	 * @author 老雷<leizongmin@gmail.com>
	 */

	var DEFAULT$1 = _default;
	var parseStyle = parser$2;


	/**
	 * 返回值是否为空
	 *
	 * @param {Object} obj
	 * @return {Boolean}
	 */
	function isNull$1 (obj) {
	  return (obj === undefined || obj === null);
	}

	/**
	 * 浅拷贝对象
	 *
	 * @param {Object} obj
	 * @return {Object}
	 */
	function shallowCopyObject$1 (obj) {
	  var ret = {};
	  for (var i in obj) {
	    ret[i] = obj[i];
	  }
	  return ret;
	}

	/**
	 * 创建CSS过滤器
	 *
	 * @param {Object} options
	 *   - {Object} whiteList
	 *   - {Function} onAttr
	 *   - {Function} onIgnoreAttr
	 *   - {Function} safeAttrValue
	 */
	function FilterCSS$2 (options) {
	  options = shallowCopyObject$1(options || {});
	  options.whiteList = options.whiteList || DEFAULT$1.whiteList;
	  options.onAttr = options.onAttr || DEFAULT$1.onAttr;
	  options.onIgnoreAttr = options.onIgnoreAttr || DEFAULT$1.onIgnoreAttr;
	  options.safeAttrValue = options.safeAttrValue || DEFAULT$1.safeAttrValue;
	  this.options = options;
	}

	FilterCSS$2.prototype.process = function (css) {
	  // 兼容各种奇葩输入
	  css = css || '';
	  css = css.toString();
	  if (!css) return '';

	  var me = this;
	  var options = me.options;
	  var whiteList = options.whiteList;
	  var onAttr = options.onAttr;
	  var onIgnoreAttr = options.onIgnoreAttr;
	  var safeAttrValue = options.safeAttrValue;

	  var retCSS = parseStyle(css, function (sourcePosition, position, name, value, source) {

	    var check = whiteList[name];
	    var isWhite = false;
	    if (check === true) isWhite = check;
	    else if (typeof check === 'function') isWhite = check(value);
	    else if (check instanceof RegExp) isWhite = check.test(value);
	    if (isWhite !== true) isWhite = false;

	    // 如果过滤后 value 为空则直接忽略
	    value = safeAttrValue(name, value);
	    if (!value) return;

	    var opts = {
	      position: position,
	      sourcePosition: sourcePosition,
	      source: source,
	      isWhite: isWhite
	    };

	    if (isWhite) {

	      var ret = onAttr(name, value, opts);
	      if (isNull$1(ret)) {
	        return name + ':' + value;
	      } else {
	        return ret;
	      }

	    } else {

	      var ret = onIgnoreAttr(name, value, opts);
	      if (!isNull$1(ret)) {
	        return ret;
	      }

	    }
	  });

	  return retCSS;
	};


	var css = FilterCSS$2;

	/**
	 * cssfilter
	 *
	 * @author 老雷<leizongmin@gmail.com>
	 */

	(function (module, exports) {
		var DEFAULT = _default;
		var FilterCSS = css;


		/**
		 * XSS过滤
		 *
		 * @param {String} css 要过滤的CSS代码
		 * @param {Object} options 选项：whiteList, onAttr, onIgnoreAttr
		 * @return {String}
		 */
		function filterCSS (html, options) {
		  var xss = new FilterCSS(options);
		  return xss.process(html);
		}


		// 输出
		exports = module.exports = filterCSS;
		exports.FilterCSS = FilterCSS;
		for (var i in DEFAULT) exports[i] = DEFAULT[i];

		// 在浏览器端使用
		if (typeof window !== 'undefined') {
		  window.filterCSS = module.exports;
		}
	} (lib, libExports));

	var util = {
	  indexOf: function (arr, item) {
	    var i, j;
	    if (Array.prototype.indexOf) {
	      return arr.indexOf(item);
	    }
	    for (i = 0, j = arr.length; i < j; i++) {
	      if (arr[i] === item) {
	        return i;
	      }
	    }
	    return -1;
	  },
	  forEach: function (arr, fn, scope) {
	    var i, j;
	    if (Array.prototype.forEach) {
	      return arr.forEach(fn, scope);
	    }
	    for (i = 0, j = arr.length; i < j; i++) {
	      fn.call(scope, arr[i], i, arr);
	    }
	  },
	  trim: function (str) {
	    if (String.prototype.trim) {
	      return str.trim();
	    }
	    return str.replace(/(^\s*)|(\s*$)/g, "");
	  },
	  spaceIndex: function (str) {
	    var reg = /\s|\n|\t/;
	    var match = reg.exec(str);
	    return match ? match.index : -1;
	  },
	};

	/**
	 * default settings
	 *
	 * @author Zongmin Lei<leizongmin@gmail.com>
	 */

	var FilterCSS$1 = libExports.FilterCSS;
	var getDefaultCSSWhiteList = libExports.getDefaultWhiteList;
	var _$2 = util;

	function getDefaultWhiteList() {
	  return {
	    a: ["target", "href", "title"],
	    abbr: ["title"],
	    address: [],
	    area: ["shape", "coords", "href", "alt"],
	    article: [],
	    aside: [],
	    audio: [
	      "autoplay",
	      "controls",
	      "crossorigin",
	      "loop",
	      "muted",
	      "preload",
	      "src",
	    ],
	    b: [],
	    bdi: ["dir"],
	    bdo: ["dir"],
	    big: [],
	    blockquote: ["cite"],
	    br: [],
	    caption: [],
	    center: [],
	    cite: [],
	    code: [],
	    col: ["align", "valign", "span", "width"],
	    colgroup: ["align", "valign", "span", "width"],
	    dd: [],
	    del: ["datetime"],
	    details: ["open"],
	    div: [],
	    dl: [],
	    dt: [],
	    em: [],
	    figcaption: [],
	    figure: [],
	    font: ["color", "size", "face"],
	    footer: [],
	    h1: [],
	    h2: [],
	    h3: [],
	    h4: [],
	    h5: [],
	    h6: [],
	    header: [],
	    hr: [],
	    i: [],
	    img: ["src", "alt", "title", "width", "height"],
	    ins: ["datetime"],
	    li: [],
	    mark: [],
	    nav: [],
	    ol: [],
	    p: [],
	    pre: [],
	    s: [],
	    section: [],
	    small: [],
	    span: [],
	    sub: [],
	    summary: [],
	    sup: [],
	    strong: [],
	    strike: [],
	    table: ["width", "border", "align", "valign"],
	    tbody: ["align", "valign"],
	    td: ["width", "rowspan", "colspan", "align", "valign"],
	    tfoot: ["align", "valign"],
	    th: ["width", "rowspan", "colspan", "align", "valign"],
	    thead: ["align", "valign"],
	    tr: ["rowspan", "align", "valign"],
	    tt: [],
	    u: [],
	    ul: [],
	    video: [
	      "autoplay",
	      "controls",
	      "crossorigin",
	      "loop",
	      "muted",
	      "playsinline",
	      "poster",
	      "preload",
	      "src",
	      "height",
	      "width",
	    ],
	  };
	}

	var defaultCSSFilter = new FilterCSS$1();

	/**
	 * default onTag function
	 *
	 * @param {String} tag
	 * @param {String} html
	 * @param {Object} options
	 * @return {String}
	 */
	function onTag(tag, html, options) {
	  // do nothing
	}

	/**
	 * default onIgnoreTag function
	 *
	 * @param {String} tag
	 * @param {String} html
	 * @param {Object} options
	 * @return {String}
	 */
	function onIgnoreTag(tag, html, options) {
	  // do nothing
	}

	/**
	 * default onTagAttr function
	 *
	 * @param {String} tag
	 * @param {String} name
	 * @param {String} value
	 * @return {String}
	 */
	function onTagAttr(tag, name, value) {
	  // do nothing
	}

	/**
	 * default onIgnoreTagAttr function
	 *
	 * @param {String} tag
	 * @param {String} name
	 * @param {String} value
	 * @return {String}
	 */
	function onIgnoreTagAttr(tag, name, value) {
	  // do nothing
	}

	/**
	 * default escapeHtml function
	 *
	 * @param {String} html
	 */
	function escapeHtml(html) {
	  return html.replace(REGEXP_LT, "&lt;").replace(REGEXP_GT, "&gt;");
	}

	/**
	 * default safeAttrValue function
	 *
	 * @param {String} tag
	 * @param {String} name
	 * @param {String} value
	 * @param {Object} cssFilter
	 * @return {String}
	 */
	function safeAttrValue(tag, name, value, cssFilter) {
	  // unescape attribute value firstly
	  value = friendlyAttrValue(value);

	  if (name === "href" || name === "src") {
	    // filter `href` and `src` attribute
	    // only allow the value that starts with `http://` | `https://` | `mailto:` | `/` | `#`
	    value = _$2.trim(value);
	    if (value === "#") return "#";
	    if (
	      !(
	        value.substr(0, 7) === "http://" ||
	        value.substr(0, 8) === "https://" ||
	        value.substr(0, 7) === "mailto:" ||
	        value.substr(0, 4) === "tel:" ||
	        value.substr(0, 11) === "data:image/" ||
	        value.substr(0, 6) === "ftp://" ||
	        value.substr(0, 2) === "./" ||
	        value.substr(0, 3) === "../" ||
	        value[0] === "#" ||
	        value[0] === "/"
	      )
	    ) {
	      return "";
	    }
	  } else if (name === "background") {
	    // filter `background` attribute (maybe no use)
	    // `javascript:`
	    REGEXP_DEFAULT_ON_TAG_ATTR_4.lastIndex = 0;
	    if (REGEXP_DEFAULT_ON_TAG_ATTR_4.test(value)) {
	      return "";
	    }
	  } else if (name === "style") {
	    // `expression()`
	    REGEXP_DEFAULT_ON_TAG_ATTR_7.lastIndex = 0;
	    if (REGEXP_DEFAULT_ON_TAG_ATTR_7.test(value)) {
	      return "";
	    }
	    // `url()`
	    REGEXP_DEFAULT_ON_TAG_ATTR_8.lastIndex = 0;
	    if (REGEXP_DEFAULT_ON_TAG_ATTR_8.test(value)) {
	      REGEXP_DEFAULT_ON_TAG_ATTR_4.lastIndex = 0;
	      if (REGEXP_DEFAULT_ON_TAG_ATTR_4.test(value)) {
	        return "";
	      }
	    }
	    if (cssFilter !== false) {
	      cssFilter = cssFilter || defaultCSSFilter;
	      value = cssFilter.process(value);
	    }
	  }

	  // escape `<>"` before returns
	  value = escapeAttrValue(value);
	  return value;
	}

	// RegExp list
	var REGEXP_LT = /</g;
	var REGEXP_GT = />/g;
	var REGEXP_QUOTE = /"/g;
	var REGEXP_QUOTE_2 = /&quot;/g;
	var REGEXP_ATTR_VALUE_1 = /&#([a-zA-Z0-9]*);?/gim;
	var REGEXP_ATTR_VALUE_COLON = /&colon;?/gim;
	var REGEXP_ATTR_VALUE_NEWLINE = /&newline;?/gim;
	// var REGEXP_DEFAULT_ON_TAG_ATTR_3 = /\/\*|\*\//gm;
	var REGEXP_DEFAULT_ON_TAG_ATTR_4 =
	  /((j\s*a\s*v\s*a|v\s*b|l\s*i\s*v\s*e)\s*s\s*c\s*r\s*i\s*p\s*t\s*|m\s*o\s*c\s*h\s*a):/gi;
	// var REGEXP_DEFAULT_ON_TAG_ATTR_5 = /^[\s"'`]*(d\s*a\s*t\s*a\s*)\:/gi;
	// var REGEXP_DEFAULT_ON_TAG_ATTR_6 = /^[\s"'`]*(d\s*a\s*t\s*a\s*)\:\s*image\//gi;
	var REGEXP_DEFAULT_ON_TAG_ATTR_7 =
	  /e\s*x\s*p\s*r\s*e\s*s\s*s\s*i\s*o\s*n\s*\(.*/gi;
	var REGEXP_DEFAULT_ON_TAG_ATTR_8 = /u\s*r\s*l\s*\(.*/gi;

	/**
	 * escape double quote
	 *
	 * @param {String} str
	 * @return {String} str
	 */
	function escapeQuote(str) {
	  return str.replace(REGEXP_QUOTE, "&quot;");
	}

	/**
	 * unescape double quote
	 *
	 * @param {String} str
	 * @return {String} str
	 */
	function unescapeQuote(str) {
	  return str.replace(REGEXP_QUOTE_2, '"');
	}

	/**
	 * escape html entities
	 *
	 * @param {String} str
	 * @return {String}
	 */
	function escapeHtmlEntities(str) {
	  return str.replace(REGEXP_ATTR_VALUE_1, function replaceUnicode(str, code) {
	    return code[0] === "x" || code[0] === "X"
	      ? String.fromCharCode(parseInt(code.substr(1), 16))
	      : String.fromCharCode(parseInt(code, 10));
	  });
	}

	/**
	 * escape html5 new danger entities
	 *
	 * @param {String} str
	 * @return {String}
	 */
	function escapeDangerHtml5Entities(str) {
	  return str
	    .replace(REGEXP_ATTR_VALUE_COLON, ":")
	    .replace(REGEXP_ATTR_VALUE_NEWLINE, " ");
	}

	/**
	 * clear nonprintable characters
	 *
	 * @param {String} str
	 * @return {String}
	 */
	function clearNonPrintableCharacter(str) {
	  var str2 = "";
	  for (var i = 0, len = str.length; i < len; i++) {
	    str2 += str.charCodeAt(i) < 32 ? " " : str.charAt(i);
	  }
	  return _$2.trim(str2);
	}

	/**
	 * get friendly attribute value
	 *
	 * @param {String} str
	 * @return {String}
	 */
	function friendlyAttrValue(str) {
	  str = unescapeQuote(str);
	  str = escapeHtmlEntities(str);
	  str = escapeDangerHtml5Entities(str);
	  str = clearNonPrintableCharacter(str);
	  return str;
	}

	/**
	 * unescape attribute value
	 *
	 * @param {String} str
	 * @return {String}
	 */
	function escapeAttrValue(str) {
	  str = escapeQuote(str);
	  str = escapeHtml(str);
	  return str;
	}

	/**
	 * `onIgnoreTag` function for removing all the tags that are not in whitelist
	 */
	function onIgnoreTagStripAll() {
	  return "";
	}

	/**
	 * remove tag body
	 * specify a `tags` list, if the tag is not in the `tags` list then process by the specify function (optional)
	 *
	 * @param {array} tags
	 * @param {function} next
	 */
	function StripTagBody(tags, next) {
	  if (typeof next !== "function") {
	    next = function () {};
	  }

	  var isRemoveAllTag = !Array.isArray(tags);
	  function isRemoveTag(tag) {
	    if (isRemoveAllTag) return true;
	    return _$2.indexOf(tags, tag) !== -1;
	  }

	  var removeList = [];
	  var posStart = false;

	  return {
	    onIgnoreTag: function (tag, html, options) {
	      if (isRemoveTag(tag)) {
	        if (options.isClosing) {
	          var ret = "[/removed]";
	          var end = options.position + ret.length;
	          removeList.push([
	            posStart !== false ? posStart : options.position,
	            end,
	          ]);
	          posStart = false;
	          return ret;
	        } else {
	          if (!posStart) {
	            posStart = options.position;
	          }
	          return "[removed]";
	        }
	      } else {
	        return next(tag, html, options);
	      }
	    },
	    remove: function (html) {
	      var rethtml = "";
	      var lastPos = 0;
	      _$2.forEach(removeList, function (pos) {
	        rethtml += html.slice(lastPos, pos[0]);
	        lastPos = pos[1];
	      });
	      rethtml += html.slice(lastPos);
	      return rethtml;
	    },
	  };
	}

	/**
	 * remove html comments
	 *
	 * @param {String} html
	 * @return {String}
	 */
	function stripCommentTag(html) {
	  var retHtml = "";
	  var lastPos = 0;
	  while (lastPos < html.length) {
	    var i = html.indexOf("<!--", lastPos);
	    if (i === -1) {
	      retHtml += html.slice(lastPos);
	      break;
	    }
	    retHtml += html.slice(lastPos, i);
	    var j = html.indexOf("-->", i);
	    if (j === -1) {
	      break;
	    }
	    lastPos = j + 3;
	  }
	  return retHtml;
	}

	/**
	 * remove invisible characters
	 *
	 * @param {String} html
	 * @return {String}
	 */
	function stripBlankChar(html) {
	  var chars = html.split("");
	  chars = chars.filter(function (char) {
	    var c = char.charCodeAt(0);
	    if (c === 127) return false;
	    if (c <= 31) {
	      if (c === 10 || c === 13) return true;
	      return false;
	    }
	    return true;
	  });
	  return chars.join("");
	}

	_default$1.whiteList = getDefaultWhiteList();
	_default$1.getDefaultWhiteList = getDefaultWhiteList;
	_default$1.onTag = onTag;
	_default$1.onIgnoreTag = onIgnoreTag;
	_default$1.onTagAttr = onTagAttr;
	_default$1.onIgnoreTagAttr = onIgnoreTagAttr;
	_default$1.safeAttrValue = safeAttrValue;
	_default$1.escapeHtml = escapeHtml;
	_default$1.escapeQuote = escapeQuote;
	_default$1.unescapeQuote = unescapeQuote;
	_default$1.escapeHtmlEntities = escapeHtmlEntities;
	_default$1.escapeDangerHtml5Entities = escapeDangerHtml5Entities;
	_default$1.clearNonPrintableCharacter = clearNonPrintableCharacter;
	_default$1.friendlyAttrValue = friendlyAttrValue;
	_default$1.escapeAttrValue = escapeAttrValue;
	_default$1.onIgnoreTagStripAll = onIgnoreTagStripAll;
	_default$1.StripTagBody = StripTagBody;
	_default$1.stripCommentTag = stripCommentTag;
	_default$1.stripBlankChar = stripBlankChar;
	_default$1.cssFilter = defaultCSSFilter;
	_default$1.getDefaultCSSWhiteList = getDefaultCSSWhiteList;

	var parser$1 = {};

	/**
	 * Simple HTML Parser
	 *
	 * @author Zongmin Lei<leizongmin@gmail.com>
	 */

	var _$1 = util;

	/**
	 * get tag name
	 *
	 * @param {String} html e.g. '<a hef="#">'
	 * @return {String}
	 */
	function getTagName(html) {
	  var i = _$1.spaceIndex(html);
	  var tagName;
	  if (i === -1) {
	    tagName = html.slice(1, -1);
	  } else {
	    tagName = html.slice(1, i + 1);
	  }
	  tagName = _$1.trim(tagName).toLowerCase();
	  if (tagName.slice(0, 1) === "/") tagName = tagName.slice(1);
	  if (tagName.slice(-1) === "/") tagName = tagName.slice(0, -1);
	  return tagName;
	}

	/**
	 * is close tag?
	 *
	 * @param {String} html 如：'<a hef="#">'
	 * @return {Boolean}
	 */
	function isClosing(html) {
	  return html.slice(0, 2) === "</";
	}

	/**
	 * parse input html and returns processed html
	 *
	 * @param {String} html
	 * @param {Function} onTag e.g. function (sourcePosition, position, tag, html, isClosing)
	 * @param {Function} escapeHtml
	 * @return {String}
	 */
	function parseTag$1(html, onTag, escapeHtml) {

	  var rethtml = "";
	  var lastPos = 0;
	  var tagStart = false;
	  var quoteStart = false;
	  var currentPos = 0;
	  var len = html.length;
	  var currentTagName = "";
	  var currentHtml = "";

	  chariterator: for (currentPos = 0; currentPos < len; currentPos++) {
	    var c = html.charAt(currentPos);
	    if (tagStart === false) {
	      if (c === "<") {
	        tagStart = currentPos;
	        continue;
	      }
	    } else {
	      if (quoteStart === false) {
	        if (c === "<") {
	          rethtml += escapeHtml(html.slice(lastPos, currentPos));
	          tagStart = currentPos;
	          lastPos = currentPos;
	          continue;
	        }
	        if (c === ">" || currentPos === len - 1) {
	          rethtml += escapeHtml(html.slice(lastPos, tagStart));
	          currentHtml = html.slice(tagStart, currentPos + 1);
	          currentTagName = getTagName(currentHtml);
	          rethtml += onTag(
	            tagStart,
	            rethtml.length,
	            currentTagName,
	            currentHtml,
	            isClosing(currentHtml)
	          );
	          lastPos = currentPos + 1;
	          tagStart = false;
	          continue;
	        }
	        if (c === '"' || c === "'") {
	          var i = 1;
	          var ic = html.charAt(currentPos - i);

	          while (ic.trim() === "" || ic === "=") {
	            if (ic === "=") {
	              quoteStart = c;
	              continue chariterator;
	            }
	            ic = html.charAt(currentPos - ++i);
	          }
	        }
	      } else {
	        if (c === quoteStart) {
	          quoteStart = false;
	          continue;
	        }
	      }
	    }
	  }
	  if (lastPos < len) {
	    rethtml += escapeHtml(html.substr(lastPos));
	  }

	  return rethtml;
	}

	var REGEXP_ILLEGAL_ATTR_NAME = /[^a-zA-Z0-9\\_:.-]/gim;

	/**
	 * parse input attributes and returns processed attributes
	 *
	 * @param {String} html e.g. `href="#" target="_blank"`
	 * @param {Function} onAttr e.g. `function (name, value)`
	 * @return {String}
	 */
	function parseAttr$1(html, onAttr) {

	  var lastPos = 0;
	  var lastMarkPos = 0;
	  var retAttrs = [];
	  var tmpName = false;
	  var len = html.length;

	  function addAttr(name, value) {
	    name = _$1.trim(name);
	    name = name.replace(REGEXP_ILLEGAL_ATTR_NAME, "").toLowerCase();
	    if (name.length < 1) return;
	    var ret = onAttr(name, value || "");
	    if (ret) retAttrs.push(ret);
	  }

	  // 逐个分析字符
	  for (var i = 0; i < len; i++) {
	    var c = html.charAt(i);
	    var v, j;
	    if (tmpName === false && c === "=") {
	      tmpName = html.slice(lastPos, i);
	      lastPos = i + 1;
	      lastMarkPos = html.charAt(lastPos) === '"' || html.charAt(lastPos) === "'" ? lastPos : findNextQuotationMark(html, i + 1);
	      continue;
	    }
	    if (tmpName !== false) {
	      if (
	        i === lastMarkPos
	      ) {
	        j = html.indexOf(c, i + 1);
	        if (j === -1) {
	          break;
	        } else {
	          v = _$1.trim(html.slice(lastMarkPos + 1, j));
	          addAttr(tmpName, v);
	          tmpName = false;
	          i = j;
	          lastPos = i + 1;
	          continue;
	        }
	      }
	    }
	    if (/\s|\n|\t/.test(c)) {
	      html = html.replace(/\s|\n|\t/g, " ");
	      if (tmpName === false) {
	        j = findNextEqual(html, i);
	        if (j === -1) {
	          v = _$1.trim(html.slice(lastPos, i));
	          addAttr(v);
	          tmpName = false;
	          lastPos = i + 1;
	          continue;
	        } else {
	          i = j - 1;
	          continue;
	        }
	      } else {
	        j = findBeforeEqual(html, i - 1);
	        if (j === -1) {
	          v = _$1.trim(html.slice(lastPos, i));
	          v = stripQuoteWrap(v);
	          addAttr(tmpName, v);
	          tmpName = false;
	          lastPos = i + 1;
	          continue;
	        } else {
	          continue;
	        }
	      }
	    }
	  }

	  if (lastPos < html.length) {
	    if (tmpName === false) {
	      addAttr(html.slice(lastPos));
	    } else {
	      addAttr(tmpName, stripQuoteWrap(_$1.trim(html.slice(lastPos))));
	    }
	  }

	  return _$1.trim(retAttrs.join(" "));
	}

	function findNextEqual(str, i) {
	  for (; i < str.length; i++) {
	    var c = str[i];
	    if (c === " ") continue;
	    if (c === "=") return i;
	    return -1;
	  }
	}

	function findNextQuotationMark(str, i) {
	  for (; i < str.length; i++) {
	    var c = str[i];
	    if (c === " ") continue;
	    if (c === "'" || c === '"') return i;
	    return -1;
	  }
	}

	function findBeforeEqual(str, i) {
	  for (; i > 0; i--) {
	    var c = str[i];
	    if (c === " ") continue;
	    if (c === "=") return i;
	    return -1;
	  }
	}

	function isQuoteWrapString(text) {
	  if (
	    (text[0] === '"' && text[text.length - 1] === '"') ||
	    (text[0] === "'" && text[text.length - 1] === "'")
	  ) {
	    return true;
	  } else {
	    return false;
	  }
	}

	function stripQuoteWrap(text) {
	  if (isQuoteWrapString(text)) {
	    return text.substr(1, text.length - 2);
	  } else {
	    return text;
	  }
	}

	parser$1.parseTag = parseTag$1;
	parser$1.parseAttr = parseAttr$1;

	/**
	 * filter xss
	 *
	 * @author Zongmin Lei<leizongmin@gmail.com>
	 */

	var FilterCSS = libExports.FilterCSS;
	var DEFAULT = _default$1;
	var parser = parser$1;
	var parseTag = parser.parseTag;
	var parseAttr = parser.parseAttr;
	var _ = util;

	/**
	 * returns `true` if the input value is `undefined` or `null`
	 *
	 * @param {Object} obj
	 * @return {Boolean}
	 */
	function isNull(obj) {
	  return obj === undefined || obj === null;
	}

	/**
	 * get attributes for a tag
	 *
	 * @param {String} html
	 * @return {Object}
	 *   - {String} html
	 *   - {Boolean} closing
	 */
	function getAttrs(html) {
	  var i = _.spaceIndex(html);
	  if (i === -1) {
	    return {
	      html: "",
	      closing: html[html.length - 2] === "/",
	    };
	  }
	  html = _.trim(html.slice(i + 1, -1));
	  var isClosing = html[html.length - 1] === "/";
	  if (isClosing) html = _.trim(html.slice(0, -1));
	  return {
	    html: html,
	    closing: isClosing,
	  };
	}

	/**
	 * shallow copy
	 *
	 * @param {Object} obj
	 * @return {Object}
	 */
	function shallowCopyObject(obj) {
	  var ret = {};
	  for (var i in obj) {
	    ret[i] = obj[i];
	  }
	  return ret;
	}

	function keysToLowerCase(obj) {
	  var ret = {};
	  for (var i in obj) {
	    if (Array.isArray(obj[i])) {
	      ret[i.toLowerCase()] = obj[i].map(function (item) {
	        return item.toLowerCase();
	      });
	    } else {
	      ret[i.toLowerCase()] = obj[i];
	    }
	  }
	  return ret;
	}

	/**
	 * FilterXSS class
	 *
	 * @param {Object} options
	 *        whiteList (or allowList), onTag, onTagAttr, onIgnoreTag,
	 *        onIgnoreTagAttr, safeAttrValue, escapeHtml
	 *        stripIgnoreTagBody, allowCommentTag, stripBlankChar
	 *        css{whiteList, onAttr, onIgnoreAttr} `css=false` means don't use `cssfilter`
	 */
	function FilterXSS(options) {
	  options = shallowCopyObject(options || {});

	  if (options.stripIgnoreTag) {
	    if (options.onIgnoreTag) {
	      console.error(
	        'Notes: cannot use these two options "stripIgnoreTag" and "onIgnoreTag" at the same time'
	      );
	    }
	    options.onIgnoreTag = DEFAULT.onIgnoreTagStripAll;
	  }
	  if (options.whiteList || options.allowList) {
	    options.whiteList = keysToLowerCase(options.whiteList || options.allowList);
	  } else {
	    options.whiteList = DEFAULT.whiteList;
	  }

	  options.onTag = options.onTag || DEFAULT.onTag;
	  options.onTagAttr = options.onTagAttr || DEFAULT.onTagAttr;
	  options.onIgnoreTag = options.onIgnoreTag || DEFAULT.onIgnoreTag;
	  options.onIgnoreTagAttr = options.onIgnoreTagAttr || DEFAULT.onIgnoreTagAttr;
	  options.safeAttrValue = options.safeAttrValue || DEFAULT.safeAttrValue;
	  options.escapeHtml = options.escapeHtml || DEFAULT.escapeHtml;
	  this.options = options;

	  if (options.css === false) {
	    this.cssFilter = false;
	  } else {
	    options.css = options.css || {};
	    this.cssFilter = new FilterCSS(options.css);
	  }
	}

	/**
	 * start process and returns result
	 *
	 * @param {String} html
	 * @return {String}
	 */
	FilterXSS.prototype.process = function (html) {
	  // compatible with the input
	  html = html || "";
	  html = html.toString();
	  if (!html) return "";

	  var me = this;
	  var options = me.options;
	  var whiteList = options.whiteList;
	  var onTag = options.onTag;
	  var onIgnoreTag = options.onIgnoreTag;
	  var onTagAttr = options.onTagAttr;
	  var onIgnoreTagAttr = options.onIgnoreTagAttr;
	  var safeAttrValue = options.safeAttrValue;
	  var escapeHtml = options.escapeHtml;
	  var cssFilter = me.cssFilter;

	  // remove invisible characters
	  if (options.stripBlankChar) {
	    html = DEFAULT.stripBlankChar(html);
	  }

	  // remove html comments
	  if (!options.allowCommentTag) {
	    html = DEFAULT.stripCommentTag(html);
	  }

	  // if enable stripIgnoreTagBody
	  var stripIgnoreTagBody = false;
	  if (options.stripIgnoreTagBody) {
	    stripIgnoreTagBody = DEFAULT.StripTagBody(
	      options.stripIgnoreTagBody,
	      onIgnoreTag
	    );
	    onIgnoreTag = stripIgnoreTagBody.onIgnoreTag;
	  }

	  var retHtml = parseTag(
	    html,
	    function (sourcePosition, position, tag, html, isClosing) {
	      var info = {
	        sourcePosition: sourcePosition,
	        position: position,
	        isClosing: isClosing,
	        isWhite: Object.prototype.hasOwnProperty.call(whiteList, tag),
	      };

	      // call `onTag()`
	      var ret = onTag(tag, html, info);
	      if (!isNull(ret)) return ret;

	      if (info.isWhite) {
	        if (info.isClosing) {
	          return "</" + tag + ">";
	        }

	        var attrs = getAttrs(html);
	        var whiteAttrList = whiteList[tag];
	        var attrsHtml = parseAttr(attrs.html, function (name, value) {
	          // call `onTagAttr()`
	          var isWhiteAttr = _.indexOf(whiteAttrList, name) !== -1;
	          var ret = onTagAttr(tag, name, value, isWhiteAttr);
	          if (!isNull(ret)) return ret;

	          if (isWhiteAttr) {
	            // call `safeAttrValue()`
	            value = safeAttrValue(tag, name, value, cssFilter);
	            if (value) {
	              return name + '="' + value + '"';
	            } else {
	              return name;
	            }
	          } else {
	            // call `onIgnoreTagAttr()`
	            ret = onIgnoreTagAttr(tag, name, value, isWhiteAttr);
	            if (!isNull(ret)) return ret;
	            return;
	          }
	        });

	        // build new tag html
	        html = "<" + tag;
	        if (attrsHtml) html += " " + attrsHtml;
	        if (attrs.closing) html += " /";
	        html += ">";
	        return html;
	      } else {
	        // call `onIgnoreTag()`
	        ret = onIgnoreTag(tag, html, info);
	        if (!isNull(ret)) return ret;
	        return escapeHtml(html);
	      }
	    },
	    escapeHtml
	  );

	  // if enable stripIgnoreTagBody
	  if (stripIgnoreTagBody) {
	    retHtml = stripIgnoreTagBody.remove(retHtml);
	  }

	  return retHtml;
	};

	var xss = FilterXSS;

	/**
	 * xss
	 *
	 * @author Zongmin Lei<leizongmin@gmail.com>
	 */

	(function (module, exports) {
		var DEFAULT = _default$1;
		var parser = parser$1;
		var FilterXSS = xss;

		/**
		 * filter xss function
		 *
		 * @param {String} html
		 * @param {Object} options { whiteList, onTag, onTagAttr, onIgnoreTag, onIgnoreTagAttr, safeAttrValue, escapeHtml }
		 * @return {String}
		 */
		function filterXSS(html, options) {
		  var xss = new FilterXSS(options);
		  return xss.process(html);
		}

		exports = module.exports = filterXSS;
		exports.filterXSS = filterXSS;
		exports.FilterXSS = FilterXSS;

		(function () {
		  for (var i in DEFAULT) {
		    exports[i] = DEFAULT[i];
		  }
		  for (var j in parser) {
		    exports[j] = parser[j];
		  }
		})();

		// using `xss` on the browser, output `filterXSS` to the globals
		if (typeof window !== "undefined") {
		  window.filterXSS = module.exports;
		}

		// using `xss` on the WebWorker, output `filterXSS` to the globals
		function isWorkerEnv() {
		  return (
		    typeof self !== "undefined" &&
		    typeof DedicatedWorkerGlobalScope !== "undefined" &&
		    self instanceof DedicatedWorkerGlobalScope
		  );
		}
		if (isWorkerEnv()) {
		  self.filterXSS = module.exports;
		}
	} (lib$1, libExports$1));

	var xssFilter = libExports$1;

	// Unique ID creation requires a high quality random # generator. In the browser we therefore
	// require the crypto API and do not support built-in fallback to lower quality random number
	// generators (like Math.random()).
	let getRandomValues;
	const rnds8 = new Uint8Array(16);
	function rng() {
	  // lazy load so that environments that need to polyfill have a chance to do so
	  if (!getRandomValues) {
	    // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation.
	    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto);

	    if (!getRandomValues) {
	      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
	    }
	  }

	  return getRandomValues(rnds8);
	}

	/**
	 * Convert array of 16 byte values to UUID string format of the form:
	 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
	 */

	const byteToHex = [];

	for (let i = 0; i < 256; ++i) {
	  byteToHex.push((i + 0x100).toString(16).slice(1));
	}

	function unsafeStringify(arr, offset = 0) {
	  // Note: Be careful editing this code!  It's been tuned for performance
	  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
	  return (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase();
	}

	const randomUUID = typeof crypto !== 'undefined' && crypto.randomUUID && crypto.randomUUID.bind(crypto);
	var native = {
	  randomUUID
	};

	function v4(options, buf, offset) {
	  if (native.randomUUID && !buf && !options) {
	    return native.randomUUID();
	  }

	  options = options || {};
	  const rnds = options.random || (options.rng || rng)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`

	  rnds[6] = rnds[6] & 0x0f | 0x40;
	  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

	  if (buf) {
	    offset = offset || 0;

	    for (let i = 0; i < 16; ++i) {
	      buf[offset + i] = rnds[i];
	    }

	    return buf;
	  }

	  return unsafeStringify(rnds);
	}

	function ownKeys(object, enumerableOnly) { var keys = _Object$keys(object); if (_Object$getOwnPropertySymbols) { var symbols = _Object$getOwnPropertySymbols(object); enumerableOnly && (symbols = _filterInstanceProperty(symbols).call(symbols, function (sym) { return _Object$getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
	function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var _context8, _context9; var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? _forEachInstanceProperty(_context8 = ownKeys(Object(source), !0)).call(_context8, function (key) { _defineProperty(target, key, source[key]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(target, _Object$getOwnPropertyDescriptors(source)) : _forEachInstanceProperty(_context9 = ownKeys(Object(source))).call(_context9, function (key) { _Object$defineProperty(target, key, _Object$getOwnPropertyDescriptor(source, key)); }); } return target; }
	/**
	 * Test if an object implements the DataView interface from vis-data.
	 * Uses the idProp property instead of expecting a hardcoded id field "id".
	 */
	function isDataViewLike(obj) {
	  var _obj$idProp;
	  if (!obj) {
	    return false;
	  }
	  var idProp = (_obj$idProp = obj.idProp) !== null && _obj$idProp !== void 0 ? _obj$idProp : obj._idProp;
	  if (!idProp) {
	    return false;
	  }
	  return esnext.isDataViewLike(idProp, obj);
	}

	// parse ASP.Net Date pattern,
	// for example '/Date(1198908717056)/' or '/Date(1198908717056-0700)/'
	// code from http://momentjs.com/
	var ASPDateRegex = /^\/?Date\((-?\d+)/i;
	var NumericRegex = /^\d+$/;
	/**
	 * Convert an object into another type
	 *
	 * @param object - Value of unknown type.
	 * @param type - Name of the desired type.
	 *
	 * @returns Object in the desired type.
	 * @throws Error
	 */
	function convert(object, type) {
	  var match;
	  if (object === undefined) {
	    return undefined;
	  }
	  if (object === null) {
	    return null;
	  }
	  if (!type) {
	    return object;
	  }
	  if (!(typeof type === "string") && !(type instanceof String)) {
	    throw new Error("Type must be a string");
	  }

	  //noinspection FallthroughInSwitchStatementJS
	  switch (type) {
	    case "boolean":
	    case "Boolean":
	      return Boolean(object);
	    case "number":
	    case "Number":
	      if (isString(object) && !isNaN(Date.parse(object))) {
	        return moment$3(object).valueOf();
	      } else {
	        // @TODO: I don't think that Number and String constructors are a good idea.
	        // This could also fail if the object doesn't have valueOf method or if it's redefined.
	        // For example: Object.create(null) or { valueOf: 7 }.
	        return Number(object.valueOf());
	      }
	    case "string":
	    case "String":
	      return String(object);
	    case "Date":
	      try {
	        return convert(object, "Moment").toDate();
	      } catch (e) {
	        if (e instanceof TypeError) {
	          throw new TypeError("Cannot convert object of type " + getType(object) + " to type " + type);
	        } else {
	          throw e;
	        }
	      }
	    case "Moment":
	      if (isNumber(object)) {
	        return moment$3(object);
	      }
	      if (object instanceof Date) {
	        return moment$3(object.valueOf());
	      } else if (moment$3.isMoment(object)) {
	        return moment$3(object);
	      }
	      if (isString(object)) {
	        match = ASPDateRegex.exec(object);
	        if (match) {
	          // object is an ASP date
	          return moment$3(Number(match[1])); // parse number
	        }

	        match = NumericRegex.exec(object);
	        if (match) {
	          return moment$3(Number(object));
	        }
	        return moment$3(object); // parse string
	      } else {
	        throw new TypeError("Cannot convert object of type " + getType(object) + " to type " + type);
	      }
	    case "ISODate":
	      if (isNumber(object)) {
	        return new Date(object);
	      } else if (object instanceof Date) {
	        return object.toISOString();
	      } else if (moment$3.isMoment(object)) {
	        return object.toDate().toISOString();
	      } else if (isString(object)) {
	        match = ASPDateRegex.exec(object);
	        if (match) {
	          // object is an ASP date
	          return new Date(Number(match[1])).toISOString(); // parse number
	        } else {
	          return moment$3(object).format(); // ISO 8601
	        }
	      } else {
	        throw new Error("Cannot convert object of type " + getType(object) + " to type ISODate");
	      }
	    case "ASPDate":
	      if (isNumber(object)) {
	        return "/Date(" + object + ")/";
	      } else if (object instanceof Date || moment$3.isMoment(object)) {
	        return "/Date(" + object.valueOf() + ")/";
	      } else if (isString(object)) {
	        match = ASPDateRegex.exec(object);
	        var value;
	        if (match) {
	          // object is an ASP date
	          value = new Date(Number(match[1])).valueOf(); // parse number
	        } else {
	          value = new Date(object).valueOf(); // parse string
	        }

	        return "/Date(" + value + ")/";
	      } else {
	        throw new Error("Cannot convert object of type " + getType(object) + " to type ASPDate");
	      }
	    default:
	      throw new Error("Unknown type ".concat(type));
	  }
	}

	/**
	 * Create a Data Set like wrapper to seamlessly coerce data types.
	 *
	 * @param rawDS - The Data Set with raw uncoerced data.
	 * @param type - A record assigning a data type to property name.
	 *
	 * @remarks
	 * The write operations (`add`, `remove`, `update` and `updateOnly`) write into
	 * the raw (uncoerced) data set. These values are then picked up by a pipe
	 * which coerces the values using the [[convert]] function and feeds them into
	 * the coerced data set. When querying (`forEach`, `get`, `getIds`, `off` and
	 * `on`) the values are then fetched from the coerced data set and already have
	 * the required data types. The values are coerced only once when inserted and
	 * then the same value is returned each time until it is updated or deleted.
	 *
	 * For example: `typeCoercedDataSet.add({ id: 7, start: "2020-01-21" })` would
	 * result in `typeCoercedDataSet.get(7)` returning `{ id: 7, start: moment(new
	 * Date("2020-01-21")).toDate() }`.
	 *
	 * Use the dispose method prior to throwing a reference to this away. Otherwise
	 * the pipe connecting the two Data Sets will keep the unaccessible coerced
	 * Data Set alive and updated as long as the raw Data Set exists.
	 *
	 * @returns A Data Set like object that saves data into the raw Data Set and
	 * retrieves them from the coerced Data Set.
	 */
	function typeCoerceDataSet(rawDS) {
	  var _context, _context3, _context4, _context5, _context6, _context7;
	  var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
	    start: "Date",
	    end: "Date"
	  };
	  var idProp = rawDS._idProp;
	  var coercedDS = new esnext.DataSet({
	    fieldId: idProp
	  });
	  var pipe = _mapInstanceProperty(_context = esnext.createNewDataPipeFrom(rawDS)).call(_context, function (item) {
	    var _context2;
	    return _reduceInstanceProperty(_context2 = _Object$keys(item)).call(_context2, function (acc, key) {
	      acc[key] = convert(item[key], type[key]);
	      return acc;
	    }, {});
	  }).to(coercedDS);
	  pipe.all().start();
	  return {
	    // Write only.
	    add: function add() {
	      var _rawDS$getDataSet;
	      return (_rawDS$getDataSet = rawDS.getDataSet()).add.apply(_rawDS$getDataSet, arguments);
	    },
	    remove: function remove() {
	      var _rawDS$getDataSet2;
	      return (_rawDS$getDataSet2 = rawDS.getDataSet()).remove.apply(_rawDS$getDataSet2, arguments);
	    },
	    update: function update() {
	      var _rawDS$getDataSet3;
	      return (_rawDS$getDataSet3 = rawDS.getDataSet()).update.apply(_rawDS$getDataSet3, arguments);
	    },
	    updateOnly: function updateOnly() {
	      var _rawDS$getDataSet4;
	      return (_rawDS$getDataSet4 = rawDS.getDataSet()).updateOnly.apply(_rawDS$getDataSet4, arguments);
	    },
	    clear: function clear() {
	      var _rawDS$getDataSet5;
	      return (_rawDS$getDataSet5 = rawDS.getDataSet()).clear.apply(_rawDS$getDataSet5, arguments);
	    },
	    // Read only.
	    forEach: _bindInstanceProperty(_context3 = _forEachInstanceProperty(coercedDS)).call(_context3, coercedDS),
	    get: _bindInstanceProperty(_context4 = coercedDS.get).call(_context4, coercedDS),
	    getIds: _bindInstanceProperty(_context5 = coercedDS.getIds).call(_context5, coercedDS),
	    off: _bindInstanceProperty(_context6 = coercedDS.off).call(_context6, coercedDS),
	    on: _bindInstanceProperty(_context7 = coercedDS.on).call(_context7, coercedDS),
	    get length() {
	      return coercedDS.length;
	    },
	    // Non standard.
	    idProp: idProp,
	    type: type,
	    rawDS: rawDS,
	    coercedDS: coercedDS,
	    dispose: function dispose() {
	      return pipe.stop();
	    }
	  };
	}

	// Configure XSS protection
	var setupXSSCleaner = function setupXSSCleaner(options) {
	  var customXSS = new xssFilter.FilterXSS(options);
	  return function (string) {
	    return customXSS.process(string);
	  };
	};
	var setupNoOpCleaner = function setupNoOpCleaner(string) {
	  return string;
	};

	// when nothing else is configured: filter XSS with the lib's default options
	var configuredXSSProtection = setupXSSCleaner();
	var setupXSSProtection = function setupXSSProtection(options) {
	  // No options? Do nothing.
	  if (!options) {
	    return;
	  }

	  // Disable XSS protection completely on request
	  if (options.disabled === true) {
	    configuredXSSProtection = setupNoOpCleaner;
	    console.warn('You disabled XSS protection for vis-Timeline. I sure hope you know what you\'re doing!');
	  } else {
	    // Configure XSS protection with some custom options.
	    // For a list of valid options check the lib's documentation:
	    // https://github.com/leizongmin/js-xss#custom-filter-rules
	    if (options.filterOptions) {
	      configuredXSSProtection = setupXSSCleaner(options.filterOptions);
	    }
	  }
	};
	var availableUtils = _objectSpread(_objectSpread({}, util$2), {}, {
	  convert: convert,
	  setupXSSProtection: setupXSSProtection
	});
	_Object$defineProperty(availableUtils, 'xss', {
	  get: function get() {
	    return configuredXSSProtection;
	  }
	});

	var _parseFloatExports = {};
	var _parseFloat$3 = {
	  get exports(){ return _parseFloatExports; },
	  set exports(v){ _parseFloatExports = v; },
	};

	var global$2 = global$j;
	var fails$5 = fails$u;
	var uncurryThis$2 = functionUncurryThis;
	var toString$2 = toString$b;
	var trim = stringTrim.trim;
	var whitespaces = whitespaces$4;

	var charAt = uncurryThis$2(''.charAt);
	var $parseFloat$1 = global$2.parseFloat;
	var Symbol$1 = global$2.Symbol;
	var ITERATOR = Symbol$1 && Symbol$1.iterator;
	var FORCED$1 = 1 / $parseFloat$1(whitespaces + '-0') !== -Infinity
	  // MS Edge 18- broken with boxed symbols
	  || (ITERATOR && !fails$5(function () { $parseFloat$1(Object(ITERATOR)); }));

	// `parseFloat` method
	// https://tc39.es/ecma262/#sec-parsefloat-string
	var numberParseFloat = FORCED$1 ? function parseFloat(string) {
	  var trimmedString = trim(toString$2(string));
	  var result = $parseFloat$1(trimmedString);
	  return result === 0 && charAt(trimmedString, 0) == '-' ? -0 : result;
	} : $parseFloat$1;

	var $$8 = _export;
	var $parseFloat = numberParseFloat;

	// `parseFloat` method
	// https://tc39.es/ecma262/#sec-parsefloat-string
	$$8({ global: true, forced: parseFloat != $parseFloat }, {
	  parseFloat: $parseFloat
	});

	var path$2 = path$r;

	var _parseFloat$2 = path$2.parseFloat;

	var parent$7 = _parseFloat$2;

	var _parseFloat$1 = parent$7;

	(function (module) {
		module.exports = _parseFloat$1;
	} (_parseFloat$3));

	var _parseFloat = /*@__PURE__*/getDefaultExportFromCjs(_parseFloatExports);

	/** Prototype for visual components */
	var Component = /*#__PURE__*/function () {
	  /**
	  * @param {{dom: Object, domProps: Object, emitter: Emitter, range: Range}} [body]
	  * @param {Object} [options]
	  */
	  function Component(body, options) {
	    _classCallCheck(this, Component);
	    // eslint-disable-line no-unused-vars
	    this.options = null;
	    this.props = null;
	  }

	  /**
	   * Set options for the component. The new options will be merged into the
	   * current options.
	   * @param {Object} options
	   */
	  _createClass(Component, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options) {
	        availableUtils.extend(this.options, options);
	      }
	    }

	    /**
	     * Repaint the component
	     * @return {boolean} Returns true if the component is resized
	     */
	  }, {
	    key: "redraw",
	    value: function redraw() {
	      // should be implemented by the component
	      return false;
	    }

	    /**
	     * Destroy the component. Cleanup DOM and event listeners
	     */
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      // should be implemented by the component
	    }

	    /**
	     * Test whether the component is resized since the last time _isResized() was
	     * called.
	     * @return {Boolean} Returns true if the component is resized
	     * @protected
	     */
	  }, {
	    key: "_isResized",
	    value: function _isResized() {
	      var resized = this.props._previousWidth !== this.props.width || this.props._previousHeight !== this.props.height;
	      this.props._previousWidth = this.props.width;
	      this.props._previousHeight = this.props.height;
	      return resized;
	    }
	  }]);
	  return Component;
	}();

	var repeatExports = {};
	var repeat$4 = {
	  get exports(){ return repeatExports; },
	  set exports(v){ repeatExports = v; },
	};

	var toIntegerOrInfinity = toIntegerOrInfinity$5;
	var toString$1 = toString$b;
	var requireObjectCoercible = requireObjectCoercible$6;

	var $RangeError = RangeError;

	// `String.prototype.repeat` method implementation
	// https://tc39.es/ecma262/#sec-string.prototype.repeat
	var stringRepeat = function repeat(count) {
	  var str = toString$1(requireObjectCoercible(this));
	  var result = '';
	  var n = toIntegerOrInfinity(count);
	  if (n < 0 || n == Infinity) throw $RangeError('Wrong number of repetitions');
	  for (;n > 0; (n >>>= 1) && (str += str)) if (n & 1) result += str;
	  return result;
	};

	var $$7 = _export;
	var repeat$3 = stringRepeat;

	// `String.prototype.repeat` method
	// https://tc39.es/ecma262/#sec-string.prototype.repeat
	$$7({ target: 'String', proto: true }, {
	  repeat: repeat$3
	});

	var entryVirtual$5 = entryVirtual$k;

	var repeat$2 = entryVirtual$5('String').repeat;

	var isPrototypeOf$7 = objectIsPrototypeOf;
	var method$5 = repeat$2;

	var StringPrototype = String.prototype;

	var repeat$1 = function (it) {
	  var own = it.repeat;
	  return typeof it == 'string' || it === StringPrototype
	    || (isPrototypeOf$7(StringPrototype, it) && own === StringPrototype.repeat) ? method$5 : own;
	};

	var parent$6 = repeat$1;

	var repeat = parent$6;

	(function (module) {
		module.exports = repeat;
	} (repeat$4));

	var _repeatInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(repeatExports);

	var sortExports = {};
	var sort$3 = {
	  get exports(){ return sortExports; },
	  set exports(v){ sortExports = v; },
	};

	var arraySlice = arraySliceSimple;

	var floor = Math.floor;

	var mergeSort = function (array, comparefn) {
	  var length = array.length;
	  var middle = floor(length / 2);
	  return length < 8 ? insertionSort(array, comparefn) : merge(
	    array,
	    mergeSort(arraySlice(array, 0, middle), comparefn),
	    mergeSort(arraySlice(array, middle), comparefn),
	    comparefn
	  );
	};

	var insertionSort = function (array, comparefn) {
	  var length = array.length;
	  var i = 1;
	  var element, j;

	  while (i < length) {
	    j = i;
	    element = array[i];
	    while (j && comparefn(array[j - 1], element) > 0) {
	      array[j] = array[--j];
	    }
	    if (j !== i++) array[j] = element;
	  } return array;
	};

	var merge = function (array, left, right, comparefn) {
	  var llength = left.length;
	  var rlength = right.length;
	  var lindex = 0;
	  var rindex = 0;

	  while (lindex < llength || rindex < rlength) {
	    array[lindex + rindex] = (lindex < llength && rindex < rlength)
	      ? comparefn(left[lindex], right[rindex]) <= 0 ? left[lindex++] : right[rindex++]
	      : lindex < llength ? left[lindex++] : right[rindex++];
	  } return array;
	};

	var arraySort = mergeSort;

	var userAgent$1 = engineUserAgent;

	var firefox = userAgent$1.match(/firefox\/(\d+)/i);

	var engineFfVersion = !!firefox && +firefox[1];

	var UA = engineUserAgent;

	var engineIsIeOrEdge = /MSIE|Trident/.test(UA);

	var userAgent = engineUserAgent;

	var webkit = userAgent.match(/AppleWebKit\/(\d+)\./);

	var engineWebkitVersion = !!webkit && +webkit[1];

	var $$6 = _export;
	var uncurryThis$1 = functionUncurryThis;
	var aCallable = aCallable$7;
	var toObject = toObject$d;
	var lengthOfArrayLike$1 = lengthOfArrayLike$b;
	var deletePropertyOrThrow = deletePropertyOrThrow$2;
	var toString = toString$b;
	var fails$4 = fails$u;
	var internalSort = arraySort;
	var arrayMethodIsStrict$2 = arrayMethodIsStrict$6;
	var FF = engineFfVersion;
	var IE_OR_EDGE = engineIsIeOrEdge;
	var V8 = engineV8Version;
	var WEBKIT = engineWebkitVersion;

	var test = [];
	var nativeSort = uncurryThis$1(test.sort);
	var push = uncurryThis$1(test.push);

	// IE8-
	var FAILS_ON_UNDEFINED = fails$4(function () {
	  test.sort(undefined);
	});
	// V8 bug
	var FAILS_ON_NULL = fails$4(function () {
	  test.sort(null);
	});
	// Old WebKit
	var STRICT_METHOD$2 = arrayMethodIsStrict$2('sort');

	var STABLE_SORT = !fails$4(function () {
	  // feature detection can be too slow, so check engines versions
	  if (V8) return V8 < 70;
	  if (FF && FF > 3) return;
	  if (IE_OR_EDGE) return true;
	  if (WEBKIT) return WEBKIT < 603;

	  var result = '';
	  var code, chr, value, index;

	  // generate an array with more 512 elements (Chakra and old V8 fails only in this case)
	  for (code = 65; code < 76; code++) {
	    chr = String.fromCharCode(code);

	    switch (code) {
	      case 66: case 69: case 70: case 72: value = 3; break;
	      case 68: case 71: value = 4; break;
	      default: value = 2;
	    }

	    for (index = 0; index < 47; index++) {
	      test.push({ k: chr + index, v: value });
	    }
	  }

	  test.sort(function (a, b) { return b.v - a.v; });

	  for (index = 0; index < test.length; index++) {
	    chr = test[index].k.charAt(0);
	    if (result.charAt(result.length - 1) !== chr) result += chr;
	  }

	  return result !== 'DGBEFHACIJK';
	});

	var FORCED = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD$2 || !STABLE_SORT;

	var getSortCompare = function (comparefn) {
	  return function (x, y) {
	    if (y === undefined) return -1;
	    if (x === undefined) return 1;
	    if (comparefn !== undefined) return +comparefn(x, y) || 0;
	    return toString(x) > toString(y) ? 1 : -1;
	  };
	};

	// `Array.prototype.sort` method
	// https://tc39.es/ecma262/#sec-array.prototype.sort
	$$6({ target: 'Array', proto: true, forced: FORCED }, {
	  sort: function sort(comparefn) {
	    if (comparefn !== undefined) aCallable(comparefn);

	    var array = toObject(this);

	    if (STABLE_SORT) return comparefn === undefined ? nativeSort(array) : nativeSort(array, comparefn);

	    var items = [];
	    var arrayLength = lengthOfArrayLike$1(array);
	    var itemsLength, index;

	    for (index = 0; index < arrayLength; index++) {
	      if (index in array) push(items, array[index]);
	    }

	    internalSort(items, getSortCompare(comparefn));

	    itemsLength = lengthOfArrayLike$1(items);
	    index = 0;

	    while (index < itemsLength) array[index] = items[index++];
	    while (index < arrayLength) deletePropertyOrThrow(array, index++);

	    return array;
	  }
	});

	var entryVirtual$4 = entryVirtual$k;

	var sort$2 = entryVirtual$4('Array').sort;

	var isPrototypeOf$6 = objectIsPrototypeOf;
	var method$4 = sort$2;

	var ArrayPrototype$4 = Array.prototype;

	var sort$1 = function (it) {
	  var own = it.sort;
	  return it === ArrayPrototype$4 || (isPrototypeOf$6(ArrayPrototype$4, it) && own === ArrayPrototype$4.sort) ? method$4 : own;
	};

	var parent$5 = sort$1;

	var sort = parent$5;

	(function (module) {
		module.exports = sort;
	} (sort$3));

	var _sortInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(sortExports);

	/**
	 * used in Core to convert the options into a volatile variable
	 * 
	 * @param {function} moment
	 * @param {Object} body
	 * @param {Array | Object} hiddenDates
	 * @returns {number}
	 */
	function convertHiddenOptions(moment, body, hiddenDates) {
	  if (hiddenDates && !_Array$isArray$1(hiddenDates)) {
	    return convertHiddenOptions(moment, body, [hiddenDates]);
	  }
	  body.hiddenDates = [];
	  if (hiddenDates) {
	    if (_Array$isArray$1(hiddenDates) == true) {
	      var _context;
	      for (var i = 0; i < hiddenDates.length; i++) {
	        if (_repeatInstanceProperty(hiddenDates[i]) === undefined) {
	          var dateItem = {};
	          dateItem.start = moment(hiddenDates[i].start).toDate().valueOf();
	          dateItem.end = moment(hiddenDates[i].end).toDate().valueOf();
	          body.hiddenDates.push(dateItem);
	        }
	      }
	      _sortInstanceProperty(_context = body.hiddenDates).call(_context, function (a, b) {
	        return a.start - b.start;
	      }); // sort by start time
	    }
	  }
	}

	/**
	 * create new entrees for the repeating hidden dates
	 *
	 * @param {function} moment
	 * @param {Object} body
	 * @param {Array | Object} hiddenDates
	 * @returns {null}
	 */
	function updateHiddenDates(moment, body, hiddenDates) {
	  if (hiddenDates && !_Array$isArray$1(hiddenDates)) {
	    return updateHiddenDates(moment, body, [hiddenDates]);
	  }
	  if (hiddenDates && body.domProps.centerContainer.width !== undefined) {
	    convertHiddenOptions(moment, body, hiddenDates);
	    var start = moment(body.range.start);
	    var end = moment(body.range.end);
	    var totalRange = body.range.end - body.range.start;
	    var pixelTime = totalRange / body.domProps.centerContainer.width;
	    for (var i = 0; i < hiddenDates.length; i++) {
	      if (_repeatInstanceProperty(hiddenDates[i]) !== undefined) {
	        var startDate = moment(hiddenDates[i].start);
	        var endDate = moment(hiddenDates[i].end);
	        if (startDate._d == "Invalid Date") {
	          throw new Error("Supplied start date is not valid: ".concat(hiddenDates[i].start));
	        }
	        if (endDate._d == "Invalid Date") {
	          throw new Error("Supplied end date is not valid: ".concat(hiddenDates[i].end));
	        }
	        var duration = endDate - startDate;
	        if (duration >= 4 * pixelTime) {
	          var offset = 0;
	          var runUntil = end.clone();
	          switch (_repeatInstanceProperty(hiddenDates[i])) {
	            case "daily":
	              // case of time
	              if (startDate.day() != endDate.day()) {
	                offset = 1;
	              }
	              startDate.dayOfYear(start.dayOfYear());
	              startDate.year(start.year());
	              startDate.subtract(7, 'days');
	              endDate.dayOfYear(start.dayOfYear());
	              endDate.year(start.year());
	              endDate.subtract(7 - offset, 'days');
	              runUntil.add(1, 'weeks');
	              break;
	            case "weekly":
	              {
	                var dayOffset = endDate.diff(startDate, 'days');
	                var day = startDate.day();

	                // set the start date to the range.start
	                startDate.date(start.date());
	                startDate.month(start.month());
	                startDate.year(start.year());
	                endDate = startDate.clone();

	                // force
	                startDate.day(day);
	                endDate.day(day);
	                endDate.add(dayOffset, 'days');
	                startDate.subtract(1, 'weeks');
	                endDate.subtract(1, 'weeks');
	                runUntil.add(1, 'weeks');
	                break;
	              }
	            case "monthly":
	              if (startDate.month() != endDate.month()) {
	                offset = 1;
	              }
	              startDate.month(start.month());
	              startDate.year(start.year());
	              startDate.subtract(1, 'months');
	              endDate.month(start.month());
	              endDate.year(start.year());
	              endDate.subtract(1, 'months');
	              endDate.add(offset, 'months');
	              runUntil.add(1, 'months');
	              break;
	            case "yearly":
	              if (startDate.year() != endDate.year()) {
	                offset = 1;
	              }
	              startDate.year(start.year());
	              startDate.subtract(1, 'years');
	              endDate.year(start.year());
	              endDate.subtract(1, 'years');
	              endDate.add(offset, 'years');
	              runUntil.add(1, 'years');
	              break;
	            default:
	              console.log("Wrong repeat format, allowed are: daily, weekly, monthly, yearly. Given:", _repeatInstanceProperty(hiddenDates[i]));
	              return;
	          }
	          while (startDate < runUntil) {
	            body.hiddenDates.push({
	              start: startDate.valueOf(),
	              end: endDate.valueOf()
	            });
	            switch (_repeatInstanceProperty(hiddenDates[i])) {
	              case "daily":
	                startDate.add(1, 'days');
	                endDate.add(1, 'days');
	                break;
	              case "weekly":
	                startDate.add(1, 'weeks');
	                endDate.add(1, 'weeks');
	                break;
	              case "monthly":
	                startDate.add(1, 'months');
	                endDate.add(1, 'months');
	                break;
	              case "yearly":
	                startDate.add(1, 'y');
	                endDate.add(1, 'y');
	                break;
	              default:
	                console.log("Wrong repeat format, allowed are: daily, weekly, monthly, yearly. Given:", _repeatInstanceProperty(hiddenDates[i]));
	                return;
	            }
	          }
	          body.hiddenDates.push({
	            start: startDate.valueOf(),
	            end: endDate.valueOf()
	          });
	        }
	      }
	    }
	    // remove duplicates, merge where possible
	    removeDuplicates(body);
	    // ensure the new positions are not on hidden dates
	    var startHidden = getIsHidden(body.range.start, body.hiddenDates);
	    var endHidden = getIsHidden(body.range.end, body.hiddenDates);
	    var rangeStart = body.range.start;
	    var rangeEnd = body.range.end;
	    if (startHidden.hidden == true) {
	      rangeStart = body.range.startToFront == true ? startHidden.startDate - 1 : startHidden.endDate + 1;
	    }
	    if (endHidden.hidden == true) {
	      rangeEnd = body.range.endToFront == true ? endHidden.startDate - 1 : endHidden.endDate + 1;
	    }
	    if (startHidden.hidden == true || endHidden.hidden == true) {
	      body.range._applyRange(rangeStart, rangeEnd);
	    }
	  }
	}

	/**
	 * remove duplicates from the hidden dates list. Duplicates are evil. They mess everything up.
	 * Scales with N^2
	 *
	 * @param {Object} body
	 */
	function removeDuplicates(body) {
	  var _context2;
	  var hiddenDates = body.hiddenDates;
	  var safeDates = [];
	  for (var i = 0; i < hiddenDates.length; i++) {
	    for (var j = 0; j < hiddenDates.length; j++) {
	      if (i != j && hiddenDates[j].remove != true && hiddenDates[i].remove != true) {
	        // j inside i
	        if (hiddenDates[j].start >= hiddenDates[i].start && hiddenDates[j].end <= hiddenDates[i].end) {
	          hiddenDates[j].remove = true;
	        }
	        // j start inside i
	        else if (hiddenDates[j].start >= hiddenDates[i].start && hiddenDates[j].start <= hiddenDates[i].end) {
	          hiddenDates[i].end = hiddenDates[j].end;
	          hiddenDates[j].remove = true;
	        }
	        // j end inside i
	        else if (hiddenDates[j].end >= hiddenDates[i].start && hiddenDates[j].end <= hiddenDates[i].end) {
	          hiddenDates[i].start = hiddenDates[j].start;
	          hiddenDates[j].remove = true;
	        }
	      }
	    }
	  }
	  for (i = 0; i < hiddenDates.length; i++) {
	    if (hiddenDates[i].remove !== true) {
	      safeDates.push(hiddenDates[i]);
	    }
	  }
	  body.hiddenDates = safeDates;
	  _sortInstanceProperty(_context2 = body.hiddenDates).call(_context2, function (a, b) {
	    return a.start - b.start;
	  }); // sort by start time
	}

	/**
	 * Prints dates to console
	 * @param {array} dates
	 */
	function printDates(dates) {
	  for (var i = 0; i < dates.length; i++) {
	    console.log(i, new Date(dates[i].start), new Date(dates[i].end), dates[i].start, dates[i].end, dates[i].remove);
	  }
	}

	/**
	 * Used in TimeStep to avoid the hidden times.
	 * @param {function} moment
	 * @param {TimeStep} timeStep
	 * @param {Date} previousTime
	 */
	function stepOverHiddenDates(moment, timeStep, previousTime) {
	  var stepInHidden = false;
	  var currentValue = timeStep.current.valueOf();
	  for (var i = 0; i < timeStep.hiddenDates.length; i++) {
	    var startDate = timeStep.hiddenDates[i].start;
	    var endDate = timeStep.hiddenDates[i].end;
	    if (currentValue >= startDate && currentValue < endDate) {
	      stepInHidden = true;
	      break;
	    }
	  }
	  if (stepInHidden == true && currentValue < timeStep._end.valueOf() && currentValue != previousTime) {
	    var prevValue = moment(previousTime);
	    var newValue = moment(endDate);
	    //check if the next step should be major
	    if (prevValue.year() != newValue.year()) {
	      timeStep.switchedYear = true;
	    } else if (prevValue.month() != newValue.month()) {
	      timeStep.switchedMonth = true;
	    } else if (prevValue.dayOfYear() != newValue.dayOfYear()) {
	      timeStep.switchedDay = true;
	    }
	    timeStep.current = newValue;
	  }
	}

	///**
	// * Used in TimeStep to avoid the hidden times.
	// * @param timeStep
	// * @param previousTime
	// */
	//checkFirstStep = function(timeStep) {
	//  var stepInHidden = false;
	//  var currentValue = timeStep.current.valueOf();
	//  for (var i = 0; i < timeStep.hiddenDates.length; i++) {
	//    var startDate = timeStep.hiddenDates[i].start;
	//    var endDate = timeStep.hiddenDates[i].end;
	//    if (currentValue >= startDate && currentValue < endDate) {
	//      stepInHidden = true;
	//      break;
	//    }
	//  }
	//
	//  if (stepInHidden == true && currentValue <= timeStep._end.valueOf()) {
	//    var newValue = moment(endDate);
	//    timeStep.current = newValue.toDate();
	//  }
	//};

	/**
	 * replaces the Core toScreen methods
	 *
	 * @param {timeline.Core} Core
	 * @param {Date} time
	 * @param {number} width
	 * @returns {number}
	 */
	function toScreen(Core, time, width) {
	  var conversion;
	  if (Core.body.hiddenDates.length == 0) {
	    conversion = Core.range.conversion(width);
	    return (time.valueOf() - conversion.offset) * conversion.scale;
	  } else {
	    var hidden = getIsHidden(time, Core.body.hiddenDates);
	    if (hidden.hidden == true) {
	      time = hidden.startDate;
	    }
	    var duration = getHiddenDurationBetween(Core.body.hiddenDates, Core.range.start, Core.range.end);
	    if (time < Core.range.start) {
	      conversion = Core.range.conversion(width, duration);
	      var hiddenBeforeStart = getHiddenDurationBeforeStart(Core.body.hiddenDates, time, conversion.offset);
	      time = Core.options.moment(time).toDate().valueOf();
	      time = time + hiddenBeforeStart;
	      return -(conversion.offset - time.valueOf()) * conversion.scale;
	    } else if (time > Core.range.end) {
	      var rangeAfterEnd = {
	        start: Core.range.start,
	        end: time
	      };
	      time = correctTimeForHidden(Core.options.moment, Core.body.hiddenDates, rangeAfterEnd, time);
	      conversion = Core.range.conversion(width, duration);
	      return (time.valueOf() - conversion.offset) * conversion.scale;
	    } else {
	      time = correctTimeForHidden(Core.options.moment, Core.body.hiddenDates, Core.range, time);
	      conversion = Core.range.conversion(width, duration);
	      return (time.valueOf() - conversion.offset) * conversion.scale;
	    }
	  }
	}

	/**
	 * Replaces the core toTime methods
	 *
	 * @param {timeline.Core} Core
	 * @param {number} x
	 * @param {number} width
	 * @returns {Date}
	 */
	function toTime(Core, x, width) {
	  if (Core.body.hiddenDates.length == 0) {
	    var conversion = Core.range.conversion(width);
	    return new Date(x / conversion.scale + conversion.offset);
	  } else {
	    var hiddenDuration = getHiddenDurationBetween(Core.body.hiddenDates, Core.range.start, Core.range.end);
	    var totalDuration = Core.range.end - Core.range.start - hiddenDuration;
	    var partialDuration = totalDuration * x / width;
	    var accumulatedHiddenDuration = getAccumulatedHiddenDuration(Core.body.hiddenDates, Core.range, partialDuration);
	    return new Date(accumulatedHiddenDuration + partialDuration + Core.range.start);
	  }
	}

	/**
	 * Support function
	 *
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @param {number} start
	 * @param {number} end
	 * @returns {number}
	 */
	function getHiddenDurationBetween(hiddenDates, start, end) {
	  var duration = 0;
	  for (var i = 0; i < hiddenDates.length; i++) {
	    var startDate = hiddenDates[i].start;
	    var endDate = hiddenDates[i].end;
	    // if time after the cutout, and the
	    if (startDate >= start && endDate < end) {
	      duration += endDate - startDate;
	    }
	  }
	  return duration;
	}

	/**
	 * Support function
	 *
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @param {number} start
	 * @param {number} end
	 * @returns {number}
	 */
	function getHiddenDurationBeforeStart(hiddenDates, start, end) {
	  var duration = 0;
	  for (var i = 0; i < hiddenDates.length; i++) {
	    var startDate = hiddenDates[i].start;
	    var endDate = hiddenDates[i].end;
	    if (startDate >= start && endDate <= end) {
	      duration += endDate - startDate;
	    }
	  }
	  return duration;
	}

	/**
	 * Support function
	 * @param {function} moment
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @param {{start: number, end: number}} range
	 * @param {Date} time
	 * @returns {number}
	 */
	function correctTimeForHidden(moment, hiddenDates, range, time) {
	  time = moment(time).toDate().valueOf();
	  time -= getHiddenDurationBefore(moment, hiddenDates, range, time);
	  return time;
	}

	/**
	 * Support function
	 * @param {function} moment
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @param {{start: number, end: number}} range
	 * @param {Date} time
	 * @returns {number}
	 */
	function getHiddenDurationBefore(moment, hiddenDates, range, time) {
	  var timeOffset = 0;
	  time = moment(time).toDate().valueOf();
	  for (var i = 0; i < hiddenDates.length; i++) {
	    var startDate = hiddenDates[i].start;
	    var endDate = hiddenDates[i].end;
	    // if time after the cutout, and the
	    if (startDate >= range.start && endDate < range.end) {
	      if (time >= endDate) {
	        timeOffset += endDate - startDate;
	      }
	    }
	  }
	  return timeOffset;
	}

	/**
	 * sum the duration from start to finish, including the hidden duration,
	 * until the required amount has been reached, return the accumulated hidden duration
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @param {{start: number, end: number}} range
	 * @param {number} [requiredDuration=0]
	 * @returns {number}
	 */
	function getAccumulatedHiddenDuration(hiddenDates, range, requiredDuration) {
	  var hiddenDuration = 0;
	  var duration = 0;
	  var previousPoint = range.start;
	  //printDates(hiddenDates)
	  for (var i = 0; i < hiddenDates.length; i++) {
	    var startDate = hiddenDates[i].start;
	    var endDate = hiddenDates[i].end;
	    // if time after the cutout, and the
	    if (startDate >= range.start && endDate < range.end) {
	      duration += startDate - previousPoint;
	      previousPoint = endDate;
	      if (duration >= requiredDuration) {
	        break;
	      } else {
	        hiddenDuration += endDate - startDate;
	      }
	    }
	  }
	  return hiddenDuration;
	}

	/**
	 * used to step over to either side of a hidden block. Correction is disabled on tablets, might be set to true
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @param {Date} time
	 * @param {number} direction
	 * @param {boolean} correctionEnabled
	 * @returns {Date|number}
	 */
	function snapAwayFromHidden(hiddenDates, time, direction, correctionEnabled) {
	  var isHidden = getIsHidden(time, hiddenDates);
	  if (isHidden.hidden == true) {
	    if (direction < 0) {
	      if (correctionEnabled == true) {
	        return isHidden.startDate - (isHidden.endDate - time) - 1;
	      } else {
	        return isHidden.startDate - 1;
	      }
	    } else {
	      if (correctionEnabled == true) {
	        return isHidden.endDate + (time - isHidden.startDate) + 1;
	      } else {
	        return isHidden.endDate + 1;
	      }
	    }
	  } else {
	    return time;
	  }
	}

	/**
	 * Check if a time is hidden
	 *
	 * @param {Date} time
	 * @param {Array.<{start: Window.start, end: *}>} hiddenDates
	 * @returns {{hidden: boolean, startDate: Window.start, endDate: *}}
	 */
	function getIsHidden(time, hiddenDates) {
	  for (var i = 0; i < hiddenDates.length; i++) {
	    var startDate = hiddenDates[i].start;
	    var endDate = hiddenDates[i].end;
	    if (time >= startDate && time < endDate) {
	      // if the start is entering a hidden zone
	      return {
	        hidden: true,
	        startDate: startDate,
	        endDate: endDate
	      };
	    }
	  }
	  return {
	    hidden: false,
	    startDate: startDate,
	    endDate: endDate
	  };
	}

	var DateUtil = /*#__PURE__*/Object.freeze({
		__proto__: null,
		convertHiddenOptions: convertHiddenOptions,
		correctTimeForHidden: correctTimeForHidden,
		getAccumulatedHiddenDuration: getAccumulatedHiddenDuration,
		getHiddenDurationBefore: getHiddenDurationBefore,
		getHiddenDurationBeforeStart: getHiddenDurationBeforeStart,
		getHiddenDurationBetween: getHiddenDurationBetween,
		getIsHidden: getIsHidden,
		printDates: printDates,
		removeDuplicates: removeDuplicates,
		snapAwayFromHidden: snapAwayFromHidden,
		stepOverHiddenDates: stepOverHiddenDates,
		toScreen: toScreen,
		toTime: toTime,
		updateHiddenDates: updateHiddenDates
	});

	function _createSuper$c(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$c(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$c() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A Range controls a numeric range with a start and end value.
	 * The Range adjusts the range based on mouse events or programmatic changes,
	 * and triggers events when the range is changing or has been changed.
	 */
	var Range = /*#__PURE__*/function (_Component) {
	  _inherits(Range, _Component);
	  var _super = _createSuper$c(Range);
	  /**
	  * @param {{dom: Object, domProps: Object, emitter: Emitter}} body
	  * @param {Object} [options]    See description at Range.setOptions
	  * @constructor Range
	  * @extends Component
	  */
	  function Range(body, options) {
	    var _context, _context2, _context3, _context4, _context5, _context6, _context7;
	    var _this;
	    _classCallCheck(this, Range);
	    _this = _super.call(this);
	    var now = moment$2().hours(0).minutes(0).seconds(0).milliseconds(0);
	    var start = now.clone().add(-3, 'days').valueOf();
	    var end = now.clone().add(3, 'days').valueOf();
	    _this.millisecondsPerPixelCache = undefined;
	    if (options === undefined) {
	      _this.start = start;
	      _this.end = end;
	    } else {
	      _this.start = options.start || start;
	      _this.end = options.end || end;
	    }
	    _this.rolling = false;
	    _this.body = body;
	    _this.deltaDifference = 0;
	    _this.scaleOffset = 0;
	    _this.startToFront = false;
	    _this.endToFront = true;

	    // default options
	    _this.defaultOptions = {
	      rtl: false,
	      start: null,
	      end: null,
	      moment: moment$2,
	      direction: 'horizontal',
	      // 'horizontal' or 'vertical'
	      moveable: true,
	      zoomable: true,
	      min: null,
	      max: null,
	      zoomMin: 10,
	      // milliseconds
	      zoomMax: 1000 * 60 * 60 * 24 * 365 * 10000,
	      // milliseconds
	      rollingMode: {
	        follow: false,
	        offset: 0.5
	      }
	    };
	    _this.options = availableUtils.extend({}, _this.defaultOptions);
	    _this.props = {
	      touch: {}
	    };
	    _this.animationTimer = null;

	    // drag listeners for dragging
	    _this.body.emitter.on('panstart', _bindInstanceProperty(_context = _this._onDragStart).call(_context, _assertThisInitialized$1(_this)));
	    _this.body.emitter.on('panmove', _bindInstanceProperty(_context2 = _this._onDrag).call(_context2, _assertThisInitialized$1(_this)));
	    _this.body.emitter.on('panend', _bindInstanceProperty(_context3 = _this._onDragEnd).call(_context3, _assertThisInitialized$1(_this)));

	    // mouse wheel for zooming
	    _this.body.emitter.on('mousewheel', _bindInstanceProperty(_context4 = _this._onMouseWheel).call(_context4, _assertThisInitialized$1(_this)));

	    // pinch to zoom
	    _this.body.emitter.on('touch', _bindInstanceProperty(_context5 = _this._onTouch).call(_context5, _assertThisInitialized$1(_this)));
	    _this.body.emitter.on('pinch', _bindInstanceProperty(_context6 = _this._onPinch).call(_context6, _assertThisInitialized$1(_this)));

	    // on click of rolling mode button
	    _this.body.dom.rollingModeBtn.addEventListener('click', _bindInstanceProperty(_context7 = _this.startRolling).call(_context7, _assertThisInitialized$1(_this)));
	    _this.setOptions(options);
	    return _this;
	  }

	  /**
	   * Set options for the range controller
	   * @param {Object} options      Available options:
	   *                              {number | Date | String} start  Start date for the range
	   *                              {number | Date | String} end    End date for the range
	   *                              {number} min    Minimum value for start
	   *                              {number} max    Maximum value for end
	   *                              {number} zoomMin    Set a minimum value for
	   *                                                  (end - start).
	   *                              {number} zoomMax    Set a maximum value for
	   *                                                  (end - start).
	   *                              {boolean} moveable Enable moving of the range
	   *                                                 by dragging. True by default
	   *                              {boolean} zoomable Enable zooming of the range
	   *                                                 by pinching/scrolling. True by default
	   */
	  _createClass(Range, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options) {
	        // copy the options that we know
	        var fields = ['animation', 'direction', 'min', 'max', 'zoomMin', 'zoomMax', 'moveable', 'zoomable', 'moment', 'activate', 'hiddenDates', 'zoomKey', 'zoomFriction', 'rtl', 'showCurrentTime', 'rollingMode', 'horizontalScroll'];
	        availableUtils.selectiveExtend(fields, this.options, options);
	        if (options.rollingMode && options.rollingMode.follow) {
	          this.startRolling();
	        }
	        if ('start' in options || 'end' in options) {
	          // apply a new range. both start and end are optional
	          this.setRange(options.start, options.end);
	        }
	      }
	    }

	    /**
	     * Start auto refreshing the current time bar
	     */
	  }, {
	    key: "startRolling",
	    value: function startRolling() {
	      var me = this;

	      /**
	       *  Updates the current time.
	       */
	      function update() {
	        me.stopRolling();
	        me.rolling = true;
	        var interval = me.end - me.start;
	        var t = availableUtils.convert(new Date(), 'Date').valueOf();
	        var rollingModeOffset = me.options.rollingMode && me.options.rollingMode.offset || 0.5;
	        var start = t - interval * rollingModeOffset;
	        var end = t + interval * (1 - rollingModeOffset);
	        var options = {
	          animation: false
	        };
	        me.setRange(start, end, options);

	        // determine interval to refresh
	        var scale = me.conversion(me.body.domProps.center.width).scale;
	        interval = 1 / scale / 10;
	        if (interval < 30) interval = 30;
	        if (interval > 1000) interval = 1000;
	        me.body.dom.rollingModeBtn.style.visibility = "hidden";
	        // start a renderTimer to adjust for the new time
	        me.currentTimeTimer = _setTimeout(update, interval);
	      }
	      update();
	    }

	    /**
	     * Stop auto refreshing the current time bar
	     */
	  }, {
	    key: "stopRolling",
	    value: function stopRolling() {
	      if (this.currentTimeTimer !== undefined) {
	        clearTimeout(this.currentTimeTimer);
	        this.rolling = false;
	        this.body.dom.rollingModeBtn.style.visibility = "visible";
	      }
	    }

	    /**
	     * Set a new start and end range
	     * @param {Date | number | string} start
	     * @param {Date | number | string} end
	     * @param {Object} options      Available options:
	     *                              {boolean | {duration: number, easingFunction: string}} [animation=false]
	     *                                    If true, the range is animated
	     *                                    smoothly to the new window. An object can be
	     *                                    provided to specify duration and easing function.
	     *                                    Default duration is 500 ms, and default easing
	     *                                    function is 'easeInOutQuad'.
	     *                              {boolean} [byUser=false]
	     *                              {Event}  event  Mouse event
	     * @param {Function} callback     a callback function to be executed at the end of this function  
	     * @param {Function} frameCallback    a callback function executed each frame of the range animation.
	     *                                    The callback will be passed three parameters:
	     *                                    {number} easeCoefficient    an easing coefficent
	     *                                    {boolean} willDraw          If true the caller will redraw after the callback completes
	     *                                    {boolean} done              If true then animation is ending after the current frame
	     * @return {void}
	     */
	  }, {
	    key: "setRange",
	    value: function setRange(start, end, options, callback, frameCallback) {
	      if (!options) {
	        options = {};
	      }
	      if (options.byUser !== true) {
	        options.byUser = false;
	      }
	      var me = this;
	      var finalStart = start != undefined ? availableUtils.convert(start, 'Date').valueOf() : null;
	      var finalEnd = end != undefined ? availableUtils.convert(end, 'Date').valueOf() : null;
	      this._cancelAnimation();
	      this.millisecondsPerPixelCache = undefined;
	      if (options.animation) {
	        // true or an Object
	        var initStart = this.start;
	        var initEnd = this.end;
	        var duration = _typeof(options.animation) === 'object' && 'duration' in options.animation ? options.animation.duration : 500;
	        var easingName = _typeof(options.animation) === 'object' && 'easingFunction' in options.animation ? options.animation.easingFunction : 'easeInOutQuad';
	        var easingFunction = availableUtils.easingFunctions[easingName];
	        if (!easingFunction) {
	          var _context8;
	          throw new Error(_concatInstanceProperty(_context8 = "Unknown easing function ".concat(_JSON$stringify(easingName), ". Choose from: ")).call(_context8, _Object$keys(availableUtils.easingFunctions).join(', ')));
	        }
	        var initTime = _Date$now();
	        var anyChanged = false;
	        var next = function next() {
	          if (!me.props.touch.dragging) {
	            var now = _Date$now();
	            var time = now - initTime;
	            var ease = easingFunction(time / duration);
	            var done = time > duration;
	            var s = done || finalStart === null ? finalStart : initStart + (finalStart - initStart) * ease;
	            var e = done || finalEnd === null ? finalEnd : initEnd + (finalEnd - initEnd) * ease;
	            changed = me._applyRange(s, e);
	            updateHiddenDates(me.options.moment, me.body, me.options.hiddenDates);
	            anyChanged = anyChanged || changed;
	            var params = {
	              start: new Date(me.start),
	              end: new Date(me.end),
	              byUser: options.byUser,
	              event: options.event
	            };
	            if (frameCallback) {
	              frameCallback(ease, changed, done);
	            }
	            if (changed) {
	              me.body.emitter.emit('rangechange', params);
	            }
	            if (done) {
	              if (anyChanged) {
	                me.body.emitter.emit('rangechanged', params);
	                if (callback) {
	                  return callback();
	                }
	              }
	            } else {
	              // animate with as high as possible frame rate, leave 20 ms in between
	              // each to prevent the browser from blocking
	              me.animationTimer = _setTimeout(next, 20);
	            }
	          }
	        };
	        return next();
	      } else {
	        var changed = this._applyRange(finalStart, finalEnd);
	        updateHiddenDates(this.options.moment, this.body, this.options.hiddenDates);
	        if (changed) {
	          var params = {
	            start: new Date(this.start),
	            end: new Date(this.end),
	            byUser: options.byUser,
	            event: options.event
	          };
	          this.body.emitter.emit('rangechange', params);
	          clearTimeout(me.timeoutID);
	          me.timeoutID = _setTimeout(function () {
	            me.body.emitter.emit('rangechanged', params);
	          }, 200);
	          if (callback) {
	            return callback();
	          }
	        }
	      }
	    }

	    /**
	     * Get the number of milliseconds per pixel.
	     *
	     * @returns {undefined|number}
	     */
	  }, {
	    key: "getMillisecondsPerPixel",
	    value: function getMillisecondsPerPixel() {
	      if (this.millisecondsPerPixelCache === undefined) {
	        this.millisecondsPerPixelCache = (this.end - this.start) / this.body.dom.center.clientWidth;
	      }
	      return this.millisecondsPerPixelCache;
	    }

	    /**
	     * Stop an animation
	     * @private
	     */
	  }, {
	    key: "_cancelAnimation",
	    value: function _cancelAnimation() {
	      if (this.animationTimer) {
	        clearTimeout(this.animationTimer);
	        this.animationTimer = null;
	      }
	    }

	    /**
	     * Set a new start and end range. This method is the same as setRange, but
	     * does not trigger a range change and range changed event, and it returns
	     * true when the range is changed
	     * @param {number} [start]
	     * @param {number} [end]
	     * @return {boolean} changed
	     * @private
	     */
	  }, {
	    key: "_applyRange",
	    value: function _applyRange(start, end) {
	      var newStart = start != null ? availableUtils.convert(start, 'Date').valueOf() : this.start;
	      var newEnd = end != null ? availableUtils.convert(end, 'Date').valueOf() : this.end;
	      var max = this.options.max != null ? availableUtils.convert(this.options.max, 'Date').valueOf() : null;
	      var min = this.options.min != null ? availableUtils.convert(this.options.min, 'Date').valueOf() : null;
	      var diff;

	      // check for valid number
	      if (isNaN(newStart) || newStart === null) {
	        throw new Error("Invalid start \"".concat(start, "\""));
	      }
	      if (isNaN(newEnd) || newEnd === null) {
	        throw new Error("Invalid end \"".concat(end, "\""));
	      }

	      // prevent end < start
	      if (newEnd < newStart) {
	        newEnd = newStart;
	      }

	      // prevent start < min
	      if (min !== null) {
	        if (newStart < min) {
	          diff = min - newStart;
	          newStart += diff;
	          newEnd += diff;

	          // prevent end > max
	          if (max != null) {
	            if (newEnd > max) {
	              newEnd = max;
	            }
	          }
	        }
	      }

	      // prevent end > max
	      if (max !== null) {
	        if (newEnd > max) {
	          diff = newEnd - max;
	          newStart -= diff;
	          newEnd -= diff;

	          // prevent start < min
	          if (min != null) {
	            if (newStart < min) {
	              newStart = min;
	            }
	          }
	        }
	      }

	      // prevent (end-start) < zoomMin
	      if (this.options.zoomMin !== null) {
	        var zoomMin = _parseFloat(this.options.zoomMin);
	        if (zoomMin < 0) {
	          zoomMin = 0;
	        }
	        if (newEnd - newStart < zoomMin) {
	          // compensate for a scale of 0.5 ms
	          var compensation = 0.5;
	          if (this.end - this.start === zoomMin && newStart >= this.start - compensation && newEnd <= this.end) {
	            // ignore this action, we are already zoomed to the minimum
	            newStart = this.start;
	            newEnd = this.end;
	          } else {
	            // zoom to the minimum
	            diff = zoomMin - (newEnd - newStart);
	            newStart -= diff / 2;
	            newEnd += diff / 2;
	          }
	        }
	      }

	      // prevent (end-start) > zoomMax
	      if (this.options.zoomMax !== null) {
	        var zoomMax = _parseFloat(this.options.zoomMax);
	        if (zoomMax < 0) {
	          zoomMax = 0;
	        }
	        if (newEnd - newStart > zoomMax) {
	          if (this.end - this.start === zoomMax && newStart < this.start && newEnd > this.end) {
	            // ignore this action, we are already zoomed to the maximum
	            newStart = this.start;
	            newEnd = this.end;
	          } else {
	            // zoom to the maximum
	            diff = newEnd - newStart - zoomMax;
	            newStart += diff / 2;
	            newEnd -= diff / 2;
	          }
	        }
	      }
	      var changed = this.start != newStart || this.end != newEnd;

	      // if the new range does NOT overlap with the old range, emit checkRangedItems to avoid not showing ranged items (ranged meaning has end time, not necessarily of type Range)
	      if (!(newStart >= this.start && newStart <= this.end || newEnd >= this.start && newEnd <= this.end) && !(this.start >= newStart && this.start <= newEnd || this.end >= newStart && this.end <= newEnd)) {
	        this.body.emitter.emit('checkRangedItems');
	      }
	      this.start = newStart;
	      this.end = newEnd;
	      return changed;
	    }

	    /**
	     * Retrieve the current range.
	     * @return {Object} An object with start and end properties
	     */
	  }, {
	    key: "getRange",
	    value: function getRange() {
	      return {
	        start: this.start,
	        end: this.end
	      };
	    }

	    /**
	     * Calculate the conversion offset and scale for current range, based on
	     * the provided width
	     * @param {number} width
	     * @param {number} [totalHidden=0]
	     * @returns {{offset: number, scale: number}} conversion
	     */
	  }, {
	    key: "conversion",
	    value: function conversion(width, totalHidden) {
	      return Range.conversion(this.start, this.end, width, totalHidden);
	    }

	    /**
	     * Static method to calculate the conversion offset and scale for a range,
	     * based on the provided start, end, and width
	     * @param {number} start
	     * @param {number} end
	     * @param {number} width
	     * @param {number} [totalHidden=0]
	     * @returns {{offset: number, scale: number}} conversion
	     */
	  }, {
	    key: "_onDragStart",
	    value:
	    /**
	     * Start dragging horizontally or vertically
	     * @param {Event} event
	     * @private
	     */
	    function _onDragStart(event) {
	      this.deltaDifference = 0;
	      this.previousDelta = 0;

	      // only allow dragging when configured as movable
	      if (!this.options.moveable) return;

	      // only start dragging when the mouse is inside the current range
	      if (!this._isInsideRange(event)) return;

	      // refuse to drag when we where pinching to prevent the timeline make a jump
	      // when releasing the fingers in opposite order from the touch screen
	      if (!this.props.touch.allowDragging) return;
	      this.stopRolling();
	      this.props.touch.start = this.start;
	      this.props.touch.end = this.end;
	      this.props.touch.dragging = true;
	      if (this.body.dom.root) {
	        this.body.dom.root.style.cursor = 'move';
	      }
	    }

	    /**
	     * Perform dragging operation
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onDrag",
	    value: function _onDrag(event) {
	      if (!event) return;
	      if (!this.props.touch.dragging) return;

	      // only allow dragging when configured as movable
	      if (!this.options.moveable) return;

	      // TODO: this may be redundant in hammerjs2
	      // refuse to drag when we where pinching to prevent the timeline make a jump
	      // when releasing the fingers in opposite order from the touch screen
	      if (!this.props.touch.allowDragging) return;
	      var direction = this.options.direction;
	      validateDirection(direction);
	      var delta = direction == 'horizontal' ? event.deltaX : event.deltaY;
	      delta -= this.deltaDifference;
	      var interval = this.props.touch.end - this.props.touch.start;

	      // normalize dragging speed if cutout is in between.
	      var duration = getHiddenDurationBetween(this.body.hiddenDates, this.start, this.end);
	      interval -= duration;
	      var width = direction == 'horizontal' ? this.body.domProps.center.width : this.body.domProps.center.height;
	      var diffRange;
	      if (this.options.rtl) {
	        diffRange = delta / width * interval;
	      } else {
	        diffRange = -delta / width * interval;
	      }
	      var newStart = this.props.touch.start + diffRange;
	      var newEnd = this.props.touch.end + diffRange;

	      // snapping times away from hidden zones
	      var safeStart = snapAwayFromHidden(this.body.hiddenDates, newStart, this.previousDelta - delta, true);
	      var safeEnd = snapAwayFromHidden(this.body.hiddenDates, newEnd, this.previousDelta - delta, true);
	      if (safeStart != newStart || safeEnd != newEnd) {
	        this.deltaDifference += delta;
	        this.props.touch.start = safeStart;
	        this.props.touch.end = safeEnd;
	        this._onDrag(event);
	        return;
	      }
	      this.previousDelta = delta;
	      this._applyRange(newStart, newEnd);
	      var startDate = new Date(this.start);
	      var endDate = new Date(this.end);

	      // fire a rangechange event
	      this.body.emitter.emit('rangechange', {
	        start: startDate,
	        end: endDate,
	        byUser: true,
	        event: event
	      });

	      // fire a panmove event
	      this.body.emitter.emit('panmove');
	    }

	    /**
	     * Stop dragging operation
	     * @param {event} event
	     * @private
	     */
	  }, {
	    key: "_onDragEnd",
	    value: function _onDragEnd(event) {
	      if (!this.props.touch.dragging) return;

	      // only allow dragging when configured as movable
	      if (!this.options.moveable) return;

	      // TODO: this may be redundant in hammerjs2
	      // refuse to drag when we where pinching to prevent the timeline make a jump
	      // when releasing the fingers in opposite order from the touch screen
	      if (!this.props.touch.allowDragging) return;
	      this.props.touch.dragging = false;
	      if (this.body.dom.root) {
	        this.body.dom.root.style.cursor = 'auto';
	      }

	      // fire a rangechanged event
	      this.body.emitter.emit('rangechanged', {
	        start: new Date(this.start),
	        end: new Date(this.end),
	        byUser: true,
	        event: event
	      });
	    }

	    /**
	     * Event handler for mouse wheel event, used to zoom
	     * Code from http://adomas.org/javascript-mouse-wheel/
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onMouseWheel",
	    value: function _onMouseWheel(event) {
	      // retrieve delta
	      var delta = 0;
	      if (event.wheelDelta) {
	        /* IE/Opera. */
	        delta = event.wheelDelta / 120;
	      } else if (event.detail) {
	        /* Mozilla case. */
	        // In Mozilla, sign of delta is different than in IE.
	        // Also, delta is multiple of 3.
	        delta = -event.detail / 3;
	      } else if (event.deltaY) {
	        delta = -event.deltaY / 3;
	      }

	      // don't allow zoom when the according key is pressed and the zoomKey option or not zoomable but movable
	      if (this.options.zoomKey && !event[this.options.zoomKey] && this.options.zoomable || !this.options.zoomable && this.options.moveable) {
	        return;
	      }

	      // only allow zooming when configured as zoomable and moveable
	      if (!(this.options.zoomable && this.options.moveable)) return;

	      // only zoom when the mouse is inside the current range
	      if (!this._isInsideRange(event)) return;

	      // If delta is nonzero, handle it.
	      // Basically, delta is now positive if wheel was scrolled up,
	      // and negative, if wheel was scrolled down.
	      if (delta) {
	        // perform the zoom action. Delta is normally 1 or -1

	        // adjust a negative delta such that zooming in with delta 0.1
	        // equals zooming out with a delta -0.1

	        var zoomFriction = this.options.zoomFriction || 5;
	        var scale;
	        if (delta < 0) {
	          scale = 1 - delta / zoomFriction;
	        } else {
	          scale = 1 / (1 + delta / zoomFriction);
	        }

	        // calculate center, the date to zoom around
	        var pointerDate;
	        if (this.rolling) {
	          var rollingModeOffset = this.options.rollingMode && this.options.rollingMode.offset || 0.5;
	          pointerDate = this.start + (this.end - this.start) * rollingModeOffset;
	        } else {
	          var pointer = this.getPointer({
	            x: event.clientX,
	            y: event.clientY
	          }, this.body.dom.center);
	          pointerDate = this._pointerToDate(pointer);
	        }
	        this.zoom(scale, pointerDate, delta, event);

	        // Prevent default actions caused by mouse wheel
	        // (else the page and timeline both scroll)
	        event.preventDefault();
	      }
	    }

	    /**
	     * Start of a touch gesture
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onTouch",
	    value: function _onTouch(event) {
	      // eslint-disable-line no-unused-vars
	      this.props.touch.start = this.start;
	      this.props.touch.end = this.end;
	      this.props.touch.allowDragging = true;
	      this.props.touch.center = null;
	      this.props.touch.centerDate = null;
	      this.scaleOffset = 0;
	      this.deltaDifference = 0;
	      // Disable the browser default handling of this event.
	      availableUtils.preventDefault(event);
	    }

	    /**
	     * Handle pinch event
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onPinch",
	    value: function _onPinch(event) {
	      // only allow zooming when configured as zoomable and moveable
	      if (!(this.options.zoomable && this.options.moveable)) return;

	      // Disable the browser default handling of this event.
	      availableUtils.preventDefault(event);
	      this.props.touch.allowDragging = false;
	      if (!this.props.touch.center) {
	        this.props.touch.center = this.getPointer(event.center, this.body.dom.center);
	        this.props.touch.centerDate = this._pointerToDate(this.props.touch.center);
	      }
	      this.stopRolling();
	      var scale = 1 / (event.scale + this.scaleOffset);
	      var centerDate = this.props.touch.centerDate;
	      var hiddenDuration = getHiddenDurationBetween(this.body.hiddenDates, this.start, this.end);
	      var hiddenDurationBefore = getHiddenDurationBefore(this.options.moment, this.body.hiddenDates, this, centerDate);
	      var hiddenDurationAfter = hiddenDuration - hiddenDurationBefore;

	      // calculate new start and end
	      var newStart = centerDate - hiddenDurationBefore + (this.props.touch.start - (centerDate - hiddenDurationBefore)) * scale;
	      var newEnd = centerDate + hiddenDurationAfter + (this.props.touch.end - (centerDate + hiddenDurationAfter)) * scale;

	      // snapping times away from hidden zones
	      this.startToFront = 1 - scale <= 0; // used to do the right auto correction with periodic hidden times
	      this.endToFront = scale - 1 <= 0; // used to do the right auto correction with periodic hidden times

	      var safeStart = snapAwayFromHidden(this.body.hiddenDates, newStart, 1 - scale, true);
	      var safeEnd = snapAwayFromHidden(this.body.hiddenDates, newEnd, scale - 1, true);
	      if (safeStart != newStart || safeEnd != newEnd) {
	        this.props.touch.start = safeStart;
	        this.props.touch.end = safeEnd;
	        this.scaleOffset = 1 - event.scale;
	        newStart = safeStart;
	        newEnd = safeEnd;
	      }
	      var options = {
	        animation: false,
	        byUser: true,
	        event: event
	      };
	      this.setRange(newStart, newEnd, options);
	      this.startToFront = false; // revert to default
	      this.endToFront = true; // revert to default
	    }

	    /**
	     * Test whether the mouse from a mouse event is inside the visible window,
	     * between the current start and end date
	     * @param {Object} event
	     * @return {boolean} Returns true when inside the visible window
	     * @private
	     */
	  }, {
	    key: "_isInsideRange",
	    value: function _isInsideRange(event) {
	      // calculate the time where the mouse is, check whether inside
	      // and no scroll action should happen.
	      var clientX = event.center ? event.center.x : event.clientX;
	      var centerContainerRect = this.body.dom.centerContainer.getBoundingClientRect();
	      var x = this.options.rtl ? clientX - centerContainerRect.left : centerContainerRect.right - clientX;
	      var time = this.body.util.toTime(x);
	      return time >= this.start && time <= this.end;
	    }

	    /**
	     * Helper function to calculate the center date for zooming
	     * @param {{x: number, y: number}} pointer
	     * @return {number} date
	     * @private
	     */
	  }, {
	    key: "_pointerToDate",
	    value: function _pointerToDate(pointer) {
	      var conversion;
	      var direction = this.options.direction;
	      validateDirection(direction);
	      if (direction == 'horizontal') {
	        return this.body.util.toTime(pointer.x).valueOf();
	      } else {
	        var height = this.body.domProps.center.height;
	        conversion = this.conversion(height);
	        return pointer.y / conversion.scale + conversion.offset;
	      }
	    }

	    /**
	     * Get the pointer location relative to the location of the dom element
	     * @param {{x: number, y: number}} touch
	     * @param {Element} element   HTML DOM element
	     * @return {{x: number, y: number}} pointer
	     * @private
	     */
	  }, {
	    key: "getPointer",
	    value: function getPointer(touch, element) {
	      var elementRect = element.getBoundingClientRect();
	      if (this.options.rtl) {
	        return {
	          x: elementRect.right - touch.x,
	          y: touch.y - elementRect.top
	        };
	      } else {
	        return {
	          x: touch.x - elementRect.left,
	          y: touch.y - elementRect.top
	        };
	      }
	    }

	    /**
	     * Zoom the range the given scale in or out. Start and end date will
	     * be adjusted, and the timeline will be redrawn. You can optionally give a
	     * date around which to zoom.
	     * For example, try scale = 0.9 or 1.1
	     * @param {number} scale      Scaling factor. Values above 1 will zoom out,
	     *                            values below 1 will zoom in.
	     * @param {number} [center]   Value representing a date around which will
	     *                            be zoomed.
	     * @param {number} delta
	     * @param {Event} event
	     */
	  }, {
	    key: "zoom",
	    value: function zoom(scale, center, delta, event) {
	      // if centerDate is not provided, take it half between start Date and end Date
	      if (center == null) {
	        center = (this.start + this.end) / 2;
	      }
	      var hiddenDuration = getHiddenDurationBetween(this.body.hiddenDates, this.start, this.end);
	      var hiddenDurationBefore = getHiddenDurationBefore(this.options.moment, this.body.hiddenDates, this, center);
	      var hiddenDurationAfter = hiddenDuration - hiddenDurationBefore;

	      // calculate new start and end
	      var newStart = center - hiddenDurationBefore + (this.start - (center - hiddenDurationBefore)) * scale;
	      var newEnd = center + hiddenDurationAfter + (this.end - (center + hiddenDurationAfter)) * scale;

	      // snapping times away from hidden zones
	      this.startToFront = delta > 0 ? false : true; // used to do the right autocorrection with periodic hidden times
	      this.endToFront = -delta > 0 ? false : true; // used to do the right autocorrection with periodic hidden times
	      var safeStart = snapAwayFromHidden(this.body.hiddenDates, newStart, delta, true);
	      var safeEnd = snapAwayFromHidden(this.body.hiddenDates, newEnd, -delta, true);
	      if (safeStart != newStart || safeEnd != newEnd) {
	        newStart = safeStart;
	        newEnd = safeEnd;
	      }
	      var options = {
	        animation: false,
	        byUser: true,
	        event: event
	      };
	      this.setRange(newStart, newEnd, options);
	      this.startToFront = false; // revert to default
	      this.endToFront = true; // revert to default
	    }

	    /**
	     * Move the range with a given delta to the left or right. Start and end
	     * value will be adjusted. For example, try delta = 0.1 or -0.1
	     * @param {number}  delta     Moving amount. Positive value will move right,
	     *                            negative value will move left
	     */
	  }, {
	    key: "move",
	    value: function move(delta) {
	      // zoom start Date and end Date relative to the centerDate
	      var diff = this.end - this.start;

	      // apply new values
	      var newStart = this.start + diff * delta;
	      var newEnd = this.end + diff * delta;

	      // TODO: reckon with min and max range

	      this.start = newStart;
	      this.end = newEnd;
	    }

	    /**
	     * Move the range to a new center point
	     * @param {number} moveTo      New center point of the range
	     */
	  }, {
	    key: "moveTo",
	    value: function moveTo(_moveTo) {
	      var center = (this.start + this.end) / 2;
	      var diff = center - _moveTo;

	      // calculate new start and end
	      var newStart = this.start - diff;
	      var newEnd = this.end - diff;
	      var options = {
	        animation: false,
	        byUser: true,
	        event: null
	      };
	      this.setRange(newStart, newEnd, options);
	    }
	  }], [{
	    key: "conversion",
	    value: function conversion(start, end, width, totalHidden) {
	      if (totalHidden === undefined) {
	        totalHidden = 0;
	      }
	      if (width != 0 && end - start != 0) {
	        return {
	          offset: start,
	          scale: width / (end - start - totalHidden)
	        };
	      } else {
	        return {
	          offset: 0,
	          scale: 1
	        };
	      }
	    }
	  }]);
	  return Range;
	}(Component);
	function validateDirection(direction) {
	  if (direction != 'horizontal' && direction != 'vertical') {
	    throw new TypeError("Unknown direction \"".concat(direction, "\". Choose \"horizontal\" or \"vertical\"."));
	  }
	}

	var someExports = {};
	var some$3 = {
	  get exports(){ return someExports; },
	  set exports(v){ someExports = v; },
	};

	var $$5 = _export;
	var $some = arrayIteration.some;
	var arrayMethodIsStrict$1 = arrayMethodIsStrict$6;

	var STRICT_METHOD$1 = arrayMethodIsStrict$1('some');

	// `Array.prototype.some` method
	// https://tc39.es/ecma262/#sec-array.prototype.some
	$$5({ target: 'Array', proto: true, forced: !STRICT_METHOD$1 }, {
	  some: function some(callbackfn /* , thisArg */) {
	    return $some(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$3 = entryVirtual$k;

	var some$2 = entryVirtual$3('Array').some;

	var isPrototypeOf$5 = objectIsPrototypeOf;
	var method$3 = some$2;

	var ArrayPrototype$3 = Array.prototype;

	var some$1 = function (it) {
	  var own = it.some;
	  return it === ArrayPrototype$3 || (isPrototypeOf$5(ArrayPrototype$3, it) && own === ArrayPrototype$3.some) ? method$3 : own;
	};

	var parent$4 = some$1;

	var some = parent$4;

	(function (module) {
		module.exports = some;
	} (some$3));

	var _someInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(someExports);

	var setIntervalExports = {};
	var setInterval$1 = {
	  get exports(){ return setIntervalExports; },
	  set exports(v){ setIntervalExports = v; },
	};

	var path$1 = path$r;

	var setInterval = path$1.setInterval;

	(function (module) {
		module.exports = setInterval;
	} (setInterval$1));

	var _setInterval = /*@__PURE__*/getDefaultExportFromCjs(setIntervalExports);

	var _firstTarget = null; // singleton, will contain the target element where the touch event started

	/**
	 * Extend an Hammer.js instance with event propagation.
	 *
	 * Features:
	 * - Events emitted by hammer will propagate in order from child to parent
	 *   elements.
	 * - Events are extended with a function `event.stopPropagation()` to stop
	 *   propagation to parent elements.
	 * - An option `preventDefault` to stop all default browser behavior.
	 *
	 * Usage:
	 *   var hammer = propagatingHammer(new Hammer(element));
	 *   var hammer = propagatingHammer(new Hammer(element), {preventDefault: true});
	 *
	 * @param {Hammer.Manager} hammer   An hammer instance.
	 * @param {Object} [options]        Available options:
	 *                                  - `preventDefault: true | false | 'mouse' | 'touch' | 'pen'`.
	 *                                    Enforce preventing the default browser behavior.
	 *                                    Cannot be set to `false`.
	 * @return {Hammer.Manager} Returns the same hammer instance with extended
	 *                          functionality
	 */
	function propagating(hammer, options) {
	  var _options = options || {
	    preventDefault: false
	  };

	  if (hammer.Manager) {
	    // This looks like the Hammer constructor.
	    // Overload the constructors with our own.
	    var Hammer = hammer;

	    var PropagatingHammer = function(element, options) {
	      var o = Object.create(_options);
	      if (options) Hammer.assign(o, options);
	      return propagating(new Hammer(element, o), o);
	    };
	    Hammer.assign(PropagatingHammer, Hammer);

	    PropagatingHammer.Manager = function (element, options) {
	      var o = Object.create(_options);
	      if (options) Hammer.assign(o, options);
	      return propagating(new Hammer.Manager(element, o), o);
	    };

	    return PropagatingHammer;
	  }

	  // create a wrapper object which will override the functions
	  // `on`, `off`, `destroy`, and `emit` of the hammer instance
	  var wrapper = Object.create(hammer);

	  // attach to DOM element
	  var element = hammer.element;

	  if(!element.hammer) element.hammer = [];
	  element.hammer.push(wrapper);

	  // register an event to catch the start of a gesture and store the
	  // target in a singleton
	  hammer.on('hammer.input', function (event) {
	    if (_options.preventDefault === true || (_options.preventDefault === event.pointerType)) {
	      event.preventDefault();
	    }
	    if (event.isFirst) {
	      _firstTarget = event.target;
	    }
	  });

	  /** @type {Object.<String, Array.<function>>} */
	  wrapper._handlers = {};

	  /**
	   * Register a handler for one or multiple events
	   * @param {String} events    A space separated string with events
	   * @param {function} handler A callback function, called as handler(event)
	   * @returns {Hammer.Manager} Returns the hammer instance
	   */
	  wrapper.on = function (events, handler) {
	    // register the handler
	    split(events).forEach(function (event) {
	      var _handlers = wrapper._handlers[event];
	      if (!_handlers) {
	        wrapper._handlers[event] = _handlers = [];

	        // register the static, propagated handler
	        hammer.on(event, propagatedHandler);
	      }
	      _handlers.push(handler);
	    });

	    return wrapper;
	  };

	  /**
	   * Unregister a handler for one or multiple events
	   * @param {String} events      A space separated string with events
	   * @param {function} [handler] Optional. The registered handler. If not
	   *                             provided, all handlers for given events
	   *                             are removed.
	   * @returns {Hammer.Manager}   Returns the hammer instance
	   */
	  wrapper.off = function (events, handler) {
	    // unregister the handler
	    split(events).forEach(function (event) {
	      var _handlers = wrapper._handlers[event];
	      if (_handlers) {
	        _handlers = handler ? _handlers.filter(function (h) {
	          return h !== handler;
	        }) : [];

	        if (_handlers.length > 0) {
	          wrapper._handlers[event] = _handlers;
	        }
	        else {
	          // remove static, propagated handler
	          hammer.off(event, propagatedHandler);
	          delete wrapper._handlers[event];
	        }
	      }
	    });

	    return wrapper;
	  };

	  /**
	   * Emit to the event listeners
	   * @param {string} eventType
	   * @param {Event} event
	   */
	  wrapper.emit = function(eventType, event) {
	    _firstTarget = event.target;
	    hammer.emit(eventType, event);
	  };

	  wrapper.destroy = function () {
	    // Detach from DOM element
	    var hammers = hammer.element.hammer;
	    var idx = hammers.indexOf(wrapper);
	    if(idx !== -1) hammers.splice(idx,1);
	    if(!hammers.length) delete hammer.element.hammer;

	    // clear all handlers
	    wrapper._handlers = {};

	    // call original hammer destroy
	    hammer.destroy();
	  };

	  // split a string with space separated words
	  function split(events) {
	    return events.match(/[^ ]+/g);
	  }

	  /**
	   * A static event handler, applying event propagation.
	   * @param {Object} event
	   */
	  function propagatedHandler(event) {
	    // let only a single hammer instance handle this event
	    if (event.type !== 'hammer.input') {
	      // it is possible that the same srcEvent is used with multiple hammer events,
	      // we keep track on which events are handled in an object _handled
	      if (!event.srcEvent._handled) {
	        event.srcEvent._handled = {};
	      }

	      if (event.srcEvent._handled[event.type]) {
	        return;
	      }
	      else {
	        event.srcEvent._handled[event.type] = true;
	      }
	    }

	    // attach a stopPropagation function to the event
	    var stopped = false;
	    event.stopPropagation = function () {
	      stopped = true;
	    };

	    //wrap the srcEvent's stopPropagation to also stop hammer propagation:
	    var srcStop = event.srcEvent.stopPropagation.bind(event.srcEvent);
	    if(typeof srcStop == "function") {
	      event.srcEvent.stopPropagation = function(){
	        srcStop();
	        event.stopPropagation();
	      };
	    }

	    // attach firstTarget property to the event
	    event.firstTarget = _firstTarget;

	    // propagate over all elements (until stopped)
	    var elem = _firstTarget;
	    while (elem && !stopped) {
	      var elemHammer = elem.hammer;
	      if(elemHammer){
	        var _handlers;
	        for(var k = 0; k < elemHammer.length; k++){
	          _handlers = elemHammer[k]._handlers[event.type];
	          if(_handlers) for (var i = 0; i < _handlers.length && !stopped; i++) {
	            _handlers[i](event);
	          }
	        }
	      }
	      elem = elem.parentNode;
	    }
	  }

	  return wrapper;
	}

	/**
	 * Setup a mock hammer.js object, for unit testing.
	 *
	 * Inspiration: https://github.com/uber/deck.gl/pull/658
	 *
	 * @returns {{on: noop, off: noop, destroy: noop, emit: noop, get: get}}
	 */
	function hammerMock() {
	  var noop = function noop() {};
	  return {
	    on: noop,
	    off: noop,
	    destroy: noop,
	    emit: noop,
	    get: function get(m) {
	      //eslint-disable-line no-unused-vars
	      return {
	        set: noop
	      };
	    }
	  };
	}
	var modifiedHammer;
	if (typeof window !== 'undefined') {
	  var OurHammer = window['Hammer'] || Hammer$4;
	  modifiedHammer = propagating(OurHammer, {
	    preventDefault: 'mouse'
	  });
	} else {
	  modifiedHammer = function modifiedHammer() {
	    return (
	      // hammer.js is only available in a browser, not in node.js. Replacing it with a mock object.
	      hammerMock()
	    );
	  };
	}
	var Hammer = modifiedHammer;

	/**
	 * Register a touch event, taking place before a gesture
	 * @param {Hammer} hammer       A hammer instance
	 * @param {function} callback   Callback, called as callback(event)
	 */
	function onTouch(hammer, callback) {
	  callback.inputHandler = function (event) {
	    if (event.isFirst) {
	      callback(event);
	    }
	  };
	  hammer.on('hammer.input', callback.inputHandler);
	}

	/**
	 * Register a release event, taking place after a gesture
	 * @param {Hammer} hammer       A hammer instance
	 * @param {function} callback   Callback, called as callback(event)
	 * @returns {*}
	 */
	function onRelease(hammer, callback) {
	  callback.inputHandler = function (event) {
	    if (event.isFinal) {
	      callback(event);
	    }
	  };
	  return hammer.on('hammer.input', callback.inputHandler);
	}

	/**
	 * Hack the PinchRecognizer such that it doesn't prevent default behavior
	 * for vertical panning.
	 *
	 * Yeah ... this is quite a hack ... see https://github.com/hammerjs/hammer.js/issues/932
	 *
	 * @param {Hammer.Pinch} pinchRecognizer
	 * @return {Hammer.Pinch} returns the pinchRecognizer
	 */
	function disablePreventDefaultVertically(pinchRecognizer) {
	  var TOUCH_ACTION_PAN_Y = 'pan-y';
	  pinchRecognizer.getTouchAction = function () {
	    // default method returns [TOUCH_ACTION_NONE]
	    return [TOUCH_ACTION_PAN_Y];
	  };
	  return pinchRecognizer;
	}

	/**
	 * The class TimeStep is an iterator for dates. You provide a start date and an
	 * end date. The class itself determines the best scale (step size) based on the
	 * provided start Date, end Date, and minimumStep.
	 *
	 * If minimumStep is provided, the step size is chosen as close as possible
	 * to the minimumStep but larger than minimumStep. If minimumStep is not
	 * provided, the scale is set to 1 DAY.
	 * The minimumStep should correspond with the onscreen size of about 6 characters
	 *
	 * Alternatively, you can set a scale by hand.
	 * After creation, you can initialize the class by executing first(). Then you
	 * can iterate from the start date to the end date via next(). You can check if
	 * the end date is reached with the function hasNext(). After each step, you can
	 * retrieve the current date via getCurrent().
	 * The TimeStep has scales ranging from milliseconds, seconds, minutes, hours,
	 * days, to years.
	 *
	 * Version: 1.2
	 *
	 */
	var TimeStep = /*#__PURE__*/function () {
	  /**
	    * @param {Date} [start]         The start date, for example new Date(2010, 9, 21)
	    *                               or new Date(2010, 9, 21, 23, 45, 00)
	    * @param {Date} [end]           The end date
	    * @param {number} [minimumStep] Optional. Minimum step size in milliseconds
	    * @param {Date|Array.<Date>} [hiddenDates] Optional.
	    * @param {{showMajorLabels: boolean, showWeekScale: boolean}} [options] Optional.
	    * @constructor  TimeStep
	    */
	  function TimeStep(start, end, minimumStep, hiddenDates, options) {
	    _classCallCheck(this, TimeStep);
	    this.moment = options && options.moment || moment$2;
	    this.options = options ? options : {};

	    // variables
	    this.current = this.moment();
	    this._start = this.moment();
	    this._end = this.moment();
	    this.autoScale = true;
	    this.scale = 'day';
	    this.step = 1;

	    // initialize the range
	    this.setRange(start, end, minimumStep);

	    // hidden Dates options
	    this.switchedDay = false;
	    this.switchedMonth = false;
	    this.switchedYear = false;
	    if (_Array$isArray$1(hiddenDates)) {
	      this.hiddenDates = hiddenDates;
	    } else if (hiddenDates != undefined) {
	      this.hiddenDates = [hiddenDates];
	    } else {
	      this.hiddenDates = [];
	    }
	    this.format = TimeStep.FORMAT; // default formatting
	  }

	  /**
	   * Set custom constructor function for moment. Can be used to set dates
	   * to UTC or to set a utcOffset.
	   * @param {function} moment
	   */
	  _createClass(TimeStep, [{
	    key: "setMoment",
	    value: function setMoment(moment) {
	      this.moment = moment;

	      // update the date properties, can have a new utcOffset
	      this.current = this.moment(this.current.valueOf());
	      this._start = this.moment(this._start.valueOf());
	      this._end = this.moment(this._end.valueOf());
	    }

	    /**
	     * Set custom formatting for the minor an major labels of the TimeStep.
	     * Both `minorLabels` and `majorLabels` are an Object with properties:
	     * 'millisecond', 'second', 'minute', 'hour', 'weekday', 'day', 'week', 'month', 'year'.
	     * @param {{minorLabels: Object, majorLabels: Object}} format
	     */
	  }, {
	    key: "setFormat",
	    value: function setFormat(format) {
	      var defaultFormat = availableUtils.deepExtend({}, TimeStep.FORMAT);
	      this.format = availableUtils.deepExtend(defaultFormat, format);
	    }

	    /**
	     * Set a new range
	     * If minimumStep is provided, the step size is chosen as close as possible
	     * to the minimumStep but larger than minimumStep. If minimumStep is not
	     * provided, the scale is set to 1 DAY.
	     * The minimumStep should correspond with the onscreen size of about 6 characters
	     * @param {Date} [start]      The start date and time.
	     * @param {Date} [end]        The end date and time.
	     * @param {int} [minimumStep] Optional. Minimum step size in milliseconds
	     */
	  }, {
	    key: "setRange",
	    value: function setRange(start, end, minimumStep) {
	      if (!(start instanceof Date) || !(end instanceof Date)) {
	        throw "No legal start or end date in method setRange";
	      }
	      this._start = start != undefined ? this.moment(start.valueOf()) : _Date$now();
	      this._end = end != undefined ? this.moment(end.valueOf()) : _Date$now();
	      if (this.autoScale) {
	        this.setMinimumStep(minimumStep);
	      }
	    }

	    /**
	     * Set the range iterator to the start date.
	     */
	  }, {
	    key: "start",
	    value: function start() {
	      this.current = this._start.clone();
	      this.roundToMinor();
	    }

	    /**
	     * Round the current date to the first minor date value
	     * This must be executed once when the current date is set to start Date
	     */
	  }, {
	    key: "roundToMinor",
	    value: function roundToMinor() {
	      // round to floor
	      // to prevent year & month scales rounding down to the first day of week we perform this separately
	      if (this.scale == 'week') {
	        this.current.weekday(0);
	      }
	      // IMPORTANT: we have no breaks in this switch! (this is no bug)
	      // noinspection FallThroughInSwitchStatementJS
	      switch (this.scale) {
	        case 'year':
	          this.current.year(this.step * Math.floor(this.current.year() / this.step));
	          this.current.month(0);
	        // eslint-disable-line no-fallthrough
	        case 'month':
	          this.current.date(1);
	        // eslint-disable-line no-fallthrough
	        case 'week': // eslint-disable-line no-fallthrough
	        case 'day': // eslint-disable-line no-fallthrough
	        case 'weekday':
	          this.current.hours(0);
	        // eslint-disable-line no-fallthrough
	        case 'hour':
	          this.current.minutes(0);
	        // eslint-disable-line no-fallthrough
	        case 'minute':
	          this.current.seconds(0);
	        // eslint-disable-line no-fallthrough
	        case 'second':
	          this.current.milliseconds(0);
	        // eslint-disable-line no-fallthrough
	        //case 'millisecond': // nothing to do for milliseconds
	      }

	      if (this.step != 1) {
	        // round down to the first minor value that is a multiple of the current step size
	        var priorCurrent = this.current.clone();
	        switch (this.scale) {
	          case 'millisecond':
	            this.current.subtract(this.current.milliseconds() % this.step, 'milliseconds');
	            break;
	          case 'second':
	            this.current.subtract(this.current.seconds() % this.step, 'seconds');
	            break;
	          case 'minute':
	            this.current.subtract(this.current.minutes() % this.step, 'minutes');
	            break;
	          case 'hour':
	            this.current.subtract(this.current.hours() % this.step, 'hours');
	            break;
	          case 'weekday': // intentional fall through
	          case 'day':
	            this.current.subtract((this.current.date() - 1) % this.step, 'day');
	            break;
	          case 'week':
	            this.current.subtract(this.current.week() % this.step, 'week');
	            break;
	          case 'month':
	            this.current.subtract(this.current.month() % this.step, 'month');
	            break;
	          case 'year':
	            this.current.subtract(this.current.year() % this.step, 'year');
	            break;
	        }
	        if (!priorCurrent.isSame(this.current)) {
	          this.current = this.moment(snapAwayFromHidden(this.hiddenDates, this.current.valueOf(), -1, true));
	        }
	      }
	    }

	    /**
	     * Check if the there is a next step
	     * @return {boolean}  true if the current date has not passed the end date
	     */
	  }, {
	    key: "hasNext",
	    value: function hasNext() {
	      return this.current.valueOf() <= this._end.valueOf();
	    }

	    /**
	     * Do the next step
	     */
	  }, {
	    key: "next",
	    value: function next() {
	      var prev = this.current.valueOf();

	      // Two cases, needed to prevent issues with switching daylight savings
	      // (end of March and end of October)
	      switch (this.scale) {
	        case 'millisecond':
	          this.current.add(this.step, 'millisecond');
	          break;
	        case 'second':
	          this.current.add(this.step, 'second');
	          break;
	        case 'minute':
	          this.current.add(this.step, 'minute');
	          break;
	        case 'hour':
	          this.current.add(this.step, 'hour');
	          if (this.current.month() < 6) {
	            this.current.subtract(this.current.hours() % this.step, 'hour');
	          } else {
	            if (this.current.hours() % this.step !== 0) {
	              this.current.add(this.step - this.current.hours() % this.step, 'hour');
	            }
	          }
	          break;
	        case 'weekday': // intentional fall through
	        case 'day':
	          this.current.add(this.step, 'day');
	          break;
	        case 'week':
	          if (this.current.weekday() !== 0) {
	            // we had a month break not correlating with a week's start before
	            this.current.weekday(0); // switch back to week cycles
	            this.current.add(this.step, 'week');
	          } else if (this.options.showMajorLabels === false) {
	            this.current.add(this.step, 'week'); // the default case
	          } else {
	            // first day of the week
	            var nextWeek = this.current.clone();
	            nextWeek.add(1, 'week');
	            if (nextWeek.isSame(this.current, 'month')) {
	              // is the first day of the next week in the same month?
	              this.current.add(this.step, 'week'); // the default case
	            } else {
	              // inject a step at each first day of the month
	              this.current.add(this.step, 'week');
	              this.current.date(1);
	            }
	          }
	          break;
	        case 'month':
	          this.current.add(this.step, 'month');
	          break;
	        case 'year':
	          this.current.add(this.step, 'year');
	          break;
	      }
	      if (this.step != 1) {
	        // round down to the correct major value
	        switch (this.scale) {
	          case 'millisecond':
	            if (this.current.milliseconds() > 0 && this.current.milliseconds() < this.step) this.current.milliseconds(0);
	            break;
	          case 'second':
	            if (this.current.seconds() > 0 && this.current.seconds() < this.step) this.current.seconds(0);
	            break;
	          case 'minute':
	            if (this.current.minutes() > 0 && this.current.minutes() < this.step) this.current.minutes(0);
	            break;
	          case 'hour':
	            if (this.current.hours() > 0 && this.current.hours() < this.step) this.current.hours(0);
	            break;
	          case 'weekday': // intentional fall through
	          case 'day':
	            if (this.current.date() < this.step + 1) this.current.date(1);
	            break;
	          case 'week':
	            if (this.current.week() < this.step) this.current.week(1);
	            break;
	          // week numbering starts at 1, not 0
	          case 'month':
	            if (this.current.month() < this.step) this.current.month(0);
	            break;
	        }
	      }

	      // safety mechanism: if current time is still unchanged, move to the end
	      if (this.current.valueOf() == prev) {
	        this.current = this._end.clone();
	      }

	      // Reset switches for year, month and day. Will get set to true where appropriate in DateUtil.stepOverHiddenDates
	      this.switchedDay = false;
	      this.switchedMonth = false;
	      this.switchedYear = false;
	      stepOverHiddenDates(this.moment, this, prev);
	    }

	    /**
	     * Get the current datetime
	     * @return {Moment}  current The current date
	     */
	  }, {
	    key: "getCurrent",
	    value: function getCurrent() {
	      return this.current.clone();
	    }

	    /**
	     * Set a custom scale. Autoscaling will be disabled.
	     * For example setScale('minute', 5) will result
	     * in minor steps of 5 minutes, and major steps of an hour.
	     *
	     * @param {{scale: string, step: number}} params
	     *                               An object containing two properties:
	     *                               - A string 'scale'. Choose from 'millisecond', 'second',
	     *                                 'minute', 'hour', 'weekday', 'day', 'week', 'month', 'year'.
	     *                               - A number 'step'. A step size, by default 1.
	     *                                 Choose for example 1, 2, 5, or 10.
	     */
	  }, {
	    key: "setScale",
	    value: function setScale(params) {
	      if (params && typeof params.scale == 'string') {
	        this.scale = params.scale;
	        this.step = params.step > 0 ? params.step : 1;
	        this.autoScale = false;
	      }
	    }

	    /**
	     * Enable or disable autoscaling
	     * @param {boolean} enable  If true, autoascaling is set true
	     */
	  }, {
	    key: "setAutoScale",
	    value: function setAutoScale(enable) {
	      this.autoScale = enable;
	    }

	    /**
	     * Automatically determine the scale that bests fits the provided minimum step
	     * @param {number} [minimumStep]  The minimum step size in milliseconds
	     */
	  }, {
	    key: "setMinimumStep",
	    value: function setMinimumStep(minimumStep) {
	      if (minimumStep == undefined) {
	        return;
	      }

	      //var b = asc + ds;

	      var stepYear = 1000 * 60 * 60 * 24 * 30 * 12;
	      var stepMonth = 1000 * 60 * 60 * 24 * 30;
	      var stepDay = 1000 * 60 * 60 * 24;
	      var stepHour = 1000 * 60 * 60;
	      var stepMinute = 1000 * 60;
	      var stepSecond = 1000;
	      var stepMillisecond = 1;

	      // find the smallest step that is larger than the provided minimumStep
	      if (stepYear * 1000 > minimumStep) {
	        this.scale = 'year';
	        this.step = 1000;
	      }
	      if (stepYear * 500 > minimumStep) {
	        this.scale = 'year';
	        this.step = 500;
	      }
	      if (stepYear * 100 > minimumStep) {
	        this.scale = 'year';
	        this.step = 100;
	      }
	      if (stepYear * 50 > minimumStep) {
	        this.scale = 'year';
	        this.step = 50;
	      }
	      if (stepYear * 10 > minimumStep) {
	        this.scale = 'year';
	        this.step = 10;
	      }
	      if (stepYear * 5 > minimumStep) {
	        this.scale = 'year';
	        this.step = 5;
	      }
	      if (stepYear > minimumStep) {
	        this.scale = 'year';
	        this.step = 1;
	      }
	      if (stepMonth * 3 > minimumStep) {
	        this.scale = 'month';
	        this.step = 3;
	      }
	      if (stepMonth > minimumStep) {
	        this.scale = 'month';
	        this.step = 1;
	      }
	      if (stepDay * 7 > minimumStep && this.options.showWeekScale) {
	        this.scale = 'week';
	        this.step = 1;
	      }
	      if (stepDay * 2 > minimumStep) {
	        this.scale = 'day';
	        this.step = 2;
	      }
	      if (stepDay > minimumStep) {
	        this.scale = 'day';
	        this.step = 1;
	      }
	      if (stepDay / 2 > minimumStep) {
	        this.scale = 'weekday';
	        this.step = 1;
	      }
	      if (stepHour * 4 > minimumStep) {
	        this.scale = 'hour';
	        this.step = 4;
	      }
	      if (stepHour > minimumStep) {
	        this.scale = 'hour';
	        this.step = 1;
	      }
	      if (stepMinute * 15 > minimumStep) {
	        this.scale = 'minute';
	        this.step = 15;
	      }
	      if (stepMinute * 10 > minimumStep) {
	        this.scale = 'minute';
	        this.step = 10;
	      }
	      if (stepMinute * 5 > minimumStep) {
	        this.scale = 'minute';
	        this.step = 5;
	      }
	      if (stepMinute > minimumStep) {
	        this.scale = 'minute';
	        this.step = 1;
	      }
	      if (stepSecond * 15 > minimumStep) {
	        this.scale = 'second';
	        this.step = 15;
	      }
	      if (stepSecond * 10 > minimumStep) {
	        this.scale = 'second';
	        this.step = 10;
	      }
	      if (stepSecond * 5 > minimumStep) {
	        this.scale = 'second';
	        this.step = 5;
	      }
	      if (stepSecond > minimumStep) {
	        this.scale = 'second';
	        this.step = 1;
	      }
	      if (stepMillisecond * 200 > minimumStep) {
	        this.scale = 'millisecond';
	        this.step = 200;
	      }
	      if (stepMillisecond * 100 > minimumStep) {
	        this.scale = 'millisecond';
	        this.step = 100;
	      }
	      if (stepMillisecond * 50 > minimumStep) {
	        this.scale = 'millisecond';
	        this.step = 50;
	      }
	      if (stepMillisecond * 10 > minimumStep) {
	        this.scale = 'millisecond';
	        this.step = 10;
	      }
	      if (stepMillisecond * 5 > minimumStep) {
	        this.scale = 'millisecond';
	        this.step = 5;
	      }
	      if (stepMillisecond > minimumStep) {
	        this.scale = 'millisecond';
	        this.step = 1;
	      }
	    }

	    /**
	     * Snap a date to a rounded value.
	     * The snap intervals are dependent on the current scale and step.
	     * Static function
	     * @param {Date} date    the date to be snapped.
	     * @param {string} scale Current scale, can be 'millisecond', 'second',
	     *                       'minute', 'hour', 'weekday, 'day', 'week', 'month', 'year'.
	     * @param {number} step  Current step (1, 2, 4, 5, ...
	     * @return {Date} snappedDate
	     */
	  }, {
	    key: "isMajor",
	    value:
	    /**
	     * Check if the current value is a major value (for example when the step
	     * is DAY, a major value is each first day of the MONTH)
	     * @return {boolean} true if current date is major, else false.
	     */
	    function isMajor() {
	      if (this.switchedYear == true) {
	        switch (this.scale) {
	          case 'year':
	          case 'month':
	          case 'week':
	          case 'weekday':
	          case 'day':
	          case 'hour':
	          case 'minute':
	          case 'second':
	          case 'millisecond':
	            return true;
	          default:
	            return false;
	        }
	      } else if (this.switchedMonth == true) {
	        switch (this.scale) {
	          case 'week':
	          case 'weekday':
	          case 'day':
	          case 'hour':
	          case 'minute':
	          case 'second':
	          case 'millisecond':
	            return true;
	          default:
	            return false;
	        }
	      } else if (this.switchedDay == true) {
	        switch (this.scale) {
	          case 'millisecond':
	          case 'second':
	          case 'minute':
	          case 'hour':
	            return true;
	          default:
	            return false;
	        }
	      }
	      var date = this.moment(this.current);
	      switch (this.scale) {
	        case 'millisecond':
	          return date.milliseconds() == 0;
	        case 'second':
	          return date.seconds() == 0;
	        case 'minute':
	          return date.hours() == 0 && date.minutes() == 0;
	        case 'hour':
	          return date.hours() == 0;
	        case 'weekday': // intentional fall through
	        case 'day':
	          return this.options.showWeekScale ? date.isoWeekday() == 1 : date.date() == 1;
	        case 'week':
	          return date.date() == 1;
	        case 'month':
	          return date.month() == 0;
	        case 'year':
	          return false;
	        default:
	          return false;
	      }
	    }

	    /**
	     * Returns formatted text for the minor axislabel, depending on the current
	     * date and the scale. For example when scale is MINUTE, the current time is
	     * formatted as "hh:mm".
	     * @param {Date} [date=this.current] custom date. if not provided, current date is taken
	     * @returns {String}
	     */
	  }, {
	    key: "getLabelMinor",
	    value: function getLabelMinor(date) {
	      if (date == undefined) {
	        date = this.current;
	      }
	      if (date instanceof Date) {
	        date = this.moment(date);
	      }
	      if (typeof this.format.minorLabels === "function") {
	        return this.format.minorLabels(date, this.scale, this.step);
	      }
	      var format = this.format.minorLabels[this.scale];
	      // noinspection FallThroughInSwitchStatementJS
	      switch (this.scale) {
	        case 'week':
	          // Don't draw the minor label if this date is the first day of a month AND if it's NOT the start of the week.
	          // The 'date' variable may actually be the 'next' step when called from TimeAxis' _repaintLabels.
	          if (date.date() === 1 && date.weekday() !== 0) {
	            return "";
	          }
	        default:
	          // eslint-disable-line no-fallthrough
	          return format && format.length > 0 ? this.moment(date).format(format) : '';
	      }
	    }

	    /**
	     * Returns formatted text for the major axis label, depending on the current
	     * date and the scale. For example when scale is MINUTE, the major scale is
	     * hours, and the hour will be formatted as "hh".
	     * @param {Date} [date=this.current] custom date. if not provided, current date is taken
	     * @returns {String}
	     */
	  }, {
	    key: "getLabelMajor",
	    value: function getLabelMajor(date) {
	      if (date == undefined) {
	        date = this.current;
	      }
	      if (date instanceof Date) {
	        date = this.moment(date);
	      }
	      if (typeof this.format.majorLabels === "function") {
	        return this.format.majorLabels(date, this.scale, this.step);
	      }
	      var format = this.format.majorLabels[this.scale];
	      return format && format.length > 0 ? this.moment(date).format(format) : '';
	    }

	    /**
	     * get class name
	     * @return {string} class name
	     */
	  }, {
	    key: "getClassName",
	    value: function getClassName() {
	      var _context;
	      var _moment = this.moment;
	      var m = this.moment(this.current);
	      var current = m.locale ? m.locale('en') : m.lang('en'); // old versions of moment have .lang() function
	      var step = this.step;
	      var classNames = [];

	      /**
	       *
	       * @param {number} value
	       * @returns {String}
	       */
	      function even(value) {
	        return value / step % 2 == 0 ? ' vis-even' : ' vis-odd';
	      }

	      /**
	       *
	       * @param {Date} date
	       * @returns {String}
	       */
	      function today(date) {
	        if (date.isSame(_Date$now(), 'day')) {
	          return ' vis-today';
	        }
	        if (date.isSame(_moment().add(1, 'day'), 'day')) {
	          return ' vis-tomorrow';
	        }
	        if (date.isSame(_moment().add(-1, 'day'), 'day')) {
	          return ' vis-yesterday';
	        }
	        return '';
	      }

	      /**
	       *
	       * @param {Date} date
	       * @returns {String}
	       */
	      function currentWeek(date) {
	        return date.isSame(_Date$now(), 'week') ? ' vis-current-week' : '';
	      }

	      /**
	       *
	       * @param {Date} date
	       * @returns {String}
	       */
	      function currentMonth(date) {
	        return date.isSame(_Date$now(), 'month') ? ' vis-current-month' : '';
	      }

	      /**
	       *
	       * @param {Date} date
	       * @returns {String}
	       */
	      function currentYear(date) {
	        return date.isSame(_Date$now(), 'year') ? ' vis-current-year' : '';
	      }
	      switch (this.scale) {
	        case 'millisecond':
	          classNames.push(today(current));
	          classNames.push(even(current.milliseconds()));
	          break;
	        case 'second':
	          classNames.push(today(current));
	          classNames.push(even(current.seconds()));
	          break;
	        case 'minute':
	          classNames.push(today(current));
	          classNames.push(even(current.minutes()));
	          break;
	        case 'hour':
	          classNames.push(_concatInstanceProperty(_context = "vis-h".concat(current.hours())).call(_context, this.step == 4 ? '-h' + (current.hours() + 4) : ''));
	          classNames.push(today(current));
	          classNames.push(even(current.hours()));
	          break;
	        case 'weekday':
	          classNames.push("vis-".concat(current.format('dddd').toLowerCase()));
	          classNames.push(today(current));
	          classNames.push(currentWeek(current));
	          classNames.push(even(current.date()));
	          break;
	        case 'day':
	          classNames.push("vis-day".concat(current.date()));
	          classNames.push("vis-".concat(current.format('MMMM').toLowerCase()));
	          classNames.push(today(current));
	          classNames.push(currentMonth(current));
	          classNames.push(this.step <= 2 ? today(current) : '');
	          classNames.push(this.step <= 2 ? "vis-".concat(current.format('dddd').toLowerCase()) : '');
	          classNames.push(even(current.date() - 1));
	          break;
	        case 'week':
	          classNames.push("vis-week".concat(current.format('w')));
	          classNames.push(currentWeek(current));
	          classNames.push(even(current.week()));
	          break;
	        case 'month':
	          classNames.push("vis-".concat(current.format('MMMM').toLowerCase()));
	          classNames.push(currentMonth(current));
	          classNames.push(even(current.month()));
	          break;
	        case 'year':
	          classNames.push("vis-year".concat(current.year()));
	          classNames.push(currentYear(current));
	          classNames.push(even(current.year()));
	          break;
	      }
	      return _filterInstanceProperty(classNames).call(classNames, String).join(" ");
	    }
	  }], [{
	    key: "snap",
	    value: function snap(date, scale, step) {
	      var clone = moment$2(date);
	      if (scale == 'year') {
	        var year = clone.year() + Math.round(clone.month() / 12);
	        clone.year(Math.round(year / step) * step);
	        clone.month(0);
	        clone.date(0);
	        clone.hours(0);
	        clone.minutes(0);
	        clone.seconds(0);
	        clone.milliseconds(0);
	      } else if (scale == 'month') {
	        if (clone.date() > 15) {
	          clone.date(1);
	          clone.add(1, 'month');
	          // important: first set Date to 1, after that change the month.
	        } else {
	          clone.date(1);
	        }
	        clone.hours(0);
	        clone.minutes(0);
	        clone.seconds(0);
	        clone.milliseconds(0);
	      } else if (scale == 'week') {
	        if (clone.weekday() > 2) {
	          // doing it the momentjs locale aware way
	          clone.weekday(0);
	          clone.add(1, 'week');
	        } else {
	          clone.weekday(0);
	        }
	        clone.hours(0);
	        clone.minutes(0);
	        clone.seconds(0);
	        clone.milliseconds(0);
	      } else if (scale == 'day') {
	        //noinspection FallthroughInSwitchStatementJS
	        switch (step) {
	          case 5:
	          case 2:
	            clone.hours(Math.round(clone.hours() / 24) * 24);
	            break;
	          default:
	            clone.hours(Math.round(clone.hours() / 12) * 12);
	            break;
	        }
	        clone.minutes(0);
	        clone.seconds(0);
	        clone.milliseconds(0);
	      } else if (scale == 'weekday') {
	        //noinspection FallthroughInSwitchStatementJS
	        switch (step) {
	          case 5:
	          case 2:
	            clone.hours(Math.round(clone.hours() / 12) * 12);
	            break;
	          default:
	            clone.hours(Math.round(clone.hours() / 6) * 6);
	            break;
	        }
	        clone.minutes(0);
	        clone.seconds(0);
	        clone.milliseconds(0);
	      } else if (scale == 'hour') {
	        switch (step) {
	          case 4:
	            clone.minutes(Math.round(clone.minutes() / 60) * 60);
	            break;
	          default:
	            clone.minutes(Math.round(clone.minutes() / 30) * 30);
	            break;
	        }
	        clone.seconds(0);
	        clone.milliseconds(0);
	      } else if (scale == 'minute') {
	        //noinspection FallthroughInSwitchStatementJS
	        switch (step) {
	          case 15:
	          case 10:
	            clone.minutes(Math.round(clone.minutes() / 5) * 5);
	            clone.seconds(0);
	            break;
	          case 5:
	            clone.seconds(Math.round(clone.seconds() / 60) * 60);
	            break;
	          default:
	            clone.seconds(Math.round(clone.seconds() / 30) * 30);
	            break;
	        }
	        clone.milliseconds(0);
	      } else if (scale == 'second') {
	        //noinspection FallthroughInSwitchStatementJS
	        switch (step) {
	          case 15:
	          case 10:
	            clone.seconds(Math.round(clone.seconds() / 5) * 5);
	            clone.milliseconds(0);
	            break;
	          case 5:
	            clone.milliseconds(Math.round(clone.milliseconds() / 1000) * 1000);
	            break;
	          default:
	            clone.milliseconds(Math.round(clone.milliseconds() / 500) * 500);
	            break;
	        }
	      } else if (scale == 'millisecond') {
	        var _step = step > 5 ? step / 2 : 1;
	        clone.milliseconds(Math.round(clone.milliseconds() / _step) * _step);
	      }
	      return clone;
	    }
	  }]);
	  return TimeStep;
	}(); // Time formatting
	TimeStep.FORMAT = {
	  minorLabels: {
	    millisecond: 'SSS',
	    second: 's',
	    minute: 'HH:mm',
	    hour: 'HH:mm',
	    weekday: 'ddd D',
	    day: 'D',
	    week: 'w',
	    month: 'MMM',
	    year: 'YYYY'
	  },
	  majorLabels: {
	    millisecond: 'HH:mm:ss',
	    second: 'D MMMM HH:mm',
	    minute: 'ddd D MMMM',
	    hour: 'ddd D MMMM',
	    weekday: 'MMMM YYYY',
	    day: 'MMMM YYYY',
	    week: 'MMMM YYYY',
	    month: 'YYYY',
	    year: ''
	  }
	};

	function _createSuper$b(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$b(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$b() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/** A horizontal time axis */
	var TimeAxis = /*#__PURE__*/function (_Component) {
	  _inherits(TimeAxis, _Component);
	  var _super = _createSuper$b(TimeAxis);
	  /**
	   * @param {{dom: Object, domProps: Object, emitter: Emitter, range: Range}} body
	   * @param {Object} [options]        See TimeAxis.setOptions for the available
	   *                                  options.
	   * @constructor TimeAxis
	   * @extends Component
	   */
	  function TimeAxis(body, options) {
	    var _this;
	    _classCallCheck(this, TimeAxis);
	    _this = _super.call(this);
	    _this.dom = {
	      foreground: null,
	      lines: [],
	      majorTexts: [],
	      minorTexts: [],
	      redundant: {
	        lines: [],
	        majorTexts: [],
	        minorTexts: []
	      }
	    };
	    _this.props = {
	      range: {
	        start: 0,
	        end: 0,
	        minimumStep: 0
	      },
	      lineTop: 0
	    };
	    _this.defaultOptions = {
	      orientation: {
	        axis: 'bottom'
	      },
	      // axis orientation: 'top' or 'bottom'
	      showMinorLabels: true,
	      showMajorLabels: true,
	      showWeekScale: false,
	      maxMinorChars: 7,
	      format: availableUtils.extend({}, TimeStep.FORMAT),
	      moment: moment$2,
	      timeAxis: null
	    };
	    _this.options = availableUtils.extend({}, _this.defaultOptions);
	    _this.body = body;

	    // create the HTML DOM
	    _this._create();
	    _this.setOptions(options);
	    return _this;
	  }

	  /**
	   * Set options for the TimeAxis.
	   * Parameters will be merged in current options.
	   * @param {Object} options  Available options:
	   *                          {string} [orientation.axis]
	   *                          {boolean} [showMinorLabels]
	   *                          {boolean} [showMajorLabels]
	   *                          {boolean} [showWeekScale]
	   */
	  _createClass(TimeAxis, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options) {
	        // copy all options that we know
	        availableUtils.selectiveExtend(['showMinorLabels', 'showMajorLabels', 'showWeekScale', 'maxMinorChars', 'hiddenDates', 'timeAxis', 'moment', 'rtl'], this.options, options);

	        // deep copy the format options
	        availableUtils.selectiveDeepExtend(['format'], this.options, options);
	        if ('orientation' in options) {
	          if (typeof options.orientation === 'string') {
	            this.options.orientation.axis = options.orientation;
	          } else if (_typeof(options.orientation) === 'object' && 'axis' in options.orientation) {
	            this.options.orientation.axis = options.orientation.axis;
	          }
	        }

	        // apply locale to moment.js
	        // TODO: not so nice, this is applied globally to moment.js
	        if ('locale' in options) {
	          if (typeof moment$2.locale === 'function') {
	            // moment.js 2.8.1+
	            moment$2.locale(options.locale);
	          } else {
	            moment$2.lang(options.locale);
	          }
	        }
	      }
	    }

	    /**
	     * Create the HTML DOM for the TimeAxis
	     */
	  }, {
	    key: "_create",
	    value: function _create() {
	      this.dom.foreground = document.createElement('div');
	      this.dom.background = document.createElement('div');
	      this.dom.foreground.className = 'vis-time-axis vis-foreground';
	      this.dom.background.className = 'vis-time-axis vis-background';
	    }

	    /**
	     * Destroy the TimeAxis
	     */
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      // remove from DOM
	      if (this.dom.foreground.parentNode) {
	        this.dom.foreground.parentNode.removeChild(this.dom.foreground);
	      }
	      if (this.dom.background.parentNode) {
	        this.dom.background.parentNode.removeChild(this.dom.background);
	      }
	      this.body = null;
	    }

	    /**
	     * Repaint the component
	     * @return {boolean} Returns true if the component is resized
	     */
	  }, {
	    key: "redraw",
	    value: function redraw() {
	      var props = this.props;
	      var foreground = this.dom.foreground;
	      var background = this.dom.background;

	      // determine the correct parent DOM element (depending on option orientation)
	      var parent = this.options.orientation.axis == 'top' ? this.body.dom.top : this.body.dom.bottom;
	      var parentChanged = foreground.parentNode !== parent;

	      // calculate character width and height
	      this._calculateCharSize();

	      // TODO: recalculate sizes only needed when parent is resized or options is changed
	      var showMinorLabels = this.options.showMinorLabels && this.options.orientation.axis !== 'none';
	      var showMajorLabels = this.options.showMajorLabels && this.options.orientation.axis !== 'none';

	      // determine the width and height of the elemens for the axis
	      props.minorLabelHeight = showMinorLabels ? props.minorCharHeight : 0;
	      props.majorLabelHeight = showMajorLabels ? props.majorCharHeight : 0;
	      props.height = props.minorLabelHeight + props.majorLabelHeight;
	      props.width = foreground.offsetWidth;
	      props.minorLineHeight = this.body.domProps.root.height - props.majorLabelHeight - (this.options.orientation.axis == 'top' ? this.body.domProps.bottom.height : this.body.domProps.top.height);
	      props.minorLineWidth = 1; // TODO: really calculate width
	      props.majorLineHeight = props.minorLineHeight + props.majorLabelHeight;
	      props.majorLineWidth = 1; // TODO: really calculate width

	      //  take foreground and background offline while updating (is almost twice as fast)
	      var foregroundNextSibling = foreground.nextSibling;
	      var backgroundNextSibling = background.nextSibling;
	      foreground.parentNode && foreground.parentNode.removeChild(foreground);
	      background.parentNode && background.parentNode.removeChild(background);
	      foreground.style.height = "".concat(this.props.height, "px");
	      this._repaintLabels();

	      // put DOM online again (at the same place)
	      if (foregroundNextSibling) {
	        parent.insertBefore(foreground, foregroundNextSibling);
	      } else {
	        parent.appendChild(foreground);
	      }
	      if (backgroundNextSibling) {
	        this.body.dom.backgroundVertical.insertBefore(background, backgroundNextSibling);
	      } else {
	        this.body.dom.backgroundVertical.appendChild(background);
	      }
	      return this._isResized() || parentChanged;
	    }

	    /**
	     * Repaint major and minor text labels and vertical grid lines
	     * @private
	     */
	  }, {
	    key: "_repaintLabels",
	    value: function _repaintLabels() {
	      var orientation = this.options.orientation.axis;

	      // calculate range and step (step such that we have space for 7 characters per label)
	      var start = availableUtils.convert(this.body.range.start, 'Number');
	      var end = availableUtils.convert(this.body.range.end, 'Number');
	      var timeLabelsize = this.body.util.toTime((this.props.minorCharWidth || 10) * this.options.maxMinorChars).valueOf();
	      var minimumStep = timeLabelsize - getHiddenDurationBefore(this.options.moment, this.body.hiddenDates, this.body.range, timeLabelsize);
	      minimumStep -= this.body.util.toTime(0).valueOf();
	      var step = new TimeStep(new Date(start), new Date(end), minimumStep, this.body.hiddenDates, this.options);
	      step.setMoment(this.options.moment);
	      if (this.options.format) {
	        step.setFormat(this.options.format);
	      }
	      if (this.options.timeAxis) {
	        step.setScale(this.options.timeAxis);
	      }
	      this.step = step;

	      // Move all DOM elements to a "redundant" list, where they
	      // can be picked for re-use, and clear the lists with lines and texts.
	      // At the end of the function _repaintLabels, left over elements will be cleaned up
	      var dom = this.dom;
	      dom.redundant.lines = dom.lines;
	      dom.redundant.majorTexts = dom.majorTexts;
	      dom.redundant.minorTexts = dom.minorTexts;
	      dom.lines = [];
	      dom.majorTexts = [];
	      dom.minorTexts = [];
	      var current;
	      var next;
	      var x;
	      var xNext;
	      var isMajor;
	      var showMinorGrid;
	      var width = 0;
	      var prevWidth;
	      var line;
	      var xFirstMajorLabel = undefined;
	      var count = 0;
	      var MAX = 1000;
	      var className;
	      step.start();
	      next = step.getCurrent();
	      xNext = this.body.util.toScreen(next);
	      while (step.hasNext() && count < MAX) {
	        count++;
	        isMajor = step.isMajor();
	        className = step.getClassName();
	        current = next;
	        x = xNext;
	        step.next();
	        next = step.getCurrent();
	        xNext = this.body.util.toScreen(next);
	        prevWidth = width;
	        width = xNext - x;
	        switch (step.scale) {
	          case 'week':
	            showMinorGrid = true;
	            break;
	          default:
	            showMinorGrid = width >= prevWidth * 0.4;
	            break;
	          // prevent displaying of the 31th of the month on a scale of 5 days
	        }

	        if (this.options.showMinorLabels && showMinorGrid) {
	          var label = this._repaintMinorText(x, step.getLabelMinor(current), orientation, className);
	          label.style.width = "".concat(width, "px"); // set width to prevent overflow
	        }

	        if (isMajor && this.options.showMajorLabels) {
	          if (x > 0) {
	            if (xFirstMajorLabel == undefined) {
	              xFirstMajorLabel = x;
	            }
	            label = this._repaintMajorText(x, step.getLabelMajor(current), orientation, className);
	          }
	          line = this._repaintMajorLine(x, width, orientation, className);
	        } else {
	          // minor line
	          if (showMinorGrid) {
	            line = this._repaintMinorLine(x, width, orientation, className);
	          } else {
	            if (line) {
	              // adjust the width of the previous grid
	              line.style.width = "".concat(_parseInt(line.style.width) + width, "px");
	            }
	          }
	        }
	      }
	      if (count === MAX && !warnedForOverflow) {
	        console.warn("Something is wrong with the Timeline scale. Limited drawing of grid lines to ".concat(MAX, " lines."));
	        warnedForOverflow = true;
	      }

	      // create a major label on the left when needed
	      if (this.options.showMajorLabels) {
	        var leftTime = this.body.util.toTime(0); // upper bound estimation
	        var leftText = step.getLabelMajor(leftTime);
	        var widthText = leftText.length * (this.props.majorCharWidth || 10) + 10;
	        if (xFirstMajorLabel == undefined || widthText < xFirstMajorLabel) {
	          this._repaintMajorText(0, leftText, orientation, className);
	        }
	      }

	      // Cleanup leftover DOM elements from the redundant list
	      _forEachInstanceProperty(availableUtils).call(availableUtils, this.dom.redundant, function (arr) {
	        while (arr.length) {
	          var elem = arr.pop();
	          if (elem && elem.parentNode) {
	            elem.parentNode.removeChild(elem);
	          }
	        }
	      });
	    }

	    /**
	     * Create a minor label for the axis at position x
	     * @param {number} x
	     * @param {string} text
	     * @param {string} orientation   "top" or "bottom" (default)
	     * @param {string} className
	     * @return {Element} Returns the HTML element of the created label
	     * @private
	     */
	  }, {
	    key: "_repaintMinorText",
	    value: function _repaintMinorText(x, text, orientation, className) {
	      // reuse redundant label
	      var label = this.dom.redundant.minorTexts.shift();
	      if (!label) {
	        // create new label
	        var content = document.createTextNode('');
	        label = document.createElement('div');
	        label.appendChild(content);
	        this.dom.foreground.appendChild(label);
	      }
	      this.dom.minorTexts.push(label);
	      label.innerHTML = availableUtils.xss(text);
	      var y = orientation == 'top' ? this.props.majorLabelHeight : 0;
	      this._setXY(label, x, y);
	      label.className = "vis-text vis-minor ".concat(className);
	      //label.title = title;  // TODO: this is a heavy operation

	      return label;
	    }

	    /**
	     * Create a Major label for the axis at position x
	     * @param {number} x
	     * @param {string} text
	     * @param {string} orientation   "top" or "bottom" (default)
	     * @param {string} className
	     * @return {Element} Returns the HTML element of the created label
	     * @private
	     */
	  }, {
	    key: "_repaintMajorText",
	    value: function _repaintMajorText(x, text, orientation, className) {
	      // reuse redundant label
	      var label = this.dom.redundant.majorTexts.shift();
	      if (!label) {
	        // create label
	        var content = document.createElement('div');
	        label = document.createElement('div');
	        label.appendChild(content);
	        this.dom.foreground.appendChild(label);
	      }
	      label.childNodes[0].innerHTML = availableUtils.xss(text);
	      label.className = "vis-text vis-major ".concat(className);
	      //label.title = title; // TODO: this is a heavy operation

	      var y = orientation == 'top' ? 0 : this.props.minorLabelHeight;
	      this._setXY(label, x, y);
	      this.dom.majorTexts.push(label);
	      return label;
	    }

	    /**
	     * sets xy
	     * @param {string} label
	     * @param {number} x
	     * @param {number} y
	     * @private
	     */
	  }, {
	    key: "_setXY",
	    value: function _setXY(label, x, y) {
	      var _context;
	      // If rtl is true, inverse x.
	      var directionX = this.options.rtl ? x * -1 : x;
	      label.style.transform = _concatInstanceProperty(_context = "translate(".concat(directionX, "px, ")).call(_context, y, "px)");
	    }

	    /**
	     * Create a minor line for the axis at position x
	     * @param {number} left
	     * @param {number} width
	     * @param {string} orientation   "top" or "bottom" (default)
	     * @param {string} className
	     * @return {Element} Returns the created line
	     * @private
	     */
	  }, {
	    key: "_repaintMinorLine",
	    value: function _repaintMinorLine(left, width, orientation, className) {
	      var _context2;
	      // reuse redundant line
	      var line = this.dom.redundant.lines.shift();
	      if (!line) {
	        // create vertical line
	        line = document.createElement('div');
	        this.dom.background.appendChild(line);
	      }
	      this.dom.lines.push(line);
	      var props = this.props;
	      line.style.width = "".concat(width, "px");
	      line.style.height = "".concat(props.minorLineHeight, "px");
	      var y = orientation == 'top' ? props.majorLabelHeight : this.body.domProps.top.height;
	      var x = left - props.minorLineWidth / 2;
	      this._setXY(line, x, y);
	      line.className = _concatInstanceProperty(_context2 = "vis-grid ".concat(this.options.rtl ? 'vis-vertical-rtl' : 'vis-vertical', " vis-minor ")).call(_context2, className);
	      return line;
	    }

	    /**
	     * Create a Major line for the axis at position x
	     * @param {number} left
	     * @param {number} width
	     * @param {string} orientation   "top" or "bottom" (default)
	     * @param {string} className
	     * @return {Element} Returns the created line
	     * @private
	     */
	  }, {
	    key: "_repaintMajorLine",
	    value: function _repaintMajorLine(left, width, orientation, className) {
	      var _context3;
	      // reuse redundant line
	      var line = this.dom.redundant.lines.shift();
	      if (!line) {
	        // create vertical line
	        line = document.createElement('div');
	        this.dom.background.appendChild(line);
	      }
	      this.dom.lines.push(line);
	      var props = this.props;
	      line.style.width = "".concat(width, "px");
	      line.style.height = "".concat(props.majorLineHeight, "px");
	      var y = orientation == 'top' ? 0 : this.body.domProps.top.height;
	      var x = left - props.majorLineWidth / 2;
	      this._setXY(line, x, y);
	      line.className = _concatInstanceProperty(_context3 = "vis-grid ".concat(this.options.rtl ? 'vis-vertical-rtl' : 'vis-vertical', " vis-major ")).call(_context3, className);
	      return line;
	    }

	    /**
	     * Determine the size of text on the axis (both major and minor axis).
	     * The size is calculated only once and then cached in this.props.
	     * @private
	     */
	  }, {
	    key: "_calculateCharSize",
	    value: function _calculateCharSize() {
	      // Note: We calculate char size with every redraw. Size may change, for
	      // example when any of the timelines parents had display:none for example.

	      // determine the char width and height on the minor axis
	      if (!this.dom.measureCharMinor) {
	        this.dom.measureCharMinor = document.createElement('DIV');
	        this.dom.measureCharMinor.className = 'vis-text vis-minor vis-measure';
	        this.dom.measureCharMinor.style.position = 'absolute';
	        this.dom.measureCharMinor.appendChild(document.createTextNode('0'));
	        this.dom.foreground.appendChild(this.dom.measureCharMinor);
	      }
	      this.props.minorCharHeight = this.dom.measureCharMinor.clientHeight;
	      this.props.minorCharWidth = this.dom.measureCharMinor.clientWidth;

	      // determine the char width and height on the major axis
	      if (!this.dom.measureCharMajor) {
	        this.dom.measureCharMajor = document.createElement('DIV');
	        this.dom.measureCharMajor.className = 'vis-text vis-major vis-measure';
	        this.dom.measureCharMajor.style.position = 'absolute';
	        this.dom.measureCharMajor.appendChild(document.createTextNode('0'));
	        this.dom.foreground.appendChild(this.dom.measureCharMajor);
	      }
	      this.props.majorCharHeight = this.dom.measureCharMajor.clientHeight;
	      this.props.majorCharWidth = this.dom.measureCharMajor.clientWidth;
	    }
	  }]);
	  return TimeAxis;
	}(Component);
	var warnedForOverflow = false;

	/**
	 * Created by Alex on 11/6/2014.
	 */
	function keycharm(options) {
	  var preventDefault = options && options.preventDefault || false;

	  var container = options && options.container || window;

	  var _exportFunctions = {};
	  var _bound = {keydown:{}, keyup:{}};
	  var _keys = {};
	  var i;

	  // a - z
	  for (i = 97; i <= 122; i++) {_keys[String.fromCharCode(i)] = {code:65 + (i - 97), shift: false};}
	  // A - Z
	  for (i = 65; i <= 90; i++) {_keys[String.fromCharCode(i)] = {code:i, shift: true};}
	  // 0 - 9
	  for (i = 0;  i <= 9;   i++) {_keys['' + i] = {code:48 + i, shift: false};}
	  // F1 - F12
	  for (i = 1;  i <= 12;   i++) {_keys['F' + i] = {code:111 + i, shift: false};}
	  // num0 - num9
	  for (i = 0;  i <= 9;   i++) {_keys['num' + i] = {code:96 + i, shift: false};}

	  // numpad misc
	  _keys['num*'] = {code:106, shift: false};
	  _keys['num+'] = {code:107, shift: false};
	  _keys['num-'] = {code:109, shift: false};
	  _keys['num/'] = {code:111, shift: false};
	  _keys['num.'] = {code:110, shift: false};
	  // arrows
	  _keys['left']  = {code:37, shift: false};
	  _keys['up']    = {code:38, shift: false};
	  _keys['right'] = {code:39, shift: false};
	  _keys['down']  = {code:40, shift: false};
	  // extra keys
	  _keys['space'] = {code:32, shift: false};
	  _keys['enter'] = {code:13, shift: false};
	  _keys['shift'] = {code:16, shift: undefined};
	  _keys['esc']   = {code:27, shift: false};
	  _keys['backspace'] = {code:8, shift: false};
	  _keys['tab']       = {code:9, shift: false};
	  _keys['ctrl']      = {code:17, shift: false};
	  _keys['alt']       = {code:18, shift: false};
	  _keys['delete']    = {code:46, shift: false};
	  _keys['pageup']    = {code:33, shift: false};
	  _keys['pagedown']  = {code:34, shift: false};
	  // symbols
	  _keys['=']     = {code:187, shift: false};
	  _keys['-']     = {code:189, shift: false};
	  _keys[']']     = {code:221, shift: false};
	  _keys['[']     = {code:219, shift: false};



	  var down = function(event) {handleEvent(event,'keydown');};
	  var up = function(event) {handleEvent(event,'keyup');};

	  // handle the actualy bound key with the event
	  var handleEvent = function(event,type) {
	    if (_bound[type][event.keyCode] !== undefined) {
	      var bound = _bound[type][event.keyCode];
	      for (var i = 0; i < bound.length; i++) {
	        if (bound[i].shift === undefined) {
	          bound[i].fn(event);
	        }
	        else if (bound[i].shift == true && event.shiftKey == true) {
	          bound[i].fn(event);
	        }
	        else if (bound[i].shift == false && event.shiftKey == false) {
	          bound[i].fn(event);
	        }
	      }

	      if (preventDefault == true) {
	        event.preventDefault();
	      }
	    }
	  };

	  // bind a key to a callback
	  _exportFunctions.bind = function(key, callback, type) {
	    if (type === undefined) {
	      type = 'keydown';
	    }
	    if (_keys[key] === undefined) {
	      throw new Error("unsupported key: " + key);
	    }
	    if (_bound[type][_keys[key].code] === undefined) {
	      _bound[type][_keys[key].code] = [];
	    }
	    _bound[type][_keys[key].code].push({fn:callback, shift:_keys[key].shift});
	  };


	  // bind all keys to a call back (demo purposes)
	  _exportFunctions.bindAll = function(callback, type) {
	    if (type === undefined) {
	      type = 'keydown';
	    }
	    for (var key in _keys) {
	      if (_keys.hasOwnProperty(key)) {
	        _exportFunctions.bind(key,callback,type);
	      }
	    }
	  };

	  // get the key label from an event
	  _exportFunctions.getKey = function(event) {
	    for (var key in _keys) {
	      if (_keys.hasOwnProperty(key)) {
	        if (event.shiftKey == true && _keys[key].shift == true && event.keyCode == _keys[key].code) {
	          return key;
	        }
	        else if (event.shiftKey == false && _keys[key].shift == false && event.keyCode == _keys[key].code) {
	          return key;
	        }
	        else if (event.keyCode == _keys[key].code && key == 'shift') {
	          return key;
	        }
	      }
	    }
	    return "unknown key, currently not supported";
	  };

	  // unbind either a specific callback from a key or all of them (by leaving callback undefined)
	  _exportFunctions.unbind = function(key, callback, type) {
	    if (type === undefined) {
	      type = 'keydown';
	    }
	    if (_keys[key] === undefined) {
	      throw new Error("unsupported key: " + key);
	    }
	    if (callback !== undefined) {
	      var newBindings = [];
	      var bound = _bound[type][_keys[key].code];
	      if (bound !== undefined) {
	        for (var i = 0; i < bound.length; i++) {
	          if (!(bound[i].fn == callback && bound[i].shift == _keys[key].shift)) {
	            newBindings.push(_bound[type][_keys[key].code][i]);
	          }
	        }
	      }
	      _bound[type][_keys[key].code] = newBindings;
	    }
	    else {
	      _bound[type][_keys[key].code] = [];
	    }
	  };

	  // reset all bound variables.
	  _exportFunctions.reset = function() {
	    _bound = {keydown:{}, keyup:{}};
	  };

	  // unbind all listeners and reset all variables.
	  _exportFunctions.destroy = function() {
	    _bound = {keydown:{}, keyup:{}};
	    container.removeEventListener('keydown', down, true);
	    container.removeEventListener('keyup', up, true);
	  };

	  // create listeners.
	  container.addEventListener('keydown',down,true);
	  container.addEventListener('keyup',up,true);

	  // return the public functions.
	  return _exportFunctions;
	}

	/**
	 * Turn an element into an clickToUse element.
	 * When not active, the element has a transparent overlay. When the overlay is
	 * clicked, the mode is changed to active.
	 * When active, the element is displayed with a blue border around it, and
	 * the interactive contents of the element can be used. When clicked outside
	 * the element, the elements mode is changed to inactive.
	 * @param {Element} container
	 * @constructor Activator
	 */
	function Activator(container) {
	  var _context, _context2;
	  this.active = false;
	  this.dom = {
	    container: container
	  };
	  this.dom.overlay = document.createElement('div');
	  this.dom.overlay.className = 'vis-overlay';
	  this.dom.container.appendChild(this.dom.overlay);
	  this.hammer = Hammer(this.dom.overlay);
	  this.hammer.on('tap', _bindInstanceProperty(_context = this._onTapOverlay).call(_context, this));

	  // block all touch events (except tap)
	  var me = this;
	  var events = ['tap', 'doubletap', 'press', 'pinch', 'pan', 'panstart', 'panmove', 'panend'];
	  _forEachInstanceProperty(events).call(events, function (event) {
	    me.hammer.on(event, function (event) {
	      event.stopPropagation();
	    });
	  });

	  // attach a click event to the window, in order to deactivate when clicking outside the timeline
	  if (document && document.body) {
	    this.onClick = function (event) {
	      if (!_hasParent(event.target, container)) {
	        me.deactivate();
	      }
	    };
	    document.body.addEventListener('click', this.onClick);
	  }
	  if (this.keycharm !== undefined) {
	    this.keycharm.destroy();
	  }
	  this.keycharm = keycharm();

	  // keycharm listener only bounded when active)
	  this.escListener = _bindInstanceProperty(_context2 = this.deactivate).call(_context2, this);
	}

	// turn into an event emitter
	Emitter(Activator.prototype);

	// The currently active activator
	Activator.current = null;

	/**
	 * Destroy the activator. Cleans up all created DOM and event listeners
	 */
	Activator.prototype.destroy = function () {
	  this.deactivate();

	  // remove dom
	  this.dom.overlay.parentNode.removeChild(this.dom.overlay);

	  // remove global event listener
	  if (this.onClick) {
	    document.body.removeEventListener('click', this.onClick);
	  }
	  // remove keycharm
	  if (this.keycharm !== undefined) {
	    this.keycharm.destroy();
	  }
	  this.keycharm = null;
	  // cleanup hammer instances
	  this.hammer.destroy();
	  this.hammer = null;
	  // FIXME: cleaning up hammer instances doesn't work (Timeline not removed from memory)
	};

	/**
	 * Activate the element
	 * Overlay is hidden, element is decorated with a blue shadow border
	 */
	Activator.prototype.activate = function () {
	  var _context3;
	  // we allow only one active activator at a time
	  if (Activator.current) {
	    Activator.current.deactivate();
	  }
	  Activator.current = this;
	  this.active = true;
	  this.dom.overlay.style.display = 'none';
	  availableUtils.addClassName(this.dom.container, 'vis-active');
	  this.emit('change');
	  this.emit('activate');

	  // ugly hack: bind ESC after emitting the events, as the Network rebinds all
	  // keyboard events on a 'change' event
	  _bindInstanceProperty(_context3 = this.keycharm).call(_context3, 'esc', this.escListener);
	};

	/**
	 * Deactivate the element
	 * Overlay is displayed on top of the element
	 */
	Activator.prototype.deactivate = function () {
	  if (Activator.current === this) {
	    Activator.current = null;
	  }
	  this.active = false;
	  this.dom.overlay.style.display = '';
	  availableUtils.removeClassName(this.dom.container, 'vis-active');
	  this.keycharm.unbind('esc', this.escListener);
	  this.emit('change');
	  this.emit('deactivate');
	};

	/**
	 * Handle a tap event: activate the container
	 * @param {Event}  event   The event
	 * @private
	 */
	Activator.prototype._onTapOverlay = function (event) {
	  // activate the container
	  this.activate();
	  event.stopPropagation();
	};

	/**
	 * Test whether the element has the requested parent element somewhere in
	 * its chain of parent nodes.
	 * @param {HTMLElement} element
	 * @param {HTMLElement} parent
	 * @returns {boolean} Returns true when the parent is found somewhere in the
	 *                    chain of parent nodes.
	 * @private
	 */
	function _hasParent(element, parent) {
	  while (element) {
	    if (element === parent) {
	      return true;
	    }
	    element = element.parentNode;
	  }
	  return false;
	}

	/*
	 * IMPORTANT: Locales for Moment has to be imported in the legacy and standalone
	 * entry points. For the peer build it's users responsibility to do so.
	 */

	// English
	var en = {
	  current: 'current',
	  time: 'time',
	  deleteSelected: 'Delete selected'
	};
	var en_EN = en;
	var en_US = en;

	// Italiano
	var it = {
	  current: 'attuale',
	  time: 'tempo',
	  deleteSelected: 'Cancella la selezione'
	};
	var it_IT = it;
	var it_CH = it;

	// Dutch
	var nl = {
	  current: 'huidige',
	  time: 'tijd',
	  deleteSelected: 'Selectie verwijderen'
	};
	var nl_NL = nl;
	var nl_BE = nl;

	// German
	var de = {
	  current: 'Aktuelle',
	  time: 'Zeit',
	  deleteSelected: "L\xF6sche Auswahl"
	};
	var de_DE = de;

	// French
	var fr = {
	  current: 'actuel',
	  time: 'heure',
	  deleteSelected: 'Effacer la selection'
	};
	var fr_FR = fr;
	var fr_CA = fr;
	var fr_BE = fr;

	// Espanol
	var es = {
	  current: 'corriente',
	  time: 'hora',
	  deleteSelected: "Eliminar selecci\xF3n"
	};
	var es_ES = es;

	// Ukrainian
	var uk = {
	  current: 'поточний',
	  time: 'час',
	  deleteSelected: 'Видалити обране'
	};
	var uk_UA = uk;

	// Russian
	var ru = {
	  current: 'текущее',
	  time: 'время',
	  deleteSelected: 'Удалить выбранное'
	};
	var ru_RU = ru;

	// Polish
	var pl = {
	  current: 'aktualny',
	  time: 'czas',
	  deleteSelected: 'Usuń wybrane'
	};
	var pl_PL = pl;

	// Portuguese
	var pt = {
	  current: 'atual',
	  time: 'data',
	  deleteSelected: 'Apagar selecionado'
	};
	var pt_BR = pt;
	var pt_PT = pt;

	// Japanese
	var ja = {
	  current: '現在',
	  time: '時刻',
	  deleteSelected: '選択されたものを削除'
	};
	var ja_JP = ja;

	// Swedish
	var sv = {
	  current: 'nuvarande',
	  time: 'tid',
	  deleteSelected: 'Radera valda'
	};
	var sv_SE = sv;

	// Norwegian
	var nb = {
	  current: 'nåværende',
	  time: 'tid',
	  deleteSelected: 'Slett valgte'
	};
	var nb_NO = nb;
	var nn = nb;
	var nn_NO = nb;

	// Lithuanian
	var lt = {
	  current: 'einamas',
	  time: 'laikas',
	  deleteSelected: 'Pašalinti pasirinktą'
	};
	var lt_LT = lt;
	var locales = {
	  en: en,
	  en_EN: en_EN,
	  en_US: en_US,
	  it: it,
	  it_IT: it_IT,
	  it_CH: it_CH,
	  nl: nl,
	  nl_NL: nl_NL,
	  nl_BE: nl_BE,
	  de: de,
	  de_DE: de_DE,
	  fr: fr,
	  fr_FR: fr_FR,
	  fr_CA: fr_CA,
	  fr_BE: fr_BE,
	  es: es,
	  es_ES: es_ES,
	  uk: uk,
	  uk_UA: uk_UA,
	  ru: ru,
	  ru_RU: ru_RU,
	  pl: pl,
	  pl_PL: pl_PL,
	  pt: pt,
	  pt_BR: pt_BR,
	  pt_PT: pt_PT,
	  ja: ja,
	  ja_JP: ja_JP,
	  lt: lt,
	  lt_LT: lt_LT,
	  sv: sv,
	  sv_SE: sv_SE,
	  nb: nb,
	  nn: nn,
	  nb_NO: nb_NO,
	  nn_NO: nn_NO
	};

	function _createSuper$a(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$a(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$a() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/** A custom time bar */
	var CustomTime = /*#__PURE__*/function (_Component) {
	  _inherits(CustomTime, _Component);
	  var _super = _createSuper$a(CustomTime);
	  /**
	  * @param {{range: Range, dom: Object}} body
	  * @param {Object} [options]        Available parameters:
	  *                                  {number | string} id
	  *                                  {string} locales
	  *                                  {string} locale
	  * @constructor CustomTime
	  * @extends Component
	  */
	  function CustomTime(body, options) {
	    var _context;
	    var _this;
	    _classCallCheck(this, CustomTime);
	    _this = _super.call(this);
	    _this.body = body;

	    // default options
	    _this.defaultOptions = {
	      moment: moment$2,
	      locales: locales,
	      locale: 'en',
	      id: undefined,
	      title: undefined
	    };
	    _this.options = availableUtils.extend({}, _this.defaultOptions);
	    _this.setOptions(options);
	    _this.options.locales = availableUtils.extend({}, locales, _this.options.locales);
	    var defaultLocales = _this.defaultOptions.locales[_this.defaultOptions.locale];
	    _forEachInstanceProperty(_context = _Object$keys(_this.options.locales)).call(_context, function (locale) {
	      _this.options.locales[locale] = availableUtils.extend({}, defaultLocales, _this.options.locales[locale]);
	    });
	    if (options && options.time != null) {
	      _this.customTime = options.time;
	    } else {
	      _this.customTime = new Date();
	    }
	    _this.eventParams = {}; // stores state parameters while dragging the bar

	    // create the DOM
	    _this._create();
	    return _this;
	  }

	  /**
	   * Set options for the component. Options will be merged in current options.
	   * @param {Object} options  Available parameters:
	   *                                  {number | string} id
	   *                                  {string} locales
	   *                                  {string} locale
	   */
	  _createClass(CustomTime, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options) {
	        // copy all options that we know
	        availableUtils.selectiveExtend(['moment', 'locale', 'locales', 'id', 'title', 'rtl', 'snap'], this.options, options);
	      }
	    }

	    /**
	     * Create the DOM for the custom time
	     * @private
	     */
	  }, {
	    key: "_create",
	    value: function _create() {
	      var _context2, _context3, _context4;
	      var bar = document.createElement('div');
	      bar['custom-time'] = this;
	      bar.className = "vis-custom-time ".concat(this.options.id || '');
	      bar.style.position = 'absolute';
	      bar.style.top = '0px';
	      bar.style.height = '100%';
	      this.bar = bar;
	      var drag = document.createElement('div');
	      drag.style.position = 'relative';
	      drag.style.top = '0px';
	      if (this.options.rtl) {
	        drag.style.right = '-10px';
	      } else {
	        drag.style.left = '-10px';
	      }
	      drag.style.height = '100%';
	      drag.style.width = '20px';

	      /**
	       *
	       * @param {WheelEvent} e
	       */
	      function onMouseWheel(e) {
	        this.body.range._onMouseWheel(e);
	      }
	      if (drag.addEventListener) {
	        // IE9, Chrome, Safari, Opera
	        drag.addEventListener("mousewheel", _bindInstanceProperty(onMouseWheel).call(onMouseWheel, this), false);
	        // Firefox
	        drag.addEventListener("DOMMouseScroll", _bindInstanceProperty(onMouseWheel).call(onMouseWheel, this), false);
	      } else {
	        // IE 6/7/8
	        drag.attachEvent("onmousewheel", _bindInstanceProperty(onMouseWheel).call(onMouseWheel, this));
	      }
	      bar.appendChild(drag);
	      // attach event listeners
	      this.hammer = new Hammer(drag);
	      this.hammer.on('panstart', _bindInstanceProperty(_context2 = this._onDragStart).call(_context2, this));
	      this.hammer.on('panmove', _bindInstanceProperty(_context3 = this._onDrag).call(_context3, this));
	      this.hammer.on('panend', _bindInstanceProperty(_context4 = this._onDragEnd).call(_context4, this));
	      this.hammer.get('pan').set({
	        threshold: 5,
	        direction: Hammer.DIRECTION_ALL
	      });
	      // delay addition on item click for trackpads...
	      this.hammer.get('press').set({
	        time: 10000
	      });
	    }

	    /**
	     * Destroy the CustomTime bar
	     */
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.hide();
	      this.hammer.destroy();
	      this.hammer = null;
	      this.body = null;
	    }

	    /**
	     * Repaint the component
	     * @return {boolean} Returns true if the component is resized
	     */
	  }, {
	    key: "redraw",
	    value: function redraw() {
	      var parent = this.body.dom.backgroundVertical;
	      if (this.bar.parentNode != parent) {
	        // attach to the dom
	        if (this.bar.parentNode) {
	          this.bar.parentNode.removeChild(this.bar);
	        }
	        parent.appendChild(this.bar);
	      }
	      var x = this.body.util.toScreen(this.customTime);
	      var locale = this.options.locales[this.options.locale];
	      if (!locale) {
	        if (!this.warned) {
	          console.warn("WARNING: options.locales['".concat(this.options.locale, "'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization"));
	          this.warned = true;
	        }
	        locale = this.options.locales['en']; // fall back on english when not available
	      }

	      var title = this.options.title;
	      // To hide the title completely use empty string ''.
	      if (title === undefined) {
	        var _context5;
	        title = _concatInstanceProperty(_context5 = "".concat(locale.time, ": ")).call(_context5, this.options.moment(this.customTime).format('dddd, MMMM Do YYYY, H:mm:ss'));
	        title = title.charAt(0).toUpperCase() + title.substring(1);
	      } else if (typeof title === "function") {
	        title = title.call(this, this.customTime);
	      }
	      this.options.rtl ? this.bar.style.right = "".concat(x, "px") : this.bar.style.left = "".concat(x, "px");
	      this.bar.title = title;
	      return false;
	    }

	    /**
	     * Remove the CustomTime from the DOM
	     */
	  }, {
	    key: "hide",
	    value: function hide() {
	      // remove the line from the DOM
	      if (this.bar.parentNode) {
	        this.bar.parentNode.removeChild(this.bar);
	      }
	    }

	    /**
	     * Set custom time.
	     * @param {Date | number | string} time
	     */
	  }, {
	    key: "setCustomTime",
	    value: function setCustomTime(time) {
	      this.customTime = availableUtils.convert(time, 'Date');
	      this.redraw();
	    }

	    /**
	     * Retrieve the current custom time.
	     * @return {Date} customTime
	     */
	  }, {
	    key: "getCustomTime",
	    value: function getCustomTime() {
	      return new Date(this.customTime.valueOf());
	    }

	    /**
	     * Set custom marker.
	     * @param {string} [title] Title of the custom marker
	     * @param {boolean} [editable] Make the custom marker editable.
	     */
	  }, {
	    key: "setCustomMarker",
	    value: function setCustomMarker(title, editable) {
	      var marker = document.createElement('div');
	      marker.className = "vis-custom-time-marker";
	      marker.innerHTML = availableUtils.xss(title);
	      marker.style.position = 'absolute';
	      if (editable) {
	        var _context6, _context7;
	        marker.setAttribute('contenteditable', 'true');
	        marker.addEventListener('pointerdown', function () {
	          marker.focus();
	        });
	        marker.addEventListener('input', _bindInstanceProperty(_context6 = this._onMarkerChange).call(_context6, this));
	        // The editable div element has no change event, so here emulates the change event.
	        marker.title = title;
	        marker.addEventListener('blur', _bindInstanceProperty(_context7 = function _context7(event) {
	          if (this.title != event.target.innerHTML) {
	            this._onMarkerChanged(event);
	            this.title = event.target.innerHTML;
	          }
	        }).call(_context7, this));
	      }
	      this.bar.appendChild(marker);
	    }

	    /**
	      * Set custom title.
	      * @param {Date | number | string} title
	      */
	  }, {
	    key: "setCustomTitle",
	    value: function setCustomTitle(title) {
	      this.options.title = title;
	    }

	    /**
	     * Start moving horizontally
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onDragStart",
	    value: function _onDragStart(event) {
	      this.eventParams.dragging = true;
	      this.eventParams.customTime = this.customTime;
	      event.stopPropagation();
	    }

	    /**
	     * Perform moving operating.
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onDrag",
	    value: function _onDrag(event) {
	      if (!this.eventParams.dragging) return;
	      var deltaX = this.options.rtl ? -1 * event.deltaX : event.deltaX;
	      var x = this.body.util.toScreen(this.eventParams.customTime) + deltaX;
	      var time = this.body.util.toTime(x);
	      var scale = this.body.util.getScale();
	      var step = this.body.util.getStep();
	      var snap = this.options.snap;
	      var snappedTime = snap ? snap(time, scale, step) : time;
	      this.setCustomTime(snappedTime);

	      // fire a timechange event
	      this.body.emitter.emit('timechange', {
	        id: this.options.id,
	        time: new Date(this.customTime.valueOf()),
	        event: event
	      });
	      event.stopPropagation();
	    }

	    /**
	     * Stop moving operating.
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onDragEnd",
	    value: function _onDragEnd(event) {
	      if (!this.eventParams.dragging) return;

	      // fire a timechanged event
	      this.body.emitter.emit('timechanged', {
	        id: this.options.id,
	        time: new Date(this.customTime.valueOf()),
	        event: event
	      });
	      event.stopPropagation();
	    }

	    /**
	     * Perform input operating.
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onMarkerChange",
	    value: function _onMarkerChange(event) {
	      this.body.emitter.emit('markerchange', {
	        id: this.options.id,
	        title: event.target.innerHTML,
	        event: event
	      });
	      event.stopPropagation();
	    }

	    /**
	     * Perform change operating.
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onMarkerChanged",
	    value: function _onMarkerChanged(event) {
	      this.body.emitter.emit('markerchanged', {
	        id: this.options.id,
	        title: event.target.innerHTML,
	        event: event
	      });
	      event.stopPropagation();
	    }

	    /**
	     * Find a custom time from an event target:
	     * searches for the attribute 'custom-time' in the event target's element tree
	     * @param {Event} event
	     * @return {CustomTime | null} customTime
	     */
	  }], [{
	    key: "customTimeFromTarget",
	    value: function customTimeFromTarget(event) {
	      var target = event.target;
	      while (target) {
	        if (target.hasOwnProperty('custom-time')) {
	          return target['custom-time'];
	        }
	        target = target.parentNode;
	      }
	      return null;
	    }
	  }]);
	  return CustomTime;
	}(Component);

	/**
	 * Create a timeline visualization
	 * @constructor Core
	 */
	var Core = /*#__PURE__*/function () {
	  function Core() {
	    _classCallCheck(this, Core);
	  }
	  _createClass(Core, [{
	    key: "_create",
	    value:
	    /**
	     * Create the main DOM for the Core: a root panel containing left, right,
	     * top, bottom, content, and background panel.
	     * @param {Element} container  The container element where the Core will
	     *                             be attached.
	     * @protected
	     */
	    function _create(container) {
	      var _this = this,
	        _context,
	        _context2,
	        _context3;
	      this.dom = {};
	      this.dom.container = container;
	      this.dom.container.style.position = 'relative';
	      this.dom.root = document.createElement('div');
	      this.dom.background = document.createElement('div');
	      this.dom.backgroundVertical = document.createElement('div');
	      this.dom.backgroundHorizontal = document.createElement('div');
	      this.dom.centerContainer = document.createElement('div');
	      this.dom.leftContainer = document.createElement('div');
	      this.dom.rightContainer = document.createElement('div');
	      this.dom.center = document.createElement('div');
	      this.dom.left = document.createElement('div');
	      this.dom.right = document.createElement('div');
	      this.dom.top = document.createElement('div');
	      this.dom.bottom = document.createElement('div');
	      this.dom.shadowTop = document.createElement('div');
	      this.dom.shadowBottom = document.createElement('div');
	      this.dom.shadowTopLeft = document.createElement('div');
	      this.dom.shadowBottomLeft = document.createElement('div');
	      this.dom.shadowTopRight = document.createElement('div');
	      this.dom.shadowBottomRight = document.createElement('div');
	      this.dom.rollingModeBtn = document.createElement('div');
	      this.dom.loadingScreen = document.createElement('div');
	      this.dom.root.className = 'vis-timeline';
	      this.dom.background.className = 'vis-panel vis-background';
	      this.dom.backgroundVertical.className = 'vis-panel vis-background vis-vertical';
	      this.dom.backgroundHorizontal.className = 'vis-panel vis-background vis-horizontal';
	      this.dom.centerContainer.className = 'vis-panel vis-center';
	      this.dom.leftContainer.className = 'vis-panel vis-left';
	      this.dom.rightContainer.className = 'vis-panel vis-right';
	      this.dom.top.className = 'vis-panel vis-top';
	      this.dom.bottom.className = 'vis-panel vis-bottom';
	      this.dom.left.className = 'vis-content';
	      this.dom.center.className = 'vis-content';
	      this.dom.right.className = 'vis-content';
	      this.dom.shadowTop.className = 'vis-shadow vis-top';
	      this.dom.shadowBottom.className = 'vis-shadow vis-bottom';
	      this.dom.shadowTopLeft.className = 'vis-shadow vis-top';
	      this.dom.shadowBottomLeft.className = 'vis-shadow vis-bottom';
	      this.dom.shadowTopRight.className = 'vis-shadow vis-top';
	      this.dom.shadowBottomRight.className = 'vis-shadow vis-bottom';
	      this.dom.rollingModeBtn.className = 'vis-rolling-mode-btn';
	      this.dom.loadingScreen.className = 'vis-loading-screen';
	      this.dom.root.appendChild(this.dom.background);
	      this.dom.root.appendChild(this.dom.backgroundVertical);
	      this.dom.root.appendChild(this.dom.backgroundHorizontal);
	      this.dom.root.appendChild(this.dom.centerContainer);
	      this.dom.root.appendChild(this.dom.leftContainer);
	      this.dom.root.appendChild(this.dom.rightContainer);
	      this.dom.root.appendChild(this.dom.top);
	      this.dom.root.appendChild(this.dom.bottom);
	      this.dom.root.appendChild(this.dom.rollingModeBtn);
	      this.dom.centerContainer.appendChild(this.dom.center);
	      this.dom.leftContainer.appendChild(this.dom.left);
	      this.dom.rightContainer.appendChild(this.dom.right);
	      this.dom.centerContainer.appendChild(this.dom.shadowTop);
	      this.dom.centerContainer.appendChild(this.dom.shadowBottom);
	      this.dom.leftContainer.appendChild(this.dom.shadowTopLeft);
	      this.dom.leftContainer.appendChild(this.dom.shadowBottomLeft);
	      this.dom.rightContainer.appendChild(this.dom.shadowTopRight);
	      this.dom.rightContainer.appendChild(this.dom.shadowBottomRight);

	      // size properties of each of the panels
	      this.props = {
	        root: {},
	        background: {},
	        centerContainer: {},
	        leftContainer: {},
	        rightContainer: {},
	        center: {},
	        left: {},
	        right: {},
	        top: {},
	        bottom: {},
	        border: {},
	        scrollTop: 0,
	        scrollTopMin: 0
	      };
	      this.on('rangechange', function () {
	        if (_this.initialDrawDone === true) {
	          _this._redraw();
	        }
	      });
	      this.on('rangechanged', function () {
	        if (!_this.initialRangeChangeDone) {
	          _this.initialRangeChangeDone = true;
	        }
	      });
	      this.on('touch', _bindInstanceProperty(_context = this._onTouch).call(_context, this));
	      this.on('panmove', _bindInstanceProperty(_context2 = this._onDrag).call(_context2, this));
	      var me = this;
	      this._origRedraw = _bindInstanceProperty(_context3 = this._redraw).call(_context3, this);
	      this._redraw = availableUtils.throttle(this._origRedraw);
	      this.on('_change', function (properties) {
	        if (me.itemSet && me.itemSet.initialItemSetDrawn && properties && properties.queue == true) {
	          me._redraw();
	        } else {
	          me._origRedraw();
	        }
	      });

	      // create event listeners for all interesting events, these events will be
	      // emitted via emitter
	      this.hammer = new Hammer(this.dom.root);
	      var pinchRecognizer = this.hammer.get('pinch').set({
	        enable: true
	      });
	      pinchRecognizer && disablePreventDefaultVertically(pinchRecognizer);
	      this.hammer.get('pan').set({
	        threshold: 5,
	        direction: Hammer.DIRECTION_ALL
	      });
	      this.timelineListeners = {};
	      var events = ['tap', 'doubletap', 'press', 'pinch', 'pan', 'panstart', 'panmove', 'panend'
	      // TODO: cleanup
	      //'touch', 'pinch',
	      //'tap', 'doubletap', 'hold',
	      //'dragstart', 'drag', 'dragend',
	      //'mousewheel', 'DOMMouseScroll' // DOMMouseScroll is needed for Firefox
	      ];

	      _forEachInstanceProperty(events).call(events, function (type) {
	        var listener = function listener(event) {
	          if (me.isActive()) {
	            me.emit(type, event);
	          }
	        };
	        me.hammer.on(type, listener);
	        me.timelineListeners[type] = listener;
	      });

	      // emulate a touch event (emitted before the start of a pan, pinch, tap, or press)
	      onTouch(this.hammer, function (event) {
	        me.emit('touch', event);
	      });

	      // emulate a release event (emitted after a pan, pinch, tap, or press)
	      onRelease(this.hammer, function (event) {
	        me.emit('release', event);
	      });

	      /**
	       *
	       * @param {WheelEvent} event
	       */
	      function onMouseWheel(event) {
	        // Reasonable default wheel deltas
	        var LINE_HEIGHT = 40;
	        var PAGE_HEIGHT = 800;
	        if (this.isActive()) {
	          this.emit('mousewheel', event);
	        }

	        // deltaX and deltaY normalization from jquery.mousewheel.js
	        var deltaX = 0;
	        var deltaY = 0;

	        // Old school scrollwheel delta
	        if ('detail' in event) {
	          deltaY = event.detail * -1;
	        }
	        if ('wheelDelta' in event) {
	          deltaY = event.wheelDelta;
	        }
	        if ('wheelDeltaY' in event) {
	          deltaY = event.wheelDeltaY;
	        }
	        if ('wheelDeltaX' in event) {
	          deltaX = event.wheelDeltaX * -1;
	        }

	        // Firefox < 17 horizontal scrolling related to DOMMouseScroll event
	        if ('axis' in event && event.axis === event.HORIZONTAL_AXIS) {
	          deltaX = deltaY * -1;
	          deltaY = 0;
	        }

	        // New school wheel delta (wheel event)
	        if ('deltaY' in event) {
	          deltaY = event.deltaY * -1;
	        }
	        if ('deltaX' in event) {
	          deltaX = event.deltaX;
	        }

	        // Normalize deltas
	        if (event.deltaMode) {
	          if (event.deltaMode === 1) {
	            // delta in LINE units
	            deltaX *= LINE_HEIGHT;
	            deltaY *= LINE_HEIGHT;
	          } else {
	            // delta in PAGE units
	            deltaX *= LINE_HEIGHT;
	            deltaY *= PAGE_HEIGHT;
	          }
	        }
	        // Prevent scrolling when zooming (no zoom key, or pressing zoom key)
	        if (this.options.preferZoom) {
	          if (!this.options.zoomKey || event[this.options.zoomKey]) return;
	        } else {
	          if (this.options.zoomKey && event[this.options.zoomKey]) return;
	        }
	        // Don't preventDefault if you can't scroll
	        if (!this.options.verticalScroll && !this.options.horizontalScroll) return;
	        if (this.options.verticalScroll && Math.abs(deltaY) >= Math.abs(deltaX)) {
	          var current = this.props.scrollTop;
	          var adjusted = current + deltaY;
	          if (this.isActive()) {
	            var newScrollTop = this._setScrollTop(adjusted);
	            if (newScrollTop !== current) {
	              this._redraw();
	              this.emit('scroll', event);

	              // Prevent default actions caused by mouse wheel
	              // (else the page and timeline both scroll)
	              event.preventDefault();
	            }
	          }
	        } else if (this.options.horizontalScroll) {
	          var delta = Math.abs(deltaX) >= Math.abs(deltaY) ? deltaX : deltaY;

	          // calculate a single scroll jump relative to the range scale
	          var diff = delta / 120 * (this.range.end - this.range.start) / 20;
	          // calculate new start and end
	          var newStart = this.range.start + diff;
	          var newEnd = this.range.end + diff;
	          var options = {
	            animation: false,
	            byUser: true,
	            event: event
	          };
	          this.range.setRange(newStart, newEnd, options);
	          event.preventDefault();
	        }
	      }

	      // Add modern wheel event listener
	      var wheelType = "onwheel" in document.createElement("div") ? "wheel" :
	      // Modern browsers support "wheel"
	      document.onmousewheel !== undefined ? "mousewheel" :
	      // Webkit and IE support at least "mousewheel"

	      // DOMMouseScroll - Older Firefox versions use "DOMMouseScroll"
	      // onmousewheel - All the use "onmousewheel"
	      this.dom.centerContainer.addEventListener ? "DOMMouseScroll" : "onmousewheel";
	      this.dom.top.addEventListener ? "DOMMouseScroll" : "onmousewheel";
	      this.dom.bottom.addEventListener ? "DOMMouseScroll" : "onmousewheel";
	      this.dom.centerContainer.addEventListener(wheelType, _bindInstanceProperty(onMouseWheel).call(onMouseWheel, this), false);
	      this.dom.top.addEventListener(wheelType, _bindInstanceProperty(onMouseWheel).call(onMouseWheel, this), false);
	      this.dom.bottom.addEventListener(wheelType, _bindInstanceProperty(onMouseWheel).call(onMouseWheel, this), false);

	      /**
	       *
	       * @param {scroll} event
	       */
	      function onMouseScrollSide(event) {
	        if (!me.options.verticalScroll) return;
	        event.preventDefault();
	        if (me.isActive()) {
	          var adjusted = -event.target.scrollTop;
	          me._setScrollTop(adjusted);
	          me._redraw();
	          me.emit('scrollSide', event);
	        }
	      }
	      this.dom.left.parentNode.addEventListener('scroll', _bindInstanceProperty(onMouseScrollSide).call(onMouseScrollSide, this));
	      this.dom.right.parentNode.addEventListener('scroll', _bindInstanceProperty(onMouseScrollSide).call(onMouseScrollSide, this));
	      var itemAddedToTimeline = false;

	      /**
	       *
	       * @param {dragover} event
	       * @returns {boolean}
	       */
	      function handleDragOver(event) {
	        var _context4;
	        if (event.preventDefault) {
	          me.emit('dragover', me.getEventProperties(event));
	          event.preventDefault(); // Necessary. Allows us to drop.
	        }

	        // make sure your target is a timeline element
	        if (!(_indexOfInstanceProperty(_context4 = event.target.className).call(_context4, "timeline") > -1)) return;

	        // make sure only one item is added every time you're over the timeline
	        if (itemAddedToTimeline) return;
	        event.dataTransfer.dropEffect = 'move';
	        itemAddedToTimeline = true;
	        return false;
	      }

	      /**
	       *
	       * @param {drop} event
	       * @returns {boolean}
	       */
	      function handleDrop(event) {
	        // prevent redirect to blank page - Firefox
	        if (event.preventDefault) {
	          event.preventDefault();
	        }
	        if (event.stopPropagation) {
	          event.stopPropagation();
	        }
	        // return when dropping non-timeline items
	        try {
	          var itemData = JSON.parse(event.dataTransfer.getData("text"));
	          if (!itemData || !itemData.content) return;
	        } catch (err) {
	          return false;
	        }
	        itemAddedToTimeline = false;
	        event.center = {
	          x: event.clientX,
	          y: event.clientY
	        };
	        if (itemData.target !== 'item') {
	          me.itemSet._onAddItem(event);
	        } else {
	          me.itemSet._onDropObjectOnItem(event);
	        }
	        me.emit('drop', me.getEventProperties(event));
	        return false;
	      }
	      this.dom.center.addEventListener('dragover', _bindInstanceProperty(handleDragOver).call(handleDragOver, this), false);
	      this.dom.center.addEventListener('drop', _bindInstanceProperty(handleDrop).call(handleDrop, this), false);
	      this.customTimes = [];

	      // store state information needed for touch events
	      this.touch = {};
	      this.redrawCount = 0;
	      this.initialDrawDone = false;
	      this.initialRangeChangeDone = false;

	      // attach the root panel to the provided container
	      if (!container) throw new Error('No container provided');
	      container.appendChild(this.dom.root);
	      container.appendChild(this.dom.loadingScreen);
	    }

	    /**
	     * Set options. Options will be passed to all components loaded in the Timeline.
	     * @param {Object} [options]
	     *                           {String} orientation
	     *                              Vertical orientation for the Timeline,
	     *                              can be 'bottom' (default) or 'top'.
	     *                           {string | number} width
	     *                              Width for the timeline, a number in pixels or
	     *                              a css string like '1000px' or '75%'. '100%' by default.
	     *                           {string | number} height
	     *                              Fixed height for the Timeline, a number in pixels or
	     *                              a css string like '400px' or '75%'. If undefined,
	     *                              The Timeline will automatically size such that
	     *                              its contents fit.
	     *                           {string | number} minHeight
	     *                              Minimum height for the Timeline, a number in pixels or
	     *                              a css string like '400px' or '75%'.
	     *                           {string | number} maxHeight
	     *                              Maximum height for the Timeline, a number in pixels or
	     *                              a css string like '400px' or '75%'.
	     *                           {number | Date | string} start
	     *                              Start date for the visible window
	     *                           {number | Date | string} end
	     *                              End date for the visible window
	     */
	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      var _context7;
	      if (options) {
	        // copy the known options
	        var fields = ['width', 'height', 'minHeight', 'maxHeight', 'autoResize', 'start', 'end', 'clickToUse', 'dataAttributes', 'hiddenDates', 'locale', 'locales', 'moment', 'preferZoom', 'rtl', 'zoomKey', 'horizontalScroll', 'verticalScroll', 'longSelectPressTime', 'snap'];
	        availableUtils.selectiveExtend(fields, this.options, options);
	        this.dom.rollingModeBtn.style.visibility = 'hidden';
	        if (this.options.rtl) {
	          this.dom.container.style.direction = "rtl";
	          this.dom.backgroundVertical.className = 'vis-panel vis-background vis-vertical-rtl';
	        }
	        if (this.options.verticalScroll) {
	          if (this.options.rtl) {
	            this.dom.rightContainer.className = 'vis-panel vis-right vis-vertical-scroll';
	          } else {
	            this.dom.leftContainer.className = 'vis-panel vis-left vis-vertical-scroll';
	          }
	        }
	        if (_typeof(this.options.orientation) !== 'object') {
	          this.options.orientation = {
	            item: undefined,
	            axis: undefined
	          };
	        }
	        if ('orientation' in options) {
	          if (typeof options.orientation === 'string') {
	            this.options.orientation = {
	              item: options.orientation,
	              axis: options.orientation
	            };
	          } else if (_typeof(options.orientation) === 'object') {
	            if ('item' in options.orientation) {
	              this.options.orientation.item = options.orientation.item;
	            }
	            if ('axis' in options.orientation) {
	              this.options.orientation.axis = options.orientation.axis;
	            }
	          }
	        }
	        if (this.options.orientation.axis === 'both') {
	          if (!this.timeAxis2) {
	            var timeAxis2 = this.timeAxis2 = new TimeAxis(this.body);
	            timeAxis2.setOptions = function (options) {
	              var _options = options ? availableUtils.extend({}, options) : {};
	              _options.orientation = 'top'; // override the orientation option, always top
	              TimeAxis.prototype.setOptions.call(timeAxis2, _options);
	            };
	            this.components.push(timeAxis2);
	          }
	        } else {
	          if (this.timeAxis2) {
	            var _context5;
	            var index = _indexOfInstanceProperty(_context5 = this.components).call(_context5, this.timeAxis2);
	            if (index !== -1) {
	              var _context6;
	              _spliceInstanceProperty(_context6 = this.components).call(_context6, index, 1);
	            }
	            this.timeAxis2.destroy();
	            this.timeAxis2 = null;
	          }
	        }

	        // if the graph2d's drawPoints is a function delegate the callback to the onRender property
	        if (typeof options.drawPoints == 'function') {
	          options.drawPoints = {
	            onRender: options.drawPoints
	          };
	        }
	        if ('hiddenDates' in this.options) {
	          convertHiddenOptions(this.options.moment, this.body, this.options.hiddenDates);
	        }
	        if ('clickToUse' in options) {
	          if (options.clickToUse) {
	            if (!this.activator) {
	              this.activator = new Activator(this.dom.root);
	            }
	          } else {
	            if (this.activator) {
	              this.activator.destroy();
	              delete this.activator;
	            }
	          }
	        }

	        // enable/disable autoResize
	        this._initAutoResize();
	      }

	      // propagate options to all components
	      _forEachInstanceProperty(_context7 = this.components).call(_context7, function (component) {
	        return component.setOptions(options);
	      });

	      // enable/disable configure
	      if ('configure' in options) {
	        var _context8;
	        if (!this.configurator) {
	          this.configurator = this._createConfigurator();
	        }
	        this.configurator.setOptions(options.configure);

	        // collect the settings of all components, and pass them to the configuration system
	        var appliedOptions = availableUtils.deepExtend({}, this.options);
	        _forEachInstanceProperty(_context8 = this.components).call(_context8, function (component) {
	          availableUtils.deepExtend(appliedOptions, component.options);
	        });
	        this.configurator.setModuleOptions({
	          global: appliedOptions
	        });
	      }
	      this._redraw();
	    }

	    /**
	     * Returns true when the Timeline is active.
	     * @returns {boolean}
	     */
	  }, {
	    key: "isActive",
	    value: function isActive() {
	      return !this.activator || this.activator.active;
	    }

	    /**
	     * Destroy the Core, clean up all DOM elements and event listeners.
	     */
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      var _context9;
	      // unbind datasets
	      this.setItems(null);
	      this.setGroups(null);

	      // remove all event listeners
	      this.off();

	      // stop checking for changed size
	      this._stopAutoResize();

	      // remove from DOM
	      if (this.dom.root.parentNode) {
	        this.dom.root.parentNode.removeChild(this.dom.root);
	      }
	      this.dom = null;

	      // remove Activator
	      if (this.activator) {
	        this.activator.destroy();
	        delete this.activator;
	      }

	      // cleanup hammer touch events
	      for (var event in this.timelineListeners) {
	        if (this.timelineListeners.hasOwnProperty(event)) {
	          delete this.timelineListeners[event];
	        }
	      }
	      this.timelineListeners = null;
	      this.hammer && this.hammer.destroy();
	      this.hammer = null;

	      // give all components the opportunity to cleanup
	      _forEachInstanceProperty(_context9 = this.components).call(_context9, function (component) {
	        return component.destroy();
	      });
	      this.body = null;
	    }

	    /**
	     * Set a custom time bar
	     * @param {Date} time
	     * @param {number} [id=undefined] Optional id of the custom time bar to be adjusted.
	     */
	  }, {
	    key: "setCustomTime",
	    value: function setCustomTime(time, id) {
	      var _context10;
	      var customTimes = _filterInstanceProperty(_context10 = this.customTimes).call(_context10, function (component) {
	        return id === component.options.id;
	      });
	      if (customTimes.length === 0) {
	        throw new Error("No custom time bar found with id ".concat(_JSON$stringify(id)));
	      }
	      if (customTimes.length > 0) {
	        customTimes[0].setCustomTime(time);
	      }
	    }

	    /**
	     * Retrieve the current custom time.
	     * @param {number} [id=undefined]    Id of the custom time bar.
	     * @return {Date | undefined} customTime
	     */
	  }, {
	    key: "getCustomTime",
	    value: function getCustomTime(id) {
	      var _context11;
	      var customTimes = _filterInstanceProperty(_context11 = this.customTimes).call(_context11, function (component) {
	        return component.options.id === id;
	      });
	      if (customTimes.length === 0) {
	        throw new Error("No custom time bar found with id ".concat(_JSON$stringify(id)));
	      }
	      return customTimes[0].getCustomTime();
	    }

	    /**
	     * Set a custom marker for the custom time bar.
	     * @param {string} [title] Title of the custom marker.
	     * @param {number} [id=undefined] Id of the custom marker.
	     * @param {boolean} [editable=false] Make the custom marker editable.
	     */
	  }, {
	    key: "setCustomTimeMarker",
	    value: function setCustomTimeMarker(title, id, editable) {
	      var _context12;
	      var customTimes = _filterInstanceProperty(_context12 = this.customTimes).call(_context12, function (component) {
	        return component.options.id === id;
	      });
	      if (customTimes.length === 0) {
	        throw new Error("No custom time bar found with id ".concat(_JSON$stringify(id)));
	      }
	      if (customTimes.length > 0) {
	        customTimes[0].setCustomMarker(title, editable);
	      }
	    }

	    /**
	     * Set a custom title for the custom time bar.
	     * @param {string} [title] Custom title
	     * @param {number} [id=undefined]    Id of the custom time bar.
	     * @returns {*}
	     */
	  }, {
	    key: "setCustomTimeTitle",
	    value: function setCustomTimeTitle(title, id) {
	      var _context13;
	      var customTimes = _filterInstanceProperty(_context13 = this.customTimes).call(_context13, function (component) {
	        return component.options.id === id;
	      });
	      if (customTimes.length === 0) {
	        throw new Error("No custom time bar found with id ".concat(_JSON$stringify(id)));
	      }
	      if (customTimes.length > 0) {
	        return customTimes[0].setCustomTitle(title);
	      }
	    }

	    /**
	     * Retrieve meta information from an event.
	     * Should be overridden by classes extending Core
	     * @param {Event} event
	     * @return {Object} An object with related information.
	     */
	  }, {
	    key: "getEventProperties",
	    value: function getEventProperties(event) {
	      return {
	        event: event
	      };
	    }

	    /**
	     * Add custom vertical bar
	     * @param {Date | string | number} [time]  A Date, unix timestamp, or
	     *                                         ISO date string. Time point where
	     *                                         the new bar should be placed.
	     *                                         If not provided, `new Date()` will
	     *                                         be used.
	     * @param {number | string} [id=undefined] Id of the new bar. Optional
	     * @return {number | string}               Returns the id of the new bar
	     */
	  }, {
	    key: "addCustomTime",
	    value: function addCustomTime(time, id) {
	      var _context14;
	      var timestamp = time !== undefined ? availableUtils.convert(time, 'Date') : new Date();
	      var exists = _someInstanceProperty(_context14 = this.customTimes).call(_context14, function (customTime) {
	        return customTime.options.id === id;
	      });
	      if (exists) {
	        throw new Error("A custom time with id ".concat(_JSON$stringify(id), " already exists"));
	      }
	      var customTime = new CustomTime(this.body, availableUtils.extend({}, this.options, {
	        time: timestamp,
	        id: id,
	        snap: this.itemSet ? this.itemSet.options.snap : this.options.snap
	      }));
	      this.customTimes.push(customTime);
	      this.components.push(customTime);
	      this._redraw();
	      return id;
	    }

	    /**
	     * Remove previously added custom bar
	     * @param {int} id ID of the custom bar to be removed
	     * [at]returns {boolean} True if the bar exists and is removed, false otherwise
	     */
	  }, {
	    key: "removeCustomTime",
	    value: function removeCustomTime(id) {
	      var _context15,
	        _this2 = this;
	      var customTimes = _filterInstanceProperty(_context15 = this.customTimes).call(_context15, function (bar) {
	        return bar.options.id === id;
	      });
	      if (customTimes.length === 0) {
	        throw new Error("No custom time bar found with id ".concat(_JSON$stringify(id)));
	      }
	      _forEachInstanceProperty(customTimes).call(customTimes, function (customTime) {
	        var _context16, _context17, _context18, _context19;
	        _spliceInstanceProperty(_context16 = _this2.customTimes).call(_context16, _indexOfInstanceProperty(_context17 = _this2.customTimes).call(_context17, customTime), 1);
	        _spliceInstanceProperty(_context18 = _this2.components).call(_context18, _indexOfInstanceProperty(_context19 = _this2.components).call(_context19, customTime), 1);
	        customTime.destroy();
	      });
	    }

	    /**
	     * Get the id's of the currently visible items.
	     * @returns {Array} The ids of the visible items
	     */
	  }, {
	    key: "getVisibleItems",
	    value: function getVisibleItems() {
	      return this.itemSet && this.itemSet.getVisibleItems() || [];
	    }

	    /**
	     * Get the id's of the items at specific time, where a click takes place on the timeline.
	     * @returns {Array} The ids of all items in existence at the time of event.
	     */
	  }, {
	    key: "getItemsAtCurrentTime",
	    value: function getItemsAtCurrentTime(timeOfEvent) {
	      this.time = timeOfEvent;
	      return this.itemSet && this.itemSet.getItemsAtCurrentTime(this.time) || [];
	    }

	    /**
	     * Get the id's of the currently visible groups.
	     * @returns {Array} The ids of the visible groups
	     */
	  }, {
	    key: "getVisibleGroups",
	    value: function getVisibleGroups() {
	      return this.itemSet && this.itemSet.getVisibleGroups() || [];
	    }

	    /**
	     * Set Core window such that it fits all items
	     * @param {Object} [options]  Available options:
	     *                                `animation: boolean | {duration: number, easingFunction: string}`
	     *                                    If true (default), the range is animated
	     *                                    smoothly to the new window. An object can be
	     *                                    provided to specify duration and easing function.
	     *                                    Default duration is 500 ms, and default easing
	     *                                    function is 'easeInOutQuad'.
	     * @param {function} [callback] a callback funtion to be executed at the end of this function
	     */
	  }, {
	    key: "fit",
	    value: function fit(options, callback) {
	      var range = this.getDataRange();

	      // skip range set if there is no min and max date
	      if (range.min === null && range.max === null) {
	        return;
	      }

	      // apply a margin of 1% left and right of the data
	      var interval = range.max - range.min;
	      var min = new Date(range.min.valueOf() - interval * 0.01);
	      var max = new Date(range.max.valueOf() + interval * 0.01);
	      var animation = options && options.animation !== undefined ? options.animation : true;
	      this.range.setRange(min, max, {
	        animation: animation
	      }, callback);
	    }

	    /**
	     * Calculate the data range of the items start and end dates
	     * [at]returns {{min: [Date], max: [Date]}}
	     * @protected
	     */
	  }, {
	    key: "getDataRange",
	    value: function getDataRange() {
	      // must be implemented by Timeline and Graph2d
	      throw new Error('Cannot invoke abstract method getDataRange');
	    }

	    /**
	     * Set the visible window. Both parameters are optional, you can change only
	     * start or only end. Syntax:
	     *
	     *     TimeLine.setWindow(start, end)
	     *     TimeLine.setWindow(start, end, options)
	     *     TimeLine.setWindow(range)
	     *
	     * Where start and end can be a Date, number, or string, and range is an
	     * object with properties start and end.
	     *
	     * @param {Date | number | string | Object} [start] Start date of visible window
	     * @param {Date | number | string} [end]            End date of visible window
	     * @param {Object} [options]  Available options:
	     *                                `animation: boolean | {duration: number, easingFunction: string}`
	     *                                    If true (default), the range is animated
	     *                                    smoothly to the new window. An object can be
	     *                                    provided to specify duration and easing function.
	     *                                    Default duration is 500 ms, and default easing
	     *                                    function is 'easeInOutQuad'.
	     * @param {function} [callback] a callback funtion to be executed at the end of this function
	     */
	  }, {
	    key: "setWindow",
	    value: function setWindow(start, end, options, callback) {
	      if (typeof arguments[2] == "function") {
	        callback = arguments[2];
	        options = {};
	      }
	      var animation;
	      var range;
	      if (arguments.length == 1) {
	        range = arguments[0];
	        animation = range.animation !== undefined ? range.animation : true;
	        this.range.setRange(range.start, range.end, {
	          animation: animation
	        });
	      } else if (arguments.length == 2 && typeof arguments[1] == "function") {
	        range = arguments[0];
	        callback = arguments[1];
	        animation = range.animation !== undefined ? range.animation : true;
	        this.range.setRange(range.start, range.end, {
	          animation: animation
	        }, callback);
	      } else {
	        animation = options && options.animation !== undefined ? options.animation : true;
	        this.range.setRange(start, end, {
	          animation: animation
	        }, callback);
	      }
	    }

	    /**
	     * Move the window such that given time is centered on screen.
	     * @param {Date | number | string} time
	     * @param {Object} [options]  Available options:
	     *                                `animation: boolean | {duration: number, easingFunction: string}`
	     *                                    If true (default), the range is animated
	     *                                    smoothly to the new window. An object can be
	     *                                    provided to specify duration and easing function.
	     *                                    Default duration is 500 ms, and default easing
	     *                                    function is 'easeInOutQuad'.
	     * @param {function} [callback] a callback funtion to be executed at the end of this function
	     */
	  }, {
	    key: "moveTo",
	    value: function moveTo(time, options, callback) {
	      if (typeof arguments[1] == "function") {
	        callback = arguments[1];
	        options = {};
	      }
	      var interval = this.range.end - this.range.start;
	      var t = availableUtils.convert(time, 'Date').valueOf();
	      var start = t - interval / 2;
	      var end = t + interval / 2;
	      var animation = options && options.animation !== undefined ? options.animation : true;
	      this.range.setRange(start, end, {
	        animation: animation
	      }, callback);
	    }

	    /**
	     * Get the visible window
	     * @return {{start: Date, end: Date}}   Visible range
	     */
	  }, {
	    key: "getWindow",
	    value: function getWindow() {
	      var range = this.range.getRange();
	      return {
	        start: new Date(range.start),
	        end: new Date(range.end)
	      };
	    }

	    /**
	     * Zoom in the window such that given time is centered on screen.
	     * @param {number} percentage - must be between [0..1]
	     * @param {Object} [options]  Available options:
	     *                                `animation: boolean | {duration: number, easingFunction: string}`
	     *                                    If true (default), the range is animated
	     *                                    smoothly to the new window. An object can be
	     *                                    provided to specify duration and easing function.
	     *                                    Default duration is 500 ms, and default easing
	     *                                    function is 'easeInOutQuad'.
	     * @param {function} [callback] a callback funtion to be executed at the end of this function
	     */
	  }, {
	    key: "zoomIn",
	    value: function zoomIn(percentage, options, callback) {
	      if (!percentage || percentage < 0 || percentage > 1) return;
	      if (typeof arguments[1] == "function") {
	        callback = arguments[1];
	        options = {};
	      }
	      var range = this.getWindow();
	      var start = range.start.valueOf();
	      var end = range.end.valueOf();
	      var interval = end - start;
	      var newInterval = interval / (1 + percentage);
	      var distance = (interval - newInterval) / 2;
	      var newStart = start + distance;
	      var newEnd = end - distance;
	      this.setWindow(newStart, newEnd, options, callback);
	    }

	    /**
	     * Zoom out the window such that given time is centered on screen.
	     * @param {number} percentage - must be between [0..1]
	     * @param {Object} [options]  Available options:
	     *                                `animation: boolean | {duration: number, easingFunction: string}`
	     *                                    If true (default), the range is animated
	     *                                    smoothly to the new window. An object can be
	     *                                    provided to specify duration and easing function.
	     *                                    Default duration is 500 ms, and default easing
	     *                                    function is 'easeInOutQuad'.
	     * @param {function} [callback] a callback funtion to be executed at the end of this function
	     */
	  }, {
	    key: "zoomOut",
	    value: function zoomOut(percentage, options, callback) {
	      if (!percentage || percentage < 0 || percentage > 1) return;
	      if (typeof arguments[1] == "function") {
	        callback = arguments[1];
	        options = {};
	      }
	      var range = this.getWindow();
	      var start = range.start.valueOf();
	      var end = range.end.valueOf();
	      var interval = end - start;
	      var newStart = start - interval * percentage / 2;
	      var newEnd = end + interval * percentage / 2;
	      this.setWindow(newStart, newEnd, options, callback);
	    }

	    /**
	     * Force a redraw. Can be overridden by implementations of Core
	     *
	     * Note: this function will be overridden on construction with a trottled version
	     */
	  }, {
	    key: "redraw",
	    value: function redraw() {
	      this._redraw();
	    }

	    /**
	     * Redraw for internal use. Redraws all components. See also the public
	     * method redraw.
	     * @protected
	     */
	  }, {
	    key: "_redraw",
	    value: function _redraw() {
	      var _context20;
	      this.redrawCount++;
	      var dom = this.dom;
	      if (!dom || !dom.container || dom.root.offsetWidth == 0) return; // when destroyed, or invisible

	      var resized = false;
	      var options = this.options;
	      var props = this.props;
	      updateHiddenDates(this.options.moment, this.body, this.options.hiddenDates);

	      // update class names
	      if (options.orientation == 'top') {
	        availableUtils.addClassName(dom.root, 'vis-top');
	        availableUtils.removeClassName(dom.root, 'vis-bottom');
	      } else {
	        availableUtils.removeClassName(dom.root, 'vis-top');
	        availableUtils.addClassName(dom.root, 'vis-bottom');
	      }
	      if (options.rtl) {
	        availableUtils.addClassName(dom.root, 'vis-rtl');
	        availableUtils.removeClassName(dom.root, 'vis-ltr');
	      } else {
	        availableUtils.addClassName(dom.root, 'vis-ltr');
	        availableUtils.removeClassName(dom.root, 'vis-rtl');
	      }

	      // update root width and height options
	      dom.root.style.maxHeight = availableUtils.option.asSize(options.maxHeight, '');
	      dom.root.style.minHeight = availableUtils.option.asSize(options.minHeight, '');
	      dom.root.style.width = availableUtils.option.asSize(options.width, '');
	      var rootOffsetWidth = dom.root.offsetWidth;

	      // calculate border widths
	      props.border.left = 1;
	      props.border.right = 1;
	      props.border.top = 1;
	      props.border.bottom = 1;

	      // calculate the heights. If any of the side panels is empty, we set the height to
	      // minus the border width, such that the border will be invisible
	      props.center.height = dom.center.offsetHeight;
	      props.left.height = dom.left.offsetHeight;
	      props.right.height = dom.right.offsetHeight;
	      props.top.height = dom.top.clientHeight || -props.border.top;
	      props.bottom.height = Math.round(dom.bottom.getBoundingClientRect().height) || dom.bottom.clientHeight || -props.border.bottom;

	      // TODO: compensate borders when any of the panels is empty.

	      // apply auto height
	      // TODO: only calculate autoHeight when needed (else we cause an extra reflow/repaint of the DOM)
	      var contentHeight = Math.max(props.left.height, props.center.height, props.right.height);
	      var autoHeight = props.top.height + contentHeight + props.bottom.height + props.border.top + props.border.bottom;
	      dom.root.style.height = availableUtils.option.asSize(options.height, "".concat(autoHeight, "px"));

	      // calculate heights of the content panels
	      props.root.height = dom.root.offsetHeight;
	      props.background.height = props.root.height;
	      var containerHeight = props.root.height - props.top.height - props.bottom.height;
	      props.centerContainer.height = containerHeight;
	      props.leftContainer.height = containerHeight;
	      props.rightContainer.height = props.leftContainer.height;

	      // calculate the widths of the panels
	      props.root.width = rootOffsetWidth;
	      props.background.width = props.root.width;
	      if (!this.initialDrawDone) {
	        props.scrollbarWidth = availableUtils.getScrollBarWidth();
	      }
	      var leftContainerClientWidth = dom.leftContainer.clientWidth;
	      var rightContainerClientWidth = dom.rightContainer.clientWidth;
	      if (options.verticalScroll) {
	        if (options.rtl) {
	          props.left.width = leftContainerClientWidth || -props.border.left;
	          props.right.width = rightContainerClientWidth + props.scrollbarWidth || -props.border.right;
	        } else {
	          props.left.width = leftContainerClientWidth + props.scrollbarWidth || -props.border.left;
	          props.right.width = rightContainerClientWidth || -props.border.right;
	        }
	      } else {
	        props.left.width = leftContainerClientWidth || -props.border.left;
	        props.right.width = rightContainerClientWidth || -props.border.right;
	      }
	      this._setDOM();

	      // update the scrollTop, feasible range for the offset can be changed
	      // when the height of the Core or of the contents of the center changed
	      var offset = this._updateScrollTop();

	      // reposition the scrollable contents
	      if (options.orientation.item != 'top') {
	        offset += Math.max(props.centerContainer.height - props.center.height - props.border.top - props.border.bottom, 0);
	      }
	      dom.center.style.transform = "translateY(".concat(offset, "px)");

	      // show shadows when vertical scrolling is available
	      var visibilityTop = props.scrollTop == 0 ? 'hidden' : '';
	      var visibilityBottom = props.scrollTop == props.scrollTopMin ? 'hidden' : '';
	      dom.shadowTop.style.visibility = visibilityTop;
	      dom.shadowBottom.style.visibility = visibilityBottom;
	      dom.shadowTopLeft.style.visibility = visibilityTop;
	      dom.shadowBottomLeft.style.visibility = visibilityBottom;
	      dom.shadowTopRight.style.visibility = visibilityTop;
	      dom.shadowBottomRight.style.visibility = visibilityBottom;
	      if (options.verticalScroll) {
	        dom.rightContainer.className = 'vis-panel vis-right vis-vertical-scroll';
	        dom.leftContainer.className = 'vis-panel vis-left vis-vertical-scroll';
	        dom.shadowTopRight.style.visibility = "hidden";
	        dom.shadowBottomRight.style.visibility = "hidden";
	        dom.shadowTopLeft.style.visibility = "hidden";
	        dom.shadowBottomLeft.style.visibility = "hidden";
	        dom.left.style.top = '0px';
	        dom.right.style.top = '0px';
	      }
	      if (!options.verticalScroll || props.center.height < props.centerContainer.height) {
	        dom.left.style.top = "".concat(offset, "px");
	        dom.right.style.top = "".concat(offset, "px");
	        dom.rightContainer.className = dom.rightContainer.className.replace(new RegExp('(?:^|\\s)' + 'vis-vertical-scroll' + '(?:\\s|$)'), ' ');
	        dom.leftContainer.className = dom.leftContainer.className.replace(new RegExp('(?:^|\\s)' + 'vis-vertical-scroll' + '(?:\\s|$)'), ' ');
	        props.left.width = leftContainerClientWidth || -props.border.left;
	        props.right.width = rightContainerClientWidth || -props.border.right;
	        this._setDOM();
	      }

	      // enable/disable vertical panning
	      var contentsOverflow = props.center.height > props.centerContainer.height;
	      this.hammer.get('pan').set({
	        direction: contentsOverflow ? Hammer.DIRECTION_ALL : Hammer.DIRECTION_HORIZONTAL
	      });

	      // set the long press time
	      this.hammer.get('press').set({
	        time: this.options.longSelectPressTime
	      });

	      // redraw all components
	      _forEachInstanceProperty(_context20 = this.components).call(_context20, function (component) {
	        resized = component.redraw() || resized;
	      });
	      var MAX_REDRAW = 5;
	      if (resized) {
	        if (this.redrawCount < MAX_REDRAW) {
	          this.body.emitter.emit('_change');
	          return;
	        } else {
	          console.log('WARNING: infinite loop in redraw?');
	        }
	      } else {
	        this.redrawCount = 0;
	      }

	      //Emit public 'changed' event for UI updates, see issue #1592
	      this.body.emitter.emit("changed");
	    }

	    /**
	     * sets the basic DOM components needed for the timeline\graph2d
	     */
	  }, {
	    key: "_setDOM",
	    value: function _setDOM() {
	      var props = this.props;
	      var dom = this.dom;
	      props.leftContainer.width = props.left.width;
	      props.rightContainer.width = props.right.width;
	      var centerWidth = props.root.width - props.left.width - props.right.width;
	      props.center.width = centerWidth;
	      props.centerContainer.width = centerWidth;
	      props.top.width = centerWidth;
	      props.bottom.width = centerWidth;

	      // resize the panels
	      dom.background.style.height = "".concat(props.background.height, "px");
	      dom.backgroundVertical.style.height = "".concat(props.background.height, "px");
	      dom.backgroundHorizontal.style.height = "".concat(props.centerContainer.height, "px");
	      dom.centerContainer.style.height = "".concat(props.centerContainer.height, "px");
	      dom.leftContainer.style.height = "".concat(props.leftContainer.height, "px");
	      dom.rightContainer.style.height = "".concat(props.rightContainer.height, "px");
	      dom.background.style.width = "".concat(props.background.width, "px");
	      dom.backgroundVertical.style.width = "".concat(props.centerContainer.width, "px");
	      dom.backgroundHorizontal.style.width = "".concat(props.background.width, "px");
	      dom.centerContainer.style.width = "".concat(props.center.width, "px");
	      dom.top.style.width = "".concat(props.top.width, "px");
	      dom.bottom.style.width = "".concat(props.bottom.width, "px");

	      // reposition the panels
	      dom.background.style.left = '0';
	      dom.background.style.top = '0';
	      dom.backgroundVertical.style.left = "".concat(props.left.width + props.border.left, "px");
	      dom.backgroundVertical.style.top = '0';
	      dom.backgroundHorizontal.style.left = '0';
	      dom.backgroundHorizontal.style.top = "".concat(props.top.height, "px");
	      dom.centerContainer.style.left = "".concat(props.left.width, "px");
	      dom.centerContainer.style.top = "".concat(props.top.height, "px");
	      dom.leftContainer.style.left = '0';
	      dom.leftContainer.style.top = "".concat(props.top.height, "px");
	      dom.rightContainer.style.left = "".concat(props.left.width + props.center.width, "px");
	      dom.rightContainer.style.top = "".concat(props.top.height, "px");
	      dom.top.style.left = "".concat(props.left.width, "px");
	      dom.top.style.top = '0';
	      dom.bottom.style.left = "".concat(props.left.width, "px");
	      dom.bottom.style.top = "".concat(props.top.height + props.centerContainer.height, "px");
	      dom.center.style.left = '0';
	      dom.left.style.left = '0';
	      dom.right.style.left = '0';
	    }

	    /**
	     * Set a current time. This can be used for example to ensure that a client's
	     * time is synchronized with a shared server time.
	     * Only applicable when option `showCurrentTime` is true.
	     * @param {Date | string | number} time     A Date, unix timestamp, or
	     *                                          ISO date string.
	     */
	  }, {
	    key: "setCurrentTime",
	    value: function setCurrentTime(time) {
	      if (!this.currentTime) {
	        throw new Error('Option showCurrentTime must be true');
	      }
	      this.currentTime.setCurrentTime(time);
	    }

	    /**
	     * Get the current time.
	     * Only applicable when option `showCurrentTime` is true.
	     * @return {Date} Returns the current time.
	     */
	  }, {
	    key: "getCurrentTime",
	    value: function getCurrentTime() {
	      if (!this.currentTime) {
	        throw new Error('Option showCurrentTime must be true');
	      }
	      return this.currentTime.getCurrentTime();
	    }

	    /**
	     * Convert a position on screen (pixels) to a datetime
	     * @param {int}     x    Position on the screen in pixels
	     * @return {Date}   time The datetime the corresponds with given position x
	     * @protected
	     * TODO: move this function to Range
	     */
	  }, {
	    key: "_toTime",
	    value: function _toTime(x) {
	      return toTime(this, x, this.props.center.width);
	    }

	    /**
	     * Convert a position on the global screen (pixels) to a datetime
	     * @param {int}     x    Position on the screen in pixels
	     * @return {Date}   time The datetime the corresponds with given position x
	     * @protected
	     * TODO: move this function to Range
	     */
	  }, {
	    key: "_toGlobalTime",
	    value: function _toGlobalTime(x) {
	      return toTime(this, x, this.props.root.width);
	      //var conversion = this.range.conversion(this.props.root.width);
	      //return new Date(x / conversion.scale + conversion.offset);
	    }

	    /**
	     * Convert a datetime (Date object) into a position on the screen
	     * @param {Date}   time A date
	     * @return {int}   x    The position on the screen in pixels which corresponds
	     *                      with the given date.
	     * @protected
	     * TODO: move this function to Range
	     */
	  }, {
	    key: "_toScreen",
	    value: function _toScreen(time) {
	      return toScreen(this, time, this.props.center.width);
	    }

	    /**
	     * Convert a datetime (Date object) into a position on the root
	     * This is used to get the pixel density estimate for the screen, not the center panel
	     * @param {Date}   time A date
	     * @return {int}   x    The position on root in pixels which corresponds
	     *                      with the given date.
	     * @protected
	     * TODO: move this function to Range
	     */
	  }, {
	    key: "_toGlobalScreen",
	    value: function _toGlobalScreen(time) {
	      return toScreen(this, time, this.props.root.width);
	      //var conversion = this.range.conversion(this.props.root.width);
	      //return (time.valueOf() - conversion.offset) * conversion.scale;
	    }

	    /**
	     * Initialize watching when option autoResize is true
	     * @private
	     */
	  }, {
	    key: "_initAutoResize",
	    value: function _initAutoResize() {
	      if (this.options.autoResize == true) {
	        this._startAutoResize();
	      } else {
	        this._stopAutoResize();
	      }
	    }

	    /**
	     * Watch for changes in the size of the container. On resize, the Panel will
	     * automatically redraw itself.
	     * @private
	     */
	  }, {
	    key: "_startAutoResize",
	    value: function _startAutoResize() {
	      var me = this;
	      this._stopAutoResize();
	      this._onResize = function () {
	        if (me.options.autoResize != true) {
	          // stop watching when the option autoResize is changed to false
	          me._stopAutoResize();
	          return;
	        }
	        if (me.dom.root) {
	          var rootOffsetHeight = me.dom.root.offsetHeight;
	          var rootOffsetWidth = me.dom.root.offsetWidth;
	          // check whether the frame is resized
	          // Note: we compare offsetWidth here, not clientWidth. For some reason,
	          // IE does not restore the clientWidth from 0 to the actual width after
	          // changing the timeline's container display style from none to visible
	          if (rootOffsetWidth != me.props.lastWidth || rootOffsetHeight != me.props.lastHeight) {
	            me.props.lastWidth = rootOffsetWidth;
	            me.props.lastHeight = rootOffsetHeight;
	            me.props.scrollbarWidth = availableUtils.getScrollBarWidth();
	            me.body.emitter.emit('_change');
	          }
	        }
	      };

	      // add event listener to window resize
	      availableUtils.addEventListener(window, 'resize', this._onResize);

	      //Prevent initial unnecessary redraw
	      if (me.dom.root) {
	        me.props.lastWidth = me.dom.root.offsetWidth;
	        me.props.lastHeight = me.dom.root.offsetHeight;
	      }
	      this.watchTimer = _setInterval(this._onResize, 1000);
	    }

	    /**
	     * Stop watching for a resize of the frame.
	     * @private
	     */
	  }, {
	    key: "_stopAutoResize",
	    value: function _stopAutoResize() {
	      if (this.watchTimer) {
	        clearInterval(this.watchTimer);
	        this.watchTimer = undefined;
	      }

	      // remove event listener on window.resize
	      if (this._onResize) {
	        availableUtils.removeEventListener(window, 'resize', this._onResize);
	        this._onResize = null;
	      }
	    }

	    /**
	     * Start moving the timeline vertically
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onTouch",
	    value: function _onTouch(event) {
	      // eslint-disable-line no-unused-vars
	      this.touch.allowDragging = true;
	      this.touch.initialScrollTop = this.props.scrollTop;
	    }

	    /**
	     * Start moving the timeline vertically
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onPinch",
	    value: function _onPinch(event) {
	      // eslint-disable-line no-unused-vars
	      this.touch.allowDragging = false;
	    }

	    /**
	     * Move the timeline vertically
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onDrag",
	    value: function _onDrag(event) {
	      if (!event) return;
	      // refuse to drag when we where pinching to prevent the timeline make a jump
	      // when releasing the fingers in opposite order from the touch screen
	      if (!this.touch.allowDragging) return;
	      var delta = event.deltaY;
	      var oldScrollTop = this._getScrollTop();
	      var newScrollTop = this._setScrollTop(this.touch.initialScrollTop + delta);
	      if (this.options.verticalScroll) {
	        this.dom.left.parentNode.scrollTop = -this.props.scrollTop;
	        this.dom.right.parentNode.scrollTop = -this.props.scrollTop;
	      }
	      if (newScrollTop != oldScrollTop) {
	        this.emit("verticalDrag");
	      }
	    }

	    /**
	     * Apply a scrollTop
	     * @param {number} scrollTop
	     * @returns {number} scrollTop  Returns the applied scrollTop
	     * @private
	     */
	  }, {
	    key: "_setScrollTop",
	    value: function _setScrollTop(scrollTop) {
	      this.props.scrollTop = scrollTop;
	      this._updateScrollTop();
	      return this.props.scrollTop;
	    }

	    /**
	     * Update the current scrollTop when the height of  the containers has been changed
	     * @returns {number} scrollTop  Returns the applied scrollTop
	     * @private
	     */
	  }, {
	    key: "_updateScrollTop",
	    value: function _updateScrollTop() {
	      // recalculate the scrollTopMin
	      var scrollTopMin = Math.min(this.props.centerContainer.height - this.props.border.top - this.props.border.bottom - this.props.center.height, 0); // is negative or zero
	      if (scrollTopMin != this.props.scrollTopMin) {
	        // in case of bottom orientation, change the scrollTop such that the contents
	        // do not move relative to the time axis at the bottom
	        if (this.options.orientation.item != 'top') {
	          this.props.scrollTop += scrollTopMin - this.props.scrollTopMin;
	        }
	        this.props.scrollTopMin = scrollTopMin;
	      }

	      // limit the scrollTop to the feasible scroll range
	      if (this.props.scrollTop > 0) this.props.scrollTop = 0;
	      if (this.props.scrollTop < scrollTopMin) this.props.scrollTop = scrollTopMin;
	      if (this.options.verticalScroll) {
	        this.dom.left.parentNode.scrollTop = -this.props.scrollTop;
	        this.dom.right.parentNode.scrollTop = -this.props.scrollTop;
	      }
	      return this.props.scrollTop;
	    }

	    /**
	     * Get the current scrollTop
	     * @returns {number} scrollTop
	     * @private
	     */
	  }, {
	    key: "_getScrollTop",
	    value: function _getScrollTop() {
	      return this.props.scrollTop;
	    }

	    /**
	     * Load a configurator
	     * [at]returns {Object}
	     * @private
	     */
	  }, {
	    key: "_createConfigurator",
	    value: function _createConfigurator() {
	      throw new Error('Cannot invoke abstract method _createConfigurator');
	    }
	  }]);
	  return Core;
	}(); // turn Core into an event emitter
	Emitter(Core.prototype);

	function _createSuper$9(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$9(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$9() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * A current time bar
	 */
	var CurrentTime = /*#__PURE__*/function (_Component) {
	  _inherits(CurrentTime, _Component);
	  var _super = _createSuper$9(CurrentTime);
	  /**
	   * @param {{range: Range, dom: Object, domProps: Object}} body
	   * @param {Object} [options]        Available parameters:
	   *                                  {Boolean} [showCurrentTime]
	   *                                  {String}  [alignCurrentTime]
	   * @constructor CurrentTime
	   * @extends Component
	   */
	  function CurrentTime(body, options) {
	    var _context;
	    var _this;
	    _classCallCheck(this, CurrentTime);
	    _this = _super.call(this);
	    _this.body = body;

	    // default options
	    _this.defaultOptions = {
	      rtl: false,
	      showCurrentTime: true,
	      alignCurrentTime: undefined,
	      moment: moment$2,
	      locales: locales,
	      locale: 'en'
	    };
	    _this.options = availableUtils.extend({}, _this.defaultOptions);
	    _this.setOptions(options);
	    _this.options.locales = availableUtils.extend({}, locales, _this.options.locales);
	    var defaultLocales = _this.defaultOptions.locales[_this.defaultOptions.locale];
	    _forEachInstanceProperty(_context = _Object$keys(_this.options.locales)).call(_context, function (locale) {
	      _this.options.locales[locale] = availableUtils.extend({}, defaultLocales, _this.options.locales[locale]);
	    });
	    _this.offset = 0;
	    _this._create();
	    return _this;
	  }

	  /**
	   * Create the HTML DOM for the current time bar
	   * @private
	   */
	  _createClass(CurrentTime, [{
	    key: "_create",
	    value: function _create() {
	      var bar = document.createElement('div');
	      bar.className = 'vis-current-time';
	      bar.style.position = 'absolute';
	      bar.style.top = '0px';
	      bar.style.height = '100%';
	      this.bar = bar;
	    }

	    /**
	     * Destroy the CurrentTime bar
	     */
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.options.showCurrentTime = false;
	      this.redraw(); // will remove the bar from the DOM and stop refreshing

	      this.body = null;
	    }

	    /**
	     * Set options for the component. Options will be merged in current options.
	     * @param {Object} options  Available parameters:
	     *                          {boolean} [showCurrentTime]
	     *                          {String}  [alignCurrentTime]
	     */
	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options) {
	        // copy all options that we know
	        availableUtils.selectiveExtend(['rtl', 'showCurrentTime', 'alignCurrentTime', 'moment', 'locale', 'locales'], this.options, options);
	      }
	    }

	    /**
	     * Repaint the component
	     * @return {boolean} Returns true if the component is resized
	     */
	  }, {
	    key: "redraw",
	    value: function redraw() {
	      if (this.options.showCurrentTime) {
	        var _context2, _context3;
	        var parent = this.body.dom.backgroundVertical;
	        if (this.bar.parentNode != parent) {
	          // attach to the dom
	          if (this.bar.parentNode) {
	            this.bar.parentNode.removeChild(this.bar);
	          }
	          parent.appendChild(this.bar);
	          this.start();
	        }
	        var now = this.options.moment(_Date$now() + this.offset);
	        if (this.options.alignCurrentTime) {
	          now = now.startOf(this.options.alignCurrentTime);
	        }
	        var x = this.body.util.toScreen(now);
	        var locale = this.options.locales[this.options.locale];
	        if (!locale) {
	          if (!this.warned) {
	            console.warn("WARNING: options.locales['".concat(this.options.locale, "'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization"));
	            this.warned = true;
	          }
	          locale = this.options.locales['en']; // fall back on english when not available
	        }

	        var title = _concatInstanceProperty(_context2 = _concatInstanceProperty(_context3 = "".concat(locale.current, " ")).call(_context3, locale.time, ": ")).call(_context2, now.format('dddd, MMMM Do YYYY, H:mm:ss'));
	        title = title.charAt(0).toUpperCase() + title.substring(1);
	        if (this.options.rtl) {
	          this.bar.style.transform = "translateX(".concat(x * -1, "px)");
	        } else {
	          this.bar.style.transform = "translateX(".concat(x, "px)");
	        }
	        this.bar.title = title;
	      } else {
	        // remove the line from the DOM
	        if (this.bar.parentNode) {
	          this.bar.parentNode.removeChild(this.bar);
	        }
	        this.stop();
	      }
	      return false;
	    }

	    /**
	     * Start auto refreshing the current time bar
	     */
	  }, {
	    key: "start",
	    value: function start() {
	      var me = this;

	      /**
	       *  Updates the current time.
	       */
	      function update() {
	        me.stop();

	        // determine interval to refresh
	        var scale = me.body.range.conversion(me.body.domProps.center.width).scale;
	        var interval = 1 / scale / 10;
	        if (interval < 30) interval = 30;
	        if (interval > 1000) interval = 1000;
	        me.redraw();
	        me.body.emitter.emit('currentTimeTick');

	        // start a renderTimer to adjust for the new time
	        me.currentTimeTimer = _setTimeout(update, interval);
	      }
	      update();
	    }

	    /**
	     * Stop auto refreshing the current time bar
	     */
	  }, {
	    key: "stop",
	    value: function stop() {
	      if (this.currentTimeTimer !== undefined) {
	        clearTimeout(this.currentTimeTimer);
	        delete this.currentTimeTimer;
	      }
	    }

	    /**
	     * Set a current time. This can be used for example to ensure that a client's
	     * time is synchronized with a shared server time.
	     * @param {Date | string | number} time     A Date, unix timestamp, or
	     *                                          ISO date string.
	     */
	  }, {
	    key: "setCurrentTime",
	    value: function setCurrentTime(time) {
	      var t = availableUtils.convert(time, 'Date').valueOf();
	      var now = _Date$now();
	      this.offset = t - now;
	      this.redraw();
	    }

	    /**
	     * Get the current time.
	     * @return {Date} Returns the current time.
	     */
	  }, {
	    key: "getCurrentTime",
	    value: function getCurrentTime() {
	      return new Date(_Date$now() + this.offset);
	    }
	  }]);
	  return CurrentTime;
	}(Component);

	var findExports = {};
	var find$3 = {
	  get exports(){ return findExports; },
	  set exports(v){ findExports = v; },
	};

	var $$4 = _export;
	var $find = arrayIteration.find;

	var FIND = 'find';
	var SKIPS_HOLES$1 = true;

	// Shouldn't skip holes
	if (FIND in []) Array(1)[FIND](function () { SKIPS_HOLES$1 = false; });

	// `Array.prototype.find` method
	// https://tc39.es/ecma262/#sec-array.prototype.find
	$$4({ target: 'Array', proto: true, forced: SKIPS_HOLES$1 }, {
	  find: function find(callbackfn /* , that = undefined */) {
	    return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$2 = entryVirtual$k;

	var find$2 = entryVirtual$2('Array').find;

	var isPrototypeOf$4 = objectIsPrototypeOf;
	var method$2 = find$2;

	var ArrayPrototype$2 = Array.prototype;

	var find$1 = function (it) {
	  var own = it.find;
	  return it === ArrayPrototype$2 || (isPrototypeOf$4(ArrayPrototype$2, it) && own === ArrayPrototype$2.find) ? method$2 : own;
	};

	var parent$3 = find$1;

	var find = parent$3;

	(function (module) {
		module.exports = find;
	} (find$3));

	var _findInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(findExports);

	var setExports = {};
	var set$2 = {
	  get exports(){ return setExports; },
	  set exports(v){ setExports = v; },
	};

	var internalMetadataExports = {};
	var internalMetadata = {
	  get exports(){ return internalMetadataExports; },
	  set exports(v){ internalMetadataExports = v; },
	};

	// FF26- bug: ArrayBuffers are non-extensible, but Object.isExtensible does not report it
	var fails$3 = fails$u;

	var arrayBufferNonExtensible = fails$3(function () {
	  if (typeof ArrayBuffer == 'function') {
	    var buffer = new ArrayBuffer(8);
	    // eslint-disable-next-line es/no-object-isextensible, es/no-object-defineproperty -- safe
	    if (Object.isExtensible(buffer)) Object.defineProperty(buffer, 'a', { value: 8 });
	  }
	});

	var fails$2 = fails$u;
	var isObject$2 = isObject$g;
	var classof = classofRaw$2;
	var ARRAY_BUFFER_NON_EXTENSIBLE = arrayBufferNonExtensible;

	// eslint-disable-next-line es/no-object-isextensible -- safe
	var $isExtensible = Object.isExtensible;
	var FAILS_ON_PRIMITIVES = fails$2(function () { $isExtensible(1); });

	// `Object.isExtensible` method
	// https://tc39.es/ecma262/#sec-object.isextensible
	var objectIsExtensible = (FAILS_ON_PRIMITIVES || ARRAY_BUFFER_NON_EXTENSIBLE) ? function isExtensible(it) {
	  if (!isObject$2(it)) return false;
	  if (ARRAY_BUFFER_NON_EXTENSIBLE && classof(it) == 'ArrayBuffer') return false;
	  return $isExtensible ? $isExtensible(it) : true;
	} : $isExtensible;

	var fails$1 = fails$u;

	var freezing = !fails$1(function () {
	  // eslint-disable-next-line es/no-object-isextensible, es/no-object-preventextensions -- required for testing
	  return Object.isExtensible(Object.preventExtensions({}));
	});

	var $$3 = _export;
	var uncurryThis = functionUncurryThis;
	var hiddenKeys = hiddenKeys$6;
	var isObject$1 = isObject$g;
	var hasOwn = hasOwnProperty_1;
	var defineProperty$1 = objectDefineProperty.f;
	var getOwnPropertyNamesModule = objectGetOwnPropertyNames;
	var getOwnPropertyNamesExternalModule = objectGetOwnPropertyNamesExternal;
	var isExtensible = objectIsExtensible;
	var uid = uid$4;
	var FREEZING = freezing;

	var REQUIRED = false;
	var METADATA = uid('meta');
	var id = 0;

	var setMetadata = function (it) {
	  defineProperty$1(it, METADATA, { value: {
	    objectID: 'O' + id++, // object ID
	    weakData: {}          // weak collections IDs
	  } });
	};

	var fastKey$1 = function (it, create) {
	  // return a primitive with prefix
	  if (!isObject$1(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
	  if (!hasOwn(it, METADATA)) {
	    // can't set metadata to uncaught frozen object
	    if (!isExtensible(it)) return 'F';
	    // not necessary to add metadata
	    if (!create) return 'E';
	    // add missing metadata
	    setMetadata(it);
	  // return object ID
	  } return it[METADATA].objectID;
	};

	var getWeakData = function (it, create) {
	  if (!hasOwn(it, METADATA)) {
	    // can't set metadata to uncaught frozen object
	    if (!isExtensible(it)) return true;
	    // not necessary to add metadata
	    if (!create) return false;
	    // add missing metadata
	    setMetadata(it);
	  // return the store of weak collections IDs
	  } return it[METADATA].weakData;
	};

	// add metadata on freeze-family methods calling
	var onFreeze = function (it) {
	  if (FREEZING && REQUIRED && isExtensible(it) && !hasOwn(it, METADATA)) setMetadata(it);
	  return it;
	};

	var enable = function () {
	  meta.enable = function () { /* empty */ };
	  REQUIRED = true;
	  var getOwnPropertyNames = getOwnPropertyNamesModule.f;
	  var splice = uncurryThis([].splice);
	  var test = {};
	  test[METADATA] = 1;

	  // prevent exposing of metadata key
	  if (getOwnPropertyNames(test).length) {
	    getOwnPropertyNamesModule.f = function (it) {
	      var result = getOwnPropertyNames(it);
	      for (var i = 0, length = result.length; i < length; i++) {
	        if (result[i] === METADATA) {
	          splice(result, i, 1);
	          break;
	        }
	      } return result;
	    };

	    $$3({ target: 'Object', stat: true, forced: true }, {
	      getOwnPropertyNames: getOwnPropertyNamesExternalModule.f
	    });
	  }
	};

	var meta = internalMetadata.exports = {
	  enable: enable,
	  fastKey: fastKey$1,
	  getWeakData: getWeakData,
	  onFreeze: onFreeze
	};

	hiddenKeys[METADATA] = true;

	var bind$1 = functionBindContext;
	var call = functionCall;
	var anObject = anObject$b;
	var tryToString = tryToString$6;
	var isArrayIteratorMethod = isArrayIteratorMethod$2;
	var lengthOfArrayLike = lengthOfArrayLike$b;
	var isPrototypeOf$3 = objectIsPrototypeOf;
	var getIterator = getIterator$2;
	var getIteratorMethod = getIteratorMethod$9;
	var iteratorClose = iteratorClose$2;

	var $TypeError$1 = TypeError;

	var Result = function (stopped, result) {
	  this.stopped = stopped;
	  this.result = result;
	};

	var ResultPrototype = Result.prototype;

	var iterate$2 = function (iterable, unboundFunction, options) {
	  var that = options && options.that;
	  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
	  var IS_RECORD = !!(options && options.IS_RECORD);
	  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
	  var INTERRUPTED = !!(options && options.INTERRUPTED);
	  var fn = bind$1(unboundFunction, that);
	  var iterator, iterFn, index, length, result, next, step;

	  var stop = function (condition) {
	    if (iterator) iteratorClose(iterator, 'normal', condition);
	    return new Result(true, condition);
	  };

	  var callFn = function (value) {
	    if (AS_ENTRIES) {
	      anObject(value);
	      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
	    } return INTERRUPTED ? fn(value, stop) : fn(value);
	  };

	  if (IS_RECORD) {
	    iterator = iterable.iterator;
	  } else if (IS_ITERATOR) {
	    iterator = iterable;
	  } else {
	    iterFn = getIteratorMethod(iterable);
	    if (!iterFn) throw $TypeError$1(tryToString(iterable) + ' is not iterable');
	    // optimisation for array iterators
	    if (isArrayIteratorMethod(iterFn)) {
	      for (index = 0, length = lengthOfArrayLike(iterable); length > index; index++) {
	        result = callFn(iterable[index]);
	        if (result && isPrototypeOf$3(ResultPrototype, result)) return result;
	      } return new Result(false);
	    }
	    iterator = getIterator(iterable, iterFn);
	  }

	  next = IS_RECORD ? iterable.next : iterator.next;
	  while (!(step = call(next, iterator)).done) {
	    try {
	      result = callFn(step.value);
	    } catch (error) {
	      iteratorClose(iterator, 'throw', error);
	    }
	    if (typeof result == 'object' && result && isPrototypeOf$3(ResultPrototype, result)) return result;
	  } return new Result(false);
	};

	var isPrototypeOf$2 = objectIsPrototypeOf;

	var $TypeError = TypeError;

	var anInstance$2 = function (it, Prototype) {
	  if (isPrototypeOf$2(Prototype, it)) return it;
	  throw $TypeError('Incorrect invocation');
	};

	var $$2 = _export;
	var global$1 = global$j;
	var InternalMetadataModule = internalMetadataExports;
	var fails = fails$u;
	var createNonEnumerableProperty = createNonEnumerableProperty$6;
	var iterate$1 = iterate$2;
	var anInstance$1 = anInstance$2;
	var isCallable = isCallable$i;
	var isObject = isObject$g;
	var setToStringTag = setToStringTag$6;
	var defineProperty = objectDefineProperty.f;
	var forEach = arrayIteration.forEach;
	var DESCRIPTORS$2 = descriptors;
	var InternalStateModule$1 = internalState;

	var setInternalState$1 = InternalStateModule$1.set;
	var internalStateGetterFor$1 = InternalStateModule$1.getterFor;

	var collection$1 = function (CONSTRUCTOR_NAME, wrapper, common) {
	  var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
	  var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
	  var ADDER = IS_MAP ? 'set' : 'add';
	  var NativeConstructor = global$1[CONSTRUCTOR_NAME];
	  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
	  var exported = {};
	  var Constructor;

	  if (!DESCRIPTORS$2 || !isCallable(NativeConstructor)
	    || !(IS_WEAK || NativePrototype.forEach && !fails(function () { new NativeConstructor().entries().next(); }))
	  ) {
	    // create collection constructor
	    Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
	    InternalMetadataModule.enable();
	  } else {
	    Constructor = wrapper(function (target, iterable) {
	      setInternalState$1(anInstance$1(target, Prototype), {
	        type: CONSTRUCTOR_NAME,
	        collection: new NativeConstructor()
	      });
	      if (iterable != undefined) iterate$1(iterable, target[ADDER], { that: target, AS_ENTRIES: IS_MAP });
	    });

	    var Prototype = Constructor.prototype;

	    var getInternalState = internalStateGetterFor$1(CONSTRUCTOR_NAME);

	    forEach(['add', 'clear', 'delete', 'forEach', 'get', 'has', 'set', 'keys', 'values', 'entries'], function (KEY) {
	      var IS_ADDER = KEY == 'add' || KEY == 'set';
	      if (KEY in NativePrototype && !(IS_WEAK && KEY == 'clear')) {
	        createNonEnumerableProperty(Prototype, KEY, function (a, b) {
	          var collection = getInternalState(this).collection;
	          if (!IS_ADDER && IS_WEAK && !isObject(a)) return KEY == 'get' ? undefined : false;
	          var result = collection[KEY](a === 0 ? 0 : a, b);
	          return IS_ADDER ? this : result;
	        });
	      }
	    });

	    IS_WEAK || defineProperty(Prototype, 'size', {
	      configurable: true,
	      get: function () {
	        return getInternalState(this).collection.size;
	      }
	    });
	  }

	  setToStringTag(Constructor, CONSTRUCTOR_NAME, false, true);

	  exported[CONSTRUCTOR_NAME] = Constructor;
	  $$2({ global: true, forced: true }, exported);

	  if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);

	  return Constructor;
	};

	var defineBuiltIn = defineBuiltIn$5;

	var defineBuiltIns$1 = function (target, src, options) {
	  for (var key in src) {
	    if (options && options.unsafe && target[key]) target[key] = src[key];
	    else defineBuiltIn(target, key, src[key], options);
	  } return target;
	};

	var getBuiltIn = getBuiltIn$c;
	var defineBuiltInAccessor$1 = defineBuiltInAccessor$3;
	var wellKnownSymbol = wellKnownSymbol$l;
	var DESCRIPTORS$1 = descriptors;

	var SPECIES = wellKnownSymbol('species');

	var setSpecies$1 = function (CONSTRUCTOR_NAME) {
	  var Constructor = getBuiltIn(CONSTRUCTOR_NAME);

	  if (DESCRIPTORS$1 && Constructor && !Constructor[SPECIES]) {
	    defineBuiltInAccessor$1(Constructor, SPECIES, {
	      configurable: true,
	      get: function () { return this; }
	    });
	  }
	};

	var create = objectCreate;
	var defineBuiltInAccessor = defineBuiltInAccessor$3;
	var defineBuiltIns = defineBuiltIns$1;
	var bind = functionBindContext;
	var anInstance = anInstance$2;
	var isNullOrUndefined = isNullOrUndefined$4;
	var iterate = iterate$2;
	var defineIterator = iteratorDefine;
	var createIterResultObject = createIterResultObject$3;
	var setSpecies = setSpecies$1;
	var DESCRIPTORS = descriptors;
	var fastKey = internalMetadataExports.fastKey;
	var InternalStateModule = internalState;

	var setInternalState = InternalStateModule.set;
	var internalStateGetterFor = InternalStateModule.getterFor;

	var collectionStrong$1 = {
	  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
	    var Constructor = wrapper(function (that, iterable) {
	      anInstance(that, Prototype);
	      setInternalState(that, {
	        type: CONSTRUCTOR_NAME,
	        index: create(null),
	        first: undefined,
	        last: undefined,
	        size: 0
	      });
	      if (!DESCRIPTORS) that.size = 0;
	      if (!isNullOrUndefined(iterable)) iterate(iterable, that[ADDER], { that: that, AS_ENTRIES: IS_MAP });
	    });

	    var Prototype = Constructor.prototype;

	    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);

	    var define = function (that, key, value) {
	      var state = getInternalState(that);
	      var entry = getEntry(that, key);
	      var previous, index;
	      // change existing entry
	      if (entry) {
	        entry.value = value;
	      // create new entry
	      } else {
	        state.last = entry = {
	          index: index = fastKey(key, true),
	          key: key,
	          value: value,
	          previous: previous = state.last,
	          next: undefined,
	          removed: false
	        };
	        if (!state.first) state.first = entry;
	        if (previous) previous.next = entry;
	        if (DESCRIPTORS) state.size++;
	        else that.size++;
	        // add to index
	        if (index !== 'F') state.index[index] = entry;
	      } return that;
	    };

	    var getEntry = function (that, key) {
	      var state = getInternalState(that);
	      // fast case
	      var index = fastKey(key);
	      var entry;
	      if (index !== 'F') return state.index[index];
	      // frozen object case
	      for (entry = state.first; entry; entry = entry.next) {
	        if (entry.key == key) return entry;
	      }
	    };

	    defineBuiltIns(Prototype, {
	      // `{ Map, Set }.prototype.clear()` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.clear
	      // https://tc39.es/ecma262/#sec-set.prototype.clear
	      clear: function clear() {
	        var that = this;
	        var state = getInternalState(that);
	        var data = state.index;
	        var entry = state.first;
	        while (entry) {
	          entry.removed = true;
	          if (entry.previous) entry.previous = entry.previous.next = undefined;
	          delete data[entry.index];
	          entry = entry.next;
	        }
	        state.first = state.last = undefined;
	        if (DESCRIPTORS) state.size = 0;
	        else that.size = 0;
	      },
	      // `{ Map, Set }.prototype.delete(key)` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.delete
	      // https://tc39.es/ecma262/#sec-set.prototype.delete
	      'delete': function (key) {
	        var that = this;
	        var state = getInternalState(that);
	        var entry = getEntry(that, key);
	        if (entry) {
	          var next = entry.next;
	          var prev = entry.previous;
	          delete state.index[entry.index];
	          entry.removed = true;
	          if (prev) prev.next = next;
	          if (next) next.previous = prev;
	          if (state.first == entry) state.first = next;
	          if (state.last == entry) state.last = prev;
	          if (DESCRIPTORS) state.size--;
	          else that.size--;
	        } return !!entry;
	      },
	      // `{ Map, Set }.prototype.forEach(callbackfn, thisArg = undefined)` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.foreach
	      // https://tc39.es/ecma262/#sec-set.prototype.foreach
	      forEach: function forEach(callbackfn /* , that = undefined */) {
	        var state = getInternalState(this);
	        var boundFunction = bind(callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	        var entry;
	        while (entry = entry ? entry.next : state.first) {
	          boundFunction(entry.value, entry.key, this);
	          // revert to the last existing entry
	          while (entry && entry.removed) entry = entry.previous;
	        }
	      },
	      // `{ Map, Set}.prototype.has(key)` methods
	      // https://tc39.es/ecma262/#sec-map.prototype.has
	      // https://tc39.es/ecma262/#sec-set.prototype.has
	      has: function has(key) {
	        return !!getEntry(this, key);
	      }
	    });

	    defineBuiltIns(Prototype, IS_MAP ? {
	      // `Map.prototype.get(key)` method
	      // https://tc39.es/ecma262/#sec-map.prototype.get
	      get: function get(key) {
	        var entry = getEntry(this, key);
	        return entry && entry.value;
	      },
	      // `Map.prototype.set(key, value)` method
	      // https://tc39.es/ecma262/#sec-map.prototype.set
	      set: function set(key, value) {
	        return define(this, key === 0 ? 0 : key, value);
	      }
	    } : {
	      // `Set.prototype.add(value)` method
	      // https://tc39.es/ecma262/#sec-set.prototype.add
	      add: function add(value) {
	        return define(this, value = value === 0 ? 0 : value, value);
	      }
	    });
	    if (DESCRIPTORS) defineBuiltInAccessor(Prototype, 'size', {
	      configurable: true,
	      get: function () {
	        return getInternalState(this).size;
	      }
	    });
	    return Constructor;
	  },
	  setStrong: function (Constructor, CONSTRUCTOR_NAME, IS_MAP) {
	    var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
	    var getInternalCollectionState = internalStateGetterFor(CONSTRUCTOR_NAME);
	    var getInternalIteratorState = internalStateGetterFor(ITERATOR_NAME);
	    // `{ Map, Set }.prototype.{ keys, values, entries, @@iterator }()` methods
	    // https://tc39.es/ecma262/#sec-map.prototype.entries
	    // https://tc39.es/ecma262/#sec-map.prototype.keys
	    // https://tc39.es/ecma262/#sec-map.prototype.values
	    // https://tc39.es/ecma262/#sec-map.prototype-@@iterator
	    // https://tc39.es/ecma262/#sec-set.prototype.entries
	    // https://tc39.es/ecma262/#sec-set.prototype.keys
	    // https://tc39.es/ecma262/#sec-set.prototype.values
	    // https://tc39.es/ecma262/#sec-set.prototype-@@iterator
	    defineIterator(Constructor, CONSTRUCTOR_NAME, function (iterated, kind) {
	      setInternalState(this, {
	        type: ITERATOR_NAME,
	        target: iterated,
	        state: getInternalCollectionState(iterated),
	        kind: kind,
	        last: undefined
	      });
	    }, function () {
	      var state = getInternalIteratorState(this);
	      var kind = state.kind;
	      var entry = state.last;
	      // revert to the last existing entry
	      while (entry && entry.removed) entry = entry.previous;
	      // get next entry
	      if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
	        // or finish the iteration
	        state.target = undefined;
	        return createIterResultObject(undefined, true);
	      }
	      // return step by kind
	      if (kind == 'keys') return createIterResultObject(entry.key, false);
	      if (kind == 'values') return createIterResultObject(entry.value, false);
	      return createIterResultObject([entry.key, entry.value], false);
	    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);

	    // `{ Map, Set }.prototype[@@species]` accessors
	    // https://tc39.es/ecma262/#sec-get-map-@@species
	    // https://tc39.es/ecma262/#sec-get-set-@@species
	    setSpecies(CONSTRUCTOR_NAME);
	  }
	};

	var collection = collection$1;
	var collectionStrong = collectionStrong$1;

	// `Set` constructor
	// https://tc39.es/ecma262/#sec-set-objects
	collection('Set', function (init) {
	  return function Set() { return init(this, arguments.length ? arguments[0] : undefined); };
	}, collectionStrong);

	var path = path$r;

	var set$1 = path.Set;

	var parent$2 = set$1;


	var set = parent$2;

	(function (module) {
		module.exports = set;
	} (set$2));

	var _Set = /*@__PURE__*/getDefaultExportFromCjs(setExports);

	var findIndexExports = {};
	var findIndex$3 = {
	  get exports(){ return findIndexExports; },
	  set exports(v){ findIndexExports = v; },
	};

	var $$1 = _export;
	var $findIndex = arrayIteration.findIndex;

	var FIND_INDEX = 'findIndex';
	var SKIPS_HOLES = true;

	// Shouldn't skip holes
	if (FIND_INDEX in []) Array(1)[FIND_INDEX](function () { SKIPS_HOLES = false; });

	// `Array.prototype.findIndex` method
	// https://tc39.es/ecma262/#sec-array.prototype.findindex
	$$1({ target: 'Array', proto: true, forced: SKIPS_HOLES }, {
	  findIndex: function findIndex(callbackfn /* , that = undefined */) {
	    return $findIndex(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual$1 = entryVirtual$k;

	var findIndex$2 = entryVirtual$1('Array').findIndex;

	var isPrototypeOf$1 = objectIsPrototypeOf;
	var method$1 = findIndex$2;

	var ArrayPrototype$1 = Array.prototype;

	var findIndex$1 = function (it) {
	  var own = it.findIndex;
	  return it === ArrayPrototype$1 || (isPrototypeOf$1(ArrayPrototype$1, it) && own === ArrayPrototype$1.findIndex) ? method$1 : own;
	};

	var parent$1 = findIndex$1;

	var findIndex = parent$1;

	(function (module) {
		module.exports = findIndex;
	} (findIndex$3));

	var _findIndexInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(findIndexExports);

	function _createForOfIteratorHelper$5(o, allowArrayLike) { var it = typeof _Symbol !== "undefined" && _getIteratorMethod(o) || o["@@iterator"]; if (!it) { if (_Array$isArray$1(o) || (it = _unsupportedIterableToArray$5(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
	function _unsupportedIterableToArray$5(o, minLen) { var _context5; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$5(o, minLen); var n = _sliceInstanceProperty(_context5 = Object.prototype.toString.call(o)).call(_context5, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return _Array$from$1(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$5(o, minLen); }
	function _arrayLikeToArray$5(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
	// Utility functions for ordering and stacking of items
	var EPSILON = 0.001; // used when checking collisions, to prevent round-off errors

	/**
	 * Order items by their start data
	 * @param {Item[]} items
	 */
	function orderByStart(items) {
	  _sortInstanceProperty(items).call(items, function (a, b) {
	    return a.data.start - b.data.start;
	  });
	}

	/**
	 * Order items by their end date. If they have no end date, their start date
	 * is used.
	 * @param {Item[]} items
	 */
	function orderByEnd(items) {
	  _sortInstanceProperty(items).call(items, function (a, b) {
	    var aTime = 'end' in a.data ? a.data.end : a.data.start;
	    var bTime = 'end' in b.data ? b.data.end : b.data.start;
	    return aTime - bTime;
	  });
	}

	/**
	 * Adjust vertical positions of the items such that they don't overlap each
	 * other.
	 * @param {Item[]} items
	 *            All visible items
	 * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
	 *            Margins between items and between items and the axis.
	 * @param {boolean} [force=false]
	 *            If true, all items will be repositioned. If false (default), only
	 *            items having a top===null will be re-stacked
	 * @param {function} shouldBailItemsRedrawFunction
	 *            bailing function
	 * @return {boolean} shouldBail
	 */
	function stack(items, margin, force, shouldBailItemsRedrawFunction) {
	  var stackingResult = performStacking(items, margin.item, false, function (item) {
	    return item.stack && (force || item.top === null);
	  }, function (item) {
	    return item.stack;
	  }, function (item) {
	    return margin.axis;
	  }, shouldBailItemsRedrawFunction);

	  // If shouldBail function returned true during stacking calculation
	  return stackingResult === null;
	}

	/**
	 * Adjust vertical positions of the items within a single subgroup such that they
	 * don't overlap each other.
	 * @param {Item[]} items
	 *            All items withina subgroup
	 * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
	 *            Margins between items and between items and the axis.
	 * @param {subgroup} subgroup
	 *            The subgroup that is being stacked
	 */
	function substack(items, margin, subgroup) {
	  var subgroupHeight = performStacking(items, margin.item, false, function (item) {
	    return item.stack;
	  }, function (item) {
	    return true;
	  }, function (item) {
	    return item.baseTop;
	  });
	  subgroup.height = subgroupHeight - subgroup.top + 0.5 * margin.item.vertical;
	}

	/**
	 * Adjust vertical positions of the items without stacking them
	 * @param {Item[]} items
	 *            All visible items
	 * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
	 *            Margins between items and between items and the axis.
	 * @param {subgroups[]} subgroups
	 *            All subgroups
	 * @param {boolean} isStackSubgroups
	 */
	function nostack(items, margin, subgroups, isStackSubgroups) {
	  for (var _i = 0; _i < items.length; _i++) {
	    if (items[_i].data.subgroup == undefined) {
	      items[_i].top = margin.item.vertical;
	    } else if (items[_i].data.subgroup !== undefined && isStackSubgroups) {
	      var newTop = 0;
	      for (var subgroup in subgroups) {
	        if (subgroups.hasOwnProperty(subgroup)) {
	          if (subgroups[subgroup].visible == true && subgroups[subgroup].index < subgroups[items[_i].data.subgroup].index) {
	            newTop += subgroups[subgroup].height;
	            subgroups[items[_i].data.subgroup].top = newTop;
	          }
	        }
	      }
	      items[_i].top = newTop + 0.5 * margin.item.vertical;
	    }
	  }
	  if (!isStackSubgroups) {
	    stackSubgroups(items, margin, subgroups);
	  }
	}

	/**
	 * Adjust vertical positions of the subgroups such that they don't overlap each
	 * other.
	 * @param {Array.<timeline.Item>} items
	 * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin Margins between items and between items and the axis.
	 * @param {subgroups[]} subgroups
	 *            All subgroups
	 */
	function stackSubgroups(items, margin, subgroups) {
	  var _context;
	  performStacking(_sortInstanceProperty(_context = _Object$values2(subgroups)).call(_context, function (a, b) {
	    if (a.index > b.index) return 1;
	    if (a.index < b.index) return -1;
	    return 0;
	  }), {
	    vertical: 0
	  }, true, function (item) {
	    return true;
	  }, function (item) {
	    return true;
	  }, function (item) {
	    return 0;
	  });
	  for (var _i2 = 0; _i2 < items.length; _i2++) {
	    if (items[_i2].data.subgroup !== undefined) {
	      items[_i2].top = subgroups[items[_i2].data.subgroup].top + 0.5 * margin.item.vertical;
	    }
	  }
	}

	/**
	 * Adjust vertical positions of the subgroups such that they don't overlap each
	 * other, then stacks the contents of each subgroup individually.
	 * @param {Item[]} subgroupItems
	 *            All the items in a subgroup
	 * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
	 *            Margins between items and between items and the axis.
	 * @param {subgroups[]} subgroups
	 *            All subgroups
	 */
	function stackSubgroupsWithInnerStack(subgroupItems, margin, subgroups) {
	  var doSubStack = false;

	  // Run subgroups in their order (if any)
	  var subgroupOrder = [];
	  for (var subgroup in subgroups) {
	    if (subgroups[subgroup].hasOwnProperty("index")) {
	      subgroupOrder[subgroups[subgroup].index] = subgroup;
	    } else {
	      subgroupOrder.push(subgroup);
	    }
	  }
	  for (var j = 0; j < subgroupOrder.length; j++) {
	    subgroup = subgroupOrder[j];
	    if (subgroups.hasOwnProperty(subgroup)) {
	      doSubStack = doSubStack || subgroups[subgroup].stack;
	      subgroups[subgroup].top = 0;
	      for (var otherSubgroup in subgroups) {
	        if (subgroups[otherSubgroup].visible && subgroups[subgroup].index > subgroups[otherSubgroup].index) {
	          subgroups[subgroup].top += subgroups[otherSubgroup].height;
	        }
	      }
	      var items = subgroupItems[subgroup];
	      for (var _i3 = 0; _i3 < items.length; _i3++) {
	        if (items[_i3].data.subgroup !== undefined) {
	          items[_i3].top = subgroups[items[_i3].data.subgroup].top + 0.5 * margin.item.vertical;
	          if (subgroups[subgroup].stack) {
	            items[_i3].baseTop = items[_i3].top;
	          }
	        }
	      }
	      if (doSubStack && subgroups[subgroup].stack) {
	        substack(subgroupItems[subgroup], margin, subgroups[subgroup]);
	      }
	    }
	  }
	}

	/**
	 * Reusable stacking function
	 * 
	 * @param {Item[]} items 
	 * An array of items to consider during stacking.
	 * @param {{horizontal: number, vertical: number}} margins
	 * Margins to be used for collision checking and placement of items.
	 * @param {boolean} compareTimes
	 * By default, horizontal collision is checked based on the spatial position of the items (left/right and width).
	 * If this argument is true, horizontal collision will instead be checked based on the start/end times of each item.
	 * Vertical collision is always checked spatially.
	 * @param {(Item) => number | null} shouldStack
	 * A callback function which is called before we start to process an item. The return value indicates whether the item will be processed.
	 * @param {(Item) => boolean} shouldOthersStack
	 * A callback function which indicates whether other items should consider this item when being stacked.
	 * @param {(Item) => number} getInitialHeight
	 * A callback function which determines the height items are initially placed at
	 * @param {() => boolean} shouldBail 
	 * A callback function which should indicate if the stacking process should be aborted.
	 * 
	 * @returns {null|number}
	 * if shouldBail was triggered, returns null
	 * otherwise, returns the maximum height
	 */
	function performStacking(items, margins, compareTimes, shouldStack, shouldOthersStack, getInitialHeight, shouldBail) {
	  // Time-based horizontal comparison
	  var getItemStart = function getItemStart(item) {
	    return item.start;
	  };
	  var getItemEnd = function getItemEnd(item) {
	    return item.end;
	  };
	  if (!compareTimes) {
	    // Spatial horizontal comparisons
	    var rtl = !!(items[0] && items[0].options.rtl);
	    if (rtl) {
	      getItemStart = function getItemStart(item) {
	        return item.right;
	      };
	    } else {
	      getItemStart = function getItemStart(item) {
	        return item.left;
	      };
	    }
	    getItemEnd = function getItemEnd(item) {
	      return getItemStart(item) + item.width + margins.horizontal;
	    };
	  }
	  var itemsToPosition = [];
	  var itemsAlreadyPositioned = []; // It's vital that this array is kept sorted based on the start of each item

	  // If the order we needed to place items was based purely on the start of each item, we could calculate stacking very efficiently.
	  // Unfortunately for us, this is not guaranteed. But the order is often based on the start of items at least to some degree, and
	  // we can use this to make some optimisations. While items are proceeding in order of start, we can keep moving our search indexes
	  // forwards. Then if we encounter an item that's out of order, we reset our indexes and search from the beginning of the array again.
	  var previousStart = null;
	  var insertionIndex = 0;

	  // First let's handle any immoveable items
	  var _iterator = _createForOfIteratorHelper$5(items),
	    _step;
	  try {
	    var _loop2 = function _loop2() {
	      var item = _step.value;
	      if (shouldStack(item)) {
	        itemsToPosition.push(item);
	      } else {
	        if (shouldOthersStack(item)) {
	          var itemStart = getItemStart(item);

	          // We need to put immoveable items into itemsAlreadyPositioned and ensure that this array is sorted.
	          // We could simply insert them, and then use JavaScript's sort function to sort them afterwards.
	          // This would achieve an average complexity of O(n log n).
	          // 
	          // Instead, I'm gambling that the start of each item will usually be the same or later than the
	          // start of the previous item. While this holds (best case), we can insert items in O(n).
	          // In the worst case (where each item starts before the previous item) this grows to O(n^2).
	          // 
	          // I am making the assumption that for most datasets, the "order" function will have relatively low cardinality,
	          // and therefore this tradeoff should be easily worth it.
	          if (previousStart !== null && itemStart < previousStart - EPSILON) {
	            insertionIndex = 0;
	          }
	          previousStart = itemStart;
	          insertionIndex = findIndexFrom(itemsAlreadyPositioned, function (i) {
	            return getItemStart(i) - EPSILON > itemStart;
	          }, insertionIndex);
	          _spliceInstanceProperty(itemsAlreadyPositioned).call(itemsAlreadyPositioned, insertionIndex, 0, item);
	          insertionIndex++;
	        }
	      }
	    };
	    for (_iterator.s(); !(_step = _iterator.n()).done;) {
	      _loop2();
	    }

	    // Now we can loop through each item (in order) and find a position for them
	  } catch (err) {
	    _iterator.e(err);
	  } finally {
	    _iterator.f();
	  }
	  previousStart = null;
	  var previousEnd = null;
	  insertionIndex = 0;
	  var horizontalOverlapStartIndex = 0;
	  var horizontalOverlapEndIndex = 0;
	  var maxHeight = 0;
	  var _loop = function _loop() {
	    var _context2, _context3;
	    var item = itemsToPosition.shift();
	    item.top = getInitialHeight(item);
	    var itemStart = getItemStart(item);
	    var itemEnd = getItemEnd(item);
	    if (previousStart !== null && itemStart < previousStart - EPSILON) {
	      horizontalOverlapStartIndex = 0;
	      horizontalOverlapEndIndex = 0;
	      insertionIndex = 0;
	      previousEnd = null;
	    }
	    previousStart = itemStart;

	    // Take advantage of the sorted itemsAlreadyPositioned array to narrow down the search
	    horizontalOverlapStartIndex = findIndexFrom(itemsAlreadyPositioned, function (i) {
	      return itemStart < getItemEnd(i) - EPSILON;
	    }, horizontalOverlapStartIndex);
	    // Since items aren't sorted by end time, it might increase or decrease from one item to the next. In order to keep an efficient search area, we will seek forwards/backwards accordingly.
	    if (previousEnd === null || previousEnd < itemEnd - EPSILON) {
	      horizontalOverlapEndIndex = findIndexFrom(itemsAlreadyPositioned, function (i) {
	        return itemEnd < getItemStart(i) - EPSILON;
	      }, Math.max(horizontalOverlapStartIndex, horizontalOverlapEndIndex));
	    }
	    if (previousEnd !== null && previousEnd - EPSILON > itemEnd) {
	      horizontalOverlapEndIndex = findLastIndexBetween(itemsAlreadyPositioned, function (i) {
	        return itemEnd + EPSILON >= getItemStart(i);
	      }, horizontalOverlapStartIndex, horizontalOVerlapEndIndex) + 1;
	    }

	    // Sort by vertical position so we don't have to reconsider past items if we move an item
	    var horizontallyCollidingItems = _sortInstanceProperty(_context2 = _filterInstanceProperty(_context3 = _sliceInstanceProperty(itemsAlreadyPositioned).call(itemsAlreadyPositioned, horizontalOverlapStartIndex, horizontalOverlapEndIndex)).call(_context3, function (i) {
	      return itemStart < getItemEnd(i) - EPSILON && itemEnd - EPSILON > getItemStart(i);
	    })).call(_context2, function (a, b) {
	      return a.top - b.top;
	    });

	    // Keep moving the item down until it stops colliding with any other items
	    for (var i2 = 0; i2 < horizontallyCollidingItems.length; i2++) {
	      var otherItem = horizontallyCollidingItems[i2];
	      if (checkVerticalSpatialCollision(item, otherItem, margins)) {
	        item.top = otherItem.top + otherItem.height + margins.vertical;
	      }
	    }
	    if (shouldOthersStack(item)) {
	      // Insert the item into itemsAlreadyPositioned, ensuring itemsAlreadyPositioned remains sorted.
	      // In the best case, we can insert an item in constant time O(1). In the worst case, we insert an item in linear time O(n).
	      // In both cases, this is better than doing a naive insert and then sort, which would cost on average O(n log n).
	      insertionIndex = findIndexFrom(itemsAlreadyPositioned, function (i) {
	        return getItemStart(i) - EPSILON > itemStart;
	      }, insertionIndex);
	      _spliceInstanceProperty(itemsAlreadyPositioned).call(itemsAlreadyPositioned, insertionIndex, 0, item);
	      insertionIndex++;
	    }

	    // Keep track of the tallest item we've seen before
	    var currentHeight = item.top + item.height;
	    if (currentHeight > maxHeight) {
	      maxHeight = currentHeight;
	    }
	    if (shouldBail && shouldBail()) {
	      return {
	        v: null
	      };
	    }
	  };
	  while (itemsToPosition.length > 0) {
	    var _ret = _loop();
	    if (_typeof(_ret) === "object") return _ret.v;
	  }
	  return maxHeight;
	}

	/**
	 * Test if the two provided items collide
	 * The items must have parameters left, width, top, and height.
	 * @param {Item} a          The first item
	 * @param {Item} b          The second item
	 * @param {{vertical: number}} margin
	 *                          An object containing a horizontal and vertical
	 *                          minimum required margin.
	 * @return {boolean}        true if a and b collide, else false
	 */
	function checkVerticalSpatialCollision(a, b, margin) {
	  return a.top - margin.vertical + EPSILON < b.top + b.height && a.top + a.height + margin.vertical - EPSILON > b.top;
	}

	/**
	 * Find index of first item to meet predicate after a certain index.
	 * If no such item is found, returns the length of the array.
	 * 
	 * @param {any[]} arr The array
	 * @param {(item) => boolean} predicate A function that should return true when a suitable item is found
	 * @param {number|undefined} startIndex The index to start search from (inclusive). Optional, if not provided will search from the beginning of the array.
	 * 
	 * @return {number}
	 */
	function findIndexFrom(arr, predicate, startIndex) {
	  var _context4;
	  if (!startIndex) {
	    startIndex = 0;
	  }
	  var matchIndex = _findIndexInstanceProperty(_context4 = _sliceInstanceProperty(arr).call(arr, startIndex)).call(_context4, predicate);
	  if (matchIndex === -1) {
	    return arr.length;
	  }
	  return matchIndex + startIndex;
	}

	/**
	 * Find index of last item to meet predicate within a given range.
	 * If no such item is found, returns the index prior to the start of the range.
	 * 
	 * @param {any[]} arr The array
	 * @param {(item) => boolean} predicate A function that should return true when a suitable item is found
	 * @param {number|undefined} startIndex The earliest index to search to (inclusive). Optional, if not provided will continue until the start of the array.
	 * @param {number|undefined} endIndex The end of the search range (exclusive). The search will begin on the index prior to this value. Optional, defaults to the end of array.
	 * 
	 * @return {number}
	 */
	function findLastIndexBetween(arr, predicate, startIndex, endIndex) {
	  if (!startIndex) {
	    startIndex = 0;
	  }
	  if (!endIndex) {
	    endIndex = arr.length;
	  }
	  for (i = endIndex - 1; i >= startIndex; i--) {
	    if (predicate(arr[i])) {
	      return i;
	    }
	  }
	  return startIndex - 1;
	}

	var stack$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		nostack: nostack,
		orderByEnd: orderByEnd,
		orderByStart: orderByStart,
		stack: stack,
		stackSubgroups: stackSubgroups,
		stackSubgroupsWithInnerStack: stackSubgroupsWithInnerStack,
		substack: substack
	});

	var UNGROUPED$3 = '__ungrouped__'; // reserved group id for ungrouped items
	var BACKGROUND$2 = '__background__'; // reserved group id for background items without group

	var ReservedGroupIds$1 = {
	  UNGROUPED: UNGROUPED$3,
	  BACKGROUND: BACKGROUND$2
	};

	/**
	 * @constructor Group
	 */
	var Group = /*#__PURE__*/function () {
	  /**
	  * @param {number | string} groupId
	  * @param {Object} data
	  * @param {ItemSet} itemSet
	  * @constructor Group
	  */
	  function Group(groupId, data, itemSet) {
	    var _this = this;
	    _classCallCheck(this, Group);
	    this.groupId = groupId;
	    this.subgroups = {};
	    this.subgroupStack = {};
	    this.subgroupStackAll = false;
	    this.subgroupVisibility = {};
	    this.doInnerStack = false;
	    this.shouldBailStackItems = false;
	    this.subgroupIndex = 0;
	    this.subgroupOrderer = data && data.subgroupOrder;
	    this.itemSet = itemSet;
	    this.isVisible = null;
	    this.stackDirty = true; // if true, items will be restacked on next redraw

	    // This is a stack of functions (`() => void`) that will be executed before
	    // the instance is disposed off (method `dispose`). Anything that needs to
	    // be manually disposed off before garbage collection happens (or so that
	    // garbage collection can happen) should be added to this stack.
	    this._disposeCallbacks = [];
	    if (data && data.nestedGroups) {
	      this.nestedGroups = data.nestedGroups;
	      if (data.showNested == false) {
	        this.showNested = false;
	      } else {
	        this.showNested = true;
	      }
	    }
	    if (data && data.subgroupStack) {
	      if (typeof data.subgroupStack === "boolean") {
	        this.doInnerStack = data.subgroupStack;
	        this.subgroupStackAll = data.subgroupStack;
	      } else {
	        // We might be doing stacking on specific sub groups, but only
	        // if at least one is set to do stacking
	        for (var key in data.subgroupStack) {
	          this.subgroupStack[key] = data.subgroupStack[key];
	          this.doInnerStack = this.doInnerStack || data.subgroupStack[key];
	        }
	      }
	    }
	    if (data && data.heightMode) {
	      this.heightMode = data.heightMode;
	    } else {
	      this.heightMode = itemSet.options.groupHeightMode;
	    }
	    this.nestedInGroup = null;
	    this.dom = {};
	    this.props = {
	      label: {
	        width: 0,
	        height: 0
	      }
	    };
	    this.className = null;
	    this.items = {}; // items filtered by groupId of this group
	    this.visibleItems = []; // items currently visible in window
	    this.itemsInRange = []; // items currently in range
	    this.orderedItems = {
	      byStart: [],
	      byEnd: []
	    };
	    this.checkRangedItems = false; // needed to refresh the ranged items if the window is programatically changed with NO overlap.

	    var handleCheckRangedItems = function handleCheckRangedItems() {
	      _this.checkRangedItems = true;
	    };
	    this.itemSet.body.emitter.on("checkRangedItems", handleCheckRangedItems);
	    this._disposeCallbacks.push(function () {
	      _this.itemSet.body.emitter.off("checkRangedItems", handleCheckRangedItems);
	    });
	    this._create();
	    this.setData(data);
	  }

	  /**
	   * Create DOM elements for the group
	   * @private
	   */
	  _createClass(Group, [{
	    key: "_create",
	    value: function _create() {
	      var label = document.createElement('div');
	      if (this.itemSet.options.groupEditable.order) {
	        label.className = 'vis-label draggable';
	      } else {
	        label.className = 'vis-label';
	      }
	      this.dom.label = label;
	      var inner = document.createElement('div');
	      inner.className = 'vis-inner';
	      label.appendChild(inner);
	      this.dom.inner = inner;
	      var foreground = document.createElement('div');
	      foreground.className = 'vis-group';
	      foreground['vis-group'] = this;
	      this.dom.foreground = foreground;
	      this.dom.background = document.createElement('div');
	      this.dom.background.className = 'vis-group';
	      this.dom.axis = document.createElement('div');
	      this.dom.axis.className = 'vis-group';

	      // create a hidden marker to detect when the Timelines container is attached
	      // to the DOM, or the style of a parent of the Timeline is changed from
	      // display:none is changed to visible.
	      this.dom.marker = document.createElement('div');
	      this.dom.marker.style.visibility = 'hidden';
	      this.dom.marker.style.position = 'absolute';
	      this.dom.marker.innerHTML = '';
	      this.dom.background.appendChild(this.dom.marker);
	    }

	    /**
	     * Set the group data for this group
	     * @param {Object} data   Group data, can contain properties content and className
	     */
	  }, {
	    key: "setData",
	    value: function setData(data) {
	      if (this.itemSet.groupTouchParams.isDragging) return;

	      // update contents
	      var content;
	      var templateFunction;
	      if (data && data.subgroupVisibility) {
	        for (var key in data.subgroupVisibility) {
	          this.subgroupVisibility[key] = data.subgroupVisibility[key];
	        }
	      }
	      if (this.itemSet.options && this.itemSet.options.groupTemplate) {
	        var _context;
	        templateFunction = _bindInstanceProperty(_context = this.itemSet.options.groupTemplate).call(_context, this);
	        content = templateFunction(data, this.dom.inner);
	      } else {
	        content = data && data.content;
	      }
	      if (content instanceof Element) {
	        while (this.dom.inner.firstChild) {
	          this.dom.inner.removeChild(this.dom.inner.firstChild);
	        }
	        this.dom.inner.appendChild(content);
	      } else if (content instanceof Object && content.isReactComponent) ; else if (content instanceof Object) {
	        templateFunction(data, this.dom.inner);
	      } else if (content !== undefined && content !== null) {
	        this.dom.inner.innerHTML = availableUtils.xss(content);
	      } else {
	        this.dom.inner.innerHTML = availableUtils.xss(this.groupId || ''); // groupId can be null
	      }

	      // update title
	      this.dom.label.title = data && data.title || '';
	      if (!this.dom.inner.firstChild) {
	        availableUtils.addClassName(this.dom.inner, 'vis-hidden');
	      } else {
	        availableUtils.removeClassName(this.dom.inner, 'vis-hidden');
	      }
	      if (data && data.nestedGroups) {
	        if (!this.nestedGroups || this.nestedGroups != data.nestedGroups) {
	          this.nestedGroups = data.nestedGroups;
	        }
	        if (data.showNested !== undefined || this.showNested === undefined) {
	          if (data.showNested == false) {
	            this.showNested = false;
	          } else {
	            this.showNested = true;
	          }
	        }
	        availableUtils.addClassName(this.dom.label, 'vis-nesting-group');
	        if (this.showNested) {
	          availableUtils.removeClassName(this.dom.label, 'collapsed');
	          availableUtils.addClassName(this.dom.label, 'expanded');
	        } else {
	          availableUtils.removeClassName(this.dom.label, 'expanded');
	          availableUtils.addClassName(this.dom.label, 'collapsed');
	        }
	      } else if (this.nestedGroups) {
	        this.nestedGroups = null;
	        availableUtils.removeClassName(this.dom.label, 'collapsed');
	        availableUtils.removeClassName(this.dom.label, 'expanded');
	        availableUtils.removeClassName(this.dom.label, 'vis-nesting-group');
	      }
	      if (data && (data.treeLevel || data.nestedInGroup)) {
	        availableUtils.addClassName(this.dom.label, 'vis-nested-group');
	        if (data.treeLevel) {
	          availableUtils.addClassName(this.dom.label, 'vis-group-level-' + data.treeLevel);
	        } else {
	          // Nesting level is unknown, but we're sure it's at least 1
	          availableUtils.addClassName(this.dom.label, 'vis-group-level-unknown-but-gte1');
	        }
	      } else {
	        availableUtils.addClassName(this.dom.label, 'vis-group-level-0');
	      }

	      // update className
	      var className = data && data.className || null;
	      if (className != this.className) {
	        if (this.className) {
	          availableUtils.removeClassName(this.dom.label, this.className);
	          availableUtils.removeClassName(this.dom.foreground, this.className);
	          availableUtils.removeClassName(this.dom.background, this.className);
	          availableUtils.removeClassName(this.dom.axis, this.className);
	        }
	        availableUtils.addClassName(this.dom.label, className);
	        availableUtils.addClassName(this.dom.foreground, className);
	        availableUtils.addClassName(this.dom.background, className);
	        availableUtils.addClassName(this.dom.axis, className);
	        this.className = className;
	      }

	      // update style
	      if (this.style) {
	        availableUtils.removeCssText(this.dom.label, this.style);
	        this.style = null;
	      }
	      if (data && data.style) {
	        availableUtils.addCssText(this.dom.label, data.style);
	        this.style = data.style;
	      }
	    }

	    /**
	     * Get the width of the group label
	     * @return {number} width
	     */
	  }, {
	    key: "getLabelWidth",
	    value: function getLabelWidth() {
	      return this.props.label.width;
	    }

	    /**
	     * check if group has had an initial height hange
	     * @returns {boolean} 
	     */
	  }, {
	    key: "_didMarkerHeightChange",
	    value: function _didMarkerHeightChange() {
	      var markerHeight = this.dom.marker.clientHeight;
	      if (markerHeight != this.lastMarkerHeight) {
	        this.lastMarkerHeight = markerHeight;
	        var redrawQueue = {};
	        var redrawQueueLength = 0;
	        _forEachInstanceProperty(availableUtils).call(availableUtils, this.items, function (item, key) {
	          item.dirty = true;
	          if (item.displayed) {
	            var returnQueue = true;
	            redrawQueue[key] = item.redraw(returnQueue);
	            redrawQueueLength = redrawQueue[key].length;
	          }
	        });
	        var needRedraw = redrawQueueLength > 0;
	        if (needRedraw) {
	          var _loop = function _loop(i) {
	            _forEachInstanceProperty(availableUtils).call(availableUtils, redrawQueue, function (fns) {
	              fns[i]();
	            });
	          };
	          // redraw all regular items
	          for (var i = 0; i < redrawQueueLength; i++) {
	            _loop(i);
	          }
	        }
	        return true;
	      } else {
	        return false;
	      }
	    }

	    /**
	     * calculate group dimentions and position
	     * @param {number} pixels
	     */
	  }, {
	    key: "_calculateGroupSizeAndPosition",
	    value: function _calculateGroupSizeAndPosition() {
	      var _this$dom$foreground = this.dom.foreground,
	        offsetTop = _this$dom$foreground.offsetTop,
	        offsetLeft = _this$dom$foreground.offsetLeft,
	        offsetWidth = _this$dom$foreground.offsetWidth;
	      this.top = offsetTop;
	      this.right = offsetLeft;
	      this.width = offsetWidth;
	    }

	    /**
	     * checks if should bail redraw of items
	     * @returns {boolean} should bail 
	     */
	  }, {
	    key: "_shouldBailItemsRedraw",
	    value: function _shouldBailItemsRedraw() {
	      var me = this;
	      var timeoutOptions = this.itemSet.options.onTimeout;
	      var bailOptions = {
	        relativeBailingTime: this.itemSet.itemsSettingTime,
	        bailTimeMs: timeoutOptions && timeoutOptions.timeoutMs,
	        userBailFunction: timeoutOptions && timeoutOptions.callback,
	        shouldBailStackItems: this.shouldBailStackItems
	      };
	      var bail = null;
	      if (!this.itemSet.initialDrawDone) {
	        if (bailOptions.shouldBailStackItems) {
	          return true;
	        }
	        if (Math.abs(_Date$now() - new Date(bailOptions.relativeBailingTime)) > bailOptions.bailTimeMs) {
	          if (bailOptions.userBailFunction && this.itemSet.userContinueNotBail == null) {
	            bailOptions.userBailFunction(function (didUserContinue) {
	              me.itemSet.userContinueNotBail = didUserContinue;
	              bail = !didUserContinue;
	            });
	          } else if (me.itemSet.userContinueNotBail == false) {
	            bail = true;
	          } else {
	            bail = false;
	          }
	        }
	      }
	      return bail;
	    }

	    /**
	     * redraws items
	     * @param {boolean} forceRestack
	     * @param {boolean} lastIsVisible
	     * @param {number} margin
	     * @param {object} range
	     * @private
	     */
	  }, {
	    key: "_redrawItems",
	    value: function _redrawItems(forceRestack, lastIsVisible, margin, range) {
	      var _this2 = this;
	      var restack = forceRestack || this.stackDirty || this.isVisible && !lastIsVisible;

	      // if restacking, reposition visible items vertically
	      if (restack) {
	        var _context2, _context3, _context4, _context5, _context6, _context7;
	        var orderedItems = {
	          byEnd: _filterInstanceProperty(_context2 = this.orderedItems.byEnd).call(_context2, function (item) {
	            return !item.isCluster;
	          }),
	          byStart: _filterInstanceProperty(_context3 = this.orderedItems.byStart).call(_context3, function (item) {
	            return !item.isCluster;
	          })
	        };
	        var orderedClusters = {
	          byEnd: _toConsumableArray(new _Set(_filterInstanceProperty(_context4 = _mapInstanceProperty(_context5 = this.orderedItems.byEnd).call(_context5, function (item) {
	            return item.cluster;
	          })).call(_context4, function (item) {
	            return !!item;
	          }))),
	          byStart: _toConsumableArray(new _Set(_filterInstanceProperty(_context6 = _mapInstanceProperty(_context7 = this.orderedItems.byStart).call(_context7, function (item) {
	            return item.cluster;
	          })).call(_context6, function (item) {
	            return !!item;
	          })))
	        };

	        /**
	        * Get all visible items in range
	        * @return {array} items
	        */
	        var getVisibleItems = function getVisibleItems() {
	          var _context8, _context9, _context10;
	          var visibleItems = _this2._updateItemsInRange(orderedItems, _filterInstanceProperty(_context8 = _this2.visibleItems).call(_context8, function (item) {
	            return !item.isCluster;
	          }), range);
	          var visibleClusters = _this2._updateClustersInRange(orderedClusters, _filterInstanceProperty(_context9 = _this2.visibleItems).call(_context9, function (item) {
	            return item.isCluster;
	          }), range);
	          return _concatInstanceProperty(_context10 = []).call(_context10, _toConsumableArray(visibleItems), _toConsumableArray(visibleClusters));
	        };

	        /**
	         * Get visible items grouped by subgroup
	         * @param {function} orderFn An optional function to order items inside the subgroups
	         * @return {Object}
	         */
	        var getVisibleItemsGroupedBySubgroup = function getVisibleItemsGroupedBySubgroup(orderFn) {
	          var visibleSubgroupsItems = {};
	          var _loop2 = function _loop2(subgroup) {
	            var _context11;
	            var items = _filterInstanceProperty(_context11 = _this2.visibleItems).call(_context11, function (item) {
	              return item.data.subgroup === subgroup;
	            });
	            visibleSubgroupsItems[subgroup] = orderFn ? _sortInstanceProperty(items).call(items, function (a, b) {
	              return orderFn(a.data, b.data);
	            }) : items;
	          };
	          for (var subgroup in _this2.subgroups) {
	            _loop2(subgroup);
	          }
	          return visibleSubgroupsItems;
	        };
	        if (typeof this.itemSet.options.order === 'function') {
	          // a custom order function
	          //show all items
	          var me = this;
	          if (this.doInnerStack && this.itemSet.options.stackSubgroups) {
	            // Order the items within each subgroup
	            var visibleSubgroupsItems = getVisibleItemsGroupedBySubgroup(this.itemSet.options.order);
	            stackSubgroupsWithInnerStack(visibleSubgroupsItems, margin, this.subgroups);
	            this.visibleItems = getVisibleItems();
	            this._updateSubGroupHeights(margin);
	          } else {
	            var _context12, _context13, _context14, _context15;
	            this.visibleItems = getVisibleItems();
	            this._updateSubGroupHeights(margin);
	            // order all items and force a restacking
	            // order all items outside clusters and force a restacking
	            var customOrderedItems = _sortInstanceProperty(_context12 = _filterInstanceProperty(_context13 = _sliceInstanceProperty(_context14 = this.visibleItems).call(_context14)).call(_context13, function (item) {
	              return item.isCluster || !item.isCluster && !item.cluster;
	            })).call(_context12, function (a, b) {
	              return me.itemSet.options.order(a.data, b.data);
	            });
	            this.shouldBailStackItems = stack(customOrderedItems, margin, true, _bindInstanceProperty(_context15 = this._shouldBailItemsRedraw).call(_context15, this));
	          }
	        } else {
	          // no custom order function, lazy stacking
	          this.visibleItems = getVisibleItems();
	          this._updateSubGroupHeights(margin);
	          if (this.itemSet.options.stack) {
	            if (this.doInnerStack && this.itemSet.options.stackSubgroups) {
	              var _visibleSubgroupsItems = getVisibleItemsGroupedBySubgroup();
	              stackSubgroupsWithInnerStack(_visibleSubgroupsItems, margin, this.subgroups);
	            } else {
	              var _context16;
	              // TODO: ugly way to access options...
	              this.shouldBailStackItems = stack(this.visibleItems, margin, true, _bindInstanceProperty(_context16 = this._shouldBailItemsRedraw).call(_context16, this));
	            }
	          } else {
	            // no stacking
	            nostack(this.visibleItems, margin, this.subgroups, this.itemSet.options.stackSubgroups);
	          }
	        }
	        for (var i = 0; i < this.visibleItems.length; i++) {
	          this.visibleItems[i].repositionX();
	          if (this.subgroupVisibility[this.visibleItems[i].data.subgroup] !== undefined) {
	            if (!this.subgroupVisibility[this.visibleItems[i].data.subgroup]) {
	              this.visibleItems[i].hide();
	            }
	          }
	        }
	        if (this.itemSet.options.cluster) {
	          _forEachInstanceProperty(availableUtils).call(availableUtils, this.items, function (item) {
	            if (item.cluster && item.displayed) {
	              item.hide();
	            }
	          });
	        }
	        if (this.shouldBailStackItems) {
	          this.itemSet.body.emitter.emit('destroyTimeline');
	        }
	        this.stackDirty = false;
	      }
	    }

	    /**
	     * check if group resized
	     * @param {boolean} resized
	     * @param {number} height
	     * @return {boolean} did resize
	     */
	  }, {
	    key: "_didResize",
	    value: function _didResize(resized, height) {
	      resized = availableUtils.updateProperty(this, 'height', height) || resized;
	      // recalculate size of label
	      var labelWidth = this.dom.inner.clientWidth;
	      var labelHeight = this.dom.inner.clientHeight;
	      resized = availableUtils.updateProperty(this.props.label, 'width', labelWidth) || resized;
	      resized = availableUtils.updateProperty(this.props.label, 'height', labelHeight) || resized;
	      return resized;
	    }

	    /**
	     * apply group height
	     * @param {number} height
	     */
	  }, {
	    key: "_applyGroupHeight",
	    value: function _applyGroupHeight(height) {
	      this.dom.background.style.height = "".concat(height, "px");
	      this.dom.foreground.style.height = "".concat(height, "px");
	      this.dom.label.style.height = "".concat(height, "px");
	    }

	    /**
	     * update vertical position of items after they are re-stacked and the height of the group is calculated
	     * @param {number} margin
	     */
	  }, {
	    key: "_updateItemsVerticalPosition",
	    value: function _updateItemsVerticalPosition(margin) {
	      for (var i = 0, ii = this.visibleItems.length; i < ii; i++) {
	        var item = this.visibleItems[i];
	        item.repositionY(margin);
	        if (!this.isVisible && this.groupId != ReservedGroupIds$1.BACKGROUND) {
	          if (item.displayed) item.hide();
	        }
	      }
	    }

	    /**
	     * Repaint this group
	     * @param {{start: number, end: number}} range
	     * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
	     * @param {boolean} [forceRestack=false]  Force restacking of all items
	     * @param {boolean} [returnQueue=false]  return the queue or if the group resized
	     * @return {boolean} Returns true if the group is resized or the redraw queue if returnQueue=true
	     */
	  }, {
	    key: "redraw",
	    value: function redraw(range, margin, forceRestack, returnQueue) {
	      var _this3 = this,
	        _context17,
	        _context18,
	        _context21,
	        _context23,
	        _context27;
	      var resized = false;
	      var lastIsVisible = this.isVisible;
	      var height;
	      var queue = [function () {
	        forceRestack = _this3._didMarkerHeightChange.call(_this3) || forceRestack;
	      },
	      // recalculate the height of the subgroups
	      _bindInstanceProperty(_context17 = this._updateSubGroupHeights).call(_context17, this, margin),
	      // calculate actual size and position
	      _bindInstanceProperty(_context18 = this._calculateGroupSizeAndPosition).call(_context18, this), function () {
	        var _context19;
	        _this3.isVisible = _bindInstanceProperty(_context19 = _this3._isGroupVisible).call(_context19, _this3)(range, margin);
	      }, function () {
	        var _context20;
	        _bindInstanceProperty(_context20 = _this3._redrawItems).call(_context20, _this3)(forceRestack, lastIsVisible, margin, range);
	      },
	      // update subgroups
	      _bindInstanceProperty(_context21 = this._updateSubgroupsSizes).call(_context21, this), function () {
	        var _context22;
	        height = _bindInstanceProperty(_context22 = _this3._calculateHeight).call(_context22, _this3)(margin);
	      },
	      // calculate actual size and position again
	      _bindInstanceProperty(_context23 = this._calculateGroupSizeAndPosition).call(_context23, this), function () {
	        var _context24;
	        resized = _bindInstanceProperty(_context24 = _this3._didResize).call(_context24, _this3)(resized, height);
	      }, function () {
	        var _context25;
	        _bindInstanceProperty(_context25 = _this3._applyGroupHeight).call(_context25, _this3)(height);
	      }, function () {
	        var _context26;
	        _bindInstanceProperty(_context26 = _this3._updateItemsVerticalPosition).call(_context26, _this3)(margin);
	      }, _bindInstanceProperty(_context27 = function _context27() {
	        if (!_this3.isVisible && _this3.height) {
	          resized = false;
	        }
	        return resized;
	      }).call(_context27, this)];
	      if (returnQueue) {
	        return queue;
	      } else {
	        var result;
	        _forEachInstanceProperty(queue).call(queue, function (fn) {
	          result = fn();
	        });
	        return result;
	      }
	    }

	    /**
	     * recalculate the height of the subgroups
	     *
	     * @param {{item: timeline.Item}} margin
	     * @private
	     */
	  }, {
	    key: "_updateSubGroupHeights",
	    value: function _updateSubGroupHeights(margin) {
	      var _this4 = this;
	      if (_Object$keys(this.subgroups).length > 0) {
	        var me = this;
	        this._resetSubgroups();
	        _forEachInstanceProperty(availableUtils).call(availableUtils, this.visibleItems, function (item) {
	          if (item.data.subgroup !== undefined) {
	            me.subgroups[item.data.subgroup].height = Math.max(me.subgroups[item.data.subgroup].height, item.height + margin.item.vertical);
	            me.subgroups[item.data.subgroup].visible = typeof _this4.subgroupVisibility[item.data.subgroup] === 'undefined' ? true : Boolean(_this4.subgroupVisibility[item.data.subgroup]);
	          }
	        });
	      }
	    }

	    /**
	     * check if group is visible
	     *
	     * @param {timeline.Range} range
	     * @param {{axis: timeline.DataAxis}} margin
	     * @returns {boolean} is visible
	     * @private
	     */
	  }, {
	    key: "_isGroupVisible",
	    value: function _isGroupVisible(range, margin) {
	      return this.top <= range.body.domProps.centerContainer.height - range.body.domProps.scrollTop + margin.axis && this.top + this.height + margin.axis >= -range.body.domProps.scrollTop;
	    }

	    /**
	     * recalculate the height of the group
	     * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
	     * @returns {number} Returns the height
	     * @private
	     */
	  }, {
	    key: "_calculateHeight",
	    value: function _calculateHeight(margin) {
	      // recalculate the height of the group
	      var height;
	      var items;
	      if (this.heightMode === 'fixed') {
	        items = availableUtils.toArray(this.items);
	      } else {
	        // default or 'auto'
	        items = this.visibleItems;
	      }
	      if (items.length > 0) {
	        var min = items[0].top;
	        var max = items[0].top + items[0].height;
	        _forEachInstanceProperty(availableUtils).call(availableUtils, items, function (item) {
	          min = Math.min(min, item.top);
	          max = Math.max(max, item.top + item.height);
	        });
	        if (min > margin.axis) {
	          // there is an empty gap between the lowest item and the axis
	          var offset = min - margin.axis;
	          max -= offset;
	          _forEachInstanceProperty(availableUtils).call(availableUtils, items, function (item) {
	            item.top -= offset;
	          });
	        }
	        height = Math.ceil(max + margin.item.vertical / 2);
	        if (this.heightMode !== "fitItems") {
	          height = Math.max(height, this.props.label.height);
	        }
	      } else {
	        height = this.props.label.height;
	      }
	      return height;
	    }

	    /**
	     * Show this group: attach to the DOM
	     */
	  }, {
	    key: "show",
	    value: function show() {
	      if (!this.dom.label.parentNode) {
	        this.itemSet.dom.labelSet.appendChild(this.dom.label);
	      }
	      if (!this.dom.foreground.parentNode) {
	        this.itemSet.dom.foreground.appendChild(this.dom.foreground);
	      }
	      if (!this.dom.background.parentNode) {
	        this.itemSet.dom.background.appendChild(this.dom.background);
	      }
	      if (!this.dom.axis.parentNode) {
	        this.itemSet.dom.axis.appendChild(this.dom.axis);
	      }
	    }

	    /**
	     * Hide this group: remove from the DOM
	     */
	  }, {
	    key: "hide",
	    value: function hide() {
	      var label = this.dom.label;
	      if (label.parentNode) {
	        label.parentNode.removeChild(label);
	      }
	      var foreground = this.dom.foreground;
	      if (foreground.parentNode) {
	        foreground.parentNode.removeChild(foreground);
	      }
	      var background = this.dom.background;
	      if (background.parentNode) {
	        background.parentNode.removeChild(background);
	      }
	      var axis = this.dom.axis;
	      if (axis.parentNode) {
	        axis.parentNode.removeChild(axis);
	      }
	    }

	    /**
	     * Add an item to the group
	     * @param {Item} item
	     */
	  }, {
	    key: "add",
	    value: function add(item) {
	      var _context28;
	      this.items[item.id] = item;
	      item.setParent(this);
	      this.stackDirty = true;
	      // add to
	      if (item.data.subgroup !== undefined) {
	        this._addToSubgroup(item);
	        this.orderSubgroups();
	      }
	      if (!_includesInstanceProperty(_context28 = this.visibleItems).call(_context28, item)) {
	        var range = this.itemSet.body.range; // TODO: not nice accessing the range like this
	        this._checkIfVisible(item, this.visibleItems, range);
	      }
	    }

	    /**
	     * add item to subgroup
	     * @param {object} item
	     * @param {string} subgroupId
	     */
	  }, {
	    key: "_addToSubgroup",
	    value: function _addToSubgroup(item) {
	      var subgroupId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : item.data.subgroup;
	      if (subgroupId != undefined && this.subgroups[subgroupId] === undefined) {
	        this.subgroups[subgroupId] = {
	          height: 0,
	          top: 0,
	          start: item.data.start,
	          end: item.data.end || item.data.start,
	          visible: false,
	          index: this.subgroupIndex,
	          items: [],
	          stack: this.subgroupStackAll || this.subgroupStack[subgroupId] || false
	        };
	        this.subgroupIndex++;
	      }
	      if (new Date(item.data.start) < new Date(this.subgroups[subgroupId].start)) {
	        this.subgroups[subgroupId].start = item.data.start;
	      }
	      var itemEnd = item.data.end || item.data.start;
	      if (new Date(itemEnd) > new Date(this.subgroups[subgroupId].end)) {
	        this.subgroups[subgroupId].end = itemEnd;
	      }
	      this.subgroups[subgroupId].items.push(item);
	    }

	    /**
	     * update subgroup sizes
	     */
	  }, {
	    key: "_updateSubgroupsSizes",
	    value: function _updateSubgroupsSizes() {
	      var me = this;
	      if (me.subgroups) {
	        var _loop3 = function _loop3() {
	          var _context29;
	          var initialEnd = me.subgroups[subgroup].items[0].data.end || me.subgroups[subgroup].items[0].data.start;
	          var newStart = me.subgroups[subgroup].items[0].data.start;
	          var newEnd = initialEnd - 1;
	          _forEachInstanceProperty(_context29 = me.subgroups[subgroup].items).call(_context29, function (item) {
	            if (new Date(item.data.start) < new Date(newStart)) {
	              newStart = item.data.start;
	            }
	            var itemEnd = item.data.end || item.data.start;
	            if (new Date(itemEnd) > new Date(newEnd)) {
	              newEnd = itemEnd;
	            }
	          });
	          me.subgroups[subgroup].start = newStart;
	          me.subgroups[subgroup].end = new Date(newEnd - 1); // -1 to compensate for colliding end to start subgroups;
	        };
	        for (var subgroup in me.subgroups) {
	          _loop3();
	        }
	      }
	    }

	    /**
	     * order subgroups
	     */
	  }, {
	    key: "orderSubgroups",
	    value: function orderSubgroups() {
	      if (this.subgroupOrderer !== undefined) {
	        var sortArray = [];
	        if (typeof this.subgroupOrderer == 'string') {
	          for (var subgroup in this.subgroups) {
	            sortArray.push({
	              subgroup: subgroup,
	              sortField: this.subgroups[subgroup].items[0].data[this.subgroupOrderer]
	            });
	          }
	          _sortInstanceProperty(sortArray).call(sortArray, function (a, b) {
	            return a.sortField - b.sortField;
	          });
	        } else if (typeof this.subgroupOrderer == 'function') {
	          for (var _subgroup in this.subgroups) {
	            sortArray.push(this.subgroups[_subgroup].items[0].data);
	          }
	          _sortInstanceProperty(sortArray).call(sortArray, this.subgroupOrderer);
	        }
	        if (sortArray.length > 0) {
	          for (var i = 0; i < sortArray.length; i++) {
	            this.subgroups[sortArray[i].subgroup].index = i;
	          }
	        }
	      }
	    }

	    /**
	     * add item to subgroup
	     */
	  }, {
	    key: "_resetSubgroups",
	    value: function _resetSubgroups() {
	      for (var subgroup in this.subgroups) {
	        if (this.subgroups.hasOwnProperty(subgroup)) {
	          this.subgroups[subgroup].visible = false;
	          this.subgroups[subgroup].height = 0;
	        }
	      }
	    }

	    /**
	     * Remove an item from the group
	     * @param {Item} item
	     */
	  }, {
	    key: "remove",
	    value: function remove(item) {
	      var _context30, _context31;
	      delete this.items[item.id];
	      item.setParent(null);
	      this.stackDirty = true;

	      // remove from visible items
	      var index = _indexOfInstanceProperty(_context30 = this.visibleItems).call(_context30, item);
	      if (index != -1) _spliceInstanceProperty(_context31 = this.visibleItems).call(_context31, index, 1);
	      if (item.data.subgroup !== undefined) {
	        this._removeFromSubgroup(item);
	        this.orderSubgroups();
	      }
	    }

	    /**
	     * remove item from subgroup
	     * @param {object} item
	     * @param {string} subgroupId
	     */
	  }, {
	    key: "_removeFromSubgroup",
	    value: function _removeFromSubgroup(item) {
	      var subgroupId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : item.data.subgroup;
	      if (subgroupId != undefined) {
	        var subgroup = this.subgroups[subgroupId];
	        if (subgroup) {
	          var _context32;
	          var itemIndex = _indexOfInstanceProperty(_context32 = subgroup.items).call(_context32, item);
	          //  Check the item is actually in this subgroup. How should items not in the group be handled?
	          if (itemIndex >= 0) {
	            var _context33;
	            _spliceInstanceProperty(_context33 = subgroup.items).call(_context33, itemIndex, 1);
	            if (!subgroup.items.length) {
	              delete this.subgroups[subgroupId];
	            } else {
	              this._updateSubgroupsSizes();
	            }
	          }
	        }
	      }
	    }

	    /**
	     * Remove an item from the corresponding DataSet
	     * @param {Item} item
	     */
	  }, {
	    key: "removeFromDataSet",
	    value: function removeFromDataSet(item) {
	      this.itemSet.removeItem(item.id);
	    }

	    /**
	     * Reorder the items
	     */
	  }, {
	    key: "order",
	    value: function order() {
	      var array = availableUtils.toArray(this.items);
	      var startArray = [];
	      var endArray = [];
	      for (var i = 0; i < array.length; i++) {
	        if (array[i].data.end !== undefined) {
	          endArray.push(array[i]);
	        }
	        startArray.push(array[i]);
	      }
	      this.orderedItems = {
	        byStart: startArray,
	        byEnd: endArray
	      };
	      orderByStart(this.orderedItems.byStart);
	      orderByEnd(this.orderedItems.byEnd);
	    }

	    /**
	     * Update the visible items
	     * @param {{byStart: Item[], byEnd: Item[]}} orderedItems   All items ordered by start date and by end date
	     * @param {Item[]} oldVisibleItems                          The previously visible items.
	     * @param {{start: number, end: number}} range              Visible range
	     * @return {Item[]} visibleItems                            The new visible items.
	     * @private
	     */
	  }, {
	    key: "_updateItemsInRange",
	    value: function _updateItemsInRange(orderedItems, oldVisibleItems, range) {
	      var visibleItems = [];
	      var visibleItemsLookup = {}; // we keep this to quickly look up if an item already exists in the list without using indexOf on visibleItems

	      if (!this.isVisible && this.groupId != ReservedGroupIds$1.BACKGROUND) {
	        for (var i = 0; i < oldVisibleItems.length; i++) {
	          var item = oldVisibleItems[i];
	          if (item.displayed) item.hide();
	        }
	        return visibleItems;
	      }
	      var interval = (range.end - range.start) / 4;
	      var lowerBound = range.start - interval;
	      var upperBound = range.end + interval;

	      // this function is used to do the binary search for items having start date only.
	      var startSearchFunction = function startSearchFunction(value) {
	        if (value < lowerBound) {
	          return -1;
	        } else if (value <= upperBound) {
	          return 0;
	        } else {
	          return 1;
	        }
	      };

	      // this function is used to do the binary search for items having start and end dates (range).
	      var endSearchFunction = function endSearchFunction(data) {
	        var start = data.start,
	          end = data.end;
	        if (end < lowerBound) {
	          return -1;
	        } else if (start <= upperBound) {
	          return 0;
	        } else {
	          return 1;
	        }
	      };

	      // first check if the items that were in view previously are still in view.
	      // IMPORTANT: this handles the case for the items with startdate before the window and enddate after the window!
	      // also cleans up invisible items.
	      if (oldVisibleItems.length > 0) {
	        for (var _i = 0; _i < oldVisibleItems.length; _i++) {
	          this._checkIfVisibleWithReference(oldVisibleItems[_i], visibleItems, visibleItemsLookup, range);
	        }
	      }

	      // we do a binary search for the items that have only start values.
	      var initialPosByStart = availableUtils.binarySearchCustom(orderedItems.byStart, startSearchFunction, 'data', 'start');

	      // trace the visible items from the inital start pos both ways until an invisible item is found, we only look at the start values.
	      this._traceVisible(initialPosByStart, orderedItems.byStart, visibleItems, visibleItemsLookup, function (item) {
	        return item.data.start < lowerBound || item.data.start > upperBound;
	      });

	      // if the window has changed programmatically without overlapping the old window, the ranged items with start < lowerBound and end > upperbound are not shown.
	      // We therefore have to brute force check all items in the byEnd list
	      if (this.checkRangedItems == true) {
	        this.checkRangedItems = false;
	        for (var _i2 = 0; _i2 < orderedItems.byEnd.length; _i2++) {
	          this._checkIfVisibleWithReference(orderedItems.byEnd[_i2], visibleItems, visibleItemsLookup, range);
	        }
	      } else {
	        // we do a binary search for the items that have defined end times.
	        var initialPosByEnd = availableUtils.binarySearchCustom(orderedItems.byEnd, endSearchFunction, 'data');

	        // trace the visible items from the inital start pos both ways until an invisible item is found, we only look at the end values.
	        this._traceVisible(initialPosByEnd, orderedItems.byEnd, visibleItems, visibleItemsLookup, function (item) {
	          return item.data.end < lowerBound || item.data.start > upperBound;
	        });
	      }
	      var redrawQueue = {};
	      var redrawQueueLength = 0;
	      for (var _i3 = 0; _i3 < visibleItems.length; _i3++) {
	        var _item = visibleItems[_i3];
	        if (!_item.displayed) {
	          var returnQueue = true;
	          redrawQueue[_i3] = _item.redraw(returnQueue);
	          redrawQueueLength = redrawQueue[_i3].length;
	        }
	      }
	      var needRedraw = redrawQueueLength > 0;
	      if (needRedraw) {
	        var _loop4 = function _loop4(j) {
	          _forEachInstanceProperty(availableUtils).call(availableUtils, redrawQueue, function (fns) {
	            fns[j]();
	          });
	        };
	        // redraw all regular items
	        for (var j = 0; j < redrawQueueLength; j++) {
	          _loop4(j);
	        }
	      }
	      for (var _i4 = 0; _i4 < visibleItems.length; _i4++) {
	        visibleItems[_i4].repositionX();
	      }
	      return visibleItems;
	    }

	    /**
	     * trace visible items in group
	     * @param {number} initialPos
	     * @param {array} items
	     * @param {aray} visibleItems
	     * @param {object} visibleItemsLookup
	     * @param {function} breakCondition
	     */
	  }, {
	    key: "_traceVisible",
	    value: function _traceVisible(initialPos, items, visibleItems, visibleItemsLookup, breakCondition) {
	      if (initialPos != -1) {
	        for (var i = initialPos; i >= 0; i--) {
	          var item = items[i];
	          if (breakCondition(item)) {
	            break;
	          } else {
	            if (!(item.isCluster && !item.hasItems()) && !item.cluster) {
	              if (visibleItemsLookup[item.id] === undefined) {
	                visibleItemsLookup[item.id] = true;
	                visibleItems.push(item);
	              }
	            }
	          }
	        }
	        for (var _i5 = initialPos + 1; _i5 < items.length; _i5++) {
	          var _item2 = items[_i5];
	          if (breakCondition(_item2)) {
	            break;
	          } else {
	            if (!(_item2.isCluster && !_item2.hasItems()) && !_item2.cluster) {
	              if (visibleItemsLookup[_item2.id] === undefined) {
	                visibleItemsLookup[_item2.id] = true;
	                visibleItems.push(_item2);
	              }
	            }
	          }
	        }
	      }
	    }

	    /**
	     * this function is very similar to the _checkIfInvisible() but it does not
	     * return booleans, hides the item if it should not be seen and always adds to
	     * the visibleItems.
	     * this one is for brute forcing and hiding.
	     *
	     * @param {Item} item
	     * @param {Array} visibleItems
	     * @param {{start:number, end:number}} range
	     * @private
	     */
	  }, {
	    key: "_checkIfVisible",
	    value: function _checkIfVisible(item, visibleItems, range) {
	      if (item.isVisible(range)) {
	        if (!item.displayed) item.show();
	        // reposition item horizontally
	        item.repositionX();
	        visibleItems.push(item);
	      } else {
	        if (item.displayed) item.hide();
	      }
	    }

	    /**
	     * this function is very similar to the _checkIfInvisible() but it does not
	     * return booleans, hides the item if it should not be seen and always adds to
	     * the visibleItems.
	     * this one is for brute forcing and hiding.
	     *
	     * @param {Item} item
	     * @param {Array.<timeline.Item>} visibleItems
	     * @param {Object<number, boolean>} visibleItemsLookup
	     * @param {{start:number, end:number}} range
	     * @private
	     */
	  }, {
	    key: "_checkIfVisibleWithReference",
	    value: function _checkIfVisibleWithReference(item, visibleItems, visibleItemsLookup, range) {
	      if (item.isVisible(range)) {
	        if (visibleItemsLookup[item.id] === undefined) {
	          visibleItemsLookup[item.id] = true;
	          visibleItems.push(item);
	        }
	      } else {
	        if (item.displayed) item.hide();
	      }
	    }

	    /**
	     * Update the visible items
	     * @param {array} orderedClusters 
	     * @param {array} oldVisibleClusters                         
	     * @param {{start: number, end: number}} range             
	     * @return {Item[]} visibleItems                            
	     * @private
	     */
	  }, {
	    key: "_updateClustersInRange",
	    value: function _updateClustersInRange(orderedClusters, oldVisibleClusters, range) {
	      // Clusters can overlap each other so we cannot use binary search here
	      var visibleClusters = [];
	      var visibleClustersLookup = {}; // we keep this to quickly look up if an item already exists in the list without using indexOf on visibleItems

	      if (oldVisibleClusters.length > 0) {
	        for (var i = 0; i < oldVisibleClusters.length; i++) {
	          this._checkIfVisibleWithReference(oldVisibleClusters[i], visibleClusters, visibleClustersLookup, range);
	        }
	      }
	      for (var _i6 = 0; _i6 < orderedClusters.byStart.length; _i6++) {
	        this._checkIfVisibleWithReference(orderedClusters.byStart[_i6], visibleClusters, visibleClustersLookup, range);
	      }
	      for (var _i7 = 0; _i7 < orderedClusters.byEnd.length; _i7++) {
	        this._checkIfVisibleWithReference(orderedClusters.byEnd[_i7], visibleClusters, visibleClustersLookup, range);
	      }
	      var redrawQueue = {};
	      var redrawQueueLength = 0;
	      for (var _i8 = 0; _i8 < visibleClusters.length; _i8++) {
	        var item = visibleClusters[_i8];
	        if (!item.displayed) {
	          var returnQueue = true;
	          redrawQueue[_i8] = item.redraw(returnQueue);
	          redrawQueueLength = redrawQueue[_i8].length;
	        }
	      }
	      var needRedraw = redrawQueueLength > 0;
	      if (needRedraw) {
	        // redraw all regular items
	        for (var j = 0; j < redrawQueueLength; j++) {
	          _forEachInstanceProperty(availableUtils).call(availableUtils, redrawQueue, function (fns) {
	            fns[j]();
	          });
	        }
	      }
	      for (var _i9 = 0; _i9 < visibleClusters.length; _i9++) {
	        visibleClusters[_i9].repositionX();
	      }
	      return visibleClusters;
	    }

	    /**
	     * change item subgroup
	     * @param {object} item
	     * @param {string} oldSubgroup
	     * @param {string} newSubgroup
	     */
	  }, {
	    key: "changeSubgroup",
	    value: function changeSubgroup(item, oldSubgroup, newSubgroup) {
	      this._removeFromSubgroup(item, oldSubgroup);
	      this._addToSubgroup(item, newSubgroup);
	      this.orderSubgroups();
	    }

	    /**
	     * Call this method before you lose the last reference to an instance of this.
	     * It will remove listeners etc.
	     */
	  }, {
	    key: "dispose",
	    value: function dispose() {
	      this.hide();
	      var disposeCallback;
	      while (disposeCallback = this._disposeCallbacks.pop()) {
	        disposeCallback();
	      }
	    }
	  }]);
	  return Group;
	}();

	function _createSuper$8(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$8(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$8() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * @constructor BackgroundGroup
	 * @extends Group
	 */
	var BackgroundGroup = /*#__PURE__*/function (_Group) {
	  _inherits(BackgroundGroup, _Group);
	  var _super = _createSuper$8(BackgroundGroup);
	  /**
	  * @param {number | string} groupId
	  * @param {Object} data
	  * @param {ItemSet} itemSet
	  */
	  function BackgroundGroup(groupId, data, itemSet) {
	    var _this;
	    _classCallCheck(this, BackgroundGroup);
	    _this = _super.call(this, groupId, data, itemSet);
	    // Group.call(this, groupId, data, itemSet);

	    _this.width = 0;
	    _this.height = 0;
	    _this.top = 0;
	    _this.left = 0;
	    return _this;
	  }

	  /**
	   * Repaint this group
	   * @param {{start: number, end: number}} range
	   * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
	   * @param {boolean} [forceRestack=false]  Force restacking of all items
	   * @return {boolean} Returns true if the group is resized
	   */
	  _createClass(BackgroundGroup, [{
	    key: "redraw",
	    value: function redraw(range, margin, forceRestack) {
	      // eslint-disable-line no-unused-vars
	      var resized = false;
	      this.visibleItems = this._updateItemsInRange(this.orderedItems, this.visibleItems, range);

	      // calculate actual size
	      this.width = this.dom.background.offsetWidth;

	      // apply new height (just always zero for BackgroundGroup
	      this.dom.background.style.height = '0';

	      // update vertical position of items after they are re-stacked and the height of the group is calculated
	      for (var i = 0, ii = this.visibleItems.length; i < ii; i++) {
	        var item = this.visibleItems[i];
	        item.repositionY(margin);
	      }
	      return resized;
	    }

	    /**
	     * Show this group: attach to the DOM
	     */
	  }, {
	    key: "show",
	    value: function show() {
	      if (!this.dom.background.parentNode) {
	        this.itemSet.dom.background.appendChild(this.dom.background);
	      }
	    }
	  }]);
	  return BackgroundGroup;
	}(Group);

	function _createForOfIteratorHelper$4(o, allowArrayLike) { var it = typeof _Symbol !== "undefined" && _getIteratorMethod(o) || o["@@iterator"]; if (!it) { if (_Array$isArray$1(o) || (it = _unsupportedIterableToArray$4(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
	function _unsupportedIterableToArray$4(o, minLen) { var _context8; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$4(o, minLen); var n = _sliceInstanceProperty(_context8 = Object.prototype.toString.call(o)).call(_context8, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return _Array$from$1(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$4(o, minLen); }
	function _arrayLikeToArray$4(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

	/**
	 * Item
	 */
	var Item = /*#__PURE__*/function () {
	  /**
	  * @constructor Item
	  * @param {Object} data             Object containing (optional) parameters type,
	  *                                  start, end, content, group, className.
	  * @param {{toScreen: function, toTime: function}} conversion
	  *                                  Conversion functions from time to screen and vice versa
	  * @param {Object} options          Configuration options
	  *                                  // TODO: describe available options
	  */
	  function Item(data, conversion, options) {
	    var _context,
	      _this = this;
	    _classCallCheck(this, Item);
	    this.id = null;
	    this.parent = null;
	    this.data = data;
	    this.dom = null;
	    this.conversion = conversion || {};
	    this.defaultOptions = {
	      locales: locales,
	      locale: 'en'
	    };
	    this.options = availableUtils.extend({}, this.defaultOptions, options);
	    this.options.locales = availableUtils.extend({}, locales, this.options.locales);
	    var defaultLocales = this.defaultOptions.locales[this.defaultOptions.locale];
	    _forEachInstanceProperty(_context = _Object$keys(this.options.locales)).call(_context, function (locale) {
	      _this.options.locales[locale] = availableUtils.extend({}, defaultLocales, _this.options.locales[locale]);
	    });
	    this.selected = false;
	    this.displayed = false;
	    this.groupShowing = true;
	    this.selectable = options && options.selectable || false;
	    this.dirty = true;
	    this.top = null;
	    this.right = null;
	    this.left = null;
	    this.width = null;
	    this.height = null;
	    this.setSelectability(data);
	    this.editable = null;
	    this._updateEditStatus();
	  }

	  /**
	   * Select current item
	   */
	  _createClass(Item, [{
	    key: "select",
	    value: function select() {
	      if (this.selectable) {
	        this.selected = true;
	        this.dirty = true;
	        if (this.displayed) this.redraw();
	      }
	    }

	    /**
	     * Unselect current item
	     */
	  }, {
	    key: "unselect",
	    value: function unselect() {
	      this.selected = false;
	      this.dirty = true;
	      if (this.displayed) this.redraw();
	    }

	    /**
	     * Set data for the item. Existing data will be updated. The id should not
	     * be changed. When the item is displayed, it will be redrawn immediately.
	     * @param {Object} data
	     */
	  }, {
	    key: "setData",
	    value: function setData(data) {
	      var groupChanged = data.group != undefined && this.data.group != data.group;
	      if (groupChanged && this.parent != null) {
	        this.parent.itemSet._moveToGroup(this, data.group);
	      }
	      this.setSelectability(data);
	      if (this.parent) {
	        this.parent.stackDirty = true;
	      }
	      var subGroupChanged = data.subgroup != undefined && this.data.subgroup != data.subgroup;
	      if (subGroupChanged && this.parent != null) {
	        this.parent.changeSubgroup(this, this.data.subgroup, data.subgroup);
	      }
	      this.data = data;
	      this._updateEditStatus();
	      this.dirty = true;
	      if (this.displayed) this.redraw();
	    }

	    /**
	     * Set whether the item can be selected.
	     * Can only be set/unset if the timeline's `selectable` configuration option is `true`.
	     * @param {Object} data `data` from `constructor` and `setData`
	     */
	  }, {
	    key: "setSelectability",
	    value: function setSelectability(data) {
	      if (data) {
	        this.selectable = typeof data.selectable === 'undefined' ? true : Boolean(data.selectable);
	      }
	    }

	    /**
	     * Set a parent for the item
	     * @param {Group} parent
	     */
	  }, {
	    key: "setParent",
	    value: function setParent(parent) {
	      if (this.displayed) {
	        this.hide();
	        this.parent = parent;
	        if (this.parent) {
	          this.show();
	        }
	      } else {
	        this.parent = parent;
	      }
	    }

	    /**
	     * Check whether this item is visible inside given range
	     * @param {timeline.Range} range with a timestamp for start and end
	     * @returns {boolean} True if visible
	     */
	  }, {
	    key: "isVisible",
	    value: function isVisible(range) {
	      // eslint-disable-line no-unused-vars
	      return false;
	    }

	    /**
	     * Show the Item in the DOM (when not already visible)
	     * @return {Boolean} changed
	     */
	  }, {
	    key: "show",
	    value: function show() {
	      return false;
	    }

	    /**
	     * Hide the Item from the DOM (when visible)
	     * @return {Boolean} changed
	     */
	  }, {
	    key: "hide",
	    value: function hide() {
	      return false;
	    }

	    /**
	     * Repaint the item
	     */
	  }, {
	    key: "redraw",
	    value: function redraw() {
	      // should be implemented by the item
	    }

	    /**
	     * Reposition the Item horizontally
	     */
	  }, {
	    key: "repositionX",
	    value: function repositionX() {
	      // should be implemented by the item
	    }

	    /**
	     * Reposition the Item vertically
	     */
	  }, {
	    key: "repositionY",
	    value: function repositionY() {
	      // should be implemented by the item
	    }

	    /**
	     * Repaint a drag area on the center of the item when the item is selected
	     * @protected
	     */
	  }, {
	    key: "_repaintDragCenter",
	    value: function _repaintDragCenter() {
	      if (this.selected && this.editable.updateTime && !this.dom.dragCenter) {
	        var _context2, _context3;
	        var me = this;
	        // create and show drag area
	        var dragCenter = document.createElement('div');
	        dragCenter.className = 'vis-drag-center';
	        dragCenter.dragCenterItem = this;
	        this.hammerDragCenter = new Hammer(dragCenter);
	        this.hammerDragCenter.on('tap', function (event) {
	          me.parent.itemSet.body.emitter.emit('click', {
	            event: event,
	            item: me.id
	          });
	        });
	        this.hammerDragCenter.on('doubletap', function (event) {
	          event.stopPropagation();
	          me.parent.itemSet._onUpdateItem(me);
	          me.parent.itemSet.body.emitter.emit('doubleClick', {
	            event: event,
	            item: me.id
	          });
	        });
	        this.hammerDragCenter.on('panstart', function (event) {
	          // do not allow this event to propagate to the Range
	          event.stopPropagation();
	          me.parent.itemSet._onDragStart(event);
	        });
	        this.hammerDragCenter.on('panmove', _bindInstanceProperty(_context2 = me.parent.itemSet._onDrag).call(_context2, me.parent.itemSet));
	        this.hammerDragCenter.on('panend', _bindInstanceProperty(_context3 = me.parent.itemSet._onDragEnd).call(_context3, me.parent.itemSet));
	        // delay addition on item click for trackpads...
	        this.hammerDragCenter.get('press').set({
	          time: 10000
	        });
	        if (this.dom.box) {
	          if (this.dom.dragLeft) {
	            this.dom.box.insertBefore(dragCenter, this.dom.dragLeft);
	          } else {
	            this.dom.box.appendChild(dragCenter);
	          }
	        } else if (this.dom.point) {
	          this.dom.point.appendChild(dragCenter);
	        }
	        this.dom.dragCenter = dragCenter;
	      } else if (!this.selected && this.dom.dragCenter) {
	        // delete drag area
	        if (this.dom.dragCenter.parentNode) {
	          this.dom.dragCenter.parentNode.removeChild(this.dom.dragCenter);
	        }
	        this.dom.dragCenter = null;
	        if (this.hammerDragCenter) {
	          this.hammerDragCenter.destroy();
	          this.hammerDragCenter = null;
	        }
	      }
	    }

	    /**
	     * Repaint a delete button on the top right of the item when the item is selected
	     * @param {HTMLElement} anchor
	     * @protected
	     */
	  }, {
	    key: "_repaintDeleteButton",
	    value: function _repaintDeleteButton(anchor) {
	      var editable = (this.options.editable.overrideItems || this.editable == null) && this.options.editable.remove || !this.options.editable.overrideItems && this.editable != null && this.editable.remove;
	      if (this.selected && editable && !this.dom.deleteButton) {
	        // create and show button
	        var me = this;
	        var deleteButton = document.createElement('div');
	        if (this.options.rtl) {
	          deleteButton.className = 'vis-delete-rtl';
	        } else {
	          deleteButton.className = 'vis-delete';
	        }
	        var optionsLocale = this.options.locales[this.options.locale];
	        if (!optionsLocale) {
	          if (!this.warned) {
	            console.warn("WARNING: options.locales['".concat(this.options.locale, "'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization"));
	            this.warned = true;
	          }
	          optionsLocale = this.options.locales['en']; // fall back on english when not available
	        }

	        deleteButton.title = optionsLocale.deleteSelected;

	        // TODO: be able to destroy the delete button
	        this.hammerDeleteButton = new Hammer(deleteButton).on('tap', function (event) {
	          event.stopPropagation();
	          me.parent.removeFromDataSet(me);
	        });
	        anchor.appendChild(deleteButton);
	        this.dom.deleteButton = deleteButton;
	      } else if ((!this.selected || !editable) && this.dom.deleteButton) {
	        // remove button
	        if (this.dom.deleteButton.parentNode) {
	          this.dom.deleteButton.parentNode.removeChild(this.dom.deleteButton);
	        }
	        this.dom.deleteButton = null;
	        if (this.hammerDeleteButton) {
	          this.hammerDeleteButton.destroy();
	          this.hammerDeleteButton = null;
	        }
	      }
	    }

	    /**
	     * Repaint a onChange tooltip on the top right of the item when the item is selected
	     * @param {HTMLElement} anchor
	     * @protected
	     */
	  }, {
	    key: "_repaintOnItemUpdateTimeTooltip",
	    value: function _repaintOnItemUpdateTimeTooltip(anchor) {
	      if (!this.options.tooltipOnItemUpdateTime) return;
	      var editable = (this.options.editable.updateTime || this.data.editable === true) && this.data.editable !== false;
	      if (this.selected && editable && !this.dom.onItemUpdateTimeTooltip) {
	        var onItemUpdateTimeTooltip = document.createElement('div');
	        onItemUpdateTimeTooltip.className = 'vis-onUpdateTime-tooltip';
	        anchor.appendChild(onItemUpdateTimeTooltip);
	        this.dom.onItemUpdateTimeTooltip = onItemUpdateTimeTooltip;
	      } else if (!this.selected && this.dom.onItemUpdateTimeTooltip) {
	        // remove button
	        if (this.dom.onItemUpdateTimeTooltip.parentNode) {
	          this.dom.onItemUpdateTimeTooltip.parentNode.removeChild(this.dom.onItemUpdateTimeTooltip);
	        }
	        this.dom.onItemUpdateTimeTooltip = null;
	      }

	      // position onChange tooltip
	      if (this.dom.onItemUpdateTimeTooltip) {
	        // only show when editing
	        this.dom.onItemUpdateTimeTooltip.style.visibility = this.parent.itemSet.touchParams.itemIsDragging ? 'visible' : 'hidden';

	        // position relative to item's content
	        this.dom.onItemUpdateTimeTooltip.style.transform = 'translateX(-50%)';
	        this.dom.onItemUpdateTimeTooltip.style.left = '50%';

	        // position above or below the item depending on the item's position in the window
	        var tooltipOffset = 50; // TODO: should be tooltip height (depends on template)
	        var scrollTop = this.parent.itemSet.body.domProps.scrollTop;

	        // TODO: this.top for orientation:true is actually the items distance from the bottom... 
	        // (should be this.bottom)
	        var itemDistanceFromTop;
	        if (this.options.orientation.item == 'top') {
	          itemDistanceFromTop = this.top;
	        } else {
	          itemDistanceFromTop = this.parent.height - this.top - this.height;
	        }
	        var isCloseToTop = itemDistanceFromTop + this.parent.top - tooltipOffset < -scrollTop;
	        if (isCloseToTop) {
	          this.dom.onItemUpdateTimeTooltip.style.bottom = "";
	          this.dom.onItemUpdateTimeTooltip.style.top = "".concat(this.height + 2, "px");
	        } else {
	          this.dom.onItemUpdateTimeTooltip.style.top = "";
	          this.dom.onItemUpdateTimeTooltip.style.bottom = "".concat(this.height + 2, "px");
	        }

	        // handle tooltip content
	        var content;
	        var templateFunction;
	        if (this.options.tooltipOnItemUpdateTime && this.options.tooltipOnItemUpdateTime.template) {
	          var _context4;
	          templateFunction = _bindInstanceProperty(_context4 = this.options.tooltipOnItemUpdateTime.template).call(_context4, this);
	          content = templateFunction(this.data);
	        } else {
	          content = "start: ".concat(moment$2(this.data.start).format('MM/DD/YYYY hh:mm'));
	          if (this.data.end) {
	            content += "<br> end: ".concat(moment$2(this.data.end).format('MM/DD/YYYY hh:mm'));
	          }
	        }
	        this.dom.onItemUpdateTimeTooltip.innerHTML = availableUtils.xss(content);
	      }
	    }

	    /**
	    * get item data
	    * @return {object}
	    * @private
	    */
	  }, {
	    key: "_getItemData",
	    value: function _getItemData() {
	      return this.parent.itemSet.itemsData.get(this.id);
	    }

	    /**
	     * Set HTML contents for the item
	     * @param {Element} element   HTML element to fill with the contents
	     * @private
	     */
	  }, {
	    key: "_updateContents",
	    value: function _updateContents(element) {
	      var content;
	      var changed;
	      var templateFunction;
	      var itemVisibleFrameContent;
	      var visibleFrameTemplateFunction;
	      var itemData = this._getItemData(); // get a clone of the data from the dataset

	      var frameElement = this.dom.box || this.dom.point;
	      var itemVisibleFrameContentElement = frameElement.getElementsByClassName('vis-item-visible-frame')[0];
	      if (this.options.visibleFrameTemplate) {
	        var _context5;
	        visibleFrameTemplateFunction = _bindInstanceProperty(_context5 = this.options.visibleFrameTemplate).call(_context5, this);
	        itemVisibleFrameContent = availableUtils.xss(visibleFrameTemplateFunction(itemData, itemVisibleFrameContentElement));
	      } else {
	        itemVisibleFrameContent = '';
	      }
	      if (itemVisibleFrameContentElement) {
	        if (itemVisibleFrameContent instanceof Object && !(itemVisibleFrameContent instanceof Element)) {
	          visibleFrameTemplateFunction(itemData, itemVisibleFrameContentElement);
	        } else {
	          changed = this._contentToString(this.itemVisibleFrameContent) !== this._contentToString(itemVisibleFrameContent);
	          if (changed) {
	            // only replace the content when changed
	            if (itemVisibleFrameContent instanceof Element) {
	              itemVisibleFrameContentElement.innerHTML = '';
	              itemVisibleFrameContentElement.appendChild(itemVisibleFrameContent);
	            } else if (itemVisibleFrameContent != undefined) {
	              itemVisibleFrameContentElement.innerHTML = availableUtils.xss(itemVisibleFrameContent);
	            } else {
	              if (!(this.data.type == 'background' && this.data.content === undefined)) {
	                throw new Error("Property \"content\" missing in item ".concat(this.id));
	              }
	            }
	            this.itemVisibleFrameContent = itemVisibleFrameContent;
	          }
	        }
	      }
	      if (this.options.template) {
	        var _context6;
	        templateFunction = _bindInstanceProperty(_context6 = this.options.template).call(_context6, this);
	        content = templateFunction(itemData, element, this.data);
	      } else {
	        content = this.data.content;
	      }
	      if (content instanceof Object && !(content instanceof Element)) {
	        templateFunction(itemData, element);
	      } else {
	        changed = this._contentToString(this.content) !== this._contentToString(content);
	        if (changed) {
	          // only replace the content when changed
	          if (content instanceof Element) {
	            element.innerHTML = '';
	            element.appendChild(content);
	          } else if (content != undefined) {
	            element.innerHTML = availableUtils.xss(content);
	          } else {
	            if (!(this.data.type == 'background' && this.data.content === undefined)) {
	              throw new Error("Property \"content\" missing in item ".concat(this.id));
	            }
	          }
	          this.content = content;
	        }
	      }
	    }

	    /**
	     * Process dataAttributes timeline option and set as data- attributes on dom.content
	     * @param {Element} element   HTML element to which the attributes will be attached
	     * @private
	     */
	  }, {
	    key: "_updateDataAttributes",
	    value: function _updateDataAttributes(element) {
	      if (this.options.dataAttributes && this.options.dataAttributes.length > 0) {
	        var attributes = [];
	        if (_Array$isArray$1(this.options.dataAttributes)) {
	          attributes = this.options.dataAttributes;
	        } else if (this.options.dataAttributes == 'all') {
	          attributes = _Object$keys(this.data);
	        } else {
	          return;
	        }
	        var _iterator = _createForOfIteratorHelper$4(attributes),
	          _step;
	        try {
	          for (_iterator.s(); !(_step = _iterator.n()).done;) {
	            var name = _step.value;
	            var value = this.data[name];
	            if (value != null) {
	              element.setAttribute("data-".concat(name), value);
	            } else {
	              element.removeAttribute("data-".concat(name));
	            }
	          }
	        } catch (err) {
	          _iterator.e(err);
	        } finally {
	          _iterator.f();
	        }
	      }
	    }

	    /**
	     * Update custom styles of the element
	     * @param {Element} element
	     * @private
	     */
	  }, {
	    key: "_updateStyle",
	    value: function _updateStyle(element) {
	      // remove old styles
	      if (this.style) {
	        availableUtils.removeCssText(element, this.style);
	        this.style = null;
	      }

	      // append new styles
	      if (this.data.style) {
	        availableUtils.addCssText(element, this.data.style);
	        this.style = this.data.style;
	      }
	    }

	    /**
	     * Stringify the items contents
	     * @param {string | Element | undefined} content
	     * @returns {string | undefined}
	     * @private
	     */
	  }, {
	    key: "_contentToString",
	    value: function _contentToString(content) {
	      if (typeof content === 'string') return content;
	      if (content && 'outerHTML' in content) return content.outerHTML;
	      return content;
	    }

	    /**
	     * Update the editability of this item.
	     */
	  }, {
	    key: "_updateEditStatus",
	    value: function _updateEditStatus() {
	      if (this.options) {
	        if (typeof this.options.editable === 'boolean') {
	          this.editable = {
	            updateTime: this.options.editable,
	            updateGroup: this.options.editable,
	            remove: this.options.editable
	          };
	        } else if (_typeof(this.options.editable) === 'object') {
	          this.editable = {};
	          availableUtils.selectiveExtend(['updateTime', 'updateGroup', 'remove'], this.editable, this.options.editable);
	        }
	      }
	      // Item data overrides, except if options.editable.overrideItems is set.
	      if (!this.options || !this.options.editable || this.options.editable.overrideItems !== true) {
	        if (this.data) {
	          if (typeof this.data.editable === 'boolean') {
	            this.editable = {
	              updateTime: this.data.editable,
	              updateGroup: this.data.editable,
	              remove: this.data.editable
	            };
	          } else if (_typeof(this.data.editable) === 'object') {
	            // TODO: in timeline.js 5.0, we should change this to not reset options from the timeline configuration.
	            // Basically just remove the next line...
	            this.editable = {};
	            availableUtils.selectiveExtend(['updateTime', 'updateGroup', 'remove'], this.editable, this.data.editable);
	          }
	        }
	      }
	    }

	    /**
	     * Return the width of the item left from its start date
	     * @return {number}
	     */
	  }, {
	    key: "getWidthLeft",
	    value: function getWidthLeft() {
	      return 0;
	    }

	    /**
	     * Return the width of the item right from the max of its start and end date
	     * @return {number}
	     */
	  }, {
	    key: "getWidthRight",
	    value: function getWidthRight() {
	      return 0;
	    }

	    /**
	     * Return the title of the item
	     * @return {string | undefined}
	     */
	  }, {
	    key: "getTitle",
	    value: function getTitle() {
	      if (this.options.tooltip && this.options.tooltip.template) {
	        var _context7;
	        var templateFunction = _bindInstanceProperty(_context7 = this.options.tooltip.template).call(_context7, this);
	        return templateFunction(this._getItemData(), this.data);
	      }
	      return this.data.title;
	    }
	  }]);
	  return Item;
	}();
	Item.prototype.stack = true;

	function _createSuper$7(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$7(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$7() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * @constructor BoxItem
	 * @extends Item
	 */
	var BoxItem = /*#__PURE__*/function (_Item) {
	  _inherits(BoxItem, _Item);
	  var _super = _createSuper$7(BoxItem);
	  /**
	  * @param {Object} data             Object containing parameters start
	  *                                  content, className.
	  * @param {{toScreen: function, toTime: function}} conversion
	  *                                  Conversion functions from time to screen and vice versa
	  * @param {Object} [options]        Configuration options
	  *                                  // TODO: describe available options
	  */
	  function BoxItem(data, conversion, options) {
	    var _this;
	    _classCallCheck(this, BoxItem);
	    _this = _super.call(this, data, conversion, options);
	    _this.props = {
	      dot: {
	        width: 0,
	        height: 0
	      },
	      line: {
	        width: 0,
	        height: 0
	      }
	    };
	    // validate data
	    if (data) {
	      if (data.start == undefined) {
	        throw new Error("Property \"start\" missing in item ".concat(data));
	      }
	    }
	    return _this;
	  }

	  /**
	   * Check whether this item is visible inside given range
	   * @param {{start: number, end: number}} range with a timestamp for start and end
	   * @returns {boolean} True if visible
	   */
	  _createClass(BoxItem, [{
	    key: "isVisible",
	    value: function isVisible(range) {
	      if (this.cluster) {
	        return false;
	      }
	      // determine visibility
	      var isVisible;
	      var align = this.data.align || this.options.align;
	      var widthInMs = this.width * range.getMillisecondsPerPixel();
	      if (align == 'right') {
	        isVisible = this.data.start.getTime() > range.start && this.data.start.getTime() - widthInMs < range.end;
	      } else if (align == 'left') {
	        isVisible = this.data.start.getTime() + widthInMs > range.start && this.data.start.getTime() < range.end;
	      } else {
	        // default or 'center'
	        isVisible = this.data.start.getTime() + widthInMs / 2 > range.start && this.data.start.getTime() - widthInMs / 2 < range.end;
	      }
	      return isVisible;
	    }

	    /**
	    * create DOM element
	    * @private
	    */
	  }, {
	    key: "_createDomElement",
	    value: function _createDomElement() {
	      if (!this.dom) {
	        // create DOM
	        this.dom = {};

	        // create main box
	        this.dom.box = document.createElement('DIV');

	        // contents box (inside the background box). used for making margins
	        this.dom.content = document.createElement('DIV');
	        this.dom.content.className = 'vis-item-content';
	        this.dom.box.appendChild(this.dom.content);

	        // line to axis
	        this.dom.line = document.createElement('DIV');
	        this.dom.line.className = 'vis-line';

	        // dot on axis
	        this.dom.dot = document.createElement('DIV');
	        this.dom.dot.className = 'vis-dot';

	        // attach this item as attribute
	        this.dom.box['vis-item'] = this;
	        this.dirty = true;
	      }
	    }

	    /**
	     * append DOM element
	     * @private
	     */
	  }, {
	    key: "_appendDomElement",
	    value: function _appendDomElement() {
	      if (!this.parent) {
	        throw new Error('Cannot redraw item: no parent attached');
	      }
	      if (!this.dom.box.parentNode) {
	        var foreground = this.parent.dom.foreground;
	        if (!foreground) throw new Error('Cannot redraw item: parent has no foreground container element');
	        foreground.appendChild(this.dom.box);
	      }
	      if (!this.dom.line.parentNode) {
	        var background = this.parent.dom.background;
	        if (!background) throw new Error('Cannot redraw item: parent has no background container element');
	        background.appendChild(this.dom.line);
	      }
	      if (!this.dom.dot.parentNode) {
	        var axis = this.parent.dom.axis;
	        if (!background) throw new Error('Cannot redraw item: parent has no axis container element');
	        axis.appendChild(this.dom.dot);
	      }
	      this.displayed = true;
	    }

	    /**
	     * update dirty DOM element
	     * @private
	     */
	  }, {
	    key: "_updateDirtyDomComponents",
	    value: function _updateDirtyDomComponents() {
	      // An item is marked dirty when:
	      // - the item is not yet rendered
	      // - the item's data is changed
	      // - the item is selected/deselected
	      if (this.dirty) {
	        this._updateContents(this.dom.content);
	        this._updateDataAttributes(this.dom.box);
	        this._updateStyle(this.dom.box);
	        var editable = this.editable.updateTime || this.editable.updateGroup;

	        // update class
	        var className = (this.data.className ? ' ' + this.data.className : '') + (this.selected ? ' vis-selected' : '') + (editable ? ' vis-editable' : ' vis-readonly');
	        this.dom.box.className = "vis-item vis-box".concat(className);
	        this.dom.line.className = "vis-item vis-line".concat(className);
	        this.dom.dot.className = "vis-item vis-dot".concat(className);
	      }
	    }

	    /**
	     * get DOM components sizes
	     * @return {object}
	     * @private
	     */
	  }, {
	    key: "_getDomComponentsSizes",
	    value: function _getDomComponentsSizes() {
	      return {
	        previous: {
	          right: this.dom.box.style.right,
	          left: this.dom.box.style.left
	        },
	        dot: {
	          height: this.dom.dot.offsetHeight,
	          width: this.dom.dot.offsetWidth
	        },
	        line: {
	          width: this.dom.line.offsetWidth
	        },
	        box: {
	          width: this.dom.box.offsetWidth,
	          height: this.dom.box.offsetHeight
	        }
	      };
	    }

	    /**
	     * update DOM components sizes
	     * @param {object} sizes
	     * @private
	     */
	  }, {
	    key: "_updateDomComponentsSizes",
	    value: function _updateDomComponentsSizes(sizes) {
	      if (this.options.rtl) {
	        this.dom.box.style.right = "0px";
	      } else {
	        this.dom.box.style.left = "0px";
	      }

	      // recalculate size
	      this.props.dot.height = sizes.dot.height;
	      this.props.dot.width = sizes.dot.width;
	      this.props.line.width = sizes.line.width;
	      this.width = sizes.box.width;
	      this.height = sizes.box.height;

	      // restore previous position
	      if (this.options.rtl) {
	        this.dom.box.style.right = sizes.previous.right;
	      } else {
	        this.dom.box.style.left = sizes.previous.left;
	      }
	      this.dirty = false;
	    }

	    /**
	     * repaint DOM additionals
	     * @private
	     */
	  }, {
	    key: "_repaintDomAdditionals",
	    value: function _repaintDomAdditionals() {
	      this._repaintOnItemUpdateTimeTooltip(this.dom.box);
	      this._repaintDragCenter();
	      this._repaintDeleteButton(this.dom.box);
	    }

	    /**
	     * Repaint the item
	     * @param {boolean} [returnQueue=false]  return the queue
	     * @return {boolean} the redraw queue if returnQueue=true
	     */
	  }, {
	    key: "redraw",
	    value: function redraw(returnQueue) {
	      var _context,
	        _context2,
	        _context3,
	        _this2 = this,
	        _context5;
	      var sizes;
	      var queue = [
	      // create item DOM
	      _bindInstanceProperty(_context = this._createDomElement).call(_context, this),
	      // append DOM to parent DOM
	      _bindInstanceProperty(_context2 = this._appendDomElement).call(_context2, this),
	      // update dirty DOM
	      _bindInstanceProperty(_context3 = this._updateDirtyDomComponents).call(_context3, this), function () {
	        if (_this2.dirty) {
	          sizes = _this2._getDomComponentsSizes();
	        }
	      }, function () {
	        if (_this2.dirty) {
	          var _context4;
	          _bindInstanceProperty(_context4 = _this2._updateDomComponentsSizes).call(_context4, _this2)(sizes);
	        }
	      },
	      // repaint DOM additionals
	      _bindInstanceProperty(_context5 = this._repaintDomAdditionals).call(_context5, this)];
	      if (returnQueue) {
	        return queue;
	      } else {
	        var result;
	        _forEachInstanceProperty(queue).call(queue, function (fn) {
	          result = fn();
	        });
	        return result;
	      }
	    }

	    /**
	     * Show the item in the DOM (when not already visible). The items DOM will
	     * be created when needed.
	     * @param {boolean} [returnQueue=false]  whether to return a queue of functions to execute instead of just executing them
	     * @return {boolean} the redraw queue if returnQueue=true
	     */
	  }, {
	    key: "show",
	    value: function show(returnQueue) {
	      if (!this.displayed) {
	        return this.redraw(returnQueue);
	      }
	    }

	    /**
	     * Hide the item from the DOM (when visible)
	     */
	  }, {
	    key: "hide",
	    value: function hide() {
	      if (this.displayed) {
	        var dom = this.dom;
	        if (dom.box.remove) dom.box.remove();else if (dom.box.parentNode) dom.box.parentNode.removeChild(dom.box); // IE11

	        if (dom.line.remove) dom.line.remove();else if (dom.line.parentNode) dom.line.parentNode.removeChild(dom.line); // IE11

	        if (dom.dot.remove) dom.dot.remove();else if (dom.dot.parentNode) dom.dot.parentNode.removeChild(dom.dot); // IE11

	        this.displayed = false;
	      }
	    }

	    /**
	     * Reposition the item XY
	     */
	  }, {
	    key: "repositionXY",
	    value: function repositionXY() {
	      var rtl = this.options.rtl;
	      var repositionXY = function repositionXY(element, x, y) {
	        var _context6;
	        var rtl = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	        if (x === undefined && y === undefined) return;
	        // If rtl invert the number.
	        var directionX = rtl ? x * -1 : x;

	        //no y. translate x
	        if (y === undefined) {
	          element.style.transform = "translateX(".concat(directionX, "px)");
	          return;
	        }

	        //no x. translate y
	        if (x === undefined) {
	          element.style.transform = "translateY(".concat(y, "px)");
	          return;
	        }
	        element.style.transform = _concatInstanceProperty(_context6 = "translate(".concat(directionX, "px, ")).call(_context6, y, "px)");
	      };
	      repositionXY(this.dom.box, this.boxX, this.boxY, rtl);
	      repositionXY(this.dom.dot, this.dotX, this.dotY, rtl);
	      repositionXY(this.dom.line, this.lineX, this.lineY, rtl);
	    }

	    /**
	     * Reposition the item horizontally
	     * @Override
	     */
	  }, {
	    key: "repositionX",
	    value: function repositionX() {
	      var start = this.conversion.toScreen(this.data.start);
	      var align = this.data.align === undefined ? this.options.align : this.data.align;
	      var lineWidth = this.props.line.width;
	      var dotWidth = this.props.dot.width;
	      if (align == 'right') {
	        // calculate right position of the box
	        this.boxX = start - this.width;
	        this.lineX = start - lineWidth;
	        this.dotX = start - lineWidth / 2 - dotWidth / 2;
	      } else if (align == 'left') {
	        // calculate left position of the box
	        this.boxX = start;
	        this.lineX = start;
	        this.dotX = start + lineWidth / 2 - dotWidth / 2;
	      } else {
	        // default or 'center'
	        this.boxX = start - this.width / 2;
	        this.lineX = this.options.rtl ? start - lineWidth : start - lineWidth / 2;
	        this.dotX = start - dotWidth / 2;
	      }
	      if (this.options.rtl) this.right = this.boxX;else this.left = this.boxX;
	      this.repositionXY();
	    }

	    /**
	     * Reposition the item vertically
	     * @Override
	     */
	  }, {
	    key: "repositionY",
	    value: function repositionY() {
	      var orientation = this.options.orientation.item;
	      var lineStyle = this.dom.line.style;
	      if (orientation == 'top') {
	        var lineHeight = this.parent.top + this.top + 1;
	        this.boxY = this.top || 0;
	        lineStyle.height = "".concat(lineHeight, "px");
	        lineStyle.bottom = '';
	        lineStyle.top = '0';
	      } else {
	        // orientation 'bottom'
	        var itemSetHeight = this.parent.itemSet.props.height; // TODO: this is nasty
	        var _lineHeight = itemSetHeight - this.parent.top - this.parent.height + this.top;
	        this.boxY = this.parent.height - this.top - (this.height || 0);
	        lineStyle.height = "".concat(_lineHeight, "px");
	        lineStyle.top = '';
	        lineStyle.bottom = '0';
	      }
	      this.dotY = -this.props.dot.height / 2;
	      this.repositionXY();
	    }

	    /**
	     * Return the width of the item left from its start date
	     * @return {number}
	     */
	  }, {
	    key: "getWidthLeft",
	    value: function getWidthLeft() {
	      return this.width / 2;
	    }

	    /**
	     * Return the width of the item right from its start date
	     * @return {number}
	     */
	  }, {
	    key: "getWidthRight",
	    value: function getWidthRight() {
	      return this.width / 2;
	    }
	  }]);
	  return BoxItem;
	}(Item);

	function _createSuper$6(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$6(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$6() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * @constructor PointItem
	 * @extends Item
	 */
	var PointItem = /*#__PURE__*/function (_Item) {
	  _inherits(PointItem, _Item);
	  var _super = _createSuper$6(PointItem);
	  /**
	  * @param {Object} data             Object containing parameters start
	  *                                  content, className.
	  * @param {{toScreen: function, toTime: function}} conversion
	  *                                  Conversion functions from time to screen and vice versa
	  * @param {Object} [options]        Configuration options
	  *                                  // TODO: describe available options
	  */
	  function PointItem(data, conversion, options) {
	    var _this;
	    _classCallCheck(this, PointItem);
	    _this = _super.call(this, data, conversion, options);
	    _this.props = {
	      dot: {
	        top: 0,
	        width: 0,
	        height: 0
	      },
	      content: {
	        height: 0,
	        marginLeft: 0,
	        marginRight: 0
	      }
	    };
	    // validate data
	    if (data) {
	      if (data.start == undefined) {
	        throw new Error("Property \"start\" missing in item ".concat(data));
	      }
	    }
	    return _this;
	  }

	  /**
	   * Check whether this item is visible inside given range
	   * @param {{start: number, end: number}} range with a timestamp for start and end
	   * @returns {boolean} True if visible
	   */
	  _createClass(PointItem, [{
	    key: "isVisible",
	    value: function isVisible(range) {
	      if (this.cluster) {
	        return false;
	      }
	      // determine visibility
	      var widthInMs = this.width * range.getMillisecondsPerPixel();
	      return this.data.start.getTime() + widthInMs > range.start && this.data.start < range.end;
	    }

	    /**
	     * create DOM element
	     * @private
	     */
	  }, {
	    key: "_createDomElement",
	    value: function _createDomElement() {
	      if (!this.dom) {
	        // create DOM
	        this.dom = {};

	        // background box
	        this.dom.point = document.createElement('div');
	        // className is updated in redraw()

	        // contents box, right from the dot
	        this.dom.content = document.createElement('div');
	        this.dom.content.className = 'vis-item-content';
	        this.dom.point.appendChild(this.dom.content);

	        // dot at start
	        this.dom.dot = document.createElement('div');
	        this.dom.point.appendChild(this.dom.dot);

	        // attach this item as attribute
	        this.dom.point['vis-item'] = this;
	        this.dirty = true;
	      }
	    }

	    /**
	     * append DOM element
	     * @private
	     */
	  }, {
	    key: "_appendDomElement",
	    value: function _appendDomElement() {
	      if (!this.parent) {
	        throw new Error('Cannot redraw item: no parent attached');
	      }
	      if (!this.dom.point.parentNode) {
	        var foreground = this.parent.dom.foreground;
	        if (!foreground) {
	          throw new Error('Cannot redraw item: parent has no foreground container element');
	        }
	        foreground.appendChild(this.dom.point);
	      }
	      this.displayed = true;
	    }

	    /**
	     * update dirty DOM components
	     * @private
	     */
	  }, {
	    key: "_updateDirtyDomComponents",
	    value: function _updateDirtyDomComponents() {
	      // An item is marked dirty when:
	      // - the item is not yet rendered
	      // - the item's data is changed
	      // - the item is selected/deselected
	      if (this.dirty) {
	        this._updateContents(this.dom.content);
	        this._updateDataAttributes(this.dom.point);
	        this._updateStyle(this.dom.point);
	        var editable = this.editable.updateTime || this.editable.updateGroup;
	        // update class
	        var className = (this.data.className ? ' ' + this.data.className : '') + (this.selected ? ' vis-selected' : '') + (editable ? ' vis-editable' : ' vis-readonly');
	        this.dom.point.className = "vis-item vis-point".concat(className);
	        this.dom.dot.className = "vis-item vis-dot".concat(className);
	      }
	    }

	    /**
	     * get DOM component sizes
	     * @return {object}
	     * @private
	     */
	  }, {
	    key: "_getDomComponentsSizes",
	    value: function _getDomComponentsSizes() {
	      return {
	        dot: {
	          width: this.dom.dot.offsetWidth,
	          height: this.dom.dot.offsetHeight
	        },
	        content: {
	          width: this.dom.content.offsetWidth,
	          height: this.dom.content.offsetHeight
	        },
	        point: {
	          width: this.dom.point.offsetWidth,
	          height: this.dom.point.offsetHeight
	        }
	      };
	    }

	    /**
	     * update DOM components sizes
	     * @param {array} sizes
	     * @private
	     */
	  }, {
	    key: "_updateDomComponentsSizes",
	    value: function _updateDomComponentsSizes(sizes) {
	      // recalculate size of dot and contents
	      this.props.dot.width = sizes.dot.width;
	      this.props.dot.height = sizes.dot.height;
	      this.props.content.height = sizes.content.height;

	      // resize contents
	      if (this.options.rtl) {
	        this.dom.content.style.marginRight = "".concat(this.props.dot.width / 2, "px");
	      } else {
	        this.dom.content.style.marginLeft = "".concat(this.props.dot.width / 2, "px");
	      }
	      //this.dom.content.style.marginRight = ... + 'px'; // TODO: margin right

	      // recalculate size
	      this.width = sizes.point.width;
	      this.height = sizes.point.height;

	      // reposition the dot
	      this.dom.dot.style.top = "".concat((this.height - this.props.dot.height) / 2, "px");
	      var dotWidth = this.props.dot.width;
	      var translateX = this.options.rtl ? dotWidth / 2 : dotWidth / 2 * -1;
	      this.dom.dot.style.transform = "translateX(".concat(translateX, "px");
	      this.dirty = false;
	    }

	    /**
	     * Repain DOM additionals
	     * @private
	     */
	  }, {
	    key: "_repaintDomAdditionals",
	    value: function _repaintDomAdditionals() {
	      this._repaintOnItemUpdateTimeTooltip(this.dom.point);
	      this._repaintDragCenter();
	      this._repaintDeleteButton(this.dom.point);
	    }

	    /**
	     * Repaint the item
	     * @param {boolean} [returnQueue=false]  return the queue
	     * @return {boolean} the redraw queue if returnQueue=true
	     */
	  }, {
	    key: "redraw",
	    value: function redraw(returnQueue) {
	      var _context,
	        _context2,
	        _context3,
	        _this2 = this,
	        _context5;
	      var sizes;
	      var queue = [
	      // create item DOM
	      _bindInstanceProperty(_context = this._createDomElement).call(_context, this),
	      // append DOM to parent DOM
	      _bindInstanceProperty(_context2 = this._appendDomElement).call(_context2, this),
	      // update dirty DOM
	      _bindInstanceProperty(_context3 = this._updateDirtyDomComponents).call(_context3, this), function () {
	        if (_this2.dirty) {
	          sizes = _this2._getDomComponentsSizes();
	        }
	      }, function () {
	        if (_this2.dirty) {
	          var _context4;
	          _bindInstanceProperty(_context4 = _this2._updateDomComponentsSizes).call(_context4, _this2)(sizes);
	        }
	      },
	      // repaint DOM additionals
	      _bindInstanceProperty(_context5 = this._repaintDomAdditionals).call(_context5, this)];
	      if (returnQueue) {
	        return queue;
	      } else {
	        var result;
	        _forEachInstanceProperty(queue).call(queue, function (fn) {
	          result = fn();
	        });
	        return result;
	      }
	    }

	    /**
	     * Reposition XY
	     */
	  }, {
	    key: "repositionXY",
	    value: function repositionXY() {
	      var rtl = this.options.rtl;
	      var repositionXY = function repositionXY(element, x, y) {
	        var _context6;
	        var rtl = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	        if (x === undefined && y === undefined) return;
	        // If rtl invert the number.
	        var directionX = rtl ? x * -1 : x;

	        //no y. translate x
	        if (y === undefined) {
	          element.style.transform = "translateX(".concat(directionX, "px)");
	          return;
	        }

	        //no x. translate y
	        if (x === undefined) {
	          element.style.transform = "translateY(".concat(y, "px)");
	          return;
	        }
	        element.style.transform = _concatInstanceProperty(_context6 = "translate(".concat(directionX, "px, ")).call(_context6, y, "px)");
	      };
	      repositionXY(this.dom.point, this.pointX, this.pointY, rtl);
	    }

	    /**
	     * Show the item in the DOM (when not already visible). The items DOM will
	     * be created when needed.
	     * @param {boolean} [returnQueue=false]  whether to return a queue of functions to execute instead of just executing them
	     * @return {boolean} the redraw queue if returnQueue=true
	     */
	  }, {
	    key: "show",
	    value: function show(returnQueue) {
	      if (!this.displayed) {
	        return this.redraw(returnQueue);
	      }
	    }

	    /**
	     * Hide the item from the DOM (when visible)
	     */
	  }, {
	    key: "hide",
	    value: function hide() {
	      if (this.displayed) {
	        if (this.dom.point.parentNode) {
	          this.dom.point.parentNode.removeChild(this.dom.point);
	        }
	        this.displayed = false;
	      }
	    }

	    /**
	     * Reposition the item horizontally
	     * @Override
	     */
	  }, {
	    key: "repositionX",
	    value: function repositionX() {
	      var start = this.conversion.toScreen(this.data.start);
	      this.pointX = start;
	      if (this.options.rtl) {
	        this.right = start - this.props.dot.width;
	      } else {
	        this.left = start - this.props.dot.width;
	      }
	      this.repositionXY();
	    }

	    /**
	     * Reposition the item vertically
	     * @Override
	     */
	  }, {
	    key: "repositionY",
	    value: function repositionY() {
	      var orientation = this.options.orientation.item;
	      if (orientation == 'top') {
	        this.pointY = this.top;
	      } else {
	        this.pointY = this.parent.height - this.top - this.height;
	      }
	      this.repositionXY();
	    }

	    /**
	     * Return the width of the item left from its start date
	     * @return {number}
	     */
	  }, {
	    key: "getWidthLeft",
	    value: function getWidthLeft() {
	      return this.props.dot.width;
	    }

	    /**
	     * Return the width of the item right from  its start date
	     * @return {number}
	     */
	  }, {
	    key: "getWidthRight",
	    value: function getWidthRight() {
	      return this.props.dot.width;
	    }
	  }]);
	  return PointItem;
	}(Item);

	function _createSuper$5(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$5(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$5() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * @constructor RangeItem
	 * @extends Item
	 */
	var RangeItem = /*#__PURE__*/function (_Item) {
	  _inherits(RangeItem, _Item);
	  var _super = _createSuper$5(RangeItem);
	  /**
	  * @param {Object} data             Object containing parameters start, end
	  *                                  content, className.
	  * @param {{toScreen: function, toTime: function}} conversion
	  *                                  Conversion functions from time to screen and vice versa
	  * @param {Object} [options]        Configuration options
	  *                                  // TODO: describe options
	  */
	  function RangeItem(data, conversion, options) {
	    var _this;
	    _classCallCheck(this, RangeItem);
	    _this = _super.call(this, data, conversion, options);
	    _this.props = {
	      content: {
	        width: 0
	      }
	    };
	    _this.overflow = false; // if contents can overflow (css styling), this flag is set to true
	    // validate data
	    if (data) {
	      if (data.start == undefined) {
	        throw new Error("Property \"start\" missing in item ".concat(data.id));
	      }
	      if (data.end == undefined) {
	        throw new Error("Property \"end\" missing in item ".concat(data.id));
	      }
	    }
	    return _this;
	  }

	  /**
	   * Check whether this item is visible inside given range
	   *
	   * @param {timeline.Range} range with a timestamp for start and end
	   * @returns {boolean} True if visible
	   */
	  _createClass(RangeItem, [{
	    key: "isVisible",
	    value: function isVisible(range) {
	      if (this.cluster) {
	        return false;
	      }
	      // determine visibility
	      return this.data.start < range.end && this.data.end > range.start;
	    }

	    /**
	     * create DOM elements
	     * @private
	     */
	  }, {
	    key: "_createDomElement",
	    value: function _createDomElement() {
	      if (!this.dom) {
	        // create DOM
	        this.dom = {};

	        // background box
	        this.dom.box = document.createElement('div');
	        // className is updated in redraw()

	        // frame box (to prevent the item contents from overflowing)
	        this.dom.frame = document.createElement('div');
	        this.dom.frame.className = 'vis-item-overflow';
	        this.dom.box.appendChild(this.dom.frame);

	        // visible frame box (showing the frame that is always visible)
	        this.dom.visibleFrame = document.createElement('div');
	        this.dom.visibleFrame.className = 'vis-item-visible-frame';
	        this.dom.box.appendChild(this.dom.visibleFrame);

	        // contents box
	        this.dom.content = document.createElement('div');
	        this.dom.content.className = 'vis-item-content';
	        this.dom.frame.appendChild(this.dom.content);

	        // attach this item as attribute
	        this.dom.box['vis-item'] = this;
	        this.dirty = true;
	      }
	    }

	    /**
	     * append element to DOM
	     * @private
	     */
	  }, {
	    key: "_appendDomElement",
	    value: function _appendDomElement() {
	      if (!this.parent) {
	        throw new Error('Cannot redraw item: no parent attached');
	      }
	      if (!this.dom.box.parentNode) {
	        var foreground = this.parent.dom.foreground;
	        if (!foreground) {
	          throw new Error('Cannot redraw item: parent has no foreground container element');
	        }
	        foreground.appendChild(this.dom.box);
	      }
	      this.displayed = true;
	    }

	    /**
	     * update dirty DOM components
	     * @private
	     */
	  }, {
	    key: "_updateDirtyDomComponents",
	    value: function _updateDirtyDomComponents() {
	      // update dirty DOM. An item is marked dirty when:
	      // - the item is not yet rendered
	      // - the item's data is changed
	      // - the item is selected/deselected
	      if (this.dirty) {
	        this._updateContents(this.dom.content);
	        this._updateDataAttributes(this.dom.box);
	        this._updateStyle(this.dom.box);
	        var editable = this.editable.updateTime || this.editable.updateGroup;

	        // update class
	        var className = (this.data.className ? ' ' + this.data.className : '') + (this.selected ? ' vis-selected' : '') + (editable ? ' vis-editable' : ' vis-readonly');
	        this.dom.box.className = this.baseClassName + className;

	        // turn off max-width to be able to calculate the real width
	        // this causes an extra browser repaint/reflow, but so be it
	        this.dom.content.style.maxWidth = 'none';
	      }
	    }

	    /**
	     * get DOM component sizes
	     * @return {object}
	     * @private
	     */
	  }, {
	    key: "_getDomComponentsSizes",
	    value: function _getDomComponentsSizes() {
	      // determine from css whether this box has overflow
	      this.overflow = window.getComputedStyle(this.dom.frame).overflow !== 'hidden';
	      this.whiteSpace = window.getComputedStyle(this.dom.content).whiteSpace !== 'nowrap';
	      return {
	        content: {
	          width: this.dom.content.offsetWidth
	        },
	        box: {
	          height: this.dom.box.offsetHeight
	        }
	      };
	    }

	    /**
	     * update DOM component sizes
	     * @param {array} sizes
	     * @private
	     */
	  }, {
	    key: "_updateDomComponentsSizes",
	    value: function _updateDomComponentsSizes(sizes) {
	      this.props.content.width = sizes.content.width;
	      this.height = sizes.box.height;
	      this.dom.content.style.maxWidth = '';
	      this.dirty = false;
	    }

	    /**
	     * repaint DOM additional components
	     * @private
	     */
	  }, {
	    key: "_repaintDomAdditionals",
	    value: function _repaintDomAdditionals() {
	      this._repaintOnItemUpdateTimeTooltip(this.dom.box);
	      this._repaintDeleteButton(this.dom.box);
	      this._repaintDragCenter();
	      this._repaintDragLeft();
	      this._repaintDragRight();
	    }

	    /**
	     * Repaint the item
	     * @param {boolean} [returnQueue=false]  return the queue
	     * @return {boolean} the redraw queue if returnQueue=true
	     */
	  }, {
	    key: "redraw",
	    value: function redraw(returnQueue) {
	      var _context,
	        _context2,
	        _context3,
	        _this2 = this,
	        _context6;
	      var sizes;
	      var queue = [
	      // create item DOM
	      _bindInstanceProperty(_context = this._createDomElement).call(_context, this),
	      // append DOM to parent DOM
	      _bindInstanceProperty(_context2 = this._appendDomElement).call(_context2, this),
	      // update dirty DOM 
	      _bindInstanceProperty(_context3 = this._updateDirtyDomComponents).call(_context3, this), function () {
	        if (_this2.dirty) {
	          var _context4;
	          sizes = _bindInstanceProperty(_context4 = _this2._getDomComponentsSizes).call(_context4, _this2)();
	        }
	      }, function () {
	        if (_this2.dirty) {
	          var _context5;
	          _bindInstanceProperty(_context5 = _this2._updateDomComponentsSizes).call(_context5, _this2)(sizes);
	        }
	      },
	      // repaint DOM additionals
	      _bindInstanceProperty(_context6 = this._repaintDomAdditionals).call(_context6, this)];
	      if (returnQueue) {
	        return queue;
	      } else {
	        var result;
	        _forEachInstanceProperty(queue).call(queue, function (fn) {
	          result = fn();
	        });
	        return result;
	      }
	    }

	    /**
	     * Show the item in the DOM (when not already visible). The items DOM will
	     * be created when needed.
	     * @param {boolean} [returnQueue=false]  whether to return a queue of functions to execute instead of just executing them
	     * @return {boolean} the redraw queue if returnQueue=true
	     */
	  }, {
	    key: "show",
	    value: function show(returnQueue) {
	      if (!this.displayed) {
	        return this.redraw(returnQueue);
	      }
	    }

	    /**
	     * Hide the item from the DOM (when visible)
	     */
	  }, {
	    key: "hide",
	    value: function hide() {
	      if (this.displayed) {
	        var box = this.dom.box;
	        if (box.parentNode) {
	          box.parentNode.removeChild(box);
	        }
	        this.displayed = false;
	      }
	    }

	    /**
	     * Reposition the item horizontally
	     * @param {boolean} [limitSize=true] If true (default), the width of the range
	     *                                   item will be limited, as the browser cannot
	     *                                   display very wide divs. This means though
	     *                                   that the applied left and width may
	     *                                   not correspond to the ranges start and end
	     * @Override
	     */
	  }, {
	    key: "repositionX",
	    value: function repositionX(limitSize) {
	      var parentWidth = this.parent.width;
	      var start = this.conversion.toScreen(this.data.start);
	      var end = this.conversion.toScreen(this.data.end);
	      var align = this.data.align === undefined ? this.options.align : this.data.align;
	      var contentStartPosition;
	      var contentWidth;

	      // limit the width of the range, as browsers cannot draw very wide divs
	      // unless limitSize: false is explicitly set in item data
	      if (this.data.limitSize !== false && (limitSize === undefined || limitSize === true)) {
	        if (start < -parentWidth) {
	          start = -parentWidth;
	        }
	        if (end > 2 * parentWidth) {
	          end = 2 * parentWidth;
	        }
	      }

	      //round to 3 decimals to compensate floating-point values rounding
	      var boxWidth = Math.max(Math.round((end - start) * 1000) / 1000, 1);
	      if (this.overflow) {
	        if (this.options.rtl) {
	          this.right = start;
	        } else {
	          this.left = start;
	        }
	        this.width = boxWidth + this.props.content.width;
	        contentWidth = this.props.content.width;

	        // Note: The calculation of width is an optimistic calculation, giving
	        //       a width which will not change when moving the Timeline
	        //       So no re-stacking needed, which is nicer for the eye;
	      } else {
	        if (this.options.rtl) {
	          this.right = start;
	        } else {
	          this.left = start;
	        }
	        this.width = boxWidth;
	        contentWidth = Math.min(end - start, this.props.content.width);
	      }
	      if (this.options.rtl) {
	        this.dom.box.style.transform = "translateX(".concat(this.right * -1, "px)");
	      } else {
	        this.dom.box.style.transform = "translateX(".concat(this.left, "px)");
	      }
	      this.dom.box.style.width = "".concat(boxWidth, "px");
	      if (this.whiteSpace) {
	        this.height = this.dom.box.offsetHeight;
	      }
	      switch (align) {
	        case 'left':
	          this.dom.content.style.transform = 'translateX(0)';
	          break;
	        case 'right':
	          if (this.options.rtl) {
	            var translateX = Math.max(boxWidth - contentWidth, 0) * -1;
	            this.dom.content.style.transform = "translateX(".concat(translateX, "px)");
	          } else {
	            this.dom.content.style.transform = "translateX(".concat(Math.max(boxWidth - contentWidth, 0), "px)");
	          }
	          break;
	        case 'center':
	          if (this.options.rtl) {
	            var _translateX = Math.max((boxWidth - contentWidth) / 2, 0) * -1;
	            this.dom.content.style.transform = "translateX(".concat(_translateX, "px)");
	          } else {
	            this.dom.content.style.transform = "translateX(".concat(Math.max((boxWidth - contentWidth) / 2, 0), "px)");
	          }
	          break;
	        default:
	          // 'auto'
	          // when range exceeds left of the window, position the contents at the left of the visible area
	          if (this.overflow) {
	            if (end > 0) {
	              contentStartPosition = Math.max(-start, 0);
	            } else {
	              contentStartPosition = -contentWidth; // ensure it's not visible anymore
	            }
	          } else {
	            if (start < 0) {
	              contentStartPosition = -start;
	            } else {
	              contentStartPosition = 0;
	            }
	          }
	          if (this.options.rtl) {
	            var _translateX2 = contentStartPosition * -1;
	            this.dom.content.style.transform = "translateX(".concat(_translateX2, "px)");
	          } else {
	            this.dom.content.style.transform = "translateX(".concat(contentStartPosition, "px)");
	            // this.dom.content.style.width = `calc(100% - ${contentStartPosition}px)`;
	          }
	      }
	    }

	    /**
	     * Reposition the item vertically
	     * @Override
	     */
	  }, {
	    key: "repositionY",
	    value: function repositionY() {
	      var orientation = this.options.orientation.item;
	      var box = this.dom.box;
	      if (orientation == 'top') {
	        box.style.top = "".concat(this.top, "px");
	      } else {
	        box.style.top = "".concat(this.parent.height - this.top - this.height, "px");
	      }
	    }

	    /**
	     * Repaint a drag area on the left side of the range when the range is selected
	     * @protected
	     */
	  }, {
	    key: "_repaintDragLeft",
	    value: function _repaintDragLeft() {
	      if ((this.selected || this.options.itemsAlwaysDraggable.range) && this.editable.updateTime && !this.dom.dragLeft) {
	        // create and show drag area
	        var dragLeft = document.createElement('div');
	        dragLeft.className = 'vis-drag-left';
	        dragLeft.dragLeftItem = this;
	        this.dom.box.appendChild(dragLeft);
	        this.dom.dragLeft = dragLeft;
	      } else if (!this.selected && !this.options.itemsAlwaysDraggable.range && this.dom.dragLeft) {
	        // delete drag area
	        if (this.dom.dragLeft.parentNode) {
	          this.dom.dragLeft.parentNode.removeChild(this.dom.dragLeft);
	        }
	        this.dom.dragLeft = null;
	      }
	    }

	    /**
	     * Repaint a drag area on the right side of the range when the range is selected
	     * @protected
	     */
	  }, {
	    key: "_repaintDragRight",
	    value: function _repaintDragRight() {
	      if ((this.selected || this.options.itemsAlwaysDraggable.range) && this.editable.updateTime && !this.dom.dragRight) {
	        // create and show drag area
	        var dragRight = document.createElement('div');
	        dragRight.className = 'vis-drag-right';
	        dragRight.dragRightItem = this;
	        this.dom.box.appendChild(dragRight);
	        this.dom.dragRight = dragRight;
	      } else if (!this.selected && !this.options.itemsAlwaysDraggable.range && this.dom.dragRight) {
	        // delete drag area
	        if (this.dom.dragRight.parentNode) {
	          this.dom.dragRight.parentNode.removeChild(this.dom.dragRight);
	        }
	        this.dom.dragRight = null;
	      }
	    }
	  }]);
	  return RangeItem;
	}(Item);
	RangeItem.prototype.baseClassName = 'vis-item vis-range';

	function _createSuper$4(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$4(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$4() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * @constructor BackgroundItem
	 * @extends Item
	 */
	var BackgroundItem = /*#__PURE__*/function (_Item) {
	  _inherits(BackgroundItem, _Item);
	  var _super = _createSuper$4(BackgroundItem);
	  /**
	  * @constructor BackgroundItem
	  * @param {Object} data             Object containing parameters start, end
	  *                                  content, className.
	  * @param {{toScreen: function, toTime: function}} conversion
	  *                                  Conversion functions from time to screen and vice versa
	  * @param {Object} [options]        Configuration options
	  *                                  // TODO: describe options
	  * // TODO: implement support for the BackgroundItem just having a start, then being displayed as a sort of an annotation
	  */
	  function BackgroundItem(data, conversion, options) {
	    var _this;
	    _classCallCheck(this, BackgroundItem);
	    _this = _super.call(this, data, conversion, options);
	    _this.props = {
	      content: {
	        width: 0
	      }
	    };
	    _this.overflow = false; // if contents can overflow (css styling), this flag is set to true

	    // validate data
	    if (data) {
	      if (data.start == undefined) {
	        throw new Error("Property \"start\" missing in item ".concat(data.id));
	      }
	      if (data.end == undefined) {
	        throw new Error("Property \"end\" missing in item ".concat(data.id));
	      }
	    }
	    return _this;
	  }

	  /**
	   * Check whether this item is visible inside given range
	   * @param {timeline.Range} range with a timestamp for start and end
	   * @returns {boolean} True if visible
	   */
	  _createClass(BackgroundItem, [{
	    key: "isVisible",
	    value: function isVisible(range) {
	      // determine visibility
	      return this.data.start < range.end && this.data.end > range.start;
	    }

	    /**
	     * create DOM element
	     * @private
	     */
	  }, {
	    key: "_createDomElement",
	    value: function _createDomElement() {
	      if (!this.dom) {
	        // create DOM
	        this.dom = {};

	        // background box
	        this.dom.box = document.createElement('div');
	        // className is updated in redraw()

	        // frame box (to prevent the item contents from overflowing
	        this.dom.frame = document.createElement('div');
	        this.dom.frame.className = 'vis-item-overflow';
	        this.dom.box.appendChild(this.dom.frame);

	        // contents box
	        this.dom.content = document.createElement('div');
	        this.dom.content.className = 'vis-item-content';
	        this.dom.frame.appendChild(this.dom.content);

	        // Note: we do NOT attach this item as attribute to the DOM,
	        //       such that background items cannot be selected
	        //this.dom.box['vis-item'] = this;

	        this.dirty = true;
	      }
	    }

	    /**
	     * append DOM element
	     * @private
	     */
	  }, {
	    key: "_appendDomElement",
	    value: function _appendDomElement() {
	      if (!this.parent) {
	        throw new Error('Cannot redraw item: no parent attached');
	      }
	      if (!this.dom.box.parentNode) {
	        var background = this.parent.dom.background;
	        if (!background) {
	          throw new Error('Cannot redraw item: parent has no background container element');
	        }
	        background.appendChild(this.dom.box);
	      }
	      this.displayed = true;
	    }

	    /**
	     * update DOM Dirty components
	     * @private
	     */
	  }, {
	    key: "_updateDirtyDomComponents",
	    value: function _updateDirtyDomComponents() {
	      // update dirty DOM. An item is marked dirty when:
	      // - the item is not yet rendered
	      // - the item's data is changed
	      // - the item is selected/deselected
	      if (this.dirty) {
	        this._updateContents(this.dom.content);
	        this._updateDataAttributes(this.dom.content);
	        this._updateStyle(this.dom.box);

	        // update class
	        var className = (this.data.className ? ' ' + this.data.className : '') + (this.selected ? ' vis-selected' : '');
	        this.dom.box.className = this.baseClassName + className;
	      }
	    }

	    /**
	     * get DOM components sizes
	     * @return {object}
	     * @private
	     */
	  }, {
	    key: "_getDomComponentsSizes",
	    value: function _getDomComponentsSizes() {
	      // determine from css whether this box has overflow
	      this.overflow = window.getComputedStyle(this.dom.content).overflow !== 'hidden';
	      return {
	        content: {
	          width: this.dom.content.offsetWidth
	        }
	      };
	    }

	    /**
	     * update DOM components sizes
	     * @param {object} sizes
	     * @private
	     */
	  }, {
	    key: "_updateDomComponentsSizes",
	    value: function _updateDomComponentsSizes(sizes) {
	      // recalculate size
	      this.props.content.width = sizes.content.width;
	      this.height = 0; // set height zero, so this item will be ignored when stacking items

	      this.dirty = false;
	    }

	    /**
	     * repaint DOM additionals
	     * @private
	     */
	  }, {
	    key: "_repaintDomAdditionals",
	    value: function _repaintDomAdditionals() {}

	    /**
	     * Repaint the item
	     * @param {boolean} [returnQueue=false]  return the queue
	     * @return {boolean} the redraw result or the redraw queue if returnQueue=true
	     */
	  }, {
	    key: "redraw",
	    value: function redraw(returnQueue) {
	      var _context,
	        _context2,
	        _context3,
	        _this2 = this,
	        _context6;
	      var sizes;
	      var queue = [
	      // create item DOM
	      _bindInstanceProperty(_context = this._createDomElement).call(_context, this),
	      // append DOM to parent DOM
	      _bindInstanceProperty(_context2 = this._appendDomElement).call(_context2, this), _bindInstanceProperty(_context3 = this._updateDirtyDomComponents).call(_context3, this), function () {
	        if (_this2.dirty) {
	          var _context4;
	          sizes = _bindInstanceProperty(_context4 = _this2._getDomComponentsSizes).call(_context4, _this2)();
	        }
	      }, function () {
	        if (_this2.dirty) {
	          var _context5;
	          _bindInstanceProperty(_context5 = _this2._updateDomComponentsSizes).call(_context5, _this2)(sizes);
	        }
	      },
	      // repaint DOM additionals
	      _bindInstanceProperty(_context6 = this._repaintDomAdditionals).call(_context6, this)];
	      if (returnQueue) {
	        return queue;
	      } else {
	        var result;
	        _forEachInstanceProperty(queue).call(queue, function (fn) {
	          result = fn();
	        });
	        return result;
	      }
	    }

	    /**
	     * Reposition the item vertically
	     * @Override
	     */
	  }, {
	    key: "repositionY",
	    value: function repositionY(margin) {
	      // eslint-disable-line no-unused-vars
	      var height;
	      var orientation = this.options.orientation.item;

	      // special positioning for subgroups
	      if (this.data.subgroup !== undefined) {
	        // TODO: instead of calculating the top position of the subgroups here for every BackgroundItem, calculate the top of the subgroup once in Itemset
	        var itemSubgroup = this.data.subgroup;
	        this.dom.box.style.height = "".concat(this.parent.subgroups[itemSubgroup].height, "px");
	        if (orientation == 'top') {
	          this.dom.box.style.top = "".concat(this.parent.top + this.parent.subgroups[itemSubgroup].top, "px");
	        } else {
	          this.dom.box.style.top = "".concat(this.parent.top + this.parent.height - this.parent.subgroups[itemSubgroup].top - this.parent.subgroups[itemSubgroup].height, "px");
	        }
	        this.dom.box.style.bottom = '';
	      }
	      // and in the case of no subgroups:
	      else {
	        // we want backgrounds with groups to only show in groups.
	        if (this.parent instanceof BackgroundGroup) {
	          // if the item is not in a group:
	          height = Math.max(this.parent.height, this.parent.itemSet.body.domProps.center.height, this.parent.itemSet.body.domProps.centerContainer.height);
	          this.dom.box.style.bottom = orientation == 'bottom' ? '0' : '';
	          this.dom.box.style.top = orientation == 'top' ? '0' : '';
	        } else {
	          height = this.parent.height;
	          // same alignment for items when orientation is top or bottom
	          this.dom.box.style.top = "".concat(this.parent.top, "px");
	          this.dom.box.style.bottom = '';
	        }
	      }
	      this.dom.box.style.height = "".concat(height, "px");
	    }
	  }]);
	  return BackgroundItem;
	}(Item);
	BackgroundItem.prototype.baseClassName = 'vis-item vis-background';
	BackgroundItem.prototype.stack = false;

	/**
	 * Show the item in the DOM (when not already visible). The items DOM will
	 * be created when needed.
	 */
	BackgroundItem.prototype.show = RangeItem.prototype.show;

	/**
	 * Hide the item from the DOM (when visible)
	 * @return {Boolean} changed
	 */
	BackgroundItem.prototype.hide = RangeItem.prototype.hide;

	/**
	 * Reposition the item horizontally
	 * @Override
	 */
	BackgroundItem.prototype.repositionX = RangeItem.prototype.repositionX;

	/**
	 * Popup is a class to create a popup window with some text
	 */
	var Popup = /*#__PURE__*/function () {
	  /**
	   * @param {Element} container       The container object.
	   * @param {string}  overflowMethod  How the popup should act to overflowing ('flip', 'cap' or 'none')
	   */
	  function Popup(container, overflowMethod) {
	    _classCallCheck(this, Popup);
	    this.container = container;
	    this.overflowMethod = overflowMethod || 'cap';
	    this.x = 0;
	    this.y = 0;
	    this.padding = 5;
	    this.hidden = false;

	    // create the frame
	    this.frame = document.createElement('div');
	    this.frame.className = 'vis-tooltip';
	    this.container.appendChild(this.frame);
	  }

	  /**
	   * @param {number} x   Horizontal position of the popup window
	   * @param {number} y   Vertical position of the popup window
	   */
	  _createClass(Popup, [{
	    key: "setPosition",
	    value: function setPosition(x, y) {
	      this.x = _parseInt(x);
	      this.y = _parseInt(y);
	    }

	    /**
	     * Set the content for the popup window. This can be HTML code or text.
	     * @param {string | Element} content
	     */
	  }, {
	    key: "setText",
	    value: function setText(content) {
	      if (content instanceof Element) {
	        this.frame.innerHTML = '';
	        this.frame.appendChild(content);
	      } else {
	        this.frame.innerHTML = availableUtils.xss(content); // string containing text or HTML
	      }
	    }

	    /**
	     * Show the popup window
	     * @param {boolean} [doShow]    Show or hide the window
	     */
	  }, {
	    key: "show",
	    value: function show(doShow) {
	      if (doShow === undefined) {
	        doShow = true;
	      }
	      if (doShow === true) {
	        var height = this.frame.clientHeight;
	        var width = this.frame.clientWidth;
	        var maxHeight = this.frame.parentNode.clientHeight;
	        var maxWidth = this.frame.parentNode.clientWidth;
	        var left = 0,
	          top = 0;
	        if (this.overflowMethod == 'flip' || this.overflowMethod == 'none') {
	          var isLeft = false,
	            isTop = true; // Where around the position it's located

	          if (this.overflowMethod == 'flip') {
	            if (this.y - height < this.padding) {
	              isTop = false;
	            }
	            if (this.x + width > maxWidth - this.padding) {
	              isLeft = true;
	            }
	          }
	          if (isLeft) {
	            left = this.x - width;
	          } else {
	            left = this.x;
	          }
	          if (isTop) {
	            top = this.y - height;
	          } else {
	            top = this.y;
	          }
	        } else {
	          // this.overflowMethod == 'cap'
	          top = this.y - height;
	          if (top + height + this.padding > maxHeight) {
	            top = maxHeight - height - this.padding;
	          }
	          if (top < this.padding) {
	            top = this.padding;
	          }
	          left = this.x;
	          if (left + width + this.padding > maxWidth) {
	            left = maxWidth - width - this.padding;
	          }
	          if (left < this.padding) {
	            left = this.padding;
	          }
	        }
	        this.frame.style.left = left + "px";
	        this.frame.style.top = top + "px";
	        this.frame.style.visibility = "visible";
	        this.hidden = false;
	      } else {
	        this.hide();
	      }
	    }

	    /**
	     * Hide the popup window
	     */
	  }, {
	    key: "hide",
	    value: function hide() {
	      this.hidden = true;
	      this.frame.style.left = "0";
	      this.frame.style.top = "0";
	      this.frame.style.visibility = "hidden";
	    }

	    /**
	     * Remove the popup window
	     */
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.frame.parentNode.removeChild(this.frame); // Remove element from DOM
	    }
	  }]);
	  return Popup;
	}();

	var everyExports = {};
	var every$3 = {
	  get exports(){ return everyExports; },
	  set exports(v){ everyExports = v; },
	};

	var $ = _export;
	var $every = arrayIteration.every;
	var arrayMethodIsStrict = arrayMethodIsStrict$6;

	var STRICT_METHOD = arrayMethodIsStrict('every');

	// `Array.prototype.every` method
	// https://tc39.es/ecma262/#sec-array.prototype.every
	$({ target: 'Array', proto: true, forced: !STRICT_METHOD }, {
	  every: function every(callbackfn /* , thisArg */) {
	    return $every(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var entryVirtual = entryVirtual$k;

	var every$2 = entryVirtual('Array').every;

	var isPrototypeOf = objectIsPrototypeOf;
	var method = every$2;

	var ArrayPrototype = Array.prototype;

	var every$1 = function (it) {
	  var own = it.every;
	  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.every) ? method : own;
	};

	var parent = every$1;

	var every = parent;

	(function (module) {
		module.exports = every;
	} (every$3));

	var _everyInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(everyExports);

	function _createForOfIteratorHelper$3(o, allowArrayLike) { var it = typeof _Symbol !== "undefined" && _getIteratorMethod(o) || o["@@iterator"]; if (!it) { if (_Array$isArray$1(o) || (it = _unsupportedIterableToArray$3(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
	function _unsupportedIterableToArray$3(o, minLen) { var _context14; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$3(o, minLen); var n = _sliceInstanceProperty(_context14 = Object.prototype.toString.call(o)).call(_context14, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return _Array$from$1(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$3(o, minLen); }
	function _arrayLikeToArray$3(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
	function _createSuper$3(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$3(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$3() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	/**
	 * ClusterItem
	 */
	var ClusterItem = /*#__PURE__*/function (_Item) {
	  _inherits(ClusterItem, _Item);
	  var _super = _createSuper$3(ClusterItem);
	  /**
	  * @constructor Item
	  * @param {Object} data             Object containing (optional) parameters type,
	  *                                  start, end, content, group, className.
	  * @param {{toScreen: function, toTime: function}} conversion
	  *                                  Conversion functions from time to screen and vice versa
	  * @param {Object} options          Configuration options
	  *                                  // TODO: describe available options
	  */
	  function ClusterItem(data, conversion, options) {
	    var _this;
	    _classCallCheck(this, ClusterItem);
	    var modifiedOptions = _Object$assign({}, {
	      fitOnDoubleClick: true
	    }, options, {
	      editable: false
	    });
	    _this = _super.call(this, data, conversion, modifiedOptions);
	    _this.props = {
	      content: {
	        width: 0,
	        height: 0
	      }
	    };
	    if (!data || data.uiItems == undefined) {
	      throw new Error('Property "uiItems" missing in item ' + data.id);
	    }
	    _this.id = v4();
	    _this.group = data.group;
	    _this._setupRange();
	    _this.emitter = _this.data.eventEmitter;
	    _this.range = _this.data.range;
	    _this.attached = false;
	    _this.isCluster = true;
	    _this.data.isCluster = true;
	    return _this;
	  }

	  /**
	   * check if there are items
	   * @return {boolean}
	   */
	  _createClass(ClusterItem, [{
	    key: "hasItems",
	    value: function hasItems() {
	      return this.data.uiItems && this.data.uiItems.length && this.attached;
	    }

	    /**
	     * set UI items
	     * @param {array} items
	     */
	  }, {
	    key: "setUiItems",
	    value: function setUiItems(items) {
	      this.detach();
	      this.data.uiItems = items;
	      this._setupRange();
	      this.attach();
	    }

	    /**
	     * check is visible
	     * @param {object} range
	     * @return {boolean}
	     */
	  }, {
	    key: "isVisible",
	    value: function isVisible(range) {
	      var rangeWidth = this.data.end ? this.data.end - this.data.start : 0;
	      var widthInMs = this.width * range.getMillisecondsPerPixel();
	      var end = Math.max(this.data.start.getTime() + rangeWidth, this.data.start.getTime() + widthInMs);
	      return this.data.start < range.end && end > range.start && this.hasItems();
	    }

	    /**
	     * get cluster data
	     * @return {object}
	     */
	  }, {
	    key: "getData",
	    value: function getData() {
	      return {
	        isCluster: true,
	        id: this.id,
	        items: this.data.items || [],
	        data: this.data
	      };
	    }

	    /**
	     * redraw cluster item
	     * @param {boolean} returnQueue
	     * @return {boolean}
	     */
	  }, {
	    key: "redraw",
	    value: function redraw(returnQueue) {
	      var _context, _context2, _context3, _context4, _context5, _context7;
	      var sizes;
	      var queue = [
	      // create item DOM
	      _bindInstanceProperty(_context = this._createDomElement).call(_context, this),
	      // append DOM to parent DOM
	      _bindInstanceProperty(_context2 = this._appendDomElement).call(_context2, this),
	      // update dirty DOM
	      _bindInstanceProperty(_context3 = this._updateDirtyDomComponents).call(_context3, this), _bindInstanceProperty(_context4 = function _context4() {
	        if (this.dirty) {
	          sizes = this._getDomComponentsSizes();
	        }
	      }).call(_context4, this), _bindInstanceProperty(_context5 = function _context5() {
	        if (this.dirty) {
	          var _context6;
	          _bindInstanceProperty(_context6 = this._updateDomComponentsSizes).call(_context6, this)(sizes);
	        }
	      }).call(_context5, this),
	      // repaint DOM additionals
	      _bindInstanceProperty(_context7 = this._repaintDomAdditionals).call(_context7, this)];
	      if (returnQueue) {
	        return queue;
	      } else {
	        var result;
	        _forEachInstanceProperty(queue).call(queue, function (fn) {
	          result = fn();
	        });
	        return result;
	      }
	    }

	    /**
	     * show cluster item
	     */
	  }, {
	    key: "show",
	    value: function show() {
	      if (!this.displayed) {
	        this.redraw();
	      }
	    }

	    /**
	     * Hide the item from the DOM (when visible)
	     */
	  }, {
	    key: "hide",
	    value: function hide() {
	      if (this.displayed) {
	        var dom = this.dom;
	        if (dom.box.parentNode) {
	          dom.box.parentNode.removeChild(dom.box);
	        }
	        if (this.options.showStipes) {
	          if (dom.line.parentNode) {
	            dom.line.parentNode.removeChild(dom.line);
	          }
	          if (dom.dot.parentNode) {
	            dom.dot.parentNode.removeChild(dom.dot);
	          }
	        }
	        this.displayed = false;
	      }
	    }

	    /**
	     * reposition item x axis
	     */
	  }, {
	    key: "repositionX",
	    value: function repositionX() {
	      var start = this.conversion.toScreen(this.data.start);
	      var end = this.data.end ? this.conversion.toScreen(this.data.end) : 0;
	      if (end) {
	        this.repositionXWithRanges(start, end);
	      } else {
	        var align = this.data.align === undefined ? this.options.align : this.data.align;
	        this.repositionXWithoutRanges(start, align);
	      }
	      if (this.options.showStipes) {
	        this.dom.line.style.display = this._isStipeVisible() ? 'block' : 'none';
	        this.dom.dot.style.display = this._isStipeVisible() ? 'block' : 'none';
	        if (this._isStipeVisible()) {
	          this.repositionStype(start, end);
	        }
	      }
	    }

	    /**
	     * reposition item stype
	     * @param {date} start
	     * @param {date} end
	     */
	  }, {
	    key: "repositionStype",
	    value: function repositionStype(start, end) {
	      this.dom.line.style.display = 'block';
	      this.dom.dot.style.display = 'block';
	      var lineOffsetWidth = this.dom.line.offsetWidth;
	      var dotOffsetWidth = this.dom.dot.offsetWidth;
	      if (end) {
	        var lineOffset = lineOffsetWidth + start + (end - start) / 2;
	        var dotOffset = lineOffset - dotOffsetWidth / 2;
	        var lineOffsetDirection = this.options.rtl ? lineOffset * -1 : lineOffset;
	        var dotOffsetDirection = this.options.rtl ? dotOffset * -1 : dotOffset;
	        this.dom.line.style.transform = "translateX(".concat(lineOffsetDirection, "px)");
	        this.dom.dot.style.transform = "translateX(".concat(dotOffsetDirection, "px)");
	      } else {
	        var _lineOffsetDirection = this.options.rtl ? start * -1 : start;
	        var _dotOffsetDirection = this.options.rtl ? (start - dotOffsetWidth / 2) * -1 : start - dotOffsetWidth / 2;
	        this.dom.line.style.transform = "translateX(".concat(_lineOffsetDirection, "px)");
	        this.dom.dot.style.transform = "translateX(".concat(_dotOffsetDirection, "px)");
	      }
	    }

	    /**
	     * reposition x without ranges
	     * @param {date} start
	     * @param {string} align
	     */
	  }, {
	    key: "repositionXWithoutRanges",
	    value: function repositionXWithoutRanges(start, align) {
	      // calculate left position of the box
	      if (align == 'right') {
	        if (this.options.rtl) {
	          this.right = start - this.width;

	          // reposition box, line, and dot
	          this.dom.box.style.right = this.right + 'px';
	        } else {
	          this.left = start - this.width;

	          // reposition box, line, and dot
	          this.dom.box.style.left = this.left + 'px';
	        }
	      } else if (align == 'left') {
	        if (this.options.rtl) {
	          this.right = start;

	          // reposition box, line, and dot
	          this.dom.box.style.right = this.right + 'px';
	        } else {
	          this.left = start;

	          // reposition box, line, and dot
	          this.dom.box.style.left = this.left + 'px';
	        }
	      } else {
	        // default or 'center'
	        if (this.options.rtl) {
	          this.right = start - this.width / 2;

	          // reposition box, line, and dot
	          this.dom.box.style.right = this.right + 'px';
	        } else {
	          this.left = start - this.width / 2;

	          // reposition box, line, and dot
	          this.dom.box.style.left = this.left + 'px';
	        }
	      }
	    }

	    /**
	     * reposition x with ranges
	     * @param {date} start
	     * @param {date} end
	     */
	  }, {
	    key: "repositionXWithRanges",
	    value: function repositionXWithRanges(start, end) {
	      var boxWidth = Math.round(Math.max(end - start + 0.5, 1));
	      if (this.options.rtl) {
	        this.right = start;
	      } else {
	        this.left = start;
	      }
	      this.width = Math.max(boxWidth, this.minWidth || 0);
	      if (this.options.rtl) {
	        this.dom.box.style.right = this.right + 'px';
	      } else {
	        this.dom.box.style.left = this.left + 'px';
	      }
	      this.dom.box.style.width = boxWidth + 'px';
	    }

	    /**
	     * reposition item y axis
	     */
	  }, {
	    key: "repositionY",
	    value: function repositionY() {
	      var orientation = this.options.orientation.item;
	      var box = this.dom.box;
	      if (orientation == 'top') {
	        box.style.top = (this.top || 0) + 'px';
	      } else {
	        // orientation 'bottom'
	        box.style.top = (this.parent.height - this.top - this.height || 0) + 'px';
	      }
	      if (this.options.showStipes) {
	        if (orientation == 'top') {
	          this.dom.line.style.top = '0';
	          this.dom.line.style.height = this.parent.top + this.top + 1 + 'px';
	          this.dom.line.style.bottom = '';
	        } else {
	          // orientation 'bottom'
	          var itemSetHeight = this.parent.itemSet.props.height;
	          var lineHeight = itemSetHeight - this.parent.top - this.parent.height + this.top;
	          this.dom.line.style.top = itemSetHeight - lineHeight + 'px';
	          this.dom.line.style.bottom = '0';
	        }
	        this.dom.dot.style.top = -this.dom.dot.offsetHeight / 2 + 'px';
	      }
	    }

	    /**
	     * get width left
	     * @return {number}
	     */
	  }, {
	    key: "getWidthLeft",
	    value: function getWidthLeft() {
	      return this.width / 2;
	    }

	    /**
	     * get width right
	     * @return {number}
	     */
	  }, {
	    key: "getWidthRight",
	    value: function getWidthRight() {
	      return this.width / 2;
	    }

	    /**
	     * move cluster item
	     */
	  }, {
	    key: "move",
	    value: function move() {
	      this.repositionX();
	      this.repositionY();
	    }

	    /**
	     * attach
	     */
	  }, {
	    key: "attach",
	    value: function attach() {
	      var _context8;
	      var _iterator = _createForOfIteratorHelper$3(this.data.uiItems),
	        _step;
	      try {
	        for (_iterator.s(); !(_step = _iterator.n()).done;) {
	          var item = _step.value;
	          item.cluster = this;
	        }
	      } catch (err) {
	        _iterator.e(err);
	      } finally {
	        _iterator.f();
	      }
	      this.data.items = _mapInstanceProperty(_context8 = this.data.uiItems).call(_context8, function (item) {
	        return item.data;
	      });
	      this.attached = true;
	      this.dirty = true;
	    }

	    /**
	     * detach
	     * @param {boolean} detachFromParent
	     * @return {void}
	     */
	  }, {
	    key: "detach",
	    value: function detach() {
	      var detachFromParent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
	      if (!this.hasItems()) {
	        return;
	      }
	      var _iterator2 = _createForOfIteratorHelper$3(this.data.uiItems),
	        _step2;
	      try {
	        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
	          var item = _step2.value;
	          delete item.cluster;
	        }
	      } catch (err) {
	        _iterator2.e(err);
	      } finally {
	        _iterator2.f();
	      }
	      this.attached = false;
	      if (detachFromParent && this.group) {
	        this.group.remove(this);
	        this.group = null;
	      }
	      this.data.items = [];
	      this.dirty = true;
	    }

	    /**
	     * handle on double click
	     */
	  }, {
	    key: "_onDoubleClick",
	    value: function _onDoubleClick() {
	      this._fit();
	    }

	    /**
	     * set range
	     */
	  }, {
	    key: "_setupRange",
	    value: function _setupRange() {
	      var _context9, _context10, _context11;
	      var stats = _mapInstanceProperty(_context9 = this.data.uiItems).call(_context9, function (item) {
	        return {
	          start: item.data.start.valueOf(),
	          end: item.data.end ? item.data.end.valueOf() : item.data.start.valueOf()
	        };
	      });
	      this.data.min = Math.min.apply(Math, _toConsumableArray(_mapInstanceProperty(stats).call(stats, function (s) {
	        return Math.min(s.start, s.end || s.start);
	      })));
	      this.data.max = Math.max.apply(Math, _toConsumableArray(_mapInstanceProperty(stats).call(stats, function (s) {
	        return Math.max(s.start, s.end || s.start);
	      })));
	      var centers = _mapInstanceProperty(_context10 = this.data.uiItems).call(_context10, function (item) {
	        return item.center;
	      });
	      var avg = _reduceInstanceProperty(centers).call(centers, function (sum, value) {
	        return sum + value;
	      }, 0) / this.data.uiItems.length;
	      if (_someInstanceProperty(_context11 = this.data.uiItems).call(_context11, function (item) {
	        return item.data.end;
	      })) {
	        // contains ranges
	        this.data.start = new Date(this.data.min);
	        this.data.end = new Date(this.data.max);
	      } else {
	        this.data.start = new Date(avg);
	        this.data.end = null;
	      }
	    }

	    /**
	     * get UI items
	     * @return {array}
	     */
	  }, {
	    key: "_getUiItems",
	    value: function _getUiItems() {
	      var _this2 = this;
	      if (this.data.uiItems && this.data.uiItems.length) {
	        var _context12;
	        return _filterInstanceProperty(_context12 = this.data.uiItems).call(_context12, function (item) {
	          return item.cluster === _this2;
	        });
	      }
	      return [];
	    }

	    /**
	     * create DOM element
	     */
	  }, {
	    key: "_createDomElement",
	    value: function _createDomElement() {
	      if (!this.dom) {
	        // create DOM
	        this.dom = {};

	        // create main box
	        this.dom.box = document.createElement('DIV');

	        // contents box (inside the background box). used for making margins
	        this.dom.content = document.createElement('DIV');
	        this.dom.content.className = 'vis-item-content';
	        this.dom.box.appendChild(this.dom.content);
	        if (this.options.showStipes) {
	          // line to axis
	          this.dom.line = document.createElement('DIV');
	          this.dom.line.className = 'vis-cluster-line';
	          this.dom.line.style.display = 'none';

	          // dot on axis
	          this.dom.dot = document.createElement('DIV');
	          this.dom.dot.className = 'vis-cluster-dot';
	          this.dom.dot.style.display = 'none';
	        }
	        if (this.options.fitOnDoubleClick) {
	          var _context13;
	          this.dom.box.ondblclick = _bindInstanceProperty(_context13 = ClusterItem.prototype._onDoubleClick).call(_context13, this);
	        }

	        // attach this item as attribute
	        this.dom.box['vis-item'] = this;
	        this.dirty = true;
	      }
	    }

	    /**
	     * append element to DOM
	     */
	  }, {
	    key: "_appendDomElement",
	    value: function _appendDomElement() {
	      if (!this.parent) {
	        throw new Error('Cannot redraw item: no parent attached');
	      }
	      if (!this.dom.box.parentNode) {
	        var foreground = this.parent.dom.foreground;
	        if (!foreground) {
	          throw new Error('Cannot redraw item: parent has no foreground container element');
	        }
	        foreground.appendChild(this.dom.box);
	      }
	      var background = this.parent.dom.background;
	      if (this.options.showStipes) {
	        if (!this.dom.line.parentNode) {
	          if (!background) throw new Error('Cannot redraw item: parent has no background container element');
	          background.appendChild(this.dom.line);
	        }
	        if (!this.dom.dot.parentNode) {
	          var axis = this.parent.dom.axis;
	          if (!background) throw new Error('Cannot redraw item: parent has no axis container element');
	          axis.appendChild(this.dom.dot);
	        }
	      }
	      this.displayed = true;
	    }

	    /**
	     * update dirty DOM components
	     */
	  }, {
	    key: "_updateDirtyDomComponents",
	    value: function _updateDirtyDomComponents() {
	      // An item is marked dirty when:
	      // - the item is not yet rendered
	      // - the item's data is changed
	      // - the item is selected/deselected
	      if (this.dirty) {
	        this._updateContents(this.dom.content);
	        this._updateDataAttributes(this.dom.box);
	        this._updateStyle(this.dom.box);

	        // update class
	        var className = this.baseClassName + ' ' + (this.data.className ? ' ' + this.data.className : '') + (this.selected ? ' vis-selected' : '') + ' vis-readonly';
	        this.dom.box.className = 'vis-item ' + className;
	        if (this.options.showStipes) {
	          this.dom.line.className = 'vis-item vis-cluster-line ' + (this.selected ? ' vis-selected' : '');
	          this.dom.dot.className = 'vis-item vis-cluster-dot ' + (this.selected ? ' vis-selected' : '');
	        }
	        if (this.data.end) {
	          // turn off max-width to be able to calculate the real width
	          // this causes an extra browser repaint/reflow, but so be it
	          this.dom.content.style.maxWidth = 'none';
	        }
	      }
	    }

	    /**
	     * get DOM components sizes
	     * @return {object}
	     */
	  }, {
	    key: "_getDomComponentsSizes",
	    value: function _getDomComponentsSizes() {
	      var sizes = {
	        previous: {
	          right: this.dom.box.style.right,
	          left: this.dom.box.style.left
	        },
	        box: {
	          width: this.dom.box.offsetWidth,
	          height: this.dom.box.offsetHeight
	        }
	      };
	      if (this.options.showStipes) {
	        sizes.dot = {
	          height: this.dom.dot.offsetHeight,
	          width: this.dom.dot.offsetWidth
	        };
	        sizes.line = {
	          width: this.dom.line.offsetWidth
	        };
	      }
	      return sizes;
	    }

	    /**
	     * update DOM components sizes
	     * @param {object} sizes
	     */
	  }, {
	    key: "_updateDomComponentsSizes",
	    value: function _updateDomComponentsSizes(sizes) {
	      if (this.options.rtl) {
	        this.dom.box.style.right = "0px";
	      } else {
	        this.dom.box.style.left = "0px";
	      }

	      // recalculate size
	      if (!this.data.end) {
	        this.width = sizes.box.width;
	      } else {
	        this.minWidth = sizes.box.width;
	      }
	      this.height = sizes.box.height;

	      // restore previous position
	      if (this.options.rtl) {
	        this.dom.box.style.right = sizes.previous.right;
	      } else {
	        this.dom.box.style.left = sizes.previous.left;
	      }
	      this.dirty = false;
	    }

	    /**
	     * repaint DOM additional components
	     */
	  }, {
	    key: "_repaintDomAdditionals",
	    value: function _repaintDomAdditionals() {
	      this._repaintOnItemUpdateTimeTooltip(this.dom.box);
	    }

	    /**
	     * check is stripe visible
	     * @return {number}
	     * @private
	     */
	  }, {
	    key: "_isStipeVisible",
	    value: function _isStipeVisible() {
	      return this.minWidth >= this.width || !this.data.end;
	    }

	    /**
	     * get fit range
	     * @return {object}
	     * @private
	     */
	  }, {
	    key: "_getFitRange",
	    value: function _getFitRange() {
	      var offset = 0.05 * (this.data.max - this.data.min) / 2;
	      return {
	        fitStart: this.data.min - offset,
	        fitEnd: this.data.max + offset
	      };
	    }

	    /**
	    * fit
	    * @private
	    */
	  }, {
	    key: "_fit",
	    value: function _fit() {
	      if (this.emitter) {
	        var _this$_getFitRange = this._getFitRange(),
	          fitStart = _this$_getFitRange.fitStart,
	          fitEnd = _this$_getFitRange.fitEnd;
	        var fitArgs = {
	          start: new Date(fitStart),
	          end: new Date(fitEnd),
	          animation: true
	        };
	        this.emitter.emit('fit', fitArgs);
	      }
	    }

	    /**
	    * get item data
	    * @return {object}
	    * @private
	    */
	  }, {
	    key: "_getItemData",
	    value: function _getItemData() {
	      return this.data;
	    }
	  }]);
	  return ClusterItem;
	}(Item);
	ClusterItem.prototype.baseClassName = 'vis-item vis-range vis-cluster';

	function _createForOfIteratorHelper$2(o, allowArrayLike) { var it = typeof _Symbol !== "undefined" && _getIteratorMethod(o) || o["@@iterator"]; if (!it) { if (_Array$isArray$1(o) || (it = _unsupportedIterableToArray$2(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
	function _unsupportedIterableToArray$2(o, minLen) { var _context4; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$2(o, minLen); var n = _sliceInstanceProperty(_context4 = Object.prototype.toString.call(o)).call(_context4, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return _Array$from$1(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$2(o, minLen); }
	function _arrayLikeToArray$2(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
	var UNGROUPED$2 = '__ungrouped__'; // reserved group id for ungrouped items
	var BACKGROUND$1 = '__background__'; // reserved group id for background items without group

	var ReservedGroupIds = {
	  UNGROUPED: UNGROUPED$2,
	  BACKGROUND: BACKGROUND$1
	};

	/**
	 * An Cluster generator generates cluster items
	 */
	var ClusterGenerator = /*#__PURE__*/function () {
	  /**
	   * @param {ItemSet} itemSet itemsSet instance
	   * @constructor ClusterGenerator
	  */
	  function ClusterGenerator(itemSet) {
	    _classCallCheck(this, ClusterGenerator);
	    this.itemSet = itemSet;
	    this.groups = {};
	    this.cache = {};
	    this.cache[-1] = [];
	  }

	  /**
	   * @param {Object} itemData             Object containing parameters start content, className.
	   * @param {{toScreen: function, toTime: function}} conversion
	   *                                  Conversion functions from time to screen and vice versa
	   * @param {Object} [options]        Configuration options
	   * @return {Object} newItem
	  */
	  _createClass(ClusterGenerator, [{
	    key: "createClusterItem",
	    value: function createClusterItem(itemData, conversion, options) {
	      var newItem = new ClusterItem(itemData, conversion, options);
	      return newItem;
	    }

	    /**
	     * Set the items to be clustered.
	     * This will clear cached clusters.
	     * @param {Item[]} items
	     * @param {Object} [options]  Available options:
	     *                            {boolean} applyOnChangedLevel
	     *                                If true (default), the changed data is applied
	     *                                as soon the cluster level changes. If false,
	     *                                The changed data is applied immediately
	     */
	  }, {
	    key: "setItems",
	    value: function setItems(items, options) {
	      this.items = items || [];
	      this.dataChanged = true;
	      this.applyOnChangedLevel = false;
	      if (options && options.applyOnChangedLevel) {
	        this.applyOnChangedLevel = options.applyOnChangedLevel;
	      }
	    }

	    /**
	     * Update the current data set: clear cache, and recalculate the clustering for
	     * the current level
	     */
	  }, {
	    key: "updateData",
	    value: function updateData() {
	      this.dataChanged = true;
	      this.applyOnChangedLevel = false;
	    }

	    /**
	     * Cluster the items which are too close together
	     * @param {array} oldClusters 
	     * @param {number} scale      The scale of the current window : (windowWidth / (endDate - startDate)) 
	     * @param {{maxItems: number, clusterCriteria: function, titleTemplate: string}} options             
	     * @return {array} clusters
	    */
	  }, {
	    key: "getClusters",
	    value: function getClusters(oldClusters, scale, options) {
	      var _ref = typeof options === "boolean" ? {} : options,
	        maxItems = _ref.maxItems,
	        clusterCriteria = _ref.clusterCriteria;
	      if (!clusterCriteria) {
	        clusterCriteria = function clusterCriteria() {
	          return true;
	        };
	      }
	      maxItems = maxItems || 1;
	      var level = -1;
	      var granularity = 2;
	      var timeWindow = 0;
	      if (scale > 0) {
	        if (scale >= 1) {
	          return [];
	        }
	        level = Math.abs(Math.round(Math.log(100 / scale) / Math.log(granularity)));
	        timeWindow = Math.abs(Math.pow(granularity, level));
	      }

	      // clear the cache when and re-generate groups the data when needed.
	      if (this.dataChanged) {
	        var levelChanged = level != this.cacheLevel;
	        var applyDataNow = this.applyOnChangedLevel ? levelChanged : true;
	        if (applyDataNow) {
	          this._dropLevelsCache();
	          this._filterData();
	        }
	      }
	      this.cacheLevel = level;
	      var clusters = this.cache[level];
	      if (!clusters) {
	        clusters = [];
	        for (var groupName in this.groups) {
	          if (this.groups.hasOwnProperty(groupName)) {
	            var items = this.groups[groupName];
	            var iMax = items.length;
	            var i = 0;
	            while (i < iMax) {
	              // find all items around current item, within the timeWindow
	              var item = items[i];
	              var neighbors = 1; // start at 1, to include itself)

	              // loop through items left from the current item
	              var j = i - 1;
	              while (j >= 0 && item.center - items[j].center < timeWindow / 2) {
	                if (!items[j].cluster && clusterCriteria(item.data, items[j].data)) {
	                  neighbors++;
	                }
	                j--;
	              }

	              // loop through items right from the current item
	              var k = i + 1;
	              while (k < items.length && items[k].center - item.center < timeWindow / 2) {
	                if (clusterCriteria(item.data, items[k].data)) {
	                  neighbors++;
	                }
	                k++;
	              }

	              // loop through the created clusters
	              var l = clusters.length - 1;
	              while (l >= 0 && item.center - clusters[l].center < timeWindow) {
	                if (item.group == clusters[l].group && clusterCriteria(item.data, clusters[l].data)) {
	                  neighbors++;
	                }
	                l--;
	              }

	              // aggregate until the number of items is within maxItems
	              if (neighbors > maxItems) {
	                // too busy in this window.
	                var num = neighbors - maxItems + 1;
	                var clusterItems = [];

	                // append the items to the cluster,
	                // and calculate the average start for the cluster
	                var m = i;
	                while (clusterItems.length < num && m < items.length) {
	                  if (clusterCriteria(items[i].data, items[m].data)) {
	                    clusterItems.push(items[m]);
	                  }
	                  m++;
	                }
	                var groupId = this.itemSet.getGroupId(item.data);
	                var group = this.itemSet.groups[groupId] || this.itemSet.groups[ReservedGroupIds.UNGROUPED];
	                var cluster = this._getClusterForItems(clusterItems, group, oldClusters, options);
	                clusters.push(cluster);
	                i += num;
	              } else {
	                delete item.cluster;
	                i += 1;
	              }
	            }
	          }
	        }
	        this.cache[level] = clusters;
	      }
	      return clusters;
	    }

	    /**
	     * Filter the items per group.
	     * @private
	     */
	  }, {
	    key: "_filterData",
	    value: function _filterData() {
	      // filter per group
	      var groups = {};
	      this.groups = groups;

	      // split the items per group
	      for (var _i = 0, _Object$values = _Object$values2(this.items); _i < _Object$values.length; _i++) {
	        var item = _Object$values[_i];
	        // put the item in the correct group
	        var groupName = item.parent ? item.parent.groupId : '';
	        var group = groups[groupName];
	        if (!group) {
	          group = [];
	          groups[groupName] = group;
	        }
	        group.push(item);

	        // calculate the center of the item
	        if (item.data.start) {
	          if (item.data.end) {
	            // range
	            item.center = (item.data.start.valueOf() + item.data.end.valueOf()) / 2;
	          } else {
	            // box, dot
	            item.center = item.data.start.valueOf();
	          }
	        }
	      }

	      // sort the items per group
	      for (var currentGroupName in groups) {
	        if (groups.hasOwnProperty(currentGroupName)) {
	          var _context;
	          _sortInstanceProperty(_context = groups[currentGroupName]).call(_context, function (a, b) {
	            return a.center - b.center;
	          });
	        }
	      }
	      this.dataChanged = false;
	    }

	    /**
	     * Create new cluster or return existing
	     * @private
	     * @param {array} clusterItems    
	     * @param {object} group 
	     * @param {array} oldClusters 
	     * @param {object} options 
	     * @returns {object} cluster
	     */
	  }, {
	    key: "_getClusterForItems",
	    value: function _getClusterForItems(clusterItems, group, oldClusters, options) {
	      var _context2;
	      var oldClustersLookup = _mapInstanceProperty(_context2 = oldClusters || []).call(_context2, function (cluster) {
	        var _context3;
	        return {
	          cluster: cluster,
	          itemsIds: new _Set(_mapInstanceProperty(_context3 = cluster.data.uiItems).call(_context3, function (item) {
	            return item.id;
	          }))
	        };
	      });
	      var cluster;
	      if (oldClustersLookup.length) {
	        var _iterator = _createForOfIteratorHelper$2(oldClustersLookup),
	          _step;
	        try {
	          var _loop = function _loop() {
	            var oldClusterData = _step.value;
	            if (oldClusterData.itemsIds.size === clusterItems.length && _everyInstanceProperty(clusterItems).call(clusterItems, function (clusterItem) {
	              return oldClusterData.itemsIds.has(clusterItem.id);
	            })) {
	              cluster = oldClusterData.cluster;
	              return "break";
	            }
	          };
	          for (_iterator.s(); !(_step = _iterator.n()).done;) {
	            var _ret = _loop();
	            if (_ret === "break") break;
	          }
	        } catch (err) {
	          _iterator.e(err);
	        } finally {
	          _iterator.f();
	        }
	      }
	      if (cluster) {
	        cluster.setUiItems(clusterItems);
	        if (cluster.group !== group) {
	          if (cluster.group) {
	            cluster.group.remove(cluster);
	          }
	          if (group) {
	            group.add(cluster);
	            cluster.group = group;
	          }
	        }
	        return cluster;
	      }
	      var titleTemplate = options.titleTemplate || '';
	      var conversion = {
	        toScreen: this.itemSet.body.util.toScreen,
	        toTime: this.itemSet.body.util.toTime
	      };
	      var title = titleTemplate.replace(/{count}/, clusterItems.length);
	      var clusterContent = '<div title="' + title + '">' + clusterItems.length + '</div>';
	      var clusterOptions = _Object$assign({}, options, this.itemSet.options);
	      var data = {
	        'content': clusterContent,
	        'title': title,
	        'group': group,
	        'uiItems': clusterItems,
	        'eventEmitter': this.itemSet.body.emitter,
	        'range': this.itemSet.body.range
	      };
	      cluster = this.createClusterItem(data, conversion, clusterOptions);
	      if (group) {
	        group.add(cluster);
	        cluster.group = group;
	      }
	      cluster.attach();
	      return cluster;
	    }

	    /**
	     * Drop cache
	     * @private
	     */
	  }, {
	    key: "_dropLevelsCache",
	    value: function _dropLevelsCache() {
	      this.cache = {};
	      this.cacheLevel = -1;
	      this.cache[this.cacheLevel] = [];
	    }
	  }]);
	  return ClusterGenerator;
	}();

	function _createForOfIteratorHelper$1(o, allowArrayLike) { var it = typeof _Symbol !== "undefined" && _getIteratorMethod(o) || o["@@iterator"]; if (!it) { if (_Array$isArray$1(o) || (it = _unsupportedIterableToArray$1(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
	function _unsupportedIterableToArray$1(o, minLen) { var _context34; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$1(o, minLen); var n = _sliceInstanceProperty(_context34 = Object.prototype.toString.call(o)).call(_context34, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return _Array$from$1(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$1(o, minLen); }
	function _arrayLikeToArray$1(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
	function _createSuper$2(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = _Reflect$construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
	function _isNativeReflectConstruct$2() { if (typeof Reflect === "undefined" || !_Reflect$construct) return false; if (_Reflect$construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(_Reflect$construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var UNGROUPED$1 = '__ungrouped__'; // reserved group id for ungrouped items
	var BACKGROUND = '__background__'; // reserved group id for background items without group

	/**
	 * An ItemSet holds a set of items and ranges which can be displayed in a
	 * range. The width is determined by the parent of the ItemSet, and the height
	 * is determined by the size of the items.
	 */
	var ItemSet = /*#__PURE__*/function (_Component) {
	  _inherits(ItemSet, _Component);
	  var _super = _createSuper$2(ItemSet);
	  /**
	  * @param {{dom: Object, domProps: Object, emitter: Emitter, range: Range}} body
	  * @param {Object} [options]      See ItemSet.setOptions for the available options.
	  * @constructor ItemSet
	  * @extends Component
	  */
	  function ItemSet(body, options) {
	    var _this;
	    _classCallCheck(this, ItemSet);
	    _this = _super.call(this);
	    _this.body = body;
	    _this.defaultOptions = {
	      type: null,
	      // 'box', 'point', 'range', 'background'
	      orientation: {
	        item: 'bottom' // item orientation: 'top' or 'bottom'
	      },

	      align: 'auto',
	      // alignment of box items
	      stack: true,
	      stackSubgroups: true,
	      groupOrderSwap: function groupOrderSwap(fromGroup, toGroup, groups) {
	        // eslint-disable-line no-unused-vars
	        var targetOrder = toGroup.order;
	        toGroup.order = fromGroup.order;
	        fromGroup.order = targetOrder;
	      },
	      groupOrder: 'order',
	      selectable: true,
	      multiselect: false,
	      longSelectPressTime: 251,
	      itemsAlwaysDraggable: {
	        item: false,
	        range: false
	      },
	      editable: {
	        updateTime: false,
	        updateGroup: false,
	        add: false,
	        remove: false,
	        overrideItems: false
	      },
	      groupEditable: {
	        order: false,
	        add: false,
	        remove: false
	      },
	      snap: TimeStep.snap,
	      // Only called when `objectData.target === 'item'.
	      onDropObjectOnItem: function onDropObjectOnItem(objectData, item, callback) {
	        callback(item);
	      },
	      onAdd: function onAdd(item, callback) {
	        callback(item);
	      },
	      onUpdate: function onUpdate(item, callback) {
	        callback(item);
	      },
	      onMove: function onMove(item, callback) {
	        callback(item);
	      },
	      onRemove: function onRemove(item, callback) {
	        callback(item);
	      },
	      onMoving: function onMoving(item, callback) {
	        callback(item);
	      },
	      onAddGroup: function onAddGroup(item, callback) {
	        callback(item);
	      },
	      onMoveGroup: function onMoveGroup(item, callback) {
	        callback(item);
	      },
	      onRemoveGroup: function onRemoveGroup(item, callback) {
	        callback(item);
	      },
	      margin: {
	        item: {
	          horizontal: 10,
	          vertical: 10
	        },
	        axis: 20
	      },
	      showTooltips: true,
	      tooltip: {
	        followMouse: false,
	        overflowMethod: 'flip',
	        delay: 500
	      },
	      tooltipOnItemUpdateTime: false
	    };

	    // options is shared by this ItemSet and all its items
	    _this.options = availableUtils.extend({}, _this.defaultOptions);
	    _this.options.rtl = options.rtl;
	    _this.options.onTimeout = options.onTimeout;
	    _this.conversion = {
	      toScreen: body.util.toScreen,
	      toTime: body.util.toTime
	    };
	    _this.dom = {};
	    _this.props = {};
	    _this.hammer = null;
	    var me = _assertThisInitialized$1(_this);
	    _this.itemsData = null; // DataSet
	    _this.groupsData = null; // DataSet
	    _this.itemsSettingTime = null;
	    _this.initialItemSetDrawn = false;
	    _this.userContinueNotBail = null;
	    _this.sequentialSelection = false;

	    // listeners for the DataSet of the items
	    _this.itemListeners = {
	      'add': function add(event, params, senderId) {
	        // eslint-disable-line no-unused-vars
	        me._onAdd(params.items);
	        if (me.options.cluster) {
	          me.clusterGenerator.setItems(me.items, {
	            applyOnChangedLevel: false
	          });
	        }
	        me.redraw();
	      },
	      'update': function update(event, params, senderId) {
	        // eslint-disable-line no-unused-vars
	        me._onUpdate(params.items);
	        if (me.options.cluster) {
	          me.clusterGenerator.setItems(me.items, {
	            applyOnChangedLevel: false
	          });
	        }
	        me.redraw();
	      },
	      'remove': function remove(event, params, senderId) {
	        // eslint-disable-line no-unused-vars
	        me._onRemove(params.items);
	        if (me.options.cluster) {
	          me.clusterGenerator.setItems(me.items, {
	            applyOnChangedLevel: false
	          });
	        }
	        me.redraw();
	      }
	    };

	    // listeners for the DataSet of the groups
	    _this.groupListeners = {
	      'add': function add(event, params, senderId) {
	        // eslint-disable-line no-unused-vars
	        me._onAddGroups(params.items);
	        if (me.groupsData && me.groupsData.length > 0) {
	          var _context;
	          var groupsData = me.groupsData.getDataSet();
	          _forEachInstanceProperty(_context = groupsData.get()).call(_context, function (groupData) {
	            if (groupData.nestedGroups) {
	              var _context2;
	              if (groupData.showNested != false) {
	                groupData.showNested = true;
	              }
	              var updatedGroups = [];
	              _forEachInstanceProperty(_context2 = groupData.nestedGroups).call(_context2, function (nestedGroupId) {
	                var updatedNestedGroup = groupsData.get(nestedGroupId);
	                if (!updatedNestedGroup) {
	                  return;
	                }
	                updatedNestedGroup.nestedInGroup = groupData.id;
	                if (groupData.showNested == false) {
	                  updatedNestedGroup.visible = false;
	                }
	                updatedGroups = _concatInstanceProperty(updatedGroups).call(updatedGroups, updatedNestedGroup);
	              });
	              groupsData.update(updatedGroups, senderId);
	            }
	          });
	        }
	      },
	      'update': function update(event, params, senderId) {
	        // eslint-disable-line no-unused-vars
	        me._onUpdateGroups(params.items);
	      },
	      'remove': function remove(event, params, senderId) {
	        // eslint-disable-line no-unused-vars
	        me._onRemoveGroups(params.items);
	      }
	    };
	    _this.items = {}; // object with an Item for every data item
	    _this.groups = {}; // Group object for every group
	    _this.groupIds = [];
	    _this.selection = []; // list with the ids of all selected nodes

	    _this.popup = null;
	    _this.popupTimer = null;
	    _this.touchParams = {}; // stores properties while dragging
	    _this.groupTouchParams = {
	      group: null,
	      isDragging: false
	    };

	    // create the HTML DOM
	    _this._create();
	    _this.setOptions(options);
	    _this.clusters = [];
	    return _this;
	  }

	  /**
	   * Create the HTML DOM for the ItemSet
	   */
	  _createClass(ItemSet, [{
	    key: "_create",
	    value: function _create() {
	      var _this2 = this,
	        _context3,
	        _context4,
	        _context5,
	        _context6,
	        _context7,
	        _context8,
	        _context9,
	        _context10,
	        _context11,
	        _context12,
	        _context13,
	        _context14,
	        _context15,
	        _context16,
	        _context17;
	      var frame = document.createElement('div');
	      frame.className = 'vis-itemset';
	      frame['vis-itemset'] = this;
	      this.dom.frame = frame;

	      // create background panel
	      var background = document.createElement('div');
	      background.className = 'vis-background';
	      frame.appendChild(background);
	      this.dom.background = background;

	      // create foreground panel
	      var foreground = document.createElement('div');
	      foreground.className = 'vis-foreground';
	      frame.appendChild(foreground);
	      this.dom.foreground = foreground;

	      // create axis panel
	      var axis = document.createElement('div');
	      axis.className = 'vis-axis';
	      this.dom.axis = axis;

	      // create labelset
	      var labelSet = document.createElement('div');
	      labelSet.className = 'vis-labelset';
	      this.dom.labelSet = labelSet;

	      // create ungrouped Group
	      this._updateUngrouped();

	      // create background Group
	      var backgroundGroup = new BackgroundGroup(BACKGROUND, null, this);
	      backgroundGroup.show();
	      this.groups[BACKGROUND] = backgroundGroup;

	      // attach event listeners
	      // Note: we bind to the centerContainer for the case where the height
	      //       of the center container is larger than of the ItemSet, so we
	      //       can click in the empty area to create a new item or deselect an item.
	      this.hammer = new Hammer(this.body.dom.centerContainer);

	      // drag items when selected
	      this.hammer.on('hammer.input', function (event) {
	        if (event.isFirst) {
	          _this2._onTouch(event);
	        }
	      });
	      this.hammer.on('panstart', _bindInstanceProperty(_context3 = this._onDragStart).call(_context3, this));
	      this.hammer.on('panmove', _bindInstanceProperty(_context4 = this._onDrag).call(_context4, this));
	      this.hammer.on('panend', _bindInstanceProperty(_context5 = this._onDragEnd).call(_context5, this));
	      this.hammer.get('pan').set({
	        threshold: 5,
	        direction: Hammer.ALL
	      });
	      // delay addition on item click for trackpads...
	      this.hammer.get('press').set({
	        time: 10000
	      });

	      // single select (or unselect) when tapping an item
	      this.hammer.on('tap', _bindInstanceProperty(_context6 = this._onSelectItem).call(_context6, this));

	      // multi select when holding mouse/touch, or on ctrl+click
	      this.hammer.on('press', _bindInstanceProperty(_context7 = this._onMultiSelectItem).call(_context7, this));
	      // delay addition on item click for trackpads...
	      this.hammer.get('press').set({
	        time: 10000
	      });

	      // add item on doubletap
	      this.hammer.on('doubletap', _bindInstanceProperty(_context8 = this._onAddItem).call(_context8, this));
	      if (this.options.rtl) {
	        this.groupHammer = new Hammer(this.body.dom.rightContainer);
	      } else {
	        this.groupHammer = new Hammer(this.body.dom.leftContainer);
	      }
	      this.groupHammer.on('tap', _bindInstanceProperty(_context9 = this._onGroupClick).call(_context9, this));
	      this.groupHammer.on('panstart', _bindInstanceProperty(_context10 = this._onGroupDragStart).call(_context10, this));
	      this.groupHammer.on('panmove', _bindInstanceProperty(_context11 = this._onGroupDrag).call(_context11, this));
	      this.groupHammer.on('panend', _bindInstanceProperty(_context12 = this._onGroupDragEnd).call(_context12, this));
	      this.groupHammer.get('pan').set({
	        threshold: 5,
	        direction: Hammer.DIRECTION_VERTICAL
	      });
	      this.body.dom.centerContainer.addEventListener('mouseover', _bindInstanceProperty(_context13 = this._onMouseOver).call(_context13, this));
	      this.body.dom.centerContainer.addEventListener('mouseout', _bindInstanceProperty(_context14 = this._onMouseOut).call(_context14, this));
	      this.body.dom.centerContainer.addEventListener('mousemove', _bindInstanceProperty(_context15 = this._onMouseMove).call(_context15, this));
	      // right-click on timeline 
	      this.body.dom.centerContainer.addEventListener('contextmenu', _bindInstanceProperty(_context16 = this._onDragEnd).call(_context16, this));
	      this.body.dom.centerContainer.addEventListener('mousewheel', _bindInstanceProperty(_context17 = this._onMouseWheel).call(_context17, this));

	      // attach to the DOM
	      this.show();
	    }

	    /**
	     * Set options for the ItemSet. Existing options will be extended/overwritten.
	     * @param {Object} [options] The following options are available:
	     *                           {string} type
	     *                              Default type for the items. Choose from 'box'
	     *                              (default), 'point', 'range', or 'background'.
	     *                              The default style can be overwritten by
	     *                              individual items.
	     *                           {string} align
	     *                              Alignment for the items, only applicable for
	     *                              BoxItem. Choose 'center' (default), 'left', or
	     *                              'right'.
	     *                           {string} orientation.item
	     *                              Orientation of the item set. Choose 'top' or
	     *                              'bottom' (default).
	     *                           {Function} groupOrder
	     *                              A sorting function for ordering groups
	     *                           {boolean} stack
	     *                              If true (default), items will be stacked on
	     *                              top of each other.
	     *                           {number} margin.axis
	     *                              Margin between the axis and the items in pixels.
	     *                              Default is 20.
	     *                           {number} margin.item.horizontal
	     *                              Horizontal margin between items in pixels.
	     *                              Default is 10.
	     *                           {number} margin.item.vertical
	     *                              Vertical Margin between items in pixels.
	     *                              Default is 10.
	     *                           {number} margin.item
	     *                              Margin between items in pixels in both horizontal
	     *                              and vertical direction. Default is 10.
	     *                           {number} margin
	     *                              Set margin for both axis and items in pixels.
	     *                           {boolean} selectable
	     *                              If true (default), items can be selected.
	     *                           {boolean} multiselect
	     *                              If true, multiple items can be selected.
	     *                              False by default.
	     *                           {boolean} editable
	     *                              Set all editable options to true or false
	     *                           {boolean} editable.updateTime
	     *                              Allow dragging an item to an other moment in time
	     *                           {boolean} editable.updateGroup
	     *                              Allow dragging an item to an other group
	     *                           {boolean} editable.add
	     *                              Allow creating new items on double tap
	     *                           {boolean} editable.remove
	     *                              Allow removing items by clicking the delete button
	     *                              top right of a selected item.
	     *                           {Function(item: Item, callback: Function)} onAdd
	     *                              Callback function triggered when an item is about to be added:
	     *                              when the user double taps an empty space in the Timeline.
	     *                           {Function(item: Item, callback: Function)} onUpdate
	     *                              Callback function fired when an item is about to be updated.
	     *                              This function typically has to show a dialog where the user
	     *                              change the item. If not implemented, nothing happens.
	     *                           {Function(item: Item, callback: Function)} onMove
	     *                              Fired when an item has been moved. If not implemented,
	     *                              the move action will be accepted.
	     *                           {Function(item: Item, callback: Function)} onRemove
	     *                              Fired when an item is about to be deleted.
	     *                              If not implemented, the item will be always removed.
	     */
	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      var _this3 = this;
	      if (options) {
	        var _context18, _context20;
	        // copy all options that we know
	        var fields = ['type', 'rtl', 'align', 'order', 'stack', 'stackSubgroups', 'selectable', 'multiselect', 'sequentialSelection', 'multiselectPerGroup', 'longSelectPressTime', 'groupOrder', 'dataAttributes', 'template', 'groupTemplate', 'visibleFrameTemplate', 'hide', 'snap', 'groupOrderSwap', 'showTooltips', 'tooltip', 'tooltipOnItemUpdateTime', 'groupHeightMode', 'onTimeout'];
	        availableUtils.selectiveExtend(fields, this.options, options);
	        if ('itemsAlwaysDraggable' in options) {
	          if (typeof options.itemsAlwaysDraggable === 'boolean') {
	            this.options.itemsAlwaysDraggable.item = options.itemsAlwaysDraggable;
	            this.options.itemsAlwaysDraggable.range = false;
	          } else if (_typeof(options.itemsAlwaysDraggable) === 'object') {
	            availableUtils.selectiveExtend(['item', 'range'], this.options.itemsAlwaysDraggable, options.itemsAlwaysDraggable);
	            // only allow range always draggable when item is always draggable as well
	            if (!this.options.itemsAlwaysDraggable.item) {
	              this.options.itemsAlwaysDraggable.range = false;
	            }
	          }
	        }
	        if ('sequentialSelection' in options) {
	          if (typeof options.sequentialSelection === 'boolean') {
	            this.options.sequentialSelection = options.sequentialSelection;
	          }
	        }
	        if ('orientation' in options) {
	          if (typeof options.orientation === 'string') {
	            this.options.orientation.item = options.orientation === 'top' ? 'top' : 'bottom';
	          } else if (_typeof(options.orientation) === 'object' && 'item' in options.orientation) {
	            this.options.orientation.item = options.orientation.item;
	          }
	        }
	        if ('margin' in options) {
	          if (typeof options.margin === 'number') {
	            this.options.margin.axis = options.margin;
	            this.options.margin.item.horizontal = options.margin;
	            this.options.margin.item.vertical = options.margin;
	          } else if (_typeof(options.margin) === 'object') {
	            availableUtils.selectiveExtend(['axis'], this.options.margin, options.margin);
	            if ('item' in options.margin) {
	              if (typeof options.margin.item === 'number') {
	                this.options.margin.item.horizontal = options.margin.item;
	                this.options.margin.item.vertical = options.margin.item;
	              } else if (_typeof(options.margin.item) === 'object') {
	                availableUtils.selectiveExtend(['horizontal', 'vertical'], this.options.margin.item, options.margin.item);
	              }
	            }
	          }
	        }
	        _forEachInstanceProperty(_context18 = ['locale', 'locales']).call(_context18, function (key) {
	          if (key in options) {
	            _this3.options[key] = options[key];
	          }
	        });
	        if ('editable' in options) {
	          if (typeof options.editable === 'boolean') {
	            this.options.editable.updateTime = options.editable;
	            this.options.editable.updateGroup = options.editable;
	            this.options.editable.add = options.editable;
	            this.options.editable.remove = options.editable;
	            this.options.editable.overrideItems = false;
	          } else if (_typeof(options.editable) === 'object') {
	            availableUtils.selectiveExtend(['updateTime', 'updateGroup', 'add', 'remove', 'overrideItems'], this.options.editable, options.editable);
	          }
	        }
	        if ('groupEditable' in options) {
	          if (typeof options.groupEditable === 'boolean') {
	            this.options.groupEditable.order = options.groupEditable;
	            this.options.groupEditable.add = options.groupEditable;
	            this.options.groupEditable.remove = options.groupEditable;
	          } else if (_typeof(options.groupEditable) === 'object') {
	            availableUtils.selectiveExtend(['order', 'add', 'remove'], this.options.groupEditable, options.groupEditable);
	          }
	        }

	        // callback functions
	        var addCallback = function addCallback(name) {
	          var fn = options[name];
	          if (fn) {
	            if (!(typeof fn === 'function')) {
	              var _context19;
	              throw new Error(_concatInstanceProperty(_context19 = "option ".concat(name, " must be a function ")).call(_context19, name, "(item, callback)"));
	            }
	            _this3.options[name] = fn;
	          }
	        };
	        _forEachInstanceProperty(_context20 = ['onDropObjectOnItem', 'onAdd', 'onUpdate', 'onRemove', 'onMove', 'onMoving', 'onAddGroup', 'onMoveGroup', 'onRemoveGroup']).call(_context20, addCallback);
	        if (options.cluster) {
	          _Object$assign(this.options, {
	            cluster: options.cluster
	          });
	          if (!this.clusterGenerator) {
	            this.clusterGenerator = new ClusterGenerator(this);
	          }
	          this.clusterGenerator.setItems(this.items, {
	            applyOnChangedLevel: false
	          });
	          this.markDirty({
	            refreshItems: true,
	            restackGroups: true
	          });
	          this.redraw();
	        } else if (this.clusterGenerator) {
	          this._detachAllClusters();
	          this.clusters = [];
	          this.clusterGenerator = null;
	          this.options.cluster = undefined;
	          this.markDirty({
	            refreshItems: true,
	            restackGroups: true
	          });
	          this.redraw();
	        } else {
	          // force the itemSet to refresh: options like orientation and margins may be changed
	          this.markDirty();
	        }
	      }
	    }

	    /**
	     * Mark the ItemSet dirty so it will refresh everything with next redraw.
	     * Optionally, all items can be marked as dirty and be refreshed.
	     * @param {{refreshItems: boolean}} [options]
	     */
	  }, {
	    key: "markDirty",
	    value: function markDirty(options) {
	      this.groupIds = [];
	      if (options) {
	        if (options.refreshItems) {
	          _forEachInstanceProperty(availableUtils).call(availableUtils, this.items, function (item) {
	            item.dirty = true;
	            if (item.displayed) item.redraw();
	          });
	        }
	        if (options.restackGroups) {
	          _forEachInstanceProperty(availableUtils).call(availableUtils, this.groups, function (group, key) {
	            if (key === BACKGROUND) return;
	            group.stackDirty = true;
	          });
	        }
	      }
	    }

	    /**
	     * Destroy the ItemSet
	     */
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.clearPopupTimer();
	      this.hide();
	      this.setItems(null);
	      this.setGroups(null);
	      this.hammer && this.hammer.destroy();
	      this.groupHammer && this.groupHammer.destroy();
	      this.hammer = null;
	      this.body = null;
	      this.conversion = null;
	    }

	    /**
	     * Hide the component from the DOM
	     */
	  }, {
	    key: "hide",
	    value: function hide() {
	      // remove the frame containing the items
	      if (this.dom.frame.parentNode) {
	        this.dom.frame.parentNode.removeChild(this.dom.frame);
	      }

	      // remove the axis with dots
	      if (this.dom.axis.parentNode) {
	        this.dom.axis.parentNode.removeChild(this.dom.axis);
	      }

	      // remove the labelset containing all group labels
	      if (this.dom.labelSet.parentNode) {
	        this.dom.labelSet.parentNode.removeChild(this.dom.labelSet);
	      }
	    }

	    /**
	     * Show the component in the DOM (when not already visible).
	     */
	  }, {
	    key: "show",
	    value: function show() {
	      // show frame containing the items
	      if (!this.dom.frame.parentNode) {
	        this.body.dom.center.appendChild(this.dom.frame);
	      }

	      // show axis with dots
	      if (!this.dom.axis.parentNode) {
	        this.body.dom.backgroundVertical.appendChild(this.dom.axis);
	      }

	      // show labelset containing labels
	      if (!this.dom.labelSet.parentNode) {
	        if (this.options.rtl) {
	          this.body.dom.right.appendChild(this.dom.labelSet);
	        } else {
	          this.body.dom.left.appendChild(this.dom.labelSet);
	        }
	      }
	    }

	    /**
	     * Activates the popup timer to show the given popup after a fixed time.
	     * @param {Popup} popup
	     */
	  }, {
	    key: "setPopupTimer",
	    value: function setPopupTimer(popup) {
	      this.clearPopupTimer();
	      if (popup) {
	        var delay = this.options.tooltip.delay || typeof this.options.tooltip.delay === 'number' ? this.options.tooltip.delay : 500;
	        this.popupTimer = _setTimeout(function () {
	          popup.show();
	        }, delay);
	      }
	    }

	    /**
	     * Clears the popup timer for the tooltip.
	     */
	  }, {
	    key: "clearPopupTimer",
	    value: function clearPopupTimer() {
	      if (this.popupTimer != null) {
	        clearTimeout(this.popupTimer);
	        this.popupTimer = null;
	      }
	    }

	    /**
	     * Set selected items by their id. Replaces the current selection
	     * Unknown id's are silently ignored.
	     * @param {string[] | string} [ids] An array with zero or more id's of the items to be
	     *                                  selected, or a single item id. If ids is undefined
	     *                                  or an empty array, all items will be unselected.
	     */
	  }, {
	    key: "setSelection",
	    value: function setSelection(ids) {
	      var _context21;
	      if (ids == undefined) {
	        ids = [];
	      }
	      if (!_Array$isArray$1(ids)) {
	        ids = [ids];
	      }
	      var idsToDeselect = _filterInstanceProperty(_context21 = this.selection).call(_context21, function (id) {
	        return _indexOfInstanceProperty(ids).call(ids, id) === -1;
	      });

	      // unselect currently selected items
	      var _iterator = _createForOfIteratorHelper$1(idsToDeselect),
	        _step;
	      try {
	        for (_iterator.s(); !(_step = _iterator.n()).done;) {
	          var selectedId = _step.value;
	          var item = this.getItemById(selectedId);
	          if (item) {
	            item.unselect();
	          }
	        }

	        // select items
	      } catch (err) {
	        _iterator.e(err);
	      } finally {
	        _iterator.f();
	      }
	      this.selection = _toConsumableArray(ids);
	      var _iterator2 = _createForOfIteratorHelper$1(ids),
	        _step2;
	      try {
	        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
	          var id = _step2.value;
	          var _item2 = this.getItemById(id);
	          if (_item2) {
	            _item2.select();
	          }
	        }
	      } catch (err) {
	        _iterator2.e(err);
	      } finally {
	        _iterator2.f();
	      }
	    }

	    /**
	     * Get the selected items by their id
	     * @return {Array} ids  The ids of the selected items
	     */
	  }, {
	    key: "getSelection",
	    value: function getSelection() {
	      var _context22;
	      return _concatInstanceProperty(_context22 = this.selection).call(_context22, []);
	    }

	    /**
	     * Get the id's of the currently visible items.
	     * @returns {Array} The ids of the visible items
	     */
	  }, {
	    key: "getVisibleItems",
	    value: function getVisibleItems() {
	      var range = this.body.range.getRange();
	      var right;
	      var left;
	      if (this.options.rtl) {
	        right = this.body.util.toScreen(range.start);
	        left = this.body.util.toScreen(range.end);
	      } else {
	        left = this.body.util.toScreen(range.start);
	        right = this.body.util.toScreen(range.end);
	      }
	      var ids = [];
	      for (var groupId in this.groups) {
	        if (this.groups.hasOwnProperty(groupId)) {
	          var group = this.groups[groupId];
	          var rawVisibleItems = group.isVisible ? group.visibleItems : [];

	          // filter the "raw" set with visibleItems into a set which is really
	          // visible by pixels
	          var _iterator3 = _createForOfIteratorHelper$1(rawVisibleItems),
	            _step3;
	          try {
	            for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
	              var item = _step3.value;
	              // TODO: also check whether visible vertically
	              if (this.options.rtl) {
	                if (item.right < left && item.right + item.width > right) {
	                  ids.push(item.id);
	                }
	              } else {
	                if (item.left < right && item.left + item.width > left) {
	                  ids.push(item.id);
	                }
	              }
	            }
	          } catch (err) {
	            _iterator3.e(err);
	          } finally {
	            _iterator3.f();
	          }
	        }
	      }
	      return ids;
	    }

	    /**
	    * Get the id's of the items at specific time, where a click takes place on the timeline.
	    * @returns {Array} The ids of all items in existence at the time of click event on the timeline.
	    */
	  }, {
	    key: "getItemsAtCurrentTime",
	    value: function getItemsAtCurrentTime(timeOfEvent) {
	      var right;
	      var left;
	      if (this.options.rtl) {
	        right = this.body.util.toScreen(timeOfEvent);
	        left = this.body.util.toScreen(timeOfEvent);
	      } else {
	        left = this.body.util.toScreen(timeOfEvent);
	        right = this.body.util.toScreen(timeOfEvent);
	      }
	      var ids = [];
	      for (var groupId in this.groups) {
	        if (this.groups.hasOwnProperty(groupId)) {
	          var group = this.groups[groupId];
	          var rawVisibleItems = group.isVisible ? group.visibleItems : [];

	          // filter the "raw" set with visibleItems into a set which is really
	          // visible by pixels
	          var _iterator4 = _createForOfIteratorHelper$1(rawVisibleItems),
	            _step4;
	          try {
	            for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
	              var item = _step4.value;
	              if (this.options.rtl) {
	                if (item.right < left && item.right + item.width > right) {
	                  ids.push(item.id);
	                }
	              } else {
	                if (item.left < right && item.left + item.width > left) {
	                  ids.push(item.id);
	                }
	              }
	            }
	          } catch (err) {
	            _iterator4.e(err);
	          } finally {
	            _iterator4.f();
	          }
	        }
	      }
	      return ids;
	    }

	    /**
	     * Get the id's of the currently visible groups.
	     * @returns {Array} The ids of the visible groups
	     */
	  }, {
	    key: "getVisibleGroups",
	    value: function getVisibleGroups() {
	      var ids = [];
	      for (var groupId in this.groups) {
	        if (this.groups.hasOwnProperty(groupId)) {
	          var group = this.groups[groupId];
	          if (group.isVisible) {
	            ids.push(groupId);
	          }
	        }
	      }
	      return ids;
	    }

	    /**
	     * get item by id
	     * @param {string} id
	     * @return {object} item
	     */
	  }, {
	    key: "getItemById",
	    value: function getItemById(id) {
	      var _context23;
	      return this.items[id] || _findInstanceProperty(_context23 = this.clusters).call(_context23, function (cluster) {
	        return cluster.id === id;
	      });
	    }

	    /**
	     * Deselect a selected item
	     * @param {string | number} id
	     * @private
	     */
	  }, {
	    key: "_deselect",
	    value: function _deselect(id) {
	      var selection = this.selection;
	      for (var i = 0, ii = selection.length; i < ii; i++) {
	        if (selection[i] == id) {
	          // non-strict comparison!
	          _spliceInstanceProperty(selection).call(selection, i, 1);
	          break;
	        }
	      }
	    }

	    /**
	     * Repaint the component
	     * @return {boolean} Returns true if the component is resized
	     */
	  }, {
	    key: "redraw",
	    value: function redraw() {
	      var margin = this.options.margin;
	      var range = this.body.range;
	      var asSize = availableUtils.option.asSize;
	      var options = this.options;
	      var orientation = options.orientation.item;
	      var resized = false;
	      var frame = this.dom.frame;

	      // recalculate absolute position (before redrawing groups)
	      this.props.top = this.body.domProps.top.height + this.body.domProps.border.top;
	      if (this.options.rtl) {
	        this.props.right = this.body.domProps.right.width + this.body.domProps.border.right;
	      } else {
	        this.props.left = this.body.domProps.left.width + this.body.domProps.border.left;
	      }

	      // update class name
	      frame.className = 'vis-itemset';
	      if (this.options.cluster) {
	        this._clusterItems();
	      }

	      // reorder the groups (if needed)
	      resized = this._orderGroups() || resized;

	      // check whether zoomed (in that case we need to re-stack everything)
	      // TODO: would be nicer to get this as a trigger from Range
	      var visibleInterval = range.end - range.start;
	      var zoomed = visibleInterval != this.lastVisibleInterval || this.props.width != this.props.lastWidth;
	      var scrolled = range.start != this.lastRangeStart;
	      var changedStackOption = options.stack != this.lastStack;
	      var changedStackSubgroupsOption = options.stackSubgroups != this.lastStackSubgroups;
	      var forceRestack = zoomed || scrolled || changedStackOption || changedStackSubgroupsOption;
	      this.lastVisibleInterval = visibleInterval;
	      this.lastRangeStart = range.start;
	      this.lastStack = options.stack;
	      this.lastStackSubgroups = options.stackSubgroups;
	      this.props.lastWidth = this.props.width;
	      var firstGroup = this._firstGroup();
	      var firstMargin = {
	        item: margin.item,
	        axis: margin.axis
	      };
	      var nonFirstMargin = {
	        item: margin.item,
	        axis: margin.item.vertical / 2
	      };
	      var height = 0;
	      var minHeight = margin.axis + margin.item.vertical;

	      // redraw the background group
	      this.groups[BACKGROUND].redraw(range, nonFirstMargin, forceRestack);
	      var redrawQueue = {};
	      var redrawQueueLength = 0;

	      // collect redraw functions
	      _forEachInstanceProperty(availableUtils).call(availableUtils, this.groups, function (group, key) {
	        if (key === BACKGROUND) return;
	        var groupMargin = group == firstGroup ? firstMargin : nonFirstMargin;
	        var returnQueue = true;
	        redrawQueue[key] = group.redraw(range, groupMargin, forceRestack, returnQueue);
	        redrawQueueLength = redrawQueue[key].length;
	      });
	      var needRedraw = redrawQueueLength > 0;
	      if (needRedraw) {
	        var redrawResults = {};
	        var _loop = function _loop(i) {
	          _forEachInstanceProperty(availableUtils).call(availableUtils, redrawQueue, function (fns, key) {
	            redrawResults[key] = fns[i]();
	          });
	        };
	        for (var i = 0; i < redrawQueueLength; i++) {
	          _loop(i);
	        }

	        // redraw all regular groups
	        _forEachInstanceProperty(availableUtils).call(availableUtils, this.groups, function (group, key) {
	          if (key === BACKGROUND) return;
	          var groupResized = redrawResults[key];
	          resized = groupResized || resized;
	          height += group.height;
	        });
	        height = Math.max(height, minHeight);
	      }
	      height = Math.max(height, minHeight);

	      // update frame height
	      frame.style.height = asSize(height);

	      // calculate actual size
	      this.props.width = frame.offsetWidth;
	      this.props.height = height;

	      // reposition axis
	      this.dom.axis.style.top = asSize(orientation == 'top' ? this.body.domProps.top.height + this.body.domProps.border.top : this.body.domProps.top.height + this.body.domProps.centerContainer.height);
	      if (this.options.rtl) {
	        this.dom.axis.style.right = '0';
	      } else {
	        this.dom.axis.style.left = '0';
	      }
	      this.hammer.get('press').set({
	        time: this.options.longSelectPressTime
	      });
	      this.initialItemSetDrawn = true;
	      // check if this component is resized
	      resized = this._isResized() || resized;
	      return resized;
	    }

	    /**
	     * Get the first group, aligned with the axis
	     * @return {Group | null} firstGroup
	     * @private
	     */
	  }, {
	    key: "_firstGroup",
	    value: function _firstGroup() {
	      var firstGroupIndex = this.options.orientation.item == 'top' ? 0 : this.groupIds.length - 1;
	      var firstGroupId = this.groupIds[firstGroupIndex];
	      var firstGroup = this.groups[firstGroupId] || this.groups[UNGROUPED$1];
	      return firstGroup || null;
	    }

	    /**
	     * Create or delete the group holding all ungrouped items. This group is used when
	     * there are no groups specified.
	     * @protected
	     */
	  }, {
	    key: "_updateUngrouped",
	    value: function _updateUngrouped() {
	      var ungrouped = this.groups[UNGROUPED$1];
	      var item;
	      var itemId;
	      if (this.groupsData) {
	        // remove the group holding all ungrouped items
	        if (ungrouped) {
	          ungrouped.dispose();
	          delete this.groups[UNGROUPED$1];
	          for (itemId in this.items) {
	            if (this.items.hasOwnProperty(itemId)) {
	              item = this.items[itemId];
	              item.parent && item.parent.remove(item);
	              var groupId = this.getGroupId(item.data);
	              var group = this.groups[groupId];
	              group && group.add(item) || item.hide();
	            }
	          }
	        }
	      } else {
	        // create a group holding all (unfiltered) items
	        if (!ungrouped) {
	          var id = null;
	          var data = null;
	          ungrouped = new Group(id, data, this);
	          this.groups[UNGROUPED$1] = ungrouped;
	          for (itemId in this.items) {
	            if (this.items.hasOwnProperty(itemId)) {
	              item = this.items[itemId];
	              ungrouped.add(item);
	            }
	          }
	          ungrouped.show();
	        }
	      }
	    }

	    /**
	     * Get the element for the labelset
	     * @return {HTMLElement} labelSet
	     */
	  }, {
	    key: "getLabelSet",
	    value: function getLabelSet() {
	      return this.dom.labelSet;
	    }

	    /**
	     * Set items
	     * @param {vis.DataSet | null} items
	     */
	  }, {
	    key: "setItems",
	    value: function setItems(items) {
	      this.itemsSettingTime = new Date();
	      var me = this;
	      var ids;
	      var oldItemsData = this.itemsData;

	      // replace the dataset
	      if (!items) {
	        this.itemsData = null;
	      } else if (isDataViewLike(items)) {
	        this.itemsData = typeCoerceDataSet(items);
	      } else {
	        throw new TypeError('Data must implement the interface of DataSet or DataView');
	      }
	      if (oldItemsData) {
	        // unsubscribe from old dataset
	        _forEachInstanceProperty(availableUtils).call(availableUtils, this.itemListeners, function (callback, event) {
	          oldItemsData.off(event, callback);
	        });

	        // stop maintaining a coerced version of the old data set
	        oldItemsData.dispose();

	        // remove all drawn items
	        ids = oldItemsData.getIds();
	        this._onRemove(ids);
	      }
	      if (this.itemsData) {
	        // subscribe to new dataset
	        var id = this.id;
	        _forEachInstanceProperty(availableUtils).call(availableUtils, this.itemListeners, function (callback, event) {
	          me.itemsData.on(event, callback, id);
	        });

	        // add all new items
	        ids = this.itemsData.getIds();
	        this._onAdd(ids);

	        // update the group holding all ungrouped items
	        this._updateUngrouped();
	      }
	      this.body.emitter.emit('_change', {
	        queue: true
	      });
	    }

	    /**
	     * Get the current items
	     * @returns {vis.DataSet | null}
	     */
	  }, {
	    key: "getItems",
	    value: function getItems() {
	      return this.itemsData != null ? this.itemsData.rawDS : null;
	    }

	    /**
	     * Set groups
	     * @param {vis.DataSet} groups
	     */
	  }, {
	    key: "setGroups",
	    value: function setGroups(groups) {
	      var me = this;
	      var ids;

	      // unsubscribe from current dataset
	      if (this.groupsData) {
	        _forEachInstanceProperty(availableUtils).call(availableUtils, this.groupListeners, function (callback, event) {
	          me.groupsData.off(event, callback);
	        });

	        // remove all drawn groups
	        ids = this.groupsData.getIds();
	        this.groupsData = null;
	        this._onRemoveGroups(ids); // note: this will cause a redraw
	      }

	      // replace the dataset
	      if (!groups) {
	        this.groupsData = null;
	      } else if (isDataViewLike(groups)) {
	        this.groupsData = groups;
	      } else {
	        throw new TypeError('Data must implement the interface of DataSet or DataView');
	      }
	      if (this.groupsData) {
	        var _context24;
	        // go over all groups nesting
	        var groupsData = this.groupsData.getDataSet();
	        _forEachInstanceProperty(_context24 = groupsData.get()).call(_context24, function (group) {
	          if (group.nestedGroups) {
	            var _context25;
	            _forEachInstanceProperty(_context25 = group.nestedGroups).call(_context25, function (nestedGroupId) {
	              var updatedNestedGroup = groupsData.get(nestedGroupId);
	              updatedNestedGroup.nestedInGroup = group.id;
	              if (group.showNested == false) {
	                updatedNestedGroup.visible = false;
	              }
	              groupsData.update(updatedNestedGroup);
	            });
	          }
	        });

	        // subscribe to new dataset
	        var id = this.id;
	        _forEachInstanceProperty(availableUtils).call(availableUtils, this.groupListeners, function (callback, event) {
	          me.groupsData.on(event, callback, id);
	        });

	        // draw all ms
	        ids = this.groupsData.getIds();
	        this._onAddGroups(ids);
	      }

	      // update the group holding all ungrouped items
	      this._updateUngrouped();

	      // update the order of all items in each group
	      this._order();
	      if (this.options.cluster) {
	        this.clusterGenerator.updateData();
	        this._clusterItems();
	        this.markDirty({
	          refreshItems: true,
	          restackGroups: true
	        });
	      }
	      this.body.emitter.emit('_change', {
	        queue: true
	      });
	    }

	    /**
	     * Get the current groups
	     * @returns {vis.DataSet | null} groups
	     */
	  }, {
	    key: "getGroups",
	    value: function getGroups() {
	      return this.groupsData;
	    }

	    /**
	     * Remove an item by its id
	     * @param {string | number} id
	     */
	  }, {
	    key: "removeItem",
	    value: function removeItem(id) {
	      var _this4 = this;
	      var item = this.itemsData.get(id);
	      if (item) {
	        // confirm deletion
	        this.options.onRemove(item, function (item) {
	          if (item) {
	            // remove by id here, it is possible that an item has no id defined
	            // itself, so better not delete by the item itself
	            _this4.itemsData.remove(id);
	          }
	        });
	      }
	    }

	    /**
	     * Get the time of an item based on it's data and options.type
	     * @param {Object} itemData
	     * @returns {string} Returns the type
	     * @private
	     */
	  }, {
	    key: "_getType",
	    value: function _getType(itemData) {
	      return itemData.type || this.options.type || (itemData.end ? 'range' : 'box');
	    }

	    /**
	     * Get the group id for an item
	     * @param {Object} itemData
	     * @returns {string} Returns the groupId
	     * @private
	     */
	  }, {
	    key: "getGroupId",
	    value: function getGroupId(itemData) {
	      var type = this._getType(itemData);
	      if (type == 'background' && itemData.group == undefined) {
	        return BACKGROUND;
	      } else {
	        return this.groupsData ? itemData.group : UNGROUPED$1;
	      }
	    }

	    /**
	     * Handle updated items
	     * @param {number[]} ids
	     * @protected
	     */
	  }, {
	    key: "_onUpdate",
	    value: function _onUpdate(ids) {
	      var _this5 = this;
	      var me = this;
	      _forEachInstanceProperty(ids).call(ids, function (id) {
	        var itemData = me.itemsData.get(id);
	        var item = me.items[id];
	        var type = itemData ? me._getType(itemData) : null;
	        var constructor = ItemSet.types[type];
	        var selected;
	        if (item) {
	          // update item   	
	          if (!constructor || !(item instanceof constructor)) {
	            // item type has changed, delete the item and recreate it
	            selected = item.selected; // preserve selection of this item
	            me._removeItem(item);
	            item = null;
	          } else {
	            me._updateItem(item, itemData);
	          }
	        }
	        if (!item && itemData) {
	          // create item
	          if (constructor) {
	            item = new constructor(itemData, me.conversion, me.options);
	            item.id = id; // TODO: not so nice setting id afterwards

	            me._addItem(item);
	            if (selected) {
	              _this5.selection.push(id);
	              item.select();
	            }
	          } else {
	            throw new TypeError("Unknown item type \"".concat(type, "\""));
	          }
	        }
	      });
	      this._order();
	      if (this.options.cluster) {
	        this.clusterGenerator.setItems(this.items, {
	          applyOnChangedLevel: false
	        });
	        this._clusterItems();
	      }
	      this.body.emitter.emit('_change', {
	        queue: true
	      });
	    }

	    /**
	     * Handle removed items
	     * @param {number[]} ids
	     * @protected
	     */
	  }, {
	    key: "_onRemove",
	    value: function _onRemove(ids) {
	      var count = 0;
	      var me = this;
	      _forEachInstanceProperty(ids).call(ids, function (id) {
	        var item = me.items[id];
	        if (item) {
	          count++;
	          me._removeItem(item);
	        }
	      });
	      if (count) {
	        // update order
	        this._order();
	        this.body.emitter.emit('_change', {
	          queue: true
	        });
	      }
	    }

	    /**
	     * Update the order of item in all groups
	     * @private
	     */
	  }, {
	    key: "_order",
	    value: function _order() {
	      // reorder the items in all groups
	      // TODO: optimization: only reorder groups affected by the changed items
	      _forEachInstanceProperty(availableUtils).call(availableUtils, this.groups, function (group) {
	        group.order();
	      });
	    }

	    /**
	     * Handle updated groups
	     * @param {number[]} ids
	     * @private
	     */
	  }, {
	    key: "_onUpdateGroups",
	    value: function _onUpdateGroups(ids) {
	      this._onAddGroups(ids);
	    }

	    /**
	     * Handle changed groups (added or updated)
	     * @param {number[]} ids
	     * @private
	     */
	  }, {
	    key: "_onAddGroups",
	    value: function _onAddGroups(ids) {
	      var me = this;
	      _forEachInstanceProperty(ids).call(ids, function (id) {
	        var groupData = me.groupsData.get(id);
	        var group = me.groups[id];
	        if (!group) {
	          // check for reserved ids
	          if (id == UNGROUPED$1 || id == BACKGROUND) {
	            throw new Error("Illegal group id. ".concat(id, " is a reserved id."));
	          }
	          var groupOptions = _Object$create(me.options);
	          availableUtils.extend(groupOptions, {
	            height: null
	          });
	          group = new Group(id, groupData, me);
	          me.groups[id] = group;

	          // add items with this groupId to the new group
	          for (var itemId in me.items) {
	            if (me.items.hasOwnProperty(itemId)) {
	              var item = me.items[itemId];
	              if (item.data.group == id) {
	                group.add(item);
	              }
	            }
	          }
	          group.order();
	          group.show();
	        } else {
	          // update group
	          group.setData(groupData);
	        }
	      });
	      this.body.emitter.emit('_change', {
	        queue: true
	      });
	    }

	    /**
	     * Handle removed groups
	     * @param {number[]} ids
	     * @private
	     */
	  }, {
	    key: "_onRemoveGroups",
	    value: function _onRemoveGroups(ids) {
	      var _this6 = this;
	      _forEachInstanceProperty(ids).call(ids, function (id) {
	        var group = _this6.groups[id];
	        if (group) {
	          group.dispose();
	          delete _this6.groups[id];
	        }
	      });
	      if (this.options.cluster) {
	        this.clusterGenerator.updateData();
	        this._clusterItems();
	      }
	      this.markDirty({
	        restackGroups: !!this.options.cluster
	      });
	      this.body.emitter.emit('_change', {
	        queue: true
	      });
	    }

	    /**
	     * Reorder the groups if needed
	     * @return {boolean} changed
	     * @private
	     */
	  }, {
	    key: "_orderGroups",
	    value: function _orderGroups() {
	      if (this.groupsData) {
	        // reorder the groups
	        var groupIds = this.groupsData.getIds({
	          order: this.options.groupOrder
	        });
	        groupIds = this._orderNestedGroups(groupIds);
	        var changed = !availableUtils.equalArray(groupIds, this.groupIds);
	        if (changed) {
	          // hide all groups, removes them from the DOM
	          var groups = this.groups;
	          _forEachInstanceProperty(groupIds).call(groupIds, function (groupId) {
	            groups[groupId].hide();
	          });

	          // show the groups again, attach them to the DOM in correct order
	          _forEachInstanceProperty(groupIds).call(groupIds, function (groupId) {
	            groups[groupId].show();
	          });
	          this.groupIds = groupIds;
	        }
	        return changed;
	      } else {
	        return false;
	      }
	    }

	    /**
	     * Reorder the nested groups
	     *
	     * @param {Array.<number>} groupIds
	     * @returns {Array.<number>}
	     * @private
	     */
	  }, {
	    key: "_orderNestedGroups",
	    value: function _orderNestedGroups(groupIds) {
	      var _this7 = this;
	      /**
	       * Recursively order nested groups
	       *
	       * @param {ItemSet} t
	       * @param {Array.<number>} groupIds
	       * @returns {Array.<number>}
	       * @private
	       */
	      function getOrderedNestedGroups(t, groupIds) {
	        var result = [];
	        _forEachInstanceProperty(groupIds).call(groupIds, function (groupId) {
	          result.push(groupId);
	          var groupData = t.groupsData.get(groupId);
	          if (groupData.nestedGroups) {
	            var _context26;
	            var nestedGroupIds = _mapInstanceProperty(_context26 = t.groupsData.get({
	              filter: function filter(nestedGroup) {
	                return nestedGroup.nestedInGroup == groupId;
	              },
	              order: t.options.groupOrder
	            })).call(_context26, function (nestedGroup) {
	              return nestedGroup.id;
	            });
	            result = _concatInstanceProperty(result).call(result, getOrderedNestedGroups(t, nestedGroupIds));
	          }
	        });
	        return result;
	      }
	      var topGroupIds = _filterInstanceProperty(groupIds).call(groupIds, function (groupId) {
	        return !_this7.groupsData.get(groupId).nestedInGroup;
	      });
	      return getOrderedNestedGroups(this, topGroupIds);
	    }

	    /**
	     * Add a new item
	     * @param {Item} item
	     * @private
	     */
	  }, {
	    key: "_addItem",
	    value: function _addItem(item) {
	      this.items[item.id] = item;

	      // add to group
	      var groupId = this.getGroupId(item.data);
	      var group = this.groups[groupId];
	      if (!group) {
	        item.groupShowing = false;
	      } else if (group && group.data && group.data.showNested) {
	        item.groupShowing = true;
	      }
	      if (group) group.add(item);
	    }

	    /**
	     * Update an existing item
	     * @param {Item} item
	     * @param {Object} itemData
	     * @private
	     */
	  }, {
	    key: "_updateItem",
	    value: function _updateItem(item, itemData) {
	      // update the items data (will redraw the item when displayed)
	      item.setData(itemData);
	      var groupId = this.getGroupId(item.data);
	      var group = this.groups[groupId];
	      if (!group) {
	        item.groupShowing = false;
	      } else if (group && group.data && group.data.showNested) {
	        item.groupShowing = true;
	      }
	    }

	    /**
	     * Delete an item from the ItemSet: remove it from the DOM, from the map
	     * with items, and from the map with visible items, and from the selection
	     * @param {Item} item
	     * @private
	     */
	  }, {
	    key: "_removeItem",
	    value: function _removeItem(item) {
	      var _context27, _context28;
	      // remove from DOM
	      item.hide();

	      // remove from items
	      delete this.items[item.id];

	      // remove from selection
	      var index = _indexOfInstanceProperty(_context27 = this.selection).call(_context27, item.id);
	      if (index != -1) _spliceInstanceProperty(_context28 = this.selection).call(_context28, index, 1);

	      // remove from group
	      item.parent && item.parent.remove(item);

	      // remove Tooltip from DOM
	      if (this.popup != null) {
	        this.popup.hide();
	      }
	    }

	    /**
	     * Create an array containing all items being a range (having an end date)
	     * @param {Array.<Object>} array
	     * @returns {Array}
	     * @private
	     */
	  }, {
	    key: "_constructByEndArray",
	    value: function _constructByEndArray(array) {
	      var endArray = [];
	      for (var i = 0; i < array.length; i++) {
	        if (array[i] instanceof RangeItem) {
	          endArray.push(array[i]);
	        }
	      }
	      return endArray;
	    }

	    /**
	     * Register the clicked item on touch, before dragStart is initiated.
	     *
	     * dragStart is initiated from a mousemove event, AFTER the mouse/touch is
	     * already moving. Therefore, the mouse/touch can sometimes be above an other
	     * DOM element than the item itself.
	     *
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onTouch",
	    value: function _onTouch(event) {
	      // store the touched item, used in _onDragStart
	      this.touchParams.item = this.itemFromTarget(event);
	      this.touchParams.dragLeftItem = event.target.dragLeftItem || false;
	      this.touchParams.dragRightItem = event.target.dragRightItem || false;
	      this.touchParams.itemProps = null;
	    }

	    /**
	     * Given an group id, returns the index it has.
	     *
	     * @param {number} groupId
	     * @returns {number} index / groupId
	     * @private
	     */
	  }, {
	    key: "_getGroupIndex",
	    value: function _getGroupIndex(groupId) {
	      for (var i = 0; i < this.groupIds.length; i++) {
	        if (groupId == this.groupIds[i]) return i;
	      }
	    }

	    /**
	     * Start dragging the selected events
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onDragStart",
	    value: function _onDragStart(event) {
	      var _this8 = this;
	      if (this.touchParams.itemIsDragging) {
	        return;
	      }
	      var item = this.touchParams.item || null;
	      var me = this;
	      var props;
	      if (item && (item.selected || this.options.itemsAlwaysDraggable.item)) {
	        if (this.options.editable.overrideItems && !this.options.editable.updateTime && !this.options.editable.updateGroup) {
	          return;
	        }

	        // override options.editable
	        if (item.editable != null && !item.editable.updateTime && !item.editable.updateGroup && !this.options.editable.overrideItems) {
	          return;
	        }
	        var dragLeftItem = this.touchParams.dragLeftItem;
	        var dragRightItem = this.touchParams.dragRightItem;
	        this.touchParams.itemIsDragging = true;
	        this.touchParams.selectedItem = item;
	        if (dragLeftItem) {
	          props = {
	            item: dragLeftItem,
	            initialX: event.center.x,
	            dragLeft: true,
	            data: this._cloneItemData(item.data)
	          };
	          this.touchParams.itemProps = [props];
	        } else if (dragRightItem) {
	          props = {
	            item: dragRightItem,
	            initialX: event.center.x,
	            dragRight: true,
	            data: this._cloneItemData(item.data)
	          };
	          this.touchParams.itemProps = [props];
	        } else if (this.options.editable.add && (event.srcEvent.ctrlKey || event.srcEvent.metaKey)) {
	          // create a new range item when dragging with ctrl key down
	          this._onDragStartAddItem(event);
	        } else {
	          if (this.groupIds.length < 1) {
	            // Mitigates a race condition if _onDragStart() is
	            // called after markDirty() without redraw() being called between.
	            this.redraw();
	          }
	          var baseGroupIndex = this._getGroupIndex(item.data.group);
	          var itemsToDrag = this.options.itemsAlwaysDraggable.item && !item.selected ? [item.id] : this.getSelection();
	          this.touchParams.itemProps = _mapInstanceProperty(itemsToDrag).call(itemsToDrag, function (id) {
	            var item = me.items[id];
	            var groupIndex = me._getGroupIndex(item.data.group);
	            return {
	              item: item,
	              initialX: event.center.x,
	              groupOffset: baseGroupIndex - groupIndex,
	              data: _this8._cloneItemData(item.data)
	            };
	          });
	        }
	        event.stopPropagation();
	      } else if (this.options.editable.add && (event.srcEvent.ctrlKey || event.srcEvent.metaKey)) {
	        // create a new range item when dragging with ctrl key down
	        this._onDragStartAddItem(event);
	      }
	    }

	    /**
	     * Start creating a new range item by dragging.
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onDragStartAddItem",
	    value: function _onDragStartAddItem(event) {
	      var snap = this.options.snap || null;
	      var frameRect = this.dom.frame.getBoundingClientRect();

	      // plus (if rtl) 10 to compensate for the drag starting as soon as you've moved 10px
	      var x = this.options.rtl ? frameRect.right - event.center.x + 10 : event.center.x - frameRect.left - 10;
	      var time = this.body.util.toTime(x);
	      var scale = this.body.util.getScale();
	      var step = this.body.util.getStep();
	      var start = snap ? snap(time, scale, step) : time;
	      var end = start;
	      var itemData = {
	        type: 'range',
	        start: start,
	        end: end,
	        content: 'new item'
	      };
	      var id = v4();
	      itemData[this.itemsData.idProp] = id;
	      var group = this.groupFromTarget(event);
	      if (group) {
	        itemData.group = group.groupId;
	      }
	      var newItem = new RangeItem(itemData, this.conversion, this.options);
	      newItem.id = id; // TODO: not so nice setting id afterwards
	      newItem.data = this._cloneItemData(itemData);
	      this._addItem(newItem);
	      this.touchParams.selectedItem = newItem;
	      var props = {
	        item: newItem,
	        initialX: event.center.x,
	        data: newItem.data
	      };
	      if (this.options.rtl) {
	        props.dragLeft = true;
	      } else {
	        props.dragRight = true;
	      }
	      this.touchParams.itemProps = [props];
	      event.stopPropagation();
	    }

	    /**
	     * Drag selected items
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onDrag",
	    value: function _onDrag(event) {
	      var _this9 = this;
	      if (this.popup != null && this.options.showTooltips && !this.popup.hidden) {
	        // this.popup.hide();
	        var container = this.body.dom.centerContainer;
	        var containerRect = container.getBoundingClientRect();
	        this.popup.setPosition(event.center.x - containerRect.left + container.offsetLeft, event.center.y - containerRect.top + container.offsetTop);
	        this.popup.show(); // redraw
	      }

	      if (this.touchParams.itemProps) {
	        var _context29;
	        event.stopPropagation();
	        var me = this;
	        var snap = this.options.snap || null;
	        var domRootOffsetLeft = this.body.dom.root.offsetLeft;
	        var xOffset = this.options.rtl ? domRootOffsetLeft + this.body.domProps.right.width : domRootOffsetLeft + this.body.domProps.left.width;
	        var scale = this.body.util.getScale();
	        var step = this.body.util.getStep();

	        //only calculate the new group for the item that's actually dragged
	        var selectedItem = this.touchParams.selectedItem;
	        var updateGroupAllowed = (this.options.editable.overrideItems || selectedItem.editable == null) && this.options.editable.updateGroup || !this.options.editable.overrideItems && selectedItem.editable != null && selectedItem.editable.updateGroup;
	        var newGroupBase = null;
	        if (updateGroupAllowed && selectedItem) {
	          if (selectedItem.data.group != undefined) {
	            // drag from one group to another
	            var group = me.groupFromTarget(event);
	            if (group) {
	              //we know the offset for all items, so the new group for all items
	              //will be relative to this one.
	              newGroupBase = this._getGroupIndex(group.groupId);
	            }
	          }
	        }

	        // move
	        _forEachInstanceProperty(_context29 = this.touchParams.itemProps).call(_context29, function (props) {
	          var current = me.body.util.toTime(event.center.x - xOffset);
	          var initial = me.body.util.toTime(props.initialX - xOffset);
	          var offset;
	          var initialStart;
	          var initialEnd;
	          var start;
	          var end;
	          if (_this9.options.rtl) {
	            offset = -(current - initial); // ms
	          } else {
	            offset = current - initial; // ms
	          }

	          var itemData = _this9._cloneItemData(props.item.data); // clone the data
	          if (props.item.editable != null && !props.item.editable.updateTime && !props.item.editable.updateGroup && !me.options.editable.overrideItems) {
	            return;
	          }
	          var updateTimeAllowed = (_this9.options.editable.overrideItems || selectedItem.editable == null) && _this9.options.editable.updateTime || !_this9.options.editable.overrideItems && selectedItem.editable != null && selectedItem.editable.updateTime;
	          if (updateTimeAllowed) {
	            if (props.dragLeft) {
	              // drag left side of a range item
	              if (_this9.options.rtl) {
	                if (itemData.end != undefined) {
	                  initialEnd = availableUtils.convert(props.data.end, 'Date');
	                  end = new Date(initialEnd.valueOf() + offset);
	                  // TODO: pass a Moment instead of a Date to snap(). (Breaking change)
	                  itemData.end = snap ? snap(end, scale, step) : end;
	                }
	              } else {
	                if (itemData.start != undefined) {
	                  initialStart = availableUtils.convert(props.data.start, 'Date');
	                  start = new Date(initialStart.valueOf() + offset);
	                  // TODO: pass a Moment instead of a Date to snap(). (Breaking change)
	                  itemData.start = snap ? snap(start, scale, step) : start;
	                }
	              }
	            } else if (props.dragRight) {
	              // drag right side of a range item
	              if (_this9.options.rtl) {
	                if (itemData.start != undefined) {
	                  initialStart = availableUtils.convert(props.data.start, 'Date');
	                  start = new Date(initialStart.valueOf() + offset);
	                  // TODO: pass a Moment instead of a Date to snap(). (Breaking change)
	                  itemData.start = snap ? snap(start, scale, step) : start;
	                }
	              } else {
	                if (itemData.end != undefined) {
	                  initialEnd = availableUtils.convert(props.data.end, 'Date');
	                  end = new Date(initialEnd.valueOf() + offset);
	                  // TODO: pass a Moment instead of a Date to snap(). (Breaking change)
	                  itemData.end = snap ? snap(end, scale, step) : end;
	                }
	              }
	            } else {
	              // drag both start and end
	              if (itemData.start != undefined) {
	                initialStart = availableUtils.convert(props.data.start, 'Date').valueOf();
	                start = new Date(initialStart + offset);
	                if (itemData.end != undefined) {
	                  initialEnd = availableUtils.convert(props.data.end, 'Date');
	                  var duration = initialEnd.valueOf() - initialStart.valueOf();

	                  // TODO: pass a Moment instead of a Date to snap(). (Breaking change)
	                  itemData.start = snap ? snap(start, scale, step) : start;
	                  itemData.end = new Date(itemData.start.valueOf() + duration);
	                } else {
	                  // TODO: pass a Moment instead of a Date to snap(). (Breaking change)
	                  itemData.start = snap ? snap(start, scale, step) : start;
	                }
	              }
	            }
	          }
	          if (updateGroupAllowed && !props.dragLeft && !props.dragRight && newGroupBase != null) {
	            if (itemData.group != undefined) {
	              var newOffset = newGroupBase - props.groupOffset;

	              //make sure we stay in bounds
	              newOffset = Math.max(0, newOffset);
	              newOffset = Math.min(me.groupIds.length - 1, newOffset);
	              itemData.group = me.groupIds[newOffset];
	            }
	          }

	          // confirm moving the item
	          itemData = _this9._cloneItemData(itemData); // convert start and end to the correct type
	          me.options.onMoving(itemData, function (itemData) {
	            if (itemData) {
	              props.item.setData(_this9._cloneItemData(itemData, 'Date'));
	            }
	          });
	        });
	        this.body.emitter.emit('_change');
	      }
	    }

	    /**
	     * Move an item to another group
	     * @param {Item} item
	     * @param {string | number} groupId
	     * @private
	     */
	  }, {
	    key: "_moveToGroup",
	    value: function _moveToGroup(item, groupId) {
	      var group = this.groups[groupId];
	      if (group && group.groupId != item.data.group) {
	        var oldGroup = item.parent;
	        oldGroup.remove(item);
	        oldGroup.order();
	        item.data.group = group.groupId;
	        group.add(item);
	        group.order();
	      }
	    }

	    /**
	     * End of dragging selected items
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onDragEnd",
	    value: function _onDragEnd(event) {
	      var _this10 = this;
	      this.touchParams.itemIsDragging = false;
	      if (this.touchParams.itemProps) {
	        event.stopPropagation();
	        var me = this;
	        var itemProps = this.touchParams.itemProps;
	        this.touchParams.itemProps = null;
	        _forEachInstanceProperty(itemProps).call(itemProps, function (props) {
	          var id = props.item.id;
	          var exists = me.itemsData.get(id) != null;
	          if (!exists) {
	            // add a new item
	            me.options.onAdd(props.item.data, function (itemData) {
	              me._removeItem(props.item); // remove temporary item
	              if (itemData) {
	                me.itemsData.add(itemData);
	              }

	              // force re-stacking of all items next redraw
	              me.body.emitter.emit('_change');
	            });
	          } else {
	            // update existing item
	            var itemData = _this10._cloneItemData(props.item.data); // convert start and end to the correct type
	            me.options.onMove(itemData, function (itemData) {
	              if (itemData) {
	                // apply changes
	                itemData[_this10.itemsData.idProp] = id; // ensure the item contains its id (can be undefined)
	                _this10.itemsData.update(itemData);
	              } else {
	                // restore original values
	                props.item.setData(props.data);
	                me.body.emitter.emit('_change');
	              }
	            });
	          }
	        });
	      }
	    }

	    /**
	     * On group click
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onGroupClick",
	    value: function _onGroupClick(event) {
	      var _this11 = this;
	      var group = this.groupFromTarget(event);
	      _setTimeout(function () {
	        _this11.toggleGroupShowNested(group);
	      }, 1);
	    }

	    /**
	     * Toggle show nested
	     * @param {object} group
	     * @param {boolean} force
	     */
	  }, {
	    key: "toggleGroupShowNested",
	    value: function toggleGroupShowNested(group) {
	      var force = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;
	      if (!group || !group.nestedGroups) return;
	      var groupsData = this.groupsData.getDataSet();
	      if (force != undefined) {
	        group.showNested = !!force;
	      } else {
	        group.showNested = !group.showNested;
	      }
	      var nestingGroup = groupsData.get(group.groupId);
	      nestingGroup.showNested = group.showNested;
	      var fullNestedGroups = group.nestedGroups;
	      var nextLevel = fullNestedGroups;
	      while (nextLevel.length > 0) {
	        var current = nextLevel;
	        nextLevel = [];
	        for (var i = 0; i < current.length; i++) {
	          var node = groupsData.get(current[i]);
	          if (node.nestedGroups) {
	            nextLevel = _concatInstanceProperty(nextLevel).call(nextLevel, node.nestedGroups);
	          }
	        }
	        if (nextLevel.length > 0) {
	          fullNestedGroups = _concatInstanceProperty(fullNestedGroups).call(fullNestedGroups, nextLevel);
	        }
	      }
	      var nestedGroups;
	      if (nestingGroup.showNested) {
	        var showNestedGroups = groupsData.get(nestingGroup.nestedGroups);
	        for (var _i = 0; _i < showNestedGroups.length; _i++) {
	          var _group = showNestedGroups[_i];
	          if (_group.nestedGroups && _group.nestedGroups.length > 0 && (_group.showNested == undefined || _group.showNested == true)) {
	            showNestedGroups.push.apply(showNestedGroups, _toConsumableArray(groupsData.get(_group.nestedGroups)));
	          }
	        }
	        nestedGroups = _mapInstanceProperty(showNestedGroups).call(showNestedGroups, function (nestedGroup) {
	          if (nestedGroup.visible == undefined) {
	            nestedGroup.visible = true;
	          }
	          nestedGroup.visible = !!nestingGroup.showNested;
	          return nestedGroup;
	        });
	      } else {
	        var _context30;
	        nestedGroups = _mapInstanceProperty(_context30 = groupsData.get(fullNestedGroups)).call(_context30, function (nestedGroup) {
	          if (nestedGroup.visible == undefined) {
	            nestedGroup.visible = true;
	          }
	          nestedGroup.visible = !!nestingGroup.showNested;
	          return nestedGroup;
	        });
	      }
	      groupsData.update(_concatInstanceProperty(nestedGroups).call(nestedGroups, nestingGroup));
	      if (nestingGroup.showNested) {
	        availableUtils.removeClassName(group.dom.label, 'collapsed');
	        availableUtils.addClassName(group.dom.label, 'expanded');
	      } else {
	        availableUtils.removeClassName(group.dom.label, 'expanded');
	        availableUtils.addClassName(group.dom.label, 'collapsed');
	      }
	    }

	    /**
	     * Toggle group drag classname
	     * @param {object} group
	     */
	  }, {
	    key: "toggleGroupDragClassName",
	    value: function toggleGroupDragClassName(group) {
	      group.dom.label.classList.toggle('vis-group-is-dragging');
	      group.dom.foreground.classList.toggle('vis-group-is-dragging');
	    }

	    /**
	     * on drag start
	     * @param {Event} event
	     * @return {void}   
	     * @private
	     */
	  }, {
	    key: "_onGroupDragStart",
	    value: function _onGroupDragStart(event) {
	      if (this.groupTouchParams.isDragging) return;
	      if (this.options.groupEditable.order) {
	        this.groupTouchParams.group = this.groupFromTarget(event);
	        if (this.groupTouchParams.group) {
	          event.stopPropagation();
	          this.groupTouchParams.isDragging = true;
	          this.toggleGroupDragClassName(this.groupTouchParams.group);
	          this.groupTouchParams.originalOrder = this.groupsData.getIds({
	            order: this.options.groupOrder
	          });
	        }
	      }
	    }

	    /**
	     * on drag
	     * @param {Event} event
	     * @return {void}
	     * @private
	     */
	  }, {
	    key: "_onGroupDrag",
	    value: function _onGroupDrag(event) {
	      if (this.options.groupEditable.order && this.groupTouchParams.group) {
	        event.stopPropagation();
	        var groupsData = this.groupsData.getDataSet();
	        // drag from one group to another
	        var group = this.groupFromTarget(event);

	        // try to avoid toggling when groups differ in height
	        if (group && group.height != this.groupTouchParams.group.height) {
	          var movingUp = group.top < this.groupTouchParams.group.top;
	          var clientY = event.center ? event.center.y : event.clientY;
	          var targetGroup = group.dom.foreground.getBoundingClientRect();
	          var draggedGroupHeight = this.groupTouchParams.group.height;
	          if (movingUp) {
	            // skip swapping the groups when the dragged group is not below clientY afterwards
	            if (targetGroup.top + draggedGroupHeight < clientY) {
	              return;
	            }
	          } else {
	            var targetGroupHeight = group.height;
	            // skip swapping the groups when the dragged group is not below clientY afterwards
	            if (targetGroup.top + targetGroupHeight - draggedGroupHeight > clientY) {
	              return;
	            }
	          }
	        }
	        if (group && group != this.groupTouchParams.group) {
	          var _targetGroup = groupsData.get(group.groupId);
	          var draggedGroup = groupsData.get(this.groupTouchParams.group.groupId);

	          // switch groups
	          if (draggedGroup && _targetGroup) {
	            this.options.groupOrderSwap(draggedGroup, _targetGroup, groupsData);
	            groupsData.update(draggedGroup);
	            groupsData.update(_targetGroup);
	          }

	          // fetch current order of groups
	          var newOrder = groupsData.getIds({
	            order: this.options.groupOrder
	          });

	          // in case of changes since _onGroupDragStart
	          if (!availableUtils.equalArray(newOrder, this.groupTouchParams.originalOrder)) {
	            var origOrder = this.groupTouchParams.originalOrder;
	            var draggedId = this.groupTouchParams.group.groupId;
	            var numGroups = Math.min(origOrder.length, newOrder.length);
	            var curPos = 0;
	            var newOffset = 0;
	            var orgOffset = 0;
	            while (curPos < numGroups) {
	              // as long as the groups are where they should be step down along the groups order
	              while (curPos + newOffset < numGroups && curPos + orgOffset < numGroups && newOrder[curPos + newOffset] == origOrder[curPos + orgOffset]) {
	                curPos++;
	              }

	              // all ok
	              if (curPos + newOffset >= numGroups) {
	                break;
	              }

	              // not all ok
	              // if dragged group was move upwards everything below should have an offset
	              if (newOrder[curPos + newOffset] == draggedId) {
	                newOffset = 1;
	              }
	              // if dragged group was move downwards everything above should have an offset
	              else if (origOrder[curPos + orgOffset] == draggedId) {
	                orgOffset = 1;
	              }
	              // found a group (apart from dragged group) that has the wrong position -> switch with the 
	              // group at the position where other one should be, fix index arrays and continue
	              else {
	                var slippedPosition = _indexOfInstanceProperty(newOrder).call(newOrder, origOrder[curPos + orgOffset]);
	                var switchGroup = groupsData.get(newOrder[curPos + newOffset]);
	                var shouldBeGroup = groupsData.get(origOrder[curPos + orgOffset]);
	                this.options.groupOrderSwap(switchGroup, shouldBeGroup, groupsData);
	                groupsData.update(switchGroup);
	                groupsData.update(shouldBeGroup);
	                var switchGroupId = newOrder[curPos + newOffset];
	                newOrder[curPos + newOffset] = origOrder[curPos + orgOffset];
	                newOrder[slippedPosition] = switchGroupId;
	                curPos++;
	              }
	            }
	          }
	        }
	      }
	    }

	    /**
	     * on drag end
	     * @param {Event} event
	     * @return {void}
	     * @private
	     */
	  }, {
	    key: "_onGroupDragEnd",
	    value: function _onGroupDragEnd(event) {
	      this.groupTouchParams.isDragging = false;
	      if (this.options.groupEditable.order && this.groupTouchParams.group) {
	        event.stopPropagation();

	        // update existing group
	        var me = this;
	        var id = me.groupTouchParams.group.groupId;
	        var dataset = me.groupsData.getDataSet();
	        var groupData = availableUtils.extend({}, dataset.get(id)); // clone the data
	        me.options.onMoveGroup(groupData, function (groupData) {
	          if (groupData) {
	            // apply changes
	            groupData[dataset._idProp] = id; // ensure the group contains its id (can be undefined)
	            dataset.update(groupData);
	          } else {
	            // fetch current order of groups
	            var newOrder = dataset.getIds({
	              order: me.options.groupOrder
	            });

	            // restore original order
	            if (!availableUtils.equalArray(newOrder, me.groupTouchParams.originalOrder)) {
	              var origOrder = me.groupTouchParams.originalOrder;
	              var numGroups = Math.min(origOrder.length, newOrder.length);
	              var curPos = 0;
	              while (curPos < numGroups) {
	                // as long as the groups are where they should be step down along the groups order
	                while (curPos < numGroups && newOrder[curPos] == origOrder[curPos]) {
	                  curPos++;
	                }

	                // all ok
	                if (curPos >= numGroups) {
	                  break;
	                }

	                // found a group that has the wrong position -> switch with the
	                // group at the position where other one should be, fix index arrays and continue
	                var slippedPosition = _indexOfInstanceProperty(newOrder).call(newOrder, origOrder[curPos]);
	                var switchGroup = dataset.get(newOrder[curPos]);
	                var shouldBeGroup = dataset.get(origOrder[curPos]);
	                me.options.groupOrderSwap(switchGroup, shouldBeGroup, dataset);
	                dataset.update(switchGroup);
	                dataset.update(shouldBeGroup);
	                var switchGroupId = newOrder[curPos];
	                newOrder[curPos] = origOrder[curPos];
	                newOrder[slippedPosition] = switchGroupId;
	                curPos++;
	              }
	            }
	          }
	        });
	        me.body.emitter.emit('groupDragged', {
	          groupId: id
	        });
	        this.toggleGroupDragClassName(this.groupTouchParams.group);
	        this.groupTouchParams.group = null;
	      }
	    }

	    /**
	     * Handle selecting/deselecting an item when tapping it
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onSelectItem",
	    value: function _onSelectItem(event) {
	      if (!this.options.selectable) return;
	      var ctrlKey = event.srcEvent && (event.srcEvent.ctrlKey || event.srcEvent.metaKey);
	      var shiftKey = event.srcEvent && event.srcEvent.shiftKey;
	      if (ctrlKey || shiftKey) {
	        this._onMultiSelectItem(event);
	        return;
	      }
	      var oldSelection = this.getSelection();
	      var item = this.itemFromTarget(event);
	      var selection = item && item.selectable ? [item.id] : [];
	      this.setSelection(selection);
	      var newSelection = this.getSelection();

	      // emit a select event,
	      // except when old selection is empty and new selection is still empty
	      if (newSelection.length > 0 || oldSelection.length > 0) {
	        this.body.emitter.emit('select', {
	          items: newSelection,
	          event: event
	        });
	      }
	    }

	    /**
	     * Handle hovering an item
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onMouseOver",
	    value: function _onMouseOver(event) {
	      var item = this.itemFromTarget(event);
	      if (!item) return;

	      // Item we just left
	      var related = this.itemFromRelatedTarget(event);
	      if (item === related) {
	        // We haven't changed item, just element in the item
	        return;
	      }
	      var title = item.getTitle();
	      if (this.options.showTooltips && title) {
	        if (this.popup == null) {
	          this.popup = new Popup(this.body.dom.root, this.options.tooltip.overflowMethod || 'flip');
	        }
	        this.popup.setText(title);
	        var container = this.body.dom.centerContainer;
	        var containerRect = container.getBoundingClientRect();
	        this.popup.setPosition(event.clientX - containerRect.left + container.offsetLeft, event.clientY - containerRect.top + container.offsetTop);
	        this.setPopupTimer(this.popup);
	      } else {
	        // Hovering over item without a title, hide popup
	        // Needed instead of _just_ in _onMouseOut due to #2572
	        this.clearPopupTimer();
	        if (this.popup != null) {
	          this.popup.hide();
	        }
	      }
	      this.body.emitter.emit('itemover', {
	        item: item.id,
	        event: event
	      });
	    }

	    /**
	     * on mouse start
	     * @param {Event} event
	     * @return {void}   
	     * @private
	     */
	  }, {
	    key: "_onMouseOut",
	    value: function _onMouseOut(event) {
	      var item = this.itemFromTarget(event);
	      if (!item) return;

	      // Item we are going to
	      var related = this.itemFromRelatedTarget(event);
	      if (item === related) {
	        // We aren't changing item, just element in the item
	        return;
	      }
	      this.clearPopupTimer();
	      if (this.popup != null) {
	        this.popup.hide();
	      }
	      this.body.emitter.emit('itemout', {
	        item: item.id,
	        event: event
	      });
	    }

	    /**
	     * on mouse move
	     * @param {Event} event
	     * @return {void}   
	     * @private
	     */
	  }, {
	    key: "_onMouseMove",
	    value: function _onMouseMove(event) {
	      var item = this.itemFromTarget(event);
	      if (!item) return;
	      if (this.popupTimer != null) {
	        // restart timer
	        this.setPopupTimer(this.popup);
	      }
	      if (this.options.showTooltips && this.options.tooltip.followMouse && this.popup && !this.popup.hidden) {
	        var container = this.body.dom.centerContainer;
	        var containerRect = container.getBoundingClientRect();
	        this.popup.setPosition(event.clientX - containerRect.left + container.offsetLeft, event.clientY - containerRect.top + container.offsetTop);
	        this.popup.show(); // Redraw
	      }
	    }

	    /**
	     * Handle mousewheel
	     * @param {Event}  event   The event
	     * @private
	     */
	  }, {
	    key: "_onMouseWheel",
	    value: function _onMouseWheel(event) {
	      if (this.touchParams.itemIsDragging) {
	        this._onDragEnd(event);
	      }
	    }

	    /**
	     * Handle updates of an item on double tap
	     * @param {timeline.Item}  item   The item
	     * @private
	     */
	  }, {
	    key: "_onUpdateItem",
	    value: function _onUpdateItem(item) {
	      if (!this.options.selectable) return;
	      if (!this.options.editable.updateTime && !this.options.editable.updateGroup) return;
	      var me = this;
	      if (item) {
	        // execute async handler to update the item (or cancel it)
	        var itemData = me.itemsData.get(item.id); // get a clone of the data from the dataset
	        this.options.onUpdate(itemData, function (itemData) {
	          if (itemData) {
	            me.itemsData.update(itemData);
	          }
	        });
	      }
	    }

	    /**
	     * Handle drop event of data on item
	     * Only called when `objectData.target === 'item'.
	     * @param {Event} event The event 
	     * @private
	     */
	  }, {
	    key: "_onDropObjectOnItem",
	    value: function _onDropObjectOnItem(event) {
	      var item = this.itemFromTarget(event);
	      var objectData = JSON.parse(event.dataTransfer.getData("text"));
	      this.options.onDropObjectOnItem(objectData, item);
	    }

	    /**
	     * Handle creation of an item on double tap or drop of a drag event
	     * @param {Event} event   The event
	     * @private
	     */
	  }, {
	    key: "_onAddItem",
	    value: function _onAddItem(event) {
	      if (!this.options.selectable) return;
	      if (!this.options.editable.add) return;
	      var me = this;
	      var snap = this.options.snap || null;

	      // add item
	      var frameRect = this.dom.frame.getBoundingClientRect();
	      var x = this.options.rtl ? frameRect.right - event.center.x : event.center.x - frameRect.left;
	      var start = this.body.util.toTime(x);
	      var scale = this.body.util.getScale();
	      var step = this.body.util.getStep();
	      var end;
	      var newItemData;
	      if (event.type == 'drop') {
	        newItemData = JSON.parse(event.dataTransfer.getData("text"));
	        newItemData.content = newItemData.content ? newItemData.content : 'new item';
	        newItemData.start = newItemData.start ? newItemData.start : snap ? snap(start, scale, step) : start;
	        newItemData.type = newItemData.type || 'box';
	        newItemData[this.itemsData.idProp] = newItemData.id || v4();
	        if (newItemData.type == 'range' && !newItemData.end) {
	          end = this.body.util.toTime(x + this.props.width / 5);
	          newItemData.end = snap ? snap(end, scale, step) : end;
	        }
	      } else {
	        newItemData = {
	          start: snap ? snap(start, scale, step) : start,
	          content: 'new item'
	        };
	        newItemData[this.itemsData.idProp] = v4();

	        // when default type is a range, add a default end date to the new item
	        if (this.options.type === 'range') {
	          end = this.body.util.toTime(x + this.props.width / 5);
	          newItemData.end = snap ? snap(end, scale, step) : end;
	        }
	      }
	      var group = this.groupFromTarget(event);
	      if (group) {
	        newItemData.group = group.groupId;
	      }

	      // execute async handler to customize (or cancel) adding an item
	      newItemData = this._cloneItemData(newItemData); // convert start and end to the correct type
	      this.options.onAdd(newItemData, function (item) {
	        if (item) {
	          me.itemsData.add(item);
	          if (event.type == 'drop') {
	            me.setSelection([item.id]);
	          }
	          // TODO: need to trigger a redraw?
	        }
	      });
	    }

	    /**
	     * Handle selecting/deselecting multiple items when holding an item
	     * @param {Event} event
	     * @private
	     */
	  }, {
	    key: "_onMultiSelectItem",
	    value: function _onMultiSelectItem(event) {
	      var _this12 = this;
	      if (!this.options.selectable) return;
	      var item = this.itemFromTarget(event);
	      if (item) {
	        // multi select items (if allowed)

	        var selection = this.options.multiselect ? this.getSelection() // take current selection
	        : []; // deselect current selection

	        var shiftKey = event.srcEvent && event.srcEvent.shiftKey || false;
	        if ((shiftKey || this.options.sequentialSelection) && this.options.multiselect) {
	          // select all items between the old selection and the tapped item
	          var itemGroup = this.itemsData.get(item.id).group;

	          // when filtering get the group of the last selected item
	          var lastSelectedGroup = undefined;
	          if (this.options.multiselectPerGroup) {
	            if (selection.length > 0) {
	              lastSelectedGroup = this.itemsData.get(selection[0]).group;
	            }
	          }

	          // determine the selection range
	          if (!this.options.multiselectPerGroup || lastSelectedGroup == undefined || lastSelectedGroup == itemGroup) {
	            selection.push(item.id);
	          }
	          var range = ItemSet._getItemRange(this.itemsData.get(selection));
	          if (!this.options.multiselectPerGroup || lastSelectedGroup == itemGroup) {
	            // select all items within the selection range
	            selection = [];
	            for (var id in this.items) {
	              if (this.items.hasOwnProperty(id)) {
	                var _item = this.items[id];
	                var start = _item.data.start;
	                var end = _item.data.end !== undefined ? _item.data.end : start;
	                if (start >= range.min && end <= range.max && (!this.options.multiselectPerGroup || lastSelectedGroup == this.itemsData.get(_item.id).group) && !(_item instanceof BackgroundItem)) {
	                  selection.push(_item.id); // do not use id but item.id, id itself is stringified
	                }
	              }
	            }
	          }
	        } else {
	          // add/remove this item from the current selection
	          var index = _indexOfInstanceProperty(selection).call(selection, item.id);
	          if (index == -1) {
	            // item is not yet selected -> select it
	            selection.push(item.id);
	          } else {
	            // item is already selected -> deselect it
	            _spliceInstanceProperty(selection).call(selection, index, 1);
	          }
	        }
	        var filteredSelection = _filterInstanceProperty(selection).call(selection, function (item) {
	          return _this12.getItemById(item).selectable;
	        });
	        this.setSelection(filteredSelection);
	        this.body.emitter.emit('select', {
	          items: this.getSelection(),
	          event: event
	        });
	      }
	    }

	    /**
	     * Calculate the time range of a list of items
	     * @param {Array.<Object>} itemsData
	     * @return {{min: Date, max: Date}} Returns the range of the provided items
	     * @private
	     */
	  }, {
	    key: "itemFromElement",
	    value:
	    /**
	     * Find an item from an element:
	     * searches for the attribute 'vis-item' in the element's tree
	     * @param {HTMLElement} element
	     * @return {Item | null} item
	     */
	    function itemFromElement(element) {
	      var cur = element;
	      while (cur) {
	        if (cur.hasOwnProperty('vis-item')) {
	          return cur['vis-item'];
	        }
	        cur = cur.parentNode;
	      }
	      return null;
	    }

	    /**
	     * Find an item from an event target:
	     * searches for the attribute 'vis-item' in the event target's element tree
	     * @param {Event} event
	     * @return {Item | null} item
	     */
	  }, {
	    key: "itemFromTarget",
	    value: function itemFromTarget(event) {
	      return this.itemFromElement(event.target);
	    }

	    /**
	     * Find an item from an event's related target:
	     * searches for the attribute 'vis-item' in the related target's element tree
	     * @param {Event} event
	     * @return {Item | null} item
	     */
	  }, {
	    key: "itemFromRelatedTarget",
	    value: function itemFromRelatedTarget(event) {
	      return this.itemFromElement(event.relatedTarget);
	    }

	    /**
	     * Find the Group from an event target:
	     * searches for the attribute 'vis-group' in the event target's element tree
	     * @param {Event} event
	     * @return {Group | null} group
	     */
	  }, {
	    key: "groupFromTarget",
	    value: function groupFromTarget(event) {
	      var clientY = event.center ? event.center.y : event.clientY;
	      var groupIds = this.groupIds;
	      if (groupIds.length <= 0 && this.groupsData) {
	        groupIds = this.groupsData.getIds({
	          order: this.options.groupOrder
	        });
	      }
	      for (var i = 0; i < groupIds.length; i++) {
	        var groupId = groupIds[i];
	        var group = this.groups[groupId];
	        var foreground = group.dom.foreground;
	        var foregroundRect = foreground.getBoundingClientRect();
	        if (clientY >= foregroundRect.top && clientY < foregroundRect.top + foreground.offsetHeight) {
	          return group;
	        }
	        if (this.options.orientation.item === 'top') {
	          if (i === this.groupIds.length - 1 && clientY > foregroundRect.top) {
	            return group;
	          }
	        } else {
	          if (i === 0 && clientY < foregroundRect.top + foreground.offset) {
	            return group;
	          }
	        }
	      }
	      return null;
	    }

	    /**
	     * Find the ItemSet from an event target:
	     * searches for the attribute 'vis-itemset' in the event target's element tree
	     * @param {Event} event
	     * @return {ItemSet | null} item
	     */
	  }, {
	    key: "_cloneItemData",
	    value:
	    /**
	     * Clone the data of an item, and "normalize" it: convert the start and end date
	     * to the type (Date, Moment, ...) configured in the DataSet. If not configured,
	     * start and end are converted to Date.
	     * @param {Object} itemData, typically `item.data`
	     * @param {string} [type]  Optional Date type. If not provided, the type from the DataSet is taken
	     * @return {Object} The cloned object
	     * @private
	     */
	    function _cloneItemData(itemData, type) {
	      var clone = availableUtils.extend({}, itemData);
	      if (!type) {
	        // convert start and end date to the type (Date, Moment, ...) configured in the DataSet
	        type = this.itemsData.type;
	      }
	      if (clone.start != undefined) {
	        clone.start = availableUtils.convert(clone.start, type && type.start || 'Date');
	      }
	      if (clone.end != undefined) {
	        clone.end = availableUtils.convert(clone.end, type && type.end || 'Date');
	      }
	      return clone;
	    }

	    /**
	     * cluster items
	     * @return {void}   
	     * @private
	     */
	  }, {
	    key: "_clusterItems",
	    value: function _clusterItems() {
	      if (!this.options.cluster) {
	        return;
	      }
	      var _this$body$range$conv = this.body.range.conversion(this.body.domProps.center.width),
	        scale = _this$body$range$conv.scale;
	      var clusters = this.clusterGenerator.getClusters(this.clusters, scale, this.options.cluster);
	      if (this.clusters != clusters) {
	        this._detachAllClusters();
	        if (clusters) {
	          var _iterator5 = _createForOfIteratorHelper$1(clusters),
	            _step5;
	          try {
	            for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
	              var cluster = _step5.value;
	              cluster.attach();
	            }
	          } catch (err) {
	            _iterator5.e(err);
	          } finally {
	            _iterator5.f();
	          }
	          this.clusters = clusters;
	        }
	        this._updateClusters(clusters);
	      }
	    }

	    /**
	     * detach all cluster items
	     * @private
	     */
	  }, {
	    key: "_detachAllClusters",
	    value: function _detachAllClusters() {
	      if (this.options.cluster) {
	        if (this.clusters && this.clusters.length) {
	          var _iterator6 = _createForOfIteratorHelper$1(this.clusters),
	            _step6;
	          try {
	            for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
	              var cluster = _step6.value;
	              cluster.detach();
	            }
	          } catch (err) {
	            _iterator6.e(err);
	          } finally {
	            _iterator6.f();
	          }
	        }
	      }
	    }

	    /**
	     * update clusters
	     * @param {array} clusters
	     * @private
	     */
	  }, {
	    key: "_updateClusters",
	    value: function _updateClusters(clusters) {
	      if (this.clusters && this.clusters.length) {
	        var _context31;
	        var newClustersIds = new _Set(_mapInstanceProperty(clusters).call(clusters, function (cluster) {
	          return cluster.id;
	        }));
	        var clustersToUnselect = _filterInstanceProperty(_context31 = this.clusters).call(_context31, function (cluster) {
	          return !newClustersIds.has(cluster.id);
	        });
	        var selectionChanged = false;
	        var _iterator7 = _createForOfIteratorHelper$1(clustersToUnselect),
	          _step7;
	        try {
	          for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
	            var _context32;
	            var cluster = _step7.value;
	            var selectedIdx = _indexOfInstanceProperty(_context32 = this.selection).call(_context32, cluster.id);
	            if (selectedIdx !== -1) {
	              var _context33;
	              cluster.unselect();
	              _spliceInstanceProperty(_context33 = this.selection).call(_context33, selectedIdx, 1);
	              selectionChanged = true;
	            }
	          }
	        } catch (err) {
	          _iterator7.e(err);
	        } finally {
	          _iterator7.f();
	        }
	        if (selectionChanged) {
	          var newSelection = this.getSelection();
	          this.body.emitter.emit('select', {
	            items: newSelection,
	            event: event
	          });
	        }
	      }
	      this.clusters = clusters || [];
	    }
	  }], [{
	    key: "_getItemRange",
	    value: function _getItemRange(itemsData) {
	      var max = null;
	      var min = null;
	      _forEachInstanceProperty(itemsData).call(itemsData, function (data) {
	        if (min == null || data.start < min) {
	          min = data.start;
	        }
	        if (data.end != undefined) {
	          if (max == null || data.end > max) {
	            max = data.end;
	          }
	        } else {
	          if (max == null || data.start > max) {
	            max = data.start;
	          }
	        }
	      });
	      return {
	        min: min,
	        max: max
	      };
	    }
	  }, {
	    key: "itemSetFromTarget",
	    value: function itemSetFromTarget(event) {
	      var target = event.target;
	      while (target) {
	        if (target.hasOwnProperty('vis-itemset')) {
	          return target['vis-itemset'];
	        }
	        target = target.parentNode;
	      }
	      return null;
	    }
	  }]);
	  return ItemSet;
	}(Component); // available item types will be registered here
	ItemSet.types = {
	  background: BackgroundItem,
	  box: BoxItem,
	  range: RangeItem,
	  point: PointItem
	};

	/**
	 * Handle added items
	 * @param {number[]} ids
	 * @protected
	 */
	ItemSet.prototype._onAdd = ItemSet.prototype._onUpdate;

	var errorFound = false;
	var allOptions$2;
	var printStyle = 'background: #FFeeee; color: #dd0000';
	/**
	 *  Used to validate options.
	 */
	var Validator = /*#__PURE__*/function () {
	  /**
	   * @ignore
	   */
	  function Validator() {
	    _classCallCheck(this, Validator);
	  }

	  /**
	   * Main function to be called
	   * @param {Object} options
	   * @param {Object} referenceOptions
	   * @param {Object} subObject
	   * @returns {boolean}
	   * @static
	   */
	  _createClass(Validator, null, [{
	    key: "validate",
	    value: function validate(options, referenceOptions, subObject) {
	      errorFound = false;
	      allOptions$2 = referenceOptions;
	      var usedOptions = referenceOptions;
	      if (subObject !== undefined) {
	        usedOptions = referenceOptions[subObject];
	      }
	      Validator.parse(options, usedOptions, []);
	      return errorFound;
	    }

	    /**
	     * Will traverse an object recursively and check every value
	     * @param {Object} options
	     * @param {Object} referenceOptions
	     * @param {array} path    | where to look for the actual option
	     * @static
	     */
	  }, {
	    key: "parse",
	    value: function parse(options, referenceOptions, path) {
	      for (var option in options) {
	        if (options.hasOwnProperty(option)) {
	          Validator.check(option, options, referenceOptions, path);
	        }
	      }
	    }

	    /**
	     * Check every value. If the value is an object, call the parse function on that object.
	     * @param {string} option
	     * @param {Object} options
	     * @param {Object} referenceOptions
	     * @param {array} path    | where to look for the actual option
	     * @static
	     */
	  }, {
	    key: "check",
	    value: function check(option, options, referenceOptions, path) {
	      if (referenceOptions[option] === undefined && referenceOptions.__any__ === undefined) {
	        Validator.getSuggestion(option, referenceOptions, path);
	        return;
	      }
	      var referenceOption = option;
	      var is_object = true;
	      if (referenceOptions[option] === undefined && referenceOptions.__any__ !== undefined) {
	        // NOTE: This only triggers if the __any__ is in the top level of the options object.
	        //       THAT'S A REALLY BAD PLACE TO ALLOW IT!!!!
	        // TODO: Examine if needed, remove if possible

	        // __any__ is a wildcard. Any value is accepted and will be further analysed by reference.
	        referenceOption = '__any__';

	        // if the any-subgroup is not a predefined object in the configurator,
	        // we do not look deeper into the object.
	        is_object = Validator.getType(options[option]) === 'object';
	      }
	      var refOptionObj = referenceOptions[referenceOption];
	      if (is_object && refOptionObj.__type__ !== undefined) {
	        refOptionObj = refOptionObj.__type__;
	      }
	      Validator.checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path);
	    }

	    /**
	     *
	     * @param {string}  option           | the option property
	     * @param {Object}  options          | The supplied options object
	     * @param {Object}  referenceOptions | The reference options containing all options and their allowed formats
	     * @param {string}  referenceOption  | Usually this is the same as option, except when handling an __any__ tag.
	     * @param {string}  refOptionObj     | This is the type object from the reference options
	     * @param {Array}   path             | where in the object is the option
	     * @static
	     */
	  }, {
	    key: "checkFields",
	    value: function checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path) {
	      var log = function log(message) {
	        console.log('%c' + message + Validator.printLocation(path, option), printStyle);
	      };
	      var optionType = Validator.getType(options[option]);
	      var refOptionType = refOptionObj[optionType];
	      if (refOptionType !== undefined) {
	        // if the type is correct, we check if it is supposed to be one of a few select values
	        if (Validator.getType(refOptionType) === 'array' && _indexOfInstanceProperty(refOptionType).call(refOptionType, options[option]) === -1) {
	          log('Invalid option detected in "' + option + '".' + ' Allowed values are:' + Validator.print(refOptionType) + ' not "' + options[option] + '". ');
	          errorFound = true;
	        } else if (optionType === 'object' && referenceOption !== "__any__") {
	          path = availableUtils.copyAndExtendArray(path, option);
	          Validator.parse(options[option], referenceOptions[referenceOption], path);
	        }
	      } else if (refOptionObj['any'] === undefined) {
	        // type of the field is incorrect and the field cannot be any
	        log('Invalid type received for "' + option + '". Expected: ' + Validator.print(_Object$keys(refOptionObj)) + '. Received [' + optionType + '] "' + options[option] + '"');
	        errorFound = true;
	      }
	    }

	    /**
	     *
	     * @param {Object|boolean|number|string|Array.<number>|Date|Node|Moment|undefined|null} object
	     * @returns {string}
	     * @static
	     */
	  }, {
	    key: "getType",
	    value: function getType(object) {
	      var type = _typeof(object);
	      if (type === 'object') {
	        if (object === null) {
	          return 'null';
	        }
	        if (object instanceof Boolean) {
	          return 'boolean';
	        }
	        if (object instanceof Number) {
	          return 'number';
	        }
	        if (object instanceof String) {
	          return 'string';
	        }
	        if (_Array$isArray$1(object)) {
	          return 'array';
	        }
	        if (object instanceof Date) {
	          return 'date';
	        }
	        if (object.nodeType !== undefined) {
	          return 'dom';
	        }
	        if (object._isAMomentObject === true) {
	          return 'moment';
	        }
	        return 'object';
	      } else if (type === 'number') {
	        return 'number';
	      } else if (type === 'boolean') {
	        return 'boolean';
	      } else if (type === 'string') {
	        return 'string';
	      } else if (type === undefined) {
	        return 'undefined';
	      }
	      return type;
	    }

	    /**
	     * @param {string} option
	     * @param {Object} options
	     * @param {Array.<string>} path
	     * @static
	     */
	  }, {
	    key: "getSuggestion",
	    value: function getSuggestion(option, options, path) {
	      var localSearch = Validator.findInOptions(option, options, path, false);
	      var globalSearch = Validator.findInOptions(option, allOptions$2, [], true);
	      var localSearchThreshold = 8;
	      var globalSearchThreshold = 4;
	      var msg;
	      if (localSearch.indexMatch !== undefined) {
	        msg = ' in ' + Validator.printLocation(localSearch.path, option, '') + 'Perhaps it was incomplete? Did you mean: "' + localSearch.indexMatch + '"?\n\n';
	      } else if (globalSearch.distance <= globalSearchThreshold && localSearch.distance > globalSearch.distance) {
	        msg = ' in ' + Validator.printLocation(localSearch.path, option, '') + 'Perhaps it was misplaced? Matching option found at: ' + Validator.printLocation(globalSearch.path, globalSearch.closestMatch, '');
	      } else if (localSearch.distance <= localSearchThreshold) {
	        msg = '. Did you mean "' + localSearch.closestMatch + '"?' + Validator.printLocation(localSearch.path, option);
	      } else {
	        msg = '. Did you mean one of these: ' + Validator.print(_Object$keys(options)) + Validator.printLocation(path, option);
	      }
	      console.log('%cUnknown option detected: "' + option + '"' + msg, printStyle);
	      errorFound = true;
	    }

	    /**
	     * traverse the options in search for a match.
	     * @param {string} option
	     * @param {Object} options
	     * @param {Array} path    | where to look for the actual option
	     * @param {boolean} [recursive=false]
	     * @returns {{closestMatch: string, path: Array, distance: number}}
	     * @static
	     */
	  }, {
	    key: "findInOptions",
	    value: function findInOptions(option, options, path) {
	      var recursive = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	      var min = 1e9;
	      var closestMatch = '';
	      var closestMatchPath = [];
	      var lowerCaseOption = option.toLowerCase();
	      var indexMatch = undefined;
	      for (var op in options) {
	        // eslint-disable-line guard-for-in
	        var distance = void 0;
	        if (options[op].__type__ !== undefined && recursive === true) {
	          var result = Validator.findInOptions(option, options[op], availableUtils.copyAndExtendArray(path, op));
	          if (min > result.distance) {
	            closestMatch = result.closestMatch;
	            closestMatchPath = result.path;
	            min = result.distance;
	            indexMatch = result.indexMatch;
	          }
	        } else {
	          var _context;
	          if (_indexOfInstanceProperty(_context = op.toLowerCase()).call(_context, lowerCaseOption) !== -1) {
	            indexMatch = op;
	          }
	          distance = Validator.levenshteinDistance(option, op);
	          if (min > distance) {
	            closestMatch = op;
	            closestMatchPath = availableUtils.copyArray(path);
	            min = distance;
	          }
	        }
	      }
	      return {
	        closestMatch: closestMatch,
	        path: closestMatchPath,
	        distance: min,
	        indexMatch: indexMatch
	      };
	    }

	    /**
	     * @param {Array.<string>} path
	     * @param {Object} option
	     * @param {string} prefix
	     * @returns {String}
	     * @static
	     */
	  }, {
	    key: "printLocation",
	    value: function printLocation(path, option) {
	      var prefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'Problem value found at: \n';
	      var str = '\n\n' + prefix + 'options = {\n';
	      for (var i = 0; i < path.length; i++) {
	        for (var j = 0; j < i + 1; j++) {
	          str += '  ';
	        }
	        str += path[i] + ': {\n';
	      }
	      for (var _j = 0; _j < path.length + 1; _j++) {
	        str += '  ';
	      }
	      str += option + '\n';
	      for (var _i = 0; _i < path.length + 1; _i++) {
	        for (var _j2 = 0; _j2 < path.length - _i; _j2++) {
	          str += '  ';
	        }
	        str += '}\n';
	      }
	      return str + '\n\n';
	    }

	    /**
	     * @param {Object} options
	     * @returns {String}
	     * @static
	     */
	  }, {
	    key: "print",
	    value: function print(options) {
	      return _JSON$stringify(options).replace(/(\")|(\[)|(\])|(,"__type__")/g, "").replace(/(\,)/g, ', ');
	    }

	    /**
	     *  Compute the edit distance between the two given strings
	     * http://en.wikibooks.org/wiki/Algorithm_Implementation/Strings/Levenshtein_distance#JavaScript
	     *
	     * Copyright (c) 2011 Andrei Mackenzie
	     *
	     * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
	     *
	     * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
	     *
	     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
	     *
	     * @param {string} a
	     * @param {string} b
	     * @returns {Array.<Array.<number>>}}
	     * @static
	     */
	  }, {
	    key: "levenshteinDistance",
	    value: function levenshteinDistance(a, b) {
	      if (a.length === 0) return b.length;
	      if (b.length === 0) return a.length;
	      var matrix = [];

	      // increment along the first column of each row
	      var i;
	      for (i = 0; i <= b.length; i++) {
	        matrix[i] = [i];
	      }

	      // increment each column in the first row
	      var j;
	      for (j = 0; j <= a.length; j++) {
	        matrix[0][j] = j;
	      }

	      // Fill in the rest of the matrix
	      for (i = 1; i <= b.length; i++) {
	        for (j = 1; j <= a.length; j++) {
	          if (b.charAt(i - 1) == a.charAt(j - 1)) {
	            matrix[i][j] = matrix[i - 1][j - 1];
	          } else {
	            matrix[i][j] = Math.min(matrix[i - 1][j - 1] + 1,
	            // substitution
	            Math.min(matrix[i][j - 1] + 1,
	            // insertion
	            matrix[i - 1][j] + 1)); // deletion
	          }
	        }
	      }

	      return matrix[b.length][a.length];
	    }
	  }]);
	  return Validator;
	}();

	/**
	 * This object contains all possible options. It will check if the types are correct, if required if the option is one
	 * of the allowed values.
	 *
	 * __any__ means that the name of the property does not matter.
	 * __type__ is a required field for all objects and contains the allowed types of all objects
	 */
	var string$1 = 'string';
	var bool$1 = 'boolean';
	var number$1 = 'number';
	var array$1 = 'array';
	var date$1 = 'date';
	var object$1 = 'object'; // should only be in a __type__ property
	var dom$1 = 'dom';
	var moment$1 = 'moment';
	var any$1 = 'any';
	var allOptions$1 = {
	  configure: {
	    enabled: {
	      'boolean': bool$1
	    },
	    filter: {
	      'boolean': bool$1,
	      'function': 'function'
	    },
	    container: {
	      dom: dom$1
	    },
	    __type__: {
	      object: object$1,
	      'boolean': bool$1,
	      'function': 'function'
	    }
	  },
	  //globals :
	  align: {
	    string: string$1
	  },
	  alignCurrentTime: {
	    string: string$1,
	    'undefined': 'undefined'
	  },
	  rtl: {
	    'boolean': bool$1,
	    'undefined': 'undefined'
	  },
	  rollingMode: {
	    follow: {
	      'boolean': bool$1
	    },
	    offset: {
	      number: number$1,
	      'undefined': 'undefined'
	    },
	    __type__: {
	      object: object$1
	    }
	  },
	  onTimeout: {
	    timeoutMs: {
	      number: number$1
	    },
	    callback: {
	      'function': 'function'
	    },
	    __type__: {
	      object: object$1
	    }
	  },
	  verticalScroll: {
	    'boolean': bool$1,
	    'undefined': 'undefined'
	  },
	  horizontalScroll: {
	    'boolean': bool$1,
	    'undefined': 'undefined'
	  },
	  autoResize: {
	    'boolean': bool$1
	  },
	  throttleRedraw: {
	    number: number$1
	  },
	  // TODO: DEPRICATED see https://github.com/almende/vis/issues/2511
	  clickToUse: {
	    'boolean': bool$1
	  },
	  dataAttributes: {
	    string: string$1,
	    array: array$1
	  },
	  editable: {
	    add: {
	      'boolean': bool$1,
	      'undefined': 'undefined'
	    },
	    remove: {
	      'boolean': bool$1,
	      'undefined': 'undefined'
	    },
	    updateGroup: {
	      'boolean': bool$1,
	      'undefined': 'undefined'
	    },
	    updateTime: {
	      'boolean': bool$1,
	      'undefined': 'undefined'
	    },
	    overrideItems: {
	      'boolean': bool$1,
	      'undefined': 'undefined'
	    },
	    __type__: {
	      'boolean': bool$1,
	      object: object$1
	    }
	  },
	  end: {
	    number: number$1,
	    date: date$1,
	    string: string$1,
	    moment: moment$1
	  },
	  format: {
	    minorLabels: {
	      millisecond: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      second: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      minute: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      hour: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      weekday: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      day: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      week: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      month: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      year: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      __type__: {
	        object: object$1,
	        'function': 'function'
	      }
	    },
	    majorLabels: {
	      millisecond: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      second: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      minute: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      hour: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      weekday: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      day: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      week: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      month: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      year: {
	        string: string$1,
	        'undefined': 'undefined'
	      },
	      __type__: {
	        object: object$1,
	        'function': 'function'
	      }
	    },
	    __type__: {
	      object: object$1
	    }
	  },
	  moment: {
	    'function': 'function'
	  },
	  groupHeightMode: {
	    string: string$1
	  },
	  groupOrder: {
	    string: string$1,
	    'function': 'function'
	  },
	  groupEditable: {
	    add: {
	      'boolean': bool$1,
	      'undefined': 'undefined'
	    },
	    remove: {
	      'boolean': bool$1,
	      'undefined': 'undefined'
	    },
	    order: {
	      'boolean': bool$1,
	      'undefined': 'undefined'
	    },
	    __type__: {
	      'boolean': bool$1,
	      object: object$1
	    }
	  },
	  groupOrderSwap: {
	    'function': 'function'
	  },
	  height: {
	    string: string$1,
	    number: number$1
	  },
	  hiddenDates: {
	    start: {
	      date: date$1,
	      number: number$1,
	      string: string$1,
	      moment: moment$1
	    },
	    end: {
	      date: date$1,
	      number: number$1,
	      string: string$1,
	      moment: moment$1
	    },
	    repeat: {
	      string: string$1
	    },
	    __type__: {
	      object: object$1,
	      array: array$1
	    }
	  },
	  itemsAlwaysDraggable: {
	    item: {
	      'boolean': bool$1,
	      'undefined': 'undefined'
	    },
	    range: {
	      'boolean': bool$1,
	      'undefined': 'undefined'
	    },
	    __type__: {
	      'boolean': bool$1,
	      object: object$1
	    }
	  },
	  limitSize: {
	    'boolean': bool$1
	  },
	  locale: {
	    string: string$1
	  },
	  locales: {
	    __any__: {
	      any: any$1
	    },
	    __type__: {
	      object: object$1
	    }
	  },
	  longSelectPressTime: {
	    number: number$1
	  },
	  margin: {
	    axis: {
	      number: number$1
	    },
	    item: {
	      horizontal: {
	        number: number$1,
	        'undefined': 'undefined'
	      },
	      vertical: {
	        number: number$1,
	        'undefined': 'undefined'
	      },
	      __type__: {
	        object: object$1,
	        number: number$1
	      }
	    },
	    __type__: {
	      object: object$1,
	      number: number$1
	    }
	  },
	  max: {
	    date: date$1,
	    number: number$1,
	    string: string$1,
	    moment: moment$1
	  },
	  maxHeight: {
	    number: number$1,
	    string: string$1
	  },
	  maxMinorChars: {
	    number: number$1
	  },
	  min: {
	    date: date$1,
	    number: number$1,
	    string: string$1,
	    moment: moment$1
	  },
	  minHeight: {
	    number: number$1,
	    string: string$1
	  },
	  moveable: {
	    'boolean': bool$1
	  },
	  multiselect: {
	    'boolean': bool$1
	  },
	  multiselectPerGroup: {
	    'boolean': bool$1
	  },
	  onAdd: {
	    'function': 'function'
	  },
	  onDropObjectOnItem: {
	    'function': 'function'
	  },
	  onUpdate: {
	    'function': 'function'
	  },
	  onMove: {
	    'function': 'function'
	  },
	  onMoving: {
	    'function': 'function'
	  },
	  onRemove: {
	    'function': 'function'
	  },
	  onAddGroup: {
	    'function': 'function'
	  },
	  onMoveGroup: {
	    'function': 'function'
	  },
	  onRemoveGroup: {
	    'function': 'function'
	  },
	  onInitialDrawComplete: {
	    'function': 'function'
	  },
	  order: {
	    'function': 'function'
	  },
	  orientation: {
	    axis: {
	      string: string$1,
	      'undefined': 'undefined'
	    },
	    item: {
	      string: string$1,
	      'undefined': 'undefined'
	    },
	    __type__: {
	      string: string$1,
	      object: object$1
	    }
	  },
	  selectable: {
	    'boolean': bool$1
	  },
	  sequentialSelection: {
	    'boolean': bool$1
	  },
	  showCurrentTime: {
	    'boolean': bool$1
	  },
	  showMajorLabels: {
	    'boolean': bool$1
	  },
	  showMinorLabels: {
	    'boolean': bool$1
	  },
	  showWeekScale: {
	    'boolean': bool$1
	  },
	  stack: {
	    'boolean': bool$1
	  },
	  stackSubgroups: {
	    'boolean': bool$1
	  },
	  cluster: {
	    maxItems: {
	      'number': number$1,
	      'undefined': 'undefined'
	    },
	    titleTemplate: {
	      'string': string$1,
	      'undefined': 'undefined'
	    },
	    clusterCriteria: {
	      'function': 'function',
	      'undefined': 'undefined'
	    },
	    showStipes: {
	      'boolean': bool$1,
	      'undefined': 'undefined'
	    },
	    fitOnDoubleClick: {
	      'boolean': bool$1,
	      'undefined': 'undefined'
	    },
	    __type__: {
	      'boolean': bool$1,
	      object: object$1
	    }
	  },
	  snap: {
	    'function': 'function',
	    'null': 'null'
	  },
	  start: {
	    date: date$1,
	    number: number$1,
	    string: string$1,
	    moment: moment$1
	  },
	  template: {
	    'function': 'function'
	  },
	  loadingScreenTemplate: {
	    'function': 'function'
	  },
	  groupTemplate: {
	    'function': 'function'
	  },
	  visibleFrameTemplate: {
	    string: string$1,
	    'function': 'function'
	  },
	  showTooltips: {
	    'boolean': bool$1
	  },
	  tooltip: {
	    followMouse: {
	      'boolean': bool$1
	    },
	    overflowMethod: {
	      'string': ['cap', 'flip', 'none']
	    },
	    delay: {
	      number: number$1
	    },
	    template: {
	      'function': 'function'
	    },
	    __type__: {
	      object: object$1
	    }
	  },
	  tooltipOnItemUpdateTime: {
	    template: {
	      'function': 'function'
	    },
	    __type__: {
	      'boolean': bool$1,
	      object: object$1
	    }
	  },
	  timeAxis: {
	    scale: {
	      string: string$1,
	      'undefined': 'undefined'
	    },
	    step: {
	      number: number$1,
	      'undefined': 'undefined'
	    },
	    __type__: {
	      object: object$1
	    }
	  },
	  type: {
	    string: string$1
	  },
	  width: {
	    string: string$1,
	    number: number$1
	  },
	  preferZoom: {
	    'boolean': bool$1
	  },
	  zoomable: {
	    'boolean': bool$1
	  },
	  zoomKey: {
	    string: ['ctrlKey', 'altKey', 'shiftKey', 'metaKey', '']
	  },
	  zoomFriction: {
	    number: number$1
	  },
	  zoomMax: {
	    number: number$1
	  },
	  zoomMin: {
	    number: number$1
	  },
	  xss: {
	    disabled: {
	      boolean: bool$1
	    },
	    filterOptions: {
	      __any__: {
	        any: any$1
	      },
	      __type__: {
	        object: object$1
	      }
	    },
	    __type__: {
	      object: object$1
	    }
	  },
	  __type__: {
	    object: object$1
	  }
	};
	var configureOptions$1 = {
	  global: {
	    align: ['center', 'left', 'right'],
	    alignCurrentTime: ['none', 'year', 'month', 'quarter', 'week', 'isoWeek', 'day', 'date', 'hour', 'minute', 'second'],
	    direction: false,
	    autoResize: true,
	    clickToUse: false,
	    // dataAttributes: ['all'], // FIXME: can be 'all' or string[]
	    editable: {
	      add: false,
	      remove: false,
	      updateGroup: false,
	      updateTime: false
	    },
	    end: '',
	    format: {
	      minorLabels: {
	        millisecond: 'SSS',
	        second: 's',
	        minute: 'HH:mm',
	        hour: 'HH:mm',
	        weekday: 'ddd D',
	        day: 'D',
	        week: 'w',
	        month: 'MMM',
	        year: 'YYYY'
	      },
	      majorLabels: {
	        millisecond: 'HH:mm:ss',
	        second: 'D MMMM HH:mm',
	        minute: 'ddd D MMMM',
	        hour: 'ddd D MMMM',
	        weekday: 'MMMM YYYY',
	        day: 'MMMM YYYY',
	        week: 'MMMM YYYY',
	        month: 'YYYY',
	        year: ''
	      }
	    },
	    groupHeightMode: ['auto', 'fixed', 'fitItems'],
	    //groupOrder: {string, 'function': 'function'},
	    groupsDraggable: false,
	    height: '',
	    //hiddenDates: {object, array},
	    locale: '',
	    longSelectPressTime: 251,
	    margin: {
	      axis: [20, 0, 100, 1],
	      item: {
	        horizontal: [10, 0, 100, 1],
	        vertical: [10, 0, 100, 1]
	      }
	    },
	    max: '',
	    maxHeight: '',
	    maxMinorChars: [7, 0, 20, 1],
	    min: '',
	    minHeight: '',
	    moveable: false,
	    multiselect: false,
	    multiselectPerGroup: false,
	    //onAdd: {'function': 'function'},
	    //onUpdate: {'function': 'function'},
	    //onMove: {'function': 'function'},
	    //onMoving: {'function': 'function'},
	    //onRename: {'function': 'function'},
	    //order: {'function': 'function'},
	    orientation: {
	      axis: ['both', 'bottom', 'top'],
	      item: ['bottom', 'top']
	    },
	    preferZoom: false,
	    selectable: true,
	    showCurrentTime: false,
	    showMajorLabels: true,
	    showMinorLabels: true,
	    stack: true,
	    stackSubgroups: true,
	    cluster: false,
	    //snap: {'function': 'function', nada},
	    start: '',
	    //template: {'function': 'function'},
	    //timeAxis: {
	    //  scale: ['millisecond', 'second', 'minute', 'hour', 'weekday', 'day', 'week', 'month', 'year'],
	    //  step: [1, 1, 10, 1]
	    //},
	    showTooltips: true,
	    tooltip: {
	      followMouse: false,
	      overflowMethod: 'flip',
	      delay: [500, 0, 99999, 100]
	    },
	    tooltipOnItemUpdateTime: false,
	    type: ['box', 'point', 'range', 'background'],
	    width: '100%',
	    zoomable: true,
	    zoomKey: ['ctrlKey', 'altKey', 'shiftKey', 'metaKey', ''],
	    zoomMax: [315360000000000, 10, 315360000000000, 1],
	    zoomMin: [10, 10, 315360000000000, 1],
	    xss: {
	      disabled: false
	    }
	  }
	};

	var htmlColors = {
	  black: '#000000',
	  navy: '#000080',
	  darkblue: '#00008B',
	  mediumblue: '#0000CD',
	  blue: '#0000FF',
	  darkgreen: '#006400',
	  green: '#008000',
	  teal: '#008080',
	  darkcyan: '#008B8B',
	  deepskyblue: '#00BFFF',
	  darkturquoise: '#00CED1',
	  mediumspringgreen: '#00FA9A',
	  lime: '#00FF00',
	  springgreen: '#00FF7F',
	  aqua: '#00FFFF',
	  cyan: '#00FFFF',
	  midnightblue: '#191970',
	  dodgerblue: '#1E90FF',
	  lightseagreen: '#20B2AA',
	  forestgreen: '#228B22',
	  seagreen: '#2E8B57',
	  darkslategray: '#2F4F4F',
	  limegreen: '#32CD32',
	  mediumseagreen: '#3CB371',
	  turquoise: '#40E0D0',
	  royalblue: '#4169E1',
	  steelblue: '#4682B4',
	  darkslateblue: '#483D8B',
	  mediumturquoise: '#48D1CC',
	  indigo: '#4B0082',
	  darkolivegreen: '#556B2F',
	  cadetblue: '#5F9EA0',
	  cornflowerblue: '#6495ED',
	  mediumaquamarine: '#66CDAA',
	  dimgray: '#696969',
	  slateblue: '#6A5ACD',
	  olivedrab: '#6B8E23',
	  slategray: '#708090',
	  lightslategray: '#778899',
	  mediumslateblue: '#7B68EE',
	  lawngreen: '#7CFC00',
	  chartreuse: '#7FFF00',
	  aquamarine: '#7FFFD4',
	  maroon: '#800000',
	  purple: '#800080',
	  olive: '#808000',
	  gray: '#808080',
	  skyblue: '#87CEEB',
	  lightskyblue: '#87CEFA',
	  blueviolet: '#8A2BE2',
	  darkred: '#8B0000',
	  darkmagenta: '#8B008B',
	  saddlebrown: '#8B4513',
	  darkseagreen: '#8FBC8F',
	  lightgreen: '#90EE90',
	  mediumpurple: '#9370D8',
	  darkviolet: '#9400D3',
	  palegreen: '#98FB98',
	  darkorchid: '#9932CC',
	  yellowgreen: '#9ACD32',
	  sienna: '#A0522D',
	  brown: '#A52A2A',
	  darkgray: '#A9A9A9',
	  lightblue: '#ADD8E6',
	  greenyellow: '#ADFF2F',
	  paleturquoise: '#AFEEEE',
	  lightsteelblue: '#B0C4DE',
	  powderblue: '#B0E0E6',
	  firebrick: '#B22222',
	  darkgoldenrod: '#B8860B',
	  mediumorchid: '#BA55D3',
	  rosybrown: '#BC8F8F',
	  darkkhaki: '#BDB76B',
	  silver: '#C0C0C0',
	  mediumvioletred: '#C71585',
	  indianred: '#CD5C5C',
	  peru: '#CD853F',
	  chocolate: '#D2691E',
	  tan: '#D2B48C',
	  lightgrey: '#D3D3D3',
	  palevioletred: '#D87093',
	  thistle: '#D8BFD8',
	  orchid: '#DA70D6',
	  goldenrod: '#DAA520',
	  crimson: '#DC143C',
	  gainsboro: '#DCDCDC',
	  plum: '#DDA0DD',
	  burlywood: '#DEB887',
	  lightcyan: '#E0FFFF',
	  lavender: '#E6E6FA',
	  darksalmon: '#E9967A',
	  violet: '#EE82EE',
	  palegoldenrod: '#EEE8AA',
	  lightcoral: '#F08080',
	  khaki: '#F0E68C',
	  aliceblue: '#F0F8FF',
	  honeydew: '#F0FFF0',
	  azure: '#F0FFFF',
	  sandybrown: '#F4A460',
	  wheat: '#F5DEB3',
	  beige: '#F5F5DC',
	  whitesmoke: '#