/*
 * This file is part of  the extension: Ebla Multiple Link Pro
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

define('ebla-link-pro:views/fields/link-multiple-form/footer-sum', ['view', 'views/fields/currency', 'views/fields/float'], function (Dep, CurrencyView, FloatView) {
    return Dep.extend({

        template: 'ebla-link-pro:footer-sum',

        data: function () {
            const data = {};
            data.scope = this.scope;
            data.numericFields = this.options.numericFields;
            data.hidden = this.collection.length === 0;
            return data;
        },

        reCalculate: function () {
            this.options.numericFields.forEach(field => {
                let sum = 0;
                this.collection.models.forEach(model => {
                    sum += model.get(field);
                });

                this._model.set(field, Math.round(sum * 100) / 100);

                if (this.options.numericFieldsMap[field] && this.getParentView().mode === 'edit') {
                    if (this._parentView) {
                        this._parentView.model.set(this.options.numericFieldsMap[field], sum);
                    }
                }
            });

            this.reRender();
        },

        setup: function () {
            Dep.prototype.setup.call(this);

            this.scope = this.options.scope;
            this.collection = this.options.collection;
            this.fieldList = [];

            this.collection.on('change', () => {
                this.reCalculate();
            });

            this.collection.on('sync', () => {
                this.reCalculate();
            });

            this.wait(true);
            this.getModelFactory().create(this.options.collection.entityType).then((model) => {
                this._model = model;
                this.wait(false);
            });
        },

        afterRender: function () {
            Dep.prototype.afterRender.call(this);

            this.options.numericFields.forEach((field) => {
                const type = this._model.getFieldType(field);
                const viewName = this.getFieldManager().getViewName(type);

                this.waitForView(field);
                this.createView(field, viewName, {
                    model: this._model,
                    el: this.options.el + ' .field-sum[data-name="' + field + '"]',
                    defs: {
                        name: field
                    },
                    mode: 'list',
                }).then((view) => {
                    view.render();
                });
            }, this);
        },
    });
});
